package parseXml;
use strict;
use Data::Dumper;
use xmlParser;

use Type;
use Table;
use Attrib;
use parseXml;
use Data::Dumper;

sub parse
{
    my $conf = shift;
    my $obj = {};
    my $state = 0;
    my $type;
    my $table;
    my $rename = {};
    my $xmlStart = sub
    {
        my( $expat, $element, %att )= @_;
        if ( $state == 0 && $element eq "teSummary" )
        {
            $state = 1;
        }
        elsif ( $state == 1 && $element eq "type" )
        {
            $state = 2;
            $type = new Type( conf => $conf, matchString => $att{matchString} );
            $type->addTimeStamp( period => $conf->{period} );
            push ( @{$obj->{types}}, $type );
            $table = undef;
        }
        elsif( $state == 2 && $element eq "timestamp" )
        {
            $state = 3;
            #$type->addTimeStamp( matchString => $att{matchString}, period => $conf->{period} );
        }
        elsif ( $state == 2 && $element eq "attrib" )
        {
            $state = 3;
            ## The name attribute is not needed if named capture groups are used
            if (!exists $att{name})
            {
                if ($conf->{perlversion} < 5.010000)
                {
                    warn "Named group captures is not suported in perl ".$conf->{perlversion} .", please use perl newer than 5.010000" ;
                }
                $att{name} = "";
            }
            $type->addAttribute( name => $att{name}, matchString => $att{matchString}, cleanString => $att{cleanString}, rename => $rename->{$att{name}}, notMatchString => $att{notMatchString} );
        }
        elsif ( $state == 2 && $element eq "rename" )
        {
            $state = 3;
            if ( defined $att{from} && defined $att{to} )
            {
                push( @{$rename->{$att{name}}->{from}}, $att{from});
                push( @{$rename->{$att{name}}->{to}}, $att{to});
            }
        }
        elsif ( $state == 2 && $element eq "keys" )
        {
            $state = 3;
            if ( defined $att{name} && defined $att{attribs} )
            {
                $type->addKeys( name => $att{name}, attribs => $att{attribs} );
            }
        }
        elsif ( $state == 2 && $element eq "store" )
        {
            $state = 3;
            if ( defined $att{mainkey} && defined $att{key} && defined $att{string} && defined $att{type} )
            {
                $type->addStoreData( mainkey => $att{mainkey}, key => $att{key}, string => $att{string}, type => $att{type} );
            }
        }
        elsif ( $state == 2 && $element eq "table" )
        {
            $state = 3;
            $table = $type->addTable( renamefrom => $rename, multiline => $att{multiline}, name => $att{name}, max => (defined $att{max}?$att{max}:$conf->{max}), diff => $att{diff}, diffstore => $att{diffstore}, silent => $conf->{silent}, outfile => $conf->{outfile},if => $att{if}  );

        }
        elsif ( $state == 3 && $element eq "header" )
        {
            $state = 3;
            $table->addHeader( %att );
        }
        elsif ( $state == 3 && $element eq "group_by" )
        {
            $state = 3;
            $table->addGroupBy( %att );
        }
    };
    my $xmlChar = sub
    {
        my( $expat, $string )= @_;
    };
    my $xmlEnd = sub
    {
        my( $expat, $element )= @_;
        if ( $element eq "teSummary" )
        {
            $state = 0;
        }
        elsif ( $element eq "type" )
        {
            $state = 1;
        }
        elsif ( $element eq "attrib" )
        {
            $state = 2;
        }
        elsif ( $element eq "table" )
        {
            $state = 2;
        }
        elsif ( $element eq "rename" )
        {
            $state = 2;
        }
        elsif ( $element eq "keys" )
        {
            $state = 2;
        }
        elsif ( $element eq "store" )
        {
            $state = 2;
        }
        elsif ( $element eq "header" )
        {
            $state = 3;

        }
        elsif ( $element eq "group_by" )
        {
            $state = 3;

        }
        elsif( $element eq "timestamp" )
        {
            $state = 2;
        }
    };
    my ($error,$xmlobj) = xmlParser->new( xmlfile => $conf->{xmlfile}, start => \&$xmlStart, char => \&$xmlChar, end => \&$xmlEnd );
    $xmlobj->parse_xml_file;
    return $obj;

}
1;
