package xmlParser;
#Author Martin Aldrin
#Date 2009-04-20
use strict;
###########################################################################################
#                                                                                         #
# © Ericsson AB 2010    - All Rights Reserved                                             #
#                                                                                         #
# The copyright to the computer program(s) herein is the property   of Ericsson AB,       #
# Sweden. The programs may be used and/or copied only with the written permission         #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the      #
# agreement/contract under which the program(s) have been supplied.                       #
#                                                                                         #
###########################################################################################

##########################################################
#********************** Constructor **********************
# Requried input paramters are "xmlfile, start, char and end".
# Thoes paramters are requred if you want to parse a xmlfile.
#
# The constructor will return a list, (error,self).

sub new{
    my $class = shift;
    my %config = @_;
    my $self;
    my $error;
    while (my ($key,$value) = each %config)
    {
        $self->{$key} = $value;
    }
    #Thoes parameters are required.
    if (!$self->{xmlfile})
    {
        $error .= "missing input parmeter for xmlfile\n";
    }
    if (!$self->{start} || !$self->{char} || !$self->{end})
    {
        $error .= "missing input parmeter for start, char or end function\n";
    }
    bless($self,$class);
    return ($error,$self);
}


sub parse_xml_file{
    my $self = shift;

    my ($parameter,$char,$end,$attrib,$comment,$comment_flag);
    open XMLFILE," < $self->{xmlfile}" or die "couln't open file: $self->{xmlfile}\n";
    my $ignore;
    while( my $line = <XMLFILE>){
        my $att ={};
        $line =~ s/^\s*|\s*$//g;

        if ( $line =~ /\<\!--/ )
        {
            $ignore =1;
            if( $line =~ /--\>/ )
            {
                $ignore = undef;
                next;
            }
            next;
        }
        if( $line =~ /--\>/ )
        {
            $ignore = undef;
            next;
        }
        if ( defined $ignore )
        {
            next;
        }
        if ( $line =~ /^\<(\w+)\>([^\>]+)\<\/(\w+)\>/ ){
            $parameter = $1;
            $char = $2;
            $end = $3;
            $self->{start}("",$parameter);
            $self->{char}("",$char);
            $self->{end}("",$end);
            next;
        }elsif ( $line =~ /^\<(\w+) ([^\>]+)\>?(\S+)<\/(\w+)\>/){
            $parameter = $1;
            $attrib = $2;
            $char = $3;
            $end = $4;

            getAttrib($attrib,$att);
            $self->{start}("",$parameter,%$att);
            $self->{char}("",$char);
            $self->{end}("",$end);
            next;
        }
        elsif ( $line =~ /^\<(\w+)\>/ ){
            $parameter = $1;
            $self->{start}("",$parameter);
            $comment_flag = 1;
            next;
        }
        elsif ( $line =~ /\<\/(\w+)\>/ ){
            $end = $1;
            $self->{char}("",$comment);
            $self->{end}("",$end);
            $comment_flag = 0;
            next;
        }
        #elsif ( $line =~ /^\<(\w+) ([^\>]+)\/>$/)
        elsif ( $line =~ /^\<(\w+)\s*((?:\w+=(?:\"|\')[^\"\']*(?:\"|\')\s*)+)\/>$/)
        {
            $parameter = $1;
            $attrib = $2;
            $end = $1;
            getAttrib($attrib,$att);
            $self->{start}("",$parameter,%$att);
            $self->{end}("",$end);
            next;
        }
        elsif ( $line =~ /^\<(\w+) ([^\>]+)/)
        {
            $parameter = $1;
            $attrib = $2;
            getAttrib($attrib,$att);
            $self->{start}("",$parameter,%$att);
            next;
        }
        elsif ( $line =~ /^\<(\w+) ([^\>]+)\>?(\S+)\>/)
        {
            $parameter = $1;
            $attrib = $2;
            $char = $3;
            getAttrib($attrib,$att);
            $self->{start}("",$parameter,%$att);
            $self->{char}("",$char);
            next;
        }
        elsif ( $line =~ /([^\<]+)/ && $comment_flag == 1){
            $comment = $1;
            next;
        }

    }
    close XMLFILE;

}

sub getAttrib
{
    my ($attrib,$att) = @_;
    #my @attribs = ($attrib =~ /(\S+?\s*=\s*(?:\"|\').+?(?:\"|\'))/g); TODO remove this backup!
    my @attribs = ($attrib =~ /(\S+?\s*=\s*(?:\"|\').+?(?:\"|\'))/g);
    while(@attribs){
        my $attrib = shift(@attribs);
        my ($key,$value) = ($attrib =~ /(\w+)=(.+)/);
        $value =~ s/\"|\'//g;
        $value =~ s/&quot;/"/g;
        $value =~ s/&lt;/</g;
        $value =~ s/&gt;/>/g;
        $value =~ s/&amp;/&/g;
        $value =~ s/&apos;/'/g;
        $att->{$key} = $value;
    }
}

1;
