#!/bin/bash

# Author: Rose Condori (ebbrmc)
# Date: June 15, 2017 Version: 1.2
# Date: May 07, 2018 Version 2 - Add vCSCF, vMTAS

# ----------------------------------------------------------------
# COPYRIGHT (c)Telefonaktiebolaget L M Ericsson
#
# The copyright to the computer program(s) herein is the
# property of Telefonaktiebolaget L M Ericsson. The programs
# may be used and/or copied only with the written permission
# from Telefonaktiebolaget L M Ericsson or in accordance with the
# terms and conditions stipulated in the agreement/contract under
# which the program(s) have been supplied.
#
# Disclaimer of Warranty.
#
# THIS PROGRAM IS PROVIDED "AS IS" WITHOUT ANY WARRANTY.
# ERICSSON MAKES NO REPRESENTATIONS OR WARRANTIES WHATSOEVER
# THAT THE PROGRAM IS ERROR-FREE OR THAT THE USE OF THIS PROGRAM
# WILL BE SECURE OR UNINTERRUPTED. FURTHER, ERICSSON MAKES NO
# REPRESENTATIONS OR WARRANTIES WHATSOEVER FOR THE PROGRAM WHETHER
# EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, IMPLIED
# WARRANTIES OF MERCHANTABILITY,NON-INFRINGEMENT AND FITNESS FOR
# A PARTICULAR PURPOSE AND IN NO EVENT SHALL ERICSSON BE LIABLE
# TO LICENSEE FOR ANY LOSS OR DAMAGES ARISING FROM THE USE OF
# THIS PROGRAM.
# ----------------------------------------------------------------

# Overview:
#   This script parses xml counter files from different platforms
#   like TSP nodes, SBG, EPDG, EME, vMTAS, vSBG, vCSCF
#   The script uses available scripts from moshell tool
#   

#Variables
moshell_dir=${HOME}/moshell/
node=""
counter_name=""
counter_type=""
output_fname=""
date_cust=""
hour_cust=""
mo_name=""
type_name=""

### SUB FUNCTIONS ###

#To parse SBG, WCG, EPDG and EME counters, 
check_sbg_counter(){
hour=$hour_cust
curr_date=$date_cust

cat $KPI_dir/*$curr_date.$hour* |  $moshell_dir/./gawk -f $moshell_dir/commonjars/pmExtract.awk  -u "$mo_name" "$counter_name" | $moshell_dir/pmXtab -cols time
}

#To parse TSP counters and EME counters, 
check_tsp_counter(){
hour=$hour_cust
curr_date=$date_cust

cat $KPI_dir/A$curr_date.$hour* |  $moshell_dir/pmExtract  -u "$mo_name" "$counter_name" | $moshell_dir/pmXtab -cols time

}
### MAIN ###

  echo "start"
  if [ "$1" == "" ]; then
         echo "USAGE:"
         echo "    ./ims_counter_check [-n /path/node_name] [-o mo] [-d yyyymmdd] [-h hhmm] [-c counter name] [-t type]"
         echo ""
         echo "OPTIONS:"
         echo " -n"
         echo "     Specify the path/node_name where node_name will be the last folder of the path: sbg, wcg,cscf, mtas, hss,  <MyNode>, CSRXXX"
         echo " -o"
         echo "     Specify MO, example below:"
         echo "     	SBG use: bsNo=11 for a particular SGC, or netId=1 for a specific interface"
         echo "     	WCG use: traffic_instance9"
	 echo "     	MTAS use: Mo=SIP,503"
         echo "     	or if you are not sure use wildcard . to print all "
         echo " -d"
         echo "     Specify date i.e 20170610"
         echo " -h"
         echo "     Specify hour i.e 0800 for 15 min, 08 for an hour, \"*\" for whole day"
         echo " -c"
         echo "     Specify counter name, example below:"
		 echo " 	SBG: sbgSgcCritResCpLoad, MtasSipOrigUnregRequestIn or partial name such as load, or wildcard . "
		 echo " 	MTAS: MtasSipOrigUnregRequestIn "
		 echo " 	or partial name such as \"load\" "
		 echo " 	or if you are not sure or want to see all available counters use wildcard . "
         echo " -t"
         echo "     Specify the node i.e sbg, wcg, epdg, tsp, emeA, emeB, vsbg, vmtas, vcscf"
		 echo "     Note: emeA use this one if the xml files start with A or emeB if they start with B"
         echo ""
         echo "  	Example: ./ims_counter_check -n /cygdrive/c/counter/sbg -o netId=1 -d 20180219 -h 00 -c sbgSipRegStatRegUserGauge -t sbg"
         echo "  	Example: ./ism_counter_check -n //cygdrive/c/counter/wcg -o instance4_PL-7 -d 20180302 -h 00 -c reg -t wcg "
		 echo "  	Example: ./ims_counter_check -n /cygdrive/c/counter/eme -o . -d 20180310 -h 00 -c sms.numsms_smsx_session_failed -t emeA"
		 echo "  	Example: ./ims_counter_check -n /cygdrive/c/counter/epdg -o . -d 20180306 -h 16 -c cpu -t epdg"
		 echo "  	Example: ./ims_counter_check -n /cygdrive/c/counter/eme -o . -d 20180310 -h 00 -c TotalSipDialogLifetime.actual -t emeB"
         echo "  	Example: ./ims_counter_check -n /cygdrive/c/counter/mtas -o Mo=500 -d 20180223 -h 00 -c reg -t tsp"
		 echo "  	Example: ./ims_counter_check -n /cygdrive/c/counter/hss -o . -d 20180215 -h 00 -c DhRequests -t tsp"
         echo "         Example: ./ims_counter_check -n /cygdrive/c/counter/vsbg -o . -d 20180219 -h 00 -c sbgCurrentTotalRegUsers -t vsbg"
         echo "         Example: ./ism_counter_check -n /cygdrive/c/counter/vmtas -o . -d 20180219 -h 00 -c MtasSubsDataInitialRegOk -t vmtas "
 	 echo "		Example:  ./ims_counter_check.sh -n /cygdrive/c/counter/vCSCF -o . -d 20180430 -h 10 -c scscfAttemptedReregistrationPerAccess -t vcscf" 
         echo ""
         exit

  fi
  
  while getopts "n:o:d:h:c:t:" opt
  do
  sc=0
    case $opt in
		
            n)
                    KPI_dir=$OPTARG
                    if [ -n "$KPI_dir" ]; then
                       echo " =========== " 
                       echo " ${OPTARG##*/}"
                       echo " =========== "
                    else
                       echo "Wrong KPI dir name!"
                       exit
                    fi
                    ;;
            o)
                    mo_name=$OPTARG
                    ;;

            d)      date_cust=$OPTARG
                    ;;

            h)
                    hour_cust=$OPTARG
                    ;;

            c)
                    counter_name=$OPTARG
                    ;;

			t)		type_name=$OPTARG
					if [  "$type_name" == 'tsp' ] || [ "$type_name" == 'emeA' ]; then
						echo "Parsing " $type_name " counters"
						check_tsp_counter
						exit 1
						
					elif [ "$type_name" == 'sbg' ] || [ "$type_name" == 'wcg' ] || [ "$type_name" == 'epdg' ] || [ "$type_name" == 'emeB' ]  || [ "$type_name" == 'vsbg' ]  || [ "$type_name" == 'vmtas' ] || [ "$type_name" == 'vcscf' ]; then 
						echo "Parsing " $type_name " counters"
						check_sbg_counter
						exit 2
					else
						echo "Wrong type name!"
						exit 3
					fi	
					;;	
			\?)
					echo "Invalid option: -$OPTARG" >&2
					;;

    esac
    shift $((OPTIND - 1 + sc))
    OPTIND=1
  done

