var config = {
 // #####################################################################################################
 // To show timespan markings  (teSummary lost traces for instance)
 gapMarkings : true,
 gapMarkingsFile : 'dataseries/lost_traces.js',
 gapMarkingsText : 'A bar with this color means there were lost traces',

 // #####################################################################################################
  // To be able to show the formulas used for dataseries in pmr we need to read the formula file from pmr
 dataSeriesTranslation: false,
 dataSeriesTranslationFile : 'dataseries/formulas.js',
 dataSeriesTranslationConfig: 'configfile.txt',

 // #####################################################################################################
 // add visability toggles to a class
 dynamicToggleImages: true,
 dynamicToggleClass: 'ropTableLink',

 // #####################################################################################################
 // if set to true, an aggregation to hour will be made. Set it to false and rop/hour choice is hidden
 dataAggregation: true,

 // dynamic inital resolution. Set to false to always start with untouched timestamps. Set to true and threshold will come into play picking initial aggregation
 dynamicInitialResolution: false,

 //if number of timestamps are below this threshold unaggregated data will be used
 dynamicInitialResolutionThreshold: 16,
 // #####################################################################################################
 // to completely hide the overview
 overview: true,

 // #####################################################################################################
 // This will control what css class to use for mouse over on legends
 // teSummary uses serieInfo
 // pmSummary uses formula
 legendMouseOverViewClass: 'SerieInfo',

 // #####################################################################################################
 eventSupport : false,
 eventFile : 'dataseries/events.js',
 eventTypes : {
    // lgs system log
    'crash': {
        eventType: "lgs: crash",
        level: 0,
        icon: {
        image: "images/warn2_16x16.png",
        width: 16,
        height: 16
        }
    },
    //lga alarm log
    'alarm major': {
        eventType: "lga: Major alarm",
        level: 1,
        icon: {
        image: "images/warn1_16x16.png",
        width: 16,
        height: 16
        }
    },
    //lga alarm log
    'alarm': {
        eventType: "lga: Alarm",
        level: 2,
        icon: {
        image: "images/error1_16x16.png",
        width: 16,
        height: 16
        }
    }

    }, // eventTypes


    // this will apply when no config is defined for an event
 defaultEventConfiguration : {
     eventType: "default",
     level: 99,
     icon:  {
     image: "images/redtriangle.png",
     width: 10,
     height: 10
     }
 }



 // #####################################################################################################
};

function setConfig(newC)
{
    $.merge(config,newC);
}