package formatRRS;

use strict;
use locale;
use warnings;
use Data::Dumper;
use SOAP::Lite;# +trace=>'all';
sub formatRRS::new() {
    my $class = shift;
    my %self=@_;
    $self{format} = "RRS";
    return bless \%self;
}

sub formatRRS::begin() {
    my $self = shift;
    my ( $not_used, $suitename, $rrsSession) = @_;

    if( defined $rrsSession)
    {
        my $soap = $rrsSession->{soap};
        my $sid = $rrsSession->{sessionId};
        my $seqnum = $rrsSession->{seqnum};
        my $super_suitename = $rrsSession->{suitename};



        my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
        my $start_date= sprintf("%4d-%02d-%02d", ($year+1900), ($mon+1), $mday);
        my $start_time=sprintf("%02d:%02d:%02d", $hour,$min,$sec);

    #    $suitename="minisuite-".$start_date.'-'.$start_time;
    #    print "sleep 3 sec\n";
    #    sleep(3);
        print "STARTING $suitename\n";
        my @suitestart_params = (
            SOAP::Data->name('sid')->value($sid)->type('integer'),
            SOAP::Data->name('seqnum')->value(++$seqnum)->type('integer'),
            SOAP::Data->name('suitename')->value("$suitename")->type('string'),
            SOAP::Data->name('parentsuitename')->value($super_suitename)->type('string'),
            SOAP::Data->name('startdate')->value($start_date)->type('date'),
            SOAP::Data->name('starttime')->value($start_time)->type('time'),
        );

        my $sub_suitestart = $soap->ws_suitestart(
            SOAP::Data->name('suitestartreq' => \@suitestart_params)->type('SuiteStartStruct'));

        if( !defined $sub_suitestart)
        {
            print "Couldn't start sub suite: $suitename \n";
        }

        $rrsSession->{runningSuite}=$suitename;
        $rrsSession->{seqnum}=$seqnum;
    }
}

sub formatRRS::header() {
    my $self = shift;
    my $conf = shift;
    my $test = shift;

    #print Dumper($test);
    #print "\n";

#    print "in formatRRS::header\n";
#    print Dumper(\%self);
#    print "\n";

    ## skippa så länge
    1;
}

sub formatRRS::content() {
    my $self = shift;
    my ( $numberOf, $string, $rops, $rrsSession ) = @_;


    if( defined $rrsSession )
    {
        $string = $numberOf . $string . $rops;
        my $soap = $rrsSession->{soap};
        my $sid = $rrsSession->{sessionId};
        my $seqnum = $rrsSession->{seqnum};
        my $sub_suitename = $rrsSession->{runningSuite};

        my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
        my $start_date= sprintf("%4d-%02d-%02d", ($year+1900), ($mon+1), $mday);
        my $start_time=sprintf("%02d:%02d:%02d", $hour,$min,$sec);
        my $stop_date= sprintf("%4d-%02d-%02d", ($year+1900), ($mon+1), $mday);
        my $stop_time=sprintf("%02d:%02d:%02d", $hour,$min,$sec+2);


#        print "SENDING report in $sub_suitename\n";

        my @report_params = (
            SOAP::Data->name('sid')->value($sid)->type('integer'),
            SOAP::Data->name('seqnum')->value(++$seqnum)->type('integer'),
            SOAP::Data->name('suitename')->value($sub_suitename)->type('string'),
            SOAP::Data->name
            (
                'testcases' => \SOAP::Data->value
                (
                    SOAP::Data->name
                    (
                        'testcase' => \SOAP::Data->value
                        (
                            SOAP::Data->name('testcaseid')->value('testcaseid'.$start_time)->type('string'),
                            SOAP::Data->name('slogan')->value('slogan')->type('string'),
                            SOAP::Data->name('result')->value('PASS')->type('string'),
                            SOAP::Data->name('startdate')->value($start_date)->type('date'),
                            SOAP::Data->name('starttime')->value($start_time)->type('time'),
                            SOAP::Data->name('stopdate')->value($stop_date)->type('date'),
                            SOAP::Data->name('stoptime')->value($stop_time)->type('time'),
                            SOAP::Data->name
                            (
                                'resultdata' => \SOAP::Data->value
                                (
                                    SOAP::Data->name('key')->value('Count')->type('string'),
                                    SOAP::Data->name('type')->value('string')->type('string'),
                                    SOAP::Data->name('value')->value($numberOf)->type('string'),
                                )
                            )->type('resultdataStruct'),

                            SOAP::Data->name
                            (
                                'resultdata' => \SOAP::Data->value
                                (
                                    SOAP::Data->name('key')->value('String')->type('string'),
                                    SOAP::Data->name('type')->value('string')->type('string'),
                                    SOAP::Data->name('value')->value($string)->type('string'),
                                )
                            )->type('resultdataStruct'),

                        ),
                    )->type('TestCaseDataStruct'),
                ),
            )->type('TestCasesStruct'),
        );


        my $report = $soap->ws_report(
            SOAP::Data->name('reportreq' => \@report_params)->type('ReportStruct'));

        $rrsSession->{seqnum}=$seqnum;


        if( !defined $report)
        {
            print "Couldn't send report to RRS \n";
        }

    }
    else
    {
        print "RRSsession is undefined!!!\n";
    }
}

sub formatRRS::end() {
    my $self = shift;
    my $rrsSession = shift;

    ## stop the running sub suite
    if( defined $rrsSession->{runningSuite})
    {

        my $soap = $rrsSession->{soap};

        my $sid = $rrsSession->{sessionId};
        my $seqnum = $rrsSession->{seqnum};
        my $suitename = $rrsSession->{suitename};
        my $running_suitename = $rrsSession->{runningSuite};

#        print "STOPPING $running_suitename\n";

        my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
        my $stop_date= sprintf("%4d-%02d-%02d", ($year+1900), ($mon+1), $mday);
        my $stop_time=sprintf("%02d:%02d:%02d", $hour,$min,$sec);


        ## parameters for suitestop
        my @suitestop_params = (
                SOAP::Data->name('sid')->value($sid)->type('integer'),
                SOAP::Data->name('seqnum')->value(++$seqnum)->type('integer'),
                SOAP::Data->name('suitename')->value($running_suitename)->type('string'),
                SOAP::Data->name('parentsuitename')->value($suitename)->type('string'),
                SOAP::Data->name('stopdate')->value($stop_date)->type('date'),
                SOAP::Data->name('stoptime')->value($stop_time)->type('time'),
        );

        ## stop sub suite
        my $suitestop = $soap->ws_suitestop(
            SOAP::Data->name('suitestopreq' => \@suitestop_params)->type('SuiteStopStruct'))->result();

        if( !defined $suitestop)
        {
            print "Couldn't stop the sub suite: $running_suitename \n";
        }

        delete $rrsSession->{runningSuite};
        $rrsSession->{seqnum}=$seqnum;
    }

}

sub formatRRS::printer() {
    my $self = shift;
    my %hash = @_;

    print Dumper(%hash);
    ## behövs ej

#    print "in formatRRS::printer\n";
#    print Dumper(\%self);
#    print "\n";
    1;
}

sub formatRRS::endReport() {
    my $self = shift;
    my $conf = shift;

    if(defined $conf->{RRSsession})
    {
        my $soap = $conf->{RRSsession}->{soap};

        my $sid = $conf->{RRSsession}->{sessionId};
        my $seqnum = $conf->{RRSsession}->{seqnum};
        my $suitename = $conf->{RRSsession}->{suitename};

        my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
        my $stop_date= sprintf("%4d-%02d-%02d", ($year+1900), ($mon+1), $mday);
        my $stop_time=sprintf("%02d:%02d:%02d", $hour,$min,$sec);

        ## parameters for suitestop
        my @suitestop_params = (
                SOAP::Data->name('sid')->value($sid)->type('integer'),
                SOAP::Data->name('seqnum')->value(++$seqnum)->type('integer'),
                SOAP::Data->name('suitename')->value($suitename)->type('string'),
                SOAP::Data->name('stopdate')->value($stop_date)->type('date'),
                SOAP::Data->name('stoptime')->value($stop_time)->type('time'),
        );

        ## stop super suite
        my $suitestop = $soap->ws_suitestop(
            SOAP::Data->name('suitestopreq' => \@suitestop_params)->type('SuiteStopStruct'))->result();

        if( !defined $suitestop)
        {
            print "Couldn't stop the super suite: $suitename\n";
        }

        ## parameters for sessionend
        my @sessionend_params = (
            SOAP::Data->name('sid')->value($sid)->type('integer'),
            SOAP::Data->name('seqnum')->value(++$seqnum)->type('integer'),
        );

        ## send sessionend
        my $sessionend = $soap->ws_sessionend(
            SOAP::Data->name('sessionendreq' => \@sessionend_params)->type('SessionEndStruct'))->result();


        if( !defined $sessionend)
        {
            print "Couldn't end the RRS session with session Id: $sid \n";
        }
    }
}


## get sessionId, send sessioninit, start super suite
sub formatRRS::initReport() {
    my $self = shift;
    my $conf = shift;

    my $soap = $conf->{RRSsession}->{soap};

    ## get sid
    my $response = $soap->ws_sidrequest(SOAP::Data->name('sidrequestreq'));

    if(defined checkIfBlessed($response) )
    {
        my $sid = $response->result();

        ## parameters for sessioninit
        my @sessioninit_params = (
            SOAP::Data->name('sid'=> $sid)->type('integer'),
            SOAP::Data->name('seqnum' => 1)->type('integer'),
            SOAP::Data->name('user' => $ENV{USER})->type('string'),
        );
        ## send sessioninit
        my $session = $soap->ws_sessioninit(
                    SOAP::Data->name('sessioninitreq' => \@sessioninit_params)->type('SessionInitStruct'))->result();
        my $seqnum = $session->{seqnum};

        if( defined $seqnum)
        {
            ## save sid and seqnum to conf
            $conf->{RRSsession}->{sessionId}=$sid;
            $conf->{RRSsession}->{seqnum}=$seqnum;

            ## start the super suite
            my $suitename = $conf->{RRSsession}->{suitename};

            my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
            my $start_date= sprintf("%4d-%02d-%02d", ($year+1900), ($mon+1), $mday);
            my $start_time= sprintf("%02d:%02d:%02d", $hour,$min,$sec);



            my @suitestart_params = (
                SOAP::Data->name('sid')->value($sid)->type('integer'),
                SOAP::Data->name('seqnum')->value(++$seqnum)->type('integer'),
                SOAP::Data->name('suitename')->value($suitename)->type('string'),
                SOAP::Data->name('startdate')->value($start_date)->type('date'),
                SOAP::Data->name('starttime')->value($start_time)->type('time'),
            );

            my $suitestart = $soap->ws_suitestart(
                        SOAP::Data->name('suitestartreq' => \@suitestart_params)->type('SuiteStartStruct'))->result();



            if( !defined $suitestart)
            {
                print "Couldn't start the super suite, will now continue without the RRS!\n";
                delete $conf->{RRSsession};
            }
        }
        else
        {
            #die "Couldn't get a sequence number from the RRS, terminating...\n";
            print "Couldn't get seqnum from the RRS, will now continue without the RRS!\n";
            delete $conf->{RRSsession};
        }
    }
    else
    {
        #die "Couldn't get session ID from the RRS, terminating...\n";
        print "Couldn't get a session Id from the RRS, will now continue without the RRS!\n";
        delete $conf->{RRSsession};

    }
}

sub checkIfBlessed
{
    my ($response)=@_;

    if ( !defined $response || !ref($response) || !UNIVERSAL::can($response,'can') )
    {
        ## something is wrong with the response
        return undef;
    }

    return defined;
}

1;

__END__


