#!/app/perl/5.8.9/bin/perl
# package mpswRadiator;
#########################################
#
# File name: RadiatorCI.pm 
#
# FUNCTION: 
# The purpose of this module is to:
#   - Store build information in the radiator DB.
#
#########################################
#use lib '/app/perl/5.8.9.827/lib';
use DBI;
use Exporter;
@ISA = ('Exporter');
@EXPORT = qw(&send_data_to_radiator);
my $verbose = 0;
my $RadiatorName = "RadiatorCI.pm";

sub send_data_to_radiator()
{
############################################################
#
# Sub: send_data_to_radiator ( <reference to %hash>, <verbose> )
#
# INPUT:
#   <reference to %hash>
#   <verbose> 0 = no output, 1 = more trace information
#   $hash = { 
#       db         => "database name";
#       db_host    => "database host name";
#       db_port    => "port"
#       db_user    => "user",
#       db_pwd     => "password",
#       prod       => "product",
#       rev        => "revision",
# 	from	   => "from_product",   			NEW
#	from_rev   => "from_product_revision",   		NEW  
#	config     => "configuration",
#       configname => "title",
#       filter     => "filter",
#       filtername => "filter name",
#       rrsid      => "rrs_id",
#       rrs_wsdl   => "rrs_wsdl_link",
#       rrs_search => "rrs_search",
#       no_of_tc   => "no_of_testcases",
#       links      => {
#                   link1 => "link1"
#                   link2 => "link2"
#                }
#       }
# Function:
# This function stores build information 
# in the radiator database.
#
############################################################

    my $href = shift;    # reference to hash parameter
    my $verb = shift;
    $verbose = 1 if ($verb);

    __printComment( "==================================",
            "=== $RadiatorName       ===",
            "=== send_data_to_radiator()    ===",
                    "==================================" );

    my $dbh = __dbConnect( $href->{db},      $href->{db_host},
                           $href->{db_port}, $href->{db_user},
                           $href->{db_pwd} );    # Database connect

    my $session_id = __create_session_id($dbh);
    __create_config( $dbh, $session_id, $href->{config}, $href->{configname} );
    __create_filter( $dbh, $session_id, $href->{filter}, $href->{filtername} );

    #__create_product($dbh, $session_id, $href->{prod}, $href->{rev});
    my $product_id =
        __create_product( $dbh, $session_id, $href->{prod}, $href->{rev} )
        ;                      #NEW
    ## NEW
    #   Check to see the 'from' comes from om upgrade --HARDCODED	
    #	Check if the from and the from_rev field has values then call the from_product function
    if ( $href->{db} eq "radiator_upgrade" )
    {
        if ( ( defined $href->{from} ) && ( defined $href->{from_rev} ) )
	{
            __create_from_product( $dbh, $session_id, $product_id,
                                   $href->{from}, $href->{from_rev} );
	}
	else
	{
	       	__printComment("Please Give the from state and from revision!\n");
	}
    }
    ## END NEW
    __create_rrs_instance( $dbh, $session_id, $href->{rrsid},
                           $href->{rrs_wsdl}, $href->{rrs_search} );
    __create_no_of_tc( $dbh, $session_id, $href->{no_of_tc} )
        if ( $href->{no_of_tc} );
        
    # Check if links already exist, then use old link id
    if ( $href->{links} )
    {
        my $link_id = 0;
        for my $link ( keys %{ $href->{links} } )
        {
            my $id = __check_link( $dbh, $href->{links}{$link}, $link );
            last if ( $id == 0 );   # No need to continue checking, link is new
            $link_id = $id unless ($link_id);
            if ( $id != $link_id )
            {
                # All links are not the same, so we need to create a new one
                $link_id = 0;
                last;
            }
        }
        if ( $link_id > 0 )
        {
            __printComment("Links already exist with link id $link_id");
            __update_link( $dbh, $session_id, $link_id );
        }
        else
        {
            # No link id exist, creat a new one
            $link_id = __create_link_id($dbh);
            for my $link ( keys %{ $href->{links} } )
            {
                __create_link( $dbh, $session_id, $link_id,
                               $href->{links}{$link}, $link );
            }
        }
    }

    $dbh->disconnect;

}   # END of send_data_to_radiator

sub __create_config
{
############################################################
#
# Sub: __create_config (dbh, session_id, config_name, config_displayname)
# Returns:
# Function:
# This function stores configuration information 
# in the radiator database.
#
############################################################

    my $dbh                = shift;  # the database handler
    my $session_id         = shift;  # the session id
    my $config_name        = shift;  # the config name
    my $config_displayname = shift;  # the config display name

    __printComment( "==============================",
            "=== $RadiatorName   ===",
            "=== __create_config()      ===",
                    "==============================" );
        
    # Check if the config name exists in the database
    my $SQL = "SELECT count(*) AS NbOfIds FROM config WHERE config_name='"
        . $config_name . "';";
    my $sth = $dbh->prepare($SQL);
    $sth->execute;
    my $row_href = $sth->fetchrow_hashref();
    my $NbOfIds = $row_href->{NbOfIds};
    $sth->finish;

    my $id = 0;
    if ( $NbOfIds > 0 )
    {
        # config name exists in the database
        $SQL = "SELECT config_id FROM config WHERE config_name='"
            . $config_name . "';";
        $sth = $dbh->prepare($SQL);
        $sth->execute;
        $row_href = $sth->fetchrow_hashref();
        $id = $row_href->{config_id};
        $sth->finish;
        __printComment(
               "config name $config_name already in Radiator DB with id $id.");
    }
    else
    {
        # config does not exist in the database so insert it
        $SQL =
            "INSERT INTO config (config_name, config_displayname) VALUES ('$config_name', '$config_displayname');";
        my $res = $dbh->do($SQL);
        if ( defined $res )
        {
            # New values inserted. Get the config_id for this configurations
            $id = $dbh->{'mysql_insertid'}
                ;    # "SELECT LAST_INSERT_ID() AS config_id;"
            __printComment("Radiator DB created new config id: $id");
        }
        else
        {
            # ERROR: 400
            __printErrorAndExit( 400,
                "Could not create new config in the radiator DB (config table). \n"
                    . $dbh->errstr
                    . "\n SQL: "
                    . $SQL );
        }
    }

    # insert the config_id into the table session
    $SQL =
          "UPDATE session SET config_id='"
        . $id
        . "' WHERE session_id="
        . $session_id . ";";
    my $res = $dbh->do($SQL);
    if ( defined $res )
    {
        __printComment(
            "Radiator DB updated session table with config_id $id for session_id $session_id."
        );
    }
    else
    {
        __printComment(
            "ERROR 440: Could not update the 'config_id' field in the Radiator DB (session table). \n"
                . $dbh->errstr
                . "\n SQL: "
                . $SQL );
    }

    return;
}   # END of __create_config

sub __create_filter
{
############################################################
#
# Sub: __create_filter (dbh, session_id, filter_name, filter_displayname)
# Returns:
# Function:
# This function stores filter information 
# in the radiator database.
#
############################################################

    my $dbh                = shift;  # the database handler
    my $session_id         = shift;  # the session id
    my $filter_name        = shift;  # the filter name
    my $filter_displayname = shift;  # the filter display name

    __printComment( "==============================",
            "=== $RadiatorName   ===",
            "=== __create_filter()      ===",
                    "==============================" );
    
    # Check if the filter name exists in the database
    my $SQL = "SELECT count(*) AS NbOfIds FROM filter WHERE filter_name='"
        . $filter_name . "';";
    my $sth = $dbh->prepare($SQL);
    $sth->execute;
    my $row_href = $sth->fetchrow_hashref();
    my $NbOfIds = $row_href->{NbOfIds};
    $sth->finish;

    my $id = 0;
    if ( $NbOfIds > 0 )
    {
        # filter name exists in the database
        $SQL = "SELECT filter_id FROM filter WHERE filter_name='"
            . $filter_name . "';";
        $sth = $dbh->prepare($SQL);
        $sth->execute;
        $row_href = $sth->fetchrow_hashref();
        $id = $row_href->{filter_id};
        $sth->finish;
        __printComment(
               "filter name $filter_name already in Radiator DB with id $id.");
    }
    else
    {
        # filter does not exist in the database so insert it
        $SQL =
            "INSERT INTO filter (filter_name, filter_displayname) VALUES ('$filter_name', '$filter_displayname');";
        my $res = $dbh->do($SQL);
        if ( defined $res )
        {
            # New values inserted. Get the filter_id for this filter
            $id = $dbh->{'mysql_insertid'}
                ;    # "SELECT LAST_INSERT_ID() AS filter_id;"
            __printComment("Radiator DB created new filter id: $id");
        }
        else
        {
            # ERROR: 400
            __printErrorAndExit( 400,
                "Could not create new filter in the radiator DB (filter table). \n"
                    . $dbh->errstr
                    . "\n SQL: "
                    . $SQL );
        }
    }

    # insert the filter_id into the table session
    $SQL =
          "UPDATE session SET filter_id='"
        . $id
        . "' WHERE session_id="
        . $session_id . ";";
    my $res = $dbh->do($SQL);
    if ( defined $res )
    {
        __printComment(
            "Radiator DB updated session table with filter_id $id for session_id $session_id."
        );
    }
    else
    {
        __printComment(
            "ERROR 440: Could not update the 'filter_id' field in the Radiator DB (session table). \n"
                . $dbh->errstr
                . "\n SQL: "
                . $SQL );
    }

    return;
}   # END of __create_filter

sub __create_link_id
{
############################################################
#
# Sub: __create_link_id (dbh)
# Returns: link_id
# Function:
# This function stores link information 
# in the radiator database.
#
############################################################

    my $dbh = shift;  # the database handler

    __printComment( "==============================",
            "=== $RadiatorName   ===",
            "=== __create_link_id()     ===",
                    "==============================" );
    
    my $SQL = "SELECT coalesce(max(link_id)+1,1) AS ID FROM `link`;";
    my $sth = $dbh->prepare($SQL);
    $sth->execute;
    my $row_href = $sth->fetchrow_hashref();
    my $id = $row_href->{ID};
    $sth->finish;
    __printComment("Created link id $id in Radiator DB.");

    return $id;
}   # END of __create_link_id

sub __check_link
{
############################################################
#
# Sub: __check_link (dbh, link_id, link_url, link_name)
# Returns: link_id if it exist, otherwise 0
# Function:
# This function stores link information 
# in the radiator database.
#
############################################################

    my $dbh         = shift;  # the database handler
    my $link_url    = shift;  # the link url
    my $link_name   = shift;  # the link name

    __printComment( "==============================",
            "=== $RadiatorName   ===",
            "=== __check_link()         ===",
                    "==============================" );
    
    # Check if the link url exists in the database
    my $SQL =
          "SELECT count(*) AS NbOfIds FROM link WHERE link_url='"
        . $link_url
        . "' AND link_name='"
        . $link_name . "';";
    my $sth = $dbh->prepare($SQL);
    $sth->execute;
    my $row_href = $sth->fetchrow_hashref();
    my $NbOfIds = $row_href->{NbOfIds};
    $sth->finish;

    if ( $NbOfIds > 0 )
    {
        # link url exists in the database
        $SQL =
              "SELECT link_id FROM link WHERE link_url='"
            . $link_url
            . "' AND link_name='"
            . $link_name . "';";
        $sth = $dbh->prepare($SQL);
        $sth->execute;
        $row_href = $sth->fetchrow_hashref();
        my $id = $row_href->{link_id};
        $sth->finish;
        __printComment(
            "link $link_url ($link_name) already in Radiator DB with id $id.");
        return $id;
    }
    return 0;
}   # END of __check_link

sub __update_link
{
############################################################
#
# Sub: __update_link (dbh, session_id, link_id)
# Function:
# This function stores link information 
# in the radiator database.
#
############################################################

    my $dbh         = shift;  # the database handler
    my $session_id  = shift;  # the session id
    my $link_id     = shift;  # the link id

    __printComment( "==============================",
            "=== $RadiatorName   ===",
            "=== __update_link()        ===",
                    "==============================" );
    
    # insert the link_id into the table session
    my $SQL =
          "UPDATE session SET link_id='"
        . $link_id
        . "' WHERE session_id="
        . $session_id . ";";
    my $res = $dbh->do($SQL);
    if ( defined $res )
    {
        __printComment(
            "Radiator DB updated session table with link_id $link_id for session_id $session_id."
        );
    }
    else
    {
        __printComment(
            "ERROR 440: Could not update the 'link_id' field in the Radiator DB (session table). \n"
                . $dbh->errstr
                . "\n SQL: "
                . $SQL );
    }
}   # END of __update_link

sub __create_link
{
############################################################
#
# Sub: __create_link (dbh, session_id, link_id, link_url, link_name)
# Returns:
# Function:
# This function stores link information 
# in the radiator database.
#
############################################################

    my $dbh         = shift;  # the database handler
    my $session_id  = shift;  # the session id
    my $link_id     = shift;  # the link id
    my $link_url    = shift;  # the link url
    my $link_name   = shift;  # the link name

    __printComment( "==============================",
            "=== $RadiatorName   ===",
            "=== __create_link()        ===",
                    "==============================" );

    # Check if the link url exists in the database
    my $SQL =
          "SELECT count(*) AS NbOfIds FROM link WHERE link_id='"
        . $link_id
        . "' AND link_url='"
        . $link_url . "';";
    my $sth = $dbh->prepare($SQL);
    $sth->execute;
    my $row_href = $sth->fetchrow_hashref();
    my $NbOfIds = $row_href->{NbOfIds};
    $sth->finish;

    if ( $NbOfIds > 0 )
    {
        # link url exists in the database
        __printComment(
                "link url $link_url already in Radiator DB with id $link_id.");
        return $session_id;
    }
    else
    {
        # link url does not exist in the database so insert it
        $SQL =
            "INSERT INTO link (link_id, link_url, link_name) VALUES ('$link_id', '$link_url', '$link_name');";
        my $res = $dbh->do($SQL);
        if ( defined $res )
        {
            # New values inserted. 
            __printComment(
                "Radiator DB created new link $link_name with link id: $link_id"
            );
        }
        else
        {
            # ERROR: 400
            __printErrorAndExit( 400,
                "Could not create new link in the radiator DB (link table). \n"
                    . $dbh->errstr
                    . "\n SQL: "
                    . $SQL );
        }
    }

    # insert the link_id into the table session
    $SQL =
          "UPDATE session SET link_id='"
        . $link_id
        . "' WHERE session_id="
        . $session_id . ";";
    my $res = $dbh->do($SQL);
    if ( defined $res )
    {
        __printComment(
            "Radiator DB updated session table with link_id $link_id for session_id $session_id."
        );
    }
    else
    {
        __printComment(
            "ERROR 440: Could not update the 'link_id' field in the Radiator DB (session table). \n"
                . $dbh->errstr
                . "\n SQL: "
                . $SQL );
    }

    return;
}   # END of __create_link

sub __create_no_of_tc
{
############################################################
#
# Sub: __create_no_of_tc (dbh, session_id, no_of_tc)
# Function:
# This function number of testcases information 
# in the radiator database.
#
############################################################

    my $dbh         = shift;  # the database handler
    my $session_id  = shift;  # the session id
    my $no_of_tc    = shift;  # the number of testcases

    __printComment( "==============================",
            "=== $RadiatorName   ===",
            "=== __create_no_of_tc()    ===",
                    "==============================" );
    
    # insert the no_of_tc into the table session
    my $SQL =
          "UPDATE session SET nr_of_test_cases='"
        . $no_of_tc
        . "' WHERE session_id="
        . $session_id . ";";
    my $res = $dbh->do($SQL);
    if ( defined $res )
    {
        __printComment(
            "Radiator DB updated session table with nr_of_test_cases to $no_of_tc for session_id $session_id."
        );
    }
    else
    {
        __printComment(
            "ERROR 440: Could not update the 'nr_of_test_cases' field in the Radiator DB (session table). \n"
                . $dbh->errstr
                . "\n SQL: "
                . $SQL );
    }
}   # END of __create_no_of_tc

sub __create_product
{
############################################################
#
# Sub: __create_product (dbh, session_id, product_number, product_revision)
# Returns:
# Function:
# This function stores product information 
# in the radiator database.
#
############################################################

    my $dbh                = shift;  # the database handler
    my $session_id         = shift;  # the session id
    my $product_number     = shift;  # the product number
    my $product_revision   = shift;  # the product revision

    __printComment( "=============================",
            "=== $RadiatorName  ===",
            "=== __create_product()    ===",
                    "=============================" );

    # Check if the product number and revision exists in the database
    my $SQL =
          "SELECT count(*) AS NbOfIds FROM product WHERE product_number='"
        . $product_number
        . "' AND product_revision='"
        . $product_revision . "';";
    my $sth = $dbh->prepare($SQL);
    $sth->execute;
    my $row_href = $sth->fetchrow_hashref();
    my $NbOfIds = $row_href->{NbOfIds};
    $sth->finish;

    my $id = 0;
    if ( $NbOfIds > 0 )
    {
        # product number and revision exists in the database
        $SQL =
              "SELECT product_id FROM product WHERE product_number='"
            . $product_number
            . "' AND product_revision='"
            . $product_revision . "';";
        $sth = $dbh->prepare($SQL);
        $sth->execute;
        $row_href = $sth->fetchrow_hashref();
        $id = $row_href->{product_id};
        $sth->finish;
        __printComment(
            "product number $product_number with revision $product_revision already in Radiator DB with id $id."
        );
    }
    else
    {
        # product number/revision does not exist in the database so insert it
        $SQL =
            "INSERT IGNORE INTO product (product_number, product_revision) VALUES ('$product_number', '$product_revision');";
        my $res = $dbh->do($SQL);
        if ( defined $res )
        {
            # New values inserted. Get the product_id for this product
            $id = $dbh->{'mysql_insertid'}
                ;    # "SELECT LAST_INSERT_ID() AS product_id;"
            __printComment("Radiator DB created new product id: $id");
        }
        else
        {
            # ERROR: 400
            __printErrorAndExit( 400,
                "Could not create new product in the radiator DB (product table). \n"
                    . $dbh->errstr
                    . "\n SQL: "
                    . $SQL );
        }
    }

    # insert the product_id into the table session
    $SQL =
          "UPDATE session SET product_id='"
        . $id
        . "' WHERE session_id="
        . $session_id . ";";

    my $res = $dbh->do($SQL);
    if ( defined $res )
    {
        __printComment(
            "Radiator DB updated session table with product_id $id for session_id $session_id."
        );
    }
    else
    {
        __printComment(
            "ERROR 440: Could not update the 'product_id' field in the Radiator DB (session table). \n"
                . $dbh->errstr
                . "\n SQL: "
                . $SQL );
    }		
	
    return $id;							#NEW
}   # END of __create_product

## NEW
sub __create_from_product
{
############################################################
#
# Sub: __create_from_product (dbh, session_id, to_product_id, from_product_number, from_product_revision)
# Returns:
# Function:
# This function stores product information 
# in the radiator database.
#
############################################################

    my $dbh                		= shift;  # the database handler
    my $session_id         		= shift;  # the session id
    my $to_product_id			= shift;  # the product id			
    my $from_product_number     	= shift;  # the from_product number
    my $from_product_revision   	= shift;  # the from_product revision

    __printComment( "=============================",
            "=== $RadiatorName  ===",
            "=== __create_from_product()    ===",
                    "=============================" );

    # Check if the from_product number and from_revision exists in the table product
    my $SQL =
          "SELECT count(*) AS NbOfIds FROM product WHERE product_number='"
        . $from_product_number
        . "' AND product_revision='"
        . $from_product_revision . "';";
    my $sth = $dbh->prepare($SQL);
    $sth->execute;
    my $row_href = $sth->fetchrow_hashref();
    my $NbOfIds = $row_href->{NbOfIds};
    $sth->finish;

    my $id = 0;
    if ( $NbOfIds > 0 )
    {
        # from_product number and from_revision exists in the table
        $SQL =
            "SELECT product_id AS from_product_id FROM product WHERE product_number='"
            . $from_product_number
            . "' AND product_revision='"
            . $from_product_revision . "';";
        $sth = $dbh->prepare($SQL);
        $sth->execute;
        $row_href = $sth->fetchrow_hashref();
        $id = $row_href->{from_product_id};
	$from_product_id = $id;
        $sth->finish;
        __printComment(
            "from product number $from_product_number with from_revision $from_product_revision already in Radiator DB with id $id."
        );
    }
    else
    {
	# from_product number/from_revision does not exist in the table so insert it
        $SQL =
            "INSERT INTO product (product_number, product_revision) VALUES ('$from_product_number', '$from_product_revision');";
        my $res = $dbh->do($SQL);
        if ( defined $res )
        {
            # New values inserted. Get the from_product_id for this table product
            $id = $dbh->{'mysql_insertid'}
                ;    # "SELECT LAST_INSERT_ID() AS product_id;"
            $from_product_id = $id;
            __printComment("Radiator DB created new from product id: $id");
        }
        else
        {
            # ERROR: 400
            __printErrorAndExit( 400,
                "Could not create new from product in the radiator DB (product table). \n"
                    . $dbh->errstr
                    . "\n SQL: "
                    . $SQL );
        }
    }

    # insert the from_product_id into the table session for that product_id 
    $SQL =
          "UPDATE session SET from_product_id ='"
        . $from_product_id
        . "' WHERE session_id ="
        . $session_id
        . " AND product_id = "
        . $to_product_id . ";";
    my $res = $dbh->do($SQL);
    if ( defined $res )
    {
        __printComment(
            "Radiator DB updated session table with from_product_id $id for session_id $session_id. and product_id $to_product_id"
        );
    }
    else
    {
        __printComment(
            "ERROR 440: Could not update the 'from_product_id' field in the Radiator DB (session table). \n"
                . $dbh->errstr
                . "\n SQL: "
                . $SQL );
    }

    return;
}   # END of __create_from_product
## END NEW

sub __create_rrs_instance
{
############################################################
#
# Sub: __create_rrs_instance (dbh, session_id, rrs_session_id, rrs_instance_wsdl, rrs_instance_search)
# Returns: 
# Function:
# This function stores rrs information 
# in the radiator database.
#
############################################################

    my $dbh                   = shift;  # the database handler
    my $session_id            = shift;  # the session id
    my $rrs_session_id        = shift;  # the rrs session id
    my $rrs_instance_wsdl     = shift;  # the rrs instance wsdl
    my $rrs_instance_search   = shift;  # the rrs instance search

    __printComment( "===============================",
            "=== $RadiatorName    ===",
            "=== __create_rrs_instance() ===",
                    "===============================" );

    # Check if the rrs instance wsdl/search exists in the database
    my $SQL =
        "SELECT count(*) AS NbOfIds FROM rrs_instance WHERE rrs_instance_wsdl='"
        . $rrs_instance_wsdl
        . "' AND rrs_instance_search='"
        . $rrs_instance_search . "';";
    my $sth = $dbh->prepare($SQL);
    $sth->execute;
    my $row_href = $sth->fetchrow_hashref();
    my $NbOfIds = $row_href->{NbOfIds};
    $sth->finish;

    my $id = 0;
    if ( $NbOfIds > 0 )
    {
        # rrs instance wsdl/search exists in the database
        $SQL =
            "SELECT rrs_instance_id FROM rrs_instance WHERE rrs_instance_wsdl='"
            . $rrs_instance_wsdl
            . "' AND rrs_instance_search='"
            . $rrs_instance_search . "';";
        $sth = $dbh->prepare($SQL);
        $sth->execute;
        $row_href = $sth->fetchrow_hashref();
        $id = $row_href->{rrs_instance_id};
        $sth->finish;
        __printComment(
            "rrs instance wsdl $rrs_instance_wsdl and rrs instance search $rrs_instance_search already in Radiator DB with id $id."
        );
    }
    else
    {
        # rrs instance wsdl/search does not exist in the database so insert it
        $SQL =
            "INSERT INTO rrs_instance (rrs_instance_wsdl, rrs_instance_search) VALUES ('$rrs_instance_wsdl', '$rrs_instance_search');";
        my $res = $dbh->do($SQL);
        if ( defined $res )
        {
            # New values inserted. Get the rrs_instance_id for this product
            $id = $dbh->{'mysql_insertid'}
                ;    # "SELECT LAST_INSERT_ID() AS rrs_instance_id;"
            __printComment("Radiator DB created new rrs instance id: $id");
        }
        else
        {
            # ERROR: 400
            __printErrorAndExit( 400,
                "Could not create new rrs_instance in the radiator DB (rrs_instance table). \n"
                    . $dbh->errstr
                    . "\n SQL: "
                    . $SQL );
        }
    }

    # insert the rrs_instance_id and the rrs_session_id into the table session
    $SQL =
          "UPDATE session SET rrs_instance_id='"
        . $id
        . "' WHERE session_id="
        . $session_id . ";";
    my $res = $dbh->do($SQL);
    if ( defined $res )
    {
        __printComment(
            "Radiator DB updated session table with rrs_instance_id $id for session_id $session_id."
        );
    }
    else
    {
        __printComment(
            "ERROR 440: Could not update the 'rrs_instance_id' field in the Radiator DB (session table). \n"
                . $dbh->errstr
                . "\n SQL: "
                . $SQL );
    }
    
    # Check if the rrs session id exists in the database
    $SQL = "SELECT count(*) AS NbOfIds FROM session WHERE rrs_session_id='"
        . $rrs_session_id . "';";
    $sth = $dbh->prepare($SQL);
    $sth->execute;
    $row_href = $sth->fetchrow_hashref();
    $NbOfIds = $row_href->{NbOfIds};
    $sth->finish;

    $id = 0;
    if ( $NbOfIds > 0 )
    {
        # rrs session id exists in the database
        $SQL = "SELECT rrs_session_id FROM session WHERE rrs_session_id='"
            . $rrs_session_id . "';";
        $sth = $dbh->prepare($SQL);
        $sth->execute;
        $row_href = $sth->fetchrow_hashref();
        $id = $row_href->{rrs_session_id};
        $sth->finish;
        __printComment(
            "ERROR: rrs session id $rrs_session_id already exist in the Radiator DB with id $id."
        );
    }
    else
    {
        $SQL =
              "UPDATE session SET rrs_session_id='"
            . $rrs_session_id
            . "' WHERE session_id="
            . $session_id . ";";
        my $res = $dbh->do($SQL);
        if ( defined $res )
        {
            __printComment(
                "Radiator DB updated session table with rrs_session_id $rrs_session_id for session_id $session_id."
            );
        }
        else
        {
            __printComment(
                "ERROR 440: Could not update the 'rrs_session_id' field in the Radiator DB (session table). \n"
                    . $dbh->errstr
                    . "\n SQL: "
                    . $SQL );
        }
    }

    return;
}   # END of __create_rrs_instance

sub __create_session_id()
{
############################################################
#
# Sub: __create_session_id
#
############################################################

    my $dbh = shift;  # database handle

    # Session does not exist in the database so insert it
    my $SQL = "INSERT INTO session VALUES();";
    my $id;
    my $res = $dbh->do($SQL);
    if ( defined $res )
    {
        # New values inserted. Get the rbs_config_id for this configurations
        $id = $dbh->{'mysql_insertid'}
            ;           # "SELECT LAST_INSERT_ID() AS session_id;"
        __printComment("Radiator DB created new session id: $id");
    }
    else
    {
        # ERROR: 400
        __printErrorAndExit( 400,
            "Could not create new session in the radiator DB (session table). \n SQL: "
                . $SQL );
    }
    return $id;
}   # END of __create_session_id

sub __dbConnect() 
############################################################
#
# Sub: __dbConnectNew(db,host,port,user,password)
#
############################################################
{
  # Database connect
    my ( $db, $host, $port, $usr, $pwd ) = @_;
  my $databasePath = "DBI:mysql:database=$db;host=$host:$port";
  my $dbh = DBI->connect( $databasePath, "$usr", "$pwd",
                            { RaiseError => 0, AutoCommit => 1 } );
  return $dbh;

}   # END of __dbConnect

sub __printComment
{
############################################################
#
# Sub: __printComment ( <Comment> )
#
# Function:
# To print a comment.
#
############################################################

    return unless ($verbose);
    my @time = localtime;
    $time[5] += 1900;
    $time[4] += 1;
    my $time = sprintf( "[%04d-%02d-%02d %02d:%02d:%02d] ",
                        @time[ 5, 4, 3, 2, 1, 0 ] );
    my $indt = " " x length $time;
    print $time . shift() . "\n";
    print $indt . shift() . "\n" while (@_);

}   # END of __printComment

sub __printErrorAndExit
{
############################################################
#
# Sub: __printErrorAndExit ( <Error Code> <Error description> )
#
# Function:
# To exit with given exit code.
#
############################################################

    my $ErrorCode   = shift;
    my $Description = shift;

    print "\n";
    print "<1> === ************************************************\n";
    print "<1> === ERROR: $ErrorCode\n";
    print "<1> === $Description \n";
    print "<1> === ************************************************\n";
    print "\n";
    exit $ErrorCode;

}   # END of __printErrorAndExit

1;
