#!/usr/bin/perl

use strict;
my $BASE;
BEGIN
{
    use Cwd 'abs_path';
    umask 2;
    $BASE = abs_path($0);
    $BASE =~ s:(/[^/]+){2}$::;

    unshift @INC,     $BASE, "$BASE/lib";
}


use moshellApi;
use Data::Dumper;
my $exitCode = 0;

print "------------- INIT -------------\n";
my $logpath = "/tmp/moshellApiTest";
my $moshellLogFile = "$logpath/moshell_logfile.txt";
my $moshellLogFiles = "$logpath/moshell_logfiles";
my $developmentPath = "$logpath/developmentPath";
`rm -rf $logpath` if -d $logpath;
`mkdir -p $logpath` if !-d $logpath;




print "------------- TEST CREATING NEW MOSHELL INSTANCE -------------\n";
my $mos = moshellApi->new(
	timeout  => 7200,
	ip       => "10.74.59.134",
	password => "tch134",
	nodeName => "tch134",
	mosDebug => 0,
	silent   => 0,
	logDir   => $moshellLogFiles,
	logFile   => $moshellLogFile,
	setDevelopment => $developmentPath,
	apiDebug => 0);

print "------------- TEST CONNECT MOSHELL -------------\n";
my $connecktionCheck = $mos->connect();
printResult($connecktionCheck);


if ( defined $$mos{errorCode} ){
	printResult(0, "errorCode: $$mos{errorCode}\n");
}




print "------------- TEST SEND MOSHELL COMMAND LT ALL -------------\n";
my $resLT = $mos->send( cmd => "lt all", output => 1 );
#Last MO:  6247. Loaded 6247 MOs. Total:  6248 MOs.
my $ltHit = 0;
if ( $resLT =~ /(Last MO:.+?Total:.*)/ ){
	$ltHit = 1;
}
printResult($ltHit);






print "------------- TEST GET ATTRIBUTE -------------\n";
my ( $value, $valueinfo ) = $mos->getAttr( mo => "configurationVersion=1", attr => "executingCv"  );
my ( @structList ) = $mos->getStruct( mo => "configurationVersion=1", attr => "storedConfigurationVersions",mosdebug => 0  );
my $attribResult = 0;
foreach my $struct ( @structList ){
	if( $$struct{name} eq $value ){
		$attribResult = 1;
	} 
}
printResult($attribResult);




print "------------- TEST SEND MOSHELL COMMAND RETURN LIST -------------\n";
my @result = $mos->send( cmd => "al", output => 0 );
my $alHit = 0;
foreach my $line ( @result ){
	if ( $line =~ />>> Total:/ ){
		$alHit = 1;
	}
}
printResult($alHit);






print "------------- TEST SEND MOSHELL COMMAND RETURN STRING -------------\n";
my $resVII = $mos->send( cmd => "vii", mosDebug => 0, output => 1 );
my $viiHit = 0;
if ( $resVII =~ /(.+(YELLOW|RED|GREEN|LED).+)/ ){
	$viiHit = 1;
}
printResult($viiHit);







print "------------- TEST SEND MOSHELL COMMAND CREATING LOGFILE -------------\n";
my $outfile = "$logpath/vii.log";
$mos->send( cmd => "vii", output => 99, outfile => $outfile );

if ( !-e $outfile ){
	printResult(0);
}
else{
	print "OUTFILE created: $outfile\n";
	open OUTFILE, "<$outfile";
	my @a = <OUTFILE>;
	close OUTFILE;
	my $viiHitOUTFILE = 0;
	if(!@a){
		printResult(0);
	}
	else{
		
		foreach my $line (@a){
			if ( $line =~ /(.+(YELLOW|RED|GREEN|LED).+)/ ){
				$viiHitOUTFILE = 1;
			}
		}
	}
	printResult($viiHitOUTFILE);
}





print "------------- TEST CHECK MOSHELL LOG FILE IS CREATED -------------\n";
if (!-d $moshellLogFiles ){
	print "no moshell logdir created: $moshellLogFiles\n";
	printResult(0);
}
else{
	print "moshell logdir created: $moshellLogFiles\n";
	printResult(1);
}





print "------------- checking moshell logfile -------------\n";
if ( !-e $moshellLogFile ){
	print "moshell logFile is not created. ($moshellLogFile)\n";
	printResult(0);
}
else{
	print "moshellLogFile is created: $moshellLogFile\n";
	printResult(1);
}





print "------------- TEST CHEKING SO DEVELOPMENT FILE IS CREATED -------------\n";
if ( !-e $developmentPath ){
	printResult(0);
}
else{
	my $lsRes = `ls -l $developmentPath`;
	my $lsResHit = 0;
	if ( $lsRes =~ /total\s+(\d+)/ ){
		$lsResHit = 1 if $1 > 0;
	}
	printResult($lsResHit);
}



print "------------- TEST NODE RESTART -------------\n";
my $restart = $mos->send( cmd => "acc 0 manualrestart", timeout => 180, mosDebug => 0, output => 1, prompts => [0,0,"moshellApiTest"] );
if( $restart =~ /Return value = null/ ){
	printResult(1);
}
else{
	printResult(0);
}

my $poll = $mos->send( cmd => "poll", mosDebug => 0, output => 1, apiDebug => 0 );
if( $poll =~ /MO service is ready/ ){
	printResult(1);
}
else{
	printResult(0,$poll);
}




print "------------- DOWNLOAD DCGK -------------\n";
my @dcgResult = $mos->send( cmd => "dcgk", output => 0 );
my $dcgDump;
foreach my $line ( @dcgResult ){
	if ( $line =~ /Successful storage of the MO dump to (.*)$/ ){
		$dcgDump = $1;
	}
}
printResult((defined $dcgDump?1:0),\@dcgResult);





print "------------- TEST RECONNECT -------------\n";
my $resVII = $mos->send( cmd => "bye", mosDebug => 0, output => 1, apiDebug => 0 );

my $resVIIreconnect = $mos->send( cmd => "vii", mosDebug => 0, output => 1, apiDebug => 0 );
my $viiHitReconnect = 0;
if ( $resVIIreconnect =~ /(.+(YELLOW|RED|GREEN|LED).+)/ ){
	$viiHitReconnect = 1;
}
printResult($viiHitReconnect,$resVIIreconnect);



sleep 60;

print "------------- TEST TIMEOUT -------------\n";
my $resTIMEOUT = $mos->send( cmd => "inv .", output => 2, timeout => 2 );

if ( defined $$resTIMEOUT{error} && $$resTIMEOUT{error} =~ /^\s*1.+/){
	printResult(1);
}
else{
	printResult(0, $resTIMEOUT);
}

sleep 60;


print "------------- TEST SEND COMMAND AFTER SEND TIMEOUT -------------\n";
my $resCmdTIMEOUT = $mos->send( cmd => "vii", output => 2 );
my $resTIMEOUT = 0;
if ( $$resCmdTIMEOUT{before_match} =~ /(.+(YELLOW|RED|GREEN|LED).+)/ ){
	$resTIMEOUT = 1;
}
printResult($resTIMEOUT,$resCmdTIMEOUT);





print "------------- TEST RETRIVE CORRECT RESULT -------------\n";
my @resVII = $mos->send( cmd => "vii", mosDebug => 0, output => 0, prompts => [0,0] );
my $retriveViiRes = 0;
foreach my $line ( @resVII ){
	if ( $line =~/^\$\s+vii/ ){
		$retriveViiRes = 1;
	}
}
#printResult($retriveViiRes);

#how solve, will give wrong result?
#need to figure out how to clear without timeout.
my @pwd = $mos->send( cmd => "pwd", mosDebug => 0, output => 0 );
my $retrivePwdRes = 0;
foreach my $line ( @pwd ){
	if ( $line =~/^\$\s+pwd/ ){
		$retrivePwdRes = 1;
	}
}
#printResult($retrivePwdRes);
print "Not implemented.\n";



print "------------- TEST CLOSE MOSHELL  -------------\n";
#Add check
$mos->close();




print "------------- TEST CREATING NEW MOSHELL INSTANCE IN DEVELOPMENT MODE -------------\n";
my $mos = moshellApi->new( getDevelopment => $developmentPath,
						   ip       => "10.74.59.134",
						   apiDebug => 0, );





print "------------- TEST SEND USING CASHED DATA FROM DEVELOMPENT PATH -------------\n";

my $resVIIOFFLINE = $mos->send( cmd => "vii", output => 1 );
my $viiHitOFFLINE = 0;
if ( $resVIIOFFLINE =~ /(.+(YELLOW|RED|GREEN|LED).+)/ ){
	$viiHitOFFLINE = 1;
}
printResult($viiHitOFFLINE);
my $res1 = $mos->send( cmd => "vii", output => 2 );
if ( -e $$res1{developmentFile} && $$res1{before_match} =~ /(.+(YELLOW|RED|GREEN|LED).+)/){
	printResult(1);
}
else{
	printResult(0);
}
my $res2 = $mos->send( cmd => "vii", output => 2 );
if ( -e $$res2{developmentFile} && $$res2{before_match} =~ /(.+(YELLOW|RED|GREEN|LED).+)/){
	printResult(1);
}
else{
	printResult(0);
}




print "------------- TESTING PASSWORD CHECK USING WRONG PASSWORD -------------\n";
my $mos = moshellApi->new(
	timeout        => 7200,
	ip             => "10.74.59.134",
	password       => "laban",
	logDir         => $moshellLogFiles,
	mosDebug       => 0,
	silent         => 1,
	apiDebug       => 0);


my $wrongPasswordCheck = $mos->connect();
if ( $wrongPasswordCheck == 1 ){
	printResult(0);
}
elsif ( $wrongPasswordCheck == 0 ){
	printResult(1);
}






print "------------- TEST CORBA SECURITY USING WRONG SECURITY -------------\n";
my $mos = moshellApi->new(
	timeout        => 7200,
	ip             => "10.74.59.134",
	password       => "tch134",
	nodeName       => "tch134",
	mosDebug       => 0,
	silent         => 1,
	param          => "corba_class=3,smart_corba=0",
	logDir         => $moshellLogFiles,
	logFile        => $moshellLogFile,
	apiDebug       => 0);

my $wrongCorbaCheck = $mos->connect();
if ( $wrongCorbaCheck == 1 ){
	printResult(0);
}
elsif ( $wrongCorbaCheck == 0 ){
	printResult(1);
}



print "------------- TEST OFFLINE -------------\n";
my $mosOFFLINE = moshellApi->new(
	timeout        => 7200,
	ip             => $dcgDump,
	logDir         => $moshellLogFiles,
	mosDebug       => 0,
	apiDebug       => 0);
my $offlinceConnectionCheck = $mosOFFLINE->connect();
printResult($offlinceConnectionCheck);
my @offlinceAl = $mosOFFLINE->send( cmd => "cvls", output => 0 );
my $alHitOffline = 0;
foreach my $line ( @offlinceAl ){
	if ( $line =~ /Executing:/ ){
		$alHitOffline = 1;
	}
}
printResult($alHitOffline);



sub printResult{
	my $res = shift;
	my $line = shift;
	$exitCode = 1 if  $res != 1;
	print "RESULT: " . ($res == 1?"PASS":"FAIL") . "\n";
	if( $res != 1){
		if( ref $line eq "HASH" ){
			print "--->" . Dumper($line);
		}
		elsif( ref $line eq "ARRAY" ){
			print "--->" . Dumper($line);
		}
		else{
			print "--->$line\n";
		}
	}
}

exit $exitCode;
