######################################################################################
#                                                                                    #
#  Ericsson AB 2001-2024    - All Rights Reserved                                   #
#                                                                                    #
# The copyright to the computer program(s) herein is the property   of Ericsson AB,  #
# Sweden. The programs may be used and/or copied only with the written permission    #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                  #
#                                                                                    #
######################################################################################

function undo(locallogfile,open_close,undoswitch,Me,opt,    \
date,maxRef,maxRefSeq,tempLdn,tempAttr,i,j,n,undoMoList,undoAttributeTable,array,undoActionTable,nr_params,\
motype,last,tempVal,make_undodelcommandfile,filetype,read_from_file,var,undo_error,tmpdn,tmpme,tmpval,tmp_attrs,moattr,crn_warning,thismoc_use_crn,\
tmpmember,tempMoc,tmptype,tmp_mom_file,vName)
{
	if (multi>0 && yangcli==0 && open_close ~ /^open/ && nrOfMomVersions > 1)
	{
		customPrint("ERROR: Undo mode is currently not supported in multi mode when several different MOM versions are loaded.\n\
It can only be used toward a single node or toward several nodes running identical MOM versions.")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	date=strftime("%y%m%d-%H%M%S",systime())
	fileOps("mkdir -p "logdir"/undo")  #always create the folder in case it had been deleted during the session by some external cleanup script
	if (open_close == "generate")
	{
		if (fileOps("test -s "locallogfile) != 0)
		{
			Display_help("u+")
			return add_to_moscomlog("","%@> Fail (Syntax error)")
		}
		while ((getline < locallogfile)>0)
		{
			gsub("\r","")
			if (/#DoNotEditThisLine: UndoLogFile|Undo(Del)*CommandFile|DiffCmdFile|ResubCommandFile /)
			{
				##DoNotEditThisLine: UndoLogFile a.b.c.d 7.0b CPP_MOM_MOM-CPP6-LSV11_2 stopfile=/tmp/3016
				if (/UndoLogFile/) filetype="log" ; else filetype="cmd"
				if (mom_version != $(NF-1))
				{
					tmp_mom_version=$(NF-1)
					tmp_mom_file=jarxmldir"/"tmp_mom_version".xml"
					if (fileOps("test -s "tmp_mom_file".gz")==0) tmp_mom_file=tmp_mom_file".gz"
					if (fileOps("test -s "tmp_mom_file) != 0)
					{
						customPrint(sprintf("\nMOM file: %s not found!\n\
Please download the file %s.xml to %s/jarxml before proceeding.\n\
This can be done with the command: getmom %s",tmp_mom_file,tmp_mom_version,moshelldir,tmp_mom_version))
						undo_error=1
					}
					else
					{
						mom_version=tmp_mom_version
						mom_file=tmp_mom_file
						readmom(mom_file)
					}
				}
				break
			}
			else if ($1~/^(CREATE|SET|ACTION|DELETE)$/)
			{
				filetype=".mo"
				break
			}
		}
		close(locallogfile)
		if (undo_error==1) return add_to_moscomlog("","%@> Fail (Syntax error)")
		if (filetype !~ /^(log|cmd|.mo)$/)
		{
			customPrint("Invalid input file! Should be either an undologfile, an undocommandfile, or an undodelcommandfile, made by moshell 7.0c or higher.")
			customPrint("Type \"h u!\" for more info.")
			return add_to_moscomlog("","%@> Fail (Syntax error)")
		}
		if (filetype=="log")
		{
			undoLogfile=locallogfile
			open_close="close"
			undoMode=2
			old_gs=gs
			assignCustomVar("$undologfile",undoLogfile)
			read_from_file=1
		}
		else if (filetype=="cmd")
		{
			if (comcli>0 || yangcli>0) vName="$undoxmlfile" ; else vName="$undotrunfile"
			undoTrunFile=gensub(/.mos$/,"",1,locallogfile) ((comcli>0 || yangcli>0)?".xml":".mo")
			empty_file(undoTrunFile)
			mos2mo(locallogfile,undoTrunFile,opt)
			assignCustomVar(vName,undoTrunFile)
			customPrint("\nResult saved to: "undoTrunFile" ("vName").")
		}
		else if (filetype==".mo")
		{
			undoMosFile=gensub(/.mo$/,"",1,locallogfile)".mos"
			empty_file(undoMosFile)
			mo2mos(locallogfile,undoMosFile)
			assignCustomVar("$undomosfile",undoMosFile)
			customPrint("\nResult saved to: "undoMosFile" ($undomosfile).")
		}
	}
	if (open_close ~ /^opens*$/)
	{
		if (undoMode > 0)
		{
			customPrint(sprintf("\n%sUndo Mode has already been started. To stop, execute command \"u-\"",(undoMode==2 ? "Simulated " : "Regular ")))
			return add_to_moscomlog("","%@> Fail (Syntax error)")
		}
		undoMode=0
		if (locallogfile != "")
		{
			if (open_close=="open" && tolower(locallogfile)=="s")
			{
				#the user wrote "u+ s" instead of "u+s"
				Display_help("u+")
				return add_to_moscomlog("","%@> Fail (Syntax error)")
			}
			if (locallogfile ~ /\.mos?$/) locallogfile=gensub(/\.mos?$/,"",1,locallogfile)".log" #if the user did "u+ file.mos" then we will not have any logfile at the end
			undoLogfile=process_path(locallogfile,"write")
			if (undoLogfile == 999) return add_to_moscomlog("","%@> Fail (Syntax error)")
		}
		else
		{
			undoLogfile=sprintf("%s/undo/undo_%s_%s.log",logdir,process_nodename(node),date)
		}
		undoMode = (open_close == "open" ? 1 : 2)
		gsg=0 ; old_gs=gs ; gs=1
		fileOps("rm "undoLogfile)
		if (mom_version=="")
		{
			#we need the MOM version in the header of the undo file
			$0="getmom" ; getmom()
			$0="parsemom" ; parsemom()
		}
		customPrint(sprintf("\nStarting the %sundo mode...",(open_close=="open"?"regular ":"simulated ")))
		customPrint("Logging cr/del/rdel/set/bl/deb/acc commands to file: " undoLogfile)
		print_date(undoLogfile,"#DoNotEditThisLine: UndoLogFile","overwrite")
		assignCustomVar("$undologfile",undoLogfile)
	}
	else if (open_close=="check")
	{
		if (undoMode==1) customPrint("\nRegular Undo Mode is active")
		else if (undoMode==2) customPrint("\nSimulated Undo Mode is active")
		else customPrint("Undo Mode is not active")
	}
	else if (open_close=="close")
	{
		if (undoMode == 0)
		{
			customPrint("\nUndo mode has not been started. To start, execute command: \"u+\" or \"u+s\".")
			return add_to_moscomlog("","%@> Fail (Syntax error)")
		}
		if (undoMode == 2)
		{
	 		undoDelCommandFile=sprintf("%s_del.mos",gensub(/\....$/,"",1,undoLogfile))
			assignCustomVar("$undodelcommandfile",undoDelCommandFile)
			close(undoDelCommandFile)
			print_date(undoDelCommandFile,"#DoNotEditThisLine: UndoDelCommandFile","overwrite")
			print "lt all" >> undoDelCommandFile
			customPrint(sprintf("\nDelete file: %s ($undodelcommandfile)",undoDelCommandFile))
			#restoreProxys(deletedProxies);
			delete deletedProxies
			make_undodelcommandfile=1
		}
		undoMode=0
		gs=old_gs
		#customPrint("\nClosing and parsing logfile: " undoLogfile)
		#  Id   MO                                                            userlabel            Result
		# 140   IubLink=5041040		                                      1 --> 0              >>> Set.
		# 173   AtmPort=1231,VplTp=47,VpcTp=47,VclTp=3410999                    --> finn 1         >>> Set.
		# 173   AtmPort=1231,VplTp=47,VpcTp=47,VclTp=3410999                  finn 1 --> finn 2    >>> Set.
		# 140   RncFunction=1,IubLink=5041040		                       >>> Mo deleted
		#RncFunction=1,IubLink=5041040                                           availabilityStatus  0 (NO_STATUS)
		#RncFunction=1,IubLink=5041040                                           operationalState   1 (ENABLED)
		#RncFunction=1,IubLink=5041040                                           rbsId              5041040
		#RncFunction=1,IubLink=5041040                                           reservedBy         [3] =
		# >>> reservedBy = RncFunction=1,UtranCell=50410401
		# >>> reservedBy = RncFunction=1,UtranCell=50410402
		# >>> reservedBy = RncFunction=1,UtranCell=50410403
		#RncFunction=1,IubLink=5041040                                           rncModuleRef       RncModule=4
		#RncFunction=1,Sid=1                                                     sib1               Struct{2}
		# >>> 1.sib1RepPeriod = 32
		# >>> 2.sib1StartPos = 2
		#RncFunction=1,CnOperator=24099                          equivalentPlmnIdentities t[1] =
		# >>> Struct[0]  has 3 members:
		# >>> 1.mcc = 240
		# >>> 2.mnc = 99
		# >>> 3.mncLength = 2
		#RncFunction=1,UeRc=12,UeRcPhyChTfc=12                                   rcTfi              i[5] = 2 1 1 1 0
		#Equipment=1,Subrack=MS                                  administrativeProductData Struct{5}
		# >>> 1.productNumber = 2/BFD 742 2018
		# >>> 2.productRevision = R1A
		# >>> 3.productName = Subrack
		# >>> 4.productInfo = Cello 2 HW
		# >>> 5.productionDate = 01W05
		close(undoLogfile)
  		while ((getline < undoLogfile)>0)
 		{
 			gsub("\r","") ; gsub("\x00","") #; print 0,$0
 			if ($1 ~ /^[A-Z].*=/ && NF >= 2)
 			{
				tempLdn=$1
				tempAttr=$2
				tempMoc=s2t($1)
				undoAttributeTable[tempLdn,tempAttr]=""
 				if ($3 ~ /^\[[0-9]+\]$/)
 				{
 					maxRef=gensub(/\[|\]/,"","g",$3)+0
 					for (i=1;i<=maxRef;i++)
 					{
 						getline < undoLogfile
 						gsub("\r","") ; gsub("\x00","") #; print 1,$0
	 					if (/^ >>> /) undoAttributeTable[tempLdn,tempAttr]=sprintf("%s %s",undoAttributeTable[tempLdn,tempAttr],$NF)
	 				}
	 				gsub(/^ +/,"",undoAttributeTable[tempLdn,tempAttr])
	 			}
	 			else if ($3 ~ /^Struct/)
	 			{
	 				maxRef=gensub(/Struct\{|\}/,"","g",$3)+0
	 				for (i=1;i<=maxRef;i++)
	 				{
	 					getline< undoLogfile
	 					gsub("\r","") ; gsub("\x00","") #; print 2,$0
	 					tmpmember=gensub(/^[0-9]+\./,"",1,$2)
	 					tmpval=gensub(/^ >>> [^ ]+ += +/,"",1,$0)
	 					sub(/ \(.*$/,"",tmpval)
	 					if (exclude_deprecated>=4 && tempMoc":"tempAttr in MoAttributesType && MoAttributesType[tempMoc":"tempAttr]!="")
	 					{
	 						tmptype=gensub(/^structRef./,"",1,MoAttributesType[tempMoc":"tempAttr])
	 						if ((tmptype,tmpmember) in struct_deprecated && struct_deprecated[tmptype,tmpmember]==1) continue
	 					}
	 					if (/^ >>> /) undoAttributeTable[tempLdn,tempAttr]=sprintf("%s,%s=%s",undoAttributeTable[tempLdn,tempAttr],tmpmember,tmpval)
	 				}
	 				sub(/^,/,"",undoAttributeTable[tempLdn,tempAttr])
	 			}
	 			else if ($3 ~ /^t\[[0-9]+\]$/)
	 			{
	 				maxRefSeq=gensub(/^t\[|\]$/,"","g",$3)+0
	 				for (j=1;j<=maxRefSeq;j++)
	 				{
	 					getline < undoLogfile
	 					gsub("\r","") ; gsub("\x00","") #; print 3,$0
		 				maxRef=$4
		 				#for (i=1;i<=maxRef;i++)
		 				while (1)
		 				{
		 					#The struct may have more lines than the number of members, TR HU51588, HU55260
							#IpSystem=1,IpSec=1,IpSecTunnel=IpSecTunnel_SECURGW507_CA_JEREZ_MSC securityAssociations t[2] =
							# >>> Struct[0]  has 6 members:
							# >>> 1.direction = 1 (EGRESS)
							# >>> 2.encryptionAlgorithm = 2 (AES_CBC_256)
							# >>> 3.integrityAlgorithm = 2 (HMAC_SHA_1_96)
							# >>> 4.localTrafficSelectors = Ip Address Range = 0.0.0.0 - 255.255.255.255, Protocol = 0, Port Range = 0 - 65535
							# >>> 5.remoteTrafficSelectors = Ip Address Range = a.b.c.d - a.b.c.d, Protocol = 0, Port Range = 0 - 65535
							#Ip Address Range = a.b.c.d - a.b.c.d, Protocol = 0, Port Range = 0 - 65535
							#Ip Address Range = a.b.c.d - a.b.c.d, Protocol = 0, Port Range = 0 - 65535
							# >>> 6.spiValue = 0x04553E34

		 					getline< undoLogfile
		 					gsub("\r","") ; gsub("\x00","") #; print 4,$0
		 					if (/^ >>> /) undoAttributeTable[tempLdn,tempAttr]=sprintf("%s,%s=%s",undoAttributeTable[tempLdn,tempAttr],gensub(/^[0-9]+\./,"",1,$2),$4)
		 					if ($1==">>>" && $2 ~ sprintf("^%s[^0-9]",maxRef)) break
		 				}
		 				sub(/^,/,"",undoAttributeTable[tempLdn,tempAttr])
		 				undoAttributeTable[tempLdn,tempAttr]=undoAttributeTable[tempLdn,tempAttr]";"
		 			}
		 			sub(/;$/,"",undoAttributeTable[tempLdn,tempAttr])
		 			gsub(/;,/,";",undoAttributeTable[tempLdn,tempAttr])
	 			}
	 			else if ($3 ~ /^[^t]\[[0-9]+\]$/)
	 			{
	 				if ($3 ~ /^i/) sub(/ \(.*$/,"",$0)  #for sequence of enum, remove the translation
	 				for (i=5;i<=NF;i++) undoAttributeTable[tempLdn,tempAttr]=sprintf("%s,%s",undoAttributeTable[tempLdn,tempAttr],$i)
	 				sub(/^,/,"",undoAttributeTable[tempLdn,tempAttr])
	 			}
	 			else
	 			{
	 				for (i=3;i<=NF;i++) undoAttributeTable[tempLdn,tempAttr]=sprintf("%s %s",undoAttributeTable[tempLdn,tempAttr],$i)
	 				gsub(/^ | \([^)=}{,]*\)[ \t]*$/,"",undoAttributeTable[tempLdn,tempAttr]) #to remove enum translations 
	 				#workaround for the attribute IubLink:preferredSubrackRef, shall not be empty otherwise, creation fails
	 				if (s2t(tempLdn)=="IubLink" && tempAttr=="preferredSubrackRef" && undoAttributeTable[tempLdn,tempAttr]=="") undoAttributeTable[tempLdn,tempAttr]="Subrack=MS #preferredSubrackRef"
	 			}
	 		}
	 		else if ($1 ~ /^[0-9]+$/ && $2 ~ /^[A-Z][^=]+=[^=]/ && />>> (Mo deleted|Simulated MO deletion)/)
	 		{
				# 140   RncFunction=1,IubLink=5041040		              >>> Mo deleted
				# 1000  TransportNetwork=1,UniSaalTp=Iub-14-36                >>> Simulated MO deletion
	 			if (undoswitch ~ "u" && $2 ~ /,UtranRelation=/) {}
	 			else undoMoList[++n]=sprintf("%s\nDEL",$2)
	 		}
	 		else if ($1=="Id" && $2=="MO" && $4=="Result")
	 		{
	 			# Id  MO                                 userLabel            Result
	 			tempAttr=$3
	 		}
	 		else if ($1 ~ /^[0-9]+$/ && $2 ~ /^[A-Z][^=]+=[^=]/ && />>> (Simulated )?Set\.$/ && / --> /)
	 		{
	 			# 0  ManagedElement=1                       RNC11 -->            >>> Set.
	 			# 0  ManagedElement=1                             --> RNC11      >>> Simulated Set.
	 			tempVal=""
	 			if ($3 == "-->") tempVal=""
	 			else if ($4 == "-->") tempVal=$3
	 			else
	 			{
	 				for (i=5;i<=NF;i++)
	 				{
	 					if ($i=="-->") break
	 				}
 					for (j=3;j<i;j++) tempVal=sprintf("%s %s",tempVal,$j)
 					sub(/^ /,"",tempVal)
	 			}
	 			undoMoList[++n]=sprintf("%s\nSET\n%s\n%s",m2l($2),tempAttr,tempVal)
	 		}
	 		else if (/>>>  \[Proxy ID = [0-9]+\] MO name :|>>> Simulated MO creation: [A-Z][^=]+=[^=]/)
	 		{
				#>>>  [Proxy ID = 82280] MO name :a.b.c.d;ManagedElement=1,RncFunction=1,UtranCell=Iub-20-3,UtranRelation=Soft-Iub-10-3
				#>>>  [Proxy ID = 5061] MO name :ManagedElement=1,RncFunction=1,UtranCell=Iub-10-1,UtranRelation=Soft-Iub-30-1
				#>>>  [Proxy ID = 346] MO name :a.b.c.d;ManagedElement=1,RncFunction=1,UtranCell=Iub 99 22
				#>>> Simulated MO creation: ManagedElement=1,RncFunction=1,IubLink=99
				#>>> Simulated MO creation: Me=rnc11,ManagedElement=1,RncFunction=1,IubLink=999
				if (multi>0 && yangcli==0) tmpme="Me="nodeName[gensub(/^[^:]+: ?|;.*$/,"","g",$0)]"," ; else tmpme=""
				tmpdn=gensub(/^.*ManagedElement=[^,]+,/,"",1,$0)
	 			undoMoList[++n]=sprintf("%s%s\nCRE",tmpme,tmpdn)
	 		}
	 		else if ($1=="InputValue" && $3 in revAction && $4 ~ /^[0-9]+$/)
	 		{
	 			#InputValue TransportNetwork=1,Aal2Sp=1,Aal2Ap=Iub-1,Aal2PathDistributionUnit=Iub-1-1 removePath 1 Aal2PathVccTp=Iub-1-51
	 			#special case for addAal2ApToRc/removeAal2ApFromRc, the order will be the opposite
				#InputValue TransportNetwork=1,Aal2RoutingCase=Iuc-2351-2300 removeAal2ApFromRc 1 TransportNetwork=1,Aal2Sp=1,Aal2Ap=Iuc-2300-2351-1
				#InputValue TransportNetwork=1,Aal2RoutingCase=Iuc-2351-2300 removeAal2ApFromRc 2 1
	 			if ($3~/^(addAal2ApToRc|removeAal2ApFromRc)$/) undoActionTable[$2,$3,($4==1?2:1)]=gensub(/^InputValue [^ ]+ [^ ]+ [^ ]+ /,"",1,$0)
	 			else undoActionTable[$2,$3,$4]=gensub(/^InputValue [^ ]+ [^ ]+ [^ ]+ /,"",1,$0)
	 		}
	 		else if ($1=="lacc" && $3 in revAction && $4 ~ /^[0-9]+$/)
	 		{
	 			#lacc TransportNetwork=1,Aal2Sp=1,Aal2Ap=Iub-1,Aal2PathDistributionUnit=Iub-1-1 removePath 1
	 			#special case for removeSyncRefResource and addSyncRefResource
	 			if ($3 ~ /^(removeSyncRefResource|resetSystConst|deleteConst|removeAal2ApFromRc)$/) nr_params=2
	 			else if ($3 ~ /^(addSyncRefResource|writeSystConst|writeConst|addAal2ApToRc)$/) nr_params=1
	 			else nr_params=$4
	 			undoMoList[++n]=sprintf("%s\nACT\n%s",$2,$3)
	 			for (i=1;i<=nr_params;i++) undoMoList[n]=sprintf("%s\n%s",undoMoList[n],undoActionTable[$2,$3,i])
	 		}
 		}
 		close(undoLogfile)
		#workaround for CPP6 and above, the attribute Aal2PathDistributionUnit::rpuId should be "d" if Aal2Ap::allocationMode==1 (AUTOMATIC)
		#this check must be outside the first read of undoLogfile since we may need to reread the undoLogfile
		#also make sure that the attribute loaderType must be "d" on Program MOs that are not below the PlugInUnit MO
		for (var in undoAttributeTable)
		{
			split(var,array,SUBSEP)
			tempLdn=array[1] ; tempAttr=array[2]
			if (s2t(tempLdn)=="Aal2PathDistributionUnit" && tempAttr=="rpuId")
			{
				if (read_from_file==1)
				{
					while ((getline < undoLogfile)>0)
					{
						gsub("\r","")
						if ($2=="allocationMode" && $1==gensub(/,Aal2PathDistributionUnit=.*$/,"",1,tempLdn) && $3==1)
						{
							undoAttributeTable[tempLdn,tempAttr]="d"
							break
						}
					}
					close(undoLogfile)
				}
				else
				{
					#multi:  Me=stp49,TransportNetwork=1,Aal2Sp=1,Aal2Ap=Iub-32,Aal2PathDistributionUnit=1
					#!multi: TransportNetwork=1,Aal2Sp=1,Aal2Ap=Iub-32,Aal2PathDistributionUnit=1
					#---> convert to: Me=stp49,ManagedElement=1,TransportNetwork=1,Aal2Sp=1,Aal2Ap=Iub-32
					if (multi) tmpdn=s2me(tempLdn)",ManagedElement=1,"gensub(/^..=[^,]+,|,Aal2PathDistributionUnit=.*$/,"","g",tempLdn)
					else tmpdn="ManagedElement=1,"gensub(/,Aal2PathDistributionUnit=.*$/,"",1,tempLdn)
					if (getMoAttribute(tmpdn,"allocationMode") ~ /^1/ || undoAttributeTable[gensub(/,Aal2PathDistributionUnit=.*$/,"",1,tempLdn),"allocationMode"]==1) undoAttributeTable[tempLdn,tempAttr]="d"
				}
			}
			#when use_crn=1 we must also do the same on Aal2Ap if the allocationMode is specified at create to value 1
			else if (use_crn==1 && s2t(tempLdn)=="Aal2Ap" && tempAttr=="allocationMode" && undoAttributeTable[tempLdn,tempAttr]==1) undoAttributeTable[tempLdn,"rpuId"]="d"
			else if (s2t(tempLdn)=="Program" && tempAttr=="loaderType" && tempLdn ~ /PlugInUnit=[^,]+,.*,Program=/) undoAttributeTable[tempLdn,"loaderType"]="d"
		}


 		undoCommandFile=sprintf("%s.mos",gensub(/\....?$/,"",1,undoLogfile))
 		close(undoCommandFile)
 		print_date(undoCommandFile,"#DoNotEditThisLine: UndoCommandFile","overwrite")
 		printf("gs+\n") >> undoCommandFile
		#if (use_crn==1) printf("if $moshell_version ~ ^([7-9]|10)\n   l echo \"The moshell version is too old. 11.0a or higher is required for scripts containing the crn command.\"\n   return\nfi\n") >> undoCommandFile
 		for (i=n;i>=1;i--)
 		{
 			last=split(undoMoList[i],array,"\n")
 			if (array[2]=="SET")
 			{
 				printf("lset %s$ %s %s\n",array[1],array[3],array[4]) >> undoCommandFile
 			}
 			else if (array[2]=="DEL")
 			{
 				tempLdn=array[1]
 				motype=s2t(tempLdn)  #must use s2t function for COM
 				#print "motype="motype
 				thismoc_use_crn=use_crn
 				if (thismoc_use_crn==1 && no_crn_mocs[gensub(/^.*\./,"",1,motype)]==1) thismoc_use_crn=0
 				if (multi>0 && yangcli==0)
 				{
 					motype=sprintf("%s%s%s",mom_version,SUBSEP,motype)
 					#print "motype (multi)="motype
 				}
 				if (motype in class_syscreated)
 				{
 					#not necessary to do "ld" on SctpAssociation since they don't have any writeable attributes
 					if (motype!="SctpAssociation") printf("\nld %s #SystemCreated\n",tempLdn) >> undoCommandFile
 				}
 				else if (thismoc_use_crn==1) printf("\ncrn %s\n",tempLdn) >> undoCommandFile
 				else printf("\ncr %s\n",tempLdn) >> undoCommandFile
 				last=split(tempLdn,array,",")
 				#motype=gensub(/=.*$/,"",1,array[last])
 				if (thismoc_use_crn!=1)
 				{
					last=split(mandatory_attributes[motype],array,",")
					if (motype in class_syscreated) last=0  #since we did not do "cr" , only "ld"
					for (j=1;j<=last;j++)
					{
						printf("%s #%s\n",undoAttributeTable[tempLdn,array[j]],array[j]) >> undoCommandFile
						delete undoAttributeTable[tempLdn,array[j]]
					}
					last=split(restricted_attributes[motype],array,",")
					if (motype in class_syscreated) last=0  #since we did not do "cr" , only "ld"
					for (j=1;j<=last;j++)
					{
						if (s2t(tempLdn)=="IpInterface" && array[j]=="rps" && undoAttributeTable[tempLdn,array[j]]=="true")
						{
							#workaround when rps is true and we will need to set defaultRouter1/2 we must set it to false when creating the MO, then set it to true at the end only
							#http://utran01.epa.ericsson.se/moshell/e107_plugins/suggestions_menu/suggestions.php?0.view.280.3.0
							printf("%s #%s\n","false",array[j]) >> undoCommandFile
						}
						else
						{
							if (undoAttributeTable[tempLdn,array[j]] == "") undoAttributeTable[tempLdn,array[j]]="d"
							else if (undoAttributeTable[tempLdn,array[j]] ~ "indicator=0,natureOfAddress=0,numberingPlan=0,translationType=0,addressInformation=,encodingScheme=0") undoAttributeTable[tempLdn,array[j]]="d"
							printf("%s #%s\n",undoAttributeTable[tempLdn,array[j]],array[j]) >> undoCommandFile
							delete undoAttributeTable[tempLdn,array[j]]
						}
					}
				}
				last=split(sorted_attribute_list[motype],array,",")
				for (j=1;j<=last;j++)
				{
					if (thismoc_use_crn==1 && (!(motype in class_syscreated)) && attr_comments[motype,array[j]] !~ /readOnly|key/ && array[j] != sprintf("%sId",motype))
					{
						printf("%s %s\n",array[j],undoAttributeTable[tempLdn,array[j]]) >> undoCommandFile
 						delete undoAttributeTable[tempLdn,array[j]]
 					}
					if (attr_comments[motype,array[j]] ~ /restricted|mandatory|nonPersistent|readOnly|key/)
					{
						#we can still set the mandatory attributes on system created MOs since we did not run the cr command on them, eg, the children of CnOperator MO
						if (motype in class_syscreated && attr_comments[motype,array[j]] ~ /mandatory/ && attr_comments[motype,array[j]] !~ /restricted|nonPersistent|readOnly|key/) {}
						else continue
					}
					if (!(sprintf("%s%s%s",tempLdn,SUBSEP,array[j]) in undoAttributeTable)) continue
					if (array[j]=="mBuffer" && s2t(tempLdn)=="Sctp" && ((tempLdn,"nThreshold") in undoAttributeTable))
					{
						#workaround when setting mBuffer the nThreshold must be set before to avoid inconsistency
						#http://utran01.epa.ericsson.se/moshell/e107_plugins/suggestions_menu/suggestions.php?0.view.279.3.0
						printf("lset %s$ %s %s\n",tempLdn,"nThreshold",undoAttributeTable[tempLdn,"nThreshold"]) >> undoCommandFile
						delete undoAttributeTable[tempLdn,"nThreshold"]
					}
					else if (array[j]=="pathSelection" && s2t(tempLdn)=="Sctp" && ((tempLdn,"switchbackMode") in undoAttributeTable))
					{
						#workaround when setting pathSelection the switchbackMode must be set before to avoid inconsistency
						printf("lset %s$ %s %s\n",tempLdn,"switchbackMode",undoAttributeTable[tempLdn,"switchbackMode"]) >> undoCommandFile
						delete undoAttributeTable[tempLdn,"switchbackMode"]
					}
					else if (array[j]=="heartbeatInterval" && s2t(tempLdn)=="Sctp")
					{
						if ((tempLdn,"maximumRto") in undoAttributeTable)
						{
							#workaround when setting heartbeatInterval the maximumRto must be set first to avoid inconsistency
							printf("lset %s$ %s %s\n",tempLdn,"maximumRto",undoAttributeTable[tempLdn,"maximumRto"]) >> undoCommandFile
							delete undoAttributeTable[tempLdn,"maximumRto"]
						}
						if ((tempLdn,"heartbeatPathProbingInterval") in undoAttributeTable)
						{
							#workaround when setting heartbeatInterval the maximumRto and heartbeatPathProbingInterval must be set before to avoid inconsistency
							printf("lset %s$ %s %s\n",tempLdn,"heartbeatPathProbingInterval",undoAttributeTable[tempLdn,"heartbeatPathProbingInterval"]) >> undoCommandFile
							delete undoAttributeTable[tempLdn,"heartbeatPathProbingInterval"]
						}
					}
					else if (array[j]=="administrativeState" && s2t(tempLdn)~/^(..PhysPathTerm|Os155SpiTtp)$/ && ((tempLdn,"loopback") in undoAttributeTable))
					{
						#workaround when setting administrativeState, the loopback attribute must be set before, while the MO is locked
						printf("lset %s$ %s %s\n",tempLdn,"loopback",undoAttributeTable[tempLdn,"loopback"]) >> undoCommandFile
						delete undoAttributeTable[tempLdn,"loopback"]
					}
					else if (array[j]=="interPwrMax" && s2t(tempLdn)=="UtranCell" && ((tempLdn,"maxPwrMax") in undoAttributeTable))
					{
						#workaround when setting interPwrMax, the maxPwrMax must be set before to avoid inconsistency
						#http://utran01.epa.ericsson.se/moshell/forum_viewtopic.php?4.4463
						printf("lset %s$ %s %s\n",tempLdn,"maxPwrMax",undoAttributeTable[tempLdn,"maxPwrMax"]) >> undoCommandFile
						delete undoAttributeTable[tempLdn,"maxPwrMax"]
					}
					else if (array[j]=="m3uaRemoteSpRefs" && s2t(tempLdn)~/^M3ua(Remote|Local)As$/ && ((tempLdn,"routingContext") in undoAttributeTable))
					{
						#workaround when setting m3uaRemoteSpRefs the routingContext must be set before otherwise we cannot set m3uaRemoteSpRef
						printf("lset %s$ %s %s\n",tempLdn,"routingContext",undoAttributeTable[tempLdn,"routingContext"]) >> undoCommandFile
						delete undoAttributeTable[tempLdn,"routingContext"]
					}
					else if (array[j]=="administrativeState" && s2t(tempLdn)=="IubLink")
					{
						#workaround when setting administrativeState on IubLink, the remoteip and sctp attributes must be set before, while the MO is locked, TR HO40742
						delete tmp_attrs
						tmp_attrs["remoteCpIpAddress1"]=tmp_attrs["remoteCpIpAddress2"]=tmp_attrs["remoteSctpPortNbapC"]=tmp_attrs["remoteSctpPortNbapD"]=1
						for (moattr in tmp_attrs)
						{
							if ((tempLdn,moattr) in undoAttributeTable)
							printf("lset %s$ %s %s\n",tempLdn,moattr,undoAttributeTable[tempLdn,moattr]) >> undoCommandFile
							delete undoAttributeTable[tempLdn,moattr]
						}
					}
					else if (array[j]=="administrativeState" && s2t(tempLdn)~/TermPointToMme(M3)?$/)
					{
						#workaround when setting administrativeState on TermPointToMme, the following attributes must be set before, while the MO is locked:
						#domainName,ipAddress1,ipAddress2,ipv6Address1,ipv6Address2
						delete tmp_attrs
						tmp_attrs["domainName"]=tmp_attrs["ipAddress1"]=tmp_attrs["ipAddress2"]=tmp_attrs["ipv6Address1"]=tmp_attrs["ipv6Address2"]=1
						for (moattr in tmp_attrs)
						{
							if ((tempLdn,moattr) in undoAttributeTable)
							printf("lset %s$ %s %s\n",tempLdn,moattr,undoAttributeTable[tempLdn,moattr]) >> undoCommandFile
							delete undoAttributeTable[tempLdn,moattr]
						}
					}
					else if (array[j]=="administrativeState" && s2t(tempLdn)=="TermPointToENB")
					{
						#workaround when setting administrativeState on TermPointToENB, the following attributes must be set before, while the MO is locked:
						#ipAddress,ipv6Address
						delete tmp_attrs
						tmp_attrs["ipAddress"]=tmp_attrs["ipv6Address"]=1
						for (moattr in tmp_attrs)
						{
							if ((tempLdn,moattr) in undoAttributeTable)
							printf("lset %s$ %s %s\n",tempLdn,moattr,undoAttributeTable[tempLdn,moattr]) >> undoCommandFile
							delete undoAttributeTable[tempLdn,moattr]
						}
					}
					printf("lset %s$ %s %s\n",tempLdn,array[j],undoAttributeTable[tempLdn,array[j]]) >> undoCommandFile
					delete undoAttributeTable[tempLdn,array[j]]
				}
				if (thismoc_use_crn==1 && (!(motype in class_syscreated))) print "end" >> undoCommandFile
			}
			else if (array[2]=="CRE")
			{
				if (mospace_convert==1 && array[1] ~ " ") gsub(" ",space_sign,array[1])
				printf("ldel %s$\n",array[1]) >> undoCommandFile
			}
			else if (array[2]=="ACT")
			{
				printf("lacc %s$ %s\n",array[1],revAction[array[3]]) >> undoCommandFile
				for (j=4;j<=last;j++) print array[j] >> undoCommandFile
			}
		}
		printf("gs-\n") >> undoCommandFile
		close(undoCommandFile)
		customPrint(sprintf("\nTo undo, execute command: run %s ($undocommandfile)",undoCommandFile))
		customPrint("\nNote: to convert command files from moshell format to "(comcli>0?"NETCONF":"trun/emas")" format, execute the command: u! <commandfile>")
		assignCustomVar("$undocommandfile",undoCommandFile)
		if (make_undodelcommandfile==1)
		{
			for (i=1;i<=n;i++)
			{
				split(undoMoList[i],array,"\n")
				if (array[2]=="DEL" && (!(s2t(array[1]) in class_syscreated)))
				{
					print "ldel " array[1] "$" >> undoDelCommandFile
				}
			}
			print "" >> undoDelCommandFile
			close(undoDelCommandFile)
		}
 	}
}

function remod(remodswitch,  newMod,remodfile,rncModMax,motypes,Filter1,i,ok,p,proxyList,iubDN,array,j,tempfilter,tempfilter1,tmpvar,result_list,old_use_crn)
{
	if (comcli>0) return comcli_error()
	if (yangcli>0) return yangcli_error()
	if (NF !=3 )
	{
		Display_help("remod")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	Filter1=$2
	newMod=$3
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)")
	if (tolower(mom_version) !~ /rnc/) { customPrint("REMOD command only applicable for RNC.") ; return }
	if (sorted_attribute_list["IubLink"] ~ /,(preferredSubrackRef|atmUserPlaneTermSubrackRef),/) { customPrint("\nThis command is obsolete, please use command \"resub\" instead.") ; return }
	motypes["rncmodule"]=motypes["iublink"]=1 ; ConditionalLoad(motypes)
	for (i in Ldn) { if (p2s("MoType",i)=="RncModule") rncModuleList[gensub(/^.*=/,"","g",p2s("Mo",i))]=gensub(/^.*=/,"","g",p2s("Mo",i)) }
	$0="" ; $2=Filter1 ; buildProxyList("short",proxyList,otherVars) ; p=otherVars["p"]
	if (p > 1 )
	{
		customPrint("Only one IubLink at a time can be remoduled. Type \"h remod\" for more indo.")
		return
	}
	else if (p2s("MoType",proxyList[p]) != "IubLink")
	{
		customPrint("Only an IubLink MO can be remoduled. Type \"h remod\" for more info.")
		return
	}
	else if (newMod !~ /^[0-9]+$/)
	{
		customPrint("The new module must be an integer. Type \"h remod\" for more info.")
		return
	}
	else
	{
		for (i in rncModuleList) { if (newMod == i) ok=1 }
		if (ok != 1)
		{
			customPrint("The new module doesn't exist.")
			return
		}
		#Force bo refresh to make sure that latest bo tables have been fetched in this session, for safety purposes
		if (rncHasBeenRefreshed != 1) boRefresh=1
		makeBoTables()
		customPrint("---------------------------------------------------------------------")
		if (remodswitch ~ "u" && mom_version < "RNC_NODE_MODEL_E") printf("Warning: UtranRelations will have to be recreated manually after the remoduling!\n")
		printf("Remodule %s from %s to RncModule=%s ? [y/n]: ",\
p2s("MediumMo",proxyList[p]),getMoAttribute(proxyList[p],"rncModuleRef"),newMod)
		iubDN=p2s("MediumMo",proxyList[p])
		answer=Read_Answer(reading_script,"","","","","yesno")
		if (tolower(answer) !~ /^y+(es)?$/) return
	}
	customPrint("---------------------------------------------------------------------\n")
	date=strftime("%y%m%d-%H%M%S",systime())
	remodfile=sprintf("%s/remod/remod_%s_%s_%s.mos",logdir,date,process_nodename(node),gensub(/^.*=/,"",1,p2s("MediumMo",proxyList[p])))
	empty_file(remodfile)
	old_use_crn=use_crn
	use_crn=0
	$0="" ; undo("","open")
	if (mom_version < "RNC_NODE_MODEL_E" || remodswitch ~ 2)
	{
		#P2.1
		$0="" ; $2=proxyList[p] ; tmpvar=del("short","rec","remod")
	}
	else
	{
		#P3 and after
		result_list=mo2plist(make_lk_list(proxyList[p],"IubLink","print"))
		last=split(result_list,array," ")
		for (j=1;j<=last;j++)
		{
			if (p2s("MoType",array[j])=="Aal5TpVccTp") tempfilter=sprintf("%s %s",tempfilter,array[j])
			else if (p2s("MoType",array[j]) == "UtranCell") tempfilter1=sprintf("%s %s",tempfilter1,array[j])
		}
		$0="lbl "tempfilter1  ; block_deblock(0,"long","noconfirm")
		$0="lrdel "tempfilter ; tmpvar=del("long","rec","remod")
		#%$0="mr tempremod" ; buildMoGroup("remove","","silent")
		if (tmpvar==0)
		{
			#means that we had accepted rdel of the aal5 belonging to the tempremod group and can go on without asking
			$0=sprintf("ldel %s,nodesynchtp",p2s("Mo",proxyList[p])) ; del("long","","","noconfirm")
			$0=sprintf("ldel %s,nodesynch",p2s("Mo",proxyList[p])) ; del("long","","","noconfirm")
		}
	}
	$0="" ; undo("","close",remodswitch)
	use_crn=old_use_crn
	while ((getline < undoCommandFile)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if ($1 ~ /^RncModule=/) print gensub($1,"RncModule="newMod,1,$0) >> remodfile
		else if ($1 ~ /^ReliableProgramUniter=/) print gensub($1,gensub(/_[0-9]+$/,"_"newMod,1,$1),1,$0) >> remodfile
		else if ($2 ~ /^#processorId/ && $1 !~ /,Slot=[45],/)
		{
			if (rncModTable[gensub(/,PlugInUnit=1/,"",1,$1)] !="") print gensub($1,rncModTable["RncModule="newMod]",PlugInUnit=1",1,$0) >> remodfile
			else print gensub($1,rncModSBTable["RncModule="newMod]",PlugInUnit=1",1,$0) >> remodfile
		}
		else if ($1 == "gs+" && tmpvar==0 && (!(mom_version < "RNC_NODE_MODEL_E" || remodswitch ~ 2))) printf("gs+\n\nlset %s$ rncModuleRef RncModule=%s\n",p2s("Mo",proxyList[p]),newMod) >> remodfile
		else print $0 >> remodfile
	}
	close(undoCommandFile)
	close(remodfile)
	Read_script(remodfile)
	if (tmpvar==1) customPrint(sprintf("\n>>>> Remoduling %s : ABORTED",iubDN))
	else if (getMoAttribute(s2p(iubDN),"rncModuleRef") == sprintf("RncModule=%s",newMod)) customPrint(sprintf("\n>>>> Remoduling %s : OK",iubDN))
	else customPrint(sprintf("\n>>>> Remoduling %s : FAILED",iubDN))
}


function set(molength,force,what,quiet,  count,count_ok,proxyList,otherVars,Filter1,Filter2,Value,Type,syntaxOk,refarray,paramok,\
Proxy,i,j,p,manyArray,z,last,last1,array,k,ok,choice,setResult,setCommand,answer,colorstart,colorend,tmpstruct,tmpstructval,blockedreason,b,\
manyTypes,manyAttributes,manyValues,tmpType,tmpAttribute,thisclass,thisattribute,forceAttr,tmpclass,Me,newval,tmpstructype,tmpwarn,refrange,res,origValue,tcount)
{
	#if (yangcli>0) return yangcli_error(1)
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }
	#Note: if "answer" is the last local variable, it crashes gawk
	setCommand=$0
	forceAttr=$3
	ok=count=count_ok=tcount=0
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)")
	buildProxyList(molength,proxyList,otherVars,"",safe_syntax,"",force)
	count=p=otherVars["p"]
	Filter1=otherVars["Filter1"]
	Filter2=otherVars["Filter2"]
	Value=otherVars["Value_to_Set"]
	origValue=Value
	Type=otherVars["Type"]
	syntaxOk=otherVars["syntaxOk"]
	#usual syntax is set mo attribute value [type]   (data type is optional)
	#problem when trying to set an attribute to a value which is equal to a data type eg "r", "s", "i", etc, for instance: set 0 userlabel r
	#if the value is empty then it shall have the value of the data type
	if (Value=="" && Type!="") { Value=Type ; Type="" }
	#print Filter1,Filter2,"val="Value,"type="Type
	if (what ~ /../ && what!="1x") { customPrint("Options cannot be mixed, only one option at a time!\n") ; Display_help("set") ; return add_to_moscomlog("","%@> Fail (Syntax error)") }
	if (what=="1x")
	{
		if (comcli>0 || yangcli>0) inSet1x=1
		else
		{
			customPrint("INFO: Option \"1x\" is only supported on COM nodes. Using option \"1\" instead.")
			what="1"
		}
	}
	if (what ~ "m" )
	{
		if (undoMode > 0) { customPrint("Option m cannot be used while running undo mode!\nPlease stop undo mode and try again.\n") ; return add_to_moscomlog("","%@> Fail (Syntax error)")}
		if (gs > 0 || gsg > 0) { customPrint("Option m cannot be used while gs/gsg is active!\nPlease stop gs/gsg and try again.\n") ; return add_to_moscomlog("","%@> Fail (Syntax error)")}
	}
	if (Value == "") Value=" "
	if (Filter2=="")
	{
		if (force != "force") Display_help("set")
		else if (force == "force") Display_help("fset")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	#find out the MO class, attribute and attribute type. We only set on MOs that have the same attribute type.
	#Otherwise there can be clashes with the attribute type, as in the case of Aal2Ap:rpuId (MoRef) and ReliableProgramUniter:rpuId (Integer)
	if (force != "force")
	{
		for (i=1;i<=p;i++)
		{
			thisclass=p2s("MoType",proxyList[i])
			if (multi>0 && yangcli==0)
			{
				Me=p2s("Me",proxyList[i])
				thisclass=sprintf("%s%s%s",momVersion[Me],SUBSEP,thisclass)
			}
			last=split(sorted_attribute_list[thisclass],array,",")
			for (j=1;j<=last;j++)
			{
				if (tolower(array[j]) == Filter2)
				{
					thisattribute=array[j]
					ok=1
					break
				}
			}
			if (ok==1) break
		}
	}
	else
	{
		thisclass=p2s("MoType",proxyList[1])
		thisattribute=forceAttr
	}
	if (what ~ "p")
	{
		inputAttribute("",MoAttributesType[thisclass":"thisattribute],attrTable,"","",thisattribute,thisclass,"e","Please enter attribute value","setp")
		Value=attrTable["value"]
	}
	if (force == "force" && Type=="")
	{
		#printf("Please enter attribute type (i|l|s|f|b|r|t|ai|al|as|af|ab|ar|at): ")
		Type=Read_Answer("","","","","","","Please enter attribute type (i|l|s|f|b|r|t|ai|al|as|af|ab|ar|at): ")
		if (Type=="")
		{
			if (Value ~ /^[0-9]+$/) Type="i"
			else Type="s"
		}
	}
	else if (Type=="")
	{
		Type=MoAttributesTypeJava[thisclass":"thisattribute]
		if (what ~ "m")
		{
			if (thisattribute!="")
			{
				manyTypes=Type
				manyAttributes=thisattribute
				last1=split(Value,manyArray," ")
				manyValues=process_value(manyArray[1],Type,force,MoAttributesType[thisclass":"thisattribute],Me)
				for (k=2;k<=last1;k++)
				{
					if (k%2==0)
					{
						tmpAttribute="NotFound"
						last=split(sorted_attribute_list[thisclass],array,",")
						for (j=1;j<=last;j++) 
						{
							if (tolower(array[j]) == tolower(manyArray[k])) 
							{
								tmpAttribute=array[j]
								break
							}
						}
						if (tmpAttribute=="NotFound")
						{
							customPrint("\n!!! Invalid attribute name: "manyArray[k])
							print_tail(0,0)
							return
						}
						tmpType=MoAttributesTypeJava[thisclass":"tmpAttribute]
						manyAttributes=manyAttributes"<@%>"tmpAttribute
						manyTypes=manyTypes"<@%>"tmpType
						manyValues=manyValues"<@%>"process_value(manyArray[k+1],tmpType,force,MoAttributesType[thisclass":"tmpAttribute],Me)
					}
				}
			}
		}
		else if (what !~ "c") Value=process_value(Value,Type,force,MoAttributesType[thisclass":"thisattribute],Me)
		#print thisclass,thisattribute,Type,MoAttributesType[thisclass":"thisattribute],Value
	}
	if (force != "force")
	{
		#the following is to avoid setting an attribute that has the same name but a different type than some other MO
		#also must skip attributes that are deprecated or obsolete
		for (i=1;i<=p;i++)
		{
			tmpclass=p2s("MoType",proxyList[i])
			if (multi>0 && yangcli==0) tmpclass=sprintf("%s%s%s",momVersion[p2s("Me",proxyList[i])],SUBSEP,tmpclass)
			if (Type=="" || MoAttributesTypeJava[tmpclass":"thisattribute] != Type ||\
			    (exclude_deprecated>=2 && attr_comments[tmpclass,thisattribute] ~ /deprecated|obsolete/))
			{
				delete proxyList[i]
				count--
			}
		}
	}
	if (bldebset_confirmation == 1 && disabled_confirmation == 0 && count >0 && quiet != "quiet" && reading_script==0)
	{
		customPrint(sprintf("Set %s on following %s MOs ?\n===================================================================================",forceAttr,count))
		for (i=1;i<=p;i++) if (i in proxyList && proxyList[i] != "") customPrint(sprintf("%5s  %s",proxyList[i],p2s("Mo",proxyList[i])))
		customPrint("===================================================================================")
		if (undoMode==2) customPrint("Note: Running in Simulated Undo mode. No actual set will be performed !!!!")
		else if (set_check>=1 && multi != 1 && force != "force" && what !~ /[cm]/)
		{
			if (attr_comments[thisclass,thisattribute] ~ "readOnly")            customPrint("Warning: this attribute is readOnly and is not possible to set.")
			else if (attr_comments[thisclass,thisattribute] ~ /key|restricted/) customPrint("Warning: this attribute is restricted and is not possible to set.")
			else if (attr_comments[thisclass,thisattribute] ~ "obsolete")       customPrint("Warning: this attribute is obsolete, use \"mom\" command for more info.")
			else if (attr_comments[thisclass,thisattribute] ~ "EricssonOnly")   customPrint("Warning: this is a EricssonOnly attribute and should only be modified by Ericsson personnel.")
			else if (attr_comments[thisclass,thisattribute] ~ "deprecated")     customPrint("Warning: this attribute is deprecated, use \"mom\" command for more info.")
			if (Type=="t")
			{
				last=split(Value,array,",")
				for (i=1;i<=last;i++)
				{
					tmpstruct=gensub(/:.*$/,"",1,array[i])
					tmpstructval=gensub(/^[^=]+=/,"",1,array[i])
					if (sprintf("%s%s%s.%s",thisclass,SUBSEP,thisattribute,tmpstruct) in param_table)
					{
						tmpstructype=struct_type[gensub(/^.*:/,"",1,MoAttributesType[thisclass":"thisattribute]),tmpstruct]
						if (tmpstructype ~ /^enumRef:/ && sprintf("%s%s%s",gensub(/^.*:/,"",1,tmpstructype),SUBSEP,tmpstructval) in enum) tmpstructval=tmpstructval" ("enum[gensub(/^.*:/,"",1,tmpstructype),tmpstructval]")"
						if (tolower(tmpstructval) != tolower(param_table[sprintf("%s%s%s.%s",thisclass,SUBSEP,thisattribute,tmpstruct)]))
						{
							customPrint(sprintf("%s"(tmpwarn!=1?"!! Warning: the new value is not according to recommended value !!\n":"")"   %s: New value = %s, Recommended value = %s%s",colorstart,tmpstruct,tmpstructval,param_table[sprintf("%s%s%s.%s",thisclass,SUBSEP,thisattribute,tmpstruct)],colorend))
							tmpwarn=1
							if (set_check==2 && attr_comments[thisclass,thisattribute] ~ "EricssonOnly") blockedreason="Not allowed to change an Ericsson Internal Parameter to a value different than its recommended value."
						}
					}
				}
			}
			else if (sprintf("%s%s%s",thisclass,SUBSEP,thisattribute) in param_table)
			{
				#print thisclass,thisattribute,MoAttributesType[thisclass":"thisattribute] #,enum[gensub(/^.*:/,"",1,MoAttributesType[thisclass":"thisattribute]),Value]
				#first, check if attribute is an enum, in which case ignore the enum translation part
				newval=Value
				if (thisclass":"thisattribute in MoAttributesType && MoAttributesType[thisclass":"thisattribute]~/^enumRef:/)
				{
					if (sprintf("%s%s%s",gensub(/^.*:/,"",1,MoAttributesType[thisclass":"thisattribute]),SUBSEP,Value) in enum) newval=Value" ("enum[gensub(/^.*:/,"",1,MoAttributesType[thisclass":"thisattribute]),Value]")"
				}
				if (tolower(newval) != tolower(param_table[thisclass,thisattribute]) )
				{
					paramok=0
					#first check if the reference value is a range of allowed values, eg -1,200,300
					if (newval ~ /^-?[0-9]+$/ && param_table[thisclass,thisattribute] ~ /^(-?[0-9]+,)(-?[0-9]+,?)+$/)
					{
						delete refrange
						split(param_table[thisclass,thisattribute],refarray,",")
						for (b in refarray) refrange[refarray[b]]=refarray[b]
						if (newval in refrange) paramok=1
					}
					if (paramok==0)
					{
						customPrint(sprintf("%s!! Warning: the new value is not according to recommended value !!\n   New value = %s, Recommended value = %s%s",colorstart,newval,param_table[thisclass,thisattribute],colorend))
						if (set_check==2 && attr_comments[thisclass,thisattribute] ~ "EricssonOnly") blockedreason="Not allowed to change an Ericsson Internal Parameter to a value different than its recommended value."
					}
				}
			}
		}
		if (blockedreason=="" && use_nosetmany==1 && count>1 && thisattribute!="" && multi!=1 && force!="force" && what!~/[cm]/ && tolower(nosetmany_list) ~ sprintf("(^|,)%s($|,)",tolower(thisattribute)))
		{
			blockedreason="Not allowed to set "thisattribute" on more than one MO instance."
		}
		#customPrint(sprintf("Set %s on %s MOs. Are you Sure [y/n] ? ",forceAttr,count),"","","noLf")
		answer=Read_Answer(reading_script,"","","","","yesno",sprintf("Set %s on %s MOs. Are you Sure [y/n] ? ",forceAttr,count))
	}
	else answer="y"
	if (tolower(answer) !~ /^y+(es)?$/)
	{
		return add_to_moscomlog("","%@> Fail (Command aborted)")
	}
	#print Proxy,p2s("MediumMo",Proxy),Value,Type
	customPrint(sprintf("\n\
============================================================================================================\n\
%5s  %*s  %*s  %s\n\
============================================================================================================",\
"Id",(what~"m"?"-20":"-60"),"MO",(what~"m"?"-69":"-19"),\
(what ~ "m" ? gensub("<@%>",",","g",manyAttributes) : (thisattribute!="" ? thisattribute : Filter2)),"Result"),undoMode)
	if (what ~ "1")
	{
		if (comcli>0 || yangcli>0) runOneTransaction=1
		res=create_session()
		if (res != "") { customPrint(res) ; print_tail(0,0) ; return }
	}
	for (i=1;i<=p;i++)
	{
		if (!(i in proxyList && proxyList[i] != "")) continue
		Proxy=proxyList[i]
		tcount++
		if ((getline dummy < stopfile)==0 && fileOps("rm "stopfile)==0) { abortLoop=1 ; break }
		#print Proxy,p2s("MediumMo",Proxy),Value,Type
		if (gs==1 && tolower(Type) !~ /^at$/)
		{
			#not supported on array of struct
			if (what ~ "1") choice=35
			else choice=31
		}
		else if (gsg==1 && tolower(Type) !~ /^(at|ar|t)$/) choice=32   #not supported on struct, array of struct, array of moref
		else if (what ~ "m") choice=30
		else if (what ~ "1") choice=34
		else choice=3
		if (what=="c")
		{
			Value=getMoAttribute(Proxy,thisattribute)
			if (Value ~ /^!!!/) continue
			if (Type ~ /^a/)
			{
				sub(/^[^ ]+ = +/,"",Value)
				if (Type ~ "r") gsub(/[\n] >>> [^ ]+ = /," ",Value)
				else if (Type ~ "t")
				{
					last=split(Value,array,/\n >>> Struct[^\n]+has[^\n]+members:/)
					Value=""
					for (j=2;j<=last;j++)
					{
						gsub(/[\n] >>> [0-9]+\./,",",array[j])
						gsub(/ = /,"=",array[j])
						sub(/^,/,"",array[j])
						Value=Value";"array[j]
					}
					sub(/^;/,"",Value)
				}
				else
				{
					gsub(" ",",",Value)
					sub(/,$/,"",Value)
				}
			}
			else if (Type ~ "t")
			{
				sub(/^Struct[^\n]+/,"",Value)
				gsub(/[\n] >>> [0-9]+\./,",",Value)
				gsub(/ = /,"=",Value)
				sub(/^,/,"",Value)
			}
			Value=process_value(Value,Type,force,MoAttributesType[thisclass":"thisattribute],Me)
		}
		if (mosdebug==1) print choice,Proxy,thisattribute,"origValue="origValue" Value="Value" Type="Type,manyAttributes,manyTypes,manyValues
		if (what!~"m" && Type=="at" && (Value=="" || Value !~ "=") && tolower(origValue) !~ /^(|null)$/)
		{
			setResult=sprintf("%-19s  %s","Incorrect Value",">>> Fail.")
		}
		else
		{
			setResult=setAttribute(choice,Proxy,thisattribute,Value,Type,manyAttributes,manyTypes,manyValues,MoAttributesType[thisclass":"thisattribute],Me,blockedreason,origValue)
			if (p2s("MoType",Proxy)=="UtranCell" && thisattribute=="administrativeState" && Value==1 && setResult ~ "No Change")
			{
				#Deblock of UtranCell must always be done regardless of gs/gsg setting where there is the attribute UtranCell:tpsPowerLockState
				#http://newtran01.au.ao.ericsson.se/moshell/forum_viewtopic.php?4.9005.0#9008
				setResult=gensub(/^1      /,"1 --> 1",1,setAttribute(3,Proxy,thisattribute,Value,Type,manyAttributes,manyTypes,manyValues,MoAttributesType[thisclass":"thisattribute],Me,blockedreason))
			}
		}
		customPrint(sprintf("%5s  %-*s  %s",Proxy,(what~"m"?20:60),p2s("MediumMo",Proxy),setResult),undoMode)
		if (setResult !~ /!!!|>>> Fail./) count_ok++
		else if (what ~ "1")
		{
			if (comcli>0 || yangcli>0)
			{
				if (what !~ "x")
				{
					runOneTransaction=0
					if (start_config_mode()==0) stop_config_mode()
				}
			}
			else create_session("rollback")
			print_tail(tcount,0)
			return
		}
		if (makeScriptSummary==1)
		{
			summaryCommand[++summaryIndex]=setCommand
			summaryResult[summaryIndex]=gensub(/^.*>>>/,">>>",1,gensub(/^.*!!!/,"!!!",1,gensub(/^.*-No Change-/,"-No Change-",1,setResult)))
		}
	}
	if (what ~ "1")
	{
		if (comcli>0 || yangcli>0)
		{
			if (what !~ "x")
			{
				runOneTransaction=0
				start_config_mode()
				res=stop_config_mode()
			}
		}
		else
		{
			res=create_session("commit")
		}
		if (res !~ /^(|0)$/) { customPrint(res) ; print_tail(count,0) ; return }
	}
	print_tail(count,count_ok,"",thisclass,thisattribute)
}
function eset(molength,force,what,quiet,  count,count_ok,proxyList,otherVars,Filter1,Filter2,Value,Type,syntaxOk,refarray,paramok,\
Proxy,i,j,p,manyArray,z,last,last1,array,k,ok,choice,setResult,setCommand,answer,tmpstruct,tmpstructval,blockedreason,b,\
manyTypes,manyAttributes,manyValues,tmpType,tmpAttribute,thisclass,thisattribute,forceAttr,tmpclass,Me,newval,tmpstructype,tmpwarn,refrange,\
res,attrList,nr,ValueToSet,tcount)
{
	#if (yangcli>0) return yangcli_error(1)
	#Note: if "answer" is the last local variable, it crashes gawk
	setCommand=$0
	ok=count=count_ok=0
	if (what ~ /../) { customPrint("Options cannot be mixed, only one option at a time!\n") ; Display_help("eset") ; return add_to_moscomlog("","%@> Fail (Syntax error)") }
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)")
	buildProxyList(molength,proxyList,otherVars,"",safe_syntax)
	p=otherVars["p"]
	Filter1=otherVars["Filter1"]
	Filter2=otherVars["Filter2"]
	Value=otherVars["Value_to_Set"]
	syntaxOk=otherVars["syntaxOk"]
	#print Filter1,Filter2,"val="Value,"type="Type
	if (Value == "") Value=" "
	if (Filter2=="")
	{
		Display_help("eset")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	for (i=1;i<=p;i++)
	{
		thisclass=p2s("MoType",proxyList[i])
		if (multi>0 && yangcli==0)
		{
			Me=p2s("Me",proxyList[i])
			thisclass=sprintf("%s%s%s",momVersion[Me],SUBSEP,thisclass)
		}
		last=split(sorted_attribute_list[thisclass],array,",")
		for (j=1;j<=last;j++)
		{
			if (Filter2 ~ /^!/ && tolower(array[j]) ~ gensub(/^!/,"",1,Filter2)) continue
			if (Filter2 !~ /^!/ && tolower(array[j]) !~ Filter2) continue
			if (attr_comments[thisclass,array[j]] !~ /restricted|readOnly|key/)
			{
				attrList[++nr]=proxyList[i] SUBSEP array[j]
			}
		}
	}
	if (bldebset_confirmation == 1 && nr >0 && quiet != "quiet" && reading_script==0)
	{
		customPrint(sprintf("Set following %s attributes?\n\
============================================================================================================",nr))
		for (i=1;i<=nr;i++)
		{
			split(attrList[i],array,SUBSEP)
			customPrint(sprintf("%5s  %-60s  %s",array[1],p2s("MediumMo",array[1]),array[2]))
		}
		customPrint("============================================================================================================")
		if (undoMode==2) customPrint("Note: Running in Simulated Undo mode. No actual set will be performed !!!!")
		#customPrint(sprintf("Set %s attributes. Are you Sure [y/n] ? ",nr),"","","noLf")
		answer=Read_Answer(reading_script,"","","","","yesno",sprintf("Set %s attributes. Are you Sure [y/n] ? ",nr))
	}
	else answer="y"
	if (tolower(answer) !~ /^y+(es)?$/)
	{
		return add_to_moscomlog("","%@> Fail (Command aborted)")
	}
	#print Proxy,p2s("MediumMo",Proxy),Value,Type
	customPrint(sprintf("\n\
=================================================================================================================\n\
%5s %-60s %-19s %-19s %s\n\
=================================================================================================================",\
"Id","MO","Attribute","Value","Result"))
	if (what ~ "1")
	{
		if (comcli>0 || yangcli>0) runOneTransaction=1
		res=create_session()
		if (res != "") { customPrint(res) ; print_tail(0,0,"attributes") ; return }
	}
	for (i=1;i<=nr;i++)
	{
		if ((getline dummy < stopfile)==0 && fileOps("rm "stopfile)==0) { abortLoop=1 ; break }
		split(attrList[i],array,SUBSEP)
		Proxy=array[1]
		tcount++
		thisattribute=array[2]
		thisclass=p2s("MoType",Proxy)
		if (multi>0 && yangcli==0)
		{
			Me=p2s("Me",Proxy)
			thisclass=sprintf("%s%s%s",momVersion[Me],SUBSEP,thisclass)
		}
		Type=MoAttributesTypeJava[thisclass":"thisattribute]
		#print Proxy,p2s("MediumMo",Proxy),Value,Type
		if (gs==1 && tolower(Type) !~ /^at$/) choice=31         #not supported on array of struct
		else if (gsg==1 && tolower(Type) !~ /^(at|ar|t)$/) choice=32   #not supported on struct, array of struct, array of moref
		else if (what ~ "m") choice=30
		else if (what ~ "1") choice=34
		else choice=3
		if (what~"c")
		{
			Value=getMoAttribute(Proxy,thisattribute)
			if (Value ~ /^!!!/) continue
			if (Type ~ /^a/)
			{
				sub(/^[^ ]+ = +/,"",Value)
				if (Type ~ "r") gsub(/[\n] >>> [^ ]+ = /," ",Value)
				else if (Type ~ "t")
				{
					last=split(Value,array,/\n >>> Struct[^\n]+has[^\n]+members:/)
					Value=""
					for (j=2;j<=last;j++)
					{
						gsub(/[\n] >>> [0-9]+\./,",",array[j])
						gsub(/ = /,"=",array[j])
						sub(/^,/,"",array[j])
						Value=Value";"array[j]
					}
					sub(/^;/,"",Value)
				}
				else
				{
					gsub(" ",",",Value)
					sub(/,$/,"",Value)
				}
			}
			else if (Type ~ "t")
			{
				sub(/^Struct[^\n]+/,"",Value)
				gsub(/[\n] >>> [0-9]+\./,",",Value)
				gsub(/ = /,"=",Value)
				sub(/^,/,"",Value)
			}
		}
		ValueToSet=process_value(Value,Type,force,MoAttributesType[thisclass":"thisattribute],Me)
		if (mosdebug==1) print choice,Proxy,thisattribute,Value,ValueToSet,Type
		setResult=setAttribute(choice,Proxy,thisattribute,ValueToSet,Type,manyAttributes,manyTypes,manyValues,MoAttributesType[thisclass":"thisattribute],Me,blockedreason)
		customPrint(sprintf("%5s %-60s %-19s %s",Proxy,p2s("MediumMo",Proxy),thisattribute,setResult))
		if (undoMode >= 1)
		{
			print sprintf("%5s %-60s %-19s %s\n%5s %-60s %s","Id","MO",thisattribute,"Result",Proxy,p2s("MediumMo",Proxy),setResult) >> undoLogfile
			#close(undoLogfile) #Becomes very slow if the logfile is closed all the time
		}
		count++
		if (setResult !~ /!!!|>>> Fail./) count_ok++
		else if (what ~ "1")
		{
			if (comcli>0 || yangcli>0)
			{
				runOneTransaction=0
				if (start_config_mode()==0) stop_config_mode()
			}
			else create_session("rollback")
			print_tail(count,0,"attributes")
			return
		}
		if (makeScriptSummary==1)
		{
			summaryCommand[++summaryIndex]=setCommand
			summaryResult[summaryIndex]=gensub(/^.*>>>/,">>>",1,gensub(/^.*!!!/,"!!!",1,gensub(/^.*-No Change-/,"-No Change-",1,setResult)))
		}
	}
	if (what ~ "1")
	{
		if (comcli>0 || yangcli>0)
		{
			runOneTransaction=0
			start_config_mode()
			res=stop_config_mode()
		}
		else
		{
			res=create_session("commit")
		}
		if (res !~ /^(|0)$/) { customPrint(res) ; print_tail(count,0,"attributes") ; return }
	}
	print_tail(count,count_ok,"attributes")
}
function process_value(Value,Type,force,fulltype,Me,  last,j,array,tmp,sep,b,k,start,stop)
{
	if (comcli>0 || yangcli>0)
	{
		#the value processing in comcli/yangcli mode is done by the function com_process_value()
		if (tolower(Value) ~ /^(null| *)$/) Value=""
		return Value
	}
	if (tolower(Type) == "r")
	{
		if (tolower(Value) ~ /^(null| *)$/) Value=-1
		else Value=giveMoProxy(Value,"","ignorecase",Me)
	}
	else if (tolower(Type) == "ar")
	{
		if (tolower(Value) ~ /^(null| *)$/) Value=""
		#it should be possible to separate the LDNs with a semicolon or a space
		if (Value !~ /[^ ]+ +[^ ]+/ && Value ~ /;/) sep=";"
		else sep=" "
		last=split(Value,array,sep)
		Value=""
		for (j=1;j<=last;j++)
		{
			tmp=giveMoProxy(array[j],"","ignorecase",Me)
			Value=Value","(tmp==0?"-1":tmp)
		}
		Value=gensub(/^,/,"",1,Value)
	}
	else if (tolower(Type) == "t" && force != "force")
	{
		#format should be: set sid=1 sib11 sib11repperiod:i=2,sib11startpos:i=4
		#              or: set sid=1 sib11 sib11repperiod=2,sib11startpos=4
		#Sid                   sib11                 structRef:Sib11Data
		#Sib11Data             sib11RepPeriod,sib11StartPos
		#struct_type[sib11,sib11repperiod]=long
		#struct_type[sib11,sib11repmax]=long
		structreference=gensub(/^.*[:\-]/,"","g",fulltype)
		Value=parse_struct(Value,structreference,Me)
	}
	else if (tolower(Type) == "at" && force != "force")
	{
		structreference=gensub(/^.*[:\-]/,"","g",fulltype)
		last=split(Value,array,";")
		Value=""
		for (j=1;j<=last;j++)
		{
			Value=Value";"parse_struct(array[j],structreference,Me)
		}
		Value=gensub(/^;/,"",1,Value)
	}
	else if (tolower(Type) == "ai" && Value ~ /[0-9]+-[0-9]+/) Value=expand_integer(Value)
	
	return Value
}
function make_rset_customtable(   i,array)
{
	split(rset_customlist,array,",")
	for (i in array) rset_customtable[tolower(array[i])]=1
}

function del(molength,what,deloption,confirm,partial,force,nolock,noundowarn,   \
answer,j,n,Filter1,proxyList,p,i,syntaxOk,otherVars,last,count_ok,motypes,result_list,found_up,tmpvalue,z,tclass,childrenBuffer,k,count,colorstart,colorend,resline,t,Proxy,\
addedChTable,tdn,rT,ldnList,tldn,xopt)
{
	#if (yangcli>0) return yangcli_error(1)
	count_ok=0
	make_rset_customtable()
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)")
	if (nolock~"1x")
	{
		if (comcli>0 || yangcli>0) xopt="1x"
		else customPrint("INFO: Option \"1x\" will be ignored as it is only supported on COM or YANG nodes.")
		sub(/1x/,"",nolock)
	}
	if (what~/^(g[psx]|z)$/)
	{
		#used by the ir && gr functions
		Filter1=$2
		if(what=="gp" && Filter1~/^IubLink=/)
		{
			$0="del "mo2plist(multilink(Filter1,"grp")) #all but relations/externalcells/externalnetworks
		}
		else if (Filter1!="" && fileOps("test -s "Filter1)==0)
		{
			if(what=="z") $0="del "mo2plist(multilink("","full",Filter1))
			else if(what=="gs") $0="del "mo2plist(multilink("","grs",Filter1))
			else if(what=="gx") $0="del "mo2plist(multilink("","grx",Filter1))
		}
		else return
		what=""
	}
	if (check_syntax_validity()==1)
	{
		#this check must be done before buildProxyList since that function changes the positional variables $0,$1,etc
		if (what=="rec") Display_help("rdel")
		else Display_help("del")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	buildProxyList(molength,proxyList,otherVars,force "deletion",safe_syntax,what,"",addedChTable,"makeLdn",ldnList)
	p=otherVars["p"]
	Filter1=otherVars["Filter1"]
	syntaxOk=otherVars["syntaxOk"]
	if (Filter1 == "" && syntaxOk!=1)
	{
		if (what=="rec") Display_help("rdel")
		else Display_help("del")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	if (del_confirmation == 1 && disabled_confirmation == 0 && reading_script==0)
	{
		customPrint((what=="rec" ? "Recursive " : "")"Delete following MOs ?\n===================================================================================")
		for (i=1;i<=p;i++)
		{
			if (what=="rec" && p2s("MoType",proxyList[i]) in class_syscreated && force!="force") continue
			customPrint(sprintf("%5s  %s",proxyList[i],p2s("Mo",proxyList[i])))
			count++
		}
		customPrint("===================================================================================")
		if (noundowarn=="")
		{
			if (undoMode < 1)       customPrint(colorstart"!! Warning: Undo Mode is currently inactive !!"colorend)
			else if (undoMode == 2) customPrint("Note: Running in Simulated Undo mode. No actual deletion will be performed !!!!")
		}
		if (confirm=="noconfirm") answer="y"
		else
		{
			#customPrint(sprintf("Delete "count" MOs. Are you Sure [y/n] ? "),"","","noLF")
			answer=Read_Answer(reading_script,"","","","","yesno",sprintf("Delete "count" MOs. Are you Sure [y/n] ? "))
		}
	}
	else answer="y"
	if (tolower(answer) !~ /^y+(es)?$/)
	{
		return add_to_moscomlog("","%@> Fail (Command aborted)","",1)  #return code used by the cvrm function
	}
	if (xopt~"1x") { inSet1x=1 ; runOneTransaction=1 ; inCrDel1x=1 }
	if (what=="rec")
	{
		for (i=1;i<=p;i++)
		{
			if (rdel_check(proxyList[i],ldnList[i])==1) break
			if (p2s("MoType",proxyList[i]) in class_syscreated) continue
			result_list=mo2plist(make_lk_list(proxyList[i],p2s("MoType",proxyList[i]),deloption,partial))
			if (rdel_check(proxyList[i],ldnList[i])==1) break
			if (result_list == -1)  #should never happen, all MO classes are now allowed
			{
				if (tolower(p2s("MoType",proxyList[i])) in rset_customtable) result_list=proxyList[i]
				else
				{
					customPrint("Command not supported on MO class "p2s("MoType",proxyList[i]))
					Display_help("rdel")
					return add_to_moscomlog("","%@> Fail (Syntax error)")
				}
			}
			customPrint("")
			if (result_list=="") continue
			#print "DEBUG:" result_list
			$0="del "result_list
			if (del_confirmation==1 && result_list~/^ *[0-9]+ *$/ && reading_script==0)
			{
				#when only one MO to delete skip the second confirmation
				del_confirmation=0
				del("short","","",(deloption=="remod" ? "noconfirm" : ""))
				del_confirmation=1
			}
			else del("short","","",(deloption=="remod" ? "noconfirm" : ""))
		}
		jvm_gc()
		return 0
	}
	#standard delete starts here
	if (undoMode>=1)
	{
		customPrint("\nGetting Attributes...\n===================================================================================")
		old_get_printoutformat=get_printoutformat
		get_printoutformat="noproxy"
		for (i=1;i<=p;i++)
		{
			Proxy=proxyList[i]
			#this is so we only handle MOs once in simulated delete mode
			if (undoMode == 2 && (Ldn[Proxy] in deletedProxies)) continue
			if ((getline dummy < stopfile)==0 && fileOps("rm "stopfile)==0) { abortLoop=1 ; break }
			$0="" ; $2=Proxy ; $3="all" ; get("short","","","","","","mget")
		}
		get_printoutformat=old_get_printoutformat
	}
	if (undoMode < 2)
	{
		#only remove CVs from rollback list if it is not simulated undo mode
		if (delPreventingCvs(proxyList,p)==1) return
	}
	for (i in proxyList) { if (p2s("MoType",proxyList[i]) == "UpgradePackage") {found_up=1 ; updata_LastNrOfUp=uplist_LastNrOfUp=0 } }
	customPrint(sprintf("\nDeleting %s...",(found_up==1?"(Be patient, may take up to 30 minutes for large UpgradePackage) ":"")))
	customPrint("===================================================================================")
	for (i=1;i<=p;i++)
	{
		Proxy=proxyList[i]
		tclass=p2s("MoType",Proxy)
		tdn=p2s("Mo",Proxy)
		if ((getline dummy < stopfile)==0 && fileOps("rm "stopfile)==0) { abortLoop=1 ; break }
		if ((tclass in class_syscreated && force!="force" && tclass !~ /\.UpgradePackage$/) || (addedChTable[Ldn[Proxy]]==1))
		{
			#these MOs have to be buffered until we reach their parent who will come just after
			childrenBuffer[Proxy]=Proxy
			continue
		}
		if (undoMode == 2)
		{
			#this is so we only handle MOs once in simulated delete mode
			if (Ldn[Proxy] in deletedProxies) continue
			deletedProxies[Ldn[Proxy]]=Proxy
                	#delresponse = ">>> Simulated MO deletion"
		}
		#else if (node ~ /^OFFLINE_/) delresponse=">>> Mo deleted"
		#else delresponse=delprox(Proxy,nolock)
		if (rdel_check(proxyList[i],ldnList[i])==1) break
		delresponse=delprox(Proxy,nolock)
		if (delresponse ~ />>> (Mo deleted|Simulated MO deletion)/ && ((tclass in has_syscreated_children)||((comcli>0 || yangcli>0) && tclass in sorted_recursive_childList)))
		{
			z=asort(childrenBuffer)
			if (mom_version ~ /^MSRBS_NODE_MODEL/ && customVar["$rats"]~/[LN]/)
			{
				#NR / LRAT MOs that must be deleted first:
				# - NRCellRelation must be deleted before NRFreqRelation
				# - PmUeMeasControl must be deleted before ReportConfigEUtraIntraFreqPm
				for (k=z;k>=1;k--)
				{
					if (p2s("MoType",childrenBuffer[k])!~/\.(NRCellRelation|PmUeMeasControl)$/) continue
					rT[k]=1
					customPrint(sprintf("%5s  %-80s %s", childrenBuffer[k], p2s("Mo",childrenBuffer[k]), delresponse),undoMode)
					removeProxy(childrenBuffer[k],undoMode)
					count_ok++
				}
			}
			for (k=z;k>=1;k--)
			{
				if (rT[k]==1) continue
				customPrint(sprintf("%5s  %-80s %s", childrenBuffer[k], p2s("Mo",childrenBuffer[k]), delresponse),undoMode)
				removeProxy(childrenBuffer[k],undoMode)
				count_ok++
			}
			delete childrenBuffer
		}
		customPrint(sprintf("%5s  %-80s %s", Proxy, tdn, delresponse),undoMode)
		if (p2s("MoType",Proxy)=="UpgradePackage" && delresponse ~ "org.omg.CORBA.TIMEOUT|org.omg.CORBA.COMM_FAILURE")
		{
			customPrint("*** Moshell timeout while waiting for delete result, checking progress...")
			while (1)
			{
				tmpvalue=getMoAttribute(Proxy,"upgradePackageId")
				if (tmpvalue ~ "!!!")
				{
					delresponse=">>> Mo deleted"
					customPrint(sprintf("%5s  %-80s %s", Proxy, p2s("Mo",Proxy), delresponse),undoMode)
					break
				}
				else
				{
					customPrint("UP Deletion ongoing, please wait. Rechecking in 10 seconds...")
					mysleep(10)
				}
			}
		}

		if (delresponse ~ />>> (Mo deleted|Simulated MO deletion)/)
		{
			if (comcli>0 && tclass ~ /\.UpgradePackage$/ && p2s("Mo",Proxy)!=tdn) Proxy=s2p(tdn)  #the Proxy id could be pointing to a different MO since there is a "lt all" after UP deletion in COM node
			removeProxy(Proxy,undoMode)
			count_ok++
		}
	}
	customPrint("===================================================================================")
	resline=sprintf("%s MOs attempted, %s MOs deleted",p,count_ok)
	customPrint("Total: "resline)
	assignCustomVar("$nr_of_mos",p)
	assignCustomVar("$nr_of_mos_ok",count_ok)
	add_to_moscomlog("",sprintf("%@> %s (%s%s)",(p>0&&p==count_ok?"OK":"Fail"),resline,(undoMode==2?" - Simulated":"")))
	jvm_gc()
	if (comcli>0 || yangcli>0) unload_orphan_mos()
	return 0
}
function rdel_check(proxyL,ldnL,   tldn,res)
{
	res=0
	tldn=p2s("LdnMo",proxyL)
	if (tldn!=ldnL)
	{
		customPrint("Error (rdel): proxy id "proxyL" ("ldnL") is now pointing to "(tldn!=""?tldn:"no LDN")". Aborting...","","force")
		res=1
	}
	if (cv_has_changed==1)
	{
		customPrint("Error (rdel): the node has restarted during deletion. Aborting...","","force")
		res=1
	}
	return res
}
function rset(molength,     \
proxyList,otherVars,Filter1,Filter2,Value,rsetfile,inMo,moDN,p,i,moclass,newmoDN,attribute,j,array,last,count,warnList,z,colorstart,colorend,old_use_crn,Proxy)
{
	if (multi>0 && yangcli==0) return multi_error()
	make_rset_customtable()
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)")
	if (show_colors==1) { colorstart="\033[1;31m" ; colorend="\033[0m" }
	buildProxyList(molength,proxyList,otherVars,"",safe_syntax)
	p=otherVars["p"]
	Filter1=otherVars["Filter1"]
	Filter2=otherVars["Filter2"]
	Value=otherVars["Value_to_Set"]
	syntaxOk=otherVars["syntaxOk"]
	if (Value == "") Value=" "
	attribute=moclass=""
	for (i=1;i<=p;i++)
	{
		last=split(sorted_attribute_list[p2s("MoType",proxyList[i])],array,",")
		for (j=1;j<=last;j++)
		{
			if (tolower(array[j]) == Filter2)
			{
				attribute=array[j]
				moclass=p2s("MoType",proxyList[i])
				if (attr_comments[moclass,attribute] !~ "restricted") warnList["!!!!WARNING: Attribute "moclass":"attribute" is not a restricted attribute.\nIt is recommended to use \"set\" instead of \"rset\"\n"]=1
				break
			}
		}
	}
	if (moclass=="") return add_to_moscomlog("","%@> Fail (Syntax error)")
	if (moclass=="UpgradePackage")
	{
		customPrint("Error: the rset command is not support for UpgradePackage MO.")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	for (z in warnList) customPrint(z)
	#check that the moclass is supported  --> no more check, all MOs are now allowed
	#if ((! (tolower(moclass) in rdel_supportedtable)) && (! (tolower(moclass) in rset_customtable)))
	#{
	#	customPrint("\nCommand not supported on MO class "moclass". Try adding this moclass into the uservariable rset_customlist.")
	#	Display_help("rset")
	#	return
	#}
	#check that there is no error in the LDNs in case the value to set is an LDN or an array of LDN
	#print moclass,attribute,Value,giveMoProxy(Value),MoAttributesTypeJava[moclass":"attribute]
	if (MoAttributesTypeJava[moclass":"attribute] == "r" && giveMoProxy(Value)== 0)
	{
		customPrint(sprintf("\nLDN not found: %s",Value))
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	if (MoAttributesTypeJava[moclass":"attribute] == "ar")
	{
		last=split(Value,array," ")
		for (j=1;j<=last;j++)
		{
			if (giveMoProxy(array[j]) == 0)
			{
				customPrint(sprintf("\nLDN not found: %s",array[j]))
				return add_to_moscomlog("","%@> Fail (Syntax error)")
			}
		}
	}
	if (del_confirmation == 1 && disabled_confirmation == 0 && reading_script==0)
	{
		customPrint(sprintf("Set restricted attribute %s on following MOs ?\n===================================================================================",Filter2))
		for (i=1;i<=p;i++)
		{
			if (p2s("MoType",proxyList[i]) == moclass)
			{
				customPrint(sprintf("%5s  %s",proxyList[i],p2s("Mo",proxyList[i])))
				count++
			}
		}
		customPrint("===================================================================================")
		#printf("Rset "Filter2" on "count" MOs. Are you Sure [y/n] ? ")
		answer=Read_Answer(reading_script,"","","","","yesno","Rset "Filter2" on "count" MOs. Are you Sure [y/n] ? ")
	}
	else answer="y"
	if (tolower(answer) !~ /^y+(es)?$/)
	{
		return add_to_moscomlog("","%@> Fail (Command aborted)")
	}
	for (i=1;i<=p;i++)
	{
		Proxy=proxyList[i]
		if (p2s("MoType",Proxy) != moclass) continue   #skip the MOs that are not of the same moclass as the one we want to set
		moDN=p2s("Mo",Proxy)
		shortMoDN=p2s("ShortMo",Proxy)
		date=strftime("%y%m%d-%H%M%S",systime())
		rsetfile=sprintf("%s/rset/rset_%s_%s_%s.mos",logdir,date,process_nodename(node),gensub(/[= /:]/,"","g",p2s("ShortMo",Proxy)))
		printf("") > rsetfile
		#old_use_crn=use_crn
		#use_crn=0
		$0="u+" ; undo("","open")
		$0="rdel "Proxy ; del("short","rec","remod","noconfirm","partial")
		$0="u-" ; undo("","close")
		#use_crn=old_use_crn
		inMo=changeMoId=0
		while ((getline < undoCommandFile)>0)
		{
			gsub("\r","") ; gsub("\x00","")
			if ($1 ~ /^crn?$/ && $2 == moDN)
			{
				#print "DEBUG:",sprintf("%sid",tolower(s2t(moDN))),Filter2
				#Check if we are changing the MO-id or just a normal attribute
				if (sprintf("%sid",tolower(cutmoc(s2t(moDN)))) == Filter2)
				{
					sub(/=[^,]+$/,"="Value,$2)
					new_shortMoDN=gensub(/^.*,/,"","g",$2)
					changeMoId=1
				}
				else inMo=1
			}
			else if ($1=="end") inMo=0
			else if (inMo==1)
			{
				if (tolower($NF) ~ sprintf("#%s$",Filter2))
				{
					sub($0,sprintf("%s #%s",Value,Filter2))
					inMo=0
				}
				else if (tolower($1)==Filter2)
				{
					$0=$1" "Value
					inMo=0
				}
				else if (tolower($3) == Filter2)
				{
					$0=sprintf("%s %s %s %s",$1,$2,$3,Value) #didnt work with sub()
					inMo=0
				}
			}
			else if (changeMoId==1 && $0 ~ shortMoDN)
			{
				#if ($2 ~ sprintf("%s(\\$|,)",moDN)) sub(moDN,gensub(/=[^,]+$/,"="Value,1,moDN),$2)
				for (i=1;i<=NF;i++)
				{
					if ($i ~ sprintf("(^|,)%s([,$]|$)",shortMoDN)) $i=gensub(shortMoDN,new_shortMoDN,"g",$i)
				}
				$0=$0
			}
			print $0 >> rsetfile
		}
		close(undoCommandFile)
		close(rsetfile)
		old_show_timestamp=show_timestamp; show_timestamp=0
		Read_script(rsetfile)
		show_timestamp=old_show_timestamp
		#check if the rset succeeded
		if (changeMoId==1) moDN=gensub(shortMoDN,new_shortMoDN,1,moDN)
		if (giveMoProxy(moDN,"","","","conditional") > 0) {}
		else
		{
			customPrint("\n\n"colorstart"ERROR: MO "moDN" not found, rset command failed. Running undo file..."colorend"\n")
			Read_script(undoCommandFile)
		}
	}
}
function fclean(f_only,  xmlFileList,file,motypes,rmdir,filter,i,ftimestamp,fclog,cp_command,fileList,nr_of_files,curr_file)
{
	if (multi) return multi_error()
	if (comcli>0) return comcli_error()
	for (i=2;i<=NF;i++)
	{
		if ($i=="-f")
		{
			filter=$(i+1)
			i++
		}
		else if (rmdir=="") rmdir=$i
		else if (rmdir!="")
		{
			#in case the user wrote more than 1 argument, eg: fclean /c /pmd   (e.g. a space inside the path)
			Display_help("fclean")
			return add_to_moscomlog("","%@> Fail (Syntax error)")
		}

	}
	if ((f_only ~ /[de]/ && rmdir=="") || (f_only ~ "f" && rmdir != ""))
	{
		#the user tried to run fclean[d|e] on its own or tried to run fclean[f|ff] on a directory
		#the correct syntax is: fclean[f|ff] or fclean[d|e] <directory>
		Display_help("fclean")
		return add_to_moscomlog("","%@> Fail (Syntax error)")
	}
	#if (nocorba==1) nocorba=0 #this command cannot work in light mode
	check_node_password()
	if (node_password == "") return add_to_moscomlog("","%@> Fail (Connection failure or wrong password)","",1)
	if (rmdir != "")
	{
		rmDir(rmdir,f_only,filter)
		return
	}
	if (Start_moMode()==1) return add_to_moscomlog("","%@> Fail (Connection failure)")
	#do an lt all in case some loadmodules/programs had been removed by the upgrade package deletion before running fclean
	$0="lt all" ; Load_Proxys("all")
	buildBoardGroup() #availableBoards(0)
	old_getSpeed=getSpeed
	getSpeed=1
	printf("\
uv print_lmid > $print_lmid\n\
uv print_lmid=0\n") > tempfcleancmd
	if (in_amos_mode()!=1 && os!="cygwin")
	{
		#polyhedra is not licensed for usage in amos and running it in cygwin will be too slow because currently we allow only one polyhedra session at a time in cygwin
		printf("\
ftget -f db.dat$ /d/configuration/cv $tempdir\n\
! %s -w $moshelldir/mobatch -dr -v nomo=1 $tempdir/cv \x27 select * from spppgmresource_ ; select * from sppspupgmresource_ ; select * from jvmfro_r1 ; select * from xpprogram ; select loadpath from cspgmresource \x27 $tempdir/logs_mobatch\n\
\n",perl) >> tempfcleancmd
	}
	if (f_only == "") printf("\
get loadmodule filepath\n\
get upgradepackage loadmodulelist\n\
get upgrade path$\n\
get program loadmodule\n\
get jvm admclasspath\n\
arm print\n\
ftree /c/up\n\
lh bp ftree /f\n\
lh mp ftree /d/loadmodules\n\
lh coremp ftree /d/tftp\n\
ftree /c/loadmodules_tftp\n\
ftree /c/loadmodules\n\
ftree /c/loadmodules_norepl\n\
ftree /c/java\n\
ftree /c/cmxb/loadmodules\n\
ftree /c/fpga_load_files\n\
ftree /c/dsp_load_files\n\
ftree /d/configuration/cv\n\
\n") > tempfcleancmd
	else printf("\
get loadmodule filepath\n\
get program loadmodule\n\
lh bp ftree /f\n\
\n") > tempfcleancmd
	printf("\
uv print_lmid=$print_lmid\n") > tempfcleancmd
	close(tempfcleancmd)
	mo_log(tempfcleanlog,"open","mute","overwrite")
	muteFactor=800
	old_iRu=iRu ; iRu=1
	Read_script(tempfcleancmd)
	iRu=old_iRu
	close(tempfcleanlog)
	nr_of_files=fileOps(sprintf("ls %s/logs_mobatch",tempdir),fileList)
	for (i=1;i<=nr_of_files;i++)
	{
		if (fileList[i] !~ /\.log$/) continue
		curr_file=sprintf("%s/logs_mobatch/%s",tempdir,fileList[i])
		while ((getline < curr_file)>0)
		{
			if (/\/c\/(java|loadmodules(_norepl)?)\/|(\|.*\|.*\|.*\|)/) print gensub("\r","",1,$0) >> tempfcleanlog
		}
		close(curr_file)
	}
	close(tempfcleanlog)
	getSpeed=old_getSpeed
	while ((getline < tempfcleanlog)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		#UpgradePackage=InitialUP     upgradeControlFilePath  /c/up/initUP/initUP.xml
		#-rw-rw-rw-  87041     19 Jul 2004 11:53:55  /c/up/MGw_R2_CNP_R2.0.7.0_R1A01_backup/MGw_R2_CNP_R2.0.7.0_R1A01.xml
		#-r--r--r--  47541      2 Jan 1970 02:16:32  /d/configuration/cv/M_MGw_R3_Inc7_CM29_08072004_epakjj/ARMAMENT
		if (tolower($2) ~ "upgradecontrolfilepath") xmlFileList[$3]=$3
		else if ($1 ~ /^-r/ && tolower($NF) ~ /^\/c\/up\/.*\.xml$/) xmlFileList[$NF]=$NF
		else if ($1 ~ /^-r/ && $NF ~ /ARMAMENT$/) armamentFileList[$NF]=$NF
	}
	close(tempfcleanlog)
	customPrint("")
	for (file in xmlFileList)
	{
		if (ftpclient(node_address,node_password,sprintf("Get %s %s.tmp",file,tempfcleanlog))==0)
		{
			while ((getline < sprintf("%s.tmp",tempfcleanlog))>0) print $0 >> tempfcleanlog
			close(sprintf("%s.tmp",tempfcleanlog))
		}
	}
	for (file in armamentFileList)
	{
		if (ftpclient(node_address,node_password,sprintf("Get %s %s.tmp",file,tempfcleanlog))==0)
		{
			while ((getline < sprintf("%s.tmp",tempfcleanlog))>0) print $0 >> tempfcleanlog
			close(sprintf("%s.tmp",tempfcleanlog))
		}
	}
	fileOps(sprintf("rm %s.tmp",tempfcleanlog))
	mo_log(tempfcleanlog,"close")
	ftimestamp=strftime("%y%m%d-%H%M%S",systime())
	fclog=sprintf("%s/fclean_%s_%s.log",fcleandir,process_nodename(node),ftimestamp)
	cp_command=sprintf("cp "tempfcleanlog" "fclog)
	customPrint(cp_command)
	if (system(cp_command)==0) { customPrint("gzip "fclog) ; system("gzip "fclog) }
	parseFclean(tempfcleanlog,f_only,ftimestamp)
}
function delPreventingCvs(proxyList,p,  i,proxy,delcvs,array,last,j,cvList,l,k,answer,delCvFilter,rbList,rbListOk)
{
	if (comcli>0 || yangcli>0) return 0
	delete rbList
	rbListOk=0
	last=split(getMoAttribute("ManagedElement=1,SwManagement=1,ConfigurationVersion=1","rollbackList"),array," ")
	if (array[1] ~ /^s\[[0-9]+\]$/ && array[2]=="=") rbListOk=1
	for (i=3;i<=last;i++) rbList[array[i]]=1
	for (i=1;i<=p;i++)
	{
		proxy=proxyList[i]
		if (p2s("MoType",proxy) == "UpgradePackage")
		{
			delcvs=getMoAttribute(proxy, "deletepreventingcvs")
			last=split(delcvs,array," ")
			for (j=3;j<=last;j++)
			{
				if (rbListOk==1 && rbList[array[j]]!=1) continue #if the CV is found in deletePreventingCVs but not in the rollbackList then we ignore it.
				cvList[++l]=array[j]
			}
		}
	}
	if (l>0)
	{
		customPrint("\nFollowing CVs need to be removed from the rollback list before it is possible to delete related UP's:")
		customPrint("===================================================================================")
		for (k=1;k<=l;k++) customPrint(cvList[k])
		customPrint("===================================================================================")
		for (k=1;k<=l;k++) delCvFilter=sprintf("%s|^%s$",delCvFilter,cvList[k])
		sub(/^\|/,"",delCvFilter)
		$0=""; $2=delCvFilter
		if (cvrm("rbrm")==1) return 1
	}
	return 0
}

function delprox(proxy,nolock,  array,last,i,mo_to_lock,attr_to_set,ranap_list,nr_ranap,j,ranap_proxy,tmp_vmgw,motypes,value,ok,inres,tmpresult,oldAdmState,run_with_netconf,t_dn,moclass,res,currMe,tcom,result)
{
	if (comcli>0)
	{
		if (nolock!="b" && p2s("MoType",proxy)~ lockBeforeDeleteMOsCOM)
		{
			#these MO classes have to be locked before being able to be deleted. If delete failed, they will be unlocked further down (if they were already unlocked)
			oldAdmState=getMoAttribute(proxy,"administrativeState")
			if (oldAdmState==1) setAttribute(3,proxy,"administrativeState",0,"i")
		}
		else if (p2s("MoType",proxy)~/\.PmJob$/) setAttribute(3,proxy,"requestedJobState",2,"i")
	}
	else if (yangcli==0)
	{
		if (p2s("MoType",proxy)=="Aal2PathDistributionUnit")
		{
			#if deleting an aal2pathdistributionunit, the aal2pathes used by it must be locked before
			$0="mr tmp_group_aal2pathdist" ; buildMoGroup("remove","short","silent")
			$0="ma tmp_group_aal2pathdist "proxy" aal2PathVccTpList" ; buildMoGroup("add","short","silent")
			last=split(moGroup["tmp_group_aal2pathdist"],array,SUBSEP)
			for (i=1;i<=last;i++)
			{
				if (getMoAttribute(s2p(array[i]),"administrativeState")~ /^1/) mo_to_lock[s2p(array[i])]=1
			}
			for (i in mo_to_lock) setAttribute(3,i,"administrativeState",0,"i")
		}
		else if (p2s("MoType",proxy)=="PacketDataRouter")
		{
			#if deleting the packetdatarouter, it has to be taken out of the Ranap/IuLink:packetDataRouterRef attribute before
			#find out all the Ranap/IuLink MOs using this packetdatarouter
			$0="mr tmp_group_ranap" ; buildMoGroup("remove","short","silent")
			$0="ma tmp_group_ranap "proxy" reservedby" ; buildMoGroup("add","short","silent")
			nr_ranap=split(moGroup["tmp_group_ranap"],ranap_list,SUBSEP)
			for (j=1;j<=nr_ranap;j++)
			{
				ranap_proxy=s2p(ranap_list[j])
				$0="mr tmp_group_packetdatarouter" ; buildMoGroup("remove","short","silent")
				$0="ma tmp_group_packetdatarouter "ranap_proxy" packetDataRouterRef" ; buildMoGroup("add","short","silent")
				last=split(moGroup["tmp_group_packetdatarouter"],array,SUBSEP)
				for (i=1;i<=last;i++)
				{
					if (array[i] != p2s("Mo",proxy)) attr_to_set=sprintf("%s %s",attr_to_set,array[i])
				}
				$0="set "ranap_proxy" packetDataRouterRef "attr_to_set ; set("short","","","quiet")
				$0="mr tmp_group_packetdatarouter" ; buildMoGroup("remove","short","silent")
			}
			$0="mr tmp_group_ranap" ; buildMoGroup("remove","short","silent")
		}
		else if (nolock!="b" && p2s("MoType",proxy)~ lockBeforeDeleteMOs)
		{
			#these MO classes have to be locked before being able to be deleted. If delete failed, they will be unlocked further down (if they were already unlocked)
			oldAdmState=getMoAttribute(proxy,"administrativeState")
			if (oldAdmState==1) setAttribute(3,proxy,"administrativeState",0,"i")
			if (p2s("MoType",proxy)=="IpSyncRef")
			{
				if (getMoAttribute(proxy,"reservedBy") ~ /Synchronization=/)
				{
					delete motypes ; motypes["synchronization"]=1 ; ConditionalLoad(motypes)
					empty_file(temp_cvrm_file)
					#print "confb+" >> temp_cvrm_file
					print "acc Synchronization=1 removeSyncRefResource" >> temp_cvrm_file
					print p2s("MediumMo",proxy) >> temp_cvrm_file
					#print "confb-" >> temp_cvrm_file
					close(temp_cvrm_file)
					old_show_timestamp=show_timestamp ; show_timestamp=0
					Read_script(temp_cvrm_file)
					show_timestamp=old_show_timestamp
				}
			}
		}
		else if (p2s("MoType",proxy)=="TdmTermGrp")
		{
			tmp_vmgw=getMoAttribute(proxy,"reservedBy")
			if (tmp_vmgw ~ /Vmgw=/)
			{
				tmp_vmgw=giveMoProxy(tmp_vmgw)
				if (tmp_vmgw > 0)
				{
					empty_file(temp_cvrm_file)
					#print "confb+" >> temp_cvrm_file
					print "bl "proxy >> temp_cvrm_file
					print "acc "tmp_vmgw" removeTdmTermGrpMos" >> temp_cvrm_file
					print p2s("MediumMo",proxy) >> temp_cvrm_file
					#print "confb-" >> temp_cvrm_file
					close(temp_cvrm_file)
					old_show_timestamp=show_timestamp ; show_timestamp=0
					Read_script(temp_cvrm_file)
					show_timestamp=old_show_timestamp
				}
			}
		}
	}
	delete array
	if (undoMode == 2) array[2]= ">>> Simulated MO deletion"
	else if (use_morestrict==1 && morestrict_list !~ sprintf("(^|,)%s($|,)",p2s("MoType",proxy))) array[2]="!!!! Not allowed to delete "p2s("MoType",proxy)" MOs."
	else if (use_nodelete==1 && nodelete_list ~ sprintf("(^|,)%s($|,)",p2s("MoType",proxy))) array[2]="!!!! Not allowed to delete "p2s("MoType",proxy)" MOs."
	else if (node ~ /^OFFLINE_/) array[2]=">>> Mo deleted"
	else if (comcli>0 && p2s("MoType",proxy)~/\.UpgradePackage$/) value=del_com_up(p2s("LdnMo",proxy))
	else if (comcli>0)
	{
		if (comcli>0 && comcli_netconf_del==1 && runOneTransaction!=1)
		{
			make_moc_key_attributes()
			if (netconf_function("","start")=="NetconfOK") run_with_netconf=1
		}
		if (run_with_netconf==1) value=sendNetconfCommand("delete",make_netconf_string("delete",proxy))
		else
		{
			if (start_config_mode()==1) return
			ok=0 ; inres=0
			print "no "origLdn[proxy] |& SshClient
			while ((SshClient |& getline)>0)
			{
				gsub("\r","") ; gsub("\x00","")
				if (mosdebug==1) print $0
				if ($1=="EndOfPrint") { ok=1 ; cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break }
				if (/Timeout, server ([^ ]+) not responding./) { customPrint($0) ; break }
				if ($0 ~ /^>no ManagedElement=/ && inres==0) { inres=1 ; continue }
				if (inres==1) value=value" "$0
			}
			sub(/^ /,"",value)
			if (mosdebug==1) print "DEBUG: value="value,"cliDN="cliDN,"newdn="newdn
			tmpresult=stop_config_mode()
			if (tmpresult==0 && value=="") value=">>> Mo deleted"
			else value=sprintf("!!!! %s%s",(value!=""?value" ":""),(tmpresult!=0?tmpresult:""))
		}
	}
	else if (yangcli>0) 
	{
		t_dn=p2s("origLdnMo",proxy) 
		moclass=p2s("MoType",proxy)
		res=gotohost(yip(t_dn))
		if (res!=0) return sprintf("!!!! %s",res) #{ customPrint(res) ; continue }
		if (start_config_mode()==1) return sprintf("!!!! Unable to start config mode.")
		currMe=gensub(/,.*$/,"",1,t_dn)
		sub(/^Me=[^,]+,/,"",t_dn)
		tcom="no "t_dn
		result=""
		print  tcom |& SshClient
		while ((SshClient |& getline)>0)
		{
			gsub("\r","") ; gsub("\x00","")
			if (mosdebug==1) print $0
			if ($1=="EndOfPrint") { cli_mode(gensub(/^EndOfPrint +/,"",1,$0)) ; break }
			if ($1~/^>no$/) continue
			result=result" "$0
		}
		sub(/^ /,"",result)
		#if (result=="") result=sprintf(">>> Mo deleted")
		#else result=sprintf("!!!! %s",result)
		tmpresult=stop_config_mode()
		if (tmpresult==0 && result=="") result=sprintf(">>> Mo deleted")
		else result=sprintf("!!!! %s%s",(result!=""?result" ":""),(tmpresult!=0?tmpresult:""))
	}		
	else
	{
		print "4"       |& TestClient
		print proxy     |& TestClient
		while ((TestClient |& getline)>0)
		{
			gsub("\r","") ; if (corba_debug >= 1) customPrint($0)
			if ($1 == "Enter_choice_or_type_8_for_help") break
			else if (/MO Proxy ID:/) split($0,array,"ID:")
		}
	}
	if (comcli>0)
	{
		if (nolock!="b" && p2s("MoType",proxy)~ lockBeforeDeleteMOsCOM)
		{
			#if the deletion failed we must unlock the MO
			if (value ~ /!!!/ && oldAdmState==1) setAttribute(3,proxy,"administrativeState",1,"i")
		}
	}
	else if (yangcli==0)
	{
		if (p2s("MoType",proxy)=="Aal2PathDistributionUnit")
		{
			for (i in mo_to_lock) setAttribute(3,i,"administrativeState",1,"i")
			$0="mr tmp_group_aal2pathdist" ; buildMoGroup("remove","short","silent")
		}
		if (nolock != "b" && p2s("MoType",proxy)~ lockBeforeDeleteMOs)
		{
			#if the deletion failed we must unlock the MO
			if (array[2] ~ /!!!/ && oldAdmState==1) setAttribute(3,proxy,"administrativeState",1,"i")
		}
	}
	if (moscommandlog==1 && multi==1 && nrOfNodes>1) add_multi_command(proxy," del "p2s("Mo",proxy)" "array[2])
	if (undoMode == 2) return array[2]
	else if (node ~ /^OFFLINE_/) return array[2]
	else if (comcli>0) return value
	else if (yangcli>0) return result
	else return array[2]
}
function del_com_up(theup,   a,i,pn,pr,res,ares)
{
	res="!!!! "
	upprod=getMoAttribute(theup,"administrativeData")
	split(upprod,a,"\n")
	for (i in a)
	{
		if (a[i] ~ /productNumber = /) pn=gensub(/^.* | *$/,"","g",a[i])
		else if (a[i] ~ /productRevision = /) pr=gensub(/^.* | *$/,"","g",a[i])
	}
	if (pn=="" || pr=="") return res "Could not read the UP administrativeData"
	$0="cvrmu "pn"_"pr
	if (cvrm("","u")!=0) return res "Command aborted"
	customPrint("\naccn swm=1 removeUpgradePackage "gensub(/^.*SystemFunctions=1,/,"SystemFunctions=1,",1,theup))
	unassignCustomVar("$polp_result")
	unassignCustomVar("$polp_info")
	$0="accn swm=1 removeUpgradePackage "gensub(/^.*SystemFunctions=1,/,"SystemFunctions=1,",1,theup)
	no_reload_after_action=1
	ares=act("call","short","","n")
	no_reload_after_action=0
	if (customVar["$polp_result"]~"SUCCESS") return ">>> Mo deleted"
	else if (ares!=0) return res "Command aborted"
	return res customVar["$polp_result"]" "customVar["$polp_info"]
}
