#!/usr/bin/perl -w

#
#  v0.01 erached & ecarnsa:	 plot the pmPrbUtilDl counter under the "pmr" command... need a proper CONFIG file.
#  v0.02 ecarnsa: 	Changed the size of the circles: no more logaritmic function but sqrt function. used the transparency
#
#
#
# (this script require to install "gnuplot" under cygwin)
#


use strict;
use FileHandle;




my (@Object_array, @unique_object, @name_file, @title_plot);
my (@data, @temp, @ytics);
my %Kpi;
my $var;
my $xtics;
my $index = 0;
my @time;
my ($i,$k,$j,$title,$usage,$circle_factor);
my ($date, $time, $Object, $value, $list, $time_object);
my $offset=0;
my $counter_index;
my ($license,$string);
my $flag="";
my $folder=".";
my %colour = (
1 => '#0000FF',
2 => '#0000FF',
3 => '#0000FF',
4 => '#0000FF',
5 => '#0000FF',
6 => '#0000FF',
7 => '#0000FF',
8 => '#0000FF',
9 => '#0000FF',
10 => '#0000FF',
11 => '#FF0000',
);

my %colour1 = (
1 => '#AFAFFF',
2 => '#AFAFFF',
3 => '#AFAFFF',
4 => '#AFAFFF',
5 => '#AFAFFF',
6 => '#AFAFFF',
7 => '#AFAFFF',
8 => '#AFAFFF',
9 => '#AFAFFF',
10 => '#AFAFFF',
11 => '#FFAFAF',
);

$usage="\n\n\n\n Usage: $0 Counter_name \n\n\n";
@ARGV == 1 or @ARGV == 3 or die $usage;
if ($ARGV[0] eq "h" ){print $usage;exit;}
if (defined $ARGV[0] ){ $title = $ARGV[0]; }
if (defined $ARGV[1]) {
	if ($ARGV[1] eq "-out") { $folder = $ARGV[2]; } else { die(" argument not correct"); }
	}



while (<STDIN>) {
	$date = "";
	if (/^(\d\d\d\d-\d\d-\d\d) (\d\d:\d\d) (\S+) (.*)/) { $date=$1; $offset=1;} #set an offset of one in case there is also the date
	if (/(\d\d:\d\d) (\S+) (.*)/) { $time = $1; $Object= $2; $value=$3; print $date." ".$time." ".$Object." ".$value."\n";
		$time_object = $date." ".$time." ".$Object;
	$Kpi{$time_object} = $value;
	$Object_array[$index] = $Object; 
	$index ++;
	}
}

###  Find the unique elements of $Object_array to define the number of file to create -> $list

my %temp;
@unique_object = grep { ! $temp{$_}++ } @Object_array;
$list = @unique_object;

for ($i=0; $i<$list; $i++) {
	$name_file[$i]=$unique_object[$i];
	$title_plot[$i]=$unique_object[$i];
	$name_file[$i]=~s/,/_/g;
	$title_plot[$i]=~s/_/_-/g;
}




for ($j=0; $j<$list; $j++) {

$counter_index = 0;

# create a "temp" file in the right format to be plotted.

open OUTPUTFILE, ">".$folder."/PRB_temp.txt";

foreach $var (sort keys %Kpi) {
	if ($var =~ $unique_object[$j]) {

	$counter_index ++;
	if ($var=~ /(\d\d:\d\d) \S+/) {$time[$counter_index]=$1;}
	@data = split(',',$Kpi{$var});
	if (scalar(@data) > 0) {
		for ($i=1; $i<scalar(@data)+1; $i++) {print OUTPUTFILE ($counter_index." ".($i)." ".$data[$i-1]." ");
			if ($counter_index==1) {$license=$data[0];}
#			if ($license!=$data[0]) {$flag="Configured license limit changed during the plotted period";}   #in case something change in the element[0]
		}
	}
	print OUTPUTFILE "\n";
	}
}


# define the x axis

$xtics = 'set xtics (';
for ($k=1; $k<scalar(@time); $k=$k+4) {
if ($k==1) { $xtics = $xtics.'"'.$time[$k].'"'.$k;}
else { $xtics = $xtics.',"'.$time[$k].'"'.$k;}
}
$xtics = $xtics.") rotate by -90";
close OUTPUTFILE;


open (GP, "|gnuplot ") or die "no gnuplot";
GP->autoflush(1);
print GP "set term pngcairo size 1200,480 enhanced font 'Verdana,10'\n";
print GP "set output '",$folder,"/",$name_file[$j],"_",$title,".png'\n";
print GP "reset\n";
print GP "set lmargin 15\n";
print GP "set rmargin 15\n";
print GP "set title '",$title,"' font 'Verdana,14'\n";
print GP "set xlabel 'Time'\n";
print GP "set ytics nomirror\n";
print GP "set xtics nomirror\n";
print GP "set grid xtics\n";
print GP "set ytics ('0<=x<10' 1, '10<=x<20' 2, '20<=x<30' 3, '30<=x<40' 4, '40<=x<50' 5, '50<=x<60' 6, '60<=x<70' 7, '70<=x<80' 8, '80<=x<90' 9, '90<=x' 10)\n";
print GP  $xtics,"\n";
print GP "set yrange [0:",(scalar(@data)+1),"]\n";
# in case of "circles" in the plot, replaces scalar(@time) with number 96, to avoid that the circle become too big
#print GP "set xrange [-1:",(scalar(@time)+1),"]\n";
print GP "set xrange [-1:",(96+1),"]\n"; 
print GP "set multiplot\n";
print GP "set key out\n";


$string = "plot ";
for ($i=1; $i<scalar(@data)+1; $i++) {$string= $string." '".$folder."/PRB_temp.txt' u ".($i*3-2).":".($i*3-1).":(((\$".($i*3)."+0.001)**0.5)/9) w circles lc rgbcolor '".$colour{($i+1)}."' fs transparent solid 0.15 noborder notitle, '".$folder."/PRB_temp.txt' u ".($i*3-2).":".($i*3-1).":(((\$".($i*3)."+0.001)**0.5)/2.9) w p pt 6 ps var lc rgbcolor '".$colour1{($i+1)}."' notitle,";}
## log(\$".($i*3)."+1)/1.5   with circles lc rgb "blue" fs transparent solid 0.15 noborder
##(((\$3+0.1)**0.5)/1.5) w p pt 6 ps var lc rgbcolor

print GP substr($string,0,length($string)-2),"\n";

print GP "unset border\n";
print GP "unset xtics\n";
print GP "unset ytics\n";
print GP "unset title\n";
print GP "unset xlabel\n";
print GP "set ylabel 'PRB [%]'\n";
print GP "unset key\n";
print GP "unset grid\n";
print GP "set lmargin 4\n";
print GP "unset rmargin\n";
print GP "set xrange [1:10]\n";
print GP "set yrange [1:10]\n";
print GP "set label '",$flag,"' at 1,9.7 textcolor rgbcolor '#FF0000'\n";
#print GP "set label 'License Limit: ",$license,"' at 1,10\n";
print GP "set label 'Legend' at 9.52,9.5\n";
print GP "set label '900' at 9.86,8.6\n";
print GP "set label '500' at 9.8,7.45\n";
print GP "set label '200' at 9.75,6.6\n";
print GP "set label '100' at 9.7,6\n";
print GP "set label '50' at 9.68,5.5\n";
print GP "set label '20' at 9.66,5\n";
print GP "set label '10' at 9.65,4.5\n";
print GP "set label '5' at 9.65,4\n";
print GP "set label '2' at 9.65,3.6\n";
print GP "set label '1' at 9.65,3.2\n";

print GP "set label '",$title_plot[$j],"' font 'Verdana,12' at 6.5,9.8\n";

## the scaling factor is different because the xrange and yrange are different... tuning value: (((\$3+0.1)**0.5)/1.5) w p pt 6 ps var lc rgbcolor

print GP "plot '-' u 1:2:(((\$3+0.001)**0.5)/124) w circles lc rgbcolor '#0000FF' fs transparent solid 0.15 noborder notitle, '-' u 1:2:(((\$3+0.001)**0.5)/2.9) w p pt 6 ps var lc rgbcolor '#AFAFFF' notitle\n";


print GP "9.6 8.6 900\n";
print GP "9.6 7.45 500\n";
print GP "9.6 6.6 200\n";
print GP "9.6 6 100\n";
print GP "9.6 5.5 50\n";
print GP "9.6 5 20\n";
print GP "9.6 4.5 10\n";
print GP "9.6 4  5\n";
print GP "9.6 3.6  2\n";
print GP "9.6 3.2  1\n";
print GP "e\n";
print GP "9.6 8.6 900\n";
print GP "9.6 7.45 500\n";
print GP "9.6 6.6 200\n";
print GP "9.6 6 100\n";
print GP "9.6 5.5 50\n";
print GP "9.6 5 20\n";
print GP "9.6 4.5 10\n";
print GP "9.6 4  5\n";
print GP "9.6 3.6  2\n";
print GP "9.6 3.2  1\n";
print GP "e\n";
print GP "unset multiplot\n";

close GP;

}