package Port;

use strict;
use warnings;

use Data::Dumper;
use Utils;

sub new {
	my $class = shift;
	my $hasLag = shift;
	my $hasLagSpeed = shift;
	my $input = shift;

	my @test = split("-", $input->[2]);
	$hasLag = (@test == 3) ? 1 : 0;

	my $hasRemote = $input->[2] ne "NOLINK";

	# Add something here, so we don't screw up things in the case of L2GP master port
	if ($hasLag && ((@$input == 17 && $hasLagSpeed) || (@$input == 16 && !$hasLagSpeed))) {
		# New style, with lag speed column present and link has a lag, but no remote == External L2GP LAG
		splice(@$input, 3, 0, "REPLACEME"); # remoteBridge
	} elsif (!$hasLag && !$hasLagSpeed && @$input == 15) {
		# Old style, before lag speed column was added
		splice(@$input, 2, 0, "REPLACEME");
	} elsif (!$hasLag && $hasLagSpeed && @$input == 15) {
		# New style, with lag speed column present and link doesn't have lag and no remote == External L2GP interface
		splice(@$input, 2, 0, "REPLACEME");
	}

	my $_board = shift(@$input);
	my $_portIdentifier = shift(@$input);
	my $_lagGroup = shift(@$input) if $hasLag;
	my $_remoteBridge;

	if( $hasRemote ) {
	    $_remoteBridge = shift(@$input);
	} else {
	    $_remoteBridge = "";
	}
	my $_lagSpeed = shift(@$input) if $hasLag && $hasLagSpeed;

	my $self = {
		_actualSpeed => shift(@$input),
		_configuredSpeed => shift(@$input),
		_autoNegotiation => shift(@$input),
		_externalPort => shift(@$input),
		__state => shift(@$input),
		_portPriority => shift(@$input),
		_portPathCost => shift(@$input),
		_rootPathCost => shift(@$input),
		__stp => shift(@$input),
		_edgeMode => shift(@$input),
	};

	shift(@$input); # PbitQMap
	shift(@$input); # UnIng

	$self->{_vlans} = shift(@$input);

	$self->{_board} = $_board;
	$self->{_remoteBridge} = $_remoteBridge;
	$self->{_portIdentifier} = $_portIdentifier;
	$self->{_lagGroup} = $_lagGroup;
	$self->{_lagSpeed} = $_lagSpeed;
	@{$self->{_members}} = ();

	undef $_remoteBridge;
	undef $_portIdentifier;
	undef $_lagGroup;
	undef $_lagSpeed;

	my @_bridge = split(/-/, $self->{_portIdentifier});
	$self->{_portNumber} = int(pop(@_bridge));
	my $_slot = int(pop(@_bridge));
	my $_subrack = pop(@_bridge);

	if ($_board eq "CCIB") {
		if ($_slot == 1) {
			$_slot = 3;
		} elsif ($_slot == 4) {
			$_slot = 6;
		}
	}

	$self->{_slot} = $_slot;

	if ($_subrack eq "EXT") {
		$self->{_subrack} = -1;
	} else {
		$self->{_subrack} = Utils->calculateSubrackNumber($_subrack);

		if ($self->{_subrack} < 0) {
			print STDERR "Unknown subrack: $_subrack\n";
		}
	}

	$self->{_bridge} = sprintf("%s-%02d", $_subrack, $_slot);

	if ($self->{_remoteBridge} eq "REPLACEME") {
		$self->{_remoteBridge} = $self->{_bridge};
	}
	undef $_slot;
	undef $_subrack;
	undef $_board;
	undef @_bridge;

	$self->{_autoNegotiation} = ($self->{_autoNegotiation} eq "true") ? 1 : 0;
	$self->{_externalPort} = ($self->{_externalPort} eq "true") ? 1 : 0;

	my @__state = split("", $self->{__state});
	$self->{_portState} = $__state[0];
	$self->{_trafficState} = $__state[1];
	$self->{_lagState} = (@__state == 3) ? $__state[2] : -1;
	delete $self->{__state};

	($self->{_stpRole}, $self->{_stpState}) = split("-", $self->{__stp});
	delete $self->{__stp};

	bless $self, $class;

	return $self;
}

sub addMember {
	my ($self, $member) = @_;
	push(@{$self->{_members}}, $member) if defined $member;
}

sub getMembers {
	my ($self) = @_;
	return @{$self->{_members}};
}

sub getBoard {
	my ($self) = @_;
	return $self->{_board};
}

sub getBridge {
	my ($self) = @_;
	return $self->{_bridge};
}

sub getSubrack {
	my ($self) = @_;
	return $self->{_subrack};
}

sub getSlot {
	my ($self) = @_;
	return $self->{_slot};
}

sub getPortIdentifier {
	my ($self) = @_;
	return $self->{_portIdentifier};
}

sub getPortNumber {
	my ($self) = @_;
	return $self->{_portNumber};
}

sub getLagGroup {
	my ($self) = @_;
	return $self->{_lagGroup};
}

sub getLagSpeed {
	my ($self) = @_;
	return $self->{_lagSpeed};
}

sub getRemoteBridge {
	my ($self) = @_;
	return $self->{_remoteBridge};
}

sub setRemoteBridge {
	my ($self, $remoteBridge) = @_;
	$self->{_remoteBridge} = $remoteBridge;
}

sub getActualSpeed {
	my ($self) = @_;
	return $self->{_actualSpeed};
}

sub getConfiguredSpeed {
	my ($self) = @_;
	return $self->{_configuredSpeed};
}

sub getAutoNegotiation {
	my ($self) = @_;
	return $self->{_autoNegotiation};
}

sub getExternalPort {
	my ($self) = @_;
	return $self->{_externalPort};
}

sub setExternalPort {
	my ($self, $externalPort) = @_;
	$self->{_externalPort} = $externalPort if defined($externalPort);
}

sub getPortState {
	my ($self) = @_;
	return $self->{_portState};
}

sub getTrafficState {
	my ($self) = @_;
	return $self->{_trafficState};
}

sub getLagState {
	my ($self) = @_;
	return $self->{_lagState};
}

sub getPortPriority {
	my ($self) = @_;
	return $self->{_portPriority};
}

sub getPortPathCost {
	my ($self) = @_;
	return $self->{_portPathCost};
}

sub getRootPathCost {
	my ($self) = @_;
	return $self->{_rootPathCost};
}

sub getStpRole {
	my ($self) = @_;
	return $self->_convertStpRole($self->{_stpRole});
}

sub getStpState {
	my ($self) = @_;
	return $self->_convertStpState($self->{_stpState});
}

sub getEdgeMode() {
	my ($self) = @_;
	return $self->{_edgeMode};
}

sub getVlans() {
	my ($self) = @_;
	return $self->{_vlans};
}

sub _convertStpRole {
	my ($self, $role) = @_;

        if ($role eq "ROOT") { return "R"; }
        elsif ($role eq "DESIGNATED") { return "D"; }
        elsif ($role eq "ALTERNATE") { return "A"; }
        elsif ($role eq "BACKUP") { return "B"; }
        else { return "U"; }
}

sub _convertStpState {
	my ($self, $state) = @_;

        if ($state eq "DISABLED") { return "DIS"; }
        elsif ($state eq "BLOCKING") { return "BLO"; }
        elsif ($state eq "LISTENING") { return "LIS"; }
        elsif ($state eq "DISCARDING") { return "DSC"; }
        elsif ($state eq "LEARNING") { return "LEA"; }
        elsif ($state eq "FORWARDING") { return "FWD"; }
        else { return "UNK"; }
}

1;
