#####################################################################################
#                                                                                   #
#  Ericsson AB 2010 - All Rights Reserved                                          #
#                                                                                   #
# The copyright to the computer program(s) herein is the property of Ericsson AB,   #
# Sweden. The programs may be used and/or copied only with the written permission   #
# from Ericsson AB or in accordance with the terms and conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                 #
#                                                                                   #
#####################################################################################
#Author: Magnus Steen
package time_calc;
use strict;
use Data::Dumper;
use POSIX qw(strftime);
use POSIX;
use Time::Local;

sub modify_time
{
    my (%input) = @_;
    my ( $format, $oldyear, $oldmonth, $oldday, $oldhour, $oldmin, $oldsec ) =
        $input{time} =~ /(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2}):(\d{2})/
        ? ( 0, $1, $2, $3, $4, $5, $6 )
        : $input{time} =~ /(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})(\d{2})/
        ? ( 1, $1, $2, $3, $4, $5, $6 )
        : $input{time} =~ /(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2})/
        ? ( 2, $1, $2, $3, $4, $5, 0 )
        : $input{time} =~ /(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})/
        ? ( 3, $1, $2, $3, $4, $5, 0 )
        : ( undef, undef, undef, undef, undef, undef, undef );
    if ( $input{newtime} )
    {
        (  $input{year}, $input{month}, $input{day},
           $input{hour}, $input{min},   $input{sec} )
            = $input{newtime} =~
            /(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2}):(\d{2})/
            ? ( $1, $2, $3, $4, $5, $6 )
            : $input{newtime} =~ /(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})(\d{2})/
            ? ( $1, $2, $3, $4, $5, $6 )
            : $input{newtime} =~ /(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2})/
            ? ( $1, $2, $3, $4, $5, 0 )
            : $input{newtime} =~ /(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})/
            ? ( $1, $2, $3, $4, $5, 0 )
            : ( undef, undef, undef, undef, undef, undef );
    }
    my @formats = ( "%04s-%02s-%02s %02s:%02s:%02s",
                    "%04s%02s%02s.%02s%02s%02s",
                    "%04s-%02s-%02s %02s:%02s",
                    "%04s%02s%02s.%02s%02s" );
    return undef if ( !defined $oldyear );

    my ( $year, $month, $day, $hour, $min, $sec, $diff ) =
        correct_time( $oldyear +
                          ( defined $input{year} ? $input{year} : 0 ) *
                          ( $input{diff}         ? -1           : 1 ),
                      $oldmonth +
                          ( defined $input{month} ? $input{month} : 0 ) *
                          ( $input{diff}          ? -1            : 1 ),
                      $oldday +
                          ( defined $input{day} ? $input{day} : 0 ) *
                          ( $input{diff}        ? -1          : 1 ),
                      $oldhour +
                          ( defined $input{hour} ? $input{hour} : 0 ) *
                          ( $input{diff}         ? -1           : 1 ),
                      $oldmin +
                          ( defined $input{min} ? $input{min} : 0 ) *
                          ( $input{diff}        ? -1          : 1 ),
                      $oldsec +
                          ( defined $input{sec} ? $input{sec} : 0 ) *
                          ( $input{diff}        ? -1          : 1 ),
                      $input{diff},
                      $input{rop} );
    return (
             sprintf( $formats[$format],
                      $year, $month, $day, $hour, $min, $sec
                    ),
             $diff )
        if $input{rop};
    return
        sprintf( $formats[$format], $year, $month, $day, $hour, $min, $sec );
}

sub correct_time
{
    my ( $year, $month, $day, $hour, $min, $sec, $diff, $rop ) = @_;
    ( $year++, $month++, $day++ ) if $diff;
    my @dim = ( 31, 31, 0, 31, 30, 31, 30, 31, 31, 30, 31, 30 );
    my $old_time;
    if ( defined $rop )
    {
        $old_time = $min, $sec = 0;
        $min = ( ( ( $min / 15 ) % 4 ) * 15 );
        $min += 15 if $rop < 0;
        $min += $rop * 15;
        $old_time = $min - $old_time;
    }
    while ( $sec > 59 )
    {
        $sec -= 60;
        $min++;
    }
    while ( $sec < 0 )
    {
        $sec += 60;
        $min--;
    }
    while ( $min > 59 )
    {
        $min -= 60;
        $hour++;
    }
    while ( $min < 0 )
    {
        $min += 60;
        $hour--;
    }
    while ( $hour > 23 )
    {
        $hour -= 24;
        $day++;
    }
    while ( $hour < 0 )
    {
        $hour += 24;
        $day--;
    }
    while (
            $day > (   $dim[ ( $month + 12000 ) % 12 ] == 0
                     ? is_leap_year($year)
                             ? 29
                             : 28
                     : $dim[ ( $month + 12000 ) % 12 ] ) )
    {
        $day -=
            $dim[$month] == 0 ? is_leap_year($year) ? 29 : 28 : $dim[$month];
        $month++;
    }
    while ( $day < 1 )
    {
        $day +=
              $dim[ ( $month + 11999 ) % 12 ] == 0
            ? is_leap_year($year)
                ? 29
                : 28
            : $dim[ ( $month + 11999 ) % 12 ];
        $month--;
    }
    while ( $month > 12 )
    {
        $month -= 12;
        $year++;
    }
    while ( $month < 1 )
    {
        $month += 12;
        $year--;
    }
    ( $year--, $month--, $day-- ) if $diff;
    return ( $year, $month, $day, $hour, $min, $sec, $old_time );
}

sub is_leap_year
{
    return ( $_[0] % 4 ) ? ( $_[0] % 100 ) ? ( $_[0] % 400 ) ? 0 : 1 : 0 : 1;
}
1;
