######################################################################################
#                                                                                    #
#  Ericsson AB 2001-2024    - All Rights Reserved                                   #
#                                                                                    #
# The copyright to the computer program(s) herein is the property   of Ericsson AB,  #
# Sweden. The programs may be used and/or copied only with the written permission    #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                  #
#                                                                                    #
######################################################################################

function find_jarxmldir(file,   found)
{
	if (file==moshell && in_amos_mode()!=1 && system("test -d "ENVIRON["HOME"])==0)
	{
		jarxmldir=ENVIRON["HOME"]"/jarxml"
		return
	}
	if (fileOps("test -f "file,"","noscandir")!=0) { customPrint("ERROR: file "file" not found.") ; return }
	while ((getline < file)>0)
	{
		if (found==1) continue
		if ($1 ~ /^jarxmldir(=|$)/)
		{
        		gsub("\r","") ; gsub("\x00","") ; gsub(/#.*$/,"") ; gsub(/"/,"") ; gsub(/[ \t]*$/,"")
        		if (/^[ \t]*[a-zA-Z_][ \t]*=/) gsub(/[ \t]/,"")
        		$0=replace_path_variables($0)
        		if (split($0,array,"=") < 2 || $1 ~ /^#/) continue
			jarxmldir=array[2]
			found=1
		}
	}
	close(file)
}
function ftreecommand(inputvariables,  thisDir,lnh,showlmid,filesOnly,line,array,norecursive,reverse,last,word,i,viasftp,ftpserver,dirsOnly,filePrefix,viaftps,tcurl,errList,o,kexalgopt,macsopt,ipqosopt,tmp,ftps_user,ftps_port)
{
	parse_inputvars(inputvariables)
	thisDir=inputoptions
	if (mosdebug==1) print "ftree: "thisDir
	lnh=commandfile
	if (cpplinux==1 && lnh ~ /!$/)
	{
		sub(/!$/,"",lnh)
		filePrefix=lnh"!"
	}
	split(currentDir,array,":")
	showlmid=array[1]
	filesOnly=array[2]
	norecursive=array[3]
	reverse=array[4]
	viasftp=array[5]
	dirsOnly=array[6]
	viaftps=array[7]
	tcurl=gensub(SUBSEP,":","g",array[8])
	delete ftreeTotal

	if (mosdebug==1) print "DEBUG: ftree "gensub(SUBSEP,",","g",thisDir)
	if (thisDir=="/c/pmd" && filesOnly != "")
	{
		dumplista()
		ftreeTotal["dir"]+=0 ; ftreeTotal["file"]+=0 ; ftreeTotal["size"]+=0
		customPrint(sprintf("\nTotal: %.1f MB (%s bytes), %s directories, %s files.",ftreeTotal["size"]/1048576,ftreeTotal["size"],ftreeTotal["dir"],ftreeTotal["file"]))
		return
	}
	if (viasftp==1 && viaftps==1)
	{
		ftpserver=node_address
		if (is_ip_addr(ftpserver)==2 && ftpserver!~/^\[.*\]$/) ftpserver="["ftpserver"]"
		find_pemfiles(pemfiles)
		tmp=""
		if (use_tls==21 || use_tls==31) tmp=sprintf(" --key %s%s",(use_tls==21?keypem:pemfiles["key"]),(keypass!=""?" --pass "keypass:""))		
		if (comcli>0) 
		{
			ftps_port=s_ftp_port
			ftps_user="USER"
		}
		else if (yangcli>0) 
		{
			ftps_port=s_yangftp_port
			ftps_user=ca_password
		}
		ftree_session=sprintf("%s --connect-timeout %s --max-time %s --insecure -s -S --ftp-method nocwd --ssl --cert %s --cacert %s%s ftp://%s@%s:%s",tcurl,ip_connection_timeout,ip_inactivity_timeout,pemfiles["client"],pemfiles["ca"],tmp,ftps_user,put_brackets(ftpserver),ftps_port)
		if (mosdebug==1) print "DEBUG: "ftree_session
	}
	else if (viasftp==1)
	{
		ftpserver=node_address
		if (comcli>0 && linux_shell==0) sftp_port=ftp_port
		else if (yangcli>0) sftp_port=yangftp_port
		else sftp_port=secure_port
		if (sftp_kexalg!="") kexalgopt="-o KexAlgorithms="sftp_kexalg" "
		if (sftp_macs!="")   macsopt="-o MACs="sftp_macs" "
		if (sftp_ipqos!="")  ipqosopt="-o IPQoS="sftp_ipqos" "
		ftree_session=sprintf("%s -S %s -o Port=%s -z '%s' -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o HostKeyAlgorithms=\"%s\" -o NumberOfPasswordPrompts=1 -o ConnectTimeout=%s -o ServerAliveInterval=%s -o ServerAliveCountMax=0 -o PreferredAuthentications=%s -o TCPKeepAlive=no %s%s%s-o User=%s %s 2>&1",sftp,ssh,sftp_port,tempsshzfile,sftp_keyalg,ip_connection_timeout,ip_connection_timeout,auth_method,kexalgopt,macsopt,ipqosopt,username,put_brackets(ftpserver,1))
		if (mosdebug==1) print "DEBUG: "ftree_session
		sftp_res=sftp_login(ftree_session)
		if (sftp_res>0)
		{
			if (sftp_res==1) customPrint("SFTP login failed.","","force")
			else customPrint(sprintf("Unable to connect to %s:%s.",ftpserver,sftp_port),"","force")
			close(ftree_session)
			ftpcleanup()
			return 1
		}
	}
	else
	{
		ftree_session=enter_telnet_login(node_address,node_password)
		if (ftree_session ~ /Unable to connect|Wrong Password/)
		{
			customPrint(ftree_session)
			return
		}
	}
	last=split(thisDir,word,SUBSEP)
	for (i=1;i<=last;i++)
	{
		thisDir=word[i]
		printDir(thisDir,"",lnh,showlmid,filesOnly,norecursive,reverse,viasftp,dirsOnly,filePrefix,viaftps,errList)
	}
	for (o in errList) customPrint(o,"","force")
	if (viaftps!=1)
	{
		print "exit" |& ftree_session
		while ((ftree_session |& getline line)>0) {}
		close(ftree_session)
	}
	ftreeTotal["dir"]+=0 ; ftreeTotal["file"]+=0 ; ftreeTotal["size"]+=0
	customPrint(sprintf("\nTotal: %.1f MB (%s bytes), %s directories, %s files.",ftreeTotal["size"]/1048576,ftreeTotal["size"],ftreeTotal["dir"],ftreeTotal["file"]))
}
function monx_function(inputvariables,    tb,tok,lastLine,tlast,ok,tcom,i,k)
{
	parse_inputvars(inputvariables)
	#tb=inputoptions
	tb=ARGV[1]
	if (tb=="")
	{
		customPrint("Syntax: monx.sh <linkhandler> [</path/to/logfile>] [<log-buffer-lines>]")
		exit 1
	}
	if (ARGV[2]=="debug") mosdebug=1
	if (comcli>0) comcli=1
	customPrint("[Trying to contact the Trace & Error Log via link handler '"tb"'...]")
	telnet_session=enter_telnet_login(node_address,node_password)
	if (telnet_session ~ /Unable to connect|Wrong Password/)
	{
		customPrint(telnet_session)
		return
	}
	if (ARGV[2]!="" && ARGV[2]!="debug") 
	{
		logging=1
		logfile=ARGV[2]
		if (fileOps("rm "logfile)!=0)
		{
			customPrint("ERROR: cannot write to file: "logfile)
			return
		}
		else customPrint("Logging to file: "logfile)
		if (ARGV[3]~/^[1-9][0-9]*$/) k=ARGV[3]+0
	}
	while (1)
	{
		tok=0
		if (comcli>0)
		{
			if (tb=="000100") tcom="/diagm/te log read"
			else tcom="/fruacc/lhsh "tb" te log read"
		}
		else tcom="lhsh -v "tb" te log read"
		if (mosdebug==1) print "Executing command: "tcom
		print tcom |& telnet_session
		while ((telnet_session |& getline)>0)
		{
			gsub("\r","") ; gsub("\x00","")
			if ($1=="EndOfPrint" || $0~/returned with status .*, errno /) break
			if (NF==0) continue
			if (comcli>0)
			{
				#END
				#WARNING: /fruacc/lhsh is deprecated and might not work. Registered COLIs might be missing and supported COLIs could fail to execute. please use LDN to adress and execute COLIs.
				#Example:
				#ManagedElement=1,Equipment=1,FieldReplaceableUnit=1 /fruacc/vii
				if ($1=="END" || $1=="WARNING:" || $1=="Example:" || $1=="ManagedElement=1,Equipment=1,FieldReplaceableUnit=1" || $1=="coli>") continue
			}
			if (mosdebug==1) print
			if ($1~/^\[[12][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]$/ && $2~/\]$/) tlast=$0
			if (lastLine!="" && $0==lastLine) { tok=1 ; continue}
			if (tok==1 && $1~/^\[[12][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]$/ && $2~/\]$/) tok=2
			if (tok==2) customPrint($0)
			if (logging==1 && k>0 && ++i==k) { close(logfile) ; i=0 }
		}
		lastLine=tlast
		if (mosdebug==1)
		{
			print "lastLine: "lastLine
			print "----------------------------------------------------------------------------------------------------"
		}
		if (lastLine!="" && ok==0)
		{
			ok=1
			customPrint("[Contact established with the Trace & Error Log via link handler '"tb"']","","force")
		}
	}
}
####################################################################################################################
# TELNODE RELATED FUNCTIONS (LH COMMAND AND OSE SHELL)
####################################################################################################################
function telnode_function(inputvariables,   nr_of_lines,nr_of_files,commandFileTable,i,j,k,localcommandFileTable,nseg,lineTable,array,z,qsign)
{
	#telnode function will always be called from a system call:
	#system("gawk -f funcs.awk -v inputvariables=xxx,yyy,zzz,... --source BEGIN{ telnode_function(inputvariables)}  | pipeCommand")
	#this is order to support the piping and also in case the telnode crashes, it won't crash the moshell session
	initialise_telnode()
	parse_inputvars(inputvariables)
	if (commandfile ~ "@@@@")
	{
		split(commandfile,array,"@@@@")
		commandfile=array[1]
		lhzlogfile=array[2]
	}
	#fast_lh,show_lnh,append,nr_of_cmds,currentDir ---> for telnode
	if (inputoptions ~ "f") fast_lh=1 ; else fast_lh=0
	if (inputoptions ~ "h") show_lnh=1 ; else show_lnh=0
	if (inputoptions ~ "a") append=1   ; else append=0
	if (inputoptions ~ "s") sqlbatch=1 ; else sqlbatch=0
	if (inputoptions ~ "9")  tmattach=1 ; else tmattach=0
	if (inputoptions ~ "v") lhsh_v=1 ; else lhsh_v=0
	if (inputoptions ~ "z") lhz=1 ; else lhz=0
	nr_of_cmds=1

	define_codes()
	if (NColi>0)
	{
		offline_telnode()
		return
	}

	if (lhz==1 && fileOps(sprintf("test -s %s",commandfile))!=0) exit 1
	if (logfile !="" && append==0)
	{
		printf("Logging to file %s\n",logfile) > logfile
		close(logfile)
	}
	if ((fast_lh==1 || sqlbatch==1) && fileOps(sprintf("test -s %s",commandfile))==0)
	{
		#fast_lh mode means that the command file is sent to the node via ftp and run from there using the shell command
		if (sqlbatch != 1)
		{
			qsign=""
			if (cpplinux==1) qsign="'"
			#this is to put some echo statements otherwise the commands are not echoed on the screen when run with shell -f
			fileOps("rm %s.tmp",commandfile)
			if (currentDir != "") printf("cd %s\n",currentDir) > sprintf("%s.tmp",commandfile)
			close(commandfile)
			while ((getline < commandfile)>0)
			{
				gsub("\r","") ; gsub("\x00","")
				if ($0 ~ / echo / && $0 ~ />/) printf("echo $ %s\n",gensub(">","^","g",$0)) >> sprintf("%s.tmp",commandfile)
				else
				{
					if (lhz==1)
					{
						#Currently disabled the line with @@@@, makes the execution slower, especially with secure_shell=0 (telnet)
						#But we use this line on CPP Linux where the line " returned with status 0, errno 0" comes on stdout instead of stderr
						if (cpplinux==1) printf("@@@@%s\n",gensub(/[ \t]/,"@","g",$0)) >> sprintf("%s.tmp",commandfile)
						printf("echo %s$ %s%s\n",qsign,gensub(/lhsh -v /,"lhsh ",1,$0),qsign) >> sprintf("%s.tmp",commandfile)
					}
					else printf("echo %s$ %s%s\n",qsign,$0,qsign) >> sprintf("%s.tmp",commandfile)
				}
				print $0 >> sprintf("%s.tmp",commandfile)
			}
			#with lh command, the EndOfPrint statement is in the command file because otherwise it can put characters in the printout
			if (lhz!=1) print "echo \"EndOfPrint\"" >> sprintf("%s.tmp",commandfile)
			close(commandfile) ; close(sprintf("%s.tmp",commandfile))
			fileOps(sprintf("mv %s.tmp %s",commandfile,commandfile))
		}
		localcommandfile=sprintf("%s/%s",nodetempdir,gensub(/^.*\//,"","g",commandfile))
		localnogzlogfile=sprintf("%s/%s",nodetempdir,gensub(/^.*\//,"","g",lhzlogfile))
		localgzlogfile=sprintf("/gzip%s",localnogzlogfile)
		if (cpplinux==1) localgzlogfile=localnogzlogfile
		if (sqlbatch == 1)
		{
			nr_of_files=splitFile(commandfile,500,splitFileTable)
			tempsqldir=sprintf("%s/sqlCmd%s",nodetempdir,gensub(/^.*lhCmd/,"","g",commandfile))
			telnet_session=enter_telnet_login(node_address,node_password)
			if (telnet_session ~ /Unable to connect|Wrong Password/)
			{
				customPrint(telnet_session)
				exit 1
			}
			print "rm -Rf "tempsqldir"\nexit" |& telnet_session
			while ((telnet_session |& getline)>0) {}
			close(telnet_session)
			delete ftpcommandlist
			ftpcommandlist[0]=sprintf("mkdir "tempsqldir)
			for (i=1;i<=nr_of_files;i++)
			{
				commandFileTable[i]=splitFileTable[i]
				localcommandFileTable[i]=sprintf("%s/%s.sql",tempsqldir,gensub(/^.*\//,"","g",commandFileTable[i]))
				ftpcommandlist[i]=sprintf("put %s %s",commandFileTable[i],localcommandFileTable[i])
			}
			customPrint("Transferring "nr_of_files" command files...","","force")
			if (ftpclient(node_address,node_password,"",ftpcommandlist)==0)
			{
				#printf("sqlc\ninclude \x27%s\x27;\nexit;\necho \"EndOfPrint\"\n",localcommandfile) |& telnet_session
				telnet_session=enter_telnet_login(node_address,node_password)
				if (telnet_session ~ /Unable to connect|Wrong Password/)
				{
					customPrint(telnet_session)
					exit 1
				}
				print coliMap("sqlc") |& telnet_session
				if (cpplinux==1) sleep(1)
				for (i=1;i<=nr_of_files+1;i++)
				{
					if (i<=nr_of_files) printf("%s \x27%s\x27;\necho \"EndOfPrint\";\n",coliMap("include"),localcommandFileTable[i]) |& telnet_session
					else print coliMap("exit;")"\necho \"EndOfPrint\"" |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						gsub("\r","") ; gsub("\x00","")
						if (/(^|[^"])EndOfPrint$/) break
						else if (/Error: unknown command: echo .?EndOfPrint.?;|LINE 1: echo .?EndOfPrint/) break
						else processLine(show_lnh,currentDir,"","sql_linux")
					}
				}
				for (i=1;i<=nr_of_files;i++) printf("rm -f %s\n",localcommandFileTable[i]) |& telnet_session
				printf("rmdir %s\n",tempsqldir) |& telnet_session
			}
			else exit 1
		}
		else if (ftpclient(node_address,node_password,sprintf("put %s %s",commandfile,localcommandfile))==0)
		{
			if (cpplinux==1 && lhz==1 && ip_inactivity_timeout<90) ip_inactivity_timeout=90
			telnet_session=enter_telnet_login(node_address,node_password)
			if (telnet_session ~ /Unable to connect|Wrong Password/)
			{
				customPrint(telnet_session)
				exit 1
			}
			else
			{
				if (lhz==1)
				{
					lhz_increment=0
					lhzCount=gensub(/^.*\/[^/]+_|\.gz$/,"","g",lhzlogfile)+0
					lhzName=gensub(/_[0-9]+\.gz$/,"",1,lhzlogfile)
					locallhzName=gensub(/_[0-9]+\.gz$/,"",1,localnogzlogfile)
					for (b=0;b<=lhzCount;b++)
					{
						#try removing old lhLog_X.gz in order to not fill up the disk
						print "rm -f "locallhzName"_"b".gz" |& telnet_session
					}
					print "echo \"EndOfPrint\"" |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						gsub("\r","");gsub("\x00",""); gsub(/^([$] )+/,"")
						if ($1=="EndOfPrint") break
						if (mosdebug==1) print $0
					}
					#check if the latest lhz logfile is still there even after deleting it
					#if yes then we increment the lhzCount, but not higher than 9
					print "ls -l "localnogzlogfile |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						gsub("\r","");gsub("\x00",""); gsub(/^([$] )+/,"")
						if ($1 ~ /^-r/) { lhz_increment=1 ; break }
						else if (tolower($0) ~ "no such file") break
					}
					if (lhz_increment==1)
					{
						if (lhzCount<2) lhzCount++  #max of 3 lhLog (_0 to _2) files, then go back to _0
						else lhzCount=0
						lhzlogfile=lhzName"_"lhzCount".gz"
						localnogzlogfile=sprintf("%s/%s",nodetempdir,gensub(/^.*\//,"","g",lhzlogfile))
						localgzlogfile=sprintf("/gzip%s",localnogzlogfile)
						if (cpplinux==1) localgzlogfile=localnogzlogfile
					}
				}
				#On ENB Gen1 there are some Linux boards like XMU03, RRU2212, etc, the lhz command does not work well with those boards as the echo EndOfPrint disappears
				printf("%s %s%s\n",((lhz==1 && mom_version~/^ERBS_NODE_MODEL_/)?"lhsh -v 000100 shell -f":coliMap("shell -f")),localcommandfile,(lhz==1?(cpplinux==1?" | zip ":"")" > "localgzlogfile:"")) |& telnet_session
				if (lhz==1 && mom_version!~/^ERBS_NODE_MODEL_/) print "echo \"EndOfPrint\"" |& telnet_session   #in regular lh, the EndOfPrint is in the command file already.
			}
			delete errorlist
			fatalError=""
			while ((telnet_session |& getline)>0)
			{
				gsub("\r","") ; gsub("\x00","")
				if (/EndOfPrint/) gsub(/^([$] )+/,"")
				if (/(^|[^"])EndOfPrint$/) break
				if (/commonjars\/connect[^ ]*: connection timed out|Timeout, server .* not responding|nc6[^ ]*: remote idle timed out/) { fatalError=$0 ; break }
				#if (/: (unknown command|illegal command) 'EndOfFileCommand'/) break
				#currently disabled show_lnh with lhz since @@@@ is not used
				else if (lhz==1)
				{
					#if ($0 !~ /echo \"EndOfPrint\"/) customPrint($0)
					if (mosdebug==1) print "Debug: "$0
					if ($0 ~ sprintf("Could not open file \x27%s\x27",localgzlogfile)||\
					    $0 ~ /commonjars\/connect[^ ]*: connection timed out|Timeout, server .* not responding|nc6[^ ]*: remote idle timed out/)
					{
						fatalError=$0 ; break
					}
					else if ($0 ~ sprintf("%s %s",coliMap("shell -f"),localcommandfile)) customPrint($0)
					else
					{
						#rcmd to OSE: 'vii' returned with status 0, errno 0
						#rcmd to OSE: shell returned with status 0, errno 0
						#rcmd: failed to connect to 002300
						#rcmd: unknown command 'hello'
					        #gpsh to GEP: 'te' terminated
						printf "."
						#/d/usr/lhCmd9361: line 10: @@@@lhsh@-v@000800@vii: command not found
						#rcmd to OSE: 'shell' returned with status 0, errno 0
						if (cpplinux==1 && lhz==1 && NF==7 && $2=="line" && $5=="command" && $6=="not" && $4 ~ /^@@@@lhsh@-v@.*/) {}
						else if (mom_version~/^ERBS_NODE_MODEL_/ && $0~/rcmd to OSE: 'shell' returned with status/) break
						else if ($0 !~ / returned with status .*, errno |EndOfPrint|gpsh to GEP:.* terminated/) errorlist[$0]=$0
					}
				}
				else processLine(show_lnh,currentDir)
			}
			if (lhz==1)
			{
				customPrint("")
				last=asort(errorlist)
				for (k=1;k<=last;k++) customPrint(errorlist[k])
			}
			if (fatalError!="")
			{
				customPrint(fatalError)
				usleep(1000000)
				cabres=""
				close(telnet_session)
				telnet_session=enter_telnet_login(node_address,node_password)
				if (telnet_session ~ /Unable to connect|Wrong Password/)
				{
					customPrint(telnet_session)
					exit 1
				}
			}
			printf("rm -f %s\n",localcommandfile) |& telnet_session
			#if (lhz==1) customPrint("")
			if (measuretimeStart>0 && lhz==1) customPrint(sprintf("Duration_%d: %d",++measuretimeCount,systime()-measuretimeStart))
		}
		else exit 1
	}
	else
	{
		telnet_session=enter_telnet_login(node_address,node_password,tmattach)
		#if (axenode=="SIU" && lincli > 0 && comcli==0) CliSep="\r\n" #\r\n is used for SIU nodes, but not working for R6K
		#else CliSep="\n"    #all other nodes, CPP and COM
		if (use_crlf>0) CliSep="\r\n"  #needed for SIU
		else CliSep="\n"   # all other node types
		if (telnet_session ~ /Unable to connect|Wrong Password/)
		{
			customPrint(telnet_session)
			exit 1
		}
		if (fileOps(sprintf("test -s %s",commandfile)) != 0)
		{
			#the input was a command instead of a commmandfile
			#the commands should be separated by ; eg vii ; lhsh 000100 pglist ; vols
			i=split(commandfile,Command,";")
			for (j=1;j<=i;j++) gsub(/^[ \t]*|[ \t]*$/,"",Command[j])
		}
		else
		{
			i=0
			while ((getline < commandfile)>0)
			{
				gsub("\r","")
				Command[++i]=$0
			}
			close(commandfile)
			if (comcli==1 && linux_shell==0 && epg_ssr!=1) #do not come here if R6K connected with comcli=35 (epg_ssr=1)
			{
				#print "command"i": "Command[1]
			}
			else if (axenode == "SIU")
			{
				if (comcli==2) 
				{
					#if (linux_shell>=1) comPrefix="COLUMNS="comcli_columns" "gensub(/,/," ","g",cliss) CliSep
					#else comPrefix=""
					#On EPG, the new prompt takes effect after going in and out of configure mode
					#Command[1]=comPrefix "prompt \"EndOfPrint\\n\"" CliSep "configure" CliSep "end" CliSep "length" CliSep Command[1]
					#Command[0]=comPrefix "prompt \"EndOfPrint\\n\""
					if (linux_shell>=1) Command[-1]="COLUMNS="comcli_columns" "gensub(/,/," ","g",cliss)
					Command[0]="prompt \"EndOfPrint\\n\"" (linux_shell==0?CliSep:"")
				}
				if (comcli==2) {}  
				else
				{
					for (j=2;j<=i;j++) Command[1]=Command[1] CliSep Command[j]
					if (lincli==2) Command[1]=Command[1]"\r"
					else Command[1]=Command[1] CliSep (rcli==2?"quit":"exit")
					#if (comcli==2) Command[1]=Command[1] CliSep "exit" CliSep "exit" CliSep "exit"
					i=1
				}
			}
			else if (axenode != "")
			{
				#i=1
				if (lincli==3)
				{
					#Command[1]=Command[1]";\r\n;\r\nexit;\r\n"
					Command[1]=Command[1] ";\r\n"    #only the first command is auto-confirmed
					for (j=2;j<=i;j++) Command[1]=Command[1] ";\r\n" Command[j]
					Command[1]=Command[1]";\r\nexit;\r\n"
					i=1
				}
				else
				{
					i=1
					Command[1]=Command[1]";\r\n;\r\nexit\r"
				}
			}
		}
		if (i==1)
		{
			if (Command[i] ~ /^(lhsh[ \t]+(-v +)?[^ \t]+[ \t]+)?sqlc*[ \t]*$/)
			{
				customPrint(sprintf("\
SQL command syntax: sql/sqlc ; command1 ; command2 ; command3; etc...\n\
E.g: sql select * from tables where name like %s%spgm%s%s\n\
     sql select * from cspgmresource_01 where pno=%sCXC 132 0784%s; \n\
     sql update cspgmresource_01 set poolsize=20000000 where pno=%sCXC 132 0784%s; commit;\n","\x27","\x25","\x25","\x27","\x27","\x27","\x27","\x27","\x27","\x27"))
				customPrint("See also \"h sql+\" for help on how to start/stop/check the SQL LM")
				i=0
			}
			else if (Command[i] ~ /^lhsh[ \t]+(-v +)?[^ \t]+[ \t]*(shell)?[ \t]*$/)
			{
				customPrint(sprintf("\
lhsh command syntax (type \"h ose\" for more info):\n\
     lhsh XXYY00 command1                        \n\
or:  lhsh XXYY00 command1 ; lhsh XXYY00 command2 ; ...\n\
or:  lhsh XXYY00 ; command1 ; command2 \n\
or:  lhsh XXYY00/spZ.lnh command1 \n\
etc...\n\
"))
				i=0
			}
			else if (Command[i] ~ /^xbsh[ \t]+[^ \t]+[ \t]*$/)
			{
				customPrint(sprintf("\
xbsh command syntax (type \"h ose\" for more info):\n\
     xbsh XXYY00 command1                        \n\
or:  xbsh XXYY00 command1 ; command2 ; ...\n\
"))
				i=0
			}
			else if (Command[i] ~ /^lhsh[ \t]+(-v +)?[^ \t]+[ \t]+cmxbsh[ \t]*$/)
			{
				customPrint(sprintf("\
cmxbsh command syntax (type \"h ose\" for more info):\n\
     lhsh XXYY00 cmxbsh command1                        \n\
or:  lhsh XXYY00 cmxbsh command1 ; command2 ; ...\n\
"))
				i=0
			}
			else if (Command[i] ~ /^(lhsh[ \t]+(-v +)?[^ \t]+[ \t]+)?cbex$/)
			{
				customPrint(sprintf("Please run cbex followed by the command, e.g. \"cbex <command>\""))
				i=0
			}
			else if (Command[i] ~ /^(lhsh[ \t]+(-v +)?[^ \t]+[ \t]+)?cbex.*[ \t]-p[sq]([ \t]|$)/)
			{
				customPrint("Cbex options -ps/-pq cannot be used from moshell. Please run the cbex command without these options.")
				i=0
			}
		}
	}
	if (fast_lh != 1)
	{
		if (comcli==0 && lincli==0 && axenode=="" && currentDir != "")
		{
			printf("cd %s\necho \"EndOfPrint\"\n",currentDir) |& telnet_session
			while ((telnet_session |& getline)>0)
			{
				gsub("\r","") ; gsub("\x00","")
				if (/(^|[^"])EndOfPrint$/) break
				else if ($0 ~ /not change working/) customPrint($0)
				if (mosdebug==1) print
			}
		}
		for (j=-1;j<=i;j++)
		{
			if (j<1)
			{
				if (!(comcli==2 && Command[j]!="")) continue
			}
			ordered_printout=0
			tmp_crbrffile=""
			crb_command=0
			if (Command[j] ~ /^([Cc]orben|crb|3gsim) +/) crb_command=1
			if (Command[j] ~ /^[ \t]*$/) continue
			if (Command[j] ~ /^sqlc*[ \t]+[^ \t]+/)
			{
				#in case the command looks like: sql select * from tables
				print coliMap("sqlc") |& telnet_session
				if (cpplinux==1) sleep(1)

				#reversal of the correction http://newtran01.au.ao.ericsson.se/moshell/e107_plugins/suggestions_menu/suggestions.php?200.view.89.3.0
				#causes problems when doing a sql insert on values containing spaces, a carriage return will get inserted in the value. Eg:
				#sql INSERT INTO frodata_reportconfigb2utra_c_1_74_1 (froid,ldn,parentref,b2threshold1rsrp,b2threshold1rsrq,b2threshold2ecnoutra,b2threshold2rscputra,hysteresisb2,maxreportcellsb2,reportamountb2,reportintervalb2,timetotriggerb2,triggerquantityb2,triggerquantityutrab2) VALUES (1, 'ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=CAL00437_7B_1,UeMeasControl=1,ReportConfigB2Utra=1','<moref name="parentRef"><attr name="ldn" type="STRING" value="ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=CAL00437_7B_1,UeMeasControl=1"/><attr name="froType" type="S32" value="117506068"/><attr name="froId" type="S32" value="1"/></moref>',-110,-195,-240,-115,10,4,0,2,640,0,0); COMMIT;
				#the problem with SQLC not handling long commands does not seem to be there anymore, thus the splitting seems not needed anymore

				nseg=splitLine(gensub(/^sqlc*[ \t]*/,"","g",Command[j]),1000,lineTable,"word")
				if (nseg==1) print coliMap(lineTable[1])";" |& telnet_session
				else
				{
					for (k=1;k<=nseg;k++) print lineTable[k] |& telnet_session
					print ";" |& telnet_session
				}
			}
			else if (insql==";" && cpplinux==1 && Command[j]~/^exit/) print coliMap("exit;") |& telnet_session
			else if (insql==";")
			{
				nseg=splitLine(Command[j],1000,lineTable,"word")
				if (nseg==1) print coliMap(lineTable[1])";" |& telnet_session
				else
				{
					for (k=1;k<=nseg;k++) print lineTable[k] |& telnet_session
					print ";" |& telnet_session
				}
			}
			else if (Command[j] ~ /^(lhsh +(-v +)?[0-9]+00 +)?(telnet|mmpp dptelnet) +/)
			{
				print Command[j] |& telnet_session
				usleep(1000000)
				print Command[++j] |& telnet_session  #username
				usleep(1000000)
				print Command[++j] |& telnet_session  #password
				usleep(1000000)
				intelnet=1
			}
			else
			{
				if (comcli==0 && cpplinux==0) usleep(100000)
				if (mosdebug==1) printf("Debug: RUNNING COMMAND %s: %s%s%sEND_OF_COMMAND\n",j,Command[j],insql,CliSep)
				if (Command[j] ~ /\\x0[aA]/) gsub(/\\x0[aA]/,"\n",Command[j])
				#if (comcli==0 && cpplinux==0 && length(Command[j])>508)
				#{
				#	if (ssh_server_type~/OSE SSH /)
				#	{
				#		if (warning_printed!=1) customPrint("WARNING: command longer than 510 characters may be cut off.")
				#		warning_printed=1
				#		Command[j]=Command[j]"\n"
				#	}
				#	#else if (length(Command[j])>2006) { print 3 ; Command[j]=Command[j]"\n\n\n\n" }
				#	#else if (length(Command[j])>1003) { print 2 ; Command[j]=Command[j]"\n" }
				#}
				if (comcli==2 && use_netconf==0 && is_netsim==0 && Command[j]~/\?$/) printf Command[j] |& telnet_session  #when the command ends with a question mark the completion will kick in so no carriage return should be given
				else if (comcli==1 && use_netconf==0 && is_netsim==0 && Command[j]~/\\t$/) printf gensub(/\\t$/,"",1,Command[j])"\t" |& telnet_session
				else if (Command[j] ~ /\/diagm\/te +log +read +[1-9]/)
				{
					teOk=0
					theSecs=gensub(/^.*te +log +read +/,"",1,Command[j])+0
					sub(/\/diagm\/te +log +read +[1-9][0-9]*/,"/diagm/te log read ",Command[j])
					delete mm
					mm["Jan"]=1;mm["Feb"]=2;mm["Mar"]=3;mm["Apr"]=4;mm["May"]=5;mm["Jun"]=6; mm["Jul"]=7;mm["Aug"]=8;mm["Sep"]=9;mm["Oct"]=10;mm["Nov"]=11;mm["Dec"]=12
					print "/os/date" |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						gsub("\r","");gsub("\x00","")
						if (mosdebug==1) print
						if ($1=="EndOfPrint") break
						#Sat Oct  8 17:17:11 UTC 2016
						if ($5=="UTC")
						{
							split($4,a,":")
							theTeStart=mktime($6" "mm[$2]" "$3" "a[1]" "a[2]" "a[3])
							#customPrint("Current board time: "strftime("%Y-%m-%d %H:%M:%S",theTeStart))
							theTeStart-=theSecs
						}
					}
					if (Command[j] ~ /^\/fruacc\/lhsh 000100(\/bbEqm[0-9]+)? /) print gensub(/^\/fruacc\/lhsh 000100(\/bbEqm[0-9]+)? /,"",1,Command[j]) |& telnet_session
					else if (Command[j] ~ /^\/fruacc\/lhsh du[2-9]\/(bbEqm[0-9]+)? /)
					{
						split(Command[j],arrb," ")
						sub(/bbEqm[0-9]+/,"",arrb[2])
						if (duMo[arrb[2]]!="")
						{
							if (mosdebug==1) print "DEBUG: "duMo[arrb[2]] gensub(/^\/fruacc\/lhsh du[2-9]\/(bbEqm[0-9]+)? /," ",1,Command[j])
							print duMo[arrb[2]] gensub(/^\/fruacc\/lhsh du[2-9]\/(bbEqm[0-9]+)? /," ",1,Command[j]) |& telnet_session
						}
						else print Command[j] |& telnet_session
					}
					else print Command[j] |& telnet_session
				}
				else if (Command[j] ~ /^\/fruacc\/lhsh 000100(\/bbEqm[0-9]+)? /) print gensub(/^\/fruacc\/lhsh 000100(\/bbEqm[0-9]+)? /,"",1,Command[j]) |& telnet_session
				else if (Command[j] ~ /^\/fruacc\/lhsh du[2-9]\/(bbEqm[0-9]+)? /)
				{
					split(Command[j],arrb," ")
					sub(/bbEqm[0-9]+/,"",arrb[2])
					if (duMo[arrb[2]]!="")
					{
						if (mosdebug==1) print "DEBUG: "duMo[arrb[2]] gensub(/^\/fruacc\/lhsh du[2-9]\/(bbEqm[0-9]+)? /," ",1,Command[j])
						print duMo[arrb[2]] gensub(/^\/fruacc\/lhsh du[2-9]\/(bbEqm[0-9]+)? /," ",1,Command[j]) |& telnet_session
					}
					else print Command[j] |& telnet_session
				}
				else if (Command[j] ~ /^\/fruacc\/lhsh (du[2-9]\/)?fru_[0-9]+\/bbEqm[0-9]+ /)
				{
					print gensub(/\/bbEqm[0-9]+ +\/diagm\//," ",1,Command[j]) |& telnet_session
				}
				else if (cpplinux==1 && Command[j] ~ /^lhcp +[^ ]+ +[^ ]+/)
				{
					tmppwfile="/d/usr/tmp_"username"_"strftime("%Y%m%d_%H%M%S",systime())
					print "echo "node_password" > "tmppwfile |& telnet_session
					split(Command[j],arrz," ")
					if (mosdebug==1) print "DEBUG: lhcp -z "tmppwfile" "arrz[2]" "arrz[3]";echo \"EndOfPrint\""
					print "lhcp -z "tmppwfile" "arrz[2]" "arrz[3]";echo \"EndOfPrint\"" |& telnet_session
				}
				else printf("%s%s%s",Command[j],insql,CliSep) |& telnet_session
				if ((comcli>0 && epg_ssr==1)||(rcli==1)) #Router6000
				{
					if (Command[j] ~ /^(config(ure)?|debug-mode|release download .+|release upgrade|context .+|no context .+|save conf.*|delete .+|restore backup-package .+|restore backup-all .+|reload|reload .+)($|\n)/) inrouter=2  
					if (inrouter<2) print "echo \"EndOfPrint\"" |& telnet_session
				}
			}
			if (Command[j] ~ /^sqlc*/) insql=";"
			else if (Command[j] ~ /^lhsh[ \t]+(-v +)?[^ \t]+[ \t]*([ \t]+shell)?$/) inlhsh=1
			else if (Command[j] ~ /^([Cc]orben|crb|[Ll]oco|3gsim)[ \t]*$/) insubshell=1
			else if (Command[j] ~ /^(lhsh +(-v +)?[0-9]+ +)?((cm|sudo )?xbsh|dpci +dpio +start)/) { iniss=0 ; incmxb=10 }
			else if (incmxb==1 && Command[j] ~ /(^|[ \t])iss([ \t]|$)/) iniss=10
			else if (Command[j] ~ /^(lhsh +(-v +)?[0-9]+ +)?ncli/) inncli=10
			else if (Command[j] == "shell") inshell=1
			#else if (Command[j] == "debug-mode") indebugmode=1  #Router6000
			else if (Command[j] ~ /^exit/)
			{
				if (iniss==0 && incmxb==0 && inncli==0 && insubshell==0 && insql=="" && inlhsh==0 && intelnet==0 && indebugmode==0 && inrouter==0) continue
				if (iniss==1) iniss=0
				else if (incmxb==1) { incmxb=0 ; fflush() }
				else if (inncli==1) inncli=0
				else if (insubshell==1) insubshell=0
				else if (insql==";") insql=""
				else if (intelnet==1) intelnet=0
				else if (inlhsh==1) inlhsh=0
				else if (indebugmode==1) indebugmode=0
				else if (inrouter>0) inrouter=0
			}
			if (j % nr_of_cmds ==0)
			{
				#if (incmxb==1 && Command[j] ~ /ssh advanced/) print "yes\ngimaiwei" |& telnet_session
				if (Command[j] ~ /^(EtHostMo_startTraceRoute|ethtraceroute)/)
				{
					if (cpplinux==1)
					{
						thelastword=split(Command[j],array," ")
						tmp_destip=array[thelastword]
					}
					else
					{
						match(Command[j],/[ \t]-d[ \t]+([^ \t]+)/,array)
						tmp_destip=array[1]
					}
				}
				else if (Command[j] ~ /^([Cc]orben|crb|3gsim) +rf +(-f |[^-h?])/)
				{
					#crb rf -f /c/corben/start -delay 1000
					#crb rf -f /c/corben/start
					#3gsim rf -f /c/3gsim/cmdfiles/p7/start.std.cmd
					#3gsim rf /c/3gsim/cmdfiles/p7/start.std.cmd
					split(Command[j],array," ")
					if (array[3]=="-f") tmp_crbrffile=array[4] ; else if (array[3]!~/^[-h?]/) tmp_crbrffile=array[3]
					if (tmp_crbrffile~/\+/)
					{
						gsub(/\+/,"\\+",tmp_crbrffile) #; print "debug: "tmp_crbrffile
					}
				}
				else if (axenode != "")
				{
					if (axenode != "SIU")
					{
						customPrint(axenode)
						if (lincli!=3) customPrint(sprintf("<%s",toupper(gensub(/\r.*$/,"",1,Command[j]))))
					}
					if (inrouter>1 && Command[j] !~ /^(config(ure)?|debug-mode|release download .*|release upgrade|context .+|no context .+|save conf.*|delete .+|restore backup-package .+|restore backup-all .+|reload|reload .+)$/) print "no" |& telnet_session

					#if (comcli==2 && linux_shell==0)
					#{
					#	print "length" |& telnet_session
					#}
				}
				else if (comcli==1 && linux_shell==0) {}
				else if (cpplinux==1 && Command[j] ~ /^lhcp +[^ ]+ +[^ ]+/){}
				else if (!(Command[j] ~ /^([lL]oco +(st|ls)|MsbHostMo_StartPing|EtHostMo_start(Ping|TraceRoute)|ethtraceroute)/ || (incmxb==10) || (iniss==10) || (inncli > 0) ))
				#|| (Command[j] ~ /^3gsim +/ && (telnet_port !~ /^2[23]$/ || Command[j] ~ /^3gsim +(lu|list ue|lr|list rbs|lsub|list subscription|li|list installation|ls|list statistics|hi|heapinfo|lpdf|la|list alias|lc|list capabilities|lres|lb|list behavior|lgc|list gsm_cell|llp|list log_points|lmn|list msc_node|lpdg|list packet_data_generator|lpm|list performance_monitoring|lrg|list rab_group|lrl|list ranap_link|lsan|list sas_node|lsn|list sgsn_node|lssl|list ss7_signaling_link|lsubd|list subscription_data|lto|list trace_objects|stou|stop ue|modify|mc|mb|ml|mrg|mr|msubd|mu)($| )/))
				{
					#delay needed to avoid spurious characters in printout due to echo command
					if (secure_shell==0 || incmxb==1) usleep(500000) ; else usleep(300000)
					if (Command[j] ~ /^3gsim +/)
					{
						if (Command[j] !~ /^3gsim +(lr|list +rbs|lb|list +behaviour|ou|order +ue|li|list +installation|lcbc|list +cbc)( +|$)/ || Command[j] ~ /^3gsim.* +help *$/) print "3gsim ~" |& telnet_session
						#else usleep(1000000)
					}
					else if (Command[j] ~ /^([Cc]orben|crb) +/) print "corben ~" |& telnet_session
					else if (lhsh_v !=1)
					{
						#print "command "j" "Command[j]
						if (!(use_lhv==1 && Command[j] ~ /^lhsh -v [^ ]+ +[^ ]+/))
						{
							if (cpplinux==1 && no_access_to_os==1 && insql==";") usleep(1000000)
							printf("echo \"EndOfPrint\"%s\n",insql) |& telnet_session
						}
					}
				}
				#PROCINFO[telnet_session, "READ_TIMEOUT"] = ip_inactivity_timeout*1000
				#ERRNO=""
				while ((telnet_session |& getline)>0)
				{
					gsub("\r","");gsub("\x00","")
					#mask this line which comes after doing exit on Router6000 over TLS:
					#00000000:error:0A000126:SSL routines:ssl3_read_n:unexpected eof while reading:ssl/record/rec_layer_s3.c:307
					if (epg_ssr==1 && $0~/routines:ssl3_read_n:unexpected eof while reading:ssl\/record\/rec_layer_s3.c/) continue

					#Handling of the command start shell / config in Router6000
					if ((comcli>0 || rcli==1)&&\
					    ((Command[j]~/^start[ \t]+shell$/ && $0~/#start[ \t]+shell[ \t]*$/) ||\
					    	(Command[j]~/^config$/ && $0~/#config[ \t]*$/) || \
					    	(Command[j]~/^configure$/ && $0~/#configure[ \t]*$/) || \
					    	(Command[j]~/^debug-mode$/ && $0~/#debug-mode[ \t]*$/) ))
					{
						if ($0~/#(config|debug-mode)/) inrouter=2
						else if ($0~/#start/) inrouter=1
						customPrint($0)
						usleep(1000000)
						break
					}
					if ((comcli>0 || rcli==1) && (inrouter>1))
					{
						#[local]R66(config)#no
						#% Incomplete command: no
						if ($1~/#no$/ && NF==1) continue
						if (/^% Incomplete command: no/) break
					}
					#if (ERRNO != "") { print "ERRNO="ERRNO ; break }
					if (comcli>0) remove_colors()
					#if (mosdebug==1) print "debug: "$0    #disable this otherwise ends up in the log
					if (cpplinux==1)
					{
						if ($0~/lhcp -z \/d\/usr\/tmp_/)
						{
							sub(/lhcp -z \/d\/usr\/tmp_[^ ]+ +/,"lhcp ")
							sub(/;echo .*$/,"")
						}
						else if ($0~/echo [^ ]+ > \/d\/usr\/tmp_[^_]+_[^_]+_/) continue
						else if ($1=="Host" && Command[j]~/^lhcp / && $0 ~ / is not in the trusted hosts file./) print "y" |& telnet_session
					}
					if (comcli==1)
					{
						#coli>   -> when we run a known command like /board/vii it does not show the command
						#coli>x   -> but when we run an unknown command it shows the command
						if ($0~/^coli>ManagedElement=[^,]+,Equipment=1,FieldReplaceableUnit=[^, ]+ /)
						{
							tmoldn=gensub(/^coli>/,"",1,$1)
							for (zzz in duMo) if (duMo[zzz]==tmoldn) { sub($1,"coli>/fruacc/lhsh "zzz) ; break }
						}
						if ($0=="coli>" || $0==sprintf("coli>%s",gensub(/^\/fruacc\/lhsh 000100 /,"",1,Command[j])))
						{
							$0="coli>"Command[j]
							for (z=1;z<=NF;z++)
							{
								if ($z~/\/lrat\/exportexcep$/ && $(z+2)!="")
								{
									#sub(sprintf(" %s ",$(z+2))," ******** ")  #hide the password of the /lrat/exportexcep command
									$0=hide_word(z+2,$0)
									break
								}
								else if ($z~/\/diagm\/exportdump$/ && $(z+1)=="export" && $(z+3)!="")
								{
									#coli>/fruacc/lhsh 000100 /diagm/exportdump export sftp://x@a.b.c.d:22/d/usr/lg_20161017_160657_18042/ x  1 2
									#sub(sprintf(" %s ",$(z+3))," ******** ")  #hide the password of the /diagm/exportdump command
									$0=hide_word(z+3,$0)
									break
								}
							}
						}

					}
					if (comcli>0 && theTeStart!="" && Command[j]~/\/diagm\/te +log +read /)
					{
						#[2016-10-07 11:22:36.376204507] (+?.?????????) du1 com_ericsson_triobjif:INFO: { cpu_id = 7 }, { processAndObjIf = "nc_main_thread(sfpModuleCtrlSwU)", fileAndLine = "sfpModuleConnector.cc:439", msg = "#HV24132 SfpModuleConnector::updateReq: Sending updated product data for LDN = "ManagedElement=1,Equipment=1,FieldReplaceableUnit=1,SfpModule=D"" }
						if ($1~/^\[/)
						{
							split(gensub(/^./,"",1,$1),a,"-")
							split($2,b,"[.:]")
							if (mktime(a[1]" "a[2]" "a[3]" "b[1]" "b[2]" "b[3])>=theTeStart) teOk=1
						}
						if ($0~/^coli>/) processLine(show_lnh,currentDir,lhsh_v)
						if (NF==1 && $1=="EndOfPrint")
						{
							if (teOk!=1)
							{
								$0="No newer log records was found"
								processLine(show_lnh,currentDir,lhsh_v)
							}
							break
						}
						if (teOk!=1) continue
					}
					if (comcli>0 && Command[j] ~ /^\/bin\/lhsh / && $0=="END") 
					{
						customPrint($0)
						break
					}

					if (axenode != "")
					{
						#comment out the line below since it causes that write commands will not produce any printout
						#if (lincli==3 && $0~/^[^ \t]*<;$/) { com_noprint=1 ; continue }
						#instead we use a counter that the line "NOT ACCEPTED" will not be shown if there has been some printout after the command
						if (lincli==3)
						{
							#print
							if (/<exit;/) break
							else if ($1!~/^.?</) { axelinecount++ } #; print axelinecount,$0
							if ($0~/^(NOT ACCEPTED|.?<;)$/ && axelinecount>2) continue   #we dont show the confirmation and not accepted that occurs at the end of a printout due to the auto confirmation by moshell
						}
						if (axenode == "SIU")
						{
							if (/^[^ ]*OSmon> */) sub(/^[^ ]*OSmon> */,"OSmon> "gensub(/\n.*$/,"",1,Command[++siuCommand])"\n")
						}
						else gsub(/^.?<$/,"")
					}
					if (comcli==2 && /Connection to COM failed.|Authentication with COM failed./)
					{
						#Connection to COM failed. (Connection refused)
						#Authentication with COM failed.
						customPrint($0)
						j=i
						break
					}
					if (comcli==2 && $0~/^[*]+$/)
					{
						#we start printing after the second line with asterisks, eg:
						#********************************************************************************************************************************
						#Welcome to local config
						#********************************************************************************************************************************
						if (com_noprint<1) { com_noprint=1 ; continue }
						else { com_noprint=0 ; break }
						#else { com_noprint=0 ; continue }
					}
					#else if (comcli==2 && com_noprint>0 && $0 ~ />prompt \"\"$/) { com_noprint=0 ; continue }
					#else if (comcli==2 && com_noprint>0 && $1 == "length" && NF==2) { com_noprint=0 ; continue }
					else if (comcli==2 && com_noprint>0 && $1 == "EndOfPrint" && NF==1) { com_noprint=0 ; continue }
					if (com_noprint==1) continue
					if (tmp_crbrffile == "" && crb_command==1)
					{
						if (/ORDERED/) ordered_printout=1
						if (/3Gsim does not recognize the command '~'|Command 'corben ~' not found/)
						{
							if (ordered_printout != 1) break
						}
						if (ordered_printout == 1 && /^EXECUTED|TIMED_OUT/) { customPrint($0) ; break }
					}
					if ( (($0~/(^|[^"])EndOfPrint;?$/)&&(!(cpplinux==1 && insql==";" && have_sqlc==1))) || (iniss==1 && /^% Invalid Command/) )
					{
						#for cases where the last line doesnt finish with a carriage return
						#Note: in cpplinux sqlc the command echo "EndOfPrint"; shows echo EndOfPrint; (without quotes) whereas with psql it keeps the quotes
						#So we dont go into this part when cpplinux sql interface is using sqlc instead of psql
						if ($0 !~ /^(\$ )*EndOfPrint/ && $0 !~ /^% Invalid Command/) customPrint(gensub(/(\$ )*EndOfPrint/,"",1,$0))
						if (mosdebug==1) print "DEBUG: "$0
						break
					}
					else if (comcli==2 && linux_shell==0 && $0~">length$") continue
					else if (comcli==1 && linux_shell==0 && $1=="RC:") break
					#Cannot have the line below, TR HU24913
					#else if (comcli==1 && linux_shell==0 && $0~/^[^ ]+: command not found/) { customPrint($0) ; break }
					else if (comcli==2 && $0 ~ /prompt: (command )?not found/) {  break }
					#else if (comcli==2 && linux_shell==0 && $1=="length" && $2 ~ /^[0-9]/ && NF==2) break
					else if (comcli==2 && $1=="EndOfPrint") { break}
					else if ((lhsh_v==1 || use_lhv==1) && / returned with status .*, errno |: unknown command '|rcmd: failed to connect to |: illegal command '|rcmd: lost contact with '|gpsh to GEP:.* terminated/ && $0!~/gpsh: unknown command '/)
					{
						#rcmd to OSE: 'ls' returned with status 0, errno 0
						#0006: rcmd: lost contact with 'reload'
						#if (secure_shell==0 && /rcmd: lost contact with |returned with status/) usleep(300000)
						#must wait a little here otherwise with telnet the $ sign gets printed after the next command, resulting in out of sync printout
						if (secure_shell==0) usleep(300000)
						#must wait a little here otherwise the "lhsh -v" command appears in the printout of the current board
						else if (secure_shell==1 && cpplinux==1) usleep(100000)
						else if (secure_shell==1) usleep(100000)  #needed also on CPP OSE with newer OpenSSH
						processLine(show_lnh,currentDir,lhsh_v)
						break
						#on GEP, lhsh -v xxxx <wrongcommand> gives both "unknown command" and "gpsh to GEP terminated", therefore we only break at gpsh to GEP terminated
					}
					else if (crb_command==1 && /3Gsim does not recognize the command '~'|Command 'corben ~' not found|3gsim ~$|corben ~$/) { } #never print this line
					else if (incmxb==1 && /^Unknown command( .echo .EndOfPrint..)?\.$/)
					{
						#this is actually the response of the MSBAM board in MGW when we issue the echo EndOfPrint command
						break
					}
					else if (inncli == 10)
					{
						if (/command not found|nknown command|llegal command|connect to NCLI Server|failed to connect/)
						{
							#Failed to connect to NCLI Server.
							#rcmd: unknown command 'ncli'
							#Unknown command 'ncli'.
							#lhsh: unknown command 'ncli'
							#lhsh: failed to connect to 001100
							customPrint($0)
							inncli=0
							break
						}
						else if (/ncli/) customPrint($0)
						else if ($1=="\x1b[1m")
						{
							customPrint("")
							inncli=1
							break
						}
					}
					else if (indebugmode>0 && NF==1 && $1=="^") {}
					else if (indebugmode>0 && $0=="% Invalid input at '^' marker") break
					else if (tmattach==1 && /^debug1: Remote: Server has no support for port forwarding./)
					{
						tmattach_ok=1
						break
					}
					else if (tmattach==1 && /[Mm]ax number|already attached|not active|[lL]ink handler|stream|handle/)
					{
						#Link handler 001400 is already attached to the monitor that's listening to port 33082
						#Max number (50) of link handlers already monitored.
						#The specified stream (handle -4) is not active
						#Expected link handler[s]
						customPrint($0)
						if (!/Hunting for link handler /) tmattach_fail=1
						#Note: this printout is actually ok eventhough status 1 :
						#Hunting for link handler 001100 from monitor handle 1
						#rcmd: 'tm' returned with status 1, errno 0
					}
					else if (tmattach==1 && /: 'tm' returned with status [0-9]+, errno /)
					{
						if (/ status 0, errno/) tmattach_ok=1
					}
					else if (/Error: unknown command: echo .?EndOfPrint.?;|Exit: No such method: [^ ]+ echo./) break
					else if (cpplinux==1 && insql==";" && /^ +\^$/) break
					else if (cpplinux==1 && insql==";" && have_sqlc==1 && /illegal command .*status: Not enough credentials/) break
					else if ((Command[j] ~ /^([Ll]oco +(st|ls))/ && /^ *(EXECUTED|TIMED_OUT: |.*LOCO: All statistics collected|END\.|.*[sS]imulation.*stopped|.*already running|.*[sS]imulation started|.*Sim started on RoseRT LM\.|already used by .*simulation|No matching simulation found|.*Simulation start result:)/))
					         #(Command[j] ~ /^3gsim +/ && (telnet_port !~ /^2[23]$/ || Command[j] ~ /^3gsim +(lu|list ue|lr|list rbs|lsub|list subscription|li|list installation|ls|list statistics|hi|heapinfo|lpdf|la|list alias|lc|list capabilities|lres|lb|list behavior|lgc|list gsm_cell|llp|list log_points|lmn|list msc_node|lpdg|list packet_data_generator|lpm|list performance_monitoring|lrg|list rab_group|lrl|list ranap_link|lsan|list sas_node|lsn|list sgsn_node|lssl|list ss7_signaling_link|lsubd|list subscription_data|lto|list trace_objects|stou|stop ue|modify|mc|mb|ml|mrg|mr|msubd|mu)($| )/) && /^EXECUTED|No UE defined|No RBS node defined|Could not execute '3gsim |^TIMED_OUT: |3Gsim does not recognize the command/)
					{
						#Simulation start result: GtpUdp Sim started on RoseRT LM.
						#MTP simulation 1 already running on froId 3.
						#Simulation start result: Simulation started.
						#Simulation start result: LSP2 simulation started.
						#Simulation on MP 001400 stopped.
						#LOCO: All statistics collected
						#-froid 1 already used by SCTP simulation with -simNo 1
						#No matching simulation found
						#No RBS node defined.
						customPrint($0)
						break
					}
					else if (incmxb==10 && /--- Completed cmxbsh auto-login ---|DPG I.O Menu System .C. Ericsson AB|Timer expired - poll failed|^Last login: |WARNING: This is a restricted access server. If you do not have explicit/)
					{
						if (/DPG|Timer expired/) customPrint($0)
						incmxb=1
						break
					}
					else if (incmxb==10 && /(unknown|illegal) command .((cm|sudo )?xbsh|dpci)|lost contact|Error in SNMP|Timeout waiting for SNMP|rcmd: failed to connect to|dpIO setup...ERROR - Timer expired|^dpIO help$|connection to XB board could not be established|bash: \/[^ ]*\/xbsh: Permission denied/)
					{
						#$ xbsh 000500
						#telnet connection to XB board could not be established due to failure when setting temporary password on XB.
						#xbsh_telnet is dead now.
						#bash: /mnt/loadmodules/bin/xbsh: Permission denied
						incmxb=0
						customPrint($0)
						break
					}
					else if (iniss==10 && /Component Main Switch/)
					{
						iniss=1
						break
					}
					else if (Command[j] ~ /^([Cc]orben|crb|3gsim) +rf +(-f |[^-h?])/ && $0 ~ sprintf("Read file %s done.|Command file .%s. executed|The command file .%s. failed.|Command file '%s' could not be found or opened.",tmp_crbrffile,tmp_crbrffile,tmp_crbrffile,tmp_crbrffile))
					{
						#[Sun Feb 08 2009 09:50:26.513] Read file /c/corben/bat_sh9_ETMP5_start done.
						#[ Mon Feb 16 09:41:55 2009 ] Read file /c/corben/cmdfiles/test/_start done.
						#Command file 'mb_packet_dest_address.std.cmd' executed.
						customPrint($0) ; break
					}
					else if ((Command[j] ~ /^3gsim +(lr|list +rbs)( +|$)/ && $0 ~ /No RBS node defined\.$|^Parsing error/)||\
					         (Command[j] ~ /^3gsim +(lb|list +behaviour|ou|order +ue|li|list +installation|lcbc|list +cbc)( +|$)/ && $0 ~ /^Validation error|^EXECUTED$|^Could not execute |^The specified cell .* has not been created/))
					{
						customPrint($0) ; break
					}
					else if ((Command[j] ~ /^(MsbHostMo_StartPing|EtHostMo_startPing|EtHostMo_startTraceRoute|ethtraceroute)/ && /Host with IP|PING statistics|Command syntax:|No host configured with IP|Ping session already ongoing|Host with hostFroId=.* doesn.t exist|: command not found|Usage: | ping statistics /)||\
						 (Command[j] ~ /^(EtHostMo_startTraceRoute|ethtraceroute)/ && ($NF==tmp_destip || $2==tmp_destip)))
					{
						#error messages:
						#Ping session already ongoing for Host with hostFroId=1.
						#No host configured with IP a.b.c.d
						#Host with hostFroId=2 doesn't exist

						#Host with IP address 10.0.0.0 is not configured.
						#----- a.b.c.d PING statistics -----
						customPrint($0)
						#delay needed to avoid spurious characters in printout due to echo command

						#successful print of ethtraceroute on EPB1, the destination ip address is printed after colon sign
						# : a.b.c.d

						if (secure_shell==0) usleep(400000) ; else usleep(300000)
						printf("echo \"EndOfPrint\"%s\n",insql) |& telnet_session
					}
					else if (axenode != "" && /^COMMAND UNKNOWN$/)
					{
						if (command_unknown_count < 1) command_unknown_count++
						else customPrint("NOT ACCEPTED\nCOMMAND UNKNOWN")
					}
					else if (!/EndOfPrint|^LOGGED OFF$|<NOT ACCEPTED$/)
					{
						if (tmattach==1 && /commonjars\/connect[^ ]*: connection timed out|nc6[^ ]*: remote idle timed out/) tmattach_ok=1
						else if ((incmxb==10 && $0 !~ /(cm|sudo )?xbsh|dpci +dpio +start/) || iniss==10 || (incmxb==1 && NF==0) || (iniss==1 && (NF==0 || /\x1b/))) {} #hide empty lines or lines containing escape characters
						else if (inncli==1 && $1=="\x1b[1m") { customPrint("") ; break }
						else processLine(show_lnh,currentDir,lhsh_v)
					}
					else if (/^.+\$ echo "EndOfPrint"/) customPrint(gensub(/\$ echo "EndOfPrint"/,"",1,$0))
					else if (cpplinux==1 && Command[j]~/^ethtraceroute/ && /msecho "EndOfPrint"/)
					{
						#debug:  1       a.b.c.d            0.292 ms        0.295 ms        0.228 msecho "EndOfPrint"
						customPrint(gensub(/echo "EndOfPrint"/,"",1,$0),"","","noLF")
					}

					#close logfile after each line of printout for commands that are likely to get aborted with ctrl-C , eg "ping -X" or "ping6"
					if (Command[j] ~ /^ping/) close(logfile)
				}
				#close logfile after the printout is finished
				if (logging == 1) close(logfile) #very important, especially if there has been a "connect" timeout, so the error message is captured
			}
			if (nowarn!="nowarn" && Command[j] ~ /^cv +mk /) customPrint("\n\
##############################################################################################################################\n\
!!! WARNING: For live sites, please use the command \"cvmk\" or \"cvms\" instead.\n\
##############################################################################################################################")
			else if (nowarn!="nowarn" && Command[j] ~ /^(lhsh +(-v +)?[0-9][0-9][0-9][0-9]00 +)*reload/) customPrint("\n\
##############################################################################################################################\n\
!!! WARNING: For live sites, please use the command \"acc <lnh> manualRestart\" instead, as it is a more controlled kind of restart. \n\
             For instance: \"acc 001400 manualRestart\", or \"acc mod1 manualRestart\"\n\
##############################################################################################################################")
		}
	}
	if (indebugmode==1) print "exit" |& telnet_session
	if (tmattach==1 && tmattach_ok==1) {}
	else if (axenode != "" && lincli==3)
	{
		#AXE node
		print "\r\n\r\n\r\n\r\n\r\nexit\r" |& telnet_session
		while ((telnet_session |& getline)>0) {if (mosdebug==1) print}
		close(telnet_session)
	}
	else if (comcli>0 || rcli==1)
	{
		exit_printed=0
		if (inrouter>0) { print "exit" |& telnet_session ; usleep(500000) }    #used for Router6000 "start shell" , "config" , and "debug-mode"
		if (comcli==2) print "exit\nexit\nexit" |& telnet_session
		print "exit" |& telnet_session
		while ((telnet_session |& getline)>0)
		{
			gsub("\r","")
			remove_colors()
			if (/exit$/ && comcli==1 && exit_printed!=1)
			{
				customPrint(gensub(/exit$/,"",1,$0))
				exit_printed=1
			}
		}
		if (comcli==2) customPrint(">exit")
		else if (comcli==1 && secure_port==4192) customPrint("coli>") #RCS node
	}
	else if (axenode == "")
	{
		if (insql==";") print coliMap("exit;") |& telnet_session
		if (incmxb==1)
		{
			if (iniss==1)
			{
				$0=""
				print "logout" |& telnet_session
				while ((telnet_session |& getline)>0)
				{
					if (/Connection closed/) break
				}
			}
			$0=""
			print "exit" |& telnet_session
			while ((telnet_session |& getline)>0)
			{
				#CMXB: Connection closed by peer.
				#MSBAM: dpIO terminate...OK
				#gsub("\r","") ; sub(/\x1b.*\x1b/,"")
				if (/Connection closed|dpIO terminate/) { usleep(500000) ; break }
			}
		}
		if (inncli==1)
		{
			print "exit" |& telnet_session
			while ((telnet_session |& getline)>0)
			{
				gsub("\r","")
				if ($NF=="\x1b[mexit") break
			}
			usleep(1000000)
			fflush()
		}
		#the usleep is for XMU03 which does not buffer the commands, thus we have to wait for the exit to take effect before sending the next exit, eg in the case of:
		#lhsh BXP_0 shell ; shell ; ps
		if (intelnet==1) print "exit" |& telnet_session
		if (inlhsh==1)  { print "exit"  |& telnet_session ; usleep(500000) ; if (cpplinux==1) usleep(500000) }
		if (insubshell==1) print "exit" |& telnet_session
		if (inshell==1) { print "exit" |& telnet_session ; usleep(500000) }
		print "exit" |& telnet_session
		while ((telnet_session |& getline)>0)
		{
			gsub("\r","") ; gsub("\x00","")
			if (mosdebug==1) print "DEBUG: "$0
			if (comcli>0) remove_colors()
			if (/Buffered commands exist: COMMIT or ROLLBACK before typing EXIT/ && sqlRollbackPrinted != 1)
			{
				print ";\nrollback;\nexit;\nexit" |& telnet_session
				sqlRollbackPrinted=1
			}
			if (!((tmattach==1 && /debug1:/)||(crb_command==1 && /3Gsim does not recognize the command '~'|Command 'corben ~' not found|3gsim ~$|corben ~$/))) processLine(show_lnh,currentDir)
		}
		if (show_lnh != 1 && currentDir == "") customPrint("Connection closed by foreign host.")
		else customPrint("$ ")
	}
	close(telnet_session)
	if (lhz==1)
	{
		if (measuretimeStart>0) customPrint(sprintf("Duration_%d: %d",++measuretimeCount,systime()-measuretimeStart))
		delete ftpcommandlist
		ftpcommandlist[0]=sprintf("get %s %s",localnogzlogfile,lhzlogfile)
		ftpcommandlist[1]=sprintf("dele %s",localnogzlogfile)
		ftpclient(node_address,node_password,"",ftpcommandlist)
		if (measuretimeStart>0) customPrint(sprintf("Duration_%d: %d",++measuretimeCount,systime()-measuretimeStart))
		if (fileOps("test -s "lhzlogfile)==0)
		{
			gzipdc_com="gzip -dc "lhzlogfile
			while (gzipdc_com |& getline)
			{
				gsub("\r","") ; gsub("\x00","")
				processLine(show_lnh,currentDir)
			}
			close(gzipdc_com)
		}
		if (measuretimeStart>0) customPrint(sprintf("Duration_%d: %d",++measuretimeCount,systime()-measuretimeStart))
	}
	initialise_telnode()
	if (tmattach == 1)
	{
		if (mosdebug==1) print "tmattach_fail="tmattach_fail", tmattach_ok="tmattach_ok
		if (tmattach_fail == 1) return 98
		else if (tmattach_ok != 1) return 97
	}
}
function splitLine(line,segmentlength,lineTable,what,   a,last,nr_of_segments,i,j,starpos,endpos,splitchar)
{
	#if what=="char":
	#split the line in segments of "segmentlength" characters and put each segment in the hashtable lineTable. Return the number of segments
	#example:   line=hello world
	#nr_of_segments = cutline(line,array,4)
	#---> array[1]=hell
	#     array[2]=o wo
	#     array[3]=rld
	#nr_of_segements=3

	#if what=="word"
	#split the line in segments of "segmentlength" words and put each segment in the hashtable lineTable. Return the number of segments
	#example: line=hello world, how are you?
	#nr_of_segments = cutline(line,array,2)
	#---> array[1]=hello world,
	#     array[2]=how are
	#     array[3]=you?
	#nr_of_segments=3

	if (what=="char") splitchar=""
	else if (what=="word") splitchar=" "
	delete lineTable
	last=split(line,a,splitchar)
	if (last <= segmentlength)
	{
		lineTable[1]=line
		return 1
	}
	nr_of_segments=last / segmentlength
	if (last % segmentlength > 0) nr_of_segments++
	for (i=1;i<=nr_of_segments;i++)
	{
		startpos=(i-1)*segmentlength+1
		endpos=startpos+segmentlength-1
		for (j=startpos;j<=endpos;j++) lineTable[i]=lineTable[i]" "a[j]
		gsub(/^ +| +$/,"",lineTable[i])
		lineTable[i]=lineTable[i]" "
	}
	return nr_of_segments
}
function splitFile(file,batchsize,splitFileTable,  nr_of_lines,filecount,i)
{
	#splits the file in small files containing "batchsize" lines each
	#the pathes of the small files is file_X where X is an integer from 1 upwards
	close(file)
	while ((getline < file)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		nr_of_lines++
		if (nr_of_lines%batchsize==1)
		{
			filecount++
			splitFileTable[filecount]=file"_"filecount
			fileOps("rm "splitFileTable[filecount])
		}
		print $0 >> splitFileTable[filecount]
	}
	close(file)
	for (i in splitFileTable) close(splitFileTable[i])
	return filecount
}

function initialise_telnode()
{
	#following variables are global between telnode_function and processLine only.
	#we initialize them at the beginning and end of telnode_function in order not to interfere with other functions
	#shouldn't be needed since telnode_function always called from system call but let's leave it there anyway
	board=lastCommand=smn=apn=sp=shortboard=output=localcommandfile=""
}
function processLine(show_lnh,currentDir,lhsh_v,sql_linux,   cxcnum,lm,array,templength,last,a)
{
	gsub(/^([$] )+/,"$ ")
	gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
	if (cpplinux==1 && (insql==";" || sql_linux=="sql_linux"))
	{
		if (/^ERROR: +syntax error at or near |^ *\^$/) return 0
		gsub(/ +$/,"")
		if ($0~/^--/) $0="--"$0"-"
		else if ($0 !~ /^(exit|\([0-9]+ rows?\)|[ \t]*)$|^postgres=|^\$ |^LINE 1: |ERROR: +syntax error at or near |^psql -U postgres |^SQL> |^logout$/) $0="| "$0" |"  #table entries must have pipe at the beginning and end to be recognised by moshell
	}
	if (cpplinux==1 && $0=="logout") return 0
	if (cpplinux==1) sub(/^CpxLsi initialised/,"")
	if (comcli>0 && NF==0) return 0
	if (comcli>0 && NF==1 && $1=="END") return 0 #the last line of /fruacc/lhsh is END
	if (comcli>0)
	{
		#coli [/]-> /fruacc/lhsh BXP_0 vii
		#WARNING: /fruacc/lhsh is deprecated and might not work. Registered COLIs might be missing and supported COLIs could fail to execute. please use LDN to adress and execute COLIs.
		#
		#Example:
		#ManagedElement=1,Equipment=1,FieldReplaceableUnit=1 /fruacc/vii

		#On Radio 2212/2219 the following appears:
		#Warning: Could not get fru type. Assuming radio unit

		if (/Warning: Could not get fru type. Assuming radio unit/) return 0

		if ($1=="WARNING:" && $2=="/fruacc/lhsh" && $0~/is deprecated and might not work/) { globC=1 ; return 0 }
		else if (globC==1 && $1=="Example:" && NF==1) { globC=2 ; return 0 }
		else if (globC==2 && $1=="ManagedElement=1,Equipment=1,FieldReplaceableUnit=1" && $2=="/fruacc/vii") { globC=0 ; return 0 }
		else globC=0
	}
	if (show_lnh==1 || currentDir != "")
	{
		if (lhz==1 && NF==4 && $2=="command" && $3=="not" && $1 ~ /^@@@@lhsh@-v@.*/)
		{
			#@@@@lhsh@-v@000000@vii: command not found
			$0=$1
			sub(/:$/,"")
			sub(/^@@@@lhsh@-v@/,"$ lhsh ")
			gsub(/@/," ")
		}
		if ( ((comcli==0)&&($0~/^\$[ $]*(lhsh( +-v)?|sudo|te|bs -d|ls|pglist|capi +prog|pm_pginfo|lmlist|listloaded|ps|sma -all|listAal2NccRejCnt|bl|rld|bmpgmconfig)( |$)/)) || ((comcli>0)&&($0~/^coli>\//)) ) lastCommand=$0
		if ((show_lnh==1 && (NF==0 || /^=========+$|^>>>>>>/ ))|| /Connection .* closed( by (foreign|remote) host)?./ || \
			/EndOfPrint/ || /^(\$ exit|exit)$/ || /^\$ *$/ || \
			(localcommandfile != "" && $0 ~ sprintf("rm -f %s",localcommandfile))) {}
		else if (((lhsh_v==1 || use_lhv==1) && / returned with status.*, errno/) || /gpsh to GEP:.* terminated/)
		{
			#rcmd to OSE: 'ls' returned with status 0, errno 0
		        #gpsh to GEP: 'te' terminated
		        #rcmd to OSE: shell returned with status 0, errno 0


		        #returned with status -> goes to stderr -> in lhz this line goes to the screen
		        #gpsh to GEP -> goes to stdout -> in lhz this line goes to the logfile
		        if (mosdebug==1) print "DEBUG: "$0
		}
		else if (/^\$ (shell -f|sh -f|bash -l) /) customPrint($0)
		else if (cpplinux==1 && /^sh -f /) {} #in cpplinux the line "sh -f" appears twice, once without dollar and once with dollar. Dont print the line without dollar
		else if (cpplinux==1 && /(^| )sh: [^ ]+: command not found/)
		{
			match($0,/sh: ([^ ]+): command not found/,a)
			sub(/sh: [^ ]+: command not found/,"rcmd: unknown command '"a[1]"'")
			customPrint($0)
		}
		else if ( ((comcli==0)&&($0~/^\$[ $]*(lhsh( +-v)?) /)) ||\
		          ((comcli>0)&&($0~/^coli>\//)) )
		{
			sub(/^\$ \$/,"$")
			if (show_lnh==1) customPrint("=============================================================================================")
			if (/^\$ lhsh [0-9]+ *te -p /) board=sprintf("%s/%s",$3,$6)
			else if (/^\$ lhsh/)
			{
				if (lhsh_v==1 || use_lhv==1) sub(/lhsh +-v +/,"lhsh ") #$ lhsh -v 001000
				board=$3
			}
			else if (/^\$ te -p /) board=$4
			else if (/^\$ b(oard_statu)*s -d /)
			{
				board=sprintf("%02d%02d00",$4,$5)
			}
			else if (comcli>0)
			{
				if ($1=="coli>/fruacc/lhsh") board=$2
				else board="000100"
			}
			customPrint($0)
			lastCommand=$0
			shortboard=make_shortboard(board)
		}
		else if (anon_ue==1 && lastCommand ~ / ueregprint /)
		{
			#    0        0     27        4        4                     imsi  147001800000008    147001800000008    6259  con        00:00:32
			if ($1 ~ /^[0-9]+$/ && $2 ~ /^[0-9]+$/ && $3 ~ /^[0-9]+$/)
			{
				for (i=6;i<=NF;i++)
				{
					if ($i ~ /^(con|ura)$/ && $(i-2) ~ /^[0-9]{14,18}$/)
					{
						imsi=$(i-2)
						break
					}
				}
				encoded_imsi=enc_imsi(imsi)
				gsub(imsi,encoded_imsi)
			}
			output=$0
			if (show_lnh==1) output=sprintf("%s: %s",shortboard,output)
			customPrint(output)
		}
		else if (lastCommand ~ /te.* log read|rld/)
		{
			output=appendCXCtranslation($0)
			output=put_colours(output)
			if (show_lnh==1) output=sprintf("%s: %s",shortboard,output)
			customPrint(output)
		}
 		else if (print_lmid >= 1 && lastCommand ~ /(^| )(sudo +)?(\?|rev|mmpp dspc devt|ls|pglist|capi +prog|pm_pginfo|lmlist|listloaded|ps|sma -all|bl|listAal2NccRejCnt|bmpgmconfig)( |$)/)
 		{
			output = $0
			if (lastCommand ~ "sma -all" && output !~ /^0x|illegal command.*credentials/)
			{
				#0x000301f6  CXC1322417%12_R60FX02
				last=split(output,array,"")
				output=""
				for (i=1;i<=24;i++) output=sprintf("%s%s",output,array[i])
				for (i=33;i<=82;i++) output=sprintf("%s%s",output,array[i])
				for (i=104;i<=last;i++) output=sprintf("%s%s",output,array[i])
			}
			if (show_lnh==1) output=sprintf("%s: %s",shortboard,output)

			if (lastCommand ~/pglist|pm_pginfo/) templength = 45;
			else if (NF > 1) templength=70
			else templength=30

			output=appendCXCtranslation(output,templength)
			customPrint(output)
 		}
		else if (show_lnh==1) customPrint(sprintf("%s: %s",shortboard,$0))
		else customPrint($0)
	}
	else if ($0 !~ /^(\$ exit|EndOfPrint|exit)$/ && $0 !~ sprintf("rm -f %s",localcommandfile)) customPrint($0)
	if ($0 ~ /Timeout.*not responding|: connection timed out|: remote idle timed out/) return 1
	return 0
}
function put_colours(line)
{
	#ANSI color codes:
	#Black       0;30     Dark Gray     1;30
	#Red         0;31     Light Red     1;31
	#Green       0;32     Light Green   1;32
	#Brown       0;33     Yellow        1;33
	#Blue        0;34     Light Blue    1;34
	#Purple      0;35     Light Purple  1;35
	#Cyan        0;36     Light Cyan    1;36
	#Light Gray  0;37     White         1;37
	if (line !~ colour_string || show_colors != 1) return line
	if (line ~ /ERROR:|Pathindex rejected|ABNORMAL/) line="\33[1;31m"line"\33[0m"
	else if (line ~ /:Start of @/) line="\33[1;34m"line"\33[0m"
	else if (line ~ /[rR]estart|lost contact|:EMAN:/) line="\33[1;35m"line"\33[0m"
	else if (line ~ /OMS initialized/) line="\33[1;32m"line"\33[0m"
	return line
}
function offline_telnode(   cline,cList,z,i,res,n,a,sb)
{
	#global variables:
	lastColiFile=""
	lastColiStop=0
	lCount=0

	if (fileOps("test -s "commandfile)!=0) { customPrint("ERROR: file not found "commandfile) ; return }
	while (getline cline < commandfile)
	{
		gsub("\r","",cline)
		sub(/^lhsh -v /,"lhsh ",cline)
		cList[++z]=cline
	}
	close(commandfile)
	if (show_lnh==1) customPrint("=============================================================================================")
	for(i=1;i<=z;i++)
	{
		cline=cList[i]
		gsub(/[ \t]+/," ",cline)   #replace repeated spaces by one space only
		n=split(cline,a," ")
		if (n==3 && a[3]=="?")
		{
			sb=make_shortboard(a[2])
			if (coliBdList[a[2]]=="") customPrint(sprintf("%s%s\n%s: No commands are available on board %s.",(comcli>0?"coli>":"$ "),cline,sb,a[2]))
			else customPrint(sprintf("%s%s\n%s: Available Commands on board %s:\n%s",(comcli>0?"coli>":"$ "),cline,sb,a[2],sb": "gensub(SUBSEP,"\n"sb": ","g",coliBdList[a[2]])))
		}
		else if (cline in coliList && coliList[cline]=="1") res=display_printout(cline)
		else
		{
			if (comcli>0) customPrint("coli>"cline)
			else customPrint("$ "cline)
			if (cline ~ /^(lhsh (-v +)?[^ ]+ )?echo /) customPrint(gensub(/^(lhsh (-v +)?[^ ]+ )?echo /,"",1,cline))
			else customPrint("Command not found in the COLI logs.")
		}
		if (show_lnh==1 && i<z) customPrint("=============================================================================================")
		else if (comcli>0) customPrint("coli>")
		else customPrint("$ ")
	}
	finish_readfile(res)
}
function display_printout(command,    file,start,stop,dline,readfile_command)
{
	file=coliDB[command,"file"]
	start=coliDB[command,"start"]+0
	stop=coliDB[command,file,"end"]+0
	if (mosdebug==1) print "file="file", start="start", stop="stop
	if (file ~ /\.gz$/) readfile_command="gzip -dc "file
	else readfile_command="cat "file
	readfile_command=readfile_command" 2>&1"  #to avoid gzip: stdout: Broken pipe or "cat: write error: Broken pipe" which started appearing with gawk 4.1.1
	if ((readfile_command != lastColiFile)||(lastColiStop > start))
	{
		#finish reading the previous pipe, to avoid "broken pipe", then close it
		if (lastColiFile!="")
		{
			while (lastColiFile |& getline dline) {}
		}
		close(lastColiFile)
		lCount=0
	}
	while (readfile_command |& getline dline)
	{
		lCount++
		if (lCount < start) continue
		if (lCount > stop) break
		if (show_lnh != 1)
		{
			if (dline ~ /^====+$/) continue
			sub(/^[^: ]+: /,"",dline)
		}
		customPrint(dline)
	}
	#don't close the file
	lastColiFile=readfile_command
	lastColiStop=stop
	return readfile_command
}
function finish_readfile(thereadfile_session,    dline)
{
	if (thereadfile_session!="")
	{
		while ((thereadfile_session |& getline dline)>0) {}
	}
	close(thereadfile_session)
}
####################################################################################################################
# CABVIEW RELATED FUNCTIONS (CAB COMMAND)
####################################################################################################################
function define_memory()
{
	total_mem["GPB2"]=256
	total_mem["GPB3"]=512
	total_mem["GPB31"]=256
	total_mem["GPB32"]=512
	total_mem["GPB40"]=512
	total_mem["GPB41"]=256
	total_mem["GPB42"]=512
	total_mem["GPB43"]=1024
	total_mem["GPB51"]=512
	total_mem["GPB52"]=1024
	total_mem["GPB53"]=1024
	total_mem["CBU1"]=512
}
function define_leds(   i)
{
	#TX map for ODM radio RRUS31 RRU22F
	txmap["A"]=1
	txmap["B"]=2
	txmap["C"]=3
	txmap["D"]=4
	txmap["E"]=5
	txmap["F"]=6
	# Mapping table EGEM2 -> Mos
	EGEM_LED["STEADY_ON"]  = "ON"
	EGEM_LED["SLOW_BLINK"] = "05HZ"
	EGEM_LED["FAST_BLINK"] = "4HZ"
	EGEM_LED["OFF"]        = "OFF"
	EGEM_LED["NOT_AVAILABLE"]= "?"
	EGEM_LED["NOT_APPLICABLE"]="N/A"
	EGEM_LED["?"]          = "?"
	EGEM_LED[""]           = "?"
	EGEM_LED["DOUBLE_FLASH_AND_STEADY_ON"] = "xx1"
	EGEM_LED["DOUBLE_FLASH_AND_OFF"]="xx0"
	EGEM_LED["2"]          = "OFF"
	EGEM_LED["3"]          = "ON"
	#HCS
	EGEM_LED["OUT"]        = "OFF"
	EGEM_LED["STEADY_LIGHT"] = "ON"
	EGEM_LED["FLICKERING"] = "16HZ"
	EGEM_LED["UNAVAILABLE"] = "?"
	EGEM_LED["ENABLED"] = "1"
	EGEM_LED["DISABLED"] = "0"
	# PFM led
	#getAttrObj pfmData
	#ledState        : 0 (PFM_LED_OFF)
	EGEM_LED["0"]="OFF"

	buildHwidTable()

	rru82Name="^RRU.82"
	rrul8Name="^RRUL8[^2]"
	rrul6Name="^RRUL6[^3]"
	rrus31Name="^(RRUS31|RRU?22F[123])"   #ODM Radio (2TX or 4TX or 6TX)
	rrus32Name="^RRUS[37]2"   #4TX
	rrus33Name="^RRU(2217|2203)" #NGR G1 2TX , same commands as RRUS32
	rrulName=rrul8Name"|"rrul6Name"|"rru82Name
	rrus2Name="^RRU?22F1"    #2TX ODM RR22F1
	rrus4Name=rrus31Name"|"rrus32Name    #4TX and 6TX , or 2TX ODM
	rrus6Name="^RRU?22F3"  #6TX . This group overlaps with rrus4Name and rrus31Name

	rrul8Prod=rrul6Prod=rrus31Prod=rrus32Prod=rru82Prod=""
	rrulProd=rrus4Prod=rrus2Prod=rrus6Prod=rrus33Prod=""
	for (i in hwidLookupTable)
	{
		     if (hwidLookupTable[i] ~ rrus6Name)  { rrus6Prod=rrus6Prod"|"i    ; sub(/^\|/,"",rrus6Prod)  }  #Fujitsu 6TX ODM radio , also included in rrus31Name/rrus31Prod
		     if (hwidLookupTable[i] ~ rrus2Name)  { rrus2Prod=rrus2Prod"|"i    ; sub(/^\|/,"",rrus2Prod)  }  #Fujitsu 2TX ODM radio , also included in rrus31Name/rrus31Prod
		     if (hwidLookupTable[i] ~ rrul8Name)  { rrul8Prod=rrul8Prod"|"i    ; sub(/^\|/,"",rrul8Prod)  }  #TDD LTE 8TX
		else if (hwidLookupTable[i] ~ rrul6Name)  { rrul6Prod=rrul6Prod"|"i    ; sub(/^\|/,"",rrul6Prod)  }  #TDD LTE 2TX
		else if (hwidLookupTable[i] ~ rru82Name)  { rru82Prod=rru82Prod"|"i    ; sub(/^\|/,"",rru82Prod)  }  #RRUx82 8 TX
		else if (hwidLookupTable[i] ~ rrus31Name) { rrus31Prod=rrus31Prod"|"i  ; sub(/^\|/,"",rrus31Prod) }  #Fujitsu  4TX ODM radio
		else if (hwidLookupTable[i] ~ rrus32Name) { rrus32Prod=rrus32Prod"|"i  ; sub(/^\|/,"",rrus32Prod) }  #Ericsson 4TX RRU (32) and AIR (72)
		else if (hwidLookupTable[i] ~ rrus33Name) { rrus33Prod=rrus33Prod"|"i  ; sub(/^\|/,"",rrus33Prod) }  #NGR G1 2TX, same commands as Ericsson 4TX RRU
	}
	rrulProd=rrul8Prod"|"rrul6Prod"|"rru82Prod
	rrus4Prod=rrus31Prod"|"rrus32Prod

	if (mosdebug==1)
	{
		print "DEBUG: rrul8Prod="rrul8Prod" rru82Prod="rru82Prod" rrul6Prod="rrul6Prod" rrulProd="rrulProd" rrus31Prod="rrus31Prod" rrus32Prod="rrus32Prod" rrus4Prod="rrus4Prod" rrus6Prod="rrus6Prod" rrus2Prod="rrus2Prod
		print "DEBUG: rrul8Name="rrul8Name" rru82Name="rru82Name" rrul6Name="rrul6Name" rrulName="rrulName" rrus31Name="rrus31Name" rrus31Name="rrus31Name" rrus4Name="rrus4Name" rrus6Name="rrus6Name" rrus2Name="rrus2Name
	}
}
function process_pdr_line()
{
	#0x01823320   8    0   8    0 0x00080000    338           0
	#0x0180f940   2    0  10    0 0x000a0000      0   001000  0
	#0,13,ROJ1192106/3,R2,MP,3,CXC1320785_R61BJ02,100,h=0,p=0
	#0,10,ROJ1192106/3,R2,MP,3,CXC1320785_R61BJ02,100,h=0,p=0

	#OWN LOCATION DETAILS are:
	#SMN is [0]
	#APN is [3]
	#ERN is [0]
	#Other boards in the node are:
	#smn     apn     ern     status             mac_addr     product-number                  product-revision
	#0       1       0       PRESENT         0x020000010000  ROJ 208 395/1                   R3A/B
	#0       25      0       ICP_CONNECTED   0x020000190000
	#0       27      0       PRESENT         0x0200001b0000  ROJ 208 395/1                   R3A/B
	#15      1       0       PRESENT         0x02000f010000  ROJ208468/1                     P1C
	#15      3       0       PRESENT         0x02000f030000  ROJ 208 392/1                   R7B
	#15      4       0       PRESENT         0x02000f040000  ROJ208468/1                     P1C
	#15      6       0       PRESENT         0x02000f060000  ROJ 208 392/1                   R7B

	#In RBS6000
	# APN 1  -  META_CONNECTED
	# APN 2  -  ICP_CONNECTED
	#or:
	# smn    apn     ern     status             mac_addr
	# 0      1       0       PRESENT         0x020001000000


	if (($1 ~ /^0x/ && $3 ~ /^[0-9]+$/ && $4 ~ /^[0-9]+$/) || ($1 ~ /^[0-9]+,[0-9]+,/)  || ($1 ~ /^[0-9]+$/ && $2 ~ /^[0-9]+$/ && $4 ~/^(PRESENT|ICP_CONNECTED)$/) || ($1=="APN" && $2 ~ /^[0-9]+$/ && $4 =="ICP_CONNECTED"))
	{
	        if (($4=="ICP_CONNECTED") )
		{
			#This part is only done for boards that are ICP_CONNECTED
			if ($1=="APN") smn=tmp_hubsmn
			else smn=$1
			apn=$2
		}
		else if ($1 ~ /^0x/) { smn=$3 ; apn=$4 }
		else if ($1 ~ /^[0-9]+,[0-9]+,/) { split($1,array,","); smn=array[1] ; apn=array[2] }
		else return  #in case none of the above was found, to avoid having a entry with: board[,]=1 . Use return instead of continue since this function only looks at one line
		if (nocontact[smn,apn]!=1) board[smn,apn]=1
		smn_list[smn]=1
		apn_list[apn]=1
		if ($1 ~ /^0x/ && $2==2) board[smn,apn]=2 #Hub MP
		if (/,CXC132078[12]_/) cab_core_mp_list[smn,apn]=1
	}
	else if (/SMN is \[[0-9]+\]/)
	{
		tmp_hubsmn=gensub(/^.*\[|\].*$/,"","g",$0)+0
		smn_list[tmp_hubsmn]=1
	}
	else if (/APN is \[[0-9]+\]/)
	{
		tmp_hubapn=gensub(/^.*\[|\].*$/,"","g",$0)+0
		evoHubMp[tmp_hubsmn,tmp_hubapn]=1
		apn_list[tmp_hubapn]=1
		board[tmp_hubsmn,tmp_hubapn]=1
	}
}
function sortCabTable(table,sorted_table,countRx,   array,last,i,j)
{
	delete sorted_table
	for (i in table)
	{
		split(table[i],array,",")
		last=asort(array)
		if (countRx=="countRx" && last>=4) have4Rx=1
		for (j=1;j<=last;j++)
		{
			if (array[j]=="") continue
			sorted_table[i]=sorted_table[i]","array[j]
		}
		sub(/^,/,"",sorted_table[i])
	}
}
function printCabxObsolete()
{
	customPrint("\nNote: the RU/TX/VSWR tables in cabx are obsolete. Command invxrf can be used instead.")
}
function printCabTable(table,tablename,  i)
{
	for (i in table)
	{
		print "DEBUG: "tablename"["i"]="table[i]
	}
	print ""
}
function cabview_function(inputvariables,    array,zz)
{
	parse_inputvars(inputvariables)

	if (inputoptions ~ /s|x|h/) check_hw=1           ; else check_hw=0
	if (inputoptions ~ "s") check_sw=1               ; else check_sw=0
	if (inputoptions ~ "x") check_xp=1               ; else check_xp=0
	if (inputoptions ~ "l") check_load=1             ; else check_load=0
	if (inputoptions ~ "r") check_llog=1             ; else check_llog=0
	if (inputoptions ~ "a") check_crash=check_llog=1 ; else check_crash=0
	if (inputoptions ~ "d") check_vols=1             ; else check_vols=0
	if (inputoptions ~ "f") check_f=check_vols=1     ; else check_f=0
	if (inputoptions ~ "t") notemp=1                 ; else notemp=0
	if (inputoptions ~ "g") check_dumpelg=1          ; else check_dumpelg=0
	if (inputoptions ~ "0") show_colors=0            ; else show_colors=1
	if (inputoptions ~ "m") check_mem=1              ; else check_mem=0
	if (inputoptions ~ "e") check_te=1               ; else check_te=0
	if (inputoptions ~ "c") csvoutput=1              ; else csvoutput=0
	if (inputoptions ~ /^[t01c]*$/) check_hw=1
	#if (check_hw == 0 && check_llog==0 && check_vols==0 && check_dumpelg==0 && check_te==0) check_hw=1
	fast_cab_threshold=currentDir
	if (check_mem==1) define_memory()
	if (check_hw==1) define_leds()
	if (csvoutput==1) sep=";" ; else sep=""
	if (inputoptions ~ "z") check_hw=2  #internal option
	cabhwinfofile=gensub(/\/[^/]+$/,"",1,commandfile)"/cabHwInfoFile"
	evo_node=0
	has4Led=0
	cabLen["board"]=length("Board")
	len["auxboard"]=length("Board")
	len["trx"]=length("Board")
	len["carrRu"]=length("AuxPIU")
	len["carrTr"]=length("Sectors")
	if (fileOps("test -s "cabhwinfofile)==0)
	{
		delete ruSerialTable
		delete ruCarrierTable
		delete trCarrierTable
		delete trDeviceTable
		delete carrierList
		delete carrierTrList
		delete sorted_carrierTrList
		delete lteCells
		while ((getline < cabhwinfofile)>0)
		{
			if (mosdebug==1) print "DEBUG: "$0
			if ($1 ~ /^[0-9]+$/ && $2 ~ /^[0-9]+$/)
			{
				#0   1  SCXB3                            ROJ208395/1    R4B    A064493148 20110627
				#0   2  CMXB3                            ROJ208392/1    R4A    A064515733 20110715
				#0   4  EPB1                             ROJ208394/1    P1G/1  A064441928    20110504   CoreMP*
				#0   5  NOCONTACT
				smn_list[$1]=1
				cabhwSubracks[$1]=1  #this is the list of subracks that are present in the cabhwInfoFile. The CAX subrack will not be in this list as it is not shown on purpose in the cabhwfile. We use this table further down to check the boards of the CAX subrack
				if ($3=="NOCONTACT")
				{
					nocontact[$1,$2]=1
					continue
				}
				productname[$1,$2]=prodname_sw[$1,$2]=$3
				if (length(productname[$1,$2]) > cabLen["board"]) cabLen["board"]=length(productname[$1,$2])
				productnumber[$1,$2]=$4
				if ($3 ~ /^(GPB|CBU|DU[WLS]|EPB|CBM|OD[WS]|TP5)/)
				{
					mpList[$1,$2]=1
					foundmp=1
					if ($3 ~ /^(OD[WS]|DU[WLS]|TP5)/)
					{
						if (is_3000!=1) is_6000=1  #could be a rbs3000 using DUW/ODW with XCU to the RU/FUs
						if ($3 ~ /^DUL/) is_LTE=1
						if ($3 ~ /^(DUW|ODW)/) is_wrbs=1
						if ($3 ~ /^(DUW4|ODS|DUS)/) has4Led=1
					}
				}
				else if ($3 ~ /^(SCXB|SMXB)/) { evo_node=1 ; has4Led=1 }
				else if ($3 ~ /^SCB-[DT]/) hcs_node=1
				else if ($3 ~ /^(RAX|TX)/) { is_3000=1 ; is_6000=0 }
				if ($3 !~ /^(SCXB|CMXB|CCIB|SMXB)/)
				{
					board[$1,$2]=1
					apn_list[$2]=1
				}
				if ($NF ~ /^CoreMP/) cab_core_mp_list[$1,$2]=1
			}
			#WRBS NCLI:
			#   ManagedElement=1
			#   productName=(String)"RBS3206"
			#   productName=(String)"RBS 6501"
			#   ManagedElement=1,Equipment=1,SectorAntenna=1-1,AuxPlugInUnit=2,RetuDeviceGroup=1,RetDeviceSet=1,RetDevice=1
			#      antennaSerialNumber=(String)"CQ30022937"
   			#   ManagedElement=1,Equipment=1,SectorAntenna=1,AuxPlugInUnit=RRUW-1
   			#   ManagedElement=1,Equipment=1,Subrack=2,Slot=10,PlugInUnit=1,TrxDeviceGroup=1,TrDeviceSet=1,TrDevice=1     (MCPA)
			#   ManagedElement=1,Equipment=1,SectorAntenna=1,AuxPlugInUnit=RRUW-1,RruDeviceGroup=1,TrDeviceSet=1,TrDevice=1
			#   ManagedElement=1,Equipment=1,RbsSubrack=RU1,RbsSlot=2,AuxPlugInUnit=1
			#   productName=(String)"FCU 31"
			#   serialNumber=(String)"AE53276449"
			#   ManagedElement=1,Equipment=1,RbsSubrack=RU1,RbsSlot=2,AuxPlugInUnit=1,RuDeviceGroup=1,TrDeviceSet=1,TrDevice=1
			#   ManagedElement=1,NodeBFunction=1,Sector=1,Carrier=1
			else if ($1 ~ /,AuxPlugInUnit=|,TrDevice=|,RetDevice=/) #($1 ~ /RbsSubrack=[^,]+,RbsSlot=[^,]+,AuxPlugInUnit=/)
			{
				currMo=make_short_ru($1)
				if ($1 ~ /,TrDevice=/) currFullMo=$1
			}
			else if ($1 ~ /serialNumber=|antennaSerialNumber=/)
			{
				split($0,array,"\"")
				ruSerialTable[gensub(/[ \t]/,"","g",array[2])]=currMo
			}
			else if ($1 == "ManagedElement=1") inManagedElement=1
			else if (inManagedElement==1 && $1 ~ /productNumber=/)
			{
				#we have read first the productNumber of ManagedElement because some times the node type is written there instead of in productName
				#this is only done on WCDMA RBS to find out if the node is RBS3000 or RBS6000
				#productNumber=(String)"BGM 1361006/2"
				split($0,array,"\"")
				gsub(" ","",array[2])
				if (tolower(array[2]) ~ /rbs *3[0-9][0-9][0-9]/) { is_3000=1 ; is_6000=0 }
				wrbsType=array[2]
			}
			else if ($1 ~ /productName=/)
			{
				#only the first instance of productName corresponds to the node type , read from ManagedElement
				#subsequent instances belong to AuxPlugInUnit
				split($0,array,"\"")
				gsub(" ","",array[2])
				if (inManagedElement==1)
				{
					#productName of ManagedElement, only taken on WCDMA
					is_wcdma=1 ; is_LTE=0
					if (tolower(array[2]) ~ /rbs *3[0-9][0-9][0-9]/) { is_3000=1 ; is_6000=0 }
					if (tolower(array[2]) ~ "rbs") wrbsType=array[2]
				}
				else
				{
					#productName of AuxPlugInUnit
					if (length(array[2])>len["auxboard"]) len["auxboard"]=length(array[2])
				}
				inManagedElement=0
			}
			else if ($1 ~ /,Carrier=/)
			{
				currSect="S"gensub(/^.*Sector=|,Carrier=.*$/,"","g",$1)"C"gensub(/^.*Carrier=/,"",1,$1)
				currMoList[currMo]=currMo
				currFullMoList[currFullMo]=currFullMo
				currSectList[currSect]=currSect
				ruCarrierTable[currMo,currSect]=1
				trCarrierTable[currFullMo,currSect]=1
			}
			#   deviceFroId=(int)404684808
			else if ($1 ~ /^deviceFroId/)
			{
				tmpfroid=gensub(/^.*\)/,"",1,$1)+0
				tmpfroid=sprintf("%X",strtonum(tmpfroid))  #181F0008
				y=split(tmpfroid,a,"")
				if (y==8) tmpfroid=a[3] a[4] a[7] a[8]
				else tmpfroid="?"
				trDeviceTable[tmpfroid]=currFullMo
			}
			#LTE NCLI up to L12 SectorEquipment->EUtranCell
			#   ManagedElement=1,Equipment=1,AuxPlugInUnit=RRU-1
			#      productName=(String)"RUS"
			#      serialNumber=(String)"C823883849"

			#   ManagedElement=1,SectorEquipmentFunction=1
			#   reservedBy=(Ref){
			#         ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=1
			#   ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=1
			#   reservedBy=(Ref){
			#         ManagedElement=1,SectorEquipmentFunction=1
			#   ManagedElement=1,Equipment=1,AuxPlugInUnit=RRU-1,DeviceGroup=ru,RfPort=A
			#   reservedBy=(Ref){
			#         ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=1
			#   ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=1
			#   physicalLayerCellIdGroup=(int)46
			#   ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=1
			#   physicalLayerSubCellId=(int)0
			#   ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=1
			#   cellId=(int)1

			#LTE NCLI from L13 SectorEquipment->SectorCarrier->EUtranCell

			#   ManagedElement=1,ENodeBFunction=1,SectorCarrier=1
			#   reservedBy=(Ref){
			#         ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=1
			#   ManagedElement=1,SectorEquipmentFunction=1
			#   reservedBy=(Ref){
			#         ManagedElement=1,ENodeBFunction=1,SectorCarrier=1
			#   ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=1
			#   reservedBy=(Ref){
			#         ManagedElement=1,SectorEquipmentFunction=1
			#   ManagedElement=1,Equipment=1,AuxPlugInUnit=RRU-1,DeviceGroup=ru,RfPort=A
			#   reservedBy=(Ref){
			#         ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=1
			#   ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=1
			#   physicalLayerCellIdGroup=(int)46
			#   ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=1
			#   physicalLayerSubCellId=(int)0
			#   ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=1
			#   cellId=(int)1

			#8TX RRUL81
			#productNumber=(String)"KRC 161 334/1"


			#NOT ACCEPTED
			#MemoryNotSufficientException: bytesToBeAllocated=1024. Free memory of the JVM=197100. Required free memory=204800

			if ($1=="LDN") { inLdn=1;inAttr=0 }
			else if ($1=="ATTRIBUTES") { inAttr=1;inLdn=0}
			else if (inLdn==1 && $1 ~ /^ManagedElement=1,/) currentMO=$1
			else if (inAttr==1 && $1 ~ /EUtranCell.DD=/) lteCells[currentMO]=lteCells[currentMO] SUBSEP $1
			else if (inAttr==1 && $1 ~ /SectorCarrier=/) lteCells[currentMO]=lteCells[currentMO] SUBSEP lteCells[$1]
			else if (inAttr==1 && $1 ~ /SectorEquipmentFunction=/) lteCells[currentMO]=lteCells[currentMO] SUBSEP ($1 in lteCells && lteCells[$1]!=""?lteCells[$1]:lteCells[lteCells[$1]])
			else if (inAttr==1 && $1 ~ /RfBranch=/) lteCells[make_short_ru(currentMO)]=lteCells[make_short_ru(currentMO)] SUBSEP lteCells[$1]
			else if ($1 ~ /^(physicalLayerCellIdGroup|physicalLayerSubCellId|cellId)=/) cellData[currentMO,gensub(/=.*$/,"",1,$1)]=gensub(/^.*\)/,"",1,$1)+0
			else if (/MemoryNotSufficientException/) ncli_error=$0
			else if (/productNumber=.String/)
			{
				split($0,array,/["]/)
				gsub(/ /,"",array[2])
				if (array[2] ~ rrul8Prod || array[2] ~ rru82Prod) TX8=1  #RRUL81 / RRUx82
				else if (array[2] ~ rrus6Prod) TX6=1   #RR22F3
				else if (array[2] ~ rrus2Prod) {}      #RR22F1
				else if (array[2] ~ rrus4Prod) TX4=1   #RRUS31 RR22F2

			}
			else if (/productName=.String/)
			{
				split($0,array,/["]/)
				gsub(/ /,"",array[2])
				if (array[2] ~ rrul8Name || array[2] ~ rru82Name) TX8=1
				else if (array[2] ~ rrus6Name) TX6=1
				else if (array[2] ~ rrus2Name) {}   #2 TX ODM RR22F1 , also belongs to rrus4Name
				else if (array[2] ~ rrus4Name) TX4=1
			}
		}
		close(cabhwinfofile)
		y=asort(currSectList)
		for (j in currMoList)
		{
			for (i=1;i<=y;i++)
			{
				if ((j,currSectList[i]) in ruCarrierTable)
				{
					ruCarrierTable[j]=ruCarrierTable[j] currSectList[i]" "
					if (length(j) > len["carrRu"]) len["carrRu"]=length(j)
				}
			}
		}
		for (j in currFullMoList)
		{
			for (i=1;i<=y;i++)
			{
				if ((j ~ /TrDevice=/) && ((j,currSectList[i]) in trCarrierTable))
				{
					trCarrierTable[j]=trCarrierTable[j]" "currSectList[i]
					sub(/^ /,"",trCarrierTable[j])
					if (length(trCarrierTable[j]) > len["carrTr"]) len["carrTr"]=length(trCarrierTable[j])
				}
			}
		}
		trdevfile=tempdir"/trdev.awk"
		close(trdevfile)
		print "BEGIN{" > trdevfile
		for (j in trDeviceTable)
		{
			if (j !~ /^[0-9A-F][0-9A-F][0-9A-F][0-9A-F]$/) continue
			trCarrierTable[j]=trCarrierTable[trDeviceTable[j]]
			printf("trCarrierTable[\"%s\"]=\"%s\"\n",j,trCarrierTable[j]) >> trdevfile
		}
		#Now we have the table below, giving the mapping of Tr Device to Cell
		#In the example below we can see that the Cell S2C1 has 4 RX branches and the other cells have 2 RX branches
		#trCarrierTable[0B01]=S1C1
		#trCarrierTable[0F01]=S1C1
		#trCarrierTable[0B02]=S1C1
		#trCarrierTable[0F04]=S1C2
		#trCarrierTable[0F03]=S1C2
		#trCarrierTable[0B03]=S1C2
		#trCarrierTable[1702]=S2C1
		#trCarrierTable[1701]=S2C1
		#trCarrierTable[1301]=S2C1
		#trCarrierTable[1302]=S2C1
		#trCarrierTable[1B01]=S3C1
		#trCarrierTable[1B02]=S3C1
		#trCarrierTable[1F04]=S3C2
		#trCarrierTable[1F03]=S3C2

		#we will make a table like this, where the list of tr values are sorted in ascending order
		#carrierTrList[S2C1]=1301,1302,1701,1702
		for (j in trCarrierTable)
		{
			if (j !~ /^[0-9A-F][0-9A-F][0-9A-F][0-9A-F]$/ || trCarrierTable[j] == "") continue
			carrierList[trCarrierTable[j]]=trCarrierTable[j]
			carrierTrList[trCarrierTable[j]]=carrierTrList[trCarrierTable[j]]","j
			sub(/^,/,"",carrierTrList[trCarrierTable[j]])
		}
		sortCabTable(carrierTrList,sorted_carrierTrList,"countRx")
		for (j in sorted_carrierTrList) printf("sorted_carrierTrList[\"%s\"]=\"%s\"\n",j,sorted_carrierTrList[j]) >> trdevfile
		print "}" >> trdevfile
		close(trdevfile)
		if (mosdebug==1)
		{
			printCabTable(ruSerialTable,"ruSerialTable")
			printCabTable(ruCarrierTable,"ruCarrierTable")
			printCabTable(trCarrierTable,"trCarrierTable")
			printCabTable(trDeviceTable,"trDeviceTable")
			printCabTable(carrierList,"carrierList")
			printCabTable(carrierTrList,"carrierTrList")
			printCabTable(sorted_carrierTrList,"sorted_carrierTrList")
			printCabTable(lteCells,"lteCells")
		}
		if (foundmp!=1) fileOps("rm "cabhwinfofile)  #there was a problem taking the printout, we remove the file so it will be taken again
	}
	#Summary:
	#The attribute ManagedElement::productName is read on WRBS only (in prog.awk, we look at the MOM version to know if WRBS or ERBS)
	#If this attribute is there then it is a WRBS, if not and there is a DUL, then ERBS
	#From this attribute we can also tell if it is RBS6000 or RBS3000

	#We must have this in case it is a ENB with DUS:
	if (is_6000==1 && is_wcdma!=1) is_LTE=1

	howoften=100
	redlimit=90
	purplelimit=80
	tmp_sp_load="   ?"
	funcs=sprintf("%s/funcs.awk",moshelldir)
	telnet_session=enter_telnet_login(node_address,node_password)
	if (telnet_session ~ /Unable to connect|Wrong Password/)
	{
		customPrint(telnet_session)
		exit 1
	}
	#if (evo_node) pdr_command="csti topology" ; else pdr_command="pdr"
	pdr_command="csti info\ncsti topology\npdr"
	if (fileOps("test -s "cabhwinfofile)==0) print pdr_command"\necho \"EndOfPrint\"" |& telnet_session
	else print "arm print\n"pdr_command"\necho \"EndOfPrint\"" |& telnet_session
	while ((telnet_session |& getline)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		show_progress(howoften)
		if (/(^|[^"])EndOfPrint$/) break
		process_pdr_line()
	}
	nr_core_MPs=0
	for (i in cab_core_mp_list) nr_core_MPs++
	ls_subrack_command=""
	print "listObj subrack\necho \"EndOfPrint\"" |& telnet_session
	while ((telnet_session |& getline)>0)
	{
	     gsub("\r","") ; gsub("\x00","") ; gsub(/^( *\$ *)+/,"")
	     show_progress(howoften)
	     if (/(^|[^"])EndOfPrint$/) break
	     if($0 ~ /^Sr Id/) ls_subrack_command=sprintf("%sgetAttrObj subrack %d\n", ls_subrack_command, $3)
	}
	print ls_subrack_command"\necho \"EndOfPrint\"" |& telnet_session
	while ((telnet_session |& getline)>0)
	{
		gsub("\r","") ; gsub("\x00","") ; gsub(/^( *\$ *)+/,"")
		show_progress(howoften)
		if (/(^|[^"])EndOfPrint$/) break
		if($0 ~ / *Subrack Number/)
		{
			tmp_smn = $3
			if(smn_list[tmp_smn] == 1) continue # Skip known subracks
		}
		if($0 ~ /Product[ \t]*Name[ \t]*CAS2/)
		{
			smn_list[tmp_smn]=1
		}
		else if($0 ~ /Transmission[ \t]*Type[ \t]*4/)
		{
			evo_node=1
		}
	}
	for (i in board)
	{
		if (mosdebug==1) print "board["gensub(SUBSEP,",",1,i)"]="board[i]
		number_of_boards++
	}
	if (is_6000==1 || is_3000==1 || cpplinux==1)
	{
		print "getAttrObj me\necho \"EndOfPrint\"" |& telnet_session
		while ((telnet_session |& getline)>0)
		{
			gsub("\r","") ; gsub("\x00","") ; gsub(/^( *\$ *)+/,"")
			show_progress(howoften)
			if (/(^|[^"])EndOfPrint$/) break
			#Piu Group Escalation Type: 4
			#Logical Name: HXU0026
			#Product Name: RBS3206
			#Product Name: RBS 6501
			#Product No  : 11/COH1092069
			#Product Rev : -
			#Site        : HXU0026
			#cVolFreeLim : 20 Mb
			#FTC State   : PiuId 1 on Slot 1 has cmState PassiveReady
			#              PiuId 8 on Slot 2 has cmState Active
			if (is_LTE==1 && $1=="Product" && $2=="Name:") erbsType=gensub(/^Product Name: *| /,"","g",$0)
			#on RBS with single core MP the "mirror s" command does not always work
			else if (/has cmState Active/)
			{
				ftc[0,$(NF-3)+0]="Active"
				sysMgr=sprintf("%s,%s",0,$(NF-3)+0)
			}
			else if (/has cmState /)
			{
				sysMgrSB=sprintf("%s,%s",0,$(NF-3)+0)
				sbStatus=$NF
			}
		}
	}


	if (number_of_boards > fast_cab_threshold)
	{
                print "exit" |& telnet_session
                while ((telnet_session |& getline)>0) {}
		close(telnet_session)
		fileOps("rm "commandfile)
		localcommandfile=sprintf("%s/%s",nodetempdir,gensub(/^.*\//,"","g",commandfile))
		printf("echo \n") >> commandfile
	}
	for (i=0;i<=99;i++)
	{
		if (smn_list[i] != 1) continue
		if ((check_hw==1 && evo_node)||(check_hw==2))
		{
			if (number_of_boards > fast_cab_threshold)  printf("\
echo \"LOGGING INTO BOARD: %s 1\"\ngetAttrObj piu -d %02d0100\ngetAttrObj slot -d %02d0100\n\
echo \"LOGGING INTO BOARD: %s 2\"\ngetAttrObj piu -d %02d0200\ngetAttrObj slot -d %02d0200\n\
echo \"LOGGING INTO BOARD: %s 3\"\ngetAttrObj piu -d %02d0300\ngetAttrObj slot -d %02d0300\n\
echo \"LOGGING INTO BOARD: %s 4\"\ngetAttrObj piu -d %02d0400\ngetAttrObj slot -d %02d0400\n\
echo \"LOGGING INTO BOARD: %s 6\"\ngetAttrObj piu -d %02d0600\ngetAttrObj slot -d %02d0600\n\
echo \"LOGGING INTO BOARD: %s 26\"\ngetAttrObj piu -d %02d2600\ngetAttrObj slot -d %02d2600\n\
echo \"LOGGING INTO BOARD: %s 27\"\ngetAttrObj piu -d %02d2700\ngetAttrObj slot -d %02d2700\n\
echo \"LOGGING INTO BOARD: %s 28\"\ngetAttrObj piu -d %02d2800\ngetAttrObj slot -d %02d2800\n",
i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i) >> commandfile
			else
			{
				for (j=1;j<=28;j++)
				{
					if (j==5) j=6
					if (j==7) j=26
					printf("getAttrObj piu -d %02d%02d00\ngetAttrObj slot -d %02d%02d00\necho \"EndOfPrint\"\n",i,j,i,j) |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						gsub("\r","") ; gsub("\x00","")
						gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
						show_progress(howoften)
						cabres=parseCabLine()
						if (cabres ~ /^(break|timeout)$/) break
					}
					if (cabres=="timeout")
					{
						customPrint("Timeout, reconnecting...")
						usleep(1000000)
						cabres=""
						close(telnet_session)
						telnet_session=enter_telnet_login(node_address,node_password)
						if (telnet_session ~ /Unable to connect|Wrong Password/)
						{
							customPrint(telnet_session)
							exit 1
						}
					}
				}
			}
		}
		for (j=0;j<=28;j++)
		{
			if (board[i,j]<=0) continue
			if (number_of_boards > fast_cab_threshold)
			{
				#VERY IMPORTANT: llog command must be sent LAST, just before the stopline ("endofprint")
				if (board[i,j] == 1)
				{
					printf("echo \"LOGGING INTO BOARD: %s %s\"\n",i,j) >> commandfile
					if (check_hw == 1)
					{
						if (evo_node) printf("getAttrObj piu -d %02d%02d00\ngetAttrObj slot -d %02d%02d00\n",i,j,i,j) >> commandfile
						else printf("getAttrObj slot -d %02d%02d00\nlhsh %02d%02d00 pboot sh par\nlhsh %02d%02d00 ps port*\nlhsh %02d%02d00 vii\nlhsh %02d%02d00 ps BXP_*\n",i,j,i,j,i,j,i,j,i,j) >> commandfile
					}
					else if (check_hw == 2) printf("getAttrObj slot -d %02d%02d00\nlhsh %02d%02d00 pboot sh par\n",i,j,i,j) >> commandfile
					if (check_sw == 1) printf("lhsh %02d%02d00 listloaded\n",i,j) >> commandfile
					if (check_te == 1) printf("echo SavedTraces:\nlhsh %02d%02d00 te s -restart\necho EnabledTraces:\nlhsh %02d%02d00 te s\n",i,j,i,j) >> commandfile
					if (check_mem== 1) printf("lhsh %02d%02d00 mm%s\n",i,j,(ose_version>="5"?" -p":"u"))        >> commandfile
					if (check_load == 1) printf("lhsh %02d%02d00 capi prio\n",i,j) >> commandfile
					if (check_vols == 1 && ((i,j) in mpList)) printf("lhsh %02d%02d00 ls -l /d/loadmodules\nlhsh %02d%02d00 vols\n",i,j,i,j)     >> commandfile
					if (check_f == 1 && (!((i,j) in mpList))) printf("lhsh %02d%02d00 vols\n",i,j) >> commandfile
					if (check_hw == 1 && i==0) printf("lhsh %02d%02d00 mirror s\n",i,j)   >> commandfile
					if (check_dumpelg == 1) printf("lhsh %02d%02d00 dumpelg\n",i,j)  >> commandfile
					if (check_llog == 1)
					{
						printf("lhsh %02d%02d00 llog -l\n",i,j)  >> commandfile
						if (productname[i,j] ~ /^EPB/) printf("lhsh %02d%02d00/d00001 llog -l\n",i,j)  >> commandfile
					}
					printf("echo \"EndOfBoardPrint\"\n") >> commandfile
				}
				else if (board[i,j]==2)
				{
					printf("echo \"LOGGING INTO BOARD: %s %s\"\n",i,j) >> commandfile
					if (check_hw == 1)
					{
						if (evo_node) printf("getAttrObj piu -d %02d%02d00\ngetAttrObj slot -d %02d%02d00\n",i,j,i,j) >> commandfile
						else printf("getAttrObj slot -d %02d%02d00\npboot sh par\nps port*\nvii\nps BXP_*\n",i,j) >> commandfile
					}
					else if (check_hw == 2) printf("getAttrObj slot -d %02d%02d00\npboot sh par\n",i,j) >> commandfile
					if (check_sw == 1) printf("listloaded\n")     >> commandfile
					if (check_te == 1) printf("echo SavedTraces:\nte s -restart\necho EnabledTraces:\nte s\n")     >> commandfile
					if (check_mem== 1) printf("mm%s\n",(ose_version>="5"?" -p":"u"))  >> commandfile
					if (check_load == 1) printf("capi prio\n")     >> commandfile
					if (check_vols == 1) printf("ls -l /d/loadmodules\nvols\n")         >> commandfile
					if (check_hw == 1) printf("mirror s\nwho\n")  >> commandfile
					if (check_dumpelg == 1) printf("dumpelg\n")   >> commandfile
					if (check_llog == 1)
					{
						printf("llog -l\n")      >> commandfile
						if (productname[i,j] ~ /^EPB/) printf("lhsh d00001 llog -l\n")  >> commandfile
					}
					printf("echo \"EndOfBoardPrint\"\n")  >> commandfile
				}
			}
			else
			{
				#VERY IMPORTANT: llog command must be sent LAST, just before stopline
				if (board[i,j] == 1)
				{
					if (check_hw == 1)
					{
						if (evo_node) printf("getAttrObj piu -d %02d%02d00\ngetAttrObj slot -d %02d%02d00\n",i,j,i,j) |& telnet_session
						else printf("getAttrObj slot -d %02d%02d00\nlhsh %02d%02d00 pboot sh par\nlhsh %02d%02d00 ps port*\nlhsh %02d%02d00 vii\nlhsh %02d%02d00 ps BXP_*\n",i,j,i,j,i,j,i,j,i,j) |& telnet_session
					}
					else if (check_hw == 2) printf("getAttrObj slot -d %02d%02d00\nlhsh %02d%02d00 pboot sh par\n",i,j,i,j) |& telnet_session
					if (check_sw == 1) printf("lhsh %02d%02d00 listloaded\n",i,j) |& telnet_session
					if (check_te == 1) printf("echo SavedTraces:\nlhsh %02d%02d00 te s -restart\necho EnabledTraces:\nlhsh %02d%02d00 te s\n",i,j,i,j) |& telnet_session
					if (check_mem== 1) printf("lhsh %02d%02d00 mm%s\n",i,j,(ose_version>="5"?" -p":"u"))  |& telnet_session
					if (check_load == 1) printf("lhsh %02d%02d00 capi prio\n",i,j) |& telnet_session
					if (check_vols == 1 && ((i,j) in mpList)) printf("lhsh %02d%02d00 ls -l /d/loadmodules\nlhsh %02d%02d00 vols\n",i,j,i,j)     |& telnet_session
					if (check_f == 1 && (!((i,j) in mpList))) printf("lhsh %02d%02d00 vols\n",i,j) |& telnet_session
					if (check_hw == 1 && i==0) printf("lhsh %02d%02d00 mirror s\n",i,j)    |& telnet_session
					if (check_dumpelg == 1) printf("lhsh %02d%02d00 dumpelg\n",i,j)  |& telnet_session
					if (check_llog == 1)
					{
						printf("lhsh %02d%02d00 llog -l\n",i,j)  |& telnet_session
						if (productname[i,j] ~ /^EPB/) printf("lhsh %02d%02d00/d00001 llog -l\n",i,j)  |& telnet_session
					}
					printf("echo \"EndOfPrint\"\n") |& telnet_session
				}
				else if (board[i,j]==2)
				{
					if (check_hw == 1)
					{
						if (evo_node) printf("getAttrObj piu -d %02d%02d00\ngetAttrObj slot -d %02d%02d00\n",i,j,i,j) |& telnet_session
						else printf("getAttrObj slot -d %02d%02d00\npboot sh par\nps port*\nvii\nps BXP_*\n",i,j) |& telnet_session
					}
					else if (check_hw == 2) printf("getAttrObj slot -d %02d%02d00\npboot sh par\n",i,j) |& telnet_session
					if (check_sw == 1) printf("listloaded\n")     |& telnet_session
					if (check_te == 1) printf("echo SavedTraces:\nte s -restart\necho EnabledTraces:\nte s\n")     |& telnet_session
					if (check_mem== 1) printf("mm%s\n",(ose_version>="5"?" -p":"u"))  |& telnet_session
					if (check_load == 1) printf("capi prio\n")     |& telnet_session
					if (check_vols == 1) printf("ls -l /d/loadmodules\nvols\n")         |& telnet_session
					if (check_hw == 1) printf("mirror s\nwho\n")  |& telnet_session
					if (check_dumpelg == 1) printf("dumpelg\n")      |& telnet_session
					if (check_llog == 1)
					{
						printf("llog -l\n")      |& telnet_session
						if (productname[i,j] ~ /^EPB/) printf("lhsh d00001 llog -l\n")  |& telnet_session
					}
					printf("echo \"EndOfPrint\"\n") |& telnet_session
				}
				while ((telnet_session |& getline)>0)
				{
					gsub("\r","") ; gsub("\x00","") ;
					gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
					show_progress(howoften)
					cabres=parseCabLine()
					if (cabres ~ /^(break|timeout)$/) break
				}
				if (cabres=="timeout")
				{
					customPrint("Timeout, reconnecting...")
					usleep(1000000)
					cabres=""
					close(telnet_session)
					telnet_session=enter_telnet_login(node_address,node_password)
					if (telnet_session ~ /Unable to connect|Wrong Password/)
					{
						customPrint(telnet_session)
						exit 1
					}
				}
			}
		}
	}
	if (number_of_boards > fast_cab_threshold)
	{
		close(commandfile)
		if (ftpclient(node_address,node_password,sprintf("put %s %s",commandfile,localcommandfile)) !=0) exit 1
		if (mosdebug==1) system("cat "commandfile)
		fileOps("rm "commandfile)
		telnet_session=enter_telnet_login(node_address,node_password)
		if (telnet_session ~ /Unable to connect|Wrong Password/)
		{
			customPrint(telnet_session)
			exit 1
		}
		else printf("%s %s\necho \"EndOfPrint\"\n",coliMap("shell -f"),localcommandfile) |& telnet_session
		while ((telnet_session |& getline)>0)
		{
			gsub("\r","") ; gsub("\x00","")
			gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
			show_progress(howoften)
			cabres=parseCabLine()
			if (cabres ~ /^(break|timeout)$/) break
		}
		if (cabres=="timeout")
		{
			customPrint("Timeout, reconnecting...")
			usleep(1000000)
			cabres=""
			close(telnet_session)
			telnet_session=enter_telnet_login(node_address,node_password)
			if (telnet_session ~ /Unable to connect|Wrong Password/)
			{
				customPrint(telnet_session)
				exit 1
			}
		}
		printf("rm -f %s\n",localcommandfile) |& telnet_session
	}
	if (check_llog==1)
	{
		for (i=0;i<=99;i++)
		{
			if (smn_list[i]!=1) continue
			for (j=0;j<=27;j++)
			{
				if (board[i,j]<=0) continue
				for (r=1;r<=rMax[i,j];r++) if (restartError[i,j,r] != "" && restartCause[i,j,r]=="") rerunLlog[i,j]=1
			}
		}
	}
	if (check_load==1)
	{
		#check if the SPB uses sp procload or capi prio
		spcapi=1
		for (z in productname)
		{
			if (productname[z] ~ /^SPB($|[2-3])/)
			{
				split(z,array,SUBSEP)
				i=array[1] ; j=array[2]
				printf("spp -p %02d%02d00/sp0.lnh sp procload 1\nspp -p %02d%02d00/sp1.lnh sp procload 1\nspp -p %02d%02d00/sp2.lnh sp procload 1\n",i,j,i,j,i,j) |& telnet_session
				printf("echo \"EndOfPrint\"\n") |& telnet_session
				while ((telnet_session |& getline)>0)
				{
					gsub("\r","") ; gsub("\x00","") ; sub(/^\$/,"") ;
					gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
					show_progress(howoften)
					if (/(^|[^"])EndOfPrint$/) break
					if (/Unknown command procload/) spcapi=1
					else if (/Total processor load/) spcapi=0
				}
				break
			}
		}
	}

	for (i=0;i<=99;i++)
	{
		if (smn_list[i]!=1) continue
		for (j=0;j<=27;j++)
		{
			curcore=-1
			if (productname[i,j] ~ /^([GE]PB|CBU|S.B|MSB|DU[WLS]|ET-?IPG|OD[WS]|EVOET|CETB)/ && notemp==0 && check_hw==1)
			{
				if (productname[i,j] ~ /^MSB/) printf("lhsh %02d%02d00 temprt\nlhsh %02d%02d00 cmpp temprt\n",i,j,i,j) |& telnet_session
				else if (productname[i,j] ~ /^(GPB[2-3])/) printf("lhsh %02d%02d00 ppctemp\n",i,j) |& telnet_session
				else if (productname[i,j] ~ /^([GE]PB|CBU|S.B|ET-?IPG|EVOET|CETB)/) printf("lhsh %02d%02d00 boardtemp\n",i,j) |& telnet_session
				#old moshell versions
				#else if (productname[i,j] ~ /^(DUW|ODW)/)
				#{
				#	printf("lhsh %02d%02d00 te e bus_send bus_receive CBCI_DUI\nlhsh %02d%02d00 te e trace1 supSysCtrlClimate\n",i,j,i,j) |& telnet_session
				#	usleep(8000000)
				#	printf("lhsh %02d%02d00 te log read 20\nlhsh %02d%02d00 te d bus_send bus_receive CBCI_DUI\nlhsh %02d%02d00 te d trace1 supSysCtrlClimate\n",i,j,i,j,i,j) |& telnet_session
				#}
				#else if (productname[i,j] ~ /^DU[LS]/)
				#{
				#	printf("lhsh %02d%02d00 te e trace5 nciCommonTemp\nlhsh %02d%02d00 te e trace1 supSysCtrlClimate\n",i,j,i,j) |& telnet_session
				#	usleep(8000000)
				#	printf("lhsh %02d%02d00 te log read 20\nlhsh %02d%02d00 te d trace5 nciCommonTemp\nlhsh %02d%02d00 te d trace1 supSysCtrlClimate\n",i,j,i,j,i,j) |& telnet_session
				#}
				#up to moshell 9.0w :
				#else if (productname[i,j] ~ /^(DU|OD)/)
				#{
				#	printf("lhsh %02d%02d00 te e bus_send SRI_MP_IF\nlhsh %02d%02d00 te e trace5 NCI_COMMON\nlhsh %02d%02d00 te e trace1 supSysCtrlClimate\n",i,j,i,j,i,j) |& telnet_session
				#	usleep(8000000)
				#	printf("lhsh %02d%02d00 te log read 20\nlhsh %02d%02d00 te d bus_send SRI_MP_IF\nlhsh %02d%02d00 te d trace5 NCI_COMMON\nlhsh %02d%02d00 te d trace1 supSysCtrlClimate\n",i,j,i,j,i,j,i,j) |& telnet_session
				#}
				#from moshell 9.0y :
				else if (productname[i,j] ~ /^(DU|OD)/)
				{
					#mapping of sensor number to hex value can be found from the command  dbvl
					# On DUWv2 (DUW11/31/41) hotspot is on sensor 1 and has address 0x4d
					# On DUWv1 (DUW10/30/40) hotspot is on sensor 3 and has address 0x4b
					#Note: on DUWv2 the temperature is now read with the command readPower instead of the trace
					if (productname[i,j] ~ /W.1/) hotSpotSensor=1
					else if (productname[i,j] ~ "W") hotSpotSensor=3  #"0x4B" #DUW10/20/30 , ODW, and unknown DUW types : sensor 3
					else if (productname[i,j] ~ "S") hotSpotSensor=1   #DUS31/41/ODS11/ODS41
					else hotSpotSensor=0 #DUL
					#Elisabeth Larsson trace5 NCI_COMMON sensor1 fr LTE, trace4 SriBcThread fr WCDMA
					#Fr DUL20/21 s r hotspotsensorn sensor0
					#Fr DUS31/41/ODS s r hotspotsensorn sensor1
					#Fr DUW10/20/30 s r hotspotsensorn sensor3 (0x4B)
					#Fr DUW11/31/41 s r hotspotsensorn sensor1 (0x49)

					#Try first to read the temperature via the boardtemp/readPower command and if it does not work, then use the traces
					boardtempok=0
					readpowerok=0
					printf("lhsh -v %02d%02d00 boardtemp\n",i,j) |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						#Sensor 1: Temp 38 (38) DegC: Status: 0 Limits: 90 85 0 -5 hotspot
						#rcmd to OSE: 'boardtemp' returned with status 0, errno 0
						#rcmd: unknown command 'boardtemp'
						#rcmd: failed to connect to 000100
						show_progress(howoften)
						if (/^rcmd:| returned with status .*, errno |unknown command|failed to connect/) break
						#Sensor 0: Temp 34 (34) DegC: Status: 0 Address: 0x49 Limits: 70 65 0 -5 hotspot
						#Sensor 1: Temp 33 (33) DegC: Status: 0 Address: 0x48 Limits: 90 85 0 -5
						else if ($1=="Sensor") boardtempok=1
					}
					printf("lhsh -v %02d%02d00 readPower\n",i,j) |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						#2015-07-01 14:59:06 Power consumption is  91.821 W, Temp: 44 50 39 38
						#rcmd to OSE: 'readPower' returned with status 0, errno 0
						#rcmd: unknown command 'readPower'
						#rcmd: failed to connect to 000100
						show_progress(howoften)
						if (/^rcmd:| returned with status .*, errno |unknown command|failed to connect/) break
						else if ($8=="Temp:") readpowerok=1
					}
					if (boardtempok==1) printf("lhsh %02d%02d00 boardtemp\n",i,j) |& telnet_session
					else if (readpowerok==1) printf("lhsh %02d%02d00 readPower\n",i,j) |& telnet_session
					else
					{
						printf("lhsh %02d%02d00 te e trace4 SriBcThread\nlhsh %02d%02d00 te e trace5 NCI_COMMON\n",i,j,i,j) |& telnet_session
						usleep(8000000)
						printf("lhsh %02d%02d00 te log read 20\nlhsh %02d%02d00 te d trace4 SriBcThread\nlhsh %02d%02d00 te d trace5 NCI_COMMON\n",i,j,i,j,i,j) |& telnet_session
					}
				}
				#else printf("lhsh %02d%02d00 ppctemp\n",i,j) |& telnet_session
				command_printed[i,j]=1
			}
			if ((check_load == 1)&&(rerun[i,j]==1))
			{
				if (productname[i,j]~/^SPB[4-]/ || productnumber[i,j]~/^ROJ ?119 ?2403.1$/)
				{
					printf("lhsh %02d%02d00/d00001 capi core all\nlhsh %02d%02d00/d00002 capi core all\nlhsh %02d%02d00/d00003 capi core all\n",i,j,i,j,i,j) |& telnet_session
				}
				else
				{
					if (productname[i,j]~/^SPB/)
					{
						if (spcapi) printf("lhsh %02d%02d00/sp0.lnh capi prio\nlhsh %02d%02d00/sp1.lnh capi prio\nlhsh %02d%02d00/sp2.lnh capi prio\n",i,j,i,j,i,j) |& telnet_session
						else printf("spp -p %02d%02d00/sp0.lnh sp procload 1\nspp -p %02d%02d00/sp1.lnh sp procload 1\nspp -p %02d%02d00/sp2.lnh sp procload 1\n",i,j,i,j,i,j) |& telnet_session
					}
					if (productname[i,j]~/^SPB[23]/ || productnumber[i,j]~/^ROJ ?119 ?2103.5$/)
					{
						if (spcapi) printf("lhsh %02d%02d00/sp3.lnh capi prio\nlhsh %02d%02d00/sp4.lnh capi prio\n",i,j,i,j) |& telnet_session
						else printf("spp -p %02d%02d00/sp3.lnh sp procload 1\nspp -p %02d%02d00/sp4.lnh sp procload 1\n",i,j,i,j) |& telnet_session
					}
				}
				command_printed[i,j]=1
			}
			if (check_llog==1 && rerunLlog[i,j]==1)
			{
				rMax[i,j]=0
				if (board[i,j]==1) printf("lhsh %02d%02d00 llog\n",i,j) |& telnet_session
				else if (board[i,j]==2) printf("llog\n") |& telnet_session
				command_printed[i,j]=1
			}
			if ((check_load==1) && ((productname[i,j] ~ /^GPB/ && productnumber[i,j] ~ /\/[7-9]/) || (productname[i,j] ~ /^EPB/)))
			{
				#we run the command a first time to trigger the measurement
				printf("lhsh %02d%02d00 capi core all\n",i,j) |& telnet_session
				if (productname[i,j] ~ /^EPB/) printf("lhsh %02d%02d00/d00001 capi core all\n",i,j) |& telnet_session
				#then wait a second
				usleep(1000000)
				#we run the command a second time since the first time it only shows 1 measurement
				printf("lhsh %02d%02d00 capi core all\n",i,j) |& telnet_session
				if (productname[i,j] ~ /^EPB/) printf("echo \"EPB device load\"\nlhsh %02d%02d00/d00001 capi core all\n",i,j) |& telnet_session
				command_printed[i,j]=1
			}
			if (command_printed[i,j]==1)
			{
				#if (mosdebug==1) print "hotSpotSensor="hotSpotSensor
				printf("echo \"EndOfPrint\"\n") |& telnet_session
				while ((telnet_session |& getline)>0)
				{
					gsub("\r","") ; gsub("\x00","") ; gsub(/^( *\$ *)+/,"") ;
					gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
					show_progress(howoften)
					#ppctemp: PowerPC 750 chip temperature: +29C
					#ppctemp: PowerPC chip temperature: +29C
					#boardtemp: Board temperature: 30 Celsius on sensor: 0
					#boardtemp: Board temperature: 58 Celsius on sensor: 4
					#boardtemp: Read of board temperature failed
					#boardtemp: Board temperature on sensor 2: 36 degrees Celsius
					#boardtemp: Board highest temperature:  82 Celsius on sensor: 2 MCM0_die
					#boardtemp: Alarm limit: 95 degrees Celsius. Alarm cease limit: 85 degrees Celsius
					#MSB3 temprt old format:
					#Sensor: 1.(UP): 34 C     2.(BOT): 31 C     3.(MID): 36 C
					#MSB3 temprt new format:
					#Sensor No:              1(UP)     2 (C)    3 (BOT)
					#Temperature [C]:         30       25      29
					#MSB4 cmpp temprt:
					#Carrier temperature (mother board)
					#sensor              temperature(C)
					#0                    34
					#1                    37
					#2                    27
					#dbc3tvs: Core temperature = 54 C (4 ms)
					#CPU load report on Core 0
					#Load (%)     43  44  46  47  44  47  47  50  46  48
					#bg           17   17   16   18   17   18   17   18   18   17
					#Core 0      1   1   1   1   1   1   1   1   1   1
					#Core 7      0   0   0   0   0   0   0   0   0   0
					if (/(^|[^"])EndOfPrint$/) break
					else if (/(^|[^"])EPB device load/)
					{
						j=j"d00001"
						productname[i,j]="EPB"
					}
					else if (/Board highest temperature:/) temp[i,j]="+"$4"C"
					else if ($3 ~ "temperature:" || $4 ~ "temperature:") temp[i,j]=$NF
					else if ($2 ~ "temperature" && $3  ~ /^[0-9]+$/) temp[i,j]="+"$3"C"
					else if ($2 ~ "temperature" && $4  ~ /^[0-9]+$/) temp[i,j]="+"$4"C"
					else if ($2 ~ "temperature" && $6  ~ /^[0-9]+$/) temp[i,j]="+"$6"C"
					else if (/Read of board temperature failed/) temp[i,j]="?"
					else if ($1 ~ "Sensor:" && $(NF-1) ~ /^[0-9]+$/) temp[i,j]="+"$(NF-1)"C"
					else if ($1=="CPU" && $2=="load" && $5=="Core") curcore=$NF+0
					else if ($1 == "Load" || ($1=="Core" && $2~/^[0-7]$/ && NF==12))
					{
						if ($1=="Core" && $2~/^[0-7]$/ && NF==12) curcore=$2+0
						avgload=sprintf("%4.1f",($3+$4+$5+$6+$7+$8+$9+$10+$11+$12)/10)
						#print i,j,productname[i,j],curcore,avgload":     "$0
						if (curcore==-1) AverageLoad[i,j]=avgload
						else if (productname[i,j]~/^SPB/ && curcore==0) SpProcessorLoad[i,j]=SpProcessorLoad[i,j]" "avgload
						else if (productname[i,j]~/^SPB/ && curcore==1) SpProcessorLoad[i,j]=SpProcessorLoad[i,j]"/"gensub(/^ */,"",1,avgload)
						else if (productname[i,j]~/^GPB/ && curcore==0) SpProcessorLoad[i,j]=" "avgload
						else if (productname[i,j]~/^GPB/ && curcore==1)
						{
							AverageLoad[i,j]=sprintf("%4.1f",(SpProcessorLoad[i,j]+avgload)/2)
							SpProcessorLoad[i,j]=SpProcessorLoad[i,j]" "avgload
						}
						else if (productname[i,j]~/^EPB/)
						{
							if (curcore==0) SpProcessorLoad[i,j]=" "avgload
							else if (curcore > 0)
							{
								AverageLoad[i,j]=sprintf("%4.1f",(SpProcessorLoad[i,j]+avgload)/2)
								SpProcessorLoad[i,j]=SpProcessorLoad[i,j]" "avgload
							}
						}
					}
					else if (/^Total processor load += /) tmp_sp_load=sprintf("%4.1f",gensub(/%/,"",1,$5))
					else if (/^Command executed|Unable to contact target: [0-9]+.sp..lnh/)
					{
						SpProcessorLoad[i,j]=SpProcessorLoad[i,j]" "tmp_sp_load
						tmp_sp_load="   ?"
					}
					else if ($1=="bg") tmp_sp_load=sprintf("%4.1f",100-($2+$3+$4+$5+$6+$7+$8+$9+$10+$11)/10)
					else if ($1=="pri30" || /: failed to connect to [0-9]+.sp..lnh/)
					{
						SpProcessorLoad[i,j]=SpProcessorLoad[i,j]" "tmp_sp_load
						tmp_sp_load="   ?"
					}
					else if ($1 ~ /^[0-9]+\.$/)
					{
						rMax[i,j]++
						restartCauseShort[i,j,rMax[i,j]]=gensub(/^.*0x.*\([0-2]\) /,"","g",$0)
					}
					else if (/Alarm limit: /)
					{
						alarmLimit[productname[i,j]]=sprintf("%-10s  %s",productname[i,j]":",$0)
					}
					# #DUL/DUS
					# #[2013-04-10 03:18:28.927] [00]nciCommonTemp(NCI_COMMON) nci_fault.c:3414 TRACE5:readTemperature: Board Temperature = 37 degrees celsius at sensor 0
					# #[2013-04-10 03:18:29.633] [00]nciCommon(NCI_COMMON) nci_fault.c:3516 TRACE5:checkTemperature: sensor: 0 ,lastReadTemp[&d] = 37
					# #[2013-04-10 03:22:48.728] nciCommonTemp(NCI_COMMON) nci_fault.c:3422 TRACE5:readTemperature: Board Temperature = 33 degrees celsius at sensor 0
					# #[2013-04-10 03:22:48.728] nciCommonTemp(NCI_COMMON) nci_fault.c:3422 TRACE5:readTemperature: Board Temperature = 30 degrees celsius at sensor 1
					# #[2013-03-11 07:00:09.026] [00]nciCommon(NCI_COMMON) nci_fault.c:3378 TRACE5:checkTemperature: checkTemperature: Triggered on a fault. fault: 3, tempFaultActive: 0
					# #[2014-11-25 08:07:03.130] [00]nciCommon(NCI_COMMON) nci_fault.c:3652 TRACE5:checkTemperature: sensor: 1, lastReadTemp = 38

					# else if (/TRACE5:checkTemperature:.*lastReadTemp/) temp[i,j,0]=$NF+0"C"
					# #DUW
					# else if (/0000  01 03 D0 17/) temp[i,j,0]=sprintf("%.0fC",sprintf("%d",strtonum("0x"$8 $9))/100)
					# #old DU temp traces, only used if the above did not work
					# else if (/TRACE1:TempSensor on DU,/) temp[i,j,1]=$NF+0 "C"
					# else if (/0000  01 03 D0 17/) temp[i,j,2]=sprintf("%.0fC",sprintf("%d",strtonum("0x"$8 $9))/100)
					# else if (/TRACE5:Board Temperature = /) temp[i,j,2]=gensub(/^.*TRACE5:Board Temperature = |degrees celsius.*$/,"","g",$0)+0 "C"
					# else if (/TRACE1:TempSensor on SCU,/) temp[i,j,3]=$NF+0 "C"

					# new behaviour since 9.0y
					# first read the temperature from boardtemp (DUL/DUS) or readPower (DUWv2)
					# else from trace5 on NCI_COMMON (LTE) or trace4 on SriBcThread (WCDMA)
					#boardtemp:
					#Sensor 0: Temp 34 (34) DegC: Status: 0 Address: 0x49 Limits: 70 65 0 -5 hotspot
					#Sensor 1: Temp 33 (33) DegC: Status: 0 Address: 0x48 Limits: 90 85 0 -5
					#readPower:
					#DUW11 :   2015-07-01 14:59:06 Power consumption is  91.821 W, Temp: 44 50 39 38
					#DUW31/41: 2015-07-01 15:00:12 Power consumption is 255.929 W, Temp: 48 49 53 39 37 52 49 49
					else if ($1=="Sensor" && $NF=="hotspot")
					{
						#print
						temp[i,j,0]=$4"C"
					}
					else if ($8=="Temp:")
					{
						temp[i,j,0]=$10"C"
					}
					#trace5 NCI_COMMON DUL/DUS
					#[2013-05-30 10:40:30.680] nciCommon(NCI_COMMON) nci_fault.c:3516 TRACE5:checkTemperature: sensor: 1 ,lastReadTemp[&d] = 33
					#[2014-11-25 08:07:03.130] [00]nciCommon(NCI_COMMON) nci_fault.c:3652 TRACE5:checkTemperature: sensor: 1, lastReadTemp = 38
					else if (/TRACE5:checkTemperature:.*lastReadTemp/)
					{
						for (f=1;f<NF;f++) if ($f=="sensor:") { sensorPos=f+1 ; break }
						sub(/,/,"",$sensorPos)
						if ($sensorPos != hotSpotSensor) continue
						#print
						temp[i,j,1]=$NF+0"C"
					}
					else if (/SriBcThread.*TRACE4.*tempSensors 0-7: /)
					{
						#ODS:
						#[2013-06-14 10:41:03.574] 000100/00 1/SriBcThread hwi_i2c_access.cc:117 TRACE4:HwiI2cAccess::updateAllTemperatures, tempSensors 0-7: 6600 6500 6400 6600 6600 5800 0 0
						#print
						for (b=1;b<=NF;b++) { if ($b=="tempSensors") temp[i,j,1]=(($(b+3)+0)/100)"C" }
					}
					else if (/SriBcThread.*TRACE4.*temp/)
					{
						#DUW/ODW
						#[2013-05-30 10:23:53.064] 1/SriBcThread hwi_i2c_access.cc:194 TRACE4:HwiI2cAccess::setI2cData temp 3600, address 0x49
						#[2013-05-30 11:20:32.952] 1/SriBcThread hwi_i2c_access.cc:194 TRACE4:HwiI2cAccess::setI2cData temp 4200, address 0x4B
						if ((productname[i,j] ~ /W.1/)&&($NF=="0x4D" || $NF=="0x4d")) $NF=1   #Note: the temperature of DUWv2 is normally read via readPower command, not trace but the trace may be used if the command did not work
						else if ($NF=="0x4B" || $NF=="0x4b") $NF=3
						if ($NF!=hotSpotSensor) continue
						#print
						temp[i,j,1]=(($(NF-2)+0)/100)"C"
					}
					#MSB
					else if ($1=="Temperature" && $2=="[C]:") temp[i,j]="+"$3"C"  #MSB3
					else if (NF==2 && $1~/^[0-4]$/ && $2~/^[0-9]+$/) temp[i,j]="+"$2"C" #MSB4
				}
				if (temp[i,j,0] != "") temp[i,j]=temp[i,j,0]
				else if (temp[i,j,1] != "") temp[i,j]=temp[i,j,1]
				#else if (temp[i,j,2] != "") temp[i,j]=temp[i,j,2]
				#else if (temp[i,j,3] != "") temp[i,j]=temp[i,j,3]
			}
		}
	}
	#check CMXB1 (3820)
	#use ii and jj instead of i and j because i and j are used in parseCabLine
	for (ii=0;ii<=99;ii++)
	{
		if (smn_list[ii]!=1) continue
		if (check_hw!=1) continue
		for (jj=0;jj<=1;jj++)
		{
			ok=0 ; pos=0 ; ledstate[0]="OFF" ; ledstate[1]="ON"
			if (jj==0) pos=26 ; else if (jj==1) pos=3
			if (productname[ii,jj] ~ /^SCB-[DT]F/)
			{
				#New RNC3820 SW, can read the CMXB info with getAttrObj command
				if (productname[ii,pos] ~ /^CMXB/) #we had found out that the board is CMXB from the cabHwInfoFile
				{

					printf("echo \"LOGGING INTO BOARD: %s %s\"\ngetAttrObj piu -d %02d%02d00\ngetAttrObj slot -d %02d%02d00\necho \"EndOfPrint\"\n",ii,pos,ii,pos,ii,pos) |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						gsub("\r","") ; gsub("\x00","") ;
						gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
						show_progress(howoften)
						if (parseCabLine("oldled")~/^(break|timeout)$/) break
					}
					continue
				}
				#Old RNC3820 SW, must read the CMXB info via cmxbsh
				printf("lhsh %02d%02d00 cmxbsh\n",ii,jj) |& telnet_session
				while ((telnet_session |& getline)>0)
				{
					gsub("\r","") ; gsub("\x00","") ; show_progress(5)
					if (/--- Completed cmxbsh auto-login ---/) { ok=1 ; break }
					if (/(unknown|illegal) command .cmxbsh|lost contact|Error in SNMP|Timeout waiting for SNMP/) break
				}
				if (ok!=1) continue
				#board[ii,pos]=apn_list[ii,pos]=1
				delete cmxb_commands
				cmxb_commands[1]="bladeIpmi getBladeProductNumber "pos
				cmxb_commands[2]="bladeIpmi getBladeProductName "pos
				cmxb_commands[3]="bladeIpmi getLedState green"
				cmxb_commands[4]="bladeIpmi getLedState red"
				cmxb_commands[5]="bladeIpmi getLedState yellow"
				#printf("bladeIpmi getBladeProductNumber %s\nbladeIpmi getBladeProductName %s\nbladeIpmi getLedState green\nbladeIpmi getLedState red\nbladeIpmi getLedState yellow\nexit\n",pos,pos) |& telnet_session
				for (k=1;k<=6;k++)
				{
					if (k==6) print "exit" |& telnet_session
					else print cmxb_commands[k]"\necho \"EndOfPrint\"" |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						gsub("\r","") ; gsub("\x00","") ; show_progress(5)
						if (/(^|[^"])EndOfPrint$/) break
						if (/Connection closed by peer/) break
						else if (/Product number:/) productnumber[ii,pos]=gensub(/[ \t]/,"","g",gensub(/^[^:]+: *|[ \t]*$/,"","g",$0))
						else if (/Product rev/) productrev[ii,pos]=gensub(/^[^:]+: *|[ \t]*$/,"","g",$0)
						else if (/Product name:/) productname[ii,pos]=gensub(/^[^:]+: *|[ \t]*$/,"","g",$0)
						else if (/Product .*date/) productdate[ii,pos]=gensub(/^[^:]+: *|[ \t]*$/,"","g",$0)
						else if (/Product serial/) serialnumber[ii,pos]=gensub(/^[^:]+: *|[ \t]*$/,"","g",$0)
						else if (/The green LED/) green[ii,pos]=($NF in ledstate?ledstate[$NF]:$NF)
						else if (/The yellow LED/) yellow[ii,pos]=($NF in ledstate?ledstate[$NF]:$NF)
						else if (/The red LED/) red[ii,pos]=($NF in ledstate?ledstate[$NF]:$NF)
					}
				}
			}
		}
	}

	#basic@(none):/$ bladeIpmi getBladeProductNumber 3
	#bgetBladeProductNumber response received:
	#   Slot position:          3
	#   Product number:         ROJ 208 504/1
	#   Product revision state: R1C
	#basic@(none):/$ bladeIpmi getBladeProductName 3
	#bgetBladeProductName response received:
	#   Slot position:          3
	#   Product name:           CMXB
	#   Product manuf. date:    20080619
	#   Product serial number:  A063693443
	#lbasic@(none):/$ bladeIpmi getLedState green
	#The green LED has ledState = 1
	#basic@(none):/$ bladeIpmi getLedState red
	#The red LED has ledState = 0
	#basic@(none):/$ bladeIpmi getLedState yellow
	#The yellow LED has ledState = 0

	if (check_xp > 0)
	{
		split(sysMgr,array,",")
		i=array[1] ; j=array[2]
		if (board[i,j]==1) printf("lhsh %02d%02d00 listObj subrack\nlhsh %02d%02d00 listObj pfm\nlhsh %02d%02d00 listObj app\nlhsh %02d%02d00 listObj xp\nlhsh %02d%02d00 listObj cfu\n",i,j,i,j,i,j,i,j,i,j) |& telnet_session
		else if (board[i,j]==2 || sysMgr=="") printf("listObj subrack\nlistObj pfm\nlistObj app\nlistObj xp\nlistObj cfu\n") |& telnet_session
		printf("echo \"EndOfPrint\"\n") |& telnet_session
		while ((telnet_session |& getline)>0)
		{
			gsub("\r","") ; gsub("\x00","") ; gsub(/^( *\$ *)+/,"")
			gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
			show_progress(howoften)
			if (/Sr Id/) cab_subrack_list[$NF]=$NF  #nr_of_subracks=$NF
			else if (/pfm Id/) pfmUnits[$NF]=$NF
			else if (/app Id/) appUnits[$NF]=$NF
			else if (/Xp Id/) xpUnits[$NF]=$NF
			else if (/cfu FRO Id/) cfuUnits[$NF]=$NF
			if (/(^|[^"])EndOfPrint$/) break
		}
		m=-1
		nr_of_subracks=asort(cab_subrack_list)
		for (z=1;z<=nr_of_subracks;z++)
		{
			s=cab_subrack_list[z]
			if (board[i,j]==1) printf("lhsh %02d%02d00 getAttrObj subrack %s\n",i,j,s) |& telnet_session
			else if (board[i,j]==2 || sysMgr=="") printf("getAttrObj subrack %s\n",s) |& telnet_session
			while ((telnet_session |& getline)>0)
			{
				gsub("\r","") ; gsub("\x00","") ; gsub("\t"," ") ;
				gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
				show_progress(howoften)
				if (/Subrack Number/) currSmn=gensub(/^.*Subrack Number +/,"","g",$0)
				if (/Product No/)
				{
					subrackProduct[++m]=gensub(/^.*Product No +/,"","g",$0)
					subrackProduct[m]=gensub($NF,"",1,subrackProduct[m])
					subrackProduct[m]=gensub(/ +$/,"","g",subrackProduct[m])
					subrackSmn[m]=currSmn
					if ($NF != "No") subrackRev[m]=$NF
				}
				if (/Product Name/) subrackName[m]=gensub(/^.*Product Name +/,"","g",$0)
				if (/Product Date/) subrackDate[m]=gensub(/^.*Product Date +/,"","g",$0)
				if (/Product Ser. No/)
				{
					subrackSerial[m]=gensub(/^.*Product Ser. No +/,"","g",$0)
					if (++serialCounter==2)
					{
						serialCounter=0
						break
					}
				}
			}
		}
	}
	print "exit" |& telnet_session
	while ((telnet_session |& getline)>0) { show_progress(howoften) }
	close(telnet_session)
	if (ncli_error != "") customPrint("\n\nWARNING: not all data could be collected due to insufficient free memory in the node JVM (NCLI: "ncli_error")")
	if (check_hw == 1 || check_hw==2)
	{
		customPrint("")
		if (is_wcdma==1 && wrbsType!="") customPrint("Node type: "wrbsType)
		else if (is_LTE==1 && erbsType!="") customPrint("Node type: "erbsType)
		customPrint(sprintf("====================================================================================================================\n\
%3s %s%3s  %s%-*s  %s%-6s %s%-6s %s%-6s%s%s  %s%-14s %s%-6s %s%-10s %s%-8s %s%-4s %s%s\n\
====================================================================================================================",\
"SMN",sep,"APN",sep,cabLen["board"],"BOARD",sep,"FAULT",sep,"OPER",sep,"MAINT",(has4Led?sprintf(" %s%-6s",sep,"STAT"):""),\
(evo_node?sprintf(" %s%-3s",sep,"FRO"):""),sep,"PRODUCTNUMBER",sep,"REV",sep,"SERIAL",sep,"DATE",sep,"TEMP",sep,"COREMGR"))
		cab_print_node("hw")
		w=asort(alarmLimit)
		#alarm limit removed , TR HS77435/HS71227
		#for (v=1;v<=w;v++) customPrint(alarmLimit[v])
		if (w > 0)
		{
			customPrint("Note: Temp sensors and alarm limits can be printed with \"lh <boardgroup> proctemp\". Type \"h proctemp\" for info.")
			customPrint("Note: The HW/SW tables in cab/cabs are obsolete. Command invr/invhr/invxr can be used instead. Type \"h inv\" for info.")
		}
	}
	if (check_xp > 0)
	{
		customPrint(sprintf("\n================================================================\n\
%3s  %s%-18s  %s%-4s  %s%-10s  %s%-8s  %s%s\n\
================================================================",\
"SMN",sep,"ProductNr",sep,"Rev",sep,"Name",sep,"Date",sep,"SerialNr"))
		for (n=0;n<=m;n++)
		{
			if (subrackProduct[n] !~ /^ *$/)
				customPrint(sprintf("%3s  %s%-18s  %s%-4s  %s%-10s  %s%-8s  %s%s",subrackSmn[n],sep,subrackProduct[n],sep,subrackRev[n],sep,subrackName[n],sep,subrackDate[n],sep,subrackSerial[n]))
		}
		customPrint("----------------------------------------------------------------")
	}
	if (check_load > 0)
	{
		customPrint(sprintf("\n============================================================================================\n\
%3s %3s  %-9s  %-7s  %s\n\
============================================================================================","SMN","APN",\
"BOARD","TOTLOAD","SPM/CORE PROCLOAD"))
		cab_print_node("load")
		customPrint("\nNote: cabl command is obsolete. Command \"lh <boardgroup> procload\" can be used instead. Type \"h procload\" for info.")
	}
	if (check_sw > 0)
	{
		customPrint(sprintf("\n============================================================================================\n\
%3s %3s  %-*s  %s\n\
============================================================================================","SMN","APN",cabLen["board"],\
"BOARD","SOFTWARE"))
		cab_print_node("sw")
	}
	if (check_mem > 0)
	{
		customPrint(sprintf("\n=================================================\n\
%3s %3s  %-*s  %15s  %s\n\
=================================================","SMN","APN",cabLen["board"],\
"BOARD","FREE","TOTAL"))
		cab_print_node("mem")
	}
	if (check_llog > 0)
	{
		output=sprintf("\n===============================================================================================================\n\
%-4s  %-*s  %-17s","Pos",cabLen["board"],"Board","Date and Time")
		if (osSupported==1) output=sprintf("%s  %-9s  %-6s",output,"Domain","OS")
		if (cpplinux==1) output=sprintf("%s  %-20s  %-10s  %s",output,"Reason","Program (PID)","Type")
		else output=sprintf("%s  %-20s  %-10s  %s",output,"Process","Errorcode","Cause")
		if (pmdSupported==1) output=sprintf("%s %s",output,"(PMD ID)")
		output=sprintf("%s\n===============================================================================================================",output)
		customPrint(output)
		cab_print_node("llog")
	}
	if (check_dumpelg > 0)
	{
		customPrint(sprintf("\n===============================================================================================================\n\
%-4s  %-*s  %-17s\n\
===============================================================================================================","Pos",cabLen["board"],"Board","Dumpelg Entry"))
		cab_print_node("dumpelg")
	}
	if (check_vols > 0)
	{
		customPrint(sprintf("\n=====================================================================================\n\
Global Vol   total      used        free   frw device unit\n\
====================================================================================="))
		customPrint(globalDisk["/c"])
		cab_print_node("volsp")
		customPrint("-------------------------------------------------------------------------------------")
		customPrint(sprintf("\n=====================================================================================\n\
Local  volume        LMs  total      used        free   frw device unit\n\
====================================================================================="))
		cab_print_node("volsd")
		customPrint("-------------------------------------------------------------------------------------")
		if (check_f > 0)
		{
			cab_print_node("volsf")
			customPrint("-------------------------------------------------------------------------------------")
		}
		else if (cpplinux!=1) customPrint("/f volumes can be printed with option f")
		if (cpplinux==1) customPrint("\nNote: cabd command is currently not supported on EvoC8300. Command \"invh\" can be used instead.")
	}
	if (check_te > 0)
	{
		customPrint(sprintf("\n================================================================================\n\
%-4s  %-*s  %-30s  %-9s  %s\n\
================================================================================","Pos",cabLen["board"],"Board","Process","Status","AddedTraceConditions"))
		cab_print_node("te")
		customPrint("--------------------------------------------------------------------------------")
		customPrint("To remove enabled trace conditions: te default")
		customPrint("To remove saved trace conditions: te default -restart")
		customPrint("\nNote: cabe command is obsolete. Command \"lh <boardgroup> fte s [all]\" can be used instead. Type \"h fte\" for info.")
	}

	if (check_xp > 0)
	{
		len["board"]=13
		if ("auxboard" in len && len["auxboard"] > 0 && len["auxboard"] < 13) len["board"]=len["auxboard"]  #if we can have a shorter board length we use it
		len["prod"]=16
		len["date"]=12
		len["auxpiuru"]=6
		len["auxpiuboard"]=5
		if (is_6000==1)
		{
			len["board"]=15  #old setting=11 , extended to 15 for AIR units eg: AIR21B4AB12PB5P
			len["prod"]=12
			len["date"]=8
		}
		if (is_6000 || is_3000) is_rbs=1
		if (mosdebug==1) print "DEBUG: is_6000="is_6000", is_lte="is_LTE", is_wrbs="is_wrbs", is_3000="is_3000", is_wcdma="is_wcdma", is_rbs="is_rbs
		customPrint(sprintf("\n\
==============================================================================================================================\n\
%3s %s%3s %s%-*s  %s%-*s  %s%-6s %s%-6s %s%-6s %s%-*s %s%-6s %s%-12s %s%-*s %s%-4s%s\n\
==============================================================================================================================",\
"SMN",sep,"APN",sep,len["port"],"PORT",sep,len["board"],"BOARD",sep,"FAULT",sep,"OPER",sep,"MAINT",sep,len["prod"],"PRODUCT NR",sep,"REV",sep,"SERIAL",sep,len["date"],"DATE",sep,"TEMP",\
(is_rbs?"  "sep"AuxPIU  "sep"Cells":"")))
		#check if any ports end with Pht, eg port_6_dev_11Pht, then we must remove those
		for (q in port_dev_list) { if (q ~ /Pht$/) { delete port_dev_list[gensub(/Pht$/,"",1,q)] ; delete port_dev_list[q]}}
		max_portdev=sortportdev(port_dev_list,sorted_port_dev_list)
		if (max_portdev==0 && evo_node < 1 && hcs_node < 1) return
		os=check_os()
		telnet_session=enter_telnet_login(node_address,node_password)
		if (telnet_session ~ /Unable to connect|Wrong Password/)
		{
			customPrint(telnet_session)
			return
		}
		for (i=0;i<=99;i++)
		{
			if (smn_list[i]!=1) continue #if (xp_smn[i]<=0) continue
			for (j=0;j<=27;j++)
			{
				if (board[i,j]<=0) continue #if (xp_apn[j]<=0)continue
				if (notemp==0 && is_wcdma==1 && productname[i,j] ~ /^(DU|OD|GPB|CBU)/)
				{
					#printf("lhsh %02d%02d00 te e bus_receive CDCI_TR\nlhsh %02d%02d00 te filter set \"[3]<>$2F AND [3]<>$B2\" CDCI_TR\n",i,j,i,j) |& telnet_session
					printf("lhsh %02d%02d00 te s CDCI_TR\necho \"EndOfPrint\"\n",i,j) |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						gsub("\r","") ; gsub("\x00","") ; gsub(/^( *\$ *)+/,"") ; show_progress(howoften,"nodots")
						if (/(^|[^"])EndOfPrint$/) break
						else if (/CDCI_TR.*bus_receive/) cdci_ok[i,j]=1
					}
					if (cdci_ok[i,j]!=1) printf("lhsh %02d%02d00 te e bus_receive CDCI_TR\n",i,j) |& telnet_session
				}
			}
			if (notemp==0 && is_wcdma==1) usleep(8000000)
			for (j=0;j<=27;j++)
			{
				if (board[i,j]<=0) continue #if (xp_apn[j]<=0)continue
				if (notemp==0 && is_wcdma==1 && productname[i,j] ~ /^(DU|OD|GPB|CBU)/)
				{
					incdci=0
					#printf("lhsh %02d%02d00 te log read 20\nlhsh %02d%02d00 te d bus_receive CDCI_TR\nlhsh %02d%02d00 te filter reset CDCI_TR\n",i,j,i,j,i,j) |& telnet_session
					printf("lhsh %02d%02d00 te log read 20\n",i,j) |& telnet_session
					if (cdci_ok[i,j]!=1) printf("lhsh %02d%02d00 te d bus_receive CDCI_TR\n",i,j) |& telnet_session
					printf("echo \"EndOfPrint\"\n") |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						#DEBUG: [2012-12-24 08:27:22.800] SccMainFastThread(CDCI_TR) ../SccRcRouterRomMeasC.cpp:140 BUS RECEIVE:/TRX:1:10:0/ CDCI_TR_INT_LEVEL_MEAS_IND
						#0001: [2012-12-24 07:17:06.532] SccMainFastThread(CDCI_TR) ../SccRcRouterRomMeasC.cpp:140 BUS RECEIVE:/RU:0:2:0:2/ CDCI_TR_INT_LEVEL_MEAS_IND
						#0001: 0000  01 01 C2 21 16 01 00 59 0B E2 02 91               '...!...Y....'
						gsub("\r","") ; gsub("\x00","") ; gsub(/^( *\$ *)+/,"") ; show_progress(howoften,"nodots")
						if (/(^|[^"])EndOfPrint$/) break
						else if ($NF~/^CDCI_TR_INT_LEVEL_MEAS2?_IND$/)
						{
							incdci=1
							match($0,/\/([^:/]+):([^:/]+):([^:/]+):([^:/]+)/,array)
							if (array[1] ~ "TRX")
							{
								currentRu=array[2]"_"array[3]  #smn_apn
								haveTrx=1
							}
							else currentRu=array[2]"_"array[3]"_"array[4]   #smn_apn_port
						}
						else if ($1=="0000" && incdci==1)
						{
							incdci=0
							currTr=$6 $7
							currBranch=sprintf("%d",strtonum("0x"$7))
							currRssi=sprintf("%d",strtonum("0x"$8 $9)) * 0.1 - 112
							#rssiBranches[currentRu,currBranch]=currBranch
							#rssiVal[currentRu,currBranch]+=currRssi
							#rssiSamples[currentRu,currBranch]++
							rssiVal[currTr]+=currRssi
							rssiSamples[currTr]++
						}
					}
				}
			}
			if (is_wcdma==1)
			{
				for (z in rssiVal)
				{
					rssiAvg[z]=sprintf("%.1f",mDiv(rssiVal[z],rssiSamples[z]))
				}
				if (mosdebug==1)
				{
					for (z in rssiVal) print "rssiVal["gensub(SUBSEP,",","g",z)"]="rssiVal[z]
					for (z in rssiBranches) print "rssiBranches["gensub(SUBSEP,",","g",z)"]="rssiBranches[z]
					for (z in rssiSamples) print "rssiSamples["gensub(SUBSEP,",","g",z)"]="rssiSamples[z]
					for (z in rssiAvg) print "rssiAvg["gensub(SUBSEP,",","g",z)"]="rssiAvg[z]
				}
			}
			for (j=0;j<=27;j++)
			{
				if (board[i,j]<=0) continue #if (xp_apn[j]<=0)continue
				for (k=1;k<=max_portdev;k++)
				{
					if (port_dev[i,j,sorted_port_dev_list[k]] != 1) continue
					run_xp_checks(sprintf("%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k]),"par get CONTAINER_HW*")
					if (boardMoreInfo[sprintf("%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k])]~"XMU03") continue
					run_xp_checks(sprintf("%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k]),"vii;par get SYS_HW*")
					if (additional_xp_command_list[i,j,sorted_port_dev_list[k]] != "")
					{
						split(additional_xp_command_list[i,j,sorted_port_dev_list[k]],array,SUBSEP)
						run_xp_checks(sprintf("%s%s%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k],SUBSEP,array[1]),array[2])
					}
				}
			}
		}
		customPrint("\
------------------------------------------------------------------------------------------------------------------------------")
		#if (is_LTE==1 || is_wrbs==1)
		if (TX8==1)
		{
			customPrint(sprintf("\n\
==============================================================================================================================\n\
%3s %s%3s %s%-*s  %s%11s %s%11s %s%11s %s%11s %s%11s %s%11s %s%11s %s%11s %s%s\n\
==============================================================================================================================",
"SMN",sep,"APN",sep,len["port"],"PORT",sep,"TX1(W/dBm)",sep,"TX2(W/dBm)",sep,"TX3(W/dBm)",sep,"TX4(W/dBm)",sep,"TX5(W/dBm)",sep,"TX6(W/dBm)",sep,"TX7(W/dBm)",sep,"TX8(W/dBm)",sep,"Cells (cellId,PCI)"))
			for (i=0;i<=99;i++)
			{
				if (smn_list[i]!=1) continue #if (xp_smn[i]<=0) continue
				for (j=0;j<=27;j++)
				{
					if (board[i,j]<=0) continue #if (xp_apn[j]<=0)continue
					for (k=1;k<=max_portdev;k++)
					{
						if (port_dev[i,j,sorted_port_dev_list[k]] != 1) continue
						currBd=sprintf("%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k])
						if (boardMoreInfo[currBd] ~ /^(XMU|ASC)/) continue
						if (ruPrinted[boardSerial[currBd]]==1) continue #the same board has several CPRI links we only print it once
						output=sprintf("%3s %s%3s %s%-*s  ",i,sep,j,sep,len["port"],sorted_port_dev_list[k])
						for (zz=1;zz<=8;zz++) output=sprintf("%s%s%11s ",output,sep,power[currBd,zz])
						output=sprintf("%s%s%s",output,sep,cellMoreInfo[currBd])
						customPrint(output)
						ruPrinted[boardSerial[currBd]]=1
					}
				}
			}
			customPrint("\
------------------------------------------------------------------------------------------------------------------------------")
			customPrint(sprintf("\n\
==============================================================================================================================\n\
%3s %s%3s %s%-*s  %s%11s %s%11s %s%11s %s%11s %s%11s %s%11s %s%11s %s%11s %s%s\n\
==============================================================================================================================",
"SMN",sep,"APN",sep,len["port"],"PORT",sep,"VSWR1 (RL1)",sep,"VSWR2 (RL2)",sep,"VSWR3 (RL3)",sep,"VSWR4 (RL4)",sep,"VSWR5 (RL5)",sep,"VSWR6 (RL6)",sep,"VSWR7 (RL7)",sep,"VSWR8 (RL8)",sep,"Cells (cellId,PCI)"))
			for (i=0;i<=99;i++)
			{
				if (smn_list[i]!=1) continue #if (xp_smn[i]<=0) continue
				for (j=0;j<=27;j++)
				{
					if (board[i,j]<=0) continue #if (xp_apn[j]<=0)continue
					for (k=1;k<=max_portdev;k++)
					{
						if (port_dev[i,j,sorted_port_dev_list[k]] != 1) continue
						currBd=sprintf("%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k])
						if (boardMoreInfo[currBd] ~ /^(XMU|ASC)/) continue
						if (ruPrinted[boardSerial[currBd]]==2) continue #the same board has several CPRI links we only print it once
						output=sprintf("%3s %s%3s %s%-*s  ",i,sep,j,sep,len["port"],sorted_port_dev_list[k])
						for (zz=1;zz<=8;zz++) output=sprintf("%s%s%11s ",output,sep,vswr[currBd,zz])
						output=sprintf("%s%s%s",output,sep,cellMoreInfo[currBd])
						customPrint(output)
						ruPrinted[boardSerial[currBd]]=2
					}
				}
			}
			customPrint("\
------------------------------------------------------------------------------------------------------------------------------")
			printCabxObsolete()
		}
		else if (TX6==1)
		{
			customPrint(sprintf("\n\
==============================================================================================================================\n\
%3s %s%3s %s%-*s  %s%11s %s%11s %s%11s %s%11s %s%11s %s%11s %s%s\n\
==============================================================================================================================",
"SMN",sep,"APN",sep,len["port"],"PORT",sep,"TX1(W/dBm)",sep,"TX2(W/dBm)",sep,"TX3(W/dBm)",sep,"TX4(W/dBm)",sep,"TX5(W/dBm)",sep,"TX6(W/dBm)",sep,"Cells (cellId,PCI)"))
			for (i=0;i<=99;i++)
			{
				if (smn_list[i]!=1) continue #if (xp_smn[i]<=0) continue
				for (j=0;j<=27;j++)
				{
					if (board[i,j]<=0) continue #if (xp_apn[j]<=0)continue
					for (k=1;k<=max_portdev;k++)
					{
						if (port_dev[i,j,sorted_port_dev_list[k]] != 1) continue
						currBd=sprintf("%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k])
						if (boardMoreInfo[currBd] ~ /^(XMU|ASC)/) continue
						if (ruPrinted[boardSerial[currBd]]==1) continue #the same board has several CPRI links we only print it once
						output=sprintf("%3s %s%3s %s%-*s  ",i,sep,j,sep,len["port"],sorted_port_dev_list[k])
						for (zz=1;zz<=6;zz++) output=sprintf("%s%s%11s ",output,sep,power[currBd,zz])
						output=sprintf("%s%s%s",output,sep,cellMoreInfo[currBd])
						customPrint(output)
						ruPrinted[boardSerial[currBd]]=1
					}
				}
			}
			customPrint("\
------------------------------------------------------------------------------------------------------------------------------")
			customPrint(sprintf("\n\
==============================================================================================================================\n\
%3s %s%3s %s%-*s  %s%11s %s%11s %s%11s %s%11s %s%11s %s%11s %s%s\n\
==============================================================================================================================",
"SMN",sep,"APN",sep,len["port"],"PORT",sep,"VSWR1 (RL1)",sep,"VSWR2 (RL2)",sep,"VSWR3 (RL3)",sep,"VSWR4 (RL4)",sep,"VSWR5 (RL5)",sep,"VSWR6 (RL6)",sep,"Cells (cellId,PCI)"))
			for (i=0;i<=99;i++)
			{
				if (smn_list[i]!=1) continue #if (xp_smn[i]<=0) continue
				for (j=0;j<=27;j++)
				{
					if (board[i,j]<=0) continue #if (xp_apn[j]<=0)continue
					for (k=1;k<=max_portdev;k++)
					{
						if (port_dev[i,j,sorted_port_dev_list[k]] != 1) continue
						currBd=sprintf("%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k])
						if (boardMoreInfo[currBd] ~ /^(XMU|ASC)/) continue
						if (ruPrinted[boardSerial[currBd]]==2) continue #the same board has several CPRI links we only print it once
						output=sprintf("%3s %s%3s %s%-*s  ",i,sep,j,sep,len["port"],sorted_port_dev_list[k])
						for (zz=1;zz<=6;zz++) output=sprintf("%s%s%11s ",output,sep,vswr[currBd,zz])
						output=sprintf("%s%s%s",output,sep,cellMoreInfo[currBd])
						customPrint(output)
						ruPrinted[boardSerial[currBd]]=2
					}
				}
			}
			customPrint("\
------------------------------------------------------------------------------------------------------------------------------")
			printCabxObsolete()
		}
		else if (TX4==1)
		{
			customPrint(sprintf("\n\
==============================================================================================================================\n\
%3s %s%3s %s%-*s  %s%11s %s%11s %s%11s %s%11s %s%11s %s%11s %s%11s %s%11s %s%s\n\
==============================================================================================================================",
"SMN",sep,"APN",sep,len["port"],"PORT",sep,"TX1(W/dBm)",sep,"TX2(W/dBm)",sep,"TX3(W/dBm)",sep,"TX4(W/dBm)",sep,"VSWR1 (RL1)",sep,"VSWR2 (RL2)",sep,"VSWR3 (RL3)",sep,"VSWR4 (RL4)",sep,"Cells (cellId,PCI)"))
			for (i=0;i<=99;i++)
			{
				if (smn_list[i]!=1) continue #if (xp_smn[i]<=0) continue
				for (j=0;j<=27;j++)
				{
					if (board[i,j]<=0) continue #if (xp_apn[j]<=0)continue
					for (k=1;k<=max_portdev;k++)
					{
						if (port_dev[i,j,sorted_port_dev_list[k]] != 1) continue
						currBd=sprintf("%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k])
						if (boardMoreInfo[currBd] ~ /^(XMU|ASC)/) continue
						if (ruPrinted[boardSerial[currBd]]==1) continue #the same board has several CPRI links we only print it once
						output=sprintf("%3s %s%3s %s%-*s  ",i,sep,j,sep,len["port"],sorted_port_dev_list[k])
						for (zz=1;zz<=4;zz++) output=sprintf("%s%s%11s ",output,sep,power[currBd,zz])
						for (zz=1;zz<=4;zz++) output=sprintf("%s%s%11s ",output,sep,vswr[currBd,zz])
						output=sprintf("%s%s%s",output,sep,cellMoreInfo[currBd])
						customPrint(output)
						ruPrinted[boardSerial[currBd]]=1
					}
				}
			}
			customPrint("\
------------------------------------------------------------------------------------------------------------------------------")
			printCabxObsolete()
		}
		else if (is_LTE==1 || is_6000==1)
		{
			#print len["auxpiuboard"],len["auxpiuru"]
			customPrint(sprintf("\n\
====================================================================================================================\n\
%3s %s%3s %s%-*s  %s%-*s  %s%-*s  %s%11s %s%11s  %s%-11s %s%-11s  %s%s\n\
====================================================================================================================",\
"SMN",sep,"APN",sep,len["port"],"PORT",sep,len["auxpiuboard"],"BOARD",sep,len["auxpiuru"],"AuxPIU",sep,"TX1(W/dBm)",sep,"TX2(W/dBm)",sep,"VSWR1 (RL1)",sep,"VSWR2 (RL2)",sep,"Cells"(is_LTE==1?" (cellId,PCI)":"")))
			for (i=0;i<=99;i++)
			{
				if (smn_list[i]!=1) continue #if (xp_smn[i]<=0) continue
				for (j=0;j<=27;j++)
				{
					if (board[i,j]<=0) continue #if (xp_apn[j]<=0)continue
					for (k=1;k<=max_portdev;k++)
					{
						#print i,j,sorted_port_dev_list[k],port_dev[i,j,sorted_port_dev_list[k]]
						if (port_dev[i,j,sorted_port_dev_list[k]] != 1) continue
						currBd=sprintf("%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k])
						if (boardMoreInfo[currBd] ~ /^(XMU|ASC)/) continue
						if (ruPrinted[boardSerial[currBd]]==1) continue #the same board has several CPRI links we only print it once
						cab_print_extraRbsLine(extraRbsLine[i,j,sorted_port_dev_list[k]],sprintf("%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k]))
						ruPrinted[boardSerial[currBd]]=1
					}
				}
			}
			customPrint("\
--------------------------------------------------------------------------------------------------------------------")
			printCabxObsolete()
		}
#Does not work, cannot print the RSSI per RU, has to be per Cell
#		if (is_wcdma==1)
#		{
#			customPrint(sprintf("\n\
#====================================================================================================================\n\
#%3s %3s %-*s  %-*s  %-*s  %8s %8s %5s  %s\n\
#====================================================================================================================",\
#"SMN","APN",len["port"],"PORT",(haveTrx?len["trx"]:len["auxpiuboard"]),"BOARD",len["auxpiuru"],"AuxPIU","RX1(dBm)","RX2(dBm)","Delta","Sectors"))
#			for (i=0;i<=99;i++)
#			{
#				if (smn_list[i]!=1) continue #if (xp_smn[i]<=0) continue
#				for (j=0;j<=27;j++)
#				{
#					if (board[i,j]<=0) continue #if (xp_apn[j]<=0)continue
#					if (haveTrx)
#					{
#						trx_piu=i+1"/"j
#						if (productname[i,j]~"TRX") customPrint(sprintf("%3s %3s %-*s  %-*s  %-*s  %s  %s",i,j,len["port"],"",len["trx"],productname[i,j],len["auxpiuru"],trx_piu,make_rx_info(i"_"j),ruCarrierTable[trx_piu]))
#					}
#					for (k=1;k<=max_portdev;k++)
#					{
#						if (port_dev[i,j,sorted_port_dev_list[k]] != 1) continue
#						cab_print_extraRxLine(extraRxLine[i,j,sorted_port_dev_list[k]])
#					}
#				}
#			}
#			customPrint("\
#--------------------------------------------------------------------------------------------------------------------")
#		}
		if (is_wcdma==1)
		{
			customPrint(sprintf("\n\
====================================================================================================================\n\
%-5s  %s%8s  %s%8s  %s%s%5s  %s%s\n\
====================================================================================================================",\
"Cell",sep,"RX1(dBm)",sep,"RX2(dBm)",sep,(have4Rx==1?sprintf("%8s  %s%8s  %s","RX3(dBm)",sep,"RX4(dBm)",sep):""),"Delta",sep,"TrDevices"))
			for (i in carrierList) formattedCarrierList[carrierList[i]]=sprintf("%5s",carrierList[i])
			n=asort(formattedCarrierList)
			for (i=1;i<=n;i++)
			{
				delete rssiTable
				trdevs=""
				carrierList[i]=gensub(/^ */,"",1,formattedCarrierList[i])
				output=sprintf("%-5s",carrierList[i])
				last=split(sorted_carrierTrList[carrierList[i]],array,",")
				for (j=1;j<=last;j++)
				{
					trdevs=trdevs" "(array[j] in rssiAvg && rssiAvg[array[j]]!=""?"*":"")make_short_ru(trDeviceTable[array[j]],"trdev")
					if (rssiAvg[array[j]]!="")
					{
						output=sprintf("%s  %s%8s",output,sep,rssiAvg[array[j]])
						rssiTable[rssiAvg[array[j]]+0]=rssiAvg[array[j]]+0
					}
				}
				sub(/^ +/,"",trdevs)
				z=asort(rssiTable)
				delta=rssiTable[z]-rssiTable[1]
				if (output ~ /^[^ ]+$/) output=sprintf("%s  %s%8s  %s%8s",output,sep,0,sep,0)
				if (last>=4)
				{
					if (output ~ / 0 +0/) output=sprintf("%s  %s%8s  %s%8s  %s%5s",output,sep,0,sep,0,sep,0)
					else output=sprintf("%s  %s%5s",output,sep,delta)
				}
				else
				{
					if (have4Rx==1) output=sprintf("%s  %s%8s  %s%8s  %s%5s",output,sep,"",sep,"",sep,delta)
					else output=sprintf("%s  %s%5s",output,sep,delta)
				}
				output=sprintf("%s  %s%s",output,sep,trdevs)
				customPrint(output)
			}
			customPrint("\
--------------------------------------------------------------------------------------------------------------------")

		}

		if (hcs_node==1)
		{
			for (xp in xpUnits) print "echo \"Reading XP "xp"\"\ngetAttrObj xp " xp |& telnet_session
			print "echo \"EndOfPrint\"" |& telnet_session
			while ((telnet_session |& getline)>0)
			{
				gsub("\r","") ; gsub("\x00",""); gsub(/^( *\$ *)+/,"")
				gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
				show_progress(howoften)
				if (/(^|[^"])EndOfPrint$/) break
				#        Piu1 Id 1
				#        Piu2 Id 28
				#        Xp No   7
				#        Fan Number      4
				#        High AirLim     47
				#        Critical AirLim 57
				#        Yellow LED      CELLO_LED_SLOW_BLINK
				#        Position        ABOVE
				#Administrative Data:
				#        Product No      BFB14012/1
				#        Product Rev     *
				#        Product Name    FAN
				#        Product Type    HW
				#        State           UNLOCKED
				#Operative Data:
				#        Product No      BFB14012/1
				#        Product Rev     R1B
				#        Product Name    FAN UNIT5006
				#        Product Type    HW
				#        Product Date    08W49
				#        Product Ser. No BN73588022
				#        State           ENABLED
				#
				#        Piu1 Id 1
				#        Piu2 Id 28
				#        Xp No   7
				#        Fan Number      3
				#        High AirLim     47
				#        Critical AirLim 57
				#        Yellow LED      CELLO_LED_SLOW_BLINK
				#        Position        DENIB_DEVICE2
				#Administrative Data:
				#        Product No      KDU137557/4
				#        Product Rev     *
				#        Product Name    APP_FAN
				#        Product Type    HW
				#        State           UNLOCKED
				#Operative Data:
				#        Product No      KDU137557/4
				#        Product Rev     R2C
				#        Product Name    O/E conv.
				#        Product Type    HW
				#        Product Date    20100415
				#        Product Ser. No A442605147
				#        State           ENABLED
				if ($0 ~ /Reading XP/ ) { currUnit = $3 ; what=""}
				else if ($1 ~ /^(Administrative|Operative)$/) what=$1
				else if (NF>=2)
				{
					match($0,/(Piu. Id|Fan Number|High AirLim|Critical AirLim|Yellow LED|Position|Product No|Product Rev|Product Name|Product Type|Product Date|Product Ser. No|State)/,array)
					field=array[1]
					val=gensub(sprintf("^.*%s[ \t]*",array[1]),"",1,$0)
					hcsXp[what,currUnit,field]=val
					#print "hcsXp["what","currUnit","field"]="val
				}
			}
			customPrint(sprintf("\n\
=========================================================================================================\n\
%-4s  %-2s  %-15s  %1s  %-4s  %-13s  %-13s  %-4s  %-12s  %-8s\n\
=========================================================================================================",\
"PIU1","NR", "POS", "S", "LED", "NAME", "PRODUCT NR", "REV", "SERIAL", "DATE"))
			for (xp in xpUnits )
			{
				#print "xp="xp,hcsXp["",xp,"Yellow LED"],EGEM_LED[hcsXp["",xp,"Yellow LED"]]
				oline=sprintf("%4s  %2s  %-15s  %-1s  %-4s  %-13s  %-13s  %-4s  %-12s  %-8s",\
hcsXp["",xp,"Piu1 Id"],\
hcsXp["",xp,"Fan Number"],\
hcsXp["",xp,"Position"],\
(hcsXp["Administrative",xp,"State"]=="LOCKED"?"L":EGEM_LED[hcsXp["Operative",xp,"State"]]),\
EGEM_LED[gensub(/^CELLO_LED.?_/,"",1,hcsXp["",xp,"Yellow LED"])],\
(hcsXp["Operative",xp,"Product Name"]!=""?hcsXp["Operative",xp,"Product Name"]:hcsXp["Administrative",xp,"Product Name"]),\
(hcsXp["Operative",xp,"Product No"]!=""?hcsXp["Operative",xp,"Product No"]:hcsXp["Administrative",xp,"Product No"]),\
(hcsXp["Operative",xp,"Product Rev"]!=""?hcsXp["Operative",xp,"Product Rev"]:hcsXp["Administrative",xp,"Product Rev"]),\
hcsXp["Operative",xp,"Product Ser. No"],\
hcsXp["Operative",xp,"Product Date"])
				xpOutput[oline]=oline
			}
			maxoline=asort(xpOutput)
			for (t=1;t<=maxoline;t++) customPrint(xpOutput[t])

		}
		if (evo_node)
		{
			for( pfm in pfmUnits ) print "echo \"Reading PFM "pfm"\"\ngetAttrObj pfmData " pfm |& telnet_session
			for( app in appUnits ) print "echo \"Reading APP "app"\"\ngetAttrObj app " app |& telnet_session
			for( cfu in cfuUnits ) print "echo \"Reading CFU "cfu"\"\ngetAttrObj cfu " cfu |& telnet_session
			print "echo \"EndOfPrint\"" |& telnet_session

			# $ getAttrObj pfmData 1
			# froId           : 1
			# subrackNumber   : 0
			# position        : 0 (LOWER)
			# connectedXb     : 1
			# admState        : 1(UNLOCKED)
			# operProdId      : BFB 140 13/1
			# operProdRevRev  : R9A
			# operProdDataDate: 20110224
			# operProdDataName: FAN UNIT
			# serialNr        : T01F003733
			# operState       : 1 (ENABLED)
			# ledState        : 2 (CELLO_LED2_OFF)
			# connectionStatus: 1 (CONNECTED)

			# $ getAttrObj app 1
			# admState       : UNLOCKED
			# froId          : 1
			# operState      : ENABLED
			# subrackNr      : 0
			# connectedXb    : 1
			# maintenanceInd : 2
			# operProdDate   : 20110819O/E conv.
			# operProdRev    : R2C
			# operProdName   : O/E conv.
			# operProdNr     : KDU 137 557/4
			# operSerialNr   : A442645574

			#$ getAttrObj cfu 1
			#GetAttributeCfm
			#        Cfu FRO Id              :1
			#        Admin State             :UNLOCKED
			#        OperationalState        :ENABLED
			#        connectedTo             :1
			#        maintenenceInd          :2
			#        cfuPosition             :Left
			#        operProductNum          :BFB 140 17/1
			#        operProductRev          :R2B
			#        operProductName         :CAS2FANMODUL
			#        operProductSer          :A065036907
			#        operProductDate         :20130903
			#$


			while ((telnet_session |& getline)>0)
			{
				gsub("\r","") ; gsub("\x00",""); gsub(/^( *\$ *)+/,"")
				gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
				show_progress(howoften)
				if (/(^|[^"])EndOfPrint$/) break

				if( $0 ~ /Reading PFM/ ) {xpType = "PFM"; currUnit = $3}
				if( $0 ~ /Reading APP/ ) {xpType = "APP";currUnit = $3}
				if( $0 ~ /Reading CFU/ ) {xpType = "CFU";currUnit = $3}

				# PFM or APP
				if( $1 ~ /^connectedXb$/ && NF==3 ) evoXp[xpType,currUnit,"ConXP"] = sprintf("%s%0.2u00",evoXp[xpType,currUnit,"ConXP"],$3)
				if( $1 ~ /^admState$/ && NF==3 ) evoXp[xpType,currUnit,"admState"] = ($3 ~ /UNL/) ? "1" : "L"

				# PFM
				if( $1 ~ /^subrackNumber$/ && NF==3 ) evoXp[xpType,currUnit,"ConXP"] = sprintf("%0.2u",$3)
				if( $1 ~ /^position$/ && NF>=4 ) evoXp[xpType,currUnit,"Pos"] = gensub("\\(|\\)","","g",$4)
				if( $1 ~ /^operState$/ && NF>=3 ) evoXp[xpType,currUnit,"opState"] = $3
				if( $1 ~ /^operProdId$/ && NF>=2 ) evoXp[xpType,currUnit,"pNum"] = gensub(/^.*: *| /,"","g",$0)
				if( $1 ~ /^operProdRevRev$/ && NF>=3 ) evoXp[xpType,currUnit,"pRev"] = $3
				if( $1 ~ /^operProdDataDate/ && NF>=2 ) evoXp[xpType,currUnit,"pDate"] = $2
				if( $1 ~ /^operProdDataName/ && NF>=2 ) evoXp[xpType,currUnit,"pName"] = gensub("(operProdDataName)*|[ \t:]*","","g",$0)
				if( $1 ~ /^serialNr$/ && NF>=3 ) evoXp[xpType,currUnit,"pSer"] = $3
				if( $1 ~ /^ledState$/ && NF>=4 ) evoXp[xpType,currUnit,"led"] = $3

				# APP
				if( $1 ~ /^subrackNr$/ && NF>=3 ) evoXp[xpType,currUnit,"ConXP"] = sprintf("%0.2u",$3)
				if( $1 ~ /^operState$/ && NF>=3 ) evoXp[xpType,currUnit,"opState"] = ($3 ~ /ENABLED/) ? "1" : "0"
				if( $1 ~ /^operProdNr$/ && NF>=3 ) evoXp[xpType,currUnit,"pNum"] = gensub("(operProdNr)*|[ \t:]*","","g",$0)
				if( $1 ~ /^operProdRev$/ && NF>=3 ) evoXp[xpType,currUnit,"pRev"] = gensub("(operProdRev)*|[ \t:]*","","g",$0)
				if( $1 ~ /^operProdDate$/ && NF>=3 ) evoXp[xpType,currUnit,"pDate"] = gensub("(operProdDate)*|[ \t:]*","","g",$0)
				if( $1 ~ /^operProdName$/ && NF>=3 ) evoXp[xpType,currUnit,"pName"] = gensub("(operProdName)*|[ \t:]*","","g",$0)
				if( $1 ~ /^operSerialNr$/ && NF>=3 ) evoXp[xpType,currUnit,"pSer"] = gensub("(operSerialNr)*|[ \t:]*","","g",$0)
				if( $1 ~ /^maintenanceInd$/ && NF>=3 ) evoXp[xpType,currUnit,"led"] = $3

				#CFU
			#        Admin State             :UNLOCKED
			#        OperationalState        :ENABLED
			#        connectedTo             :1
			#        maintenenceInd          :2
			#        cfuPosition             :Left
			#        operProductNum          :BFB 140 17/1
			#        operProductRev          :R2B
			#        operProductName         :CAS2FANMODUL
			#        operProductSer          :A065036907
			#        operProductDate         :20130903

				if( $1 ~ /^Admin$/ && NF==3 ) { sub(/^.*: */,"") ; evoXp[xpType,currUnit,"admState"] = ($NF ~ /UNL/) ? "1" : "L" }
				if( $1 ~ /^OperationalState$/ && NF>=2 ) { sub(/^.*: */,"") ; evoXp[xpType,currUnit,"opState"] = ($NF ~ /ENABLED/) ? "1" : "0" }
				if( $1 ~ /^operProductNum$/   && NF>=2 ) { sub(/^.*: */,"") ; gsub(/[ \t]/,""); evoXp[xpType,currUnit,"pNum"]  = $0 }
				if( $1 ~ /^operProductRev$/   && NF>=2 ) { sub(/^.*: */,"") ; gsub(/[ \t]/,""); evoXp[xpType,currUnit,"pRev"]  = $0 }
				if( $1 ~ /^operProductDate$/  && NF>=2 ) { sub(/^.*: */,"") ; gsub(/[ \t]/,""); evoXp[xpType,currUnit,"pDate"] = $0 }
				if( $1 ~ /^operProductName$/  && NF>=2 ) { sub(/^.*: */,"") ; gsub(/[ \t]/,""); evoXp[xpType,currUnit,"pName"] = $0 }
				if( $1 ~ /^operProductSer$/   && NF>=2 ) { sub(/^.*: */,"") ; gsub(/[ \t]/,""); evoXp[xpType,currUnit,"pSer"]  = $0 }
				if( $1 ~ /^maintenenceInd$/   && NF>=2 ) { sub(/^.*: */,"") ; gsub(/[ \t]/,""); evoXp[xpType,currUnit,"led"]   = $0 }
				if( $1 ~ /^cfuPosition$/      && NF>=2 ) { sub(/^.*: */,"") ; gsub(/[ \t]/,""); evoXp[xpType,currUnit,"Pos"]   = $0 }
				if( $1 ~ /^connectedTo$/      && NF>=2 ) { sub(/^.*: */,"") ; gsub(/[ \t]/,""); evoXp[xpType,currUnit,"ConXP"] = sprintf("15%0.2u00",$0) }

			}
			customPrint(sprintf("\n\
===================================================================================\n\
%-9s %-6s %1s %3s %-12s %-13s %-6s %-12s %-8s\n\
===================================================================================",\
"CONNECTED", "POS", "S", "LED", "NAME", "PRODUCT NR", "REV", "SERIAL", "DATE"))
			for( pfm in pfmUnits )
			{
				oline=sprintf("%-9s %-6s %-1s %-3s %-12s %-13s %-6s %-12s %-8s",evoXp["PFM",pfm,"ConXP"],evoXp["PFM",pfm,"Pos"],
(evoXp["PFM",pfm,"admState"]=="L")?"L":evoXp["PFM",pfm,"opState"],EGEM_LED[evoXp["PFM",pfm,"led"]],
evoXp["PFM",pfm,"pName"],evoXp["PFM",pfm,"pNum"],evoXp["PFM",pfm,"pRev"],evoXp["PFM",pfm,"pSer"],evoXp["PFM",pfm,"pDate"])
				pfmOutput[oline]=oline
			}
			maxoline=asort(pfmOutput)
			for (t=1;t<=maxoline;t++) customPrint(pfmOutput[t])
			for( app in appUnits )
			{
				oline=sprintf("%-9s %-6s %-1s %-3s %-12s %-13s %-6s %-12s %-8s",evoXp["APP",app,"ConXP"],evoXp["APP",app,"Pos"],
(evoXp["APP",app,"admState"]=="L")?"L":evoXp["APP",app,"opState"],EGEM_LED[evoXp["APP",app,"led"]],
evoXp["APP",app,"pName"],evoXp["APP",app,"pNum"],evoXp["APP",app,"pRev"],evoXp["APP",app,"pSer"],evoXp["APP",app,"pDate"])
				appOutput[oline]=oline
			}
			maxoline=asort(appOutput)
			for (t=1;t<=maxoline;t++) customPrint(appOutput[t])
			for( cfu in cfuUnits )
			{
				oline=sprintf("%-9s %-6s %-1s %-3s %-12s %-13s %-6s %-12s %-8s",evoXp["CFU",cfu,"ConXP"],evoXp["CFU",cfu,"Pos"],
(evoXp["CFU",cfu,"admState"]=="L")?"L":evoXp["CFU",cfu,"opState"],EGEM_LED[evoXp["CFU",cfu,"led"]],
evoXp["CFU",cfu,"pName"],evoXp["CFU",cfu,"pNum"],evoXp["CFU",cfu,"pRev"],evoXp["CFU",cfu,"pSer"],evoXp["CFU",cfu,"pDate"])
				cfuOutput[oline]=oline
			}
			maxoline=asort(cfuOutput)
			for (t=1;t<=maxoline;t++) customPrint(cfuOutput[t])
		}

		print "exit" |& telnet_session
		while ((telnet_session |& getline)>0) {}
		close(telnet_session)
	}
	if (mosdebug==1)
	{
		#for (z in len) print "len["z"]="len[z]
		$0="" ; gv("t")
		$0="" ; gv("s")
	}
}
function run_xp_checks(l,xp_command,   array,tmp_xp_board,last,z,line,f,y,rbsPwrInfo,rbsVswrInfo,rl,g,currRu,tmpLteCells,lteCellInfo,name,red,green,yellow,pid,rev,serial,pdate,temp,currentRx,tx,pwr,q,r,xmu03_ok)
{
	currentRx=""
	xmu03_ok=0
	if (mosdebug==1) print "run_xp_checks: "l,xp_command" END"
	q=split(l,array,SUBSEP)
	if (mosdebug==1) { printf "RUN XP CHECK ON : " ; for (r=1;r<=q;r++) printf r": "array[r]"  " ; printf name[l] ; print "" }
	xp_smn[array[1]]=1 ; xp_apn[array[2]]=1
	tmp_xp_board=sprintf("%02d%02d00/%s",array[1],array[2],array[3])

	if (xp_command =="par get CONTAINER_HW*")
	{
		print "lhsh -v "tmp_xp_board" par get CONTAINER_HW*" |& telnet_session
	}
	else
	{
		last=split(xp_command,xp_array,";")
		xp_command=""
		for (z=1;z<=last;z++)
		{
			xp_command=sprintf("%s\nlhsh %s %s",xp_command,tmp_xp_board,xp_array[z])
		}
		print xp_command |& telnet_session
		if (secure_shell==0) usleep(500000)  #the echo command can sometimes corrupt the printout otherwise, via telnet
		print "echo \"EndOfPrint\"" |& telnet_session
	}
	while ((telnet_session |& getline line)>0)
	{
		$0=line
		if (mosdebug==1) print "DEBUG: "$0
		#remove null sign and prompts like $ or 000100/port_0_dev_11>
		#  Yellow:     VII_BOARD_BUSY       (16 hz)
		#On RU the led state can be on separate lines
		#  Red:
		#          Default                               (off)
		#          VII_BOARD_BUSY                        (16 hz)
		#  Blue/Yellow:
	        #  Default                               (off)
		#RRUL:
		#Product name: RRUL 11 B12
		#Product number: KRC 131 142/1
		#Product revision: P1A
		#Production date : 20100430
		#Serial number: CH50000079
		gsub("\r","") ; gsub("\x00","") ; sub(/^(\$|[^ ]+> )/,"")
		gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
		if (/(^|[^"])EndOfPrint$/) break
		if (/ returned with status .*, errno/) break
		if (tolower($3) ~ /^hz/)  $2=sprintf("%shz",$2)
		else if (tolower($4) ~ /^hz/)  $3=sprintf("%shz",$3)
		#XMU03
		#productdate='20141107'
		#productname='XMU 03 01'
		#productnumber='KDU 137 949/1'
		#productrevision='R1B'
		#serialnumber='D16K238693'
		#sys_current_lmc='1'
		#sys_debug='0'
		#sys_mode='auapplic'
		#sys_sw_pid='CXP9025194%1_R2A'
		if (/^productdate=/)        { pdate[l]=gensub(/^.*='|'[^']*$|[ \t]/,"","g",$0)  ; xmu03_ok=1 }
		else if (/^productnumber=/)  {  pid[l]=gensub(/^.*='|'[^']*$|[ \t]/,"","g",$0)  ; xmu03_ok=1 }
		else if (/^productname=/)    { name[l]=gensub(/^.*='|'[^']*$|[ \t]/,"","g",$0)  ; xmu03_ok=1 }
		else if (/^serialnumber=/)  { serial[l]=gensub(/^.*='|'[^']*$|[ \t]/,"","g",$0)  ; xmu03_ok=1 }
		else if (/^productrevision=/) { rev[l]=gensub(/^.*='|'[^']*$|[ \t]/,"","g",$0)  ; xmu03_ok=1 }
		else if (/^(sys_mode|sys_debug|sys_current_lmc|sys_sw_pid)=/)
		{
			if (xmu03_ok!=1)
			{
				name[l]="XMU03"
				pid[l]="KDU137949/1"
				serial[l]="0000000000"
				rev[l]="???"
				pdate[l]="????????"
			}
		}
		else if (tolower($1) ~ /^red:/)    { if (NF >= 3) red[l]   =gensub(/\(|\)/,"","g",$3) ; else color="red"   }
		else if (tolower($1) ~ /^green:/)  { if (NF >= 3) green[l] =gensub(/\(|\)/,"","g",$3) ; else color="green" }
		else if (tolower($1) ~ /^(blue.)?yellow:/) { if (NF >= 3) yellow[l]=gensub(/\(|\)/,"","g",$3) ; else color="yellow"}
		else if (tolower($1) ~ /^red$/)                     red[l]    =gensub(/\(|\)/,"","g",$2)
		else if (tolower($1) ~ /^green$/)                   green[l]  =gensub(/\(|\)/,"","g",$2)
		else if (tolower($1) ~ /^(blue.)?yellow$/)                  yellow[l] =gensub(/\(|\)/,"","g",$2)
		else if (tolower($1) ~ /_pid/)                      pid[l]    =gensub(/^.*=[ \t]+|\x27|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /_rev/)                      rev[l]    =gensub(/^.*=[ \t]+|\x27|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /_name/ && tolower($1)!~/market/) name[l]   =gensub(/^.*=[ \t]+|\x27|[ \t]/,"","g",$0)   #SYS_HW_MARKET_NAME
		else if (tolower($1) ~ /_date/)                     pdate[l]  =gensub(/^.*=[ \t]+|\x27|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /_serial/)                   serial[l] =gensub(/^.*=[ \t]+|\x27|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /prod.nr/  || $0 ~ /Product number *:/)   pid[l]    =gensub(/^.*:[ \t]+|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /prod.rev/ || $0 ~ /Product revision *:/) rev[l]    =gensub(/^.*:[ \t]+|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /prod.name/|| $0 ~ /Product name *:/)     name[l]   =gensub(/^.*:[ \t]+|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /prod.date/|| $0 ~ /Production date *:/)  pdate[l]  =gensub(/^.*:[ \t]+|[ \t]/,"","g",$0)
		else if (tolower($1) ~ /serial.nr/|| $0 ~ /Serial number *:/)    serial[l] =gensub(/^.*:[ \t]+|[ \t]/,"","g",$0)
		#else if (tolower($1) ~ /temperature/)               temp[l]=$3
		if ($2~/^\(/ && $NF ~ /\)$/) # && NF<=3
		{
			#          VII_MISSING_RESOURCE                  (0.5 hz)
			#          VII_MISSING_RESOURCE_START_LOADING_SW (0.5 hz + double flash)
			colorval=gensub(/\(|\)/,"","g",$2)
			#print color,colorval
			if (color=="red" && (!(l in red))) red[l]=colorval
			else if (color=="green" && (!(l in green))) green[l]=colorval
			else if (color=="yellow" && (!(l in yellow))) yellow[l]=colorval
			color=""
		}
	}
	#on RRUS31/RRU22F the command "par get CONTAINER_HW*" returns the product info of the RRUS
	#if (pid[l] ~ /KRC118159/ ) print "DEBUG: "xp_command"x"
	if (pid[l] ~ rrus31Prod && xp_command=="par get CONTAINER_HW*") return

	if (name[l]~"XMU03")
	{
		print "lhsh -v "tmp_xp_board" vii" |& telnet_session
		while ((telnet_session |& getline line)>0)
		{
			$0=line
			if (mosdebug==1) print "DEBUG: "$0
			#Red:   Default                      (off)
			#Green: Default                      (on)
			#Blue:  Default                      (off)
			gsub("\r","") ; gsub("\x00","") ; sub(/^(\$|[^ ]+> )/,"")
			gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
			gsub(/\(|\)/,"",$3)
			gsub(/\(|\)/,"",$4)
			if (/ returned with status .*, errno/) break
			if      (tolower($1) ~ /^red:/)    red[l]   =$3 $4
			else if (tolower($1) ~ /^green:/)  green[l] =$3 $4
			else if (tolower($1) ~ /^blue:/)   yellow[l]=$3 $4
		}
		print "lhsh -v "tmp_xp_board" boardtemp" |& telnet_session
		while ((telnet_session |& getline line)>0)
		{
			$0=line
			if (mosdebug==1) print "DEBUG: "$0
			#Value of temperature sensor 1 in Celsius: 34.1875
			gsub("\r","") ; gsub("\x00","") ; sub(/^(\$|[^ ]+> )/,"")
			gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
			if (/ returned with status .*, errno/) break
			if (/Value of temperature sensor/ && sprintf("%.1f",$NF)>temp[l]) temp[l]=sprintf("%.1f",$NF)
		}
	}

	#the serial number and product name of the board are kept in some global variables
	boardSerial[l]=serial[l]
	boardMoreInfo[l]=name[l]
	#dont do the checks below if they had already been done previously on the unit
	if (name[l] ~ /XMU|AIR|^RR|TRANSCEIVER|^FU/ && xmuPrinted[serial[l]]==1) return

	#Now check temperature when applicable
	if (notemp==0)
	{
		xp_command=""
		     if (pid[l] ~ rru82Prod || name[l] ~ rru82Name) xp_command="FpgaTemp read hwy"
		else if (pid[l] ~ rrulProd  || name[l] ~ rrulName)  xp_command="FPGATempSv getTemp FPGA0"
		else if (name[l] ~ "RRUL11") xp_command="pmstat"    #RRUL11 Nortel
		else if (name[l] ~ "MCPA") xp_command="mcpaBoard temp"
		else if (name[l] ~ /^IRU/) xp_command="ts read"
		else if (name[l] ~ /RU|^RR22/) xp_command="fui get temp"   #Fujitsu ODM is called RR22 instead of RRU22
		else if (name[l] ~ "FAN")  xp_command="fantemp"
		if (xp_command != "")
		{
			print sprintf("lhsh %s %s\necho \"EndOfPrint\"",tmp_xp_board,xp_command) |& telnet_session
			while ((telnet_session |& getline line)>0)
			{
				$0=line
				if (mosdebug==1) print "DEBUG: "$0
				#mcpaBoard temp:  LM75 temperature = 36.5 degrees [C]
				#fantemp:         Measured Fan Temperature     :  30.00  C
				#pmstat:          PA temperature [degC]                   |(51)(52)
				#fui get temp:    temp:  36.0[C]
				#fui get temp:    temp 0: 36.4[C]
				#remove null sign and prompts like $ or 000100/port_0_dev_11>
				#Tx RF power [dBm]                       |(30.2)(30.2)
				#Tx RF power [dBm]                       |(0.0)(0.0)
				#VSWR: Tx return loss for DUL [dB / 10]  |(298)(277)
				#VSWR: Tx return loss for DUL [dB / 10]  |(65535)(65535)
				#RRUL6/RRUL8:
				#FPGATempSv : FPGA0. temperature = 850(0.1C).
				#FpgaTemp: the board temp is 42
				#Board                     : 26 C
				gsub("\r","") ; gsub("\x00","") ; sub(/^(\$|[^ ]+> )/,"")
				gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
				if (/(^|[^"])EndOfPrint$/) break
				if (pid[l] ~ rru82Prod || name[l] ~ rru82Name)
				{
					if ($1=="FpgaTemp:" && $3=="board") temp[l]=sprintf("%.1f",$NF)
				}
				else if (pid[l] ~ rrulProd || name[l] ~ rrulName)
				{
					if ($1=="FPGATempSv" && $4=="temperature") temp[l]=sprintf("%.1f",gensub(/\(.*$/,"",1,$6)/10)
				}
				else if (name[l] ~ "RRUL11")
				{
					if ($1=="PA" && $2=="temperature")
					{
						match($0,/\(([^)]*)\).*\(([^)]*)\)/,array)
						temp[l]=array[1]" "array[2]
					}
					else if ($1=="Tx" && $2=="RF" && $3=="power")
					{
						match($0,/\(([^)]*)\).*\(([^)]*)\)/,array)
						power[l,1]=sprintf("%.1f (%.1f)",10^(array[1]/10)/1000,array[1])
						power[l,2]=sprintf("%.1f (%.1f)",10^(array[2]/10)/1000,array[2])
						#print "1: "power[l,1]" 2: " power[l,2]" $0: "$0
					}
					else if ($1=="VSWR:")
					{
						match($0,/\(([^)]*)\).*\(([^)]*)\)/,array)
						vswr[l,1]=vswr[l,2]="0"
						if ((array[1]+0)!=0) vswr[l,1]=sprintf("%.2f (%.1f)",(1+10^(-array[1]/200))/(1-10^(-array[1]/200)),array[1]/10)
						if ((array[2]+0)!=0) vswr[l,2]=sprintf("%.2f (%.1f)",(1+10^(-array[2]/200))/(1-10^(-array[2]/200)),array[2]/10)
					}
				}
				else if (name[l] ~ /^IRU/ && $1=="Board" && $2==":") temp[l]=sprintf("%.0f",$3)"C"
				else if (name[l] ~ /RU|^RR22/ && $1~/^temp:?$/) temp[l]=gensub(/^.*:[ \t]*|[ \t]*\[.*$/,"","g",$0)  #Fujitsu ODM is called RR22 instead of RRU22
				else if (name[l] ~ "MCPA" && $2=="temperature") temp[l]=$4
				else if (name[l] ~ "FAN" && $3=="Temperature") temp[l]=sprintf("%.1f",$5+0)
			}
		}
	}

	#Check if this is a RBS3000 with PL4/PL5 RU/RRU/mRRU or with RU21/RU22
	if (is_3000==1 && notemp==0 && name[l] ~ /^m?R?RU[2WS]/) is_6000=1
	#Now check Output power if applicable
	if (notemp==0 && (pid[l] ~ rrulProd || name[l] ~ rrulName))
	{
		pwrClass=0
		xp_command=sprintf("lhsh %s db list /board/powerClassUsage",tmp_xp_board)
		if (pid[l] ~ rrul8Prod || name[l] ~ rrul8Name)
		{
			for (f=1;f<=8;f++) power[l,f]=rl[l,f]=vswr[l,f]=0
			xp_command=sprintf("%s\nlhsh %s psv",xp_command,tmp_xp_board)
		}
		else if (pid[l] ~ rru82Prod || name[l] ~ rru82Name)
		{
			for (f=1;f<=8;f++) power[l,f]=rl[l,f]=vswr[l,f]=0
			xp_command=sprintf("%s\nlhsh %s vcaHandler txPowerRead\nlhsh %s vswrSupHdl status",xp_command,tmp_xp_board,tmp_xp_board)
		}
		else if (pid[l] ~ rrul6Prod || name[l] ~ rrul6Name)
		{
			for (f=1;f<=2;f++) power[l,f]=rl[l,f]=vswr[l,f]=0
			xp_command=sprintf("%s\necho CurrentTx: 0\nlhsh %s txtorPwr 0 0 0\nlhsh %s vswr rtls 0\necho CurrentTx: 1\nlhsh %s txtorPwr 0 1 0\nlhsh %s vswr rtls 1",xp_command,tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board)
		}
		print sprintf("%s\necho \"EndOfPrint\"",xp_command) |& telnet_session
		while ((telnet_session |& getline line)>0)
		{
			$0=line
			gsub("\r","") ; gsub("\x00","") ; sub(/^(\$|[^ ]+> )/,"") ; gsub(/[$]/,"")
			gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
			if (mosdebug==1) print "DEBUG: "$0
			if (/(^|[^"])EndOfPrint$/) break
			#DEBUG:                                          20W
			#RRUL8
			#ch0: txpwr(-27.029217) torPwr(-29.204692) rxPwr(-50.617004) returnLoss(218)
			#ch7: txpwr(-27.066458) torPwr(-29.749833) rxPwr(-53.485723) returnLoss(234)
			#ch0: txpwr(0.000000) torPwr(0.000000) rxPwr(0.000000) returnLoss(0)
			#RRUL6
			#lhsh 000100/BXP_0_1 txtorPwr 0
			#tx PwrValue: -31.410089
			#lhsh 000100/BXP_0_1 vswr rtls 0
			#[ch0: off], returnloss = -1 [0.1dB]
			#RRUx82
			#TX0:  31.0(dBm)
			#...
			#TX7:  30.3(dBm)
			#Port:0,devId:    1,isStartVswr:Y,RawFwdPwr:2251 [1758,2817], RawRL:1945 [1687,3069], RL:65535 [65535,65535]
			#....
			#Port:7,devId:    8,isStartVswr:Y,RawFwdPwr:2534 [2480,2780], RawRL:1835 [1737,1902], RL:65535 [65535,65535]

			if (NF==1 && $1 ~ /^[0-9]+W$/) pwrClass=gensub(/W$/,"",1,$1)+0
			else if ($1~/^ch[0-7]:$/)
			{
				tx=gensub(/^ch|:/,"","g",$1)+1
				if (pwrClass==0) power[l,tx]=0
				else
				{
					pwr=gensub(/^.*\(|\).*$/,"","g",$2)+0
					if (pwr==0) power[l,tx]=0
					else
					{
						pwr=10*log(pwrClass*1000)/log(10) + 15 + pwr
						power[l,tx]=sprintf("%.1f (%.1f)",10^(pwr/10)/1000,pwr)
					}
				}
				rl[l,tx]=gensub(/^.*\(|\).*$/,"","g",$5)/10
				if (rl[l,tx]>0) vswr[l,tx]=sprintf("%.2f (%.1f)",(1+10^(-rl[l,tx]/20))/(1-10^(-rl[l,tx]/20)),rl[l,tx])
				else vswr[l,tx]=0
			}
			else if ($1=="CurrentTx:") tx=$2+1
			else if ($1=="tx" && $2=="PwrValue:")
			{
				if (pwrClass==0) power[l,tx]=0
				else
				{
					pwr=$3 + 0
					if (pwr==0 || pwr=="-Inf") power[l,tx]=0
					else
					{
						pwr=10*log(pwrClass*1000)/log(10) + 15 + pwr
						power[l,tx]=sprintf("%.1f (%.1f)",10^(pwr/10)/1000,pwr)
					}
				}
			}
			else if ($3=="returnloss")
			{
				if ($5>0) rl[l,tx]=$5/10
				if (rl[l,tx]>0) vswr[l,tx]=sprintf("%.2f (%.1f)",(1+10^(-rl[l,tx]/20))/(1-10^(-rl[l,tx]/20)),rl[l,tx])
				else vswr[l,tx]=0
			}
			else if (/Port:.*, RawRL:.*, RL:/)
			{
				#Port:0,devId:    1,isStartVswr:Y,RawFwdPwr:2640 [2295,2645], RawRL:  20 [  19, 985], RL:    0 [    0,  622]
				#Port:0,devId:   10,isStartVswr:Y,RawFwdPwr:2193 [1680,2208], RawRL:3784 [3079,3785], RL: 2761 [ 1801, 2761]
				#For the TX , must use the Port id, not the devId, because the devId can be higher than 8
				split($1,arra,",")
				split(arra[1],arra,":")
				tx=arra[2]+1
				rlvalue=gensub(/^.*, +RL: */,"",1,$0)
				rlvalue=gensub(/ *\[.*$/,"",1,rlvalue)
				rl[l,tx]=rlvalue/100
				if (rl[l,tx]>0) vswr[l,tx]=sprintf("%.2f (%.1f)",(1+10^(-rl[l,tx]/20))/(1-10^(-rl[l,tx]/20)),rl[l,tx])
				else vswr[l,tx]=0
			}
			else if ($1~/^TX[0-7]:$/)
			{
				pwr=gensub(/\(.*$/,"",1,$2)+0
				tx=gensub(/^TX|:$/,"","g",$1)+1
				power[l,tx]=sprintf("%.1f (%.1f)",10^(pwr/10)/1000,pwr)
			}
		}
	}
	else if (notemp==0 && (pid[l] ~ rrus4Prod || name[l] ~ rrus4Name || name[l] ~ rrus33Name || pid[l] ~ rrus33Prod))
	{
		pwr=tpwr=tx=currTxBranch=currTxIndex=currOffset=pwrClass=0
		     if (pid[l] ~ rrus31Prod || name[l] ~ rrus31Name) xp_command=sprintf("lhsh %s  txpwr rfport all",tmp_xp_board)
		else if (pid[l] ~ rrus32Prod || name[l] ~ rrus32Name || pid[l] ~ rrus33Prod || name[l] ~ rrus33Name) xp_command=sprintf("lhsh %s txm rh all wrk  dump\necho CurrentWarp: 0\nlhsh %s warp:0 txpwr\necho CurrentWarp: 2\nlhsh %s warp:1 txpwr\n",tmp_xp_board,tmp_xp_board,tmp_xp_board)
		for (f=1;f<=4;f++) power[l,f]=rl[l,f]=0
		for (f=5;f<=6;f++) power[l,f]=rl[l,f]=""
		xp_command=sprintf("%s\necho CurrentTx: 1\nlhsh %s fui get vswr 1\nlhsh %s fuia get antquality 1\necho CurrentTx: 2\nlhsh %s fui get vswr 2\nlhsh %s fuia get antquality 2\necho CurrentTx: 3\nlhsh %s fui get vswr 3\nlhsh %s fuia get antquality 3\necho CurrentTx: 4\nlhsh %s fui get vswr 4\nlhsh %s fuia get antquality 4",xp_command,tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board)
		if (pid[l] ~ rrus6Prod || name[l] ~ rrus6Name)
		{
			for (f=5;f<=6;f++) power[l,f]=rl[l,f]=0
			xp_command=sprintf("%s\necho CurrentTx: 5\nlhsh %s fui get vswr 5\necho CurrentTx: 6\nlhsh %s fui get vswr 6",xp_command,tmp_xp_board,tmp_xp_board)
		}
		print sprintf("%s\necho \"EndOfPrint\"",xp_command) |& telnet_session
		while ((telnet_session |& getline line)>0)
		{
			$0=line
			gsub("\r","") ; gsub("\x00","") ; sub(/^(\$|[^ ]+> )/,"") ; gsub(/[$]/,"")
			gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
			if (mosdebug==1) print "DEBUG: "$0
			if (/(^|[^"])EndOfPrint$/) break
			#Branch A
			#  Ant Power             : 27.8[dBm]
			#Branch B
			#  Ant Power             : 27.8[dBm]
			#Branch C
			#  Ant Power             :  0.0[dBm]
			#Branch D
			#  Ant Power             :  0.0[dBm]

			if (NF==2 && $1=="Branch" && $2 ~ /^[A-F]$/) tx=txmap[$2]+0
			else if ($1=="Ant" && $2=="Power" && $3==":")
			{
				pwr=gensub(/\[.*$/,"",1,$4)+0
				if (pwr > 0) power[l,tx]=sprintf("%.1f (%.1f)",10^(pwr/10)/1000,pwr)
				#else power[l,tx]=0   #dont need to do this, the value should be already initialised
			}
			else if ($1=="CurrentTx:") tx=$2+0
			else if ($1=="vswr:")
			{
				rl[l,tx]=gensub(/\[.*$/,"",1,$2)+0
				if (rl[l,tx]>0) vswr[l,tx]=sprintf("%.2f (%.1f)",(1+10^(-rl[l,tx]/20))/(1-10^(-rl[l,tx]/20)),rl[l,tx])
				else vswr[l,tx]=0
			}
			else if (/error. Type 'te log read' for more info/) vswr[l,tx]=0

			#same as for warp3
			#modularized TX, command "txm"
			#TXBRANCH:A
			#currPwr 4780 mBm 60.256 W "60W"
			#TXBRANCH:B
			#currPwr 4300 mBm 19.9526 W "20W"
			#TXBRANCH:C
			#currPwr 4480 mBm 30.1995 W "31W"
			#TXBRANCH:D
			#currPwr 4480 mBm 30.1995 W "31W"

			#A0: Power = 0xF5B9001C (-27.96 dB)
			#A1: Power = 0x00000000
			#A2: Power = 0x00000000
			#A3: Power = 0x00000000
			#A4: Power = 0x00000000
			#A5: Power = 0x00000000
			#A6: Power = 0x00000000
			#A7: Power = 0x00000000
			#B0: Power = 0xF596001C (-27.96 dB)
			#B1: Power = 0x00000000
			#B2: Power = 0x00000000
			#B3: Power = 0x00000000
			#B4: Power = 0x00000000
			#B5: Power = 0x00000000
			#B6: Power = 0x00000000
			#B7: Power = 0x00000000
			else if ($NF~/^TXBRANCH:[ABCDEF]$/) currTxBranch=gensub(/^.*:/,"",1,$0)
			else if ($1=="currPwr") pwrClassTxm[txmap[currTxBranch]]=$4
			else if ($1=="CurrentWarp:") currOffset=$2
			else if ($1 ~ /^[AB][0-7]:$/ && $2=="Power" && $3=="=" && $4 ~ /^0x/)
			{
				if (pwrClass!=0) tpwr=pwrClass
				else if ($1 ~ /^A[0-7]:/) currTxIndex=2+currOffset
				else if ($1 ~ /^B[0-7]:/) currTxIndex=1+currOffset
				tpwr=pwrClassTxm[currTxIndex]
				if ($NF ~ "dB") tpwr= tpwr * 10^((gensub(/^\(/,"",1,$(NF-1))+0)/10) * 268435456/8491396
				else tpwr=0
				#print $0,tpwr,pwrClassTxm[currTxIndex]
				power[l,currTxIndex]+=tpwr
				if ($1 ~ /^[AB]7:/)
				{
					#print $0"\n"l,currTxIndex,power[l,currTxIndex]
					if (power[l,currTxIndex] > 0) power[l,currTxIndex]=sprintf("%.1f (%.1f)",power[l,currTxIndex],10*log(power[l,currTxIndex]*1000)/log(10))
					else power[l,currTxIndex]=0
				}
				#if (mosdebug==1) printf("power[%s,%s]=%s tpwr=%s*10^(%s/10)*268435456/8491396=%s\n",l,($1~/^A/?1:2),power[l,($1~/^A/?1:2)],pwrClass,gensub(/^\(/,"",1,$(NF-1))+0,tpwr)
			}
			#Antenna quality, available with fui get antquality on following radio types
			#AIR 21 B4A B2P: KRC 118 046/1
			#AIR 21 B4A B12P B5P: KRC 118 048/1
			#AIR 21 B4A B12P B8P: KRC 118 057/1
			#AIR32 B4A B2P: KRD 901 044/1
			#AIR32 B2A B4P: KRD 901 129/1
			#mRRUS 12 B4:  KRC 161 326/1, KRC 161 326/2, KRC 161 326/, KRC 161 326/4
			#mRRUS 12 B13: KRC 161 332/1 1, KRC 161 332/2, KRC 161 332/3, KRC 161 332/4
			#RUS 12m B4: KRC 161 377/1
			#RUS 12m B13: KRC 161 513/1
			#gives:
			# a value from 1 (bad) to 5 (good) if succesful measurement
			# or an error like: error 2 6, current DL power:2220(0.01dBm) does not reach the maximum HW limited DL power:4480(0.01dBm)
			else if ($0 ~ /^[ \t]*[1-9][0-9]*$/ && vswr[l,tx]==0) vswr[l,tx]="AntQ: "$1
			#else if ($1 == "error" && $2 ~ /^(RE|[1-9])$/) vswr[l,tx]="AntQ: "($2~/^[1-9]$/?"-":"") $2

		}
	}
	else if (name[l] ~ /^R?RU2/)
	{
		rl[1]=0
		tpwr=0
		power[l,1]=0
		vswr[l,1]=0
		power[l,2]=vswr[l,2]="N/A"
		#sometimes fui get vswr does not work the first time
		xp_command=sprintf("lhsh %s fui get vswr\nlhsh %s tr meas tx get\nlhsh %s fui get vswr\nlhsh %s echo \"EndOfPrint\"",tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board)
		print xp_command |& telnet_session
		while ((telnet_session |& getline line)>0)
		{
			$0=line
			if (mosdebug==1) print "DEBUG: "$0
			gsub("\r","") ; gsub("\x00","") ; sub(/^(\$|[^ ]+> )/,"") ; gsub(/[$]/,"")
			gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
			if (/(^|[^"])EndOfPrint$/) break
			if ($1=="vswr:")
			{
				rl[1]=gensub(/\[.*$/,"",1,$2)+0
				if (rl[1]>0) vswr[l,1]=sprintf("%.2f (%.1f)",(1+10^(-rl[1]/20))/(1-10^(-rl[1]/20)),rl[1])
			}
			#TX_POWER_LEVEL_MEAS: Reported 360 on carrier 0. Num Carrs: 1
			else if ($1=="TX_POWER_LEVEL_MEAS:")
			{
				tpwr=($3+0)/10
				if (tpwr>0) power[l,1]=sprintf("%.1f (%.1f)",10^(tpwr/10)/1000,tpwr)
			}
		}
	}
	else if (is_6000==1 && notemp==0 && name[l] !~ /^(RRUL11|FU|XCU)/)
	{
		xp_command=""
		if (name[l] ~ /^m?RR?U/)
		{
			xp_command=sprintf("lhsh %s txm rh all wrk  dump\nlhsh %s db list *currentPowerClass\necho CurrentTx: 1\nlhsh %s fui get vswr\nlhsh %s fuia get antquality 1\necho CurrentTx: 2\nlhsh %s fui get vswr 2\nlhsh %s fuia get antquality 2\nlhsh %s warp3 txpwr\n",tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board)
			for (f=0;f<=3;f++) xp_command=sprintf("%slhsh %s warpA read DL_PM_PA0_C%s\n",xp_command,tmp_xp_board,f)
		}
		if (name[l] ~ /^m?RRU/)
		{
			for (f=0;f<=3;f++) xp_command=sprintf("%slhsh %s warpB read DL_PM_PA0_C%s\n",xp_command,tmp_xp_board,f)
		}
		if (name[l] ~ /^IRU/) xp_command=sprintf("lhsh %s txm rh all wrk  dump\necho CurrentTx: 1\nlhsh %s fuia get antquality 1\necho CurrentTx: 2\nlhsh %s fuia get antquality 2\nlhsh %s warp3 txpwr\n",tmp_xp_board,tmp_xp_board,tmp_xp_board,tmp_xp_board)
		if (xp_command != "")
		{
			if (mosdebug==1) print "DEBUG: xp_command= "xp_command
			delete pwrClassTxm
			delete p_index
			power[l,1]=power[l,2]=0
			vswr[l,1]=vswr[l,2]=""
			pwrClass=0
			f=y=0
			print sprintf("%secho \"EndOfPrint\"",xp_command) |& telnet_session
			while ((telnet_session |& getline line)>0)
			{
				$0=line
				if (mosdebug==1) print "DEBUG: "$0
				gsub("\r","") ; gsub("\x00","") ; sub(/^(\$|[^ ]+> )/,"") ; gsub(/[$]/,"")
				gsub("\x1e","");gsub("\x04","");gsub("\x0e","")
				#20W
				# $ $ Value 0x01367228 (20345384) read from address 0x00000B8F.
				# Value 0x00E7CBE6 (15191014) read from address 0x00000B8F.
				# $ Value 0x010A502C (17453100) read from address 0x00000B90.
				# $ Value 0x0103369B (16987803) read from address 0x00000B91.
				# $ Value 0x00EE9B7A (15637370) read from address 0x00000B92.
				# $ Value 0x00E7AE61 (15183457) read from address 0x00000B8F.
				# $ Value 0x0102BA3F (16955967) read from address 0x00000B90.
				# $ Value 0x010B15D8 (17503704) read from address 0x00000B91.
				# $ Value 0x00EEF07E (15659134) read from address 0x00000B92.
				#vswr:  24.5[dB]

				#A0: Power = 0xF5B9001C (-27.96 dB)
				#A1: Power = 0x00000000
				#A2: Power = 0x00000000
				#A3: Power = 0x00000000
				#A4: Power = 0x00000000
				#A5: Power = 0x00000000
				#A6: Power = 0x00000000
				#A7: Power = 0x00000000
				#B0: Power = 0xF596001C (-27.96 dB)
				#B1: Power = 0x00000000
				#B2: Power = 0x00000000
				#B3: Power = 0x00000000
				#B4: Power = 0x00000000
				#B5: Power = 0x00000000
				#B6: Power = 0x00000000
				#B7: Power = 0x00000000


				if (/(^|[^"])EndOfPrint$/) break
				if ($1=="Value")
				{
					warp3=0
					p_index[++f]=gensub(/^\(|\)$/,"","g",$3)+0
				}
				else if ($2=="Power" && $NF ~ "dB" && $1 ~ /^[AB][0-7]:$/)
				{
					#print $0
					warp3=1
					if (pwrClass!=0) tpwr=pwrClass
					else if ($1 ~ /^A[0-7]:/) tpwr=pwrClassTxm["B"]
					else if ($1 ~ /^B[0-7]:/) tpwr=pwrClassTxm["A"]
					tpwr= tpwr * 10^((gensub(/^\(/,"",1,$(NF-1))+0)/10) * 268435456/8491396
					if ($1 ~ /^A[0-7]/) power[l,2]+=tpwr
					else if ($1 ~ /^B[0-7]/) power[l,1]+=tpwr
					if (mosdebug==1) printf("power[%s,%s]=%s tpwr=%s*10^(%s/10)*268435456/8491396=%s\n",l,($1~/^A/?1:2),power[l,($1~/^A/?1:2)],pwrClass,gensub(/^\(/,"",1,$(NF-1))+0,tpwr)
				}
				#modularized TX, command "txm"
				#TXBRANCH:A
				#currPwr 4780 mBm 60.256 W "60W"
				#TXBRANCH:B
				#currPwr 4300 mBm 19.9526 W "20W"
				else if ($NF~/^TXBRANCH:[AB]$/) currTxBranch=gensub(/^.*:/,"",1,$0)
				else if ($1=="currPwr") pwrClassTxm[currTxBranch]=$4
				#legacy, command "db list"
				#/pa/currentPowerClass            S    char
				#					20W
				#					3700dBm
				else if (NF==1 && $1 ~ /^[0-9]+W$/) pwrClass=gensub(/W$/,"",1,$1)+0
				else if (NF==1 && $1 ~ /^[0-9]+00dBm$/) pwrClass=10^((gensub(/00dBm$/,"",1,$1)-30)/10)
				else if ($1=="CurrentTx:") tx=$2+0
				else if ($1=="vswr:")
				{
					y=tx
					rl[y]=gensub(/\[.*$/,"",1,$2)+0
					if (rl[y]>0) vswr[l,y]=sprintf("%.2f (%.1f)",(1+10^(-rl[y]/20))/(1-10^(-rl[y]/20)),rl[y])
					else vswr[l,y]="-"
				}
				else if (/unable to measure VSWR|Unknown VSWR problem|Could not find VSWR supervision|error. Type 'te log read' for more info/)
				{
					y=tx
					rl[y]="-"
				}
				#Antenna quality fuia get antquality
				else if ($0 ~ /^[ \t]*[1-9][0-9]*$/  && vswr[l,tx]=="") vswr[l,tx]="AntQ: "$1
				#else if ($1 == "error" && $2 ~ /^(RE|[1-9])$/) vswr[l,tx]="AntQ: "($2~/^[1-9]$/?"-":"") $2
			}
		}
		#
		if (vswr[l,1]=="") vswr[l,1]=0
		if (vswr[l,2]=="") vswr[l,2]=0
		if (warp3==1) { power[l,1]+=0 ; power[l,2]+=0 }
		else if (name[l] !~ /^RRUL11/)
		{
			#2 TX: RRUS11, RRUS61, RRUS12, mRRUS12 (RRUS12m), mRRUS61 (RRUS61m), RRUS13, maybe more?
			#1 TX: RRUS01, RRUS02, RRUW, RRU11, RRU22
			power[l,1]=(p_index[1]+p_index[2]+p_index[3]+p_index[4])*16384*(pwrClass!=0?pwrClass:pwrClassTxm["A"])/(1228800*8491396)
			if (name[l] ~ /^m?RRU/ && name[l] !~ /^RRU([12W]|S0)/) power[l,2]=(p_index[5]+p_index[6]+p_index[7]+p_index[8])*16384*(pwrClass!=0?pwrClass:pwrClassTxm["B"])/(1228800*8491396)
			else power[l,2]=vswr[l,2]="N/A"
		}
		if (name[l] !~ /^RRUL11/)
		{
			if (power[l,1]+0 > 0) power[l,1]=sprintf("%.1f (%.1f)",power[l,1],10*log(power[l,1]*1000)/log(10))
			if (power[l,2]+0 > 0) power[l,2]=sprintf("%.1f (%.1f)",power[l,2],10*log(power[l,2]*1000)/log(10))
		}
	}
	if (pid[l] ~ rrul8Prod || name[l] ~ rrul8Name || pid[l] ~ rru82Prod || name[l] ~ rru82Name)
	{
		TX8=1
	}
	else if (pid[l] ~ rrus6Prod || name[l] ~ rrus6Name)
	{
		TX6=1
	}
	else if ((pid[l] ~ rrus4Prod || name[l] ~ rrus4Name)&&(!(pid[l] ~ rrus2Prod || name[l] ~ rrus2Name)))   #ODM 4TX, NOT RR22F1
	{
		TX4=1
	}
	else if (pid[l] ~ rrul6Prod || name[l] ~ rrul6Name)
	{
		rbsPwrInfo=sprintf("%11s %s%11s  %s%-11s %s%-11s",power[l,1],sep,power[l,2],sep,vswr[l,1],sep,vswr[l,2])
	}
	else if (is_6000 != 1) rbsPwrInfo=sprintf("%11s %s%11s  %s%-11s %s%-11s","-",sep,"-",sep,"-",sep,"-")  #|| name[l] ~ /^RRUL/
	else rbsPwrInfo=sprintf("%11s %s%11s  %s%-11s %s%-11s",power[l,1],sep,power[l,2],sep,vswr[l,1],sep,vswr[l,2])
	currRu=ruSerialTable[serial[l]]

	#The two lines below are for AIR as one unit where the AuxPlugInUnit is only connected to the serial number of the AIR unit show in "par get CONTAINER_HW" but not the RRUs in "par get SYS_HW*"
	if (currRu != "") auxPiuTable[i,j,sorted_port_dev_list[k]]=currRu
	else currRu=auxPiuTable[i,j,sorted_port_dev_list[k]]

	if (length(currRu) > len["auxpiuru"]) len["auxpiuru"]=length(currRu)
	if (length(name[l]) > len["auxpiuboard"]) len["auxpiuboard"]=length(name[l])
	if (is_LTE==1)
	{
		delete tmpLteCells
		split(lteCells[currRu],array,SUBSEP)
		for (g in array) if (array[g] ~ "EUtranCell") tmpLteCells[array[g]]=array[g]
		last=asort(tmpLteCells)
		for (g=1;g<=last;g++) lteCellInfo[currRu]=lteCellInfo[currRu]" "gensub(/^.*=/,"",1,tmpLteCells[g])" ("cellData[tmpLteCells[g],"cellId"]","cellData[tmpLteCells[g],"physicalLayerCellIdGroup"]*3+cellData[tmpLteCells[g],"physicalLayerSubCellId"]")"
		sub(/^ /,"",lteCellInfo[currRu])
	}
	if (name[l]=="" && pid[l]=="" && rev[l]=="" && serial[l]=="" && pdate[l]=="") return
	if (name[l] !~ /^FU/)
	{
		cellMoreInfo[l]=sprintf("%s",(is_LTE==1?lteCellInfo[currRu]:ruCarrierTable[currRu]))
		#boardMoreInfo[l]=name[l]
		extraRbsLine[i,j,sorted_port_dev_list[k]]=sprintf("%s%s%s%s%s%s%s%s%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k],SUBSEP,name[l],SUBSEP,currRu,SUBSEP,rbsPwrInfo,SUBSEP,cellMoreInfo[l])
	}
	if (is_wcdma==1 && name[l] ~ /RU/)
	{
		match(sorted_port_dev_list[k],/port_([0-9]+)_dev_[0-9]+$/,array)
		currentRx=i"_"j"_"array[1]
		rbsRxInfo=make_rx_info(currentRx)
		extraRxLine[i,j,sorted_port_dev_list[k]]=sprintf("%s%s%s%s%s%s%s%s%s%s%s%s%s",i,SUBSEP,j,SUBSEP,sorted_port_dev_list[k],SUBSEP,name[l],SUBSEP,currRu,SUBSEP,rbsRxInfo,SUBSEP,ruCarrierTable[currRu])
		#print i,j,sorted_port_dev_list[k],extraRxLine[i,j,sorted_port_dev_list[k]]
	}
	if (name[l] ~ /XMU|AIR|^RR|TRANSCEIVER|^FU/ && xmuPrinted[serial[l]]==1) return
	cellInfo[l]=sprintf("%s",(is_LTE==1?"  "gensub(/ *\([^)]*\)/,"","g",lteCellInfo[currRu]):(currRu in ruCarrierTable?"  "ruCarrierTable[currRu]:"")))
	customPrint(sprintf("%3s %s%3s %s%-*s  %s%-*s  %s%-6s %s%-6s %s%-6s %s%-*s %s%-6s %s%-12s %s%-*s %s%4s  %s%-*s%s%s%s%s",i,sep,j,sep,len["port"],sorted_port_dev_list[k],sep,len["board"],\
name[l],sep,cabled(red[l]),sep,cabled(green[l]),sep,cabled(yellow[l]),sep,len["prod"],pid[l],sep,rev[l],sep,serial[l],sep,len["date"],pdate[l],sep,temp[l],sep,len["carrRu"],currRu,sep,cellInfo[l],sep,translate_hw(pid[l],name[l])))
	if (name[l] ~ /XMU|AIR|^RR|TRANSCEIVER|^FU/) xmuPrinted[serial[l]]=1 #xmuPrinted[l]=1
}
function make_rx_info(currentRx,   branchList,z,array,rssi1,rssi2,delta)
{
	delete branchList
	for (z in rssiBranches)
	{
		split(z,array,SUBSEP)
		if (array[1]==currentRx) branchList[array[2]]=array[2]
	}
	z=asort(branchList)
	rssi1=rssiAvg[currentRx,branchList[1]]+0
	rssi2=rssiAvg[currentRx,branchList[2]]+0
	if ((rssi2-rssi1)>0) delta=rssi2-rssi1
	else delta=rssi1-rssi2
	if (mosdebug==1) print "Debug: "currentRx,sprintf("%8s %8s %5s",rssi1,rssi2,delta)
	return sprintf("%8s %8s %5s",rssi1,rssi2,delta)
}
function cabled(string)
{
	string=toupper(string)
	if (string ~ "STEADY") string="ON"
	return string
}
function cab_print_extraRbsLine(string,l,   array,last,i)
{
	#print l,serial[l],xmuPrinted[l],xmuPrinted[serial[l]]
	last=split(string,array,SUBSEP)
	if (mosdebug==1) { for (i=1;i<=last;i++) print i,array[i] }
	if (array[4] ~ /XMU|XCU|XALM/ || xmuPrinted[l]==1) return
	customPrint(sprintf("%3s %s%3s %s%-*s  %s%-*s  %s%-*s  %s%s  %s%s",array[1],sep,array[2],sep,len["port"],array[3],sep,len["auxpiuboard"],array[4],sep,len["auxpiuru"],array[5],sep,array[6],sep,array[7]))
#	extraRbsLine[i,j,sorted_port_dev_list[k]]=sprintf("%3s %3s %-*s  %-*s  %-*s  %s  %s",i,j,len["port"],sorted_port_dev_list[k],len["auxpiuboard"],name[l],\
#len["auxpiuru"],currRu,rbsPwrInfo,(is_LTE==1?lteCellInfo[currRu]:ruCarrierTable[currRu]))
}
function cab_print_extraRxLine(string,   array)
{
	split(string,array,SUBSEP)
	if (array[4] ~ "XMU" || array[4]=="") return
	customPrint(sprintf("%3s %3s %-*s  %-*s  %-*s  %s  %s",array[1],array[2],len["port"],array[3],len["auxpiuboard"],array[4],len["auxpiuru"],array[5],array[6],array[7]))
#	extraRbsLine[i,j,sorted_port_dev_list[k]]=sprintf("%3s %3s %-*s  %-*s  %-*s  %s  %s",i,j,len["port"],sorted_port_dev_list[k],len["auxpiuboard"],name[l],\
#len["auxpiuru"],currRu,rbsPwrInfo,(is_LTE==1?lteCellInfo[currRu]:ruCarrierTable[currRu]))
}
function cab_print_node(what,  i,j)
{
	for (i=0;i<=99;i++)
	{
		if (smn_list[i]<=0) continue
		for (j=1;j<=28;j++)
		{
			#for SCXB, CMXB and CCIB, board[i,j] is 0 because they are not CPP boards and cannot be reached by lhsh
			#we only print them in the hw table
			if ((what=="hw" && productname[i,j] ~ /^(SCXB|CMXB|CCIB|SMXB)/)||(board[i,j] > 0)||(nocontact[i,j]==1)) cab_print_board(what,i,j)
		}
		if ((board[i,0] > 0) || (nocontact[i,0]==1)) cab_print_board(what,i,0)
		if (what=="hw")	customPrint("--------------------------------------------------------------------------------------------------------------------")
		else if (what=="load") customPrint("--------------------------------------------------------------------------------------------")
		else if (what=="llog") customPrint("---------------------------------------------------------------------------------------------------------------")
		else if (what=="dumpelg") customPrint("---------------------------------------------------------------------------------------------------------------")
		else if (what=="mem") customPrint("-------------------------------------------------")
	}
}
function cab_print_board(what,i,j,  k,r,output,crashPrinted)
{
	if (nocontact[i,j]==1 && what !~ /^vols/)
	{
		if (what ~ /^(hw|sw|load|mem)$/) customPrint(sprintf("%3s %s%3s  %s%s",i,sep,j,sep,"NOCONTACT"))
		else customPrint(sprintf("%02d%02d  %s",i,j,"NOCONTACT"))
		if (what=="llog") customPrint("")
		else if (what=="sw") customPrint("--------------------------------------------------------------------------------------------")
		return
	}
	if (what=="hw")
	{
		if (sysMgr==sprintf("%s,%s",i,j)) ftc[i,j]="Active"
		else if (sysMgrSB==sprintf("%s,%s",i,j))
		{
			#if (notemp==0) ftc[i,j]=sbStatus
			#else ftc[i,j]="StandBy"  #if using the "t" option the full info about standby shall not be printed, request from CPP I&V
			ftc[i,j]=sbStatus
		}
		else if (cab_core_mp_list[i,j]==1 && check_hw==2) ftc[i,j]="CoreMP"
		if (board[i,j]==2 || evoHubMp[i,j]==1) ftc[i,j]=sprintf("%s*",ftc[i,j])
		if (productname[i,j] ~ "TRX")
		{
			if (length(productname[i,j])>len["trx"]) len["trx"]=length(productname[i,j])
		}
		customPrint(sprintf("%3s %s%3s  %s%-*s  %s%-6s %s%-6s %s%-6s%s%s  %s%-14s %s%-6s %s%-10s %s%-8s %s%-4s %s%s",\
i,sep,j,sep,cabLen["board"],productname[i,j],sep,\
red[i,j],sep,green[i,j],sep,yellow[i,j],(has4Led?sprintf(" %s%-6s",sep,statled[i,j]):""),(evo_node?sprintf(" %s%3s",sep,froid[i,j]):""),\
sep,productnumber[i,j],sep,productrev[i,j],sep,serialnumber[i,j],sep,productdate[i,j],sep,temp[i,j],sep,ftc[i,j]))
	}
	else if (what=="load")
	{
		customPrint(sprintf("%3s %3s  %-9s  %7s  %s",i,j,productname[i,j],AverageLoad[i,j],SpProcessorLoad[i,j]))
		if (productname[i,j] ~ /^EPB/) customPrint(sprintf("%3s %3s  %-9s  %7s  %s",i,j,"d00001",AverageLoad[i,j"d00001"],SpProcessorLoad[i,j"d00001"]))
	}
	else if (what=="sw")
	{
		for (k=1;k<=kMax[i,j];k++) customPrint(sprintf("%3s %3s  %-*s  %-2s  %s",i,j,cabLen["board"],prodname_sw[i,j],k,swlist[i,j,k]))
		customPrint("--------------------------------------------------------------------------------------------")
	}
	else if (what=="mem")
	{
		customPrint(sprintf("%3s %3s  %-*s  %15s  %s",i,j,cabLen["board"],prodname_sw[i,j],free_mem[i,j],total_mem[i,j]))
	}
	else if (what=="te")
	{
		for (r=1;r<=teMax[i,j];r++)
		{
			customPrint(sprintf("%02d%02d  %-*s  %-30s  %-9s  %s",i,j,cabLen["board"],productname[i,j],teproc[i,j,r],testat[i,j,r],tegroups[i,j,r]))
		}
	}
	else if (what=="llog")
	{
		for (r=1;r<=rMax[i,j];r++)
		{
			if (restartError[i,j,r] == "") continue
			if (restartCause[i,j,r] ~ /0x0010:/ || restartCause[i,j,r] == "") restartCause[i,j,r]=restartCauseShort[i,j,r]
			output=sprintf("%02d%02d  %-*s  %-17s",i,j,cabLen["board"],productname[i,j],restartTime[i,j,r])
			if (osSupported==1) output=sprintf("%s  %-9s  %-6s",output,restartType[i,j,r],restartOS[i,j,r])
			output=sprintf("%s  %-20s  %-10s  %s%s",output,restartProcess[i,j,r],restartError[i,j,r],restartCause[i,j,r],restartPMD[i,j,r])
			if ((cpplinux==0 && restartError[i,j,r] !~ /1010[9ABCDEF]|0xB0AD|0x83482104/) || (restartPMD[i,j,r] != "" && pmdSupported==1))
			{
				if (check_crash==1 || show_colors != 1) { customPrint(output) ; crashPrinted[i,j]=1 }
				else customPrint(sprintf("\33[31m%s\33[0m",output))
			}
			else if (check_crash != 1) customPrint(output)
		}
		if (j!=0 && ((rMax[i,j] > 0 && check_crash != 1)||(check_crash==1 && crashPrinted[i,j]==1))) customPrint("")
	}
	else if (what=="dumpelg")
	{
		for (r=1;r<=elgcount_max[i,j];r++) customPrint(sprintf("%02d%02d  %-*s  %s",i,j,cabLen["board"],productname[i,j],dumpelg[i,j,r]))
		if (elgcount_max[i,j] > 0) customPrint("")
	}
	else if (what=="volsp")
	{
		#dont print "nocontact" here
		if (globalDisk[sprintf("/p%02d%02d00",i,j)] !="") customPrint(globalDisk[sprintf("/p%02d%02d00",i,j)])
	}
	else if (what=="volsd")
	{
		if (nocontact[i,j]==1) customPrint(sprintf("%02d%02d  %s",i,j,"NOCONTACT"))
		else if (localDisk[i,j,"/d"] != "") customPrint(sprintf("%02d%02d  %s",i,j,localDisk[i,j,"/d"]))
	}
	else if (what=="volsf")
	{
		if (nocontact[i,j]==1) customPrint(sprintf("%02d%02d  %s",i,j,"NOCONTACT"))
		else if (localDisk[i,j,"/f"] != "") customPrint(sprintf("%02d%02d  %s",i,j,localDisk[i,j,"/f"]))
	}
}
function translate_duw(productnr)
{
	if (productnr=="KDU127161/1") return "DUW1001"
	else if (productnr=="KDU127161/2") return "DUW2001"
	else if (productnr=="KDU127161/3") return "DUW3001"
	else if (productnr=="KDU127174/1") return "DUW1101"
	else if (productnr=="KDU127174/2") return "DUW2101"
	else if (productnr=="KDU127174/3") return "DUW3101"
	else if (productnr=="KDU127174/4") return "DUW4101"
	else return "DUW"
}

function parseCabLine(what,   result)
{
	result=""
	if (/LOGGING INTO BOARD:/) { gsub(/[$]/,"") ; gsub(/^ */,"") }
	if (/^LOGGING INTO BOARD:/)
	{
		i=$4
		j=$5
		curcore=-1
	}
	else if (/capi prio$/) curcore=-1
	else if ((NF > 7 && $3=="check" && /check .*error .*info .*interface .*object/ && teproc[i,j,$2] !~ "enabled:")||\
	         (NF > 5 && ($3=="error" || $3=="check") && /error .*info .*trace9/ && teproc[i,j,$2] !~ "enabled:" && productname[i,j]~/^MSB/)||\
	         (NF > 4 && $3=="error" && /error .*info / && teproc[i,j,$2] !~ "enabled:" && productname[i,j]!~/^MSB/))
	{
		#       - UehRabHandlingC[177]            check error info interface object
		#00010055 Sys_Spas_link_proc                            check error info interface object
		#        - DSP1/6   error info trace9
		#        - DEC0_Scheduler error info
		if (teproc[i,j,$2]~"saved:") testat[i,j,gensub(/^.*:/,"",1,teproc[i,j,$2])]="ena&saved"
		else
		{
			teMax[i,j]++
			teproc[i,j,teMax[i,j]]=$2
			teproc[i,j,$2]=testatus":"teMax[i,j]
			testat[i,j,teMax[i,j]]=testatus
			tegroups[i,j,teMax[i,j]]=gensub(/^ *[^ ]+ +[^ ]+ +|(check|error|info|interface|object)/,"","g",$0)
			if (productname[i,j]~/^MSB/) sub(/trace9/,"",tegroups[i,j,teMax[i,j]])
			gsub(/^ *| *$/,"",tegroups[i,j,teMax[i,j]])
			gsub(/  +/," ",tegroups[i,j,teMax[i,j]])
		}
	}
	else if (/EnabledTraces:$/) testatus="enabled"
	else if (/SavedTraces:$/) testatus="saved"
	else if (/(lhsh|rcmd): failed to connect/) nocontact[i,j]=1
	else if (tolower($NF) ~ /\/(telnet|sshd_handler)_/) nr_of_users++
	#the (^|[^_]) is used so we dont match lines like pba_productnumber in DU board, TR WRNae68828
	else if (tolower($1) ~ /(^|[^_])product_*number/)
	{
		productnumber[i,j]=gensub(/[ \t"]/,"","g",gensub(/^.*=/,"","g",$0))
		if (productname[i,j] == "GPB" && productnumber[i,j] ~ /\/[6-9]/) productname[i,j]=prodname_sw[i,j]="GPB"gensub(/^.*\//,"",1,productnumber[i,j])
		else if (productname[i,j] == "SPB" && productnumber[i,j] ~ /\/51/) productname[i,j]=prodname_sw[i,j]="SPB31"
		else if (productname[i,j] == "SPB" && productnumber[i,j] ~ /\/5/) productname[i,j]=prodname_sw[i,j]="SPB3"
		else if (productname[i,j] == "SPB" && productnumber[i,j] ~ /\/1/) productname[i,j]=prodname_sw[i,j]="SPB4"
		else if (productname[i,j] == "TUB" && productnumber[i,j] ~ /\/4/) productname[i,j]=prodname_sw[i,j]="TUB2"
		else if (productname[i,j] == "DUW") productname[i,j]=prodname_sw[i,j]=translate_duw(productnumber[i,j])
	}
	else if (tolower($1) ~ /(^|[^_])productname|_board_type/)
	{
		productname[i,j]=gensub(/^.*=|[ \t"]/,"","g",$0)
		prodname_sw[i,j]=gensub(" ","","g",gensub(/^.*=/,"","g",$0))
		if (productname[i,j] == "GPB" && productnumber[i,j] ~ /\/[6-9]/) productname[i,j]=prodname_sw[i,j]="GPB"gensub(/^.*\//,"",1,productnumber[i,j])
		else if (productname[i,j] == "SPB" && productnumber[i,j] ~ /\/51/) productname[i,j]=prodname_sw[i,j]="SPB31"
		else if (productname[i,j] == "SPB" && productnumber[i,j] ~ /\/5/) productname[i,j]=prodname_sw[i,j]="SPB3"
		else if (productname[i,j] == "SPB" && productnumber[i,j] ~ /\/1/) productname[i,j]=prodname_sw[i,j]="SPB4"
		else if (productname[i,j] == "TUB" && productnumber[i,j] ~ /\/4/) productname[i,j]=prodname_sw[i,j]="TUB2"
		else if (productname[i,j] == "DUW") productname[i,j]=prodname_sw[i,j]=translate_duw(productnumber[i,j])
	}
	else if (tolower($1) ~ /(^|[^_])productdate/) productdate[i,j]=gensub(/^.*=|"/,"","g",$0)
	else if (tolower($1) ~ /(^|[^_])productrev/)  productrev[i,j]=gensub(/^.*=|"/,"","g",$0)
	else if (tolower($1) ~ /(^|[^_])serialnumber/) serialnumber[i,j]=gensub(/^.*=|"/,"","g",$0)
	else if ($1 == "GREEN") green[i,j]=gensub(/^.*_/,"","g",gensub("UNDEFINED","?",1,$2))
	else if ($1 == "RED")   red[i,j]=gensub(/^.*_/,"","g",gensub("UNDEFINED","?",1,$2))
	else if ($1 == "YELLOW" || $1 == "BLUE")
	{
		#On DUWv2 and ODS the yellow led is for Status and the blue is for Maintenance
		#On older boards there is only Maintenance (no Status led) and it can be blue or yellow
		if (has4Led==1 && $1=="YELLOW") statled[i,j]=gensub(/^.*_/,"","g",gensub("UNDEFINED","?",1,$2))
		else yellow[i,j]=gensub(/^.*_/,"","g",gensub("UNDEFINED","?",1,$2))
	}
	else if (tolower($0) ~ /temperature:|sensor:/ && indumpelg!=1)
	{
		#print $0
		#ppctemp:  PowerPC 750 chip temperature: +29C
		#ppctemp:  PowerPC chip temperature: +29C
		#boardtemp: Board temperature: 30 Celsius on sensor: 0
		#temprt: Sensor: 1.(UP): 34 C     2.(BOT): 31 C     3.(MID): 36 C
		#dbc3tvs: Core temperature = 54 C (4 ms)
		if (NF > 1 && $(NF-1) ~ "temperature") temp[i,j]=$NF
		else if ($1 ~ "Sensor:" && $(NF-1) ~ /^[0-9]+$/) temp[i,j]="+"$(NF-1)"C"
		else if (NF > 4 && $(NF-4) ~ /^[0-9]+$/) temp[i,j]="+"$(NF-4)"C"
	}
	else if (check_load==1 && $1 == "Core" && $2 ~ /^[0-1]:$/) curcore=gensub(/:/,"",1,$2)+0
	else if (check_load==1 && $1 == "bg" && NF==11 && $2~/^[0-9]+$/)
	{
		avgload=sprintf("%4.1f",100-($2+$3+$4+$5+$6+$7+$8+$9+$10+$11)/10)
		if (curcore==-1) AverageLoad[i,j]=avgload
		else if (curcore==0) SpProcessorLoad[i,j]=" "avgload
		else if (curcore==1)
		{
			AverageLoad[i,j]=sprintf("%4.1f",(SpProcessorLoad[i,j]+avgload)/2)
			SpProcessorLoad[i,j]=SpProcessorLoad[i,j]" "avgload
		}
		if (productname[i,j]~/^SPB/) rerun[i,j]=1
	}
	else if (/^Load module id:/)
	{
		kMax[i,j]++
		swlist[i,j,kMax[i,j]]=$4
	}
	else if (/^Load module path:/)
	{
		#Load module path: @(#)/vobs/cello/babs/control_dm/ebos_mp_bp_lm/ebos.ppc
		#Load module path: @(#)/vobs/cello/osa_src/control_dm/loader_server_mp_bp_lm loaderserver.ppc ppc cppswdi_lmbuild_loaderservermpbp_cpp7_2
		#Load module path: @(#)/vobs/cello/osa_src/control_dm/database_mp_lm/.lmopt/lm database.ppc ppc cppswdi_lmbuild_databasemp_cpp7_2
		#Load module path: @(#)/vobs/rnc/rrt/rncNode/rncSys/rncLm/rncLmCenAgpsLmU/model/RncLmCenAgpsLmU_mp750_EXE/build RncLmCenAgps ppc elmcm002_lmbuildmd_wendy_cenagps_standard_1.1_tmp2
		#Load module path: @(#)/vobs/cello/iexs_src/int_tran_dm/iell_basic_bcm5389_bp_lm/.lmopt/lm /vobs/cello/iexs_src/int_tran_dm/iell_basic_bcm5389_bp_lm/.lmopt/lm/iell_basic_bcm5389_bp_lm.ppc ppc cppswdi_lmbuild_iellbasicbcm5389bp_cbm3_1
		#Load module path: @(#)/repo/cpp.sub.0/tools/loco/sys_int_test_dm/loco_sps_ip_lm /repo/cpp.sub.0/tools/loco/sys_int_test_dm/loco_sps_ip_lm/loco_sps_ip.ppc ppc
		#Load module path: @(#)/repo/cpp.sub.3/control/control_dm/bos_evoet_mp_lm/bos_evoet_mp.ppc ** NONE **

		swinfo=$5
		#### swinfo=$4
		if (swinfo == "" || swinfo ~ "/" || swinfo !~ /^[a-zA-Z]/)
		{
			if (swlist[i,j,kMax[i,j]] ~ /^CXC1321447_/) swinfo="gpb_cs_basic (flash)"
			else if (swlist[i,j,kMax[i,j]] ~ /^CXC1321447_/) swinfo="ebos_mp_bp (flash)"
			else if (swlist[i,j,kMax[i,j]] ~ /^CXC1322812_/) swinfo="gpb_pqii_patch (flash)"
			else if (swlist[i,j,kMax[i,j]] ~ /^CXC1321451_/) swinfo="dbm_cs_basic (flash)"
			else if (swlist[i,j,kMax[i,j]] ~ /^CXC1322025_/) swinfo="dbm_fpga_loaderpatch (flash)"
			else if (swlist[i,j,kMax[i,j]] ~ /^CXC1322250_/) swinfo="dbm2_cs_basic (flash)"
			else if (swlist[i,j,kMax[i,j]] ~ /^CXC1323195_/) swinfo="rax_bp (flash)"
			else
			{
				buildLmidTable();
				if (gensub(/_.*$/,"",1,swlist[i,j,kMax[i,j]]) in lmidLookupTable) swinfo=lmidLookupTable[gensub(/_.*$/,"",1,swlist[i,j,kMax[i,j]])]
			}
		}
		### swinfo=gensub(/^.*\//,"","g",swinfo)
		### swinfo=gensub(/_lm$/,"","g",swinfo)
		### if (swinfo ~ /^(build|lm)$/) swinfo=$5
	}
	else if (/^Load module version:/)
	{
		altswinfo=$(NF-1)
		if (swinfo ~ /^$|^lm$|^target$|^target_sr$|^build$|^bp_lm_target$|^build_sr$|^build_BP_lm$|^CXC|^load2$/)
			swlist[i,j,kMax[i,j]]=sprintf("%-22s  %s",swlist[i,j,kMax[i,j]],altswinfo)
		else swlist[i,j,kMax[i,j]]=sprintf("%-22s  %s",swlist[i,j,kMax[i,j]],swinfo)
	}
	#OSE llog:
	else if (($1 ~ /^[0-9]+\.$/) && ($2 == "Time"))
	{
		rMax[i,j]++   #; print rMax[i,j], $1
		restartTime[i,j,rMax[i,j]]=sprintf("%s %s",gensub(",","","g",$4),$5)
	}
	else if ($1 ~ /^(Error|Restart)$/ && $2 == "code" && $3 == ":") restartError[i,j,rMax[i,j]]=$4
	else if ($1 == "Process" && $2 == ":") restartProcess[i,j,rMax[i,j]]=$3
	else if ($1 == "Restart" && $2 == "type" && $3 == ":") restartType[i,j,rMax[i,j]]=$4
	else if (/OS Run Mode[ \t]*:/) { restartOS[i,j,rMax[i,j]]=$5 ; osSupported=1 }
	else if ($1 == "PMD" && $2 == "identity" && $3 == ":")
	{
		pmdSupported=1
		restartPMD[i,j,rMax[i,j]]=$4
		if (restartPMD[i,j,rMax[i,j]]=="-") restartPMD[i,j,rMax[i,j]]=""
		else restartPMD[i,j,rMax[i,j]]=sprintf(" (%s)",restartPMD[i,j,rMax[i,j]])
	}
	else if (/Error Description/) restartCause[i,j,rMax[i,j]]=$NF
	else if (/Error Information:/) inerrorinformation=1
	else if (inerrorinformation==1)
	{
		if ($1=="0x03E8:" && $2 ~ /^[0-9A-F][0-9A-F]$/ && $10 ~ /^"........"$/)
		{
			customPrint(sprintf("\n!!!!! llog -l is corrupted in board %02d%02d00. Please run command: lhsh %02d%02d00 llog -c . Exiting...\n",i,j,i,j))
			exit
		}
		else if (/^-----------------------/ || (/EndOf(Board)*Print/ && /^[^"]*$/))
		{
			restartCause[i,j,rMax[i,j]]=gensub(/^[ \t]+|----------.*$|\$.*$/,"","g",restartCause[i,j,rMax[i,j]])
			restartCause[i,j,rMax[i,j]]=gensub(/[ \t]+/," ","g",restartCause[i,j,rMax[i,j]])
			if (restartCause[i,j,rMax[i,j]] ~ /0x0010:/) rerunLlog[i,j]=1
			inerrorinformation=0
		}
		else
		{
			#Error Information:
			#0x0000: 52 65 63 6F 76 65 72 79    "Recovery"
			#0x0008: 20 61 63 74 69 6F 6E 2C    " action,"
			if ($1 ~ /^0x[0-9A-F][0-9A-F][0-9A-F][0-9A-F]:$/) { gsub(/^[^"]+"|"[^"]*$/,"") ; gsub(/\./,"") }
			restartCause[i,j,rMax[i,j]]=sprintf("%s %s",restartCause[i,j,rMax[i,j]],$0)
		}
	}
	#CPP linux llog:
	#No:       1
	#Reason:   Restart request
	#Time:     2015-12-09 07:06:38
	#Program:  Board Manager
	#Pid:      -
	#Rank:     Cold
	#Signal:   -
	#PMD:      -
	#Extra:    Restart due to restart of PIU
	else if (cpplinux==1 && NF==2 && $1=="No:" && $2~/^[0-9]+$/) { rMax[i,j]++                                              }
	else if (cpplinux==1 && NF==3 && $1=="Time:")                { restartTime[i,j,rMax[i,j]]=sprintf("%s %s",gensub(/^../,"",1,$2),$3)        }
	else if (cpplinux==1 && $1=="Reason:")                       { restartProcess[i,j,rMax[i,j]]=gensub(/^[^:]+: +| +$/,"","g",$0)  }
	else if (cpplinux==1 && $1=="Program:")                      { restartError[i,j,rMax[i,j]]=gensub(/^[^:]+: +| +$/,"","g",$0)}
	else if (cpplinux==1 && $1=="Pid:")
	{
		restartCause[i,j,rMax[i,j]]=gensub(/^[^:]+: +| +$/,"","g",$0)
		if (restartCause[i,j,rMax[i,j]]=="-") restartCause[i,j,rMax[i,j]]=""
		else restartCause[i,j,rMax[i,j]]=sprintf("(%s)",restartCause[i,j,rMax[i,j]])
	}
	else if (cpplinux==1 && $1=="Extra:")                        { restartCause[i,j,rMax[i,j]]=restartCause[i,j,rMax[i,j]]" "gensub(/^[^:]+: +/,"",1,$0) }
	else if (cpplinux==1 && $1=="Rank:")                         { restartProcess[i,j,rMax[i,j]]=restartProcess[i,j,rMax[i,j]]" "gensub(/^[^:]+: +/,"",1,$0)  }
	else if (cpplinux==1 && $1=="PMD:")
	{
		pmdSupported=1
		restartPMD[i,j,rMax[i,j]]=gensub(/^[^:]+: +| +$/,"","g",$0)
		if (restartPMD[i,j,rMax[i,j]]=="-") restartPMD[i,j,rMax[i,j]]=""
		else restartPMD[i,j,rMax[i,j]]=sprintf(" (%s)",restartPMD[i,j,rMax[i,j]])
	}

	else if ($2 ~ /^(port_(xcu|[0-9]+)_dev|BXP_[0-9]+.*\/)/)
	{
		#if ($2 ~ /^BXP_[0-9]+_[0-9]+/) is_LTE=1  --> there is also BXP on WCDMA RBS6000
		#000700fa port_0_dev_2/ose_she ph  CXC1323891%1_R23   0 -
		#000100f4 port_4_dev_3/FuCbcSe ph  CXC1323891%1_R23   0 -
		#0001010d port_4_dev_5/fuCbcSe ph  CXC1323891%1_R35   0 -
		#00010351 BXP_3_1/radioTrDcSer ph  BXP_3_1            0 -
		#01060541 port_0_dev_5/port_0_dev_11/tmaCdciServer   ph  port_0_dev_5   0 -
		#000105e1 port_xcu_dev_7/port_0_dev_8/aiServer         ph  port_xcu_dev_7        0 -
		#00010585 port_18_dev_12Pht    ph  CXC1323891%4_R14E01   0 -   --> don't use these
		last=split($2,portarray,"/")
		if (portarray[2] ~ /^port_(xcu|[0-9]+)_dev_[0-9]+$/) currportdev=portarray[1]"/"portarray[2]
		else currportdev=portarray[1]
		#port_0_dev_239 and above is for common support system (HwUnit MOs) and cannot be reached by OSE shell
		#0001054a port_0_dev_251/port_0_dev_251/ose_shelld ph  port_0_dev_251   0 -
		#11b10535 port_0_dev_251/ose_shelld                ph  port_0_dev_251   0 -
		#00010481 port_0_dev_251/port_0_dev_251/           ph  port_0_dev_251   0 -
		#0002047e port_0_dev_251/EC_Main                   ph  port_0_dev_251   0 -
		#00010480 port_0_dev_251/                          ph  port_0_dev_251   0 -
		if (currportdev ~ /port_0_dev_[2-9][0-9][0-9]/) return result
		port_dev[i,j,currportdev]=1
		port_dev_list[currportdev]=currportdev
		if (length(currportdev) > len["port"]) len["port"]=length(currportdev)
		if (portarray[last] ~ /[fF]uCbc/) additional_xp_command_list[i,j,currportdev]=sprintf("%s%s%s",portarray[last],SUBSEP,"au3vii;fui get ee pid")
	}
	else if ($1 ~ /^\/(c|[pr][0-9][0-9][0-9][0-9]00)$/ && $4 ~ /^[0-9]+%$/)
	{
		diskUsage=gensub(/%/,"","g",$4)+0
		if (diskUsage >= redlimit && show_colors==1) globalDisk[$1]=sprintf("\33[31m%s\33[0m",$0)
		else if (diskUsage >= purplelimit && show_colors==1) globalDisk[$1]=sprintf("\33[35m%s\33[0m",$0)
		else globalDisk[$1]=$0
	}
	else if ($1 ~ /^\/(f|d)$/ && $4 ~ /^[0-9]+%$/)
	{
		diskUsage=gensub(/%/,"","g",$4)+0
		volsline=sprintf("%-13s  %-4s  %s",$1,((i,j) in volslm?volslm[i,j]:"-"),gensub(/^[^ ]+ +/,"",1,$0))
		if (diskUsage >= redlimit && show_colors==1) localDisk[i,j,$1]=sprintf("\33[31m%s\33[0m",volsline)
		else if (diskUsage >= purplelimit && show_colors==1) localDisk[i,j,$1]=sprintf("\33[35m%s\33[0m",volsline)
		else localDisk[i,j,$1]=volsline
	}
	else if ($1=="Mount" && $2=="Status:")
	{
		if ($3=="Active") sysMgr=sprintf("%s,%s",i,j)
		else if ($3=="Passive") sysMgrSB=sprintf("%s,%s",i,j)
	}
	else if ($1=="Peer" && $2=="Disk" && $3=="Status:")
	{
		if ($4=="Valid") sbStatus="StandbyReady"
		else if ($4=="Syncing") sbStatus="StandbySync"
	}
	else if ($1=="Write" && $2=="Log:" && $3 !="Empty" && sbStatus !~ /Sync|Ready/) sbStatus="StandbyWriting"
	else if ($1=="Sync" && $2=="Progress:") sbStatus=sprintf("StandbySync-%s%",$3)
	else if (/^seqN. +date +time +message/) indumpelg=1
	else if ($2=="ENTRIES:" || $1=="NONE!" || /llog : Error log empty./ || /^----------/) indumpelg=0
	else if (indumpelg==1 && NF > 0)
	{
		elgcount_max[i,j]++
		#align the timestamps
		#9     031110 030845 L S Active faultlist empty, RAX_DISABLE_OPERATION_REQ received from MP; BBCLK-BFN
		#10     031110 030845 L D Active fault list empty, UBCH_DISABLE_OPERATION_REQ received from MP
		if (length($1)>1) $0=gensub(/ /,"",length($1),$0)
		dumpelg[i,j,elgcount_max[i,j]]=$0
	}
	#CPP4:
	#Free bytes: 345337856 bytes = 329,3 Mbytes
	#CPP5:
	#Total Memory:
	#   67043328 (0x3ff0000) bytes = 63,9 Mbytes
	#Free Memory:
	#   54722560 (0x3430000) bytes = 52,2 Mbytes  (81%)
	#Used Memory:
	#   12320768 (0xbc0000) bytes = 11,7 Mbytes  (19%)
	#CPP7:
	#               total       used   inactive       free #frags largest_frag  watermark
	#     RAM: 0x40000000 0x2957b000          0 0x16a85000      2   0x169b2000 0x169b2000
	#CPP8:
	#    total        free    largest_frag   watermark     #frags name
	#0x100000000  0x0e74ae000  0x080000000  0x0e74ae000        4  RAM

	else if (($1=="RAM:")||($6=="RAM"))
	{
		if ($1=="RAM:") tmpfreemem=sprintf("%d",strtonum($5))
		else if ($6=="RAM") tmpfreemem=sprintf("%d",strtonum($2))
		#Memory GPB2/GPB3 is segmented, ignore the figure in the printout and take the hardcoded value
		if (prodname_sw[i,j] ~ /^GPB[23][12]?$/ || productnumber[i,j] ~ /^ROJ ?119 ?2106\/2$/)
		{
			#Some GPB2 are just called "GPB"
			if (prodname_sw[i,j] in total_mem)
			{
				tmptotmem=total_mem[prodname_sw[i,j]]*1024*1024
				total_mem[i,j]=total_mem[prodname_sw[i,j]]" MB"
			}
			else
			{
				tmptotmem=256*1024*1024
				total_mem[i,j]="256 MB"
			}
		}
		else
		{
			if ($1=="RAM:") tmptotmem=sprintf("%d",strtonum($2))
			else if ($6=="RAM") tmptotmem=sprintf("%d",strtonum($1))
			total_mem[i,j]=sprintf("%.1f",tmptotmem/(1024*1024))" MB"
		}
		free_mem[i,j]=sprintf("%.1f",tmpfreemem/(1024*1024))" MB ("int(mDiv(tmpfreemem*100,tmptotmem))"%)"
	}
	else if (/^Free bytes: [0-9]+/)
	{
		free_mem[i,j]=$6" "toupper(gensub(/ytes/,"",1,$7))
		if (prodname_sw[i,j] in total_mem)
		{
			total_mem[i,j]=total_mem[prodname_sw[i,j]]" MB"
			free_mem[i,j]=$6" "toupper(gensub(/ytes/,"",1,$7))" ("int(($6+0)*100/total_mem[prodname_sw[i,j]])"%)"
		}

	}
	else if (/^Total Memory: *$/) intotalmem=1
	else if (intotalmem==1) { total_mem[i,j]=$5" "toupper(gensub(/ytes/,"",1,$6)) ; intotalmem=0 }
	else if (/^Free Memory: *$/) infreemem=1
	else if (infreemem==1) { free_mem[i,j]=$5" "toupper(gensub(/ytes/,"",1,$6))" "$7 ; infreemem=0 }
	else if (/Directory .\/d\/loadmodules./) indloadmodules=1
	else if (indloadmodules==1 && $1 ~ /^-r/) volslm[i,j]++
        # $ getAttrObj piu -d 000200
        # piu Id  2
        # Administrative Data:
        #         Slot Id         2
        #         Role            XB
        #         GroupNumber     0
        #         State           UNLOCKED
        #         Product No      ROJ 208 392/1   R3
        #         Product Name    CMXB3
        #         Product Date
        #         Product Ser. No
        #         AllowedRestarts 3
        #         dVolFreeLim     0
        #         Red Led         CELLO_LED_NOT_APPLICABLE
        #         Green Led       CELLO_LED_NOT_APPLICABLE
        #         Yellow Led      CELLO_LED_NOT_APPLICABLE
        #         Fault Led       CELLO_LED2_OFF
        #         Maintenance Led CELLO_LED2_OFF
        #         Operational Led CELLO_LED2_STEADY_ON
        #         Status Led      CELLO_LED2_OFF
        # Operative Data:
        #         State           ENABLED
        # Availability Status:    NO STATUS
        # HW Test Status:         HW TEST NOT PERFORMED
        # $ getAttrObj slot -p 000200
        # Slot Id 2
        #         Subrack Id      1
        #         Slot Nr         2
        # Operative Data:
        #         Used    2
        #         Product No      ROJ 208 392/1   R3A
        #         Product Name    CMXB3 EGEM2
        #         Product Date    20110126
        #         Product Ser. No A064334355

	# On CMXB1 (3820) we use Green/Red/Yellow
	# piu Id   82
	# Administrative Data:
	#  Slot Id         82
	#  Role            CMXB
	#  GroupNumber     0
	#  State           UNLOCKED
	#  Product No      ROJ 208 504/1   *
	#  Product Name    CMXB
	#  Product Date
	#  Product Ser. No
	#  AllowedRestarts 3
	#  dVolFreeLim     0
	#  Red Led         CELLO_LED_OUT
	#  Green Led       CELLO_LED_STEADY_LIGHT
	#  Yellow Led      CELLO_LED_OUT
	#  Fault Led       CELLO_LED2_NOT_AVAILABLE
	#  Maintenance Led CELLO_LED2_NOT_AVAILABLE
	#  Operational Led CELLO_LED2_NOT_AVAILABLE
	#  Status Led      CELLO_LED2_NOT_AVAILABLE
	# Operative Data:
	#  State           ENABLED
	# Availability Status:     NO STATUS
	# HW Test Status:  HW TEST NOT PERFORMED
	# SVS Status:      DISABLED

	else if (($1=="Used" || $1=="SlotState") && NF==2 && $2 ~ /^[0-9]$/)
	{
                slotstate[i,j]=$2

		# Check that there is a board in the slot except for CMXB/SCXB/CCIB/SMXB
	        if (productname[i,j] !~ /^(CMX|SCX|CCI|SMX)/ )
		{
			if ($2==2) board[i,j]=apn_list[i,j]=1
			else
			{
				productname[i,j]=productdate[i,j]=serialnumber[i,j]=productnumber[i,j]=productrev[i,j]=""
			}
		}
	}
	else if ($1=="piu" && $2=="Id" && NF==3 && $3 ~ /^[0-9]+$/) froid[i,j]=$3
	#sometimes the serial number is written next to the product name, take only the third word
	#else if ($1=="Product" && $2=="Name" && NF>=3) productname[i,j]=gensub(/^.*Product Name[ \t]*|[ \t]*$/,"","g",gensub(/EGEM2.*$/,"",1,$0))
	else if ($1=="Product" && $2=="Name" && NF>=3 && slotstate[i,j]!=3)
	{
		productname[i,j]=gensub(/EGEM2.*$/,"",1,$3)
		if (productname[i,j] == "GPB" && productnumber[i,j] ~ /\/[6-9]/) productname[i,j]=prodname_sw[i,j]="GPB"gensub(/^.*\//,"",1,productnumber[i,j])
		else if (productname[i,j] == "SPB" && productnumber[i,j] ~ /\/51/) productname[i,j]=prodname_sw[i,j]="SPB31"
		else if (productname[i,j] == "SPB" && productnumber[i,j] ~ /\/5/) productname[i,j]=prodname_sw[i,j]="SPB3"
		else if (productname[i,j] == "SPB" && productnumber[i,j] ~ /\/1/) productname[i,j]=prodname_sw[i,j]="SPB4"
		else if (productname[i,j] == "TUB" && productnumber[i,j] ~ /\/4/) productname[i,j]=prodname_sw[i,j]="TUB2"
		else if (productname[i,j] == "DUW") productname[i,j]=prodname_sw[i,j]=translate_duw(productnumber[i,j])
	}
	else if ($1=="Product" && $2=="Date" && NF>=3 && slotstate[i,j]!=3) productdate[i,j]=gensub(/^.*Product Date[\t ]*|[ \t]*$/,"","g",$0)
	else if ($1=="Product" && $2=="Ser." && $3=="No" && NF>=4 && slotstate[i,j]!=3) serialnumber[i,j]=gensub(/^.*Product Ser. No[\t ]*|[ \t]*$/,"","g",$0)
	else if ($1=="Product" && $2=="No" && NF >= 3 && slotstate[i,j]!=3)
	{
		productnumber[i,j]=gensub(/^.*Product No[\t ]*/,"",1,$0)
		productrev[i,j]=gensub(/^ROJ[0-9 ]+\/[0-9A-Z]+[\t ]*/,"",1,productnumber[i,j])
		gsub(productrev[i,j],"",productnumber[i,j])
		gsub(/[\t ]*/,"",productnumber[i,j])
		gsub(/[\t ]*/,"",productrev[i,j])
	}
	else if ($2=="Led"&&((what=="oldled" && $1=="Green")||(what=="" && $1=="Operational"))) green[i,j]=EGEM_LED[gensub(/^.*(Operational|Green) Led[\t ]*CELLO_LED2?_/,"",1,$0)]
	else if ($2=="Led"&&((what=="oldled" && $1=="Red")||(what=="" && $1=="Fault"))) red[i,j]=EGEM_LED[gensub(/^.*(Fault|Red) Led[\t ]*CELLO_LED2?_/,"",1,$0)]
	else if ($1=="Status" && $2=="Led") statled[i,j]=EGEM_LED[gensub(/^.*Status Led[\t ]*CELLO_LED2_/,"",1,$0)]
	else if ($2=="Led"&&((what=="oldled" && $1=="Yellow")||(what=="" && $1=="Maintenance"))) yellow[i,j]=EGEM_LED[gensub(/^.*(Maintenance|Yellow) Led[\t ]*CELLO_LED2?_/,"",1,$0)]

	if ($1=="$") $0=gensub(/\$/,"",1,$0) #in case the line is like $ Directory '/d/loadmodules'
	if ($1!~/^([-d]r|Directory$)/) indloadmodules=0
	if (/(^|[^"])EndOfPrint$/) result="break"   #Important: don't put an "else if" here because this row may have already occurred in the "inerrorinformation"
	if (/Timeout.*not responding|: connection timed out|: remote idle timed out/) result="timeout"
	return result
}
#$ lhsh 001200/port_0_dev_2 par get SYS_HW*
#'SYS_HW_PID'         = 'KRC 118 22/1'
#'SYS_HW_REV'         = 'P1E'
#'SYS_HW_NAME'        = 'RU22'
#'SYS_HW_DATE'        = '20050526'
#'SYS_HW_SERIAL'      = 'AE51875388'

#'CONTAINER_HW_PID'   = 'KRC 118 023/1'
#'CONTAINER_HW_REV'   = 'R1C'
#'CONTAINER_HW_NAME'  = 'AIR 21 B2A B4P'
#'CONTAINER_HW_DATE'  = '20120118'
#'CONTAINER_HW_SERIAL' = 'CQ30000608'

#On RRUL, the CONTAINER_HW shows this.
#Product name: RRUL 11 B13
#Product number: KRC 131 145/1
#Product revision: R4B
#Production date : 20110726
#Serial number: C84A00038E


#$ lhsh 001200/port_0_dev_2 vii
#Indicated states:
#  Red:        Default              (off)
#  Green:      Default              (steady light)
#  Yellow:     VII_BOARD_BUSY       (16 hz)
#  Blue/Yellow:
#          Default                               (off)


#$ lhsh 001200/port_0_dev_2 au3vii
#  Port Identifier   : 0
#  Product Identifier: FU
#  Registered Clients:
#  Client          FAULT  LOAD_START  MISSING_RESOURCE  BOARD_LOCKED  BOARD_BUSY  SHUTDOWN
#  --------------  -----  ----------  ----------------  ------------  ----------  --------
#  01: 0x0001005c  NO     NO          NO                NO            YES         NO
#  LED     State
#  ---     -----
#  Green   ON
#  Yellow  16Hz blink
#  Red     OFF

#$ lhsh 001200/port_0_dev_2 fui get ee pid
#Prod.nr   : KRC 118 21/1
#Prod.rev  : R1A
#Prod.name : FU
#Prod.date : 20050518
#Serial.nr : A400229508

function fix_hour(hh,ampm)
{
	if (ampm=="PM" && hh !=12) hh=hh+12
	else if (ampm=="AM" && hh==12) hh=0
	return hh
}
####################################################################################################################
# ALLIP RELATED FUNCTIONS (AL AND LG COMMANDS)
####################################################################################################################
function al_function(inputvariables)
{
	parse_inputvars(inputvariables)
	tempfile=sprintf("%s/al.tmp",tempdir)
	close(tempfile)
	while (getline line < tempfile)
	{
		customPrint(line)
	}
	close(tempfile)
}
function print_active_alarms(inputvariables,   line,format,alCount,alarmTable,iuText,currField,currName,sevPos,al_count,ok,arr,tCI,x,y,k,i,j,extra,inAT,yangTranslation,tVal,tCount,aa,mapTable,ss,currMe,offset,nrOfNodes,nodeList,nodeName,what,nr)
{
	parse_inputvars(inputvariables)
	make_causeTable()

	if (inputoptions ~ "a") detail=1 ; else detail=0
	if (inputoptions ~ "t") view_time=1 ; else view_time=0
	if (inputoptions ~ "k") view_ack=1  ; else view_ack=0
	if (inputoptions ~ "c") csvoutput=1 ; else csvoutput=0
	if (inputoptions ~ "u") alarm_time=1 ; else alarm_time=0

	tempfile=sprintf("%s/al.tmp",tempdir)
	if (comcli==0 && yangcli==0)
	{
		if (thetype!="offline")
		{
			#empty the file before start but keep it there since it had been created with correct permissions
			close(tempfile) ; printf "" > tempfile ; close(tempfile)

			AlarmClient=make_java_command("alarmclient","","",tempfile,alarm_time)
			if (AlarmClient==99) return
			#print AlarmClient
			while (1)
			{
				ok=0
				while ((AlarmClient |& getline line)>0)
				{
					gsub("\r","",line)
					if (line ~ /^Nr of active alarms are:/) ok=1
					split(line,arr," ")
					if (arr[1]=="at") continue
					if (corba_class>=3 && os~/^sun86/ && line ~ /org.omg.CORBA.TRANSIENT/) continue  #TR HW74114
					customPrint(line)
				}
				close(AlarmClient)
				if (ok==1) break
				sleep(10)
				al_count++
				#print al_count,al_retry
				if (al_count>al_retry) return
			}
		}
	}
	if (fileOps("test -s "tempfile".mosalarms")==0)
	{
		system("cat "tempfile".mosalarms "tempfile" > "tempfile".combined")
		tempfile=tempfile".combined"
	}
	Nr_of_crit = 0 ; Nr_of_maj = 0 ; alarmcount=0 ; nr_of_ack=0 ; nr_of_unack=0 ; alCount=0
	if (comcli>0) i=0 ; else i=1
	if (yangcli>0)
	{
		#YANG fields:
		#MajorType.1 = 193
		#MinorType.1 = 10223618
		#SpecificProblem.1 = Internal CA Internal Certificate Creation Failure
		#YangNodeInstance.2 = ManagedElement=1,GNBCUCPFunction=1
		#EventType.3 = communicationsAlarm
		#EventTime.3 = 2022-7-2,22:9:34.0,+0:0
		#OriginalEventTime.3 = 2022-7-2,22:9:34.0,+0:0
		#ProbableCause.3 = m3100Unavailable
		#Severity.1 = major
		#OriginalSeverity.1 = critical
		#AdditionalText.2 = Connection lost for Service Discovery Interfaces listed in Additional Information.
		#OrigAdditionalText.2 = Connection lost for Service Discovery Interfaces listed in Additional Information.
		#AdditionalInfo.2 = P=I=76380b86-1216-47d3-b0d3-a739b1fa31b0;N=eric-ran-cu-cp-rc-singlepod-0;;S=1
		#AdditionalInfo.3 = 1=262-80

		#COM fields:
		#activeSeverity=MINOR
		#additionalText="No SFP or electrical cable plugged in."
		#eventType=EQUIPMENTALARM
		#isNotified=NOTIFIED
		#lastEventTime="2022-07-06T21:17:42.483+00:00"
		#majorType=193
		#minorType=9175156
		#originalAdditionalText="No SFP or electrical cable plugged in."
		#originalEventTime="2022-07-06T21:17:42.483+00:00"
		#originalSeverity=MINOR
		#probableCause=62
		#sequenceNumber=85
		#source="ManagedElement=RBS530,Equipment=1,FieldReplaceableUnit=1,SfpModule=D"
		#specificProblem="SFP Not Present"
		#additionalInfo
		# name="CI"
		# value="{\"C\": [{\"I\": \"ebec0000-b180-11e4-8e92-a4a1c261b0a8\",\"n\": \"RadioNode\"}],\"P\": \"ebec0006-6611-11e4-8e92-a4a1c261b0a8\"}"
		#additionalInfo
		# name="0"
		# value="<Empty container>"

		yangTranslation["Severity"]="activeSeverity"
		yangTranslation["SpecificProblem"]="specificProblem"
		yangTranslation["ProbableCause"]="probableCause"
		yangTranslation["EventTime"]="lastEventTime" 
		yangTranslation["YangNodeInstance"]="source"
		yangTranslation["AdditionalText"]="additionalText"
		yangTranslation["AdditionalInfo"]="AI"
	}		
	while ((getline < tempfile)>0)
	{
		gsub("\r","") ; gsub("\x00","") ; gsub(/[ \t]+$/,"")
		#comcli>0

		#Online mode
		#FmAlarm=4
		#activeSeverity=CRITICAL
		#additionalInfo=""
		#     name="0" <read-only>
		#     value="eventId=39" <read-only>
		#additionalText="Card Missing"
		#eventType=COMMUNICATIONSALARM
		#lastEventTime="2012-08-17T19:08:04Z"
		#lastEventTime="2014-07-21T08:04:41+00:00" <read-only>
		#majorType=193
		#minorType=3188850769
		#probableCause=62
		#sequenceNumber=4
		#source="ManagedElement=1,Equipment=1,Slot=5"
		#specificProblem="Line Card Missing"

		#Offline mode
		#MO             ;activeSeverity;additionalInfo;additionalText                                                            ;eventType               ;fmAlarmId;lastEventTime       ;majorType;minorType ;probableCause              ;sequenceNumber;source                                                         ;specificProblem
		#Fm=1,FmAlarm=11;3 (CRITICAL)  ;t[0] =        ;Out-of-service - Ejector Switch                                           ;2 (COMMUNICATIONSALARM) ;11       ;2012-07-13T05:00:56Z;193      ;3188851032;1024 (other)               ;11            ;ManagedElement=1,Equipment=1,Slot=24                           ;SW Out-of-service - Ejector Switch
		#Fm=1,FmAlarm=13;3 (CRITICAL)  ;t[0] =        ;Out-of-service - Ejector Switch                                           ;2 (COMMUNICATIONSALARM) ;13       ;2012-07-13T05:00:56Z;193      ;3188851032;1024 (other)               ;13            ;ManagedElement=1,Equipment=1,Slot=25
		#Fm=1,FmAlarm=2;t[1] =        ;6 (WARNING)   ;Loss of signal                   ;5 (EQUIPMENTALARM)      ;2        ;2015-01-07T03:01:52+00:00;193      ;9175062  ;    ;Loss of signal                   ;2015-01-07T03:01:52+00:00;6 (WARNING)     ;506 (ClockSynchronisationProblem)      ;2             ;ManagedElement=1,Transport=1,Synchronization=1,RadioEquipmentClock=1,RadioEquipmentClockReference=1;FrequencySyncIO Reference Failed;
		#Fm=1,FmAlarm=2;t[0]          ;              ;                                 ;                        ;         ;                         ;         ;         ;0   ;                                 ;                         ;                ;                                       ;              ;                                                                                                   ;                                ;eventId=36
		#MO            ;activeSeverity;additionalText                                                         ;eventType               ;fmAlarmId;lastEventTime            ;majorType;minorType;name;originalAdditionalText                                                 ;originalEventTime        ;originalSeverity;probableCause                      ;sequenceNumber;source                                                             ;specificProblem    ;value
		#Fm=1,FmAlarm=2;5 (MINOR)     ;Not in operation, additionalData: id 1, unitId 1, portNo 0 (Mixed Mode);5 (EQUIPMENTALARM)      ;2        ;2015-10-21T05:34:13+00:00;193      ;9175144  ;    ;Not in operation, additionalData: id 1, unitId 1, portNo 0 (Mixed Mode);2015-10-21T05:34:13+00:00;5 (MINOR)       ;315 (EquipmentMalfunction)         ;3             ;ManagedElement=1,Equipment=1,RiLink=1                              ;Link Failure       ;
		#Fm=1,FmAlarm=2;              ;                                                                       ;                        ;         ;                         ;         ;         ;0   ;                                                                       ;                         ;                ;                                   ;              ;                                                                   ;                   ;1
		#Fm=1,FmAlarm=2;              ;                                                                       ;                        ;         ;                         ;         ;         ;0   ;                                                                       ;                         ;                ;                                   ;              ;                                                                   ;                   ;1
		#Fm=1,FmAlarm=2;              ;                                                                       ;                        ;         ;                         ;         ;         ;0   ;                                                                       ;                         ;                ;                                   ;              ;                                                                   ;                   ;0
		#Fm=1,FmAlarm=2;              ;                                                                       ;                        ;         ;                         ;         ;         ;0   ;                                                                       ;                         ;                ;                                   ;              ;                                                                   ;                   ;eventId=105
		#Fm=1,FmAlarm=3;4 (MAJOR)     ;                                                                       ;4 (PROCESSINGERRORALARM);3        ;2015-10-21T05:34:13+00:00;193      ;9175115  ;    ;                                                                       ;2015-10-21T05:34:13+00:00;4 (MAJOR)       ;356 (UnderlyingResourceUnavailable);4             ;ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=RBSLN153-MS1G2-S1C1;Service Unavailable;
		#Fm=1,FmAlarm=3;              ;                                                                       ;                        ;         ;                         ;         ;         ;0   ;                                                                       ;                         ;                ;                                   ;              ;                                                                   ;                   ;eventId=105
		#Fm=1,FmAlarm=4;5 (MINOR)     ;Not in operation, additionalData: id 1, unitId 2048, portNo 1          ;5 (EQUIPMENTALARM)      ;4        ;2015-10-21T05:34:17+00:00;193      ;9175144  ;    ;Not in operation, additionalData: id 1, unitId 2048, portNo 1          ;2015-10-21T05:34:17+00:00;5 (MINOR)       ;315 (EquipmentMalfunction)         ;5             ;ManagedElement=1,Equipment=1,RiLink=3                              ;Link Failure       ;
		#Fm=1,FmAlarm=4;              ;                                                                       ;                        ;         ;                         ;         ;         ;0   ;                                                                       ;                         ;                ;                                   ;              ;                                                                   ;                   ;1
		#Fm=1,FmAlarm=4;              ;                                                                       ;                        ;         ;                         ;         ;         ;0   ;                                                                       ;                         ;                ;                                   ;              ;                                                                   ;                   ;2048
		#Fm=1,FmAlarm=4;              ;                                                                       ;                        ;         ;                         ;         ;         ;0   ;                                                                       ;                         ;                ;                                   ;              ;                                                                   ;                   ;1
		#Fm=1,FmAlarm=4;              ;                                                                       ;                        ;         ;                         ;         ;         ;0   ;                                                                       ;                         ;                ;                                   ;              ;                                                                   ;                   ;eventId=113
		#Fm=1,FmAlarm=5;4 (MAJOR)     ;                                                                       ;4 (PROCESSINGERRORALARM);5        ;2015-10-21T05:34:17+00:00;193      ;9175115  ;    ;                                                                       ;2015-10-21T05:34:17+00:00;4 (MAJOR)       ;356 (UnderlyingResourceUnavailable);6             ;ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=RBSLN153-MS1G2-S3C1;Service Unavailable;
		#Fm=1,FmAlarm=5;              ;                                                                       ;                        ;         ;                         ;         ;         ;0   ;                                                                       ;                         ;                ;                                   ;              ;

		if (comcli>0)
		{
			gsub(/[\\]n/,"")   #sometimes there is a \n sign, eg: additionalText="Physical connection represented by this MO is suspected to be inconsistent with MO configuration. Physical connection at far end connects to incorrect port on unit with serial number B070996758.\n"
			gsub(/[\\]/,"")    #remove \ signs , eg: value="{\"C\": [{\"I\": \"db368000-28bf-11ed-8e92-f897a926582e\",\"n\": \"RadioNode\"}],\"P\": \"db360000-091a-11ed-8e92-f897a926582e\"}"
			#Offline mode (hgetc)
			if ($1=="MO" && $2 ~ /^;[a-z]/)
			{
				format=1
				last=split($0,array,";")
				for (i=1;i<=last;i++)
				{
					field[i]=gensub(/ +$/,"",1,array[i])
					if (field[i]=="activeSeverity") sevPos=i
				}
			}
			else if (format==1 && $1~/^Fm=1,FmAlarm=/)
			{
				last=split($0,array,";")
				if (array[2] ~ /^ *$/ && array[sevPos]~/^ *$/) continue
				alCount++
				for (i=1;i<=last;i++)
				{
					sub(/^t\[[0-9]+\] = */,"",array[i])
					gsub(/ +$/,"",array[i])
					alTable[alCount,field[i]]=array[i]
				}
			}
			#Online mode (show verbose)
			else if ($1 ~ /^FmAlarmModel=/) format=0
			else if ($1 ~ /^FmAlarm=/) { alCount++ ; format=2 ; alTable[alCount,"MO"]="Fm=1,"$1 }
			else if (format==2 && $1 ~ "=")
			{
				split($0,array,"=")
				gsub(/^[ \t]+/,"",array[1])
				if (array[1] == "name") currName=gensub(/^"|"$/,"","g",gensub(/^[^=]+=/,"",1,$0))
				else if (array[1] == "value")
				{
					alTable[alCount,"AI"]=alTable[alCount,"AI"]","(comcli>0&&show_correlation_info==0&&currName=="CI"?"":currName":"gensub(/^"|"$/,"","g",gensub(/^[^=]+=/,"",1,$0)))
					sub(/^,/,"",alTable[alCount,"AI"])
					if (currName=="CI" && show_related_alarms!=0)
					{
						#"P": "aeb30000-01a3-11ea-8e92-987a102c041f"
						#"S": ["aeb30000-01b5-11ea-8e92-987a102c041f","aeb30000-01a3-11ea-8e92-987a102c041f"]
						match($0,/["]P["]: ["]([-a-f0-9]+)["]/,x)
						if (x[1]!="")
						{
							alTable[alCount,"CI"]="P:"x[1]
							alTable[alCount,"cId"]="P:"gensub(/^.*=/,"",1,alTable[alCount,"MO"])
							alTable["cIList","P",x[1]]=1
						}
						match($0,/["]S["]: \[([^]]+)\]/,x)
						if (x[1]!="")
						{
							alTable[alCount,"CI"]="S:"gensub(/["]/,"","g",x[1])
							alTable[alCount,"cId"]="S:"gensub(/^.*=/,"",1,alTable[alCount,"MO"])
							split(gensub(/^S:/,"",1,alTable[alCount,"CI"]),y,",")
							for (k in y) alTable["cIList","S",gensub(/["]/,"","g",y[k])]=1
						}
						#print alTable[alCount,"CI"]
					}
				}
				else alTable[alCount,array[1]]=gensub(/^"|"$/,"","g",gensub(/^[^=]+=/,"",1,$0))
			}
			#APG
			else if (/^(Alarm Identifier|Object of Reference|Alarm Text|Problem Data)/)
			{
				#Alarm Identifier    Class    Category    Time
				#25781:2             O1       APZ         2014-10-06 12:08:51
				if (/^Alarm Identifier/) currField="alarmHeader"
				else if (/^Object of Reference/) currField="source"
				else if (/^Alarm Text/) currField="additionalText"
				else if (/^Problem Data/) currField="specificProblem"
			}
			else if (NF>0 && currField!="" && $1!=">alist" && $0 !~ /^Log close:/)
			{
				if (currField=="alarmHeader")
				{
					alCount++
					alTable[alCount,"lastEventTime"]=$4"T"$5"Z"
					alTable[alCount,"activeSeverity"]=$2
					currField=""
				}
				else alTable[alCount,currField]=gensub(/^ +/,"",1,alTable[alCount,currField]" "gensub(/ +/," ","g",$0))
			}
			else if (NF=="" || $1==">alist") currField=""
			continue
		}
		else if (yangcli>0)
		{
			#print $0
			#Me=cucp132 10.1.10.1
			#eriAlarmXSumIndeterminate.0 = 0
			#eriAlarmXSumCritical.0 = 0
			#eriAlarmXSumMajor.0 = 1
			#eriAlarmXSumMinor.0 = 1
			#eriAlarmXSumWarning.0 = 1
			#eriAlarmXActiveNumber.0 = 3
			#eriAlarmXActiveLastChanged.0 = 2022-7-7,11:42:40.0,+0:0
			#eriAlarmXActiveLastSequenceNo.0 = 24
			#eriAlarmXActiveTableURL.0 =
			#eriAlarmXActiveMajorType.2 = 193
			#eriAlarmXActiveMajorType.3 = 193
			#eriAlarmXActiveMajorType.12 = 193
			#eriAlarmXActiveMinorType.2 = 9699329
			#eriAlarmXActiveMinorType.3 = 9175262
			#eriAlarmXActiveMinorType.12 = 9699331
			#eriAlarmXActiveSpecificProblem.2 = Certificate Management, Certificate is about to Expire
			#eriAlarmXActiveSpecificProblem.3 = Service Discovery Service Unavailable
			#eriAlarmXActiveSpecificProblem.12 = Certificate Management, Automatic Enrollment Failed
			#eriAlarmXActiveYangNodeInstance.2 = /ks:keystore/ks:asymmetric-keys/ks:asymmetric-key[ks:name='oamNodeCredential']/ks:certificates/ks:certificate[ks:name='oamNodeCredential']
			#eriAlarmXActiveYangNodeInstance.3 = ManagedElement=1,ServiceInstance=serviceInstance
			#eriAlarmXActiveYangNodeInstance.12 = /ks:keystore/ks:asymmetric-keys/ks:asymmetric-key[ks:name='oamNodeCredential']/ks:certificates/ks:certificate[ks:name='oamNodeCredential']
			#eriAlarmXActiveEventType.2 = processingErrorAlarm
			#eriAlarmXActiveEventType.3 = processingErrorAlarm
			#eriAlarmXActiveEventType.12 = processingErrorAlarm
			#eriAlarmXActiveEventTime.2 = 2022-7-7,11:42:40.0,+0:0
			#eriAlarmXActiveEventTime.3 = 2022-7-6,8:54:59.5,+0:0
			#eriAlarmXActiveEventTime.12 = 2022-7-6,10:13:2.0,+0:0
			#eriAlarmXActiveOriginalEventTime.2 = 2022-7-2,11:39:55.4,+0:0
			#eriAlarmXActiveOriginalEventTime.3 = 2022-6-17,13:50:44.1,+0:0
			#eriAlarmXActiveOriginalEventTime.12 = 2022-7-6,10:13:2.0,+0:0
			#eriAlarmXActiveProbableCause.2 = x733ThresholdCrossed
			#eriAlarmXActiveProbableCause.3 = configurationOrCustomisationError
			#eriAlarmXActiveProbableCause.12 = x733ConfigurationOrCustomizationError
			#eriAlarmXActiveSeverity.2 = minor
			#eriAlarmXActiveSeverity.3 = major
			#eriAlarmXActiveSeverity.12 = warning
			#eriAlarmXActiveOriginalSeverity.2 = minor
			#eriAlarmXActiveOriginalSeverity.3 = major
			#eriAlarmXActiveOriginalSeverity.12 = warning
			#eriAlarmXActiveAdditionalText.2 = The certificate will expire in 24 days and should be renewed to prevent service failure
			#eriAlarmXActiveAdditionalText.3 = Connection lost for Service Discovery Interfaces listed in Additional Information.
			#eriAlarmXActiveAdditionalText.12 = Automatic certificate renewal using enrollment protocol CMP failed due to local misconfiguration or remote enrollment service denial
			#eriAlarmXActiveOrigAdditionalText.2 = The certificate will expire in 30 days and should be renewed to prevent service failure
			#eriAlarmXActiveOrigAdditionalText.3 = Connection lost for Service Discovery Interfaces listed in Additional Information.
			#eriAlarmXActiveOrigAdditionalText.12 = Automatic certificate renewal using enrollment protocol CMP failed due to local misconfiguration or remote enrollment service denial
			#eriAlarmXActiveResourceId.2 = zeroDotZero
			#eriAlarmXActiveResourceId.3 = zeroDotZero
			#eriAlarmXActiveResourceId.12 = zeroDotZero
			#eriAlarmXActiveAdditionalInfo.2 =
			#eriAlarmXActiveAdditionalInfo.3 = P=I=47eb3ba6-01fd-40d0-b8e5-03b79c7feabf;N=eric-ran-cu-up-ppf-df744699c-m4n8v;;S=SDS1
			#eriAlarmXActiveAdditionalInfo.12 =
			#eriAlarmXAlertNumber.0 = 0
			#eriAlarmXAlertLastChanged.0 = 1970-1-1,0:0:0.0,+0:0
			#eriAlarmXAlertLastSequenceNo.0 = 0
			#eriAlarmXAlertTableURL.0 =
			#eriAlarmXHbInterval.0 = 60
			#eriAlarmXHbInterval.0 = No more variables left in this MIB View (It is past the end of the MIB tree)
			#Variables found: 57
			if ($1~/^Me=/) 
			{
				currMe=$1
				nodeList[++nrOfNodes]=$2
				nodeName[$2]=gensub(/^Me=/,"",1,$1)
				offset+=1000
				nr[nodeList[nrOfNodes]]=nr[nodeList[nrOfNodes],"C"]=nr[nodeList[nrOfNodes],"M"]=nr[nodeList[nrOfNodes],"m"]=nr[nodeList[nrOfNodes],"w"]=nr[nodeList[nrOfNodes],"?"]="-"
			}
			if ($2!="=") continue
			if ($1~/^eriAlarmX(Sum|ActiveNumber)/)
			{
				#eriAlarmXSumIndeterminate.0 = 0
				#eriAlarmXSumCritical.0 = 0
				#eriAlarmXSumMajor.0 = 1
				#eriAlarmXSumMinor.0 = 1
				#eriAlarmXSumWarning.0 = 1
				#eriAlarmXActiveNumber.0 = 3
				sub(/^eriAlarmX(Sum|Active)?/,"",$1)
				if ($1=="Critical.0") what="C" ; else if ($1=="Major.0") what="M" ; else if ($1=="Minor.0") what="m" 
				else if ($1=="Warning.0") what="w" ; else if ($1=="Indeterminate.0") what="?" ; else if ($1=="Number.0") what="T"
				if (what=="T") nr[nodeList[nrOfNodes]]=$3
				else nr[nodeList[nrOfNodes],what]=$3
			}
			tCount=gensub(/^.*\./,"",1,$1)+offset
			alField=gensub(/^eriAlarmXActive/,"",1,gensub(/\.[0-9]+$/,"",1,$1))
			if (alField=="MajorType") 
			{
				alCount++
				alTable[alCount,"MO"]="Fm=1,FmAlarm=" tCount
				mapTable[tCount]=alCount
			}
			tVal=gensub(/^[^=]+ = */,"",1,$0)
			if (alField=="Severity") tVal=toupper(tVal)
			else if (alField=="EventTime") 
			{
				#convert "2022-7-7,2:57:36.9,+0:0" to: "2022-07-07T02:57:36.9+00:00" 
				split(tVal,aa,/[-:,.]/)
				tVal=sprintf("%s-%02d-%02dT%02d:%02d:%02d.%s%s",aa[1],aa[2],aa[3],aa[4],aa[5],aa[6],aa[7],aa[8])
			}
			else if (alField=="YangNodeInstance") 
			{
				tVal=currMe","xpath2ldn(tVal)
				sub(/,$/,"",tVal)
			}
			alTable[mapTable[tCount],yangTranslation[alField]]=tVal
			continue
		}
		#CPP
		#IU_TEXT = IntegrationUnlock=ACTIVATED, 8 days remaining
		#MANAGED_OBJECT_CLASS = E1PhysPathTerm
		#MANAGED_OBJECT_INSTANCE = SubNetwork=OSS38_ROOT_MO,MeContext=MGW1,ManagedElement=1,Equipment=1,Subrack=2,Slot=26,PlugInUnit=1,ExchangeTerminal=1,E1PhysPathTerm=2261
		#NOTIFICATION_ID = 1
		#EVENT_TIME time Nov 29, 2007 2:31:27 PM
		#EVENT_TIME time 09.02.2009 17:57:41
		#EVENT_TIME time 2009-jun-01 15:20:17
		#EVENT_TIME time 2014. 8. 19 $ 4:30:39
		#EVENT_TIME time 25 juin 2014 01:21:58
		#EVENT_TIME time Dec 7, 2021, 10:29:51 AM
		#SYSTEM_DN = SubNetwork=OSS38_ROOT_MO,MeContext=MGW1
		#PROBABLE_CAUSE = 8
		#PERCEIVED_SEVERITY = 3
		#SPECIFIC_PROBLEM = PDH Loss of Signal
		#ADDITIONAL_TEXT =
		#ALARM_ID = SubNetwork=OSS38_ROOT_MO,MeContext=MGW1_1
		#ACK_TIME time Oct 15, 1582 1:00:00 AM
		#ACK_USER_ID =
		#ACK_STATE = 2
		#null = E1PhysPathTerm 2261 for Etmc1 ATM Ext Sub slot 26
		if (/MANAGED_OBJECT_CLASS/) MoClass[i] = parseValue($0)
		else if (/^IU_TEXT = /) iuText=gensub(/^IU_TEXT = /,"",1,$0)
		else if (/MANAGED_OBJECT_INSTANCE/ )
		{
			MoInstance[i] = parseValue($0)
			ShortMoInstance[i]=parseMoInstance(MoInstance[i])
		}
		else if (/NOTIFICATION_ID/) Notification[i]=parseValue($0)
		else if (/EVENT_TIME/)
		{
			Time[i]=gensub(/^.* time /,"","g",$0)
			parse_event_time(Time[i],resultTime)
			Date_Time[i]=resultTime["Date_Time"]
			timestamp[i]=resultTime["timestamp"]
		}
		else if (/SYSTEM_DN/)          SystemDn[i] = parseValue($0)
		else if (/PROBABLE_CAUSE/)     Cause[i] = causeTable[parseValue($0)]
		else if (/PERCEIVED_SEVERITY/)
		{
			parseSeverity(parseValue($0),severityTable)
			Severity[i]=severityTable["long"]
			ShortSeverity[i]=severityTable["short"]
			Se[i]=severityTable["one"]
		}
		else if (/SPECIFIC_PROBLEM/ )  Problem[i] = parseValue($0)
		else if (/ADDITIONAL_TEXT/)
		{
			#ADDITIONAL_TEXT = No license key file installed.
			
			#In some cases additional text may contain empty lines or more lines, eg:
			#ADDITIONAL_TEXT = Thermal runaway risk. 
			#
			#Other nodes affected, see Additional Information.
			inAT=1
			AdditionalText[i] = parseValue($0)
			if (AdditionalText[i] ~ /No license key file installed/ && Problem[i] ~ /License Key File Fault/) AdditionalText[i]=AdditionalText[i]" "iuText
		}
		else if (/ALARM_ID/)
		{
			Id[i] = parseValue($0)
			inAT=0
		}
		else if (/ACK_TIME/) 
		{
			inAT=0
			AckTime[i] = gensub(/^.* time /,"","g",$0)
		}
		else if (/ACK_USER_ID/)
		{
			inAT=0
			AckUserid[i] = parseValue($0)
		}
		else if (/ACK_STATE/)
		{
			inAT=0
			alarmcount++
			AckState[i] = parseValue($0)
			if (AckState[i]==1) { nr_of_ack++ ; FullAckState[i]="Acknowledged by "AckUserid[i] }
			else if (AckState[i]==2)
			{
				nr_of_unack++
				FullAckState[i]="Unacknowledged"
				AckTime[i]=0
			}
		}
		else if (/^null = /)
		{
			if (!(show_alarm_userlabel==0 && /^null = userLabel = /)) additionalInformation[i]=additionalInformation[i]" "gensub(/^null = /,"",1,$0)
		}
		else if (inAT==1) 
		{
			if (NF!=0) AdditionalText[i] = AdditionalText[i] " "gensub(/^[ \t]*|[ \t]*$/,"","g",$0)
		}
		else if (NF==0) i++
	}
	close(tempfile)
	if (comcli>0 || yangcli>0)
	{
		customPrint("")
		if (comcli>0 && show_related_alarms!=0)
		{
			#for (i in alTable) { split(i,x,SUBSEP) ; if (x[1]=="cIList" && alTable[i]==1) print x[2],x[3] }
			for (i=1;i<=alCount;i++)
			{
				#print i,alTable[i,"CI"]
				if (alTable[i,"CI"]~/^P:/ && alTable["cIList","S",gensub(/^P:/,"",1,alTable[i,"CI"])]==1)
				{
					for (j=1;j<=alCount;j++)
					{
						if (alTable[j,"CI"]~/^S:/ && alTable[j,"CI"]~sprintf("(^|:|,)%s($|,)",gensub(/^P:/,"",1,alTable[i,"CI"]))) alTable[i,"Rel"]=alTable[i,"Rel"]","gensub(/^[PS]:/,"",1,alTable[j,"cId"])
					}
				}
				else if (alTable[i,"CI"]~/^S:/ && alTable["cIList","P",gensub(/^S:/,"",1,alTable[i,"CI"])]==1)
				{
					for (j=1;j<=alCount;j++)
					{
						if (alTable[j,"CI"]~/^P:/ && alTable[j,"CI"] ~ sprintf("(^|:|,)%s($|,)",gensub(/^S:/,"",1,alTable[i,"CI"]))) alTable[i,"Rel"]=alTable[i,"Rel"]","gensub(/^[PS]:/,"",1,alTable[j,"cId"])
					}
				}
			}
		}
		for (i=1;i<=alCount;i++)
		{
			Id[i]=gensub(/^.*=/,"",1,alTable[i,"MO"])
			MoInstance[i]=gensub(/ /,"","g",alTable[i,"source"])
			MoClass[i]=gensub(/=.*$/,"",1,gensub(/^.*,/,"",1,MoInstance[i]))
			ShortMoInstance[i]=parseMoInstance(MoInstance[i])
			#lastEventTime="2012-08-17T19:08:04Z"
			#lastEventTime="2014-07-21T08:04:41+00:00" <read-only>
			#lastEventTime="2017-03-03T23:49:01.165+00:00" <read-only>
			split(alTable[i,"lastEventTime"],array,"T")
			Date_Time[i]=array[1]" "gensub(/[.+A-Z].*$/,"",1,array[2])
			Time[i]=Date_Time[i]
			timestamp[i]=make_timestamp(array[1],gensub(/[A-Z]$/,"",1,array[2]))
			if (yangcli>0) Cause[i]=alTable[i,"probableCause"]
			else Cause[i]=causeTable[gensub(/ \(.*$/,"",1,alTable[i,"probableCause"])]
			parseSeverity(gensub(/^.*\(|\)$/,"","g",alTable[i,"activeSeverity"]),severityTable)
			Severity[i]=severityTable["long"]
			ShortSeverity[i]=severityTable["short"]
			Se[i]=severityTable["one"]
			Problem[i] = alTable[i,"specificProblem"]
			if (alTable[i,"isNotified"]!="")
			{
				if (show_notified!=1 && alTable[i,"isNotified"]=="NOTIFIED") IsNotif[i]=""
				else IsNotif[i]=" :"alTable[i,"isNotified"]
			}
			AdditionalText[i] = alTable[i,"additionalText"]
			additionalInformation[i] = alTable[i,"additionalInfo"]
			Notification[i]=alTable[i,"sequenceNumber"]
			sub(/ManagedElement:1,/,"ManagedElement=1,",alTable[i,"AI"])
			addInf[i] = alTable[i,"AI"]
			if (show_related_alarms!=0)
			{
				extra=""
				if (alTable[i,"Rel"]!="") extra=sprintf("%s%s",alTable[i,"cId"],gensub(/^,/,"->",1,alTable[i,"Rel"]))
				if (show_related_alarms==2 && extra=="") extra=alTable[i,"cId"]
				if (extra!="") addInf[i] = addInf[i] " " extra
			}
			AckUserid[i]=AckTime[i]=AckState[i]=SystemDn[i]="N/A"
		}
		alarmcount=alCount
	}
	for (i in Id)
	{
		#Severity;Object;Event;Cause;AdditionalText;AckState;AlarmId;NotificationId
		addText=gensub(/^ */,"",1,sprintf("%s%s",AdditionalText[i],additionalInformation[i]))
		csvLine[i]=sprintf("%s;%s;%s;%s;%s;%s;%s;%s;%s",gensub(/ /,";",1,Date_Time[i]),Severity[i],MoInstance[i],Problem[i],Cause[i],addText (addInf[i]!=""?" AI: "addInf[i]:"") IsNotif[i],FullAckState[i],Id[i],Notification[i])
		if (alarm_format>=1) alLine[i]=sprintf("%-5s %-35s %-s %-s%s",ShortSeverity[i],Problem[i],ShortMoInstance[i],process_add_text(addText,Problem[i],Cause[i],addInf[i],"",IsNotif[i]),(view_ack==1?" "AckUserid[i]:""))
		else alLine[i]=sprintf("%-5s %-35s %-25s %-19s%s",ShortSeverity[i],Problem[i],Cause[i],ShortMoInstance[i],(view_ack==1?" "AckUserid[i]:""))
		alIndex[alLine[i]]=i
		#Important: the blank space is needed at the end of the Event Time line, this is so it can be handled by "time_convert.pl" when running "alaz"
		alaLine[i]=sprintf("\nAlarm Id : %s\nEvent Time : %s \nPerceived Severity : %s\nManaged Object Class : %s\n\
Managed Object Instance : %s\nSpecific Problem : %s\nProbable Cause : %s\nAdditional Text : %s\nAcknowledged by : %s\n\
Acknowledgement Time : %s\nAcknowledgement State: %s\nSystem DN : %s\nNotification Id : %s\nAdditional Info : %s%s",\
Id[i],Time[i],Severity[i],MoClass[i],MoInstance[i],Problem[i],Cause[i],AdditionalText[i],AckUserid[i],\
AckTime[i],AckState[i],SystemDn[i],Notification[i],(addInf[i]!=""?addInf[i]:gensub(/^ */,"",1,additionalInformation[i])),\
(alTable[i,"isNotified"]!=""?"\nIs Notified: "alTable[i,"isNotified"]:""))
		if (alarm_format>=1) altLine[i]=sprintf("%-19s %1s %-35s %-s %-s%s",Date_Time[i],Se[i],Problem[i],ShortMoInstance[i],process_add_text(addText,Problem[i],Cause[i],addInf[i],"",IsNotif[i]),(view_ack==1?" "AckUserid[i]:""))
		else altLine[i]=sprintf("%-19s %1s %-35s %-25s %-19s%s",Date_Time[i],Se[i],Problem[i],Cause[i],ShortMoInstance[i],(view_ack==1?" "AckUserid[i]:""))
	}
	if (alarm_format>=1)
	{
		if (alarm_header>0) addHeader="(AdditionalText/PC, AI)"
		else addHeader="(Cause/AdditionalInfo)"
		title_sever=sprintf("%-5s %-35s %-s %-s","Sever","Specific Problem","MO",addHeader)
		title_time=sprintf("%-19s %s %-35s %-s %-s","Date & Time "(alarm_time!=1&&comcli==0&&yangcli==0?"(Local)":"(UTC)"),"S","Specific Problem","MO",addHeader)
		title_sever_ack=sprintf("%-5s %-35s %-s %-s %-s","Sever","Specific Problem","MO",addHeader,"Operator")
		title_sever_ack_time=sprintf("%-19s %s %-35s %-s %-s %-s","Date & Time "(alarm_time!=1&&comcli==0&&yangcli==0?"(Local)":"(UTC)"),"S","Specific Problem","MO",addHeader,"Operator")
	}
	else
	{
		title_sever=sprintf("%-5s %-35s %-25s %-s","Sever","Specific Problem","Cause","Mo-Reference")
		title_time=sprintf("%-19s %s %-35s %-25s %-s","Date & Time "(alarm_time!=1&&comcli==0&&yangcli==0?"(Local)":"(UTC)"),"S","Specific Problem","Cause","Mo-Reference")
		title_sever_ack=sprintf("%-5s %-35s %-25s %-s        %-s","Sever","Specific Problem","Cause","Mo-Reference","Operator")
		title_sever_ack_time=sprintf("%-19s %s %-35s %-25s %-s        %-s","Date & Time "(alarm_time!=1&&comcli==0&&yangcli==0?"(Local)":"(UTC)"),"S","Specific Problem","Cause","Mo-Reference","Operator")
	}
	headLine="===================================================================================================================="
	title_sever=title_sever"\n"headLine
	title_time=title_time"\n"headLine
	title_sever_ack=headLine"\n"title_sever_ack"\n"headLine
	title_sever_ack_time=headLine"\n"title_sever_ack_time"\n"headLine
	title_csv=sprintf("%s;%s;%s;%s;%s;%s;%s;%s;%s;%s","Date","Time","Severity","Object","Problem","Cause","AdditionalText","AckState","AlarmId","NotificationId")
	if (csvoutput==1) customPrint(title_csv)
	else
	{
		if (view_ack==1) customPrint("UNACKNOWLEDGED ALARMS: "nr_of_unack)
		customPrint(headLine)
	}
	if (view_time==0)
	{
		a=asort(alLine,dest)
		if (csvoutput==1)
		{
			for (i=1;i<=a;i++)
			{
				if (view_ack==0 || AckState[alIndex[dest[i]]]==2) customPrint(csvLine[alIndex[dest[i]]])
			}
		}
		else
		{
			customPrint(title_sever)
			for (i=1;i<=a;i++)
			{
				#print i,alIndex[dest[i]],dest[i],AckState[alIndex[dest[i]]],"$"
				if (view_ack==0 || AckState[alIndex[dest[i]]]==2) customPrint(dest[i])
			}
		}
		if (view_ack==1)
		{
			if (csvoutput==1)
			{
				for (i=1;i<=a;i++)
				{
					if (AckState[alIndex[dest[i]]]==1) customPrint(csvLine[alIndex[dest[i]]])
				}
			}
			else
			{
				customPrint("\nACKNOWLEDGED ALARMS: "nr_of_ack)
				customPrint(title_sever_ack)
				for (i=1;i<=a;i++)
				{
					if (AckState[alIndex[dest[i]]]==1) customPrint(dest[i])
				}
			}
		}
		if (detail==1 && csvoutput==0)
		{
			for (i=1;i<=a;i++) customPrint(alaLine[alIndex[dest[i]]])
		}
	}
	else if (view_time==1)
	{
		asort(timestamp,dest)
		if (csvoutput==0) customPrint(title_time)
		for (i=1;i<=alarmcount;i++)
		{
			for (j in timestamp)
			{
				if ((dest[i]==timestamp[j])&&(j !="")&&(dest[i] != "")&&(already_printed[j] < 1)&&(AckState[j]==2 || view_ack==0))
				{
					if (csvoutput==1) customPrint(csvLine[j])
					else customPrint(altLine[j])
					already_printed[j]=1
				}
			}
		}
		if (view_ack==1)
		{
			if (csvoutput==0)
			{
				customPrint("\nACKNOWLEDGED ALARMS: "nr_of_ack)
				customPrint(title_sever_ack_time)
			}
			for (i=1;i<=alarmcount;i++)
			{
				for (j in timestamp)
				{
					if ((dest[i]==timestamp[j])&&(j !="")&&(dest[i] != "")&&(already_printed[j] < 1)&&(AckState[j]==1))
					{
						if (csvoutput==1) customPrint(csvLine[j])
						else customPrint(altLine[j])
						already_printed[j]=1
					}
				}
			}
		}
		delete already_printed
		if (detail==1 && csvoutput==0)
		{
			for (i=1;i<=alarmcount;i++)
			{
				for (j in timestamp)
				{
					if ((dest[i]==timestamp[j])&&(j !="")&&(dest[i] != "")&&(already_printed[j] < 1))
					{
						customPrint(alaLine[j])
						already_printed[j]=1
					}
				}
			}
		}
	}
	alarmcount+=0
	if (yangcli>0 && nrOfNodes>1)
	{
		customPrint("\n--------------------------------------------------------------------------------------------")
		customPrint(sprintf("%-50s  %5s  %5s  %5s  %5s  %5s  %5s","Node","Total","Crit","Major","Minor","Warn","?"))
		customPrint("--------------------------------------------------------------------------------------------")
		for (i=1;i<=nrOfNodes;i++)
		{
			customPrint(sprintf("%-50s  %5s  %5s  %5s  %5s  %5s  %5s",nodeList[i]" ("nodeName[nodeList[i]]")",nr[nodeList[i]],\
	nr[nodeList[i],"C"],nr[nodeList[i],"M"],nr[nodeList[i],"m"],nr[nodeList[i],"w"],nr[nodeList[i],"?"]))
		}
	}
	customPrint(">>> Total: " alarmcount " Alarms (" Nr_of_crit " Critical, " Nr_of_maj " Major)")
	#the unix exit code cannot be more than 256 otherwise it loops back, eg: exit 300 returns 300%256=44
	if (alarmcount < 99) return alarmcount
	else return 99
}
function process_add_text(string,problem,cause,addinf,what,isnotif,nopc,   res,tpc)
{
	#print "debug: string="string", problem="problem", cause="cause
	gsub(/A (Radio NW Service|Cell Broadcast service) Impact ?|userLabel(:| =) ( *\| *)?|The Additional Info:?(:| =) ["]?/,"",string)
	gsub(/ = /,": ",string)
	#the line below messes up ipv6 addresses, eg: 2001:db8:1::1 -> becomes 2001:db8:1:1
	#gsub(/::+/,":",string)
	gsub(/^[ \t]*|[ \t]*$/,"",string)
	if (problem=="Remote IP Address Unreachable" && alarm_format==1 && string ~ "localIpAddress")
	{
		#lg: assocId: 1 | localIpAddress1: a.b.c.d | localPort: 36422 | remoteIpAddress1: a.b.c.d | remoteIpAddress2: a.b.c.d | remotePort: 36412 | unreachableIpAddress: a.b.c.d
		#al: assocId: 1 localIpAddress1: a.b.c.d localPort: 36422 remoteIpAddress1: a.b.c.d remoteIpAddress2: a.b.c.d remotePort: 36412 unreachableIpAddress: a.b.c.d
		string=gensub(/ ([|] )?localIpAddress.*$/,"",1,string)", "gensub(/^.*unreachableIpAddress: /,"unreachableIpAddress: ",1,string)
	}
	res="("
	if (nopc=="") tpc="PC:" ; else tpc=""
	if (alarm_format==2 || string=="") res=res tpc cause
	if (string != "")
	{
		if (alarm_format==2) res=res ": "
		res=res string
	}
	#show the additionalInfo on COM nodes but not things like:
	#0:correlatedEvents[0]=0
	#0:eventId=100
	#0:N/A
	#To see the complete additionalInfo, use ala/alc instead of al/alt
	gsub(/(^|,)0:((eventId=)?[0-9]+|N\/A|correlatedEvents\[[0-9]+\]=[0-9]+)?/," ",addinf)
	gsub(/ +/," ",addinf)
	gsub(/^ +| +$/,"",addinf)
	gsub(/ *= */,"=",addinf)
	gsub(/<Empty container>/,"",addinf)
	#sub(/ManagedElement:1,/,"ManagedElement=1,",addinf)
	if (addinf!="") res=res " AI: "addinf
	#sub(/:/,"",isnotif)
	#res=res isnotif
	if (isnotif!="")  #new code, replaces above
	{
		if (res ~ / AI: /) res=res isnotif   #when the AT contains AI then we put : in front of the isNotified field
		else  if (res !~ /\. *$/) res= gensub(/ *$/,"",1,res) ". " gensub(/:/,"",1,isnotif)  #there is no AI only AT and no period after the AT
		else res=res gensub(/:/,"",1,isnotif)  #there is no AI only AT but there is a period after the AT
		gsub(/ +/," ",res)
	}
	res=res ")"
	if (res=="()" && what=="nobrack") res=""
	return res
}
function wait_function(inputvariables,   dummy,stopfile,abortLoop,startTime,delay,array)
{
	parse_inputvars(inputvariables)
	split(inputoptions,array,":")
	startTime=array[1]
	delay=array[2]
	stopfile=array[3]
	while (1)
	{
		if ((getline dummy < stopfile)==0 && fileOps("rm "stopfile)==0) { abortLoop=1 ; break }
		if ((systime() - startTime) > delay) break
		sleep(1)
	}
}
function acknowledge_alarms(inputvariables, ack_inputvars,  line)
{
	parse_inputvars(inputvariables)
	make_causeTable()

	if (inputoptions ~ "u") ack_flag="u" ; else ack_flag="a"

	ack_parameters=sprintf("%s %s", ack_flag, ack_inputvars)

	AckAlarm=make_java_command("acknowledgealarm")
	if (AckAlarm==99) return
	system(AckAlarm)

	return 0
}
function parse_event_time(timestring,resultTime,   date,month,yy,time,ampm,hh,mi,ss,last,array,arrayDate,arrayTime)
{
	#Nov 29, 2007 2:31:27 PM
	#09.02.2009 17:57:41
	#2009-jun-01 15:20:17
	#2014. 8. 19 $ 4:30:39
	#25 juin 2014 01:21:58
	#Dec 7, 2021, 10:29:51 AM

	delete resultTime
	last=split(timestring,array," ")
	if (timestring ~ "EVENT_TIME")
	{
		#Mon Dec 11 13:44:45 MET 2006   EVENT_TIME offset  = 0
		yy=array[6]
		month=mm[array[2]]
		date=array[3]
		hh=gensub(/:.*$/,"",1,array[4])
		mi=gensub(/^[^:]+:|:[^:]+$/,"","g",array[4])
		ss=gensub(/^.*:/,"",1,array[4])
	}
	else if (last >= 4)
	{
		if (array[1] ~ /^[A-Z]/)
		{
		 	#Mar 13, 2004  2:29:15 AM
		 	#Mar 13, 2004 14:29:15
		 	#Aug 25, 2014 11:13:13 AM
		 	#Dec 7, 2021, 10:29:51 AM
			date=gensub(",","",1,array[2]) ; month=mm[array[1]] ;  yy=gensub(/,$/,"",1,array[3]) ; time=array[4] ; ampm=array[5]
		}
		else if (array[2] ~ /^[A-Za-z]/)
		{
			#15 oct. 1582 01:00:00
			#25 juin 2014 01:21:58
			date=array[1] ; month=mm[array[2]] ;  yy=array[3] ; time=array[4]
		}
		else
		{
			#TR HS86152 :
			#2014. 8. 19 $ 4:30:39
			sub(/\.$/,"",array[1]) ; sub(/\.$/,"",array[2])
			date=array[3] ; month=sprintf("%02d",array[2]) ; yy=array[1] ; time=array[last]
		}
		split(time,array,":")
		hh=array[1] ; mi=array[2] ; ss=array[3]
		hh=fix_hour(hh,ampm)
	}
	else if (last >= 2)
	{
	 	#18/03/2004 23:02:18
	 	#18/03/2004 11:02:18 PM
	 	#21-Aug-2006 14:00:00
	 	#21-Aug-2006 2:00:00 PM
		#09.02.2009 17:57:41
		#2009-jun-01 15:20:17
		split(array[1],arrayDate,/[-\/\.]/)
		if (arrayDate[1] ~ /^[1-2][0-9][0-9][0-9]$/) yy=arrayDate[1] ; else date=arrayDate[1]
		if (arrayDate[2] ~ /^[0-9]/) month=arrayDate[2] ; else month=mm[arrayDate[2]]
		if (arrayDate[3] ~ /^[1-2][0-9][0-9][0-9]$/) yy=arrayDate[3] ; else date=arrayDate[3]
		split(array[2],arrayTime,":")
		hh=arrayTime[1] ; mi=arrayTime[2] ; ss=arrayTime[3]
		ampm=array[3]
		hh=fix_hour(hh,ampm)
	}
	resultTime["Date_Time"]=sprintf("%4s-%02d-%02d %02d:%02d:%02d",yy,month,date,hh,mi,ss)
	resultTime["timestamp"]=mymktime(sprintf("%s %s %s %s %s %s",yy,month,date,hh,mi,ss))
	return resultTime["Date_Time"]
}
function parse_xmlsys_log(inputvariables,  date,array)
{
	parse_inputvars(inputvariables)
	make_causeTable()
	xml_log=commandfile
	split(currentDir,array,";")
	startdate=array[1]
	enddate=array[2]
	if (inputoptions ~ /[dxwj]|^g2/)
	{
		if (inputoptions ~ "c") csvformat=1
		#if (inputoptions ~ "j") calculateNodeDowntime(xml_log,startdate,enddate) --> obsolete
		if (inputoptions ~ "d") showNodeDowntime(xml_log,startdate,enddate)
		else if (inputoptions ~ "x") showActiveAlarms(xml_log,startdate,enddate)
		else if (inputoptions ~ "j") showAlarmsDuration(xml_log,startdate,enddate)
		else if (inputoptions ~ "w") showActiveConnections(xml_log,startdate,enddate)
		else if (inputoptions ~ "g2") lgg2_function(xml_log,startdate,enddate)
		return
	}
	if (inputoptions ~ "i") reverse_sort=1 ; else reverse_sort=0
	if (inputoptions ~ "c") csvoutput=1 ; else csvoutput=0
	if (comcli>0)
	{
		if (xml_log ~ /availabilityLog/) parse_xml_log(inputoptions)
		else if (xml_log ~ /(mosLog[0-9]+|[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)\.log$/) parse_mos_log()
		else if (comLogType=="xb") parse_esi_log(xml_log)
		else
		{
			if (mom_version ~ /PRBS_NODE_MODEL/) parse_pico_log(xml_log,comLogType)
			else if (xml_log ~ /teread[^\/]*.log$/) parse_te_log()
			else if (xml_log ~ /llog[^\/]*.log$/) parse_llog_log()
			else if (xml_log ~ /pmdzpm[^\/]*.log$/) parse_pmdzpm_log()
			else parse_rcs_log(xml_log,comLogType)
		}
		return
	}
	else if (yangcli>0)
	{
		if (xml_log ~ /(mosLog[0-9]+|[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)\.log$/) parse_mos_log()
		else parse_rcs_log(xml_log,comLogType)
		return
	}
	if (xml_log ~ /\.xml$/) parse_xml_log(inputoptions)
	else if (xml_log ~ /teread[^\/]*.log$/) parse_te_log()
	else if (xml_log ~ /tedLog/) parse_ted_log()
	else if (xml_log ~ /llog[^\/]*.log$/) parse_llog_log()
	else if (xml_log ~ /pmdzpm[^\/]*.log$/) parse_pmdzpm_log()
	else if (xml_log ~ /ls[^\/]*.log$/) parse_ls_log()
	else if (xml_log ~ /bp[^\/]*.log$/) parse_bp_log()
	else if (xml_log ~ /(mosLog[0-9]+|[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)\.log$/) parse_mos_log()
	else if (xml_log ~ /\.log$/) parse_upg_log()
	else if (xml_log ~ /\.(cmd|mo)$/) parse_command_log(inputoptions)
	else if (xml_log ~ /xblogs/) parse_xb_logs(inputoptions)
	else if (xml_log ~ /bgfLog/) parse_mgw_log("bgf")
	else if (xml_log ~ /ipcsLog/) parse_mgw_log("ipcs")
	else if (xml_log ~ /sweaLog/) parse_mgw_log("swea")
	else parse_sys_log()
}
function lgg2_function(file,startdate,enddate,   sep,fruMap,a,i,tfru,inAL,riMap,arr,j)
{
	customPrint("")
	if (csvformat) sep=";" 
	else 
	{
		sep="  "
		customPrint("\
======================================================================================================\n\
Timestamp (UTC)           Board            Restart\n\
======================================================================================================")
	}

	while ((getline < file)>0)
	{
#0001: ManagedElement=229324_Kokomo_East,Equipment=1,FieldReplaceableUnit=RRU-11          BXP_2                Radio 4449 B5 B13          KRC 161 749/1          R1M            CF89239712          20210722      
#0001: ManagedElement=229324_Kokomo_East,Equipment=1,FieldReplaceableUnit=RRU-21          BXP_3                Radio 4449 B5 B13          KRC 161 749/1          R1M            CF8A894173          20220625      
#0001: ManagedElement=229324_Kokomo_East,Equipment=1,FieldReplaceableUnit=RRU-31          BXP_4                Radio 4449 B5 B13          KRC 161 749/1          R1M            CF8A603670          20220507      
#RiLink=12                                               riPortRef1        FieldReplaceableUnit=1,RiPort=A
#RiLink=12                                               riPortRef2        FieldReplaceableUnit=RRU-1,RiPort=DATA_1
#2024-02-24;18:06:38;AL  ;Minor ;FieldReplaceableUnit=RRU-11;Input Power Failure;Power Failure Alarm (PFA). AI: UI=[{"PN":"Radio 4449 B5 B13","SN":"CF89239712","PNR":"KRC 161 749/1","PR":"R1M"}]
#2024-02-24;18:11:23;LLOG ;BXP_2;          ;No:   15. Board restart. Reason: Program Crash. Program: slave_init_check.sh. Rank: Cold. PMD: /var/log/pmd/pmd-generated-slave_init_check.sh-952-20240224-181121.tgz. Extra: CXP9013268%15_R95LB
#2024-01-25;05:43:23;LLOG ;0001;BB6630     ;No:   25. Board restart. Reason: Ordered restart. Rank: Cold. Extra: 'Upgrade activate'
#2024-01-26;14:21:44;AL  ;Cleared;FieldReplaceableUnit=RRU-11;Input Power Failure;Power Failure Alarm (PFA). AI: UI=[{"PN":"Radio 4449 B5 B13","SN":"CF8A898066","PNR":"KRC 161 749/1","PR":"R1M"}]
#2024-01-20;02:22:04;AL  ;Minor ;RiLink=12;Link Failure;Not in operation. Near end port:FieldReplaceableUnit=1,RiPort=A (transportType=NOT_SET) (Mixed Mode with other ME).
#2024-01-20;02:24:53;AL  ;Cleared;RiLink=12;Link Failure;Not in operation. Near end port:FieldReplaceableUnit=1,RiPort=A (transportType=NOT_SET) (Mixed Mode with other ME).
		if ($1=="0001:" && $2~/,FieldReplaceableUnit=/) 
		{
			sub(/^.*,/,"",$2)
			fruMap[$2]=$3
		}
		else if ($1~/^RiLink=/ && $3~/^FieldReplaceableUnit=/)
		{
			sub(/,.*$/,"",$3)
			if (fruMap[$3]!="") riMap[$1]=riMap[$1] ","fruMap[$3]
			sub(/^,/,"",riMap[$1])
		}
		#Debug:
		#if ($1=="Total:")
		#{
		#	for (j in fruMap) print j,fruMap[j]
		#	print ""
		#	for (j in riMap) print j,riMap[j]
		#}
		split($0,a,";")
		for (i in a) gsub(/^[ \t]*|[ \t]*$/,"",a[i])
		if (a[3]=="AL" && a[6]=="Input Power Failure")
		{
			tfru=fruMap[a[5]]
			if (a[4]=="Cleared") delete inAL[tfru] 
			else inAL[tfru]=1
		}
		else if (a[3]=="AL" && a[5]~/^RiLink=/ && a[6]~/^(Link Failure|Link Degraded|Link Stability)$/)
		{
			split(riMap[a[5]],arr,",")
			for (j in arr)
			{
				tfru=arr[j]
				if (a[4]=="Cleared") delete inAL[tfru] 
				else inAL[tfru]=1
			}
		}
		else if (a[3]=="LLOG")
		{
			if (a[4]=="0001") delete inAL
			tfru=a[4]
			if (inAL[tfru]==1) continue
			if (sep!=";") gsub(/;/," ")
			customPrint($0)
		}
	}
	close(file)
}
function parse_esi_log(dir,   fileList,i,n,file,filename,array,nTrans,a,j,k,line)
{
	#DEBUG: parsing com.log file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/comte/com.log.1
	#DEBUG: parsing com.log file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/comte/com.log.2
	#DEBUG: parsing com.log file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/comte/com.log.3
	#DEBUG: parsing com.log file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/comte/com.log.4
	#DEBUG: parsing erlang.log file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/erlang/erlang.log.1
	#DEBUG: parsing erlang.log file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/erlang/erlang.log.2
	#DEBUG: parsing erlang.log file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/erlang/erlang.log.3
	#DEBUG: parsing ai file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/AiLog/AiLog.1
	#DEBUG: parsing a_t file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/AuditTrailLog/AuditTrailLog.1
	#DEBUG: parsing atr file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/AuditTrailLog/AuditTrailLog.1
	#DEBUG: parsing a_t file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/AuditTrailLog/AuditTrailLog.2
	#DEBUG: parsing atr file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/AuditTrailLog/AuditTrailLog.2
	#DEBUG: parsing a_t file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/AuditTrailLog/AuditTrailLog.3
	#DEBUG: parsing atr file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/AuditTrailLog/AuditTrailLog.3
	#DEBUG: parsing lic file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/LicensingLog/LicensingLog.1
	#DEBUG: parsing sec file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/SecurityLog/SecurityLog.1
	#DEBUG: parsing swmi file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/SwmInternal/SwmInternal.1
	#DEBUG: parsing upg file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/SwmLog/SwmLog.1
	#DEBUG: parsing sys file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/SystemLog/SystemLog.1
	#DEBUG: parsing tri file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20141010-130115_5680/xblogs3164/rcs/log/TriLog/TriLog.1
	#DEBUG: parsing coma file /home/eanzmagn/moshell_logfiles/logs_moshell/tempfiles/20150929-093824_5980/xblogs8996/rcs/comte/com_alarm.log.0


	delete fileList
	if (csvoutput!=1)
	{
		customPrint("======================================================================================================")
		customPrint(sprintf("%-19s %-4s %-6s %s","Timestamp","Type","Sev","Description"))
		customPrint("======================================================================================================")
	}
	#find_session="find "dir" -name \"*.[0-9]\" -type f"
	find_session="find "dir" -type f"
	while ((find_session |& getline)>0)
	{
		if ($1!~ /\.([0-9]+|log)$/ && $1!~/\/(syslog|llog|crash_log|ComSALog_[_0-9]+|relog(\.[0-9]+)?|syslog(\.[0-9]+)?|(RcsEcoli|RcsPmCounters|RcsPmCountersStart|RcsPmEvents)_[-.T0-9tx]+)$/) 
		{
			#print $1
			continue
		}
		fileList[$1]=$1
	}
	close(find_session)
	#find_session="find "dir" -name \"*.log\" -type f"
	#while (find_session |& getline)
	#{
	#	#if ($1 !~ /cpu_load.log$/) continue
	#	fileList[$1]=$1
	#}
	#close(find_session)
	n=asort(fileList)

	k=0
	nTrans[++k]=trans["AiLog"]            ="ai"                #rcs/log/AiLog/AiLog.1
	nTrans[++k]=trans["saLogAlarm"]       ="al"                #rcs/saf_log/saLogAlarm/saLogAlarm_20151012__091100.log
	nTrans[++k]=trans["AuditTrailLog"]    ="a_t"  #MO          #rcs/log/AuditTrailLog/AuditTrailLog.1
	nTrans[++k]=trans["AuditTrailLog"]    ="atr"  #COLI        #rcs/log/AuditTrailLog/AuditTrailLog.1
	nTrans[++k]=trans["cpu_load.log"]     ="capi"              #cpu_load.log
	nTrans[++k]=trans["com.log"]          ="com"               #rcs/comte/com.log.0
	nTrans[++k]=trans["com_alarm.log"]    ="coma"              #rcs/comte/com_alarm.log.0
	nTrans[++k]=trans["ComInterfaceLog"]  ="comi"              #rcs/log/ComInterfaceLog/ComInterfaceLog.1
	nTrans[++k]=trans["erlang.log"]       ="erl"               #rcs/bootlogs/erlang.log.1 AND rcs/erlang/erlang.log.1
	nTrans[++k]=trans["NotificationLog"]  ="ev"                #rcs/log/NotificationLog/NotificationLog.1
	nTrans[++k]=trans["LicensingLog"]     ="lic"               #rcs/log/LicensingLog/LicensingLog.1
	nTrans[++k]=trans["LttngLog"]         ="ltt"               #rcs/log/LttngLog/LttngLog.1
	nTrans[++k]=trans["MMILog"]           ="mmi"               #rcs/log/MMILog/MMILog.1
	nTrans[++k]=trans["nl_log"]           ="nl"                #rcs/bootlogs/nl_log.1 AND rcs/networkloader/nl_log.1
	nTrans[++k]=trans["saLogNotification"]="notif"             #rcs/saf_log/saLogNotification/saLogNotification_20151012__091100.log
	nTrans[++k]=trans["PnpApplicationLog"]="pnp"               #rcs/saf_log/PnpApplicationLog/PnpApplicationLog_20151012__091312.log
	nTrans[++k]=trans["saLogSystem"]      ="sys"               #rcs/saf_log/saLogSystem/saLogSystem_20151012__091100.log
	nTrans[++k]=trans["SecurityLog"]      ="sec"               #rcs/log/SecurityLog/SecurityLog.1
	nTrans[++k]=trans["SwmInternal"]      ="swmi"              #rcs/log/SwmInternal/SwmInternal.1
	nTrans[++k]=trans["TnApplicationLog"] ="tnapp"             #rcs/saf_log/TnApplicationLog/TnApplicationLog_20151012__091254.log
	nTrans[++k]=trans["TnNetworkLog"]     ="tnnet"             #rcs/saf_log/TnNetworkLog/TnNetworkLog_20151012__091254.log
	nTrans[++k]=trans["TriLog"]           ="tri"               #rcs/log/TriLog/TriLog.1
	nTrans[++k]=trans["SwmLog"]           ="swm"               #rcs/log/SwmLog/SwmLog.1
	nTrans[++k]=trans["upgrade"]          ="upg"               #rcs/saf_log/saLogUpgrade/upgrade_20151008__092217.log
	nTrans[++k]=trans["RcsPmCounters"]    ="pmc"               #rcs/log/RcsPmCounters/RcsPmCounters.1
	nTrans[++k]=trans["RcsPmEvents"]      ="pmev"              #rcs/log/RcsPmEvents/RcsPmEvents.1
	nTrans[++k]=trans["syslog"]           ="syslog"            #var/log/syslog
	nTrans[++k]=trans["llog"]             ="llog"              #var/log/llog/llog
	nTrans[++k]=trans["ee_esi.log"]       ="hw"                #tmp/ee_esi/ee_esi.log
	nTrans[++k]=trans["sync-dcg.log"]     ="sync"              #applicationlogs/SyncDusg2_CXP2020001_1/sync-dcg.log
	nTrans[++k]=trans["esiNC.log"]        ="nc"                #applicationlogs/RBSNC_CXP2020082_1/esiNC/esiNC.log
	nTrans[++k]=trans["esiIC.log"]        ="ic"                #applicationlogs/RBSIC_*/esiIC/esiIC.log
	nTrans[++k]=trans["ricm_esi.log"]     ="ricm"              #applicationlogs/RICM_*/ricm_esi.log
	nTrans[++k]=trans["BXP_xxx.log"]      ="fru"               #applicationlogs/RBSNC_*/esiFRUs/BXP_xxx.log or fru_xxx.log
	nTrans[++k]=trans["lrat_esi_capsule_info.log"]="lratcaps"  #applicationlogs/LRAT-RACOAM-ARM_*/lrat_esi_capsule_info.log
	nTrans[++k]=trans["VesInternalLog"]   ="vesi"              #rcs/log/VesInternalLog/VesInternalLog.1
	nTrans[++k]=trans["HealthCheckInternalLog"] ="hci"         #rcs/log/HealthCheckInternalLog/HealthCheckInternalLog.1
	nTrans[++k]=trans["LogLog"]           ="loglog"            #rcs/log/LogLog/LogLog.1
	nTrans[++k]=trans["UgTriLog"]         ="ugtri"             #rcs/log/TriLog/UgTriLog
	nTrans[++k]=trans["ComSALog"]         ="comsa"             #rcs/log/ComSALog/ComSALog
	nTrans[++k]=trans["l1pmi-msg-mod_pm"] ="l1pm"              #rcs/saf_log/PlmLog/l1pm/l1pmi-msg-mod_pm_20211126__141704.log
	nTrans[++k]=trans["l1pmi-msg-mod_info"]   ="l1pm"          #rcs/saf_log/PlmLog/l1pm/l1pmi-msg-mod_info_20211126__025401.log
	nTrans[++k]=trans["l1pmi-msg-port_mgmt"]  ="l1pm"          #rcs/saf_log/PlmLog/l1pm/l1pmi-msg-port_mgmt_20211126__135410_20211126__184948.log
	nTrans[++k]=trans["l1pmi-msg-mod_status"] ="l1pm"          #l1pmi-msg-mod_status_20211029__125809_20211110__002904.log
	nTrans[++k]=trans["l1pmi-rhai_hsp"]   ="l1pm"              #l1pmi-rhai_hsp_20211122__212736_20211124__212717.log
	nTrans[++k]=trans["relog"] = "relog"                       #var/log/relog
	nTrans[++k]=trans["WratDcg"] = "wrat"                      #rcs/applicationlogs/WRAT_CXP*/WratDcg.log
	nTrans[++k]=trans["rexlog.log"] = "rexlog"                 #var/log/rexlog.log  => produced by the command "lh ru relog --read"
	nTrans[++k]=trans["NtpLog"]             ="ntp"             #rcs/log/NtpLog/NtpLog.1
	nTrans[++k]=trans["HealthCheckLog"]     ="hc"              #rcs/log/HealthCheckLog/HealthCheckLog.1
	nTrans[++k]=trans["RcsEcoli"]           ="ecoli"           #rcs/log/RcsEcoli/RcsEcoli_2022-11-28T132921.730.txt
	nTrans[++k]=trans["crash_log"]          ="crash"           #var/log/clog/crash_log , crash_log.1, ....
	

	#Not yet supported
	nTrans[++k]=trans["erlang_system_log"]="erlsys"            #rcs/erlang_disk/erlang_system_log.1
	nTrans[++k]=trans["nl_debug"]="nldeb"                      #rcs/bootlogs/nl_debug.1
	nTrans[++k]=trans["com_trace"]="comtr"                     #rcs/comte/com_trace.log.0

	#unknown logs, do they still exist?
	nTrans[++k] =trans["AvcLog"]           ="avc"
	nTrans[++k] =trans["SystemLog"]        ="syst"

	split(xbLogFilter,array,",")
	for (i in array)
	{
		if (array[i]~/^[0-9]+(-[0-9]+)?$/)
		{
			split(array[i],a,"-")
			if (a[2]=="") a[2]=a[1]
			for (j=a[1];j<=a[2];j++)
			{
				if (nTrans[j]!="") xbFilter[nTrans[j]]=nTrans[j]
			}
		}
		else if (array[i]=="TransparentDisplay") TransparentDisplay=1
		else xbFilter[array[i]]=array[i]
	}
	for (i=1;i<=n;i++)
	{
		file=fileList[i]
		filename=gensub(/^.*\//,"",1,file)
		if (mosdebug==1) print "FILE="filename
		#print "FILE="filename
		if (filename ~ /\.[0-9]+$/)
		{
			#rcs/bootlogs/erlang.log.1
			#rcs/bootlogs/nl_debug.1  #Not supported
			#rcs/bootlogs/nl_log.1
			#rcs/networkloader/nl_log.1
			#rcs/comte/com.log.0
			#rcs/comte/com_alarm.log.0
			#rcs/comte/com_trace.log.0
			#rcs/erlang/erlang.log.1
			#rcs/erlang_disk/erlang_system_log.1
			#rcs/log/AiLog/AiLog.1
			#rcs/log/AuditTrailLog/AuditTrailLog.1
			#rcs/log/ComInterfaceLog/ComInterfaceLog.1
			#rcs/log/LicensingLog/LicensingLog.1
			#rcs/log/MMILog/MMILog.1
			#rcs/log/NotificationLog/NotificationLog.1
			#rcs/log/SecurityLog/SecurityLog.1
			#rcs/log/SwmInternal/SwmInternal.1
			#rcs/log/SwmLog/SwmLog.1
			#rcs/log/TriLog/TriLog.1
			#rcs/log/ComSALog/ComSALog.3
			sub(/\.[0-9]+$/,"",filename)
		}
		else if (filename ~ /_[0-9]+_.*_[0-9]+\.log$/)
		{
			#The SAF logs
			#rcs/saf_log/PnpApplicationLog/PnpApplicationLog_20151012__091312.log
			#rcs/saf_log/saLogAlarm/saLogAlarm_20151012__091100.log
			#rcs/saf_log/saLogNotification/saLogNotification_20151012__091100.log
			#rcs/saf_log/saLogSystem/saLogSystem_20151012__091100.log
			#rcs/saf_log/TnApplicationLog/TnApplicationLog_20151012__091254.log
			#rcs/saf_log/TnNetworkLog/TnNetworkLog_20151012__091254.log
			#rcs/saf_log/saLogUpgrade/upgrade_20151008__092217.log
			#rcs/saf_log/PlmLog/l1pm/l1pmi-msg-mod_pm_20211126__141704.log
			sub(/_[0-9]+_.*_[0-9]+\.log$/,"",filename)
		}
		else if (filename ~ /WratDcg\.log$/) sub(/\.log$/,"",filename)
		else if (filename ~ /ComSALog_[_0-9]+$/)
		{
			#rcs/log/ComSALog/ComSALog_20210311_160608_891
			sub(/_.*$/,"",filename)
		}
		else if (filename ~ /(RcsEcoli|RcsPmCounters|RcsPmCountersStart|RcsPmEvents)_[-.T0-9tx]+$/)
		{
			#RcsEcoli_2022-11-28T132921.730.txt
			sub(/_.*$/,"",filename)
		}
		else if (filename ~ /^(BXP_[0-9_]+|fru_[0-9_]+|esiFRUs)\.log$/) filename="BXP_xxx.log"
		if (filename=="AuditTrailLog")
		{
			parse_rcs_log(file,"a_t","nohead")
			parse_rcs_log(file,"atr","nohead")
		}
		#var/log/syslog
		#var/log/llog/llog
		#var/log/clog/crash_log
		else if (filename in trans && trans[filename]!="") parse_rcs_log(file,trans[filename],"nohead")
		else parse_rcs_log(file,gensub(/Log/,"",1,filename),"nohead")
	}
}
function parse_pico_log(file,comLogType,nohead,  sever,n,rec,record,ti,a,sev,i,flag,trans,op,attr,sep,currmd,yy,severityTable,newflag)
{
	#fmevents.log
	#2010-01-01T00:00:38.631792+00:00 Id:20549:EoamFault_InitialNBAPlinkEstablishmentSupervision,Status:1:EStatus_Start,Source:2,Message:EOAM_Fault received
	#
	#ai
	#2014/06/03 08:22:48 Web server connection disabled, OSS-RC connection in use.
	#
	#sys
	#Jun  3 08:29:39 : SysEvnt: Cell operationalState has been changed to ENABLED
	#Jun  4 08:20:30 MWA-API: INF SysEvnt: SYNC_STATS - Daily sync summary, statistics (min / avg / max | samples), heartbeat = 86401
	#Jun  4 08:20:30 MWA-API: INF SysEvnt: SYNC_STATS - FreqErr (ppb) -76.17 / -0.49 / 74.08 | 142 (measured against external reference)
	#
	#security
	#Jun  3 08:21:40 com: ERR  -          isAttrNotifiable moc of mo ManagedElement=PRBS417,SystemFunctions=1,SecM=1,CertM=1,TrustedCertificate=4,id=1,trustedCertificateId=4,certMId=1 is does not exist in the model
	#Jun  5 21:18:58 sshd: Connection closed by a.b.c.d [preauth]
	#
	#runtime
	#Jun  5 23:06:04 ntpd: NTP 3 [226016.227]:
	#
	#startup
	#Jan  1 00:00:01 OS: Memory: 767MB = 767MB total
	#
	#error
	#Jun  5 21:37:30 ntpd: tx timestamp failed after 1 tries cnt -1 len 48
	#
	#SwUpgradeLog
	#2014/1/30 9:45:44 File: SWPackageContent.xml FTPStatus: OK Integrity check: OK
	#SW package top level information stored: productName: RBS6401, productNumber: CXP 902 3306/1, productRevision: R32AL

	if (comLogType=="hw") comLogType="ai"
	if (comLogType=="llog") comLogType="runt"
	flag=comLogType
	if (file=="") return
	if (file!="" && fileOps("test -s "file)!=0) return
	if (csvoutput==1) sep=";" ; else sep=" "
	while ((getline < file)>0)
	{
		gsub("\r",""); gsub("\x00","")
		if (comLogType=="al")
		{
			#alarm
			#Jun  3 08:20:39 com: INF Alarm Log: <FmLogRecord>   <LogTimestamp>2014-06-03T08:20:39Z</LogTimestamp>   <Alarm>1;2014-06-03T08:20:38Z;ManagedElement=PRBS417,Equipment=1,RbsUnit=1;193;7864325;Intrusion Alarm;410;MAJOR;109;1;ENVIRONMENTALARM;</Alarm></FmLogRecord>
			#Jun  3 08:20:39 com: INF Alarm Log: <FmLogRecord>   <LogTimestamp>2014-06-03T08:20:39Z</LogTimestamp>   <Alarm>1;2014-06-03T08:20:38Z;ManagedElement=PRBS417,Equipment=1,RbsUnit=1;193;7864325;Intrusion Alarm;410;MAJOR;109;1;ENVIRONMENTALARM;</Alarm></FmLogRecord>
			#Jun  3 08:25:28 com: INF Alarm Log: <FmLogRecord>   <LogTimestamp>2014-06-03T08:25:28Z</LogTimestamp>   <Alarm>1;2014-06-03T08:25:28Z;ManagedElement=PRBS417,Transport=1,Synchronization=1,RadioEquipmentClock=1;193;7864327;Synchronization Lost;506;MAJOR;36;2;COMMUNICATIONSALARM;</Alarm></FmLogRecord>
			#Jun  3 08:25:38 com: INF Alarm Log: <FmLogRecord>   <LogTimestamp>2014-06-03T08:25:38Z</LogTimestamp>   <Alarm>1;2014-06-03T08:25:38Z;ManagedElement=PRBS417,Transport=1,Synchronization=1,RadioEquipmentClock=1;193;7864327;Synchronization Lost;506;CLEARED;36;3;COMMUNICATIONSALARM;</Alarm></FmLogRecord>
			#2014-09-17T23:23:05.321+00:00 com: INF Alarm Log: <FmLogRecord>   <LogTimestamp>2014-09-17T23:23:05+00:00</LogTimestamp>   <Alarm>1;2014-09-17T23:22:49+00:00;ManagedElement=PRBS412,Equipment=1,RbsUnit=1;193;7864325;Intrusion Alarm;410;MAJOR;109;1;ENVIRONMENTALARM;2014-09-17T23:22:49+00:00;MAJOR;109;1;0</Alarm></FmLogRecord>
			gsub(/^.*<Alarm> *| *<\/Alarm.*$/,"")
			split($0,a,";")
			split(a[2],b,/[A-Z]/)
			sub(/[-+][0-9][0-9]:[0-9][0-9]$/,"",b[2])
			ti=b[1] sep b[2]
			parseSeverity(a[8],severityTable)
			sev=severityTable["one"]
			record[++n]=sprintf("%-19s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,sprintf("%s %s %s (%s)",sev,a[6],parseMoInstance(a[3]),a[9]))
			continue
		}

		if (($1 ~ /^[-0-9]+T[-+.:0-9]+$/)||($1~/^[/0-9]+$/ && $2~/^[:.0-9]+$/)||($1~/^[A-Z][a-z][a-z]$/ && $2~/^[1-9][0-9]*$/ && $3~/^[:.0-9]+$/))
		{
			n++
			if ($1 ~ /^[-0-9]+T[-+.:0-9]+$/)
			{
				#2010-01-01T00:00:38.631792+00:00 Id:20549:EoamFault_InitialNBAPlinkEstablishmentSupervision,Status:1:EStatus_Start,Source:2,Message:EOAM_Fault received
				#2010-01-01T00:00:15+00:00 Id:20547:EoamFault_SWFallbackDone,Status:1:EStatus_Start,Source:4,Message:EOAM_Fault received
				split($1,a,"T")
				sub(/\..*$/,"",a[2])
				sub(/[-+].*$/,"",a[2])
				ti=a[1] sep a[2]
				sub(/^[^ ]+ +/,"")
			}
			else if ($1~/^[/0-9]+$/ && $2~/^[:.0-9]+$/)
			{
				split($1,a,"/")
				sub(/\..*$/,"",$2)
				split($2,b,":")
				ti=sprintf("%s-%02d-%02d%s%02d:%02d:%02d",a[1],a[2],a[3],sep,b[1],b[2],b[3])
				sub(/^[^ ]+ +[^ ]+ +/,"")
			}
			else if ($1~/^[A-Z][a-z][a-z]$/ && $2~/^[1-9][0-9]*$/ && $3~/^[:.0-9]+$/)
			{
				sub(/\..*$/,"",$3)
				currmd=strftime("%m-%d %H%M%S",systime()+3600)
				if (currmd >= sprintf("%02d-%02d %s",mm[$1],$2,$3)) yy=strftime("%Y",systime())
				else yy=strftime("%Y",systime())-1
				ti=sprintf("%s-%02d-%02d%s%s",yy,mm[$1],$2,sep,$3)
				sub(/^[^ ]+ +[^ ]+ +[^ ]+ +/,"")
			}
			record[n]=sprintf("%-19s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,$0)
		}
		else if (NF>0) record[n]=record[n]" "gensub(/^[ \t]*|[ \t]*$/,"","g",$0)
		if (flag=="a_t")
		{
			#2015-11-17T05:16:24.335+01:00 com: INF interface=cli  user-name=admin  session-id=1  Invoke setMo(): DN: ManagedElement=PRBS550 class: ManagedElement, attribute: userLabel, value: 'test'
			#2015-11-17T05:16:28.166+01:00 com: INF interface=cli  user-name=admin  session-id=1  Invoke deleteMo(): DN: ManagedElement=PRBS550 class: ManagedElement, attribute: userLabel
			#2015-11-17T05:19:29.954+01:00 com: INF interface=cli  user-name=admin  session-id=1  Invoke createMo(): DN: ManagedElement=PRBS550,SystemFunctions=1,Pm=1,PmJob=test class: PmJob
			#2016-11-14T08:33:19.570+01:00 com: INF interface=netconf  user-name=COMUser  session-id=6  Invoke createMo():  Parent-DN: ManagedElement=ENB504,SystemFunctions=1,Pm=1,PmJob=262_USERDEF.LTE_PICO_1.Profile_262.Continuous_Y.MEASJOB class: MeasurementReader, keyAttr: measurementReaderId, keyValue: OPR_1138489128
			split(record[n],a,SUBSEP)
			if (!((a[2] ~ / Invoke +(set|create|delete|action)/)||(a[2] ~ /interface=netconf/ && a[2]!~/getMo\(\)|\(transaction/)))
			{
				delete record[n]
				continue
			}
			if (/interface=cli/) newflag="MO-C" ; else newflag="MO-N"
			sub("A_T",newflag,a[1])
			sub(/^.* Invoke +/,"",a[2])
			sub(/^.* (user-name|session-id)=[^ ]+ +/,"",a[2])
			sub(/^setMo..: +(DN: +)?/,"SET ",a[2])
			sub(/^createMo..: +(DN: +)?/,"CRE ",a[2])
			sub(/^deleteMo..: +(DN: +)?/,"DEL ",a[2])
			sub(/^action..: +(DN: +)?/,"ACT ",a[2])
			sub(/ +class: +[^ ]+/,"",a[2])
			gsub(/,? +(attribute|value|action):? +/," ",a[2])
			record[n]=a[1] SUBSEP a[2]
		}
	}
	close(file)
	rcs_print_records(sprintf("%-19s %-4s %s","Timestamp","Type","Description"),n,record,comLogType,nohead)
}
function parse_rcs_log(file,comLogType,nohead,    sever,n,rec,record,ti,a,b,sev,i,flag,trans,op,attr,sep,mo,text,severityTable,dollar3,currcore,extra,c,additionalTextField,tt,arr,aok,tres,x,tCI,buff,inbuff,tbd,crashB,crashL,crash_string,yy,ay,ii,aT,aline,atext,arrt,arrz,tzfield,millisecs)
{
	if (xbLogFilter!="" && xbFilter[comLogType]=="") return
	#From the document Service Availability Forum Application Interface Specification , Log Service SAI-AIS-LOG-A.02.01:
	#define SA_LOG_SEV_EMERGENCY 0
	#define SA_LOG_SEV_ALERT 1
	#define SA_LOG_SEV_CRITICAL 2
	#define SA_LOG_SEV_ERROR 3
	#define SA_LOG_SEV_WARNING 4
	#define SA_LOG_SEV_NOTICE 5
	#define SA_LOG_SEV_INFO 6
	sever[0]=sever["EM"]=sever["EMERGENCY"]="EMERG"
	sever[1]=sever["AL"]=sever["ALERT"]="ALERT"
	sever[2]=sever["CR"]=sever["CRITICAL"]="CRIT"
	sever[3]=sever["ER"]=sever["ERROR"]="ERROR"
	sever[4]=sever["WA"]=sever["WARNING"]="WARN"
	sever[5]=sever["NO"]=sever["NOTICE"]="NOTICE"
	sever[6]=sever["IN"]=sever["INFO"]="INFO"
	sever["PROGRESS"]="PROGRESS"
	sever["SUPERVISOR"]="SUPERV"
	sever["CRASH"]="CRASH"
	trans["action():"]="ACT"
	trans["createMo():"]="CRE"
	trans["deleteMo():"]="DEL"
	trans["setMo():"]="SET"
	if (comLogType=="hw" && file!~ /ee_esi.log$/) comLogType="ai"
	if (mom_version ~ /^(MRF|BGF|SBG|MTAS|CSCF)_NODE_MODEL/)
	{
		if (comLogType=="al") comLogType="coma"
		else if (comLogType=="ev") comLogType="come"
		else if (comLogType=="sys") comLogType="sysm"
		else if (comLogType=="sec") comLogType="csec"
		else if (comLogType=="swea") comLogType="com-sa"
		else if (comLogType=="cons") comLogType="lmsa"
	}
	if (file=="") return
	if (file!="" && fileOps("test -s "file)!=0) return
	if (csvoutput==1) sep=";" ; else sep=" "
	if (mosdebug==1) print "DEBUG: parsing "comLogType" file "file
	while ((getline < file)>0)
	{
		gsub("\r",""); gsub("\x00","")
		gsub(/|||||\xa0/,"")
		if (TransparentDisplay==1)
		{
			customPrint($0)
			continue
		}
		
		#YANG LOGS
		#AL: ["2022-10-13T15:41:50.574Z","info","eric-fh-alarm-handler",{"asi":{"vendor":193,"version":"0.5","eventTime":1665675710563000,"category":"CommunicationsAlarm","probableCause":14,"additionalInformation":{"1":"262-80"},"specificProblem":"GNBCUUP Service Unavailable","serviceName":"eric-ran-cu-cp-nwif","alarmName":"GNBCUUPServiceUnavailable","code":9175282,"description":"Service lost for PLMNs listed in Additional Information.","alarmUpdate":0,"severity":"Major","faultyResource":"ManagedElement=1,GNBCUCPFunction=1","log_plane":"alarm"}}]
		#MO: 2022-10-13T14:56:03.084Z        info    admin   eric-cm-yang-provider   Successfully committed changes, changes: [{"op":"add","path":"/ietf-system:system/authentication/user/0","value":"[adminpriv1#name][adminpriv1#name][adminpriv1#name][adminpriv1#name][adminpriv1#name][adminpriv1#name]********[/adminpriv1#name][/adminpriv1#name][/adminpriv1#name][/adminpriv1#name][/adminpriv1#name][/adminpriv1#name]"}]
		#SEC: 2022-10-13T14:23:37.542Z        info    eric-sec-sip-tls        Certificate Authority generated for Custom Resource: eric-cm-yang-provider-ca with certificate content: Subject CN:eric-cm-yang-provider-ca, Issuer CN:eric-cm-yang-provider-ca, Not Before:2022-10-13 14:23:06, Not After:2122-09-19 14:23:36, generatedSecretName:eric-cm-yang-provider-cmmobs-ca-cert
		#SEC: 2022-10-13T19:02:57.968Z        INFO    eric-data-name-service-pf-fa-domain     <0x709ca6999e2c15c7> User id is "ski:b9:d4:5a:c9:5d:f0:be:80:61:4e:01:aa:6b:66:84:07:4e:03:3b:10".
		#YANG LOGS new
		#AL: ["2024-02-12T23:25:13.457-06:00","info","eric-fh-alarm-handler",{"asi":{"eventTime":1707801913446000,"vendor":193,"severity":"Major","description":"No F1-C link exists to gNodeB-CU-CP listed in Additional Information","category":"CommunicationsAlarm","probableCause":14,"log_plane":"alarm","serviceName":"eric-ran-bs-du-f1-c","specificProblem":"GNBCUCP Service Unavailable","additionalInformation":{"1":"1919161 5GNB BLOOMINGTONSAP CUCP"},"version":"0.5","faultyResource":"GNBDUFunction","alarmName":"GnbCuCpServiceUnavailable","code":9175306,"alarmUpdate":0},"fluentbit":{"filename":"/logs/alarm-handler.log"}}]
		#MO: 2024-02-12T22:39:48.966-06:00   info    lteuser eric-cm-yang-provider   Action execution completed, session_type: netconf, session: 3556, action: list-pm-metrics, output: ....
		#SEC: 2024-02-12T22:37:04.690519272-06:00     info    eric-ran-du-cp-e5l-mgmt Reloading certificate for TLSConfig[name=kvdbrs, key=/etc/certs/kvdbrs/privkey.pem, file=/etc/certs/kvdbrs/cert.pem, ca=/etc/certs/ca/cacertbundle.pem]
		#AV:  [ "2024-02-12T23:27:02.34521828-06:00" "info", "eric-ran-du-cp-cell-nr", "NRCellDU in service", { "file": "/home/jenkins/agent/workspace/1.11_PostMerge_CR_eric-ran-du-cp-cell-nr_EC/cell/src/status/status_handler.go:112", "cell_local_id": 113, "gnb_du_id": 19191612509, "gnb_id": 1919161, "availability_status": { "status": "InService", "type": "DU" } }

		if (yangcli>0) 
		{
			if (comLogType=="lic") flag="K8EV"
			else flag=comLogType
			if (flag=="av")
			{
				if ($0=="]") 
				{
					$0=avbuff
					avbuff=""
					sub(/\[/,"")
				}
				else 
				{
					avbuff= avbuff $0
					continue
				}
			}
			if (flag~/^(al|av)$/) 
			{ 
				sub(/,/," ") ;  $0=$0 
			}
			gsub(/\[|"/,"",$1)
			sub(/Z$/,"",$1)
			split($1,arrt,"T")

			### old:
			### sub(/[-+].*$/,"",arrt[2])
			### ti=arrt[1] sep arrt[2]
			
			### new:
			if (arrt[2]~/[-+][0-9:]+$/)
			{
				#convert to UTC
				split(arrt[2],arrz,/[:]/) #22:37:04.690519272-06:00
				sub(/[^0-9].*$/,"",arrz[3])
				tzfield=gensub(/^[^-+]+|:/,"","g",arrt[2])
				if (arrt[2]~/[.][0-9]/) millisecs=gensub(/^[^.]+[.]|[-+].*$/,"","g",arrt[2])
				#print sprintf("%s.%s%s%s",arrt[1],arrz[1],arrz[2],tzfield),arrz[3]"."millisecs
				ti=local_to_utc(sprintf("%s.%s%s%s",arrt[1],arrz[1],arrz[2],tzfield),arrz[3]"."millisecs,sep)
			}
			else ti=arrt[1] sep arrt[2]
			### end new

			sub(/^[^ ]+ +/,"",$0)
			if (flag=="al")
			{
				delete aT
				yy=split($0,ay,/,"/)
				for (ii=1;ii<=yy;ii++) 
				{
					gsub(/"/,"",ay[ii])
					aT[gensub(/:.*$/,"",1,ay[ii])]=gensub(/^[^:]+:/,"",1,ay[ii])
				}
				sev=toupper(aT["severity"])
				parseSeverity(sev,severityTable)
				if (csvoutput==1) sev=severityTable["long"]
				else sev=severityTable["one"]
				atext=sprintf("%s%s",aT["description"],(aT["additionalInformation"]!=""?" AI: "aT["additionalInformation"]:""))
				if (csvoutput!=1) atext="("atext")"
				#2023-01-27;08:29:54;AL  ;Cleared;ENodeBFunction=1;External Link to GNodeB Failure;X2 link problem to one or several neighbouring gNodeBs. AI: PLMN ID-gNB ID 1 = 310260-2099253
				aline=sprintf("%s%s%s%s%s%s%s",sev,sep,aT["faultyResource"],sep,aT["specificProblem"],sep,atext)
				record[++n]=sprintf("%-23s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,aline)
				
			}
			else record[++n]=sprintf("%-23s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,$0)
			continue
		}
		
		
		#BXP_4: 2022-10-20T09:47:12Z.656<Tdelta: -0.515><Orig: RadioApplication,RadioBoardCtrl><Msg: Enable Operational Mode Start clientRef=4097, serverRef=305>
		#BXP_4: 2022-10-20T09:47:12Z.656<Orig: RadioApplication,RadioBoardCtrl><Msg: Enable Operational Mode End clientRef=4097, serverRef=305>
		if (comLogType=="rexlog")
		{
			if ($1!~/^[^:]+:$/) continue
			tbd=gensub(/:$/,"",1,$1)
			sub(/^[^:]+:[ \t]+/,"")
		}
		#2022-08-17T09:31:55Z.204<Orig: RP,RPC,RpcCellNr><Msg: Activate Cell End duCellId=4>
		if (comLogType=="relog" || comLogType=="rexlog")
		{
			sub("<"," <",$1)
			sub("Z","",$1)
			$0="1 "$0
			if (comLogType=="rexlog") sub(/ </," "tbd" <")
		}
		

		#In audit trail, some entries are printed on several lines, convert to single line:
		#....582332  2022-06-27T14:30:47Z 1487435_5GNB_CROWN_CCDX "INFO:FieldReplaceableUnit=BB-1: src_ip(2001:4888:a03:2234:c0:1a1:0:14) interface=coli user-name=rbs session-id=75269304 executed-command=/lrat/bbicdump result=[[70,
		#                                                                                          105,
		#                                                                                          108,
		#                                                                                          101,
		#                                                                                          32,
		#                                                                                          101,
		#                                                                                          114,
		#                                                                                          114,
		#                                                                                          111,
		#                                                                                          114,
		#                                                                                          58|
		#                                                                                          enoent]]"
		if (comLogType~/^(a_t|atr)$/)
		{
			if ($1~/^[.]+[0-9]+$/ && $2~/^[-0-9]+T[0-9:]+Z$/)
			{
				if ($NF!~/["]$/)
				{
					inbuff=1
					buff=$0
					continue
				}
			}
			else if (inbuff==1)
			{
				buff=buff " "gensub(/^[ \t]*/,"",1,$0)
				if ($NF~/["]$/)
				{
					$0=buff
					inbuff=0
					buff=""
				}
				else continue
			}
		}
		
		#convert lines like: (nl@localhost)1> =CRASH REPORT==== 18-Nov-2019::08:35:34.340663 ===
		#to: =CRASH REPORT==== 18-Nov-2019::08:35:34.340663 ===
		#Some lines can be corrupt like:
		#do_start_ssh_daemon=NOTICE REPORT==== 2019-11-21T09:35:47.964239+00:00 ===
		#===END====NOTICE REPORT==== 2019-11-21T08:18:04.730862+00:00 ===
		if (comLogType=="erl" && $2~/=[A-Z]+$/ && $3~/^REPORT=+$/ && $NF~/^=+$/) sub(/^[ \t]*[^ \t]+[ \t]+/,"")

		#convert lines like: =INFO REPORT==== {{2020,2,7},{9,7,26}} ===
		#to: =INFO REPORT==== 2020-02-07T09:07:26 ===
		if (comLogType=="erl" && $1~/=[A-Z]+$/ && $2~/^REPORT=+$/ && $NF~/^=+$/ && $3~/^\{\{([0-9]+),([0-9]+),([0-9]+)\},{([0-9]+),([0-9]+),([0-9]+)\}\}$/)
		{
			match($3,/^\{\{([0-9]+),([0-9]+),([0-9]+)\},{([0-9]+),([0-9]+),([0-9]+)\}\}$/,ta)
			$3=sprintf("%4d-%02d-%02dT%02d:%02d:%02d",ta[1],ta[2],ta[3],ta[4],ta[5],ta[6])
			$0=$0
		}

		#ee_esi.log
		#   1  700101000032  (004)  3/CXC1736593/52_R1D ; Power On (Cable plugged in). Timestamp is however from the power off moment
		#   6  150813160252  (004)  3/CXC1736593/52_R1D ; Power On (Cable plugged in). Timestamp is however from the power off moment
		#   6 * 161130150028  (003)  SW version : Baseband CXP9024418/4 R13GM started                               1    CXP9025546_3_R5BV01
		# 187   190912085055  (004)  Power On (BPM SW). Timestamp is however from the power off moment              25   3/CXC1736593/32_R1A
		# 202   200116223449  (004)  Power On (BPM SW). Timestamp is however from the power off moment              25   3/CXC1736593/32_R1A
		if (comLogType=="hw")
		{
			if ($2=="*") sub(/ [*] /," ")
			if ($1~/^[0-9]+$/ && $2~/^[0-9]{12}$/ && $3~/^\([^)]+\)$/)
			{
				flag=comLogType
				if ($2~/^70/) $2="19"$2
				else $2="20"$2
				split($2,c,"")
				sub(/^ *[^ ]+ +[^ ]+ +/,"")
				ti=sprintf("%d%d%d%d-%d%d-%d%d%s%d%d:%d%d:%d%d",c[1],c[2],c[3],c[4],c[5],c[6],c[7],c[8],sep,c[9],c[10],c[11],c[12],c[13],c[14])
				record[++n]=sprintf("%-19s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,$0)
			}
		}
		#consul
		#2018-11-08T19:39:03.425774+00:00 du1 consul[6831]: agent: Synced check 'service:6975_6975_1_24085679987784312568_RpcCellResourceMgmt'
		#syslog/llog
		#2015-11-25T13:49:29.418536+00:00 axm5516 kernel: [    0.000000] Booting Linux on physical CPU 0x0
		#2015-11-25T15:51:13.333803+00:00 du1 pghd[2173]: rlog: rlog: $ Ordered restart $ 2015-11-25 15:51:13 $ - $ - $ Cold With Test $ - $ - $ Manual restart
		else if (comLogType~/^(syslog|llog|cons)$/ && $1~/^[0-9]+-[0-9]+-[0-9]+T[0-9]+:[0-9]+:[0-9]+.[0-9]+/)
		{
			flag=comLogType
			sub(/\..*$/,"",$1)
			ti=gensub(/T/,sep,1,$1)
			record[++n]=sprintf("%-19s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,gensub(/^[^ ]+ +/,"",1,$0))
		}
		#TRI log:
		#[2014-07-16 20:16:44.708699924] (+0.000832040) du1 com_ericsson_trithread:INFO: { cpu_id = 0 }, { process = "Sync_ptp_coli", fileAndLine = "coli.c:388", msg = "FAILED TO HUNT" }
		#sync-dcg.log:
		#[2019-01-08 01:56:58.683143495] SYNC_SCSPI_RADIO_CLOCK_WARM_UP
		#[2017-08-17 02:40:10.480027854] - PORT_FREQ_REF "ManagedElement=1:Transport=1:Synchronization=1:FrequencySyncIO=1"
		else if (comLogType~/^(tri|sync|nc|ugtri)$/ && $1 ~ /^\[[-0-9]+$/ && $2~/^[:.0-9]+\]$/)
		{
			flag=comLogType
			ti=gensub(/^.|.$/,"","g",$1 sep $2)
			sub(/^[ \t]*\[[^]]+\][ \t]+/,"")
			record[++n]=sprintf("%-19s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,$0)
		}

		#MRF sys
		#     51378 2020-08-24T08:17:13.695+0000  02feff99-7f8f-44cd-b2f1-c64a9b4b1b20 COM SA logger NO: " -                     apply Changing state from PostConfigure to IdleEnabled : delay after config complete"
		else if (comLogType~/^(sysm)$/ && $1~/^[0-9]+$/ && $2~/^[-0-9/T:.]+Z?(\+[0-9]+)?$/)
		{
			flag=comLogType
			sub(/\+[0-9]+$/,"",$2)
			split($2,a,"T")
			ti=sprintf("%s%s%s",a[1],sep,a[2])
			sub(/^[ \t]*[^ \t]+[ \t]+[^ \t]+[ \t]+[^ \t]+[ \t]+/,"")
			record[++n]=sprintf("%-19s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,$0)
		}
		#COM-SEC, COM-SA, LM-SA
		#2020-10-01T01:13:52.689+0530  SC-2: "COM_SA maf_comSAMwComponentStart (): MW SA component start procedure begins: 1601495032689"
		#2020-10-02T13:32:21.430+0530  SC-1: "Emergency user emergency"
		#2020-10-01T10:21:18.554+0530  SC-2: "LM_SA maf_comSAOamComponentStop(): OAM SA component stop procedure completed: 1601527878554"
		else if (comLogType~/^(csec|com-sa|lmsa)$/ && $1~/^[-0-9/T:.]+Z?(\+[0-9]+)?$/)
		{
			flag=comLogType
			sub(/\+[0-9]+$/,"",$1)
			split($1,a,"T")
			ti=sprintf("%s%s%s",a[1],sep,a[2])
			sub(/^[ \t]*[^ \t]+[ \t]+[^ \t]+[ \t]+[^ \t]+[ \t]+/,"")
			record[++n]=sprintf("%-19s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,$0)
		}

		#[2015-10-08 09:22:22]          1 IN Could not get list of modification files from LMHI using tag modification_files, boardType ReqEquipment, return code was 4
		else if (comLogType=="upg" && $1~/^\[/)
		{
			ti=gensub(/\[|\]/,"","g",$1 sep $2)
			sub(/^[^ ]+ +[^ ]+ +/,"")
			sub(/ +$/,"")
			record[++n]=sprintf("%-19s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,$0)
		}
		#Alarm and notification log, for decoding information, google the following references:
		#SAI-AIS-LOG-A.02.01
		#SAI-AIS-NTF-A.02.01
		#SAI-Overview-B.03.02
		#saNtf.h

		#FORMAT: @Cr @Ct @Nt @Ne6 @No30 @Ng30 "@Cb"
		#    6 0x13815C5A635A9C00 0x13815C59EC250800 0x4000                                EthernetPort=eth11             "Ethernet Link Failure"
		#    2 0x138158F057847800 0x138158E52A7E9800 0x4000                                Lm=1                           "CLEARED: License Key File Fault"
		else if (comLogType~/^(al|ev)$/ && $1~/^[0-9]+$/ && $2~/^0x[0-9A-F]+$/ && $3~/^0x[0-9A-F]+$/)
		{
			flag=comLogType
			mo=$5
			text=gensub(/^[^"]+"|"[^"]*$/,"","g",$0)
			if (text ~ /^[^: ]+: +/) { sev=gensub(/:.*$/,"",1,text) ; sub(/^[^:]+: +/,"",text) }
			else sev="MAJOR"
			parseSeverity(sev,severityTable)
			if (csvoutput==1) sev=severityTable["long"]
			else sev=severityTable["one"]
			#the second field gives the time when the entry was written to the log
			#the third field gives the time when the alarm raised, even for alarm ceasing entries.
			#therefore , the timestamp will be taken from the third field in case of alarm raising, and from second field for alarm clearing.
			if (sev=="*") ti=$2 ; else ti=$3
			ti=strftime("%Y-%m-%d %H:%M:%S",sprintf("%d",strtonum(ti))/1000000000,1)
			sub(" ",sep,ti)
			#n=$1+0  #record number is not unique
			n++
			record[n]=sprintf("%-19s%s%-4s%s%-6s%s%s%s",ti,sep,toupper(flag),sep,sev,sep,SUBSEP,(csvoutput==1?sprintf("%s%s%s",mo,sep,text):sprintf("%-35s%s%s",text,sep,mo)))
		}
		#New format:
        	#   13 2015-04-02T09:43:47.000Z EthernetPort=1                 "MINOR: Ethernet Link Failure"
        	#   14 2015-04-02T09:43:51.000Z EthernetPort=1                 "CLEARED: Ethernet Link Failure"
		#         1 12:58:38 08/10/2014 Lm=1                           "CRITICAL: License Key File Fault"
		#         3 2014/10/10T18:59:55 NbapCommon=1                   "MAJOR: RNC Connection Failure"
		#         1 2014-10-16T10:15:56Z Lm=1                           "CRITICAL: License Key File Fault"
		#         1 2015-04-09T13:19:39Z.738 IN Basic_Ethernet "Physical port TN_A link status: down"
		#    4 2015-11-19T05:48:49.000Z ManagedElement=RBS501,Transport=1,Synchronization=1,RadioEquipmentClock=1,RadioEquipmentClockReference=3 "WARNING: Sync Frequency Reference Not Reliable"
		#With additionalText
		#    1 2016-02-26T13:09:39.579Z ManagedElement=1,SystemFunctions=1,Lm=1 "CRITICAL: License Key File Fault :AT:Key file fault in Managed Element"
		#Sometimes the MO can be cut:
		#         1 2016-05-05T21:04:54.612Z ManagedElement=MUSKPR,Equipmen "MINOR: No Connection :AT:"
		#In some cases the line is so long that it will get truncated before the last quote:
		#
		#      4550 2019-07-24T15:20:58.370Z ManagedElement=NSW_SOZK15_Hillvue_Reservoir_St_521225,ENodeBFunction=1 "MINOR: External Link Failure :AT:X2 link problem to one or several neighbouring eNodeBs. :AI:CI={"C": [{"I": "b0f98000-8178-11e8-8e92-98a404368d27","n": "RadioNode"}],"P": "b0f90000-0011-11e8-8e92-98a404368d27"};PLMN ID-eNB ID 1 = 5051-521811;PLMN ID-eNB ID 2 = 5051-523006;PLMN ID-eNB ID 3 = 5051-521868;PLMN ID-eNB ID 4 = 5051-521309;PLMN ID-eNB ID 5 = 5051-524174;PLMN ID-eNB ID 6 = 5051-523830;PLMN ID-eNB ID 7 = 5051-522599;PLMN ID-eNB ID 8 = 5051-520322;PLMN ID-eNB ID 9 = 5051-521474

		else if (comLogType~/^(al|ev)$/ && $1~/^[0-9]+$/ && $2~/^[-0-9/T:.]+Z?(\.[0-9]+)?$/)
		{
			#First remove blank space within the LDN
			#       599 2021-04-23T23:24:25.914Z ManagedElement=VIC_OK1C19_OAKLEIGH_BBH_936514, GNBCUCPFunction=1 "CLEARED: XnC Link to GNodeB Failure :AT:XnC Link to GNodeB Failure :AI:CI={"C": [{"I": "0b524000-fe96-11e9-8e92-78d34736da22","n": "RadioNode"}],"P": "0b520000-0677-11e9-8e92-78d34736da22"};PLMN ID-gNB ID 1 = 505:01-936512 :NOTIFIED"
			if ($3 ~ /^[A-Z][^=]+=.+,$/ && $4~/^[A-Z][^=]+=.+/)
			{
				$4=$3 $4
				sub(/ +[A-Z][^=]+=.+, +/," ")
				$0=$0
			}
			#Replace semicolons with spaces. Otherwise lgj does not work properly since lgj parses "lgac" printout and if the AdditionalText contains semicolons then the text after semicolon will be missed
			gsub(/;/," ")
			
			flag=comLogType
			if ($4 ~ /^[A-Z][^=]+=.+/)
			{
				#	  1 12:58:38 08/10/2014 Lm=1                           "CRITICAL: License Key File Fault"
				mo=$4
				split($3,a,"/")
				if (a[3]~/^[0-9][0-9][0-9][0-9]$/) ti=sprintf("%04d-%02d-%02d%s%s",a[3],a[2],a[1],sep,$2)  #the day was first
				else ti=sprintf("%04d-%02d-%02d%s%s",a[1],a[2],a[3],sep,$2)  #the year was first
			}
			else
			{
				sub(/\.[0-9]+Z$/,"",$2)
				sub(/Z\.[0-9]+$/,"",$2)
				sub(/Z$/,"",$2)
				split($2,a,"T")
				mo=parseMoInstance($3)
				ti=sprintf("%s%s%s",gensub("/","-","g",a[1]),sep,a[2])
			}
			#text=gensub(/^[^"]+"|"[^"]*$/,"","g",$0)
			text=gensub(/^[^"]+["]/,"",1,$0)
			if (text ~ /^[^: ]+: +/) { sev=gensub(/:.*$/,"",1,text) ; sub(/^[^:]+: +/,"",text) }
			else sev="MAJOR"
			parseSeverity(sev,severityTable)
			if (csvoutput==1) sev=severityTable["long"]
			else sev=severityTable["one"]
			additionalTextField=""
			if (text ~ / :AT:/)
			{
				additionalTextField=gensub(/^.* :AT:/,"",1,text)
				tres=remove_CI(additionalTextField)
				split(tres,x,SUBSEP)
				if (show_correlation_info==0) additionalTextField=x[1]
				if (show_updated_alarms!=1) tCI=x[2]
				gsub(/0=<Empty container>/,"",additionalTextField)
				sub(/ :AT:.*$/,"",text)
				sub(/^ +:AI:;*/,"AI:",additionalTextField)
				sub(/ +:AI:;*/," AI:",additionalTextField)
				if (show_notified==0) sub(/ :NOTIFIED/,"",additionalTextField)
				gsub(/ +/," ",additionalTextField)
				sub(/ *AI: *(0|0=|CI|eventId|0=N\/A| )?["]? *$/,"",additionalTextField)
				sub(/["] *$/,"",additionalTextField)
				sub(/^ *: *$/,"",additionalTextField)
				if (additionalTextField ~ /AI: +:(NOTIFIED|SUPPRESSED)/) sub(/AI: +:/,"",additionalTextField)
				if (additionalTextField ~ /[^ ] +(NOTIFIED|SUPPRESSED)/ && additionalTextField !~ /\. +(NOTIFIED|SUPPRESSED)/)
				{
					#if there is not a period between the AT and the notified/suppressed info then put one
					sub(/ *NOTIFIED/,". NOTIFIED",additionalTextField)
					sub(/ *SUPPRESSED/,". SUPPRESSED",additionalTextField)
				}
				if (csvoutput!=1 && additionalTextField !~ /^[ \t]*$/) additionalTextField=" ("additionalTextField")"
			}
			#print severityTable["one"],mo,text
			if (comLogType=="al" && show_updated_alarms!=1)
			{
				split(ti,arr,sep)
				tt=make_timestamp(arr[1],arr[2])
				if (severityTable["one"]=="*")
				{
					delete lga_printed_alarm[text,mo]
					delete lga_printed_alarm_ci[text,mo]
				}
				else
				{
					#print 1,arr[1],arr[2],text,mo,lga_printed_alarm[text,mo],tt
					if (tCI~/["][PS]["]:/)
					{
						if (lga_printed_alarm_ci[text,mo]!="" && tCI==lga_printed_alarm_ci[text,mo]) continue
						lga_printed_alarm_ci[text,mo]=tCI
					}
					#only alarms updated within 60 seconds are hidden to avoid the risk of missing alarms that were ceased and raised after a node restart
					tdelta=tt-lga_printed_alarm[text,mo]
					if (lga_printed_alarm[text,mo]!="" && (tdelta>=0) && (tdelta<60)) 
					{
						#print 2,arr[1],arr[2],text,mo,lga_printed_alarm[text,mo],tt,tdelta
						lga_printed_alarm[text,mo]=tt 
						continue
					}
					#print 3,arr[1],arr[2],text,mo,lga_printed_alarm[text,mo],tt,tdelta
					lga_printed_alarm[text,mo]=tt
				}
			}
			n++
			record[n]=sprintf("%-19s%s%-4s%s%-6s%s%s%s",ti,sep,toupper(flag),sep,sev,sep,SUBSEP,(csvoutput==1?sprintf("%s%s%s%s%s",mo,sep,text,sep,additionalTextField):sprintf("%-35s%s%s%s%s",text,sep,mo,sep,additionalTextField)))
		}

		#COM log
		#0: 2014-10-08 17:54:57.444499 [6] 1 csrc/ComOamSpiComtEManag:445   - newMoIterator            Creating iterator for tx 138 with , ManagedElement
		#Erland log
		else if (comLogType=="com" && $1~/^[0-9]+:$/ && $2 ~ /^[-0-9]+$/ && $3 ~ /^[:.0-9]+$/)
		{
			n++
			ti=$2 sep $3
			flag=comLogType
			sev="INFO"
			sub(/^[^ \t]+[ \t]+[^ \t]+[ \t]+[^ \t]+[ \t]+/,"")
			record[n]=sprintf("%-19s%s%-4s%s%-6s%s%s%s",ti,sep,toupper(flag),sep,sev,sep,SUBSEP,$0)
		}

		#COM alarm log, described in calstore.ericsson.se "COM Management Guide" 1/1553-CAA 901 2587/7
		#   <Alarm>1;2014-10-10T18:59:55+00:00;ManagedElement=1,NodeBFunction=1,Iub=1,NbapCommon=1;193;9175041;RNC Connection Failure;306;MAJOR;;3;COMMUNICATIONSALARM;2014-10-10T18:59:55+00:00;MAJOR;;3;2;0;;0;eventId=0</Alarm>
		else if (comLogType=="coma" && $1 ~ /^<Alarm>/)
		{
			split($0,a,";")
			n++
			split(a[2],b,/[+T]/)
			ti=b[1] sep b[2]
			parseSeverity(a[8],severityTable)
			if (csvoutput==1) sev=severityTable["long"]
			else sev=severityTable["one"]
			flag=comLogType
			for (i in a) gsub(/^[ \t]*|[ \t]*$/,"",a[i])
			if (alarm_format==0) extra=causeTable[a[7]]
			else if (alarm_format==1) extra=(a[9]!~/^[ \t]*$/?a[9]:causeTable[a[7]])
			else if (alarm_format==2) extra=causeTable[a[7]]". "a[9]
			#Now add the Additional Information
			#   <Alarm>1;2017-02-16T19:43:34.057+00:00;ManagedElement=ORPKFL16BBULTE0308383,Equipment=1,AntennaUnitGroup=1;193;9175142;Calibration Failure;315;MINOR;Radio calibration fault.Signal disturbed;255;EQUIPMENTALARM;2017-02-16T19:43:34.057+00:00;MINOR;Radio calibration fault.Signal disturbed;255;2;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=2;0;eventId=750</Alarm>
			#   <Alarm>1;2017-02-17T15:30:58.865+00:00;ManagedElement=ORPKFL16BBULTE0308383,Equipment=1,AntennaUnitGroup=1;193;9175142;Calibration Failure;315;MINOR;Radio calibration fault.Signal disturbed;270;EQUIPMENTALARM;2017-02-17T15:30:58.865+00:00;MINOR;Radio calibration fault.Signal disturbed;270;6;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=2;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=3;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=4;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=5;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=6;0;eventId=751</Alarm>
			#   <Alarm>1;2017-02-16T18:13:56.783+00:00;ManagedElement=ORPKFL16BBULTE0308383,Equipment=1,AntennaUnitGroup=1;193;9175142;Calibration Failure;315;MINOR;Radio calibration fault.Signal disturbed;251;EQUIPMENTALARM;2017-02-16T18:13:56.783+00:00;MINOR;Radio calibration fault.Signal disturbed;251;7;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=1;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=4;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=5;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=6;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=7;0;Direction=UL ManagedElement=1,Equipment=1,AntennaUnitGroup=1,RfBranch=8;0;eventId=749</Alarm>
			if (alarm_format>0 && sev!="*" && (a[16]+0)>0)
			{
				for (i=18;i<=(16+2*a[16]);i++)
				{
					gsub(/^[ \t]+|[ \t]+$/,"",a[i])
					sub(/<[^>]+>/,"",a[i])
					gsub(/ManagedElement=[^,]+,[^,]+=[^,]+,/,"",a[i])
					gsub(/ManagedElement=[^,]+,/,"",a[i])
					extra=extra". "a[i]
					i++
				}
			}
			record[n]=sprintf("%-19s%s%-4s%s%-6s%s%s%s (%s)",ti,sep,toupper(flag),sep,sev,sep,SUBSEP,a[6]" "l2m(a[3]),extra)
		}
		#COM Event log
		#   <Alert>0;2020-08-18T08:47:51.093+00:00;ManagedElement=1,MediaResourceFunction=1,MrfH248Control=1,MrfH248Interface=BLR1_17_mrf1;193;5308420;MRF H.248 Link Recovered after Temporary Outage;0;WARNING;SCTP association recovered;uuid:02feff99-7f8f-44cd-b2f1-c64a9b4b1b20;1;OTHER;2020-08-18T08:47:51.093+00:00;WARNING;SCTP association recovered;uuid:02feff99-7f8f-44cd-b2f1-c64a9b4b1b20;1;0</Alert>
		else if (comLogType=="come" && $1 ~ /^<Alert>/)
		{
			split($0,a,";")
			n++
			split(a[2],b,/[+T]/)
			ti=b[1] sep b[2]
			parseSeverity(a[8],severityTable)
			if (csvoutput==1) sev=severityTable["long"]
			else sev=severityTable["one"]
			flag=comLogType
			for (i in a) gsub(/^[ \t]*|[ \t]*$/,"",a[i])
			if (alarm_format==0) extra=causeTable[a[7]]
			else if (alarm_format==1) extra=(a[9]!~/^[ \t]*$/?a[9]:causeTable[a[7]])
			else if (alarm_format==2) extra=causeTable[a[7]]". "a[9]
			#Now add the Additional Information
			#   <Alert>0;2020-08-18T08:47:51.093+00:00;ManagedElement=1,MediaResourceFunction=1,MrfH248Control=1,MrfH248Interface=BLR1_17_mrf1;193;5308420;MRF H.248 Link Recovered after Temporary Outage;0;WARNING;SCTP association recovered;uuid:02feff99-7f8f-44cd-b2f1-c64a9b4b1b20;1;OTHER;2020-08-18T08:47:51.093+00:00;WARNING;SCTP association recovered;uuid:02feff99-7f8f-44cd-b2f1-c64a9b4b1b20;1;0</Alert>

			if (alarm_format>0 && sev!="*" && (a[16]+0)>0)
			{
				for (i=18;i<=(16+2*a[16]);i++)
				{
					gsub(/^[ \t]+|[ \t]+$/,"",a[i])
					sub(/<[^>]+>/,"",a[i])
					gsub(/ManagedElement=[^,]+,[^,]+=[^,]+,/,"",a[i])
					gsub(/ManagedElement=[^,]+,/,"",a[i])
					extra=extra". "a[i]
					i++
				}
			}
			record[n]=sprintf("%-19s%s%-4s%s%-6s%s%s%s (%s)",ti,sep,toupper(flag),sep,sev,sep,SUBSEP,a[6]" "l2m(a[3]),extra)
		}


		#Erlang log, old format:
		#=CRASH REPORT==== 18-Nov-2019::08:36:04.416013 ===
		#=WARNING REPORT==== 1-Oct-2014::23:55:55.911991 +00:00 ===
		#    pid: <0.1899.0>
		#    module: comte_com
		#    line: 599
		#    req: {healthCheck,25000}
		#    state: {stop_com,prepareTermination}
		#    msg: "Unexpected call from {<0.1902.0>,#Ref<0.0.0.78514>}."
		#=END ===

		#Erlang log, new format:
		#=INFO REPORT==== 2019-10-11T06:36:45.337615+00:00 ===
		#=sysInitServer <0.106.0> in sysDbServer:get_apps/0 (line: 478)=
		#sysDbServer: sysDbServer: CxsFileP: "/home/sirpa/software/*-up.xml"
		#=END===
		else if (comLogType=="erl" && $1~/=[A-Z]+$/ && $2~/^REPORT=+$/ && $NF~/^=+$/)
		{
			n++
			if ($3~"::") #old format
			{
				split($3,a,"::")
				split(a[1],b,"-")
				ti=sprintf("%04d-%02d-%02d",b[3],mm[b[2]],b[1]) sep a[2]
			}
			else
			{
				split($3,a,"T")
				ti=a[1] sep gensub(/\+.*$/,"",1,a[2])
			}
			flag=comLogType
			sev=sever[gensub(/^.*=+/,"",1,$1)]
			record[n]=sprintf("%-19s%s%-4s%s%-6s%s%s",ti,sep,toupper(flag),sep,sev,sep,SUBSEP)
		}
		#*** [2019:10:21 14:20:17 930] SNMP A-CONF DEBUG ***
		#   init snmp_framework_mib
		#*** [2019:10:21 14:20:17 989] SNMP A-CONF DEBUG ***
		#   configure snmp_framework_mib
		else if (comLogType=="erl" && $1=="***" && $2~/^\[/)
		{
			n++
			sub(/^\[/,"",$2)
			split($2,a,":")
			ti=sprintf("%s-%s-%s",a[1],a[2],a[3]) sep $3
			flag=comLogType
			sev=gensub(/^.*\]/,"",1,$0)
			record[n]=sprintf("%-19s%s%-4s%s%-6s%s%s",ti,sep,toupper(flag),sep,sev,sep,SUBSEP)
		}
		#Other logs old format
		#........26 2014-05-23T13:58:55  6 APPM appmServer:Starting progs in parallell: [{"eqmh","CXC1734941_1"},
		#                                         {"rbcibnl","CXC1734941_1"},

		#Other logs new format (1)
		#.........1 2014/10/10T18:54:33                                "INFO Start loading configuration files"
		#.........1 2014/10/10T18:53:20 SwInventory                    "INFO Running upgrade package MSRBS CXP9023001/1 R3A977"
		#.........1 2014/10/10T18:54:34 -                              "6 EventId(1) interface=netconf  user-name=autoint-7YtIpRIVE8  session-id=1  Batch setting attribute: DN: ManagedElem
		#......1765 2014/10/11T18:32:20 COLI                           "INFO User: expert Cmd: /os/meminfo Rc: normal"
		#......1755 2014/10/11T18:30:36 -                              "6 EventId(1) interface=cli  user-name=expert  session-id=1 cmd-grp-name=ComBasicCommands CLI agent connection start."
		#........15 2014-11-21T10:57:45Z -                              "INFO: EventId(1) interface=netconf  user-name=autoint-7YtIpRIVE8  session-id=1  Batch setting attribute: DN: ManagedElement=1,SystemFunctions=1,SysM=1,Snmp=1,SnmpTargetV2C=1 attrName: administrativeState, numAttrValue: 1, attrType: 12, attrValue: <administrativeState>UNLOCKED</administrativeState>"
		#........35 2015-03-05T15:56:11Z createMo <-                    "INFO: 17 <<"ManagedElement=1,Equipment=1">> <<"FieldReplaceableUnit">> <<"fieldReplaceableUnitId">> <<"1">> [{<<"administrativeState">>,
                #                                                                                       {12,
                #                                                                                        1}}]"
                #........39  2020-09-03T00:15:05Z createMo <- "INFO:14 <<"ManagedElement=1,Equipment=1,AntennaUnitGroup=RIR14_A1CE">> <<"AntennaUnit">> <<"antennaUnitId">> <<"1">> [{<<"mechanicalAntennaTilt">>,{3,0}}]"


		#Other logs new format (2)
		#.........1 00:00:09 1970/01/01 IN  Initiating system time to software build time: "Sun Sep 14 14:06:57 CEST 2014"
		#........17 12:58:09 2014/10/08 IN SwInventory Consists of EMCLITOOL CXP9024020/1 R1T
		#.........1 12:58:59 2014/10/08 6 - EventId(1) interface=netconf  user-name=autoint-7YtIpRIVE8  session-id=1  Invoke createMo():  Parent-DN: ManagedElement=1,Equipment=1 class: FieldReplaceableUnit, keyAttr: fieldReplaceableUnitId, keyValue: 1
		#.....10437 18:32:27 2014/10/11 IN COLI User: expert Cmd: /misc/prompt -s EndOfPrint\ncoli> Rc: normal
		#.........2 13:18:38 2014/10/08 IN ManagedElement=1 src_ip(-) LDAP: lookup for user: expert, Authenticated: true, Roles: expert, export
		#........10 12:23:08 2014/09/14 IN  Download progress: 10%
		#.....10433 18:28:38 2014/10/11 6 - EventId(1) interface=cli  user-name=expert  session-id=1  Invoke action(): DN: ManagedElement=1,SystemFunctions=1,LogM=1,Log=AiLog.export class: Log, action: export
		#.....44734 2015-11-10T18:09:05Z - "INFO: FieldReplaceableUnit=1: src_ip(-) EventId(1) interface=cli  user-name=rbs  session-id=14  Invoke action(): DN: ManagedElement=IrwolDogyeL0,SystemFunctions=1,LogM=1,Log=TnNetworkLog class: Log, action: export"

		#......1755 2016-11-11T04:12:46Z COLI "INFO: FieldReplaceableUnit=BB-1: src_ip(a.b.c.d) User: rbs Ref: <0.14547.0> Cmd: /fruacc/lhsh BXP_2_13 fui get temp Rc: 0"



		#Other logs new format (3)  : TnNetwork
		#         1 2014/10/10T18:57:37 IN Basic_Ethernet "ManagedElement=1,Transport=1,EthernetPort=1 link status: locked"
		#       708 09:58:53 10/11/2014 IN Basic_Ethernet "ManagedElement=1,Transport=1,EthernetPort=TN_H link status: up"

		#Other logs new format (3) : PNP
		#     15708 06:35:45 03/24/2017 IN  "Pnp Request:  MO ManagedElement=1,ENodeBFunction=1; ACTION actionname actionCreateIratCellAndRel; NoOfAttributes 13; S32 arfcn 4412; S32 bandIndicatorGeran 0; S32 pci 84; STRUCT sourcePlmnId noOfStructMembers 3; S32 mcc 505; S32 mnc 1; S32 mncLength 2; S32 sourceEnbId 533354; S32 sourceCellId 31; STRUCT targetPlmnId noOfStructMembers 3; S32 mcc 505; S32 mnc 1; S32 mncLength 2; S32 targetRncId 332; S32 targetCellId 2805; S32 rat 0; S32 locationAreaCode 8786; S32 routingAreaCode 1; S32 coverageIndicator 0; Result = Successful"

		#New new format of AuditTrail and SecurityLog from 18.Q1, there is no more space after the severity, eg:
		#.....54531  2018-01-11T12:33:24Z 1 "NOTICE:FieldReplaceableUnit=1: src_ip(-) interface=coi  interface-application=emgbeMibHandler  user-name=undefined  Transaction 459 Commit"
		#.......592  2018-01-09T14:13:00Z COLI "INFO:src_ip(a.b.c.d) User: muser Ref: <0.16951.0> Cmd: /misc/authlevel disabled Rc: normal"
		#......9996  2018-01-12T06:18:44Z ManagedElement=1 "INFO:FieldReplaceableUnit=1: src_ip(a.b.c.d) COLI, User: expert, Ref: <0.4407.17>, coli session ended, session count 0"
		#......9995  2018-01-12T06:18:42Z 1 "INFO:FieldReplaceableUnit=1: src_ip(a.b.c.d) SSH: User: expert, sftp session ended, session count 0"
		#......1982  2018-01-11T12:38:49Z SwM                    "INFO:FieldReplaceableUnit=1: Software audit complete"

		#SWEA
		#1 2020-07-08T12:14:00Z.546 ER fru_manager_thread "EventId: 182; MO: ManagedElement=1,Equipment=1,FieldReplaceableUnit=10; faultMessage: SwError; faultId: 769; faultDescription: Incompatible SW"

		else if (comLogType!~/^(coma|sync|nc|erl)$/ && $1 ~ /^(k.*)?[.]*[0-9]+$/ && $2 ~ /^[-:/.T0-9]+Z?(\.[0-9]+)?$/)
		{
			#n=gensub(/^[.]+/,"","g",$1)+0  #record number is not unique
			n++
		        if ($2 ~ /^[-/0-9]+T[.:0-9]+Z?(\.[0-9]+)?$/)  #old format and new format (1) or (3)
		        {
		        	ms=""
		        	if ($2~/^[-/0-9]+T[.:0-9]+Z?\.[0-9]+?$/) ms=gensub(/^.*Z\./,"",1,$2)
		        	sub(/\.[0-9]+Z$/,"",$2)
		        	sub(/Z\.[0-9]+$/,"",$2)
		        	sub(/Z$/,"",$2)
				split($2,a,"T")
				ti=gensub("/","-","g",a[1]) sep a[2]
				if ($3 ~ /^"[A-Z]+:[^ \t]+/) { sub(":",": ",$3) ; $0=$0 }
				else if ($4 ~ /^"[A-Z]+:[^ \t]+/) { sub(":",": ",$4) ; $0=$0 }
				if ($3 ~ /^"(EMERGENCY|ALERT|CRITICAL|ERROR|WARNING|NOTICE|INFO):?$/)      { dollar3="" ; sev=gensub(/^"|:$/,"","g",$3)   ; sub(/^ *[^ ]+ +[^ ]+ +[^ ]+ +/,"")        ; $0=$0 }
				else if ($4 ~ /^"(EMERGENCY|ALERT|CRITICAL|ERROR|WARNING|NOTICE|INFO):?$/) { dollar3=$3 ; sev=gensub(/^"|:$/,"","g",$4)   ; sub(/^ *[^ ]+ +[^ ]+ +[^ ]+ +[^ ]+ +/,"") ; $0=dollar3" "$0 }
				else if ($3 ~ /^([0-6]|EM|AL|CR|ER|WA|NO|IN)$/){ dollar3="" ; sev=sever[$3]                    ; sub(/^ *[^ ]+ +[^ ]+ +[^ ]+ +/,"")        ; $0=$0 }
				else if ($3 ~ /^"[0-6]$/)                { dollar3="" ; sev=sever[gensub(/^"/,"",1,$3)] ; sub(/^ *[^ ]+ +[^ ]+ +[^ ]+ +/,"")        ; $0=$0 }
				else if ($3 ~ /^"[A-Z]+:?$/)             { dollar3="" ; sev=gensub(/^"|:$/,"","g",$3)   ; sub(/^ *[^ ]+ +[^ ]+ +[^ ]+ +/,"")        ; $0=$0 }
				else if ($4 ~ /^"[0-6]$/)                { dollar3=$3 ; sev=sever[gensub(/^"/,"",1,$4)] ; sub(/^ *[^ ]+ +[^ ]+ +[^ ]+ +[^ ]+ +/,"") ; $0=dollar3" "$0 }
				else if ($4 ~ /^"[A-Z]+:?$/)             { dollar3=$3 ; sev=gensub(/^"|:$/,"","g",$4)   ; sub(/^ *[^ ]+ +[^ ]+ +[^ ]+ +[^ ]+ +/,"") ; $0=dollar3" "$0 }
				else                                      {                                               ; sub(/^ *[^ ]+ +[^ ]+ +/,"")               ; $0=$0           }
				gsub(/ +/," ")
				if (comLogType!~/^(swea)$/) sub(/["] *$/,"")
			}
			else if ($2~/^[:0-9]+$/) #new format (2) or (3)
			{
				theda=gensub("/","-","g",$3)
				split(theda,ddarr,"-")
				if (ddarr[3] ~ /^[12][0-9][0-9][0-9]$/) theda=ddarr[3]"-"ddarr[1]"-"ddarr[2]
				ti=theda sep $2
				if ($4 ~ /^([0-6]|EM|AL|CR|ER|WA|NO|IN)$/) sev=sever[$4]
				else if ($4 ~ /^[A-Z]+$/) sev=$4
				sub(/^ *[^ ]+ +[^ ]+ +[^ ]+ +[^ ]+ +/,"")
			}
			#if (comLogType=="a_t" && $1=="COLI") continue   #old: $1!="-"  -> does not work because can also be the nodename
			#if (comLogType=="atr" && $1!="COLI") continue
			if (comLogType~/^(a_t|atr)$/)
			{
				aok=0
				if (comLogType=="a_t") # lgo
				{
					if ($1!="COLI" && $0!~/interface=coli/) aok=1
				}
				else if (comLogType=="atr")  #lgl
				{
					if ($1=="COLI" || $0~/interface=coli/) aok=1
				}
				if (aok==1) sub(/^[ \t]*[^ \t]+[ \t]*/,"") #remove the first word which can be COLI, - , 1, or the nodename
				if (aok!=1) continue
			}
			if (comLogType=="hw") flag="ai"
			else if (comLogType=="ipc") flag="tn-n"
			else if (comLogType=="rlib") flag="tn-a"
			else if (comLogType=="cons") flag="cons"
			else if (comLogType=="a_t")
			{
				op=""
				if (/Invoke getMo\(\)/) continue
				if (/Transaction [0-9]+ (Commit|Abort)|[Tt]ransaction (commit|abort)|agent connection start|agent connection end/) continue
				if (/interface=cli.* command: (show|prompt|top|width|length|scriptmode|exit)/) continue
				#- EventId(1) interface=netconf  user-name=autoint-7YtIpRIVE8  session-id=1  Batch setting attribute: DN: ManagedElement=1,SystemFunctions=1,SecM=1,UserManagement=1,LdapAuthenticationMethod=1 attrName: administrativeState, numAttrValue: 1, attrType: 12, attrValue: <administrativeState>UNLOCKED</administrativeState>
				#....285822 2015-09-17T18:08:27Z -                              "INFO: ManagedElement=1,Equipment=1,FieldReplaceableUnit=1: EventId(1) interface=cli  user-name=expert  session-id=2  Invoke setMo(): DN: ManagedElement=1,NodeBFunction=1,NodeBLocalCellGroup=1,NodeBLocalCell=22 class: NodeBLocalCell, attribute: administrativeState, value: 'UNLOCKED'"
				#.....44734 2015-11-10T18:09:05Z - "INFO: FieldReplaceableUnit=1: src_ip(-) EventId(1) interface=cli  user-name=rbs  session-id=14  Invoke action(): DN: ManagedElement=IrwolDogyeL0,SystemFunctions=1,LogM=1,Log=TnNetworkLog class: Log, action: export"
				#........31  2018-01-09T07:45:08Z - "INFO: src_ip(-) EventId(1) interface=netconf  user-name=muser  session-id=3  Invoke createMo():  Parent-DN: ManagedElement=Cenobyte_image_redhat007-rcs_7125_qtomdab,Transport=1 class: VirtualEthernetPort, keyAttr: virtualEthernetPortId, keyValue: ETH3"
				#......3617  2020-10-22T10:13:57Z - "INFO:FieldReplaceableUnit=1: src_ip(-) EventId(1) interface=netconf  user-name=expert  session-id=13  Batch setting attribute: DN: ManagedElement=dus5544,SystemFunctions=1,SysM=1,Snmp=1,SnmpTargetV2C=1 attrName: administrativeState, numAttrValue: 1, attrType: 12, attrValue: <administrativeState>LOCKED</administrativeState>"
				#.......873  2020-10-14T13:48:46Z dus5544 "INFO:FieldReplaceableUnit=1: src_ip(-) interface=coi  interface-application=yangEdit  user-name=handle_operation  Transaction 35 Invoke setMo(): DN: ManagedElement=1,SystemFunctions=1,Fm=1 attribute: heartbeatInterval value: '70'"

				#New format:
				#.........1  2021-01-20T09:48:49Z - "NOTICE:src_ip(-) EventId(1) interface=netconf  acct=autoint-5RpCUbciUS  ses=1  Invoke createMo():  Parent-DN: ManagedElement=1,SystemFunctions=1,SecM=1,UserManagement=1,UserIdentity=1 class: MaintenanceUser, keyAttr: maintenanceUserId, keyValue: muser"

				if ($0~"interface=netconf") { flag="MO-N" ; sub(/interface=netconf +/,"") }
				else if ($0~"interface=cli"){ flag="MO-C" ; sub(/interface=cli +/,"") }
				else if ($0~"interface=coi"){ flag="MO-Y" ; sub(/interface=coi +/,"") }

				#for the new format:
				sub(/^.*acct=/,"")
				sub(/ +ses=[^ ]+ +/," ")

				if (flag=="MO-N" || flag=="MO-C")
				{
					sub(/ +session-id=[^ ]+ +/," ")
					sub(/(ManagedElement=[^,]+,Equipment=1,)?FieldReplaceableUnit=[^,: ]+: .*EventId\(1\)/,"EventId(1)")
					sub(/(src_ip[^ ]+ +)?EventId\(1\) +(user-name=|User name: *)/,"")
				}
				else if (flag=="MO-Y")
				{
					sub(/^.*user-name=/,"")
					sub(/ +Transaction [0-9]+ +/," ")
					gsub(/ +attribute: +/," ")
					gsub(/ +value: +/," ")
					gsub(/'/,"")
				}
				for (i=1;i<=NF;i++) {if ($i=="Invoke") {op=trans[$(i+1)]; break}}
				sub(/Invoke +[^ ]+ +/,op" ")
				if (/Batch setting attribute: +/) op="SET"
				sub(/Batch setting attribute: +/,op" ")
				sub(/(\.[^ ]+ +)?class: +[^ ]+, action: +/," ")
				sub(/class: +[^ ]+, +attribute: +/," ")
				sub(/, Session Id: /," session-id=")
				sub(/session-id=/,"sid=")
				sub(/, value: /," ")
				sub(/class: +[^ ]+$/,"")
				if (flag=="MO-N")
				{
					if (op=="CRE")
					{
						sub(/Parent-DN: /,"")
						sub(/ class: /,",")
						sub(/, +keyAttr: +[^ ]+, +keyValue: +/,"=")
					}
					else if (op=="SET")
					{
						attr=""
						for(i=1;i<=NF;i++) { if ($i=="attrName:") { attr=gensub(/,$/,"",1,$(i+1)) ; break }}
						sub(/attrName: /,"")
						sub(/, +numAttrValue: +[^ ]+, +attrType: +[^ ]+, +attrValue: +(<[^<>]+>)?/," ")
						gsub(sprintf("<[/]?%s>",attr),"")
						sub(/<\/[^<>]+> *$/,"")
						gsub(/<\/[^<>]+>/,",")
						gsub(/</,"")
						gsub(/>/,"=")
						sub(/,$/,"")
					}
				}
				sub(/DN: +/,"")
				gsub(/ +/," ")
			}
			else if (comLogType=="atr")
			{
				#....306147 2015-09-17T19:49:17Z COLI "INFO: src_ip(a.b.c.d) ManagedElement=1,Equipment=1,FieldReplaceableUnit=1: User: expert Cmd: /fruacc/lhsh BXP_1 par get SYS_HW* Rc: 0"
				#.....28550 2015-10-21T16:44:42Z COLI "INFO: FieldReplaceableUnit=1: src_ip(a.b.c.d) User: rbs Cmd: /fruacc/lhsh BXP_1_11 ricr -a Rc: 0"
				#......1755 2016-11-11T04:12:46Z COLI "INFO: FieldReplaceableUnit=BB-1: src_ip(a.b.c.d) User: rbs Ref: <0.14547.0> Cmd: /fruacc/lhsh BXP_2_13 fui get temp Rc: 0"

				#New:
				#......3627  2021-01-18T19:37:52Z 1 "INFO:FieldReplaceableUnit=BPU-1: src_ip(10.63.161.196) interface=coli user-name=expert session-id=110857921 executed-command=/wrat/eventlog/cell all /rcs/sftp/rop/wrateventlog_cell result=0"
				#....582305  2022-06-27T14:30:40Z 1487435_5GNB_CROWN_CCDX "INFO:FieldReplaceableUnit=BB-1: src_ip(2001:4888:a03:2234:c0:1a1:0:14) interface=coli user-name=rbs session-id=40250949 executed-command=/lrat/lratdbi result=[[70, 105, 108, 101, 32, 101, 114, 114, 111, 114, 58| enoent]]"

				#for the new format:
				sub(/^.*acct=/,"")
				sub(/^.*user-name=/,"")
				sub(/ +ses=[^ ]+ +/," ")
				sub(/ +session-id=[^ ]+/,"")
				sub(/ +executed-command=/," ")
				sub(/ +result=.*$/,"")

				#for the old format (and new):
				if (/(set_)?prompt (-s )?EndOfPrint/) continue
				sub(/ +src_ip[^ ]+ +/," ")
				sub(/(ManagedElement=[^,]+,Equipment=1,)?FieldReplaceableUnit=[^,: ]+: */,"")
				flag="COLI"
				sub(/COLI User: /,"")
				sub(/Cmd: /,"")
				sub(/User: /,"")
				sub(/Rc: (normal|0)$/,"")
				sub(/Ref: <[^>]*>/,"")
			}
			else if (comLogType=="ipcs") flag="oot"
			else if (comLogType=="bgf") flag="apc"
			else if (comLogType=="hcq") flag="hcm"
			else if (comLogType=="anr") flag="ves"
			else if (comLogType=="l1pm") 
			{
				#    740251  2021-11-26 04:33:44.375  ri_e       |        449 |      32930 | ri_e       |        826 |        131 |       3075 | ri_e       |          - |          - |          - |          - |          - |          - |          - |          - |          - |
				ti=$2 sep $3
				flag="l1pm"
				sub(/^[ \t]*[^ \t]+[ \t]+[^ \t]+[ \t]+[^ \t]+[ \t]+/,"")
			}

			else flag=comLogType
			#HWInvHistoryLog is placed after the AutoIntegration log
			#         1 2020-07-08T02:27:57Z.935 IN  ""ManagedElement=1,Equipment=1,FieldReplaceableUnit=SRU-D""ProductName=RRUS 32 B3""ProductNumber=KRC161413/1""ProductRevision=R1A""SerialNumber=D16T225503XCA""
			#        18 2022-04-25T12:05:18Z.001 IN  "ManagedElement=1,Equipment=1,FieldReplaceableUnit=AIR-2,SfpModule=DATA_1;ProductName=SEP6200LH-E2-W  ;ProductNumber=RDH10275/3    ;ProductRevision=R1A  ;SerialNumber=EA60XL28F2;Reconfiguration"
			#         1 2022-03-25T08:36:27Z.000 IN "Logs restored from backup file"
			if (flag=="ai" && ms~/^[0-9]+$/)
			{
				flag="hwhi"
				sub(/["]+ManagedElement=[^,]+,Equipment=1,/,"")
				gsub(/["]["]/,";")
				gsub(/ *; */," ")
				sub(/["]+ *$/,"")
				sub(/["]+/,"")  #if there is still a quote at the start, remove it
			}

			record[n]=sprintf("%-19s%s%-4s%s%-6s%s%s%s",ti,sep,toupper(flag),sep,sev,sep,SUBSEP,$0)
		}

		#Network loader
		#1970/01/01 00:01:21 Setting system time to software build time: "2015-03-30 16:25:48"
		#2015/04/09 13:13:23 Download progress: 65%
		else if ($1 ~ /^[0-9]+\/[0-9]+\/[0-9]+$/ && $2~/^[0-9]+:[0-9]+:[0-9]+$/)
		{
			split($1,b,"/")
			ti=sprintf("%04d-%02d-%02d",b[1],b[2],b[3]) sep $2
			flag=comLogType
			sub(/^ *[^ ]+ +[^ ]+ +/,"")
			record[++n]=sprintf("%-19s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,$0)
		}
		#CORE 0
		#Mon Mar  9 16:17:22.1425917842
		#load:  1.00
		#us:  1.00 ni:  0.00 sy:  0.00 id: 99.00
		#wa:  0.00 hi:  0.00 si:  0.00 st:  0.00
		#gu:  0.00
		else if (comLogType=="capi")
		{
			if ($1=="CORE" && $2~/^[0-9]+$/ && NF==2) currcore=$2
			else if ($1~/^[A-Z]/ && $2~/^[A-Z]/ && $3~/^[0-9]+$/ && $4~/^[0-9:.]+$/)
			{
				ti=sprintf("%04d-%02d-%02d",strftime("%Y",systime()),mm[$2],$3) sep gensub(/\..*$/,"",1,$4)
				flag=comLogType
				record[++n]=sprintf("%-19s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,sprintf("CORE %02d",currcore),sep,SUBSEP)
			}
			else if (NF>0 && n>0) record[n]=record[n]" "$0
		}

#  {
#    "eventType": "Restart request",
#    "eventTime": "2022-02-15 07:34:24",
#    "entryTime": "2022-02-15 07:34:25.559658",
#    "class": "Primary",
#    "dump": "pmd-dubc_server-5218-20220215-073424",
#    "dumpReady": "2022-02-15 07:34:28.887122",
#    "thread": "dubc_server",
#    "program": "/home/sirpa/software/DUBC-ARM_CXP2020588_2_R51B02/sbin/bc-server",
#    "rank": "Cold",
#    "signal": "SIGABRT",
#    "extra": "Recovery action initiated by DU via BCI, faultId: 0x300 (HwfForEvaluation), faultDescription: Comprehensive Fault /repo/catbuilder/fem1s10-eiffel122/seroius06486/IC-Delivery-DUBC-ARM-bpug2-MTR_20.45_2_3/build/work/bpug2/du-bc/du-bc-/git/src/bc/bc_restart.c:114"
#  },
#	
#  {
#    "eventType": "Program Crash",
#    "eventTime": "2022-03-18 11:51:36",
#    "entryTime": "2022-03-18 11:51:36.952291",
#    "class": "Primary",
#    "dump": "pmd-Nci_control_pro-6099-20220318-115136",
#    "dumpReady": "2022-03-18 11:51:40.671403",
#    "thread": "Nci_control_pro",
#    "program": "/home/sirpa/software/RICM_CXP2020150_2_R27B02/sbin/ricm",
#    "signal": "SIGABRT",
#    "extra": "-"
#  },
#
#  {
#    "eventType": "Escalation Restart",
#    "eventTime": "2022-03-18 11:51:41",
#    "entryTime": "2022-03-18 11:51:41.227931",
#    "class": "Secondary",
#    "reason": "Escalation",
#    "rank": "Warm",
#    "program": "ricm",
#    "extra": "Local"
#  }
#	
#  {
#    "eventType": "Program Crash",
#    "eventTime": "2023-03-13 07:47:38",
#    "entryTime": "2023-03-13 07:47:39.053462",
#    "class": "Primary",
#    "dump": "pmd-cliss-7243-20230313-074738",
#    "dumpReady": "2023-03-13 07:47:45.147178",
#    "thread": "cliss",
#    "program": "/home/sirpa/software/RCSMW-ARM_CXP2020233_2_R26A327/RCSMW_CXC2010721_1/com-R26A327/priv/tgt_arm32/opt/com/bin/cliss -c /etc/rcs_cs/com_user 9889",
#    "signal": "SIGQUIT",
#    "extra": "-",
#    "globalData": {
#        "SW version": "CXP2010005/15-R72A45"
#      }
#  }

		else if (comLogType=="crash")
		{
			flag=comLogType
			if ($0~/^[ \t]*"[^"]+":[ \t]+"/) 
			{
				split($0,aa,":")
				gsub(/[ \t]|"|:/,"",aa[1])
				crashB[aa[1]]=gensub(/^[^:]+:[ \t]+"|",?[ \t]*$/,"","g",$0)
				crashL[aa[1]]=aa[1]
			}
			else if (NF==1 && $1~/^(\},|\])$/)
			{
				ti=gensub(/ /,sep,1,crashB["entryTime"])
				cn=asort(crashL)
				for (ci=1;ci<=cn;ci++) 
				{ 
					if (crashL[ci]~/^(eventType|eventTime|entryTime|dumpReady|extra|rank|class)$/) continue
					crash_string=crash_string crashL[ci]": "crashB[crashL[ci]]" | "
				}
				crash_string=crash_string "extra: "crashB["extra"]
				crash_string=crashB["eventType"]" "crashB["rank"]" "crashB["class"]" | "crash_string
				record[++n]=sprintf("%-19s%s%-4s%s%s%s",ti,sep,toupper(flag),sep,SUBSEP,crash_string)
				delete crashB
				delete crashL
				crash_string=""
			}
		}
			
		else if (NF>0)
		{
			if (NF==1 && $1~/^"$/) continue #some lines contain only a quote
			if (comLogType=="erl" && ($1=="=END" || $1=="=====" || $1=="=END===")) continue
			if (comLogType~/^(coma|come|sync|nc)$/) continue #records only take one line in com_alarm and sync-dcg.log
			#skip lines like this:
			#===== ALIVE Wed Oct  8 16:38:01 UTC 2014
			#===== Wed Oct  8 16:50:54 UTC 2014
			#=END ===
			record[n]=record[n]" "gensub(/^[ \t]*|[ \t]*$/,"","g",$0)
		}
	}
	close(file)
	rcs_print_records(sprintf("%-*s %-4s %-6s %s",(yangcli>0?23:19),"Timestamp","Type","Sev","Description"),n,record,comLogType,nohead)
}
function remove_CI(t,   a,n,z,b,i,s,ci)
{
	#19 2021-03-01T08:33:28.200Z ManagedElement=KISTP5286,SystemFunctions=1,Lm=11 "MINOR: License Key File Fault :AT:test :AI:CI={"C":[{"I":"baab4000-d6c7-11e6-8e92-903809f80af0","n":"RadioNode"}]} :NOTIFIED"
	#1 2021-03-01T08:17:18.653Z ManagedElement=1,SystemFunctions=1,Lm=1 "CRITICAL: License Key File Fault :AT:Key file fault in Managed Element :AI:CI={"C":[{"I":"baab4000-d6c7-11e6-8e92-903809f80af0","n":"RadioNode"}],"P":"baab0000-0001-11e6-8e92-903809f80af0"};eventId=1 :NOTIFIED"
	#8 2021-03-01T08:21:16.799Z ManagedElement=KISTP5286,Equipment=1,FieldReplaceableUnit=DU-01,SfpModule=E "MINOR: SFP Not Present :AT:No SFP or electrical cable plugged in. :AI:CI={"C": [{"I": "baab4000-d6c7-11e6-8e92-903809f80af0","n": "RadioNode"}],"P": "baab0000-0034-11e6-8e92-903809f80af0"};0=<Empty container> :NOTIFIED"
	#CI={"C": [{"I": "40f34000-4ff7-11e8-8e92-98a404015762","n": "RadioNode"}],"P": "40f30000-1bb9-11e8-8e92-98a404015762"};UNIT1=RRUS 32 B66A,D16U569741"
	split(t,a,/CI=\{/)
	n=1
	z=split(a[2],b,"")
	for (i=1;i<=z;i++)
	{
		if (n==0) s=s b[i]
		else if (b[i]=="{") n++
		else if (b[i]=="}") n--
		if (n>0) ci=ci b[i]
	}
	sub(/^;? */,"",s)
	gsub(/^ *| *$/,"",a[1])
	if (a[1]!="") s=a[1]" "s
	return s SUBSEP ci
}

function rcs_process_record(line,what,    a,rec,head,timestamp,array,sep)
{
	split(line,a,SUBSEP)
	head=a[1]
	rec=a[2]
	if (csvoutput!=1) sep=" "; else sep=";"
	split(head,array,sep)
	timestamp=make_timestamp(array[1],array[2])

	#if (timestamp < startdate || timestamp > enddate) return

	#we show all the entries between startdate and enddate even if they have a date outside that range, such as 1970 or 2010
	#if the timestamp is not 1970 or 2000 or 2010 but is less than startdate then we must set rcs_t_ok to 0 => this can happen when parsing a printout from "lh" where there are logs from different boards in the same file, eg "lgk -x rexlog"
	if (strftime("%Y",timestamp)!~/^(1970|2000|2010)$/ && timestamp<startdate) rcs_t_ok=0
	if (timestamp>startdate) rcs_t_ok=1  #start printing
	if (timestamp>enddate) rcs_t_ok=0    #stop printing
	if (rcs_t_ok==0) return

	if (what=="sys" && mom_version ~ /^(CRBS|MSRBS|RCS)_NODE_MODEL/)
	{
		if (rec ~ /Starting progs in parallell:/) { gsub(/["], *["][^"]+["][}],?/,"",rec) ; gsub(/[{]["]/,"",rec) }
		gsub("#","",rec)
	}
	else if (what=="upg" && mom_version ~ /PRBS_NODE_MODEL/)
	{
		gsub(/SW Item product information,? *|,? *[Pp]roduct ?(Name|Number|Revision) *: *|SwInventory.active.consistsOf.administrativeData/," ",rec)
	}
	if (head!~/ (AL|EV) /) gsub(/ +/," ",rec)
	customPrint(head rec)
}
function rcs_print_records(header,n,record,comLogType,nohead,     i)
{
	#used by:
	#function parse_rcs_log (file,comLogType,nohead,  sever,n,rec,record,ti,a,sev,i,flag,trans,op,attr,sep,mo,text,severityTable,dollar3,currcore,extra,b)
	#function parse_pico_log(file,comLogType,nohead,  sever,n,rec,record,ti,a,sev,i,flag,trans,op,attr,sep,currmd,yy,severityTable,newflag)
	rcs_t_ok=0
	if (csvoutput!=1 && nohead!="nohead")
	{
		customPrint("======================================================================================================")
		customPrint(header)
		customPrint("======================================================================================================")
	}
	if (reverse_sort==0)
	{
		for (i=1;i<=n;i++)
		{
			if (i in record && record[i]!="") rcs_process_record(record[i],comLogType)
		}
	}
	else
	{
		for (i=n;i>=1;i--)
		{
			if (i in record && record[i]!="") rcs_process_record(record[i],comLogType)
		}
	}
}
function parse_ls_log(   board,line,lines,i,n,array,date,time,timestamp,size,nfiles)
{
	Define_months()
	customPrint("\n======================================================================================================")
	customPrint(sprintf("%-24s  %s","Timestamp (UTC)","Logfile"))
	customPrint("======================================================================================================")

	while ((getline < xml_log)>0)
	{
		if ($2 ~ /^ftree/) board=$4
		if ($1 ~ /^-r/)
		{
			#-rw-rw-rw-    409325  23 Aug 2011 13:47:39  /c/systemfiles/cello/cma/backuprestore/restorefiles/CXP9013831_R9YC%6.xml P7.1.4-4 (CPP_7.0.3.10.1)
			#skip files that have a upid/cxc translation
			if ($NF !~ /^\//) continue

			#-rw-rw-rw-  175244    26 Sep 2012 01:06:00  /c/pmd/1/000200/0x79dfbac7.pmd

			#if a file is on /d we put the board in front
			if ($NF ~ /^\/d\//) $NF=board"!"$NF
			if ($NF ~ /^\/c\/systemfiles\// && $NF !~ /Trace.log/) continue
			if ($NF ~ /^\/c\/usr\// && $NF !~ /winDrv|dump/) continue

			date=sprintf("%s-%02d-%02d",$5,mm[$4],$3)
			time=$6
			timestamp=make_timestamp(date,time)
			if (timestamp >= startdate && timestamp <= enddate)
			{
				line=sprintf("%s %s FILE  %-10s  %9s  %s",date,time,$1,$2,$NF)
				lines[line]=line
				size+=$2
				nfiles++
			}
		}
	}
	close(xml_log)
	n=asort(lines)
	for (i=1;i<=n;i++)
	{
		customPrint(lines[i])
	}
	customPrint(sprintf("\nTotal: %.1f MB (%s bytes), %s files.",size/1048576,size,nfiles))
}
function parse_bp_log(   ok)
{
	while ((getline < xml_log)>0)
	{
		if ($NF=="BoardGroups") ok=1
		if (ok==1) customPrint($0)
	}
	close(xml_log)
}
function make_board_table(file,    inboard,i,rnc,tpos)
{
	#090626-07:23:45 a.b.c.d 7.1s RBS_NODE_MODEL_L_10_8_COMPLETE stopfile=/tmp/30200
	#Board   BoardType           SwAllocation                    BoardGroups
	#Board   BoardType      Mod  SwAllocation/DevType  BoardGroups
	#001600  GPB53            8  GPB_Module            aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod8 modact modms mp sctpmp
	#Board   BoardType      Mod  ModName    SwAllocation/DevType  BoardGroups
	#001100  GPB            110  MS-11-0    GPB_Module            aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod110 modact modms mp sctpmp
	#Board   BoardType      Mod (fro)  SwAllocation/DevType  BoardGroups
	#001400  GPB43             1  (0)  GPB_Module            aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod1 modact modms modpdr mp sctpmp
	#Board   BoardType      Mod (fro)  ModName    SwAllocation/DevType  BoardGroups
	#000600  GPB75          1061  (0)  MS-6-1     GPB_Module            aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod1061 mod1062 modact modms mp
	#001700  RAX                 RBS_RAXB                        all allp bp rax
	#001200/port_0_dev_13        **                              all ru ru1 xp
	#000100  CBU1                Main_CBU                        aal2ap aal2cpsrc aal2ncc aal2nccadm all allp coremp mp ommp sctpmp
	#002300/sp0.lnh           1  **PDR                 all pdr pdr1 pdrms
	#020900/sp4.lnh          72  ES-2-7-0   **DC                  all dc dc72 dces2
	#000200  GPB53               Core_GPB                        aal2ap aal2cpsrc aal2ncc aal2nccadm all allp coremp mp ommp
	#000600  GPB53               AAL2_GPB                        aal2ap aal2cpsrc aal2ncc all allp mp
	while ((getline < file)>0)
	{
		if (NF >=4 && $NF ~ /^stopfile=/)
		{
			if (inboard==1) break
			#if ($(NF-1) !~ /^(RBS|RNC|(MRS)?MGW|CPP|Cello)/) break
		}
		if (NF >=4 && NF <=6 && $1=="Board" && $2=="BoardType" && $NF=="BoardGroups")
		{
			inboard=1
			if ($3=="Mod") rnc=1
		}
		if (inboard==1 && $1 ~ /^[0-9][0-9][0-2][0-9]00(\/sp.*|\/port.*)?$/)
		{
			if ($1 ~ /\/sp/)
			{
				for (i=2;i<=4;i++)
				{
					if ($i ~ /^\*\*/) boardType[toupper(gensub(/00\/|.lnh/,"","g",$1))]=$i
				}
			}
			else if ($1 ~ /\/port/)
			{
				boardType[gensub(/_dev_/,"d",1,gensub(/00\/port_/,"p",1,$1))]="RU"
			}
			else
			{
				boardType[gensub(/00$/,"",1,$1)]=$2
				if ($2 ~ /^GPB/ && rnc==1)
				{
					if ($3 ~ /^[0-9]+$/)
					{
						#001400  GPB53             1       GPB_Module            aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod1 modact modms modpdr mp sctpmp
						#001400  GPB53             1  (0)  GPB_Module            aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod1 modact modms modpdr mp sctpmp
						#001100  GPB             110       MS-11-0    GPB_Module            aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod110 modact modms mp sctpmp
						#000600  GPB75          1061  (0)  MS-6-1     GPB_Module            aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod1061 mod1062 modact modms mp
						tpos=4
						if ($(tpos) ~ /^\([0-9]*\)$/) tpos++
						if ($(tpos) ~ /^[ME]S/) tpos++
						boardType[gensub(/00$/,"",1,$1)]=$(tpos)
					}
					else if ($3 ~ /^GPB_Central/) boardType[gensub(/00$/,"",1,$1)]="GPB_Central"
					else if ($3 ~ /^GPB_RANAP/) boardType[gensub(/00$/,"",1,$1)]="GPB_RANAP"
					else if ($3 ~ /^GPB_SCCP/) boardType[gensub(/00$/,"",1,$1)]="GPB_SCCP"
					else boardType[gensub(/00$/,"",1,$1)]=$3
				}
				#print gensub(/00$/,"",1,$1),boardType[gensub(/00$/,"",1,$1)]
			}
		}
	}
	close(file)
}
function parse_mos_log(   timestamp,record,timelist,n,i,count,sep1,sep2,origtimestamp,command,array,offset,newstartdate)
{
	customPrint("")
	if (csvoutput==1) { sep1=sep2=";" }
	else
	{
		sep1=" " ; sep2="\n"
		customPrint("======================================================================================================")
		customPrint(sprintf("%-19s %-5s %-8s %-15s %5s  %s","Timestamp "(inputoptions~"m"?"(UTC)":"(Local)"),"","User","Node","PID","Command"))
		customPrint("======================================================================================================")
	}
	if (startdate == -1E8) startdate=systime()-30*86400
	newstartdate=startdate
	newenddate=enddate+86400
	offset=gensub(/..$/,"",1,strftime("%z"))*3600
	#in case the workstation is in western timezone , as the startdate is in UTC we must substract the number of hours of the timezone to the startdate , otherwise we dont catch the entries that occurred before the UTC
	if (offset<0) newstartdate+=offset
	while ((getline < xml_log)>0)
	{
		gsub("\r","")
		#20091102:225013:eanzmagn:moshelluser:a.b.c.d:20091102-215423_28324:0:0 get loadmodule path /c/java
		command=gensub(/^[^ ]+ +/,"",1,$0)
		if (command ~ /^(#|y$|\/\/)/) continue
		if (command ~ /^@%> YesNo=[yY]/) continue  #do not log "yes" answers
		if (command ~ /Cannot connect to MO service, exiting.../) continue  #To solve Issue when launching AMOS from the topology browser.
		if (command ~ /exiting\.\.\./) gsub(/exiting.../,"exiting ...",command)  #To solve Issue when launching AMOS from the topology browser. TORF-487803
		if (command ~ /^(@%|%@)> /)
		{
			if (command ~ /^(@%|%@)> $/) continue
			record[timestamp]=record[timestamp]" "(command~/^@%> /?gensub(/^@%>/,";",1,command):gensub(/^%@> /," ; Result=",1,command))
			continue
		}
		split($1,array,":")
		origtimestamp=make_timestamp(array[1],array[2])
		timestamp=sprintf("%20.6f",origtimestamp)
		if (origtimestamp >= newstartdate && origtimestamp <= newenddate)
		{
			if (timestamp in timelist) { count[timestamp]+=0.000001 ; timestamp=sprintf("%20.6f",timestamp+=count[timestamp])}
			record[timestamp]=sprintf("%-19s%s%-5s%s%-8s%s%-15s%s%5s %s%s",\
sprintf("%s%s%s",mystrftime("%Y-%m-%d",origtimestamp,(inputoptions~"m"?1:"")),sep1,mystrftime("%H:%M:%S",origtimestamp,(inputoptions~"m"?1:""))),sep1,"MOS",sep1,array[3],sep1,array[5],sep1,gensub(/^.*_/,"",1,array[6]),sep1,command)
			timelist[timestamp]=timestamp
		}
	}
	close(xml_log)
	for (i in record)
	{
		if (record[i] ~ / Result=Fail/)
		{
			#when result fail due to command aborted, there can be several other causes on the same line so we remove them and only keep "command aborted"
			sub(/ Result=Fail .Command aborted.*$/," Result=Fail (Command aborted)",record[i])
			#we mark the failed command by a MOS-F tag
			sub(sprintf("%s%-5s%s",sep1,"MOS",sep1),sprintf("%s%-5s%s",sep1,"MOS-F",sep1),record[i])
		}
	}
	n=asort(timelist)
	if (reverse_sort==0)
	{
		for (i=1;i<=n;i++) customPrint(record[timelist[i]])
	}
	else
	{
		for (i=n;i>=1;i--) customPrint(record[timelist[i]])
	}
}
function parse_te_log(   timestamp,record,timelist,n,i,count,sep1,sep2,origtimestamp)
{
	customPrint("")
	if (csvoutput==1) { sep1=sep2=";" }
	else
	{
		sep1=" " ; sep2="\n"
		customPrint("======================================================================================================")
		customPrint(sprintf("%-28s %s %s","Timestamp (UTC)","Board","Trace"))
		customPrint("======================================================================================================")
	}
	make_board_table(xml_log)
	while ((getline < xml_log)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		#0000: [2008-12-19 08:06:05.868] Sys_Osa_clkDistr_proc systemclock.c:1594 INFO:RTC panic set
		#0014: [2009-02-28 06:53:59.084] RncLmUePT(NBAP_ASN) RlibInsNbapProtocol.cc:196 BUS SEND:NBAP PDU ENCODED, ueRef = 502, length = 31
		#0014: 0000  00 18 46 27 7A 19 00 00 03 00 8F 00 02 00 00 00   '..F'z...........'
		#0014: 0010  2C 00 02 00 36 00 D5 80 06 00 00 CE 80 01 02      ',...6..........'
		#gcpu04: [1970-01-01 00:00:03.244] LPP_TRACE_BIN -:0 INFO
		#gcpu04: 0000  01 40 00 01 02 0E 00 67 00 23 00 03 20 00 03 6D   '.@.....g.#.. ..m'
		#BXP_3_1: [1970-01-01 00:02:12.860] - /vobs/rbs/hw/re/sw/app/hal/cpri/src/cpriCtrlProc.cc:74 INFO:RICR link status ind for link 0
		#BXP_3_1:        hfnSync:         0x01
		#BXP_3_1:        linkOperational: 0x00
		#BXP_3_1:        syncBit:         0x00
		#0023SP4: [2009-02-27 08:13:02.406] DedicatedChMainPT ../src/DcsSchC.cpp:1228 INFO:Signal DRHIFDHBP_CONFIG_SP_RESTART_RSP received with spRestartResult=0
		#0012p10d13: [2009-02-19 14:35:40.756] ccie ccie.cc:5803 INFO:yellow LED set to IDLE
		if ($1 !~ /^[^:]+:$/ || $0 ~ /^[^: ]+: The Trace & Error Log is empty/) continue
		if ($2 ~ /^\[[0-9]+-[0-9]+-[0-9]+$/ && $3~/\]$/)
		{
			sub(/\[/,"",$2) ; sub(/\]/,"",$3)
			origtimestamp=mymktime(sprintf("%s %s",gensub("-"," ","g",$2),gensub(/:|\.[0-9]+$/," ","g",$3)))+0
			timestamp=sprintf("%20.6f",origtimestamp+gensub(/^.*\./,"",1,$3)/1000+10000) #+10000 is to make the value always positive because 1970-01-01=-3600
			if (origtimestamp >= startdate && origtimestamp <= enddate)
			{
				if (timestamp in timelist) { count[timestamp]+=0.000001 ; timestamp=sprintf("%20.6f",timestamp+=count[timestamp])}
				record[timestamp]=sprintf("%-25s%sTE%s%s%s%s%s%s",gensub(/\[|\]/,"","g",$2 sep1 $3),sep1,sep1,gensub(/:/,"",1,$1),sep1,boardType[gensub(/:/,"",1,$1)],sep1,gensub(/^[^ ]+ [^ ]+ [^ ]+ +/,"",1,$0))
				timelist[timestamp]=timestamp
			}
		}
		else if (origtimestamp >= startdate && origtimestamp <= enddate)
		{
			record[timestamp]=record[timestamp] sep2 gensub(/^[^ ]+ /,"",1,$0)
		}
	}
	close(xml_log)
	n=asort(timelist)
	for (i=1;i<=n;i++) customPrint(record[timelist[i]])
}
function parse_ted_log(   ts,ok,d,t)
{
	ok=0
	startdate+=0
	enddate+=0
	if (csvoutput==1) { sep1=sep2=";" }
	else
	{
		sep1=" " ; sep2="\n"
		customPrint("======================================================================================================")
		customPrint(sprintf("%-28s %s %s","Timestamp (UTC)","Board","Trace"))
		customPrint("======================================================================================================")
	}
	close(xml_log)
	while ((getline < xml_log)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if (NF==0) continue
		if ($1~/^\[/ && $2~/\]$/)
		{
			d=gensub(/^\[/,"",1,$1)
			t=gensub(/(\.[0-9]+)?\]$/,"",1,$2)
			ts=make_timestamp(d,t)+0
		}
		if (startdate!="" && ts<startdate) continue
		if (enddate!="" && ts>enddate) continue
		sub(/^\[/,"",$1);sub(/\]$/,"  TED",$2)
		customPrint($0)
	}
	close(xml_log)
}
function save_llog_entry()
{
	if (!("board" in llogT)) return
	if (llogT["origtimestamp"] >= startdate && llogT["origtimestamp"] <= enddate)
	{
		#for (i in llogT) print i" "llogT[i]
		#print "\n\n------------------------------\n\n"
		record[llogT["origtimestamp"],llogT["board"],llogT["number"]]=sprintf("%s%s%s%s%s%s%s%s%s%s",llogT["time"],\
(lgg_showno==1 && "No:" in llogT && llogT["No:"]!=""?llogT["No:"]". ":""),\
(llogT["restartType"]~"Program"?"Program restart":"Board restart"("restartRank" in llogT?" rank="llogT["restartRank"]:"")),\
(llogT["osmod"]~"BACKUP"?" (OS in Backup mode)":""),\
("pmd" in llogT?" PMD="llogT["pmd"]:""),\
("process" in llogT?" Proc="llogT["process"]("file" in llogT?" ("llogT["file"]")":""):""),\
("code" in llogT?" "llogT["code"]:""),\
("desc" in llogT?" "llogT["desc"]:""),\
("info" in llogT?". "llogT["info"]:""),\
("linuxboard" in llogT?". "llogT["linuxboard"]:""))
		if (!(llogT["board"] in bdlist))
		{
			bList[++nrBoards]=llogT["board"]
			bdlist[llogT["board"]]=llogT["board"]
		}
		if (!(llogT["number"] in numberlist))
		{
			nList[++nrNumbers]=llogT["number"]
			numberlist[llogT["number"]]=llogT["number"]
		}
		tList[llogT["origtimestamp"]]=llogT["origtimestamp"]
	}
	delete llogT
}
function compress_llog_log(tfile,   a,lgg_opt)
{
	if (lgg_compress==0) return tfile
	split(lgg_intervals,a,",")
	a[1]+=0 ; a[2]+=0 ; a[3]+=0
	lgg_opt=""
	if (a[1]>0) lgg_opt=sprintf(" -vint_crash=%d",a[1])
	if (a[2]>0) lgg_opt=sprintf("%s -vint_reg=%d",lgg_opt,a[2])
	if (a[3]>0) lgg_opt=sprintf("%s -vint_prog=%d",lgg_opt,a[3])
	if (lgg_compress==1) lgg_opt=sprintf("%s -vfix_2000=1",lgg_opt)  #use a different value like 2 in order to not have the option fix_2000
	#print sprintf("%s %s -f %s/parse_llog.awk %s > %s.1",gawk,lgg_opt,commonjardir,tfile,tfile)
	if (mosdebug==1) print sprintf("%s %s -f %s/parse_llog.awk",gawk,lgg_opt,commonjardir) > "/dev/stderr"
	system(sprintf("%s %s -f %s/parse_llog.awk %s > %s.1",gawk,lgg_opt,commonjardir,tfile,tfile))
	system("sleep 1")
	return tfile".1"
}
function parse_llog_log(  lloglog,s)
{
	customPrint("")
	if (csvoutput==1) { sep1=sep2=";" }
	else
	{
		sep1=" " ; sep2="\n"
		customPrint("======================================================================================================")
		customPrint(sprintf("%-24s  %-16s %s","Timestamp (UTC)","Board","Restart"))
		customPrint("======================================================================================================")
	}

#Date;Time;Scope;lnh;PiuType;pmd File;Process;Error Description;Error Code;Actor/ExtraData;Srr0;Message;State;SwLevel;TR/CSR
#2009-04-27;20:52:27;MP;001000;CoreMp;20090427_205656_360_001000_0xe1b2ae36.pmd;TargetMonitorProc;Pool extension failed.;0x80000021;0x00000020;;;;CXP9013831_R9HA;

#0107:  6.    Time           :  09-06-28, 05:21:14
#0012p0d15:  6.    Time           :  2009-06-25, 14:16:04
#Restart type: Processor , Program
#Restart rank: Application, Cold, Cold with test, Refresh, Warm
#OS Run Mode: BACKUP , BASIC
#Process :
#File:line      :  osa_board_mgr.c:3194
#PMD identity   :  0x00000884   , -
#Error code|Restart code
#  0xB0AD0006 (User error)
#  0x83210007 (Reported via CELLO:ERI IF)  --> eri_api
#  0x87000113 (Reported by OSE Kernel)     --> kernel
#  0x00000020 (Reported via the OSE error API) --> ose_api
#             (Ordered restart)
#Error Description  :       [OSE_HEAP_EPTR_INVALID]
#Error Description  :       OSE_EUSED_NIL_POINTER
#Error Information|Restart Information --> several lines
#0x0000: 01 00 00 00 00 02 42 6F    "......Bo"
#0x0008: 61 72 64 20 6D 61 6E 61    "ard mana"
#0x0010: 67 65 72 20 72 65 73 74    "ger rest"
#0x0000: 00 0C 15 01 00 00 00 01    "........"
#        Error code 0x83000113 was encountered
#        while an error handler was executing.

	make_board_table(xml_log)
	lloglog=compress_llog_log(xml_log)
	while ((getline < lloglog)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if ($1 !~ /^[^:]+:$/)
		{
			ininfo=0
			save_llog_entry()
			continue
		}
		curboard=gensub(/:/,"",1,$1)
		sub($1,"")
		if ($1 ~ /^-+$/) { ininfo=0 ; continue }
		if (NF==2 && $1=="No:" && (($2~/^[0-9]+$/) || ($2~/^[0-9,]+$/ && lgg_compress==1)))
		{
			save_llog_entry()
			currNo=$2
			if ($2~/^[0-9,]+$/ && lgg_compress==1) currNo=gensub(/,.*$/,"",1,$2)+0
			linuxboard=1
		}
		if (NF==3 && $1=="Time:")
		{
			#Convert the Time line of linux boards (DUSG2, XMU03, EPB2) to look like RU/MP/BP:
			#Linux:
			#No: 2
			#Time:     2015-08-28 14:57:21
			#RU:      4.    Time           :  2015-08-24, 15:08:47
			#MP/BP:   1.    Time           :  70-01-01, 00:00:00
			$0=currNo".  Time   :  "$2", "$3
		}

		if ($2=="Time")
		{
			ininfo=0
			if (linuxboard!=1) save_llog_entry()
			linuxboard=0
			sub(/,$/,"",$4)
			if ($4 ~ /^70-/) $4="19"$4 ; else if ($4 ~ /^..-/) $4="20"$4
			llogT["origtimestamp"]=mymktime(sprintf("%s %s",gensub("-"," ","g",$4),gensub(/:/," ","g",$5)))+0
			llogT["number"]=gensub(/\.$/,"",1,$1)+0
			llogT["board"]=curboard
			llogT["time"]=sprintf("%-24s%s%-16s%s",$4 sep1 $5 sep1 "LLOG ",sep1,curboard sep1 boardType[curboard],sep1)
		}
		else if (/Restart type *:/) llogT["restartType"]=$NF
		else if (/Restart rank *:/) llogT["restartRank"]=gensub(/^.*Restart rank *: *| /,"","g",$0)
		else if (/OS Run Mode *:/)  llogT["osmod"]=$NF
		else if (/Process *:/)      llogT["process"]=gensub(/^[^:]+:| /,"","g",$0)
		else if (/File:line *:/)    llogT["file"]=$NF
		else if (/PMD identity *:/)
		{
			if ($NF != "-") llogT["pmd"]=$NF
		}
		else if (/(Error|Restart) code *:/)
		{
			llogT["code"]=gensub(/^\(/,"",1,$4)
			if (/CELLO:ERI/) llogT["orig"]="eri_api" ; else if (/OSE error API/) llogT["orig"]="ose_api" ; else if (/OSE Kernel/) llogT["orig"]="kernel"
			if (llogT["code"] ~ "Ordered") llogT["code"]="Ordered"
			else llogT["code"]="Err="llogT["code"]("orig" in llogT?" ("llogT["orig"]")":"")
		}
		else if (/Error Description *:/) llogT["desc"]=gensub(/\[|\]/,"","g",$NF)
		else if (/(Error|Restart) Information *:/) { ininfo=1 ; continue }
		#Linux board (DUSG2, XMU03, EPB2)
		#No:       2
		#Reason:   Program Crash
		#Time:     2015-08-28 14:57:21
		#Program:  /usr/sbin/rhd-cprid -n -p 15
		#Pid:      700
		#Rank:     warm
		#Signal:   SIGILL
		#PMD:      pmd-rhd-cprid-700-20150828-145721
		#Extra:    -
		else if ($1~/^(Reason|Program|Rank|Signal|PMD|Extra):$/)
		{
			#if ($1=="Reason:" && llogT["xmu03"] ~ /Reason: /) continue   #otherwise it will append the Reason field of the next restart
			if ($1=="Rank:" && $2~/^(-|Program)$/) llogT["restartType"]="Program"
			if (NF==2 && $2=="-") continue
			llogT["linuxboard"]=llogT["linuxboard"]". "gensub(/ +/," ","g",gensub(/^ +| +$/,"","g",$0))
			sub(/^\. +/,"",llogT["linuxboard"])
		}
		else if (lgg_showno==1 && $1=="No:")
		{
			#llogT["No:"]=gensub(/ +/," ","g",gensub(/^ +| +$/,"","g",$0))
			s=" "
			if ($2~/^[1-9](,|$)/) s="    "
			else if ($2~/^[1-9][0-9](,|$)/) s="   "
			else if ($2~/^[1-9][0-9][0-9](,|$)/) s="  "
			else if ($2~/^[1-9][0-9][0-9][0-9](,|$)/) s=" "
			llogT["No:"]=sprintf("No:%s%s",s,$2)
		}
		if (ininfo==1)
		{
			gsub(/^ *| *$/,"")
			if (/^0x[^:]+:.*"/) { gsub(/^[^"]+"|"[^"]*$/,"") ; gsub(/\./,"") ; llogT["info"]=llogT["info"] $0}
			else llogT["info"]=llogT["info"]" "$0
			sub(/^ +/,"",llogT["info"])
		}
	}
	close(lloglog)
	n=asort(tList)
	for (i=1;i<=n;i++)
	{
		#print "T: "i" "tList[i]
		for (j=1;j<=nrBoards;j++)
		{
			#print "B: "j" "bList[j]
			for (k=1;k<=nrNumbers;k++)
			{
				if ((tList[i],bList[j],nList[k]) in record) customPrint(record[tList[i],bList[j],nList[k]])
			}
		}
	}
}
function save_pmd_entry(    errcode,errdesc,errnr,tsep)
{
	if (!("board" in pmdT)) return
	if ("timeReference" in llogT && llogT["timeReference"] != pmdT["timeReference"]) delete llogT
	if ("code" in llogT && gensub(/ .*$/,"",1,llogT["code"]) != gensub(/ .*$/,"",1,pmdT["code"]) && pmdT["code"]!="")
	{
		#print "here: "llogT["code"],pmdT["code"]
		delete llogT
	}
	if (csvoutput==1) tsep=" " ; else tsep=" "
	if (pmdT["timestamp"] >= startdate && pmdT["timestamp"] <= enddate)
	{
		#for (i in pmdT) print i" "pmdT[i]
		#print "\n\n------------------------------\n\n"
		errdesc=errcode=errnr=""
		if ("code" in llogT) errcode=llogT["code"] ; else errcode=pmdT["code"]
		errnr=sprintf("%d",strtonum(gensub(/Err=| .*$/,"","g",errcode)))
		if (errnr in errToText && errToText[errnr]!="") errdesc=tsep "Desc="errToText[errnr]
		record[pmdT["timestamp"],pmdT["board"],pmdT["number"]]=sprintf("%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",pmdT["time"],\
(llogT["restartType"]~"Program"?"Program restart":(pmdT["board"]~"SP"?"SPM restart":(pmdT["board"]~"D0"?"PiuDev restart":"Board restart"("restartRank" in llogT?" rank="llogT["restartRank"]:"")))),\
(llogT["osmod"]~"BACKUP"?" (OS in Backup mode)":""),\
("core" in pmdT?tsep pmdT["core"]:""),\
("process" in pmdT?tsep"Proc="pmdT["process"]("file" in llogT?" ("llogT["file"]")":""):""),\
("block" in pmdT?tsep"Block="pmdT["block"](gensub(/_.*$/,"",1,pmdT["block"]) in lmidLookupTable?" ("lmidLookupTable[gensub(/_.*$/,"",1,pmdT["block"])]")":""):""),\
("code" in llogT?tsep llogT["code"]:tsep pmdT["code"]),\
("desc" in llogT?tsep "Desc="llogT["desc"]:errdesc),\
tsep "PMD="pmdT["pmdfile"],\
("PC" in pmdT?tsep pmdT["PC"]:""),\
("SRR0" in pmdT?tsep pmdT["SRR0"]:""),\
("controller" in pmdT?tsep pmdT["controller"]:""),\
("capsule" in pmdT?tsep pmdT["capsule"]:""),\
("message" in pmdT?tsep pmdT["message"]:""),\
("state" in pmdT?tsep pmdT["state"]:""),\
("info" in llogT?tsep "Info="llogT["info"]:""),\
(csvoutput==1&&"appinfo" in pmdT?tsep "AppInfo="pmdT["appinfo"]:""))
		if (!(pmdT["board"] in bdlist))
		{
			bList[++nrBoards]=pmdT["board"]
			bdlist[pmdT["board"]]=pmdT["board"]
		}
		if (!(pmdT["number"] in numberlist))
		{
			nList[++nrNumbers]=pmdT["number"]
			numberlist[pmdT["number"]]=pmdT["number"]
		}
		tList[pmdT["timestamp"]]=pmdT["timestamp"]
	}
	delete pmdT
	delete llogT
}
function save_rupmd_entry(    errcode,errdesc,errnr,tsep)
{
	if (!("board" in rupmdT)) return
	if (csvoutput==1) tsep=" " ; else tsep=" "
	if (rupmdT["timestamp"] >= startdate && rupmdT["timestamp"] <= enddate)
	{
		#for (i in rupmdT) print i" "rupmdT[i]
		#print "\n\n------------------------------\n\n"
		errcode=rupmdT["code"]
		errnr=sprintf("%d",strtonum(gensub(/Err=| .*$/,"","g",errcode)))
		if (errnr in errToText && errToText[errnr]!="") errdesc=tsep "Desc="errToText[errnr]
		record[rupmdT["timestamp"],rupmdT["board"],rupmdT["number"]]=sprintf("%s%s%s%s%s%s%s%s",\
rupmdT["time"],"Board restart",rupmdT["processname"],rupmdT["code"],rupmdT["extra"],rupmdT["lm"],rupmdT["lmc"],rupmdT["file"])
		if (!(rupmdT["board"] in bdlist))
		{
			bList[++nrBoards]=rupmdT["board"]
			bdlist[rupmdT["board"]]=rupmdT["board"]
		}
		if (!(rupmdT["number"] in numberlist))
		{
			nList[++nrNumbers]=rupmdT["number"]
			numberlist[rupmdT["number"]]=rupmdT["number"]
		}
		tList[rupmdT["timestamp"]]=rupmdT["timestamp"]
	}
	delete rupmdT
}
function save_error_entry()
{
	if (!("board" in errT)) return
	if (errT["timestamp"] >= startdate && errT["timestamp"] <= enddate)
	{
		gsub(/^ *| *$/,"",errT["info"])
		gsub(/^ *| *$/,"",errT["lm"])
		if (errT["lm"] != "") errT["lm"]="LM="errT["lm"]" "
		#for (i in errT) print i" "errT[i]
		#print "\n\n------------------------------\n\n"
		record[errT["timestamp"],errT["board"],errT["number"]]=sprintf("%s%sFile=%s %s",errT["time"],errT["lm"],errT["errfile"],errT["info"])
		if (!(errT["board"] in bdlist))
		{
			bList[++nrBoards]=errT["board"]
			bdlist[errT["board"]]=errT["board"]
		}
		if (!(errT["number"] in numberlist))
		{
			nList[++nrNumbers]=errT["number"]
			numberlist[errT["number"]]=errT["number"]
		}
		tList[errT["timestamp"]]=errT["timestamp"]
	}
	delete errT
}
function save_mgw_entry()
{
	if (!("board" in mgwT)) return
	if (mgwT["timestamp"] >= startdate && mgwT["timestamp"] <= enddate)
	{
		while ((mgwT["timestamp"],mgwT["board"],mgwT["number"]) in record) mgwT["number"]++

		record[mgwT["timestamp"],mgwT["board"],mgwT["number"]]=sprintf("%s%s%s%s%s%s%s%s",gensub(/ $/,"",1,mgwT["time"]),mgwT["rtype"],mgwT["rank"],mgwT["sig"],mgwT["proc"],mgwT["dsp"],mgwT["file"],mgwT["extra"])
		if (!(mgwT["board"] in bdlist))
		{
			bList[++nrBoards]=mgwT["board"]
			bdlist[mgwT["board"]]=mgwT["board"]
		}
		if (!(mgwT["number"] in numberlist))
		{
			nList[++nrNumbers]=mgwT["number"]
			numberlist[mgwT["number"]]=mgwT["number"]
		}
		tList[mgwT["timestamp"]]=mgwT["timestamp"]
	}
	delete mgwT
}
function save_faultlog_entry()
{
	#2012-10-27 12:17:29 PMD   0001 DUL21       Program restart Proc=nc_main_thread (ncEriFacade.cc:95) Block=CXC1732768%7_R22E (rbsNcLm) Err=0xF0F0F0F2 (eri_api) PMD=20121027_121754_c_pmd_50_000100_0x2e86887f.pmd PC=008135A8 SRR0=0081B14C. Recovery action for: faultId:0x204 faultDescription:Contact lost with resource object
	#2012-10-27 12:16:30 FAULT 0001 ULMA[00512] bbbase_trses_fatalerror_ovl.c:364: Timeout in RERC transaction for signal 345.Element (null) is n File=000100!/d/systemfiles/FAULTLOG08_121027_121630.log
	if (!("board" in fauT)) return
	if (fauT["timestamp"] >= startdate && fauT["timestamp"] <= enddate)
	{
		record[fauT["timestamp"],fauT["board"],fauT["number"]]=sprintf("%s%s File=%s",fauT["time"],fauT["info"],fauT["faultfile"])
		if (!(fauT["board"] in bdlist))
		{
			bList[++nrBoards]=fauT["board"]
			bdlist[fauT["board"]]=fauT["board"]
		}
		if (!(fauT["number"] in numberlist))
		{
			nList[++nrNumbers]=fauT["number"]
			numberlist[fauT["number"]]=fauT["number"]
		}
		tList[fauT["timestamp"]]=fauT["timestamp"]
	}
	delete fauT
}
function optionalDisplay(table,Index,header,  res)
{
	res=""
	if (Index in table) res=" "(header!=""?header:Index)"="table[Index]
	return res
}
function save_ecdalog_entry()
{
	#DSP SNID            : 6400
	#LM Product Number   : CXC1726399/3
	#LM Product Revision : R8E
	#Date and time       : 110105 141006
	#TraceID   : 3
	#ErrorCode : 0x0010
	#AddInfo   : 0x0000
	#Filename  : /vobs/rbs/bb/dp/subsystems/QuickStop/src/QuickStopReceiver.cpp
	#Line      : 137
	#Message   : Quick stop request received. Entering Fatal Error mode. Source = Faraday12
	#1. Error Messages
	#=================
	#No error detected.
	#Fatal Error       : Yes
	#Error Code Number : 0x00000162 (User Error.)
	#Error Function    : 0x00000000 (User defined extra information.)
	#Current Pid       : 0000000e (SystemTime)
	#Caller            : USER
	if (!("board" in ecdT)) return
	if (ecdT["timestamp"] >= startdate && ecdT["timestamp"] <= enddate)
	{
		#for (i in ecdT) print i" "ecdT[i]
		#print "\n\n------------------------------\n\n"
		if ("LMProductNumber" in ecdT)
		{
			ecdT["lm"]=ecdT["LMProductNumber"]
			if ("LMProductRevision" in ecdT) ecdT["lm"]=ecdT["lm"]"_"ecdT["LMProductRevision"]
			ecdT["lm"]=ecdT["lm"](ecdT["LMProductNumber"] in lmidLookupTable?" ("lmidLookupTable[ecdT["LMProductNumber"]]")":"")
		}
		if ("Filename" in ecdT)
		{
			ecdT["src"]=ecdT["Filename"]
			if ("Line" in ecdT) ecdT["src"]=ecdT["src"]":"ecdT["Line"]
		}
		record[ecdT["timestamp"],ecdT["board"],ecdT["number"]]=sprintf("%s%s%s%s%s%s%s%s%s%s%s%s File=%s%s",ecdT["time"],\
optionalDisplay(ecdT,"lm","LM"),optionalDisplay(ecdT,"DSPSNID","DSP_SNID"),optionalDisplay(ecdT,"TraceID"),optionalDisplay(ecdT,"ErrorCode"),\
optionalDisplay(ecdT,"AddInfo"),optionalDisplay(ecdT,"src","Src"),\
optionalDisplay(ecdT,"FatalError"),optionalDisplay(ecdT,"ErrorCodeNumber"),optionalDisplay(ecdT,"ErrorFunction"),\
optionalDisplay(ecdT,"CurrentPid"),optionalDisplay(ecdT,"Caller"),ecdT["ecdafile"],optionalDisplay(ecdT,"Message"))
		if (!(ecdT["board"] in bdlist))
		{
			bList[++nrBoards]=ecdT["board"]
			bdlist[ecdT["board"]]=ecdT["board"]
		}
		if (!(ecdT["number"] in numberlist))
		{
			nList[++nrNumbers]=ecdT["number"]
			numberlist[ecdT["number"]]=ecdT["number"]
		}
		tList[ecdT["timestamp"]]=ecdT["timestamp"]
	}
	delete ecdT
}
function buildOseTable(filter,  tcode,osefile)
{
	osefile=commonjardir"/ose_err.h"
	if (fileOps("test -s "osefile)!=0)
	{
		customPrint("ERROR: file "osefile" not found.")
		return
	}
	while ((getline < osefile)>0)
	{
		#define ERRCMD_NO_PARAM            ((char *) 0x0000000)   /* There is no extra parameters               */
		##define OSE_EERROR_MASK                 (0x0000ffff)

		#makes the lines like:

		#0x006f0006      OSE_RES_ENOT_INITIALIZED
		#0x00660000      OSE_UDPPDR_EBASE
		#OSE_UDPPDR_EBASE | 0x0000 OSE_UDPPDR_ESOCKET_FAILED
		#OSE_EFATAL_MASK | 0x00610000 OSE_OTL_EBASE
		#OSE_OTL_EBASE 0 OSE_OTL_EMAX_SIG_SIZE
		#OSE_EFATAL_MASK OSE_OSL_EBASE 0x1000 OSE_OSL_EINTERNAL_ERROR

		gsub("\r","")
		if ($0 ~ "&" || NF<3 || $0 ~ /ERRCMD_END/ || $1 != "#define") continue
		sub(/\([a-z][^)]+\)/,"")
		sub(/\/.*$/,"")
		gsub(/[+|)(]/,"")
		sub(/#define[ \t]+/,"")
		$0=sprintf("%-15s %s",gensub(/^[^ \t]+[ \t]+|[ \t]+$/,"","g",$0),$1)
		#if (mosdebug==1) print
		if ($1 ~ /^0x/) $1=sprintf("%d",strtonum($1))
		if (NF==2 && $1 ~ /^[0-9]+$/ && $2 ~ /^[A-Z]/)
		{
			tcode=$1
			if (tcode in errToText && errToText[tcode]!=$2) dupTable[tcode]=dupTable[tcode]" "errToText[tcode]" "$2
			errToText[tcode]=$2 ; textToErr[$2]=tcode
		}
		else if (NF >= 3)
		{
			tcode=0
			for (i=1;i<=(NF-1);i++)
			{
				if ($i in textToErr && textToErr[$i]!="") tcode+=textToErr[$i]
				else if ($i ~ /^0x/) tcode+=sprintf("%d",strtonum($i))
				else tcode+=$i
			}
			errToText[tcode]=$NF
			textToErr[$NF]=tcode
		}
		#if (mosdebug==1 && filter=="") printf("%-10d  %s\n",tcode,errToText[tcode])
		#printf("%-4d  %s   %s\n",tcode,errToText[tcode],$0)
	}
	close(osefile)
	if (filter=="") return
	#Used for debug only, from command line, type errose <filter>
	#or:
	#gawk -l tools/moshell/commonjars/lib/cygwin/filefuncs.dll -vcommonjardir=tools/moshell/commonjars -f tools/moshell/funcs.awk -f tools/moshell/extern.awk --source 'BEGIN{buildOseTable(".*")}'
	if (filter ~ /^[0-9]+$/) print errToText[filter]
	else if (filter in textToErr) print textToErr[filter]
	else if (filter=="dup")
	{
		printf("%-10s  %-34s  %s\n","Code","Main Translation"," Other translations")
		for (i in dupTable) printf("%-10d  %-34s  %s\n",i,errToText[i],gensub(/ +/," ","g",gensub(errToText[i],"","g",dupTable[i])))
	}
	else if (filter==".*")
	{
		for (i in errToText) printf("%-10d 0x%X %s\n", i,i,errToText[i])
	}
}
function parse_pmdzpm_log(   rsep,bDev,msep,array,a,b,arr,ruok,arry,z,k)
{
	buildLmidTable()
	buildOseTable()
	customPrint("")
	if (csvoutput==1) { sep1=sep2=";" }
	else
	{
		sep1=" " ; sep2="\n"
		customPrint("======================================================================================================")
		customPrint(sprintf("%-24s  %-16s %s","Timestamp (UTC)","Board","Info"))
		customPrint("======================================================================================================")
	}

#Date;Time;Scope;lnh;PiuType;pmd File;Process;Error Description;Error Code;Actor/ExtraData;Srr0;Message;State;SwLevel;TR/CSR
#2009-04-27;20:52:27;MP;001000;CoreMp;20090427_205656_360_001000_0xe1b2ae36.pmd;TargetMonitorProc;Pool extension failed.;0x80000021;0x00000020;;;;CXP9013831_R9HA;

#Parsing PMD file: /net/rncweb/export/share4/RNC/LOG_SERVER/rnciov/PV/eanzmagn/logs_moshell/pmdfiles/a.b.c.d/pmd/20090509_083442_c_pmd_116_001000_0x2db6faa0.pmd
#[POST MORTEM DUMP]
#  user called :  0
#  error code  :  0x00020113
#  extra       :  0x081cc1e8
#  curr_proc   :  0x001005b2
#[USER REPORTED ERROR DATA]  (used in case the ERROR LOG part is missing)
#
#  Error type:              HW Error
#  String:                  Recovery action, faultId: 0x301 (SwError), faultDescription: ULMA[01024]:dlmacce_transportformatselection.c:604: DBC Assert failure: sele
#  File:                    bpai_basic_if.c
#  Line:                    184
#[CXC1727645%1_P4AL11-TSL INFORMATION]
#  General actor info (last active capsule)
#  controller = RncLmUePT
#  capsule = RlibInsRanapTerminatorC
#  capsule role = rlibInsRanapTerminatorC[0]
#  message = rlibInsRanapDecodedP%ranapIuReleaseReq
#  state = /TOP
#[ERROR CODE]
#  PMD-id: 0x2db6faa0    Board location: 001000
#  PMD-id: 0x2db6faa0    Board location: d00001
#  Time: 09-05-09  08:34:36
#  ERROR NUMBER 0x00820105 WITH EXTRA DATA 0x3C452AC0 WAS REPORTED BY
#  PROCESS tm
#  TYPE PRI-31
#  BLOCK   CXC1326054_R51SZ01
#[ERROR LOG]
#----------------------------------------------------------------------------
# 7.    Time           :  09-05-09, 08:34:36
#       Error code     :  0x00820105 (Reported via the OSE error API)
#       File:line      :  heap.c:1480
#       Process        :  tm
#       Queued signals :  0
#       Owned signals  :  3
#       Restart type   :  Program
#       OS Run Mode    :  BASIC
#       PMD identity   :  0x2db6faa0
#       Restart rank   :  Application
#       OSE Component  :  HEAP
#       Error Description  :       [OSE_HEAP_EHEAP_EXHAUSTED]
#       Heap exhausted and could not be properly extended.
#       Owner process identity    : 0x45430a41
#Ignore this part !!!
#[ERROR ANALYZE STACK]
#
# 004086C8: eeeeeeee eeeeeeee eeeeeeee eeeeeeee   "................"
# 004086D8: eeeeeeee eeeeeeee eeeeeeee eeeeeeee   "................"
# 004086E8: eeeeeeee eeeeeeee eeeeeeee eeeeeeee   "................"

#Also ignore this part , comes after ERROR LOG:
#[HARD DISK ERROR LOG]
#  Len:1 head:1
#  (  0) 0000000212.0170:    START - 0x00000000, 0x00000000

#Parsing FAULTLOG file: 000100!/d/systemfiles/FAULTLOG02_120801_145258.log 2012-08-01 14:52:58 ULMA[00768]:pap_xio_dliqb_cproc.c:426: DBC Assert failure: xioPortMapping.valid == 1
#Parsing FAULTLOG file: /c/logfiles/dspdumps/00_01/FAULTLOG02_120801_145258.log 2012-08-18 02:26:30 Lost Connection with DSPs on ULMA[00256]


#Parsing ECDA file: /home/eanzmagn/moshell_logfiles/logs_moshell/pmdfiles/a.b.c.d/dspdumps/20110105_141009_00_01_ECDAdump6400-11.gz

#Parsing RUPMD file: /home/eanzmagn/moshell_logfiles/logs_moshell/pmdfiles/a.b.c.d/pmd/20131225_070731_0x1_0001BXP_0_1.txt.gz
#Parsing RUPMD file: /home/eanzmagn/moshell_logfiles/logs_moshell/pmdfiles/a.b.c.d/pmd/20170119_190127_pmd-cmd_proc-916-20170119-190127_0001BXP_0.tar.gz


	make_board_table(xml_log)
	while ((getline < xml_log)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		#print ininfo,$0
		if (/^Parsing RUPMD file: /)
		{
			save_entry_and_reset()
			inrupmd=1
			#inecda=inerr=0
			#save_rupmd_entry()
			if (csvoutput==1) rsep=" " ; else rsep=" "
			rupmdT["pmdfile"]=gensub(/^.*\//,"",1,$NF)
			rupmdT["file"]=rsep"File="rupmdT["pmdfile"]
			last=split(rupmdT["pmdfile"],array,"_")
			ruok=0
			for (i=4;i<=last;i++)
			{
				if (array[i]~"BXP") ruok=1
				if (ruok==1) rupmdT["board"]=rupmdT["board"]"_"array[i]
			}
			ruok=0
			gsub(/^_|.txt.gz$|.tar.gz$/,"",rupmdT["board"])
			rupmdT["number"]=sprintf("%d",strtonum(array[3]))
			rupmdT["timestamp"]=make_timestamp(array[1],array[2])
			split(array[1],a,"") ; split(array[2],b,"")
			rupmdT["filetime"]=sprintf("%s%s%s%s-%s%s-%s%s%s%s%s:%s%s:%s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],sep1,b[1],b[2],b[3],b[4],b[5],b[6])
			rupmdT["time"]=sprintf("%-24s%s%-16s%s",rupmdT["filetime"] sep1 "RUPMD",sep1,rupmdT["board"] sep1 boardType[rupmdT["board"]],sep1)
		}
		else if (/^Parsing (MGWDSP|MGWVPP|LinuxPMD) file: /)
		{
			if (csvoutput==1) msep=" " ; else msep=" "
			#Parsing MGWDSP file: 20121118_175239_73-19-65-9-last
			#Parsing MGWDSP file: 20121118_175258_73-19-65-9-last.ext
			#2012-05-23 12:59:52 DSP   7313 MSB3        File=20121118_175258_73-19-65-9-last
			#Parsing MGWVPP file: 20140217_145011_bgfdump-00-16-00-date2014-02-17-14-50-11
			#Parsing LinuxPMD file: /home/eanzmagn/moshell_logfiles/logs_moshell/pmdfiles/a.b.c.d/pmd/20151020_122914_c_pmd_1_000300_pmd-Cs_lighttp_proc-2026-20151020-122900.tgz
			#Parsing LinuxPMD file: 19700101_003528_c_pmd_20_001201_pmd-t25b_fw_upg-1116-19700103-174737.tgz Jan  3 17:47:37 1970 oamhost local0.err elog: $  Restart request  $ 1970-01-03 17:47:37 $ /usr/imagestore//CXC1739213_P94A001/bin/t25b-loader-upg-epb2-fw  $ 1116 $ Warm $ SIGABRT $ pmd-t25b_fw_upg-1116-19700103-174737 $  Type 2.5 B upgrade failed. /repo/cpp.sub.1/control/BABS_CRX901142_1/epb2_lx_bl/epb2_type_25b_fw_upg_swu/src/fw_upg.c:535
			#Parsing LinuxPMD file: 20161004_193227_c_pmd_53_000401_pmd-bmImgMgr-3262-20161004-192341.tgz Oct  4 19:23:41 2016 oamhost local0.err elog: $  Restart request  $ 2016-10-04 19:23:41 $ bos-epb2-mp-dp-lm  $ 3262 $ Cold $ SIGABRT $ pmd-bmImgMgr-3262-20161004-192341 $  Failed to delete /repo/enavnal/cpp/control/BCS_CRX901143_1/board-manager_bl/board-manager_lx_swu/src/util/board_mgr_util.c:588
			#Parsing LinuxPMD file: pmd-Nci_control_pro-6470-20161016-174406.tgz 2016-10-16T17:44:06.153834+00:00 axm5516 llogger: rlog: elog: $ Restart request $ 2016-10-16 17:44:06 $ /home/sirpa/software/RICM_CXP9028836_5_R2GL/bin/ricm  $ 6470 $ Cold $ SIGABRT $ pmd-Nci_control_pro-6470-20161016-174406 $  Recovery action initiated by DU via BCI, faultId: 0x300 (HwfForEvaluation), faultDescription: Suspected HW fault, escalation ma /repo/catbuilder/RICM_G2.sub.3/CBD_CNH1606395/ric_bl/ricm_cat_swu/control/src/ricm_control_ricm_handler.c:4481
			#Parsing LinuxPMD file: 20170119_190127_pmd-cmd_proc-916-20170119-190127_0001BXP_0.tar.gz Jan 19 18:53:29 xenon elog: $ Ordered restart $ 2017-01-19 18:53:29 $ ngr2.elf $ - $ Cold $ - $ - $ Application ordered restart, faultId: 0x998 (LogicalNameUndefined), faultDescription: Performing internal restart
			if ($4 ~ /\.ext$/) continue #each dsp crash generates two files, we will not show the .ext file
			if ($2=="MGWVPP") mwhat="VPP"
			else if ($2=="MGWDSP") mwhat="DSP"
			else mwhat="LPMD"
			mgwT["number"]=1
			split($4,array,"_")
			if (comcli>0 || cpplinux>0)
			{
				#old cpplinux pmd file : 20180905_140843_c_pmd_33_000300_pmd-Osa_jvmfro_proc-11791-20180903-091345.tar
				#new cpplinux pmd file : 20190327_013006_c_pmd_1_000300_pmd-Osa_EthMauFroFa-2043-20190327-013001-066256.tar
				match($4,/-([1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9])-([0-9][0-9][0-9][0-9][0-9][0-9])(-[0-9][0-9][0-9][0-9][0-9][0-9])?\./,array)
			}
			if (cpplinux>0 && array[1]~/^1970/) split($4,array,"_")
			mgwT["file"]=msep"File="$4
			mgwT["timestamp"]=make_timestamp(array[1],array[2])
			split(array[1],a,"") ; split(array[2],b,"")
			if (cpplinux>0) split($4,array,"_")
			mgwT["filetime"]=sprintf("%s%s%s%s-%s%s-%s%s%s%s%s:%s%s:%s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],sep1,b[1],b[2],b[3],b[4],b[5],b[6])
			if (mwhat=="VPP")
			{
				split(array[3],array,"-")
				mgwT["board"]=sprintf("%02d%02d",array[2],array[3])
			}
			else if (mwhat=="DSP")
			{
				split(array[3],array,"-")
				mgwT["board"]=sprintf("%02d%02d",array[1],array[2])
				mgwT["dsp"]=sprintf("%sDSP=%s-%s",msep,array[3],array[4])
			}
			else if (comcli>0) mgwT["board"]="0001"
			else if (mgwT["file"]~/\.tar.gz$/)
			{
				#XMU03 or NGR G2 radio
				z=split(mgwT["file"],arry,"_")
				ruok=0
				for (k=1;k<=z;k++)
				{
					if (arry[k]~"BXP") ruok=1
					if (ruok==1) mgwT["board"]=mgwT["board"]"_"arry[k]
				}
				sub(/^_/,"",mgwT["board"])
				sub(/\.tar.gz$/,"",mgwT["board"])
				ruok=0
			}
			else
			{
				mgwT["board"]=array[6]
			}
			mgwT["time"]=sprintf("%-24s%s%-16s%s",mgwT["filetime"] sep1 sprintf("%-4s ",mwhat),sep1,mgwT["board"] sep1 boardType[mgwT["board"]],sep1)
			if (mwhat=="LPMD")
			{
				split($0,array,/[$]/)
				for (i in array) gsub(/^[- \t]+|[- \t]+$/,"",array[i])
				if (array[2]!="") mgwT["rtype"]=msep array[2]
				if (array[4]!="") mgwT["proc"]=msep "Proc="array[4]
				if (array[6]!="") mgwT["rank"]=msep "Rank="array[6]
				if (array[7]!="") mgwT["sig"]=msep "Sig="array[7]
				if (array[9]!="") mgwT["extra"]=msep "Extra="array[9]
			}
			save_mgw_entry()
		}
		else if (/^Parsing FAULTLOG file: /)
		{
			fauT["faultfile"]=$4
			if ($4 ~ /^\/c\//) fauT["board"]="0001"
			else fauT["board"]=gensub(/00!.*$/,"",1,$4)
			fauT["number"]=1
			fauT["timestamp"]=make_timestamp($5,$6)
			#in case there is already another entry with the same timestamp, we increase the fauT["number"] field:
			while ((fauT["timestamp"],fauT["board"],fauT["number"]) in record) fauT["number"]++
			fauT["info"]=gensub(/^[^\]]+\]:/,"",1,$0)
			fauT["ulma"]=gensub(/:.*$/,"",1,$7)
			if (fauT["ulma"] !~ /^ULMA\[[0-9]+\]$/)
			{
				fauT["ulma"]=""
				fauT["info"]=gensub(/^Parsing FAULTLOG file: [^ ]+ [^ ]+ [^ ]+ +/,"",1,$0)
			}
			fauT["filetime"]=sprintf("%s%s%s",$5,sep1,$6)
			fauT["time"]=sprintf("%-24s%s%-16s%s",fauT["filetime"] sep1 "FAULT",sep1,fauT["board"] sep1 fauT["ulma"],sep1)
			save_faultlog_entry()
		}
		else if (/^Parsing ECDA file: /)
		{
			#Parsing ECDA file: /home/eanzmagn/moshell_logfiles/logs_moshell/pmdfiles/a.b.c.d/dspdumps/20110105_141009_00_01_ECDAdump6400-11.gz
			#ininfo=tslinfo=inappinfo=0
			#inerr=inrupmd=0
			save_entry_and_reset()
			inecda=1
			#save_ecdalog_entry()
			ecdT["ecdafile"]=gensub(/^.*\//,"",1,$NF)
			last=split(ecdT["ecdafile"],array,"_")
			ecdT["board"]=array[3] array[4]
			ecdT["number"]=1
			ecdT["timestamp"]=make_timestamp(array[1],array[2])
			#in case there is already another entry with the same timestamp, we increase the ecdT["number"] field:
			while ((ecdT["timestamp"],ecdT["board"],ecdT["number"]) in record) ecdT["number"]++
			split(array[1],a,"") ; split(array[2],b,"")
			ecdT["filetime"]=sprintf("%s%s%s%s-%s%s-%s%s%s%s%s:%s%s:%s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],sep1,b[1],b[2],b[3],b[4],b[5],b[6])
			ecdT["info"]=gensub(/^[^\]]+\]:/,"",1,$0)
			ecdT["ulma"]=gensub(/:.*$/,"",1,$7)
			#we make ecdT["time"] and ecdT["board"] here in case it does not appear in the decoded err file. If it does appear in the err file, then it will be overwritten anyway
			ecdT["time"]=sprintf("%-24s%s%-16s%s",ecdT["filetime"] sep1 "ECDA ",sep1,ecdT["board"] sep1 boardType[ecdT["board"]],sep1)
		}
		else if (/^Parsing ERROR file: /)
		{
			save_entry_and_reset()
			#ininfo=tslinfo=inappinfo=0
			errfile_count=0
			inerr=1
			#save_error_entry()
			errT["errfile"]=gensub(/^.*\//,"",1,$NF)
			last=split(errT["errfile"],array,"_")
			errT["board"]="0001"
			errT["number"]=1
			errT["timestamp"]=make_timestamp(array[1],array[2])
			#in case there is already another entry with the same timestamp, we increase the errT["number"] field:
			while ((errT["timestamp"],errT["board"],errT["number"]) in record) errT["number"]++
			split(array[1],a,"") ; split(array[2],b,"")
			errT["filetime"]=sprintf("%s%s%s%s-%s%s-%s%s%s%s%s:%s%s:%s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],sep1,b[1],b[2],b[3],b[4],b[5],b[6])
			#we make errT["time"] and errT["board"] here in case it does not appear in the decoded err file. If it does appear in the err file, then it will be overwritten anyway
			errT["time"]=sprintf("%-24s%s%-16s%s",errT["filetime"] sep1 "ERR  ",sep1,errT["board"] sep1 boardType[errT["board"]],sep1)
		}
		else if (/^Parsing PMD file: /)
		{
			#ininfo=tslinfo=inappinfo=0
			#inerr=inecda=inrupmd=0
			#save_pmd_entry()
			save_entry_and_reset()
			pmdT["pmdfile"]=gensub(/^.*\//,"",1,$NF)
			last=split(pmdT["pmdfile"],array,"_")
			pmdT["board"]=array[last-1]
			pmdT["number"]=array[5]
			pmdT["timestamp"]=make_timestamp(array[1],array[2])
			split(array[1],a,"") ; split(array[2],b,"")
			pmdT["filetime"]=sprintf("%s%s%s%s-%s%s-%s%s%s%s%s:%s%s:%s%s",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],sep1,b[1],b[2],b[3],b[4],b[5],b[6])
			#we make pmdT["time"] and pmdT["board"] here in case it does not appear in the decoded pmd file. If it does appear in the pmd file, then it will be overwritten anyway
			match(pmdT["board"],/^([0-9][0-9][0-2][0-9])([0-9][0-9])/,array)
			bDev=""
			if (array[2]~/^(1[6-9]|20)$/) bDev="SP"array[2]-16
			else if (array[2]~/^0[1-3]$/) bDev="D"array[2]
			pmdT["board"]=array[1] bDev
			pmdT["time"]=sprintf("%-24s%s%-16s%s",pmdT["filetime"] sep1 "PMD  ",sep1,pmdT["board"] sep1 boardType[pmdT["board"]],sep1)
			checkTimeAgain=1
		}
		else if (inrupmd==1)
		{
			#[Start of POST MORTEM DUMP]
			#  PMD identity : 0x8
			#  Date         : 2013-12-24
			#  Time         : 13:53:44
			#[PRODUCT INFORMATION]
			#  LMC PID      : CXP9013268_R48ZD
			#  XPP PID      : CXC1321797/4_R14F
			#  XPL PID      : CXC1321812/1-R4F
			#  IBOOT PID    : CXC1321302/2-R6D01
			#  HW TYPE      : AUM2HP Flash=16Mb RAM=16Mb AUC-rev=0x0 OSE Delta PowerPC/BL250296
			#  HW PID       : KRC 118 42/3
			#  HW REV       : R1C
			#  HW NAME      : RRUW
			#  HW DATE      : 20101213
			#  HW SERIAL    : CB4F612184
			#[ERROR HANDLER PARAMETERS]
			#  user called  : 0
			#  error code   : 0x83000113
			#  extra        : 0x3cd670
			#[CURRENT PROGRAM]
			#  Current process        : 0x1009f
			#  Current process name   : readmem
			#  File                   :
			#  Line                   : 0
			#  Program (Suname)       : XPP
			#  Load module (LM PID)   : CXC1321797/4_R14F
			#if (rupmdT["number"]=="" && $2=="PMD" && $3=="identity" && $4==":")
			#{
			#	rupmdT["board"]=gensub(/:$/,"",1,$1)
			#	rupmdT["number"]=sprintf("%d",strtonum($5))
			#	rupmdT["pmd"]=rsep "PMD="$5
			#}
			#else if (rupmdT["date"]=="" && $2=="Date" && $3==":") rupmdT["date"]=$4
			#else if (rupmdT["timestamp"]=="" && $2=="Time" && $3==":")
			#{
			#	rupmdT["timestamp"]=make_timestamp(rupmdT["date"],$4)
			#	rupmdT["time"]=sprintf("%-24s%s%-16s%s",rupmdT["date"]" "$4 sep1 "RUPMD",sep1,rupmdT["board"] sep1 boardType[rupmdT["board"]],sep1)
			#}
			if (rupmdT["lmc"]=="" && $1=="LMC" && $2=="PID" && $3==":") rupmdT["lmc"]=rsep "LMC="$4
			else if (rupmdT["code"]=="" && $1=="error" && $2=="code" && $3==":") rupmdT["code"]=rsep "Err="$4
			else if (rupmdT["extra"]=="" && $1=="extra" && $2==":") rupmdT["extra"]=rsep "Extra="$3
			else if (rupmdT["process"]=="" && $1=="Current" && $2=="process" && $3==":") rupmdT["process"]=rsep "ProcId="$4
			else if (rupmdT["processname"]=="" && $1=="Current" && $2=="process" && $3=="name" && $4==":") rupmdT["processname"]=rsep "Proc="$5
			else if (rupmdT["lm"]=="" && $1=="Load" && $2=="module" && $3=="(LM" && $4=="PID)" && $5==":") rupmdT["lm"]=rsep "LM="$6
			#if ($1=="Parsing" && $3=="file:" && $2~/^(MGWDSP|MGWVPP|FAULTLOG|ECDA|ERROR|PMD)$/) inrupmd=0
			#else continue
			continue
		}
		else if (inecda>=1)
		{
			if ($1=="2.") inecda=2
			if (inecda==2) continue
			if (NF==0) continue

			if (/^[^:]+:[ \t]/) ecdT[gensub(/[ \t]/,"","g",gensub(/:.*$/,"",1,$0))]=gensub(/^[^:]+:[ \t]+|[ \t]+$/,"","g",$0)
			continue
		}

		else if (inerr>=1)
		{
			if (errT["errfile"] ~ /\.gz$/) continue
			#*** Trace ****
			if ($1=="***") inerr=2
			#13:43:59.228 LmCellPT3 omfPmAgentC[0] received message: eventTimer[0]%timeout from: undef new state: Idle data: 0x0
			if ($1~ /^[0-9]+:[0-9][0-9]:[\.0-9]+$/) inerr=2
			if (inerr==2) continue
			if (NF==0) continue
			#Mon Sep 27 09:37:42 2010
			if (NF==5 && $5 ~ /^[12][0-9][0-9][0-9]$/ && $4 ~ /^[0-9]+:[0-9]+:[0-9]+$/)
			{
				#errT["time"]=sprintf("%-24s%s%-16s%s",errT["filetime"] sep1 "ERR  ",sep1,errT["board"] sep1 boardType[errT["board"]],sep1)
				continue
			}
			#/n*** User Message ***
			if (/\*\*\* .* \*\*\*/) continue
			#[2012-06-18 16:43:45] rnhCellCtrlC: signal serviceAvailInd void received on port ctrlRoCtrlP[2] in state ProtocolVersion
			if ($1~/^.?[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]$/ && $2 ~ /^[0-9][0-9]:[0-9][0-9]:[0-9][0-9].?$/) continue
			if (NF==2 && $1=="Additional" && $2=="information:") continue

			#part to keep:
			#CXC1725191%11_R4H
			#!<0x9c8>! Failed to read eNBId from IMA response in MonSwU, <?xml version="1.0" encoding="UTF-8" ?><ima version="R1A"><class ldn="ManagedElement=1,ENodeBFunction=1"></class></ima>^R
			if ($1 ~ /^CXC/)
			{
				if (gensub(/_.*$/,"",1,$1) in lmidLookupTable) $1=sprintf("%s (%s)",$1,lmidLookupTable[gensub(/_.*$/,"",1,$1)])
				errT["lm"]=$0
				continue
			}
			#only take the first 5 lines of the error file
			errfile_count++
			if (errfile_count>6) continue
			errT["info"]=sprintf("%s %s",errT["info"],$0)
			continue
		}
		#PMD file entries
		#Dump created  :   2018-12-17  05:44:54.1555
		else if (checkTimeAgain==1 && /^ *Dump created +: +/)
		{
			checkTimeAgain=0
			pmdT["dumptime"]=$4 sep1 gensub(/\..*$/,"",1,$5)
			pmdT["time"]=sprintf("%-24s%s%-16s%s",pmdT["dumptime"] sep1 "PMD  ",sep1,pmdT["board"] sep1 boardType[pmdT["board"]],sep1)
		}
		else if (/\[POST MORTEM DUMP\]/) inpostmortemdumpdata=1
		else if (inpostmortemdumpdata==1 && /^ *error code +: +0x/) pmdT["code"]="Err="$NF
		else if (/USER REPORTED ERROR DATA/) usererrordata=1
		else if (usererrordata==1 && $1=="String:") { llogT["info"]=gensub(/^[^:]+:[ \t]+/,"",1,$0) ; usererrordata=0 }
		else if (/TSL INFORMATION/) { tslinfo=1 ; usererrordata=0 }
		else if (tslinfo==1 && $2=="=" && $1 ~ /^(capsule|controller|message|state)$/ && (!($1 in pmdT))) pmdT[$1]=$1"="$3
		else if (/Board location: / && pmdT["board"]!~/^[0-9][0-9][0-2][0-9]/)
		{
			#  PMD-id: 0x00000002    Board location: 000500
			#  PMD-id: 0x00000002    Board location: d00001
			#  PMD-id: 0x00000002    Board location: 000300/d00001
			#  PMD-id: 0x00000002    Board location: 011403.sp
			#  PMD-id: 0x00000004    Board location: 002019.sp
			if ($NF ~ /^d0000/) pmdT["board"]=pmdT["board"]"D0"gensub(/^d0000/,"",1,$NF)
			else pmdT["board"]=$NF
			if (pmdT["board"]~/00\/d0000/) sub(/00\/d0000/,"D0",pmdT["board"])
			else if (pmdT["board"]~/\.sp$/)
			{
				match(pmdT["board"],/([0-9][0-9][0-9][0-9])([0-9][0-9])\.sp$/,array)
				bDev=""
				if (array[2]~/^(1[6-9]|20)$/) bDev="SP"array[2]-16
				else if (array[2]~/^0[1-3]$/) bDev="D"array[2]
				pmdT["board"]=array[1] bDev
			}
		}
		else if ($1=="Time:")
		{
			ininfo=inappinfo=0
			if ($2 ~ /^70-/) $2="19"$2 ; else if ($2 ~ /^..-/) $2="20"$2
			if ($2 ~ /^(1970|2000)-/) pmdT["TIME"]=pmdT["filetime"]
			else pmdT["TIME"]=$2 sep1 $3
			pmdT["referenceTime"]=$2 sep1 $3
			if (pmdT["board"] ~ /^[0-9][0-9][0-2][0-9][0-9][0-9]/)
			{
				#only process pmdT["board"] if it has not already been processed
				match(pmdT["board"],/^([0-9][0-9][0-2][0-9])([0-9][0-9])?/,array)
				bDev=""
				if (array[2]~/^(1[6-9]|20)$/) bDev="SP"array[2]-16
				else if (array[2]~/^0[1-3]$/) bDev="D"array[2]
				pmdT["board"]=array[1] bDev
			}
			pmdT["time"]=sprintf("%-24s%s%-16s%s",pmdT["TIME"] sep1 "PMD  ",sep1,pmdT["board"] sep1 boardType[pmdT["board"]],sep1)
		}
		#  ERROR NUMBER 0x00000029 WITH EXTRA DATA 0x00000006 OCCURRED IN
		#  ERROR NUMBER 0x83230007 WITH EXTRA DATA 0x004C3370 WAS REPORTED BY
		#  ERROR NUMBER 0xF0F0F0F2 WITH EXTRA DATA 0x0BB0CBF0 WAS REPORTED BY
		else if (/^ *ERROR NUMBER /) pmdT["code"]="Err="$3
		#Currently we are ignoring the line with RECURSIVE ERROR and just use the error code from llog
		#RECURSIVE ERROR WITH ERROR NUMBER 0x80020113 WITH EXTRA DATA 0x006E655C WAS REPORTED BY
		#else if (/^ *RECURSIVE ERROR WITH ERROR NUMBER /) pmdT["code"]="Err="$6
		else if ($1=="PROCESS")
		{
			#PROCESS d00001/
			#PROCESS 011600/
			if ($2 ~ /^([0-9][0-9][0-9][0-9]|d0000)/) { pmdT["process"]=pmdT["process"]"/"$2 ; gsub(/^\/|\/$/,"",pmdT["process"]) }
			else pmdT["process"]=$2
		}
		else if ($1=="BLOCK")
		{
			#  BLOCK   d00001
			if ($2 ~ /^([0-9][0-9][0-9][0-9]|d0000)/) { pmdT["block"]=pmdT["block"]"/"$2 ; gsub(/^\/|\/$/,"",pmdT["block"]) }
			else pmdT["block"]=$2
		}
		else if ($2=="Time")
		{
			delete llogT
			ininfo=inappinfo=0
			sub(/,$/,"",$4)
			if ($4 ~ /^70-/) $4="19"$4 ; else if ($4 ~ /^..-/) $4="20"$4
			llogT["time"]=sprintf("%-24s%s%-16s%s",$4 sep1 $5 sep1 "PMD  ",sep1,pmdT["board"] sep1 boardType[pmdT["board"]],sep1)
			llogT["referenceTime"]=$4 sep1 $5
		}
		else if (/Restart type *:/) llogT["restartType"]=$NF
		else if (/Restart rank *:/) llogT["restartRank"]=gensub(/^.*Restart rank *: *| /,"","g",$0)
		else if (/OS Run Mode *:/)  llogT["osmod"]=$NF
		else if (/Process *:/)      llogT["process"]=$NF
		else if (/File:line *:/)
		{
			llogT["file"]=$NF
			#sometimes the filename is corrupt, eg: File:line      :  M-XM--^PM-'M-]M-\M-M^A^LgM-]M-`M-1^LM-^CM-]M-dM-x(M-@lM-]M-hM-p:4530$
			if (llogT["file"] !~ /^[A-Za-z0-9_]/) sub(/^.*:/,"?????:",llogT["file"])
		}
		else if (/PMD identity *:/)
		{
			if ($NF != "-") llogT["pmd"]=$NF
		}
		else if (/(Error|Restart) code *:/)
		{
			llogT["code"]=gensub(/^\(/,"",1,$4)
			if (/CELLO:ERI/) llogT["orig"]="eri_api" ; else if (/OSE error API/) llogT["orig"]="ose_api" ; else if (/OSE Kernel/) llogT["orig"]="kernel"
			if (llogT["code"] ~ "Ordered") llogT["code"]="Ordered"
			else llogT["code"]="Err="llogT["code"]("orig" in llogT?" ("llogT["orig"]")":"")
		}
		else if (/Error Description *:/) llogT["desc"]=gensub(/\[|\]/,"","g",$NF)
		else if (/(Error|Restart) Information *:/) { inappinfo=0 ; ininfo=1 ; continue }
		else if (/The following text message was provided by the reporting application:/) { inappinfo=1 ; continue }
		else if (/^[ \t]*\[(HARD DISK ERROR LOG|OUTPUT OF DUMP INFORMATION|ERROR CODE|CALLTRACE)\]/ || $1=="IRQ:") { ininfo=inappinfo=0 ; continue}
		else if (/ (PC|SRR0) += +/)
		{
			#  PC  = 46022FC8  SP  = 3DFA2478  MSR = 0000D030  LR  = 460025F4
			#  SRR0  = 01584A9C     SRR1  = 00009030     SPRG0 = 00000004
			#  SPRG7  = 00000000     SRR0   = 008200FC     SRR1   = 00029030
			for (i=1;i<=NF;i++) if ($i~/^(PC|SRR0)$/) pmdT[$i]=$i"="$(i+2)
		}
		else if (/Restart initiated on core [0-9.]+$/) pmdT["core"]="Core="gensub(/\.$/,"",1,$NF)+0
		if (ininfo==1)
		{
			gsub(/^ *| *$/,"")
			if (/^0x[^:]+:.*"/) { gsub(/^[^"]+"|"[^"]*$/,"") ; gsub(/\./,"") ; llogT["info"]=llogT["info"] $0}
			else llogT["info"]=llogT["info"]" "$0
			gsub(/^ +| +$/,"",llogT["info"])
			gsub(/  +/," ",llogT["info"])
		}
		else if (inappinfo==1)
		{
			gsub(/^ *| *$/,"")
			pmdT["appinfo"]=pmdT["appinfo"]" "$0
			gsub(/^ +| +$/,"",pmdT["appinfo"])
			gsub(/  +/," ",llogT["appinfo"])
		}
	}
	close(xml_log)
	save_entry_and_reset()
	#save_pmd_entry()
	#if (inerr>=1) save_error_entry()
	#if (inecda>=1) save_ecdalog_entry()
	#if (inrupmd==1) save_rupmd_entry()
	n=asort(tList)
	if (reverse_sort==0)
	{
		for (i=1;i<=n;i++)
		{
			#print "T: "i" "tList[i]
			for (j=1;j<=nrBoards;j++)
			{
				#print "B: "j" "bList[j]
				for (k=1;k<=nrNumbers;k++)
				{
					if ((tList[i],bList[j],nList[k]) in record) customPrint(record[tList[i],bList[j],nList[k]])
				}
			}
		}
	}
	else
	{
		for (i=n;i>=1;i--)
		{
			#print "T: "i" "tList[i]
			for (j=1;j<=nrBoards;j++)
			{
				#print "B: "j" "bList[j]
				for (k=1;k<=nrNumbers;k++)
				{
					if ((tList[i],bList[j],nList[k]) in record) customPrint(record[tList[i],bList[j],nList[k]])
				}
			}
		}
	}
}
function save_entry_and_reset()
{
	#if (inpmd==1)
	#if (inerr>=1)
	#if (inecda>=1)
	#if (inrupmd==1)
	save_pmd_entry()
	save_error_entry()
	save_ecdalog_entry()
	save_rupmd_entry()

	errfile_count=0
	inappinfo=0
	inecda=0
	inerr=0
	ininfo=0
	inrupmd=0
	tslinfo=0
	usererrordata=0
	inpmd=0
}
function parse_upg_log(  date,time,inlog,logcontents,i,flag,arrayD,arrayT,hh,mi,ss,dd,mo,yy,ok,class,method,sep,obj)
{
	if (csvoutput==1) sep=";" ; else sep=" "
	while ((getline < xml_log)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if ($1=="Date:")
		{
			#Date:   2007-12-31, Time: 11:16:26.759,  SU_SW: 5.1 LSV21 - R51EL46

			#dump the previous record into table
			if ((logcontents == "" || flag ~ /-d|Debug/ || csvoutput==1) && class != "") logcontents=gensub(/^ */,"",1,class"."method"(): "logcontents)
			#special case theLmRefAttr.length: is a confusing entry, add the method in front
			else if (flag !~ /-d|Debug/ && csvoutput!=1 && logcontents ~ /^ *theLmRefAttr.length:/) logcontents=method"(): "gensub(/^ */,"",1,logcontents)
			if (logcontents != "") contents[++i]= sprintf("%s%s%s%sUP%s%s%s%s",date,sep,time,sep,flag,sep,(csvoutput==1 ? obj sep : " "),gensub(/^ */,"",1,logcontents))

			#initialisation
			ok=inlog=0 ; logcontents=class=method=obj="" ; flag=(csvoutput==1?"":" ") sep

			date=gensub(",","",1,$2)
			time=gensub(/\..*$/,"",1,$4)
			if (length(time)==7) time="0"time  #put an extra 0 in front to align
			if (make_timestamp(date,time) >= startdate && make_timestamp(date,time) <= enddate)
			{
				ok=1
				obj=gensub(/^.*, */,"",1,$0)
			}
		}
		else if (ok==1)
		{
			if (/^(I N F O|E R R O R|W A R N I N G|Log|Info|Debug):/)
			{
				inlog=1
				logcontents=logcontents" "gensub(/^(I N F O|E R R O R|W A R N I N G|Log|Info|Debug):[ \t]+/,"",1,$0)
				if (csvoutput==1)
				{
					if (/^I N F O:/) flag=sep"INFO"
					else if (/^E R R O R:/) flag=sep"ERROR"
					else if (/^Info:/)  flag=sep"Info"
					else if (/^Debug:/) flag=sep"Debug"
					else if (/^W A R N I N G:/) flag=sep"WARNING"
				}
				else
				{
					if (/^I N F O:/) flag="-I"
					else if (/^E R R O R:/) flag="-E"
					else if (/^Info:/)  flag="-i"
					else if (/^Debug:/) flag="-d"
					else if (/^W A R N I N G:/) flag="-W"
				}
			}
			else if ($1 ~ /^(Method|Class):$/)
			{
				inlog=0
				if (/^Method:/) method=gensub(/^Method:[ \t]+|\(.*$/,"","g",$0)
				else if (/^Class:/) class=gensub(/^Class:[ \t]+/,"",1,$0)
			}
			else if ($1 == "Operation:")
			{
				inlog=0
				logcontents=logcontents" "gensub(/^Operation:[\t ]+/,"",1,$0)
			}
			else if (inlog==1 && NF >0)
			{
				#always keep this rule last
				logcontents=logcontents" "gensub(/^[ \t]+/,"",1,$0)
			}
		}
	}
	close(xml_log)

	#dump the last record
	if ((logcontents == "" || flag ~ /-d|Debug/ || csvoutput==1) && class != "") logcontents=gensub(/^ */,"",1,class"."method"(): "logcontents)
	#special case theLmRefAttr.length: is a confusing entry, add the method in front
	else if (flag !~ /-d|Debug/ && csvoutput!=1 && logcontents ~ /^ *theLmRefAttr.length:/) logcontents=method"(): "gensub(/^ */,"",1,logcontents)
	if (logcontents != "") contents[++i]= sprintf("%s%s%s%sUP%s%s%s%s",date,sep,time,sep,flag,sep,(csvoutput==1 ? obj sep : " "),gensub(/^ */,"",1,logcontents))

	if (csvoutput!=1)
	{
		customPrint("======================================================================================================")
		customPrint(sprintf("%-19s  %-3s  %s","Timestamp (UTC)","","Description"))
		customPrint("======================================================================================================")
	}
	if (reverse_sort==0) for (j=1;j<=i;j++) customPrint(process_upg_record(contents[j]))
	else for (j=i;j>=1;j--)	customPrint(process_upg_record(contents[j]))
}
function process_upg_record(record)
{
	gsub(/^[ \t]*|[ \t]*$/,"",record)
	gsub(/ *\( */,"(",record)
	gsub(/ *\) */,")",record)
	gsub(/ : /,": ",record)
	gsub(/(SubNetwork=[^,]+,SubNetwork=[^,]+,MeContext=[^,]+,)*ManagedElement=1,/,"",record)
	gsub(/Equipment=1,|SwManagement=1,/,"",record)
	record=appendCXCtranslation(record)
	return record
}
function replace_xml_chars()
{
	gsub(/&(amp;)?quot;/,"\"")
	gsub(  /&quot;|&#0*34;|&#x0*22;/,           "\"")
	gsub(   /&amp;|&#0*38;|&#x0*26;/,           "\\&")
	gsub(  /&apos;|&#0*39;|&#x0*27;/,           "'")
	gsub( /&ndash;|&#0*8211;|&#x2013;/,         "")
	gsub( /&mdash;|&#0*8212;|&#x2014;/,         "")
}

function parse_hili_log(    date,time,logRec,currentCV,smn,apn,tag,prodno,prodrev,prodname,proddate,prodserial,teststatus,intestresult,testresult,hwaddress,logRecTable,taglist,hwinfo,position,output)
{
	while ((getline < xml_log)>0)
	{
		replace_xml_chars()
		#<year> 2005 </year> <month> 11 </month> <day> 4 </day>
		#<hour> 15 </hour> <minute> 8 </minute> <second> 38 </second>
		if ($1=="<year>") date=sprintf("%s-%02d-%02d",$2,$5,$8)
		else if ($1=="<hour>") time=sprintf("%02d:%02d:%02d",$2,$5,$8)
		#  <LogRecord number = "1">
		else if ($1=="<LogRecord")
		{
			logRec=gensub(/"|>/,"","g",$NF)+0
			logRecTable[logRec]=logRec
		}
		#Startable Configuration Version = cv_BP_LLV14_TEMI
		else if ($1=="Startable") currentCV=$NF
		#<SwitchModuleNumber>  0 </SwitchModuleNumber>
		#<SwitchPortNumber>    0 </SwitchPortNumber>
		else if ($1=="<SwitchModuleNumber>") smn[logRec]=$2
		else if ($1=="<SwitchPortNumber>")   apn[logRec]=$2
		else if ($1=="<UnitHwPid>")          tag="unit"
		else if ($1=="<ConfiguredHwPid>")    tag="conf"
		#<ProdNo>       ROJ 119 2108/3              </ProdNo>
		#<ProdRev>      R2E                       </ProdRev>
		#<ProdName>     SCB2                      </ProdName>
		#<ProdDate>     03W01                     </ProdDate>
		#<ProdSerialNo> T012138431                </ProdSerialNo>
		else if ($1=="<ProdNo>") prodno[logRec,tag]=gensub(/^.*<ProdNo> *| *<.ProdNo>.*$|[ \t]/,"","g",$0)
		else if ($1=="<ProdRev>") prodrev[logRec,tag]=$2
		else if ($1=="<ProdName>") prodname[logRec,tag]=gensub(/^.*<ProdName> *| *<.ProdName>.*$|[ \t]/,"","g",$0)
		else if ($1=="<ProdDate>") proddate[logRec,tag]=$2
		else if ($1=="<ProdSerialNo>") prodserial[logRec,tag]=$2
		#<UnitTestStatusOk/>
		#<UnitTestStatusNoConnection/>
		#<UnitTestStatusFaulty/>
		#<HwAddress>Cabinet 1, bottom unit </HwAddress>
		else if ($1=="<HwAddress>") hwaddress[logRec]=gensub(/^.*<HwAddress> *| *<.HwAddress>.*$/,"","g",$0)"  "
		#<HwType> Battery charger </HwType>
		else if ($1=="<HwType>") hwtype[logRec]=gensub(/^.*<HwType> *| *<.HwType>.*$/,"","g",$0)"  "
		else if ($1=="<UnitNotConfigured/>") hwinfo[logRec,"conf"]="UnitNotConfigured"
		else if ($1=="<HwPidNotAvailable/>") hwinfo[logRec,"unit"]="HwPidNotAvailable"
		else if ($1 ~ /^<UnitTestStatus/) teststatus[logRec]=gensub(/^<UnitTestStatus|\/|>/,"","g",$1)
		#<UnitTestResult>
		else if ($1 == "<UnitTestResult>" || $1 == "<AdditionalInfo>") intestresult=1
		#</UnitTestResult>
		else if ($1 == "</UnitTestResult>" || $1 == "</AdditionalInfo>") intestresult=0
		else if (intestresult==1) testresult[logRec]=testresult[logRec]"\n"$0
		#<HwAddress> Cabinet 1, bottom unit </HwAddress>
	}
	close(xml_log)
	customPrint(sprintf("\nHW INVENTORY LOG FOR CV: %s, TAKEN ON: %s at %s.\n",currentCV,date,time))
	n=asort(logRecTable)
	taglist["unit"]=taglist["conf"]=1
	for (i=1;i<=n;i++)
	{
		logRec=logRecTable[i]
		if (logRec in smn && smn[logRec] != "") position[logRec]=sprintf("%02d%02d",smn[logRec],apn[logRec])
		else position[logRec]=" -- "
		for (tag in taglist)
		{
			if (hwinfo[logRec,tag] != "") continue
			if (prodno[logRec,tag] != "")   hwinfo[logRec,tag]=sprintf("%-15s ",prodno[logRec,tag])
			if (prodrev[logRec,tag] != "")  hwinfo[logRec,tag]=sprintf("%s%-7s ",hwinfo[logRec,tag], prodrev[logRec,tag])
			if (prodname[logRec,tag] != "") hwinfo[logRec,tag]=sprintf("%s%-8s ",hwinfo[logRec,tag],prodname[logRec,tag])
			if (proddate[logRec,tag] != "") hwinfo[logRec,tag]=sprintf("%s%-8s ",hwinfo[logRec,tag],proddate[logRec,tag])
			if (prodserial[logRec,tag] !="")hwinfo[logRec,tag]=sprintf("%s%-10s ",hwinfo[logRec,tag],prodserial[logRec,tag])
		}
		output[logRec]=sprintf("%s  %-12s  %-52s  %-25s  %s%s",position[logRec],teststatus[logRec],hwinfo[logRec,"unit"],hwinfo[logRec,"conf"],hwtype[logRec],hwaddress[logRec])
	}
	customPrint(sprintf("\
===============================================================================================================================\n\
%-4s  %-12s  %-52s  %-25s  %s\n\
===============================================================================================================================",\
"POS","TEST_STATUS","ACTUAL_HW","CONFIGURED_HW","HW_TYPE/HW_ADDRESS"))
	for (i=1;i<=n;i++)
	{
		logRec=logRecTable[i]
		if (output[logRec] !~ /^ --  *$/) customPrint(output[logRec])
	}
	customPrint(sprintf("\n\
=======================================================================================\n\
HW TEST RESULTS AND ADDITIONAL INFO\n\
======================================================================================="))
	for (i=1;i<=n;i++)
	{
		logRec=logRecTable[i]
		if (testresult[logRec] != "") customPrint(output[logRec] testresult[logRec]"\n---------------------------------------------------------------------------------------")
	}
	customPrint("")
}
function parse_xml_log(what,  array,headerprinted,tt)
{
	recordOffset=0
	if (os~/^sunsparc/ || os=="sun86")
	{
		#print "StartDate="startdate,mystrftime("%H%M%S",startdate)
		if ("StartDate" in ENVIRON) startdate=make_timestamp(ENVIRON["StartDate"])
		if ("EndDate" in ENVIRON) enddate=make_timestamp(ENVIRON["EndDate"])
		#print "StartDate="ENVIRON["StartDate"],startdate,mystrftime("%H%M%S",startdate)
		#print "EndDate="ENVIRON["EndDate"],enddate,mystrftime("%H%M%S",enddate)
	}
	while ((getline < xml_log)>0)
	{
		gsub(/\r|\x00/,"")
		replace_xml_chars()
		if (/<LogName>/)
		{
			#    <LogName> ALARM_LOG </LogName>
			#Possible lognames:
			#CELLO_AVAILABILITY2_LOG (cpp5 and above) CELLO_AVAILABILITY_LOG (cpp4 and below)
			#ALARM_LOG  (cpp5.1 and above)  CELLO_ALARM_LOG (cpp5 and below)
			#EVENT_LOG  (cpp5.1 and above)  CELLO_EVENT_LOG (cpp5 and below)
			#CELLO_SECURITYEVENT_LOG
			#CELLO_AUDITTRAIL_LOG, SHELL_AUDITTRAIL_LOG
			#AUDIT_TRAIL_LOG
			#CELLO_HWINVENTORY_LOG
			#CELLO_IPTRAN_LOG
			#CELLO_IPTRAN_DEBUG_LOG

			#we convert the logname so it is unique for each type of log:
			logname=$2
			if (logname ~ "AVAILABILITY2") sub("AVAILABILITY2","AVAILABILITY",logname)
			else if (logname ~ /^CELLO_IPTRAN_DEBUG/) { logname="IPDEBUG"  }
			else if (logname ~ /^CELLO_(ALARM|EVENT|IPTRAN)/) sub(/CELLO_/,"",logname)
			else if (logname ~ /RBS_CS_AVAILABILITY_LOG/) sub(/RBS_CS/,"CELLO",logname)
			else if (logname ~ /^(ANR|TPS|ANR_EUTRAN)_EVENTLOG/) { son_logtype=gensub(/_EVENTLOG.*$/,"",1,logname) ; logname="SON_EVENTLOG" }
			if (logname ~ /AUDIT_TRAIL|CORBA_AUDITTRAIL_LOG|PNP_LOG/)  { parse_command_log(what) ; return }
			if (logname ~ "CELLO_HWINVENTORY")                 { parse_hili_log()    ; return }
			if (csvoutput!=1 && headerprinted[logname]!=1)
			{
				customPrint("====================================================================================================================")
				if (logname ~ "AVAILABILITY") customPrint(sprintf("%-19s %-4s  %-4s %-15s  %-3s %-6s  %-10s  %s","Timestamp (UTC)","Type","Serv","Reason","Piu","Positn","Board/Prog","AdditionalInfo"))
				else if (logname ~ /^ALARM/)
				{
					if (alarm_header>0) addHeader="(AdditionalText/PC, AI)"
					else addHeader="(Cause/AdditionalInfo)"					
					if (alarm_format==0) customPrint(sprintf("%-19s %5s %s %-35s %-25s %s","Timestamp (UTC)","","S","Problem","Cause","MO-reference"))
					else customPrint(sprintf("%-19s %5s %s %-35s %-s","Timestamp (UTC)","","S","Problem","MO "addHeader))
				}
				else if (logname ~ /^(EVENT|IPTRAN)/) customPrint(sprintf("%-19s %5s %-40s %s","Timestamp (UTC)","","MO-reference","Event"))
				else if (logname ~ /AUDITTRAIL/) customPrint(sprintf("%-19s %5s %-12s %-31s %-15s %s","Timestamp (UTC)","","User","Terminal","Event","Info"))
				else if (logname ~ /SECURITYEVENT/) customPrint(sprintf("%-19s %5s %s","Timestamp (UTC)","","Event (Info)"))
				else if (logname ~ /RLIB_PM_LOG|SON_EVENTLOG|CELLO_WEBSERVER_LOG|ROAM_GEO_LOG/) customPrint(sprintf("%-19s %5s %s","Timestamp (UTC)","","Description"))
				customPrint("====================================================================================================================")
				headerprinted[logname]=1
			}
		}
		else if (/<LogRecord number *= */)
		{
			if (/<LogRecord number=[^ ]/) sub(/=/," = ")   #This is for RCS availability where there is no space around the equal sign on the LogRecord line
			if (logname=="")
			{
				#in case the log is corrupt and the <LogName> was missing
				if (tolower(xml_log) ~ "alarm") logname="ALARM_LOG"
				else if (tolower(xml_log) ~ "event") logname="EVENT_LOG"
				else if (tolower(xml_log) ~ "availability") logname="CELLO_AVAILABILITY2_LOG"
				else if (tolower(xml_log) ~ "iptran") logname="IPTRAN_LOG"
				else if (tolower(xml_log) ~ "consul") logname="CELLO_WEBSERVER_LOG"
				else if (tolower(xml_log) ~ "liclog") logname="ROAM_GEO_LOG"
			}
			recordNumber=gensub(/"|>/,"","g",$4)+recordOffset
			if (recordNumber in recordNumberTable)
			{
				#in case we are parsing a toggling log like audit trail and the same record numbers have been reused in the log as in the push log
				recordOffset+=100000
				recordNumber+=recordOffset
			}
			recordNumberList[++recordNumberCount]=recordNumber
			recordNumberTable[recordNumber]=1
			#if (recordNumber > maxRecordNumber) maxRecordNumber=recordNumber
		}
		else if (logname == "IPDEBUG" && $1~/^time=/)
		{
			#time=2014-12-09 04:58:04;piu=0025;DEMUX_POLICER_DISCARD_ING=0;FAIL_L4_CSUM_NO_DISCARD=0;FAIL_L3L4_CHCKSUMS=0;FAIL_L4_CHCKSUM=0;INVALID_IPIF_TO_VID_MAP=0;FAIL_AAL5_CRC=0;ARP_RESOLVED_DROP_TRUE=0;ARP_NOT_RESOLVED_DROP_TRUE=0;TERM_RELEASE_PENDING_DISC=0;TERM_ARP_DROP_TRUE=0;INVALID_IPSRC_UDPSRC=0;ING_DEFRAG_ERROR=0;MISS_ING_GET_ACTION=0;MISS_ING_MAC_FILTER=6862;MISS_ING_DIST_DID=0;MISS_ING_TERM_SESSION=0;MISS_ING_SESSION_TREE=0;MISS_ING_SCTP_DIST_DID=32;MISS_TERM_INT_SESSION=0;MISS_MUX_DEMUX_SESSION=0;DEMUX_SESSION_ERROR=0;ATI_DEMUX_UDP_SRC_ERROR=0;ATI_DEMUX_DROP=0;RTP_V2_DISCARD_OUT_OF_SEQUENCE=0;MISS_SCTP_DIST_DID=0;SILENT_DISCARD=1;DEMUX_RELEASE_PENDING=0;MISS_LAID_TO_IPIF=0;MISS_EGR_GET_DIST_DATA=0;P2_BROADCAST_FROM_HOST=0;rx64B_front_link_A=0;rx64B_127B_front_link_A=0;rx128B_255B_front_link_A=0;rx256B_511B_front_link_A=0;rx512B_1023B_front_link_A=0;rx1024B_max_front_link_A=0;tx64B_front_link_A=0;tx64B_127B_front_link_A=0;tx128B_255B_front_link_A=0;tx256B_511B_front_link_A=0;tx512B_1023B_front_link_A=0;tx1024B_max_front_link_A=0;rx64B_back_link_A=458435;rx64B_127B_back_link_A=3256514;rx128B_255B_back_link_A=1609480;rx256B_511B_back_link_A=1715;rx512B_1023B_back_link_A=26;rx1024B_max_back_link_A=0;tx64B_back_link_A=350485;tx64B_127B_back_link_A=7352569;tx128B_255B_back_link_A=1605974;tx256B_511B_back_link_A=366;tx512B_1023B_back_link_A=321;tx1024B_max_back_link_A=0;HTB1_IP_AAL5=32;HTB1_UDP_TERM=2;HTB1_INCOMPL_SESSION=0;HTB1_ARP_REQ=871;HTB1_ARP_REP=691;HTB1_ICMP_DU_PORT=0;HTB1_ICMP_DU_PROT=0;HTB1_PORT_UNREACH=31;HTB1_PROT_UNREACH=0;HTB1_REASS_TIME_EXCDS=0;HTB1_DEST_UNREACH=0;HTB1_TIME_EXCDS=0;HTB1_INCOMPL_NAT_IPV6_SESSION=0;HTB1_REASS_TIME_EXCDS_V6=0;HTB1_FPC_NP2S_NXTHOPD=0;LP_0_pduPassed=0;LP_0_pduDiscarded=0;LP_0_tttPassed=0;LP_0_tttDiscarded=0;LP_0_blockRemaining=0;LP_3_pduPassed=5320695;LP_3_pduDiscarded=0;LP_3_tttPassed=13773928;LP_3_tttDiscarded=0;LP_3_blockRemaining=0;LP_4_pduPassed=1627;LP_4_pduDiscarded=0;LP_4_tttPassed=2204;LP_4_tttDiscarded=0;LP_4_blockRemaining=0
			lastf=split($0,arr,";")
			sub(/^time=/,"",arr[1])
			for (k=3;k<=lastf;k++)
			{
				split(arr[k],brr,"=")
				t_mo=piuToMo(arr[2])
				#if (tolower(t_mo) !~ tolower(ipdMoFilter)) continue
				#if (tolower(brr[1]) !~ tolower(ipdAttFilter)) continue
				customPrint(arr[1]";"t_mo";"brr[1]";"brr[2])
			}
		}
		else if (logname ~ /^(ALARM|EVENT)/)
		{
			#on LTE some alarms contain a carriage return, eg "DBC Assert failure" and "GeneralSwError"
			#if (/DBC Assert failure:[^;]*$/) { buffline=$0 ;continue}
			nrs=split($0,array,";")
			if (array[1]=="1f1" && nrs<23) { buffline=$0 ; continue }
			if (buffline != "" && NF>0) { $0=buffline $0 ; buffline=""}
			if (!/.*;.*;.*;.*;.*;.*;.*;/) continue 
			#in the regexp above, we make sure that the line contains many ";" because there can be multiple lines in EVENT_LOG and we are only interested in the line that has many ";"
			split($0,array,";")
			if (logname ~ /^ALARM/ && show_updated_alarms!=1 && array[3]~/^x[23]$/) continue  #TR HS49639, hide changed alarms
			RecordTimeStamp[recordNumber]=convert_gregorian_to_epoch(array[7])
			#print recordNumber" "strftime("%Y-%m-%d %H:%M:%S",RecordTimeStamp[recordNumber],1)" "$0
			#RecordTime[recordNumber]=run_utc_strftime("%Y-%m-%d %H:%M:%S",RecordTimeStamp[recordNumber])
			RecordTime[recordNumber]=mystrftime("%Y-%m-%d %H:%M:%S",RecordTimeStamp[recordNumber],1)
			RecordTimeStamp[recordNumber]=mymktime(mystrftime("%Y %m %d %H %M %S",RecordTimeStamp[recordNumber],1))
			if (RecordTimeStamp[recordNumber] >= startdate && RecordTimeStamp[recordNumber] <= enddate)
			{
				split(parse_line(logname,$0),array,SUBSEP)
				#use the timestamp of the record contents, TR WRNae17880
				if (logname ~ /^ALARM/) RecordContents[recordNumber]="AL    "
				else if (logname ~ /^EVENT/) RecordContents[recordNumber]="EV    "
				RecordContents[recordNumber]=RecordContents[recordNumber] array[2]
				if (csvoutput==1) CsvRecordContents[recordNumber]=array[3] #(mosdebug==1?";"recordNumber:"") ---> comment out this part because it causes lgx to give wrong result when mosdebug=1
				#print array[1],RecordTimeStamp[recordNumber],RecordTime[recordNumber]
				if (mosdebug==1) print startdate,mystrftime("%H%M%S",startdate,1),RecordTimeStamp[recordNumber],RecordTime[recordNumber],RecordContents[recordNumber],$0
			}
		}
		else if ($1=="<TimeStamp>") intimestamp=1
		else if (intimestamp==1)
		{
			#<year> 2006 </year> <month> 11 </month> <day> 28 </day>
			#<hour> 14 </hour> <minute> 20 </minute> <second> 11 </second>
			if ($1=="</TimeStamp>")
			{
				intimestamp=0
				if (!(recordNumber in RecordTime))
				{
					#we only assign a timestamp to a record who does not already have one, to avoid overwriting existing one.
					RecordTime[recordNumber]=sprintf("%s-%02d-%02d %02d:%02d:%02d",yy,month,dd,hh,mi,ss)
					RecordTimeStamp[recordNumber]=mymktime(sprintf("%s %s %s %s %s %s",yy,month,dd,hh,mi,ss))
				}
				continue
			}
			for (i=1 ; i<= NF ; i++)
			{
				if ($i == "<year>") yy=$(i+1)
				else if ($i == "<month>") month=$(i+1)
				else if ($i == "<day>") dd=$(i+1)
				else if ($i == "<hour>") hh=$(i+1)
				else if ($i == "<minute>") mi=$(i+1)
				else if ($i == "<second>") ss=$(i+1)
			}
		}
		else if (logname ~ /CELLO_WEBSERVER_LOG/)
		{
			#<CppCoreNodeRestart/>
			##<CppCoreTimeChange/>
			#AUTH.INFO: 2019-07-31T10:44:56Z a.b.c.d:40733 HTTPS User:- Request:GET /cello/oe/xml/CelloMOMRbs.xml HTTP/1.1 Status:200 Bytes:34974
			if ($1=="AUTH.INFO:")
			{
				split($2,array,/[TZ]/)
				RecordTime[recordNumber]=sprintf(array[1]" "array[2])
				RecordTimeStamp[recordNumber]=mymktime(gensub(/[-:]/," ","g",array[1]" "array[2]))
				sub(/^AUTH.INFO:[ \t]+[^ \t]+[ \t]+/,"AUTH.INFO: ")
			}
			if (RecordTimeStamp[recordNumber] >= startdate && RecordTimeStamp[recordNumber] <= enddate && $0~/<CppCore|AUTH.INFO:/)
			{
				if (/<CppCore/) gsub(/[<>/]/,"")
				RecordContents[recordNumber]="WEBS  "$0
				CsvRecordContents[recordNumber]="WEBS;"$0
			}
		}
		else if (logname ~ "IPTRAN" && $1=="<RecordContent>")
		{
			if (RecordTimeStamp[recordNumber] < startdate || RecordTimeStamp[recordNumber] > enddate) continue
			in_iptran=1
			RecordContents[recordNumber]="IPTR  "
			if (csvoutput==1) CsvRecordContents[recordNumber]="IPTR;"
		}
		else if (logname ~ "IPTRAN" && in_iptran==1)
		{
			if ($1=="</RecordContent>") { in_iptran=0 ; continue }
			if (/<OldTime>/) $0="OldTime:"
			else if (/<NewTime>/) $0="NewTime:"
			else if ($1=="<year>") $0=sprintf("%s-%02d-%02d",$2,$5,$8)
			else if ($1=="<hour>") $0=sprintf("%02d:%02d:%02d",$2,$5,$8)
			else if ($1 ~ /^<\//) continue
			else if ($1 ~ /<LogInfoRecord/) continue
			#this part messes up ipv6 addresses
			#else if (/.*:.*:.*:.*/)
			#{
			#	#MO RDN - ManagedElement=1,IpSystem=1,IpSec=1,IkePeer=1:Event name - AuthFail:Detailed information - authentication failed on peers side:Local IP Address - a.b.c.d:Remote IP Address - a.b.c.d:Local port - 500:Remote port - 500
			#	last=split($0,array,":")
			#	delete tmp_iptr
			#	for (i=1;i<=last;i++)
			#	{
			#		sub(/^(MO RDN|Event name|Detailed information) - (ManagedElement=1,IpSystem=1,)?/,"",array[i])
			#		sub(/ ?IP Address - /,"IP=",array[i])
			#		sub(/ ?port - /,"Port=",array[i])
			#	}
			#	#RecordContents[recordNumber]="IPTR  "
			#	for (i=1;i<=last;i++) RecordContents[recordNumber]=RecordContents[recordNumber] array[i]", "
			#	sub(/, $/,"",RecordContents[recordNumber])
			#	#Do not set RecordTime again since it is already know and by using mystrftime we will mess up the timestamp on solaris if it is in daylight saving time
			#	#RecordTime[recordNumber]=mystrftime("%Y-%m-%d %H:%M:%S",RecordTimeStamp[recordNumber],1)
			#	if (csvoutput==1)
			#	{
			#		#CsvRecordContents[recordNumber]="IPTR;"
			#		for (i=1;i<=last;i++) CsvRecordContents[recordNumber]=CsvRecordContents[recordNumber] array[i]";"
			#	}
			#}
			else
			{
				gsub(/^<[/]*|[/]*>$/,"",$1)
				$0=gensub(/^[ \t]*[:]*[ \t]*|[ \t]*$/,"","g",$0)
			}
			RecordContents[recordNumber]=RecordContents[recordNumber]" "$0
			if (csvoutput==1) CsvRecordContents[recordNumber]=CsvRecordContents[recordNumber]";"$0
			gsub(/^[ \t]*|[ \t]+$/,"",RecordContents[recordNumber])
			gsub(/^;+|;+$/,"",CsvRecordContents[recordNumber])
			gsub(/;;/,";",CsvRecordContents[recordNumber])
		}
		else if ($1=="<RecordContent>" && RecordTimeStamp[recordNumber] >= startdate && RecordTimeStamp[recordNumber] <= enddate) inrecordcontent=1
		else if (inrecordcontent==1)
		{
			if ($1=="</RecordContent>")
			{
				inrecordcontent=0
				if (logname ~ /AVAILABILITY/)
				{
					#sometimes the string RestartCompleted appears twice in a row
					sub(/RestartCompleted *RestartCompleted/,"RestartCompleted",avliAdd[recordNumber])
					#sometimes it shows "RestartCompleted Lrat RestartCompleted" instead of just: "Lrat RestartCompleted" . TR HV74915
					sub(/^RestartCompleted Lrat RestartCompleted/,"Lrat RestartCompleted",avliAdd[recordNumber])

					#  #####################################################################
					#  ##Commented out the below code, handled by the table foundAddInfo####
					#  #sometimes the following string appears twice in a row: Weighting factor: 100 percent, Existing CellIds: 6 5 4 3 2 1 , Cause: Transmission
					#  #Lrat Weighting factor: 33 percent, Existing CellIds: 5 4 1 , Cause: System, extended delay changes on CPRI
					#  match(avliAdd[recordNumber],/(Weighting factor: [^ ]+ percent, Existing CellIds: [ 0-9]+, Cause: [^ ]+).*(Weighting factor: [^ ]+ percent, Existing CellIds: [ 0-9]+, Cause: [^ ]+)/,ar)
					#  #print "debug1: "ar[1]"\ndebug2: "ar[2]
					#  if (ar[1]!="" && ar[2]!="" && ar[1]==ar[2]) sub(ar[1],"",avliAdd[recordNumber])
					#  match(avliAdd[recordNumber],/(Weighting factor: [^ ]+ percent, Existing CellIds: [ 0-9]+).*(Weighting factor: [^ ]+ percent, Existing CellIds: [ 0-9]+)/,ar)
					#  sub(/ +$/,"",ar[1]) ; sub(/ +$/,"",ar[2])
					#  #print "debug1: "ar[1]"x\ndebug2: "ar[2]"x"
					#  if (ar[1]!="" && ar[2]!="" && ar[1]==ar[2]) sub(ar[1],"",avliAdd[recordNumber])
					#  #####################################################################

					if (avliAdd[recordNumber] == "") avliAdd[recordNumber]=avliNoTag[recordNumber]
					if (avliSmn[recordNumber] != "") avliLnh[recordNumber]=sprintf("%02d%02d00",avliSmn[recordNumber],avliApn[recordNumber])
					if (avliProdNo[recordNumber] != "" && avliProdName[recordNumber]=="")
					{
						#avliProdName[recordNumber]=avliProdName[recordNumber]" "avliProdNo[recordNumber]"_"avliProdRev[recordNumber]
						#sub(/^ */,"",avliProdName[recordNumber])
						avliProdName[recordNumber]=avliProdNo[recordNumber]"_"avliProdRev[recordNumber]
					}
					tt=""
					if (avliHwAddress[recordNumber]!="") tt=" " avliHwAddress[recordNumber]
					avliMiddle[recordNumber]=sprintf("%2s  %-6s  %-10s%s  %s %s",avliPiu[recordNumber],avliLnh[recordNumber],avliProdName[recordNumber],tt,avliServType[recordNumber],avliServInstance[recordNumber])
					avliMiddle[recordNumber]=gensub(/^[ \t]*|[ \t]*$/,"","g",avliMiddle[recordNumber])
					if (avliType[recordNumber]=="") avliType[recordNumber]="NODE"
					RecordContents[recordNumber]=sprintf("%-4s",avliType[recordNumber])
					if (avliService[recordNumber] != "") RecordContents[recordNumber]=sprintf("%s  %-3s  %-15s",RecordContents[recordNumber],avliService[recordNumber],avliReason[recordNumber])
					if (avliMiddle[recordNumber] != "" ) RecordContents[recordNumber]=sprintf("%s  %-22s",RecordContents[recordNumber],avliMiddle[recordNumber])
					parsed_avliAdd[recordNumber] = avliAdd[recordNumber]
					if (avliAdd[recordNumber] ~ /^Load Module Version = @/)
					{
						# P2.1: Load Module Version = @(#)cr@@/main/ki_wil/292 CXC1323198 R17H01 2004-10-01 RncLmDh mp750 is now operational, activation cause = CELLO_CLI_ACTIVATE_CAUSE_NODESTART, RPU Id = 53
						# P3: Load Module Version = @(#)CXC1328011 R9H01 2005-04-11 23:49:47 MEST 93d6683d-09edad7b-5306 is now operational, activation cause = CELLO_CLI_ACTIVATE_CAUSE_NODESTART, RPU Id = 65
						# P4: Load Module Version = @(#)CXC1328825 R7B03 2005-05-04 02:03:30 MEST 93d66842-0a0acdd2-465a is now operational, activation cause = CELLO_CLI_ACTIVATE_CAUSE_NODESTART, RPU Id = 32
						sub(/20[0-9][0-9]-[01][0-9]-[0-3][0-9].*is now operational/,"is now operational",parsed_avliAdd[recordNumber])
						sub(/Load Module Version = .*CXC/,"CXC",parsed_avliAdd[recordNumber])
						sub(/activation cause = (CELLO_CLI_ACTIVATE_)*/,"",parsed_avliAdd[recordNumber])
						sub(/RPU Id = /,"RpuId=",parsed_avliAdd[recordNumber])
					}
					RecordContents[recordNumber]=sprintf("%s  %s",RecordContents[recordNumber],parsed_avliAdd[recordNumber])
					RecordContents[recordNumber]=appendCXCtranslation(RecordContents[recordNumber])
					if (csvoutput==1)
					{
						#last=split(avliMiddle[recordNumber],array," ")
						#if (last<=1) csvavliMiddle[recordNumber]=";;"
						#else if (last==2) csvavliMiddle[recordNumber]=gensub(/ +/,";","g",avliMiddle[recordNumber])";"
						#else csvavliMiddle[recordNumber]=gensub(/ +/,";","g",avliMiddle[recordNumber])
						#CsvRecordContents[recordNumber]=sprintf("%s;%s;%s;%s;%s;%s",recordNumber,avliType[recordNumber],avliService[recordNumber],avliReason[recordNumber],csvavliMiddle[recordNumber],avliAdd[recordNumber])
						CsvRecordContents[recordNumber]=appendCXCtranslation(sprintf("AV;%s;%s;%s",\
gensub(/ *$/,"",1,sprintf("%s %s %s",avliType[recordNumber],avliService[recordNumber],avliReason[recordNumber])),\
gensub(/ +/," ","g",avliMiddle[recordNumber]),avliAdd[recordNumber]))
					}
				}
				else if (logname ~ /SECURITY|AUDITTRAIL/)
				{
					if (logname ~ /SECURITY/) RecordContents[recordNumber]="SEC   "
					else if (logname ~ /AUDITTRAIL/) RecordContents[recordNumber]="COLI  "
					if (secUser[recordNumber] != "") RecordContents[recordNumber]=sprintf("%s%-12s %-21s %-30s %s%s",RecordContents[recordNumber],secUser[recordNumber],secEvent[recordNumber],secTerm[recordNumber],secInfo[recordNumber],secDn[recordNumber])
					else
					{
						if (secEvent[recordNumber] != "") RecordContents[recordNumber]=sprintf("%s%-15s ",RecordContents[recordNumber],secEvent[recordNumber])
						if (secTerm[recordNumber] != "") RecordContents[recordNumber]=sprintf("%s%-30s ",RecordContents[recordNumber],secTerm[recordNumber])
						if (secRemote[recordNumber] != "") RecordContents[recordNumber]=sprintf("%s%s",RecordContents[recordNumber],secRemote[recordNumber])
						if (secLocal[recordNumber] != "") RecordContents[recordNumber]=sprintf("%s%s",RecordContents[recordNumber],secLocal[recordNumber])
						if (secInfo[recordNumber] != "") RecordContents[recordNumber]=sprintf("%s%s",RecordContents[recordNumber],secInfo[recordNumber])
						if (secDn[recordNumber] != "") RecordContents[recordNumber]=sprintf("%s%s",RecordContents[recordNumber],secDn[recordNumber])
					}
					if (csvoutput==1)
					{
						if (logname ~ /SECURITY/) CsvRecordContents[recordNumber]="SEC"
						else if (logname ~ /AUDITTRAIL/) CsvRecordContents[recordNumber]="COLI"
						CsvRecordContents[recordNumber]=sprintf("%s;%s;%s;%s%s%s%s%s",CsvRecordContents[recordNumber],secUser[recordNumber],secTerm[recordNumber],secEvent[recordNumber],secRemote[recordNumber],secLocal[recordNumber],secInfo[recordNumber],secDn[recordNumber])
						#for debug: CsvRecordContents[recordNumber]=sprintf("%s;%s",CsvRecordContents[recordNumber],recordNumber)
					}
				}
				else if (logname ~ "RLIB_PM_LOG")
				{
					RecordContents[recordNumber]="RLIB  "gensub(/^ *| *$/,"","g",current_rlib_record)
					if (csvoutput==1) CsvRecordContents[recordNumber]="RLIB;"gensub(/^ *| *$/,"","g",current_rlib_record)
					current_rlib_record=""
				}
				else if (logname ~ "ROAM_GEO_LOG")
				{
					RecordContents[recordNumber]="GEOR  "gensub(/^ *| *$/,"","g",current_geor_record)
					if (csvoutput==1) CsvRecordContents[recordNumber]="GEOR;"gensub(/^ *| *$/,"","g",current_geor_record)
					current_geor_record=""
				}
			}
			else if (logname ~ /AUDITTRAIL/)
			{
				delete avliTable
				parse_line(logname,$0,avliTable)
				if (avliTable["user"] != "")       secUser[recordNumber]=avliTable["user"]
				if (avliTable["termname"] != "")   secTerm[recordNumber]=avliTable["termname"]
				if (avliTable["event"] != "")      secEvent[recordNumber]=avliTable["event"]
				if (avliTable["info"] != "")       secInfo[recordNumber]=" "avliTable["info"]
				if (avliTable["remotehost"] != "") secRemote[recordNumber]=avliTable["remotehost"]
				if (avliTable["local"] != "")      secLocal[recordNumber]=avliTable["local"]
				if (avliTable["dn"] != "")         secDn[recordNumber]=avliTable["dn"]
			}
			else if (logname ~ /SECURITY/)
			{
				delete avliTable
				parse_line(logname,$0,avliTable)
				if (avliTable["user"] != "")       secUser[recordNumber]=avliTable["user"]
				if (avliTable["termname"] != "")   secTerm[recordNumber]=avliTable["termname"]
				if (avliTable["event"] != "")
				{
					secEvent[recordNumber]=secEvent[recordNumber] " "avliTable["event"]
					sub(/^ +/,"",secEvent[recordNumber])
				}
				if (avliTable["info"] != "")       secInfo[recordNumber]=" ("avliTable["info"]")"
				if (avliTable["remotehost"] != "") secRemote[recordNumber]=avliTable["remotehost"]
				if (avliTable["local"] != "")      secLocal[recordNumber]=avliTable["local"]
				if (avliTable["dn"] != "")         secDn[recordNumber]=avliTable["dn"]
			}
			else if (logname ~ "AVAILABILITY")
			{
				delete avliTable
				parse_line(logname,$0,avliTable)
				if (avliTable["type"] != "") avliType[recordNumber]=avliTable["type"]
				if (avliTable["service"] != "") avliService[recordNumber]=avliTable["service"]
				if (avliTable["piu"] != "") avliPiu[recordNumber]=avliTable["piu"]
				if (avliTable["smn"] != "") avliSmn[recordNumber]=avliTable["smn"]
				if (avliTable["apn"] != "") avliApn[recordNumber]=avliTable["apn"]
				if (avliTable["reason"] != "") avliReason[recordNumber]=avliTable["reason"]
				if (avliTable["prodName"] != "") avliProdName[recordNumber]=avliTable["prodName"]
				if (avliTable["prodNo"]   != "") avliProdNo[recordNumber]=avliTable["prodNo"]
				if (avliTable["prodRev"]  != "") avliProdRev[recordNumber]=avliTable["prodRev"]
				if (avliTable["additionalInfo"] != "") avliAdd[recordNumber]=avliTable["additionalInfo"]
				if (avliTable["noTag"] != "") avliNoTag[recordNumber]=avliTable["noTag"]
				if (avliTable["serviceType"] != "") avliServType[recordNumber]=avliTable["serviceType"]
				if (avliTable["serviceInstance"] != "") avliServInstance[recordNumber]=avliTable["serviceInstance"]
				if (avliTable["HwAddress"] != "") avliHwAddress[recordNumber]=avliTable["HwAddress"]
			}
			else if (logname ~ /RLIB_PM_LOG|ROAM_GEO_LOG/)
			{
				gsub(/<.?LogInfoRecord>/,"")
				replace_xml_chars()
				if (/<OldTime>/) $0="OldTime:"
				if (/<NewTime>/) $0="NewTime:"
				if ($1=="<year>") $0=sprintf("%s-%02d-%02d",$2,$5,$8)
				if ($1=="<hour>") $0=sprintf("%02d:%02d:%02d",$2,$5,$8)
				if ($1 ~ /^<\//) continue
				gsub(/^<|[/]?>$/,"",$1)
				if (logname ~ "RLIB_PM_LOG") current_rlib_record=current_rlib_record" "gensub(/^ *| *$/,"","g",$0)
				else if (logname ~ "ROAM_GEO_LOG") current_geor_record=current_geor_record" "gensub(/^ *| *$/,"","g",$0)
			}
			else if (logname ~ "SON_EVENTLOG")
			{
				RecordContents[recordNumber]=son_logtype"   "$0
				if (csvoutput==1) CsvRecordContents[recordNumber]=son_logtype";"$0
			}
			#customPrint(sprintf("%s %s",RecordTime[recordNumber],RecordContents[recordNumber]))
			####timestamp[sprintf("%s %s",RecordTime[recordNumber],RecordContents[recordNumber])]=RecordTimeStamp[recordNumber]
		}
	}
	close(xml_log)
	maxRecordNumber=asort(recordNumberList)
	if (maxRecordNumber != recordNumberCount) customPrint("WARNING: maxRecordNumber="maxRecordNumber", different from recordNumberCount="recordNumberCount)

	#Uncomment the text below in order to get the output with record number in third field.
	#if (mosdebug==2)
	#{
	#	for (j=1;j<=maxRecordNumber;j++)
	#	{
	#		i=recordNumberList[j]
	#		if (RecordContents[i] != "")
	#		{
	#			if (csvoutput==1) customPrint(sprintf("%s;%s;%s",gensub(/ +/,";",1,RecordTime[i]),i,CsvRecordContents[i]))
	#			else customPrint(sprintf("%s %s %s",RecordTime[i],i,RecordContents[i]))
	#		}
	#	}
	#	customPrint("")
	#}
	if (reverse_sort==0)
	{
		for (j=1;j<=maxRecordNumber;j++)
		{
			i=recordNumberList[j]
			if (RecordContents[i] != "")
			{
				if (csvoutput==1) customPrint(sprintf("%s;%s",gensub(/ +/,";",1,RecordTime[i]),CsvRecordContents[i]))
				else customPrint(sprintf("%s %s",RecordTime[i],RecordContents[i]))
			}
		}
	}
	else
	{
		for (j=maxRecordNumber;j>=1;j--)
		{
			i=recordNumberList[j]
			if (RecordContents[i] != "")
			{
				if (csvoutput==1) customPrint(sprintf("%s;%s",gensub(/ +/,";",1,RecordTime[i]),CsvRecordContents[i]))
				else customPrint(sprintf("%s %s",RecordTime[i],RecordContents[i]))
			}
		}
	}

	#this method allows to sort the records in chronological order but we prefer to keep the records in order of record number since some records have the 1970 date
	#if chronological order is required then the user can use option "m": lgvm
	#for (j=1;j<=maxRecordNumber;j++)
	#{
	#	i=recordNumberList[j]
	#	if (RecordContents[i]=="") continue
	#	if (csvoutput==1) outputline=sprintf("%s;%s",gensub(/ +/,";",1,RecordTime[i]),CsvRecordContents[i])
	#	else outputline=sprintf("%s %s",RecordTime[i],RecordContents[i])
	#	outputLines[outputline]=outputline
	#}
	#n=asort(outputLines)
	#if (reverse_sort==0)
	#{
	#	for (j=1;j<=n;j++) customPrint(outputLines[j])
	#}
	#else
	#{
	#	for (j=n;j>=1;j--) customPrint(outputLines[j])
	#}

}
function piuToMo(piu,   a,sr,sl)
{
	#piu=0004 -> ManagedElement=1,Equipment=1,Subrack=MS,Slot=4
	sub(/^.*=/,"",piu)
	split(piu,a,"")
	if (a[2]=="0") sr="MS"
	else sr="ES"a[2]
	sl=sprintf("%d",a[3] a[4])
	return "ManagedElement=1,Equipment=1,Subrack="sr",Slot="sl
}
function parse_line(logtype,line,avliTable,  \
i,array,mo_instance,parsed_line,moInstance,cause,severityTable,problem,last,event,absoluteTime,notificationId,alarmType,moclass,moDn,\
additionalText,additionalInfo,addTextPos,alarmId,ackUser,ackState,nrAddInfoFields,z,addText,corrAlarms,foundAddInfo,nok)
{
	nok=0
	if (logtype ~ /^ALARM/)
	{
		last=split(line,array,";")
		#we don't check how many elements are in the line this way we can parse corrupted or incomplete records
		#if (last < 15) return ""
		moInstance=parseMoInstance(array[5])
		cause=causeTable[array[9]]
		parseSeverity(array[10],severityTable)
		problem=array[11]
		absoluteTime=array[7]
		if (csvoutput==1 || alarm_format>=1)
		{
			alarmType=parseAlarmType(array[2])
			moclass=array[4]
			moDn=array[5]
			notificationId=array[6]
			addTextPos=12+2*array[12]+1
			additionalText=array[addTextPos]
			alarmId=array[addTextPos+1]
			ackUser=array[addTextPos+2]
			ackState=array[addTextPos+4]
			nrAddInfoFields=array[addTextPos+6]
			if (nrAddInfoFields > 0)
			{
				for (i=(addTextPos+7);i<(addTextPos+7+2*nrAddInfoFields);i++)
				{
					additionalInfo=additionalInfo" | "array[i]": "array[i+1]
					i++
				}
				sub(/^ \| /,"",additionalInfo)
			}
			addText=gensub(/^ *| *$/,"","g",sprintf("%s %s",additionalText,additionalInfo))
			if (csvoutput==1 && array[12]>0)
			{
				corrAlarms=""
				for (i=13;i<=(12+2*array[12]);i++)
				{
					corrAlarms=corrAlarms", "array[i+1]" ("parseMoInstance(array[i])")"
					i++
					sub(/^, /,"",corrAlarms)
				}
			}
		}
		if (alarm_format==0) parsed_line=sprintf("%s%s%s %-35s %-25s %s",absoluteTime,SUBSEP,severityTable["one"],problem,cause,moInstance)
		else if (alarm_format>=1) parsed_line=sprintf("%s%s%s %-35s %-s %s",absoluteTime,SUBSEP,severityTable["one"],problem,moInstance,process_add_text(addText,problem,cause))
		#notificationId,severityTable["long"],alarmType,moclass,cause,problem,moInstance,moDn,additionalText,alarmId,ackUser,ackState,additionalInfo)
		if (csvoutput==1) parsed_line=sprintf("%s%sAL;%s;%s;%s;%s;%s;%s;%s;%s;%s",parsed_line,SUBSEP,severityTable["long"],moDn,problem,cause,addText,(ackState==2?"Unacknowledged":sprintf("Acknowledged by "ackUser)),alarmId,notificationId,corrAlarms)
	}
	else if (logtype ~ /^EVENT/)
	{
		last=split(line,array,";")
		#we don't check how many elements are in the line this way we can parse corrupted or incomplete records
		#if (last < 10) return ""

		moInstance=parseMoInstance(array[5]) #; print array[5],array[4],moInstance
		event=gensub(/^[ \t]*|\.*[ \t]*$/,"","g",array[9]". "array[10])
		if (array[12]>0)
		{
			for (z=1;z<=(array[12]*2);z++)
			{
				event=event". "gensub(/^ +|[,=]* +$/,"","g",array[12+z])"="gensub(/^ +| +$/,"","g",array[13+z])
				z++
			}
		}
		moclass=array[4]
		moDn=array[5]
		notificationId=array[6]
		absoluteTime=array[7]
		#if (csvoutput==1) parsed_line=sprintf("%s%s%s;%s;%s;%s;%s;%s",parsed_line,SUBSEP,absoluteTime,notificationId,moclass,event,moInstance,moDn)
		parsed_line=sprintf("%s%s%-40s %s",absoluteTime,SUBSEP,moInstance,event)
		if (csvoutput==1) parsed_line=sprintf("%s%sEV;;%s;%s",parsed_line,SUBSEP,moDn,event)
	}
	else if (logtype ~ /SECURITY|AUDITTRAIL/)
	{
		if (line ~ /<\//)
		{
			last=split(line,array," ")
			for (i=1;i<=last;i++)
			{
				if (array[i] ~ "<User>") avliTable["user"]=gensub("</User>","",1,array[i+1])
				else if (array[i] ~ "<Termname>") avliTable["termname"]=gensub("</Termname>","",1,array[i+1])
				else if (array[i] ~ "<Event>") avliTable["event"]=gensub(/^.*<Event> *| *<\/Event>.*$/,"","g",line)
				else if (array[i] ~ "<Info>")  avliTable["info"]= gensub(/^.*<Info> *| *<\/Info>.*$/,"","g",line)
				else if (array[i] ~ "<RemoteHost>") avliTable["remotehost"]="between "gensub(/ *<[^>]+> */,"","g",gensub(/ *<RemotePort> */,":",1,line))
				else if (array[i] ~ "<LocalPort>")  avliTable["local"]=" and localhost:"gensub(/ *<[^>]+> */,"","g",line)
				else if (array[i] ~ "<DN>" && line ~ "=") avliTable["dn"]=" DN: "gensub(/ *<[^>]+> */,"","g",line)
			}
		}
		else avliTable["event"]=gensub(/<LogInfoRecord>|^[\t ]*|[\t ]*$|<|<\/|>/,"","g",line)
	}
	else if (logtype=="CELLO_AVAILABILITY_LOG")
	{
		     if (/<ProgramEvent/)    avliTable["type"]="PGM"
		else if (/<NodeEvent/)       avliTable["type"]="NODE"
		else if (/<PlugInUnitEvent/) avliTable["type"]="PIU"
		else if (/<HardWareEvent/)   avliTable["type"]="HW"
		else if (/<ServiceEvent/)    avliTable["type"]="SERV"
		else if (/<OtherEvent/)      avliTable["type"]="OTHR"
		     if (/<OutOfService/)    avliTable["service"]="OUT"
		else if (/<InService/)       avliTable["service"]="IN"
		else if (/<PartiallyOut/)    avliTable["service"]="OUT_PARTIAL"
		if (/<PiuType>/ && $2 !~ /^</)            avliTable["piu"]=toupper($2)
		if (/<SwitchModuleNumber>/ && $2 !~ /^</) avliTable["smn"]=$2
		if (/<SwitchPortNumber>/ && $2 !~ /^</)   avliTable["apn"]=$2
		if (/<EventReason>/ && $2 !~ /^</)        avliTable["reason"]=$2
		if (/<ProdName>/ && $2 !~ /^</) avliTable["prodName"]=gensub(/^.*<ProdName> *| *<.ProdName>.*$|[ \t]/,"","g",$0)
		if (/<ProdNo>/   && $2 !~ /^</) avliTable["prodNo"]=gensub(/^.*<ProdNo> *| *<.ProdNo>.*$|[ \t]/,"","g",$0)
		if (/<ProdRev>/  && $2 !~ /^</) avliTable["prodRev"]=$2
		if (/<HwAddress>/&& $2 !~ /^</) avliTable["HwAddress"]=$2
		if (/<ServiceType>/ && $2 !~ /^</)
		{
			avliTable["serviceType"]=gensub(/<[^>]*>/,"","g",$0)
			gsub(/^ +| +$/,"",avliTable["serviceType"])
			gsub(/ +/," ",avliTable["serviceType"])
		}
		if (/<ServiceInstance>/ && $2 !~ /^</)
		{
			avliTable["serviceInstance"]=gensub(/<[^>]*>/,"","g",$0)
			gsub(/^ +| +$/,"",avliTable["serviceInstance"])
			gsub(/ +/," ",avliTable["serviceInstance"])
		}
		if (/<(CppCore|Rcs)NodeRestart\/>|<(CppCore|Rcs)TimeChange>|<(CppCore|Rcs)NodeDown>|<AdditionalInfo>|<AvailabilityInfo>/)
		{
			if (/<(CppCore|Rcs)NodeRestart\/>|<(CppCore|Rcs)TimeChange>/)
			{
				avliTable["additionalInfo"]=sprintf("%s %s",avliTable["additionalInfo"],gensub(/^.*<|\/*>.*$/,"","g",$0))
			}
			if (/<AdditionalInfo>|<AvailabilityInfo>|<(CppCore|Rcs)TimeChange>/)
			{
				while ((getline < xml_log)>0)
				{
					gsub("\r","") ; gsub("\x00","")
					replace_xml_chars()
					if (/<\/AdditionalInfo>|<\/AvailabilityInfo>|<\/NewTime>/) break

					#if (/<RestartRequested>/) nok=1
					#if (/<\/RestartRequested>/) nok=0
					#if (nok==1) continue
					if (/<RestartRequested>/) $0="Requested:"
					else if (/<RestartPerformed>/) $0="Performed:"

					if (/<ConfigurationVersion>/) gsub(/<ConfigurationVersion> */,"CV=")
					if (/<UpgradePackage>/) gsub(/<UpgradePackage> */,"UP=")
					if (/<Rank[A-Z][a-zA-Z]+\/>/) gsub(/<|>|\//,"")
					if (/<RcsNodeDown[/]?>/) gsub(/<|>|\//,"")
					if (/<RestartCompleted\/>/) sub(/<RestartCompleted\/>/,"RestartCompleted")
					if (/<(Tn|Cat|Lrat|Grat|Wrat|GNBDU)>/)
					{
						match($0,/<(Tn|Cat|Lrat|Grat|Wrat|GNBDU)>/,ar)
						sub(/<(Tn|Cat|Lrat|Grat|Wrat|GNBDU)>/," "ar[1]" ")
						#$0=gensub(/<(Tn|Cat|Lrat|Grat|Wrat)>/,"\\1",1,$0)
					}
					if (/<OldTime>/) $0="OldTime:"
					if (/<NewTime>/) $0="NewTime:"
					if ($1=="<year>") { if (NF>=8) $0=sprintf("%s-%02d-%02d",$2,$5,$8) ; else $0=$2 }
					if ($1=="<hour>") { if (NF>=8) $0=sprintf("%02d:%02d:%02d",$2,$5,$8) ; else $0=$2 }
					if ($1~"<(month|day)>") avliTable["additionalInfo"]=sprintf("%s-%02d",avliTable["additionalInfo"],$2)
					else if ($1~"<(minute|second)>") avliTable["additionalInfo"]=sprintf("%s:%02d",avliTable["additionalInfo"],$2)
					else
					{
						if (foundAddInfo[$0]==1) sub($0,"",avliTable["additionalInfo"])
						avliTable["additionalInfo"]=sprintf("%s %s",avliTable["additionalInfo"],$0)
						if ($0~/Weighting factor/)
						{
							#lines like this sometimes appear twice:
							#          <NodeInfo> Weighting factor: 100 percent, Existing CellIds: 1 4 , Cause: Manual </NodeInfo>
							foundAddInfo[$0]=1
						}
					}
				}
			}
			#gsub(/^[\t ]*|<\/AdditionalInfo>|<Cause> | <\/Cause>/,"",avliTable["additionalInfo"])
			gsub(/<[^<>]*>/,"",avliTable["additionalInfo"])
			gsub(/^ +| +$/,"",avliTable["additionalInfo"])
			gsub(/ +/," ",avliTable["additionalInfo"])
			delete foundAddInfo
		}
		if ($0 !~ /</ && NF > 0)  avliTable["noTag"]=gensub(/^[ \t]+/,"","g",$0)
	}
	return parsed_line
}
function parse_command_log(what,  array,cmd,ok,hh,mi,ss,yy,mo,dd,contents,i,date,time,j,a,array1,array2,flag,\
insetact,setactdata,maxLines,linecount,instruct,parse_moscript,timepos,logRec,a_t,n,logRecTable,userid,fullCmd,inCommand,inAction,inArray,inPrev,prevVal,termname)
{
	inPrev=0
	inCommand=0
	inAction=0
	inArray=0
	recordOffset=0
	if (xml_log ~ /.mo$/) parse_moscript=1
	close(xml_log)
	while ((getline < xml_log)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		replace_xml_chars()

		if (/MO-C *\*\*\* *CREATE CV:/ && make_timestamp($1,$2) >= startdate && make_timestamp($1,$2) <= enddate)
		{
			#2005-06-05 09:16:21 MO-C *** CREATE CV: Fi_CXP9012011_R7E04_050609_1621
			contents[++i]=$0
			logRecTable[i]=i
		}
		else if ($1=="<LogRecord")
		{
			#In audit_trail:  <LogRecord number = "14240">  the log can wrap around so we need to keep the same order as the record numbers
			logRec=gensub(/"|>/,"","g",$NF)+recordOffset
			if (logRec in logRecTable)
			{
				recordOffset+=100000
				logRec+=recordOffset
			}
			logRecTable[logRec]=logRec
			a_t=1
			#reinitialise the variables (for safety reasons we do it at several lines, in case one of these lines would be missing)
			parent=identity=motype=mo=action=setactdata=insetact=instruct=maxLines=linecount=date=time=cmd=mo=inPrev=prevVal=""
		}
		else if ($1=="<LogName>")
		{
			#<LogName> CORBA_AUDITTRAIL_LOG </LogName>
			#<LogName> PNP_LOG </LogName>
			if ($2=="PNP_LOG") flag="PNP " ; else flag="MO-A"
		}


		if ($1=="//")
		{
			#Ignore line such as: // TransactionId - 0
			if (NF < 7) continue
			#reinitialise the variables (for safety reasons we do it at several lines, in case one of these lines would be missing)
			parent=identity=motype=mo=action=setactdata=insetact=instruct=maxLines=linecount=date=time=cmd=mo=userid=inPrev=prevVal=termname=""
			#AUDIT_TRAIL:	// Unknown Tue Jun 7 2005, 17:38:01
			#AUDIT_TRAIL:   // nmsadm Fri Feb 9 2007, 06:06:04
			#corrupted log:      // nmsadm Fri
			#COMMANDLOG:	// pthread Fri Jun 24 2005 at 09:01:26 AM
			#COMMANDLOG:    // Unknown Wed Sep 21 2005 at 04:03:50 PM
			#COMMANDLOG:    // CN=RNC, OU=Cingular, O=Cingular Tue Jul 26 2005 at 05:22:23 PM
			ok=0
			userid=$2
			if ($NF ~ /^[0-9]/)
			{
				timepos=NF
				#flag="MO-A"  #audit_trail
			}
			else
			{
				timepos=NF-1
				#flag="MO-C"        #command log
			}
			if ($(timepos-1) !~ /^[0-9]/) a=1 ; else a=0
			if (!(mm[$(timepos-3-a)] != "" && wkday[$(timepos-4-a)] != "")) continue
			yy=gensub(/,/,"",1,$(timepos-1-a))
			mo=mm[$(timepos-3-a)]
			dd=$(timepos-2-a)
			date=sprintf("%4s-%02d-%02d",yy,mo,dd)
			split($timepos,array,":")
			hh=array[1] ; mi=array[2] ; ss=array[3] ;
			hh=fix_hour(hh,$NF)
			time=sprintf("%02d:%02d:%02d",hh,mi,ss)
			if (mymktime(sprintf("%s %s %s %s %s %s",yy,mo,dd,hh,mi,ss)) >= startdate && mymktime(sprintf("%s %s %s %s %s %s",yy,mo,dd,hh,mi,ss)) <= enddate) ok=1
			#print date,time,mymktime(sprintf("%s %s %s %s %s %s",yy,mo,dd,hh,mi,ss)),startdate,ok
			#initialise the temp variables
			dd=mo=yy=hh=mi=ss=""
		}
		else if (ok==1 || parse_moscript==1)
		{
			if (what ~ "q")
			{
				if ($1 ~ /^(CREATE|SET|ACTION|DELETE)$/)
				{
					if (parse_moscript==1) { logRec++ ; logRecTable[logRec]=logRec }
					if (date=="" && time=="") fullCmd[logRec]=$1
					else fullCmd[logRec]=sprintf("//%s %s %s\n%s",date,time,userid,$1)
					inCommand=1
					if ($1=="ACTION") inAction=1
				}
				else if ($1==")")
				{
					fullCmd[logRec]=fullCmd[logRec]" )"
					inCommand=0
					inAction=inArray=0
				}
				else if (inCommand==1 && $1!~ /^\//)
				{
					#must have quotes around the identity because it is a string
					if ($1=="identity") $2=sprintf("\"%s\"",gensub(/"/,"","g",$2))
					else if ($1=="Array" && inAction==1) inArray=1
					#a bug of corba audit trail that Reference is written in front of each element of the sequence on ACTION statements
					else if (inArray==1 && inAction==1 && $1=="Reference" && $2 ~ /^"ManagedElement=1,/) sub("Reference","")
					fullCmd[logRec]=fullCmd[logRec]" "gensub(/^[ \t]+|[ \t]+$/,"","g",$0)
				}
			}
			if ($1 !~ /^\/\// && parse_moscript != 1)
			{
				if ($1 ~ /^(CREATE|SET|ACTION|DELETE)$/)
				{
					cmd=translateCmd[$1]
					if ($1 ~ /^(SET|ACTION)$/) insetact=1
				}
				else if ($1=="parent" || $1=="Parent") parent=gensub(/"/,"","g",$2)
				else if ($1=="identity" || $1=="Identity") identity=gensub(/"/,"","g",$2)
				else if ($1=="moType" || $1=="MoType") motype=gensub(/"/,"","g",$2)
				else if ($1=="mo") mo=gensub(/"/,"","g",$2)
				else if ($1 ~ /^(exception|[nN]rOfParameters|[rR]eturnValue|Array|\(|Struct)$/) {}
				else if ($1 == "nrOfElements" || $1 == "NrOfElements")
				{
					instruct=1
					linecount=0
					maxLines=$2 + 0
				}
				else if ($1=="actionName" || $1=="ActionName") action=$2" "
				else if ($1==")")
				{
					if (a_t != 1) { i++ ; logRec=i ; logRecTable[logRec]=logRec }
					#order of the gsubs is very important
					gsub(/@;*/," ",setactdata)
					gsub(/  */," ",setactdata)
					sub(/[; ]*$/,"",setactdata)
					gsub(/;/,"|",setactdata)
					if (mo=="") mo=sprintf("%s,%s=%s",parent,motype,identity)
					gsub(/ManagedElement=1,/,"",mo)
					gsub(/ManagedElement=1,/,"",setactdata)
					gsub(/(SwManagement|TransportNetwork|Equipment)=1,/,"",setactdata)
						#gsub(/(SwManagement|TransportNetwork|Equipment|RncFunction|SystemFunctions|IpSystem|IpOam|NodeBFunction|AccessSignalling|InteractiveMessaging|MsProcessing|MgwApplication)=1,/,"",setactdata)
						#gsub(/(SwManagement|TransportNetwork|Equipment|RncFunction|SystemFunctions|IpSystem|IpOam|NodeBFunction|AccessSignalling|InteractiveMessaging|MsProcessing|MgwApplication)=1,/,"",mo)
					if (csvoutput==1) contents[logRec]=sprintf("%s;%s;%s;%s;%s;%-4s %s %s%s",date,time,flag,userid,"-",cmd,mo,action,setactdata)
					else contents[logRec]=sprintf("%s %s %s  %-4s %s %s%s",date,time,flag,cmd,mo,action,setactdata)
					#reinitialise the variables but save cmd
					lastcmd=cmd
					parent=identity=motype=mo=action=setactdata=insetact=instruct=maxLines=linecount=date=time=cmd=mo=inPrev=prevVal=""
				}
				else if (insetact==1 && NF >= 1)
				{
					#Types: Ref Reference String Integer Long Bool Float Array
					#SET format:
					#<attributeName> <type> <value>
					#   userLabel String "this is a string"
					#   admClasspath Array Reference 1
					#       ManagedElement=1,Equipment=1
					#ACTION format:
					#<parameter-type> <value>
					#       String "1 2 3"
					#       Array Reference 1
					#
					#PNP: attribute type can be S32 or BOOLEAN
					if (instruct==1)
					{
						linecount++
						if (linecount <= maxLines) setactdata=setactdata $1"="gensub(/^[ \t]*[^ \t]+[ \t]+[^ \t]+[ \t]*|"|[ \t]*$/,"","g",$0)";"
						if (linecount == maxLines) instruct=0
					}
					else if ($1 ~ /^(Ref|String|Int|Long|Bool|Float|Struct|Array|null$)/)
					{
						#it's a parameter of an action
						setactdata=setactdata gensub(/^ *[^ \t]+ +|"/,"","g",$0)";"
					}
					else if ($2 ~ /^(Ref|String|Int|Long|Bool|Float|Struct|Array|null$|S32$|BOOLEAN$)/)
					{
						#it's an attribute in set
						setactdata=setactdata $1 " "
						if ($2 !~ /^(Array|Struct)$/) setactdata=setactdata " "gensub(/^[ \t]*[^ \t]+[ \t]+[^ \t]+[ \t]*|"|[ \t]*$/,"","g",$0)";"
					}
					else if ($1=="NrOfAttributes" && $2==1) {}
					else setactdata=setactdata gensub(/^[ \t]*|[ \t]*$|"/,"","g",$0)";"
					#old code:
					#if (NF <= 2)
					#{
					#	if ($2 == "Struct") setactdata=setactdata $1 " "
					#	else setactdata=setactdata gensub(/"/,"","g",$NF)";"
					#}
					#else if (NF == 3)
					#{
					#	linecount++
					#	if (instruct==1 && linecount <= maxLines)
					#	{
					#		setactdata=setactdata $1"="gensub(/"/,"","g",$3)";"
					#		if (linecount==maxLines) instruct=0
					#	}
					#	else setactdata=setactdata $1" "gensub(/"/,"","g",$3)";"
					#}
					#else if (NF == 4) setactdata=setactdata $1"@"
				}
				else if (/<Result value="Failed"/) contents[logRec]=gensub(lastcmd,lastcmd"-FAIL",1,contents[logRec])
				else if (/<Termname>.*<\/Termname>/)
				{
					termname=gensub(/^.*<Termname> *| *<\/Termname>.*$/,"","g",$0)
					if (csvoutput==1) contents[logRec]=gensub(/;-;/,";"termname";",1,contents[logRec])
				}

				#<PreviousAttributeValue>
				# piuGroupNumber Integer 0
				# userLabel String ""
				#</PreviousAttributeValue>
				#else if (/<PreviousAttributeValue>/)
				#{
				#	inPrev=1
				#	prevVal=""
				#}
				#else if (inPrev==1)
				#{
				#	if (/<\/PreviousAttributeValue>/)
				#	{
				#		inPrev=0
				#		gsub(/^[| ]+|[| ]+$|\"/,"",prevVal)
				#		gsub(/[ \t]+/," ",prevVal)
				#		if (what!~"q") contents[logRec]=contents[logRec]" (Prev: "prevVal")"
				#	}
				#	else if ($2 ~ /^(Ref|String|Int|Long|Bool|Float|Struct|Array|null$)/)
				#	{
				#		prevVal=prevVal"|"gensub($2,"",1,$0)
				#	}
				#	else if ($1!~/^nrOfElements/) prevVal=prevVal" "$0
				#}
			}
		}
	}
	n=asort(logRecTable)
	if (what ~ "o")
	{
		if (csvoutput!=1 && parse_moscript!=1)
		{
			customPrint("\n======================================================================================================")
			customPrint(sprintf("%-19s %-3s   %s","Timestamp (UTC)","","Description"))
			customPrint("======================================================================================================")
		}
		if (reverse_sort==0)
		{
			for (j=1;j<=n;j++)
			{
				if (contents[logRecTable[j]] != "") customPrint(contents[logRecTable[j]])
			}
		}
		else
		{
			for (j=n;j>=1;j--)
			{
				if (contents[logRecTable[j]] != "") customPrint(contents[logRecTable[j]])
			}
		}
	}
	if (what ~ "q")
	{
		if (reverse_sort==0)
		{
			for (j=1;j<=n;j++)
			{
				if (fullCmd[logRecTable[j]] != "") customPrint(fullCmd[logRecTable[j]])
			}
		}
		else
		{
			for (j=n;j>=1;j--)
			{
				if (fullCmd[logRecTable[j]] != "") customPrint(fullCmd[logRecTable[j]])
			}
		}
	}
}

function parse_xb_logs(inputoptions,  i,xblogline,abs_time,xbmergelog,listfile,gzfile,gz_session,sort_session)
{
	severityMapping["info"]="INFO"
	severityMapping["notice"]="NOTE"
	severityMapping["warning"]="WARN"
	severityMapping["error"]="ERR"

	xbmergelog = tempdir"/xbmergelog"
	system( "rm -rf "xbmergelog )

	# 2011-08-12T13:29:01.221+0000 notice: run-parts(/etc/cron.every_minute)[25267]: finished logrotate
	# 2011-08-12T13:29:08.117+0000 info: kernel: ekernlink: pmcounter, Starting pm counter sca

	listfile = commandfile"/loglist"
	system("find "commandfile" -name \"*.gz\" -type f > "listfile)
	while (getline gzfile < listfile )
	{
		match(gzfile, /\/([0-9][0-9][0-9][0-9][0-9][0-9])\//,boardLnh)
		gz_session="gzip -c -d -f "gzfile
		while ((gz_session |& getline )>0)
		{
			gsub("\r","") ; gsub("\"","\\\"")
			# Reformat timestamp to match other lg entries
			xbTimestamp = gensub(/\.[0-9]+\+0+/,"","g",gensub(/T/," ","g",$1))
			# Some processes include script file names and PID in log entry, remove these
			xbWho = gensub(/\(.*\)/,"","g",gensub(/\[[0-9]+\]/,"","g",gensub(/:/,"","g",$3)))
			xbWhat = ""
			for (i=4;i<=NF;i++) xbWhat = xbWhat" "$i
			xblogline=sprintf("%-19s %-6s %-4s  %-15s %s",xbTimestamp,boardLnh[1],severityMapping[gensub(/:/,"","g",$2)],xbWho,xbWhat)
			abs_time=mymktime(gensub(/[-:]/," ","g",xbTimestamp))
			if (abs_time >= startdate && abs_time <= enddate) print xblogline >> xbmergelog
		}
		close(gz_session)
	}
	close(xbmergelog)
	if (fileOps("test -f " xbmergelog) != 0)
	{
		# No log files to parse
		return
	}
	customPrint("=============================================================================================================")
	customPrint(sprintf("%-19s %-6s %-4s  %-15s %s", "Timestamp (UTC)","Board","Sev","Who","Message"))
	customPrint("=============================================================================================================")
	sort_session="cat "xbmergelog" | sort"
	while ((sort_session |& getline )>0) customPrint($0)
	close(sort_session)
}

function parse_sys_log(  array,subarray,inrec,linecontents,bufferedlines)
{
	if (cpplinux==1)
	{
		parse_linux_sys_log()
		return
	}
	inrec=0
	while ((getline < xml_log)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if (/^recid=/)
		{
			last=split($0,array,",")
			for (i=1;i<=last;i++)
			{
				if (array[i] ~ /^severity=/) severity=gensub(/^.*=/,"",1,array[i])
				if (array[i] ~ /^time=/)
				{
					split(gensub(/^time=/,"",1,array[i]),arrayTime," ")
					mo=mm[arrayTime[1]]
					dd=arrayTime[2]
					yy=arrayTime[4]
					ti=arrayTime[3]
					split(ti,arrayTime,":")
					hh=arrayTime[1]
					mi=arrayTime[2]
					ss=arrayTime[3]
				}
			}
			inrec=1
			linecontents=""
		}
		else if (inrec==1)
		{
			if (!/,size=/)
			{
				#eg:
				#recid=0,format=STRING,event_type=0,facility=SYSLOG,uid=0,gid=0,pid=65566,pgrp=65547,severity=INFO,time=May 31 14:11:58 2005
				#Creating new crash information envelope:
				#  initiated by: smn=00, apn=10, suua=00
				#  reporting:    ecode=0xE9B8F0EF, restartDomain=BASIC, restartType=PROCESSOR
				#  generated:    pmdId=0xbdddfc0b.pmd,  date=05-05-31, time=14:11:41
				#,size=353
				if ($1 == "reporting:")
				{
					for (i=2;i<=4;i++) $i=gensub(/.*=|,/,"","g",$i)
					$0=$4"_"$3"_"$2
				}
				linecontents=linecontents" "gensub(/ +/," ","g",$0)
			}
			else
			{
				linecontents=linecontents" "gensub(/,size=.*$/,"",1,$0)
				sub(/^ +/,"",linecontents)
				if (linecontents ~ /Creating new crash information envelope:/)
				{
					sub(/Creating new crash information envelope:/,"Crash on",linecontents)
					gsub(/ *initiated by:|smn=|, apn=|, suua=| *reporting:| restart| *generated:|date=|time=/,"",linecontents)
				}
				linecontents=appendCXCtranslation(linecontents)
				if (csvoutput==1) description=sprintf("%s;SYS;%-4s;;%s",sprintf("%4s-%02d-%02d;%s",yy,mo,dd,ti),severity,linecontents)
				else description=sprintf("%s %-4s  %s",sprintf("%4s-%02d-%02d %s",yy,mo,dd,ti),severity,linecontents)
				#OLD CODE, where the entries with 1970 are attached to the last good timestamp
				#if (yy=="1970")
				#{
				#	if (previous_timestamp != "") timestamp[description]=previous_timestamp+1
				#	else timestamp[description]=mymktime(sprintf("%s %s %s %s %s %s",yy,mo,dd,hh,mi,ss))
				#}
				#else timestamp[description]=previous_timestamp=mymktime(sprintf("%s %s %s %s %s %s",yy,mo,dd,hh,mi,ss))
				#if (timestamp[description] >= startdate && timestamp[description] <= enddate)
				#	contents[timestamp[description]]=sprintf("%s%s%s",contents[timestamp[description]],SUBSEP,description)

				#NEW CODE, where the entries with 1970 are attached to the next good timestamp (same as in the function sortMerge)
				if (yy=="1970")
				{
					bufferedlines=bufferedlines SUBSEP description
					continue
				}
				else
				{
					#print gensub(SUBSEP,"\n","g",bufferedlines)"\n"line
					timestamp[description]=previous_timestamp=mymktime(sprintf("%s %s %s %s %s %s",yy,mo,dd,hh,mi,ss))
				}
				if (timestamp[description] >= startdate && timestamp[description] <= enddate)
				{
					contents[timestamp[description]]=sprintf("%s%s%s%s",contents[timestamp[description]],bufferedlines,SUBSEP,description)
				}
				bufferedlines=""
			}
		}
	}
	close(xml_log)
	#at the end we attach the buffered lines to the previous last (previous) record , while in the beginning we attach them to the next good record
	if (bufferedlines!="")
	{
		contents[previous_timestamp]=sprintf("%s%s",contents[previous_timestamp],bufferedlines)
		bufferedlines=""
	}
	n=asort(timestamp,dest)
	if (csvoutput!=1)
	{
		customPrint("======================================================================================================")
		customPrint(sprintf("%-19s %-3s   %s","Timestamp (UTC)","Sev","Description"))
		customPrint("======================================================================================================")
	}
	if (reverse_sort==0)
	{
		for (i=1;i<=n;i++)
		{
			if (dest[i] != dest[i-1])    # to remove duplicates
			{
				last=split(contents[dest[i]],array,SUBSEP)
				for (j=1;j<=last;j++)
				{
					if (array[j] != "") customPrint(array[j])
				}
			}
		}
	}
	else
	{
		for (i=n;i>=1;i--)
		{
			if (dest[i] != dest[i-1])    # to remove duplicates
			{
				last=split(contents[dest[i]],array,SUBSEP)
				for (j=1;j<=last;j++)
				{
					if (array[j] != "") customPrint(array[j])
				}
			}
		}
	}
}
function parse_linux_sys_log(  timestamp,oldtimestamp,idx,sev,message,i,tracelist,traceidx,entry,timearr,logdate,logtime)
{
     # Parse Linux style syslog:
     #  1   2     3      4     5         6            7                 8+
     # Mar  9 14:33:59 2015 oamhost local1.info SYS-EV-LOG[1139]: Node operational.
     # Mar  9 14:33:59 2015 oamhost local1.info SYS-EV-LOG[1139]: All PIU Devices operational after Node restart.
     # Mar  9 14:34:07 2015 oamhost local1.info SYS-EV-LOG[1228]: XB ( smn = 0, apn = 2 ) is operational, administrative state = UNLOCKED

     if (csvoutput!=1)
     {
	  customPrint("======================================================================================================")
	  customPrint(sprintf("%-19s %-4s   %s","Timestamp (UTC)","Sev","Description"))
	  customPrint("======================================================================================================")
     }

     while ((getline < xml_log)>0)
     {
	  gsub("\r","") ; gsub("\x00","")

	  # Timestamp for printing
	  logdate = sprintf("%s-%.02d-%.02d", $4, mm[$1], $2)
	  logtime = $3
	  timestamp = sprintf("%s %s", logdate, logtime)

	  # Timestamp for timespan filtering
	  split(logtime, timearr, /:/)
	  datefilter = mymktime(sprintf("%s %s %s %s %s %s",$4,mm[$1],$2,timearr[1],timearr[2],timearr[3]))

	  if( datefilter < startdate || datefilter > enddate )
	       continue

	  # If more than one trace entry has the same date and time, we add a sub index
	  if( timestamp == oldtimestamp || $4 ~ /1970/ ) idx++
	  else { idx = 0; oldtimestamp = timestamp }

	  # Trace severity
	  sev = toupper(gensub(/local1\./, "", 1, $6))

	  # Assemble log entry text
	  message = $8
	  for( i = 9; i <= NF; i++ )
	       message = message " " $i

	  # Set up unique array index based on date and time
	  # We will use "for in" to iterate over these in the correct order later
	  # If the year is 1970, we just increment the last good trace index, to keep these traces
	  # after the last ones with a "good" date
	  if( $4 ~ /1970/ )
	       traceidx = sprintf("%s%.04d", oldtimestamp, idx)
	  else
	       traceidx = sprintf("%s%.04d", timestamp, idx)

	  if (csvoutput != 1)
	       tracelist[traceidx] = sprintf("%-19s %-4s   %s",timestamp,sev,message)
	  else
	       tracelist[traceidx] = sprintf("%s;%s;SYS;%s;;%s",logdate,logtime,sev,message)
     }
     close(xml_log)

     # Control the behaviour of "for in"
     # https://www.gnu.org/software/gawk/manual/html_node/Controlling-Scanning.html
     old_sorted_in = PROCINFO["sorted_in"]

     if( reverse_sort == 0 )
	  PROCINFO["sorted_in"] = "@ind_num_asc"
     else
	  PROCINFO["sorted_in"] = "@ind_num_desc"

     # Print everything
     for( entry in tracelist )
	  customPrint( tracelist[entry] )

     PROCINFO["sorted_in"] = old_sorted_in
}
function parse_mgw_log(what,   ts,ok,d,t,a,sep,l,b)
{
	if (csvoutput==1) sep=";" ; else sep=" "
	ok=0
	startdate+=0
	enddate+=0
	customPrint("======================================================================================================")
	customPrint(sprintf("%-19s %s","Timestamp (UTC)","Description"))
	customPrint("======================================================================================================")
	close(xml_log)
	while ((getline < xml_log)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if (NF==0) continue
		#BGF/IPCS log
		#[2019-03-08 00:45:11] (112) CppCoreTimeChange, OldTime=2019-03-08 09:49:00, NewTime=2019-03-08 00:45:00
		#[2019-04-11 12:50:57] (2164) CppCoreNodeRestart

		#SwErrorAlarmLog (swea)
		#[2019-05-08 07:44:08] (1) EventId: 0; MO: ManagedElement=1,Equipment=1,AntennaUnitGroup=1,AntennaNearUnit=1; faultMessage: Timeout; faultId: 514; faultDescription: Timeout: Failed to get anuConnectIndication
		# 08:57:04:383;EventID:0;MO:ManagedElement=1,Equipment=1,SectorAntenna=1-1,AuxPlugInUnit=1,DeviceGroup=ATMAU,TmaDeviceSet=1,TmaDevice=1;faultMessage:;faultID:724;faultDescription:
		#2019-03-27 08:57:04:383;EventID:0;MO:ManagedElement=1,Equipment=1,SectorAntenna=1-1,AuxPlugInUnit=1,DeviceGroup=ATMAU,TmaDeviceSet=1,TmaDevice=1;faultMessage:;faultID:724;faultDescription:
		if ($1~/^\[/ && $2~/\]$/)
		{
			d=gensub(/^\[/,"",1,$1)
			t=gensub(/(\.[0-9]+)?\]$/,"",1,$2)
			ts=make_timestamp(d,t)+0
			l=gensub(/^[^\]]*\]/,"",1,$0)
		}
		else if (what=="swea" && $0~/;/)
		{
			split($0,a,";")
			split(a[1],b," ")
			d=b[1]
			t=b[2]
			ts=make_timestamp(d,t)+0
			l=gensub(/^[^;]*;/,"",1,$0)
		}
		#print "s="startdate,strftime("%Y%m%d",startdate)" ts="ts,strftime("%Y%m%d",ts)
		$0=d sep t sep toupper(what) sep l
		if (startdate!="" && ts>=startdate) ok=1
		if (enddate!="" && ts>enddate) ok=0
		if (ok==1) customPrint($0)
	}
	close(xml_log)
}

function sortMerge(inputvariables,   sep,word,line,array,currtime,lasttimestamp,includebp,inbp,last,z,d,t,bufferedlines)
{
	parse_inputvars(inputvariables)
	if (inputoptions ~ "i") reverse_sort=1 ; else reverse_sort=0
	if (inputoptions ~ "c") csvoutput=1 ; else csvoutput=0
	if (inputoptions ~ "%") includebp=1 ; else includebp=0
	xml_log=commandfile
	close(logfile)
	close(xml_log)
	if (csvoutput==1) sep=";" ; else sep=" "
	bufferedlines=""
	while (getline line < xml_log)
	{
		gsub("\r","",line)
		if (includebp==1 && inbp<2) last=split(line,array," ")
		if (includebp==1 && inbp<2 && array[1]=="Board" && array[last]=="BoardGroups") inbp=1
		if (includebp==1 && inbp==1) customPrint(line)
		if (includebp==1 && inbp==1 && array[1]=="Total:") inbp=2
		if (line ~ /^(Timestamp .UTC.|Timestamp +Type +|================================================================|Log close: .*mergeLog| *$)/)
		{
			#previous_timestamp=""
			bufferedlines=""
			continue
		}

		#Added the tag RcsNodeDown from 20.0e. Remove it for backward compatibility
		#2020-05-11 10:37:54 NODE  OUT  UnOperational    RankCold RcsNodeDown
		#2020-05-12 14:27:41 NODE  OUT  UnOperational    RankCold RcsNodeDown 2020-05-12 14:25:14
		#changed to:
		#2020-05-11 10:37:54 NODE  OUT  UnOperational    RankCold
		#2020-05-12 14:27:41 NODE  OUT  UnOperational    RankCold 2020-05-12 14:25:14
		gsub(/ RcsNodeDown/,"",line)

		#special case 2014-04-15 08:10:50 NODE  OUT  UnOperational    2014-04-15 08:10:25 , the real timestamp is at the end
		#in Gen2 there is the Rank as well: 2016-11-05 06:51:34 NODE  OUT  UnOperational    RankCold 2016-11-05 6:46:54. Note the timestamp could have one or two digits
		#in latest RCS SW there are some more fields after the date:
		#2021-03-22 13:20:22 NODE  OUT  UnOperational    RankWarm RcsNodeDown 2021-03-22 13:20:17 Requested: RankCold OperatorInitiated Cold Performed: RankCold Other PowerReset
		if (line ~ /NODE +OUT +UnOperational( +Rank[^ ]+)? +2[0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] +[0-9][0-9]?:[0-9][0-9]?:[0-9][0-9]?/)
		{
			#old: z=split(line,word," "); d=word[z-1]; t=word[z]
			match(line,/ +(2[0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]) +([0-9][0-9]?:[0-9][0-9]?:[0-9][0-9]?)/,word)
			d=word[1]
			t=word[2]
			split(line,word,sep)
		}
		else
		{
			split(line,word,sep)
			d=word[1] ; t=word[2]
		}
		split(d,array,"-")
		yy=array[1] ; mo=array[2] ; dd=array[3]
		split(t,array,":")
		hh=array[1] ; mi=array[2] ; ss=array[3]
		currtime=mymktime(sprintf("%s %s %s %s %s %s",yy,mo,dd,hh,mi,gensub(/\..*$/,"",1,ss)))
		#to make sure that "NODE OUT Unoperational" will not come before the "NODE OUT ShutDownCommand" we add +1 seconds to "Unoperational" and substract 5 seconds to "ShutdownCommand"
		#change: NODE OUT UnOperational should not be offset otherwise there is a risk that it comes after NODE IN Operational, so we substract 6 seconds instead to ShutdownCommand
		if (line ~ /ShutdownNodePhasedRestart|Node phased restart/)  currtime+=1   #|NODE +OUT +UnOperational( +Rank[^ ]+)? +2[0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] +[0-9][0-9]?:[0-9][0-9]?:[0-9][0-9]?
		else if (line ~ /NODE +OUT +ShutdownCommand +Rank/) currtime-=6
		else if (line ~ /HW +OUT +ShutdownCommand +(Baseband|DUS.2)/) currtime-=6
		currtime+=10000 #to make it positive since 1970 gives negative timestamp
		currtime*=1000
		if (ss~/\.[0-9][0-9][0-9]$/) currtime+=gensub(/^[0-9]+\./,"",1,ss)
		currtime=sprintf("%20.0f",currtime)
		if ((currtime+0)==9999000) timestamp[line]=lasttimestamp #a line without a timestamp
		#OLD CODE, attach the entries with invalid timestamp to latest good entry
		#else if (yy=="1970" && previous_timestamp != "")
		#{
		#	timestamp[line]=lasttimestamp=sprintf("%20.0f",previous_timestamp)
		#}
		#else
		#{
		#	timestamp[line]=previous_timestamp=lasttimestamp=currtime
		#}
		#record[timestamp[line]]=sprintf("%s%s%s",record[timestamp[line]],SUBSEP,line)
		#NEW CODE, attach the entries with invalid tiemstamp to next good entry
		else if ((yy=="1970") || (comcli>0 && yy~/^(2000|2010)$/)) #when date is unknown the year sometimes is 1970 (CPP) , 2000 or 2010 (COM)
		{
			bufferedlines=bufferedlines SUBSEP line
			continue
		}
		else
		{
			#print gensub(SUBSEP,"\n","g",bufferedlines)"\n"line
			timestamp[line]=lasttimestamp=previous_timestamp=currtime
		}
		record[timestamp[line]]=sprintf("%s%s%s%s",record[timestamp[line]],bufferedlines,SUBSEP,line)
		bufferedlines=""
		#print "DEBUG: "strftime("%Y-%m-%d %H:%M:%S",sprintf("%.0f",timestamp[line]/1000)),line
	}
	close(xml_log)
	#at the end we attach the buffered lines to the previous last (previous) record , while in the beginning we attach them to the next good record
	if (bufferedlines!="")
	{
		record[previous_timestamp]=sprintf("%s%s",record[previous_timestamp],bufferedlines)
		bufferedlines=""
	}
	n=asort(timestamp,dest)
	if (csvoutput!=1)
	{
		customPrint("======================================================================================================")
		customPrint(sprintf("%-19s %-4s  %s","Timestamp (UTC)","Type","Merged Log Entry"))
		customPrint("======================================================================================================")
	}
	if (reverse_sort==0)
	{
		for (i=1;i<=n;i++)
		{
			if (dest[i]!=dest[i-1] && dest[i] != -1)   #to remove duplicate and null timestamps
			{
				last=split(record[dest[i]],array,SUBSEP)
				for (j=1;j<=last;j++)
				{
					if (array[j] != "") customPrint(array[j])
				}
			}
		}
	}
	else
	{
		for (i=n;i>=1;i--)
		{
			if (dest[i]!=dest[i-1] && dest[i] != -1)   #to remove duplicates and null timestamps
			{
				last=split(record[dest[i]],array,SUBSEP)
				for (j=1;j<=last;j++)
				{
					if (array[j] != "") customPrint(array[j])
				}
			}
		}
	}
}

function parseValue(alarmString)
{
       valueString=gensub(/^[^=]+= */,"","g",alarmString)
       return valueString
}
function parseMoInstance(moInstance,   shortMoInstance,array,i,j,z)
{
	if (comcli>0)
	{
		#not works if the MO is like: ManagedElement,1,SystemFunctions,1,Licensing,1
		if (moInstance ~ /ManagedElement[^=]/) sub(/ManagedElement./,"ManagedElement=",moInstance)
		if (mom_version ~ /^(AXE_NODE_MODEL|BSC_NODE_MODEL)/ && moInstance !~ /,/) return moInstance
	}
	if (moInstance ~ /ManagedElement=[^,]+$/) return moInstance
	if (moInstance ~ /^[^,]+$/) return moInstance  #If the MO is a RDN, eg in alarm log of RCS
	if (moInstance !~ /ManagedElement=[^,]+,/) return moInstance  #e.g. yang MOs that dont start with ManagedElement
	if (yangcli>0) return moInstance
	split(moInstance,array,/ManagedElement=[^,]+,/)
	z=split(array[2], array, ",")
	if (z==1) shortMoInstance = array[1]
	else if (z==2) shortMoInstance = array[2]
	else if (z>2)
	{
		shortMoInstance = array[2]
		for (j=3;j<=z;j++)
		{
			shortMoInstance=sprintf("%s,%s",shortMoInstance,array[j])
		}
	}
	return shortMoInstance
}
function parseAlarmType(string)
{
	if (string=="x1")      return "ET_COMMUNICATIONS_ALARM"
	else if (string=="x2") return "ET_PROCESSING_ERROR_ALARM"
	else if (string=="x3") return "ET_ENVIRONMENTAL_ALARM"
	else if (string=="x4") return "ET_QUALITY_OF_SERVICE_ALARM"
	else if (string=="x5") return "ET_EQUIPMENT_ALARM"
}
function parseSeverity(severity,severityTable)
{
	     if (severity == "1")                                                   {severityTable["long"] = "Indeterminate" ; severityTable["short"]="?"       ; severityTable["one"]="?" }
	else if (severity == "2" || severity == "CRITICAL" || severity == "A1")     {severityTable["long"] = "Critical"      ; severityTable["short"]="Crit"    ; severityTable["one"]="C" ; Nr_of_crit++ }
	else if (severity == "3" || severity == "MAJOR"    || severity == "A2")     {severityTable["long"] = "Major"         ; severityTable["short"]="Maj"     ; severityTable["one"]="M" ; Nr_of_maj++}
	else if (severity == "4" || severity == "MINOR"    || severity == "A1")     {severityTable["long"] = "Minor"         ; severityTable["short"]="Min"     ; severityTable["one"]="m" }
	else if (severity == "5" || severity == "WARNING"  || severity ~ /^O[12]$/) {severityTable["long"] = "Warning"       ; severityTable["short"]="Warn"    ; severityTable["one"]="w" }
	else if (severity == "6" || severity == "CLEARED"  || severity == "CLEAR")  {severityTable["long"] = "Cleared"       ; severityTable["short"]="Cleared" ; severityTable["one"]="*" }
}
function make_alarm_severity_table()
{
	alarm_severity_table[1]="?"
	alarm_severity_table[2]="CRIT"
	alarm_severity_table[3]="MAJOR"
	alarm_severity_table[4]="MINOR"
	alarm_severity_table[5]="WARN"
	alarm_severity_table[6]="CLEAR"
}

####################################################################################################################
# CV-FILTER
####################################################################################################################
function cvfilter_function(  date,time,short_time,timestamplist,tmptime)
{
	Define_months()
	customPrint("\n==========================================================================================================================")
	customPrint(sprintf("%-40s  %-16s  %-20s  %-12s  %-15s  %s","CV Name","Creation Date","Package","Type","Operator","Comment"))
	customPrint("==========================================================================================================================")
	while ((getline < "-")>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if (/Name:/) cvname=sprintf("%-40s",$2)
		else if (/Date:/)
		{
			#Date: Thu Jan  1 00:11:59 1970
			date=sprintf("%4s-%02d-%02d",$6,mm[$3],$4)
			time=$5
			short_time=gensub(/:[0-9]+$/,"",1,time)
			tmptime=make_timestamp(date,time)
			if (tmptime in timestamplist) tmptime+=0.1  #to avoid several CVs with the same timestamp, otherwise they are printed twice
			timestamplist[tmptime]=1
			timestamp[cvname]=tmptime
			cvdate[cvname]=date" "short_time
			#print cvdate[cvname]
		}
		else if (/Package upgrade:/ )
		{
			#Package upgrade: no value (upgrade package id)
			package=""
			if ($0 ~ /no value/) {n=4} else n=NF
			for (i=3; i<=n ; i++) package=package" "$i
			sub(/^ */,"",package)
			cvpackage[cvname]=sprintf("%-20s",package)
		}
		else if (/Operator:/ )
		{
			operator=""
			#if ($0 ~ /no value/) {n=3 }else n=NF
			for (i=2;i<=3;i++) operator=operator" "$i
			sub(/^ */,"",operator)
			cvoperator[cvname]=sprintf("%-15s",operator)
		}
		else if (/Comment:/ )
		{
			comment=""
			if ($0 ~ /no value/) {n=3 } else n=NF
			for (i=2;i<=n;i++) comment=comment" "$i
			comment=gensub(/^ */,"","g",comment)
			cvcomment[cvname]=sprintf("%s",gensub(/created at System Upgrade./,"","g",comment))
		}
		else if (/Type:/)
		{
			cvtype[cvname]=sprintf("%-12s",$2)
		}
	}
	close("-")
	n=asort(timestamp,dest)
	for (i=1;i<=n;i++)
	{
		for (j in timestamp)
		{
			if (dest[i]==timestamp[j])
			{
				customPrint(sprintf("%s  %s  %s  %s  %s  %s",j,cvdate[j],cvpackage[j],cvtype[j],cvoperator[j],cvcomment[j]))
			}
		}
	}
	customPrint(sprintf("\n>>> Total: %s CV\x27s\n",n))
}

####################################################################################################################
# STR FUNCTIONS
####################################################################################################################
function cdmareport_function(inputvariables)
{
	parse_inputvars(inputvariables)
	inputfile=commandfile
	while ((getline < inputfile)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		#Aal5TpVccTp=BHRBS1_Backhaul_BHSBackhaulSpan_1_IpAtm       vclTpId            AtmPort=BHRBS1_Backhaul_BHSBackhaulSpan_1,VplTp=1,VpcTp=1,VclTp=BHRBS1_BackhaulIpAtm
		if ($2=="vclTpId") atmport[$1]=gensub(/,.*$/,"",1,$3)
		#UniSaalTp=BHRBS1_Backhaul_BHSBackhaulSpan_1_Qaal2         aal5TpVccTpId      Aal5TpVccTp=BHRBS1_Backhaul_BHSBackhaulSpan_1_Qaal2
		else if ($2=="aal5TpVccTpId") atmport[$1]=atmport[$3]
		#BackhaulConnections=1,Backhaul=RBS1_Backhaul,AbisCommonProc=1   PriUniSaalTpRef    UniSaalTp=BHRBS1_Backhaul_BHSBackhaulSpan_1_ComProc
		#BackhaulConnections=1,Backhaul=RBS1_Backhaul,AbisCommonProc=1   SecUniSaalTpRef
		else if ($2=="PriUniSaalTpRef") atmport1[gensub(/^[^,]+,|,[^,]+$/,"","g",$1)]=atmport[$3]
		else if ($2=="SecUniSaalTpRef") atmport2[gensub(/^[^,]+,|,[^,]+$/,"","g",$1)]=atmport[$3]
		#  15                 1 (ENABLED)   BscTransportNetwork=1,BackhaulConnections=1,Backhaul=RBS1_Backhaul,AbisDedicatedProc=1
		#  16                 1 (ENABLED)   BscTransportNetwork=1,BackhaulConnections=1,Backhaul=RBS1_Backhaul,AbisCommonProc=1
		else if ($NF ~ /AbisCommon/) abisCstate[gensub(/^.*BackhaulConnections=[^,]+,|,Abis.*$/,"","g",$NF)]=$2
		else if ($NF ~ /AbisDed/)    abisDstate[gensub(/^.*BackhaulConnections=[^,]+,|,Abis.*$/,"","g",$NF)]=$2
		#MyIS2000BSS=1,Site=96,Cell=3,CDMAChannel=2                BackhaulRef        BackhaulConnections=1,Backhaul=RBS1_Backhaul
		else if ($2=="BackhaulRef")
		{
			site=gensub(/^[^,]+,|,Cell=.*$/,"","g",$1)
			backh=gensub(/^[^,]+,/,"",1,$3)
			atmport1[site]=atmport1[backh]
			if (atmport2[backh] != atmport1[backh]) atmport2[site]=atmport2[backh]
			abisCstate[site]=abisCstate[backh]
			abisDstate[site]=abisDstate[backh]
			backhaul[site]=gensub(/^.*=/,"",1,$3)
		}
		#3662   1 (UNLOCKED)  1 (ENABLED)   RAN=1,MyIS2000BSS=1,Site=96,Cell=3,CDMAChannel=2
		else if ($NF ~ /CDMAChannel/)
		{
			if ($2==1 && $4==1) tempState=1
			else if ($2==0) tempState="L"
			else if ($2==1 && $4==0) tempState=0
			else tempState="?"
			split($NF,array,",")
			if (tempState != 1)
			{
				downList[array[3]]=array[3]
				nr_of_channels_down++
			}
			tot_nr_of_channels++
			channelState[array[3],gensub(/Cell=/,"",1,array[4]),gensub(/CDMAChannel=/,"",1,array[5])]=tempState
			siteList[array[3]]=array[3]
		}
	}
	close(inputfile)
	n=asort(siteList)
	for (i in siteList) tot_nr_of_sites++
	for (i in downList) nr_of_sites_down++
	for (i=1;i<=n;i++)
	{
		site=siteList[i]
		if (downList[site] == site) continue
		else make_cdmareport_output()
	}
	customPrint("-------------------------------------------------------------------")
	for (i=1;i<=n;i++)
	{
		site=siteList[i]
		if (downList[site] != site) continue
		else make_cdmareport_output()
	}
	customPrint("===================================================================")
	nr_of_channels_up=tot_nr_of_channels - nr_of_channels_down
	nr_of_sites_up   =  tot_nr_of_sites - nr_of_sites_down
	customPrint(sprintf("Channel availability: %3s of %3s channels are up (% 3.1f%)",nr_of_channels_up,tot_nr_of_channels,100*nr_of_channels_up/tot_nr_of_channels))
	customPrint(sprintf("Site    availability: %3s of %3s sites    are fully up (% 3.1f%)",nr_of_sites_up,tot_nr_of_sites,100*nr_of_sites_up/tot_nr_of_sites))
}
function make_cdmareport_output()
{
	output=sprintf("%-15s",gensub(/Site=/,"",1,site))
	for (j=1;j<=3;j++)
	{
		output=sprintf("%s  ",output)
		for (k=1;k<=2;k++)
		{
			output=sprintf("%s%1s",output,channelState[site,j,k])
		}
	}
	output=sprintf("%s  %1s%1s    %-20s  %-35s  %s",output,abisCstate[site],abisDstate[site],backhaul[site],gensub(/AtmPort=/,"",1,atmport1[site]),gensub(/AtmPort=/,"",1,atmport2[site]))
	customPrint(output)
}
function make_tnport(ldn)
{
	if (ldn !~ /Subrack=/) return ldn
	gsub(/^.*Subrack=|,PlugInUnit=.*$/,"",ldn)
	sub(/^ES-/,"ES",ldn)
	sub(/,Slot=/,"-",ldn)
	return ldn
}
function cellreport_function(inputvariables)
{
	li=length("IUBLINK")
	lcs=length("CELLNAMES")
	parse_inputvars(inputvariables)
	inputfile=commandfile
	iredTranslation[0]="N" ; iredTranslation[1]="P" ; iredTranslation[2]="S"
	iredTranslation[3]="G" ; iredTranslation[4]="A" ; iredTranslation[5]="I"
	if (inputoptions ~ "c")
	{
		csv=1
		csvfile=currentDir
		close(csvfile)
	}
	else csv=0
	if (inputoptions ~ "1") cellformat=1
	else if (inputoptions ~ "2") cellformat=2
	else if (inputoptions ~ "3") cellformat=3
	else cellformat=0
	if (cellformat==3)
	{
		lim1=12 ; lim2=24 ; lim3=36
		start1=13 ; start2=25 ; start3=37
	}
	else
	{
		lim1=6 ; lim2=12 ; lim3=18
		start1=7 ; start2=13 ; start3=19
	}

	nr_of_iubs_down=nr_of_iubs_unknown=nr_of_cells_locked=nr_of_cells_down=nr_of_cells_locked=nr_hs_up=nr_hs_tot=nr_eul_up=nr_eul_tot=nr_eulf_up=nr_eulf_tot=0
	modConversionMethod="old"
	while ((getline < inputfile)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		#Aal5TpVccTp=csb                                           vclTpId            AtmPort=MS-26-1,VplTp=vp2,VpcTp=1,VclTp=vc34
		if ($2=="vclTpId") atmport[$1]=gensub(/,.*$/,"",1,$3)":"gensub(/^.*VplTp=|,VpcTp=.*$/,"","g",$3)
		#UniSaalTp=b63ca                                           aal5TpVccTpId      Aal5TpVccTp=b63ca
		else if ($2=="aal5TpVccTpId") atmport[$1]=atmport[$3]
		#IubLink=1002,NbapCommon=1                                 activeUniSaalTpRef  UniSaalTp=b63ca
		#IubLink=1002,NbapCommon=1                                 standbyUniSaalTpRef  UniSaalTp=b63cb
		else if ($2=="activeUniSaalTpRef") atmport1[gensub(/^IubLink=|,.*$/,"","g",$1)]=gensub(/^AtmPort=/,"",1,atmport[$3])
		else if ($2=="standbyUniSaalTpRef")
			if (gensub(/^AtmPort=/,"",1,atmport[$3]) != atmport1[gensub(/^IubLink=|,.*$/,"","g",$1)])
				atmport2[gensub(/^IubLink=|,.*$/,"","g",$1)]=gensub(/^AtmPort=/,"",1,atmport[$3])
		#IubLink=3045990                                           rncModuleRef       RncModule=4
		#UtranCell=Iub-40-1                                      localCellId       1118
		#IubLink=3045990                                           reservedBy         [3] =
		# >>> reservedBy = RncFunction=1,UtranCell=30459901
		# >>> reservedBy = RncFunction=1,UtranCell=30459902
		# >>> reservedBy = RncFunction=1,UtranCell=30459903
		# 311   1 (UNLOCKED)  1 (ENABLED)   RncFunction=1,UtranCell=30390202,Rach=1
		#1340   1 (UNLOCKED)  1 (ENABLED)   RncFunction=1,UtranCell=30531102
		#
		#Up to P5:    1   0 (LOCKED)    0 (DISABLED)  RncFunction=1,IubLink=3045990,NodeSynchTp=2
		#From P6 :    7                 1 (ENABLED)   RncFunction=1,IubLink=1002,NodeSynch=1
		#RncModule=7                                               programInstanceId  0
		#RncModule=7                                               rpuRefs            [4] =
		# >>> rpuRefs = SwManagement=1,ReliableProgramUniter=rnc_dh_7
		if ($2=="programInstanceId" && $1 ~ /^RncModule=/)
		{
			if ($3 > 0) modConversionMethod="new" ; else modConversionMethod="old"
		}
		else if ($2=="rpuRefs" && $1 ~ /^RncModule=/)
		{
			currentModule=$1
			tmpRncModNumber=convert_modname_tonumber(currentModule,modConversionMethod)
			rncModuleList[tmpRncModNumber]=tmpRncModNumber
			rncModuleNumber[currentModule]=tmpRncModNumber
			rncModuleName[tmpRncModNumber]=gensub(/^.*=/,"",1,currentModule)
		}
		#else if ($2=="rpuRefs" && $1 ~ /^RncModule=/)
		#{
		#	currentModule=$1
		#	tmpRncModNumber=gensub(/^.*=/,"",1,$1)+0
		#	if ($1 ~ /RncModule=.*[-A-Z].*$/)
		#	{
		#		#WRNae73332 , sometimes rpuRefs is not set: RncModule=MS-6-0       rpuRefs           [0] =
		#		if (gensub(/\[|\]/,"","g",$3)+0 == 0) tmpRncModNumber=convert_modname_tonumber($1,modConversionMethod)
		#	}
		#	if (tmpRncModNumber > 0) rncModuleNumber[$1]=tmpRncModNumber
		#}
		#else if (tmpRncModNumber==0 && $1==">>>" && $2=="rpuRefs")
		#{
		#	tmpRncModNumber=gensub(/^.*_/,"",1,$4)
		#	if (tmpRncModNumber+0 > 0) tmpRncModNumber+=0
		#	else tmpRncModNumber=convert_modname_tonumber(tmpRncModNumber,modConversionMethod)
		#	rncModuleNumber[currentModule]=tmpRncModNumber
		#}
		else if ($2=="rncModuleRef" && $1 ~ /^IubLink=/)
		{
			iub=gensub(/^IubLink=/,"","g",$1)
			l_iub=length(iub)
			if (maxCellList[iub] > lim1) l_iub+=2
			if (l_iub > li) li=l_iub
			if (maxCellList[iub] > lim1)
			{
				iubList[iub"%1"]=iub"%1"
				iubList[iub"%2"]=iub"%2"
				largeIubList[iub]=1
				if (maxCellList[iub] > lim2) { iubList[iub"%3"]=iub"%3" ; largeIubList[iub]=2 }
				if (maxCellList[iub] > lim3) { iubList[iub"%4"]=iub"%4" ; largeIubList[iub]=3 }
			}
			else iubList[iub]=iub
			mod[iub]=rncModuleNumber[$3]+0
			if (maxCellList[iub] > lim1) mod[iub"%1"]=mod[iub"%2"]=mod[iub]
			if (maxCellList[iub] > lim2) mod[iub"%3"]=mod[iub]
			if (maxCellList[iub] > lim3) mod[iub"%4"]=mod[iub]
			if (mod[iub] > maxMod) maxMod=mod[iub]
			mod_list[mod[iub]]=1
			nr_of_iubs++
		}
		else if ($2=="localCellId" && $1 ~ /^UtranCell=/)
		{
			localCellId[gensub(/^.*=/,"",1,$1)]=$3
		}
		else if ($1~/IubLink=/ && $2~/^[01]$/ && $4~/^[01]$/)
		{
			#MO               atm       ipv4
			#IubLink=Iub-1    1 (TRUE)  0 (FALSE)
			show_tn=1
			iub=gensub(/^IubLink=/,"",1,$1)
			if (!(iub in tn))
			{
				if ($2==1 && $4==1) tn[iub]="AI"
				else if ($2==0 && $4==1) tn[iub]=" I"
				else if ($2==1 && $4==0) tn[iub]="A "
			}
			else if ((tn[iub]=="A " && $4==1) || (tn[iub]==" I" && $2==1)) tn[iub]="AI"
		}
		else if ($2=="reservedBy"  && $1 ~ /^IubLink=/)
		{
			iub=gensub(/^IubLink=/,"","g",$1)
			split($3,array,/\[/)
			split(array[2],array,/\]/)
			delete cellListTable
			delete revCellListTable
			if (array[1]==0) down[iub]=1
			for (i=1;i<=array[1];i++)
			{
				# >>> reservedBy = RncFunction=1,UtranCell=10011
				getline < inputfile ; gsub("\r","")
				cellMoId=gensub(/^.*UtranCell=/,"","g",$0)
				cellListTable[cellMoId]=localCellId[cellMoId]
				revCellListTable[localCellId[cellMoId]]=cellMoId
			}
			maxCell=asort(cellListTable)
			if (maxCell > maxCellsPerIub) maxCellsPerIub=maxCell
			if (maxCell > lim1) tmpMaxCell=lim1 ; else tmpMaxCell=maxCell
			maxCellList[iub]=maxCell
			if (maxCell > lim1) iub=iub"%1"
			for (i=1;i<=tmpMaxCell;i++)
			{
				currentCell=revCellListTable[cellListTable[i]]
				lastDigit=substr(currentCell,length(currentCell),length(currentCell))
				if (i==1)
				{
					cell1[iub]=currentCell
					cellname[iub]=gensub(/.$/,"",1,cell1[iub])
					cellname[iub]=sprintf("%s-%s",cellname[iub],lastDigit)
				}
				else if (i==2)
				{
					cell2[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==3)
				{
					cell3[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==4)
				{
					cell4[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==5)
				{
					cell5[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==6)
				{
					cell6[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (cellformat==3)
				{
					if (i==7)
					{
						cell7[iub]=currentCell
						cellname[iub]=gensub(/.$/,"",1,cell7[iub])
						cellname[iub]=sprintf("%s-%s",cellname[iub],lastDigit)
					}
					else if (i==8)
					{
						cell8[iub]=currentCell
						cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
					}
					else if (i==9)
					{
						cell9[iub]=currentCell
						cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
					}
					else if (i==10)
					{
						cell10[iub]=currentCell
						cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
					}
					else if (i==11)
					{
						cell11[iub]=currentCell
						cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
					}
					else if (i==12)
					{
						cell12[iub]=currentCell
						cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
					}
				}
				if (length(currentCell) > lc) lc=length(currentCell)
				if (length(cellname[iub]) > lcs) lcs=length(cellname[iub])
			}
			if (maxCell > lim1) iub=gensub(/%1$/,"",1,iub)"%2"
			for (i=start1;i<=maxCell;i++)
			{
				currentCell=revCellListTable[cellListTable[i]]
				lastDigit=substr(currentCell,length(currentCell),length(currentCell))
				if (i==(lim1+1))
				{
					cell1[iub]=currentCell
					cellname[iub]=gensub(/.$/,"",1,cell1[iub])
					cellname[iub]=sprintf("%s-%s",cellname[iub],lastDigit)
				}
				else if (i==(lim1+2))
				{
					cell2[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==(lim1+3))
				{
					cell3[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==(lim1+4))
				{
					cell4[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==(lim1+5))
				{
					cell5[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==(lim1+6))
				{
					cell6[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (cellformat==3)
				{
					if (i==(lim1+7))
					{
						cell7[iub]=currentCell
						cellname[iub]=gensub(/.$/,"",1,cell7[iub])
						cellname[iub]=sprintf("%s-%s",cellname[iub],lastDigit)
					}
					else if (i==(lim1+8))
					{
						cell8[iub]=currentCell
						cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
					}
					else if (i==(lim1+9))
					{
						cell9[iub]=currentCell
						cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
					}
					else if (i==(lim1+10))
					{
						cell10[iub]=currentCell
						cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
					}
					else if (i==(lim1+11))
					{
						cell11[iub]=currentCell
						cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
					}
					else if (i==(lim1+12))
					{
						cell12[iub]=currentCell
						cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
					}
				}
				if (length(currentCell) > lc) lc=length(currentCell)
				if (length(cellname[iub]) > lcs) lcs=length(cellname[iub])
			}
			if (maxCell > lim2) iub=gensub(/%2$/,"",1,iub)"%3"
			for (i=start2;i<=maxCell;i++)
			{
				currentCell=revCellListTable[cellListTable[i]]
				lastDigit=substr(currentCell,length(currentCell),length(currentCell))
				if (i==13)
				{
					cell1[iub]=currentCell
					cellname[iub]=gensub(/.$/,"",1,cell1[iub])
					cellname[iub]=sprintf("%s-%s",cellname[iub],lastDigit)
				}
				else if (i==14)
				{
					cell2[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==15)
				{
					cell3[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==16)
				{
					cell4[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==17)
				{
					cell5[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==18)
				{
					cell6[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				if (length(currentCell) > lc) lc=length(currentCell)
				if (length(cellname[iub]) > lcs) lcs=length(cellname[iub])
			}
			if (maxCell > lim3) iub=gensub(/%3$/,"",1,iub)"%4"
			for (i=start3;i<=maxCell;i++)
			{
				currentCell=revCellListTable[cellListTable[i]]
				lastDigit=substr(currentCell,length(currentCell),length(currentCell))
				if (i==19)
				{
					cell1[iub]=currentCell
					cellname[iub]=gensub(/.$/,"",1,cell1[iub])
					cellname[iub]=sprintf("%s-%s",cellname[iub],lastDigit)
				}
				else if (i==20)
				{
					cell2[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==21)
				{
					cell3[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==22)
				{
					cell4[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==23)
				{
					cell5[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				else if (i==24)
				{
					cell6[iub]=currentCell
					cellname[iub]=sprintf("%s/%s",cellname[iub],lastDigit)
				}
				if (length(currentCell) > lc) lc=length(currentCell)
				if (length(cellname[iub]) > lcs) lcs=length(cellname[iub])
			}

			#if (i<4) c[cell3[iub]]=p[cell3[iub]]=r[cell3[iub]]=f[cell3[iub]]=" "
			#if (i<3) c[cell2[iub]]=p[cell2[iub]]=r[cell2[iub]]=f[cell2[iub]]=" "
		}
		else if ($6 ~ /NodeSynchTp=/)
		{
			iub=gensub(/^.*IubLink=|,NodeSynch.*$/,"","g",$6)
			if ($6 ~ /=1$/)
			{
				ns1_ad[iub]=$2
				ns1_op[iub]=$4
				if (ns1_ad[iub]==0) ns1[iub]="L" ; else ns1[iub]=ns1_op[iub]
			}
			else if ($6 ~ /=2$/)
			{
				ns2_ad[iub]=$2
				ns2_op[iub]=$4
				if (ns2_ad[iub]==0) ns2[iub]="L" ; else ns2[iub]=ns2_op[iub]
			}
			else
			{
				if (ns2[iub] == "")
				{
					#Assume that NodeSynchTp 2 is the highest on the list
					#This should always be the case since nodesynchtp 1 is created before nodesynchtp 2
					ns2_ad[iub]=$2
					ns2_op[iub]=$4
					if (ns2_ad[iub]==0) ns2[iub]="L" ; else ns2[iub]=ns2_op[iub]
				}
				else
				{
					ns1_ad[iub]=$2
					ns1_op[iub]=$4
					if (ns1_ad[iub]==0) ns1[iub]="L" ; else ns1[iub]=ns1_op[iub]
				}
			}
		}
		else if ($4 ~ /NodeSynch=/)
		{
			iub=gensub(/^.*IubLink=|,NodeSynch.*$/,"","g",$4)
			ns1[iub]=$2
			nodeSync=1
		}
		else if ($6 ~ /NbapCommon=/)
		{
			iub=gensub(/^.*IubLink=|,Nbap.*$/,"","g",$6)
			nc_ad[iub]=$2
			nc_op[iub]=$4
			if (nc_ad[iub]==0) nc[iub]="L" ; else nc[iub]=nc_op[iub]
			if (nc[iub] ~ /L|0/ && tn[iub]!=" I") down[iub]=1
		}
		else if ($6 ~ /NbapDedicated=/)
		{
			iub=gensub(/^.*IubLink=|,Nbap.*$/,"","g",$6)
			nd_ad[iub]=$2
			nd_op[iub]=$4
			if (nd_ad[iub]==0) nd[iub]="L" ; else nd[iub]=nd_op[iub]
			if (nd[iub] ~ /L|0/ && tn[iub]!=" I") down[iub]=1
		}
		else if ($NF ~ /,IubLink=[^,]+$/ && $1 ~ /^[0-9]+$/ && $2 ~ /^[01]$/ && $3 ~ /^\(/)
		{
			#P6
			#1  1 (UNLOCKED)  1 (ENABLED)   RncFunction=1,IubLink=Iub-350
			#P5 and below:
			#  347                1 (ENABLED)   RncFunction=1,IubLink=9
			iub=gensub(/^.*=/,"",1,$NF)
			if ($3 == "(LOCKED)") ib[iub]="L"
			else if ($0 ~ "(ENABLED)") ib[iub]="1"
			else if ($0 ~ "(DISABLED)") ib[iub]="0"
		}
		else if ($6 ~ /Rach=/)
		{
			cell=gensub(/^.*UtranCell=|,Rach=.*$/,"","g",$6)
			r_ad[cell]=$2
			r_op[cell]=$4
			if (r_ad[cell]==0) r[cell]="L" ; else r[cell]=r_op[cell]
			if (r[cell] ~ /L|0/) c_down[cell]=1
		}
		else if ($6 ~ /Pch=/)
		{
			cell=gensub(/^.*UtranCell=|,Pch=.*$/,"","g",$6)
			p_ad[cell]=$2
			p_op[cell]=$4
			if (p_ad[cell]==0) p[cell]="L" ; else p[cell]=p_op[cell]
			if (p[cell] ~ /L|0/) c_down[cell]=1
		}
		else if ($6 ~ /,Fach=/)
		{
			cell=gensub(/^.*UtranCell=|,Fach=.*$/,"","g",$6)
			f_ad[cell]=$2
			f_op[cell]=$4
			if (f_ad[cell]==0) f[cell]="L" ; else f[cell]=f_op[cell]
			if (f[cell] ~ /L|0/) c_down[cell]=1
		}
		else if ($6 ~ /Hsdsch=[^,]+$/)
		{
			cell=gensub(/^.*UtranCell=|,Hsdsch=.*$/,"","g",$6)
			h_ad[cell]=$2
			h_op[cell]=$4
			if (h_ad[cell]==0) h[cell]="L" ; else h[cell]=h_op[cell]
			if (h[cell] ~ /0/) c_down[cell]=1
			if (c_adm[cell] !~ /^[02]$/)
			{
				if (h[cell] == 1) nr_hs_up++
				nr_hs_tot++
			}
		}
		else if ($6 ~ /Eul=[^,]+$/)
		{
			#RncFunction=1,UtranCell=30273,Hsdsch=302734,Eul=1
			cell=gensub(/^.*UtranCell=|,Hsdsch=.*$/,"","g",$6)
			e_ad[cell]=$2
			e_op[cell]=$4
			if (e_ad[cell]==0) e[cell]="L" ; else e[cell]=e_op[cell]
			if (e[cell] ~ /0/) c_down[cell]=1
			if (c_adm[cell] !~ /^[02]$/)
			{
				if (e[cell] == 1) nr_eul_up++
				nr_eul_tot++
			}
		}
		else if ($6 ~ /EulFach=[^,]+$/) #MbmsCCh
		{
			#MBMS is deprecated , show EulFach instead
			#RncFunction=1,UtranCell=Iub-1-3,MbmsCch=3
			#UtranCell=Iub-21-9,Hsdsch=1,Eul=1,EulFach=1
			#cell=gensub(/^.*UtranCell=|,MbmsCch=.*$/,"","g",$6)
			cell=gensub(/^.*UtranCell=|,Hsdsch=.*$/,"","g",$6)
			m_ad[cell]=$2
			m_op[cell]=$4
			if (m_ad[cell]==0) m[cell]="L" ; else m[cell]=m_op[cell]
			if (m[cell] ~ /0/) c_down[cell]=1
			if (c_adm[cell] !~ /^[02]$/)
			{
				if (m[cell] == 1) nr_eulf_up++
				nr_eulf_tot++
			}
		}
		else if ($6 ~/UtranCell=[^,]+$/)
		{
			cell=gensub(/^.*UtranCell=/,"","g",$6)
			c_ad[cell]=$2
			c_op[cell]=$4
			if (c_ad[cell]~/^[02]$/)
			{
				if (c_ad[cell]==0) c[cell]="L"
				else c[cell]="S"
				nr_of_cells_locked++
			}
			else if (c_tps[cell]~/^[02]$/)
			{
				if (c_tps[cell]==0) c[cell]="T"
				else c[cell]="U"
				nr_of_cells_locked++
			}
			else c[cell]=c_op[cell]
			if (c[cell] ~ /L|0|S|T|U/) c_down[cell]=1
			if (cellformat==3) cellList[cell]=1
			nr_of_cells++
		}
		else if ($2=="tpsPowerLockState")
		{
			#UtranCell=Iub-19-3                                      tpsPowerLockState 1 (UNLOCKED)
			cell=gensub(/^.*UtranCell=/,"","g",$1)
			c_tps[cell]=$3
			if ($3~/^[02]$/) c_adm[cell]=$3
		}
		else if ($2=="administrativeState" && $1~/UtranCell=[^,]+$/)
		{
			#UtranCell=Iub-19-3                                      administrativeState 1 (UNLOCKED)
			cell=gensub(/^.*UtranCell=/,"","g",$1)
			c_adm[cell]=$3
		}

		#IubLink=Iub-1523                                        poolRedundancy    1 (PRIMARY_POOL_ALLOC)
		#IubLink=Iub-1523                                        remoteCpIpAddress1 a.b.c.d
		#IubLink=Iub-1523                                        remoteSctpPortNbapC 5113
		#IubLink=Iub-1523                                        remoteSctpPortNbapD 5114
		#IubLink=Iub-1523                                        sctpRef           Sctp=MS-11
		#Sctp=MS-11,SctpAssociation=64768-a.b.c.d_5113-a.b.c.d 1 (ENABLED)      a.b.c.d   5113
		else if ($2=="poolRedundancy")
		{
			iub=gensub(/^IubLink=/,"","g",$1)
			ired[iub]=$3+0
			if (ired[iub]>0) show_ired=1
			ired[iub]=iredTranslation[ired[iub]]
		}
		else if ($2=="sctpRef" && $1~/^IubLink=/)
		{
			iub=gensub(/^IubLink=/,"","g",$1)
			sctpref[iub]=$3
			#case where the str was run without complete MOM, hardcode the remoteSctpPortNbap to 5113/5114
			if (cport[iub]=="") cport[iub]="5113"
			if (dport[iub]=="") dport[iub]="5114"
		}
		else if ($2=="remoteCpIpAddress1") remip1[gensub(/^IubLink=/,"","g",$1)]=$3
		else if ($2=="remoteSctpPortNbapC") cport[gensub(/^IubLink=/,"","g",$1)]=$3
		else if ($2=="remoteSctpPortNbapD") dport[gensub(/^IubLink=/,"","g",$1)]=$3
		else if ($1~/^Sctp=[^,]+,SctpAssociation=[^,]+$/ && NF==5 && $2==1) sctpassoc[gensub(/,.*$/,"",1,$1),$4,$5]=$2
		#IpAccessHostEt=MS-25-1                                  ipInterfaceMoRef  Subrack=MS,Slot=25,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=a.b.c.d
		#IpAccessHostGpb=MS-7-1                                  interface1        Subrack=MS,Slot=4,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=a.b.c.d
		#IpAccessHostGpb=MS-7-1                                  interface2        Subrack=MS,Slot=12,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=a.b.c.d
		#IpAccessSctp=MS-6                                       ipAccessHostEtRef1 IpAccessHostEt=MS-4-2
		#IpAccessSctp=MS-6                                       ipAccessHostEtRef2 IpAccessHostEt=MS-12-2
		#Sctp=MS-11                                              ipAccessHostGpbId
		#Sctp=MS-11                                              ipAccessSctpRef   IpAccessSctp=MS-11
		if (NF==3 && $2=="ipInterfaceMoRef") atmport[$1]=make_tnport($3)
		else if (NF==3 && $2=="interface1") atmport1[$1]=make_tnport($3)
		else if (NF==3 && $2=="interface2") atmport2[$1]=make_tnport($3)
		else if (NF==3 && $2=="ipAccessHostEtRef1") atmport1[$1]=atmport[$3]
		else if (NF==3 && $2=="ipAccessHostEtRef2") atmport2[$1]=atmport[$3]
		else if (NF==3 && $2~/^(ipAccessHostGpbId|ipAccessSctpRef)$/) { atmport1[$1]=atmport1[$3] ; atmport2[$1]=atmport2[$3] }
	}
	close(inputfile)
	for (iub in sctpref)
	{
		if (tn[iub]==" I" && iub in ib && ib[iub]!="")
		{
			nc[iub]=sctpassoc[sctpref[iub],remip1[iub],cport[iub]]+0
			nd[iub]=sctpassoc[sctpref[iub],remip1[iub],dport[iub]]+0
			atmport1[iub]=atmport1[sctpref[iub]]
			atmport2[iub]=atmport2[sctpref[iub]]
			tnlen[iub]=6
		}
	}
	for (iub in largeIubList)
	{
		delete tmptable
		tmptable[iub"%1"]=tmptable[iub"%2"]=1
		if (largeIubList[iub]>1) tmptable[iub"%3"]=1
		if (largeIubList[iub]>2) tmptable[iub"%4"]=1
		for (k in tmptable)
		{
			ns1[k]=ns1[iub]
			ns2[k]=ns2[iub]
			nc[k] = nc[iub]
			nd[k] = nd[iub]
			ib[k] = ib[iub]
			down[k]=down[iub]
			tn[k]=tn[iub]
			ired[k]=ired[iub]
			tnlen[k]=tnlen[iub]
		}
	}
	for (iub in iubList)
	{
		if (ns1[iub]=="" && ns2[iub]!="") { ns1[iub]=ns2[iub] ; ns2[iub]="" }
	}
	if (cellformat==3)
	{
		for (i in cellList)
		{
			if (c[i]=="1" && p[i]=="1" && r[i]=="1" && f[i]=="1") v[i]=1
			else if (c[i]~/^[LST]$/) v[i]=c[i]
			else v[i]=0
			if (m[i]!="") y[i]=m[i]
			else y[i]=e[i]
		}
	}
	for (iub in iubList)
	{
		if (down[iub] != 1)
		{
			if ((ns1[iub] ~ /L|0/)&&(ns2[iub] ~ /L|0|^$/)) down[iub]=1
			else if (ib[iub]=="" && nc[iub]=="" && nd[iub]=="" && ns1[iub]=="") unknown[iub]=1
			else if (nc[iub]!="" && nd[iub]=="") down[iub]=1 # there is an nbapcommon but no nbapdedicated
			#else if (ns2[iub]=="") down[iub]=1
		}
		if (c_down[cell1[iub]]==1||c_down[cell2[iub]]==1||c_down[cell3[iub]]==1||c_down[cell4[iub]]==1||c_down[cell5[iub]]==1||c_down[cell6[iub]]==1) down[iub]=1
		if (c_down[cell7[iub]]==1||c_down[cell8[iub]]==1||c_down[cell9[iub]]==1||c_down[cell10[iub]]==1||c_down[cell11[iub]]==1||c_down[cell12[iub]]==1) down[iub]=1
	}
	delete thedown
	for (iub in down)
	{
		if (down[iub]!=1) continue
		if (iub ~ /%[1234]$/ && gensub(/%.$/,"",1,iub) in largeIubList) sub(/%.$/,"",iub)
		thedown[iub]=1
		#if (iub ~ /%[12]$/ && gensub(/%.$/,"",1,iub) in down && down[gensub(/%.$/,"",1,iub)]==1) continue
		#if (iub ~ /%2$/ && gensub(/%.$/,"",1,iub) in largeIubList) continue
		#nr_of_iubs_down++
	}
	for (iub in thedown) { if (thedown[iub]==1) nr_of_iubs_down++ }
	for (iub in unknown)
	{
		if (unknown[iub]==1)
		{
			if (iub ~ /%[1234]$/ && gensub(/%[1234]$/,"",1,iub) in largeIubList) real_unknown[gensub(/%[1234]$/,"",1,iub)]=1
			else real_unknown[iub]=1
		}
	}
	for (iub in real_unknown) nr_of_iubs_unknown++
	for (cell in c_down) if (c_down[cell]==1) nr_of_cells_down++
	nr_of_iubs_up = nr_of_iubs - nr_of_iubs_down - nr_of_iubs_unknown
	nr_of_cells_up = nr_of_cells - nr_of_cells_down
	nr_of_cells_unlocked = nr_of_cells - nr_of_cells_locked
	customPrint(sprintf("\nFollowing %s sites are up:",nr_of_iubs_up))
	printHeaderLine()
	printHeaders()
	customPrint(output)
	printHeaderLine()
	maxIub=asort(iubList)
	for (i=0;i<=maxMod;i++)
	{
		if (mod_list[i]==1)
		{
			for (j=1;j<=maxIub;j++)
			{
				iub=iubList[j]
				if (mod[iub]==i && down[iub]!=1 && unknown[iub]!=1)
				{
					printLine()
				}
			}
		}
	}
	printHeaderLine()
	customPrint(sprintf("\nFollowing %s sites are totally or partially unavailable:",nr_of_iubs_down))
	printHeaderLine()
	printHeaders()
	customPrint(output)
	printHeaderLine()
	for (i=0;i<=maxMod;i++)
	{
		if (mod_list[i]==1)
		{
			for (j=1;j<=maxIub;j++)
			{
				iub=iubList[j]
				if ((mod[iub]==i)&&(down[iub]==1))
				{
					printLine()
				}
			}
		}
	}
	printHeaderLine()
	if (nr_of_iubs_unknown > 0)
	{
		customPrint(sprintf("\nUnknown state for following %s sites :",nr_of_iubs_unknown))
		for (i=0;i<=maxMod;i++)
		{
			if (mod_list[i]==1)
			{
				for (j=1;j<=maxIub;j++)
				{
					iub=iubList[j]
					if ((mod[iub]==i)&&(unknown[iub]==1))
					{
						#print iub,unknown[iub],mod[iub],unknown_iub_list
						unknown_iub_list=sprintf("%s %s",unknown_iub_list,iub)
					}
				}
			}
		}
		customPrint(gensub(/^ */,"",1,unknown_iub_list))
	}
	customPrint("")
	if (nr_of_iubs != "")
	{
		if (nr_of_cells != "") customPrint(sprintf("Cell availability: %3s of %3s cells are up (%3.2f %)",nr_of_cells_up,nr_of_cells,100*nr_of_cells_up/nr_of_cells))
		if (nr_of_iubs != nr_of_iubs_unknown) customPrint(sprintf("Site availability: %3s of %3s sites are fully operational (%3.2f %)",nr_of_iubs_up,nr_of_iubs-nr_of_iubs_unknown,100*nr_of_iubs_up/(nr_of_iubs-nr_of_iubs_unknown)))
		if (nr_of_cells != "") customPrint(sprintf("Unlocked Cell availability: %3s of %3s unlocked cells are up (%3.2f %)",nr_of_cells_up,nr_of_cells_unlocked,(nr_of_cells_unlocked > 0 ? 100*nr_of_cells_up/nr_of_cells_unlocked : 0)))
		if (nr_hs_tot > 0) customPrint(sprintf("Unlocked HS availability: %3s of %3s unlocked channels are up (%3.2f %)",nr_hs_up,nr_hs_tot,100*nr_hs_up/nr_hs_tot))
		if (nr_eul_tot > 0) customPrint(sprintf("Unlocked EUL availability: %3s of %3s unlocked channels are up (%3.2f %)",nr_eul_up,nr_eul_tot,100*nr_eul_up/nr_eul_tot))
		if (nr_eulf_tot > 0) customPrint(sprintf("Unlocked EULFACH availability: %3s of %3s unlocked channels are up (%3.2f %)",nr_eulf_up,nr_eulf_tot,100*nr_eulf_up/nr_eulf_tot))
		customPrint("")
	}
	if (csvfile != "") customPrint(sprintf("Output saved to CSV file: %s",csvfile))
}
function printHeaders()
{
	if (cellformat==0 && maxCellsPerIub < 4) output=sprintf("%4s  %-*s  %-*s  %-8s %-8s %-8s %-5s  %s%s%s","MOD",li,"IUBLINK",lcs,"CELLNAMES","CFRPHEU1","CFRPHEU2","CFRPHEU3",(nodeSync==1?"ICDS":"ICD12"),(show_tn==1?"TN ":""),(show_ired==1?"R ":""),"TNPORTS")
	else if (cellformat==0) output=sprintf("%4s  %-*s  %-*s  %-8s %-8s %-8s %-8s %-8s %-8s %-5s  %s%s%s","MOD",li,"IUBLINK",lcs,"CELLNAMES","CFRPHEU1","CFRPHEU2","CFRPHEU3","CFRPHEU4","CFRPHEU5","CFRPHEU6",(nodeSync==1?"ICDS":"ICD12"),(show_tn==1?"TN ":""),(show_ired==1?"R ":""),"TNPORTS")
	else if (cellformat==1 && maxCellsPerIub < 4) output=sprintf("%4s  %-*s  %-47s    %8s %8s %8s %-5s","MOD",li,"IUBLINK","CELLNAMES","CFRPHEU1","CFRPHEU2","CFRPHEU3",(nodeSync==1?"ICDS":"ICD12"))
	else if (cellformat==1) output=sprintf("%4s  %-*s  %-65s   %-8s %-8s %-8s %-8s %-8s %-8s %-5s","MOD",li,"IUBLINK","CELLNAMES","CFRPHEU1","CFRPHEU2","CFRPHEU3","CFRPHEU4","CFRPHEU5","CFRPHEU6",(nodeSync==1?"ICDS":"ICD12"))
	else if (cellformat==2 && maxCellsPerIub < 4) output=sprintf("%4s  %-*s  %-5s  %-*s %-7s  %-*s %-7s  %-*s %-7s","MOD",li,"IUBLINK",(nodeSync==1?"ICDS":"ICD12"),lc,"CELL1","CFRPHEU",lc,"CELL2","CFRPHEU",lc,"CELL3","CFRPHEU")
	else if (cellformat==2) output=sprintf("%4s  %-*s  %-5s  %-*s %-7s  %-*s %-7s  %-*s %-7s  %-*s %-7s  %-*s %-7s  %-*s %-7s","MOD",li,"IUBLINK",(nodeSync==1?"ICDS":"ICD12"),lc,"CELL1","CFRPHEU",lc,"CELL2","CFRPHEU",lc,"CELL3","CFRPHEU",lc,"CELL4","CFRPHEU",lc,"CELL5","CFRPHEU",lc,"CELL6","CFRPHEU")
	else if (cellformat==3) output=sprintf("%-*s %4s %2s%s %-4s %-3s %-3s %-3s %-3s %-3s %-3s %-3s %-3s %-3s %-3s %-3s %-3s",li,"IUBLINK","MOD","TN"," R","ICDS","C01","C02","C03","C04","C05","C06","C07","C08","C09","C10","C11","C12")
	if (csv==1 && csvprinted!=1)
	{
		printf("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n","IubLink",(nodeSync==1?"ICDS ":"ICD12"),"CELL1","CFRPHEU","CELL2","CFRPHEU","CELL3","CFRPHEU","CELL4","CFRPHEU","CELL5","CFRPHEU","CELL6","CFRPHEU","MOD","TNPORT1","TNPORT2") > csvfile
		csvprinted=1
	}
}
function printHeaderLine()
{
	if (cellformat==0) customPrint("---------------------------------------------------------------------------------------------------------------------")
	else if (cellformat==1) customPrint("-----------------------------------------------------------------------------------------------------------------------------------")
	else customPrint("---------------------------------------------------------------------------------------------------------------------------------------------")
}
function printLine()
{
	output=sprintf("%4s  %-*s  ",mod[iub],li,iub)
	if (cellformat==0)
	{
		output=sprintf("%s%-*s  %1s%1s%1s%1s%1s%1s%1s  %1s%1s%1s%1s%1s%1s%1s  %1s%1s%1s%1s%1s%1s%1s  ", output,lcs,cellname[iub],\
c[cell1[iub]],f[cell1[iub]],r[cell1[iub]],p[cell1[iub]],h[cell1[iub]],e[cell1[iub]],m[cell1[iub]],\
c[cell2[iub]],f[cell2[iub]],r[cell2[iub]],p[cell2[iub]],h[cell2[iub]],e[cell2[iub]],m[cell2[iub]],\
c[cell3[iub]],f[cell3[iub]],r[cell3[iub]],p[cell3[iub]],h[cell3[iub]],e[cell3[iub]],m[cell3[iub]])
		if (maxCellsPerIub > 3)	output=sprintf("%s%1s%1s%1s%1s%1s%1s%1s  %1s%1s%1s%1s%1s%1s%1s  %1s%1s%1s%1s%1s%1s%1s  ", output,\
c[cell4[iub]],f[cell4[iub]],r[cell4[iub]],p[cell4[iub]],h[cell4[iub]],e[cell4[iub]],m[cell4[iub]],\
c[cell5[iub]],f[cell5[iub]],r[cell5[iub]],p[cell5[iub]],h[cell5[iub]],e[cell5[iub]],m[cell5[iub]],\
c[cell6[iub]],f[cell6[iub]],r[cell6[iub]],p[cell6[iub]],h[cell6[iub]],e[cell6[iub]],m[cell6[iub]])
		output=sprintf("%s%1s%1s%1s%1s%1s  ",output,ib[iub],nc[iub],nd[iub],ns1[iub],ns2[iub])
		output=sprintf("%s%s%s%-*s %s",output,(show_tn==1?sprintf("%2s ",tn[iub]):""),(show_ired==1?sprintf("%1s ",ired[iub]):""),(tnlen[iub]>0?tnlen[iub]:13),atmport1[gensub(/%[1234]$/,"",1,iub)],atmport2[gensub(/%[1234]$/,"",1,iub)])
	}
	else if (cellformat==1)
	{
		if (maxCellsPerIub < 4) output=sprintf("%s%-15s %-15s %-15s ",output,cell1[iub],cell2[iub],cell3[iub])
		else output=sprintf("%s%-10s %-10s %-10s %-10s %-10s %-10s",output,cell1[iub],cell2[iub],cell3[iub],cell4[iub],cell5[iub],cell6[iub])
		output=sprintf("%s   %1s%1s%1s%1s%1s%1s%1s  %1s%1s%1s%1s%1s%1s%1s  %1s%1s%1s%1s%1s%1s%1s  ",output,\
c[cell1[iub]],f[cell1[iub]],r[cell1[iub]],p[cell1[iub]],h[cell1[iub]],e[cell1[iub]],m[cell1[iub]],\
c[cell2[iub]],f[cell2[iub]],r[cell2[iub]],p[cell2[iub]],h[cell2[iub]],e[cell2[iub]],m[cell2[iub]],\
c[cell3[iub]],f[cell3[iub]],r[cell3[iub]],p[cell3[iub]],h[cell3[iub]],e[cell3[iub]],m[cell3[iub]])
		if (maxCellsPerIub > 3)	output=sprintf("%s%1s%1s%1s%1s%1s%1s%1s  %1s%1s%1s%1s%1s%1s%1s  %1s%1s%1s%1s%1s%1s%1s  ", output,\
c[cell4[iub]],f[cell4[iub]],r[cell4[iub]],p[cell4[iub]],h[cell4[iub]],e[cell4[iub]],m[cell4[iub]],\
c[cell5[iub]],f[cell5[iub]],r[cell5[iub]],p[cell5[iub]],h[cell5[iub]],e[cell5[iub]],m[cell5[iub]],\
c[cell6[iub]],f[cell6[iub]],r[cell6[iub]],p[cell6[iub]],h[cell6[iub]],e[cell6[iub]],m[cell6[iub]])
		output=sprintf("%s%1s%1s%1s%1s%1s",output,ib[iub],nc[iub],nd[iub],ns1[iub],ns2[iub])
	}
	else if (cellformat==2)
	{
		if (maxCellsPerIub < 4) output=sprintf("%s%1s%1s%1s%1s%1s  %-*s %1s%1s%1s%1s%1s%1s%1s  %-*s %1s%1s%1s%1s%1s%1s%1s  %-*s %1s%1s%1s%1s%1s%1s%1s  ",output,\
ib[iub],nc[iub],nd[iub],ns1[iub],ns2[iub],\
lc,cell1[iub],c[cell1[iub]],f[cell1[iub]],r[cell1[iub]],p[cell1[iub]],h[cell1[iub]],e[cell1[iub]],m[cell1[iub]],\
lc,cell2[iub],c[cell2[iub]],f[cell2[iub]],r[cell2[iub]],p[cell2[iub]],h[cell2[iub]],e[cell2[iub]],m[cell2[iub]],\
lc,cell3[iub],c[cell3[iub]],f[cell3[iub]],r[cell3[iub]],p[cell3[iub]],h[cell3[iub]],e[cell3[iub]],m[cell3[iub]])
		else output=sprintf("%s%1s%1s%1s%1s%1s  %-*s %1s%1s%1s%1s%1s%1s%1s  %-*s %1s%1s%1s%1s%1s%1s%1s  %-*s %1s%1s%1s%1s%1s%1s%1s  %-*s %1s%1s%1s%1s%1s%1s%1s  %-*s %1s%1s%1s%1s%1s%1s%1s  %-*s %1s%1s%1s%1s%1s%1s%1s",output,\
ib[iub],nc[iub],nd[iub],ns1[iub],ns2[iub],\
lc,cell1[iub],c[cell1[iub]],f[cell1[iub]],r[cell1[iub]],p[cell1[iub]],h[cell1[iub]],e[cell1[iub]],m[cell1[iub]],\
lc,cell2[iub],c[cell2[iub]],f[cell2[iub]],r[cell2[iub]],p[cell2[iub]],h[cell2[iub]],e[cell2[iub]],m[cell2[iub]],\
lc,cell3[iub],c[cell3[iub]],f[cell3[iub]],r[cell3[iub]],p[cell3[iub]],h[cell3[iub]],e[cell3[iub]],m[cell3[iub]],\
lc,cell4[iub],c[cell4[iub]],f[cell4[iub]],r[cell4[iub]],p[cell4[iub]],h[cell4[iub]],e[cell4[iub]],m[cell4[iub]],\
lc,cell5[iub],c[cell5[iub]],f[cell5[iub]],r[cell5[iub]],p[cell5[iub]],h[cell5[iub]],e[cell5[iub]],m[cell5[iub]],\
lc,cell6[iub],c[cell6[iub]],f[cell6[iub]],r[cell6[iub]],p[cell6[iub]],h[cell6[iub]],e[cell6[iub]],m[cell6[iub]])
	}
	else if (cellformat==3)
	{
		output=sprintf("%-*s %4s %2s%s %1s%1s%1s%1s %1s%1s%1s %1s%1s%1s %1s%1s%1s %1s%1s%1s %1s%1s%1s %1s%1s%1s %1s%1s%1s %1s%1s%1s %1s%1s%1s %1s%1s%1s %1s%1s%1s %1s%1s%1s",\
li,iub,mod[iub],tn[iub],(show_ired==1?sprintf(" %1s",ired[iub]):" N"),ib[iub],nc[iub],nd[iub],ns1[iub],\
v[cell1[iub]],h[cell1[iub]],y[cell1[iub]],v[cell2[iub]],h[cell2[iub]],y[cell2[iub]],v[cell3[iub]],h[cell3[iub]],y[cell3[iub]],\
v[cell4[iub]],h[cell4[iub]],y[cell4[iub]],v[cell5[iub]],h[cell5[iub]],y[cell5[iub]],v[cell6[iub]],h[cell6[iub]],y[cell6[iub]],\
v[cell7[iub]],h[cell7[iub]],y[cell7[iub]],v[cell8[iub]],h[cell8[iub]],y[cell8[iub]],v[cell9[iub]],h[cell9[iub]],y[cell9[iub]],\
v[cell10[iub]],h[cell10[iub]],y[cell10[iub]],v[cell11[iub]],h[cell11[iub]],y[cell11[iub]],v[cell12[iub]],h[cell12[iub]],y[cell12[iub]])

#"MOD",li,"IUBLINK","TN",(show_ired==1?" R":""),"ICDS","C01","C02","C03","C04","C05","C06","C07","C08","C09","C10","C11","C12","TNPORTS")
#------------------------------------------------------------------------------------------------
#MOD  IUBLINK TN R ICDS C01 C02 C03 C04 C05 C06 C07 C08 C09 C10 C11 C12  TNPORTS
#------------------------------------------------------------------------------------------------
#1061 Iub-32   I P 1111 111 111 111 111 111 111 111 111 111 111 111 111   MS-4   MS-12
	}
	customPrint(output)
	if (csv==1) printf("%s,%1s%1s%1s%1s%1s,%s,%1s%1s%1s%1s%1s%1s%1s,%s,%1s%1s%1s%1s%1s%1s%1s,%s,%1s%1s%1s%1s%1s%1s%1s,%s,%1s%1s%1s%1s%1s%1s%1s,%s,%1s%1s%1s%1s%1s%1s%1s,%s,%1s%1s%1s%1s%1s%1s%1s,%s,%s,%s\n",\
	    iub,ib[iub],nc[iub],nd[iub],ns1[iub],ns2[iub],\
	    cell1[iub],c[cell1[iub]],f[cell1[iub]],r[cell1[iub]],p[cell1[iub]],h[cell1[iub]],e[cell1[iub]],m[cell1[iub]],\
	    cell2[iub],c[cell2[iub]],f[cell2[iub]],r[cell2[iub]],p[cell2[iub]],h[cell2[iub]],e[cell2[iub]],m[cell2[iub]],\
	    cell3[iub],c[cell3[iub]],f[cell3[iub]],r[cell3[iub]],p[cell3[iub]],h[cell3[iub]],e[cell3[iub]],m[cell3[iub]],\
	    cell4[iub],c[cell4[iub]],f[cell4[iub]],r[cell4[iub]],p[cell4[iub]],h[cell4[iub]],e[cell4[iub]],m[cell4[iub]],\
	    cell5[iub],c[cell5[iub]],f[cell5[iub]],r[cell5[iub]],p[cell5[iub]],h[cell5[iub]],e[cell5[iub]],m[cell5[iub]],\
	    cell6[iub],c[cell6[iub]],f[cell6[iub]],r[cell6[iub]],p[cell6[iub]],h[cell6[iub]],e[cell6[iub]],m[cell6[iub]],\
	    mod[iub],atmport1[gensub(/%[1234]$/,"",1,iub)],atmport2[gensub(/%[1234]$/,"",1,iub)]) >> csvfile
}
function cedsg_function(inputvariables)
{
	parse_inputvars(inputvariables)
	what=inputoptions
	inputfile=commandfile
	split(currentDir,array,SUBSEP)
	lcell=array[1]
	if (array[2] ~ /^[0-9]/) { filterbymod=1 ; split(array[2],tmparray,",") ; for (i in tmparray) moduleFilter[tmparray[i]+0]=1 }
	else if (array[3] != "") { filterbycell=1 ; cellFilter=array[3] }
	else if (array[4] != "") { filterbyrbs=1  ; rbsFilter=array[4] }
	else if (array[5] != "") { filterbyrsite=1; rsiteFilter=array[5] }
	while ((getline < inputfile)>0)
	{
		if ($1=="MO" && $2 ~ /ManagedElement=1,/)
		{
			currmo=gensub(/^.*ManagedElement=1,/,"ManagedElement=1,",1,$2)
			if (s2t(currmo) ~ /^(UtranCell)$/)
			{
				moList[currmo]=currmo
			}
			else
			{
				parentmo=childmo=""
				last=split(currmo,array,",")
				for (i=1;i<=last;i++)
				{
					if (childmo ~ /,UtranCell=/) childmo=childmo","array[i]
					if (array[i] ~ /^UtranCell=/) parentmo=childmo="ManagedElement=1,RncFunction=1,"array[i]
				}
				childList[parentmo]=childList[parentmo]";"childmo
				sub(/^;/,"",childList[parentmo])
			}
		}
		else if ($1 ~ /^(operationalState|administrativeState|antennaPosition|iubLinkRef|edchTti2Support|eulDchBalancingSupport|eulTdSchedulingSupport|improvedL2Support|enhUeDrxSupport|enhancedL2Support|hsAqmCongCtrlSupport|hsFachSupport|qam64MimoSupport|qam64Support|dualBandMultiCarrierSupport|multiCarrierMimoSupport|multiCarrierSupport|cpcSupport|fdpchSupport|loadBasedHoSupport|rncModuleRef|eulMultiCarrierSupport|ueHsThpMeasSupport|tpsPowerLockState|hsdpa3McSupport|hsdpaDb3McSupport|rSiteRef)$/)
		{
			attr[currmo,$1]=gensub(/^[^ ]+ +/,"",1,$0)
			sub(/^.*ManagedElement=1,/,"ManagedElement=1,",attr[currmo,$1])
		}
		else if ($1 ~ /^utranCellPosition\[.*$/)
		{
			attr[currmo,gensub(/\[.*$/,"",1,$1)]=gensub(/^[^ ]+ +/,"",1,$0)
		}
		else if ($2 ~ /^[0-9]\.(latitudeSign|latitude|longitude)$/) attr[currmo,gensub(/^[0-9]\./,"",1,$2)]=gensub(/^.*= /,"",1,$0)
	}
	close(inputfile)
	#for (i in attr) print i,attr[i]
	fieldIndex["C"]=1
	fieldIndex["F"]=1
	fieldIndex["R"]=1
	fieldIndex["P"]=1
	fieldIndex["H"]=1
	fieldIndex["E"]=1
	fieldIndex["M"]=1
	fieldIndex["U"]=1
	fieldIndex["a"]=1
	fieldIndex["b"]=1
	fieldIndex["c"]=1
	fieldIndex["d"]=1
	fieldIndex["e"]=1
	fieldIndex["f"]=1
	fieldIndex["g"]=1
	fieldIndex["h"]=1
	fieldIndex["i"]=1
	fieldIndex["j"]=1
	fieldIndex["k"]=1
	fieldIndex["l"]=1
	fieldIndex["m"]=1
	fieldIndex["n"]=1
	fieldIndex["o"]=1
	fieldIndex["p"]=1
	fieldIndex["q"]=1
	fieldIndex["r"]=1
	fieldIndex["s"]=1
	fieldIndex["t"]=1
	fieldIndex["cpc"]=1
	fieldIndex["dBMC"]=1
	fieldIndex["edchT2"]=1
	fieldIndex["enhDrx"]=1
	fieldIndex["enhL2"]=1
	fieldIndex["eulDch"]=1
	fieldIndex["eulTd"]=1
	fieldIndex["fdpch"]=1
	fieldIndex["hsAqm"]=1
	fieldIndex["hsFach"]=1
	fieldIndex["impL2"]=1
	fieldIndex["lBHo"]=1
	fieldIndex["mC"]=1
	fieldIndex["mCMimo"]=1
	fieldIndex["q64"]=1
	fieldIndex["q64Mimo"]=1
	fieldIndex["antennaPos"]=1
	fieldIndex["cellPos"]=1
	fieldIndex["eulMulti"]=1
	fieldIndex["hsThp"]=1
	fieldIndex["hs3MC"]=1
	fieldIndex["db3MC"]=1

	for (mo in moList)
	{
		delete field
		for (i in fieldIndex) field[i]="-"
		field["iub"]=attr[mo,"iubLinkRef"]
		field["mod"]=convert_modname_tonumber(attr[field["iub"],"rncModuleRef"])
		if (filterbyrbs==1 && tolower(gensub(/^.*=/,"",1,field["iub"]))!~rbsFilter) continue
		else if (filterbycell==1 && tolower(gensub(/^.*=/,"",1,mo)) !~ cellFilter) continue
		else if (filterbymod==1 && (!(field["mod"] in moduleFilter))) continue
		else if (filterbyrsite==1 && tolower(attr[mo,"rSiteRef"]) !~ "rsite="rsiteFilter) continue
		field["C"]=process_state(mo)
		if ((mo,"cpcSupport") in attr)         field["a"]=gensub(/ .*$/,"",1,attr[mo,"cpcSupport"])
		if ((mo,"fdpchSupport") in attr)       field["h"]=gensub(/ .*$/,"",1,attr[mo,"fdpchSupport"])
		if ((mo,"loadBasedHoSupport") in attr) field["l"]=gensub(/ .*$/,"",1,attr[mo,"loadBasedHoSupport"])
		if ((mo,"ueHsThpMeasSupport") in attr) field["r"]=gensub(/ .*$/,"",1,attr[mo,"ueHsThpMeasSupport"])
		if ((mo,"latitudeSign") in attr)
		{
			field["antennaPos"]=sprintf("%s%.4f,%.4f",(attr[mo,"latitudeSign"]~/^1/?"-":""),90 * attr[mo,"latitude"] / 2^23, 360 * attr[mo,"longitude"] / 2^24)
		}
		if ((mo,"utranCellPosition") in attr)
		{
			last=split(attr[mo,"utranCellPosition"],array," ")
			if (last >= 3)
			{
				field["cellPos"]=""
				for (i=1;i<=last;i+=3)
				{
					field["cellPos"]=sprintf("%s %s%.4f,%4f",field["cellPos"],(array[i]~/^1/?"-":""), 90 * array[i+1] / 2^23, 360 * array[i+2] / 2^24)
				}
				sub(/^ /,"",field["cellPos"])
			}
		}

		split(childList[mo],array,";")
		for (i in array)
		{
			#Level 3 children
			if (array[i] ~ ",EulFach=") field["U"]=process_state(array[i])
			else if (array[i] ~ ",MultiCarrier=")
			{
				if ((array[i],"dualBandMultiCarrierSupport") in attr) field["b"]=gensub(/ .*$/,"",1,attr[array[i],"dualBandMultiCarrierSupport"])
				if ((array[i],"multiCarrierSupport") in attr)         field["m"]=gensub(/ .*$/,"",1,attr[array[i],"multiCarrierSupport"])
				if ((array[i],"multiCarrierMimoSupport") in attr)     field["n"]=gensub(/ .*$/,"",1,attr[array[i],"multiCarrierMimoSupport"])
				if ((array[i],"eulMultiCarrierSupport") in attr)      field["q"]=gensub(/ .*$/,"",1,attr[array[i],"eulMultiCarrierSupport"])
				if ((array[i],"hsdpa3McSupport") in attr)             field["s"]=gensub(/ .*$/,"",1,attr[array[i],"hsdpa3McSupport"])
				if ((array[i],"hsdpaDb3McSupport") in attr)           field["t"]=gensub(/ .*$/,"",1,attr[array[i],"hsdpaDb3McSupport"])
			}
			#Level 2 children
			else if (array[i] ~ ",Eul=")
			{
				field["E"]=process_state(array[i])
				if ((array[i],"edchTti2Support") in attr)        field["c"]=gensub(/ .*$/,"",1,attr[array[i],"edchTti2Support"])
				if ((array[i],"eulDchBalancingSupport") in attr) field["f"]=gensub(/ .*$/,"",1,attr[array[i],"eulDchBalancingSupport"])
				if ((array[i],"eulTdSchedulingSupport") in attr) field["g"]=gensub(/ .*$/,"",1,attr[array[i],"eulTdSchedulingSupport"])
				if ((array[i],"improvedL2Support") in attr)      field["k"]=gensub(/ .*$/,"",1,attr[array[i],"improvedL2Support"])
			}
			#Level 1 children
			else if (array[i] ~ ",Hsdsch=")
			{
				field["H"]=process_state(array[i])
				if ((array[i],"enhUeDrxSupport") in attr)         field["d"]=gensub(/ .*$/,"",1,attr[array[i],"enhUeDrxSupport"])
				if ((array[i],"enhancedL2Support") in attr)       field["e"]=gensub(/ .*$/,"",1,attr[array[i],"enhancedL2Support"])
				if ((array[i],"hsAqmCongCtrlSupport") in attr)    field["i"]=gensub(/ .*$/,"",1,attr[array[i],"hsAqmCongCtrlSupport"])
				if ((array[i],"hsFachSupport") in attr)           field["j"]=gensub(/ .*$/,"",1,attr[array[i],"hsFachSupport"])
				if ((array[i],"qam64Support") in attr)            field["o"]=gensub(/ .*$/,"",1,attr[array[i],"qam64Support"])
				if ((array[i],"qam64MimoSupport") in attr)        field["p"]=gensub(/ .*$/,"",1,attr[array[i],"qam64MimoSupport"])
			}
			#else if (array[i] ~ ",MbmsCch=") field["M"]=process_state(array[i])
			else if (array[i] ~ ",EulFach=") field["M"]=process_state(array[i])
			else if (array[i] ~ ",Fach=") field["F"]=process_state(array[i])
			else if (array[i] ~ ",Pch=") field["P"]=process_state(array[i])
			else if (array[i] ~ ",Rach=") field["R"]=process_state(array[i])
		}
		for (i in field)
		{
			totF[i]+=0
			if (field[i]==1) totF[i]++
		}
		if (what ~ "s") line=sprintf("%4s  %-*s  %1s%1s%1s%1s%1s%1s%1s%1s  %1s%1s%1s%1s%1s%1s%1s%1s%1s%1s%1s%1s%1s%1s%1s%1s%1s%1s%1s%1s  %3s %4s %6s %6s %5s %6s %5s %5s %5s %6s %5s %4s %3s %6s %3s %7s %5s %5s %5s %5s",\
field["mod"],lcell,gensub(/^.*=/,"",1,mo),field["C"],field["F"],field["R"],field["P"],field["H"],field["E"],field["M"],field["U"],\
field["a"],field["b"],field["c"],field["d"],field["e"],field["f"],field["g"],field["h"],field["i"],field["j"],field["k"],field["l"],field["m"],field["n"],field["o"],field["p"],field["q"],field["r"],field["s"],field["t"],\
field["a"],field["b"],field["c"],field["d"],field["e"],field["f"],field["g"],field["h"],field["i"],field["j"],field["k"],field["l"],field["m"],field["n"],field["o"],field["p"],field["q"],field["r"],field["s"],field["t"])
		else if (what ~ "g") line=sprintf("%4s  %-*s  %1s%1s%1s%1s%1s%1s%1s%1s  %16s  %s",\
field["mod"],lcell,gensub(/^.*=/,"",1,mo),field["C"],field["F"],field["R"],field["P"],field["H"],field["E"],field["M"],field["U"],\
field["antennaPos"],field["cellPos"])
		lineTable[line]=line
	}
	n=asort(lineTable)
	for (i=1;i<=n;i++) customPrint(lineTable[i])
	if (what ~ "g") headLine="---------------------------------------------------------------------------------------------------------------------------------"
	else if (what ~ "s") headLine="--------------------------------------------------------------------------------------------------------------------------------------------------------------"
	for (i=1;i<=lcell;i++) headLine=sprintf("%s-",headLine)
	customPrint(headLine)
	if (what ~ "g") customPrint("Total: "n" Cells")
	else if (what ~ "s") customPrint(sprintf("%-*s%3s %4s %6s %6s %5s %6s %5s %5s %5s %6s %5s %4s %3s %6s %3s %7s %5s %5s %5s %5s",\
40+lcell,"Total: "sprintf("%5d",n)" Cells",totF["a"],totF["b"],totF["c"],totF["d"],totF["e"],totF["f"],totF["g"],totF["h"],totF["i"],totF["j"],totF["k"],totF["l"],totF["m"],totF["n"],totF["o"],totF["p"],totF["q"],totF["r"],totF["s"],totF["t"]))
}
function process_state(mo,   res)
{
	if (attr[mo,"administrativeState"] ~ /^0/) res="L"
	else if (attr[mo,"administrativeState"] ~ /^2/) res="S"
	else if (attr[mo,"tpsPowerLockState"] ~ /^0/) res="T"
	else if (attr[mo,"tpsPowerLockState"] ~ /^2/) res="U"
	else res=gensub(/ .*$/,"",1,attr[mo,"operationalState"])
	return res
}
function ced_function(inputvariables,   cell,array,mod,cellmo,lcell,cellList,modList,modmo,m,n,i,j,attr,\
oldcedformat,moduleFilter,filterbymod,filterbycell,cellFilter,tmparray,td,tu,modConversionMethod,ok)
{
	parse_inputvars(inputvariables)
	inputfile=commandfile
	split(currentDir,array,SUBSEP)
	lcell=array[1]
	if (array[2] ~ /^[0-9]/) { filterbymod=1 ; split(array[2],tmparray,",") ; for (i in tmparray) moduleFilter[tmparray[i]+0]=1 }
	if (array[3] != "") { filterbycell=1 ; split(array[3],tmparray,",") ; for (i in tmparray) cellFilter[tmparray[i]]=1 }

	#rncModBoTable 0020sp0 1

	#P4/P5ED:
	#$ lhsh 001000 dyncelldata -moduleId 3
	#0010: cId: 1057
	#0010: Cell froId: 56
	#0010: CC SP: 001900/sp1.lnh/CommonChMainPT
	#0010: IubLink froId: 18
	#0010: Total ASE DL: 0
	#0010: aseDlAdm: 240
	#0010: Total ASE UL: 0
	#0010: aseUlAdm: 160
	#0010: HSDPA UE Count: 0
	#0010: hsdpaUsersAdm: 10
	#0010: CPM RL Count: 0
	#0010: compModeAdm: 15
	#0010: SF8 RL DL Count: 0
	#0010: sf8Adm: 8
	#0010: SF16 RL DL Count: 0
	#0010: sf16Adm: 16
	#0010: SF32 RL DL Count: 0
	#0010: sf32Adm: 32
	#0010: SF4 RL UL Count: 0
	#0010: sf4AdmUl: 0
	#0010: DL Code Allocation Level: 390 %
	#0010: dlCodeAdm: 70 %
	#0010: UL Interference: -112.0 dBm
	#0010: Filtered DL Power: 8.87 %
	#0010: pwrAdm: 75 %
	#0010: Congestion State: Uncongested
	#0014: SF128 RL DL Count:                       0
	#0014: sf128Adm:                                128
	#0014: SF64 RL UL Count:                        0
	#0014: sf64AdmUl:                               100

	#not shown in P5MD
	#0014: dlCodeAdm:                   80 %
	#0014: beMarginDlCode:              5
	#0014: Congestion State:            Uncongested

	#if the cell has previously been found to be operational, we ignore later entries where it is not operational:
	#this is because the same cell could still have some obsolete entries in different modules
	#1116: cId:                         1418
	#1116: cellFroId:                   229
	#1116: RO instance:                 6
	#1116: RNC Module:                  30
	#1116: Error: Cell is not operational

	#RncModule=8                                             rncModuleResourceId 1
	#UtranCell=Iub-36-3                                      cId               1141

	#Evo:
	#0005: CC SP:                                   000500/CommonChMainPT

	modConversionMethod="old"
	while ((getline < inputfile)>0)
	{
		gsub("\r","")
		if ($1=="rncModBoTable") { if (NF==3 && cpplinux!=1) ccModule[$2]=$3 }
		else if ($1=="uerIubConnection") { if (NF==3) iubConnection[$2]=$3 }
		else if ($1=="subrackrefattribute") { if (NF==2) subrackrefattribute=$2 }
		else if ($2=="programInstanceId" && $1 ~ /^RncModule=/)
		{
			if ($3 > 0) modConversionMethod="new" ; else modConversionMethod="old"
		}
		else if ($2=="rpuRefs" && $1 ~ /^RncModule=/)
		{
			currentModule=$1
			tmpRncModNumber=convert_modname_tonumber(currentModule,modConversionMethod)
			rncModuleList[tmpRncModNumber]=tmpRncModNumber
			rncModuleNumber[currentModule]=tmpRncModNumber
			rncModuleName[tmpRncModNumber]=gensub(/^.*=/,"",1,currentModule)
		}
		#else if ($2=="rpuRefs" && $1 ~ /^RncModule=/)
		#{
		#	currentModule=$1
		#	tmpRncModNumber=gensub(/^.*=/,"",1,$1)+0
		#	if ($1 ~ /RncModule=.*[-A-Z].*$/)
		#	{
		#		#WRNae73332 , sometimes rpuRefs is not set : RncModule=MS-6-0       rpuRefs           [0] =
		#		if (gensub(/\[|\]/,"","g",$3)+0 == 0) tmpRncModNumber=convert_modname_tonumber($1,modConversionMethod)
		#	}
		#	if (tmpRncModNumber > 0) rncModuleNumber[$1]=tmpRncModNumber
		#}
		#else if (tmpRncModNumber==0 && $1==">>>" && $2=="rpuRefs")
		#{
		#	tmpRncModNumber=gensub(/^.*_/,"",1,$4)
		#	if (tmpRncModNumber+0 > 0) tmpRncModNumber+=0
		#	else tmpRncModNumber=convert_modname_tonumber(tmpRncModNumber,modConversionMethod)
		#	rncModuleNumber[currentModule]=tmpRncModNumber
		#}
		else if ($2=="cId" && $1 ~ /^UtranCell=/)
		{
			cellmo=sprintf("%*s",lcell,gensub("UtranCell=","",1,$1))
			cell[$3]=cellmo
			cellList[cellmo]=cellmo
		}
		else if ($2=="froId" && $1 ~ /^UtranCell=/)
		{
			cellmo=sprintf("%*s",lcell,gensub("UtranCell=","",1,$1))
			frocell[$3]=cellmo
		}
		else if ($2=="rncModuleResourceId" && $1 ~ /^RncModule=/)
		{
			modmo=sprintf("%3s",rncModuleNumber[$1])
			mod[$3]=modmo
			modList[modmo]=modmo
		}
		else if ($4=="dyncelldata" && $5=="-moduleId")
		{
			oldcedformat=1
			currentModule=mod[$6]
		}
		else if ($2=="cId:" && $1 ~ /^[0-9][0-9][0-9][0-9](D01)?:$/)
		{
			currentCell=cell[$3]
			attr[currentCell,"cId"]=$3
			if (oldcedformat==1) attr[currentCell,"RNC Module"]=currentModule
		}
		else if (/^[0-9][0-9][0-9][0-9](D01)?: RNC Module:/)
		{
			if (sprintf("%s%s%s",currentCell,SUBSEP,"Total ASE DL") in attr && attr[currentCell,"Total ASE DL"]!="") continue
			attr[currentCell,"RNC Module"]=mod[$4]
		}
		else if (/^[0-9][0-9][0-9][0-9](D01)?: CC SP:/)
		{
			#0011: CC SP:                       002300/sp1.lnh/CommonChMainPT
			#0006: CC SP:                       002300/d00001/CommonChMainPT
			#0005: CC SP:                       000500/CommonChMainPT
			#Evo8300:
			#0004D01: CC SP:                    1/CommonChMainPT
			match($4,/^([0-9][0-9][0-9][0-9])00\/(sp[0-9]|d0000[0-9])?/,array)
			attr[currentCell,"CC SP"]=array[1] gensub("0000","",1,array[2])
			if (cpplinux==1 && attr[currentCell,"CC SP"]=="" && $4~/CommonChMainPT/) attr[currentCell,"CC SP"]=gensub(/D0/,"d",1,gensub(/:$/,"",1,$1))
		}
		#0014: [cellFroId 21]: printing allocated F-DCPCH time positions
		else if ($2=="[cellFroId" && $1 ~ /^[0-9][0-9][0-9][0-9](D01)?:$/)
		{
			currentCell=frocell[gensub(/\].*$/,"",1,$3)+0]
		}
		#0014: Number of opened codes: 0 total number of allocated timepositions: 0
		else if (/Number of opened codes: .*total number of allocated timepositions:/)
		{
			attr[currentCell,"opened codes"]=$6
			attr[currentCell,"allocated timepositions"]=$NF
		}
		else if (/^[0-9][0-9][0-9][0-9](D01)?: [^:]+:/)
		{
			#match($0,/^[0-9][0-9][0-9][0-9]: ([^:]+):/,array)
			match($0,/^[D0-9]+: ([^:]+):/,array)
			if (array[1] ~ /^(cellFroId|RO instance)$/ && sprintf("%s%s%s",currentCell,SUBSEP,"Total ASE DL") in attr && attr[currentCell,"Total ASE DL"]!="") continue
			attr[currentCell,array[1]]=gensub(/^[^:]+:[^:]+:+| |dBm$/,"","g",$0)
			if (array[1] ~ "ASE" && attr[currentCell,array[1]] ~ /\./) attr[currentCell,array[1]]=100*attr[currentCell,array[1]]
			else if (array[1]=="EUL2ms UE Count serving") eul2ms=1
			else if (array[1]=="Speech Only UE Count") spchonly=1
			else if (array[1]=="Speech General UE Count") spchgen=1
			else if (array[1]=="Crnti allocation count") rntialloc=1
			else if (array[1]=="Ernti allocation count") erntialloc=1
			else if (array[1]=="SF64 RL UL Count" || array[1]=="SF128 RL DL Count") sf128=1
		}
		else if (ok!=1 && /^Command not found in the COLI logs.$/)
		{
			customPrint("Command \"celldata\" not found in the COLI logs. Make sure to collect the dcgm with moshell version 10.0h or higher.")
			ok=1
		}
	}
	close(inputfile)
	m=asort(modList)
	n=asort(cellList)
	for (i=1;i<=m;i++)
	{
		modmo=modList[i]
		if (filterbymod==1 && (!((modmo+0) in moduleFilter))) continue
		for (j=1;j<=n;j++)
		{
			cellmo=cellList[j]
			if (filterbycell==1 && (!(gensub(/ /,"","g",cellmo) in cellFilter))) continue
			if (attr[cellmo,"RNC Module"] != modmo) continue
			#0014: RNC Module:                  0                               P5MD
			#0014: cId:                         1165                            all
			#0014: cellFroId:                   149                             P5MD
			#0014: RO instance:                 0				    P5MD
			#0014: Cell froId: 56                                               P4/P5ED
			#0014: Filtered DL Power:           4.78 %                          all
			#0014: pwrAdm:                      75 %                            all
			#0014: dlCodeAdm:                   80 %                            all
			#0014: UL Interference:             -111.5 dBm                      all
			#0014: DL Code Allocation Level:    390 %                           P4/P5ED
			#0014: DL Code Allocation Level:    6.81 %                          P5MD
			#0014: SF8 RL DL Count:             0                               all
			#0014: sf8Adm:                      8                               all
			#0014: SF8 RL UL Count:             0                               P5MD
			#0014: sf8AdmUl:                    8                               P5MD
			#0014: SF16 RL DL Count:            0                               all
			#0014: sf16Adm:                     16                              all
			#0014: SF16 RL UL Count:            0                               P5MD
			#0014: sf16AdmUl:                   16                              P5MD
			#0014: SF32 RL DL Count:            0                               all
			#0014: sf32Adm:                     32                              all
			#0014: SF4 RL UL Count:             0                               P5MD
			#0014: sf4AdmUl:                    0                               P5MD
			#0014: Total ASE DL:                1662                            all
			#0014: aseDlAdm:                    240                             all
			#0014: Total ASE UL:                0                               all
			#0014: aseUlAdm:                    160                             all
			#0014: HSDPA UE Count:              0                               P5MD
			#0014: hsdpaUsersAdm:               10                              P5MD
			#0014: EUL UE Count serving:        0                               P5MD
			#0014: eulServingCellUsersAdm:      32                              P5MD
			#0014: EUL UE Count non-serving:    0                               P5MD
			#0014: eulNonServingCellUsersAdm:   100                             P5MD
			#0014: CPM RL Count:                0                               all
			#0014: compModeAdm:                 15                              all
			#0014: CC SP:                       001900/sp1.lnh/CommonChMainPT   all
			#0014: EUL2ms UE Count serving::    0				    P7
			#0014: eulServingCellUsersAdmTti2:  2                               P7
			#0014: Speech Only UE Count:        0                               W10
			#0014: Crnti allocation count:      0                               W11B
			#0014: Hrnti allocation count:      0                               W11B
			#Ernti allocation count:                  0                         W12B
			#[cellFroId 37]: printing allocated F-DCPCH time positions
			#0014: Number of opened codes: 5 total number of allocated timepositions: 49   W11B
			#Max number of Ernti:                     0                         W12B

			td=attr[cellmo,"Total ASE DL"]/100 ; tu=attr[cellmo,"Total ASE UL"]/100
			attr[cellmo,"Total ASE DL"]=sprintf("%"(td<9.95?"1.1":"3.0")"f",td)
			attr[cellmo,"Total ASE UL"]=sprintf("%"(tu<9.95?"1.1":"3.0")"f",tu)
			if (oldcedformat==1)
			{
				sub("%","",attr[cellmo,"DL Code Allocation Level"])
				if (attr[cellmo,"DL Code Allocation Level"] ~ /[0-9][0-9][0-9]+/) attr[cellmo,"DL Code Allocation Level"]=sprintf("%2.1f%",attr[cellmo,"DL Code Allocation Level"]/100)
				else attr[cellmo,"DL Code Allocation Level"]=sprintf("%2.1f%",attr[cellmo,"DL Code Allocation Level"])
				customPrint(sprintf("%4s %*s %5s %4s %9s %6s %6s %6s %6s %6s %6s %7s %7s %5s %6s %s",\
#MOD     CELL   cid  fro ro PwrDl/Adm dlCode  ulInt  sf8dl  sf16dl sf32dl  sf4ul   dlASE   ulASE HScnt   CPMcnt CC_SP
attr[cellmo,"RNC Module"],lcell,cellmo,attr[cellmo,"cId"],attr[cellmo,"Cell froId"],\
sprintf("%2.1f%",gensub("%","",1,attr[cellmo,"Filtered DL Power"]))" "attr[cellmo,"pwrAdm"],\
attr[cellmo,"DL Code Allocation Level"],\
attr[cellmo,"UL Interference"],\
attr[cellmo,"SF8 RL DL Count"]"/"attr[cellmo,"sf8Adm"],\
attr[cellmo,"SF16 RL DL Count"]"/"attr[cellmo,"sf16Adm"],\
attr[cellmo,"SF32 RL DL Count"]"/"attr[cellmo,"sf32Adm"],attr[cellmo,"SF4 RL UL Count"]"/"attr[cellmo,"sf4AdmUl"],\
attr[cellmo,"Total ASE DL"]"/"attr[cellmo,"aseDlAdm"],attr[cellmo,"Total ASE UL"]"/"attr[cellmo,"aseUlAdm"],\
attr[cellmo,"HSDPA UE Count"]"/"attr[cellmo,"hsdpaUsersAdm"],\
attr[cellmo,"CPM RL Count"]"/"attr[cellmo,"compModeAdm"],attr[cellmo,"CC SP"]))
			}
			else
			{
				tmpcell=gensub(/ /,"","g",cellmo)
				tmpmod=ccModule[attr[cellmo,"CC SP"]] #; print "tmpmod="tmpmod
				tmpccinfo=""
				if (tmpmod!="")tmpccinfo=sprintf("%2s:",tmpmod)
				tmpccinfo=sprintf("%s%s",tmpccinfo,attr[cellmo,"CC SP"])
				if ((tmpmod+0)!=(attr[cellmo,"RNC Module"]+0) && tmpmod!="")
				{
					tmpccinfo=sprintf("%s(!)",tmpccinfo)
					#print "debug:"cellmo,iubConnection[tmpcell]
					faultyIubList[iubConnection[tmpcell]]=iubConnection[tmpcell]
					faultyIubs++
				}
				if (inputoptions!~"z") customPrint(sprintf("%4s %*s %5s %4s %3s %9s %6s %6s %4s %4s %5s %5s %5s %6s %s%7s %7s %5s %5s %5s %6s %s%s%s%s%s%s",\
#MOD     CELL   cid  fro ro PwrDl/Adm dlCode  ulInt  sf8dl  sf8ul sf16dl sf16ul sf32dl  sf4ul   dlASE   ulASE HScnt   EULs  EULns CPMcnt CC_SP
attr[cellmo,"RNC Module"],lcell,cellmo,attr[cellmo,"cId"],attr[cellmo,"cellFroId"],attr[cellmo,"RO instance"],\
sprintf("%2.1f%",gensub("%","",1,attr[cellmo,"Filtered DL Power"]))" "attr[cellmo,"pwrAdm"],\
sprintf("%2.1f%",gensub("%","",1,attr[cellmo,"DL Code Allocation Level"])),\
attr[cellmo,"UL Interference"],\
attr[cellmo,"SF8 RL DL Count"]"/"attr[cellmo,"sf8Adm"],attr[cellmo,"SF8 RL UL Count"]"/"attr[cellmo,"sf8AdmUl"],\
attr[cellmo,"SF16 RL DL Count"]"/"attr[cellmo,"sf16Adm"],attr[cellmo,"SF16 RL UL Count"]"/"attr[cellmo,"sf16AdmUl"],\
attr[cellmo,"SF32 RL DL Count"]"/"attr[cellmo,"sf32Adm"],attr[cellmo,"SF4 RL UL Count"]"/"attr[cellmo,"sf4AdmUl"],\
(sf128==1?sprintf("%6s %6s ",attr[cellmo,"SF128 RL DL Count"]"/"attr[cellmo,"sf128Adm"],attr[cellmo,"SF64 RL UL Count"]"/"attr[cellmo,"sf64AdmUl"]):""),\
attr[cellmo,"Total ASE DL"]"/"attr[cellmo,"aseDlAdm"],attr[cellmo,"Total ASE UL"]"/"attr[cellmo,"aseUlAdm"],\
attr[cellmo,"CPM RL Count"]"/"attr[cellmo,"compModeAdm"],\
attr[cellmo,"HSDPA UE Count"]"/"attr[cellmo,"hsdpaUsersAdm"],\
attr[cellmo,"EUL UE Count serving"]"/"attr[cellmo,"eulServingCellUsersAdm"],\
attr[cellmo,"EUL UE Count non-serving"]"/"attr[cellmo,"eulNonServingCellUsersAdm"],\
(eul2ms==1?sprintf("%4s ",attr[cellmo,"EUL2ms UE Count serving"]"/"attr[cellmo,"eulServingCellUsersAdmTti2"]):""),\
(spchonly==1?sprintf("%4s ",attr[cellmo,"Speech Only UE Count"]):""),\
(spchgen==1?sprintf("%5s ",attr[cellmo,"Speech General UE Count"]):""),\
(rntialloc==1?sprintf("%5s %3s %3s ",attr[cellmo,"opened codes"]"/"attr[cellmo,"allocated timepositions"],attr[cellmo,"Crnti allocation count"],attr[cellmo,"Hrnti allocation count"]):""),\
(erntialloc==1?sprintf("%3s ",attr[cellmo,"Ernti allocation count"]):""),\
tmpccinfo))
				cedTotal["cell"]++
				cedTotal["sf8dl"]+=attr[cellmo,"SF8 RL DL Count"]
				cedTotal["sf8ul"]+=attr[cellmo,"SF8 RL UL Count"]
				cedTotal["sf16dl"]+=attr[cellmo,"SF16 RL DL Count"]
				cedTotal["sf16ul"]+=attr[cellmo,"SF16 RL UL Count"]
				cedTotal["sf32dl"]+=attr[cellmo,"SF32 RL DL Count"]
				cedTotal["sf4ul"]+=attr[cellmo,"SF4 RL UL Count"]
				cedTotal["sf128dl"]+=attr[cellmo,"SF128 RL DL Count"]
				cedTotal["sf64ul"]+=attr[cellmo,"SF64 RL UL Count"]
				cedTotal["dlAse"]+=attr[cellmo,"Total ASE DL"]
				cedTotal["ulAse"]+=attr[cellmo,"Total ASE UL"]
				cedTotal["HScnt"]+=attr[cellmo,"HSDPA UE Count"]
				cedTotal["EULs"]+=attr[cellmo,"EUL UE Count serving"]
				cedTotal["EULns"]+=attr[cellmo,"EUL UE Count non-serving"]
				cedTotal["Eul2ms"]+=attr[cellmo,"EUL2ms UE Count serving"]
				cedTotal["Spch"]+=attr[cellmo,"Speech Only UE Count"]
				cedTotal["SpchG"]+=attr[cellmo,"Speech General UE Count"]
				cedTotal["CPMcnt"]+=attr[cellmo,"CPM RL Count"]
				cedTotal["crncnt"]+=attr[cellmo,"Crnti allocation count"]
				cedTotal["hrncnt"]+=attr[cellmo,"Hrnti allocation count"]
				cedTotal["erncnt"]+=attr[cellmo,"Ernti allocation count"]
				cedTotal["fdpch"]+=attr[cellmo,"opened codes"]
			}
		}
	}
	customPrint("------------------------------------------------------------------------------------------------------------------------------------------------------------------")
	#customPrint("Total: "n" Cells")
	customPrint(sprintf("%*s %4s %4s %5s %5s %5s %6s %s%7s %7s %5s %5s %5s %6s%s%s%s%s%s",\
(lcell+44),"Total ("cedTotal["cell"]+0" cells):",cedTotal["sf8dl"],cedTotal["sf8ul"],cedTotal["sf16dl"],cedTotal["sf16ul"],\
cedTotal["sf32dl"],cedTotal["sf4ul"],\
(sf128==1?sprintf("%6s %6s ",cedTotal["sf128dl"],cedTotal["sf64ul"]):""),\
cedTotal["dlAse"],cedTotal["ulAse"],cedTotal["CPMcnt"],cedTotal["HScnt"],cedTotal["EULs"],cedTotal["EULns"],\
(eul2ms==1?sprintf(" %4s",cedTotal["Eul2ms"]):""),(spchonly==1?sprintf(" %4s",cedTotal["Spch"]):""),(spchgen==1?sprintf(" %5s",cedTotal["SpchG"]):""),\
(rntialloc==1?sprintf(" %s%3s %3s",(inputoptions!~"z"?sprintf("%5s ",cedTotal["fdpch"]):""),cedTotal["crncnt"],cedTotal["hrncnt"]):""),\
(erntialloc==1?sprintf(" %3s",cedTotal["erncnt"]):"")))
	customPrint("------------------------------------------------------------------------------------------------------------------------------------------------------------------")
#The following info is now in the help instead
#	if (faultyIubs < 1 || oldcedformat==1) return
#	n=asort(faultyIubList)
#	faultyiublist=""
#	for (i=1;i<=n;i++) { if (faultyIubList[i]!="") faultyiublist=faultyiublist"|"faultyIubList[i]}
#	sub(/^\|/,"",faultyiublist)
#	customPrint(sprintf("\nINFO: \n\
#Some cells (marked with !) are using CC devices belonging to a different module than the one on which the site is defined.\n\
#This affects the paging performance, see PLM info #510.\n\
#The problem can be solved by running the following command: \n\
#setc iublink=(%s)$ %s\n\
#Then run bor and cedr to check again that the problem is cleared.",faultyiublist,subrackrefattribute))
}
function cedh_function(inputvariables,    liub,iub,mod,frolist,ncelllist,currentMod,currentGrp,array,P5_NODE,\
moduleFilter,filterbymod,rbsFilter,filterbyrbs,tmparray,percent,inhwm,inRL,w11,ok,z,a,i,rbsFilterT,tId)
{
	parse_inputvars(inputvariables)
	if (inputoptions ~ "p") percent=1
	inputfile=commandfile
	split(currentDir,array,SUBSEP)
	liub=array[1]
	if (array[2] ~ /^[0-9]/) { filterbymod=1 ; split(array[2],tmparray,",") ; for (i in tmparray) moduleFilter[tmparray[i]+0]=1 }
	if (array[3] != "")
	{
		filterbyrbs=1
		#rbsFilter=array[3]
		split(array[3],a,",")
		for (i in a) rbsFilterT[a[i]]=1
	}
	GtotUE=GtotDL=GtotUL=0

	#IubLink=1002                                            froid             1
	#001400  GPB53            1  GPB_Module                      aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod1 modact modms mp
	#001500  GPB53           13  GPB_Module                      aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod13 modact modms mp
	#001600  GPB53            8  GPB_Module                      aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod8 modact modms mp

	#hwm list grp
	#P5:
	#0016: Index   localId  iubLinkFroId  DlCred  DlCons  Cells Last BE-Req
	#0014: 0    *  0        0             264     0       3     --
	#0016: 0    *  0        1             264     0       3     --
	#P6:
	#0912: Index   localId  iubLinkFroId  DlCred  DlCons  Cells
	#0912: 0    *  1        201           64      25      6
	#0914: 0    *  -1       203           264     0       0
	#0912: 2       2879     464           60000   0       1

	#GPB75: same group number can appear in each core
	#$ lhsh 010200 hwm list grp
	#0102: Cellgroups =>
	#0102: Index   localId  iubLinkFroId  DlCred  DlCons  Cells
	#0102: ----------------------------------------------------
	#0102: 10      0        46            60000   0       3
	#0102: 42      0        187           60000   1       3
	#0102: 60      0        266           60000   1       3
	#0102: Cellgroups =>
	#0102: Index   localId  iubLinkFroId  DlCred  DlCons  Cells
	#0102: ----------------------------------------------------
	#0102: 10      0        259           60000   9       3

	#hwm list rbs
	#0014: Index  IubLinkFroId   CellGroup
	#0014: ------------------------------------------
	#0014: Index  IubLinkFroId   CellGroup
	#0014: ------------------------------------------
	#0014: 0    * 5
	#0014:                            0
	#0014:                            1
	#0014: 1      18

	#0016: CellGrp Index: 0 lci: 0  ==>
	#0016: Dl Capacity Credit : 264
	#0016: Ul Capacity Credit : 256
	#0016: Dl Consumed Credit : 0
	#0016: Ul Consumed Credit : 0

	#P4
	#0117: Guaranteed,    Other :    16(100%)15          16(100%)15
	#0117: Guaranteed-Hs, Other :    16(100%)15          16(100%)15
	#0117: NonGuaranteed, Other :    16(100%)15          16(100%)15
	#0117: *           Handover :    16(100%)15          16(100%)15

	#P5:
	#0912: (Tot(Tot%),Avail)           DL                UL
	#0016: Guaranteed,        HO:    264(100%)264        256(100%)256
	#0016: Guaranteed,     Other:    264(100%)264        256(100%)256
	#P6:
	#0016: (Tot(Tot%),Avail)              DL                UL
	#0912: Guaranteed,     HO:  60000(100%)60000    60000(100%)60000
	#0912: Other             :  60000(100%)60000    60000(100%)60000

	while ((getline < inputfile)>0)
	{
		gsub("\r","")
		if (($4 ~ /^RNC_NODE_MODEL_/ && $4 >= "RNC_NODE_MODEL_M")||($4 ~ /^TDRNC_NODE_MODEL_/ && $4 >= "TDRNC_NODE_MODEL_C"))
		{
			#101129-14:44:50 a.b.c.d 8.0p RNC_NODE_MODEL_M_1_75_COMPLETE stopfile=/tmp/26687
			w11=1
		}
		else if ($1=="rncModBoTable") rncModBoTable[$2]=$3
		else if ($1=="firstModProgInstanceId") firstModProgInstanceId[$2]=$3
		else if ($1 ~ /^[0-9][0-9][0-2][0-9](D01)?:$/ && $2=="CellGrp" && $3=="Index:")
		{
			#0005: CellGrp Index: 0 lci: 0  ==>
			currentGrp=$4
		}
		else if ($0 ~ /[0-9][+x][0-9]/ || ($2=="I" && $3=="CellFroId" && $4=="UeLmId"))
		{
			if ($2=="I" && $3=="CellFroId" && $4=="UeLmId")	inRL=1
			continue #1113:           4      8      16     32     64     128    256 2(2+4)    2x2    2x4
		}
		else if (/hwm [0-9]+ print grp|hwm list (grp|rbs)/)
		{
			#$ lhsh 010200 hwm 0 print grp
			#$ lhsh 000600 hwm list grp
			#$ lhsh 000600 hwm list rbs
			if (/hwm [0-9]+ print grp/)
			{
				inhwmprintgrp=1
				currentMod=rncModBoTable[$(NF-4)]
			}
			else currentMod=rncModBoTable[$(NF-3)]
			#if (currentMod ~ /^[0-9][0-9][0-9][0-9]$/) currentMod--   #multicore GPB
		}
		else if (/Now printing for instance with Id [1-9]/)
		{
			#0005: Now printing for instance with Id 4
			currentMod=cedhmod($1,$NF)
		}
		#else if (($2=="Index" && $3=="localId" && $4=="iubLinkFroId")||($2=="Index" && $3=="IubLinkFroId" && $4=="CellGroup"))
		#{
		#	#0006: Index  IubLinkFroId   CellGroup
		#	#0912: Index   localId  iubLinkFroId  DlCred  DlCons  Cells
		#	#if (currentMod ~ /^[0-9][0-9][0-9][0-9]$/) currentMod++
		#}
		else if (tolower($2)=="froid" && $1 ~ /^IubLink=/)
		{
			#IubLink=1002                         froId             1
			#IubLink=1002                         froid             1
			iub[$3]=gensub(/^.*=/,"",1,$1)
		}
		#else if ($1 ~ /^[0-9][0-9][0-2][0-9]00$/ && $3 ~ /^[0-9]+$/)
		#{
		#	#001400  GPB53            1  GPB_Module                      aal2ap aal2cpsrc aal2ncc aal2rh all allp mod mod1 modact modms mp
		#	mod[$1]=$3
		#}
		else if ($1 ~ /^[0-9][0-9][0-2][0-9](D01)?:$/ && $2 ~ /^[0-9]+$/ && $3 ~ /^[-*0-9]+$/ && $4 ~ /^[-0-9]+$/ && \
			$5 ~ /^[0-9]+(\.[0-9]+)?$/ && $6 ~ /^[0-9]+(\.[0-9]+)?$/ && ($7 ~ /^([0-9]|[12][0-9])$/ || $8 ~ /^([0-9]|[12][0-9])$/))
		{
			#0912: 0    *  1        201           64      25      6
			#new format W16B:
			#0006: 0    *  0        8        18000.0     0.0     6
			frolist[currentMod,$2]=($3=="*" ? $5 : $4)
			ncelllist[currentMod,$2]=($3=="*" ? $8 : $7)
		}
		else if (inhwmprintgrp != 1 && $1 ~ /^[0-9][0-9][0-2][0-9](D01)?:$/ && $2 ~ /^[0-9]+$/ && $3 ~ /^[-*0-9]+$/ && $4 ~ /^([-0-9]+|)$/ && NF<=4)
		{
			iubfroro[($3=="*"?$4:$3)]=$2
		}
		else if ($1 ~ /^[0-9][0-9][0-2][0-9](D01)?:$/ && $0 ~ "Dl Capacity Credit") DlCapCred =gensub(/\.0+$/,"",1,$NF)
		else if ($1 ~ /^[0-9][0-9][0-2][0-9](D01)?:$/ && $0 ~ "Ul Capacity Credit") UlCapCred =gensub(/\.0+$/,"",1,$NF)
		else if ($1 ~ /^[0-9][0-9][0-2][0-9](D01)?:$/ && $0 ~ "Dl Consumed Credit") DlConsCred=gensub(/\.0+$/,"",1,$NF)
		else if ($1 ~ /^[0-9][0-9][0-2][0-9](D01)?:$/ && $0 ~ "Ul Consumed Credit") UlConsCred=gensub(/\.0+$/,"",1,$NF)
		else if ($1 ~ /^[0-9][0-9][0-2][0-9](D01)?:$/ && $2 ~ /^(\*|NonGuaranteed,)$/ && $3 ~ /^(HO:|Handover)$/)
		{
			#P4: *           Handover :    16(100%)15          16(100%)15
			#P4: *           Handover :    16(100%)-2          16(100%)-14
			#P5: NonGuaranteed,     HO:    384(100%)384        256(100%)256
			#P6: nothing
			#COMMENTED OUT P5_NODE setting
			#P5_NODE=1 #---> we will not include the P5 specific columns because we need that space for UE/DL/RL/leaks columns
			match($0,/ ([-0-9]+)(\([^)]+\))([-0-9]+) +([-0-9]+)(\([^)]+\))([-0-9]+)/,array)
			ngHOCEdl=array[3]"/"array[1] #gensub(" ","","g",array[2])
			ngHOCEul=array[6]"/"array[4] #gensub(" ","","g",array[5])
			if ($2=="*") { freeHoCEdl=ngHOCEdl ; freeHoCEul=ngHOCEul }  #P4
		}
		else if ($1 ~ /^[0-9][0-9][0-2][0-9](D01)?:$/ && $2 == "NonGuaranteed," && $3 ~ /^Other(|:)$/)
		{
			#P4: NonGuaranteed, Other :    16(100%)15          16(100%)15
			#P5: NonGuaranteed,  Other:    384(100%)384        256(100%)256
			#P6: nothing
			match($0,/ ([-0-9]+)(\([^)]+\))([-0-9]+) +([-0-9]+)(\([^)]+\))([-0-9]+)/,array)
			ngOthrCEdl=array[3]"/"array[1] #gensub(" ","","g",array[2])
			ngOthrCEul=array[6]"/"array[4] #gensub(" ","","g",array[5])
		}
		else if ($1 ~ /^[0-9][0-9][0-2][0-9](D01)?:$/ && (($2 == "Guaranteed," && $3 ~ /^Other(|:)$/)||($2=="Other" && $3==":")))
		{
			#P4: Guaranteed,    Other :    16(100%)15          16(100%)15
			#P5: Guaranteed,     Other:    384(100%)384        256(100%)256
			#P6: Other             :     44( 70%)44          44( 70%)44
			#W16B
			#0005: Guaranteed,     HO:  60000.0(100%)60000.0    60000.0(100%)60000.0
			#0005: Other             :  60000.0(100%)60000.0    60000.0(100%)60000.0
			match($0,/ ([-0-9.]+)(\([^)]+\))([-0-9.]+) +([-0-9.]+)(\([^)]+\))([-0-9.]+)/,array)
			for (z in array) sub(/\.0+$/,"",array[z])
			freeOthrCEdl=array[3]"/"array[1] #gensub(" ","","g",array[2])
			freeOthrCEul=array[6]"/"array[4] #gensub(" ","","g",array[5])
			freeOthrCEdlPc=sprintf("%5.1f%",100*mDiv(array[3],array[1]))
			freeOthrCEulPc=sprintf("%5.1f%",100*mDiv(array[6],array[4]))
		}
		else if ($1 ~ /^[0-9][0-9][0-2][0-9](D01)?:$/ && $2 ~ /^(\*|Guaranteed,)$/ && $3 ~ /^(HO:|Handover)$/)
		{
			#P4: *           Handover :    16(100%)15          16(100%)15
			#P5: Guaranteed,     HO:     64(100%)64          64(100%)64
			#P6: Guaranteed,     HO:     64(100%)64          64(100%)64
			#W16B
			#0005: Guaranteed,     HO:  60000.0(100%)60000.0    60000.0(100%)60000.0
			#0005: Other             :  60000.0(100%)60000.0    60000.0(100%)60000.0
			match($0,/ ([-0-9.]+)(\([^)]+\))([-0-9.]+) +([-0-9.]+)(\([^)]+\))([-0-9.]+)/,array)
			for (z in array) sub(/\.0+$/,"",array[z])
			freeHoCEdl=array[3]"/"array[1] #gensub(" ","","g",array[2])
			freeHoCEul=array[6]"/"array[4] #gensub(" ","","g",array[5])
			freeHoCEdlPc=sprintf("%5.1f%",100*mDiv(array[3],array[1])) #gensub(" ","","g",array[2])
			freeHoCEulPc=sprintf("%5.1f%",100*mDiv(array[6],array[4])) #gensub(" ","","g",array[5])
		}
		else if (/RadioLink Sets -->  #Links/)
		{
			inhwm=1
			delete ueRL ; delete dlRL ; delete ulRL
			leaks=""
			totUE=totDL=totUL=0
		}
		else if (inRL==1 && NF==3 && $1~/^[0-9][0-9][0-2][0-9](D01)?:$/ && $2 ~ /^[0-9]$/ && $3 ~ /^[0-9]+$/) currcell=$3
		else if (inRL==1 && $1~/^[0-9][0-9][0-2][0-9](D01)?:$/)
		{
			#The CmIndex column is new with RNC in pool
			#0005: I CellFroId    UeLmId  CmIndex     4      8      16     32     64     128    256 2(2+4)    2x2    2x4
			#0005: -----------------------------------------------------------------------------------------------------
			#0005: 0  3
			#0005:                0       0     Dl |  0      0      0      0      0      2      1      0      0      0

			if ($2 ~ /^[0-9]+$/ && (($3=="Dl" && $4=="|")||($4=="Dl" && $5=="|")))
			{
				for (i=5;i<=NF;i++) { sub(/,.*$/,"",$i) ; dlRL[currcell]+=$i}

			}
			else if ($2 ~ /^(Ul|EDCH)$/ && $3 == "|")
			{
				for (i=4;i<=NF;i++) { sub(/,.*$/,"",$i) ; ulRL[currcell]+=$i}
			}
			else if (($2~/^[0-9]+$/ && $3~/^[0-9]+$/ && $4~/^[0-9]+$/)&&((NF==4)||(NF==5 && $5~/^[0-9]+$/)||(NF==6 && $5~/^[0-9]+$/ && $6~/^[0-9]+$/)))
			{
				hasUE=1
				ueRL[currcell]++
			}
		}
		else if (ok!=1 && /^Command not found in the COLI logs.$/)
		{
			customPrint("Command \"hwm\" not found in the COLI logs. Make sure to collect the dcgm with moshell version 10.0h or higher.")
			ok=1
		}

		if ((inhwm==1 && /^(Log close: |==================================================================================)/)||\
		    (inhwm==1 && /Now printing for instance with Id [1-9]/ && $NF > firstModProgInstanceId[make_fullbd($1)]))
		{
			inRL=0
			if (/Now printing for instance with Id [1-9]/)
			{
				currentMod=old_currentMod
				#currentMod--
			}
			#print currentMod,currentGrp,frolist[currentMod,currentGrp],iub[frolist[currentMod,currentGrp]],$0
			if (filterbymod==1 && (!(currentMod in moduleFilter)))
			{
				if (/Now printing for instance with Id [1-9]/)
				{
					currentMod=old_currentMod=cedhmod($1,$NF)
				}
				continue
			}
			if (filterbyrbs==1 && rbsFilterT[iub[frolist[currentMod,currentGrp]]] != 1)
			{
				if (/Now printing for instance with Id [1-9]/)
				{
					currentMod=old_currentMod=cedhmod($1,$NF)
				}
				continue
			}
			if (iub[frolist[currentMod,currentGrp]] == "")
			{
				#if ($1 ~ /^[0-9][0-9][0-2][0-9]:$/ && $2=="CellGrp" && $3=="Index:" && currentMod ~ /^[0-9][0-9][0-9][0-9]$/) currentMod++
				if (/Now printing for instance with Id [1-9]/)
				{
					currentMod=old_currentMod=cedhmod($1,$NF)
				}
				continue
			}
			if (percent)
			{
				usedCEdl=sprintf("%5.1f%",100*mDiv(DlConsCred,DlCapCred))
				usedCEul=sprintf("%5.1f%",100*mDiv(UlConsCred,UlCapCred))
			}
			else
			{
				usedCEdl=DlConsCred"/"DlCapCred
				usedCEul=UlConsCred"/"UlCapCred
			}
			cedhTotalIub[iub[frolist[currentMod,currentGrp]]]=1
			cedhTotal["usedCEdl"]+=DlConsCred
			cedhTotal["totCEdl"]+=DlCapCred
			cedhTotal["usedCEul"]+=UlConsCred
			cedhTotal["totCEul"]+=UlCapCred
			cedhTotal["gHoCEdla"]+=gensub(/\/.*$/,"",1,freeHoCEdl)
			cedhTotal["gHoCEdlb"]+=gensub(/^.*\//,"",1,freeHoCEdl)
			cedhTotal["gHoCEula"]+=gensub(/\/.*$/,"",1,freeHoCEul)
			cedhTotal["gHoCEulb"]+=gensub(/^.*\//,"",1,freeHoCEul)
			cedhTotal["OtherCEdla"]+=gensub(/\/.*$/,"",1,freeOthrCEdl)
			cedhTotal["OtherCEdlb"]+=gensub(/^.*\//,"",1,freeOthrCEdl)
			cedhTotal["OtherCEula"]+=gensub(/\/.*$/,"",1,freeOthrCEul)
			cedhTotal["OtherCEulb"]+=gensub(/^.*\//,"",1,freeOthrCEul)
			if (percent)
			{
				freeOthrCEdl=freeOthrCEdlPc
				freeOthrCEul=freeOthrCEulPc
				freeHoCEdl=freeHoCEdlPc
				freeHoCEul=freeHoCEulPc
			}
			for (i in dlRL)
			{
				if (hasUE!=1) ueRL[i]=dlRL[i]
				totUE+=ueRL[i] ; totDL+=dlRL[i] ; totUL+=ulRL[i]
				#until W10, we must have nrUE = nrDlRL = nrUlRL
				#from W11, we must have nrUE >= nrDlRL and nrUlRL >= nrDlRL and nrDlRL >= nrDchUlRL
				#but if nrUlRL > 2*nrDlRL or nrUE > 2*nrDlRL then there is hanging. dont do this check if there is only a few calls.
				#print i,ueRL[i]" "ulRL[i]" "dlRL[i]" "(ueRL[i]> (2*dlRL[i]))" "(ulRL[i]> (2*dlRL[i]))
				if ( ((w11!=1) && (!(ueRL[i]==dlRL[i] && ulRL[i]==dlRL[i]))) || \
				     ((w11==1) && (!(ueRL[i]>=dlRL[i] && ulRL[i]>=dlRL[i]))) || \
				     ((w11==1) && ((ueRL[i]> (2*dlRL[i])) || (ulRL[i]> (2*dlRL[i]))) && (dlRL[i]>=5 || ulRL[i]>=10 || ueRL[i]>=10)) )
				{
					leaks=leaks","i ;   sub(/^,/,"",leaks)
					Gleaks=Gleaks","i ; sub(/^,/,"",Gleaks)
					iLeak[iub[frolist[currentMod,currentGrp]]]=iub[frolist[currentMod,currentGrp]]
				}
			}
			GtotUE+=totUE  ; GtotDL+=totDL  ; GtotUL+=totUL
			customPrint(sprintf("%4s %3s %*s %4s %2s %5s %11s %11s %13s %13s %13s %13s %4s %4s %4s  %s%s",\
currentMod,currentGrp,liub,iub[frolist[currentMod,currentGrp]],frolist[currentMod,currentGrp],iubfroro[frolist[currentMod,currentGrp]],\
ncelllist[currentMod,currentGrp],usedCEdl,usedCEul,freeHoCEdl,freeHoCEul,freeOthrCEdl,freeOthrCEul,totDL,totUL,totUE,leaks,\
(P5_NODE==1 ? sprintf(" %10s %10s %10s %10s",ngHOCEdl,ngHOCEul,ngOthrCEdl,ngOthrCEul) : "")))
		}

		if (/Now printing for instance with Id [1-9]/)
		{
			currentMod=old_currentMod=cedhmod($1,$NF)
		}

	}
	close(inputfile)
	customPrint("-------------------------------------------------------------------------------------------------------------------------------------------")
	for (i in cedhTotalIub) j++
	if (percent!=1)
	{
		customPrint(sprintf("%*s %11s %11s %13s %13s %13s %13s %4s %4s %4s %s",\
(23+liub),"Total ("j+0" sites):",cedhTotal["usedCEdl"]"/"cedhTotal["totCEdl"],cedhTotal["usedCEul"]"/"cedhTotal["totCEul"],\
cedhTotal["gHoCEdla"]"/"cedhTotal["gHoCEdlb"],cedhTotal["gHoCEula"]"/"cedhTotal["gHoCEulb"],\
cedhTotal["OtherCEdla"]"/"cedhTotal["OtherCEdlb"],cedhTotal["OtherCEula"]"/"cedhTotal["OtherCEulb"],\
GtotDL,GtotUL,GtotUE,Gleaks))
	}
	customPrint(sprintf("%*s %11s %11s %13s %13s %13s %13s%s",(23+liub),(percent!=1?"":"Total ("j+0" sites):"),\
sprintf("(%.1f%)",mDiv(cedhTotal["usedCEdl"],cedhTotal["totCEdl"])*100),     sprintf("(%.1f%)",mDiv(cedhTotal["usedCEul"],cedhTotal["totCEul"])*100),\
sprintf("(%.1f%)",mDiv(cedhTotal["gHoCEdla"],cedhTotal["gHoCEdlb"])*100),    sprintf("(%.1f%)",mDiv(cedhTotal["gHoCEula"],cedhTotal["gHoCEulb"])*100),\
sprintf("(%.1f%)",mDiv(cedhTotal["OtherCEdla"],cedhTotal["OtherCEdlb"])*100),sprintf("(%.1f%)",mDiv(cedhTotal["OtherCEula"],cedhTotal["OtherCEulb"])*100),\
(percent!=1?"":sprintf(" %4s %4s %4s %s",GtotDL,GtotUL,GtotUE,Gleaks))))
	n=asort(iLeak)
	if (n>0)
	{
		for (i=1;i<=n;i++) iLeakString=iLeakString","iLeak[i]
		sub(/^,/,"",iLeakString)
		customPrint("Following IubLinks contain hanging resources: "iLeakString"\nThe hangings can be released by lock/unlock the IubLink.")
	}
}
function cedhmod(var1,var2,   tId)
{
	tId=var2
	if (cpplinux==1 && var1 ~ /D01:$/)
	{
		#until 19Q1 (V_1_16) the modules on C1 blades were called 1/2/3 but after 19Q2 (V_1_17) they are called 5/6/7
		if ((var1!~/^00(03|25)/)||(var1~/^00(03|25)/ && rncModBoTable[make_fullbd(var1),tId]=="")) tId+=4
		#print mom_version,var1,make_fullbd(var1),tId,rncModBoTable[make_fullbd(var1),tId],$0
	}
	return rncModBoTable[make_fullbd(var1),tId]
}
####################################################################################################################
# TG FUNCTIONS P3
####################################################################################################################
function tg_p3_parsing(inputvariables,   frofilter,mofilter,modRef,maxMod,iubRef,cellRef,cellList,currentMp,currentActor,cfro,\
ifro,mfro,cid,cfroRef,ifroRef,cellCfroRef,mfroRef,actorCellRef,mpRef,modMfroRef,actorIubRef,ccRef,ccModRef,n,i,j,z,motypes,\
proxyList,otherVars,p,condition,tempmoid,inputfile,moFilterList,childrenActor,actorreffilter)
{
	#Global tables:
	#	modMfroRef[mfro]=mod  --> to show link between module ID and module FRO
	#	actorRef[cell]=actor --> to show link between Cell ID and cell actor
	#       actorRef[iub]=actor   --> to show link between Iub  ID and iub actor
	# 	make MO groups: cellmod1, cellmod2, etc
	#			iubmod1, iubmod2, etc
	#	Then: tg cellmod1 info
	#	      tg cellmod1 getattr cellData
	#	      tg cellmod1 state
	parse_inputvars(inputvariables)
	Filter1=inputoptions
	if (Filter1 ~ ":/")
	{
		#to fetch data from actors that are children to the Iub/Cell actors
		childrenActor=gensub(/^.*:\//,"/",1,Filter1)
		Filter1=gensub(/:\/.*$/,"",1,Filter1)
	}
	#inputfile=sprintf("%s/cache/%s.tg",logdir,node_address)   #also defined in prog.awk as tgtablesfile
	inputfile=commandfile
	tgCommand=currentDir

	defineErrorCodes()
	if (Filter1 ~ /^[^0-9]/) mofilter=Filter1
	else if (Filter1 ~ /^[0-9]+$/) frofilter=Filter1+0
	modConversionMethod="old"
	while ((getline < inputfile)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if ($2=="programInstanceId" && $1 ~ /^RncModule=/)
		{
			if ($3 > 0) modConversionMethod="new" ; else modConversionMethod="old"
		}
		else if ($2=="rpuRefs" && $1 ~ /^RncModule=/)
		{
			currentModule=$1
			tmpRncModNumber=convert_modname_tonumber(currentModule,modConversionMethod)
			rncModuleList[tmpRncModNumber]=tmpRncModNumber
			rncModuleNumber[currentModule]=tmpRncModNumber
			rncModuleName[tmpRncModNumber]=gensub(/^.*=/,"",1,currentModule)
		}
		#else if ($2=="rpuRefs" && $1 ~ /^RncModule=/)
		#{
		#	currentModule=$1
		#	tmpRncModNumber=gensub(/^.*=/,"",1,$1)+0
		#	if ($1 ~ /RncModule=.*[-A-Z].*$/)
		#	{
		#		#WRNae73332 , sometimes rpuRefs is not set : RncModule=MS-6-0       rpuRefs           [0] =
		#		if (gensub(/\[|\]/,"","g",$3)+0 == 0) tmpRncModNumber=convert_modname_tonumber($1,modConversionMethod)
		#	}
		#	if (tmpRncModNumber > 0) rncModuleNumber[$1]=tmpRncModNumber
		#}
		#else if (tmpRncModNumber==0 && $1==">>>" && $2=="rpuRefs")
		#{
		#	tmpRncModNumber=gensub(/^.*_/,"",1,$4)
		#	if (tmpRncModNumber+0 > 0) tmpRncModNumber+=0
		#	else tmpRncModNumber=convert_modname_tonumber(tmpRncModNumber,modConversionMethod)
		#	rncModuleNumber[currentModule]=tmpRncModNumber
		#}
		#IubLink=10                                                rncModuleRef       RncModule=2
		else if ($1 ~ /^IubLink=/ && $2=="rncModuleRef")
		{
			iubList[$1]=$1
			modRef[$1]=rncModuleNumber[$3]
			if (modRef[$1] > maxMod) maxMod=modRef[$1]
		}
		#UtranCell=90123                                           iubLinkRef         IubLink=9012
		else if ($1 ~ /^UtranCell=/ && $2=="iubLinkRef")
		{
			iubRef[$1]=$3
			modRef[$1]=modRef[iubRef[$1]]
		}
		#UtranCell=90123                                           cId                12
		else if ($1 ~ /^UtranCell=/ && $2=="cId")
		{
			cellRef[$3]=$1
			cellList[$1]=$1
		}
		#$ lhsh 001400 rrt-CXC1328008_R8U01 getattr 1/1/1/1/2/1.1 cellData
		#$ lhsh 001400 rrt-RncLmCell getattr 1/1/1/1/2/1.1-120 cellData
		else if ($1 == "$" && $2=="lhsh" && $4 ~ /^rrt-(CXC1[37]2|RncLmCell)/ && $NF=="cellData")
		{
			currentMp=$3
			currentActor=$6
			rrt_command=$4
		}
		#P3 TO P5: Value: {areaAttribs{lac 302,t3212 10,att 1,rac 1,nmo 1,sac 1},cellFroId 3,cellRoParameters{admState 1,opState 1,availStatus 0,localCellId 90123,cId 12,tCell 0,uarfcnUl 9714,uarfcnDl 10664,primaryScramblingCode 395,primaryCpichPower 230,maxTxPowerUl 33,bchPower -31,cellReserved 1,treSelection 2,qualMeasQuantity 2,qHyst1 4,qHyst2 4,hoType 1,qQualMin -18,qRxLevMin -111,individualOffset 0,pwrAdm 75,pwrAdmOffset 10,pwrOffset 5,pwrHyst 10,congDlInterval 100,congUlInterval 100,pwrCongFilter 1,tmCongAction 300,releaseAseDl 3,congTimeOut 3000,txInterval 100,txFilter 5,fPwrUp 20,fPwrDown 10,dlCodeAdm 70,aseDlAdm 240,beMarginAseDl 100,aseUlAdm 160,beMarginDlPwr 10,beMarginDlCode 10,beMarginAseUl 20,sf8Adm 8,sf32Adm 32,aseUlAdmOffset 40,tfsFlexConstant 10,minPwrRl -200,maxRate 40690,interRate 7760,minimumRate 1590,maxPwrMax 48,interPwrMax 38,minPwrMax 0,pwrEstFact 30,compModeAdm 15,iFOffset 20,iFHyst 10,iFCong 130,interFreqFddMeasIndicator 0,sRatSearch 4,sIntraSearch 0,sInterSearch 0,fachMeasOccaCycLenCoeff 0,accessClassNBarred 0,noOfUtranCellPosition 0,utranCellPosition{size 15,array{RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 1,latitude -1,longitude -1}}},sf16Adm 16,intCongFilter 1,sib1PlmnScopeValueTag 1,locationAreaFroId 0,serviceAreaFroId 0,routingAreaFroId 0,iubLinkFroId 1,rncModuleId 0,maximumTransmissionPower 400,primarySchPower -18,secondarySchPower -35,usedFreqThresh2dEcno -6,usedFreqThresh2dRscp -103,nOutSyncInd 10,nInSyncInd 10,rlFailureT 10,tmCongActionNg 500,releaseAseDlNg 3,tmInitialG 500,directedRetryTarget -1,loadSharingGsmThreshold 75,loadSharingGsmFraction 100},cellSetupInRbsFlag 1,cgiPtr 0x4de2d428,currMaxTransmissionPower 400,drhCcRefActiveFlag 1,drhCcRef 12 73 211 199 44 74 99 57 80 0 0 0 0,errorStatus 0,SPBlocked 0,spConfigFlag 1,tpcPattern01CountDl 8,rncIdChanged 0}
		#P6: Value: {hsdschRoParamsPtr 0x4c2d3ef0{{froId 1,attrib{admState 1,opState 1,availStatus 0,utranCellFroId 1,deltaAck1 4,deltaCqi1 4,deltaNack1 4,initialCqiRepetitionFactor 1,deltaAck2 8,deltaNack2 8,deltaCqi2 8,initialAckNackRepetitionFactor 1,cqiFeedbackCycle 8,hsMeasurementPowerOffset 80,numHsPdschCodes 1,codeThresholdPdu656 6,numHsScchCodes 1}}},areaAttribs{lac 3011,t3212 10,att 1,rac 1,nmo 1,sac 1002},cellFroId 1,cellRoParameters{admState 1,opState 1,availStatus 0,localCellId 1002,cId 1002,tCell 2,uarfcnUl 9763,uarfcnDl 10713,primaryScramblingCode 5,primaryCpichPower 300,maxTxPowerUl 24,bchPower -31,cellReserved 1,treSelection 2,qualMeasQuantity 2,qHyst1 4,qHyst2 4,hoType 1,qQualMin -18,qRxLevMin -115,individualOffset 0,pwrAdm 75,pwrAdmOffset 10,pwrOffset 5,pwrHyst 30,congDlInterval 100,congUlInterval 100,pwrCongFilter 1,tmCongAction 2000,releaseAseDl 1,congTimeOut 3000,txInterval 100,txFilter 5,fPwrUp 20,fPwrDown 10,dlCodeAdm 80,aseDlAdm 240,beMarginAseDl 100,aseUlAdm 160,beMarginDlPwr 10,beMarginDlCode 10,beMarginAseUl 20,sf8Adm 8,sf32Adm 32,aseUlAdmOffset 40,tfsFlexConstant 10,minPwrRl -150,maxRate 40690,interRate 7760,minimumRate 1590,maxPwrMax 48,interPwrMax 38,minPwrMax 0,pwrEstFact 30,compModeAdm 15,iFOffset 0,iFHyst 6000,iFCong 621,interFreqFddMeasIndicator 0,sRatSearch 4,sIntraSearch 0,sInterSearch 0,fachMeasOccaCycLenCoeff 0,accessClassNBarred 0,noOfUtranCellPosition 6,utranCellPosition{size 15,array{RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 5537317,longitude 836584},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 5537346,longitude 836606},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 5537359,longitude 836535},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 5537320,longitude 836527},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 5537309,longitude 836519},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 5537286,longitude 836541},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1}}},sf16Adm 16,intCongFilter 1,sib1PlmnScopeValueTag 1,locationAreaFroId 0,serviceAreaFroId 1,routingAreaFroId 0,iubLinkFroId 0,rncModuleId 0,maximumTransmissionPower 400,primarySchPower -18,secondarySchPower -35,usedFreqThresh2dEcno -12,usedFreqThresh2dRscp -97,nOutSyncInd 10,nInSyncInd 3,rlFailureT 10,tmCongActionNg 800,releaseAseDlNg 3,tmInitialG 3000,directedRetryTarget -1,loadSharingGsmThreshold 75,loadSharingGsmFraction 100,hardIfhoCorr 3,tmInitialGhs 500,tmCongActionGhs 300,releaseAseDlGhs 0,hsdpaUsersAdm 10,loadSharingMargin 0,sf4AdmUl 4,sf16gAdm 16,sHcsRat -105,sf8AdmUl 8,sf16AdmUl 16,nrOfUraFroId 1,uraFroId 0,sf8gAdmUl 0,agpsEnabled 1,eulServingCellUsersAdm 32,eulNonServingCellUsersAdm 100,codeLoadThresholdDlSf128 100,pwrLoadThresholdDlSpeech{amr12200 100,amr5900 100,amr7950 100},aseLoadThresholdUlSpeech{amr12200 100,amr5900 100,amr7950 100},rateSelectionPsInteractive{channelType 0,ulPrefRate 64,dlPrefRate 64}},cellSetupInRbsFlag 1,currMaxTransmissionPower 400,cgiPtr{{cgi 42}},drhCcRefActiveFlag 1,drhCcRef 12 72 12 152 208 0 0 0 1 0 0 0 0,errorStatus 0,SPBlocked 0,spConfigFlag 1,tpcPattern01CountDl 8,rncIdChanged 0,spAndRbsResourcesConfigured 1,eulRoParamsPtr 0x4c535690{{froId 1,attrib{admState 1,opState 1,availStatus 0,hsdschFroId 1,numEhichErgchCodes 1,numEagchCodes 1,eulMaxTargetRtwp -499}}}}
		#P7, first actor: 0015: ...  cellData  RnhCellDataD  {hsdschRoParamsPtr 0x8c4cd070{{froId 3
		#P7, next actors: 0015: 1.1/1.1/1.1/1.1/2.1/1.22  cellData  RnhCellDataD  {hsdschRoParamsPtr 0x0 0,areaAttribs{lac 3011,t3212 10,att 1,rac 1,nmo 1,sac 1064},cellFroId 63,cellRoParameters{admState 1,opState 1,availStatus 64,localCellId 1064,cId 1064,tCell 4,uarfcnUl 9612,uarfcnDl 10562,primaryScramblingCode 384,primaryCpichPower 300,maxTxPowerUl 24,bchPower -31,cellReserved 1,treSelection 2,qualMeasQuantity 2,qHyst1 4,qHyst2 4,hoType 1,qQualMin -18,qRxLevMin -115,individualOffset 0,pwrAdm 75,pwrOffset 15,pwrHyst 30,pwrCongFilter 1,tmCongAction 2000,releaseAseDl 1,txInterval 100,txFilter 5,fPwrUp 20,fPwrDown 10,dlCodeAdm 80,aseDlAdm 240,aseUlAdm 160,sf8Adm 8,sf32Adm 32,tfsFlexConstant 10,minPwrRl -150,maxRate 40690,interRate 7760,minimumRate 1590,maxPwrMax 48,interPwrMax 38,minPwrMax 0,compModeAdm 15,iFHyst 6000,iFCong 621,interFreqFddMeasIndicator 0,sRatSearch 4,sIntraSearch 0,sInterSearch 0,fachMeasOccaCycLenCoeff 0,accessClassNBarred 0,noOfUtranCellPosition 6,utranCellPosition{size 15,array{RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 1029201,longitude 5546653},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 1030300,longitude 5544456},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 1031076,longitude 5544456},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 1032175,longitude 5546653},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 1031076,longitude 5548850},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign 0,latitude 1030300,longitude 5548850},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1},RoamIfFroUtranCellRoExtCellCoordD{latitudeSign -1,latitude -1,longitude -1}}},sf16Adm 16,intCongFilter 1,sib1PlmnScopeValueTag 1,locationAreaFroId 0,serviceAreaFroId 63,routingAreaFroId 0,iubLinkFroId 21,rncModuleId 0,maximumTransmissionPower 400,primarySchPower -18,secondarySchPower -35,usedFreqThresh2dEcno -12,usedFreqThresh2dRscp -100,nOutSyncInd 10,nInSyncInd 3,rlFailureT 10,tmCongActionNg 800,releaseAseDlNg 3,tmInitialG 3000,directedRetryTarget -1,loadSharingGsmThreshold 75,loadSharingGsmFraction 100,hardIfhoCorr 3,hsdpaUsersAdm 10,loadSharingMargin 0,sf4AdmUl 4,sf16gAdm 16,sHcsRat -105,sf8AdmUl 8,sf16AdmUl 16,nrOfUraFroId 4,uraFroId 24,25,26,33,sf8gAdmUl 8,agpsEnabled 1,eulServingCellUsersAdm 32,eulNonServingCellUsersAdm 100,codeLoadThresholdDlSf128 100,pwrLoadThresholdDlSpeech{amr12200 1,amr5900 100,amr7950 0,amrWb12650 100,amrWb8850 100},aseLoadThresholdUlSpeech{amr12200 100,amr5900 100,amr7950 100,amrWb12650 100,amrWb8850 100},rateSelectionPsInteractive{channelType 0,ulPrefRate 64,dlPrefRate 64},accessClassesBarredCs 0,accessClassesBarredPs 0,hcsSib3Config{hcsPrio 0,qHcs 0,sSearchHcs -105},hcsUsage{connectedMode 0,idleMode 0},amrWbRateDlMax 12650,amrWbRateUlMax 12650,antennaPosition{latitudeSign 0,latitude 0,longitude 0},eulServingCellUsersAdmTti2 2,ctchOccasionPeriod 256,cellBroadcastSac -1,mocnCellProfileFroId -1,standAloneSrbSelector 1,amrNbSelector 0,transmissionScheme 0,loadBasedHoSupport 0,loadBasedHoType 0,cbsSchedulePeriodLength 64,ganHoEnabled 0,serviceRestrictions{csVideoCalls 0}},cellSetupInRbsFlag 1,cgiPtr{{cgi 5}},drhCcRefActiveFlag 1,drhCcRef 12 139 251 216 104 0 0 0 63 0 0 0 0,errorStatus 0,SPBlocked 0,spConfigFlag 1,tpcPattern01CountDl 8,rncIdChanged 0,spAndRbsResourcesConfigured 1,eulRoParamsPtr 0x0 0,upTransportOptionAtm 0,upTransportOptionIPv4 1,upResourceRef 0}  0x8dc0e0ac
		else if (($1 ~ /^[0-9][0-9][0-9][0-9](D01)?:$/ && $2=="Value:" && $3 ~ "{")||\
			 ($1 ~ /^[0-9][0-9][0-9][0-9](D01)?:$/ && $3=="cellData" && $5 ~ "{"))
		{
			if ($2 ~ /^1.*\/.*\/.*\//) currentActor=gensub(/\.1\//,"/","g",$2)
			else if ($2 == "...") currentActor=gensub(/-[0-9]+$/,"",1,currentActor)
			for (i=1;i<=NF;i++)
			{
				if ($i ~ /,(utran)*[cC]ellFroId/) cfro=gensub(/,.*$/,"",1,$(i+1))
				else if ($i ~ /,iubLinkFroId/) ifro=gensub(/,.*$/,"",1,$(i+1))
				else if ($i ~ /[,{]rncModuleId/)  mfro=gensub(/,.*$/,"",1,$(i+1))
				else if ($i ~ /,cId/)          cid=gensub(/,.*$/,"",1,$(i+1))
			}
			#print cfro,ifro,mfro,cid
			if (cfro < 0) continue
			cfroRef[cellRef[cid]]=cfro
			ifroRef[cellRef[cid]]=ifro
			cellCfroRef[cfro]=cellRef[cid]
			mfroRef[cellRef[cid]]=mfro
			actorCellRef[cellRef[cid]]=currentActor
			mpRef[cellRef[cid]]=currentMp
			modMfroRef[mfroRef[cellRef[cid]]]=modRef[cellRef[cid]]
		}
		#$ lhsh 001400 rrt-CXC1328008_R8U01 getattr 1/1/1/1/7/1.1/4 iubFroId
		#$ lhsh 001400 rrt-RncLmCell getattr 1/1/1/1/7/1.1/4 iubFroId
		else if ($1=="$" && $2=="lhsh" && $4 ~ /^rrt-(CXC1[37]2|RncLmCell)/ && $NF=="iubFroId")
		{
			#print $0
			currentActor=gensub(/\/4$/,"",1,$6)
		}
		#0014: Value: 1
		else if ($1 ~ /^[0-9][0-9][0-9][0-9](D01)?:$/ && $2=="Value:" && $3 ~ /^-*[0-9]+$/)
		{
			#print $3,cellIfroRef[$3],currentActor
			actorIubRef[$3]=currentActor
		}
		#(P7) 0014: 1.1/1.1/1.1/1.1/6.1/2.1/3.1  iubFroId  int  635  0x8cf78c64
		else if ($1 ~ /^[0-9][0-9][0-9][0-9](D01)?:$/ && $3=="iubFroId" && $2 ~ /^1.*\/.*\/.*\//)
		{
			currentActor=gensub(/\.1\//,"/","g",$2)
			actorIubRef[$5]=currentActor
		}
		#0218SP0: 5		143			0
		else if ($1 ~ /^[0-9][0-9][0-9][0-9](SP|D)[0-9]:$/)
		{
			ccRef[cellCfroRef[$3]]=gensub(/:/,"",1,$1)
			if ($2 != mfroRef[cellCfroRef[$3]]) ccModRef[cellCfroRef[$3]]=sprintf("!!Mod=%s",modMfroRef[$2])
		}
	}
	close(inputfile)
	if (mofilter != "" || frofilter != "")
	{
		for (cell in actorCellRef)
		{
			actorRef[cell]=actorCellRef[cell]
			actorRef[iubRef[cell]]=actorIubRef[ifroRef[cell]]
			mpRef[iubRef[cell]]=mpRef[cell]
		}
		for (cell in cellList) if (tolower(cell) ~ mofilter) moFilterList[cell]=cell
		for (iub in iubList)   if (tolower(iub)  ~ mofilter) moFilterList[iub]=iub
	}
	n=asort(cellList)
	if (tgCommand=="")
	{
		customPrint("\n-------------------------------------------------------------------------------------------------------------------------------")
		customPrint(sprintf("%-4s  %-4s  %-6s  %-15s  %-15s  %-4s  %-4s  %-15s  %-18s  %-7s  ","MOD","MFRO","ModMP","UtranCellId","IubLinkId","CfRO","IfRO","CellActor","IubActor","CcDev"))
		customPrint("-------------------------------------------------------------------------------------------------------------------------------")
	}
	else
	{
		#tgd <mo>|<fro> <attribute(s)>
		#eg: tg cell= ulinterference celldata:errorstatus celldata:spblocked celldata:spconfigflag cellRoState celldeleted cellTraceActivated
		#tgAttrList[1]=ulinterference
		#tgAttrList[2]=celldata:errorstatus
		if (tgCommand ~ /^GetAttribute /)
		{
			#tgCommand = GetAttribute ulinterference celldata:errorstatus celldata:spblocked celldata:spconfigflag cellRoState celldeleted cellTraceActivated
			tgdOption=1
			nrTgAttr=split(gensub(/^GetAttribute */,"",1,tgCommand),tgAttrList," ")
			for (i in tgAttrList) tgAttrList[i]=tolower(tgAttrList[i])
			if (nrTgAttr==0)
			{
				customPrint("Usage:   tgd <mo>|<fro> <attribute(s)>. Type \"h tg\" for more info.")
				customPrint("Example: tgd cell ulinterference celldata:errorstatus celldata:spconfigflag cellrostate celldeleted celltraceactivated")
				customPrint("To view all available attributes and subattributes, run the command:\"tg cell=<cell> info\"")
				exit
			}
			customPrint("\n-------------------------------------------------------------------------------------------------------------------------------")
			if (nrTgAttr > 0)
			{
				output=sprintf("%-30s","MO")
				for (i=1;i<=nrTgAttr;i++)
				{
					output=sprintf("%s  %-"length(gensub(/^.*:/,"",1,tgAttrList[i]))"s",output,gensub(/^.*:/,"",1,tgAttrList[i]))
				}
				customPrint(output)
			}
			else customPrint(sprintf("%-30s  %s","MO",i))
			customPrint("-------------------------------------------------------------------------------------------------------------------------------")
			tgCommand="info"

		}
		split(tgCommand,array," ")
		tgCommandPart1=array[1]
		tgCommandPart2=gensub(array[1],"",1,tgCommand)
		telnet_session=enter_telnet_login(node_address,node_password)
		if (telnet_session ~ /Unable to connect|Wrong Password/)
		{
			customPrint(telnet_session)
			exit 1
		}
		if (tgdOption==1)
		{
			#Find out the last attribute in the info printout
			for (cell in actorRef)
			{
				if (Filter1 ~ "iub") actorreffilter="IubLink=" ; else actorreffilter="UtranCell="
				if (cell ~ actorreffilter && actorRef[cell] != "")
				{
					printf("lhsh %s %s info %s%s\necho \"EndOfPrint\"\n",mpRef[cell],rrt_command,actorRef[cell],childrenActor) |& telnet_session
					while ((telnet_session |& getline)>0)
					{
						gsub("\r","") ; gsub("\x00","")
						if (/(^|[^"])EndOfPrint$/) break
						else lastTgInfoAttribute=$2
					}
					break
				}
			}
		}
	}
	for (i=0;i<=maxMod;i++)
	{
		for (j=1;j<=n;j++)
		{
			condition="false"
			currentMo="---"
			cell=cellList[j]
			if (modRef[cell]==i)
			{
				if (mofilter != "")
				{
					for (mo in moFilterList)
					{
						if (cell ~ mo)
						{
							currentMo=cell
							condition="true"
						}
						else if (iubRef[cell] ~ mo)
						{
							currentMo=iubRef[cell]
							condition="true"
						}
					}
				}
				else if (frofilter !~ /^[0-9]+$/ || frofilter==cfroRef[cell] || frofilter==ifroRef[cell])
				{
					if (frofilter == cfroRef[cell]) currentMo=cell
					else if (frofilter == ifroRef[cell]) currentMo=iubRef[cell]
					condition="true"
				}
				if (condition=="true")
				{
					if (tgCommand=="") customPrint(sprintf("%4s  %4s  %-6s  %-15s  %-15s  %4s  %4s  %-15s  %-18s  %s",\
modRef[cell],mfroRef[cell],mpRef[cell],gensub(/UtranCell=/,"",1,cell),gensub(/IubLink=/,"",1,iubRef[cell]),cfroRef[cell],ifroRef[cell],\
actorCellRef[cell],actorIubRef[ifroRef[cell]],ccRef[cell]))
					else if (printedCommand[currentMo] != 1)
					{
						printedCommand[currentMo]=1
						if (tgdOption != 1)
						{
							customPrint("------------------------------------------------------------------------------------------------")
							customPrint(sprintf(">>> %s",currentMo))
							customPrint("------------------------------------------------------------------------------------------------")
						}
						printf("lhsh %s %s %s %s%s %s\necho \"EndOfPrint\"\n",mpRef[currentMo],rrt_command,tgCommandPart1,actorRef[currentMo],childrenActor,tgCommandPart2) |& telnet_session
						while ((telnet_session |& getline)>0)
						{
							gsub("\r","") ; gsub("\x00","")
							if (/(^|[^"])EndOfPrint$/) break
							else if (/^echo "EndOfPrint"$/) {}
							else if (tgdOption != 1) customPrint(sprintf("%4s: %s",gensub(/00$/,"",1,mpRef[currentMo]),$0))
							else if (tgdOption == 1)
							{
								#To cope for broken lines:
								if ($1 ~ /^[0-9]+:$/ && $3 == "==" && $NF !~ /}$/ && NF > 10)
								{
									while ((telnet_session |& getline line)>0)
									{
										gsub("\r","",line) ; gsub("\x00","",line)
										$0=$0 line
										if (line ~ /\}$/) break
									}
								}
								#tgAttrList[1]=ulinterference
								#tgAttrList[2]=celldata:errorstatus
								for (x=1;x<=nrTgAttr;x++)
								{
									if (tolower($2)==gensub(/:.*$/,"",1,tgAttrList[x]))
									{
										if (tgAttrList[x] ~ /:/)
										{
											last=split($0,array,/[,{}()]/)
											for (y=1;y<=last;y++)
											{
												split(array[y],array1," ")
												if (tolower(array1[1])==gensub(/^.*:/,"",1,tgAttrList[x]))
												{
													tgAttrValue[x]=array1[2]
												}
											}
										}
										else
										{
											tgAttrValue[x]=gensub(/^.*== */,"",1,$0)
										}
										if (tgAttrList[x] ~ /^celldata:errorstatus$/ && tgAttrValue[x] in errTrans    && errTrans[tgAttrValue[x]] != "")    tgAttrValue[x]=sprintf("%s:%s",tgAttrValue[x],errTrans[tgAttrValue[x]])
										else if (tgAttrList[x] ~ /^cellrostate$/     && tgAttrValue[x] in cellRoTrans && cellRoTrans[tgAttrValue[x]] != "") tgAttrValue[x]=sprintf("%s:%s",tgAttrValue[x],cellRoTrans[tgAttrValue[x]])
									}
								}
								if ($2==lastTgInfoAttribute)
								{
									output=sprintf("%-30s",currentMo)
									for (z=1;z<=nrTgAttr;z++)
									{
										output=sprintf("%s  %-"length(gensub(/^.*:/,"",1,tgAttrList[z]))"s",output,tgAttrValue[z])
									}
									customPrint(output)
								}
							}
						}
					}
				}
			}
		}
	}
	close(inputfile)
	if (tgCommand == "" || tgdOption==1) customPrint("-------------------------------------------------------------------------------------------------------------------------------")
	else
	{
		print "exit" |& telnet_session
		while ((telnet_session |& getline)>0) {}
		close(telnet_session)
	}
}
function showActiveAlarms(file,startdate,enddate,    activeAlarm,array,line,last,currentalarm,n,j,dest,array2,currentTime,shortSev,nr,todaysdate,word,AlCount,x)
{
	#The input is a logfile from the command "lgasumc"
	#Alarm list will be rebuilt after:
	# - Node restart ("Cls_evlogd_proc restart" in lgs)
	# - and/or JVM restart ("Waiting for the Configuration Service to be started" in lgu)
	#Date;Time;Log;Severity;Object;Event;Cause;AdditionalText;AckState;Id
	#2008-10-06;14:22:02;AL;Warning;ManagedElement=1,TransportNetwork=1,SccpSp=Iu,SccpScrc=1,SccpApRemote=Iuc-2351-2300;SCCP Remote Subsystem Unavailable;unavailable;;Unacknowledged;_4
	#2008-10-15;05:40:20;Major;ManagedElement=1,Equipment=1,Subrack=MS,Slot=7,PlugInUnit=1,ExchangeTerminal=1,Os155SpiTtp=1;Loss of Signal;loss_of_signal;;Acknowledged by eanzmagn;_6
	#2008-10-06;14:22:02;AL;Major;ManagedElement=1,Equipment=1,Subrack=MS,Slot=4,PlugInUnit=1,TimingUnit=1,TuSyncRef=1;TU Synch Reference Loss of Signal;loss_of_signal;;Unacknowledged;_2
	#2008-10-06;14:22:18;AL;Cleared;ManagedElement=1,TransportNetwork=1,Mtp3bSpItu=Iu,Mtp3bSrs=Iup-2351-2810;MTP3b Route Set Unavailable;routing_failure;userLabel: Iup-2351-2810;Unacknowledged;_10
	#2008-10-15;05:38:53;SYS;INFO;;*** Cls_evlogd_proc restart ***
	#2011-03-15;08:45:10;UP;;SU_SW: DeltaUPs - ---;CelloConfigurationServiceStatusObserver.run():  Waiting for the Configuration Service to be started...(registered).

	#comcli:
	#2016-04-11;14:24:57;AL  ;Critical;Lm=1;License Key File Fault; (Key file fault in Managed Element)
	#2016-04-11;14:25:20;AL  ;Cleared;Lm=1;License Key File Fault; (Key file fault in Managed Element)
	#2016-04-11;15:16:11;AL  ;Minor ;RiLink=2;Link Failure; (Not in operation, additionalData: id 1, unitId 1, portNo 1)
	#2016-04-11;15:16:41;AL  ;Cleared;RiLink=2;Link Failure;
	#2016-05-05;21:51:17;AV;NODE;;RcsNodeRestart
	#2016-04-22;15:39:07;AV;NODE OUT UnOperational;;RankCold 2016-04-22 15:38:09

	shortSev["Critical"]="C" ; shortSev["Major"]="M" ; shortSev["Minor"]="m" ; shortSev["Warning"]="w" ; shortSev["Indeterminate"]="?"
	todaysdate=getTodayUTC()

	while (getline line < file)
	{
		last=split(line,array,";")
		if (comcli>0)
		{
			gsub(" ","",array[3])
			gsub(" ","",array[4])
			sub(/^ +/,"",array[6])
		}
		#Note: we cannot use the line "The Configuration Service is up and running" to clear the alarm list because some alarms raise before that line
		if (array[6]~/ Cls_evlogd_proc restart |Waiting for the Configuration Service to be started|Current properties for System Upgrade trace functionality|^RcsNodeRestart/) { delete activeAlarm ; continue }
		else if (array[3] != "AL") continue
		else if (array[8] ~ "The alarm is currently toggling.") continue  #ignore alarms in toggling state
		currentTime=make_timestamp(array[1],array[2])
		if (enddate != "" && currentTime > enddate) continue
		currentalarm=""
		for (i=5;i<=last;i++)
		{
			if (comcli>0 && i>6) continue #dont include the additionaltext in currentAlarm as it not always appears in the cleared alarm
			if (i==9) continue #ignore the ackstate otherwise alarm can appear several times
			if (array[i] ~ /^SubNetwork=/)
			{
				#take away the first SubNetwork in case it had changed in between the raise and cease
					#2010-05-18;10:52:03;AL;Major;SubNetwork=SVOSSRC1_ROOT_MO_R,SubNetwork=RNC11,MeContext=RNC11,ManagedElement=1,RncFunction=1,UtranCell=cell11711-Iub-1007-1;UtranCell_ServiceUnavailable;unavailable;A Radio NW Service Impact;Unacknowledged;SubNetwork=SVOSSRC1_ROOT_MO_R,SubNetwork=RNC11,MeContext=RNC11_50
					#2010-05-18;11:07:54;AL;Cleared;SubNetwork=ONRM_ROOT_MO_R,SubNetwork=RNC11,MeContext=RNC11,ManagedElement=1,RncFunction=1,UtranCell=cell11711-Iub-1007-1;UtranCell_ServiceUnavailable;unavailable;A Radio NW Service Impact;Unacknowledged;SubNetwork=ONRM_ROOT_MO_R,SubNetwork=RNC11,MeContext=RNC11_50
				#sub(/^SubNetwork=[^,]+,/,"",array[i])

				#take away the whole mibPrefix in case the alarm raise and cease have different mibPrefix
					#2012-02-16;05:03:09;AL;Major;ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1;Plug-In Unit General Problem;replaceable_unit_problem;;Unacknowledged;_1
					#2012-02-16;14:40:56;AL;Cleared;SubNetwork=ONRM_ROOT_MO_R,MeContext=ECL01186,ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1;Plug-In Unit General Problem;replaceable_unit_problem;;Unacknowledged;SubNetwork=ONRM_ROOT_MO_R,MeContext=ECL01186_1
				if (i==5)
				{
					#taking away the mibPrefix in FDN (5th field)
					sub(/^SubNetwork=.*ManagedElement=1/,"ManagedElement=1",array[i])
				}
				else
				{
					#taking away the mibPrefix in the alarm ID (last field)
					match(array[i],/^SubNetwork=.*(_[0-9]+)$/,word)
					if (word[1] ~ /^_[0-9]+$/) array[i]=word[1]
				}
			}
			currentalarm=currentalarm";"array[i]
		}
		#print array[4] currentalarm
		if (array[4]=="Cleared") delete activeAlarm[currentalarm]
		else activeAlarm[currentalarm]=sprintf("%15d",currentTime) SUBSEP array[4] SUBSEP array[1] SUBSEP array[2] SUBSEP array[9] SUBSEP currentalarm (comcli>0? ";" array[7] : "")
	}
	close(file)
	if (alarm_header>0) addHeader="(AdditionalText/PC, AI)"
	else addHeader="(Cause/AdditionalInfo)"	
	if (enddate>todaysdate) enddate=todaysdate
	customPrint("")
	n=asort(activeAlarm,dest)
	customPrint("Nr of active alarms on "mystrftime("%Y-%m-%d at %H:%M:%S",enddate)": "n)
	if (csvformat) customPrint("Date;Time;Severity;Object;Problem;Cause;AdditionalText;AckState;AlarmId")
	else if (alarm_format==0) customPrint(sprintf("=========================================================================================================================================\n\
Date & Time (UTC)   S Specific Problem                    Cause                     Mo-Reference\n\
========================================================================================================================================="))
	else if (alarm_format>=1) customPrint(sprintf("=========================================================================================================================================\n\
Date & Time (UTC)   S Specific Problem                    MO "addHeader"\n\
========================================================================================================================================="))
	for (i=1;i<=n;i++)
	{
		split(dest[i],array,SUBSEP)
		split(array[6],array2,";")
		nr[array[2]]++
		if (csvformat) customPrint(array[3]";"array[4]";"array[2] gensub(/;[^;]+$/,"",1,array[6])";"array[5]";"gensub(/^.*;/,"",1,array[6]))
		else if (alarm_format==0) customPrint(sprintf("%s %s %s %-35s %-25s %-s",array[3],array[4],shortSev[array[2]],array2[3],array2[4],gensub(/(^.*ManagedElement=1,)([^,]+,)?/,"",1,array2[2])))
		else if (alarm_format>=1) customPrint(sprintf("%s %s %s %-35s %-s %-s",array[3],array[4],shortSev[array[2]],array2[3],gensub(/(^.*ManagedElement=1,)([^,]+,)?/,"",1,array2[2]),process_add_text(array2[5],array2[3],array2[4])))
	}
	customPrint(">>> Total: "n" Alarms ("nr["Critical"]+0" Critical, "nr["Major"]+0" Major)")
}
function showAlarmsDuration(file,startdate,enddate,    activeAlarm,array,line,last,currentalarm,n,j,dest,array2,currentTime,shortSev,nr,todaysdate,array3,output,word,AlCount,x,arrc)
{
	#The input is a logfile from the command "lgasuvmc"
	#Alarm list will be rebuilt after:
	# - Node restart ("Cls_evlogd_proc restart" in lgs)
	# - and/or JVM restart ("Waiting for the Configuration Service to be started" in lgu)
	#Date;Time;Log;Severity;Object;Event;Cause;AdditionalText;AckState;Id
	#2008-10-06;14:22:02;AL;Warning;ManagedElement=1,TransportNetwork=1,SccpSp=Iu,SccpScrc=1,SccpApRemote=Iuc-2351-2300;SCCP Remote Subsystem Unavailable;unavailable;;Unacknowledged;_4
	#2008-10-15;05:40:20;Major;ManagedElement=1,Equipment=1,Subrack=MS,Slot=7,PlugInUnit=1,ExchangeTerminal=1,Os155SpiTtp=1;Loss of Signal;loss_of_signal;;Acknowledged by eanzmagn;_6
	#2008-10-06;14:22:02;AL;Major;ManagedElement=1,Equipment=1,Subrack=MS,Slot=4,PlugInUnit=1,TimingUnit=1,TuSyncRef=1;TU Synch Reference Loss of Signal;loss_of_signal;;Unacknowledged;_2
	#2008-10-06;14:22:18;AL;Cleared;ManagedElement=1,TransportNetwork=1,Mtp3bSpItu=Iu,Mtp3bSrs=Iup-2351-2810;MTP3b Route Set Unavailable;routing_failure;userLabel: Iup-2351-2810;Unacknowledged;_10
	#2008-10-15;05:38:53;SYS;INFO;;*** Cls_evlogd_proc restart ***
	#2011-03-15;08:45:10;UP;;SU_SW: DeltaUPs - ---;CelloConfigurationServiceStatusObserver.run():  Waiting for the Configuration Service to be started...(registered).
	#2021-12-22;08:42:25;AV;NODE;;CppCoreNodeRestart

	#comcli:
	#2016-04-11;14:24:57;AL  ;Critical;Lm=1;License Key File Fault; (Key file fault in Managed Element)
	#2016-04-11;14:25:20;AL  ;Cleared;Lm=1;License Key File Fault; (Key file fault in Managed Element)
	#2016-04-11;15:16:11;AL  ;Minor ;RiLink=2;Link Failure; (Not in operation, additionalData: id 1, unitId 1, portNo 1)
	#2016-04-11;15:16:41;AL  ;Cleared;RiLink=2;Link Failure;
	#2016-05-05;21:51:17;AV;NODE;;RcsNodeRestart
	#2016-04-22;15:39:07;AV;NODE OUT UnOperational;;RankCold 2016-04-22 15:38:09

	shortSev["Critical"]="C" ; shortSev["Major"]="M" ; shortSev["Minor"]="m" ; shortSev["Warning"]="w" ; shortSev["Indeterminate"]="?"
	todaysdate=getTodayUTC()

	while ((getline line < file)>0)
	{
		last=split(line,array,";")
		if (comcli>0)
		{
			gsub(" ","",array[3])
			gsub(" ","",array[4])
			sub(/^ +/,"",array[6])
		}
		currentTime=make_timestamp(array[1],array[2])
		if (enddate != "" && currentTime > enddate) continue
		if (array[6]~/ Cls_evlogd_proc restart |Waiting for the Configuration Service to be started|Current properties for System Upgrade trace functionality|^RcsNodeRestart|^CppCoreNodeRestart/)
		{
			if (comcli==0 && array[6]~/ Cls_evlogd_proc restart / && strftime("%Y",currentTime)=="1970") continue  #for CPP, if the correct timestamp is not given at the system log entry then we use the availability log entry instead
			for (i in activeAlarm)
			{
				split(activeAlarm[i],array2,SUBSEP)
				array2[1]+=0   #remove the leading spaces
				x=i SUBSEP array2[1]
				if (comcli>0) x=i";"++AlCount[i]  #in COM there is not the alarm ID to distinguish between several occurrences of the same alarm (MO/problem)
				finishedAlarm[x]=activeAlarm[i] SUBSEP currentTime-array2[1] SUBSEP "ClearedAtRestart"
			}
			delete activeAlarm
			continue
		}
		else if (array[3] != "AL") continue
		else if (array[8] ~ "The alarm is currently toggling.") continue  #ignore alarms in toggling state
		currentalarm=""
		for (i=5;i<=last;i++)
		{
			if (comcli>0 && i>6) continue #dont include the additionaltext in currentAlarm as it not always appears in the cleared alarm
			if (i==9) continue #ignore the ackstate otherwise alarm can appear several times
			if (array[i] ~ /^SubNetwork=/)
			{
				#take away the first SubNetwork in case it had changed in between the raise and cease
					#2010-05-18;10:52:03;AL;Major;SubNetwork=SVOSSRC1_ROOT_MO_R,SubNetwork=RNC11,MeContext=RNC11,ManagedElement=1,RncFunction=1,UtranCell=cell11711-Iub-1007-1;UtranCell_ServiceUnavailable;unavailable;A Radio NW Service Impact;Unacknowledged;SubNetwork=SVOSSRC1_ROOT_MO_R,SubNetwork=RNC11,MeContext=RNC11_50
					#2010-05-18;11:07:54;AL;Cleared;SubNetwork=ONRM_ROOT_MO_R,SubNetwork=RNC11,MeContext=RNC11,ManagedElement=1,RncFunction=1,UtranCell=cell11711-Iub-1007-1;UtranCell_ServiceUnavailable;unavailable;A Radio NW Service Impact;Unacknowledged;SubNetwork=ONRM_ROOT_MO_R,SubNetwork=RNC11,MeContext=RNC11_50
				#sub(/^SubNetwork=[^,]+,/,"",array[i])

				#take away the whole mibPrefix in case the alarm raise and cease have different mibPrefix
					#2012-02-16;05:03:09;AL;Major;ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1;Plug-In Unit General Problem;replaceable_unit_problem;;Unacknowledged;_1
					#2012-02-16;14:40:56;AL;Cleared;SubNetwork=ONRM_ROOT_MO_R,MeContext=ECL01186,ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1;Plug-In Unit General Problem;replaceable_unit_problem;;Unacknowledged;SubNetwork=ONRM_ROOT_MO_R,MeContext=ECL01186_1
				if (i==5)
				{
					#taking away the mibPrefix in FDN (5th field)
					sub(/^SubNetwork=.*ManagedElement=1/,"ManagedElement=1",array[i])
				}
				else
				{
					#taking away the mibPrefix in the alarm ID (last field)
					match(array[i],/^SubNetwork=.*(_[0-9]+)$/,word)
					if (word[1] ~ /^_[0-9]+$/) array[i]=word[1]
				}
			}
			currentalarm=currentalarm";"array[i]
		}
		#print array[4] currentalarm
		if (array[4]!="Cleared")
		{
			if (comcli>0 && activeAlarm[currentalarm]!="")
			{
				#print currentalarm
				#this is an updated alarm. Check if it has the same severity as the previous one
				split(activeAlarm[currentalarm],arrc,SUBSEP)
				if (array[4]!=arrc[2]) #different severity , consider it as a new alarm
				{
					split(activeAlarm[currentalarm],array2,SUBSEP)
					array2[1]+=0   #remove the leading spaces
					x=currentalarm SUBSEP array2[1]
					if (comcli>0) x=currentalarm";"++AlCount[currentalarm]
					finishedAlarm[x]=activeAlarm[currentalarm] SUBSEP currentTime-array2[1] SUBSEP "Cleared"
					delete activeAlarm[currentalarm]
				}
				else continue  #same severity, ignore
			}
			activeAlarm[currentalarm]=sprintf("%15d",currentTime) SUBSEP array[4] SUBSEP array[1] SUBSEP array[2] SUBSEP array[9] SUBSEP currentalarm (comcli>0? ";" array[7] : "")
		}
		else if (array[4]=="Cleared" && currentalarm in activeAlarm)
		{
			split(activeAlarm[currentalarm],array2,SUBSEP)
			array2[1]+=0   #remove the leading spaces
			x=currentalarm SUBSEP array2[1]
			if (comcli>0) x=currentalarm";"++AlCount[currentalarm]
			finishedAlarm[x]=activeAlarm[currentalarm] SUBSEP currentTime-array2[1] SUBSEP "Cleared"
			delete activeAlarm[currentalarm]
		}
	}
	close(file)
	if (enddate>todaysdate) enddate=todaysdate
	for (i in activeAlarm)
	{
		split(activeAlarm[i],array,SUBSEP)
		array[1]+=0
		x=i SUBSEP array[1]
		if (comcli>0) x=i";"++AlCount[i]
		finishedAlarm[x]=activeAlarm[i] SUBSEP enddate-array[1] SUBSEP "Active"
	}
	if (alarm_header>0) addHeader="(AdditionalText/PC, AI)"
	else addHeader="(Cause/AdditionalInfo)"
	delete activeAlarm
	customPrint("")
	n=asort(finishedAlarm,dest)
	customPrint("Alarm durations from "mystrftime("%Y-%m-%d at %H:%M:%S",startdate)" to "mystrftime("%Y-%m-%d at %H:%M:%S",enddate))
	if (csvformat) customPrint("Date;Time;Severity;Status;Duration;Object;Problem;Cause;AdditionalText;AckState;AlarmId")
	else if (alarm_format==0) customPrint(sprintf("=========================================================================================================================================\n\
Date & Time (UTC)   S  Duration          Specific Problem                    Cause                     Mo-Reference\n\
========================================================================================================================================="))
	else if (alarm_format>=1) customPrint(sprintf("=========================================================================================================================================\n\
Date & Time (UTC)   S  Duration          Specific Problem                    MO "addHeader"\n\
========================================================================================================================================="))
	for (i=1;i<=n;i++)
	{
		split(dest[i],array,SUBSEP)
		split(array[6],array2,";")
		#nr[array[2]]++
		#if an alarm was finished before the startdate we skip it
		array[1]+=0   #remove the leading spaces
		if (array[7] ~ /^[0-9]+$/ && (array[1]+array[7]) < startdate) continue
		#if an alarm has a negative duration due to the restart that cleared the alarm had a 1970 date then we use the starting date of the alarm to determine whether to take it
		if (array[7] ~ /^-[0-9]+$/ && array[1] < startdate) continue
		#ignore alarms that lasted 0 seconds
		if (show_shortduration_alarms!=1 && array[7]==0) continue
		if (array[7] ~ /^-[0-9]+$/) array[7]="? (1970-01-01)"
		else if (array[7] ~ /^[0-9]+$/) array[7]=convertSeconds(array[7],3)
		if (csvformat) output=array[3]";"array[4]";"array[2]";"array[8]";"array[7] gensub(/;[^;]+$/,"",1,array[6])";"array[5]";"gensub(/^.*;/,"",1,array[6])
		else if (alarm_format==0) output=sprintf("%s %s %-2s %-17s %-35s %-25s %-s",array[3],array[4],shortSev[array[2]] (array[8]~"Cleared"?"*":""),array[7],array2[3],array2[4],gensub(/(^.*ManagedElement=1,)([^,]+,)?/,"",1,array2[2]))
		else if (alarm_format>=1) output=sprintf("%s %s %-2s %-17s %-35s %-s %-s",array[3],array[4],shortSev[array[2]] (array[8]~"Cleared"?"*":""),array[7],array2[3],gensub(/(^.*ManagedElement=1,)([^,]+,)?/,"",1,array2[2]),process_add_text(array2[5],array2[3],array2[4],"","nobrack","","nopc"))
		customPrint(output)
	}
	#customPrint(">>> Total: "n" Alarms ("nr["Critical"]+0" Critical, "nr["Major"]+0" Major)")
}
function showActiveConnections(file,startdate,enddate,    activeConn,array,line,last,currentconn,n,j,dest,currentTime,nr,orig,port,sep,todaysdate,haveall)
{
	#The input is a logfile from the command "lgysumc"
	#it adds a corba connection upon "TCPConnectionOpened" and removes upon "TCPConnectionClosed", or core MP restart "Cls_evlogd_proc" or JVM restart "Waiting for the Configuration Service to be started"
	#Date;Time;Log;Severity;Object;Event;Cause;AdditionalText;AckState;Id
	#2010-01-07;15:01:56;SEC;;;TCPConnectionOpenedbetween a.b.c.d:46936 and localhost:56834
	#2010-01-07;15:01:58;SEC;;;TCPConnectionClosedbetween /a.b.c.d:46936 and localhost:56834
	#2010-01-07;22:13:11;SEC;;;TCPConnectionOpenedbetween a.b.c.d:49357 and localhost:56836
	#2010-01-07;22:13:11;SEC;;;SSLSessionCreatedbetween a.b.c.d:49357 and localhost:56836
	#2010-01-07;22:15:29;SEC;;;TCPConnectionClosedbetween /a.b.c.d:49357 and localhost:56836
	#2010-01-05;13:19:14;SEC;;;TCPConnectionClosedbetween a.b.c.d/a.b.c.d:49925 and localhost:65530
	#2008-10-15;05:38:53;SYS;INFO;;*** Cls_evlogd_proc restart ***
	#2011-03-15;08:45:10;UP;;SU_SW: DeltaUPs - ---;CelloConfigurationServiceStatusObserver.run():  Waiting for the Configuration Service to be started...(registered).

	#If checking currrent active connections there is also the output of rsock -fln or dsock client list port
	#rsock -fln :
	#2008-10-15;05:38:53.001;9    91     TCP   0x8f31   ose_telnet_1                   setsockopt(65535,8,0x1) 9=accept(6,a.b.c.d:40461) eof_event(0) read_event(1) fcntl(0x4,6)
	#2008-10-15;05:38:53.001;6    96     TCP   0x8f31   sshd_handler                   setsockopt(65535,8,0x1) setsockopt(65535,4098,0xffff) setsockopt(65535,4097,0xffff) 6=accept(1,a.b.c.d:43483) eof_event(0) error_event(0) read_event(1) fcntl(0x4,0) fcntl(0x4,4)
	#2008-10-15;05:38:53.001;9    91     TCP   0x8f31   ose_ftpd_spa                   setsockopt(65535,8,0x1) 9=accept(8,a.b.c.d:42840)
	#2018-01-30;15:08:59.003;18   533    TCP   0x8f33   ose_ssh_192.                   setsockopt(65535,8,0x1) setsockopt(6,1,0x1) setsockopt(0,3,0x8) 18=accept(10,a.b.c.d:34253) error_event(0) eof_event(0) read_event(1) fcntl(0x4,34)
	#dsock client list port:
	#2008-10-15;05:38:53.001;ose_telnet_a.b.c.d:57853-175441539
   	#2008-10-15;05:38:53.001;sshd_handler_a.b.c.d:60705-147326733
	#2008-10-15;05:38:53.001;ose_ftpd_spawn-230885056
	#CPP Linux: netstat -an
	#2018-02-15;07:38:57.001;tcp        0      0 a.b.c.d:22          a.b.c.d:49096      ESTABLISHED


	#ConnType          Origin                    ActiveSince
	#Corba:56834       a.b.c.d:49357       2009-12-18 14:56:37 (3h25m34s)
	#Telnet            a.b.c.d:57853
	#Ssh               a.b.c.d:43484
	#Ftp               a.b.c.d:42840

	if (csvformat) sep=";" ; else sep="  "
	todaysdate=getTodayUTC()
	while (getline line < file)
	{
		last=split(line,array,";")
		if (array[6]~/ Cls_evlogd_proc restart |Waiting for the Configuration Service to be started|The Configuration Service is up and running/) { delete activeConn ; continue }
		else if (array[3] == "SYS") continue
		currentTime=make_timestamp(array[1],array[2])
		if (enddate != "" && currentTime > enddate) continue
		if (array[6] ~ /^TCPConnection/)
		{
			orig=gensub(/^.*between | and .*$/,"","g",array[6])
			if (orig ~ "/") sub(/^.*\//,"",orig)
			port=gensub(/^.*:/,"",1,array[6])+0
			currentconn=sprintf("%-16s%s%-22s","Corba"(port>0?":"port:""),sep,orig)
		}
		if (array[6] ~ "TCPConnectionOpened") activeConn[currentconn]=sprintf("%15d",currentTime) SUBSEP currentconn
		else if (array[6]~"TCPConnectionClosed") delete activeConn[currentconn]
		else if (array[3] == "READCLOCK") haveall=1
		else if (array[3] ~ /ose_telnet_|sshd_handler|ose_ftpd_spa|ose_ssh_.*=accept/ && array[3]!~/ose_ssh_.*127.0.0.1/)
		{
			last=split(array[3],array," ")
			port=orig=""
			if (array[5] ~ /^(ose_telnet_|sshd_handler|ose_ftpd_spa|ose_ssh_)/)
			{
				if (array[5] ~ "telnet") port="Telnet" ; else if (array[5] ~ "ssh") port="Ssh" ; else if (array[5] ~ "ftp") port="Ftp"
				nr[port]++
				for (i=7;i<=last;i++)
				{
					if (array[i] ~ /=accept/) { orig=gensub(/^.*,|\).*$/,"","g",array[i]) ; break }
				}
				currentconn=sprintf("%-16s%s%-22s",port,sep,orig)
				activeConn[currentconn]=999999999999999 SUBSEP currentconn
			}
			else if (array[1] ~ /^(ose_telnet_|sshd_handler|ose_ftpd_spa)/)
			{
				if (array[1] ~ "telnet") port="Telnet" ; else if (array[1] ~ "ssh") port="Ssh" ; else if (array[1] ~ "ftp") port="Ftp"
				nr[port]++
				orig=gensub(/^.*_|-.*$/,"","g",array[1])
				if (orig=="spawn") orig=gensub(/^.*-/,"",1,array[1])
				currentconn=sprintf("%-16s%s%-22s",port,sep,orig)
				activeConn[currentconn]=999999999999999 SUBSEP currentconn
			}
		}
		else if (cpplinux==1 && array[3]~/:22 .* ESTABLISHED/)
		{
			last=split(array[3],array," ")
			#2018-02-15;07:38:57.001;tcp        0      0 a.b.c.d:22          a.b.c.d:49096      ESTABLISHED
			if (array[4]!~/:22$/) continue
			currentconn=sprintf("%-16s%s%-22s","Ssh",sep,array[5])
			activeConn[currentconn]=999999999999999 SUBSEP currentconn
			nr["Ssh"]++
		}
	}
	close(file)
	if (enddate>todaysdate) enddate=todaysdate
	customPrint("")
	n=asort(activeConn,dest)
	customPrint(sprintf("Nr of active %s connections on %s: %s",(haveall==1?"O&M":"Corba"),mystrftime("%Y-%m-%d at %H:%M:%S",enddate),n))
	if (csvformat) customPrint("ConnType;Origin;ActiveSince;Duration")
	else customPrint(sprintf("================================================================================================\n\
%-16s  %-22s  %-19s  %s\n================================================================================================",\
"ConnType","Origin","ActiveSince","Duration"))
	for (i=1;i<=n;i++)
	{
		split(dest[i],array,SUBSEP)
		if (array[1]!=999999999999999)
		{
			customPrint(array[2] sep mystrftime("%Y-%m-%d %H:%M:%S",array[1]) sep convertSeconds(enddate-array[1],1))
			nr["Corba"]++
		}
		else customPrint(array[2])
	}
	customPrint(">>> Total: "n" "(haveall==1?"O&M":"Corba")" connections "(haveall==1?"("nr["Corba"]+0" Corba, "nr["Ssh"]+0" Ssh, "nr["Telnet"]+0" Telnet, "nr["Ftp"]+0" Ftp)":""))
}
function calculateNodeDowntime(file,startdate,enddate,batch,syslogfile,    \
todaysdate,nodehasbeendown,waitingforapplication,nodeoperhasbeenmet,configversionhasbeenmet,smn,tlist,tname,\
line,subarray,datearray,timearray,downdateList,restartData,currentNode,n,i,j,k,begindate,finaldate,currentDate,logstarted,typeOfRestart,\
numberOfDays,NodeDowntime,numberOfNodeRestarts,a,maxNodeDowntime,minNodeDowntime,extraSpace,currentConfigVersion,\
update,downdate,appupdate,jvmupdate,typeOfRestartList,restartDataPrinted)
{
	#The input is a logfile from the command "lgvsum"
	#Calculate node downtime
	#print "**************"
	#cello=1 and application=2
	tlist[1]=1 ; tname[1]="CPP"
	alist[1]=1 ; aname[1]="Total"
	alist[2]=2 ; aname[2]="SwUpgrade"
	alist[3]=3 ; aname[3]="Manual"
	alist[4]=4 ; aname[4]="Spontaneous"
	alist[5]=5 ; aname[5]="Manual+Spontaneous"

	for (k=1;k<=2;k++) for (a=1;a<=5;a++) numberOfNodeRestarts[k,a]=0
	for (k=1;k<=2;k++) for (a=1;a<=5;a++) maxNodeDowntime[k,a]=0
	for (k=1;k<=2;k++) for (a=1;a<=5;a++) minNodeDowntime[k,a]=1E8
	logstarted=0
	nodehasbeendown=waitingforapplication=nodeoperhasbeenmet=configversionhasbeenmet=0
	typeOfRestart="Spontaneous"
	tmp_typeOfRestart=""
	if (enddate != "") todaysdate=enddate
	else todaysdate=getTodayUTC()
	if (batch == 1)
	{
		currentNode=gensub(/^.*\/|.log/,"","g",file)
		if (fileOps("test -s "syslogfile)==0)
		{
			close(syslogfile)
			while (getline line < syslogfile)
			{
				gsub("\r","",line) ; gsub("\x00","",line)
				split(line,subarray," ")
				if (subarray[1]=="Model:") hd[currentNode]=subarray[2] #hd is global variable
				else if (subarray[3] ~ /^SCB[0-9]*$/ && subarray[1] ~ /^[0-9]+$/ && subarray[2] ~ /^[0-9]+$/) smn[subarray[1]]=subarray[1]
			}
			close(syslogfile)
		}
	}
	close(file)
	while (getline line < file)
	{
		gsub("\r","",line);gsub("\x00","",line)
		if (line ~ /Merged Log Entry/ || batch==1) logstarted=1
		if (logstarted != 1) continue
		split(line,subarray," ")
		if (!(subarray[1] ~ /^[2][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]$/ && subarray[2] ~ /^[0-2][0-9]:[0-5][0-9]:[0-9][0-9]$/ && subarray[3] ~ /^(CRIT|INFO|NODE|T&E|SERV|UP|OTHR)$/)) continue
		currentDate=make_timestamp(subarray[1],subarray[2])
		if (!(currentDate >= startdate && (currentDate <= todaysdate || enddate == ""))) continue
		if (begindate[1] == "") begindate[1]=currentDate
		if (begindate[2] == "" && subarray[3]=="NODE") begindate[2]=currentDate
		finaldate=currentDate

		if (line ~ /SERV  OUT_PARTIAL/) partialdowndate=finaldate
		else if (line ~ /SERV  IN *When in PartialOutOfService average was: -?[0-9]+ percent/)
		{
			if (partialdowndate=="") partialdowndate=startdate #in case SERV OUT occurred before startdate
			if (partialdowndate in restartData) continue
			partialpercentage=gensub(/^.* was: |percent *$/,"",1,line)+0
			partialdowntime=finaldate-partialdowndate
			restartData[partialdowndate]=sprintf("%s  %-15s  %-40s  %-20s",mystrftime("%Y-%m-%d %H:%M:%S",partialdowndate),"","PartialOutage: "partialpercentage"% availability",convertSeconds(partialdowntime,1))
			csv_restartData[partialdowndate]=sprintf("%s;%s;%s;%s",mystrftime("%Y-%m-%d;%H:%M:%S",partialdowndate),"","PartialOutage: "partialpercentage"% availability",convertSeconds(partialdowntime,1))
			downdateList[partialdowndate]=partialdowndate
			totalpartialdowntime+=partialdowntime
			if (partialpercentage >= 0) totalweightedpartialdowntime+=partialdowntime*partialpercentage/100
			if (mosdebug==1) print restartData[partialdowndate]
			nr_of_partialoutages++
		}

		#2009-02-03 01:03:30 OTHR  NodeRestarted CV=STP49_P7MD UP=CXP9012995_R6AJ/2 P7.0
		#2009-02-03 01:04:17 OTHR  PeriodicLogging CV=STP49_P7MD UP=CXP9012995_R6AJ/2 P7.0
		#2009-02-03 01:42:12 OTHR  ConfigVersionCreated CV=Si_CXP9012995_R6CF%4_090203_0141 UP=CXP9012995_R6AJ/2 P7.0
		if (line ~ /OTHR .*CV=[^ ]+ +UP=[^ ]+/)
		{
			last=split(line,word," ")
			for (i=3;i<=last;i++) { if (word[i]~/^CV=/) tmpcv=gensub(/^CV=/,"",1,word[i]) ; else if (word[i]~/^UP=/) tmpup=gensub(/^UP=/,"",1,word[i])}
			buildLmidTable();
			swReleaseTable[tmpcv]=up_translate(tmpup,"short")
		}

		if (line ~ /Node restart order received. Restart rank = |Node manual restart, reason:/)
		{
			tmp_typeOfRestart=sprintf("Manual%s",gensub(/^.*rank = *|. Info text.*$/,"","g",line))
			#in CPP5.1, there is some extra stuff after the rank, we remove it
			#2006-03-21 11:29:01 INFO  Node restart order received. Restart rank = cold. Info text =
			#in CPP5.1, there is a new action manualRestart which gives following output:
			#2007-03-27 18:02:18 INFO  Node manual restart, reason: planned reconfiguration. Restart rank = warm. Info text = -

			gsub(/ /,"",tmp_typeOfRestart)
			if (tmp_typeOfRestart ~ /cold.*test/) tmp_typeOfRestart="ManualcoldWtest"
		}

		if (line ~ /Cls_evlogd_proc restart/ && nodehasbeendown==0)  #CRIT.*Node down cannot be used because in some restarts, only Cls_evlogd_proc restart is seen
		{
			nodehasbeendown=1
			waitingforapplication=0
			configversionhasbeenmet=0
			downdate=finaldate
			downdateList[downdate]=downdate
		}
		else if (line ~ /Node operational|NODE  IN   Operational *$/  && nodehasbeendown==1)
		{
			nodeoperhasbeenmet=1
			waitingforapplication=waitingforjvm=1  #new, we now allow that the application/jvm downtime can be lower than cpp downtime
		}
		else if (line ~ /Configuration Version =/ && nodehasbeendown==1)
		{
			waitingforapplication=waitingforjvm=1  #new, we now allow that the application/jvm downtime can be lower than cpp downtime
			if (configversionhasbeenmet != 1)
			{
				if (line ~ /Temporary_|Te_|SU_/) typeOfRestart="SwUpgrade"
				else if (tmp_typeOfRestart != "")
				{
					typeOfRestart=tmp_typeOfRestart
					tmp_typeOfRestart=""
				}
				currentConfigVersion=gensub(/.*Configuration Version = *| *$/,"","g",line)
				sub(/ +\(.+$/,"",currentConfigVersion)  #in case the cv name contains a CXC number, the lmid function would have added a translation afterwards
				configversionhasbeenmet=1
				#avoiding to have the restart date as 1970, this happens sometimes on the line Cls_evlogd_proc
				#if (mystrftime("%Y",downdate) == "1970") refdate=currentDate ; else refdate=downdate
				refdate=currentDate  #use this one instead to align the timestamps with restartcollector -r
			}
		}

		#if (nodehasbeendown==1 && line != "") print line

		#The algorithm assumes that the line "Configuration Version =" always comes before the line "RNC Node Restart Completed
		#This is not the case anymore from CPP5.1 where the line "Configuration Version =" often comes after RNC Node Restart Completed
		#The following code is to adapt for CPP5.1:

		#we must add 10 seconds to the "up date/application up date" to cope for the fact that we counted the downdate from cls_evlogd_restart instead of "Node down"

		if (line ~ /Node operational|NODE  IN   Operational *$/ && update <= downdate) update=finaldate
		if (line ~ /RNC Node Restart Completed|Cell .* enabled|First VMGw Enabled|VMGWs Unlocked|IN +Operational +(NBIOT)?CELL/ && appupdate <= downdate) appupdate=finaldate

		#End of CPP5.1 adaptation

		if ((line ~ /Node operational|NODE  IN   Operational *$/ && nodehasbeendown==1 && configversionhasbeenmet==1) || \
		    (line ~ /Configuration Version =/ && nodehasbeendown==1 && nodeoperhasbeenmet==1) || \
		    (line ~ /Cls_evlogd_proc restart/ && nodehasbeendown==1 && finaldate != downdate))  #in case there is a consecutive restart before the node even had time to come up
		{
			nodehasbeendown=nodeoperhasbeenmet=configversionhasbeenmet=0
			waitingforapplication=waitingforjvm=1
			if (update <= downdate) update=finaldate  #we only set "update" in case it has not already been found above, this would be the case in cpp5.0 and below
			if (update > downdate)
			{
				numberOfNodeRestarts[1,1]++
				NodeDowntime[1,1]=NodeDowntime[1,1]+update-downdate
				if ((update-downdate) > maxNodeDowntime[1,1]) maxNodeDowntime[1,1]=update-downdate
				if ((update-downdate) < minNodeDowntime[1,1]) minNodeDowntime[1,1]=update-downdate
				if (typeOfRestart == "SwUpgrade")
				{
					numberOfNodeRestarts[1,2]++
					NodeDowntime[1,2]=NodeDowntime[1,2]+update-downdate
					if ((update-downdate) > maxNodeDowntime[1,2]) maxNodeDowntime[1,2]=update-downdate
					if ((update-downdate) < minNodeDowntime[1,2]) minNodeDowntime[1,2]=update-downdate
				}
				else
				{
					if (typeOfRestart ~ "Manual")
					{
						NodeDowntime[1,3]=NodeDowntime[1,3]+update-downdate
						numberOfNodeRestarts[1,3]++
						if ((update-downdate) > maxNodeDowntime[1,3]) maxNodeDowntime[1,3]=update-downdate
						if ((update-downdate) < minNodeDowntime[1,3]) minNodeDowntime[1,3]=update-downdate
					}
					else if (typeOfRestart ~ "Spontaneous")
					{
						NodeDowntime[1,4]=NodeDowntime[1,4]+update-downdate
						numberOfNodeRestarts[1,4]++
						if ((update-downdate) > maxNodeDowntime[1,4]) maxNodeDowntime[1,4]=update-downdate
						if ((update-downdate) < minNodeDowntime[1,4]) minNodeDowntime[1,4]=update-downdate
					}
					numberOfNodeRestarts[1,5]++
					NodeDowntime[1,5]=NodeDowntime[1,5]+update-downdate
					if ((update-downdate) > maxNodeDowntime[1,5]) maxNodeDowntime[1,5]=update-downdate
					if ((update-downdate) < minNodeDowntime[1,5]) minNodeDowntime[1,5]=update-downdate
				}
				restartData[downdate]=sprintf("%s  %-15s  %-40s  %-20s  %-20s  %s",mystrftime("%Y-%m-%d %H:%M:%S",refdate),typeOfRestart,currentConfigVersion,convertSeconds(update-downdate+10,1),convertSeconds(appupdate-downdate+10,1),convertSeconds(jvmupdate-downdate+10,1))
				csv_restartData[downdate]=sprintf("%s;%s;%s;%s;%s;%s",mystrftime("%Y-%m-%d;%H:%M:%S",refdate),typeOfRestart,currentConfigVersion,convertSeconds(update-downdate+10,1),convertSeconds(appupdate-downdate+10,1),convertSeconds(jvmupdate-downdate+10,1))
				typeOfRestartList[downdate]=typeOfRestart
				typeOfRestart="Spontaneous"
				#print mystrftime("20%y-%m-%d %H:%M:%S",downdate)"  CRIT  Node down"
			}
		}
		if ((line ~ /RNC Node Restart Completed|Cell .* enabled|First VMGw Enabled|VMGWs Unlocked|IN +Operational +(NBIOT)?CELL/ && waitingforapplication==1)||\
		    (line ~ /Configuration Version =|Cls_evlogd_proc restart/ && appupdate > downdate))
		{
			waitingforapplication=0
			if (appupdate <= downdate) appupdate=finaldate #we only set "update" in case it has not already been found above, this would be the case in cpp5.0 and below
			if (appupdate > downdate)
			{
				numberOfNodeRestarts[2,1]++
				NodeDowntime[2,1]=NodeDowntime[2,1]+appupdate-downdate
				if ((appupdate-downdate) > maxNodeDowntime[2,1]) maxNodeDowntime[2,1]=appupdate-downdate
				if ((appupdate-downdate) < minNodeDowntime[2,1]) minNodeDowntime[2,1]=appupdate-downdate
				if (restartData[downdate] ~ "SwUpgrade")
				{
					numberOfNodeRestarts[2,2]++
					NodeDowntime[2,2]=NodeDowntime[2,2]+appupdate-downdate
					if ((appupdate-downdate) > maxNodeDowntime[2,2]) maxNodeDowntime[2,2]=appupdate-downdate
					if ((appupdate-downdate) < minNodeDowntime[2,2]) minNodeDowntime[2,2]=appupdate-downdate
				}
				else
				{
					if (restartData[downdate] ~ "Manual")
					{
						numberOfNodeRestarts[2,3]++
						NodeDowntime[2,3]=NodeDowntime[2,3]+appupdate-downdate
						if ((appupdate-downdate) > maxNodeDowntime[2,3]) maxNodeDowntime[2,3]=appupdate-downdate
						if ((appupdate-downdate) < minNodeDowntime[2,3]) minNodeDowntime[2,3]=appupdate-downdate
					}
					else if (restartData[downdate] ~ "Spontaneous")
					{
						numberOfNodeRestarts[2,4]++
						NodeDowntime[2,4]=NodeDowntime[2,4]+appupdate-downdate
						if ((appupdate-downdate) > maxNodeDowntime[2,4]) maxNodeDowntime[2,4]=appupdate-downdate
						if ((appupdate-downdate) < minNodeDowntime[2,4]) minNodeDowntime[2,4]=appupdate-downdate
					}
					numberOfNodeRestarts[2,5]++
					NodeDowntime[2,5]=NodeDowntime[2,5]+appupdate-downdate
					if ((appupdate-downdate) > maxNodeDowntime[2,5]) maxNodeDowntime[2,5]=appupdate-downdate
					if ((appupdate-downdate) < minNodeDowntime[2,5]) minNodeDowntime[2,5]=appupdate-downdate
				}
				tlist[2]=2 ; tname[2]="Application"
				restartData[downdate]=sprintf("%s  %-15s  %-40s  %-20s  %-20s  %s",mystrftime("%Y-%m-%d %H:%M:%S",refdate),typeOfRestartList[downdate],currentConfigVersion,convertSeconds(update-downdate+10,1),convertSeconds(appupdate-downdate+10,1),convertSeconds(jvmupdate-downdate+10,1))
				csv_restartData[downdate]=sprintf("%s;%s;%s;%s;%s;%s",mystrftime("%Y-%m-%d;%H:%M:%S",refdate),typeOfRestartList[downdate],currentConfigVersion,convertSeconds(update-downdate+10,1),convertSeconds(appupdate-downdate+10,1),convertSeconds(jvmupdate-downdate+10,1))
			}
		}
		if (line ~ /JVM Load Module is now operational|The Configuration Service is up and running/ && waitingforjvm==1)
		{
			waitingforjvm=0
			#we only set "jvmupdate" for the first time it is met, in case there were subsequent jvm restarts
			if (jvmupdate <= downdate) jvmupdate=finaldate
			if (jvmupdate > downdate)
			{
				restartData[downdate]=sprintf("%s  %-15s  %-40s  %-20s  %-20s  %s",mystrftime("%Y-%m-%d %H:%M:%S",refdate),typeOfRestartList[downdate],currentConfigVersion,convertSeconds(update-downdate+10,1),convertSeconds(appupdate-downdate+10,1),convertSeconds(jvmupdate-downdate+10,1))
				csv_restartData[downdate]=sprintf("%s;%s;%s;%s;%s;%s",mystrftime("%Y-%m-%d;%H:%M:%S",refdate),typeOfRestartList[downdate],currentConfigVersion,convertSeconds(update-downdate+10,1),convertSeconds(appupdate-downdate+10,1),convertSeconds(jvmupdate-downdate+10,1))
			}
		}
		if (line ~ /Cls_evlogd_proc restart/)
		{
			nodehasbeendown=1
			waitingforapplication=0
			configversionhasbeenmet=0
			downdate=finaldate
			downdateList[downdate]=downdate
		}
	}
	close(file)
	if (nodehasbeendown==1)
	{
		#in case we took the print right in the middle of a restart and the "node operational" didnt get printed yet, we put the data for the last restart
		update=finaldate
		restartData[downdate]=sprintf("%s  %-15s  %-40s  %-20s",mystrftime("%Y-%m-%d %H:%M:%S",refdate),typeOfRestart,currentConfigVersion,convertSeconds(update-downdate+10,1))
		csv_restartData[downdate]=sprintf("%s;%s;%s;%s",mystrftime("%Y-%m-%d;%H:%M:%S",refdate),typeOfRestart,currentConfigVersion,convertSeconds(update-downdate+10,1))
	}
	n=asort(downdateList)
	for (k in tlist)
	{
		if (startdate > 0) begindate[k]=startdate
		if (begindate[k]=="") numberOfDays[k]=1
		else numberOfDays[k]=int((todaysdate-begindate[k])/(24*3600))+0
		if (numberOfDays[k]==0) numberOfDays[k]=1
	}
	if (batch != 1)
	{
		if (csvformat==1)
		{
			customPrint("\nDate;Time;Restart Type;ConfigurationVersion;SwRelease;CPPDowntime;ApplicationDowntime;JVMDowntime")
		}
		else
		{
			customPrint("\n=====================================================================================================================================")
			customPrint(sprintf("%-19s %-15s %-40s %-9s %-15s %-15s %s","Timestamp (UTC)","Restart Type","Configuration Version","SwRelease","CPP Downtime","Appl. Downtime","JVM Downtime"))
			customPrint("=====================================================================================================================================")
		}
		for (i=1;i<=n;i++)
		{
			#after CPP7-LSV34, the Cls_evlogd_proc restart can appear several times for the same node restart, leading to two consecutive entries for the same restart
			#both entries have the correct info for the date/time and CV but only the first entry has the correct restartType info while only the second entry has the correct info for downtime values
			split(csv_restartData[downdateList[i]],array,";")
			if (array[3] != "" && array[4] !~ /^PartialOutage:/)
			{
				split(array[4],arraycv," ")
				tmp_cv=arraycv[1]
				tmp_sw=arraycv[2]
				if (tmp_sw == "") tmp_sw=swReleaseTable[tmp_cv]
			}
			else tmp_cv=array[4]
			if ((array[1],array[2],array[4]) in restartDataPrinted) continue
			if ((i+1) in downdateList && downdateList[i+1] in csv_restartData)
			{
				split(csv_restartData[downdateList[i+1]],array2,";")
				if (array2[1]==array[1] && array2[2]==array[2] && array2[4]==array[4])
				{
					if (csvformat==1) customPrint(sprintf("%s;%s;%s;%s;%s;%s;%s;%s",array[1],array[2],array[3],tmp_cv,tmp_sw,array2[5],array2[6],array2[7]))
					else customPrint(sprintf("%s %s %-15s %-40s %-9s %-15s %-15s %s",array[1],array[2],array[3],tmp_cv,tmp_sw,array2[5],array2[6],array2[7]))
					i++
					restartDataPrinted[array[1],array[2],array[4]]=1
					continue
				}
			}
			if (csvformat==1) customPrint(sprintf("%s;%s;%s;%s;%s;%s;%s;%s",array[1],array[2],array[3],tmp_cv,tmp_sw,array[5],array[6],array[7]))
			else customPrint(sprintf("%s %s %-15s %-40s %-9s %-15s %-15s %s",array[1],array[2],array[3],tmp_cv,tmp_sw,array[5],array[6],array[7]))
			restartDataPrinted[array[1],array[2],array[4]]=1
		}
		todaysdate=getTodayUTC()
		#print "today: "todaysdate,mystrftime("%Y %m %d %H %M %S",todaysdate)
		#print "update: "update,mystrftime("%Y %m %d %H %M %S",update)
		#print begindate,startdate
		if (update != "") uptime=convertSeconds(todaysdate-update)
		else uptime="unknown"
		customPrint("\n======================================================================================================")
		customPrint("Summary")
		customPrint("======================================================================================================")
		customPrint(sprintf("%-52s  %s","Node Up Time since last restart",uptime))
		customPrint(sprintf("%-52s  %s","Number of days covered in this log",numberOfDays[1]))
		if (numberOfNodeRestarts[2,1]>0) customPrint(sprintf("%-52s  %s","Number of days with Application information",numberOfDays[2]))
		for (k=1;k<=2;k++)
		{
			if (tname[k] != "")
			{
				customPrint("--------------------------------------------------------------------------------------------------------------------------------------")
				customPrint(sprintf("%-29s  %-21s %-20s %-20s %-20s %-20s",tname[k]" Downtime","Total","SwUpgrade","Manual","Spontaneous","Manual+Spontaneous"))
				customPrint("--------------------------------------------------------------------------------------------------------------------------------------")
				customPrint(sprintf("%-29s  %-21s %-20s %-20s %-20s %-20s","Number Of Node Restarts",numberOfNodeRestarts[k,1],numberOfNodeRestarts[k,2],numberOfNodeRestarts[k,3],numberOfNodeRestarts[k,4],numberOfNodeRestarts[k,5]))
				for (a=1;a<=5;a++) if (numberOfNodeRestarts[k,a]==0) numberOfNodeRestarts[k,a]=1 #avoid division by 0
				for (a=1;a<=5;a++) if (minNodeDowntime[k,a]==1E8) minNodeDowntime[k,a]=0  #for cases where there isnt a min dowtime
				customPrint(sprintf("%-29s  %-21s %-20s %-20s %-20s %-20s","Node  Downtime forWholePeriod",convertSeconds(NodeDowntime[k,1],1),convertSeconds(NodeDowntime[k,2],1),convertSeconds(NodeDowntime[k,3],1),convertSeconds(NodeDowntime[k,4],1),convertSeconds(NodeDowntime[k,5],1)))
				customPrint(sprintf("%-29s  %-21s %-20s %-20s %-20s %-20s","Avrge Downtime perDay",convertSeconds(NodeDowntime[k,1]/numberOfDays[k],1),convertSeconds(NodeDowntime[k,2]/numberOfDays[k],1),convertSeconds(NodeDowntime[k,3]/numberOfDays[k],1),convertSeconds(NodeDowntime[k,4]/numberOfDays[k],1),convertSeconds(NodeDowntime[k,5]/numberOfDays[k],1)))
				customPrint(sprintf("%-29s  %-21s %-20s %-20s %-20s %-20s","Avrge Downtime perNodeRestart",convertSeconds(NodeDowntime[k,1]/numberOfNodeRestarts[k,1],1),convertSeconds(NodeDowntime[k,2]/numberOfNodeRestarts[k,2],1),convertSeconds(NodeDowntime[k,3]/numberOfNodeRestarts[k,3],1),convertSeconds(NodeDowntime[k,4]/numberOfNodeRestarts[k,4],1),convertSeconds(NodeDowntime[k,5]/numberOfNodeRestarts[k,5],1)))
				customPrint(sprintf("%-29s  %-21s %-20s %-20s %-20s %-20s","Max   Downtime perNodeRestart",convertSeconds(maxNodeDowntime[k,1],1),convertSeconds(maxNodeDowntime[k,2],1),convertSeconds(maxNodeDowntime[k,3],1),convertSeconds(maxNodeDowntime[k,4],1),convertSeconds(maxNodeDowntime[k,5],1)))
				customPrint(sprintf("%-29s  %-21s %-20s %-20s %-20s %-20s","Min   Downtime perNodeRestart",convertSeconds(minNodeDowntime[k,1],1),convertSeconds(minNodeDowntime[k,2],1),convertSeconds(minNodeDowntime[k,3],1),convertSeconds(minNodeDowntime[k,4],1),convertSeconds(minNodeDowntime[k,5],1)))
			}
		}
		if (nr_of_partialoutages >0 )
		{
			customPrint(sprintf("--------------------------------------------------------------------------------------------------------------------------------------\n\
NumberOfPartialOutages    WeightedPartialDowntime          TotalPartialDowntime             AveragePartialDowntime per outage\n\
--------------------------------------------------------------------------------------------------------------------------------------\n\
%-24s  %-31s  %-31s  %s",nr_of_partialoutages,convertSeconds(totalweightedpartialdowntime,1),convertSeconds(totalpartialdowntime,1),convertSeconds(int(totalpartialdowntime/nr_of_partialoutages),1)))
		}
	}
	else
	{
		#cello=1 ; application=2
		if (itemise_restarts)
	        {
			#customPrint("\n==============================================================================================================")
			#customPrint(sprintf("%-12s  %-19s  %-12s  %-40s  %-20s  %-20s  %s","Node","Timestamp (UTC)","Restart Type","ConfigurationVersion","CPP Downtime","Application Downtime","JVM Downtime"))
			#customPrint("==============================================================================================================")
			for (i=1;i<=n;i++) customPrint(sprintf("%s;%s",currentNode,csv_restartData[downdateList[i]]))
		}
		tname[2]="Application"
		for (k=1;k<=2;k++)
		{
			#all these tables starting with an uppercase letter are global
			NrOfDays[currentNode,k]=numberOfDays[k]+0
			for (a=1;a<=5;a++)
			{
				NrOfRestarts[currentNode,k,a]=numberOfNodeRestarts[k,a]+0
				WholeDowntime[currentNode,k,a]=NodeDowntime[k,a]+0
				if (numberOfNodeRestarts[k,a]==0) numberOfNodeRestarts[k,a]=1
				if (numberOfDays[k]==0) numberOfDays[k]=1
				AvrgeDowntimePerRestart[currentNode,k,a]=(NodeDowntime[k,a]/numberOfNodeRestarts[k,a]) +0
				AvrgeDowntimePerDay[currentNode,k,a]=(NodeDowntime[k,a]/numberOfDays[k])+0
				if ((NodeDowntime[k,a]+0) > maxWholeDowntime[k,a]) maxWholeDowntime[k,a]=NodeDowntime[k,a]+0
				if ((maxNodeDowntime[k,a]+0) > maxNodeDowntimeGlobal[k,a]) maxNodeDowntimeGlobal[k,a]=maxNodeDowntime[k,a]+0
				maxNodeDowntimeTable[currentNode,k,a]=maxNodeDowntime[k,a]
			}
		}
		for (k in smn) nrOfSubracks[currentNode]++   #nrOfSubracks is a global variable
		#for (k in tlist) print currentNode,k,NrOfRestarts[currentNode,k]
	}
}
function save_noderestart_entry(   i,k,previousEntry,currentEntry,incombinedEntry,combinedEntry,totCause)
{
	if (!("type" in nodeR))
	{
		if (nodeR["cv"] ~ /^(Temporary|Te)_/) nodeR["type"]="Upgrade"  #CPP4 and lower, the upgrade restart is not given by row "upgrade restart, reason"
		else nodeR["type"]=sprintf("Spontaneous%s%s",nodeR["spontaneousRank"],nodeR["spontaneousCause"])
	}
	else if (comcli>0 && "type" in nodeR && nodeR["type"]~/^Upgrade/) nodeR["type"]=nodeR["type"] nodeR["spontaneousCause"]
	#ignore spontaneous node restarts that dont have a CV
	if ("start" in nodeR && "cv" in nodeR)
	{
		if (!("cpp" in nodeR)) nodeR["cpp"]=nodeR["cpp2"]
		#if the startyear of the restart is 1970 we assign it the cpp/app/jvm date if they are above year 2000
		if (mystrftime("%Y",nodeR["start"])<2000 && mystrftime("%Y",nodeR["cpp"])>2000) nodeR["start"]=nodeR["cpp"]
		if (nodeR["cpp"] > nodeR["start"]) nodeR["cppD"]=nodeR["cpp"]-nodeR["start"] ; else nodeR["cppD"]=""
		if (mystrftime("%Y",nodeR["start"])<2000 && mystrftime("%Y",nodeR["app"])>2000) nodeR["start"]=nodeR["app"]
		if (nodeR["app"] > nodeR["start"]) nodeR["appD"]=nodeR["app"]-nodeR["start"] ; else nodeR["appD"]=""
		if (mystrftime("%Y",nodeR["start"])<2000 && mystrftime("%Y",nodeR["jvm"])>2000) nodeR["start"]=nodeR["jvm"]
		if (nodeR["jvm"] > nodeR["start"]) nodeR["jvmD"]=nodeR["jvm"]-nodeR["start"] ; else nodeR["jvmD"]=""
		if (comcli>0)
		{
			if (nodeR["tn"]   > nodeR["start"]) nodeR["tnD"]  =nodeR["tn"]  -nodeR["start"] ; else nodeR["tnD"]=""
			if (nodeR["nrat"] > nodeR["start"]) nodeR["nratD"]=nodeR["nrat"]-nodeR["start"] ; else nodeR["nratD"]=""
			if (nodeR["lrat"] > nodeR["start"]) nodeR["lratD"]=nodeR["lrat"]-nodeR["start"] ; else nodeR["lratD"]=""
			if (nodeR["wrat"] > nodeR["start"]) nodeR["wratD"]=nodeR["wrat"]-nodeR["start"] ; else nodeR["wratD"]=""
			if (nodeR["grat"] > nodeR["start"]) nodeR["gratD"]=nodeR["grat"]-nodeR["start"] ; else nodeR["gratD"]=""
		}
		if (nodeR["phased"]==1)
		{
			nodeR["type"]=nodeR["type"]"*"
			nodeR["jvmD"]=""
			if (nodeR["jvmPdown"]=="") nodeR["jvmPdown"]=nodeR["jvmLastRestart"]
			if (nodeR["jvmPup"] > nodeR["jvmPdown"]) nodeR["jvmD"]=nodeR["jvmPup"] - nodeR["jvmPdown"]
		}
		restartList[++restartCount]=sprintf("%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s",nodeR["start"],nodeR["type"],nodeR["cv"],nodeR["cppD"],nodeR["appD"],nodeR["jvmD"],swReleaseTable[nodeR["cv"],"full"],swReleaseTable[nodeR["cv"]],nodeR["tnD"],nodeR["nratD"],nodeR["lratD"],nodeR["wratD"],nodeR["gratD"],nodeR["extraInfo"],nodeR["extraInfo2"])
		if (mosdebug==1) print "****** "sprintf("%s;%s;%s;%s;%s;%s;%s;%s",strftime("%Y-%m-%d %H:%M:%S",nodeR["start"]),nodeR["type"],nodeR["cv"],nodeR["cppD"],nodeR["appD"],nodeR["jvmD"],swReleaseTable[nodeR["cv"],"full"],swReleaseTable[nodeR["cv"]])
		summary["lastup"]=(nodeR["app"]>nodeR["cpp"]?nodeR["app"]:nodeR["cpp"])
		summary["lastdowntime"]=(nodeR["appD"]>nodeR["cppD"]?nodeR["appD"]:nodeR["cppD"])
		summary["All","nr"]++
		summary["All","downtime"]+=summary["lastdowntime"]
		if (nodeR["type"]~"Spontaneous") { summary["Spontaneous","nr"]++ ; summary["Spontaneous","downtime"]+=summary["lastdowntime"] }
		else if (nodeR["type"]~"Manual")  { summary["Manual","nr"]++      ; summary["Manual","downtime"]+=summary["lastdowntime"] }
		else if (nodeR["type"]~"Upgrade") { summary["Upgrade","nr"]++     ; summary["Upgrade","downtime"]+=summary["lastdowntime"] }
	}
	for (k=1;k<=outageCount;k++)
	{
		if (outageList[k] !~ /Partial +[0-9]+% +Cell/)
		{
			#not an LTE partial outage
			restartList[++restartCount]=outageList[k]
		}
		else
		{
			#For LTE partial outages, we combine adjacent entries
			#outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",partialR["start"],partialR["text"],"",partialR["downtime"])
			#1297861795;Partial 33% Cell 15 (System);;123;;
			#translates into:  2011-02-16 21:09:55   Partial 33% Cell 15 (System)        L11B      123s (2m3s)
			delete currentEntry
			delete nextEntry
			split(outageList[k],currentEntry,";")
			split(outageList[k+1],nextEntry,";")
			currentEntry["start"]=currentEntry[1]
			currentEntry["%"]=gensub(/^Partial +|% +Cell.*$/,"",1,currentEntry[2])+0
			currentEntry["cause"]=gensub(/^.*\(/,"",1,currentEntry[2])
			currentEntry["cell"]=gensub(/^Partial.*Cell +| +\(.*$/,"","g",currentEntry[2])
			currentEntry["duration"]=currentEntry[4]
			nextEntry["start"]=nextEntry[1]
			if (currentEntry["start"]+currentEntry["duration"] == nextEntry["start"])
			{
				#the next entry is adjacent, we buffer the current entry in the table combinedEntry
				if (incombinedEntry!=1)
				{
					#if this is the first row of the combine entry, initialise the values
					delete combinedEntry
					combinedEntry["start"]=currentEntry["start"]
					combinedEntry["%"]=currentEntry["%"]*currentEntry["duration"]
					combinedEntry["cause"]=currentEntry["cause"]
					combinedEntry["cell"]=currentEntry["cell"]
					combinedEntry["duration"]=currentEntry["duration"]
					incombinedEntry=1
				}
				else
				{
					#if this is not the first row of the combined entry, combine the values
					combinedEntry["%"]+=currentEntry["%"]*currentEntry["duration"]
					combinedEntry["duration"]+=currentEntry["duration"]
					#for the cell we take the longest string, meaning the most cells affected
					if (length(currentEntry["cell"]) > length(combinedEntry["cell"])) combinedEntry["cell"]=currentEntry["cell"]
					#reduce the total number of partial outages
					summary["Partial","nr"]--
				}
			}
			else
			{
				#the next entry is not adjacent, we save the current entry
				if (incombinedEntry!=1)	restartList[++restartCount]=outageList[k]
				else
				{
					#combine the values
					combinedEntry["%"]+=currentEntry["%"]*currentEntry["duration"]
					combinedEntry["duration"]+=currentEntry["duration"]
					combinedEntry["%"]=sprintf("%.0f%",combinedEntry["%"]/combinedEntry["duration"])
					#for the cell we take the longest string, meaning the most cells affected
					if (length(currentEntry["cell"]) > length(combinedEntry["cell"])) combinedEntry["cell"]=currentEntry["cell"]
					restartList[++restartCount]=sprintf("%s;%s;;%s;;",combinedEntry["start"],"Partial "combinedEntry["%"]" Cell "combinedEntry["cell"]" ("combinedEntry["cause"],combinedEntry["duration"])
					delete combinedEntry
					incombinedEntry=0
					summary["Partial","nr"]--
				}
			}
		}
	}
	delete nodeR
	delete partialR
	delete outageList
	tRat=""
	outageCount=0
}
function capfirst(string)
{
	sub(/^ +/,"",string)
	split(string,array,"")
	string=toupper(array[1]) gensub(/^./,"",1,string)
	return string
}
function make_outageInfoTable(line,outageInfoTable)
{
	#2016-10-18 11:10:52 SERV  OUT_PARTIAL  UnOperational    CELL 1                   Lrat Weighting factor: 16 percent, Existing CellIds: 6 5 4 3 2 1 , Cause: System
	delete outageInfoTable["cause"]
	delete outageInfoTable["cell"]
	delete outageInfoTable["percent"]
	if (line ~ / Cause: /) outageInfoTable["cause"]=" ("gensub(/^.* Cause: /,"",1,line)")"
	if (line ~ /CELL [0-9]+/) outageInfoTable["cell"]=" Cell "gensub(/^.* (NBIOT)?CELL | +(Lrat )?Weighting factor:.*$/,"","g",line)
	if (line ~ /Weighting factor:/) outageInfoTable["percent"]=" "gensub(/^.*Weighting factor: | percent,.*$/,"","g",line)"%"
}
function showNodeDowntime(file,startdate,enddate,    line,array,currentDate,inrange,todaysdate,last,word,i,tmpcv,tmpup,\
inrestart,nodeop,nodecv,swRel,swRelFull,inAppRestart,tmpreason,tmpOutageT,inbp,coreMp,nrCoreMp,d,t,z,thearray,a,l1,l2,\
theRestartReason,lastPiuRestartReason,ratList,tmprat,zz,xx)
{
	#The input is a logfile from the command "lgvsum%"

	#Mapping of restart reasons:
	#0 2010-09-06 08:26:21 INFO  Node manual restart, reason: planned reconfiguration. Restart rank = warm. Info text = 0
	#1 2010-09-20 08:20:08 INFO  Node manual restart, reason: node external problems. Restart rank = warm. Info text = -
	#2 2010-09-20 08:20:50 INFO  Node manual restart, reason: upgrade problems. Restart rank = warm. Info text = -
	#3 2010-09-20 08:24:44 INFO  Node manual restart, reason: O and M issues. Restart rank = warm. Info text = -
	#4 2010-09-20 08:25:16 INFO  Node manual restart, reason: stop cyclic recovery. Restart rank = warm. Info text = -
	#5 2010-09-20 08:39:49 INFO  Node manual restart, reason: release locked resources. Restart rank = warm. Info text = -
	#6 2010-09-20 08:42:26 INFO  Node manual restart, reason: perform HW tests. Restart rank = warm. Info text = -
	#6 2013-04-10 21:26:21 INFO  MP ( smn = 0, apn = 1 ) manual restart. Reason: Perform HW tests. Restart rank = cold with HW test. Info text = timing
	#7 2010-09-20 08:45:04 INFO  Node manual restart, reason: call processing degradation. Restart rank = warm. Info text = -
	#8 2010-09-20 08:47:56 INFO  Node manual restart, reason: low coverage. Restart rank = warm. Info text = -
	#from the MOM:
	#0:PLANNED_RECONFIGURATION, 1:UNPLANNED_NODE_EXTERNAL_PROBLEMS, 2:UNPLANNED_NODE_UPGRADE_PROBLEMS, 3:UNPLANNED_O_AND_M_ISSUE, 4:UNPLANNED_CYCLIC_RECOVERY, 5:UNPLANNED_LOCKED_RESOURCES, 6:UNPLANNED_COLD_WITH_HW_TEST, 7:UNPLANNED_CALL_PROCESSING_DEGRADATION, 8:UNPLANNED_LOW_COVERAGE, 30:UPGRADE_BOARD_RESTART, 31:OPERATOR_CLASSIFIED_PROBLEMS
	#From the document 26/102 60-CSX 101 09 , avlog causes:
	#ExtRestartRequest/
	#ManualReconfiguration/
	#ManualExternalProblems/
	#ManualUpgradeProblems/
	#ManualOandMIssues/
	#ManualStopCyclicRecovery/
	#ManualReleaseLockedResources/
	#ManualPerformHWTest/
	#ManualCallProcessingDegradation/
	#ManualLowCoverage/
	#UpgradeNormal/
	#UpgradeFailure/
	#UpgradeCancelled/
	#UpgradeRestore/
	#UpgradeRestoreFailed/
	#UpgradeRestoreCancelled/
	reasonCode["planned reconfiguration"]=reasonCode["Planned reconfiguration"]=reasonCode["ManualReconfiguration"]=0
	reasonCode["node external problems"]=reasonCode["Node external problems"]=reasonCode["ManualExternalProblems"]=1
	reasonCode["upgrade problems"]=reasonCode["Upgrade problems"]=reasonCode["ManualUpgradeProblems"]=2
	reasonCode["O and M issues"]=reasonCode["ManualOandMIssues"]=3
	reasonCode["stop cyclic recovery"]=reasonCode["Stop cyclic recovery"]=reasonCode["ManualStopCyclicRecovery"]=4
	reasonCode["release locked resources"]=reasonCode["Release locked resources"]=reasonCode["ManualReleaseLockedResources"]=5
	reasonCode["perform HW tests"]=reasonCode["Perform HW tests"]=reasonCode["ManualPerformHWTest"]=6
	reasonCode["call processing degradation"]=reasonCode["Call processing degradation"]=reasonCode["ManualCallProcessingDegradation"]=7
	reasonCode["low coverage"]=reasonCode["Low coverage"]=reasonCode["ManualLowCoverage"]=8

	todaysdate=getTodayUTC()
	inrange=inrestart=nodeop=nodecv=inAppRestart=0
	summary["Partial","downtime"]=summary["Spontaneous","downtime"]=summary["Upgrade","downtime"]=summary["Manual","downtime"]=summary["All","downtime"]=0
	summary["Partial","nr"]=summary["Spontaneous","nr"]=summary["Upgrade","nr"]=summary["Manual","nr"]=summary["All","nr"]=0

	ratList["NR"]=ratList["LRAT"]=ratList["GRAT"]=ratList["WRAT"]=1

	while (getline line < file)
	{
		gsub("\r","",line)

		last=split(line,word," ")

		#Board   BoardType                 SwAllocation                    BoardGroups
		#===============================================================================================
		#000100  SCB2                      SCB                             all allp allpd bp scb scx
		#001000  GPB3                      CORBEN_GPB_Central              aal2cpsrc aal2nccadm admmp all allp allpd coremp mp
		#001500  GPB42                     CORBEN_GPB_Module               aal2ap aal2cpsrc aal2ncc aal2rh all allp allpd mp usaalmp
		#001800  SPB21                     CORBEN_SPB_0_5                  all allp allpd bp spb
		#001800/sp0.lnh                    **                              all alld
		#===============================================================================================
		#Total: 12 boards, 15 devices
		if (inbp < 2 && word[1]=="Board" && word[last]="BoardGroups") inbp=1
		else if (inbp==1 && word[1]=="Total:")
		{
			inbp=2
			nrCoreMp=asort(coreMp)
			#for (i=1;i<=nrCoreMp;i++) print "coreMp: "coreMp[i]
		}
		else if (inbp==1)
		{
			for (i=3;i<=last;i++) if (word[i]=="coremp") coreMp[word[1]]=word[1]
		}

		#2009-02-03 01:03:30 OTHR  NodeRestarted CV=STP49_P7MD UP=CXP9012995_R6AJ/2 P7.0
		#2009-02-03 01:04:17 OTHR  PeriodicLogging CV=STP49_P7MD UP=CXP9012995_R6AJ/2 P7.0
		#2009-02-03 01:42:12 OTHR  ConfigVersionCreated CV=Si_CXP9012995_R6CF%4_090203_0141 UP=CXP9012995_R6AJ/2 P7.0
		if (word[3]=="OTHR" && line ~ / CV=[^ ]+ +UP=[^ ]+/)
		{
			for (i=4;i<=last;i++)
			{
				if (word[i]~/^CV=/) tmpcv=gensub(/^CV=/,"",1,word[i])
				else if (word[i]~/^UP=/) tmpup=gensub(/^UP=/,"",1,word[i])
			}
			buildLmidTable();
			swReleaseTable[tmpcv]=up_translate(tmpup,"short")
			swReleaseTable[tmpcv,"full"]=tmpup
			swReleaseTable[tmpcv,"date"]=make_timestamp(word[1],word[2])
		}

		#2014-01-05 21:30:03 INFO  Configuration Version = SU_CXP102051%19_R37AL_140105_2129  L13B.1.10.0 (C13.2-EP13)
		if (word[3]=="INFO" && word[4]=="Configuration" && word[5]=="Version" && word[6]=="=" && word[7]~/CXP/ && word[8]~/^[WL][1-9]/)
		{
			swReleaseTable2[word[7]]=word[8]
		}

		if (word[1] !~ /^[12][0-9][0-9][0-9]-[01][0-9]-[0-3][0-9]$/) continue

		#Added the tag RcsNodeDown from 20.0e. Remove it for backward compatibility
		#2020-05-11 10:37:54 NODE  OUT  UnOperational    RankCold RcsNodeDown
		#2020-05-12 14:27:41 NODE  OUT  UnOperational    RankCold RcsNodeDown 2020-05-12 14:25:14
		#changed to:
		#2020-05-11 10:37:54 NODE  OUT  UnOperational    RankCold
		#2020-05-12 14:27:41 NODE  OUT  UnOperational    RankCold 2020-05-12 14:25:14
		gsub(/ RcsNodeDown/,"")

		#special case 2014-04-15 08:10:50 NODE  OUT  UnOperational    2014-04-15 08:10:25 , the real timestamp is at the end
		#comcli: 2015-11-25 15:30:50 NODE  OUT  UnOperational    RankCold 2015-11-25 15:24:45 . Note the timestamp can have one or two digits, eg 6:45:15 instead of 06:45:15
		#        2018-05-29 10:37:28 NODE  OUT  UnOperational    2018-05-29 10:37:19
		if (line ~ /NODE +OUT +UnOperational +(Rank[^ ]+ +)?2[0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] +[0-9][0-9]?:[0-9][0-9]?:[0-9][0-9]?/)
		{
			#old: z=split(line,thearray," "); d=thearray[z-1]; t=thearray[z]
			match(line,/ +(2[0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]) +([0-9][0-9]?:[0-9][0-9]?:[0-9][0-9]?)/,thearray)
			d=thearray[1]
			t=thearray[2]
		}
		else
		{
			d=word[1] ; t=word[2]
		}

		currentDate=make_timestamp(d,t)
		if (!(inrestart==0 && inAppRestart==0))
		{
			#if ("delta" in nodeR) currentDate+=nodeR["delta"]  #currently only applied on node restart timestamps
		}
		if (mystrftime("%Y",currentDate) > 2000)
		{
			if (!("logbegins" in summary)) summary["logbegins"]=currentDate
			if (!("start" in summary))
			{
				if (startdate > summary["logbegins"]) summary["start"]=startdate
				else summary["start"]=summary["logbegins"]
				if (enddate < todaysdate) summary["end"]=enddate
				else summary["end"]=todaysdate
				summary["days"]=sprintf("%.0f",(summary["end"]-summary["start"])/86400)
				#print "start="mystrftime("%Y%m%d",summary["start"])", end="mystrftime("%Y%m%d",summary["end"])", diff="summary["end"]-summary["start"]
			}
		}
		if (currentDate >= startdate) inrange=1
		if (currentDate > enddate) inrange=0

		#comcli: 2015-11-28 12:39:47 NODE  IN   Operational      RestartCompleted Lrat RestartCompleted LRAT Traffic Control ready
		#comcli: 2016-07-08 14:05:06 NODE  IN   Operational      Tn RestartCompleted
		#comcli: 2016-07-08 14:05:25 NODE  IN   Operational      Wrat RestartCompleted WRAT Traffic Control active
		if (line ~ /RNC Node Restart Completed|Cell .* enabled|First VMGw Enabled|VMGWs Unlocked|SERV +IN +Operational +(NBIOT)?CELL|INFO +Node operational|NODE +IN +Operational *((.rat |GNBDU )?RestartCompleted.*)? *$/)
		{
			#this check done in case lgd was run with a start time (e.g. lgd -m 1) and this range did not include a node restart, the uptime would be wrong
			lastUpTime=currentDate
		}

		if (inrange==0) continue

		#|INFO +Node starting
		if (mosdebug==1 && comcli==0 && line ~ \
/Node restart order received. |Node [^ ]+ restart, reason:|Cls_evlogd_proc restart|CRIT +Node down|Active CIM ready|\
NODE +OUT +UnOperational *(Rank[^ ]+ +)?([-:0-9 ]+)?$|OTHR +NodeRestarted .*CV=.* UP=|NODE +OUT +ShutdownCommand|\
RNC Node Restart Completed|Cell .* enabled|First VMGw Enabled|VMGWs Unlocked|SERV +IN +Operational +(NBIOT)?CELL|\
JVM Load Module is now operational|The Configuration Service is up and running|Program CXC(1320784|1732844).*started|\
Current Trace properties for Upgrade Package functionality|Current properties for System Upgrade trace functionality|\
Program restart order received for CXC(1320784|1732844)|Program CXC(1320784|1732844).* external restart ordered|\
INFO +Node (starting|operational)|NODE +IN +Operational *((.rat |GNBDU )?RestartCompleted.*)? *$|INFO +Configuration Version =|\
SERV +OUT_PARTIAL|SERV +OUT +UnOperational +(NBIOT)?CELL |\
SERV +IN *When in PartialOutOfService average was: -?[0-9]+ percent|SERV +IN +Operational +(NBIOT)?CELL|\
INFO  MP \( smn = [0-9]+, apn = [0-9]+ \) manual restart|\
INFO  MP Last PIU \(smn = [0-9]+, apn = [0-9]+ \) restart was caused by Mmi reset button|\
Start Action - .*(Upgrade|Install)|OTHR  NodeRestarted .*UP=|\
ShutdownNodePhasedRestart|JVM is (un)?operational|Node phased restart/) print line

		if (mosdebug==1 && comcli>0 && line ~ \
/NODE +OUT +UnOperational *(Rank[^ ]+ +)?([-:0-9 ]+)?|NODE +OUT +ShutdownCommand|SERV +IN +Operational +(NBIOT)?CELL|NODE +IN +Operational *((.rat |GNBDU )?RestartCompleted.*)?|\
SERV +OUT_PARTIAL|SERV +OUT +UnOperational +(NBIOT)?CELL |\
SERV +IN *When in PartialOutOfService average was: -?[0-9]+ percent|SERV +IN +Operational +(NBIOT)?CELL|\
HW +OUT +ShutdownCommand +(Baseband|DUS.2)|OTHR  NodeRestarted .*UP=|NODE +OUT_PARTIAL|PGM +OUT +UnOperational|RcsTimeChange/) print line

		#2017-08-03 13:39:07 NODE  OUT  ShutdownNodePhasedRestart  RankCold NodePhasedRestart
		if (comcli==0)
		{
			if (line ~ /ShutdownNodePhasedRestart|Node phased restart/) nodeR["phased"]=1
			else if (nodeR["phased"]==1)
			{
				if (line ~ /CRIT +Node down/) nodeR["start"]=currentDate
				else if (line ~ /JVM is unoperational/) nodeR["jvmPdown"]=currentDate
				else if (line ~ /JVM is operational/) nodeR["jvmPup"]=currentDate
				else if (line ~ /INFO +Program CXC1732844.* started/) nodeR["jvmLastRestart"]=currentDate
			}
		}

		if (nrCoreMp==1 && line ~ /INFO  MP \( smn = [0-9]+, apn = [0-9]+ \) manual restart|INFO  MP Last PIU \(smn = [0-9]+, apn = [0-9]+ \) restart was caused by Mmi reset button/)
		{
			#print "Debug: "nrCoreMp,coreMp[1],line
			for(i=1;i<=last;i++)
			{
				#2012-10-25 15:41:06 INFO  MP ( smn = 0, apn = 10 ) manual restart. Reason: Planned reconfiguration. Restart rank = warm. Info text = 0
				#2012-10-25 23:08:32 INFO  MP ( smn = 0, apn = 10 ) manual restart. Reason: Planned reconfiguration. Restart rank = warm. Info text = 0
				if (word[i]=="smn" && sprintf("%02d%02d00",gensub(/,$/,"",1,word[i+2]),word[i+5])==coreMp[1])
				{
					#print "oldLine:"line
					#line=sprintf("%s %s INFO  Node restart order received. Restart rank = %s. Info text =",word[1],word[2],gensub(/^.*rank = |. Info text.*$/,"","g",line))
					#with the above line, the reason was missing
					line=sprintf("%s %s INFO  Node manual restart, reason: %s. Restart rank = %s. Info text =",word[1],word[2],gensub(/^.* Reason: |. Restart rank.*$/,"","g",line),gensub(/^.*rank = |. Info text.*$/,"","g",line))
					#print "newLine:"line
					break
				}
				#2013-03-07 12:11:47 INFO  MP Last PIU (smn = 0, apn = 1 ) restart was caused by Mmi reset button
				else if (word[i]=="(smn" && sprintf("%02d%02d00",gensub(/,$/,"",1,word[i+2]),word[i+5])==coreMp[1])
				{
					#print "oldLine:"line
					line=sprintf("%s %s INFO  Node manual restart, reason: -. Restart rank = %s. Info text =",word[1],word[2],"MmiReset")
					#print "newLine:"line
					break
				}
			}
		}

		#comcli:2021-09-08 21:18:52 HW    OUT  ShutdownCommand  DUS3201    D16M860465   RankWarm 0: PLANNED_RECONFIGURATION Restarted by JCAT ManagedElement=1,Equipment=1,FieldReplaceableUnit=1
		#comcli:2020-12-07 10:53:08 HW    OUT  ShutdownCommand  Baseband5216 B440811833  RankCold 0: PLANNED_RECONFIGURATION 0 ManagedElement=1,Equipment=1,FieldReplaceableUnit=1
		if (comcli>0 && line ~ /HW +OUT +ShutdownCommand +(Baseband|DUS.2).* +Rank[^ ]+ +[0-9]+:/)
		{
			split(line,a," ")
			lastPiuRestartReason=gensub(/:$/,"",1,a[9])+0
		}
		#comcli:2020-11-10 06:57:38 NODE  RcsTimeChange OldTime: 2020-11-10 5:10:05 NewTime: 2020-11-10 6:57:38
		else if (comcli>0 && line ~ /NODE +RcsTimeChange OldTime: .* NewTime: / && nodeR["delta"]=="")
		{
			split(line,a," ")
			nodeR["delta"]=make_timestamp(a[6],a[7]) - make_timestamp(a[9],a[10])
			#print nodeR["delta"],nodeR["start"],nodeR["cpp"],nodeR["tn"]
			if (nodeR["delta"]<0)
			{
				if ("cpp"  in nodeR && nodeR["cpp"] >0) nodeR["cpp"] -=nodeR["delta"]
				if ("tn"   in nodeR && nodeR["tn"]  >0) nodeR["tn"]  -=nodeR["delta"]
				if ("app"  in nodeR && nodeR["app"] >0) nodeR["app"] -=nodeR["delta"]
				if ("lrat" in nodeR && nodeR["lrat"]>0) nodeR["lrat"]-=nodeR["delta"]
				if ("wrat" in nodeR && nodeR["wrat"]>0) nodeR["wrat"]-=nodeR["delta"]
				if ("nrat" in nodeR && nodeR["nrat"]>0) nodeR["nrat"]-=nodeR["delta"]
				if ("grat" in nodeR && nodeR["grat"]>0) nodeR["grat"]-=nodeR["delta"]
			}
		}

		if ((line ~ /Node restart order received. |Node [^ ]+ restart, reason:|CRIT +Node down|CRIT +Node restart due to |NODE +OUT +UnOperational *([-:0-9 ]+)?|NODE +OUT +ShutdownCommand/)||\
		    (comcli>0 && line ~ /NODE +OUT +UnOperational/)) #|INFO +Node starting
		{
			#Only select the lines like:
			# - NODE  OUT  UnOperational    2014-05-31 06:34:02
			# - NODE  OUT  UnOperational
			#but not:
			# - NODE  OUT  UnOperational    ColdWTest

			#if there is a PgGrp Restart or Node Partial outage ongoing then we save it
			if (pgR["start"]!="")
			{
				for (tmprat in ratList)
				{
					if (pgR["start",tmprat]=="") continue
					outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",pgR["start",tmprat],sprintf("PgmGrpRestart %s%s",tmprat,pgR["reason",tmprat]),pgR["UP",tmprat],currentDate-pgR["start",tmprat])
				}
				delete pgR
			}
			else if (nopR["start"]!="")
			{
				outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",nopR["start"],"NodePartial "nopR["what"] tRat,"",currentDate-nopR["start"])
				delete nopR
			}



			#if there is a LTE partial outage ongoing then we save it
			if ("start" in partialR && currentDate > partialR["start"] &&\
			 (!(mystrftime("%Y",partialR["start"]) < 2000 && mystrftime("%Y",currentDate) > 2000)))
			{
				partialR["downtime"]=currentDate-partialR["start"]
				summary["Partial","totaldowntime"]+=partialR["downtime"]
				summary["Partial","nr"]++
				partialR["text"]="Partial" partialR["percent"] partialR["cell"] gensub(/\)$/,"",1,partialR["cause"]) partialR["tcause"] ")"
				summary["Partial","downtime"]+=partialR["downtime"]   #*partialR["percent"]/100 --> no percentage for eNodeB
				outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",partialR["start"],partialR["text"],"",partialR["downtime"])
				delete partialR
			}
			#if there is a SmartUpgrade outage ongoing then we save it
			if ("start" in swR && currentDate > swR["start"] && (!(mystrftime("%Y",swR["start"]) < 2000 && mystrftime("%Y",currentDate) > 2000)))
			{
				outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",swR["start"],"UpgradeFru","",currentDate-swR["start"])
				delete swR
			}

			#We don't use Active CIM ready because it is not always occurring because of node restart?
			#We don't use Cls_evlogd_proc restart because it can appear several times in the same node restart
			#We dont use "INFO Node Starting" anymore because it causes an extra spontaneous restart entry if happening before NODE IN Operational
			if (inrestart==0 || line ~ /Node restart order received. |Node [^ ]+ restart, reason:|CRIT +Node restart due to |NODE +OUT +ShutdownCommand/)
			{
				save_noderestart_entry()
				if (mosdebug==1) print ">>>>>> START:"line
				inrestart=1
				inAppRestart=1
				nodeop=nodecv=0
				nodeR["start"]=currentDate
				#if (line ~ /INFO +Node starting/)
				#{
				#	nodeR["start"]-=10 #add 10 seconds if the node restart start point was taken from Node starting as this comes 10 seconds after the beginning of the restart
				#	nodeR["NodeStarting"]=1  #indicates that the beginning of the restart was logged by the line "NodeStarting", which means it is not very reliable
				#}
			}
			if (nodeR["NodeStarting"]==1 && line !~ /INFO +Node starting/)
			{
				#we have encountered a line that usually is the first for a node restart and is not the line "Node starting" and the current restart was started with Node starting
				#==> we generate a new restart entry
				save_noderestart_entry()
				if (mosdebug==1) print ">>>>>> START:"line
				inrestart=1
				inAppRestart=1
				nodeop=nodecv=0
				nodeR["start"]=currentDate
			}
			#Correction: the start time of the restart must be when the line NODE OUT Unoperational <date> <time> is written and also must be the first occurrence of this line
			if (comcli>0 && line ~ /NODE +OUT +UnOperational *([-:0-9 ]+)/)
			{
				if (nodeR["startFound"]!=1) nodeR["start"]=currentDate
				nodeR["startFound"]=1
			}

			#Find out the rank and reason in case of spontaneous, eg:
			#NODE  OUT  UnOperational    RankCold ProgramErrEscalated
			#NODE  OUT  UnOperational    RankCold 2021-04-07 13:23:55 Requested: RankCold OperatorInitiated Cold Performed: RankCold Other PowerReset
			#NODE  OUT  UnOperational    RankCold 2021-08-21 04:26:35 Requested: RankCold SystemInitiated Cold Performed: RankCold SystemInitiated Cold
			if (comcli>0 && line ~ /NODE +OUT +UnOperational +Rank[^ ]+/)
			{
				zz=split(line,a," ")
				if (nodeR["spontaneousRank"]=="") nodeR["spontaneousRank"]=gensub(/^Rank/,"",1,a[6])
				#if (a[7]~/^[A-Za-z]+$/) nodeR["spontaneousCause"]="("a[7]")"
				if (zz>=7 && a[zz]~/^[A-Z][A-Za-z]+$/)
				{
					xx=""
					if (a[zz-1]~/^(Operator|System|Other)/) xx=gensub(/Initiated/,"",1,a[zz-1])":"
					if (a[zz]!~/^(Rank|Warm|Cold)/) 
					{
						nodeR["spontaneousCause"]="("xx a[zz]")"
						#this first cause is kept in memory and will be used later when we reach the second "NODE OUT Unoperational" line
						#It corresponds to a line like: NODE  OUT  UnOperational    RankCold ProgramErrEscalated
						#Then follewed by a line like : NODE  OUT  UnOperational    RankCold 2021-08-21 04:26:35 Requested: RankCold SystemInitiated Cold Performed: RankCold SystemInitiated Cold
						#We want to concatenate the both causes, eg: System:ProgramErrEscalated
						if (zz==7) nodeR["spontaneousReason"]=a[zz] 
					}
					else if (xx!="") nodeR["spontaneousCause"]="("gensub(/:$/,"",1,xx nodeR["spontaneousReason"])")"
					#old format was only showing Performed, eg:
					#NODE  OUT  UnOperational    RankCold RcsNodeDown 2021-04-07 13:42:22 RankCold OperatorInitiated Cold
					#nodeR["extraInfo"]=(a[zz-2]~/^Rank/?a[zz-2]" ":"") a[zz-1]" "a[zz]
					#New format:
					#NODE  OUT  UnOperational    RankCold RcsNodeDown 2021-04-07 13:23:55 Requested: RankCold OperatorInitiated Cold Performed: RankCold Other PowerReset
					if (line~/ Requested: /) nodeR["extraInfo"]=gensub(/^.*Requested:/,"Requested:",1,line)
				}
			}

			if (!("type" in nodeR))
			{
				if (line ~ /Node restart order received. |Node manual restart, reason:/)
				{
					#2006-03-21 11:29:01 INFO  Node restart order received. Restart rank = cold. Info text =
					#2009-10-20 18:03:40 INFO  Node manual restart, reason: planned reconfiguration. Restart rank = cold with HW test. Info text =
					#2009-10-20 18:03:40 INFO  Node manual restart, reason: upgrade problems. Restart rank = warm. Info text = eanzmagn
					nodeR["type"]="Manual" capfirst(gensub(/ /,"","g",gensub(/^.*rank = *|. Info text.*$/,"","g",line)))
					if (tolower(nodeR["type"]) ~ /cold.*test/) nodeR["type"]="ManualColdWtest"  #to save space
					#print "line="line
					if (line ~ /, reason: .*Restart rank/) nodeR["type"]=nodeR["type"]"("reasonCode[gensub(/^.*, reason: |\. Restart rank.*$/,"","g",line)]")"
					#print "code="gensub(/^.*, reason: |\. Restart rank.*$/,"","g",line),reasonCode[gensub(/^.*, reason: |\. Restart rank.*$/,"","g",line)]
				}
				else if (line ~ /Node upgrade restart, reason: /)
				{
					#2009-10-20 18:03:40 INFO  Node upgrade restart, reason: upgrade failure. Restart rank = warm. Info text =
					#2009-10-20 18:03:40 INFO  Node upgrade restart, reason: normal upgrade. Restart rank = warm. Info text =
					#2009-10-20 18:03:40 INFO  Node upgrade restart, reason: upgrade cancelled. Restart rank = warm. Info text =
					#2009-10-25 23:47:37 INFO  Node upgrade restart, reason: upgrade restore. Restart rank = warm. Info text =
					nodeR["type"]="Upgrade" capfirst(gensub(/ |upgrade/,"","g",gensub(/^.*, reason: |. Restart rank =.*$/,"","g",line)))
				}
				else if (line ~ /CRIT +Node restart due to /)
				{
					#CRIT Node restart due to PIU error during upgrade
					#CRIT Node restart due to PIU group escalation
					#CRIT Node restart due to program error during upgrade
					#CRIT Node restart due to upgrade timeout
					tmpreason=gensub(/^.*Node restart due to | *$/,"","g",line)
					if (tmpreason=="PIU error during upgrade") tmpreason="PiuErrAtUpgr"
					else if (tmpreason=="PIU group escalation") tmpreason="PiuGrpEscal"
					else if (tmpreason=="program error during upgrade") tmpreason="ProgErrAtUpgr"
					else if (tmpreason=="upgrade timeout") tmpreason="UpgrTimeout"
					nodeR["type"]="Spontaneous("tmpreason")"
				}
				else if (line ~ /NODE +OUT +ShutdownCommand/)
				{
					#NODE  OUT  ShutdownCommand  RankColdWTest ManualReconfiguration yc
					#NODE  OUT  ShutdownCommand  RankCold ManualReconfiguration karakose
					#NODE  OUT  ShutdownCommand  RankWarm UpgradeNormal
					#NODE  OUT  ShutdownCommand  RankColdWTest UpgradeNormal Node restart ordered by AutoConfiguration.
					#comcli: NODE  OUT  ShutdownCommand  RankCold ExtRestartRequest
					#comcli: NODE  OUT  ShutdownCommand  RankCold ClockUpdateExceededMaxDiff
					#comcli: NODE  OUT  ShutdownCommand  RankCold DataRestore
					#comcli: NODE  OUT  ShutdownCommand  RankCold ExtRestartRequest
					#comcli: NODE  OUT  ShutdownCommand  RankCold ManualCOLI
					#comcli: NODE  OUT  ShutdownCommand  RankCold UpgradeNormal
					#comcli: NODE  OUT  ShutdownCommand  RankCold UpgradeTimeout
					#comcli: NODE  OUT  ShutdownCommand  RankColdWTest ExtRestartRequest
					#comcli: NODE  OUT  ShutdownCommand  RankWarm ExtRestartRequest
					z=split(line,a," ")
					if (a[7] ~ /^Upgrade/) nodeR["type"]=a[7]
					else if (a[6] ~ /^Rank/)
					{
						theRestartReason=""
						if (comcli==0) theRestartReason="("reasonCode[a[7]]")"
						else if (comcli>0)
						{
							if (lastPiuRestartReason!="") theRestartReason="("lastPiuRestartReason")"
							else if (a[z]!~/^Rank/) theRestartReason="("a[z]")"
						}
						nodeR["type"]="Manual"gensub(/^Rank/,"",1,a[6]) theRestartReason #(comcli==0?"("reasonCode[a[7]]")":(a[z]!~/^Rank/?"("a[z]")":""))
					}
					else nodeR["type"]="Manual"
					lastPiuRestartReason=""
				}
			}
		}
		else if ((comcli==0 && line ~ /RNC Node Restart Completed|Cell .* enabled|First VMGw Enabled|VMGWs Unlocked|SERV +IN +Operational +(NBIOT)?CELL|NODE +IN +Operational +RestartCompleted|RBS Traffic Application Ready|Ready to Establish RNC-RBS Control Link/)||\
		         (comcli>0  && line ~ /NODE +IN +Operational +(.rat |GNBDU )?RestartCompleted/))
		{
			inAppRestart=0
			if (!("app" in nodeR)) nodeR["app"]=currentDate
			if (line ~ /NODE +IN +Operational +(.rat |GNBDU )?RestartCompleted/)
			{
				#RestartCompleted NR Cell
				#Lrat RestartCompleted
				     if (line ~ /Lrat RestartCompleted/ && nodeR["lrat"]=="") nodeR["lrat"]=currentDate
				else if (line ~ /Wrat RestartCompleted/ && nodeR["wrat"]=="") nodeR["wrat"]=currentDate
				else if (line ~ /RestartCompleted NR/   && nodeR["nrat"]=="") nodeR["nrat"]=currentDate
				else if (line ~ /Grat RestartCompleted/ && nodeR["grat"]=="") nodeR["grat"]=currentDate
				#capture the info at the end of the RestartCompleted line, eg:
				# NR Cell is Ready for Service   - NR Cell is Not Ready for Service
				# LRAT Traffic Control active    - LRAT configuration not completed
				match(line,/([A-Z][a-zA-Z]+) RestartCompleted/,arrat)
				nodeR["extraInfo2"]=nodeR["extraInfo2"] ", " arrat[1] " "gensub(/^.*RestartCompleted */,"",1,line)
				sub(/^, +/,"",nodeR["extraInfo2"])
			}
		}
		else if (comcli>0 && line ~ /NODE +IN +Operational +Tn RestartCompleted/)
		{
			nodeR["tn"]=currentDate
		}
		else if (line ~ /JVM Load Module is now operational|The Configuration Service is up and running/)
		{
			if (!("jvm" in nodeR))
			{
				nodeR["jvm"]=currentDate
				if ("start" in nodeR) jvmLine[line]=1  #the line has already been used as part of a node restart
			}
			insystemupgrade=0
		}
		else if (inAppRestart==1 && (currentDate-nodeR["start"])>200000) inAppRestart=0  #the node restart has been ongoing for more than 2 days, give up waiting on the application restart completed

		if (comcli>0 && line ~ /OTHR +NodeRestarted .*UP=/)  #need to catch the line here as well because sometimes it is not caught when instart!=1
		{
			nodeR["cv"]=gensub(/^.* UP=| *$/,"","g",line)
			if (nodeR["cv"] ~ /^[^_]+_[0-9]+-/)
			{
				sub(/_/,"/",nodeR["cv"])
				sub(/-/,"_",nodeR["cv"])
			}
		}

		if (inrestart==1)
		{
			if ((comcli==0 && line ~ /INFO +Node operational|NODE +IN +Operational *$/)||\
			    (comcli>0  && line ~ /NODE +IN +Operational *(Tn RestartCompleted|ExtUpgradeRequest)? *$/))
			{
				#CPP:
				#2009-11-25 11:50:41 INFO  Node operational.
				#2009-11-25 11:50:44 NODE  IN   Operational
				#Gen2:
				#2016-07-29 17:41:56 NODE  IN   Operational
				#2016-07-28 15:31:32 NODE  IN   Operational      ExtUpgradeRequest
				#2016-07-28 15:31:41 NODE  IN   Operational      Tn RestartCompleted

				if (!("cpp" in nodeR)) 
				{
					nodeR["cpp"]=currentDate
					#in RCS, the NODE IN Operational sometimes comes at the same timestamp as NODE OUT UnOperational, resulting in RCS downtime not printed => add 0.1s
					if (comcli>0 && nodeR["cpp"]==nodeR["start"]) nodeR["cpp"]+=0.1
				}
				nodeop=1
			}
			else if ((line ~ /INFO +Configuration Version =|OTHR +NodeRestarted .*CV=.* UP=/)||
			         (comcli>0 && line ~ /OTHR +NodeRestarted .*UP=/))
			{
				#2009-11-25 11:50:44 INFO  Configuration Version = R6_LSV08_CM51_BC3024_NW0_MPC_EXP
				#2009-10-22 01:30:05 INFO  Configuration Version = SQRNC8_CXP9012995_R6EB_17_M7_02  P7.0.3 (7.0.1.11-EP2)
				#2011-12-16 13:37:33 OTHR  NodeRestarted CV=rbs_duw_cv UP=no
				#2014-09-16 23:13:23 OTHR  NodeRestarted 00000131F5 HESDIN_ST_AUSTREBERTHE 11/COH1092069 - RBS6102W CV=Fi_CXP9023291%2_R3BA09_140916_2317 UP=CXP9023291/2_R3BA09 W14.1.1.1 ()
				#comcli: 2015-11-28 12:39:24 OTHR  NodeRestarted eNb528 CXP9024418_2 R13UD Baseband UP=CXP9024418_2-R13UD
				if (!("cv" in nodeR && nodeR["cv"]!=""))
				{
					if (comcli>0)
					{
						nodeR["cv"]=gensub(/^.* UP=| *$/,"","g",line)
						if (nodeR["cv"] ~ /^[^_]+_[0-9]+-/)
						{
							sub(/_/,"/",nodeR["cv"])
							sub(/-/,"_",nodeR["cv"])
						}
					}
					else if (line ~ /INFO +Configuration Version =/) nodeR["cv"]=word[7]
					else nodeR["cv"]=gensub(/^.* CV=| UP=.*$/,"","g",line)
					nodeR["cpp2"]=currentDate #an alternative cpp uptime in case Node operational did not appear
				}
				nodecv=1
			}
			if ((nodeop==1 && nodecv==1) || \
			    ((currentDate-nodeR["start"])>1800 && mystrftime("%Y",currentDate)==mystrftime("%Y",nodeR["start"])))
			{
				#if the two lines Node operational and ConfigurationVersion have come, or
				#if the restart has been going on for more than 30 min
				#-> we are not inside the node restart anymore
				inrestart=0
				delete partialR
			}
		}
		if (inrestart==0 && inAppRestart==0)
		{
			#Partial outages RNC, only counted when outside a node restart:
			#2009-10-22 01:30:15 SERV  OUT_PARTIAL
			#2009-10-22 01:30:15 SERV  IN                    When in PartialOutOfService average was: -1 percent
			#Partial outages ERBS, only counted when outside a node restart:
			#2010-01-09 06:58:04 SERV  OUT  UnOperational    CELL 69                 Weighting factor: 0 percent, cellId disabled: 69 , Cause: System
			#2010-01-09 06:58:05 SERV  IN   Operational      CELL
			#2010-10-21 18:22:41 SERV  OUT  UnOperational    CELL 24 23 22           Weighting factor: 100 percent, Existing CellIds: 24 23 22 , Cause: Transmission
			#2010-12-14 21:44:11 SERV  OUT_PARTIAL  UnOperational    CELL 16                 Weighting factor: 33 percent, Existing CellIds: 17 16 15 , Cause: Manual

			if (line ~ /SERV +OUT_PARTIAL|SERV +OUT +UnOperational +(NBIOT)?CELL /)
			{
				#This paragraphe not applicable
				#### if ((!("start" in partialR)) || ("start" in partialR && partialR["start"]<=(currentDate+5) ))
				#1) we take the first occurrence of the partial outage
				#Or (not applicable at the moment)
				#2) if there are more entries which are within 5 seconds of the first occurrence, then we take the last one.
				#Example below, we want to take the last entry only because the previous ones are related to the last one
				#2011-01-12 20:41:19 SERV  OUT_PARTIAL  UnOperational    CELL 15                 Weighting factor: 33 percent, Existing CellIds: 17 16 15 , Cause: Transmission
				#2011-01-12 20:41:19 SERV  OUT_PARTIAL  UnOperational    CELL 16 15              Weighting factor: 66 percent, Existing CellIds: 17 16 15 , Cause: Transmission
				#2011-01-12 20:41:19 SERV  OUT  UnOperational    CELL 17 16 15           Weighting factor: 100 percent, Existing CellIds: 17 16 15 , Cause: Tran

				if (!("start" in partialR))
				{
					partialR["start"]=currentDate
					make_outageInfoTable(line,partialR)
				}
				else if ("start" in partialR && currentDate >= partialR["start"] &&\
				 (!(mystrftime("%Y",partialR["start"]) < 2000 && mystrftime("%Y",currentDate) > 2000)))
				{
					#there is already a partial outage ongoing and a new partial outage starts
					#Check the outage characteristics and compare if same as previous outage
					#if same, then ignore the entry, example:
					#2011-02-01 15:50:59 SERV  OUT  UnOperational    CELL 28 15 35           Weighting factor: 66 percent, Existing CellIds: 28 15 35 , Cause: System
					#2011-02-01 15:50:59 SERV  OUT  UnOperational    CELL 28 15 35           Weighting factor: 66 percent, Existing CellIds: 28 15 35 , Cause: Manual
					#2011-02-01 15:51:02 SERV  OUT  UnOperational    CELL 28 15 35           Weighting factor: 66 percent, Existing CellIds: 28 15 35 , Cause: System
					#2011-02-01 15:51:02 SERV  OUT  UnOperational    CELL 28 15 35           Weighting factor: 66 percent, Existing CellIds: 28 15 35 , Cause: System
					#if different but same timestamp then just update the existing outage info, example:
					#2011-01-12 20:41:19 SERV  OUT_PARTIAL  UnOperational    CELL 15                 Weighting factor: 33 percent, Existing CellIds: 17 16 15 , Cause: Transmission
					#2011-01-12 20:41:19 SERV  OUT_PARTIAL  UnOperational    CELL 16 15              Weighting factor: 66 percent, Existing CellIds: 17 16 15 , Cause: Transmission
					#2011-01-12 20:41:19 SERV  OUT  UnOperational    CELL 17 16 15           Weighting factor: 100 percent, Existing CellIds: 17 16 15 , Cause: Transmission
					#if different outage and different timestamp then save existing outage and open new one
					#2011-01-31 21:31:19 SERV  OUT_PARTIAL  UnOperational    CELL 28 15              Weighting factor: 100 percent, Existing CellIds: 28 15 35 , Cause: Transmission
					#2011-01-31 21:31:22 SERV  OUT_PARTIAL  UnOperational    CELL 15                 Weighting factor: 100 percent, Existing CellIds: 28 15 35 , Cause: Manual
					make_outageInfoTable(line,tmpOutageT)
					if (!(tmpOutageT["cause"]==partialR["cause"] && tmpOutageT["cell"]==partialR["cell"] && tmpOutageT["percent"]==partialR["percent"]))
					{
						if (currentDate==partialR["start"])
						{
							#Same outage but with updated info
							make_outageInfoTable(line,partialR)
						}
						else
						{
							#different outage, save previous outage and open new one
							partialR["downtime"]=currentDate-partialR["start"]
							summary["Partial","totaldowntime"]+=partialR["downtime"]
							summary["Partial","nr"]++
							partialR["text"]="Partial" partialR["percent"] partialR["cell"] gensub(/\)$/,"",1,partialR["cause"]) partialR["tcause"] ")"
							summary["Partial","downtime"]+=partialR["downtime"]   #*partialR["percent"]/100 --> no percentage for eNodeB
							outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",partialR["start"],partialR["text"],"",partialR["downtime"])
							delete partialR
							partialR["start"]=currentDate
							make_outageInfoTable(line,partialR)

							#Old code:
							###Check if the outage cause is different than in the previous outage
							###If different, then save previous outage and open new one
							##if (tmpOutageT["cause"]!=partialR["cause"])
							##{
							##	partialR["downtime"]=currentDate-partialR["start"]
							##	summary["Partial","totaldowntime"]+=partialR["downtime"]
							##	summary["Partial","nr"]++
							##	partialR["text"]="Partial" partialR["percent"] partialR["cell"] partialR["cause"]
							##	summary["Partial","downtime"]+=partialR["downtime"]   #*partialR["percent"]/100 --> no percentage for eNodeB
							##	outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",partialR["start"],partialR["text"],"",partialR["downtime"])
							##	delete partialR
							##	partialR["start"]=currentDate
							##	make_outageInfoTable(line,partialR)
							##}
							##else
							##{
							##	#If same outage cause, then just update the % and cell info but keep the same outage
							##	if (tmpOutageT["percent"]!=partialR["percent"])
							##	{
							##		if ((tmpOutageT["percent"]+0) > (partialR["percent"]+0)) partialR["percent"]=tmpOutageT["percent"]
							##		if (length(tmpOutageT["cell"]) > length(partialR["cell"])) partialR["cell"]=tmpOutageT["cell"]
							##	}
							##}
						}
					}
				}
				#if (line ~ / Cause: /) partialR["cause"]=" ("gensub(/^.* Cause: /,"",1,line)")"
				#if (line ~ /CELL [0-9]+/) partialR["cell"]=" Cell "gensub(/^.* CELL | +Weighting factor:.*$/,"","g",line)
				#if (line ~ /Weighting factor:/) partialR["percent"]=" "gensub(/^.*Weighting factor: | percent,.*$/,"","g",line)"%"
			}
			else if (line ~ /SERV +IN *When in PartialOutOfService average was: -?[0-9]+ percent|SERV +IN +Operational +(NBIOT)?CELL/ &&\
				 "start" in partialR && currentDate >= partialR["start"] &&\
				 (!(mystrftime("%Y",partialR["start"]) < 2000 && mystrftime("%Y",currentDate) > 2000)))
			{
				if (currentDate == partialR["start"])
				{
					#ignore partial outages of 0 seconds
					delete partialR
					continue
				}
				partialR["downtime"]=currentDate-partialR["start"]
				summary["Partial","totaldowntime"]+=partialR["downtime"]
				summary["Partial","nr"]++
				if (line ~ /PartialOutOfService average was/)
				{
					partialR["percent"]=gensub(/^.* was: |percent *$/,"",1,line)+0
					partialR["text"]=sprintf("PartialOutage: %s availability",partialR["percent"]"%")
					if (partialR["percent"] > 0) summary["Partial","downtime"]+=partialR["downtime"]*partialR["percent"]/100
				}
				else if (line ~ /CELL/)
				{
					partialR["text"]="Partial" partialR["percent"] partialR["cell"] gensub(/\)$/,"",1,partialR["cause"]) partialR["tcause"] ")"
					summary["Partial","downtime"]+=partialR["downtime"]   #*partialR["percent"]/100 --> no percentage for eNodeB
				}
				outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",partialR["start"],partialR["text"],"",partialR["downtime"])
				delete partialR
			}
			else if (line ~ /Start Action - .*(Upgrade|Install)/) insystemupgrade=1
			else if (line ~ /INFO +(Program CXC(1320784|1732844).* started|Program restart order received for CXC(1320784|1732844)|Program CXC(1320784|1732844).* external restart ordered)/)
			{
				jvmR["start"]=currentDate
				jvmR["cause"]=""
				if (insystemupgrade!=1 && line ~ /Program restart order received for CXC(1732844|1320784)|Program CXC(1320784|1732844).* external restart ordered/) jvmR["cause"]="Manual"
			}
			else if (line ~ /Current Trace properties for Upgrade Package functionality|Current properties for System Upgrade trace functionality/)
			{
				#Current Trace properties for Upgrade Package functionality: Trace property file used: /c/systemfiles/cello/cma/su/prop/Trace_01.prop Priority Level: 2 Send Logs As Notifications: 0 Output stream: File Maximum trace log file size: 2000 Include classes:  Absolute file path to trace log: /c/systemfiles/cello/cma/su/trace/Trace.log Is trace file open: true Number of trace logs before flush: 1
				#Log reason: Trace initialize. Current properties for System Upgrade trace functionality: Active classes: ConfigSupportMoSAXdh, RepertoireMO_Handler, RepertoireMO_Handler ConfigSupportMoSAXdh UpgradePackageUpgrader UpgradeCoordinator, UpgradeCoordinator, UpgradePackageUpgrader, d Active functions:  Active function classes:  Maximum trace log file size: 2000(kB)Number of trace logs before flush: 1 Trace level: 2 Output mode: 0(FILE)Send Logs As Notifications: 0(DISABLED)Trace file name: Trace.log Trace file directory path: /c/systemfiles/cello/cma/su/trace/ Type of storage: 2(FILE)
				#can use this line from Trace.log if the program started line in syslog is not there. this line comes about 30 seconds after the jvm restart
				jvmR["start2"]=currentDate
			}
			else if (jvmLine[line]!=1 && line ~ /JVM Load Module is now operational|The Configuration Service is up and running/)
			{
				#print "jvmLine: "jvmLine[line],line
				#if (jvmLine[line]==1) continue
				if ("start" in jvmR)
				{
					jvmR["downtime"]=currentDate-jvmR["start"]
				}
				else if ("start2" in jvmR)
				{
					jvmR["start"]=jvmR["start2"]-30
					jvmR["downtime"]=currentDate-jvmR["start"]
				}
				else if (nodeR["phased"]==1 && nodeR["jvmLastRestart"]!="")
				{
					#During phased restart there could be a JVM restart that started during the phased restart and ended after the phased restart
					jvmR["start"]=nodeR["jvmLastRestart"]
					jvmR["downtime"]=currentDate-nodeR["jvmLastRestart"]
				}
				else
				{
					jvmR["start"]=currentDate
					jvmR["downtime"]="?"
				}
				outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",jvmR["start"],"JvmRestart"jvmR["cause"],"",jvmR["downtime"])
				delete jvmR
				insystemupgrade=0
			}
			else if (line ~ /PGM +OUT +UnOperational +(lrat|nr|wrat|grat)PgGrp_? +(ProgramErrEscalated|UpgradeProgramGroup)/ && nopR["start"]=="")
			{
				lastw=split(line,a," ")
				tmprat=toupper(gensub(/PgGrp.*$/,"",1,a[6]))
				if (pgR["start"]=="") pgR["start"]=currentDate
				if (pgR["start",tmprat]=="")  pgR["start",tmprat]=currentDate
				if (pgR["reason",tmprat]=="") pgR["reason",tmprat]=" "a[lastw]
			}
			else if (line ~ /PGM +OUT +UnOperational +(lrat|nr|wrat|grat)PgGrp_?/ && nopR["start"]!="")
			{
				match(line,/(lrat|nr|wrat|grat)PgGrp/,a)
				if (a[1]!="") tRat=" " toupper(a[1])
			}
			else if (line ~ /NODE +OUT_PARTIAL +UnOperational/ && pgR["start"]=="")
			{
				split(line,a," ")
				if (nopR["start"]=="") nopR["start"]=currentDate
				nopR["what"]=a[6]
			}
			else if (line ~ /NODE +IN +Operational .*(RestartCompleted|dormant state)/ && pgR["start"]!="")
			{
				for (tmprat in ratList)
				{
					if (pgR["start",tmprat]=="") continue
					outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",pgR["start",tmprat],sprintf("PgmGrpRestart %s%s",tmprat,pgR["reason",tmprat]),pgR["UP",tmprat],currentDate-pgR["start",tmprat])
				}
				delete pgR
			}
			else if (line ~ /NODE +IN +Operational .*(RestartCompleted|dormant state)/ && nopR["start"]!="")
			{
				#2021-02-11 12:17:31 NODE  IN   Operational      RestartCompleted NR Cell is Ready for Service
				#2021-02-11 12:18:02 NODE  IN   Operational      Lrat RestartCompleted LRAT Traffic Control active
				#2021-03-02 11:43:20 NODE  IN   Operational      Lrat RestartCompleted LRAT configuration not completed
				#2021-03-02 11:38:53 NODE  IN   Operational      Grat GRAT in dormant state
				#2021-03-02 11:37:53 NODE  IN   Operational      Wrat RestartCompleted WRAT Traffic Control active
				tRat=""
				match(line,/ (NR|Lrat|Wrat|Grat|LRAT|WRAT|GRAT)/,a)
				if (a[1]!="") tRat=" " toupper(a[1])
				outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",nopR["start"],"NodePartial "nopR["what"] tRat,"",currentDate-nopR["start"])
				delete nopR
			}
			#2023-01-13 08:56:40 HW    OUT  UnOperational    Baseband6630 B441835541  Cat High_Temperature ManagedElement=1,Equipment=1,FieldReplaceableUnit=DU
			else if (line ~ /HW +OUT +UnOperational +.* +Cat +(High|Low)_Temperature +/)
			{
				if (line ~ /High_Temperature/) partialR["tcause"]=":HighTemp"
				else if (line ~ /Low_Temperature/) partialR["tcause"]=":LowTemp"
			}
			#2021-08-11 09:41:38 HW    OUT  ShutdownCommand  RadioGatewayR608 E23C588968  Cat Upgrade ManagedElement=1,Equipment=1,FieldReplaceableUnit=BB_RGW-1
			#2021-08-11 09:41:50 OTHR  SoftwareChanged sekiitdus00120 CXP2010174_1 P36A BASEBAND-G3 UP=CXP2010174_1-P36A
			
			#2022-11-24 10:13:41 HW    OUT  ShutdownCommand  Radio4415B2B25 CF88331666  Cat RankCold Manual: Upgrade ManagedElement=1,Equipment=1,FieldReplaceableUnit=Radio-S1-1
			#2022-11-24 10:13:56 OTHR  SoftwareChanged SELIITRBS01302 CXP2010174_1 P63A BASEBAND-G3 UP=CXP2010174_1-P63A
			
			else if (line ~ /HW +OUT +ShutdownCommand +.*Cat +(.+ )?Upgrade +.*,FieldReplaceableUnit=/)
			{
				swR["start"]=currentDate
			}
			else if (line ~ /OTHR +SoftwareChanged.*UP=/)
			{
				tUp=gensub(/^.*UP=/,"",1,line)
				sub(/ .*$/,"",tUp)
				sub(/_/,"/",tUp)
				sub(/-/,"_",tUp)
				if (swR["start"]!="")
				{
					outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",swR["start"],"UpgradeFru",tUp,currentDate-swR["start"])
					delete swR
				}
				#if the SoftwareChaned line appears during the PG restart, i.e. between UpgradeProgramGroup and RestartCompleted
				else if (pgR["start"]!="") 
				{
					for (tmprat in ratList)
					{
						if (pgR["start",tmprat]=="") continue
						#if (pgR["reason",tmprat]~"UpgradeProgramGroup") pgR["UP",tmprat]=tUp
						pgR["UP",tmprat]=tUp  #always show the UP
					}
				}
				#if the SoftwareChaned line appears after the PG restart, i.e. after RestartCompleted
				else if (outageList[outageCount]~/;PgmGrpRestart.*UpgradeProgramGroup;/) sub(/ UpgradeProgramGroup;;/," UpgradeProgramGroup;"tUp";",outageList[outageCount])
				

				#Handle case were we have:
				#2022-11-24 10:12:43 PGM   OUT  UnOperational    nrPgGrp_                UpgradeProgramGroup
				#2022-11-24 10:12:54 PGM   IN   Starting         nrPgGrp_
				#2022-11-24 10:13:10 OTHR  SoftwareChanged SELIITRBS01296 CXP9024418_15 P68A BASEBAND UP=CXP9024418_15-P68A
				
				#instead of:
				#2022-04-05 09:37:48 PGM   OUT  UnOperational    lratPgGrp_              UpgradeProgramGroup
				#2022-04-05 09:37:58 PGM   IN   Starting         CXC2013434_1_R10A18
				#2022-04-05 09:37:58 PGM   IN   Starting         CXC2013435_1_R10A10
				#2022-04-05 09:37:58 PGM   IN   Starting         CXC2013494_1_e1d8bbb
				#2022-04-05 09:38:07 NODE  IN   Operational      Lrat RestartCompleted LRAT Traffic Control active
				
				if (pgR["start"]!="")
				{
					for (tmprat in ratList)
					{
						if (pgR["start",tmprat]=="") continue
						outageList[++outageCount]=sprintf("%s;%s;%s;%s;;",pgR["start",tmprat],sprintf("PgmGrpRestart %s%s",tmprat,pgR["reason",tmprat]),pgR["UP",tmprat],currentDate-pgR["start",tmprat])
					}
					delete pgR
				}
			}
		}
	}
	close(file)
	#save the last node restart
	#if the node application still has not come up we use the CPP time as application up, and if CPP is not up, we use the currentDate as nodeR["app"], but only if the start of the restart was not 1970
	if (!("app" in nodeR))
	{
		if ("cpp" in nodeR && mystrftime("%Y",nodeR["cpp"])>2010) nodeR["app"]=nodeR["cpp"]
		else if (mystrftime("%Y",nodeR["start"])>2010) nodeR["cpp"]=nodeR["app"]=currentDate
		else delete nodeR
		#avoid "ghost" restart where the last node restart has the year 1970 and is not completed in time to show the correct date, eg some cases the lgv
	}
	save_noderestart_entry()
	if (csvformat==1)
	{
		if (comcli>0) customPrint("\nDate;Time;RestartType;SwVersion;SwRelease;RCSDowntime;ApplicationDowntime;TNDowntime;RATsDowntime;ExtraInfo;ExtraInfo2")
		else customPrint("\nDate;Time;RestartType;ConfigurationVersion;SwRelease;CPPDowntime;ApplicationDowntime;JVMDowntime")
	}
	else
	{
		if (comcli>0) { l1=41; l2=35 }
		else { l1=26 ; l2=40 }
		customPrint("\n===================================================================================================================================================")
		customPrint(sprintf("%-19s %-*s %-*s %-10s %-15s %-15s %-12s %s","Timestamp (UTC)",l1,"RestartType/Reason",l2,(comcli>0?"Sw":"Configuration ")"Version","SwRelease",(comcli>0?"RCS":"CPP")" Downtime","Appl. Downtime",(comcli==0?"JVM":"TN")" Downtime",(comcli>0?"RATs Downtime":"")))
		customPrint("===================================================================================================================================================")
	}
	for (i=1;i<=restartCount;i++)
	{
		last=split(restartList[i],word,";")
		if (word[7]!="")
		{
			swRel=word[8]
			swRelFull=word[7]
		}
		else if (word[3] in swReleaseTable && swReleaseTable[word[3]]!="" && word[1]>=swReleaseTable[word[3],"date"])
		{
			swRel=swReleaseTable[word[3]]
			swRelFull=swReleaseTable[word[3],"full"]
		}
		else if (word[3] in swReleaseTable2 && swReleaseTable2[word[3]]!="") swRel=swReleaseTable2[word[3]]
		else if (word[3] ~ "CXP")
		{
			swRel=up_translate(gensub(/^.*CXP/,"CXP",1,word[3]),"short")
			swRelFull=gensub(/^.*CXP/,"CXP",1,word[3])
			if (swRel=="")
			{
				split(appendCXCtranslation(word[3],"","nocolor"),arry," ")
				if (arry[2]!="") swRel=arry[2]
				swRelFull=""
			}
		}
		if (word[3]=="" && word[2] ~ /^Partial/) #Partial outage
		{
			word[3]=gensub(/^Partial(Outage: )? ?/,"",1,word[2])
			word[2]="PartialOutage"
			if (word[3]~/\([^)]+\)$/)
			{
				word[2]=word[2] gensub(/^.*\(/,"(",1,word[3])
				sub(/ *\(.*$/,"",word[3])
			}
		}
		for (j=4;j<=6;j++) if (word[j] >= 0) word[j]=convertSeconds(word[j],3)
		if (comcli>0)
		{
			if (word[9]>0) word[9]=convertSeconds(word[9],3)
			trat=""
			if (word[10]>0) trat=trat "N="word[10]"s "
			if (word[11]>0) trat=trat "L="word[11]"s "
			if (word[12]>0) trat=trat "W="word[12]"s "
			if (word[13]>0) trat=trat "G="word[13]"s "
		}
		if (csvformat==1) output=sprintf("%s;%s;%s;%s;%s;%s;%s;%s;%s;%s",mystrftime("%Y-%m-%d;%H:%M:%S",word[1]),word[2],word[3],swRelFull" ("swRel")",word[4],word[5],(comcli>0?word[9]:word[6]),trat,word[14],word[15])
		else output=sprintf("%-19s %-*s %-*s %-10s %-15s %-15s %-12s %s",mystrftime("%Y-%m-%d %H:%M:%S",word[1]),l1,word[2],l2,word[3],swRel,word[4],word[5],(comcli>0?word[9]:word[6]),trat)
		customPrint(output)
	}
	for (i in summary)
	{
		split(i,word,SUBSEP)
		if (word[2]=="downtime")
		{
			summary[word[1],"downday"]=convertSeconds(sprintf("%.0f",mDiv(summary[word[1],"downtime"],summary["days"])),3)
			summary[word[1],"downout"]=convertSeconds(sprintf("%.0f",mDiv(summary[word[1],"downtime"],summary[word[1],"nr"])),3)
			summary[i]=convertSeconds(summary[i],3)
		}
	}
	customPrint("")
	#customPrint(sprintf("%-26s:  %s days","Period covered",summary["days"]))
	#print todaysdate,summary["lastup"],lastUpTime
	if (node_address ~ /^OFFLINE/ && xToday!="") todaysdate=xToday-100000  #because in getTodayFromLogfiles we had added 100000 seconds
	if (enddate >= todaysdate) customPrint("Node uptime since last restart: "convertSeconds(todaysdate-(summary["lastup"]>0?summary["lastup"]:lastUpTime)))
	customPrint("------------------------------------------------------------------------------------------------------")
	customPrint(sprintf("%-19s  %-16s %-16s %-16s %-16s %-16s","Period="summary["days"]" days","NodeUpgrade","NodeManual","NodeSpontaneous","AllNodeRestarts","PartialOutages"))
	customPrint("------------------------------------------------------------------------------------------------------")
	customPrint(sprintf("%-19s  %-16s %-16s %-16s %-16s %-16s","Number Of outages",summary["Upgrade","nr"],summary["Manual","nr"],summary["Spontaneous","nr"],summary["All","nr"],summary["Partial","nr"]))
	customPrint(sprintf("%-19s  %-16s %-16s %-16s %-16s %-16s","Total downtime",summary["Upgrade","downtime"],summary["Manual","downtime"],summary["Spontaneous","downtime"],summary["All","downtime"],summary["Partial","downtime"]))
	customPrint(sprintf("%-19s  %-16s %-16s %-16s %-16s %-16s","Downtime per day",summary["Upgrade","downday"],summary["Manual","downday"],summary["Spontaneous","downday"],summary["All","downday"],summary["Partial","downday"]))
	customPrint(sprintf("%-19s  %-16s %-16s %-16s %-16s %-16s","Downtime per outage",summary["Upgrade","downout"],summary["Manual","downout"],summary["Spontaneous","downout"],summary["All","downout"],summary["Partial","downout"]))
}
#for the restartcollector
function show_downtime(  i,j,n,k,totalNrOfDays,totalNrOfRestarts,totalNrOfNodes,srNrOfNodes,hdNrOfNodes,nrOfSubrackList,hdList,\
totalDown,avrgeDownPerRest,avrgeDownPerDay,tlist,a,tmp_sysfile,tmp_avfile,count_matching_files)
{
	tlist[1]=1 ; tlist[2]=2 ; tname[1]="Cello" ; tname[2]="Application"
	split(parse_dates(startdate,enddate,minusdays,plusdays),array,";")
	startdate=array[1]
	enddate=array[2]
	customPrint("--------------------------------------------------------------------------------------------------------------------------------------")
	customPrint(sprintf("Report from %s to %s",mystrftime("%Y-%m-%d",startdate),mystrftime("%Y-%m-%d",enddate)))
	customPrint("--------------------------------------------------------------------------------------------------------------------------------------")
	nr_of_files=fileOps("ls "sysLogDir,fileList)
	for (i=1;i<=nr_of_files;i++) { if (fileList[i] ~ nodeFilter) totalNrOfNodes++}
	customPrint(sprintf("\n%-22s  %-30s","Total Number Of Nodes:",totalNrOfNodes))
	customPrint(sprintf("\n%s;%s;%s;%s;%s;%s;%s;%s","Node","Date","Time","Restart Type","Configuration Version","CPP downtime","Application downtime","JVM downtime"))
	for (i=1;i<=nr_of_files;i++)
	{
		if (fileList[i] ~ nodeFilter)
		{
			tmp_avfile=sprintf("%s/%s",avLogDir,fileList[i])
			tmp_sysfile=sprintf("%s/%s",sysLogDir,fileList[i])
			if (fileOps("test -s "tmp_avfile)==0 && fileOps("test -s "tmp_sysfile)==0)
			{
				calculateNodeDowntime(tmp_avfile,startdate,enddate,1,tmp_sysfile)
			}
		}
	}
	totalNrOfNodes=0
	for (node in nrOfSubracks)
	{
		totalNrOfNodes++
		srNrOfNodes[nrOfSubracks[node]]++
		hdNrOfNodes[hd[node]]++
		nrOfSubrackList[nrOfSubracks[node]]=nrOfSubracks[node]
		hdList[hd[node]]=hd[node]
	}
	for (j in hdList) if (j != "") customPrint(sprintf("%-32s  %-30s","Number Of Nodes with "j" hdd",hdNrOfNodes[j]))
	for (j in nrOfSubrackList) if (j != "") customPrint(sprintf("%-32s  %-30s","Number Of Nodes with "j" subracks",srNrOfNodes[j]))
	for (k=1;k<=2;k++)
	{
		customPrint("\n--------------------------------------------------------------------------------------------------------------------------------------")
		customPrint(sprintf("%-32s  %-21s %-20s %-20s %-20s %-20s",tname[k]" Downtime","Total","SwUpgrade","Manual","Spontaneous","Manual+Spontaneous"))
		customPrint("--------------------------------------------------------------------------------------------------------------------------------------")
		for (node in nrOfSubracks) totalNrOfDays[k]=totalNrOfDays[k]+NrOfDays[node,k]+0
		customPrint(sprintf("%-32s  %s","Number Of Days",totalNrOfDays[k]))
		if (totalNrOfDays[k]==0) totalNrOfDays[k]=1 #avoid division by 0
		for (a=1;a<=5;a++)
		{
			for (node in nrOfSubracks)
			{
				totalNrOfRestarts[k,a]=totalNrOfRestarts[k,a]+NrOfRestarts[node,k,a]+0
				totalDown[k,a]=totalDown[k,a]+WholeDowntime[node,k,a]+0
			}
		}
		customPrint(sprintf("%-32s  %-21s %-20s %-20s %-20s %-20s","Number Of Node Restarts",totalNrOfRestarts[k,1],totalNrOfRestarts[k,2],totalNrOfRestarts[k,3],totalNrOfRestarts[k,4],totalNrOfRestarts[k,5]))
		for (a=1;a<=5;a++)
		{
			if (totalNrOfRestarts[k,a]==0) totalNrOfRestarts[k,a]=1 #avoid division by 0
			#if (minNodeDowntime[k,a]==1E8) minNodeDowntime[k,a]=0  #for cases where there isnt a min dowtime
			avrgeDownPerNode[k,a]=totalDown[k,a]/totalNrOfNodes
			avrgeDownPerRest[k,a]=totalDown[k,a]/totalNrOfRestarts[k,a]+0
			avrgeDownPerDay[k,a]=totalDown[k,a]/totalNrOfDays[k]+0
		}
		customPrint(sprintf("%-32s  %-21s %-20s %-20s %-20s %-20s","Total Downtime forWholePeriod",convertSeconds(totalDown[k,1],1),convertSeconds(totalDown[k,2],1),convertSeconds(totalDown[k,3],1),convertSeconds(totalDown[k,4],1),convertSeconds(totalDown[k,5],1)))
		customPrint(sprintf("%-32s  %-21s %-20s %-20s %-20s %-20s","Avrge Downtime perDay",convertSeconds(avrgeDownPerDay[k,1],1),convertSeconds(avrgeDownPerDay[k,2],1),convertSeconds(avrgeDownPerDay[k,3],1),convertSeconds(avrgeDownPerDay[k,4],1),convertSeconds(avrgeDownPerDay[k,5],1)))
		customPrint(sprintf("%-32s  %-21s %-20s %-20s %-20s %-20s","Avrge Downtime perNode",convertSeconds(avrgeDownPerNode[k,1],1),convertSeconds(avrgeDownPerNode[k,2],1),convertSeconds(avrgeDownPerNode[k,3],1),convertSeconds(avrgeDownPerNode[k,4],1),convertSeconds(avrgeDownPerNode[k,5],1)))
		customPrint(sprintf("%-32s  %-21s %-20s %-20s %-20s %-20s","Avrge Downtime perNodeRestart",convertSeconds(avrgeDownPerRest[k,1],1),convertSeconds(avrgeDownPerRest[k,2],1),convertSeconds(avrgeDownPerRest[k,3],1),convertSeconds(avrgeDownPerRest[k,4],1),convertSeconds(avrgeDownPerRest[k,5],1)))
		customPrint(sprintf("%-32s  %-21s %-20s %-20s %-20s %-20s","Max Dntme forWholePeriod for1Nod",convertSeconds(maxWholeDowntime[k,1],1),convertSeconds(maxWholeDowntime[k,2],1),convertSeconds(maxWholeDowntime[k,3],1),convertSeconds(maxWholeDowntime[k,4],1),convertSeconds(maxWholeDowntime[k,5],1)))
		customPrint(sprintf("%-32s  %-21s %-20s %-20s %-20s %-20s","Max Dntme for1Restart for1Nod",convertSeconds(maxNodeDowntimeGlobal[k,1],1),convertSeconds(maxNodeDowntimeGlobal[k,2],1),convertSeconds(maxNodeDowntimeGlobal[k,3],1),convertSeconds(maxNodeDowntimeGlobal[k,4],1),convertSeconds(maxNodeDowntimeGlobal[k,5],1)))
		#customPrint(sprintf("%-29s  %-21s %-20s %-20s %-20s %-20s","Max   Downtime perNodeRestart",convertSeconds(maxNodeDowntime[k,1],1),convertSeconds(maxNodeDowntime[k,2],1),convertSeconds(maxNodeDowntime[k,3],1),convertSeconds(maxNodeDowntime[k,4],1),convertSeconds(maxNodeDowntime[k,5],1)))
		#customPrint(sprintf("%-29s  %-21s %-20s %-20s %-20s %-20s","Min   Downtime perNodeRestart",convertSeconds(minNodeDowntime[k,1],1),convertSeconds(minNodeDowntime[k,2],1),convertSeconds(minNodeDowntime[k,3],1),convertSeconds(minNodeDowntime[k,4],1),convertSeconds(minNodeDowntime[k,5],1)))
	}
	for (node in nrOfSubracks) nodeList[node]=node
	n=asort(nodeList)
	for (k=1;k<=2;k++)
	{
		customPrint("\nNode Summary for "tname[k]" part")
		customPrint("======================================================================================================================================")
		customPrint(sprintf("%-12s  %2s  %-7s  %3s  %3s  %-13s  %-13s  %-13s  %-13s","NODE","SR","HD-DISK","NrR","NrD","TotalDown","AvrgDnPerRest","AvrgDnPerDay","MaxDnFor1Rest"))
		customPrint("======================================================================================================================================")
		for (i=1;i<=n;i++)
		{
			customPrint(sprintf("%-12s  %2s  %-7s  %3s  %3s  %-13s  %-13s  %-13s  %-13s",nodeList[i],nrOfSubracks[nodeList[i]],hd[nodeList[i]],\
NrOfRestarts[nodeList[i],k,1],NrOfDays[nodeList[i],1],convertSeconds(WholeDowntime[nodeList[i],k,1],2),convertSeconds(AvrgeDowntimePerRestart[nodeList[i],k,1],2),convertSeconds(AvrgeDowntimePerDay[nodeList[i],k,1],2),convertSeconds(maxNodeDowntimeTable[nodeList[i],k,1],2)))
		}
	}
}
function parse_upgrade_info(file,   currentDate)
{
	currentNode=gensub(/^.*\/|.log/,"","g",file)
	initialise()
	ftpserver="?"  #initialise ftpserver separately, see info in the initialise function
	fromstate=tempfromstate="?"  #initialise fromstate separately, see info in the initialise function
	while ((getline < file)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		currentDate=make_timestamp($1,$2)
		if (/IP address of FTP Server: /) ftpserver=gensub(/^.*IP address of FTP Server: |The Upgrade Control File path on the FTP Server: .*$/,"","g",$0)
		if ($NF ~ /^UP=/) tempfromstate=gensub(/^UP=/,"",1,$NF)
		if (/CV .Fi_CXP/) tempfromstate=gensub(/^.*CV .Fi_|_[0-9][0-9][0-9][0-9][0-9][0-9]_[0-2][0-9][0-9][0-9]. .*$/,"","g",$0)
		if (/Configuration Version = (Te|Fi|SU)_CXP/) tempfromstate=gensub(/^.* = (Fi|Te|SU)_|_[0-9][0-9][0-9][0-9][0-9][0-9]_[0-2][0-9][0-9][0-9].*$/,"","g",$0)
		if (inupgrade==0) fromstate=tempfromstate
		if (!(currentDate >= startdate && (currentDate <= enddate || enddate == ""))) continue
		if (/Start Action - ((Reboot Node )*Upgrade|(Non Blocking )*(Forced )*Install)/)
		{
			dump_uprecord()  #we dump here to catch failure cases
			if (/Upgrade/)
			{
				what="upgrade" ; type="soft"
				inupgrade=1
				startDate=$1 ; startTime=$2 ; startdatetime=gensub(/-/,"","g",$1)"_"gensub(/:/,"","g",$2)
			}
			if (/Reboot/) type="hard"
			if (/Install/)
			{
				what="install" ; type="blocking"
				ininstall=1
				startDate=$1 ; startTime=$2 ; startdatetime=gensub(/-/,"","g",$1)"_"gensub(/:/,"","g",$2)
			}
			if (/Blocking/) type="nonblocking"
			if (/Product number:/)
			{
				#2006-03-16 15:19:06 UP    Start Action - Reboot Node Upgrade Product number: CXP9011610/1 Product revision: R2E/1
				#2006-02-28 14:10:44 UP    Start Action - Reboot Node Upgrade Product number: CXP9010809/1 Revision: R12K
				for (i=1;i<=NF;i++) if ($i=="number:") upid=$(i+1)"_"$NF
			}
		}
		else if (inupgrade==1)
		{
			if (upid=="" && /.R[ob]_.* has been created/)
			{
				upid=gensub(/^.*R[ob]_|_[0-9]+_[0-9]+. has been created.*$/,"","g",$0)
				#gsub(/%/,"/",upid)
			}
			else if (/ConfigVersionCreated .* CV=R[ob]_.* UP=/)
			{
				fromstate=gensub(/^.* UP=/,"",1,$0)
			}
			else if (/Sending AVC Event - progressHeader:/) progressTable[++progcount]=gensub(/^.*progressHeader: */,"","g",$0)
			#else if (/Sending AVC Event - state:/) stateTable[++statecount]=gensub(/^.*state: */,"","g",$0)  #Not Needed
			else if (/Execution of step label.*starting/) currentStep=gensub(/^.*label .|. is .*$/,"","g",$0)
			else if (/Request for Node Restart/)
			{
				uprestartrequest=1
				found_uprestartrequest=1
				#to cope for cases when the "request for node restart" happens at same time as "node restart order received" but is found underneath it in logfile
				if (currentDate==startdown) upNrOfManRestarts--
			}
			else if (/CRIT.*Node down|Cls_evlogd_proc restart|Node restart order received|Node manual restart/)
			{
				if (/Node restart order received|Node manual restart/ && uprestartrequest != 1) upNrOfManRestarts++
				else if (/Cls_evlogd_proc restart/) { upNrOfRestarts++ ; uprestartrequest=0 }
				if (nodehasbeendown==0)
				{
					startdown=currentDate
					nodehasbeendown=1
					waitingforapplication=1
				}
			}
			else if (/Node operational|NODE  IN   Operational *$/ && nodehasbeendown==1)
			{
				updowntime=updowntime+currentDate-startdown
				nodehasbeendown=0
			}
			else if (/RNC Node Restart Completed|Cell .* enabled|First VMGw Enabled|VMGWs Unlocked|IN +Operational +(NBIOT)?CELL/ && waitingforapplication==1)
			{
				upappdowntime=upappdowntime+currentDate-startdown
				waitingforapplication=0
			}
			else if (/Sending AVC Event - state: Awaiting confirm/ && $1 !~ /^1970/) startwaiting=make_timestamp($1,$2)
			else if (/Start Action - Confirm Upgrade/ && startwaiting != "" && $1 !~ /^1970/) waitingtime=make_timestamp($1,$2)-startwaiting
			else if (/CV .Fi_.* has been created.|ConfigVersionCreated .* CV=Fi_.* UP=/)
			{
				#We prefer to use the Fi_ row as the end of the upgrade instead of "upgrade executed" because it says the id of the UP so we are sure we are addressing the correct UP. The time difference is only about 20 seconds.
				tmp_upid=gensub(/^.*Fi_|_[0-9]+_[0-9]+.? .*$/,"","g",$0)
				if (tmp_upid==upid || gensub(/%/,"/","g",tmp_upid)==upid)
				{
					endDate=$1 ; endTime=$2 ; enddatetime=gensub(/-/,"","g",$1)"_"gensub(/:/,"","g",$2)
					upgraderesult=1
					if ((endDate ~ /^1970/ && startDate !~ /^1970/) || (startDate ~ /^1970/ && endDate !~ /^1970/)) upgradetime="??"
					else upgradetime=make_timestamp(endDate,endTime)-make_timestamp(startDate,startTime)-waitingtime
				}
				dump_uprecord()
			}
			#We don't use this line to finish because it doesn't say to which UP it belongs.
			#else if (/UP *(UpgradePackageMoImpl: )*Upgrade executed./ && upgraderesult != 1) { upgraderesult=1 ; upgradetime=make_timestamp($1,$2)-make_timestamp(startDate,startTime) ; dump_uprecord() }
		}
		else if (ininstall==1)
		{
			if (/Sending AVC Event - .*rogressCount(er)*:/)
			{
				tempProgress=gensub(/^.*: */,"","g",$0)+0
				if (tempProgress != 0) currentProgress=tempProgress
			}
			else if (/Sending AVC Event - .*rogressTotal:/)
			{
				tempTotal=gensub(/^.*: */,"","g",$0)+0
				if (tempTotal != 0) progressTotal=tempTotal
			}
			else if (/CV .Si_.* has been created.|ConfigVersionCreated .* CV=Si_.* UP=/)
			{
				installresult=1
				if (($1 ~ /^1970/ && startDate !~ /^1970/) || (startDate ~ /^1970/ && $1 !~ /^1970/)) installtime="??"
				else installtime=make_timestamp($1,$2)-make_timestamp(startDate,startTime)
				if (/ConfigVersionCreated .* CV=Si_.* UP=/) fromstate=gensub(/^.* UP=/,"",1,$0)
				dump_uprecord()
			}
		}
	}
	close(file)
	dump_uprecord() #we dump here to catch failure cases
}
function dump_uprecord(  output)
{
	if (inupgrade == 1 && ininstall == 1 && upid != "") print "WARNING!!! ininstall==1 && inupgrade==1. Upid="upid
	if (inupgrade == 1 && upid != "")
	{
		upResult[upid,fromstate,currentNode,startdatetime]=upgraderesult
		upList[upid]=upid
		upfromstateList[fromstate]=fromstate
		nodeList[currentNode]=currentNode
		nrOfAttempts[upid,fromstate]++
		if (upgraderesult==0) nrOfFailures[upid,fromstate]++
		else if (upgraderesult==1) nrOfSuccess[upid,fromstate]++
		nodeUPList[upid,fromstate,currentNode]=1
		if (upgraderesult==0)
		{
			if (tolower(progressTable[progcount]) !~ /idle|execution failed/) currentProgress=progressTable[progcount]
			else if (tolower(progressTable[progcount-1]) !~ /idle|execution failed/) currentProgress=progressTable[progcount-1]
			else currentProgress=progressTable[progcount-2]
			upFailureInfoCount[upid,fromstate,sprintf("%-25s  %-30s",currentProgress,currentStep)]++
			upFailureNodeList[upid,fromstate,sprintf("%-25s  %-30s",currentProgress,currentStep),currentNode]=1
			upFailureInfoList[sprintf("%-25s  %-30s",currentProgress,currentStep)]=1
		}
		else
		{
			iterator=0
			while (1)
			{
				#to cope for upgrades that took the same time
				iterator++
				if (upgradetime in upgradeTimeList && iterator<100) { upgradetime+=rand() ; upgradetime-=rand() }
				else break
			}
			upgradeTimeList[upgradetime]=1
			upgradeTotalTime[upid,fromstate]=upgradeTotalTime[upid,fromstate]+upgradetime
			waitingTotalTime[upid,fromstate]=waitingTotalTime[upid,fromstate]+waitingtime
			upgradeTime[upid,fromstate,upNrOfRestarts,currentNode,waitingtime,startdatetime]=upgradetime
			if (found_uprestartrequest != 1) upNrOfManRestarts=999
			rev_upgradeTime[upgradetime]=sprintf("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",upid,fromstate,currentNode,startdatetime,enddatetime,upNrOfRestarts,upNrOfManRestarts,updowntime,upgradetime,waitingtime,upappdowntime)
			upNrOfRestartsTable[upNrOfRestarts]=1
		}
		#Date;Time;Node;Upgrade/Install;Result;To;From;NrOfRestarts;DownTime;UpgradeTime;ConfirmTime;LastProgressHeader;LastStepExecuting;InstallTime;NrOfFilesDownloaded;TotalNrOfFiles;FtpServer;AppDownTime
		#2006-03-30;11:50:06;rnc78;U;OK;CXP9012014_R8B01;CXP9012014_R8A01;1 (0M);33s;721s;330s;;;;;;
		#2006-03-30;13:45:12;rbs10;U;FAIL;CXP9012011_R8K/2;CXP9012011_R7AK/B3;;;;;The node is to be restarted;ACAJ_TO_ACLSV21_NodeUpgrade;;;;
		output=sprintf("%s;%s;%s;U;%s;%s;%s",startDate,startTime,currentNode,resTable[upgraderesult],upid,fromstate)
		if (upgraderesult==1) output=sprintf("%s;%s;%ss;%s;%ss;;;;;;;%s",output,(upNrOfManRestarts==999 ? upNrOfRestarts : upNrOfRestarts" ("upNrOfManRestarts"M)"),updowntime+0,(upgradetime=="??" ? "??" : upgradetime+0"s"),waitingtime+0,(updowntime>0 && upappdowntime < 1 ? "?" : upappdowntime+0"s"))
		else                  output=sprintf("%s;;;;;%s;%s;;;;",output,currentProgress,currentStep)
		customPrint(output)
	}
	else if (ininstall == 1 && upid != "")
	{
		installResult[upid,fromstate,currentNode,startdatetime]=installresult
		installUpList[upid]=upid
		installfromstateList[fromstate]=fromstate
		installNodeList[currentNode]=currentNode
		installNrOfAttempts[upid,fromstate]++
		if (installresult==0) installNrOfFailures[upid,fromstate]++
		else if (installresult==1) installNrOfSuccess[upid,fromstate]++
		installNodeUPList[upid,fromstate,currentNode]=1
		if (installresult==0)
		{
			installUpFailureInfoCount[upid,fromstate,sprintf("%s",currentProgress+0"/"progressTotal)]++
			installUpFailureNodeList[upid,fromstate,sprintf("%s",currentProgress+0"/"progressTotal),currentNode]=1
			installUpFailureInfoList[sprintf("%s",currentProgress+0"/"progressTotal)]=1
		}
		else
		{
			iterator=0
			while (1)
			{
				#to cope for installs that took the same time
				iterator++
				if (installtime in installTimeList && iterator<100) { installtime+=rand() ; installtime-=rand() }
				else break
			}
			installTimeList[installtime]=1
			installTotalTime[upid,fromstate]=installTotalTime[upid,fromstate]+installtime
			installTime[upid,fromstate,progressTotal,ftpserver,currentNode,startdatetime]=installtime
			rev_installTime[installtime]=sprintf("%s,%s,%s,%s,%s,%s",upid,fromstate,progressTotal,ftpserver,currentNode,startdatetime)
			#print upid,fromstate,currentNode,startdatetime,installtime
		}
		#Date;Time;Node;Upgrade/Install;Result;To;From;NrOfRestarts;DownTime;UpgradeTime;ConfirmTime;LastProgressHeader;LastStepExecuting;InstallTime;NrOfFilesDownloaded;TotalNrOfFiles;FtpServer;AppDownTime
		#2006-03-28;21:42:02;rbs71;I;OK;CXP9012014_R8B01;CXP9012014_R8A01;;;;;;;281s;28;28;a.b.c.d
		#2006-03-28;22:12:38;rbs59;I;FAIL;CXP9012014_R8B01;CXP9012014_R8A01;;;;;;;;0;28;a.b.c.d
		output=sprintf("%s;%s;%s;I;%s;%s;%s",startDate,startTime,currentNode,resTable[installresult],upid,fromstate)
		if (installresult==1) output=sprintf("%s;;;;;;;%s;%s;%s;%s",output,(installtime == "??" ? "??" : installtime+0"s"),progressTotal,progressTotal,ftpserver)
		else                  output=sprintf("%s;;;;;;;;%s;%s;%s",output,currentProgress+0,progressTotal,ftpserver)
		customPrint(output)
	}

	initialise()
}
function up_print_results(  upname,nodename,fromstatename,failname,i,n,dest)
{
	#Success statistics
	#UP  NumberOfNodesUpgraded TotalUpgradeAttempts  UpgradeSuccess UpgradeFailures
	#
	#Failure info for UP=xxx
	#LastProgressHeader  LastStepExecuting NrOfOccurrences   Nodes

	customPrint(sprintf("\n\n%s\nUPGRADE STATISTICS\n%s\n",delimiter3,delimiter3))

	for (upname in upList)
	{
		for (fromstatename in upfromstateList)
		{
			#printf("%s %s ",upname,fromstatename)
			for (nodename in nodeList)
			{
				if (nodeUPList[upname,fromstatename,nodename]==1)
				{
					#printf("%s ",nodename)
					nr_of_nodes_upgraded[upname,fromstatename]++
				}
			}
			#print nr_of_nodes_upgraded[upname,fromstatename]
		}
	}
	customPrint(delimiter1)
	customPrint(sprintf("%-20s  %-20s  %-13s  %-15s  %-14s  %-15s  %-11s  %-11s",\
"To:","From:","NodesUpgraded","UpgradeAttempts","UpgradeSuccess","UpgradeFailures","UpgradeTime","ConfirmTime"))
	customPrint(delimiter1)
	for (upname in upList)
	{
		for (fromstatename in upfromstateList)
		{
			if (nr_of_nodes_upgraded[upname,fromstatename] > 0)
			{
				customPrint(sprintf("%-20s  %-20s  %13s  %15s  %14s  %15s  %11s  %11s",\
upname,fromstatename,nr_of_nodes_upgraded[upname,fromstatename]+0,nrOfAttempts[upname,fromstatename]+0,nrOfSuccess[upname,fromstatename]+0,nrOfFailures[upname,fromstatename]+0,(nrOfSuccess[upname,fromstatename]+0 > 0 ? convertSeconds(upgradeTotalTime[upname,fromstatename]/nrOfSuccess[upname,fromstatename],2) : 0),(nrOfSuccess[upname,fromstatename]+0 > 0 ? convertSeconds(waitingTotalTime[upname,fromstatename]/nrOfSuccess[upname,fromstatename],2) : 0)))
			}
		}
	}
	customPrint(sprintf("\n%s\nFailed Upgrades Details\n%-20s  %-20s  %-25s  %-30s  %-15s  %s\n%s",\
delimiter1,"To:","From:","LastProgressHeader","LastStepExecuting","NrOfOccurrences","Nodes",delimiter1))
	for (upname in upList)
	{
		for (fromstatename in upfromstateList)
		{
			something_printed=0
			for (failname in upFailureInfoList)
			{
				if (upFailureInfoCount[upname,fromstatename,failname] > 0)
				{
					tempnodelist=""
					for (nodename in nodeList)
					{
						if (upFailureNodeList[upname,fromstatename,failname,nodename]==1) tempnodelist=nodename" "tempnodelist
					}
					customPrint(sprintf("%-20s  %-20s  %s  %-15s  %s",upname,fromstatename,failname,upFailureInfoCount[upname,fromstatename,failname],tempnodelist))
					something_printed=1
				}
			}
			if (something_printed==1) customPrint(delimiter2)
		}
	}
	customPrint(sprintf("\n%s\nSuccessful Upgrades Details\n%-20s  %-20s  %-12s  %-15s  %-15s  %-8s  %8s  %8s  %8s\n%s",\
delimiter1,"To:","From:","Node","StartTime (UTC)","EndTime (UTC)","Restarts","Downtime","UpgrTime","ConfTime",delimiter1))
	n=asort(upgradeTime,dest)
	#upgradeTime[upid,currentNode,upNrOfRestarts,startdatetime]=upgradetime
	#rev_upgradeTime[upgradetime]=upid,fromstate,currentNode,startdatetime,enddatetime,upNrOfRestarts,upNrOfManRestarts,updowntime,upgradetime,waitingtime,upappdowntime
	#upNrOfRestartsTable[upNrOfRestarts]=1
	#for (i=1;i<=n;i++) print dest[i],rev_upgradeTime[dest[i]]
	for (upname in upList)
	{
		for (fromstatename in upfromstateList)
		{
			something_printed=0
			for (i=1;i<=n;i++)
			{
				split(rev_upgradeTime[dest[i]],array,",")
				if (upname==array[1] && fromstatename==array[2])
				{
					if (array[7] != 999) tmprestartinfo=sprintf("%s (%sM)",array[6],array[7]) ; else tmprestartinfo=array[6]
					customPrint(sprintf("%-20s  %-20s  %-12s  %-15s  %-15s  %-8s  %8s  %8s  %8s",upname,array[2],array[3],array[4],array[5],tmprestartinfo,convertSeconds(array[8],2),convertSeconds(array[9],2),convertSeconds(array[10],2)))
					something_printed=1
				}
			}
			if (something_printed==1) customPrint(delimiter2)
		}
	}
}
function install_print_results(  upname,nodename,failname,i,n,dest)
{
	#Success statistics
	#UP  NumberOfNodesInstalled TotalInstallAttempts  InstallSuccess InstallFailures
	#
	#Failure info for UP=xxx
	#LastProgressHeader  LastStepExecuting NrOfOccurrences   Nodes

	customPrint(sprintf("\n\n%s\nINSTALL STATISTICS\n%s\n",delimiter3,delimiter3))

	for (upname in installUpList)
	{
		#printf upname
		for (fromstatename in installfromstateList)
		{
			#printf " "fromstatename
			for (nodename in installNodeList)
			{
				if (installNodeUPList[upname,fromstatename,nodename]==1)
				{
					#printf " "nodename
					nr_of_nodes_installed[upname,fromstatename]++
				}
			}
			#print ""
			#print upname,fromstatename,nr_of_nodes_installed[upname,fromstatename]
		}
	}
	customPrint(delimiter1)
	customPrint(sprintf("%-20s  %-20s  %-14s  %-15s  %-14s  %-15s  %-11s",\
"To:","From:","NodesInstalled","InstallAttempts","InstallSuccess","InstallFailures","InstallTime"))
	customPrint(delimiter1)
	for (upname in installUpList)
	{
		for (fromstatename in installfromstateList)
		{
			if (nr_of_nodes_installed[upname,fromstatename] > 0)
			{
				customPrint(sprintf("%-20s  %-20s  %14s  %15s  %14s  %15s  %11s",\
upname,fromstatename,nr_of_nodes_installed[upname,fromstatename]+0,installNrOfAttempts[upname,fromstatename]+0,installNrOfSuccess[upname,fromstatename]+0,installNrOfFailures[upname,fromstatename]+0,convertSeconds((installNrOfSuccess[upname,fromstatename]+0 > 0 ? installTotalTime[upname,fromstatename]/installNrOfSuccess[upname,fromstatename] : 0),2)))
			}
		}
	}
	customPrint(sprintf("\n%s\nFailed Installs Details\n%-20s  %-20s  %-25s  %-15s  %s\n%s",delimiter1,"To:","From:","NrOfFilesDownloaded/Total","NrOfOccurrences","Nodes",delimiter1))
	for (upname in installUpList)
	{
		for (fromstatename in installfromstateList)
		{
			something_printed=0
			for (failname in installUpFailureInfoList)
			{
				#print failname
				if (installUpFailureInfoCount[upname,fromstatename,failname] > 0)
				{
					tempnodelist=""
					for (nodename in installNodeList)
					{
						if (installUpFailureNodeList[upname,fromstatename,failname,nodename]==1) tempnodelist=nodename" "tempnodelist
					}
					customPrint(sprintf("%-20s  %-20s  %25s  %15s  %s",upname,fromstatename,failname,installUpFailureInfoCount[upname,fromstatename,failname],tempnodelist))
					something_printed=1
				}
			}
			if (something_printed==1) customPrint(delimiter2)
		}
	}
	customPrint(sprintf("\n%s\nSuccessful Installs Details\n%-20s  %-20s  %-9s  %-15s  %-20s  %12s\n%s",\
delimiter1,"To:","From:","NrOfFiles","FTP Server","Node","InstallTime",delimiter1))
	n=asort(installTime,dest)
	#upgradeTime[upid,currentNode,upNrOfRestarts,startdatetime]=upgradetime
	#upNrOfRestartsTable[upNrOfRestarts]=1
	#for (i=1;i<=n;i++) print dest[i],rev_upgradeTime[dest[i]]
	for (upname in installUpList)
	{
		for (fromstatename in installfromstateList)
		{
			something_printed=0
			for (i=1;i<=n;i++)
			{
				split(rev_installTime[dest[i]],array,",")
				if (upname==array[1] && fromstatename==array[2])
				{
					customPrint(sprintf("%-20s  %-20s  %-9s  %-15s  %-20s  %12s",upname,array[2],array[3],array[4],array[5],convertSeconds(dest[i],2)))
					something_printed=1
				}
			}
			if (something_printed==1) customPrint(delimiter2)
		}
	}
}
function initialise()
{
	#initialisations
	inupgrade=upgraderesult=0
	ininstall=installresult=0
	upNrOfRestarts=upNrOfManRestarts=0
	delete progressTable ; delete stateTable
	currentProgress=currentStep=startdatetime=what=type=upid=startwaiting=enddatetime=updowntime=upappdowntime=""
	startDate=startTime=endDate=endTime=startdown=""
	waitingtime=progressTotal=nodehasbeendown=uprestartrequest=found_uprestartrequest=waitingforapplication=0
	#note: do not initialise ftpserver and fromstate otherwise we dont get it at all because their line is before "start action"
}
function parse_notifications(notiftype,notiflogfile)
{
	if (notiftype ~ /^alarm/) parse_alarm_event_notifications(notiflogfile)
	else if (notiftype ~ /^csnotif/) parse_cs_notifications(notiflogfile)
}
function parse_alarm_event_notifications(notiflogfile)
{
	Define_months()
	make_alarm_severity_table()
	make_causeTable()
	while ((getline < "-")>0)
	{
		gsub("\r","");gsub("\x00","")
		if (notiflogfile != "") print $0 >> notiflogfile
		if (noprint != 1 || $1 ~ /^(org\.omg\.|at$|java\.)/) print
		if (/Successful subscription: OK/) { noprint=1 ; print "" }
		else if (/^Notification about /) what=$0
		else if (/^MANAGED_OBJECT_INSTANCE /) mo=parseMoInstance(parseValue($0))
		else if (/^EVENT_TIME /) datetime=parse_event_time(gensub(/^.* time *= */,"",1,$0))
		else if (/^(SPECIFIC_EVENT|ADDITIONAL_TEXT|SPECIFIC_PROBLEM|PROBABLE_CAUSE) /)
		{
			if (/^ADDITIONAL_TEXT /) in_add=1
			if (/^PROBABLE_CAUSE /) text[$1]=causeTable[parseValue($0)]
			else text[$1]=gensub(/^[^ ]+ = *| *$/,"","g",$0)
		}
		else if (/^ALARM_ID /) in_add=""
		else if (/^PERCEIVED_SEVERITY /) severity=$3
		else if (/^ACK_STATE /) ackstate=$3
		else if (NF==0 && what != "")
		{
			print_alarm_notification_entry()
			close(notiflogfile)
		}
		else if (NF!=0 && in_add==1) text["ADDITIONAL_TEXT"]=text["ADDITIONAL_TEXT"]" "$0
	}
	close("-")
}
function print_alarm_notification_entry()
{
	if (what ~ "new alarm") what="AL_"alarm_severity_table[severity]
	else if (what ~ "changed alarm") what="AL_CHANGE_TO_"alarm_severity_table[severity]
	else if (what ~ "ack state changed" && ackstate==2) what="AL_UNACK"
	else if (what ~ "ack state changed" && ackstate==1) what="AL_ACK"
	else if (what ~ "cleared alarm") what="AL_CLEAR"
	else if (what ~ "alarmlist rebuilt") what="ALARM_LIST_REBUILT"
	else if (what ~ "new event") what="EVENT"
	if (what=="EVENT") thistext=sprintf("%s%s",text["SPECIFIC_EVENT"],(text["ADDITIONAL_TEXT"] != "" ? ". "text["ADDITIONAL_TEXT"] : ""))
	else if (what ~ "AL_") thistext=sprintf("%s: %s %s",text["SPECIFIC_PROBLEM"],text["PROBABLE_CAUSE"],text["ADDITIONAL_TEXT"])
	print sprintf("%s %-8s %s %s",datetime,what,mo,thistext)
	what=severity=ackstate=mo=datetime=in_add=ackstate=thistext=""
	delete text
}
function parse_cs_notifications(notiflogfile)
{
	#===Notifications===
	#SequenceDeltaNotification :110120
	#Attribute: reservedBy changed.
	#DELETE:
	# >>> reservedBy = ManagedElement=1,RncFunction=1,IubLink=99
	#===================
	#===Notifications===
	#SequenceDeltaNotification :110111
	#Attribute: reservedBy changed.
	#ADD:
	# >>> reservedBy = ManagedElement=1,RncFunction=1,IubLink=99
	#===================
	#MOCreatedType no:774
	# type :IubLink name :ManagedElement=1,RncFunction=1,IubLink=99 prefix :
	#MOAVCType :775
	# type :Subrack name :ManagedElement=1,Equipment=1,Subrack=MS prefix :
	# >>> reservedBy[41] =
	# >>> reservedBy = ManagedElement=1,RncFunction=1,IubLink=Iub-18
	# >>> reservedBy = ManagedElement=1,RncFunction=1,IubLink=Iub-21
	# >>> reservedBy = ManagedElement=1,RncFunction=1,IubLink=99
	#MOAVCType :776
	# type :RncModule name :ManagedElement=1,RncFunction=1,RncModule=1 prefix :
	# >>> reservedBy[15] =
	# >>> reservedBy = ManagedElement=1,RncFunction=1,IubLink=Iub-22
	# >>> reservedBy = ManagedElement=1,RncFunction=1,IubLink=Iub-24
	# >>> reservedBy = ManagedElement=1,RncFunction=1,IubLink=Iub-10
	# >>> reservedBy = ManagedElement=1,RncFunction=1,IubLink=99
	#MOCreatedType no:777
	# type :NodeSynch name :ManagedElement=1,RncFunction=1,IubLink=99,NodeSynch=1 prefix :
	#MOAVCType :778
	# type :IubLink name :ManagedElement=1,RncFunction=1,IubLink=99 prefix :
	# >>> operationalState = 0
	#MOAVCType :779
	# type :IubLink name :ManagedElement=1,RncFunction=1,IubLink=99 prefix :
	# >>> availabilityStatus = 8
	#MOAVCType :780
	# type :NodeSynch name :ManagedElement=1,RncFunction=1,IubLink=99,NodeSynch=1 prefix :
	# >>> operationalState = 0
	#MOAVCType :781
	# type :NodeSynch name :ManagedElement=1,RncFunction=1,IubLink=99,NodeSynch=1 prefix :
	# >>> availabilityStatus = 1056
	#MOAVCType :782
	# type :NodeSynch name :ManagedElement=1,RncFunction=1,IubLink=99,NodeSynch=1 prefix :
	# >>> availabilityStatus = 1058
	#MODeletedType no:110122
	# type :NodeSynch name :ManagedElement=1,RncFunction=1,IubLink=99,NodeSynch=1 prefix :
	#MODeletedType no:110123
	# type :IubLink name :ManagedElement=1,RncFunction=1,IubLink=99 prefix :

	inattr=0
	delete excludelist
	split(csnotiflist,array,",")
	for (i in array) excludelist[tolower(array[i])]=1
	while ((getline < "-")>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if (notiflogfile != "") print $0 >> notiflogfile
		if ($1 !~ /^(===Notifications===|MO(AVC|Created|Deleted)Type|type|>>>|===================|SequenceDeltaNotification|Attribute:|ADD:|DELETE:)$/)
		{
			print
			if (/^.... Test Construction OK/) print ""
			continue
		}
		if ($1 ~ /^(MO(AVC|Deleted|Created)Type|SequenceDeltaNotification|===================)$/)
		{
			inattr=0
			if ($1=="===================") close(notiflogfile)
			print_cs_line()
			seq=gensub(/^.*:/,"",1,$NF)
			if ($1 ~ /^MO(AVC|Deleted|Created)Type$/) what=toupper(gensub(/^MO|[ea]?ted|Type/,"","g",$1))
			else if ($1=="SequenceDeltaNotification") what="SDN"
		}
		else if ($1 == "type") mo=parseMoInstance($4)
		else if ($1 == ">>>" && inattr==0)
		{
			inattr=1
			attribute=gensub(/^ *>>> *(Struct )*| has [0-9]+ members.*$| =.*$/,"","g",$0)  #|\[.*$
			if ($2 != "Struct") value=gensub(/^[^=]+ = /,"",1,$0)
			else value=""
			if (value ~ /ManagedElement=1/) value=parseMoInstance(gensub(/^[^=]+ = /,"",1,$0))
		}
		else if ($1 == ">>>" && $2 != "Struct" && inattr==1)
		{
			if ($2 ~ /^[0-9]+\./) value=value";"gensub(/^[0-9]+\./,"",1,$2)"="gensub(/^[^=]+ = /,"",1,$0)
			else if ($4 ~ /ManagedElement=1/) value=value";"parseMoInstance(gensub(/^[^=]+ = /,"",1,$0))
			else value=value";"$0
		}
		else if ($1 == "ADD:") sdn="ADD"
		else if ($1 == "DELETE:") sdn="REM"
		#else if ($1 ~ "===================" || ($1 ~ /^(MO(AVC|Deleted|Created)Type|SequenceDeltaNotification)$/ && inattr==1))
		#{
		#	inattr=0
		#	if ($1=="===================") close(notiflogfile)
		#	if (what=="AVC" && tolower(attribute) in excludelist) continue
		#	print mystrftime("%y%m%d %H:%M:%S",systime())" "seq" "what" "mo (what~/^(AVC|SDN)$/ ? " "attribute" "gensub(/^;/,"",1,value) : "")
		#}
	}
	close("-")
}
function print_cs_line()
{
	if (what=="") return
	if (what=="AVC" && tolower(attribute) in excludelist) return
	if (what=="SDN" && sdn!="") attribute=attribute" "sdn
	print mystrftime("%Y-%m-%d %H:%M:%S",systime())" "seq" "what" "mo (what~/^(AVC|SDN)$/ ? " "attribute" "gensub(/^;/,"",1,value) : "")
	what=seq=mo=sdn=attribute=value=""
}
####################################################################################################################
# RESTARTCOLLECTOR FUNCTIONS
####################################################################################################################
function parse_dates(startdate,enddate,minusdays,plusdays,  array,today)
{
	if (startdate != "")
	{
		if (startdate !~ /^[1-2][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]$/)
		{
			print "Wrong date format! Should be yyyy-mm-dd  or n (where n= number of days ago). Exiting..."
			exit
		}
		else
		{
			startdate=make_timestamp(startdate)
		}
	}
	else if (minusdays ~ /^[0-9](|[0-9](|[0-9]))$/)
	{
		#up to 999 days ago
		today=mystrftime("%Y-%m-%d" ,systime())
		today=make_timestamp(today)
		startdate= today - minusdays *24*3600
		#print mystrftime("%Y %m %d %H %M %S",startdate)
	}
	else startdate= -1E8
	if (enddate != "")
	{
		if (enddate !~ /^[1-2][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]$/)
		{
			print "Wrong date format! Should be yyyy-mm-dd. Exiting..."
			exit
		}
		else
		{
			enddate=make_timestamp(enddate)
		}
	}
	else if (plusdays ~ /^[0-9](|[0-9](|[0-9]))$/)
	{
		enddate=startdate + plusdays * 24*3600
	}
	else enddate=systime()
	return startdate";"enddate
}
function make_report(  i,nr_of_files)
{
	#-rw-r--r--    1 eric     eric        30449 May 15 16:25 6000010.log
	while ((getline < trfile)>0)
	{
		gsub("\r","")
		if ($0 !~ /^#/ && $0 ~ /^.*;.*;.*/)
		{
			#TR;process;ecode;actor;srr0;board
			#WRNab79006;RncLmUePT;0x070000113;drhIurCcRhSrncC;0C204F94;ModuleMp
			#WRNac18804;ose_mms;0x080000402;;0C204F94;TRX3.2
			#WRNac18810;ose_mms;0x080000402;;0C204F94;ET-M1
			#WRNac10451;ose_mms;0x080120405;;;ET-M1
			#WRNac10451;ose_mms;0x080120405
			#several TRs can point to same restart but same TR cannot point to several restarts
			last=split($0,array,";")
			for (l=1;l<=last;l++) gsub(/^ *| *$/,"",array[l])
			tr[array[1]]=""
			if (array[1] != "" && array[2] != "" && array[3] !="")
			{
				for (l=2;l<=6;l++) tr[array[1]]=sprintf("%s;%s",tr[array[1]],array[l])
			}
			sub(/^;/,"",tr[array[1]])
		}
	}
	close(trfile)
	split(parse_dates(startdate,enddate,minusdays,plusdays),array,";")
	startdate=array[1]
	enddate=array[2]
	print("--------------------------------------------------------------------------")
	printf("Report from %s to %s\n",mystrftime("%Y-%m-%d",startdate),mystrftime("%Y-%m-%d",enddate))
	print("--------------------------------------------------------------------------")
	nr_of_files=fileOps("ls "avLogDir,fileList)
	for (i=1;i<=nr_of_files;i++) { if (fileList[i] ~ nodeFilter) totalNrOfNodes++ }
	customPrint(sprintf("\n%-30s %s","Total Number Of Nodes:",totalNrOfNodes))

	#print mystrftime("%Y %m %d",startdate),startdate
	#print mystrftime("%Y %m %d",startdate + plusdays * 24*3600),startdate+plusdays*24*3600
	i=0
	while (sprintf("ls -l %s",dailyDir) |& getline)
	{
		gsub("\r","")
		if ($1 ~ /^-rw/)
		{
			FileDate=make_timestamp(gensub(/.log/,"",1,$NF))
			if ((FileDate+86399) >= startdate && enddate >= FileDate)
			{
				i++
				inputfile[i]=sprintf("%s/%s",dailyDir,$NF)
			}
		}
	}
	close(sprintf("ls -l %s",dailyDir))
	nr_of_files=i
	for (i=1;i<=nr_of_files;i++)
	{
		removeDuplicateLines(inputfile[i])
		while ((getline < inputfile[i])>0)
		{
			gsub("\r","")
			if ($0 ~ /^#/) continue
			if ($0 !~ /^.*;.*;.*;.*;.*;.*/) continue
			#Date;Time;Node;Site;Scope;lnh;PiuType;pmd File;Process;Error Description;Error Code;Actor/ExtraData;Srr0;Message;State;SwLevel
			#2005-04-01;17:41:00;RNC;rnc2;MP;021200;ModuleMp;20050401_174114_61_021200_0xc413c6a1.pmd;main_thread;;0x80820007;application;; rlibRestartIncarnateRpuLmP%incarnateRpuLmInd; /TOP;CXP9012008_R6C01
			#pmdOccurrence[process;ecode;actor;srr0;board]=n ; pmdTR[process;ecode;actor;srr0;board]=TR
			#tr[tr]=process;ecode;actor;srr0;board
			nrOfFields=split($0,array,";")
			if (array[4] !~ nodeFilter) continue
			nodeTypeList[array[3]]=array[3]
			node_type[array[4]]=array[3]
			piuTypeList[array[7]]=array[7]
			#take away any spaces around the semicolons
			gsub(/ +;|; +/,";")
			if (includeExtra==0 && nrOfFields>=15)
			{
				$0=""
				for (nb=1;nb<=13;nb++) $0=sprintf("%s;%s",$0,array[nb])
				$0=sprintf("%s;%s",$0,array[16])
				sub(/^;/,"",$0)
			}
			else if (includeExtra==1 && nrOfFields == 14)
			{
				#the manual restarts are stored without the empty fields for message/state, so we add them now
				#2006-03-30;06:01:00;RNC;rnc1;Node;;;;;Node restart order. rank=REFRESH;;;;CXP9012011_R8H/2
				$0=""
				for (nb=1;nb<=13;nb++) $0=sprintf("%s;%s",$0,array[nb])
				$0=sprintf("%s;;;%s",$0,array[14])
				sub(/^;/,"",$0)
			}
			split(array[1],array1,"-")
			split(array[2],array2,":")
			for (comb in tr)
			{
				split(tr[comb],combarray,";")
				if (combarray[1] != "" && combarray[2] !="")
				{
					if (combarray[3]=="")
					{
						if (combarray[4]=="")
						{
							if (combarray[5]=="")
							{
								if (array[9]==combarray[1] && array[11]==combarray[2])
									restartTR[$0]=sprintf("%s %s",comb,restartTR[$0])
							}
							else if (combarray[5]!="")
							{
								if (array[9]==combarray[1] && array[11]==combarray[2] && array[7]==combarray[5])
									restartTR[$0]=sprintf("%s %s",comb,restartTR[$0])
							}
						}
						else if (combarray[4]!="")
						{
							if (combarray[5]=="")
							{
								if (array[9]==combarray[1] && array[11]==combarray[2] && array[13]==combarray[4])
									restartTR[$0]=sprintf("%s %s",comb,restartTR[$0])
							}
							else if (combarray[5]!="")
							{
								if (array[9]==combarray[1] && array[11]==combarray[2] && array[13]==combarray[4] && array[7]==combarray[5])
									restartTR[$0]=sprintf("%s %s",comb,restartTR[$0])
							}
						}
					}
					else if (combarray[3]!="")
					{
						if (combarray[4]=="")
						{
							if (combarray[5]=="")
							{
								if (array[12]==combarray[3] && array[9]==combarray[1] && array[11]==combarray[2])
									restartTR[$0]=sprintf("%s %s",comb,restartTR[$0])
							}
							else if (combarray[5]!="")
							{
								if (array[12]==combarray[3] && array[9]==combarray[1] && array[11]==combarray[2] && array[7]==combarray[5])
									restartTR[$0]=sprintf("%s %s",comb,restartTR[$0])
							}
						}
						else if (combarray[4]!="")
						{
							if (combarray[5]=="")
							{
								if (array[12]==combarray[3] && array[9]==combarray[1] && array[11]==combarray[2] && array[13]==combarray[4])
									restartTR[$0]=sprintf("%s %s",comb,restartTR[$0])
							}
							else if (combarray[5]!="")
							{
								#if (array[9]~"DedicatedChModelPT" && array[12]~"0x2634e80") print array[12]"=="combarray[3] " " array[9]"=="combarray[1] " " array[11]"=="combarray[2] " " array[13]"=="combarray[4] " " array[7]"=="combarray[5]" X"
								if (array[12]==combarray[3] && array[9]==combarray[1] && array[11]==combarray[2] && array[13]==combarray[4] && array[7]==combarray[5])
									restartTR[$0]=sprintf("%s %s",comb,restartTR[$0])
							}
							#2004-04-21;14:00:08;RNC;H2RI;SPM;0104sp2;SPBspm;20040421_140008_sp_00019_010400_spm2.pmd;DedicatedChMainPT;;0x48;0x690740;0x4378f0;
						}
					}
				}
			}
			#print sprintf("%s;%s",$0,restartTR[$0])"$"
			timestamp[sprintf("%s;%s",$0,restartTR[$0])]=mymktime(sprintf("%s %s %s %s %s %s",array1[1],array1[2],array1[3],array2[1],array2[2],array2[3]))
			pmdOccurrence[sprintf("%s;%s;%s;%s;%s",array[9],array[11],array[12],array[13],array[7]),array[3]]++
			split(restartTR[$0],trArray," ")
			split(tr[trArray[1]],combarray,";")
			if (combarray[6]=="" || combarray[6]==array[7]) pmdTR[sprintf("%s;%s;%s;%s;%s",array[9],array[11],array[12],array[13],array[7]),array[3]]=restartTR[$0]
			delete array ; delete array1 ; delete array2 ; delete combarray ; delete trArray
		}
		close(inputfile[i])
	}
	for (a in node_type)
	{
		nr_of_nodes["total"]++
		nr_of_nodes[node_type[a]]++
	}
	printf("Number of nodes with restarts: %s (",nr_of_nodes["total"])
	for (a in nr_of_nodes) { if (a != "total") printf("  %s %s",nr_of_nodes[a],a) }
	printf(")\n\n")
	n=asort(timestamp,dest)
	if (includeExtra==0) printf("Date;Time;Node;Site;Scope;lnh;PiuType;localPmdFile;Process;ErrorDescription;ErrorCode;Actor/ExtraData;Srr0;SwLevel;TR/CSR\n")
	else printf("Date;Time;Node;Site;Scope;lnh;PiuType;pmd File;Process;Error Description;Error Code;Actor/ExtraData;Srr0;Message;State;SwLevel;TR/CSR\n")
	for (a in nodeTypeList)
	{
		manualStats["Node Restarts due to SW Upgrade:",a]=manualStats["Ordered Node Restarts:",a]=0
		manualStats["Node Restarts for Unknown Reason:",a]=0
		manualStats["Abnormal SPM Restarts:","RNC"]=0
		manualStats["Manual SPM Restarts:","RNC"]=0
		#for (b in piuTypeList)
		#{
		#	manualStats[sprintf("Ordered %s Restarts:",b),a]=0
		#	manualStats[sprintf("Abnormal %s Restarts:",b),a]=0
		#}
	}
	for (i=1;i<=n;i++)
	{
		for (j in timestamp)
		{
			if ((dest[i]==timestamp[j])&&(j !="")&&(dest[i] != "")&&(already_printed[j] < 1))
			{
				printf("%s\n",j)
				already_printed[j]=1
				#Node restart order |  Node restart, SW Upgrade  | Node restart, unknown reason | Piu restart order | Piu reload order
				split(j,manarray,";")
				if (manarray[10]~ "Node restart, SW Upgrade") manualStats["Node Restarts due to SW Upgrade:",manarray[3]]++
				else if (manarray[10] ~ "Node restart order") manualStats["Ordered Node Restarts:",manarray[3]]++
				else if (manarray[10] ~ "Node restart, unknown reason") manualStats["Node Restarts for Unknown Reason:",manarray[3]]++
				else if (manarray[5]=="SPM" && manarray[10] ~ "Spm restart order") manualStats["Manual SPM Restarts:",manarray[3]]++
				else if (manarray[5]=="SPM") manualStats["Abnormal SPM Restarts:",manarray[3]]++
				else if (manarray[8] ~ "pmd")
				{
					manualStats[sprintf("Abnormal %-8s Restarts:",manarray[7]),manarray[3],"abnormal"]++
				}
				else if (manarray[10] ~ /MP requested restart/)
				{
					manualStats[sprintf("MP-requested %-8s Restarts:",manarray[7]),manarray[3],"MPrequested"]++
				}
				else if (manarray[10] ~ /Piu (restart|reload) order/)
				{
					manualStats[sprintf("Ordered  %-8s Restarts:",manarray[7]),manarray[3],"ordered"]++
				}
				else if (manarray[10] ~ /Piu restart at board upgrade/)
				{
					manualStats[sprintf("BoardUpgrade %-8s Restarts:",manarray[7]),manarray[3],"BoardUpgrade"]++
				}
			}
		}
	}
	for (a in nodeTypeList)
	{
		printf("\n==========================================================================\n\
%s statistics:\n\
==========================================================================\n",a)
		for (comb in manualStats)
		{
			last=split(comb,combarray,SUBSEP)
			if (combarray[2]==a && last==2 && combarray[1] !~ " SPM ") printf("%-33s  %s\n",combarray[1],manualStats[comb])
		}
		print "--------------------------------------------------------------------------"
		for (comb in manualStats)
		{
			last=split(comb,combarray,SUBSEP)
			if (combarray[2]==a && combarray[3]=="ordered") printf("%-33s  %s\n",combarray[1],manualStats[comb])
		}
		print "--------------------------------------------------------------------------"
		for (comb in manualStats)
		{
			last=split(comb,combarray,SUBSEP)
			if (combarray[2]==a && combarray[3]=="BoardUpgrade") printf("%-33s  %s\n",combarray[1],manualStats[comb])
		}
		print "--------------------------------------------------------------------------"
		if (a=="RNC")
		{
			printf("%-33s  %s\n","Abnormal SPM      Restarts:",manualStats["Abnormal SPM Restarts:","RNC"])
			printf("%-33s  %s\n","Manual   SPM      Restarts:",manualStats["Manual SPM Restarts:","RNC"])
		}
		for (comb in manualStats)
		{
			last=split(comb,combarray,SUBSEP)
			if (combarray[2]==a && combarray[3]=="MPrequested") printf("%-33s  %s\n",combarray[1],manualStats[comb])
		}
		for (comb in manualStats)
		{
			last=split(comb,combarray,SUBSEP)
			if (combarray[2]==a && combarray[3]=="abnormal") printf("%-33s  %s\n",combarray[1],manualStats[comb])
		}
		print "--------------------------------------------------------------------------"
		print "Abnormal "a" restarts statistics:"
		print "---------------------------------"
		print "Process;ErrorCode;Actor/ExtraData;Srr0;PiuType;NrOfOccurrences;TR/CSR"
		for (comb in pmdOccurrence)
		{
			last=split(comb,combarray,SUBSEP)
			if (combarray[2]==a && combarray[1] !~ /^;;;/) printf("%-75s ; %-3s ; %s\n",combarray[1],pmdOccurrence[comb],pmdTR[comb])
		}

	}
#	printf("\n==========================================================================\n\
#TR statistics:\n\
#==========================================================================\n")
#	printf("TR/CSR;Process;Error Code;Actor;Nr of Restarts\n")
#	for (i in pmdOccurrence) if (sprintf("%s;%s",pmdTR[i],i) !~ /^;;;/) printf("%s;%s;%s\n",pmdTR[i],i,pmdOccurrence[i])
}
function removeDuplicateLines(file, tempfile,line,lineList,ok)
{
	ok=0
	tempfile=sprintf("%s.temp",file)
	while ((getline < file)>0)
	{
		lineList[$0]=$0
	}
	close(file)
	for (line in lineList)
	{
		print line >> tempfile
		ok=1
	}
	close(tempfile)
	if (ok==1) fileOps(sprintf("mv %s %s",tempfile,file))
}
function print_line_to_avlog(avfile)
{
	if (/(CRIT|INFO) .*\
(Configuration Version|Node restart order received|Node manual restart|Node down|Cls_evlogd_proc restart|Node operational|Node starting)|\
RNC Node Restart Completed|Cell .* enabled|First VMGw Enabled|VMGWs Unlocked|JVM Load Module is now operational|The Configuration Service is up and running|\
Program CXC(1320784|1732844).*started|Program restart order received for CXC(1320784|1732844)|Program CXC(1320784|1732844).* external restart ordered|\
Current Trace properties for Upgrade Package functionality|Current properties for System Upgrade trace functionality|\
CV=.* UP=|UP .*(Start Action -|Create an upgrade|Request for Node Restart|Execute operation|Execute trigger|Upgrade executed|\
has been set as startable.|has been created.|Sending AVC Event|Execution of step label|Retrieve the Upgrade|Upgrade Package MO created.|IN +Operational +(NBIOT)?CELL|MP Last PIU)/)
	{
		if (startPrinting[avfile]==0)
		{
			if (make_timestamp($1,$2) > latestEntry[avfile]) startPrinting[avfile]=1
		}
		if (startPrinting[avfile]==1) print $0 >> avfile
	}
}
function find_swLevel(node,timestamp,   array,res,i,n)
{
	split(swLevelTimeList[node],array,",")
	n=asort(array)
	for (i=1;i<=n;i++)
	{
		if (timestamp >= array[i]) res=swLevel[node,array[i]]
	}
	return res
}

function syslogcollection(  i,j,nr_of_files,nodename,siteList,siteFile,last,array)
{
	while ((getline < sitefile)>0)
	{
		gsub("\r",""); gsub(/#.*$/,"")
		if (NF > 0 && $1 !~ ";") sitename[$1]=$1
	}
	close(sitefile)
	last=split(ip_database,array,",")
	for (i=1;i<=last;i++)
	{
		if (fileOps("test -s "array[i])!=0) continue
		while ((getline < array[i])>0)
		{
			gsub("\r",""); gsub(/#.*$/,"")
			#skip the entry if it has already been found previously
			#==> we only take the first entry to match behaviour of the function find_node_address()
			if ($1 in ip) {}
			else if (NF > 1)
			{
	        		ip[$1]=$2
	        		pw[$1]=$3
			}
		}
		close(array[i])
	}
	for (j in sitename)
	{
		if (ip[sitename[j]] == "" )     printf("!!ERROR: Site \"%s\" not defined in ipdatabase !!\n",sitename[j])
		else if (pw[sitename[j]] == "") printf("!!ERROR: Password for site \"%s\" not defined in ipdatabase!!\n",sitename[j])
	}
	if (smallreport==1) mobatch_command=sprintf("\x27 hdinfo ; cabs ; lgvsum \x27")
	else mobatch_command=sprintf("\x27 col ; hdinfo ; cv ls ; cv cu ; cabs ; lgvsum ; cabr ; getmom ; if $momversion ~ RNC ; ba spbgroup spb ; lh spbgroup te log read ; fi ; ftreef /c/pmd \x27")
	mobatch_system=sprintf("%s -v print_lmid=0%s -l -p %s -t %s %s %s %s",mobatch,mobatch_switch,maxprocess,mobatchTimeout,sitefile,mobatch_command,sysLogDir)
	print mobatch_system
	system(mobatch_system)
	while ((getline < sitefile)>0)
	{
		gsub("\r",""); gsub(/#.*$/,"")
		if (NF > 0 && $1 !~ ";") siteList[sprintf("%s.log",$1)]=sprintf("%s.log",$1)
	}
	close(sitefile)
	i=0 #very important since i was used higher up
	while (sprintf("ls -l %s",sysLogDir) |& getline)
	{
		gsub("\r","")
		if ($1 ~ /^-rw/ && $NF !~ "manualRestarts.log")
		{
			if ($NF in siteList)
			{
				i++
				syslogfile[i]=sprintf("%s/%s",sysLogDir,$NF)
				nodename[i]=gensub(/.log/,"",1,$NF)
			}
		}
	}
	close(sprintf("ls -l %s",sysLogDir))
	nr_of_files=i
	for (i=1;i<=nr_of_files;i++)
	{
		printf("Parsing %s\n",syslogfile[i])
		nodeType[nodename[i]]="Other"
		avlogfile[i]=sprintf("%s/%s",avLogDir,gensub(/^.*\//,"","g",syslogfile[i]))
		#check the latest entry in avlogfile[i]
		if (fileOps("test -s "avlogfile[i])==0)
		{
			while ((getline < avlogfile[i])>0)
			{
				gsub("\r","") ; gsub("\x00","")
				if (/^2[0-9][0-9][0-9]-[01][0-9]-[0-3][0-9] /)
				{
					latestEntry[avlogfile[i]]=make_timestamp($1,$2)
				}
			}
			close(avlogfile[i])
		}
		thisLogsDate="unknown"
		while ((getline < syslogfile[i])>0)
		{
			gsub("\r","") ; gsub("\x00","")
			print_line_to_avlog(avlogfile[i])
			if ($1 == "Name:" && NF==2) cvName=$2
			else if ($0 ~ /^Package upgrade: / && NF>=2 && NF<=3)
			{
				cvUP[cvName]=$3
				cvName=""
			}
			else if ($1 == "Startable:" && NF==2)
			{
				startableCV[nodename[i]]=$2
			}
			else if ($1 == "Loaded:" && NF ==2)
			{
				if ($2 !~ /^(Te|SU)_/)	swLevel[nodename[i],-99999]=cvUP[$2]
				else swLevel[nodename[i],-99999]=cvUP[startableCV[nodename[i]]]
				swLevelTimeList[nodename[i]]=-99999
				delete cvUP
			}
			#2007-05-27 22:30:20 OTHR  PeriodicLogging CV=Fi_CXP9012014_R9AM04_070215_1541 UP=CXP9012014_R9AM04
			#2007-05-15 22:29:28 OTHR  NodeRestarted CV=Fi_CXP9012014_R9AM04_070215_1541 UP=CXP9012014_R9AM04
			else if ($NF ~ /^UP=..../)
			{
				swLevel[nodename[i],make_timestamp($1,$2)]=gensub(/^UP=/,"",1,$NF)
				swLevelTimeList[nodename[i]]=swLevelTimeList[nodename[i]]","make_timestamp($1,$2)
			}
			else if ($1 ~ /^[0-9]+$/ && $2 ~ /^[0-9]+$/ && $3 ~ /^GPB/)
			{
				  #0   20  GPB        1   CXC1320785_R10M%1     loaderserver
				  lnh=sprintf("%02d%02d00",$1,$2)
				  processor[lnh,nodename[i]]="MP"
				  if (nodeType[nodename[i]]=="RNC")
				  {
				  	piutype[lnh,nodename[i]]=module[lnh]
				  }
				  else piutype[lnh,nodename[i]]=$3
			}
			else if ($1 ~ /^[0-9]+$/ && $2 ~ /^[0-9]+$/)
			{
				lnh=sprintf("%02d%02d00",$1,$2)
				if (processor[lnh,nodename[i]] != "MP") processor[lnh,nodename[i]]="BP"
				if ($3 ~ /^SPB/) nodeType[nodename[i]]="RNC"
				else if ($3 ~ /^(RAX|TX|TRX)/) nodeType[nodename[i]]="RBS"
				else if ($3 ~ /^MSB/) nodeType[nodename[i]]="MGW"
				else if (nodeType[nodename[i]]=="Other" && $3 ~ /^SCB/) nodeType[nodename[i]]="RXI"
				piutype[lnh,nodename[i]]=$3
			}
			else if (/INFO.*(Node restart order received.|Node manual restart)/)
			{
				#P2.1
				#2004-02-03 13:45:01  INFO  Node restart order received. Restart rank = WARM
				#2004-02-03 13:50:16  INFO  *** Cls_evlogd_proc restart ***
				#2004-02-03 13:51:17  INFO  Node starting
				#2004-02-03 13:51:18  INFO  Configuration Version = Te_CXP9011023_R7G%C_040203_1344

				#P3
				#2005-03-07 13:42:16  INFO  Node restart order received. Restart rank = WARM
				#2005-03-07 13:43:08  INFO  *** Cls_evlogd_proc restart ***
				#2005-03-07 13:43:23  INFO  Active CIM ready.
				#2005-03-07 13:43:31  INFO  Node starting
				#2005-03-07 13:43:31  INFO  Set upgrade supervision timer to 3600 seconds
				#2005-03-07 13:43:31  INFO  Configuration Version = Te_CXP9012008_R5U%A_050307_1341

				#P5
				#2006-03-21 11:31:51 INFO  Node restart order received. Restart rank = cold. Info text =
				#2007-03-27 18:02:18 INFO  Node manual restart, reason: planned reconfiguration. Restart rank = warm. Info text = -
				#2007-03-26 03:26:59 INFO  Node manual restart, reason: O and M issues. Restart rank = refresh. Info text = What a load of hohaa

				if (/Node restart order/)
				{
					gsub(/ received|Restart /,"")
					sub(/rank = /,"rank=")
					sub(/. Info text =.*$/,"")
					gsub(/ *$/,"")
					cause=gensub(/^.*Node restart/,"Node restart",1,$0)
				}
				else if (/Node manual restart/)
				{
					cause="Node restart order"
					cause=cause ". rank="gensub(/^.* Restart rank = |. Info text =.*$/,"","g",$0)
					cause=cause ". reason="gensub(/^.*, reason: |. Restart rank =.*$/,"","g",$0)
					cause=cause ". info="gensub(/^.*Info text = /,"","g",$0)
				}
				while ((getline < syslogfile[i])>0)
				{
					print_line_to_avlog(avlogfile[i])
					if (/INFO.*Configuration Version =/) break
				}
				if (/INFO.*Configuration Version = (Temporary_|Te_|SU_)/) cause="Node restart, SW Upgrade"
				printf("%s;%s;%s;%s;Node;;;;;%s;;;;%s\n",$1,$2,nodeType[nodename[i]],nodename[i],cause,find_swLevel(nodename[i],make_timestamp($1,$2))) >> sprintf("%s/%s.log",dailyDir,$1)
				close(sprintf("%s/%s.log",dailyDir,$1))
				cause=""
			}
			else if (/\*\*\* Cls_evlogd_proc restart \*\*\*/)
			{
				#2004-02-03 13:50:16  INFO  *** Cls_evlogd_proc restart ***
				#2004-02-03 13:51:17  INFO  Node starting
				#2004-02-03 13:51:18  INFO  Configuration Version = Te_CXP9011023_R7G%C_040203_1344
				cause="Node restart, unknown reason"
				while ((getline < syslogfile[i])>0)
				{
					print_line_to_avlog(avlogfile[i])
					if (/INFO.*Configuration Version =/) break
				}
				if (/INFO.*Configuration Version = (Temporary_|Te_|SU_)/) cause="Node restart, SW Upgrade"
				printf("%s;%s;%s;%s;Node;;;;;%s;;;;%s\n",$1,$2,nodeType[nodename[i]],nodename[i],cause,find_swLevel(nodename[i],make_timestamp($1,$2))) >> sprintf("%s/%s.log",dailyDir,$1)
				close(sprintf("%s/%s.log",dailyDir,$1))
				cause=""
			}
			else if (/INFO.*[MB]P . smn = [0-9]+, apn = [0-9]+ . (restarted (by command|at upgrade)|manual restart)/)
			{
				#2004-04-17 03:11:59  INFO  MP ( smn = 0, apn = 11 ) restarted by command. Restart rank = WARM
				#2004-03-17 03:57:33  INFO  BP ( smn = 2, apn = 17 ) restarted by command. Restart rank = WARM
				#2006-05-17 13:01:42 INFO  MP ( smn = 0, apn = 17 ) restarted at upgrade
				#2007-03-29 23:16:18 INFO  MP ( smn = 0, apn = 14 ) manual restart. Reason: Low coverage. Restart rank = warm. Info text = this is some information
				#2006-03-21 11:31:51 INFO  Node restart order received. Restart rank = cold. Info text =
				tmp_cause="?"
				if (/restarted at upgrade/) tmp_cause="Piu restart at board upgrade"
				else if (/restarted by command/)
				{
					sub(/Restart rank = /,"rank=")
					sub(/. Info text =.*$/,"")
					gsub(/ *$/,"")
					tmp_cause=gensub(/^.*by command/,"Piu restart order",1,$0)
				}
				else if (/manual restart/)
				{
					tmp_cause="Piu restart order"
					tmp_cause=tmp_cause". rank="gensub(/^.* Restart rank = |. Info text =.*$/,"","g",$0)
					tmp_cause=tmp_cause ". reason="gensub(/^.*. Reason: |. Restart rank =.*$/,"","g",$0)
					tmp_cause=tmp_cause ". info="gensub(/^.*Info text = /,"","g",$0)
				}
				lnh=sprintf("%02d%02d00",gensub(",","",1,$8),$11)
				printf("%s;%s;%s;%s;%s;%s;%s;;;%s;;;;%s\n",$1,$2,nodeType[nodename[i]],nodename[i],processor[lnh,nodename[i]],lnh,piutype[lnh,nodename[i]],tmp_cause,find_swLevel(nodename[i],make_timestamp($1,$2))) >> sprintf("%s/%s.log",dailyDir,$1)
				close(sprintf("%s/%s.log",dailyDir,$1))
			}
			else if (/^[0-9]+ .*(Reload ordered by operator command|Warm start ordered)/)  # && mplist ~ $1
			{
				#P2:0016  04-04-17 02:30:29  Processor  BASIC   reload                0x80010109  Reload ordered by operator command
				#P2:0011  04-04-16 14:33:19             BACKUP  ose_cmd_reload        0x80010109  Reload ordered by operator command
				#P2:0010  04-03-04 15:28:08  ose_cmd_reload        0x80010109  Reload ordered by operator command
				#P3:0027  04-11-08 02:24:27  Processor  BASIC   reload                0xB0AD0000  Board manager restart. Warm start ordered
				lnh=sprintf("%s00",$1)
				printf("20%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;;;;%s\n",$2,$3,nodeType[nodename[i]],nodename[i],processor[lnh,nodename[i]],lnh,piutype[lnh,nodename[i]],"","","Piu reload order",find_swLevel(nodename[i],make_timestamp("20"$2,$3))) >> sprintf("%s/20%s.log",dailyDir,$2)
				close(sprintf("%s/20%s.log",dailyDir,$2))
			}
			else if (/^[0-9]+ .*MP Requested Restart/)  # && mplist ~ $1
			{
				#0009  04-05-21 01:12:32  Processor  BASIC   CbcServer             0x80010109  MP Requested Restart
				lnh=sprintf("%s00",$1)
				printf("20%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;;;;%s\n",$2,$3,nodeType[nodename[i]],nodename[i],processor[lnh,nodename[i]],lnh,piutype[lnh,nodename[i]],"","","MP requested restart",find_swLevel(nodename[i],make_timestamp("20"$2,$3))) >> sprintf("%s/20%s.log",dailyDir,$2)
				close(sprintf("%s/20%s.log",dailyDir,$2))
			}
			#0213  00-00-00 00:00:00  Processor  BASIC                         0x00000004  ERROR DETECTED BY THE HARDWARE WATCHDOG This error suggests a fatal software crash or possibly a hardware problem. A cold start was encountered as a result of this situation. Software overload situations are normally indicated by the software watchdog, but in this case the software watchdog was unable to execute for several seconds. The reason for this may be that an infinite loop was entered in an interrupt process, or an infinite loop was entered on OSE priority 0, or the OSE kernel itself was damaged as a result of a serious bug somewhere.
			#NOT CHECKED AT THE MOMENT

			#P3:
			#   0019: [2004-12-11 02:06:19.336] spp_loader sp_errormsg.cc:333 ERROR:SPM #0 called OSE kernel error handler
			#   0019: [2004-12-11 02:06:19.336] spp_loader sp_errormsg.cc:336 ERROR:process name:    No process name available
			#   0019: [2004-12-11 02:06:19.336] spp_loader sp_errormsg.cc:338 ERROR:error code:      0x1000024
			#   0019: [2004-12-11 02:06:19.336] spp_loader sp_errormsg.cc:339 ERROR:extra parameter: 0x48dff0
			#   0019: [2004-12-11 02:06:19.336] spp_loader sp_errormsg.cc:344 ERROR:srr0 reg.:       0x4df170
			#   0019: [2004-12-11 02:06:19.336] spp_loader sp_errormsg.cc:735 ERROR:SPM Satellite Loader: Restart ordered from command line interface.

			#   0016: [2004-05-11 14:13:38.376] spp_loader sp_errormsg.cc:692 ERROR:SP #1 called OSE kernel error handler
			#   0016: [2004-05-11 14:13:38.376] spp_loader sp_errormsg.cc:695 ERROR:process name:    No process name available
			#   0016: [2004-05-11 14:13:38.376] spp_loader sp_errormsg.cc:697 ERROR:error code:      0x81000012
			#   0016: [2004-05-11 14:13:38.376] spp_loader sp_errormsg.cc:698 ERROR:extra parameter: 0x1
			#   0016: [2004-05-11 14:13:38.376] spp_loader sp_errormsg.cc:703 ERROR:srr0 reg.:       0x4378f0
			#   0016: [2004-05-11 14:13:38.380] spp_loader sp_errormsg.cc:1031 ERROR:A SW based watchdog triggered SP restart.

			#   0204: [2004-04-18 16:37:02.892] spp_loader sp_errormsg.cc:692 ERROR:SP #1 called OSE kernel error handler
			#   0204: [2004-04-18 16:37:02.892] spp_loader sp_errormsg.cc:695 ERROR:process name:    DedicatedChMainPT
			#   0204: [2004-04-18 16:37:02.892] spp_loader sp_errormsg.cc:697 ERROR:error code:      0x48
			#   0204: [2004-04-18 16:37:02.892] spp_loader sp_errormsg.cc:698 ERROR:extra parameter: 0x690740
			#   0204: [2004-04-18 16:37:02.892] spp_loader sp_errormsg.cc:703 ERROR:srr0 reg.:       0x4378f0
			#   0204: [2004-04-18 16:37:10.332] spp_loader sp_errormsg.cc:637 INFO:OSE PMD written to file /c/pmd/sp/00019_020400_spm1.pmd
			else if (/ERROR:SPM* #[0-9] called OSE kernel error handler/)
			{
				te_date=te_time=te_spProcess=te_spEcode=te_spExtra=te_spSrr0=te_localPmdFile=te_spEdescription=te_spLnh=te_spBoard=""
				te_spLnh=sprintf("%ssp%s",gensub(/:/,"",1,$1),gensub(/#/,"",1,$(NF-5)))
				te_spBoard=sprintf("%sspm",piutype[sprintf("%s00",gensub(/:/,"",1,$1)),nodename[i]])
			}
			else if (/ERROR:process name:/) te_spProcess=gensub(/^.*process name: +/,"","g",$0)
			else if (/ERROR:error code:/  ) te_spEcode=$NF
			else if (/ERROR:extra parameter:/) te_spExtra=$NF
			else if (/ERROR:srr0 reg.:/) te_spSrr0=$NF
			else if (/INFO:OSE PMD written to file .c.pmd/)
			{
				te_date=gensub(/^.*\[/,"","g",$2)
				te_time=gensub(/\.[0-9]+\]/,"",1,$3)
				te_localPmdFile=sprintf("%s_%s_%s",gensub("-","","g",te_date),gensub(":","","g",te_time),gensub(/.c.pmd./,"",1,gensub(/\//,"_","g",$NF)))
				#2004-05-13;21:59:15;RNC;H2RI;SPM;0109sp1;;20040513_215951_sp_00035_010900_spm1.pmd;DedicatedChMainPT;;0x48;0x690740;0x4378f0;;;
				if (te_spLnh != "") printf("%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;;;%s\n",te_date,te_time,nodeType[nodename[i]],nodename[i],"SPM",te_spLnh,te_spBoard,te_localPmdFile,te_spProcess,te_spEdescription,te_spEcode,te_spExtra,te_spSrr0,find_swLevel(nodename[i],make_timestamp(te_date,te_time))) >> sprintf("%s/%s.log",dailyDir,te_date)
				close(sprintf("%s/%s.log",dailyDir,te_date))
				te_date=te_time=te_spProcess=te_spEcode=te_spExtra=te_spSrr0=te_localPmdFile=te_spEdescription=te_spLnh=te_spBoard=""

			}
			else if (/ERROR:A SW based watchdog triggered SP restart/)
			{
				te_spEdescription="watchdog"
				te_date=gensub(/^.*\[/,"","g",$2)
				te_time=gensub(/\.[0-9]+\]$/,"",1,$3)
				if (te_spLnh != "") printf("%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;;;%s\n",te_date,te_time,nodeType[nodename[i]],nodename[i],"SPM",te_spLnh,te_spBoard,te_localPmdFile,te_spProcess,te_spEdescription,te_spEcode,te_spExtra,te_spSrr0,find_swLevel(nodename[i],make_timestamp(te_date,te_time))) >> sprintf("%s/%s.log",dailyDir,te_date)
				close(sprintf("%s/%s.log",dailyDir,te_date))
				te_date=te_time=te_spProcess=te_spEcode=te_spExtra=te_spSrr0=te_localPmdFile=te_spEdescription=te_spLnh=te_spBoard=""
			}
			else if (/ERROR:SPM Satellite Loader: Restart ordered from command line interface./)
			{
				te_date=gensub(/^.*\[/,"","g",$2)
				te_time=gensub(/\.[0-9]+\]$/,"",1,$3)
				if (te_spLnh != "") printf("%s;%s;%s;%s;%s;%s;;;;Spm restart order;;;;%s\n",te_date,te_time,nodeType[nodename[i]],nodename[i],"SPM",te_spLnh,find_swLevel(nodename[i],make_timestamp(te_date,te_time))) >> sprintf("%s/%s.log",dailyDir,te_date)
				close(sprintf("%s/%s.log",dailyDir,te_date))
				te_date=te_time=te_spProcess=te_spEcode=te_spExtra=te_spSrr0=te_localPmdFile=te_spEdescription=te_spLnh=te_spBoard=""
			}
			else if ($1 ~ /^-rw-/ && $NF ~ /.pmd$/)
			{
				#P3:   -rw-rw-rw-  48340      5 May 2004 17:02:03  /c/pmd/20/001400/pmd.pmd
				#P2.1: -rw-rw-rw-  5496      19 Mar 2004 06:35:38  /c/pmd/sp/00020_002100_spm1.pmd
				filedate=sprintf("%4s%02d%02d_%s",$5,mm[$4],$3,gensub(/:/,"","g",$6))
				nodePmdList[nodename[i],$NF,filedate]=1
			}
			else if (/INFO:Discarding SPP_SPM_DOWN_IND signal for SPM #[0-9]/ || /INFO:SPM #[0-9] restart ordered/)
			{
				#   0204: [2004-04-18 16:37:02.892] spp_loader spm.cc:803 INFO:SPM #0 (0.19.16) : DISABLED  (CPP3)
				#   0204: [2004-04-18 16:37:02.892] spp_loader spm_cntrl.cc:799 INFO:Discarding SPP_SPM_DOWN_IND signal for SPM #0 (CPP3)
				#   0204: [2004-04-18 16:37:02.892] spp_loader_mgr spp_loader_mgr.c:1372 INFO:SPM #0 restart ordered  (CPP4/5.0/5.1)

				#===> 2004-04-15;14:46:56;RNC;H3RI;SPM;0109sp1;;;;Spm restart order
				te_spLnh=te_date=te_time=""
				match($0,/SPM #[0-9]/)
				te_spLnh=sprintf("%ssp%s",gensub(/:/,"",1,$1),substr($0,RSTART+5,1))
				te_date=gensub(/^.*\[/,"","g",$2)
				te_time=gensub(/\.[0-9]+\]/,"",1,$3)
				printf("%s;%s;%s;%s;%s;%s;;;;Spm restart order;;;;%s\n",te_date,te_time,nodeType[nodename[i]],nodename[i],"SPM",te_spLnh,find_swLevel(nodename[i],make_timestamp(te_date,te_time))) >> sprintf("%s/%s.log",dailyDir,te_date)
				close(sprintf("%s/%s.log",dailyDir,te_date))
			}
			else if ($NF ~ /^stopfile=/ && $1 ~ /^[0-9][0-9][0-9][0-9][0-9][0-9]-[0-9][0-9]:[0-9][0-9]:[0-9][0-9]$/) thisLogsDate="20"gensub(/-.*$/,"",1,$1)
		}
		close(syslogfile[i])
		close(avlogfile[i])  #necessary because we've been printing things in avlogfile using the function print_line_to_avlog
		print thisLogsDate,nodename[i],nodeType[nodename[i]] >> sprintf("%s/%s.log",dailyNodesDir,thisLogsDate)
		close(sprintf("%s/%s.log",dailyNodesDir,thisLogsDate))
	}
	print "Done."
}
function pmdcollection()
{
	if (smallreport==1) return
	while ((getline < sitefile)>0)
	{
		gsub("\r",""); gsub(/#.*$/,"")
		if (NF > 0 && $1 !~ ";")
		{
			sitename[$1]=$1
			nodeDir[$1]=sprintf("%s/%s",globalNodeDir,sitename[$1])
			fileOps(sprintf("mkdir -p %s",nodeDir[$1]))
			mpFetchedFile[$1]=sprintf("%s/mpFetched.log",nodeDir[$1])
			print "" >> mpFetchedFile[$1]
			close(mpFetchedFile[$1])
		}
	}
	close(sitefile)
	last=split(ip_database,array,",")
	for (i=1;i<=last;i++)
	{
		if (fileOps("test -s "array[i])!=0) continue
		while ((getline < array[i])>0)
		{
			gsub("\r",""); gsub(/#.*$/,"")
			#skip the entry if it has already been found previously
			#==> we only take the first entry to match behaviour of the function find_node_address()
			if ($1 in ip) {}
			else if (NF > 1)
			{
	        		ip[$1]=$2
	        		pw[$1]=$3
			}
		}
		close(array[i])
	}
	for (j in sitename)
	{
		if (ip[sitename[j]] == "" )     printf("!!ERROR: Site \"%s\" not defined in ipdatabase !!\n",sitename[j])
		else if (pw[sitename[j]] == "") printf("!!ERROR: Password for site \"%s\" not defined in ipdatabase!!\n",sitename[j])
		else fetchpmd(sitename[j],nodeDir[j],ip[sitename[j]],pw[sitename[j]],mpFetchedFile[j])
	}
}
function fetchpmd(site,sitedir,ipaddress,passwd,mpfetchedfile,  \
filename,filedate,filePresent,fileFetched,comb,fileToFetch,array,lnh,date,time,process,ecode,edescription,\
actor,srr0,message,state,pmdFile,pmdTimestamp,wrong_pw,localPmdFile,last,pmdarray,te_srr0,te_proc,te_piutype)
{
	printf("Checking IP contact to site %s (%s)...",site,ipaddress)
	if (check_ip_contact(ipaddress,telnet_port)==0) telnet_state[site]="OK"
	else telnet_state[site]="Not OK"
	print telnet_state[site]
	if (telnet_state[site]=="OK")
	{
		for (comb in nodePmdList)
		{
			split(comb,array,SUBSEP)
			if (array[1]==site) filePresent[array[2],array[3]]=1
		}
		while ((getline < mpfetchedfile)>0)
		{
			# /c/pmd/20/001400/pmd.pmd 20040223_165553
			# /c/pmd/sp/00020_002100_spm1.pmd 20040325_170053
			# /c/pmd/bp/00002_012500.pmd  20040325_170053
			if (NF == 2) fileFetched[$1,$2]=1
		}
		close(mpfetchedfile)
		for (comb in filePresent)
		{
			if (fileFetched[comb]==1) delete filePresent[comb]
		}
		for (comb in filePresent)
		{
			if (filePresent[comb]!=1) continue
			split(comb,array,SUBSEP)
			pmdFile=array[1]
			pmdTimestamp=array[2]
			#Do not fetch PMD files that are older than oldestPMD days (default 30, defined in restartcollector file)
			if ((oldestPMD > 0) && (systime() > (oldestPMD*24*3600 + make_timestamp(pmdTimestamp)))) continue
			fileToFetch=pmdFile
			if (ftpclient(ipaddress,passwd,sprintf("get %s %s",fileToFetch,sprintf("%s/%s",sitedir,gensub(/^.*\//,"","g",fileToFetch))))!=0) continue
			printf("%s %s\n",pmdFile,pmdTimestamp) >> mpfetchedfile
			close(mpfetchedfile)
			last=split(pmdFile,pmdarray,"/")
			localPmdFile=pmdTimestamp
			for (z=4;z<=last;z++) localPmdFile=sprintf("%s_%s",localPmdFile,pmdarray[z])
			fileOps(sprintf("mv %s/%s %s/%s",sitedir,gensub(/^.*\//,"","g",fileToFetch),sitedir,localPmdFile))
			date=time=process=ecode=edescription=actor=message=state=srr0=te_srr0=extradata=lnh=restart_type=osRunMode=""
			if (localPmdFile !~ /_spm..pmd/)
			{
				zpm_session=sprintf("%s %s/%s",zpm,sitedir,localPmdFile)
				while ((zpm_session |& getline)>0)
				{
					gsub("\r","") ; gsub("\x00","")
					if ($1=="0x03E8:" && $2 ~ /^[0-9A-F][0-9A-F]$/ && $10 ~ /^"........"$/) { print "Corrupted PMD!!!" ; break } #this means there is a corruption in the llog -l printout, abort
					else if (/000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000/) { print "Corrupted PMD!!!" ; break }
					else if (/^date += /)
					{
						#Old ZPM R1A
						#date   = 2004-02-03  18:09:59 802688
						date=$3
						time=$4
					}
					else if (/^ *Dump created/)
					{
						#New ZPM R6A
						#  Dump created :   2006-03-20  18:38:24.922243
						date=$4
						time=gensub(/\..*$/,"",1,$5)
					}
					else if (/^ *Process: /) process=$2
					else if (/^ *Error code: /) ecode=sprintf("0x%s",$3)
					else if (/^ *Error Description *:/)
					{
						edescription=edescription" "gensub(/\[|\]/,"","g",$4)
						sub(/^ */,"",edescription)
					}
					else if (/^ *Error Information *:/)
					{
						zpm_session |& getline
						gsub("\r","") ; gsub("\x00","")
						if (NF>0) edescription=edescription" "gensub(/^ +| +$/,"","g",$0)
						sub(/^ */,"",edescription)
					}
					else if (/^ *(actor|capsule) *=/ && actor=="") actor=gensub(/^ *(actor|capsule) *= *|\[.*$| +$/,"","g",$0)
					else if (/^ *message *=/       && message=="") message=gensub(/^ *message *= */,"",1,$0)
					else if (/^ *state *=/           && state=="") state=gensub(/^ *state *= */,"",1,$0)
					else if (/^ *ERROR NUMBER /)
					{
						ecode=$3
						if (/EXTRA DATA/)
						{
							split($0,extraArray,/EXTRA DATA /)
							split(extraArray[2],extraArray2," ")
							extradata=extraArray2[1]
						}
					}
					else if (/^ *PROCESS /) process=$2
					else if (/^ *srr0:/)
					{
						te_srr0=$2
						zpm_session |& getline
						gsub("\r","") ; gsub("\x00","")
						if (/^- BLOCK [0-9]+ /) srr0=te_srr0
						te_srr0=""
					}
					else if (/^Restart type:/) restart_type=gensub(/^Restart type: +/,"","g",$0)
					else if (/^ +Restart type +: +/) restart_type=$4
					else if (/[0-9]+\. +Time +: +/)
					{
						edescription="" # Because it is fetched from the llog -l in pmd
						restart_type="unknown"
					}
					else if (/^ +OS Run Mode +: +/) osRunMode=$5
				}
				close(zpm_session)
				system(sprintf("gzip -f %s/%s",sitedir,localPmdFile))
				last=split(localPmdFile,localpmdarray,"_")
				if (localPmdFile ~ /_(mp|bp)_/) lnh=gensub(/.pmd$/,"",1,localpmdarray[last])
				else lnh=localpmdarray[last-1]
				if (actor=="") actor=extradata
				if (restart_type=="unknown" && osRunMode=="BACKUP") restart_type="-Processor"
				else if (restart_type != "") restart_type="-"restart_type
				if (restart_type=="-Processor") restart_type=""
				if (lnh !~ /00$/)
				{
					#the link handler is like: 002218
					te_piutype=piutype[gensub(/..$/,"",1,lnh)"00",site]
					if (te_piutype ~ /^SPB/) te_proc="SPM"
				}
				else
				{
					te_proc=processor[lnh,site]
					te_piutype=piutype[lnh,site]
				}
				printf("%s;%s;%s;%s;%s%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s;%s\n",date,time,nodeType[site],site,te_proc,restart_type,lnh,te_piutype,localPmdFile,process,edescription,ecode,actor,srr0,message,state,find_swLevel(site,make_timestamp(date,time))) >> sprintf("%s/%s.log",dailyDir,date)
				close(sprintf("%s/%s.log",dailyDir,date))
			}
			else system(sprintf("gzip -f %s/%s",sitedir,localPmdFile))
		}
	}
	else print ""
}
function DefineGlobalVars()
{
	mm["Jan"]=1;mm["Feb"]=2;mm["Mar"]=3;mm["Apr"]=4;mm["May"]=5;mm["Jun"]=6
	mm["Jul"]=7;mm["Aug"]=8;mm["Sep"]=9;mm["Oct"]=10;mm["Nov"]=11;mm["Dec"]=12
	mm["jan."]=1;mm["fev."]=2;mm["mars"]=3;mm["avr."]=4;mm["mai"]=5;mm["juin"]=6
	mm["jui."]=7;mm["aout"]=8;mm["sep."]=9;mm["oct."]=10;mm["nov."]=11;mm["dec."]=12
	#module["001400"]=1
	#module["001500"]=1
	#module["011300"]=2
	#module["011400"]=3
	#module["011500"]=4
	#module["021300"]=5
	#module["021400"]=6
	#module["021500"]=7
	module["001400"]=module["001500"]=module["001600"]="ModuleMp"
	module["011200"]=module["011300"]=module["011400"]=module["011500"]=module["011600"]=module["011700"]="ModuleMp"
	module["021200"]=module["021300"]=module["021400"]=module["021500"]=module["021600"]=module["021700"]="ModuleMp"
	module["031200"]=module["031300"]=module["031400"]=module["031500"]=module["031600"]=module["031700"]="ModuleMp"
	module["041200"]=module["041300"]=module["041400"]=module["041500"]=module["041600"]=module["041700"]="ModuleMp"
	module["091200"]=module["091300"]=module["091400"]=module["091500"]=module["091600"]=module["091700"]="ModuleMp"
	module["000800"]=module["000900"]="SccpMp"
	module["001700"]="RanapMp"
	module["001800"]="RnsapMp"
	module["001200"]=module["001300"]="OaM_Mp"
	module["001000"]=module["001100"]="CoreMp"
}
##############Function for option -u in restartcollector ########################
#Use following command to get an overview of the sequence of events for a node
#lgsvum | gawk '/Start Action - |Create an upgrade|Request for Node Restart|Execute operation|Execute trigger|Upgrade executed|has been set as startable.|has been created.|Sending AVC Event|Execution of step label|Retrieve the Upgrade|Upgrade Package MO created.|Configuration Version|Node restart order received. Restart rank = |CRIT.*Node down|Cls_evlogd_proc restart|Node operational|RNC Node Restart Completed|Cell .* enabled|First VMGw Enabled|VMGWs Unlocked|JVM Load Module is now operational/ {print}'
function upgrade_report( i)
{
	delimiter1="================================================================================================================================="
	delimiter2="---------------------------------------------------------------------------------------------------------------------------------"
	delimiter3="#################################################################################################################################"
	resTable[0]="FAIL"
	resTable[1]="OK"
	split(parse_dates(startdate,enddate,minusdays,plusdays),array,";")
	startdate=array[1]
	enddate=array[2]
	customPrint(delimiter2)
	customPrint(sprintf("Report from %s to %s",mystrftime("%Y-%m-%d",startdate),mystrftime("%Y-%m-%d",enddate)))
	customPrint(delimiter2)
	nr_of_files=fileOps("ls "avLogDir,fileList)
	for (i=1;i<=nr_of_files;i++) { if (fileList[i] ~ nodeFilter) totalNrOfNodes++ }
	customPrint(sprintf("\n%-22s %s","Total Number Of Nodes:",totalNrOfNodes))
	customPrint("\nDate;Time;Node;Upgrade/Install;Result;To;From;NrOfNodeRestarts;CelloDownTime;UpgradeTime;ConfirmTime;LastProgressHeader;LastStepExecuting;InstallTime;NrOfFilesDownloaded;TotalNrOfFiles;FtpServer;ApplicationDownTime")
	for (i=1;i<=nr_of_files;i++) { if (fileList[i] ~ nodeFilter) parse_upgrade_info(sprintf("%s/%s",avLogDir,fileList[i])) }
	install_print_results()
	up_print_results()
}
