#!/usr/bin/env perl
use warnings;
$| = 1;    #don't buffer output
use strict;
use Data::Dumper;
use POSIX qw(strftime);
use POSIX;
use Time::Local;
my @lghash= ();
my $alarmHash = {};
while ( my $line = <STDIN> )
{
    chomp$line;

    if ( $line =~ /^((\d{4})-(\d{2})-(\d{2})\s(\d{2}):(\d{2}):(\d{2}))\s+(AL)\s+([M])\s+(.+?)\s*$/ )
    {
        #ALARM parser. lga
        #print "time:$1, type:$8,fault:$9,message:$10" . "\n";
        #push( @{$lghash->{a}->{$9}->{$10}}, $1 );
        my $time = $1;
        my $type = $8;
        my $fault = $9;
        my $message = $10;
        $alarmHash->{M}->{$message} = $time;
    }
    elsif ( $line =~ /^((\d{4})-(\d{2})-(\d{2})\s(\d{2}):(\d{2}):(\d{2}))\s+(AL)\s+([w])\s+(.+?)\s*$/ )
    {
        #ALARM parser. lga
        my $time = $1;
        my $type = $8;
        my $fault = $9;
        my $message = $10;
        $alarmHash->{w}->{$message} = $time;
    }
    elsif ( $line =~ /^((\d{4})-(\d{2})-(\d{2})\s(\d{2}):(\d{2}):(\d{2}))\s+(AL)\s+([\*])\s+(.+?)\s*$/ )
    {
        my $time = $1;
        my $type = $8;
        my $fault = $9;
        my $message = $10;
        #ALARM parser. lga
        if ( defined $alarmHash->{M}->{$message} )
        {
            push( @lghash, {eventType => "alarm major", min => $alarmHash->{M}->{$message}, max => $time , title => "", description => "$message" } );
            delete $alarmHash->{M}->{$message};
        }
        if ( defined $alarmHash->{w}->{$message} )
        {
            push( @lghash, {eventType => "alarm", min => $alarmHash->{w}->{$message}, max => $time , title => "", description => "$message" } );
            delete $alarmHash->{w}->{$message};
        }
    }
    elsif ( $line =~ /^((\d{4})-(\d{2})-(\d{2})\s(\d{2}):(\d{2}):(\d{2}))\s+(ERR)\s+(.+?)\s*$/ )
    {
        #Chrash parser. lgs
        my $time = $1;
        my $type = $8;
        my $message = $9;
        push( @lghash, {eventType => "crash", min => $time, max => $time , title => "", description => "$message" } );
        #push( @{$lghash->{s}->{$type}->{$message}}, {type => "crash", start => $time, stop => $time , slogan => "-" } );
    }
    elsif ( $line =~ /^((\d{4})-(\d{2})-(\d{2})\s(\d{2}):(\d{2}):(\d{2}))\s+(EV)\s+(.+?)\s*$/ )
    {
        #EVENT parser. lge
        my $time = $1;
        my $type = $8;
        my $message = $9;
        push( @lghash, {eventType => "event", min => $time, max => $time , title => "", description => "$message" } );
        #push( @{$lghash->{s}->{$type}->{$message}}, {type => "crash", start => $time, stop => $time , slogan => "-" } );
    }
}
foreach my $message ( sort keys %{$alarmHash->{M}} )
{
    #push( @{$lghash->{a}->{M}->{$message}}, { type => "alarm", start => $alarmHash->{M}->{$message}, stop => '-' , slogan => "major" } );
    push( @lghash, {eventType => "alarm major", min => $alarmHash->{M}->{$message}, max => '-' , title => "", description => "$message" } );

}
foreach my $message ( sort keys %{$alarmHash->{w}} )
{
    #push( @{$lghash->{a}->{w}->{$message}}, { type => "alarm", start => $alarmHash->{w}->{$message}, stop => '-' , slogan => "warning" } );
    push( @lghash, {eventType => "alarm", min => $alarmHash->{w}->{$message}, max => '-' , title => "", description => "$message" } );
}
foreach my $message ( sort keys %{$alarmHash->{'*'}} )
{
    #push( @{$lghash->{a}->{'*'}->{$message}}, { type => "alarm", start => '-', stop => $alarmHash->{'*'}->{$message} , slogan => '*' } );
    push( @lghash, {eventType => "alarm", min => '-', max => $alarmHash->{'*'}->{$message} , title => "", description => "$message" } );
}
my $varToPrint = "";
$varToPrint .= 'var events = [' . "\n";
foreach my $line ( @lghash )
{
    #next if $line->{min} eq '-';
    #next if $line->{max} eq '-';
    $varToPrint .= "\t" . '{ ';
    $varToPrint .=  'eventType' . ': ' . "'$line->{eventType}'" . ', ';
    if ( $line->{min} =~ /(\d{4})\-(\d{2})\-(\d{2}) (\d{2}):(\d{2}):(\d{2})/ )
    {
        $line->{min} = ( (timegm( $6, $5, $4, $3, $2 -1, $1 -1900, 0, 0, 0)) * 1000 ) ;
    }
    if ( $line->{max} =~ /(\d{4})\-(\d{2})\-(\d{2}) (\d{2}):(\d{2}):(\d{2})/ )
    {
        $line->{max} = ( (timegm( $6, $5, $4, $3, $2 -1, $1 -1900, 0, 0, 0)) * 1000 ) ;
    }
    $line->{description} =~ s/[{}'\]\[]//g;
    $varToPrint .=  'min' . ': ' . "'$line->{min}'" . ', ';
    $varToPrint .=  'max' . ': ' . "'$line->{max}'" . ', ';
    $varToPrint .=  'title' . ': ' . "'$line->{title}'" . ', ';
    $varToPrint .=  'description' . ': ' . "'$line->{description}'" ;
    $varToPrint .= ' },' . "\n";
}
$varToPrint =~s /,\n$/\n/;
$varToPrint .= ']' . "\n";
print $varToPrint . ';';

#print Dumper($lghash);
