package Attrib;

use strict;
use locale;
use Data::Dumper;

sub Attrib::new() {
  my $class = shift;
  my %self = @_;
  return bless \%self;
}

sub Attrib::getRegexp() {
    my $self = shift;
    return $self->{matchString};
}

sub Attrib::getName() {
    my $self = shift;
    return $self->{name};
}

## Returns an array of the names of the capture groups used in the matchString
## regular expression. An empty array is returned if there are no named capture
## groups in the matchString.
sub Attrib::getNamedGroups() {
    my $self = shift;
    unless (exists $self->{namedGroups})
    {
        $self->{namedGroups} = [];
        while ($self->{matchString} =~ /\?\<([^\>]*)>/g)
        {
            push @{$self->{namedGroups}}, $1;
        }
    }
    return $self->{namedGroups};
}

sub Attrib::getCleanString() {
    my $self = shift;
    my $obj = shift;
    my $line = shift;
    my @list = $$line =~ /$self->{matchString}/i;
    my %captures = %+;
    if ( @list )
    {
        if ($self->getName())
        {
            @list = RegExpDefault(@list);
            if ( defined $self->{cleanString} )
            {
                @list = RegExpCleanString(@list);
            }
            $obj->{$self->{name}} = join( ' - ', @list );
            $self->renameStrings($obj, $self->{name});
        }
        else
        {
            ## Named capture groups is probably used
            foreach my $key (keys %captures)
            {
                my $capture = $captures{$key};
                if ($capture) ## Capture may not have been found
                {
                    $capture = RegExpDefault($capture);
                    if ( defined $self->{cleanString} )
                    {
                        $capture = RegExpCleanString($capture);
                    }
                    $obj->{$key} = $capture;
                    $self->renameStrings($obj, $key);
                }
            }
        }

    }

}

sub Attrib::getRenameString() {
    my $self = shift;
    return $self->{renameString};
}

sub Attrib::renameStrings() {
    my $self = shift;
    my $obj = shift;
    my $name = shift;
    if ( defined $self->{rename} )
    {
        for ( my $i=0; $i<@{$self->{rename}->{from}}; $i++ )
        {
            if(@{$self->{rename}->{to}}[$i] =~ /^\s*\$(\S+)/){
                my $getvalue = $1;
                $obj->{$name} =~ s/@{$self->{rename}->{from}}[$i]/$obj->{$getvalue}/i if (defined $obj->{$getvalue});
            }
            else
            {
                $obj->{$name} =~ s/@{$self->{rename}->{from}}[$i]/@{$self->{rename}->{to}}[$i]/i;
            }

        }
    }
}

sub RegExpDefault
{
    my @strings = @_;
    map
    {
        if ($_)
        {
            $_ =~ s/;//g;
            $_ =~ s/\s+/ /g;
            $_ =~ s/(^\s+|\s+$)//g;
        }
    } @strings;
    return $strings[0] if (@strings == 1);
    return @strings;
};

sub RegExpCleanString
{
    my @strings = @_;
    map
    {
        if ($_)
        {
            $_ =~ s/ESC\n//g;
            $_ =~ s/ESC\[0m//g;
            $_ =~ s/\D+\.cc:\d+\s//;
            $_ =~ s/[0o]x[A-Fa-f0-9]+/xxx/g;
            $_ =~ s/\(-?xxx,-?xxx,-?xxx\)//g;
            $_ =~ s/[A-Fa-f0-9]*\d+[A-Fa-f0-9]*/xxx/g;
            $_ =~ s/\w+ HEX/xxx HEX/g;
            $_ =~ s/\e//g;
            $_ =~ s/rrcMsgData\{.+?,/rrcMsgData\{\},/gs;
        }
    } @strings;
    return $strings[0] if (@strings == 1);
    return @strings;
};

1;
