#!/usr/bin/env perl

use strict;
use warnings;
use Data::Dumper;
use Getopt::Long;
use IO::Socket;

my @mho_list = ();
$| = 1;
GetOptions
(
    'mho=s' => \@mho_list,
);

@mho_list = split(',', join(',', @mho_list ) );

unless (@mho_list)
{
    @mho_list=(  "3G-RBS-M","3G-I&V","3G-I&V-M", "3G-I&V3K-D","3G-M-AOAM", "3G-M-PERF", "3G-M-TRAF", "3G-PLM-LAB", "3G-RNC-PLM", "3G-RNC-REG");  #"3G-I&V",
}

print "mho_list is @mho_list\n";

my $host = '137.58.212.248';
my $port = '6729';

my $DB_path = '/proj/rncv/PV/OaM_Tools/teSummary/MHWeb_DB/';

my $socket = IO::Socket::INET->new(PeerAddr => $host,
                   PeerPort => $port,
                   Proto => 'tcp',
                   Type => SOCK_STREAM,
                ) or die "Could not connect to $host:$port : $@\n";

$socket->autoflush(1);

&get_all_tr();

close $socket;

sub get_all_tr
{

    foreach my $mho (@mho_list)
    {
        my $res;
        print $socket "LIST $mho\n";
        my @tr_list = ();
        #$socket->autoflush(1);
        while (my $tr = <$socket>)
        {
            print $tr;
            push @tr_list, $tr if ($tr =~ /^H\w+/);
            last if ($tr =~ /^\./);
        }

        clean_db($mho);
        get_tr_status($mho, \@tr_list);
        sleep 5;
    }
}

sub get_tr_status
{
    my $mho = shift;
    my $tr_list = shift;

    foreach my $tr ( @{$tr_list} )
    {
        chomp $tr;
        print "tr is $tr\n";
        my $res;
        print $socket "TR $tr\n";
        sysread($socket, $res, 1024);

        print $res;
        update_mho_DB($mho, $tr, $res);
    }

}

sub update_mho_DB
{
    my ($mho, $tr, $res) = @_;

    system("mkdir -p $DB_path") if(! -d $DB_path);
    my $mho_file = $DB_path . $mho.".xml";
    my @tr_status = ();
    my $ne_file = 0;
    my @tmp_res = split("\n", $res);
    foreach  my $result (@tmp_res)
    {
        next if ($result =~ /^\<CCB/);
        next if ($result =~ /^\<New/);
        next if ($result =~ /^\<SystemImpact/);

        push @tr_status, $result if($result =~ /^\</);
    }

    $ne_file = 1 if(! -e $mho_file);

    open MHOFILE, '+<', $mho_file;

    seek( MHOFILE, -8, 2 );

    foreach (@tr_status)
    {



        print MHOFILE $_."\n";
        print MHOFILE "<id>$tr<\/id>\n" if ($_ =~ /^\<ClearDDTS/);
    }

    print MHOFILE '</conf>'."\n";
    close MHOFILE;
}

sub clean_db
{
    my ($mho) = @_;
     my $mho_file = $DB_path . $mho.".xml";

    open TMP, '>', $mho_file;
    print TMP '<conf>'."\n";
    print TMP '</conf>'."\n";
    close TMP;
}

__END__;
