package fileHandler;
use strict;
use Data::Dumper;
my ($statusCounter,$length);
my $procent = 0;


sub checkFiles
{
    my $conf = shift;
    if ( defined $conf->{file} )
    {
        my @files;
        if( -d $$conf{file} ){
             opendir(DIR, $$conf{file});
            my @filenames = readdir(DIR);
            foreach my $filename (@filenames ){
            next if ($filename =~ /^[.]+$/ );
                next if ($filename =~ /^[.]+bin$/ );
                push(@files,$$conf{file}.'/'.$filename)
            }
        }
        else{
            @files = split( /,/, $conf->{file} );
        }
        my $Filesize;
        my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks);
        my $errorFlag;
        foreach my $file ( @files )
        {
            if ( !-e $file )
            {
                print "file not found: $conf->{file}\n";
                $errorFlag = 1;
            }
            else
            {
                print "$file\n";
                ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks) = stat($file);
                $Filesize += $size;

            }
        }
        if ( defined $errorFlag )
        {
            exit;
        }
        print "Filesize: " . $Filesize . " Nr of files: " . @files . "\n";
        print STDERR "\rProgress counter:   " . "0" . "%";
        $conf->{totalfileSize} = $Filesize;
        return @files;
    }

}



sub openFile
{
    my $file = shift;
    open STDIN, "< $file";
}


sub fileStatusCounter
{
    my $conf = shift;
    my $lineref = shift;

    if ( !$conf->{file} )
    {
        return;
    }
    my $filesize = $conf->{totalfileSize};
    next if $filesize == 0;
    $statusCounter += length($$lineref);
    if ( int( ( $statusCounter / $filesize ) * 100 ) > $procent )
    {
        for ( ; defined $length && $length > 0 ; $length-- )
        {
            print STDERR "\b";
        }
        print STDERR "\b";
        $procent = int( ( $statusCounter / $filesize ) * 100 );
        print STDERR "\rProgress counter:   " . $procent . "%";

    }
    $length = length($procent);
}


1;
