package formatFABRIC;

use strict;
use locale;
use Data::Dumper;
use formatTXT;
use formatCSV;
use formatHTML;
use formatFLOT;
use formatJSON;
use formatTEDB;
#use Statistics::PointEstimation;
#use Statistics::TTest;

#use formatRRS;

    my $sortingTable;
    my $sortMethod = 0;

sub formatFABRIC::new() {
    my $class = shift;
    my %self = @_;
    $self{TEXTPRINTER} = new formatTXT( silent => $self{silent}, outfile => $self{outfile} );
    $self{CSVPRINTER} = new formatCSV( silent => $self{silent}, outfile => $self{outfile} );
    $self{HTMLPRINTER} = new formatHTML();
    $self{FLOTPRINTER} = new formatFLOT();
    $self{JSONPRINTER} = new formatJSON( conf => $self{conf} );
    $self{TEDBPRINTER} = new formatTEDB();
    #$self{RRSPRINTER} = new formatRRS();
    $self{TABLEAME} = ();
    #$self{TTEST} = new Statistics::TTest;

    return bless \%self;
}

sub formatFABRIC::createDumps(){
    my $self = shift;
    my $conf = shift;
    if ( defined $self->{table}->{diffstore} && $self->{table}->{diffstore} eq "yes" )
    {
        my $obj = {};
        $obj->{TABLE} = $self->{table}->{TABLE} if ( defined $self->{table}->{TABLE} );
        $obj->{TABLE_GROUPBY} = $self->{table}->{TABLE_GROUPBY} if ( defined $self->{table}->{TABLE_GROUPBY} );
        $obj->{NAME} = $self->{table}->{NAME} if ( defined $self->{table}->{NAME} );
        $obj->{MAX} = $self->{table}->{MAX} if ( defined $self->{table}->{MAX} );
        $obj->{HEADER} = $self->{table}->{HEADER} if ( defined $self->{table}->{HEADER} );
        $obj->{GROUPBY} = $self->{table}->{GROUPBY} if ( defined $self->{table}->{GROUPBY} );
        $conf->{dumptables}->{$self->{table}->{name}} = $obj;
    }
}

sub formatFABRIC::printTable(){
    my $self = shift;
    my $rop = shift;
    #my $rrsSession = shift;

    if ( defined $self->{table}->{GROUPBY} )
    {
        if( $self->{PRINTER}->{format} ne "FLOT" )
        {
            #$self->printTableGroupBy( $self->{table}, undef, $rrsSession );
            $self->printTableGroupBy( $self->{table}, undef );
        }
        if ( defined $rop )
        {

            $self->printTableGroupBy( $self->{table}, "rop" );
        }
    }
    else
    {
        if( $self->{PRINTER}->{format} ne "FLOT" )
        {
            #$self->printTableSimple( $self->{table}, undef, $rrsSession);
            $self->printTableSimple( $self->{table}, undef );
        }
        if ( defined $rop )
        {
            $self->printTableSimple( $self->{table}, "rop" );
        }
    }
}

sub formatFABRIC::getTableHeaderFormatString(){
    my $self = shift;
    my $table = shift;
    my $tmpTable = shift;
    my @formatString;
    my @headers = @{$tmpTable->{HEADER}};
    if ( !defined $tmpTable->{noCount} )
    {
        unshift(@headers,"COUNT");
    }
    foreach my $string ( keys %{$table} )
    {
        my @att = split( /;/, $string );
        if ( !defined $tmpTable->{noCount} )
        {
            unshift(@att,$table->{$string});
        }
        for( my $i=0; $i<@att; $i++ )
        {
            my $newString = $att[$i];
            my ( $hashmap, $bitmap );
            if( defined $headers[$i] && defined $tmpTable->{HASHMAP}->{$headers[$i]} )
            {
                $hashmap = $tmpTable->{HASHMAP}->{$headers[$i]};
            }
            if ( defined $hashmap )
            {
                $newString = $newString . ' ' . lookupTables::decodeHASHMAP( $hashmap, $newString ) ;
            }
            if( defined $headers[$i] && defined $tmpTable->{BITMAP}->{$headers[$i]} )
            {
                $bitmap = $tmpTable->{BITMAP}->{$headers[$i]};
            }
            if ( defined $bitmap )
            {
                $newString = $newString . ' ' . lookupTables::decodeBITMAP( $bitmap, $newString ) ;
            }
            if ( !defined @{$self->{FORMATSTRING}}[$i] )
            {
                @{$self->{FORMATSTRING}}[$i] = 0;
            }
            if ( length( $newString ) > @{$self->{FORMATSTRING}}[$i] && length( $newString ) < 200 )
            {
                @{$self->{FORMATSTRING}}[$i] = length( $newString );
            }
        }
    }
    return @headers;
}

sub formatFABRIC::printTableHeader(){
    my $self = shift;
    my $table = shift;
    my $rop = shift;
    #my $rrsSession = shift;
    @{$self->{FORMATSTRING}} = ();
    my $printer = $self->{PRINTER};
    $printer->{fh} = $self->{fh};

    my $name = ( defined $self->{table}->{max}?"Top $self->{table}->{max} ":"") .  $table->{name};

    #$printer->begin( (defined $self->{HTMLPATH}?$self->{HTMLPATH} . "dataseries/":""), $name . (defined $rop?' per_' . $rop:"") .'.', $rrsSession );
    $printer->begin( (defined $self->{HTMLPATH}?$self->{HTMLPATH} . "dataseries/":""), $name . (defined $rop?' per_' . $rop:"") .'.' );
    push ( @{$self->{TABLEAME}}, $printer->{TABLEAME} ) if defined $printer->{TABLEAME};
    my @headers;
    if ( defined $table->{GROUPBY} )
    {
        foreach my $groupBy ( keys %{$table->{TABLE_GROUPBY}} )
        {
            @headers = $self->getTableHeaderFormatString($table->{TABLE_GROUPBY}->{$groupBy}, $table)
        }
    }
    else
    {
        @headers = $self->getTableHeaderFormatString($table->{TABLE}, $table)
    }
    my $sprintf;

    my @header = ();
    my @ropHeaders = ();
    if ( defined $rop )
    {
        if ( defined $table->{GROUPBY} )
        {
            foreach my $ropHeader ( sort keys %{$table->{ROP_TABLE_GROUPBY}} )
            {
                if ( !defined $self->{fullHeader} && $ropHeader =~ /\S+?\s+(\S+)/ )
                {
                    ($printer->{format} ne "TEDB") ? (push(@headers,$1)) : (push(@ropHeaders,$1));
                }
                elsif ( defined $self->{fullHeader} && $ropHeader =~ /(\S+?)\s+(\S+)/ )
                {
                    ($printer->{format} ne "TEDB") ? (push(@headers,$1 . '_' . $2 )) : (push(@ropHeaders,$1 . '_' . $2));
                }
                else
                {
                    ($printer->{format} ne "TEDB") ? (push(@headers, $ropHeader)) : (push(@ropHeaders, $ropHeader));
                }
                push(@header,$ropHeader);
                push( @{$self->{FORMATSTRING}},1);
            }
        }
        else
        {
            foreach my $ropHeader ( sort keys %{$table->{ROP_TABLE}} )
            {
                if ( !defined $self->{fullHeader} && $ropHeader =~ /\S+?\s+(\S+)/ )
                {
                    ($printer->{format} ne "TEDB") ? (push(@headers, $1)) : (push(@ropHeaders, $1));
                }
                elsif ( defined $self->{fullHeader} && $ropHeader =~ /(\S+?)\s+(\S+)/ )
                {
                    ($printer->{format} ne "TEDB") ? (push(@headers,$1 . '_' . $2 )) : (push(@ropHeaders, $1 . '_' . $2));
                }
                else
                {
                    ($printer->{format} ne "TEDB") ? (push(@headers, $ropHeader)) : (push(@ropHeaders, $ropHeader));
                }
                push(@header,$ropHeader);
                push( @{$self->{FORMATSTRING}},1);
            }
        }
    }
    for( my $i=0; $i<@headers; $i++ )
    {
        $sprintf .= sprintf( '%-*s;', (@{$self->{FORMATSTRING}}[$i]+10), $headers[$i]);
    }
    if ( defined $sprintf )
    {
        if ($printer->{format} eq "TEDB"){
            my @tedbHeaders = @headers;
            if(!defined $table->{noCount}){
                shift @tedbHeaders;            #get rid of COUNT, if it exists.  It is not used in TEDB headers.
            }
            $printer->header( \@tedbHeaders, \@ropHeaders );
        } else {
            $printer->header( $sprintf, \@header );
        }
    }
}

sub formatFABRIC::printTableSimple(){
    my $self = shift;
    my $table = shift;
    my $rop = shift;
    #my $rrsSession = shift;
    my $printer = $self->{PRINTER};
    if ( !defined $table->{TABLE} )
    {
        return;
    }
    if ( defined $rop )
    {
        if ( defined $self->{table}->{TABLE} || defined $self->{table}->{TABLE_GROUPBY} )
        {
                #print "in printTableSimple, rop is DEFINED \n";
            $self->printTableHeader( $self->{table}, "rop" );
        }
        else
        {
            return;
        }
    }
    else
    {
        if ( defined $self->{table}->{TABLE} || defined $self->{table}->{TABLE_GROUPBY} )
        {
            #print "int printTableSimple, rop is UNDEFINED \n";
            $self->printTableHeader( $self->{table}, undef );
            #$self->printTableHeader( $self->{table}, undef, $rrsSession );
        }
        else
        {
            return;
        }
    }
    my $total = 0;
    my $totalAll = 0;
    my $numberOfSize;
    if ( !defined $table->{noCount} )
    {
        $numberOfSize = shift@{$self->{FORMATSTRING}};
    }
    my $maxCnt = 0;
    $sortingTable = $table->{TABLE};
    $sortMethod = $table->{sortMethod};
    #foreach my $key ( sort { $table->{TABLE}->{$b} <=> $table->{TABLE}->{$a} } keys %{$table->{TABLE}} )

    foreach my $key ( sort sorter keys %{$sortingTable} )
    {
        $maxCnt++;
        next if ( $key eq "TOTAL" );
        if ( !defined $table->{noTotal} )
        {
            $totalAll += $table->{TABLE}->{$key};
        }
        next if ( defined $self->{table}->{max} && $maxCnt > $self->{table}->{max}); ##Don't print anything since maxCnt was reached.
        my @strings = split( /;/, $key );
        if ( !defined $table->{noTotal} )
        {
            $total += $table->{TABLE}->{$key};
        }
        my @rops;
        if ( defined $rop )
        {
            foreach my $rop ( sort keys %{$table->{ROP_TABLE}} )
            {
                next if ( $rop eq "TOTAL" );
                push(@rops,($table->{ROP_TABLE}->{$rop}->{$key}?$table->{ROP_TABLE}->{$rop}->{$key}:0));
            }
        }
        my $numberOf = "";
        if ( !defined $table->{noCount} )
        {
            $numberOf = sprintf(  '%-*s;', ($numberOfSize+10), $table->{TABLE}->{$key} );
        }
        my $string = "";
        my $j =0;
        for(; $j<@strings; $j++ )
        {
            my ( $hashmap, $bitmap );
            my $newString = (defined $strings[$j]?$strings[$j]:'-');
            if( defined @{$table->{HEADER}}[$j] && defined $table->{HASHMAP}->{@{$table->{HEADER}}[$j]} )
            {
                $hashmap = $table->{HASHMAP}->{@{$table->{HEADER}}[$j]};
            }
            if ( defined $hashmap )
            {
                $newString = $newString . ' ' . lookupTables::decodeHASHMAP( $hashmap, $newString ) ;
            }
            if( defined @{$table->{HEADER}}[$j] && defined $table->{BITMAP}->{@{$table->{HEADER}}[$j]} )
            {
                $bitmap = $table->{BITMAP}->{@{$table->{HEADER}}[$j]};
            }
            if ( defined $bitmap )
            {
                $newString = $newString . ' ' . lookupTables::decodeBITMAP( $bitmap, $newString ) ;
            }
            $string .= sprintf( '%-*s;', (@{$self->{FORMATSTRING}}[$j]+10), $newString );
        }
        my $rop = "";
        for(my $i =0; $i<@rops; $i++ )
        {
            my $ropValue =     ($rops[$i]?$rops[$i]:0);
            $rop .= sprintf( '%-*s;', (@{$self->{FORMATSTRING}}[$j]+10), $ropValue );
            $j++;
        }
        $rop =~ s/;$//;
        #$printer->content( $numberOf, $string, $rop, $rrsSession);
        #$printer->content( $numberOf, $string, $rop );

        ################################################################
        ##=======================TEDB SECTION ========================##
        ################################################################
        if ($printer->{format} eq "TEDB"){
            if (defined $self->{dbsession}){
                $printer->content( $self->{dbsession}, $numberOf, \@strings, \@rops );
                my $tableNameExperiment=$printer->getTableName();
                $printer->{tableName}=$tableNameExperiment;
                $self->{tableName}=$tableNameExperiment;
            }
        } else {
            $printer->content( $numberOf, $string, $rop);
        }
        ################################################################
    }
    ##==============More TEDB======================##
    if ( $printer->{format} ne "FLOT" && $printer->{format} ne "TEDB"  && !defined $table->{noTotal} )
    {
        $printer->end("$total of $totalAll (TOTAL)----------------------------------");
        #$printer->content("$total (TOTAL)----------------------------------","","", $rrsSession);
    }
    else
    {
        $printer->end();
    }
    #$printer->end($rrsSession);
}

sub sorter
{
    if ( defined $sortMethod && $sortMethod == 1)
    {
        return $sortingTable->{$a} <=> $sortingTable->{$b};
    }
    elsif ( defined $sortMethod && $sortMethod == 2)
    {
        return lc$sortingTable->{$a} cmp lc$sortingTable->{$b};
    }
    else
    {
        return $sortingTable->{$b} <=> $sortingTable->{$a};
    }
}

sub formatFABRIC::printTableGroupBy(){
    my $self = shift;
    my $table = shift;
    my $rop = shift;
    #my $rrsSession = shift;
    my $printer = $self->{PRINTER};
    if ( !defined $table->{TABLE_GROUPBY} )
    {
        return;
    }
    if ( defined $rop )
    {
        $self->printTableHeader($self->{table},"rop");
    }
    else
    {
        #$self->printTableHeader($self->{table}, undef, $rrsSession);
        $self->printTableHeader($self->{table}, undef );
    }
    my $total = 0;
    my $totalAll = 0;
    my $maxCnt = 0;
    my $numberOfSize;
    if ( !defined $table->{noCount} )
    {
        $numberOfSize = shift@{$self->{FORMATSTRING}};
    }
    my $bitmap;
    my $hashmap;
    if ( defined $table->{BITMAP}->{$table->{GROUPBY}} )
    {
        $bitmap = $table->{BITMAP}->{$table->{GROUPBY}};
    }
    if( defined $table->{HASHMAP}->{$table->{GROUPBY}} )
    {
        $hashmap = $table->{HASHMAP}->{$table->{GROUPBY}};
    }
    foreach my $GroupBy ( sort { $table->{TABLE_GROUPBY}->{$b}->{TOTAL} <=> $table->{TABLE_GROUPBY}->{$a}->{TOTAL} } keys %{$table->{TABLE_GROUPBY}} )
    {
        my $newGroupBy = $GroupBy;
        if ( defined $bitmap )
        {
            $newGroupBy = $newGroupBy . ' ' . lookupTables::decodeBITMAP( $bitmap, $newGroupBy ) ;
        }
        if ( defined $hashmap )
        {
            $newGroupBy = $newGroupBy . ' ' . lookupTables::decodeHASHMAP( $hashmap, $newGroupBy ) ;
        }
        ####################################################
        ##============TEDB SECTION========================##
        ####################################################
        if ( $printer->{format} ne "FLOT" )
        {
            if ($printer->{format} eq "TEDB")
            {
                my $groupByIdentifier = $table->{GROUPBY};
                $printer->handleGroupBys($groupByIdentifier, $newGroupBy);
            }
            elsif ( defined $self->{table}->{max} && $maxCnt >= $self->{table}->{max} )
            {
                ##Do nothing there should be no more printing since the maxCnt was reached. The script will now count the rest of the messages.
               }
            else
            {
                $printer->content( "$newGroupBy ($table->{TABLE_GROUPBY}->{$GroupBy}->{TOTAL})","","" );
                #$printer->content( "$newGroupBy ($table->{TABLE_GROUPBY}->{$GroupBy}->{TOTAL})","","", $rrsSession);
            }
        }
        next if ( $GroupBy eq "TOTAL" );

        $maxCnt++;
        $sortingTable = $table->{TABLE_GROUPBY}->{$GroupBy};
        $sortMethod = $table->{sortMethod};
        foreach my $key ( sort sorter keys %{$sortingTable} )
        #foreach my $key ( sort { $table->{TABLE_GROUPBY}->{$GroupBy}->{$b} <=> $table->{TABLE_GROUPBY}->{$GroupBy}->{$a} } keys %{$table->{TABLE_GROUPBY}->{$GroupBy}} )
        {

            next if ( $key eq "TOTAL" );
            my @strings = split( /;/, $key );
            $totalAll += $table->{TABLE_GROUPBY}->{$GroupBy}->{$key};
            next if ( defined $self->{table}->{max} && $maxCnt > $self->{table}->{max} ); ## Don't print anything else since maxCnt was reached. Return since the numbers of messages have benn counted.
            $total += $table->{TABLE_GROUPBY}->{$GroupBy}->{$key};
            my @rops;
            if ( defined $rop )
            {
                foreach my $rop ( sort keys %{$table->{ROP_TABLE_GROUPBY}} )
                {
                    push( @rops, ($table->{ROP_TABLE_GROUPBY}->{$rop}->{$GroupBy}->{$key}?$table->{ROP_TABLE_GROUPBY}->{$rop}->{$GroupBy}->{$key}:0) );
                }
            }
            my $numberOf = "";
            if ( !defined $table->{noCount} )
            {
                $numberOf = sprintf(  '%-*s;', ($numberOfSize+10), $table->{TABLE_GROUPBY}->{$GroupBy}->{$key} );
            }
            my $string = "";
            my $j =0;
            for(; $j<@strings; $j++ )
            {
                my ( $hashmap, $bitmap );
                my $newString = ($strings[$j]?$strings[$j]:'-');
                if( defined @{$table->{HEADER}}[$j] && defined $table->{HASHMAP}->{@{$table->{HEADER}}[$j]} )
                {
                    $hashmap = $table->{HASHMAP}->{@{$table->{HEADER}}[$j]};
                }
                if ( defined $hashmap )
                {
                    $newString = $newString . ' ' . lookupTables::decodeHASHMAP( $hashmap, $newString ) ;
                }
                if( defined @{$table->{HEADER}}[$j] && defined $table->{BITMAP}->{@{$table->{HEADER}}[$j]} )
                {
                    $bitmap = $table->{BITMAP}->{@{$table->{HEADER}}[$j]};
                }
                if ( defined $bitmap )
                {
                    $newString = $newString . ' ' . lookupTables::decodeBITMAP( $bitmap, $newString ) ;
                }
                $string .= sprintf( '%-*s;', (@{$self->{FORMATSTRING}}[$j]+10), $newString );
                #$string .= sprintf( '%-*s;', (@{$self->{FORMATSTRING}}[$j]+10), ($strings[$j]?$strings[$j]:'-') );
            }
            my $rop = "";
            for(my $i =0; $i<@rops; $i++ )
            {
                $rop .= sprintf( '%-*s;', (@{$self->{FORMATSTRING}}[$j]+10), ($rops[$i]?$rops[$i]:0) );
                $j++;
            }
            if ( $printer->{format} eq "FLOT" )
            {
                $string = $GroupBy . ' - ' . $string;
            }
            $rop =~ s/;$//;
            ################################################################
            ##=======================TEDB SECTION ========================##
            ################################################################
            if ($printer->{format} eq "TEDB")
            {
                if (defined $self->{dbsession})
                {
                    $printer->content( $self->{dbsession}, $numberOf, \@strings, \@rops );
                    my $tableNameExperiment=$printer->getTableName();
                    $printer->{tableName}=$tableNameExperiment;
                }
            }
            else
            {
                $printer->content( $numberOf, $string, $rop);
                #$printer->content( $numberOf, $string, $rop, $rrsSession);
            }
            ################################################################
        }
    }
    ##=================modified for TEDB=====================##
    if ( $printer->{format} ne "FLOT" && $printer->{format} ne "TEDB" && !defined $table->{noTotal} )
    {
            #$printer->content("$total (TOTAL)----------------------------------","","", $rrsSession);
        $printer->end("$total of $totalAll (TOTAL)----------------------------------");
    }
    else
    {
        $printer->end();
        #$printer->end($rrsSession);
    }
}

1;
