package formatHTML;

use strict;
use locale;
use Data::Dumper;
sub formatHTML::new() {
  my $class = shift;
  my %self = @_;
  $self{Id} = 0;
  $self{format} = "HTML";
  return bless \%self;
}


sub formatHTML::mainHeader(){
    my $self = shift;
    my $nodes = shift;
    my $version = shift;
    my $start = shift;
    my $last = shift;
    my $duration = shift;
    my $cv = shift;
    my $comment = shift;
    my $xmlfile = shift;
    my $configfile = shift;
    my $eventSupport = shift;
    my $filter = shift;
    my $extraLinks = shift;

    if ( defined $configfile )
    {
        $configfile = "config file: $configfile <br>\n";
    }
    else
    {
        $configfile = "";
    }
    if ( $cv )
    {
        $cv .= " <br>\n";
    }
    else
    {
        $cv = "";
    }
    if ( $comment )
    {
        $comment .= " <br>\n";
    }
    else
    {
        $comment = "";
    }

    if ( !defined $start )
    {
        $start = "";
    }
    if ( !defined $last )
    {
        $last = "";
    }
    if ( !defined $start )
    {
        $duration = "";
    }
    if ( defined $self->{error} )
    {
        return;
    }

    my $event = "";
    if ( defined $eventSupport )
    {
        $event = 'eventSupport:1';
    }
    my $headerstart = <<HTMLINFO;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>

    <link rel="stylesheet" type="text/css" href="style.css" />
    <link rel="stylesheet" type="text/css" href="newStyle.css" />
    <script type="text/javascript" src="jquery-1.10.2.js"></script>
    <script type="text/javascript" src="jquery.flot.js"></script>
    <script type="text/javascript" src="jquery.tablesorter.js"></script>
    <script type="text/javascript" src="jquery.flot.selection.js"></script> <!--Do not change src to https://wcdma-iov.rnd.ki.sw.ericsson.se/lib/jquery-->
    <script type="text/javascript" src="jquery.flot.time.js"></script>
    <script type="text/javascript" src="jquery.flot.symbol.js"></script>
    <script type="text/javascript" src="jquery.flot.resize.js"></script>
    <script type="text/javascript" src="jquery.flot.tooltip.min.js"></script>
    <script type="text/javascript" src="utilities.js"></script>
    <script type="text/javascript" src="eGraphs.js"></script>

    <script> var myConfig = {$event};  </script>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        <title>$nodes teSummary.pl html report</title>
    </head>
    <body>
        <div id="infobox">
        </div>
        <div id="header">
            <img style="float:left;" src="images/ericsson_logo.gif">
            <div>
                Generated by teSummary v$version<br>
                Log file Starts at: $start<br>
                Log file Ends at: $last<br>
                Log file Duration: $duration<br>
                Nodes:$nodes<br>$cv<br>$comment
                table file: $xmlfile<br>
                $configfile<br>
                <!--$filter-->

HTMLINFO
if (defined $extraLinks){
    $headerstart .= $extraLinks;
}

my $headerEnd = <<HTMLENDING;
                                 <!--<li><a href="javascript:void(0)" onclick="createReport();"> Create static HTML report</a></li>-->
            </div>
            <p>Author: Martin Aldrin,Henrik Schüller</p>
        </div>
        <hr>
HTMLENDING

my $header=$headerstart.$headerEnd;

    $self->printer($header);
}

sub formatHTML::mainContent(){
    my $self = shift;
    my $tablename = shift;
    return if !defined @{$tablename}[0];
    $self->printer( "\t\t" . '<table>' );
    $self->printer( "\t\t\t" . '<tr>' );
    $self->printer( "\t\t\t\t" . '<td class="fixedW">' );
    my $string = "\t\t\t\t\t" . @{$tablename}[0] . "</td>\n";
    $string   .= "\t\t\t\t\t" . '<td><a name="' . @{$tablename}[0] . '" class="ropTableLink" href="#' . @{$tablename}[0] . '"> Summary,</a>';
    if ( defined @{$tablename}[1] && defined @{$tablename}[2])
    {
        $string .= "\n\t\t\t\t\t" .'<a name="' . @{$tablename}[1] . '" class="ropTableLink" href="javascript:void(0)"> per rop,</a>';
        $string .= "\n\t\t\t\t\t" .'<a onclick ="toggleChart(' ."'" . @{$tablename}[2] . "'" . ');return false;" href="javascript:void(0);"> graph </a>';
        #$string .= "\n\t\t\t\t\t\t" . '<div id="wrapper_' . @{$tablename}[2] . '" style="display:none">' . '</div>';
    }
    elsif ( defined @{$tablename}[1] )
    {
          $string .= "\n\t\t\t\t\t" .'<a name="' . @{$tablename}[1] . '" class="ropTableLink" href="javascript:void(0)"> per rop,</a>';
    }
    $string .= "\n\t\t\t\t\t" . "</td></tr>";
    $self->printer( $string );
    $self->printer( "\t\t\t\t" . '</td>' );
    $self->printer( "\t\t\t" . '<tr>' );
    $self->printer( "\t\t" . '</table>' );

    if ( defined @{$tablename}[2] )
    {
        $self->printer( "\t\t" . '<div id="wrapper_' . @{$tablename}[2] . '" class="wrapperdiv">' . '</div>' );
    }
    $self->printer( "\t\t" . '<div class="ropTable" id="table_' . @{$tablename}[0] . '" style="display: none; ' . '"></div>' );
    if ( defined @{$tablename}[1] )
    {
        $self->printer( "\t\t" . '<div class="ropTable" id="table_' . @{$tablename}[1] . '" style="display: none; ' . '"></div>' );
    }
}

sub formatHTML::mainEnd(){
    my $self = shift;
    my $string = <<HTMLEND;
    </body>
</html>
HTMLEND
    $self->printer( $string );
}

sub formatHTML::begin(){
    my $self = shift;
    my $path = shift;
    my $fileName = shift;
    $fileName =~ s/\s+/_/g;
    $fileName =~ s/\.//g;
    $fileName =~ s/\,//g;
    $fileName =~ s/\(//g;
    $fileName =~ s/\)//g;

    $self->{TABLEAME} = $fileName;
    my $file = $path . $fileName . '.html';
    my $fh;
    open $fh, ">$file" or print "couldn't open FileHandle for file: $file\n";
    $self->{OPENEDHANDLE} = $fh;

}

sub formatHTML::header(){
    my $self = shift;
    my $header = shift;
    if ( defined $self->{error} )
    {
        return;
    }
    my $fileName = $self->{TABLEAME};

    $self->printer( '<table  class="sortable" id="' . $fileName . '">'  );
    $self->printer( '<caption>' . $fileName . '</caption>'  );
    my @values = split( ';', $header );
    $self->printer( "\t" . '<thead>' );
    $self->printer( "\t\t" . '<tr class="headrow">' );
    foreach my $head (<@values>)
    {
        $self->printer( "\t\t" . '<th class="header">' . $head . '</th>' );
    }
    $self->printer( "\t\t" . '</tr>');
    $self->printer( "\t" . '</thead>' );
    $self->printer( "\t" . '<tbody>' );
#    $self->printer( "\t\t" . '<tr>' );
}

sub formatHTML::content(){
    my $self = shift;
    my ( $numberOf, $string, $rops ) = @_;
    $string = $numberOf . $string . $rops;

    if ( defined $self->{error} )
    {
        return;
    }
    $self->printer( "\t\t\t" . '<tr>' );
    my @row = split( ';', $string );
    for( my $i=0; $i<@row; $i++ )
    {
        my $td = $row[$i];
        $td =~ s/\s+/ /;
        $td =~ s/\s+$//;
        $td =~ s/^\s+//;
        $td =~ s/\e//g;
        $td =~ s/\[\d+m//g;
        my $string="";
        if ( $i==1 )
        {
            $string = " class='formula' id='$self->{Id}'";
        }
        next if $td eq "";
        $self->printer( "\t\t\t\t" . '<td'.$string.'>' . $td . '</td>' );
        $self->{footer} = $td if $td=~/TOTAL/;
    }
    $self->printer( "\t\t\t" . '</tr>' );
    $self->{Id}++;
}

sub formatHTML::end(){
    my $self = shift;
    my $total = shift;
    if ( defined $self->{error} )
    {
        return;
    }
    my $fh = $self->{OPENEDHANDLE};

    $self->printer( "\t\t" . '</tr>' );
    $self->printer( "\t" . '</tbody>' );
    if ( defined $total ) {
        $self->printer( "\t" . '<tfoot>' );
        $self->printer( "\t\t\t\t" . '<td>' . $total . '</td>' );
        $self->printer( "\t" . '</tfoot>' );
    }
    $self->printer( '</table>' );

    close $fh;
}

sub formatHTML::printer(){
    my $self = shift;
    my $string = shift;
    if ( defined $self->{error} )
    {
        return;
    }
    my $fg = $self->{OPENEDHANDLE};
    print $fg "$string\n";
}


1;
