package lookupTables;
use strict;
my $laban;
sub defineTables {
    my $conf    = shift;
    my @GCPbits = (
        'CPM DL',                           # 0x0001
        'CPM UL',                           # 0x0002
        'EUL 2ms TTI',                      # 0x0004
        'Flexible PDU Format',              # 0x0008
        '64 QAM',                           # 0x0010
        'AMR-NB MM/MR',                     # 0x0020
        'AMR-NB MM/SR',                     # 0x0040
        'MIMO',                             # 0x0080
        'SRBonHS',                          # 0x0100
        'SRBonEUL',                         # 0x0200
        'Multi-Carrier',                    # 0x0400
        'High Speed Downlink for FACH',     # 0x0800
        'CPC for battery',                  # 0x1000
        'Dual-Band HSDPA Multi-Carrier',    # 0x2000
        'Battery Efficiency',               # 0x4000
        'Improved Layer2 Support',          # 0x8000
        'Enhanced Uplink for FACH UL',                    # 0x10000
        'iuUpVersion DL&UL',                # 0x20000
        'Dynamic RLC Parameter Configuration DL&UL',                           # 0x40000
        'Improved MAC-is/es Re-ordering UL',                            # 0x80000
        'eul Multi-Carrier UL, spare bit'                            # 0x100000
    );
    $conf->{gcpTable} = \@GCPbits;

    my %AdmissionCauses = (
        '1' => 'RnhIfCellControlP.admissionRej cause of Congestion',
        '2' => 'AseUl - Admission limit for UL ASE exceeded',
        '3' => 'AseDl - Admission limit for DL ASE exceeded',
        '4' => 'DlPwr',
        '5' => 'DlCodeAdm',
        '6' => 'SF8',
        '7' => 'SF16',
        '8' => 'SF32',
        '9' => 'CompModeLimit',
        '10'=> 'CellDeactivated',
        '11'=> 'RoutingFailure',
        '12'=> 'LoadSharing',
        '13'=> 'UniSaalCongestion',
        '14'=> 'RbsUlHwResources',
        '15'=> 'RbsDlHwResources',
        '16'=> 'PhysHsChanLimit',
        '17'=> 'SF4UL',
        '18'=> 'SF8UL',
        '19'=> 'SF16UL',
        '20'=> 'SF8gUL',
        '21'=> 'SF16g',
        '22'=> 'EdchLimitServingCell',
        '23'=> 'EdchLimitNonServingCell',
        '24'=> 'SctpCongestion',
        '25'=> 'Edch2msLimitServingCell',
        '26'=> 'DlIubGbrBw',
        '27'=> 'UlIubGbrBw',
        '28'=> 'DlCodeTree',
        '29'=> 'eulRateCongestion',
        '30'=> 'eulRateCongestionNoReattempt',
        '31'=> 'SF128',
        '32'=> 'SF64UL',
        '33'=> 'hsdpaUsersOffloadLimit',
        '34'=> 'dlPowerOffloadLimit',
        '35'=> 'dlCodeOffloadLimit',
    );
    $conf->{AdmissionCauses} = \%AdmissionCauses;
    my %ueRcStates = (
        0   => 'Idle',
        1   => 'Standalone RRC on DCH',
        2   => 'Speech',
        3   => '64kbps CS data, fixed rate',
        4   => 'Packet RACH/FACH',
        5   => 'PACKET 64/64',
        6   => 'Packet 64/128',
        7   => 'Packet 64/384',
        8   => '57kbps CS data, variable rate',
        9   => 'Speech + Packet 0kbps',
        10  => 'Speech + Packet 64kbps',
        11  => 'Pre-configured RRC only',
        12  => 'Pre-configured Speech',
        13  => 'PS Streaming 16/64 + Packet 8kbps',
        14  => 'CS data 64kbps + Packet 8/8',
        15  => 'PS Interactive 64/HS - HS-DSCH',
        16  => 'PS Interactive 384/HS - HS-DSCH',
        17  => 'PS Streaming 16/128 + Packet 8kbps',
        18  => 'Packet 128/128',
        19  => 'Speech+PS Interactive 64/HS',
        20  => 'Speech+PS Interactive 384/HS',
        21  => 'Packet_URA_PCH',
        22  => 'PS Streaming 128/16 + PS Interactive 8/8',
        23  => 'Speech + PS Streaming 128/16 + PS Interactive 8/8',
        24  => 'Speech + PS Streaming 16/128 + PS Interactive 8/8',
        25  => 'PS Interactive EUL/HS',
        26  => 'PS Interactive 64/64 + PS Interactive 64/64',
        27  => 'Speech 12200+PS Interactive 64/64 + PS Interactive 64/64 parameter',
        28  => 'Packet 128/64',
        29  => 'Packet 384/64',
        30  => 'Packet 384/128',
        31  => 'Packet 128/384',
        32  => 'Packet 384/384',
        33  => 'AMR7950 Speech RAB on DCH',
        34  => 'AMR5900 Speech RAB on DCH',
        35  => 'AMR4750 Speech RAB on DCH',
        36  => 'Speech 12200+PS Interactive 64/128',
        37  => 'Speech 12200+PS Interactive 128/64',
        38  => 'Speech 12200+PS Interactive 64/384',
        39  => 'PS Interactive 64/128+PS Interactive 64/128',
        40  => 'AMRWB 12650 Speech RAB on DCH',
        41  => 'PreConfigured AMRWB 12650 Speech RAB on DCH',
        42  => 'AMRWB 12650 Speech RAB + PS Interactive 0/0',
        43  => 'AMRWB 12650 Speech RAB + PS Interactive 64/64',
        44  => 'AMRWB 12650 Speech RAB + PS Interactive 64/128',
        45  => 'AMRWB 12650 Speech RAB + PS Interactive 128/64',
        46  => 'PS Streaming 128/HS + PS Interactive 8/HS',
        47  => 'AMRWB 12650 Speech RAB + PS Interactive 64/HS',
        48  => 'AMRWB 12650 Speech RAB + PS Interactive 384/HS',
        49  => 'PS Streaming 128/HS + PS Interactive 8/HS + CS Speech 12.2',
        50  => 'AMRWB 12650 Speech RAB +PS Streaming 16/128+PS Interactive 8/8',
        51  => 'AMRWB 12650 Speech RAB + PS Interactive 64/64+ PS Interactive 64/64',
        52  => 'Interact. PS (128/HS)',
        53  => 'PS Interactive 16/HS',
        54  => '2* Interact. PS (64/HS)',
        55  => '2* Interact. PS (128/HS)',
        56  => '2* Interact. PS (384/HS)',
        57  => 'Conv. CS speech 12.2 + 2* Interact. PS (64/HS)',
        58  => 'Conv. CS speech 12.2 + 2* Interact. PS (128/HS)',
        59  => 'Conv. CS speech 12.2 + 2* Interact. PS (384/HS)',
        60  => 'Conv. CS speech 12.2 + Interact. PS (128/HS)',
        61  => 'Conv. CS Speech 12.2 + 3* Interact. PS (64/HS)',
        62  => '2* Interact. PS (EUL/HS)',
        63  => 'Stream. PS (16/HS) + 2* Interact. PS (64/HS)',
        64  => 'Conv. CS Speech 12.2 + Stream. PS (16/HS) + 2*Interact. PS (64/HS)',
        65  => 'Conv CS Speech 12.2 + Stream. PS (128/HS) + 2*Interact. PS (64/HS)',
        66  => '3* Interact. PS (64/HS)',
        67  => 'PS Interactive 16/16',
        68  => 'PS Interactive 16/64',
        69  => 'PS Interactive 64/16',
        70  => 'Dummy instance',
        71  => 'Speech 12200 + 3 X PS Interactive 64/64',
        72  => 'PS Streaming 16/HS + PS Interactive 8/HS',
        73  => 'PS Streaming 32/HS + PS Interactive 8/HS',
        74  => 'PS Interactive 64/64 + PS Interactive 64/64 + PS Interactive 64/64',
        75  => 'Stream. PS (128/HS) + 2*Interact. PS (64/HS)',
        76  => 'Speech 12200 + PS Interactive 128/128 + PS Interactive 128/128',
        77  => 'PS Streaming 16/HS + PS Interactive 8/HS + CS Speech 12.2',
        78  => 'PS Streaming 32/HS + PS Interactive 8/HS + CS Speech 12.2',
        79  => 'Conv. CS speech (5.9, 4.75/5.9, 4.75) + SRB (3.4/3.4)',
        80  => 'Conv. CS speech (5.9, 4.75/5.9, 4.75) + Interact. PS (0/0) + SRB (3.4/3.4)',
        81  => 'Idle',
        82  => 'Idle',
        83  => 'Idle',
        84  => 'Idle',
        85  => 'Idle',
        86  => 'Idle',
        87  => 'Idle',
        88  => 'Idle',
        89  => 'Idle',
        90  => 'Idle',
        91  => 'Idle',
        92  => 'Idle',
        93  => 'Idle',
        94  => 'Instance for standalone RRC on DCH',
        95  => 'Instance for Pre-Configured RRC only on DCH',
        96  => 'Idle',
        97  => 'Idle',
        98  => 'Idle',
        99  => 'Idle',
        100 => 'Idle',
        101 => 'Idle',
        102 => 'Idle',
        103 => 'Idle',
        104 => 'Idle',
        105 => 'Idle',
        106 => 'Idle',
        107 => 'Idle',
        108 => 'Idle',
        109 => 'Idle',
        110 => 'Idle',
        111 => 'Idle',
        112 => 'Idle',
        113 => 'Conv. CS Speech (12.2, 7.95, 5.9, 4.75) + Interact. PS (16/HS)',
        114 => 'Idle',
        115 => 'Idle',
        116 => 'Idle',
        117 => 'Idle',
        118 => 'Idle',
        119 => 'Idle',
        120 => 'Idle',
        121 => 'Idle',
        122 => 'Idle',
        123 => 'Conv. CS Speech 12.2  + Interact. PS (EUL/HS)',
        124 => 'Conv. CS Speech 12.2  + 2 * Interact. PS (EUL/HS)',
        125 => 'Conv. CS Speech 12.2  + 3 *  Interact. PS (EUL/HS)',
        126 => 'Idle',
        127 => 'Idle',
        128 => '3 *  Interact. PS (EUL/HS)',
        129 => 'Idle',
        130 => 'Idle',
        131 => 'Idle',
        132 => 'Idle',
        133 => 'Idle',
        134 => 'Idle',
        135 => 'Idle',
        136 => 'Idle',
        137 => 'Idle',
        138 => 'Idle',
        139 => 'Idle',
        140 => 'Idle',
        141 => 'Idle',
        142 => 'Idle',
        143 => 'Idle',
        144 => 'Idle',
        145 => 'Idle',
        146 => 'Idle',
        147 => 'Idle',
        148 => 'Idle',
        149 => 'Idle',
        150 => 'Idle',
        151 => 'Idle',
        152 => 'Idle',
        153 => 'Idle',
        154 => 'Idle',
        155 => 'Idle',
        156 => 'Idle',
        157 => 'Idle',
        158 => 'Idle',
        159 => 'Idle',
        160 => 'Idle',
        161 => 'Idle',
        162 => 'Idle',
        163 => 'Idle',
        164 => 'Idle',
        165 => 'Idle',
        166 => 'Idle',
        167 => 'Idle',
        168 => 'Idle',
        169 => 'Idle',
        170 => 'Idle',
        171 => 'Idle',
        172 => 'Idle',
        173 => 'Idle',
        174 => 'Idle',
        175 => 'Idle',
        176 => 'Conv. CS Speech (5.9, 4.75/5.9,4.75)  +  Interact. PS (EUL/HS)',
    );
    $conf->{ueRcStates} = \%ueRcStates;
}

sub decodeBITMAP {
    my $table      = shift;
    my $gcpVal     = $_[0];
    my $currbitpos = 0;
    my @setBits;
    my $tmp = $gcpVal;
    return ''if ( $gcpVal !~ /^[01]+$/ );
    while ( int($gcpVal) )
    {
        push( @setBits, $currbitpos )
      if substr( $gcpVal, length($gcpVal) - 1 );    #remember position if this bit is set
        $currbitpos++;

        my $l = length($gcpVal) -1;
        #print "'$tmp',pos:$currbitpos, bits: '@setBits', l:$l, gcpVal: '$gcpVal'\n";
        if ( $l > 0 )
        {
            $gcpVal = substr( $gcpVal, 0, $l )
        }
        else
        {
            last;
        }
    }
    return ''unless @setBits;                          #only add decode string if any bits are set
    return '('. join( ',', map { @{$table}[$_] } @setBits ) . ')';
}

sub decodeHASHMAP {
    my $table = shift;
    my $val   = shift;
    if ( defined $table->{$val} ) {
        return '(' . $table->{$val} . ')';
    }
    return '';

}

1;
