package MoshellAPI;
$| = 1;    #don't buffer output
require Exporter;
use Data::Dumper;

@ISA = qw(Exporter);
@EXPORT =
    qw(  startMOShell closeMOShell loadAllProxies getProxy getLdn getLdnforProxy doCommand createMo deleteMo getProxyAttribute LoadMO);

#Version History.
#v1.0    2008-04-15    Martin Aldrin    - First Release.

use Expect;    #http://search.cpan.org/~rgiersig/Expect-1.15/Expect.pod
use strict;
use warnings;

my $loging = 0;
my $debug  = 0;
my @match_pol;

#my $MOSHELL_TIMEOUT;
my $global_logUser = 0;
my $global_development;
my $counter = 0;
my $last_commnd;
my $multiple_run;

my $ESCAPE_CHAR =
    "\001\e[0m\002>";    #new prompt in moshell 9.0y = \001\e[0m\002>
my $ESCAPE_CHAR_OLD = "\e[0m>";    # old prompt before 9.0y = \e[0m

sub printout
{
    my ( $moshell_handle, $logUser ) = @_;
    if ( $logUser && !$multiple_run )
    {
        $moshell_handle->log_user(1);
        $moshell_handle->log_stdout(1);
    }
    else
    {
        $moshell_handle->log_user(0);
        $moshell_handle->log_stdout(0);
    }

}

sub moperlLogingOn
{
    $loging = 1;
}

sub moperlLogingOff
{
    $loging = 0;
}

sub logwrite
{
    my ($logMsg) = shift;
    if ($loging)
    {
        print "$logMsg\n";
    }
}

sub progresswrite
{
    my ($logMsg) = shift;
    print "$logMsg\n";
}

sub debuglogwrite
{

    my ($logMsg) = shift;
    if ( $debug == 1 )
    {
        print "Debug: $logMsg\n";
    }
}

sub thread_printout
{
    $multiple_run = shift;

}

########################### START MOSHELL ##############################
#$obj = MoshellAPI->new("ip","password","printout","moshell path","timeout","command");
#Default timeout is 600.
#Default moshell path is not "/vobs/iov/wcdma/bin/moshell" anymore.
#
########################################################################

sub new
{
    my $class = shift;
    my ( $ip, $password, $logUser, $moshell, $timeout, $command ) = @_;
    $class->new2( ip       => $ip,
                  password => $password,
                  logUser  => $logUser,
                  moshell  => $moshell,
                  timeout  => $timeout,
                  command  => $command );
}
########################### START MOSHELL ##############################
#$obj = MoshellAPI->new2( ip => $config_hash->{ip}, password => $config_hash->{pw}, debug => $config_hash->{debug}, moshell => $config_hash->{moshell}, timeout => $config_hash->{mostimeout} );
#Default timeout is 600.
#Default moshell path is not "/vobs/iov/wcdma/bin/moshell" anymore.
#
########################################################################
sub new2
{
    my $class = shift;
    my %input = @_;

    my $ip           = $input{ip};
    my $password     = $input{password};
    my $logUser      = $input{logUser};
    my $moshell_path = $input{moshell};
    my $timeout      = $input{timeout};
    my $command      = $input{command};
    my $silent       = $input{silent};
    my $logFile      = $input{logFile};
    my $prompt       = ( defined $input{prompt} ? $input{prompt} : $ip );

    my $moDump;
    if ( -e $ip )
    {
        $moDump = 1;
        $prompt = "OFFLINE_DUMP";
    }

    my $setPrompt = $prompt;
    my @prompts = ( $prompt . $ESCAPE_CHAR, $prompt . $ESCAPE_CHAR_OLD );

    $global_development = $input{development} if defined $input{development};

    my $default_input_options =
        "prompt_highlight=1,set_window_title=1,prompt_color=1,mosdebug=0";
    if ( defined $input{param} )
    {
        $input{param} = "," . $input{param} if $input{param} !~ /^,/;
        $default_input_options .= $input{param};
    }
    if (    defined $input{password}
         && $input{password} !~ /^\s*$/
         && $input{password} ne "nopass" )
    {
        $default_input_options .= ",password=$input{password}";
    }

    if ( !defined $ip ) { return undef; }

    if ( !defined $input{timeout} ) { $input{timeout} = 600; }

    if ( !defined $input{moshell} ) { $input{moshell} = "moshell"; }

    if ( system("type $input{moshell} &> /dev/null") )
    {
        print STDOUT "Cannot find $input{moshell}\n";
        progresswrite("Cannot find $input{moshell}");
        logwrite("Cannot find $input{moshell}");
        return undef();
    }
    logwrite("Spawning moshell...");

    my $handle = new Expect;
    if ( defined $logFile )
    {
        `touch $logFile`;
        `chmod 664 $logFile`;
        $handle->log_file( $logFile, "w" );
    }
    print "$input{moshell} -v $default_input_options $ip\n"
        if ( defined $input{logUser} && $input{logUser} == 1 );
    $handle->spawn("$input{moshell} -v $default_input_options $ip");
    if ( defined $input{logUser} && $input{logUser} == 1 )
    {
        printout( $handle, 1 );
        $global_logUser = 1;
    }
    else
    {
        printout( $handle, 0 );
    }

    $handle->send("p $setPrompt\n");

    if ( !defined $moDump )
    {
        my ( $matched_pattern_position, $error, $successfully_matching_string,
             $before_match, $after_match )
            = $handle->expect( 60, @prompts );
        if ( defined $error && $error =~ /TIMEOUT/i )
        {
            print "error: $error\n" if ( !$input{silent} );
            return undef;
        }
        elsif ( defined $before_match
                && $before_match =~ /Unable to connect to $ip:22/ )
        {
            print "Unable to connect to $ip:22\n" if ( !$input{silent} );
            return undef;
        }
        elsif ( defined $before_match
                && $before_match =~ /Checking ip contact...Not OK/ )
        {
            print "Checking ip contact... $ip Not OK\n" if ( !$input{silent} );
            return undef;
        }
        elsif ( defined $before_match
                && $before_match =~ /Cannot connect to MO service, exiting/ )
        {
            print "Cannot connect to MO service, exiting ip: $ip\n"
                if ( !$input{silent} );
            return undef;
        }
        elsif ( defined $before_match && $before_match =~ /port 80 not OK/ )
        {
            print "Cannot connect to MO service, exiting ip:$ip\n"
                if ( !$input{silent} );
            return undef;
        }
        elsif ( defined $before_match
                && $before_match =~ /connection timed out/ )
        {
            print "connection timed out ip:$ip\n" if ( !$input{silent} );
            return undef;
        }
    }

    #Disable Confirmations
    $handle->send("Confbld+\n");
    $handle->expect( $input{timeout}, @prompts );

    if ( defined $command )
    {
        #Send command
        $handle->send("$command\n");
        $handle->expect( $input{timeout}, @prompts );
    }

    my $self = { ip       => $ip,
                 password => $input{password},
                 logUser  => $input{logUser},
                 moshell  => $input{moshell},
                 timeout  => $input{timeout},
                 prompt   => \@prompts,
                 handle   => $handle };

    bless( $self, $class );
    $self->{handle}->clear_accum();
    $self->{handle}->expect( 2, @prompts );
    return $self;

}

############################ SEND COMMAND ##############################
#doCommand
#$res = $obj->doCommand("match string","Print out","command");
#Default matchstring is "ip>"
#
#Example with prompts.
#$res = $obj->doCommand(undef,undef,"acc 0 manualrestart","0","0","API TEST");
########################################################################

sub doCommand
{
    my $self    = shift;
    my $output  = shift;
    my $logUser = shift;
    my $cmd     = shift;
    my @prompts = @_;

    $self->doCmd( output  => $output,
                  loguser => $logUser,
                  cmd     => $cmd,
                  prompts => \@prompts );
}

sub doCmd
{
    my $self = shift;
    my %hash = @_;

    my $output  = $hash{output};
    my $logUser = $hash{loguser};
    my $cmd     = $hash{cmd};
    my $timeout = ( $hash{timeout} ? $hash{timeout} : $self->{timeout} );
    my @prompts = @{ $hash{prompts} } if defined $hash{prompts};
    my $outfile = $hash{outfile} if defined $hash{outfile};

    my $prompt = $self->{prompt};
    $logUser = undef if ( $logUser eq "debug" );
    my $devfile;

    if ( defined $hash{development} || defined $global_development )
    {
        $hash{development} = $global_development
            if !defined $hash{development};

        if ( -d $hash{development} )
        {
            if ( $cmd =~ /^lt/ )
            {
                $hash{development} = undef;
            }
            else
            {
                my ($cmdtmp) =
                    $cmd . ( defined $prompts[0] ? "_@prompts" : '' );
                $cmdtmp =~ s/\s+/_/g;
                $cmdtmp =~ s/\-/_/g;
                $cmdtmp =~ s/\//__/g;
                $cmdtmp =~ s/\!/_/g;
                $cmdtmp =~ s/\=/_/g;
                $cmdtmp =~ s/\$//g;
                $cmdtmp =~ s/\^//g;
                $cmdtmp =~ s/\|//g;
                $devfile =
                      $hash{development} . '/'
                    . $self->{ip} . '_'
                    . $cmdtmp . '.log';
            }
        }
        else
        {
            $hash{development} = undef;
        }
    }
    my ( $matched_pattern_position, $error, $successfully_matching_string,
         $before_match, $after_match );

    if ( defined $devfile && -e $devfile )
    {
        $before_match = $self->read_logfile($devfile);
        print $before_match if ( $logUser == 1 );
    }
    else
    {
        my $i = 0;
        my ($res) = undef;
        $cmd .= "\n";
        if ( defined $prompts[$i] )
        {
            foreach (@prompts)
            {
                if ( !defined $prompts[$i] ) { last; }
                if ( $prompts[$i] ne "" )
                {
                    $cmd .= "$prompts[$i]\n";
                }
                $i++;
            }
        }
        my $exitstatus = $self->{handle}->exitstatus();
        if ( defined $exitstatus ) { return "ERROR: $exitstatus"; }
        $self->{handle}->clear_accum();
        printout( $self->{handle}, 1 ) if ( $logUser == 1 );
        $self->{handle}->send($cmd);
        $last_commnd = $cmd;
        (  $matched_pattern_position, $error, $successfully_matching_string,
           $before_match, $after_match )
            = $self->{handle}->expect( $timeout, @$prompt );
        printout( $self->{handle}, $global_logUser )
            if ( $logUser == 1 );    #set back logUser to default.
        $before_match =~ s/\[\d+m//g;
	$before_match =~ s/\[\?1034h//g;
        $before_match =~ s/(\001|\002)//g;
        $before_match =~ s/\e//g;
        $before_match =~ s/\r//g;
        $before_match =~ s/\^J//g;

        if (@prompts)
        {
            $self->{handle}->expect( 2, "$prompt" );
        }
    }
    my @lines = split( "\n", $before_match );
    if ( $multiple_run && $logUser == 1 )
    {
        foreach my $line (@lines)
        {
            print $multiple_run . " : " . $line . "\n";
        }
    }
    if ( defined $devfile )
    {
        $self->generate_logfile( \$devfile, \@lines );
    }
    if ( defined $outfile )
    {
        $self->generate_logfile( \$outfile, \@lines );
    }
    return if ( $output == 99 );
    return $before_match if ($output);

    return @lines;

    return "ERROR $error";

}

sub generate_logfile
{
    my $self    = shift;
    my $devfile = shift;
    my $lines   = shift;
    open DEVFILE, "> $$devfile";
    foreach my $line (@$lines)
    {
        print DEVFILE $line . "\n";
    }
    close DEVFILE;
}

sub read_logfile
{
    my $self    = shift;
    my $devfile = shift;
    my $lines;
    open READDEV, "< $devfile";
    while ( my $line = <READDEV> )
    {
        chomp $line;
        $lines .= $line . "\n";
    }
    close READDEV;
    return $lines;
}

sub last_command
{
    return $last_commnd;
}

sub getbuffer
{
    my $self   = shift;
    my $output = shift;
    my ( $matched_pattern_position, $error, $successfully_matching_string,
         $before_match, $after_match )
        = $self->{handle}->expect( 2, "\.*" );
    $before_match .= $after_match if ($after_match);

    #print "RETURN BEFORE MATCH\n";
    $before_match =~ s/\e\[\dm.*$//g;
    $before_match =~ s/\e//g;
    $before_match =~ s/\r//g;
    return $before_match if ($output);
    my @lines = split( "^", $before_match );
    return @lines;    #if(defined $logUser){printout($self->{handle},undef);} #

}
############################ get_attribute ############################
#This function will return a list of vaules, so make sure that you recive it as a list.
#Second value is additonal information.
#my ($value,$info) = $obj->get_attribute($up, "state");

sub get_attribute
{
    my $self = shift;
    my $MO   = shift;
    my $attr = shift;

    my $result = $self->doCommand( 1, 0, "get ${MO}\$ ${attr}\$" );

    if ( $result =~ /$MO\s+$attr\s+(\S+)\s*(\S+)?/i )
    {
        my $value     = $1;
        my $valueinfo = $2;
        $valueinfo =~ s/\(//g;
        $valueinfo =~ s/\)//g;
        return ( $value, $valueinfo );
    }
    elsif ( $result =~ /Total: 0 MOs/ )
    {
        return undef;
    }
    return undef;
}

sub updateLogFile
{
    my $self    = shift;
    my $logFile = shift;
    $self->{handle}->log_file($logFile);
}

########################### CLOSE MOSHELL ##############################
#Close Moshell
#$var = $obj->closeMOShell();
#
#if Moshell has closed correct, then it will return "512". if not, then "undef" will be returned.
########################################################################
sub closeMOShell
{
    my $self = shift;
    if ( defined( $self->{handle} ) )
    {
        #Quit moshell.
        $self->{handle}->send("q\r");
        $self->{handle}->hard_close();
        logwrite("Moshell closed");
    }
    else
    {
        logwrite("There is no handle to moshell instance.");
    }
    my $exitstatus = $self->{handle}->exitstatus();
    if ( defined $exitstatus )
    {
        return $exitstatus;
    }
    else { return undef; }
}
1;

__END__

############################ set_attribute ############################
#This function will let you set a value for one particular attribute.
#Return 1 if it has success, otherwhice undef.
#my $res = $obj->set_attribute( "ManagedElement=1", "userLabel", "EMMARALD");
#
sub set_attribute
{
    my $self = shift;
    my $MO = shift;
    my $attr = shift;
    my $value = shift;

    my $result = $self->doCommand( 1, 1, "set ${MO} ${attr} $value" );

    if ($result =~ /Total: 1 MOs attempted, 1 MOs set/)
    {
        return 1;
    }
     return undef;
}



########################### POLL MOSHELL ##############################
#POLL Moshell
#$obj = $obj->send_pol("nr of tries"); Default is 100. (100*10s ~ 1000 secunds)
#If POL failed, Moshell progress will be closed and and a new one will start up, a new object will be returned.
########################################################################
sub send_pol{
    my $self = shift;
    my ($nr_of_tries) = @_;
    $counter = 0;
    my ($obj,$flag);
    if(!defined $nr_of_tries){$nr_of_tries = 100;}
    if ($counter == 0){sleep 5;$self->{handle}->send("pol\n");$counter++;}
    my ($matched_pattern_position, $error, $successfully_matching_string, $before_match, $after_match);
    #MO service not ready, retrying in 10 seconds
    #No contact to port 80, retrying in 1 second
    while(1){
        ($matched_pattern_position, $error, $successfully_matching_string, $before_match, $after_match) = $self->{handle}->expect(1,"MO service not ready, retrying in 10 seconds","No contact to port 80, retrying in 1 second","$self->{ip}\e[0m>");
        if(!defined $successfully_matching_string){$successfully_matching_string = "";}

        if($successfully_matching_string =~ m/$self->{ip}\e\[0m/){
            print "$successfully_matching_string\n";
            $counter = 0;
            if(defined $flag){
                $self->{handle}->send("lt all\n");
                $self->{handle}->expect($self->{timeout},"$self->{ip}\e[0m>");
                $flag = undef;
            }
            return $self;

        }elsif($successfully_matching_string =~ m/MO service not ready, retrying in.*seconds/){
            print "$successfully_matching_string\n";
            $counter++;
        }elsif($successfully_matching_string =~ m/No contact to port 80, retrying in.*second/){
            print "$successfully_matching_string\n";
            $counter++;
        }else{
            #return undef;
        }
        if($counter > $nr_of_tries){
            print "CLOSE Moshell and startup a new progress.\n";
            $self->closeMOShell();

            $self = MoshellAPI->new($self->{ip},$self->{password},$self->{logUser},$self->{moshell},$self->{timeout});
            $counter = 0;
            sleep 5;
            $self->{handle}->send("pol\n");
        }
    }
}

1;  # Do not remove this line! It is needed when doing "require" on this per file/module



Waiting 60 seconds before checking result...
UP action result: UNSPECIFIED
additionalInfo  : Upgrade is not possible due to FTC synch is ongoing. theCoreMPsFTC_StatusInformation:. plugInUnitMos: [ ManagedElement=1,Equipment=1,Subrack=MS,Slot=10,PlugInUnit=1, ManagedElement=1,Equipment=1,Subrack=MS,Slot=11,PlugInUnit=1 ]. ftcStates: [ Active, PassiveNotReady ]. possibleUpgradeScenario: 2


