package transitionAttempt;
use strict;
use Data::Dumper;
use timeparser;
sub transitionAttempt::new() {
    my $class = shift;
    my $conf  = shift;
    my $types = shift;
    my %self  = @_;
    $self{UECONFIG}    = {};
    $self{TABLES}      = ();
    $self{TABLEAME}    = ();
    $self{TEXTPRINTER} = new formatTXT();
    $self{CSVPRINTER}  = new formatCSV();
    $self{HTMLPRINTER} = new formatHTML();
    foreach my $type ( @{$types} ) {
        my $exp = $type->getRegexp();
        if ( $exp eq "UE_GENERAL" ) {
            $self{TYPE}                             = $type;
            $type->{required}->{cUeRcId}            = 1;
            $type->{required}->{tUeRcId}            = 1;
            $type->{required}->{module}             = 1;
            $type->{required}->{core}               = 1;
            $type->{required}->{ueRef}              = 1;
            $type->{required}->{procedureNo}        = 1;
            $type->{required}->{procedureName}      = 1;
            $type->{required}->{procedureDirection} = 1;
        }
    }

    my $type = new Type( matchString => 'transitionAttempt' );
    $self{type} = $type;
    my @headers = ();
    my $table   = {};

    @headers = ( 'cUeRcId', 'tUeRcId' );
    my $tableName = 'transition attempt';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, max => $conf->{max}, silent => $conf->{silent} );
    foreach my $header (@headers) {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }

    $tableName = 'transition success';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, max => $conf->{max}, silent => $conf->{silent} );
    foreach my $header (@headers) {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }

    $tableName = 'transition failed';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, max => $conf->{max}, silent => $conf->{silent} );
    foreach my $header (@headers) {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    @headers = ( 'tUeRcId' );
    $tableName = 'ueRc source states';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, max => $conf->{max}, silent => $conf->{silent} );
    foreach my $header (@headers) {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    @headers = ( 'tUeRcId' );
    $tableName = 'ueRc target states';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, max => $conf->{max}, silent => $conf->{silent} );
    foreach my $header (@headers) {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $self{table} = $table;
    $table = {};
    return bless \%self;

}

#        <attrib name="cUeRcId" matchString="currentRcId: (\d+)"/>
#        <attrib name="tUeRcId" matchString="targetUeRcId: (\d+)"/>
#        <attrib name="ueRef" matchString="ueRef: (\d+)"/>
#        <attrib name="procedureNo" matchString="procedure: PROC (\d+):"/>
#        <attrib name="procedureName" matchString="procedure: PROC \d+:\s+(.+?),"/>
#        <attrib name="procedureDirection" matchString="UE_GENERAL.+?(Importing|Deporting)"/>
#        <attrib name="module" matchString="\[.+?\]\s*(?:[a-zA-Z0-9]+:)?(\d{6})\/" />
#        <attrib name="core" matchString="\[.+?\]\s*(?:[a-zA-Z0-9]+:)?\d{6}\/(\d{2})" />

sub transitionAttempt::parser {
    my $self = shift;
    my $type = shift;
    my $conf = shift;
    my $groupBy;
    my $key;
    if ( defined $self->{TYPE}->{obj}->{procedureDirection} && defined $self->{TYPE}->{obj}->{cUeRcId} && defined $self->{TYPE}->{obj}->{tUeRcId} && $self->{TYPE}->{obj}->{procedureDirection} eq "Importing" && defined $self->{TYPE}->{obj}->{ueRef} ) {
        if ( $self->{TYPE}->{obj}->{cUeRcId} != $self->{TYPE}->{obj}->{tUeRcId} ) {
            $key = ( defined $self->{TYPE}->{obj}->{module} ? $self->{TYPE}->{obj}->{module} : "" ) . ':' . ( defined $self->{TYPE}->{obj}->{core} ? $self->{TYPE}->{obj}->{core} : "" ) . ':' . $self->{TYPE}->{obj}->{ueRef};
            $self->{transitionhash}->{$key}->{target} = $self->{TYPE}->{obj}->{tUeRcId};
            $self->{transitionhash}->{$key}->{source} = $self->{TYPE}->{obj}->{cUeRcId};
            my $cUeRcIdString = ($conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{source}}?$conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{source}}:"");
            my $tUeRcIdString = ($conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{target}}?$conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{target}}:"");
            my $string = $self->{transitionhash}->{$key}->{source} . " ($cUeRcIdString)" . ';' . $self->{transitionhash}->{$key}->{target} . " ($tUeRcIdString)";
            $self->{table}->{'transition attempt'}->addKey( \$string, \$self->{TYPE}->{obj}->{newRopTime}, undef, undef );

            my $sString = $self->{transitionhash}->{$key}->{source} . " ($cUeRcIdString)";
            $self->{table}->{'ueRc source states'}->addKey( \$sString, \$self->{TYPE}->{obj}->{newRopTime}, undef, undef );
            my $tString = $self->{transitionhash}->{$key}->{target} . " ($tUeRcIdString)";
            $self->{table}->{'ueRc target states'}->addKey( \$tString, \$self->{TYPE}->{obj}->{newRopTime}, undef, undef );
        }
    }
    if ( defined $self->{TYPE}->{obj}->{procedureDirection} && defined $self->{TYPE}->{obj}->{cUeRcId} && $self->{TYPE}->{obj}->{procedureDirection} eq "Deporting" && defined $self->{TYPE}->{obj}->{ueRef} ) {
        $key = ( defined $self->{TYPE}->{obj}->{module} ? $self->{TYPE}->{obj}->{module} : "" ) . ':' . ( defined $self->{TYPE}->{obj}->{core} ? $self->{TYPE}->{obj}->{core} : "" ) . ':' . $self->{TYPE}->{obj}->{ueRef};
        if ( defined $self->{transitionhash}->{$key}->{target} && $self->{transitionhash}->{$key}->{target} eq $self->{TYPE}->{obj}->{cUeRcId} )
        {
            my $cUeRcIdString = ($conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{source}}?$conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{source}}:"");
            my $tUeRcIdString = ($conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{target}}?$conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{target}}:"");
            my $string = $self->{transitionhash}->{$key}->{source} . " ($cUeRcIdString)" . ';' . $self->{transitionhash}->{$key}->{target} . " ($tUeRcIdString)";
            $self->{table}->{'transition success'}->addKey( \$string, \$self->{TYPE}->{obj}->{newRopTime}, undef, undef );
        }
        elsif ( defined $self->{transitionhash}->{$key}->{target} && defined $self->{TYPE}->{obj}->{cUeRcId} )
        {
            my $cUeRcIdString = ($conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{source}}?$conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{source}}:"");
            my $tUeRcIdString = ($conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{target}}?$conf->{ueRcStates}->{$self->{transitionhash}->{$key}->{target}}:"");
            my $string = $self->{transitionhash}->{$key}->{source} . " ($cUeRcIdString)" . ';' . $self->{transitionhash}->{$key}->{target} . " ($tUeRcIdString)";
            $self->{table}->{'transition failed'}->addKey( \$string, \$self->{TYPE}->{obj}->{newRopTime}, undef, \$groupBy );
        }
    }
    return undef;
}

sub transitionAttempt::printer() {
    my $self          = shift;
    my $conf          = shift;
    my $modulePrinter       = shift;
    my $format = shift;

#    print "##### succededTransition #####\n";
#    print Dumper( $self->{succededTransition} );
#    print "##### failedTransition #####\n";
#    print Dumper( $self->{failedTransition} );

#

#    $self->{table}->{'transition failed'}->addKey():
#$tableObj->addKey(    \$uniqueString, \$obj->{newRopTime}, undef, \$$obj{$groupBy} );



    my $timeParser = new timeparser( );
    my $tablePrinters = $self->{type}->getTablesPrinter();
    foreach my $tablePrinter ( @$tablePrinters )
    {
        if ( defined $conf->{csv} && $format eq 'CSVPRINTER' )
        {
            $tablePrinter->{PRINTER} = $tablePrinter->{CSVPRINTER};
            $tablePrinter->{fh} = $self->{fh};
            $tablePrinter->printTable( $conf->{rop} );
        }
        elsif( $format eq 'TEXTPRINTER' )
        {
            $tablePrinter->{PRINTER} = $tablePrinter->{TEXTPRINTER};
            $tablePrinter->{fh} = $self->{fh};
            $tablePrinter->printTable( $conf->{rop} );
        }
        elsif ( defined  $conf->{html} && $format eq 'HTMLPRINTER' )
        {
            $tablePrinter->{HTMLPATH} = $conf->{html};
            $tablePrinter->{PRINTER} = $tablePrinter->{HTMLPRINTER};
            $tablePrinter->printTable( $conf->{rop} );
            $tablePrinter->{PRINTER} = $tablePrinter->{FLOTPRINTER};
            $tablePrinter->printTable( 1 );
            push( @{$self->{allowFolot}}, $tablePrinter->{TABLEAME});
        }
    }
    return ();
}



1;
