package ueRackTables;
use strict;
use Data::Dumper;
use formatTXT;
use formatCSV;
use formatHTML;
use timeparser;
sub ueRackTables::new() {
    my $class = shift;
    my $conf = shift;
    my $types = shift;
    my %self = @_;
    $self{UECONFIG} = {};
    $self{TABLES} = ();
    $self{TABLEAME} = ();
    $self{TEXTPRINTER} = new formatTXT();
    $self{CSVPRINTER} = new formatCSV();
    $self{HTMLPRINTER} = new formatHTML();
    foreach my $type ( @{$types} )
    {
        my $exp = $type->getRegexp();
        if ( $exp eq "IU_IF" )
        {
            $self{TYPE} = $type;
            $type->{required}->{IMSI} = 1;
              $type->{required}->{roamCounter} = 1;
        }


    }
    parseConfig( \%self, $conf->{config} );
    return bless \%self;
}

sub ueRackTables::parser()
{
    my $self = shift;
    if  ( defined $self->{TYPE}->{obj}->{roamCounter} && $self->{TYPE}->{obj}->{IMSI} )
    {
        if ( defined $self->{UECONFIG}->{ $self->{TYPE}->{obj}->{IMSI} } && $self->{TYPE}->{obj}->{roamCounter} !~ /SRBONLY|IURLINK/ )
        {
            my ($type) = $self->{TYPE}->{obj}->{roamCounter} =~ /(SYSTEM|NORMAL)/;
            if ( defined $type )
            {
                $self->{UE_RACK_TABLE}->{ $self->{TYPE}->{obj}->{IMSI} }->{RAB}->{$type}++;
                $self->{UE_RACK_TABLE}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastTime} = $self->{TYPE}->{obj}->{realTime};
                $self->{UE_RACK_TABLE}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastType} = $type;
            }
        }
        elsif ( defined $self->{UECONFIG}->{ $self->{TYPE}->{obj}->{IMSI} } && $self->{TYPE}->{obj}->{roamCounter} =~ /SRBONLY/ )
        {
            my ($type) = $self->{TYPE}->{obj}->{roamCounter} =~ /(SYSTEM|NORMAL)/;
            if ( defined $type )
            {
                $self->{UE_RACK_TABLE}->{ $self->{TYPE}->{obj}->{IMSI} }->{SRB}->{$type}++;
                #$self->{UE_RACK_TABLE}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastTime} = $self->{TYPE}->{obj}->{realTime};
                #$self->{UE_RACK_TABLE}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastType} = $type;
            }
        }
    }
    return undef;
}

sub centering
{
        my $string = shift;
        my $max = shift;
          if ( !defined $string )
          {
              $string = "";
        }
          my $length = length($string);
        my $spaces ='';
        $spaces .= ' ' x int(($max - $length)/2);
        $string = sprintf("%-" . $max . "s;",$spaces . $string);
        return $string;
}


sub procent
{
        my $hash = shift;
        my $elm = shift;
          my $type = shift;
        my $nrSystem = shift;
          my $nrNormal = shift;
        $hash->{$elm}->{$type}->{$nrNormal} = 0 if !defined  $hash->{$elm}->{$type}->{$nrNormal};
        $hash->{$elm}->{$type}->{$nrSystem} = 0 if !defined  $hash->{$elm}->{$type}->{$nrSystem};
        my $add = ( ($hash->{$elm}->{$type}->{$nrSystem} == 0 && $hash->{$elm}->{$type}->{$nrNormal}) == 0?1:0 );
        my $procent =  ( $hash->{$elm}->{$type}->{$nrNormal} / ($hash->{$elm}->{$type}->{$nrNormal} + $hash->{$elm}->{$type}->{$nrSystem} + $add) ) * 100;
        my $div = $hash->{$elm}->{$type}->{$nrNormal} . '/' . ($hash->{$elm}->{$type}->{$nrNormal} + $hash->{$elm}->{$type}->{$nrSystem});
        return (sprintf("%.2f%%",$procent),$div);
}

sub ueRackTables::printer(){
    my $self = shift;
    my $conf = shift;
    my $printer = shift;
    my $format = shift;
    my $timeParser = new    timeparser( );
    if ( !defined $printer )
    {
        return
    }
    else
    {
        $printer->{fh} = $self->{fh};
    }
    my $data ={};
    my @tablesToPrint = ();

    foreach my $ccn (sort keys %{$self->{UEARRAY}})
    {
        if ($format eq 'HTMLPRINTER' )
        {
            push(@tablesToPrint,$ccn);
        }
        my @elm;
        foreach my $route ( sort keys %{$self->{UEARRAY}->{$ccn}})
        {
            my @row;
            my @column;
            push( @column, sprintf( "%-9s", ' ' x 5 ) );
            push( @column, sprintf( "%-9s", ' ' x 5 ) );
            push( @column, sprintf( "%-9s", $route  ) );
            push( @column, sprintf( "%-9s", ' ' x 5 ) );
            push( @column, sprintf( "%-9s", ' ' x 5 ) );
            push( @column, sprintf( "%-9s", ' ' x 5 ) );
            push( @column, sprintf( "%-9s", ' ' x 5 ) );
            push( @column, sprintf( "%-9s", ' ' x 5 ) );
            push( @column, sprintf( "%-9s", ' ' x 5 ) );
            push( @column, sprintf( "%-9s", ' ' x 5 ) );
            push( @row, \@column );
            foreach my $imsi (@{$self->{UEARRAY}->{$ccn}->{$route}})
            {
                my @column;
                my $time;
                if ( $self->{UE_RACK_TABLE}->{$imsi}->{lastType} )
                {
                    $time = $timeParser->timeparser::modify_time( newtime=> $self->{UE_RACK_TABLE}->{$imsi}->{lastTime}, time => $conf->{endTime}, diff => 1, clean => 1 );
                    $time =~ s/^0000\-00\-00 //;
                    #$time = $timeParser->timeparser::modify_time( newtime=> $conf->{endTime}, time => $self->{UE_RACK_TABLE}->{$imsi}->{lastTime}, diff => 1 );
                }
                if ( !defined $time )
                {
                    $time = "";
                }
                my ( $procent, $div ) = procent( $self->{UE_RACK_TABLE}, $imsi,'RAB', 'SYSTEM', 'NORMAL' );
                $column[0] = centering( "RAB: " . $procent . ' ' . $div, $self->{UECONFIG_LENGTH} );
                ( $procent, $div ) = procent( $self->{UE_RACK_TABLE}, $imsi,'SRB', 'SYSTEM', 'NORMAL' );
                $column[1] = centering( "SRB: " .$procent . ' ' . $div, $self->{UECONFIG_LENGTH} );
                $column[2] = centering( $imsi, $self->{UECONFIG_LENGTH} );
                $column[3] = centering( $self->{UECONFIG}->{$imsi}->{uetype}, $self->{UECONFIG_LENGTH} );
                $column[4] = centering( $self->{UECONFIG}->{$imsi}->{profile}, $self->{UECONFIG_LENGTH} );
                $column[5] = centering( $self->{UECONFIG}->{$imsi}->{ueno}, $self->{UECONFIG_LENGTH} );
                $column[6] = centering( "last_time:", $self->{UECONFIG_LENGTH} );
                $column[7] = centering( $self->{UE_RACK_TABLE}->{$imsi}->{lastTime}, $self->{UECONFIG_LENGTH} );
                $column[8] = centering( "last release: " . ($self->{UE_RACK_TABLE}->{$imsi}->{lastType}?$self->{UE_RACK_TABLE}->{$imsi}->{lastType}:""), $self->{UECONFIG_LENGTH} );
                $column[9] = centering( "time: " . $time, $self->{UECONFIG_LENGTH} );
                push( @row, \@column );
            }
            push( @elm, \@row );
        }
        $data->{$ccn} = \@elm;
    }

    foreach my $name (sort keys %{$data})
    {
        my @elm = @{$data->{$name}};
        my $path = "";
        if ( defined $self->{HTMLPATH} )
        {
            $path = $self->{HTMLPATH} . 'dataseries/';
        }
        $printer->begin( $path, $name );
        if ( $format eq 'HTMLPRINTER' )
        {
            $printer->printer( "" . '<table id="' . $name . '">' . "\n" );
        }
        my $lineSeparater="";
        for(my $i=0; $i<@elm; $i++)
        {
            if ( $format ne 'HTMLPRINTER' )
            {
                $printer->{fh} = $self->{fh};
                $lineSeparater = "-" x ($self->{UECONFIG_LENGTH});
                $lineSeparater = "$lineSeparater " x 10;
                $lineSeparater = '--------- ' .  $lineSeparater;
                $printer->header( $lineSeparater, "notUsed", "noSeparater" );
                for(my $j=0; $j<@{$elm[0][0]}; $j++)
                {
                    my $string;
                    for(my $k=0; $k<@{$elm[0]}; $k++)
                    {
                        $string .= $elm[$i][$k][$j] . '|';
                    }
                    $printer->content( "", $string, "" );
                }
            }
            else
            {
                #print HTML
                $printer->printer( "\t" . '<tr>' );
                for(my $j=0; $j<@{$elm[0]}; $j++)
                {
                    my $color = htmlColor($elm[$i][$j][0]);
                    $printer->printer( "\t\t" . '<td border="1" ' . $color . ' >' );
                    $printer->printer( "\t\t\t" . '<center>' );
                    for(my $k=0; $k<@{$elm[0][0]}; $k++)
                    {
                        my $tmp = $elm[$i][$j][$k];
                        chomp($tmp);
                        $tmp =~ s/\s+/ /g;
                        $tmp =~ s/\n//g;
                        $printer->printer( "\t\t\t\t" . $tmp . '<br>' );
                    }
                    $printer->printer( "\t\t\t" . '</center>' );
                    $printer->printer( "\t\t" . '</td>' );
                }
            }
        }
        if ( $format ne 'HTMLPRINTER' )
        {
            $printer->header( $lineSeparater, "notUsed", "noSeparater" );
        }
        if ( $format eq 'HTMLPRINTER' )
        {
            $printer->printer( "" . '</table>' );
        }
    }
    return @tablesToPrint;
}

sub htmlColor
{
    my $string = shift;
    my $color = '';

    my ( $procent ) = $string =~ /\s*(\d+)\.\d+\%/;
    if ( !defined $procent )
    {
        $color = "";
    }
    elsif ($procent == 0)
    {
        $color = 'bgcolor="#808080"'; #gr
    }
    elsif($procent < 90)
    {
        $color = 'bgcolor="#FF0000"'; #r\ufffdd
    }
    elsif($procent > 95)
    {
        $color = 'bgcolor="#008000"'; #gr\ufffdn
    }
    elsif($procent > 90)
    {
        $color = 'bgcolor="#FFFF00"'; #gul
    }
    return $color;
}

#IMSI           TYPE            UE      PROFILE                                       ROUTE
#235911003301000 U360            0       9.2_CS_Speech_WB-AMR                                                                   Rack33_Route_A
#235911003301001 K810            1       9.2_CS_Speech_WB-AMR                                                                           Rack33_Route_A
#235911003301002 K810            2       9.2_CS_Speech_WB-AMR                          Rack33_Route_A
#235911003301003 CS702           3       9.2_CS_Speech_WB-AMR                          Rack33_Route_A
#235911003301004 QC8220          4       9.2_CS_Speech_WB-AMR                          Rack33_Route_A

sub ueRackTables::parseConfig(){
    my $self = shift;
    my $file = shift;
    open CONFIG, "< $file";
    foreach my $line ( <CONFIG> )
    {
        if ( $line =~ /^\s*#/ )
        {
            next;
        }
        next if $line =~ /^\s*$/;
        if ( $line =~ /^\s*(\S+?)\s*=\s*(.+?)\s*$/ )
        {
            next;
        }
        my @line = split( /\s+/, $line );
        if ( @line == 5 )
        {
            if ( $line =~ /^\s*(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(Rack\S+?)_(Route_\S+)\s*$/i )
            {
                my ( $imsi, $uetyp, $ueno, $profile, $ccn, $rutt ) = ( $1, $2, $3, $4, $5, $6 );
                $self->{UECONFIG}->{$imsi}->{uetype}  = $uetyp;
                $self->{UECONFIG}->{$imsi}->{ueno}    = $ueno;
                $self->{UECONFIG}->{$imsi}->{profile} = $profile;
                $self->{UECONFIG}->{$imsi}->{route}   = $rutt;
                $self->{UECONFIG}->{$imsi}->{ccn}   = $ccn;
                my $length = (length( $profile ));
                if ( !defined $self->{UECONFIG_LENGTH} )
                {
                    $self->{UECONFIG_LENGTH} = 0;
                }
                if ( $length > $self->{UECONFIG_LENGTH} )
                {
                    $self->{UECONFIG_LENGTH} = $length;
                }
                push( @{$self->{UEARRAY}->{$ccn}->{$rutt}}, $imsi );
            }
        }
        else
        {
            print STDERR "teSummary wrong format in config file: $line\n";
        }
    }
    close CONFIG;
}

1;

