package printer;
use strict;
use POSIX qw(strftime);
use POSIX;
use Time::Local;
use Data::Dumper;




sub printer {
    my $conf      = shift;
    my $parseData = shift;
    my $printRop  = shift;
    my $fh;
    if ( defined $conf->{outfile} )
    {
        open $fh, ">" . $conf->{outfile} or print "could not open file;";
    }
    else
    {
        $fh = *STDOUT;
    }
    my $tedb_fh = undef;
    my $tedb_json_fh = undef;
    if ( defined $conf->{tedb_logfile} && defined $conf->{tedb})
    {
        open $tedb_fh, ">" . $conf->{tedb_logfile} or print "could not open file: $conf->{tedb_logfile};";
    }
    elsif (defined $conf->{tedb})
    {
        open $tedb_fh, ">" . "./tedb_syslog" or print "could not open file: ./tedbsyslog";
    }
    if ( !defined $conf->{onlydiff} && defined $conf->{startTime} && defined $conf->{endTime} )
    {
        my $timeParser = new timeparser();
        $conf->{duration} = $timeParser->timeparser::modify_time( newtime => $conf->{startTime}, time => $conf->{endTime}, diff => 1 );
    }
# Instantiate a teDB printer in order to store certain teDB-specific data for use by all the other printers if they need it later
# Only do this if the --teDB flag has been set.
    my $teDBPrinter = undef;
    if (!defined $printRop && defined $conf->{tedb})
    {
        $teDBPrinter = new formatTEDB();
        $teDBPrinter->{fh} = $tedb_fh;
        $teDBPrinter->worker($conf);
    }
    print_report_times( $conf, $fh );
    if ( !defined $printRop && defined $conf->{diffstore} ) {
        foreach my $type ( @{ $parseData->{types} } ) {
            my $tablePrinters = $type->getTablesPrinter();
            foreach my $tablePrinter (@$tablePrinters) {
                $tablePrinter->createDumps($conf);
            }
        }
        my $time = strftime "%y%m%d_%H%M%S", localtime;
        my $file = $conf->{diffstore} . '/teSummary_dumper_' . $time . '.txt';
        $conf->{dumptables}->{startTime} = $conf->{startTime};
        $conf->{dumptables}->{endTime}   = $conf->{endTime};
        $conf->{dumptables}->{duration}  = $conf->{duration};
        $conf->{dumptables}->{up}  = $conf->{up} if defined $conf->{up};
        $conf->{dumptables}->{uprev}  = $conf->{uprev} if defined $conf->{uprev};
        open DUMPFILE, "> $file";
        print DUMPFILE Dumper( $conf->{dumptables} );
        close DUMPFILE;
        if ( !defined $conf->{nodiff} ) {
            my $regExp = 'teSummary_dumper_';
            if ( defined $conf->{difffiles} ) {
                $regExp = "";
                my @f = split( ',', $conf->{difffiles} );
                foreach my $f (@f) {
                    $regExp .= $f . '|';
                }
                chop $regExp;
                if ( defined $conf->{difffile} ) {
                    $regExp .= ( $regExp ne "" ? '|' : "" ) . $conf->{difffile};
                }
            }
            opendir( DIR, $conf->{diffstore} . "/" );
            my @files = grep /$regExp/, readdir(DIR);
            foreach my $file ( sort @files ) {
                my $diff;
                $file = $conf->{diffstore} . "/" . $file;
                if ( -z $file ) {
                    print "skip $file\n";
                    next;
                }
                unless ( $diff = do $file ) {
                    warn "couldn't parse $file: $@" if $@;
                    warn "couldn't do $file: $!" unless defined $diff;
                    warn "couldn't run $file"    unless $diff;
                }
                my ($name) = $file =~ /teSummary_dumper_(\S+)\.txt/;
                if ( $name =~ /(\d{2})(\d{2})(\d{2})_(\d{2})(\d{2})(\d{2})/ ) {
                    $name = '20' . $1 . '-' . $2 . '-' . $3 . ' ' . $4 . ':' . $5;
                }

                push( @{ $conf->{old_diff} }, { file => $diff, name => $name } );
            }
            my $diffType = new Type( matchString => 'Diff_TYPE' );

            push( @{ $parseData->{types} }, $diffType );
            my $tables = {};
            foreach my $diff ( @{ $conf->{old_diff} } ) {
                my @tablenames = ();
                next if ( defined $diff->{file}->{last_time} || defined $diff->{file}->{start_time} );
                foreach my $tableName ( sort keys %{ $diff->{file} } ) {
                    next if ( $tableName eq "startTime" || $tableName eq "endTime" || $tableName eq "duration" );
                    push( @tablenames, $tableName );
                    print "$tableName\n";
                    if ( !defined $tables->{$tableName} && defined $diff->{file}->{$tableName} && defined $diff->{file}->{$tableName}->{HEADER} && @{ $diff->{file}->{$tableName}->{HEADER} })
                    {
                        @{ $tables->{$tableName}->{HEADERS} } = @{ $diff->{file}->{$tableName}->{HEADER} };
                        if ( defined $diff->{file}->{$tableName}->{GROUPBY} )
                        {
                            $tables->{$tableName}->{GROUPBY} = $diff->{file}->{$tableName}->{GROUPBY};
                        }
                    }
                }
                #print "filename: $diff->{name}, starttime: $diff->{file}->{startTime}, endTime: $diff->{file}->{endTime}, duration: $diff->{file}->{duration}, tablenames: '@tablenames'\n";
            }
            foreach my $tableName ( sort keys %$tables ) {
                my @headers = @{ $tables->{$tableName}->{HEADERS} };
                my $Tableobj = $diffType->addTable( name => $tableName . '_diff', max => $conf->{max} );
                $tables->{$tableName}->{TABLEOBJECT} = $Tableobj;
                foreach my $header (@headers) {
                    $Tableobj->addHeader( name => $header );
                }
                if ( defined $tables->{$tableName}->{GROUPBY} ) {
                    $Tableobj->addGroupBy( name => $tables->{$tableName}->{GROUPBY} );
                }
            }
            my $tablePrinters = $diffType->getTablesPrinter();
            foreach my $tablePrinter (@$tablePrinters) {
                $tablePrinter->{fullHeader} = 1;
            }
            foreach my $diff ( @{ $conf->{old_diff} } ) {
                next if ( defined $diff->{file}->{last_time} || defined $diff->{file}->{start_time} );
                foreach my $tableName ( sort keys %{ $diff->{file} } ) {
                    next if ( $tableName eq "startTime" || $tableName eq "endTime" || $tableName eq "duration" );
                    my $Tableobj = $tables->{$tableName}->{TABLEOBJECT};
                    if ( defined $diff->{file}->{$tableName}->{TABLE} ) {
                        $Tableobj->{ROP_TABLE}->{ $diff->{name} } = $diff->{file}->{$tableName}->{TABLE};
                    }
                    if ( defined $diff->{file}->{$tableName}->{TABLE_GROUPBY} ) {
                        $Tableobj->{ROP_TABLE_GROUPBY}->{ $diff->{name} } = $diff->{file}->{$tableName}->{TABLE_GROUPBY};
                    }
                    if ( defined $diff->{file}->{$tableName}->{TABLE} ) {
                        foreach my $string ( keys %{ $diff->{file}->{$tableName}->{TABLE} } ) {
                            $Tableobj->{TABLE}->{$string} += $diff->{file}->{$tableName}->{TABLE}->{$string};
                        }
                    }
                    if ( defined $diff->{file}->{$tableName}->{TABLE_GROUPBY} ) {
                        foreach my $key ( keys %{ $diff->{file}->{$tableName}->{TABLE_GROUPBY} } ) {
                            foreach my $string ( keys %{ $diff->{file}->{$tableName}->{TABLE_GROUPBY}->{$key} } ) {
                                $Tableobj->{TABLE_GROUPBY}->{$key}->{$string} += $diff->{file}->{$tableName}->{TABLE_GROUPBY}->{$key}->{$string};
                            }
                        }
                    }
                }
            }
        }
    }
    if ( !defined $conf->{silent}   || defined $conf->{outfile} ) {
        foreach my $type ( @{ $parseData->{types} } ) {
            my $tablePrinters = $type->getTablesPrinter();
            foreach my $tablePrinter (@$tablePrinters) {
                $tablePrinter->{fh} = $fh;
                if ( defined $conf->{csv} ) {
                    $tablePrinter->{PRINTER} = $tablePrinter->{CSVPRINTER};
                }
                else {
                    $tablePrinter->{PRINTER} = $tablePrinter->{TEXTPRINTER};
                }
                $tablePrinter->printTable( $conf->{rop} );
            }
        }
        foreach my $module ( @{ $conf->{modules} } ) {
            my $modulePrinter = $module->{obj};
            my $printer;
            if ( defined $conf->{csv} ) {
                $modulePrinter->{format} = 'CSVPRINTER';
                $printer = $modulePrinter->{CSVPRINTER};
            }
            else {
                $modulePrinter->{format} = 'TEXTPRINTER';
                $printer = $modulePrinter->{TEXTPRINTER};
            }
            $modulePrinter->{fh} = $fh;
            $modulePrinter->printer( $conf, $printer, $modulePrinter->{format} );
        }
    }
    if ( defined $conf->{html} ) {
        use formatHTML;
        my $printer = new formatHTML();

        $printer->begin( $conf->{html}, 'index' );
        my $filter = "FILTER: "
        . (defined $$conf{filterImsi}?"-imsi " . $$conf{filterImsi}:"")
        . (defined $$conf{excludeImsi}?" -eimsi " . $$conf{excludeImsi}:"")
        . (defined $$conf{filterCell}?" -cell " . $$conf{filterCell}:"")
        . (defined $$conf{excludeCell}?" -ecell " . $$conf{excludeCell}:"")
        . (defined $$conf{filter_or}?" -or ":"") . "\n";
        if (!defined $teDBPrinter) {
            $printer->mainHeader( $conf->{nodename}, $conf->{version}, $conf->{startTime}, $conf->{endTime}, $conf->{duration}, $conf->{cv}, $conf->{comment}, $conf->{xmlfile}, $conf->{config}, $conf->{eventSupport},$filter );
        }
        else {
            $printer->mainHeader( $conf->{nodename}, $conf->{version}, $conf->{startTime}, $conf->{endTime}, $conf->{duration}, $conf->{cv}, $conf->{comment}, $conf->{xmlfile}, $conf->{config}, $conf->{eventSupport}, $filter, $teDBPrinter->getLinks() );
        }
        foreach my $type ( @{ $parseData->{types} } ) {
            my $tablePrinters = $type->getTablesPrinter();
            foreach my $tablePrinter (@$tablePrinters) {
                $tablePrinter->{HTMLPATH} = $conf->{html};
                $tablePrinter->{PRINTER}  = $tablePrinter->{HTMLPRINTER};
                $tablePrinter->printTable(1);
                $tablePrinter->{PRINTER} = $tablePrinter->{FLOTPRINTER};
                $tablePrinter->printTable(1);
                $tablePrinter->{PRINTER} = $tablePrinter->{JSONPRINTER};
                $tablePrinter->printTable(1);
                $printer->mainContent( $tablePrinter->{TABLEAME} );
            }
        }
        foreach my $module ( @{ $conf->{modules} } ) {
            my $moduleSelf = $module->{obj};
            $moduleSelf->{format}   = 'HTMLPRINTER';
            $moduleSelf->{HTMLPATH} = $conf->{html};
            my $modulePrinter = $module->{obj}->{HTMLPRINTER};
            my @list = $moduleSelf->printer( $conf, $modulePrinter, $moduleSelf->{format} );
            if ( $moduleSelf->{allowFolot} ) {

                foreach my $l ( @{$moduleSelf->{allowFolot}} )
                {
                    $printer->mainContent( $l );
                }
            }
            while (@list) {
                my @a = shift @list;
                $printer->mainContent( \@a );

            }
        }
        $printer->mainEnd();
    }
############################################
##           TEDB SECTION                 ##
############################################
    if (defined $conf->{tedb} && defined $teDBPrinter){
#        my $printer = new formatTEDB();
#        $printer->worker($conf);

        my $session = $teDBPrinter->{dbsession};
        my @tableNames;
        foreach my $type ( @{ $parseData->{types} } ) {
            my $tablePrinters = $type->getTablesPrinter();
            foreach my $tablePrinter (@$tablePrinters) {
                $tablePrinter ->{fullHeader}=1;
                $tablePrinter->{fh} = $tedb_fh;
                $tablePrinter->{PRINTER} = $tablePrinter->{TEDBPRINTER};
                $tablePrinter->{dbsession} = $session;
                $tablePrinter->printTable( $conf->{rop} );
                my $tableName = $tablePrinter->{tableName};        #extract table name from printer
                push(@tableNames, $tableName) if (defined $tableName);
            }
        }
        ##Validate and if necessary, fix the STP Session ID
        my $validated = $teDBPrinter->validateAssignedSTPSession();
        if (!$validated){
            $teDBPrinter->validateAssignedSTPSession(); #check if the row update worked and the current
                                                        #stp session id is now equal to the calculated
                                                        #stp session id.
        }
        ##end validation section
        close $tedb_fh;

        # Print to the json file, wherever it may be
        open $tedb_json_fh, ">", $conf->{tedbjsonfilehandle} or print "could not open json file handle\n";
        my $jsonInfo = $teDBPrinter->getJSONInfoString(\@tableNames);
        print $tedb_json_fh "$jsonInfo";
        close $tedb_json_fh;

    }
###########################################
    no formatHTML;
    print_report_times( $conf, $fh);

    if ( defined $conf->{outfile} )
    {
        close $fh;
    }
}

sub print_report_times
{
    my $conf = shift;
    my $fh = shift;
    if ( defined $conf->{startTime} && defined  $conf->{endTime} && defined $conf->{duration} )
    {
        print $fh "Log file Starts at: $conf->{startTime}\n";
        print $fh "Log file Ends at: $conf->{endTime}\n";
        print $fh "Log file Duration: $conf->{duration}\n";
    }
}
1;
