package temanagedbModule;
#########################################
#
# Filen name: temanagedb.pm ....
#
# FUNCTION:
# The purpose of this module is to:
#   - Store build information in the TE DB.
#
#########################################
eval{
    require "DBI.pm";
    DBI->import();
    1;
};


use Time::HiRes;

## Module variables:
my $createdSessionCnt = 0;
my $createdExceptionCnt = 0;
my $createdCodeCnt = 0;

sub te_dbConnect
############################################################
#
# Sub: te_dbConnect(db,host,port,user,password)
#
############################################################
{
 my $href = shift;    # reference to hash parameter


 my $dbh = dbConnect($href->{db}, $href->{db_host}, $href->{db_port}, $href->{db_user}, $href->{db_pwd} );

 return $dbh;
}


##**********************************************##

sub send_code_to_tedb() {

  my $href = shift;    # reference to hash parameter
  my $dbh = shift;
  my $session_id = shift;
  my $excepkey = shift;


  my $latest_session_id =  fetch_latest_session_id($dbh);
  create_code_item($dbh, $session_id, $excepkey, $href->{counter}, $href->{rbid});
}

##**********************************************##

sub send_code_to_tedb_new{

  my $href = shift;    # reference to hash parameter
  my $dbh = shift;
  my $session_id = shift;
  my $excepkey = shift;

  my $latest_session_id =  fetch_latest_session_id($dbh);

  my $ret = create_code_item_new($dbh, $session_id, $excepkey, $href->{counter}, $href->{rbid});

  return $ret;
}


##******************************************************##
## send_exception_to_tedb:                              ##
##                                                      ##
## Desc:   Send exception to db.                        ##
##                                                      ##
## Input:                                               ##
##   href   hash reference to exception                 ##
##   dbh    db handle                                   ##
##                                                      ##
## Return:                                              ##
##   unikey  -1:   not found nor created                ##
##           >= 0: found already exists in db  or       ##
##                 created and found in db              ##
##******************************************************##

sub send_exception_to_tedb() {

  my $href = shift;
  my $dbh = shift;
  my $ret = 0;
  my $found_unikey =0;
  my $unikey = 0;


  $found_unikey = fetch_exception($dbh, $href);  ## -1 not found, else found unikey

  if( $found_unikey >= 0) {
     printComment("Found equal exception item from db: unikey  $found_unikey");
     $unikey = $found_unikey;
   }
   else
     {
       create_exception_item ($dbh, $href->{code}, $href->{sconntype}, $href->{callproc}, $href->{subtype}, $href->{ec_string});
       $unikey = fetch_exception($dbh, $href);
     }

  return $unikey;
}

##******************************************************##
## send_exception_to_tedb_new:                          ##
##                                                      ##
## Desc:   Send exception to db.                        ##
##                                                      ##
## Input:                                               ##
##   href   hash reference to exception                 ##
##   dbh    db handle                                   ##
##                                                      ##
## Return:                                              ##
##   @retStatus                                         ##
##     $retStatus[0]:  0: OK,   1 (true): NOK           ##
##               [1]:  unikey                           ##
##               [2]:  cause                            ##
##                      0: found exception              ##
##                      1: created exception            ##
##                      2: not found nor created excep  ##
##                                                      ##
##******************************************************##

sub send_exception_to_tedb_new {

  my $exceptionString = shift;
  my $dbh = shift;
  my $ret = 0;
  my $cause = 0;

  my $exception_id = fetch_exception($dbh, $exceptionString);  ## -1 not found, else found unikey

  if( $exception_id != -1) {
     $ret = 0;
     $cause = 0; # found exception
   }
   else {
     create_exception_item ($dbh, $exceptionString);
     $errorStringID = fetch_exception($dbh, $href);

     if ( $errorStringID != -1   ){
         $ret = 0;
         $cause = 1; # created exception
     }
     else{
         $ret = 1;
         $cause = 2; # error
     }
   }


  my @retStatus;
   $retStatus[0] = $ret;
   $retStatus[1] = $unikey;
   $retStatus[2] = $cause;

  return @retStatus;
}


##**********************************************##


sub send_session_to_tedb {

  my $href = shift;    # reference to hash parameter
  my $dbh = shift;

  my $current_session_id = create_session_item($dbh, $href->{stp}, $href->{node}, $href->{starttime}, $href->{stoptime}, $href->{type});

  return  $current_session_id;
}


##**********************************************##

sub fetch_latest_session_id {
  my $dbh                = shift;  # db handle

  my $SQL = "SELECT `session_id` FROM `te_sessions` ORDER BY `session_id` DESC LIMIT 1;";
  my $sth = $dbh->prepare($SQL);
  $sth->execute();

  my $res = $dbh->do($SQL);

  $row_href = $sth->fetchrow_hashref();

  my $id = $row_href->{session_id};
  $sth->finish;
  return $id;
 }


##**********************************************##

sub fetch_exception {
  my $dbh                = shift;  # db handle
  my $exceptionString    = shift;
  my $found = 0;

  my $SQL = "SELECT * FROM `te_exceptions` WHERE `exception_string` = ?   LIMIT 1;";

  my $sth = $dbh->prepare($SQL);

  $sth->execute($exceptionString);


  my $row_href = $sth->fetchrow_hashref();
  my $exception_id_from_db = $row_href->{'exception_id'};
  my $exception_string_from_db = $row_href->{'exception_string'};

  if( defined $exception_string_from_db && ($exception_string_from_db eq $exceptionString))
    { $exceptionid = $exception_id_from_db; }
  else
    { $exceptionid = -1 }

  $sth->finish;

  return $exceptionid;
}

##**********************************************##

sub create_session_item {

  my $dbh    = shift;  # db handle
  my $in_stp = shift;
  my $in_node = shift;
  my $in_starttime = shift;
  my $in_stoptime = shift;
  my $in_type = shift;

  my $SQL = "SELECT * FROM `te_sessions` WHERE `stp` = '".$in_stp."'  AND `node` = '".$in_node."' AND `starttime` = '".$in_starttime."' AND `stoptime` = '".$in_stoptime."' AND `type` = '".$in_type."' LIMIT 1;";

  my $sth = $dbh->prepare($SQL);
  my $result = index($sth, "fault");

  if ($result == -1)
    {
      $sth->execute;

    }
  else
    {
      print "SQL SYNTAX FAILURE: $sth";
    }

  my $res = $dbh->do($SQL);

  my $row_href = $sth->fetchrow_hashref();
  my $session_id_db = $row_href->{'session_id'};
  my $stp_db = $row_href->{'stp'};
  my $node_db = $row_href->{'node'};
  my $starttime_db = $row_href->{'starttime'};
  my $stoptime_db = $row_href->{'stoptime'};
  my $type_db = $row_href->{'type'};
  $sth->finish;

  my $current_session_id =0;

    if (defined $session_id_db && $session_id_db != -1){

        $current_session_id =  $session_id_db;        #Session already exists; no need to add anything to the table.
        die "A session with the following info:\nstp: $stp_db\nnode: $node_db\nstart time: $starttime_db\nstop time: $stoptime_db\nrun type: $type_db\nalready exists in the database, therefore nothing was stored.  Please make sure this file has not been processed already\n";
    }
      else
    {
      $SQL = "INSERT INTO te_sessions (stp, node, starttime, stoptime, type) VALUES ('$in_stp', '$in_node', '$in_starttime', '$in_stoptime', '$in_type');";
      my $res = $dbh->do($SQL);


      $current_session_id =  fetch_latest_session_id($dbh);
    }

  return $current_session_id;
}


sub create_count_item{
############################################################
#
# Sub: create_code_item (dbh, session_id, excepkey, counter)
# Returns:
# Function:
# This function stores product information
# in the te database.
#
############################################################

  my $dbh                   = shift;  # db handle
  my $in_session_id         = shift;  # the session id
  my $in_exception_id           = shift;  # Unik key
  my $in_counter            = shift;  # Counter

  my $SQL = "SELECT * FROM `te_counts` WHERE `session_id` = $in_session_id  AND `exception_id` = $in_exception_id  AND `counter` = $in_counter LIMIT 1;";

  my $tmp_sth = $dbh->prepare($SQL);
  $tmp_sth->execute();

  my $returned_session_id=-1;
  my $returned_error_id=-1;
  my $returned_counter=-1;

  my $row_href = $tmp_sth->fetchrow_hashref();
  if (defined $row_href) {
      $returned_session_id = $row_href->{'session_id'};
      $returned_error_id = $row_href->{'error_id'};
      $returned_counter = $row_href->{'counter'};
  }

  if ( ($in_session_id == $returned_session_id) &&
       ($in_exception_id == $returned_error_id) &&
       ($in_counter ==  $returned_counter) ) {
           #do nothing...the error is already in the table.
  }
  else
    {
      $SQL = "INSERT INTO te_counts (session_id, exception_id, counter) VALUES ('$in_session_id', '$in_exception_id', '$in_counter');";

      my $res = $dbh->do($SQL);
    }
}

sub create_code_item_new{
############################################################
#
# Sub: create_code_item (dbh, session_id, excepkey, counter)
# Returns:
# Function:
# This function stores product information
# in the te database.
#
############################################################

  my $dbh                   = shift;  # db handle
  my $in_session_id         = shift;  # the session id
  my $in_excepkey           = shift;  # Unik key
  my $in_counter            = shift;  # Counter
  my $in_rbid               = shift;  # rbid
  my $ret = 0;


  my $SQL = "SELECT * FROM `te_codes` WHERE `session_id` = $in_session_id  AND `excepkey` = $in_excepkey  AND `counter` = $in_counter AND `rbid` =  '".$in_rbid."'  LIMIT 1;";

  my $tmp_sth = $dbh->prepare($SQL);
  $tmp_sth->execute();

  my $row_href = $tmp_sth->fetchrow_hashref();
  my $xid = $row_href->{'session_id'};
  my $xcode = $row_href->{'excepkey'};
  my $xcounter = $row_href->{'counter'};
  my $xrbid = $row_href->{'rbid'};

  if ( defined $xid && ($in_session_id == $xid) &&
       defined $xcode && ($in_excepkey == $xcode) &&
       defined $xcounter && ($in_counter ==  $xcounter) &&
       defined $xrbid && ($in_rbid eq  $xrbid)) {
    $ret = 0; # Equal code item
  }
  else
    {
      $SQL = "INSERT INTO te_codes (session_id, excepkey, counter, rbid) VALUES ('$in_session_id', '$in_excepkey', '$in_counter', '$in_rbid');";

      my $res = $dbh->do($SQL);

      if($res)
    {

      $ret = 1;  # Created code item

    }
      else
    {
      print"\nFault in count item creation\n";
      $ret = 2;  # Fault in creation code item
    }
    }

  return $ret;
}

sub create_exception_item {
############################################################
#
# Sub: create_exception_item (dbh, code, desc)
# Returns:
# Function:
# This function stores product information
# in the te database.
#
############################################################

 my $dbh                = shift;  # the database handler
 my $code               = shift;  # Code i.e exception number
 my $sconntype          = shift;  # connection type
 my $callproc           = shift;  # Calling process
 my $subtype            = shift;  # Subtype
 my $ec_string          = shift;  # Error string

 my $SQL = "INSERT INTO `te_exceptions` (`code`, `sconntype`, `callproc`, `subtype`, `ec_string`) VALUES (?,?,?,?,?)";
 my $sth = $dbh->prepare($SQL);
 $sth->execute($code, $sconntype, $callproc, $subtype, $ec_string);

 $createdExceptionCnt += 1;

 $SQL = "SELECT * FROM `te_exceptions` ORDER BY `unikey` DESC LIMIT 1;";
 $sth = $dbh->prepare($SQL);
 $sth->execute();
}

sub dbConnect()
############################################################
#
# Sub: dbConnect(db,host,port,user,password)
#
############################################################
{
 my $db = shift;
 my $host = shift;
 my $port = shift;
 my $usr = shift;
 my $pwd = shift;

  my $databasePath = "DBI:mysql:database=$db;host=$host:$port";
  my $dbh = DBI->connect( $databasePath, "$usr", "$pwd",
                          {RaiseError => 0, AutoCommit => 1}
                        );
  return $dbh;

}

sub printComment {
############################################################
#
# Sub: printComment ( <Comment>, [<Level>] )
#
# Function:
# To print a comment.
#
############################################################

    my $Comment = shift;
    my $Level   = shift;  # optional parameter

    if ( ! defined $Level ) {
        $Level = 1;
    }


    print "\n";
    print "$Comment \n";

}   # END of printComment

1;
