package timeparser;
use strict;
use locale;
use Data::Dumper;
use POSIX qw(strftime);
use POSIX;
use Time::Local;


sub timeparser::new() {
  my $class = shift;
  my %self = @_;
  if ( defined $self{period} )
  {
      $self{PERIOD} = $self{period};
     delete $self{period};
  }
  else
  {
    $self{PERIOD} = 15;
  }
  return bless \%self;
}

sub timeparser::parseTime()
{
    my $self = shift;
    my $line = shift;

    if ( $$line =~ /^\s*\[((\d{4})-(\d{2})-(\d{2})\s(\d{2}):(\d{2}):(\d{2})\.(\d+))\]/ )
    {
        my $realTime = $1;
        my ( $year,$month,$day,$hour,$min,$sec ) = $self->correct_time( $2,$3,$4,$5,$6,$7,undef,1,+$self->{PERIOD} );
        my $newRopTime = sprintf( "%04s-%02s-%02s %02s:%02s", $year,$month,$day,$hour,$min );
        return ( $realTime, $newRopTime );
    }
    elsif ( $$line =~ /^\s*\[((\d{2}):(\d{2}):(\d{2})\.(\d{3}))\]/ )
    {
        my ($year,$month,$day,$hour,$min,$sec,$mill) = ("1970","01","01",$2,$3,$4,$5);

        $self->{oldhour} = $hour;
        my $realTime = "$year-$month-$day $hour:$min:$sec\.$mill";
        ( $year,$month,$day,$hour,$min,$sec ) = $self->correct_time( $year,$month,$day,$hour,$min,$sec,undef,1,+$self->{PERIOD} );
        my $newRopTime = sprintf( "%04s-%02s-%02s %02s:%02s", $year,$month,$day,$hour,$min );
        return ( $realTime, $newRopTime );
    }
    elsif($$line =~ /^\s*(\d{4}):\s+\[((\d{4})-(\d{2})-(\d{2})\s(\d{2}):(\d{2}):(\d{2})\.(\d{3}))\]/){
                my ($year,$month,$day,$hour,$min,$sec,$mill) = ("1970","01","01",$3,$4,$5,$6);
        $$line =~ s/^\s*(\d{4}):\s+\[((\d{4})-(\d{2})-(\d{2})\s(\d{2}):(\d{2}):(\d{2})\.(\d{3}))\]/\[$2\]$1/;
                $self->{oldhour} = $hour;
                my $realTime = "$year-$month-$day $hour:$min:$sec\.$mill";
                ( $year,$month,$day,$hour,$min,$sec ) = $self->correct_time( $year,$month,$day,$hour,$min,$sec,undef,1,+$self->{PERIOD} );
                my $newRopTime = sprintf( "%04s-%02s-%02s %02s:%02s", $year,$month,$day,$hour,$min );
                return ( $realTime, $newRopTime );
    }
    else
    {
        return undef;
    }
}

sub timeparser::modify_time
{
        my $self = shift;
          my (%input)=@_;

        my ($format,$oldyear,$oldmonth,$oldday,$oldhour,$oldmin,$oldsec)=
                $input{time}=~/(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2}):(\d{2})/ ? (0,$1,$2,$3,$4,$5,$6) :
                $input{time}=~/(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})(\d{2})/   ? (1,$1,$2,$3,$4,$5,$6) :
                $input{time}=~/(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2})/ ? (2,$1,$2,$3,$4,$5,0) :
                $input{time}=~/(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})/   ? (3,$1,$2,$3,$4,$5,0) :
                (undef,undef,undef,undef,undef,undef,undef);
        if($input{newtime})
        {
                ($input{year},$input{month},$input{day},$input{hour},$input{min},$input{sec})=
                        $input{newtime}=~/(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2}):(\d{2})/ ? ($1,$2,$3,$4,$5,$6) :
                        $input{newtime}=~/(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})(\d{2})/   ? ($1,$2,$3,$4,$5,$6) :
                        $input{newtime}=~/(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2})/ ? ($1,$2,$3,$4,$5,0) :
                        $input{newtime}=~/(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})/   ? ($1,$2,$3,$4,$5,0) :
                        (undef,undef,undef,undef,undef,undef);
        }
        my @formats=("%04s-%02s-%02s %02s:%02s:%02s","%04s%02s%02s.%02s%02s%02s","%04s-%02s-%02s %02s:%02s","%04s%02s%02s.%02s%02s");
        return undef if(!defined $oldyear);
        my ($year,$month,$day,$hour,$min,$sec,$diff) = $self->correct_time(
                $oldyear+(defined $input{year}?$input{year}:0)*($input{diff}?-1:1),
                $oldmonth+(defined $input{month}?$input{month}:0)*($input{diff}?-1:1),
                $oldday+(defined $input{day}?$input{day}:0)*($input{diff}?-1:1),
                $oldhour+(defined $input{hour}?$input{hour}:0)*($input{diff}?-1:1),
                $oldmin+(defined $input{min}?$input{min}:0)*($input{diff}?-1:1),
                $oldsec+(defined $input{sec}?$input{sec}:0)*($input{diff}?-1:1),
                $input{diff},
                $input{rop}
        );

        return (sprintf($formats[$format],$year,$month,$day,$hour,$min,$sec),$diff) if $input{rop};
        return sprintf($formats[$format],$year,$month,$day,$hour,$min,$sec);
}

sub timeparser::correct_time
{
    my $self = shift;
    my($year,$month,$day,$hour,$min,$sec,$diff,$rop,$period)=@_;
    ($year++,$month++,$day++) if $diff;
    $period = 15 if !defined $period;
    my @dim=(31,31,0,31,30,31,30,31,31,30,31,30);
    my $old_time;
    if (defined $rop)
    {
        $old_time = $min,
        $sec = 0;
        if ( $period >= 1 && $period <= 60) {
            $old_time = $min;
            $min = ((($min/$period) % (60/$period))*$period);
            $min += $period if $rop < 0;
            $min += $rop*$period;
            $old_time = $min - $old_time;
        }
        elsif ( $period%60 == 0 && $period <= 1440 )
        {
            $period = $period/60;
            $min = 0;
            $old_time = $hour * 60;
            $hour = ((($hour/$period) % (24/$period))*$period);
            $hour += $period if $rop < 0;
            $hour += $rop*$period;
            $old_time = $hour * 60 - $old_time * 60;
        }
        else
        {
            ## This shouldn't happen. teSummaryConfiguration should catch this error.
            print "ERROR! $period is not a valied value for period. It must be 1-60 or max 1440 and divideable with 60\n";
        }

    }
    while($sec>59)
    {
        $sec-=60;
        $min++;
    }
    while($sec<0)
    {
        $sec+=60;
        $min--;
    }
    while($min>59)
    {
        $min-=60;
        $hour++;
    }
    while($min<0)
    {
        $min+=60;
        $hour--;
    }
    while($hour>23)
    {
        $hour-=24;
        $day++;
    }
    while($hour<0)
    {
        $hour+=24;
        $day--;
    }
    while($day>($dim[($month+12000)%12]==0?$self->is_leap_year($year)?29:28:$dim[($month+12000)%12]))
    {
        $day-=$dim[$month]==0?$self->is_leap_year($year)?29:28:$dim[$month];
        $month++;
    }
    while($day<1)
    {
        $day+=$dim[($month+11999)%12]==0?$self->is_leap_year($year)?29:28:$dim[($month+11999)%12];
        $month--;
    }
    while($month>12)
    {
        $month-=12;
        $year++;
    }
    while($month<1)
    {
        $month+=12;
        $year--;
    }
    ($year--,$month--,$day--) if $diff;
    return ($year,$month,$day,$hour,$min,$sec,$old_time);
}

sub timeparser::is_leap_year()
{
    my $self = shift;
        return ($_[0]%4)?($_[0]%100)?($_[0]%400)?0:1:0:1;
}
1;
