#!/APPS/COMMON/perl-5.8.7/bin/perl 

#/vobs/cello/cade_struct/SunOS/sparc/bin/perl
#/usr/bin/perl

use Net::Telnet;
use Net::SSH::Expect;

# Revision History:
#============================================================================================
# v1.0  etkvad    05-11-2008      first draft
# v1.1  etkvad    27-01-2009      add coli for etmf41
# v1.2  etkvad    20-02-2009      cpu load check added
# v1.3  etkvad    20-03-2009      etm4 coli added
# v1.4  etkvad    05-03-2010      cbm coli added, phy coli added, aal05 coli added
# v1.5  etkvad    05-22-2010      ssh support, 5 speed levels
# v1.6  etkvad    05-17-2011      fixed c41 bug, add supprot for mf4v2, add atmcc fro
# v1.7  etkvad    18-12-2012      release in moshell: etmc41s added, cpu measure fix, te e info added, spashwinfo egrq/ingrq added
#                                 cbm removed, IsBoardSupported added



sub printhelpinfo {
  # help info printed
  $0 =~ /\/(\w+)$/;
  print<<EOF;
Usage  : atm_dcg.pl -help -node <node> -user <user> -passwd <pwd> -slot <XXYY00> -out <output_folder> -usf <true|false> -protocol <telnet|ssh> -speed <1-5> default: -help
Descr. : Script connects to the specifed <node> /<slot> using <user>/<pwd> and collects  following ATM coli cmds:

         - AET RO & FRO  : aet_atmbp program, aet_atmbp atmportro, aet_atmmp etatmportfro, aet_atmbp vpcp
           aet_atmmp vpcpfro, aet_atmbp vpcep, aet_atmmp vpcepfro, aet_atmbp vccp, aet_atmmp vccpfro, 
           aet_atmbp vccep, aet_atmmp vccepfro, aet_atmmp atmsetro, aet_atmmp xxx classdata, aet_atmmp program,
           aet_aal2mp aal2pathepadm, aet_aal2mp aal2mdsetro, aet_aal2mp aal2qospfro, aet_aal2mp cacse, aet_aal2mp imf,
           aet_aal2bp program, aet_aal2bp aal2cpsdtro, aet_aal2bp aal2cpro, aet_imabp locimasetro, aet_imabp imalinkro
           aet_imabp imagroupro, aet_imamp imalinkfro, aet_imamp imagroupfro
         - windrv coli cmds :  winAtmCmd portData, winAtmCmd portStats, winAtmCmd queryVP, winAtmCmd vpData,
           winAtmCmd vpStats, winAtmCmd queryVc, winAtmCmd vcData, winAtmCmd VcStats, winAal2Cmd pathData,
           winAal2Cmd pathStats, winAal2Cmd activeCid, winImaCmd linkData, linkStats, linkState, queryLink,
           linkICPcellGet, groupData, groupStats, groupState, queryGroup, groupICPcellGet, winAtcCmd linkData
         - suni driver : sunidrv_dump all
         - tact driver : tactCmd g,  tactCmd v,  tactCmd d,  tactCmd u, tactCmd e,  tactCmd w,  tactCmd t,  tactCmd f
         - ultra mapper driver : umDrvCmd s state,  umDrvCmd s pdh
         - te3falc driver coli cmds : phy_te3fDrv
         - PHY EQMT coli cmds : phy_eqmtbp eqmtro
         - atlas, abm, amd drivers coli cmds from etm4
         - PHY coli cmds phyos155_status, phyhp_status, phylp_status, phylpdh_status, phymspg_status
         - QFalc drive on CBM : qfDrvCmd s state
         - AAL1,AAL5 coli cmds:  aal5cepfro -l, aal5cepfro -ld, aal5dyncep -l, aal5dynres PIU, al5dynres SP, aal5dynres FE, 
           aal5eficlient -l, aal5ericlient -l, aal5statcep -l, aal5statres -l, aal5statres PIU, aal5statres SP, aal05ccfro -l, 
           aal05connid -l, aal05portid -l, aal05serverid -l, aal1ccfro -l, aal1cepfro -l, aal1cepfro -ld, aal1connid -l, 
           aal1ncc pen, aal1ncc pen, aal1portid -l, aal1serverid -l, aal1statres -l

         If -usf  is true then script will only  prepare cmd file in  <output_folder> named .cmds
         This cmd file can be ftp-ed  to the node and executed with the "shell -f <commandfile>".
         If -usf  is false then script will collect coli cmds using telent or ssh and store the output in  <output_folder>/<name>.coli
         -usf true should be much faster.

         -speed <1-5> specifes nubmer of device coli to be collected this is increasing/decreasing collection time  1=slowest , 5=fastest

Version: $ver
EOF
  exit 0;
}


sub print_time {
  my ($year,$month,$day,$hour,$min,$sec,@ymd);
  ($sec,$min,$hour) = localtime();
  @ymd = (localtime)[3..5]; # grabs day/month/year values
  $month = $ymd[1]+1;
  $day = $ymd[0];
  $year = $ymd[2]+1900;
  if ($month =~ m/^[0-9]{1}$/gi) { $month="0".$month; }
  if ($day =~ m/^[0-9]{1}$/gi)   { $day="0".$day; }
  if ($hour =~ m/^[0-9]{1}$/gi)  { $hour="0".$hour; }
  if ($min =~ m/^[0-9]{1}$/gi)   { $min="0".$min; }
  if ($sec =~ m/^[0-9]{1}$/gi)   { $sec="0".$sec; }
  undef @ymd;
  print ">> Date: $day-$month-$year Time: $hr:$min:$sec\n";
  return;
}

sub COLI2collect {
  my ($numParameters,$coli2collect,@cmd_out,@cmd_out_tmp, $exec_out, $extractData,$ssh_line, $random_number);
  $numParameters = @_ ;
  #print "number of input parameters: $numParameters\n";
  if ($numParameters < 2  ) { print "COLI2collect() :: missing input parameters !\n"; return 0; }
  else {
    $coli2collect = $_[0];
    $extractData = $_[1];
    if ($debug eq "TRUE") { print ">> $coli2collect\n"; }
    if ( $use_shell_f eq "true" ) {
      $echo_coli = "echo \$ ".$coli2collect;
      print coli_cmd_output_file "$echo_coli\n";
      print coli_cmd_output_file "$coli2collect\n";
      if ($extractData eq "true" ) {
	$random_number = int(rand(39))+1;
	if ($random_number%13 == 0 ) {
	  checkCPULoad("mainmp");
	  checkCPULoad($slot);
	}
	if ( $protocol eq "telnet" ) {	  @cmd_out = $telnet->cmd($coli2collect); }
	else {
	  $ssh->send("$coli2collect");
	  while ( defined ($ssh_line = $ssh->read_line()) ) {
	    $ssh_line =~ s/\r//g;
	    push (@cmd_out, $ssh_line);
	  }
	}
      }
    } else {
      if ( $protocol eq "telnet" ) {      @cmd_out = $telnet->cmd($coli2collect); }
      else {
	$ssh->send("$coli2collect");
	while ( defined ($ssh_line = $ssh->read_line()) ) {
	  $ssh_line =~ s/\r//g;
	  push (@cmd_out, $ssh_line);
	  print Input_log_file "$ssh_line\n";
	}
	print Output_log_file "$coli2collect\n";
      }
    }
  }
  return @cmd_out;
}; #end COLI2collect

sub measureCPULoad {
  my ($slot2check, $numParameters,$cmd2run, @cmd_out, $match, $cmd2run, @cpuLoad_g,$cpuLoad,$elem, @cpuLoad_values,$ssh_line);
  $numParameters = @_ ;
  if ($numParameters < 1  ) { print "measureCPULoad() :: missing input parameters !\n"; return 0; }
  else {
    $slot2check = $_[0];
    $maxCpuLoad = -100;
    if ( $slot2check eq "mainmp") { $cmd2run = "capi tot"; }
    else { $cmd2run = "lhsh $slot2check capi tot"; }
    if ( $protocol eq "telnet" ) {
      @cmd_out = $telnet->cmd($cmd2run);
    }
    else {
      $ssh->send("$cmd2run");
      while ( defined ($ssh_line = $ssh->read_line()) ) {
	$ssh_line =~ s/\r//g;
	push (@cmd_out, $ssh_line);
      }
    }
    @cpuLoad_g = grep (/Load/, @cmd_out);
    foreach $match (@cpuLoad_g) {
      if  ($match =~ m/Load\s\(\%\)\s+(\S+.*)$/gi) { 
	$cpuLoad = $1; 
	@cpuLoad_values = split (/\s+/, $cpuLoad);
	foreach $elem (@cpuLoad_values) { 
	  #print " cpuload = $elem , ";
	  if ($elem > $maxCpuLoad) { $maxCpuLoad = $elem; }
	}
      }
    }
  }
#  print "measureCPULoad() :: CPU load on $slot2check = $maxCpuLoad %\n";
  if ( $maxCpuLoad == -100) {  $maxCpuLoad = 101; }
  return $maxCpuLoad;
}


sub checkCPULoad {
  my ($numParameters,$measuredCPULoad, $slot2check);
  $numParameters = @_ ;
  #print "number of input parameters: $numParameters\n";
  if ($numParameters < 1  ) { print "checkCPULoad() :: missing input parameters !\n"; return 0; }
  else {
    $slot2check = $_[0];
    if ($checkCPU eq "TRUE") {
      if ($debug eq "TRUE") { print ">> checking cpu load on slot $slot2check .."; }
      #1st CPU load check
      $measuredCPULoad = measureCPULoad($slot2check);
      $measuredCPULoad = measureCPULoad($slot2check);
      if ($measuredCPULoad > $maxCpuLoadLimit ) { 
	print  ">> 1 : CPU load check FAIL ! CPU load  $measuredCPULoad % is higher then $maxCpuLoadLimit % .. waiting $sleeptime4CPUload sec\n";
	sleep($sleeptime4CPUload);
	#2nd check if CPU load is lower
	$measuredCPULoad = measureCPULoad($slot2check);
	if ($measuredCPULoad > $maxCpuLoadLimit ) { 
	  print  ">> 2 : CPU load is $measuredCPULoad % which is still higer then $maxCpuLoadLimit..  waiting $sleeptime4CPUload sec\n";
	  sleep($sleeptime4CPUload);
	  #3rd check if CPU load is lower
	  $measuredCPULoad = measureCPULoad($slot2check);
	  if ($measuredCPULoad > $maxCpuLoadLimit ) { 
	    print  ">> 3 : CPU load is $measuredCPULoad % which is still higer then $maxCpuLoadLimit..  waiting $sleeptime4CPUload sec\n";
	    sleep($sleeptime4CPUload);
	    #4th check if CPU load is lower
	    $measuredCPULoad = measureCPULoad($slot2check);
	    if ($measuredCPULoad > $maxCpuLoadLimit ) { 
	      print  ">> 4 : CPU load is $measuredCPULoad % which is still higer then $maxCpuLoadLimit..  waiting $sleeptime4CPUload sec\n";
	      sleep($sleeptime4CPUload);
	      #5th check if CPU load is lower
	      $measuredCPULoad = measureCPULoad($slot2check);
	      if ($measuredCPULoad > $maxCpuLoadLimit ) {
		print  ">> 5 : CPU load is $measuredCPULoad % which is still higer then $maxCpuLoadLimit..  aborting dcg collection !\n";
		die "### CPU load $measuredCPULoad % is to high for coli cmd collection\n";
	      } else { print ">> CPU load check is now ok, CPU load is $measuredCPULoad % which is lower then $maxCpuLoadLimit %\n"; }
	    } else { print ">> CPU load check is now ok, CPU load is $measuredCPULoad % which is lower then $maxCpuLoadLimit %\n"; }
	  } else { print ">> CPU load check is now ok, CPU load is $measuredCPULoad % which is lower then $maxCpuLoadLimit %\n"; }
	} else { print ">> CPU load check is now ok, CPU load is $measuredCPULoad % which is lower then $maxCpuLoadLimit %\n"; }
      } else { 
	if ($debug eq "TRUE") { print ">> CPU load check is now ok, CPU load is $measuredCPULoad % which is lower then $maxCpuLoadLimit %\n"; }
      }
    }
  }
  return;
}

sub addImaGrpId {
  my ($numParameters,$newImaGrpId, $imagrpid_found, $numOfImaGrpIds, $i);
  $numParameters = @_ ;
  #print "number of input parameters: $numParameters\n";
  if ($numParameters == 0 ) { print "addImaGrpId() :: missing input parameters !\n"; return 0; }
  else {
    $newImaGrpId = $_[0];
    $imagrpid_found = "FALSE";
    $numOfImaGrpIds = @ImaGrpIds;
    #print "numOfImagrops = $numOfImaGrpIds\n";
    if ( $numOfImaGrpIds == 0 ) { push (@ImaGrpIds, $newImaGrpId); }
    else {
      $i = 0;
      while ($imagrpid_found eq "FALSE" && $i<$numOfImaGrpIds) {
	if ( $ImaGrpIds[$i] == $newImaGrpId   ) {	$imagrpid_found = "TRUE"; }
	$i++;
      }
      if ($imagrpid_found eq "FALSE") { 
	push (@ImaGrpIds, $newImaGrpId); 
	#print "imagroupid=$newImaGrpId added\n";
      } #else { print "imagroupid=$newImaGrpId already exists\n"; }
    }
  }
  return;
}; #end addImaGrpId

sub checkIfImaGroupDataIsCollected {
  my ($numParameters, $newImaGroupId, $imaGroupId);
  $numParameters = @_ ;
  #print "number of input parameters: $numParameters\n";
  if ($numParameters < 2 ) { print "IsImaGroupDataCollected() :: missing input parameters !\n"; return 0; }
  else {
    $newImaGroupId = $_[0];
    $IsImaGroupDataCollected = $_[1]; #GLOBAL Var
    $numOfCollectedImaGrpIds = @CollectedImaGroupIds;
    if ( $numOfCollectedImaGrpIds == 0 ) { 
      push (@CollectedImaGroupIds, $newImaGroupId);
      $IsImaGroupDataCollected = "FALSE";
      return;
    } else {
      foreach $imaGroupId (@CollectedImaGroupIds) {
	if ($imaGroupId eq $newImaGroupId) {
	  $IsImaGroupDataCollected = "TRUE";
	  return;
	}
      }
      push (@CollectedImaGroupIds, $newImaGroupId);
      $IsImaGroupDataCollected = "FALSE";
      return;
    }
}
return ;
}

sub winCmd {
  my ($numParameters, $cmd2run, @cmd_out);
  #winCmd VersionCheck
  $cmd2run = "lhsh ".$slot." winCmd VersionCheck Synchronous True";
  @cmd_out = COLI2collect($cmd2run,"false");
  #winCmd Utilization
  if ($EtBoardType ne "TP1") {
    $cmd2run = "lhsh ".$slot." winCmd Utilization numOfMeas 1 Synchronous True";
    @cmd_out = COLI2collect($cmd2run,"false");
  }
  #winCmd LoadRegulationRead
  #removed becasue it causes crash of windrv proc
  #  $cmd2run = "lhsh ".$slot." winCmd LoadRegulationRead";
  #  @cmd_out = COLI2collect($cmd2run,"false");
  return;
}; #end winCmd

sub winAtcCmd {
  my ($numParameters, $cmd2run, @cmd_out, $phyLineNo, $logLineNo);
  $numParameters = @_ ;
  #print "number of input parameters: $numParameters\n";
  if ($numParameters < 2 ) { print "winAtcCmd() :: missing input parameters !\n"; return 0; }
  else {
    $phyLineNo = $_[0];
    $logLineNo = $_[1];
    # winAtcCmd linkData
    $cmd2run = "lhsh ".$slot." winAtcCmd linkData $phyLineNo $logLineNo";
    @cmd_out = COLI2collect($cmd2run,"false");	
    # winAtcCmd queryLink
    $cmd2run = "lhsh ".$slot." winAtcCmd queryLink PhyLine $phyLineNo LogLine $logLineNo Frame 1";
    @cmd_out = COLI2collect($cmd2run,"false");
    # winAtcCmd configMode .... not needed in dcg ..example      winAtcCmd configMode Mode 2 SW False
    # winAtcCmd configDS0Group .... not needed in dcg
    # winAtcCmd configAUXLink .... not needed in dcg
    # winAtcCmd configPort .... not needed in dcg
    # winAtcCmd loopMode .... not needed in dcg
    # winAtcCmd linkStats ... doesn't work ?
  }
  return;
}; #end winAtcCmd

sub winAal2Cmd {
  my ($numParameters, $cmd2run, @cmd_out, $muxId);
  $numParameters = @_ ;
  #print "number of input parameters: $numParameters\n";
  if ($numParameters < 1 ) { print "winAal2Cmd() :: missing input parameters !\n"; return 0; }
  else {
    $muxId = $_[0];
    #winAal2Cmd pathStats
    $cmd2run = "lhsh ".$slot." winAal2Cmd pathStats $muxId";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winAal2Cmd pathData
    $cmd2run = "lhsh ".$slot." winAal2Cmd pathData $muxId";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winAal2Cmd activeCid
    $cmd2run = "lhsh ".$slot." winAal2Cmd activeCid $muxId";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winAal2Cmd pathStats : removed to speed things up
#    $cmd2run = "lhsh ".$slot." winAal2Cmd pathStats $muxId";
#    @cmd_out = COLI2collect($cmd2run,"false");
    #winAal2Cmd timerCU ... not needed in dcg
    #winAal2Cmd cidData ... not needed in dcg
  }
  return;
}; #end winAal2Cmd

sub winAtmCmd {
  my ($numParameters, $portNumber, $cmd2run, $line, $VpID, $vpi, $port, $cmd_line, $VcID_line, $VcID, $vci, $aaltype, $vcLinkId, $vci_line, $muxId, $cmd_counter);
  my (@cmd_out, @portData, @lines , @VpIDs, @vpi_lines, @VcID_lines, @VcIDs, @vci_lines);
  $numParameters = @_ ;
  #print "number of input parameters: $numParameters\n";
  if ($numParameters < 1 ) { print "winAtmCmd() :: missing input parameters !\n"; return 0; }
  else {
    $portNumber = $_[0];
  #  print "winAtmCmd() :: portNumber = $portNumber\n";
    #winAtmCmd queryIf
    $cmd2run = "lhsh ".$slot." winAtmCmd queryIf $portNumber";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winAtmCmd portStats
    $cmd2run = "lhsh ".$slot." winAtmCmd portStats $portNumber";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winAtmCmd portData
    $cmd2run = "lhsh ".$slot." winAtmCmd portData $portNumber";
    @cmd_out = COLI2collect($cmd2run,"true");
    push (@portData, @cmd_out);
    #winAtmCmd setTrafPar ... not needed in dcg
    #winAtmCmd setPolicePar ... not needed in dcg
    @lines = grep (/VpID/, @portData);
    foreach $line (@lines) {
      #print "cheking porData  line = $line\n";
      if ( $line =~ m/^VpID\s+([0-9]+)\s+.+\s+VpID\s+([0-9]+)\s+.+\s+VpID\s+([0-9]+)\s+.+\s+VpID\s+([0-9]+)/gi) {
	push (@VpIDs, $1);
	push (@VpIDs, $2);
	push (@VpIDs, $3);
	push (@VpIDs, $4);
      }
      elsif ( $line =~ m/^VpID\s+([0-9]+)\s+.+\s+VpID\s+([0-9]+)\s+.+\s+VpID\s+([0-9]+)/gi) {
	push (@VpIDs, $1);
	push (@VpIDs, $2);
	push (@VpIDs, $3);
      }
      elsif ( $line =~ m/^VpID\s+([0-9]+)\s+.+\s+VpID\s+([0-9]+)/gi) {
	push (@VpIDs, $1);
	push (@VpIDs, $2);
      }
      elsif ( $line =~ m/^VpID\s+([0-9]+)/gi) {
	push (@VpIDs, $1);
      }
    }
    undef @lines;
    undef @portData;
    $cmd_counter=0;
    foreach $VpID (@VpIDs) {
      if ($cmd_counter%$speed == 0 ) {
	#winAtmCmd queryVP
	$cmd2run = "lhsh ".$slot." winAtmCmd queryVP $VpID";
	@cmd_out = COLI2collect($cmd2run,"true");
	$vpi  = 99999;
	$port = 99999;
	@vpi_lines = grep (/vpConfig/, @cmd_out);
	foreach $cmd_line (@vpi_lines) {
	  #print "cmd_line =  $cmd_line";
	  if ($cmd_line =~ m/vpConfig\.vpi\s+=\s+([0-9]+)/gi)     { $vpi  = $1; }
	  elsif ($cmd_line =~ m/vpConfig\.ifId\s+=\s+([0-9]+)/gi) { $port = $1; }
	}
	undef @vpi_lines;
	if ($vpi == 99999 || $port == 99999 ) {
	  if ($debug eq "TRUE") { print ">> ERROR :: Can't find vpi=$vpi, port=$port in winAtmCmd queryVP $VpID output\n"; }
	} else {
	  #winAtmCmd vpStats
	  $cmd2run = "lhsh ".$slot." winAtmCmd vpStats $port $vpi";
	  @cmd_out = COLI2collect($cmd2run,"false");
	  #winAtmCmd vpData
	  $cmd2run = "lhsh ".$slot." winAtmCmd vpData $port $vpi";
	  @cmd_out = COLI2collect($cmd2run,"true");
	  @VcID_lines = grep (/VcID/, @cmd_out);
	  #winAtmCmd vpStats : removed to speed up things
	  #	$cmd2run = "lhsh ".$slot." winAtmCmd vpStats $port $vpi";
	  #	@cmd_out = COLI2collect($cmd2run,"false");
	  $vpi  = 99999;
	  $port = 99999;
	  foreach $VcID_line (@VcID_lines) {
	    if ($VcID_line =~ m/^VcID\s+([0-9]+)\s+.+VcID\s+([0-9]+)\s+.+VcID\s+([0-9]+)\s+.+VcID\s+([0-9]+)/gi) { 
	      push (@VcIDs, $1);
	      push (@VcIDs, $2);
	      push (@VcIDs, $3);
	      push (@VcIDs, $4);
	    }
	    elsif ($VcID_line =~ m/^VcID\s+([0-9]+)\s+.+VcID\s+([0-9]+)\s+.+VcID\s+([0-9]+)/gi) { 
	      push (@VcIDs, $1);
	      push (@VcIDs, $2);
	      push (@VcIDs, $3);
	    }
	    elsif ($VcID_line =~ m/^VcID\s+([0-9]+)\s+.+VcID\s+([0-9]+)/gi) { 
	      push (@VcIDs, $1);
	      push (@VcIDs, $2);
	    }
	    elsif ($VcID_line =~ m/^VcID\s+([0-9]+)/gi) { 
	      push (@VcIDs, $1);
	    }
	  }
	  undef @VcID_lines;
	  foreach $VcID (@VcIDs) {
	    #winAtmCmd queryVc
	    $cmd2run = "lhsh ".$slot." winAtmCmd queryVc $VcID";
	    @cmd_out = COLI2collect($cmd2run,"true");
	    @vci_lines = grep (/vcConfig/, @cmd_out);
	    $vpi  = 99999;
	    $port = 99999;
	    $vci  = 99999;
	    $aaltype = "NULL";
	    $vcLinkId = 99999;
	    foreach $vci_line (@vci_lines) {
	      #print "checking vci line $vci_line";
	      if    ($vci_line =~ m/vcConfig\.vc\.vpi\s+=\s+([0-9]+)/gi)  { $vpi  = $1; }
	      elsif ($vci_line =~ m/vcConfig\.ifId\s+=\s+([0-9]+)/gi)     { $port = $1; }
	      elsif ($vci_line =~ m/vcConfig\.vc\.vci\s+=\s+([0-9]+)/gi)  { $vci  = $1;}
	      elsif ($vci_line =~ m/vcConfig\.vcLinkId\s+=\s+([0-9]+)/gi) { $vcLinkId  = $1; }
	      elsif ($vci_line =~ m/vcConfig\.aalType\s+=\s+\S+AAL2/gi)   { $aaltype  = "AAL2"; }
	    }
	    undef @vci_lines;
	    if ($vpi == 99999 || $port == 99999 || $vci == 99999) {
	      if ($debug eq "TRUE") { print">> ERROR :: Can't find vpi=$vpi, port=$port, vci=$vci, vcLinkId=$vcLinkId from winAtmCmd queryVc $VcID output\n"; }
	    } else {
	      #winAtmCmd vcStats
	      $cmd2run = "lhsh ".$slot." winAtmCmd vcStats $port $vpi $vci";
	      @cmd_out = COLI2collect($cmd2run,"false");
	      #winAtmCmd vcData
	      $cmd2run = "lhsh ".$slot." winAtmCmd vcData $port $vpi $vci";
	      @cmd_out = COLI2collect($cmd2run,"false");
	      #winAtmCmd vcStats : removed to speed up things
	      #	    $cmd2run = "lhsh ".$slot." winAtmCmd vcStats $port $vpi $vci";
	      #	    @cmd_out = COLI2collect($cmd2run,"false");
	      $vpi  = 99999;
	      $port = 99999;
	      $vci  = 99999;
	    }
	    if ($vcLinkId != 99999 && $aaltype eq "AAL2" ) {
	      if ($EtBoardType eq "CBM1" || $EtBoardType eq "CBM") {  $muxId = $vcLinkId - 56; }
	      else {                                                  $muxId = $vcLinkId - 320; }
	      winAal2Cmd($muxId);
	      $aaltype = "NULL";
	      $vcLinkId = 99999;
	    }
	  }
	  undef @VcIDs;
	}
      }
      $cmd_counter++;
    }
    undef @VpIDs;
  }
  return;
}; #end winAtmCmd



sub winImaCmd {
  my ($numParameters, $phyLineNo, $logLineNo, $cmd2run, $match, $elem);
  my (@cmd_out, @groupID_g);
  $numParameters = @_ ;
  #print "number of input parameters: $numParameters\n";
  if ($numParameters < 2 ) { print "winImaCmd() :: missing input parameters !\n"; return 0; }
  else {
    $phyLineNo = $_[0];
    $logLineNo = $_[1];
   # print "winImaCmd() :: phyLineNo = $phyLineNo ,  logLineNo =  $logLineNo\n";
    # winImaCmd linkData
    $cmd2run = "lhsh ".$slot." winImaCmd linkData $phyLineNo $logLineNo";
    @cmd_out = COLI2collect($cmd2run,"true");
    @groupID_g = grep (/imaGroupID/, @cmd_out);
    #print "grep = @groupID_g \n";
    foreach $match (@groupID_g) {
      #print "checking $match\n";
      if ( $match =~ m/imaGroupID\:\s+([0-9]+)/gi) {
	#print "checking imagroupid=$1\n";
	$newImaGrpId = $1;
	&addImaGrpId( $newImaGrpId );
      }
    }
    #winImaCmd linkStats
    $cmd2run = "lhsh ".$slot." winImaCmd linkStats $phyLineNo $logLineNo";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winImaCmd linkState
    $cmd2run = "lhsh ".$slot." winImaCmd linkState $phyLineNo $logLineNo";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winImaCmd queryLink
    $cmd2run = "lhsh ".$slot." winImaCmd queryLink $phyLineNo $logLineNo";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winImaCmd linkICPcellGet 3 times : 2 removed to speed things up
    $cmd2run = "lhsh ".$slot." winImaCmd linkICPcellGet $phyLineNo $logLineNo";
    @cmd_out = COLI2collect($cmd2run,"false");
#    $cmd2run = "lhsh ".$slot." winImaCmd linkICPcellGet $phyLineNo $logLineNo";
#    @cmd_out = COLI2collect($cmd2run,"false");
#    $cmd2run = "lhsh ".$slot." winImaCmd linkICPcellGet $phyLineNo $logLineNo";
#    @cmd_out = COLI2collect($cmd2run,"false");
    #winImaCmd lsmQuery
    $cmd2run = "lhsh ".$slot." winImaCmd lsmQuery $phyLineNo $logLineNo";
    @cmd_out = COLI2collect($cmd2run,"false");

 #   $IsImaGroupDataCollected = "TRUE";
 #   &checkIfImaGroupDataIsCollected($newImaGrpId,$IsImaGroupDataCollected);
 #   if ($IsImaGroupDataCollected eq "FALSE") {

  }
  return;
}; #end winImaCmd

sub winImaCmd_Group {
  my ($cmd2run, $ImaGroupId,@cmd_out);
  checkCPULoad($slot);
  checkCPULoad("mainmp");
  foreach $ImaGroupId (@ImaGrpIds) {
    #winImaCmd groupData
    $cmd2run = "lhsh ".$slot." winImaCmd groupData $ImaGroupId";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winImaCmd groupStats
    $cmd2run = "lhsh ".$slot." winImaCmd groupStats $ImaGroupId";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winImaCmd groupState
    $cmd2run = "lhsh ".$slot." winImaCmd groupState $ImaGroupId";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winImaCmd queryGroup
    $cmd2run = "lhsh ".$slot." winImaCmd queryGroup $ImaGroupId";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winImaCmd groupICPcellGet 3 times: 2 removed to speed things up
    $cmd2run = "lhsh ".$slot." winImaCmd groupICPcellGet $ImaGroupId 0";
    @cmd_out = COLI2collect($cmd2run,"false");
    #    $cmd2run = "lhsh ".$slot." winImaCmd groupICPcellGet $ImaGroupId 0xffffffff";
    #    @cmd_out = COLI2collect($cmd2run,"false");
    $cmd2run = "lhsh ".$slot." winImaCmd groupICPcellGet $ImaGroupId 0xffffffff";
    @cmd_out = COLI2collect($cmd2run,"false");
    #winImaCmd groupTest ... not needed in dcg
    #winImaCmd groupTestQuery ... not needed in dcg
    winAtmCmd($ImaGroupId);
  }
  return;
}; #end of winImaCmd_Group

sub etmf4 {
  checkCPULoad($slot);
  checkCPULoad("mainmp");
  if ($debug eq "TRUE") { print_time(); }
  if (($RojNumber eq "ROJ1192291/2") || ($RojNumber eq "ROJ 119 2291/2")) {
    #MF4v2 (mf41 hw)
    print ">> Collecting ET-MF4 $RojNumber Glenkinchie driver coli cmds\n";
    ###############
    # Glenkinchie #
    ###############
    $cmd2run = "lhsh ".$slot." gkDrvCmd s state";
    @cmd_out = COLI2collect($cmd2run,"false");
    ##########
    # winDrv #
    ##########
    print ">> Collecting ET-MF4 $RojNumber WIN driver coli cmds\n";
    winCmd();
    for ($portNumber=0; $portNumber<=3; $portNumber++) {
      winAtmCmd($portNumber);
    }

  } else {
    ############
    # Suni Drv #
    ############
    print ">> Collecting ET-MF4 $RojNumber SUNI driver coli cmds\n";
    #sunidrv_dump all
    $cmd2run = "lhsh ".$slot." sunidrv_dump all";
    @cmd_out = COLI2collect($cmd2run,"false");
    ##########
    # winDrv #
    ##########
    print ">> Collecting ET-MF4 WIN driver coli cmds\n";
    winCmd();
    for ($portNumber=0; $portNumber<=3; $portNumber++) {
      winAtmCmd($portNumber);
    }
    # 2 do
    #### winAtmCmd    ####
    # winAtmCmd queryCe
    # winAtmCmd ceStats
    # winAtmCmd ceData
    ######################
  }
    if ($debug eq "TRUE") { print_time(); }
    return;
  }
sub etmf41 {
  my ($cmd_counter);
  checkCPULoad($slot);
  checkCPULoad("mainmp");
  if ($debug eq "TRUE") { print_time(); }
  print ">> Collecting ET-MF41 $RojNumber Glenkinchie driver coli cmds\n";
  ###############
  # Glenkinchie #
  ###############
  $cmd2run = "lhsh ".$slot." gkDrvCmd s state";
  @cmd_out = COLI2collect($cmd2run,"false");
  # no need for reading all registers  gkDrvCmd g status,  gkDrvCmd g config
  ##########
  # WinDrv #
  ##########
  print ">> Collecting ET-MF41 $RojNumber WIN driver coli cmds\n";
  #find out if it standard is ansi or etsi
  $cmd2run = "lhsh ".$slot."  winAtcCmd linkData 0 0";
  @cmd_out = COLI2collect($cmd2run,"true");
  @grep_frameFormat = grep (/frameFormat/, @cmd_out);
  foreach $grep_line (@grep_frameFormat) {
    if ($grep_line =~ m/^frameFormat\:\s+WINDRV_E1/gi) {
      $logLineMax = 62;
      $mf41_standard = "ETSI";
      print ">> ET-MF41 in ETSI mode, $logLineMax E1 links\n";
    } else {
      $logLineMax = 83;
      $mf41_standard = "ANSI";
      print ">> ET-MF41 in ANSI mode, $logLineMax T1 links\n";
    }
  }
  undef @grep_frameFormat;
  winCmd();
  # winImaCmd, winAtcCmd, winAtmCmd, winAal2Cmd for ima ports
  print ">> Collecting  winImaCmd, winAtcCmd, winAtmCmd, winAal2Cmd for ima ports  coli\n";
  for ($phyLineNo=0;$phyLineNo<=3; $phyLineNo++) {
    $cmd_counter=0;
    for ($logLineNo=0;$logLineNo<=$logLineMax; $logLineNo++) {
      if ($cmd_counter%$speed == 0 ) {
	# removed becasue it causes crash of windrv prov
	#	  winAtcCmd($phyLineNo, $logLineNo);
	winImaCmd($phyLineNo, $logLineNo);
      }
      $cmd_counter++;
    }; #end for logLineNo
  };#end for phyLineNo
  winImaCmd_Group();
  # winAtmCmd, winAal2Cmd for non-ima ports
  print ">> Collecting winAtmCmd, winAal2Cmd for non-ima ports coli\n";
  $max_port = ($logLineMax+1)*4-1;
  $cmd_counter=0;
  for ($portNumber=0; $portNumber<=$max_port; $portNumber++) {
    if ($cmd_counter%$speed == 0 ) {
      winAtmCmd($portNumber);
    }
    $cmd_counter++;
  }
  #### 2do
  #### CE and TDM   ####
  #### winAal1LcCmd ####
  # winAal1LcCmd portData
  # winAal1LcCmd lcData
  # winAal1LcCmd queryLink
  # winAal1LcCmd queryDS0Group
  #### winAtmCmd    ####
  # winAtmCmd queryCe
  # winAtmCmd ceStats
  # winAtmCmd ceData
  ######################
  if ($debug eq "TRUE") { print_time(); }
  return;
}


#### cbm sub not finished.. some errors are generated.. some stuff missing
####
sub cbm {
  checkCPULoad("mainmp");
   print ">> Collecting CBM drivers coli cmds\n";
   #############
   # qFalc Drv #
   #############
   print ">> Collecting CBM QFALC driver coli cmds\n";
   # qfDrvCmd s state
   for ($phyLineNo=0;$phyLineNo<4; $phyLineNo++) {
     $cmd2run = "lhsh ".$slot." qfDrvCmd s state $phyLineNo";
     @cmd_out = COLI2collect($cmd2run,"false");
   }
  ###############
  # Glenkinchie #
  ###############
  $cmd2run = "lhsh ".$slot." gkDrvCmd s state";
  @cmd_out = COLI2collect($cmd2run,"false");
  ##########
  # winDrv #
  ##########
  print ">> Collecting $EtBoardType WIN driver coli cmds\n";
  print ">> Collecting $EtBoardType winImaCmd, winAtcCmd, winAtmCmd, winAal2Cmd for ima ports  coli\n";
  winCmd();
  # winImaCmd, winAtcCmd, winAtmCmd, winAal2Cmd for ima ports el ports
  for ($phyLineNo=0;$phyLineNo<=5; $phyLineNo++) {
    for ($logLineNo=0;$logLineNo<=84; $logLineNo++) {
      #removed because it might cause crash of windrv proc
      #	  winAtcCmd($phyLineNo, $logLineNo);
      winImaCmd($phyLineNo, $logLineNo);
    }; #end for logLineNo
  };#end for phyLineNo
  winImaCmd_Group();
  # winAtmCmd, winAal2Cmd for non-ima ports
  print ">> Collecting winAtmCmd, winAal2Cmd for non-ima ports coli\n";
  for ($portNumber=0; $portNumber<=3; $portNumber++) {
    winAtmCmd($portNumber);
  }
  
  #### 2do
  #### CE and TDM   ####
  #### winAal1LcCmd ####
  # winAal1LcCmd portData
  # winAal1LcCmd lcData
  # winAal1LcCmd queryLink
  # winAal1LcCmd queryDS0Group
  #### winAtmCmd    ####
  # winAtmCmd queryCe
  # winAtmCmd ceStats
  # winAtmCmd ceData
  ######################
  if ($debug eq "TRUE") { print_time(); }
  
  return;
}



sub etc41 {
  my ($cmd_counter);
  checkCPULoad($slot);
  checkCPULoad("mainmp");
  if ($debug eq "TRUE") { print_time(); }
  ###############
  # UltraMapper #
  ###############
  print ">> Collecting ET-C41 UltraMapper driver coli cmds\n";
  #umDrvCmd s state
  $cmd2run = "lhsh ".$slot." umDrvCmd s state";
  @cmd_out = COLI2collect($cmd2run,"false");
  #umDrvCmd s pdh
  for ($j=0;$j<=3;$j++) {
    $cmd2run = "lhsh ".$slot." umDrvCmd s pdh ".$j;
    @cmd_out = COLI2collect($cmd2run,"false");
  }
  ########
  # Tact #
  ########
  print ">> Collecting ET-C41 Tact driver coli cmds\n";
  #tactCmd g
  $cmd2run = "lhsh ".$slot." tactCmd g";
  @cmd_out = COLI2collect($cmd2run,"false");
  for ($tact=0;$tact<=1;$tact++) {
    #tactCmd t
    $cmd2run = "lhsh ".$slot." tactCmd t ".$tact;
    @cmd_out = COLI2collect($cmd2run,"false");
    #tactCmd f
    $cmd2run = "lhsh ".$slot." tactCmd f ".$tact;
    @cmd_out = COLI2collect($cmd2run,"true");
    @NoOfLink = grep  (/E1/, @cmd_out);
    foreach $line (@NoOfLink) {
      if($line =~ m/^No\s+of\s+E1\/T1\s+links\s+on\s+TACT\:\s+([0-9]+)/gi) {
	$NoOfLinks = $1;
	$cmd_counter=0;
	for ($Chn=0;$Chn<$NoOfLinks;$Chn++) {
	  if ($cmd_counter%$speed == 0 ) {
	    if ((($NoOfLinks+1)/($Chn+1))>=2) {
	      $PhyLineNo = $tact*2;
	      $Chn2 = $Chn;
	    }   else {
	      $PhyLineNo = $tact*2+1;
	      $Chn2 = $Chn-$NoOfLinks/2;
	    }
	    $linkNo = sprintf("%x", $Chn);
	    $linkNo2 = sprintf("%x", $Chn2);
	    #tacCdm w
	    $cmd2run = "lhsh ".$slot." tactCmd w ".$PhyLineNo." ".$linkNo2." 2";
	    @cmd_out2 = COLI2collect($cmd2run,"false");
	    #tactCmd u
	    $cmd2run = "lhsh ".$slot." tactCmd u ".$PhyLineNo." ".$linkNo2;
	    @cmd_out2 = COLI2collect($cmd2run,"false");
	    #tactCmd e
	    $cmd2run = "lhsh ".$slot." tactCmd e ".$tact." ".$linkNo;
	    @cmd_out2 = COLI2collect($cmd2run,"true");
	    @NoOfTS = grep  (/Number/, @cmd_out2);
	    foreach $match (@NoOfTS) {
	      if ($match =~ m/Number\s+of\s+channels\s+on\s+link\:\s+([0-9]+)/gi) {
		$NoOfTs = $1;
		for ($ts=0;$ts<$NoOfTs;$ts=$ts+$speed) {
		  $tsHex = sprintf("%x", $ts);
		  #tacCdm v
		  $cmd2run = "lhsh ".$slot." tactCmd v ".$PhyLineNo." ".$linkNo2." ".$tsHex;
		  @cmd_out2 = COLI2collect($cmd2run,"false");
		  #tacCdm d
		  $cmd2run = "lhsh ".$slot." tactCmd d ".$tact." ".$linkNo." ".$tsHex;
		  @cmd_out2 = COLI2collect($cmd2run,"false");
		  #tacCdm v
		  # commented out to speed thigns up..
		  #		$cmd2run = "lhsh ".$slot." tactCmd v ".$PhyLineNo." ".$linkNo2." ".$tsHex;
		  #		@cmd_out2 = COLI2collect($cmd2run,"false");
		}
	      }
	    }
	    #tactCmd u
	    $cmd2run = "lhsh ".$slot." tactCmd u ".$PhyLineNo." ".$linkNo2;
	    @cmd_out2 = COLI2collect($cmd2run,"false");
	  }
	  $cmd_counter++;
	}
      }
    }
  }
  if ($debug eq "TRUE") { print_time(); }
  return;
}
sub te3falc_m3 {
  print ">> Collecting ET-M3 drivers coli cmds\n";
  checkCPULoad($slot);
  checkCPULoad("mainmp");
  ###########
  # TE3FALC #
  ###########
  print ">> Collecting ET-M3 TE3Falc drivers coli cmds\n";
  #phy_te3fDrv 0
  $cmd2run = "lhsh ".$slot." phy_te3fDrv 0";
  @cmd_out = COLI2collect($cmd2run,"false");
  #phy_te3fDrv 1
  $cmd2run = "lhsh ".$slot." phy_te3fDrv 1";
  @cmd_out = COLI2collect($cmd2run,"false");
  #phy_te3fDrv 0
  $cmd2run = "lhsh ".$slot." phy_te3fDrv 0";
  @cmd_out = COLI2collect($cmd2run,"false");
  #phy_te3fDrv 1
  $cmd2run = "lhsh ".$slot." phy_te3fDrv 1";
  @cmd_out = COLI2collect($cmd2run,"false");
 
  return;
}

sub aal1 {
  print ">> Collecting AAL1 coli cmds\n";
  checkCPULoad("mainmp");
  #aal1ccfro -l
  $cmd2run = "aal1ccfro -l";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aal1cepfro -l
  $cmd2run = "aal1cepfro -l";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aal1cepfro -ld
  $cmd2run = "aal1cepfro -ld";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aal1connid -l
  $cmd2run = "aal1connid -l";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aal1ncc pen
  $cmd2run = "aal1ncc pen";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aal1portid -l
  $cmd2run = "aal1portid -l";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aal1serverid -l
  $cmd2run = "aal1serverid -l";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aal1stat
  $cmd2run = "aal1stat";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aal1statres -l
  $cmd2run = "aal1statres -l";
  @cmd_out = COLI2collect($cmd2run,"false");
  return;
}


sub aal5_cbm {
  print ">> Collecting AAL5 CBM coli cmds\n";
  #2do
}
sub aal5 {
  print ">> Collecting AAL5 coli cmds\n";
  checkCPULoad("mainmp");
  if ($debug eq "TRUE") { print_time(); }
  if ($EtBoardType eq "CBM1" || $EtBoardType eq "CBM") {
    #aal5apterm
    $cmd2run = "aal5apterm";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5debug list
    $cmd2run = "aal5debug list";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5eph
    $cmd2run = "aal5eph";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5eph cep
    $cmd2run = "aal5eph cep";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5eph pc
    $cmd2run = "aal5eph pc";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5eph term
    $cmd2run = "aal5eph term";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5etterm -a
    $cmd2run = "aal5etterm -a";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5etterm -s
    $cmd2run = "aal5etterm -s";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5etterm -f
    $cmd2run = "aal5etterm -f";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5etterm -c
    $cmd2run = "aal5etterm -c";
    @cmd_out = COLI2collect($cmd2run,"false");
  }
  else {
    #aal5cepfro -l
    $cmd2run = "aal5cepfro -l";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5cepfro -ld
    $cmd2run = "aal5cepfro -ld";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5cepfro <froid> ... not implemented.. to many ceps it would take long time to collect
    #aal5dyncep -l
    $cmd2run = "aal5dyncep -l";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5dynres PIU
    $cmd2run = "aal5dynres PIU";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5dynres SP
    $cmd2run = "aal5dynres SP";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5dynres FE
    $cmd2run = "aal5dynres FE";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5eficlient -l
    $cmd2run = "aal5eficlient -l";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5ericlient -l
    $cmd2run = "aal5ericlient -l";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5statcep -l
    $cmd2run = "aal5statcep -l";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5statres -l
    $cmd2run = "aal5statres -l";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5statres PIU
    $cmd2run = "aal5statres PIU";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal5statres SP
    $cmd2run = "aal5statres SP";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal05ccfro -l
    $cmd2run = "aal05ccfro -l";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal05connid -l
    $cmd2run = "aal05connid -l";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal05portid -l
    $cmd2run = "aal05portid -l";
    @cmd_out = COLI2collect($cmd2run,"false");
    #aal05riconnref
    #aal05serverid -l
    $cmd2run = "aal05serverid -l";
    @cmd_out = COLI2collect($cmd2run,"false");
    ########################################################
    ################### aal1       #########################
    ########################################################
    aal1();
  }
  if ($debug eq "TRUE") { print_time(); }
  return;
}

sub phy_mp{
  print ">> Collecting PHY MP coli cmds\n";


  checkCPULoad("mainmp");
  if ($debug eq "TRUE") { print_time(); }
  $numOfHpFroIds = 0;
  $numOfos155FroIds = 0;
  $numOfpdhFroIds = 0;
  $numOflpdhFroIds = 0;
  foreach $phyPortFroId (@phyPortFroIds) {
    if ($phyPortFroId =~ m/^[0-9]{6}$/gi) {
      #unchannalised
      #phyhp_status
      $cmd2run = "phyhp_status $phyPortFroId";
      @cmd_out = COLI2collect($cmd2run,"false");
      if ($phyPortFroId =~ m/^([0-9]{4})/gi) { 
	$os155froid = $1;
	#phyos155_status
	$cmd2run = "phyos155_status $os155froid";
	@cmd_out = COLI2collect($cmd2run,"false");
	#phymspg_status
	$cmd2run = "phymspg_status $os155froid";
	@cmd_out = COLI2collect($cmd2run,"false");
      }
    }
    elsif ($phyPortFroId =~ m/^([0-9]{4})([0-9]{2})([0-9]{2})$/gi) {
      #channelised
      $os155froid = $1;
      $hpfroid = $os155froid.$2;
      #	print ">> hpfroid = $hpfroid , numOfHpFroIds= $numOfHpFroIds, os155froid = $os155froid ,numOfos155FroIds = $numOfos155FroIds, phyPortFroId = $phyPortFroId \n";
      $numOflpdhFroIds = @collected_lpdhFroIds;
      if ( $numOflpdhFroIds == 0 ) { 
	#phylpdh_status
	$cmd2run = "phylpdh_status $phyPortFroId";
	@cmd_out = COLI2collect($cmd2run,"false");
	#phylp_status
	$cmd2run = "phylp_status $phyPortFroId";
	@cmd_out = COLI2collect($cmd2run,"false");
	push (@collected_lpdhFroIds, $phyPortFroId);
      }
      else {
	$i = 0;
	$lpdhfroid_found = "FALSE";
	while ($lpdhfroid_found eq "FALSE" && $i<$numOflpdhFroIds) {
	  if ( $collected_lpdhFroIds[$i] == $phyPortFroId   ) {	$lpdhfroid_found = "TRUE"; }
	  $i++;
	}
	if ($lpdhfroid_found eq "FALSE") { 
	  #phylpdh_status
	  $cmd2run = "phylpdh_status $phyPortFroId";
	  @cmd_out = COLI2collect($cmd2run,"false");
	  push (@collected_lpdhFroIds, $phyPortFroId);
	  #phylp_status
	  $cmd2run = "phylp_status $phyPortFroId";
	  @cmd_out = COLI2collect($cmd2run,"false");
	}
      }
      #HP
      $numOfHpFroIds = @collected_HpFroIds;
      if ( $numOfHpFroIds == 0 ) { 
	#phyhp_status
	$cmd2run = "phyhp_status $hpfroid";
	@cmd_out = COLI2collect($cmd2run,"false");
	push (@collected_HpFroIds, $hpfroid);
      }
      else {
	$i = 0;
	$hpfroid_found = "FALSE";
	while ($hpfroid_found eq "FALSE" && $i<$numOfHpFroIds) {
	  if ( $collected_HpFroIds[$i] == $hpfroid   ) {	$hpfroid_found = "TRUE"; }
	  $i++;
	}
	if ($hpfroid_found eq "FALSE") { 
	  push (@collected_HpFroIds, $hpfroid);
	  #phyhp_status
	  $cmd2run = "phyhp_status $hpfroid";
	  @cmd_out = COLI2collect($cmd2run,"false");
	}
      }
      #os155
      $numOfos155FroIds = @collected_os155FroIds;
      if ( $numOfos155FroIds == 0 ) { 
	#phyos155_status
	$cmd2run = "phyos155_status $os155froid";
	@cmd_out = COLI2collect($cmd2run,"false");
	push (@collected_os155FroIds, $os155froid);
	#phymspg_status
	$cmd2run = "phymspg_status $os155froid";
	@cmd_out = COLI2collect($cmd2run,"false");
      }
      else {
	$i = 0;
	$os155froid_found = "FALSE";
	while ($os155froid_found eq "FALSE" && $i<$numOfos155FroIds) {
	  if ( $collected_os155FroIds[$i] == $os155froid   ) {	$os155froid_found = "TRUE"; }
	  $i++;
	}
	if ($os155froid_found eq "FALSE") { 
	  #phyos155_status
	  $cmd2run = "phyos155_status $os155froid";
	  @cmd_out = COLI2collect($cmd2run,"false");
	  push (@collected_os155FroIds, $os155froid);
	  #phymspg_status
	  $cmd2run = "phymspg_status $os155froid";
	  @cmd_out = COLI2collect($cmd2run,"false");
	}
      }
    }
    elsif ($phyPortFroId =~ m/^[0-9]{4}$/gi) {
      #HPDH ETM3
      #phyhpdh_status
      $cmd2run = "phyhpdh_status $phyPortFroId";
      @cmd_out = COLI2collect($cmd2run,"false");
    }
    else {
      #PDH
      $numOfpdhFroIds = @collected_pdhFroIds;
      #	print ">> PDH: numOfpdhFroIds = $numOfpdhFroIds , phyPortFroId = $phyPortFroId\n";
      if ( $numOfpdhFroIds == 0 ) { 
	#phylpdh_status
	$cmd2run = "phylpdh_status $phyPortFroId";
	@cmd_out = COLI2collect($cmd2run,"false");
	push (@collected_pdhFroIds, $phyPortFroId);
      }
      else {
	$i = 0;
	$pdhfroid_found = "FALSE";
	while ($pdhfroid_found eq "FALSE" && $i<$numOfpdhFroIds) {
	  if ( $collected_pdhFroIds[$i] == $phyPortFroId   ) {	$pdhfroid_found = "TRUE"; }
	  $i++;
	}
	if ($pdhfroid_found eq "FALSE") { 
	  #phylpdh_status
	  $cmd2run = "phylpdh_status $phyPortFroId";
	  @cmd_out = COLI2collect($cmd2run,"false");
	  push (@collected_pdhFroIds, $phyPortFroId);
	}
      }
    }
  }; #end foreach phyportfroid

  #phyos155_status_all
  $cmd2run = "phyos155_status_all";
  @cmd_out = COLI2collect($cmd2run,"false");
  #phyhp_status_all
  $cmd2run = "phyhp_status_all";
  @cmd_out = COLI2collect($cmd2run,"false");
  #phymspg_status_all
  $cmd2run = "phymspg_status_all";
  @cmd_out = COLI2collect($cmd2run,"false");
  if ($debug eq "TRUE") { print_time(); }
  return;
}

sub ds0_bp_mp {
  my ($cmd_counter);
  print ">> Collecting aet_ds0bp aet_ds0mp  coli cmds\n";
  checkCPULoad("mainmp");
  checkCPULoad($slot);
  if ($debug eq "TRUE") { print_time(); }
  #aet_ds0bp progprogram classda
  $cmd2run = "lhsh ".$slot." aet_ds0bp program classdata";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aet_ds0bp ds0BundleRo classdata
  $cmd2run = "lhsh ".$slot." aet_ds0bp ds0BundleRo classdata";
  #aet_ds0bp ds0BundleRo list
  @cmd_out = COLI2collect($cmd2run,"false");
  $cmd2run = "lhsh ".$slot." aet_ds0bp ds0BundleRo list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @ds0ros = split (/\s/, $line);
      $cmd_counter=0;
      foreach $ds0bundlero (@ds0ros) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "lhsh ".$slot." aet_ds0bp ds0BundleRo ".$ds0bundlero;
	  @cmd_out2 = COLI2collect($cmd2run,"true");
	  if ($EtBoardType eq "ET-MC41" || $EtBoardType eq "ET-MC41S" || $EtBoardType eq "ET-MC1" || $EtBoardType eq "ET-M3" || $EtBoardType eq "CBU" ||  $EtBoardType eq "CBU1" ) {
	    @ds0_lineNumber = grep (/LineNo/, @cmd_out2);
	    foreach $x (@ds0_lineNumber) {
	      if    ($x =~ m/phyLineNo\:\s+([0-9]+)/gi) { push (@ds0_phyLineNumbers, $1); }
	      elsif ($x =~ m/logLineNo\:\s+([0-9]+)/gi) { push (@ds0_logLineNumbers, $1); }
	    }
	  }
	  @ds0Fros = grep (/ds0BundleFroId/, @cmd_out2);
	  foreach $match (@ds0Fros) {
	    if ($match =~ m/^ds0BundleFroId\:\s+([0-9]+)/gi) {
	      $ds0bundlefro = $1;
	      #aet_ds0mp ds0BundleFro
	      $cmd2run = "aet_ds0mp ds0BundleFro ".$ds0bundlefro;
	      @cmd_out2 = COLI2collect($cmd2run,"true");
	      @grep_phyPortFroId = grep (/phyPortFroId/, @cmd_out2);
	      foreach $grep_line (@grep_phyPortFroId) {
		if ($grep_line =~ m/^phyPortFroId\:\s+([0-9]+)/gi) { push (@phyPortFroIds, $1); }
	      }
	      undef @grep_phyPortFroId;
	    }
	  }
	}
	$cmd_counter++;
      }
    }
  }
  #aet_ds0bp aal1PortRo classdata
  $cmd2run = "lhsh ".$slot." aet_ds0bp aal1PortRo classdata";
  #aet_ds0bp aal1PortRo list
  @cmd_out = COLI2collect($cmd2run,"false");
  $cmd2run = "lhsh ".$slot." aet_ds0bp aal1PortRo list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @aal1PortRos = split (/\s/, $line);
      $cmd_counter=0;
      foreach $aal1PortRo (@aal1PortRos) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "lhsh ".$slot." aet_ds0bp aal1PortRo ".$aal1PortRo;
	  @cmd_out2 = COLI2collect($cmd2run,"false");
	}
	$cmd_counter++;
      }
    }
  }
  #aet_ds0mp ds0BSetRo
  $cmd2run = "aet_ds0mp ds0BSetRo list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+\s+.+[0-9]+$/gi) {
      @ds0setros = split (/\s/, $line);
      foreach $ds0setro (@ds0setros) {
	$cmd2run = "aet_ds0mp ds0BSetRo  ".$ds0setro;
	@cmd_out2 = COLI2collect($cmd2run,"false");
	$cmd2run = "aet_ds0mp ds0BSetRo subordinate ".$atmsetro;
	@cmd_out2 = COLI2collect($cmd2run,"false");
      }
    }
  }
  if ($debug eq "TRUE") { print_time(); }
  return;
}


sub aal2_bp_mp {
  my ($cmd_counter);
  checkCPULoad("mainmp");
  checkCPULoad($slot);
  print ">> Collecting aet_aal2bp aet_aal2mp  coli cmds\n";
  if ($debug eq "TRUE") { print_time(); }
  #aet_aal2mp aal2pathepadm
  $cmd2run = "aet_aal2mp aal2pathepadm";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aet_aal2mp aal2mdsetro
  $cmd2run = "aet_aal2mp aal2mdsetro";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ m/^[0-9]+/gi) {
      @aal2mdsetros = split (/\s/, $line);
      foreach $aal2mdsetro (@aal2mdsetros) {
	$cmd2run = "aet_aal2mp aal2mdsetro ".$aal2mdsetro;
	@cmd_out2 = COLI2collect($cmd2run,"false");
      }
      undef @aal2mdsetros;
    }
  }
  #aet_aal2mp aal2qospfro
  $cmd2run = "aet_aal2mp aal2qospfro";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @aal2qospfros = split (/\s/, $line);
      foreach $aal2qospfro (@aal2qospfros) {
	$cmd2run = "aet_aal2mp aal2qospfro ".$aal2qospfro;
	@cmd_out2 = COLI2collect($cmd2run,"false");
      }
    }
  }
  #aet_aal2mp cacse
  $cmd2run = "aet_aal2mp cacse";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aet_aal2mp imf
  $cmd2run = "aet_aal2mp imf";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aet_aal2mp aal2pathepfro
  $cmd2run = "aet_aal2mp aal2mdsetro ".$piuId;
  @cmd_out = COLI2collect($cmd2run,"true");
  @aal2paths = grep (/resourceId/, @cmd_out);
  foreach $aal2path (@aal2paths) {
    if (  $aal2path =~ m/^\s+resourceId\:\s+.+subscriberId\:\s+([0-9]+)/gi ) {
      $aal2pathepfro = $1;
      $cmd2run = "aet_aal2mp aal2pathepfro ".$aal2pathepfro;
      @cmd_out2 = COLI2collect($cmd2run,"false");
    }
  }
  #aet_aal2bp program perfMeas on
  $cmd2run = "lhsh ".$slot." aet_aal2bp program perfMeas on";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aet_aal2bp program
  $cmd2run = "lhsh ".$slot." aet_aal2bp program";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aet_aal2bp aal2cpsdtro
  $cmd2run = "lhsh ".$slot." aet_aal2bp aal2cpsdtro";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @aal2cpsdtroIds = split (/\s/, $line);
      $cmd_counter=0;
      foreach $aal2cpsdtro (@aal2cpsdtroIds) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "lhsh ".$slot." aet_aal2bp aal2cpsdtro ".$aal2cpsdtro;
	  @cmd_out2 = COLI2collect($cmd2run,"true");
	  if ($EtBoardType eq "ET-MC41" || $EtBoardType eq "ET-MC41S" || $EtBoardType eq "ET-MC1" || $EtBoardType eq "ET-M3" || $EtBoardType eq "CBU" ||  $EtBoardType eq "CBU1" ) {
	    @muxIds = grep (/muxId/,@cmd_out2);
	    @aal2LineNumbers = grep (/LineNo/,@cmd_out2); 
	    @aal2WorkingState = grep (/workingState/,@cmd_out2);
	    foreach $x (@aal2LineNumbers) {
	      if ($EtBoardType eq "ET-MC41" || $EtBoardType eq "ET-MC41S") {
		if ($x =~ m/logLineNo\:\s+([0-9]+)/gi) { $lineNo = $1;     }
	      } else {
		if    ($x =~ m/phyLineNo\:\s+([0-9]+)/gi) { $lineNo = $1; }
	      }
	    }
	    foreach $workstate (@aal2WorkingState) { 
	      if ($workstate =~ m/workingState.+ACTIVE_ATM_CONNECTED/gi)  { 
		foreach $elem (@muxIds) { 
		  if ($elem =~ m/muxId\:\s+([0-9]+)/gi)  { $muxId = $1;  }
		}
		if (exists $muxes{$lineNo} ) { $muxes{$lineNo} = $muxes{$lineNo}." ".$muxId; }
		else                         { $muxes{$lineNo}= $muxId; }
	      }
	    }
	  }
	  #geting all cids for aal aal2paths takes to long
	  ###
	  if ($getCids eq "TRUE") {	
	    $cmd2run = "lhsh ".$slot." aet_aal2bp aal2cpro ".$aal2cpsdtro;
	    @cmd_out2 = COLI2collect($cmd2run,"false");
	    for ($cid=8;$cid<=255;$cid++) { 
	      $cmd2run = "lhsh ".$slot." aet_aal2bp aal2cpro ".$aal2cpsdtro." ".$cid;
	      @cmd_out2 = COLI2collect($cmd2run,"false");
	    }
	  }
	}
	$cmd_counter++;
      }
    }
  }
  #aet_aal2bp program
  $cmd2run = "lhsh ".$slot." aet_aal2bp program";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aet_aal2bp program perfMeas off
  $cmd2run = "lhsh ".$slot." aet_aal2bp program perfMeas off";
  @cmd_out = COLI2collect($cmd2run,"false");
  if ($debug eq "TRUE") { print_time(); }
  return;
}

sub atm_bp_mp {
  my ($cmd_counter);
  checkCPULoad($slot);
  checkCPULoad("mainmp");
  print ">> Collecting aet_atmbp  aet_atmmp coli cmds\n";
  if ($debug eq "TRUE") { print_time(); }
  #aet_atmbp program
  $cmd2run = "lhsh ".$slot." aet_atmbp program";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aet_atmbp atmportro
  $cmd2run = "lhsh ".$slot." aet_atmbp atmportro classdata";
  @cmd_out = COLI2collect($cmd2run,"false");
  $cmd2run = "lhsh ".$slot." aet_atmbp atmportro list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @atmportroIds = split (/\s/, $line);
      $cmd_counter=0;
      foreach $atmportro (@atmportroIds) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "lhsh ".$slot." aet_atmbp atmportro ".$atmportro;
	  @cmd_out2 = COLI2collect($cmd2run,"true");
	  if ($EtBoardType eq "ET-MC41" || $EtBoardType eq "ET-MC41S" || $EtBoardType eq "ET-MC1" || $EtBoardType eq "ET-M3" || $EtBoardType eq "CBU" ||  $EtBoardType eq "CBU1" ) {
	    #print "ETBOARD = $EtBoardType \n";
	    @LineNumbers = grep (/LineNo/, @cmd_out2);
	    foreach $x (@LineNumbers) {
	      if ($x =~ m/atmDrvPhyLineNo\:\s+([0-9]+)/gi) {
		$lineNum = $1;
		push (@phyLineNumbers, $lineNum);
		if ($EtBoardType ne "ET-MC41" && $EtBoardType ne "ET-MC41S") { $lineNos{$atmportro} = $lineNum; }
	      }
	      elsif ($x =~ m/atmDrvLogLineNo\:\s+([0-9]+)/gi) {
		$lineNum = $1;
		push (@logLineNumbers, $lineNum);
		if ($EtBoardType eq "ET-MC41" || $EtBoardType eq "ET-MC41S" ) { $lineNos{$atmportro} = $lineNum; }
	      }
	    }
	  }
	  #aet_atmmp etatmportfro
	  @portFro = grep (/portFroId/, @cmd_out2);
	  foreach $match (@portFro) {
	    if ($match =~ m/^portFroId\:\s+([0-9]+)/gi) {
	      $etatmportfro = $1;
	      $cmd2run = "aet_atmmp etatmportfro ".$etatmportfro;
	      @cmd_out2 = COLI2collect($cmd2run,"true");
	      @grep_circuitNo = grep (/circuitNo/, @cmd_out2);
	      @grep_phyPortFroId = grep (/phyPortFroId/, @cmd_out2);
	      @grep_serverType = grep (/serverType/, @cmd_out2);
	      foreach $grep_line (@grep_serverType) {
		if ($grep_line =~ m/^serverType\:\s+[0-9]+\s+AET_ATM_PORT_SERVERTYPE_PHYPORT/gi) { 
		  foreach $grep_line (@grep_phyPortFroId) {
		    if ($grep_line =~ m/^serverFroId\:\s+[0-9]+\s+phyPortFroId\:\s+([0-9]+)/gi) { push (@phyPortFroIds, $1); }
		  }
		}
	      }
	      undef @grep_phyPortFroId;
	      undef @grep_serverType;
	      foreach $el (@grep_circuitNo) {
		if ($el =~ m/^circuitNo\:\s+([0-9]+)/gi) { $Circuits{$lineNum} = $1-1; }
	      }
	      undef @grep_circuitNo;
	      if ($piuId == 0) {
		@piuIds = grep (/eqmtFroId/, @cmd_out2);
		foreach $tmppiuId (@piuIds) {	
		  if ( $tmppiuId =~ m/^eqmtFroId\:\s+([0-9]+)/gi) { $piuId = $1; }
		}
	      }
	    }
	  }
	}
	$cmd_counter++;
      }
    }
  }
  #aet_atmbp vpcp
  $cmd2run = "lhsh ".$slot." aet_atmbp vpcpro classdata";
  @cmd_out = COLI2collect($cmd2run,"false");
  $cmd2run = "lhsh ".$slot." aet_atmbp vpcpro list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @vpcproids = split (/\s/, $line);
      $cmd_counter=0;
      foreach $vpcpro (@vpcproids) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "lhsh ".$slot." aet_atmbp vpcpro ".$vpcpro;
	  @cmd_out2 = COLI2collect($cmd2run,"true");
	  #aet_atmmp vpcpfro
	  @vpcpfro = grep (/vpCpFroId/, @cmd_out2);
	  foreach $match (@vpcpfro) {
	    if ($match =~ m/^vpCpFroId\:\s+([0-9]+)/gi) {
	      $vpcpfro = $1;
	      $cmd2run = "aet_atmmp vpcpfro ".$vpcpfro;
	      @cmd_out2 = COLI2collect($cmd2run,"false");
	    }
	  }
	}
	$cmd_counter++;
      }
    }
  }
  #aet_atmbp vpcep
  $cmd2run = "lhsh ".$slot." aet_atmbp vpcepro classdata";
  @cmd_out = COLI2collect($cmd2run,"false");
  $cmd2run = "lhsh ".$slot." aet_atmbp vpcepro list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @vpceproids = split (/\s/, $line);
      $cmd_counter=0;
      foreach $vpcepro (@vpceproids) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "lhsh ".$slot." aet_atmbp vpcepro ".$vpcepro;
	  @cmd_out2 = COLI2collect($cmd2run,"true");
	  @atmportNum = grep (/atmPortNumber/, @cmd_out2);
	  foreach $elem (@atmportNum) {
	    if ($elem =~ m/atmPortNumber\:\s+([0-9]+)\s+vpi\:\s+([0-9]+)/gi) {
	      $atmPortNumber = $1;
	      $vpi = $2;
	      if (exists $vpis{$atmPortNumber} ) {   $vpis{$atmPortNumber} = $vpis{$atmPortNumber}." ".$vpi; }
	      else { $vpis{$atmPortNumber} = $vpi; }
	    }
	  }
	  #aet_atmmp vpcepfro
	  @vpcepfro = grep (/vpCepFroId/, @cmd_out2);
	  foreach $match (@vpcepfro) {
	    if ($match =~ m/^vpCepFroId\:\s+([0-9]+)/gi) {
	      $vpcepfro = $1;
	      $cmd2run = "aet_atmmp vpcepfro ".$vpcepfro;
	      @cmd_out2 = COLI2collect($cmd2run,"false");
	      $cmd2run = "aet_atmmp vpcepfro subordinate ".$vpcepfro;
	      @cmd_out2 = COLI2collect($cmd2run,"true");
	      @externalVci = grep (/externalVci/, @cmd_out2);
	      foreach $elem (@externalVci) {
		if ($elem =~ m/externalVci\:\s+([0-9]+)/gi) {
		  $vci = $1;
		  $myKey = $atmPortNumber."_".$vpi;
		  if (exists $vcis{$myKey} ) {  $vcis{$myKey} = $vcis{$myKey}." ".$vci; }
		  else { $vcis{$myKey}=$vci; }
		}
	      }
	    }
	  }
	}
	$cmd_counter++;
      }
    }
  }
  #aet_atmbp vccp
  $cmd2run = "lhsh ".$slot." aet_atmbp vccpro classdata";
  @cmd_out = COLI2collect($cmd2run,"false");
  $cmd2run = "lhsh ".$slot." aet_atmbp vccpro list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @vccproids = split (/\s/, $line);
      $cmd_counter=0;
      foreach $vccpro (@vccproids) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "lhsh ".$slot." aet_atmbp vccpro ".$vccpro;
	  @cmd_out2 = COLI2collect($cmd2run,"true");
	  #aet_atmmp vccpfro
	  @vccpfro = grep (/vcCpFroId/, @cmd_out2);
	  foreach $match (@vccpfro) {
	    if ($match =~ m/^vcCpFroId\:\s+([0-9]+)/gi) {
	      $vccpfro = $1;
	      $cmd2run = "aet_atmmp vccpfro ".$vccpfro;
	      @cmd_out2 = COLI2collect($cmd2run,"false");
	    }
	  }
	}
	$cmd_counter++;
      }
    }
  }
  #aet_atmbp vccep
  $cmd2run = "lhsh ".$slot." aet_atmbp vccepro classdata";
  @cmd_out = COLI2collect($cmd2run,"false");
  $cmd2run = "lhsh ".$slot." aet_atmbp vccepro list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @vcceproids = split (/\s/, $line);
      $cmd_counter=0;
      foreach $vccepro (@vcceproids) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "lhsh ".$slot." aet_atmbp vccepro ".$vccepro;
	  @cmd_out2 = COLI2collect($cmd2run,"true");
	  #aet_atmmp vccepfro
	  @vccepfro = grep (/vcCepFroId/, @cmd_out2);
	  foreach $match (@vccepfro) {
	    if ($match =~ m/^vcCepFroId\:\s+([0-9]+)/gi) {
	      $vccepfro = $1;
	      $cmd2run = "aet_atmmp vccepfro ".$vccepfro;
	      @cmd_out2 = COLI2collect($cmd2run,"false");
	      $cmd2run = "aet_atmmp vccepfro subscribers ".$vccepfro;
	      @cmd_out2 = COLI2collect($cmd2run,"false");
	    }
	  }
	}
	$cmd_counter++;
      }
    }
  }
  #aet_atmbp aal1epro
  $cmd2run = "lhsh ".$slot." aet_atmbp aal1epro classdata";
  @cmd_out = COLI2collect($cmd2run,"false");
  $cmd2run = "lhsh ".$slot." aet_atmbp aal1epro list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @aal1epros = split (/\s/, $line);
      foreach $aal1epro (@aal1epros) {
	$cmd2run = "lhsh ".$slot." aet_atmbp aal1epro ".$aal1epro;
	@cmd_out2 = COLI2collect($cmd2run,"true");
	#aet_atmmp aal1epfro
	@aal1epfros = grep (/aal1EpFroId/, @cmd_out2);
	foreach $match (@aal1epfros) {
	  if ($match =~ m/^aal1EpFroId\:\s+([0-9]+)/gi) {
	    $aal1epfro = $1;
	    $cmd2run = "aet_atmmp aal1epfro ".$aal1epfro;
	    @cmd_out2 = COLI2collect($cmd2run,"true");
	    if ($EtBoardType eq "ET-MC41" || $EtBoardType eq "ET-MC41S" || $EtBoardType eq "ET-MC1" || $EtBoardType eq "ET-M3" || $EtBoardType eq "CBU" ||  $EtBoardType eq "CBU1" ) {
	      @ce_lineNumber = grep (/phyLineNo/, @cmd_out2);
	      foreach $x (@ce_lineNumber) {
		if    ($x =~ m/phyLineNo\:\s+([0-9]+)\s+logLineNo\:\s+([0-9]+)/gi) { 
		  push (@ce_phyLineNumbers, $1);
		  push (@ce_logLineNumbers, $2);
		}
	      }
	    }
	  }
	}
      }
    }
  }
  #aet_atmmp atmsetro
  $cmd2run = "aet_atmmp atmsetro list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+\s+.+[0-9]+$/gi) {
      @atmsetros = split (/\s/, $line);
      foreach $atmsetro (@atmsetros) {
	$cmd2run = "aet_atmmp atmsetro  ".$atmsetro;
	@cmd_out2 = COLI2collect($cmd2run,"false");
	$cmd2run = "aet_atmmp atmsetro subordinate ".$atmsetro;
	@cmd_out2 = COLI2collect($cmd2run,"false");
	$cmd2run = "aet_atmmp atmsetro eqmtprotqueue ".$atmsetro;
	@cmd_out2 = COLI2collect($cmd2run,"false");
	$cmd2run = "aet_atmmp atmsetro egress ".$atmsetro;
	@cmd_out2 = COLI2collect($cmd2run,"false");
      }
    }
  }
  #aet_atmmp vpcp,vpcep,vccp,vccep, ccro,atmccfro, aal1epfro , etatmportfro , atmtdfro , program classdata
  $cmd2run = "aet_atmmp";
  @cmd_out = COLI2collect($cmd2run,"true");
  @classdatas = grep (/classdata/, @cmd_out);
  foreach $classdata (@classdatas) {
    if ($classdata =~ m/(\S+)\s+classdata\s+-/gi) {
      $cmd2run = "aet_atmmp $1 classdata";
      @cmd_out2 = COLI2collect($cmd2run,"false");
    }
  }
  #aet_atmmp program
  $cmd2run = "aet_atmmp program";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aet_atmmp program cacse
  $cmd2run = "aet_atmmp program cacse";
  @cmd_out = COLI2collect($cmd2run,"false");
  #aet_atmmp program imf
  $cmd2run = "aet_atmmp program imf";
  @cmd_out = COLI2collect($cmd2run,"false");

  #aet_atmmp atmccfro
  $cmd2run = "aet_atmmp atmccfro list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @atmccfroids = split (/\s/, $line);
      $cmd_counter=0;
      foreach $atmccfro (@atmccfroids) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "aet_atmmp atmccfro ".$atmccfro;
	  @cmd_out2 = COLI2collect($cmd2run,"false");
	}
	$cmd_counter++;
      }
    }
  }
  #aet_atmmp ccro 
  $cmd2run = "aet_atmmp ccro list";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @ccroids = split (/\s/, $line);
      $cmd_counter=0;
      foreach $ccro (@ccroids) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "aet_atmmp ccro ".$ccro;
	  @cmd_out2 = COLI2collect($cmd2run,"false");
	}
	$cmd_counter++;
      }
    }
  }
  if ($debug eq "TRUE") { print_time(); }
  return;
}


sub ima_bp_mp {
  my ($cmd_counter);
  print ">> Collecting aet_imabp  aet_imamp coli cmds\n";
  checkCPULoad("mainmp");
  checkCPULoad($slot);

  if ($debug eq "TRUE") { print_time(); }
  #aet_imabp imalinkro
  $cmd2run = "lhsh ".$slot." aet_imabp imalinkro ";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @imalinkros = split (/\s/, $line);
      $cmd_counter=0;
      foreach $imalinkro (@imalinkros) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "lhsh ".$slot." aet_imabp imalinkro ".$imalinkro;
	  @cmd_out2 = COLI2collect($cmd2run,"true");
	  @imalinkfros = grep (/imaLinkFroId/, @cmd_out2);
	  if ($EtBoardType eq "ET-MC41" || $EtBoardType eq "ET-MC41S" || $EtBoardType eq "ET-MC1" || $EtBoardType eq "CBU" ||  $EtBoardType eq "CBU1" ) {
	    @LineNo = grep (/LineNo/, @cmd_out2);
	    foreach $x (@LineNo) {
	      if    ($x =~ m/^phyLineNo\:\s+([0-9]+)/gi) { push (@ima_phyLineNo,$1); }
	      elsif ($x =~ m/^logLineNo\:\s+([0-9]+)/gi) { push (@ima_logLineNo,$1); }
	    }
	  }
	  foreach $match (@imalinkfros) {
	    if ($match =~ m/^imaLinkFroId\:\s+([0-9]+)/gi) {
	      $imaLinkFroId = $1;
	      #aet_imamp imalinkfro
	      $cmd2run = "aet_imamp imalinkfro $imaLinkFroId";
	      @cmd_out2 = COLI2collect($cmd2run,"true");
	      @grep_phyPortFroId = grep  (/phyPortFroId/, @cmd_out2);
	      foreach $grep_line (@grep_phyPortFroId) {
		if    ($grep_line =~ m/^phyPortFroId\:\s+([0-9]+)/gi) { push (@phyPortFroIds,$1); }
	      }
	      undef @grep_phyPortFroId;
	    }
	  }
	}
	$cmd_counter++;
      }
    }
  }
  #aet_imabp imagroupro
  $cmd2run = "lhsh ".$slot." aet_imabp imagroupro ";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @imagroupros = split (/\s/, $line);
      $cmd_counter=0;
      foreach $imagroupro (@imagroupros) {
	if ($cmd_counter%$speed == 0 ) {
	  $cmd2run = "lhsh ".$slot." aet_imabp imagroupro ".$imagroupro;
	  @cmd_out2 = COLI2collect($cmd2run,"true");
	  @imagroupfros = grep (/imaGroupFroId/, @cmd_out2);
	  foreach $match (@imagroupfros) {
	    if ($match =~ m/^imaGroupFroId\:\s+([0-9]+)/gi) {
	      $imaGroupFroId = $1;
	      #aet_imamp imagroupfro
	      $cmd2run = "aet_imamp imagroupfro ".$imaGroupFroId;
	      @cmd_out2 = COLI2collect($cmd2run,"false");
	    }
	  }
	}
	$cmd_counter++;
      }
    }
  }
  #aet_imabp locimasetro
  $cmd2run = "lhsh ".$slot." aet_imabp locimasetro";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @locimasetros = split (/\s/, $line);
      foreach $locimasetro (@locimasetros) {
	$cmd2run = "lhsh ".$slot." aet_imabp locimasetro ".$locimasetro;
	@cmd_out2 = COLI2collect($cmd2run,"false");
      }
    }
  }
  #aet_imamp imasetro
  $cmd2run = "aet_imamp imasetro";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) {
    if ($line =~ /^[0-9]+/gi) {
      @imasetros = split (/\s/, $line);
      foreach $imasetro (@imasetros) {
	$cmd2run = "aet_imamp imasetro ".$imasetro;
	@cmd_out2 = COLI2collect($cmd2run,"false");
      }
    }
  }
  #aet_imamp program
  $cmd2run = "aet_imamp program";
  @cmd_out = COLI2collect($cmd2run,"false");
  if ($debug eq "TRUE") { print_time(); }
  return;
}


sub etm4 {
  checkCPULoad($slot);
  checkCPULoad("mainmp");
  #######
  # ABM #
  #######
  print ">> Collecting ET-M4 ABM driver coli cmds\n";
  # phy_eqmtbp abm 0 - Driver & HW status
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x200 - Get registers 0x00-0x3c
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x200 ";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x201 - Get registers 0x3d-0x79
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x201";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x202 - Get registers 0x7a-0xb6
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x202";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x203 - Get registers 0xb7-0xf3 
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x203";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x204 - Get registers 0xf4-0xff
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x204";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x220 - TM counters: maxOcc, minOcc, currCellOcc & currNrtCellOcc:
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x220";
  @cmd_out = COLI2collect($cmd2run,"false");
  # TM counters: nrOfQ, accPack, discC, loCtrCl, loCsch, occ & diPaClp1C for traffic class 0xX:
  # X  	Explanation
  # 0 	1.CBR (if needed enable update of counters)
  # 1 	4.UBR (if needed enable update of counters)
  # 2 	3.CBR (if needed enable update of counters)
  # 3 	GFR (if needed enable update of counters)
  # 4 	ABR (if needed enable update of counters)
  # 5 	VBR_NRT (if needed enable update of counters)
  # 6 	3.UBR+ (if needed enable update of counters)
  # 7 	2.CBR (if needed enable update of counters)
  # phy_eqmtbp abm 0x400
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x400";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x401
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x401";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x402
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x402";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x403
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x403";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x404
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x404";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x405
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x405";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x406
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x406";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp abm 0x407
  $cmd2run = "lhsh ".$slot." phy_eqmtbp abm 0x407";
  @cmd_out = COLI2collect($cmd2run,"false");
  
  #######
  # AMD #
  #######
  print ">> Collecting ET-M4 AMD driver coli cmds\n";
  # phy_eqmtbp amd 0 - Driver & HW status
  $cmd2run = "lhsh ".$slot." phy_eqmtbp amd 0";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp amd 1 - Get firmware version
  $cmd2run = "lhsh ".$slot." phy_eqmtbp amd 1";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp amd 2 - Board Type (ETM1 or ETM4)
  $cmd2run = "lhsh ".$slot." phy_eqmtbp amd 2";
  @cmd_out = COLI2collect($cmd2run,"false");
  
  # phy_eqmtbp amd 0x00XX0003  	Mux/Demux status (XX=Mux/demux id)
  for ($mux=0;$mux<=127; $mux++) {
    $mux_hex = sprintf("%02x", $mux);
    $cmd2run = "lhsh ".$slot." phy_eqmtbp amd  0x00".$mux_hex."0003";
    @cmd_out = COLI2collect($cmd2run,"true");
    @isMuxStarted = grep (/Demux/, @cmd_out);
    foreach $elem (@isMuxStarted) { 
      if ($elem =~ m/^Mux\/Demux=\S+\s+started/gi) {
	# phy_eqmtbp amd 0x00XX0004 	Start PM on Mux/demux (XX=Mux/demux id)
	$cmd2run = "lhsh ".$slot." phy_eqmtbp amd  0x00".$mux_hex."0004";
	@cmd_out2 = COLI2collect($cmd2run,"false");
	# phy_eqmtbp amd 0x00XX0006 	Read PM on Mux/demux (XX=Mux/demux id)
	$cmd2run = "lhsh ".$slot." phy_eqmtbp amd  0x00".$mux_hex."0006";
	@cmd_out2 = COLI2collect($cmd2run,"false");
	@cmd_out2 = COLI2collect($cmd2run,"false");
	# phy_eqmtbp amd 0x00XX0005 	Stop PM on Mux/demux (XX=Mux/demux id)
	$cmd2run = "lhsh ".$slot." phy_eqmtbp amd  0x00".$mux_hex."0005";
	@cmd_out2 = COLI2collect($cmd2run,"false");
      }
    }
  }
  #########
  # ATLAS #
  #########
  print ">> Collecting ET-M4 ATLAS driver coli cmds\n";
  # phy_eqmtbp atlas 0  Driver & HW status:
  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp atlas 0x100  	Get cell counters
  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x100";
  @cmd_out = COLI2collect($cmd2run,"false");
  #2nd time
  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x100";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp atlas 0x200 	Get search tree node data
  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x200";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp atlas 0x201 	Get more search tree node data
  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x201";
  @cmd_out = COLI2collect($cmd2run,"false");
  # phy_eqmtbp atlas 0x60000 	Get SW port data
  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x60000";
  @cmd_out = COLI2collect($cmd2run,"false");    
  # phy_eqmtbp atlas 0x400X0000 	Get connections at port X
  # port = 0
  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x40000000";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) { 
    if ($line =~ m/^\s*\S+\:\s*(\S+)\/(\S+)/gi) {
      $m4_vpi_hex = sprintf("%02x", $1);
      $m4_vci_hex = sprintf("%04x", $2);
      # phy_eqmtbp atlas 0x2ZYYXXXX 	Get VCT table for INGRESS SRAM at connection port Z, vpi Y and vci X
      $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x20".$m4_vpi_hex.$m4_vci_hex;
      @cmd_out2 = COLI2collect($cmd2run,"false");
      # phy_eqmtbp atlas 0x3ZYYXXXX 	Get VCT table for EGRESS SRAM at connection port Z, vpi Y and vci X
      $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x30".$m4_vpi_hex.$m4_vci_hex;
      @cmd_out2 = COLI2collect($cmd2run,"false");
      # phy_eqmtbp atlas 0x1ZYYXXXX 	Get VCT address for connection at port Z, vpi Y and vci X
      $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x10".$m4_vpi_hex.$m4_vci_hex;
      @cmd_out2 = COLI2collect($cmd2run,"true");
      foreach $line2 (@cmd_out2) { 
	if ($line2 =~ m/^The\s+connection.+has\s+VCT\s+address\:(\S+)/gi) {
	  $m4_vct_address_hex = sprintf("%04x", $1);
	  # phy_eqmtbp atlas 0x100XXXX 	Get connection data (port,vpi,vci), at address XXXX <= 0x3FF
	  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x100".$m4_vct_address_hex;
	  @cmd_out3 = COLI2collect($cmd2run,"false");
	  # phy_eqmtbp atlas 0x3XXXX 	Get a VCT table from INGRESS SRAM, at address XXXX <= 0x3FFF
	  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x3".$m4_vct_address_hex;
	  @cmd_out3 = COLI2collect($cmd2run,"false");
	  # phy_eqmtbp atlas 0x4XXXX 	Get a VCT table from EGRESS SRAM, at address XXXX <= 0x3FFF
	  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x4".$m4_vct_address_hex;
	  @cmd_out3 = COLI2collect($cmd2run,"false");
	  # phy_eqmtbp atlas 0x5XXXX 	Get SW object data, at VCT address XXXX <= 0x3FFF
	  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x5".$m4_vct_address_hex;
	  @cmd_out3 = COLI2collect($cmd2run,"false");
	}
      }
    }
  }
  # port = 1
  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x40010000";
  @cmd_out = COLI2collect($cmd2run,"true");
  foreach $line (@cmd_out) { 
    if ($line =~ m/^\s*\S+\:\s*(\S+)\/(\S+)/gi) {
      $m4_vpi_hex = sprintf("%02x", $1);
      $m4_vci_hex = sprintf("%04x", $2);
      # phy_eqmtbp atlas 0x2ZYYXXXX 	Get VCT table for INGRESS SRAM at connection port Z, vpi Y and vci X
      $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x21".$m4_vpi_hex.$m4_vci_hex;
      @cmd_out2 = COLI2collect($cmd2run,"false");
      # phy_eqmtbp atlas 0x3ZYYXXXX 	Get VCT table for EGRESS SRAM at connection port Z, vpi Y and vci X
      $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x31".$m4_vpi_hex.$m4_vci_hex;
      @cmd_out2 = COLI2collect($cmd2run,"false");
      # phy_eqmtbp atlas 0x1ZYYXXXX 	Get VCT address for connection at port Z, vpi Y and vci X
      $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x11".$m4_vpi_hex.$m4_vci_hex;
      @cmd_out2 = COLI2collect($cmd2run,"true");
      foreach $line2 (@cmd_out2) { 
	if ($line2 =~ m/^The\s+connection.+has\s+VCT\s+address\:(\S+)/gi) {
	  $m4_vct_address_hex = sprintf("%04x", $1);
	  # phy_eqmtbp atlas 0x100XXXX 	Get connection data (port,vpi,vci), at address XXXX <= 0x3FF
	  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x100".$m4_vct_address_hex;
	  @cmd_out3 = COLI2collect($cmd2run,"false");
	  # phy_eqmtbp atlas 0x3XXXX 	Get a VCT table from INGRESS SRAM, at address XXXX <= 0x3FFF
	  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x3".$m4_vct_address_hex;
	  @cmd_out3 = COLI2collect($cmd2run,"false");
	  # phy_eqmtbp atlas 0x4XXXX 	Get a VCT table from EGRESS SRAM, at address XXXX <= 0x3FFF
	  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x4".$m4_vct_address_hex;
	  @cmd_out3 = COLI2collect($cmd2run,"false");
	  # phy_eqmtbp atlas 0x5XXXX 	Get SW object data, at VCT address XXXX <= 0x3FFF
	  $cmd2run = "lhsh ".$slot." phy_eqmtbp atlas 0x5".$m4_vct_address_hex;
	  @cmd_out3 = COLI2collect($cmd2run,"false");
	}
      }
    }
  }
  ######################## not collected
  # phy_eqmtbp atlas 0x1XXX 	Get register XXX
  # phy_eqmtbp atlas 0x2YXX 	Get a PM table from Ingress PM Sram, at address XX <= 0x7F and bank Y <= 1
  # phy_eqmtbp atlas 0x3YXX 	Get a PM table from Egress PM Sram, at address XX <= 0x7F and bank Y <= 1
  # phy_eqmtbp atlas 0x1ZYXX 	Get a word from INGRESS PM SRAM, at address XX <= 0x7F, line Y <= 7 and bank Z <= 1
  # phy_eqmtbp atlas 0x2ZYXX 	Get a word from EGRESS PM SRAM, at address XX <= 0x7F, line Y <= 7 and bank Z <= 1
  # phy_eqmtbp atlas 0x1YXXXX 	Get a word from INGRESS SRAM, at address XXXX <= 0x3FFF and line Y <= 14
  # phy_eqmtbp atlas 0x2YXXXX 	Get a word from EGRESS SRAM, at address XXXX <= 0x3FFF and line Y <= 15
  # phy_eqmtbp atlas 0x400X0001 	Get more connections at port X. port Z, vpi Y and vci X
  # phy_eqmtbp atlas 0x5YYX0000 	Get connections at port X and vpi Y
  # phy_eqmtbp atlas 0x5YYX0001 	Get more connections at port X and vpi Y
  ######################## not collected
  return;
}

sub iworxDrv {
  #2do: some coli cmds generate ERRORs in te log ?? check bellow
  my ($cmd_counter);
  print ">> Collecting $EtBoardType IWORX driver coli cmds\n";
  checkCPULoad($slot);
  checkCPULoad("mainmp");

  #IworxCommon-Driver status
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x0000 0x0000";
  @cmd_out = COLI2collect($cmd2run,"false");
  #IworxCommon-Board Type (ETMC1 ...)
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x0000 0x0001";
  @cmd_out = COLI2collect($cmd2run,"false");
  #IworxCommon-Active Iworx(s)
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x0000 0x0002";
  @cmd_out = COLI2collect($cmd2run,"false");
  #IworxCommon-Iworx HW&FW version
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x0000 0x0003";
  @cmd_out = COLI2collect($cmd2run,"false");
  #IworxCommon-Get Utopia State
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x0000 0x0004";
  @cmd_out = COLI2collect($cmd2run,"false");
  #IworxCommon-Get Utopia State (more)
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x0000 0x0005";
  @cmd_out = COLI2collect($cmd2run,"false");
  #on m3 atc is in te3falc, ima and tdm not supported
  if ($EtBoardType ne "ET-M3") {
    #IworxAtc-Driver status
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x3000 0x0000";
    @cmd_out = COLI2collect($cmd2run,"false");
    #IworxAtc-Board Type
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x3000 0x0001";
    @cmd_out = COLI2collect($cmd2run,"false");
    #worxAtc-Board Revision
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x3000 0x0002";
    @cmd_out = COLI2collect($cmd2run,"false");
    #IworxAtc-Active Iworx(s)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x3000 0x0003";
    @cmd_out = COLI2collect($cmd2run,"false");
    if ($EtBoardType eq "ET-MC41" || $EtBoardType eq "ET-MC41S") {
      foreach $elem (@logLineNumbers)     { push (@YY,$elem);     }
      foreach $elem (@ima_logLineNo)      { push (@Ima_YY,$elem); }
      foreach $elem (@ce_logLineNumbers)  { push (@ce_YY,$elem);  }
      foreach $elem (@ds0_logLineNumbers) { push (@ds0_YY,$elem); }
    } else {
      foreach $elem (@phyLineNumbers)     { push (@YY,$elem);     }
      foreach $elem (@ima_phyLineNo)      { push (@Ima_YY,$elem); }
      foreach $elem (@ce_phyLineNumbers)  { push (@ce_YY,$elem);  }
      foreach $elem (@ds0_phyLineNumbers) { push (@ds0_YY,$elem); }
    }
    foreach $elem (@YY) {
      $YY_hex = sprintf("%02x", $elem);
      #IworxAtc-G804 PM counters, board port=0xYY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x3000 0x".$YY_hex."04";
      @cmd_out = COLI2collect($cmd2run,"false");
      #IworxAtc-Port Object, board port=0xYY, part 1
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x3000 0x".$YY_hex."05";
      @cmd_out = COLI2collect($cmd2run,"false");
      #IworxAtc-Port Object, board port=0xYY, part 2
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x3000 0x".$YY_hex."06";
      @cmd_out = COLI2collect($cmd2run,"false");
      #IworxAtc-SSF Object, board port=0xYY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x3000 0x".$YY_hex."07";
      @cmd_out = COLI2collect($cmd2run,"false");
    }
    #IworxIma-Driver status
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x0000";
    @cmd_out = COLI2collect($cmd2run,"false");
    #IworxIma-Board Type
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x0001";
    @cmd_out = COLI2collect($cmd2run,"false");
    #IworxIma-Board Revision
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x0002";
    @cmd_out = COLI2collect($cmd2run,"false");
    #IworxIma-Active Iworx(s)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x0003";
    @cmd_out = COLI2collect($cmd2run,"false");
    foreach $elem (@Ima_YY) {
      $Ima_YY_hex = sprintf("%02x", $elem);
      #IworxIma-Group Object, board port=YY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x".$Ima_YY_hex."07";
      @cmd_out = COLI2collect($cmd2run,"false");
      #IworxIma-Group FM data, board port used=YY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x".$Ima_YY_hex."0B";
      @cmd_out = COLI2collect($cmd2run,"false");
      #IworxIma-Group PM data, board port used=YY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x".$Ima_YY_hex."0C";
      @cmd_out = COLI2collect($cmd2run,"false");
      #worxIma-G804 PM counters, board port=YY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x".$Ima_YY_hex."05";
      @cmd_out = COLI2collect($cmd2run,"false");
      #IworxIma-Port Object, board port=YY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x".$Ima_YY_hex."06";
      @cmd_out = COLI2collect($cmd2run,"false");
      #IworxIma-SSF Object, board port=YY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x".$Ima_YY_hex."08";
      @cmd_out = COLI2collect($cmd2run,"false");
      #IworxIma-Link FM data, board port=YY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x".$Ima_YY_hex."09";
      @cmd_out = COLI2collect($cmd2run,"false");
      #IworxIma-Link PM data, board port=YY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x".$Ima_YY_hex."0A";
      @cmd_out = COLI2collect($cmd2run,"false");
    }
    if ($EtBoardType eq "ET-MC41" || $EtBoardType eq "ET-MC1" || $EtBoardType eq "CBU" || $EtBoardType eq "CBU1") {
      #IworxAal1Lc-Driver status
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x6000 0x0000";
      @cmd_out = COLI2collect($cmd2run,"false");
      #IworxAal1Lc-Board Type
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x6000 0x0001";
      #IworxAal1Lc-Board Revision
      @cmd_out = COLI2collect($cmd2run,"false");
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x6000 0x0002";
      #IworxAal1Lc-Active Iworx
      @cmd_out = COLI2collect($cmd2run,"false");
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x6000 0x0003";
      @cmd_out = COLI2collect($cmd2run,"false");
      #IworxAal1Lc-Idle pattern for all Iworx
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x6000 0x0004";
      @cmd_out = COLI2collect($cmd2run,"false");
      $ts="01";
      #to do: tslist parsing
      #no really sure if there is division between tdm and ce.. need to check with design
      foreach $elem (@ds0_YY) {
	$ds0_YY_hex = sprintf("%02x", $elem);
	#IworxAal1Lc-AAL1 PM counters, XX=first used ts, YY=board port
	$cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x60".$ts." 0x".$ds0_YY_hex."05";
	@cmd_out = COLI2collect($cmd2run,"false");
	#IworxAal1Lc-Port Object, YY=board port
	$cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x6000 0x".$ds0_YY_hex."06";
	@cmd_out = COLI2collect($cmd2run,"false");
      }
      foreach $elem (@ce_YY) {
	$ce_YY_hex = sprintf("%02x", $elem);
	#IworxAal1Lc-Port CE LC Object, XX=first used ts, YY=board port
	$cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x60".$ts." 0x".$ce_YY_hex."07";
	@cmd_out = COLI2collect($cmd2run,"false");      }
    }
  }
  #IworxAtm-Driver status
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xD000 0x0000";
  @cmd_out = COLI2collect($cmd2run,"false");
  #IworxAtm-Board Type (ETMC1 ...)
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xD000 0x0001";
  @cmd_out = COLI2collect($cmd2run,"false");
  #IworxAtm-Iworx HW&FW version
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xD000 0x0002";
  @cmd_out = COLI2collect($cmd2run,"false");
  #IworxAtm-Active Iworx(s)
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xD000 0x0003";
  @cmd_out = COLI2collect($cmd2run,"false");
  #### vp,vc, ...
  if ($EtBoardType eq "ET-MC41")     { $NoOfIworx=12; }
  elsif ($EtBoardType eq "ET-MC41S") { $NoOfIworx=3; }
  elsif ($EtBoardType eq "ET-M3")    { $NoOfIworx=2; }
  else                               { $NoOfIworx=1; }
  for ($i=0;$i<$NoOfIworx;$i++) {
    $iworxId = sprintf("%02x", $i);
    $iworxId_1 = sprintf("%01x", $i);
    #VP conH occupied for Iworx=0xXX (0-11)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC000 0x03".$iworxId;
    @cmd_out = COLI2collect($cmd2run,"false");
    #VC conH occupied for Iworx=0xXX (0-11)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC000 0x04".$iworxId;
    @cmd_out = COLI2collect($cmd2run,"false");
    #CE conH occupied for Iworx=0xXX (0-11)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC000 0x05".$iworxId;
    @cmd_out = COLI2collect($cmd2run,"false");
    #IworxIma-Links used in IMA groups (lcH pairs), iworx=YY
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x4000 0x".$iworxId."04";
    @cmd_out = COLI2collect($cmd2run,"false");
    #VC handler (X=iworx)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9".$iworxId_1."00 0x0005";
    @cmd_out = COLI2collect($cmd2run,"false");
    #MuxDemux handler (X=iworx)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9".$iworxId_1."00 0x0006";
    @cmd_out = COLI2collect($cmd2run,"false");
    #conH stack for Iworx=0xXX (0-11)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC000 0x02".$iworxId;
    @cmd_out = COLI2collect($cmd2run,"false");
    #PM handle stack for Iworx=0xXX (0-11)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC000 0x06".$iworxId;
    @cmd_out = COLI2collect($cmd2run,"false");
    #PM_DC handle stack for Iworx=0xXX (0-11)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC000 0x07".$iworxId;
    @cmd_out = COLI2collect($cmd2run,"false");
    #CE extra handle stack for Iworx=0xXX (0-11)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC000 0x08".$iworxId;
    @cmd_out = COLI2collect($cmd2run,"false");
  }
  #aal2 mux
  while (($key, $value) = each(%muxes)) {
    @muxIdsOnLine = split (/\s/, $muxes{$key});
    $iworxId_1 = sprintf("%01x", $Circuits{$key});
    $iworxId   = sprintf("%02x", $Circuits{$key});
    foreach $el (@muxIdsOnLine) {
      $mux = sprintf("%02x", $el);
      #Channel handler (X=iworx, YY=muxDemuxId)
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9".$iworxId_1.$mux." 0x0007";
      @cmd_out = COLI2collect($cmd2run,"false");
      #VC object (X=iworx, YY=muxDemuxId)
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9".$iworxId_1.$mux." 0x0008";
      @cmd_out = COLI2collect($cmd2run,"false");
      if ($getCids eq "TRUE") {
	for ($cid=8;$cid<256;$cid++) {
	  $cidHex = sprintf("%02x", $cid);
	  #Channel object (X=iworx, YY=muxDemuxId, ZZ=cid)
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9".$iworxId_1.$mux." 0x".$cidHex."09";
	  @cmd_out = COLI2collect($cmd2run,"false");
	}
      } else {
	#Channel object (X=iworx, YY=muxDemuxId, ZZ=cid)
	$cidHex = "09";
	$cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9".$iworxId_1.$mux." 0x".$cidHex."09";
	@cmd_out = COLI2collect($cmd2run,"false");
      }
      #PM object (X=iworx, YY=muxDemuxId)
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9".$iworxId_1.$mux." 0x000A";
      @cmd_out = COLI2collect($cmd2run,"false");
      #Start PM on a MuxDemux (YY=muxDemuxId)
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x90".$mux." 0x000C";
      @cmd_out = COLI2collect($cmd2run,"false");
      #Read PM counter (X=iworx, YY=muxDemuxId)
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9".$iworxId_1.$mux." 0x000B";
      @cmd_out = COLI2collect($cmd2run,"false");
      #TM counters for aal2 traffic class(X=tc_h, YY=muxDemuxId)
      #X=8 for VOICE X=9 for DATA
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x98".$mux." 0x000E";
      @cmd_out = COLI2collect($cmd2run,"false");
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x99".$mux." 0x000E";
      @cmd_out = COLI2collect($cmd2run,"false");
      #Data queue info for aal2 mux (X=tc_h, YY=muxDemuxId
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x98".$mux." 0x100F";
      @cmd_out = COLI2collect($cmd2run,"false");
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x98".$mux." 0x200F";
      @cmd_out = COLI2collect($cmd2run,"false");
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x99".$mux." 0x100F";
      @cmd_out = COLI2collect($cmd2run,"false");
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x99".$mux." 0x200F";
      @cmd_out = COLI2collect($cmd2run,"false");
      #Read PM counter (X=iworx, YY=muxDemuxId)
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9".$iworxId_1.$mux." 0x000B";
      @cmd_out = COLI2collect($cmd2run,"false");
      #Stop PM on a MuxDemux (YY=muxDemuxId)
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x90".$mux." 0x000D";
      @cmd_out = COLI2collect($cmd2run,"false");
    }
  }
  
  while (($key, $value) = each(%lineNos)) {
    #      print "\nport = $key lineNo = $value\n";
    #      print "vpi on port = $vpis{$key}\n";
    $lineNo = $value;
    
    $X5 = sprintf("%05x", $lineNo);
    $X5 ="0xCF0".$X5;
    $X5 =~ s/(0xCF0\S)(\S\S\S\S)/$1 0x$2/gi;
    $X4 = sprintf("%04x", $lineNo);
    $X2 = sprintf("%02x", $lineNo);
    
    #Port object for atmPort=0xXXXXX (0-62).(IMA:atmPort=groupNo=portNumber )
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC110 0x".$X4;
    @cmd_out = COLI2collect($cmd2run,"false");
    #Port Counters for atmPort=0xXXXXX (0-62)
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC120 0x".$X4;
    @cmd_out = COLI2collect($cmd2run,"false");
    if ($EtBoardType eq "ET-MC41" || $EtBoardType eq "ET-MC1" || $EtBoardType eq "CBU" || $EtBoardType eq "CBU1") {
      #CE object for atmPort=0xXX (0-62),timeslotNumber=0xYY (0-31)
      #2do: CE ts hardcoded.. and don't know if CE is on that port ?? 
      $ts = "01";
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC004 0x".$X2.$ts;
      @cmd_out = COLI2collect($cmd2run,"false");
      #AAL1 TM counters for port=0xXX (0-62),firstTS=0xYY
      #2do : ts hard coded, add ts support
      $ts = "01";
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC010 0x".$X2.$ts;
      @cmd_out = COLI2collect($cmd2run,"false");
    }
    #######VP
    @vpiOnLine = split (/\s/, $vpis{$key});
    foreach $vpi (@vpiOnLine) {
      #	print "\n checking vpi=$vpi\n";
      $YY = sprintf("%02x", $vpi);
      #VP object for atmPort=0xXXXXX (0-62),extVpi=0xYY.
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 ".$X5;
      @cmd_out = COLI2collect($cmd2run,"false");
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC001 0x00".$YY;
      @cmd_out = COLI2collect($cmd2run,"false");
      #VP PM object(s) for atmPort=0xXXXXX (0-62),extVpi=0xYY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 ".$X5;
      @cmd_out = COLI2collect($cmd2run,"false");
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC005 0x00".$YY;
      @cmd_out = COLI2collect($cmd2run,"false");
      #VP DC objects for atmPort=0xXXXXX (0-62),extVpi=0xYY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 ".$X5;
      @cmd_out = COLI2collect($cmd2run,"false");
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC008 0x00".$YY;
      @cmd_out = COLI2collect($cmd2run,"false");
      #VP_CEP PM counters for atmPort=0xXXXXX (0-62), extVpi=0xYY
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 ".$X5;
      @cmd_out = COLI2collect($cmd2run,"false");
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC00D 0x00".$YY;
      @cmd_out = COLI2collect($cmd2run,"false");
      #VP_CP PM counters (all VPs possible) for atmPort=0xXXXXX (0-62)
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 ".$X5;
      @cmd_out = COLI2collect($cmd2run,"false");
      $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC011 0x00".$YY;
      @cmd_out = COLI2collect($cmd2run,"false");
      ######################VC
      $myKey = $key."_".$vpi;
      @vciOnvpi = split (/\s/, $vcis{$myKey});
      $cmd_counter=0;
      foreach $vci (@vciOnvpi) {
	if ($cmd_counter%$speed == 0 ) {
	  #	  print "\n atmport=$key linenum=$value myKey=$myKey vpi=$vpi vci=$vci\n";
	  $ZZ = sprintf("%04x",$vci);
	  #VC object for atmPort=0xXXXXX (0-62),extVpi=0xYY & extVci=0xZZZZ.
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 ".$X5;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC002 0x00".$YY;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC003 0x".$ZZ;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  #VC PM object(s) for atmPort=0xXXXXX (0-62),extVpi=0xYY & extVci=0xZZZZ
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 ".$X5;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC006 0x00".$YY;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC007 0x".$ZZ;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  #VC DC objects for atmPort=0xXXXXX (0-62),extVpi=0xYY & extVci=0xZZZZ
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 ".$X5;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC009 0x00".$YY;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC00A 0x".$ZZ;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  #G804 TM counters for atmPort=0xXXXXX (0-62),extVpi=0xYY & extVci=0xZZZZ
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 ".$X5;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC00B 0x00".$YY;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC00C 0x".$ZZ;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  #generates ERROR in the log  ?? investigation needed
	  #VC_CEP PM counters for atmPort=0xXXXXX (0-62), extVpi=0xYY & extVci=0xZZZZ
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 ".$X5;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC00E 0x00".$YY;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC00F 0x".$ZZ;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  #VC_CP PM counters (all VCs possible) for atmPort=0xXXXXX (0-62), extVpi=0xYY & extVci=0xZZZZ
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 ".$X5;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC00E 0x00".$YY;
	  @cmd_out = COLI2collect($cmd2run,"false");
	  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC012 0x".$ZZ;
	  @cmd_out = COLI2collect($cmd2run,"false");
	}
	$cmd_counter++;
      }; #end vci
      undef @vciOnvpi;
    }; #end vpi
    undef @vpiOnLine;
  }
  #Traffic Class object for tc_h=0xX (0-15). Note: all 16 tc_h are not in use for all versions of HW
  for ($tc=1;$tc<=15;$tc++) {
    $tclass = sprintf("%x", $tc);
    $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0xC000 0x001".$tclass;
    @cmd_out = COLI2collect($cmd2run,"false"); 
  }
  #Iworx Aal2 Init state (Driver, HW)
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9000 0x0000";
  @cmd_out = COLI2collect($cmd2run,"false");
  #Board Type (ETMC1, ETMC41 ...)
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9000 0x0001";
  @cmd_out = COLI2collect($cmd2run,"false");
  #Board Revision, Iworx HW/FW version
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9000 0x0002";
  @cmd_out = COLI2collect($cmd2run,"false");
  #Active Iworx(s)
  $cmd2run = "lhsh ".$slot." aet_iworxDrv 3 0x9000 0x0003";
  @cmd_out = COLI2collect($cmd2run,"false");
  return;
}


###############################################
#################### MAIN  ####################
###############################################
#my ($ver, $node, $passwd, $getCids, $piuId, $EtBoardType, $IMASupported, $TDMSupported, $ATMSupported, $debug, $maxCpuLoadLimit, $checkCPU, $logLineMax);
#my ($sec, $min, $hr, $date, $month, $year, $telnet, $ssh, $ssh_stdout, $ssh_stderr, $ssh_exit);

$ver = "[1.7] 18-12-2012 by mladen.vasarevic\@ericsson.com\n";
$node = "NULL";
$slot = "NULL";
$user = "NULL";
$passwd  = "NULL";
$getCids = "FALSE";
$piuId = "0";
$EtBoardType = "NULL";
$IMASupported = "TRUE";
$TDMSupported = "TRUE";
$ATMSupported = "TRUE";
$IsBoardSupported = "FALSE";
#$debug = "TRUE";
$debug = "FALSE";
$maxCpuLoadLimit = 70;
#$checkCPU = "FALSE";
$checkCPU = "TRUE";
$logLineMax = 83;
$ssh_timeout  = 1;
$ssh_debug_file= "/tmp/atm_dcg_ssh.debug";
$ssh_cmd_mode = "send";
$sleeptime4CPUload = 3;

#initialze radnom number generator
srand();

if (@ARGV == 0 || !($ARGV[0] =~ /^-/) || @ARGV != 16 ) {               # No arguments given
  print "*** Missing  input parameters  ***\n\n";
  &printhelpinfo;
}

while ($ARGV[0] =~ /^-/) {      # process any switches
  $_ = shift;
  if (/^-help/) {
    &printhelpinfo;
  }
  elsif (/^-node/ && length($ARGV[0])>0 ) {
    $node = $ARGV[0];
    $_ = shift;
  }
  elsif (/^-user/ && length($ARGV[0])>0 ) {
    $user = $ARGV[0];
    $_ = shift;
  }
  elsif (/^-passwd/ && length($ARGV[0])>0 ) {
    $passwd = $ARGV[0];
    $_ = shift;
  }
  elsif (/^-slot/ && length($ARGV[0])>0 ) {
    $slot = $ARGV[0];
    $_ = shift;
  }
  elsif (/^-out/ && length($ARGV[0])>0 ) {
    $output_folder = $ARGV[0];
    $_ = shift;
  }
  elsif (/^-usf/ && length($ARGV[0])>0 ) {
    $use_shell_f = $ARGV[0];
    $_ = shift;
    if ($use_shell_f ne "true") { $use_shell_f = "false"; }
  }
  elsif (/^-protocol/ && length($ARGV[0])>0 ) {
    $protocol = $ARGV[0];
    $_ = shift;
    if ($protocol ne "telnet") { $protocol = "ssh"; }
  }
  elsif (/^-speed/ && length($ARGV[0])>0 ) {
    $speed_exp = $ARGV[0];
    $speed =1;
    for ($i=1;$i<$speed_exp;$i++) { $speed = $speed*2; }
    $_ = shift;
  }
  else {
    print "*** Missing  input parameters ***\n\n";
    &printhelpinfo;
  }
}

if ($debug eq "TRUE") { print "\n>>Input parameters: node=$node, user=$user, passwd=$passwd, slot=$slot, out=$output_folder, usf=$use_shell_f, protocol=$protocol, speed=$speed\n"; }
if ($node ne "NULL" && $user ne "NULL" && $passwd ne "NULL" && $slot ne "NULL") {
  #get time
  ($sec,$min,$hr) = localtime();
  @f = (localtime)[3..5]; # grabs day/month/year values
  $month=$f[1] +1;
  $day = $f[0];
  $year = $f[2] + 1900;

  if ( $use_shell_f eq "true" ) {
    $coli_cmd_output_file_name = $output_folder."atm_dcg_".$node."_".$slot."_".$day.$month.$year."_".$hr.$min.$sec.".cmds";
    open(coli_cmd_output_file, join( "",">",$coli_cmd_output_file_name))     || die "Error opening file $coli_cmd_output_file_name";
    $Input_log = "/tmp/atm_dcg_telnet_input.log";
    $Output_log = "/tmp/atm_dcg_telnet_output.log";
  } else {
    $filename = "atm_dcg_".$node."_".$slot."_".$day.$month.$year."_".$hr.$min.$sec.".coli";
    $Input_log = $output_folder."/".$filename;
    $Output_log = $output_folder."/".$filename.".cmds";
  }

  if ( $protocol eq "telnet" ) {
    $telnet = new Net::Telnet (Timeout=>50,
			       Input_log=>"$Input_log",
			       Output_log=>"$Output_log",
			       Errmode=>'return',
			       Prompt => '/\$ $/i'); 
    print "opening telnet to $node.. \n";
    $telnet->open($node);
    $telnet->login($user, $passwd);
  } else {
    $ssh_option=" -o StrictHostKeyChecking=no -o HostKeyAlgorithms=\"ssh-dss,ssh-rsa\" -o NumberOfPasswordPrompts=1 -o PreferredAuthentications=password";
    $ssh = Net::SSH::Expect->new (host => "$node", 
				  password=> "$passwd",
				  user => "$user",
				  ssh_option => "$ssh_option",
				  log_file => "$ssh_debug_file",
				  timeout =>5,
				  raw_pty => 1
				 );
    # 2) logon to the SSH server using those credentials.
    # test the login output to make sure we had success
    $login_output = $ssh->login();
    if ($login_output !~ /Welcome/) {
            die "SSH Login has failed. Login output was $login_output";
    }
    # disable terminal translations and echo on the SSH server
    # executing on the server the stty command:
    $ssh->exec("stty raw -echo");
    $ssh->timeout(1);
  }


  ########################################################
  ################### check board type ###################
  ########################################################
  checkCPULoad($slot);
  # print to te log that atm dcg started
  $cmd2run = "lhsh ".$slot." te e info atm_dcg_started";
  @cmd_out = COLI2collect($cmd2run,"false");
  #pboot sh pa
  $cmd2run = "lhsh ".$slot." pboot sh pa";
  @cmd_out = COLI2collect($cmd2run,"true");
  @productNames = grep (/productname/, @cmd_out);
  foreach $match (@productNames) {
    if ($match =~ m/productname=(\S+)/gi) { $EtBoardType = $1; }
  }
  if ($EtBoardType eq "ET-M1") {
    $IMASupported = "FALSE";
    $TDMSupported = "TRUE";
    $ATMSupported = "TRUE";
    $IsBoardSupported = "TRUE";
  }
  elsif ($EtBoardType eq "ET-MC1") {
    $IMASupported = "TRUE";
    $TDMSupported = "TRUE";
    $ATMSupported = "TRUE";
    $IsBoardSupported = "TRUE";
  }
  elsif ($EtBoardType eq "CBU" || $EtBoardType eq "CBU1" ) {
    $IMASupported = "TRUE";
    $TDMSupported = "TRUE";
    $ATMSupported = "TRUE";
    $IsBoardSupported = "TRUE";
  }
  elsif ($EtBoardType eq "ET-M3") {
    $IMASupported = "FALSE";
    $TDMSupported = "FALSE";
    $ATMSupported = "TRUE";
    $IsBoardSupported = "TRUE";
  }
  elsif ($EtBoardType eq "ET-MC41") {
    $IMASupported = "TRUE";
    $TDMSupported = "TRUE";
    $ATMSupported = "TRUE";
    $IsBoardSupported = "TRUE";
  }
  elsif ( $EtBoardType eq "ET-MC41S") {
    $IMASupported = "TRUE";
    $TDMSupported = "FALSE";
    $ATMSupported = "TRUE";
    $IsBoardSupported = "TRUE";
  }
  elsif ($EtBoardType eq "ET-M4") {
    $IMASupported = "FALSE";
    $TDMSupported = "FALSE";
    $ATMSupported = "TRUE";
    $IsBoardSupported = "TRUE";
  }
  elsif ($EtBoardType eq "ET-MF4") {
    $IMASupported = "FALSE";
    $TDMSupported = "FALSE";
    $ATMSupported = "TRUE";
    $IsBoardSupported = "TRUE";
  }
  elsif ($EtBoardType eq "ET-MF41") {
    $IMASupported = "TRUE";
    $TDMSupported = "FALSE";
    $ATMSupported = "TRUE";
    $IsBoardSupported = "TRUE";
  }
  elsif ($EtBoardType eq "ET-C41") {
    $IMASupported = "FALSE";
    $TDMSupported = "TRUE";
    $ATMSupported = "FALSE";
    $IsBoardSupported = "TRUE";
  }
#   elsif ($EtBoardType eq "CBM1" || $EtBoardType eq "CBM" || $EtBoardType eq "TP1") {
#     $IMASupported = "TRUE";
#     $TDMSupported = "FALSE";
#     $ATMSupported = "TRUE";
#     $IsBoardSupported = "TRUE";
#   }

  @productnumber = grep (/productnumber/, @cmd_out);
  foreach $match (@productnumber) {
    if ($match =~ m/productnumber=(.+)$/gi) { $RojNumber = $1; }
  }
  print ">> Board in slot $slot is  $EtBoardType $RojNumber\n";
  if ($IsBoardSupported eq "FALSE" ) {
    print "\n<<<ERROR>> Unsupported Board Type = $EtBoardType $RojNumber !!\n";
    exit 0;
  } else {
    #te log read
    $cmd2run = "lhsh ".$slot." te log read";
    @cmd_out = COLI2collect($cmd2run,"false");
    #listlaoded
    $cmd2run = "lhsh ".$slot." listloaded";
    @cmd_out = COLI2collect($cmd2run,"false");
    #llog -l
    $cmd2run = "lhsh ".$slot." llog -l";
    @cmd_out = COLI2collect($cmd2run,"false");
    #ps -w
    $cmd2run = "lhsh ".$slot." ps -w";
    @cmd_out = COLI2collect($cmd2run,"false");
    #dumpelg
    $cmd2run = "lhsh ".$slot." dumpelg";
    @cmd_out = COLI2collect($cmd2run,"false");
    #spashwinfo all
    $cmd2run = "lhsh ".$slot." spashwinfo all";
    @cmd_out = COLI2collect($cmd2run,"false");
    #spashwinfo egrq
    $cmd2run = "lhsh ".$slot." spashwinfo egrq";
    @cmd_out = COLI2collect($cmd2run,"false");
    #spashwinfo ingrq
    $cmd2run = "lhsh ".$slot." spashwinfo ingrq";
    @cmd_out = COLI2collect($cmd2run,"false");
    #phy_eqmtbp eqmtro
    $cmd2run = "lhsh ".$slot." phy_eqmtbp eqmtro";
    @cmd_out = COLI2collect($cmd2run,"false");

    ####################################################
    ############### ETC41 um & tact driver #############
    ####################################################
    if ($EtBoardType eq "ET-C41") { etc41();  }
    ####################################################
    ############### ETM4 atlas,abm, amd drivers ########
    ####################################################
    if ($EtBoardType eq "ET-M4") { etm4();    }
    ####################################################
    ############### ETM3 te3falc driver ################
    ####################################################
    if ($EtBoardType eq "ET-M3") { te3falc_m3();   }
    ####################################################
    ######### ETMF41 win & Glenkinchie  drivers ########
    ####################################################
    if ( $EtBoardType eq "ET-MF41") { etmf41(); }
    ####################################################
    ######### ETMF4 win & suni  drivers ################
    ####################################################
    if ($EtBoardType eq "ET-MF4") { etmf4(); }
    ####################################################
    ######### CBM win & qfalc drivers           ########
    ####################################################
    if ( $EtBoardType eq "CBM1" || $EtBoardType eq "CBM" || $EtBoardType eq "TP1") { cbm(); }
    ########################################################
    ################### TDM ################################
    ########################################################
    if ($TDMSupported eq "TRUE") { ds0_bp_mp(); }
    ########################################################
    ################### ATM ################################
    ########################################################
    if ($ATMSupported eq "TRUE") {
      atm_bp_mp();
      aal2_bp_mp();
    }
    ########################################################
    ################### IMA ################################
    ########################################################
    if ($IMASupported eq "TRUE") { ima_bp_mp();   }
    ####################################################
    ################# PHY MP  ##########################
    ####################################################
    phy_mp();
    #############################################################
    ######### ETMC1, ETMC41, ETMC41S, ETM3, CBU iworx driver ####
    #############################################################
    if ($debug eq "TRUE") {
      #iworx debug stuff
      print "\n...........................................\n";
      while (($key, $value) = each(%lineNos)) {  print "\n port = $key lineNo = $value";  }
      print "\n...........................................\n";
      while (($key, $value) = each(%Circuits)) {  print "\n lineNo = $key iworxCircuit = $value";  }
      print "\n...........................................\n";
      while (($key, $value) = each(%muxes)) {  print "\n lineNo = $key muxId = $value";  }
      print "\n...........................................\n";
      while (($key, $value) = each(%vpis)) {  print "\n port = $key vpis = $value";  }
      print "\n...........................................\n";
      while (($key, $value) = each(%vcis)) {  print "\n port_vpi = $key vcis = $value";  }
      print "\n...........................................\n";
    }
    if ($EtBoardType eq "ET-MC41" || $EtBoardType eq "ET-MC41S" || $EtBoardType eq "ET-MC1" || $EtBoardType eq "ET-M3" || $EtBoardType eq "CBU" ||  $EtBoardType eq "CBU1" ) {
      iworxDrv();
    }
    ########################################################
    ################### aal5       #########################
    ########################################################
    if ( $EtBoardType eq "CBM1" || $EtBoardType eq "CBM" || $EtBoardType eq "TP1") { aal5_cbm(); }
    else { aal5(); }
    #aal0 skipped.. not used anymore #

    # print to te log that atm dcg is finished
    $cmd2run = "lhsh ".$slot." te e info atm_dcg_finished";
    @cmd_out = COLI2collect($cmd2run,"false");

    if ( $protocol eq "telnet" ) {  $telnet->close; }
    else {
      $ssh->close();
      close(Output_log_file);
      close(Input_log_file);
    }
    print ">> ...done...\n";
    print ">> ET board coli cmds from $node , $slot collected\n";
    if ( $use_shell_f eq "true" ) {
      print ">> coli cmds to be used with shell -f : $coli_cmd_output_file_name\n";
    } else {
      print ">> output from executed coli cmds     : $Input_log\n";
      print ">> executed coli cmds                 : $Output_log\n";
    }

    #get time
    ($sec2,$min2,$hr2) = localtime();
    @f2 = (localtime)[3..5]; # grabs day/month/year values
    $month2=$f[1] +1;
    $day2 = $f[0];
    $year2 = $f[2] + 1900;
    print ">> script start : $day-$month-$year $hr:$min:$sec\n";
    print ">> script end   : $day2-$month2-$year2 $hr2:$min2:$sec2\n";
  }; #end if board type supported
  close (coli_cmd_output_file);
} else { 
  print "\n ERROR : missing input arguments";
  exit 0;
}
