#!/usr/bin/python

# Script allows storing backup of RNC radio configuration on ENM.
# In case of RNC failure this configuration can be restored to spare RNC.

######################################################################################
#                                                                                    #
# (c) Ericsson AB 2020    - All Rights Reserved                                      #
#                                                                                    #
# The copyright to the computer program(s) herein is the property of Ericsson AB,    #
# Sweden. The programs may be used and/or copied only with the written permission    #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                  #
#                                                                                    #
######################################################################################

import getopt
import sys
import functions

def main():
    config_file = ''
    try:
        options, args = getopt.getopt(sys.argv[1:], "hc:ts:r:", ["help", "config=", "status", "store=", "restore="])
        ret_code = 0
        action = ""
        rnc_name = ""

        if len(args) != 0:
            raise getopt.GetoptError("unrecognized arguments: %s" % str(args), None)

        if len(options) == 0:
            action = "help"
            ret_code = functions.usage()
        else:
            for name, value in options:
                if name in ('-h', '--help'):
                    action = "help"
                    ret_code = functions.usage()

                elif name in ('-c', '--config'):
                    config_file = value

                elif name in ('-t', '--status'):
                    if action=="":
                        action ="status"
                    else:
                        raise getopt.GetoptError("redundant parameter %s" % name, None)

                elif name in ('-s', '--store'):
                    if action=="":
                        action ="store"
                        rnc_name = value
                    else:
                        raise getopt.GetoptError("redundant parameter %s" % name, None)

                elif name in ('-r', '--restore'):
                    if action=="":
                        action ="restore"
                        rnc_name = value
                    else:
                        raise getopt.GetoptError("redundant parameter %s" % name, None)

                else:
                    raise getopt.GetoptError("unrecognized parameter %s" % name, None)

    except getopt.GetoptError, err:
        functions.print_stderr("Error: %s: %s\n" % (sys.argv[0], err))
        functions.print_stderr("Try '%s --help' for more information.\n" % sys.argv[0])
        sys.exit(1)

    if action == "help":
        sys.exit(ret_code)

    # Print maintenance information
    functions.blame_short()

    # Parse the config file
    settings = functions.parse_config(config_file)

    # Obtain unique run_id for this session
    run_id = functions.get_run_id(settings)

    # Start logging service
    functions.configure_log(run_id, settings)

    if action=="status":
        ret_code = functions.procedure_status(settings, run_id)
    elif action=="store":
        ret_code = functions.procedure_store(rnc_name, settings, run_id)
    elif action=="restore":
        ret_code = functions.procedure_restore(rnc_name, settings, run_id)
    else:
        ret_code = 3

    sys.exit(ret_code)

main()
