package Table;

use strict;
use locale;
use Data::Dumper;

sub Table::new() {
  my $class = shift;
  my %self = @_;
  $self{HEADER} = ();
  return bless \%self;
}

sub Table::getName() {
    my $self = shift;
    return $self->{name};
}

sub Table::addHeader() {
    my $self = shift;
    my %inPut = @_;
    push @{$self->{HEADER}}, $inPut{name};
    if ( defined $inPut{bitmap} && defined $self->{conf}->{$inPut{bitmap}} )
    {
        $self->{BITMAP}->{$inPut{name}} = $self->{conf}->{$inPut{bitmap}};
    }
    if ( defined $inPut{hashmap} && defined $self->{conf}->{$inPut{hashmap}} )
    {
        $self->{HASHMAP}->{$inPut{name}} = $self->{conf}->{$inPut{hashmap}};
    }
}
sub Table::addGroupBy() {
    my $self = shift;
    my %inPut = @_;
    $self->{GROUPBY} = $inPut{name};
    if ( defined $inPut{bitmap} && defined $self->{conf}->{$inPut{bitmap}} )
    {
        $self->{BITMAP}->{$inPut{name}} = $self->{conf}->{$inPut{bitmap}};
    }
    if ( defined $inPut{hashmap} && defined $self->{conf}->{$inPut{hashmap}} )
    {
        $self->{HASHMAP}->{$inPut{name}} = $self->{conf}->{$inPut{hashmap}};
    }

}
sub Table::getGroupBy() {
    my $self = shift;
    return $self->{GROUPBY};
}
sub Table::getHeaders() {
    my $self = shift;
    return $self->{HEADER};
}
sub Table::addKey(){
    my $self = shift;
    my $string = shift;
    my $rop = shift;
    my $line = shift;
    my $table = shift;
    if ( defined $self->{GROUPBY} && defined $$string && defined $$table )
    {
        $self->{TABLE_GROUPBY}->{$$table}->{$$string}++;
        $self->{TABLE_GROUPBY}->{$$table}->{TOTAL}++;
        if ( defined $$rop )
        {
            $self->{ROP_TABLE_GROUPBY}->{$$rop}->{$$table}->{$$string}++;
            $self->{ROP_TABLE_GROUPBY}->{$$rop}->{$$table}->{TOTAL}++;
        }
    }
    elsif( defined $$string )
    {
        $self->{TABLE}->{$$string}++;
        if ( defined $$rop )
        {
            $self->{ROP_TABLE}->{$$rop}->{$$string}++;
        }
    }
}

1;
