package Type;

use strict;
use locale;
use Table;
use Attrib;
use formatFABRIC;
use timeparser;

use Data::Dumper;

sub Type::new() {
    my $class = shift;
    my %self = @_;
    $self{ATTRIB} = ();
    $self{TABLE} = ();
    $self{TABLEPRINTER} = ();
    $self{REGEXP} = $self{matchString};
    $self{TMESTAMP} = undef;
    $self{KEYS} = {};

    return bless \%self;
}

sub Type::addAttribute() {
    my $self = shift;
    my %inPut = @_;
    push @{$self->{ATTRIB}}, new Attrib( %inPut );
}
sub Type::addAttributesValues() {
    my $self = shift;
    my $obj = shift;
    $self->{obj} = $obj;
}
sub Type::removeAttributesValues() {
    my $self = shift;
    delete $self->{obj};
}
sub Type::addKeys(){
    my $self = shift;
    my %inPut = @_;
    $self->{KEYS}->{$inPut{name}} = $inPut{attribs};
}

sub Type::addStoreData(){
    my $self = shift;
    my %inPut = @_;
    my $mainkey = shift;
    my $key = shift;
    my $string = shift;
    my $type = shift;
    push ( @{$self->{STORE}}, %inPut );
}

sub Type::appendStoreData(){
    my $self = shift;
    my $obj = shift;
    my $key = shift;
    my $string = shift;
    my $type = shift;
    foreach my $store ( @{$self->{STORE}} )
    {
        if ( defined $store->{mainkey} && defined $store->{key} && defined $store->{string} && $store->{type} )
        {
            my $string = $store->{string};
            while( $string =~ /\$([a-zA-Z0-9-_]+)/g )
            {
                my $k = $1;
                if ( defined $obj->{$k} )
                {
                    $string =~ s/\$$k/$obj->{$k}/g;
                }
            }
            my $key = $store->{key};
            while( $key =~ /\$([a-zA-Z0-9-_]+)/g )
            {
                my $k = $1;
                if ( defined $obj->{$k} )
                {
                    $key =~ s/\$$k/$obj->{$k}/g;
                }
            }
            if ( $string =~ /\$/ || $key =~ /\$/ )
            {
                next;
            }
            if ( $store->{type} eq "array" )
            {
                push( @{$self->{ARRAYDATA}->{$store->{mainkey}}->{ $key } }, $string );
            }
            elsif ( $store->{type} eq "counter" )
            {
                $self->{COUNTERDATA}->{$store->{mainkey}}->{ $key }++;
            }
            elsif ( $store->{type} eq "string" )
            {
                $self->{STRINGDATA}->{$store->{mainkey}}->{ $key } = $string;
            }
        }
    }
}

sub Type::removeStoreData(){
    my $self = shift;
    delete $self->{STORE};
}

sub Type::addTable() {
    my $self = shift;
    my %inPut = @_;
    my $table = new Table( conf => $self->{conf}, %inPut );
    push @{$self->{TABLE}}, $table;
    $inPut{table} = $table;
    $self->addTablePrinter( %inPut  );
    return $table;
}

sub Type::getKeys
{
    my $self = shift;
    my $obj = shift;
    my $attribs = shift;
    while( my ( $key, $value ) = each %{$self->{KEYS}} )
    {
        my $values = $value;
        while( $values =~ /\$([a-zA-Z0-9_-]+)/g )
        {
            my $k = $1;
            if ( defined $obj->{$k} )
            {
                $values =~ s/\$$k/$obj->{$k}/g;
            }
        }
        $obj->{$key} = $values;
    }
}

sub Type::addTimeStamp() {
    my $self = shift;
    my %inPut = @_;
    $self->{TMESTAMP} = new timeparser( %inPut );
    return $self->{TMESTAMP};
}

sub Type::getTimeStamp() {
    my $self = shift;
    return $self->{TMESTAMP};
}

sub Type::addTablePrinter() {
    my $self = shift;
    my %inPut = @_;
    my $tablePrinter = new formatFABRIC( %inPut , conf => $self->{conf});
    push @{$self->{TABLEPRINTER}}, $tablePrinter;
    return $tablePrinter;
}

sub Type::getAttributes() {
    my $self = shift;
    return $self->{ATTRIB};
}

sub Type::getTables() {
    my $self = shift;
    return $self->{TABLE};
}

sub Type::getTablesPrinter() {
    my $self = shift;
    return $self->{TABLEPRINTER};
}

sub Type::getRegexp() {
    my $self = shift;
    return $self->{REGEXP};
}


1;
