package formatCSV;

use strict;
use locale;

sub formatCSV::new() {
  my $class = shift;
  my %self = @_;
  $self{format} = "CSV";
  return bless \%self;
}

sub formatCSV::begin(){
    my $self = shift;
    my $path = shift;
    my $tableName = shift;
    $self->printer( $tableName );
}

sub formatCSV::header(){
    my $self = shift;
    my $string = shift;
    my $notUsed = shift;
    my $noSeparater = shift;
    my $linebreaker = "=" x (length($string));
    $self->printer( $linebreaker ) if !defined $noSeparater;
    $self->printer( $string );
    $self->printer( $linebreaker ) if !defined $noSeparater;
}

sub formatCSV::content(){
    my $self = shift;
    my ( $numberOf, $string, $rops ) = @_;
    $self->printer( $numberOf . $string . $rops );
}

sub formatCSV::end(){
    my $self = shift;
    my $string = shift;
    $self->printer( defined $string ?
                    $string : ""); ##Only print string if it's defined.
}

sub formatCSV::printer(){
    my $self = shift;
    my $string = shift;
    my $fh = $self->{fh};
    print $fh "$string\n";
}


1;
