package xml;
use strict;
use Data::Dumper;

sub init
{
    my (%arg) = @_;
    open my $fh, '>', $arg{filename};
    return { file => $fh, level => 0, tabs => 0 };
}

sub start
{
    my (%arg) = @_;
    print { $arg{handle}->{file} } "\t" x $arg{handle}->{tabs};
    $arg{handle}->{tabs}++;
    print { $arg{handle}->{file} } "<" . $arg{name};
    my ( $key, $value );
    print { $arg{handle}->{file} } " " . $key . "=\"" . $value . "\""
        while ( ( $key, $value ) = each %{ $arg{attributes} } );
    print { $arg{handle}->{file} } ">";
    print { $arg{handle}->{file} } "\n"
        unless defined $arg{nonewline} && $arg{nonewline} == 1;
}

sub data
{
    my (%arg) = @_;
    my @lines = split /\n/, $arg{output};
    print { $arg{handle}->{file} } "\t" x $arg{handle}->{tabs}
        unless defined $arg{nonewline} && $arg{nonewline} == 1;
    print { $arg{handle}->{file} } shift @lines;
    for (@lines)
    {
        print { $arg{handle}->{file} } "\n"
            unless defined $arg{nonewline} && $arg{nonewline} == 1;
        print { $arg{handle}->{file} } "\t" x $arg{handle}->{tabs}
            unless defined $arg{nonewline} && $arg{nonewline} == 1;
        print { $arg{handle}->{file} } $_;
    }
    print { $arg{handle}->{file} } "\n"
        unless defined $arg{nonewline} && $arg{nonewline} == 1;
}

sub end
{
    my (%arg) = @_;
    $arg{handle}->{tabs}--;
    print { $arg{handle}->{file} } "\t" x $arg{handle}->{tabs}
        unless defined $arg{nonewline} && $arg{nonewline} == 1;
    print { $arg{handle}->{file} } "</" . $arg{name} . ">\n";
}

sub header
{
    my (%arg) = @_;
    print { $arg{handle}->{file} } "<?" . $arg{output} . "?>\n";
}

sub final
{
    my (%arg) = @_;
    close $arg{handle}->{file};
}

sub read
{
    my (%arg) = @_;
    open XML, '<', $arg{filename};
    my $buffer = "";
    my $line   = "";
    {
        $buffer =~ s/^\s*//;
        if ( $buffer =~ /^<!--/ )
        {
            $buffer .= <XML> until ( $buffer =~ /-->/ );
            $buffer =~ s/.*?-->//s;
            redo;
        }
        elsif ( $buffer =~ /^<\?/ )
        {
            $buffer .= <XML> until ( $buffer =~ /^<\?(.*?)\?>/ );
            &{ $arg{header} }( data => $1, ctx => $arg{ctx} );
            $buffer =~ s/^<\?.*?\?>//;
            redo;
        }
        elsif ( $buffer =~ /^<\/\s*(\S+?)\s*>/ )
        {
            return undef unless &{ $arg{end} }( name => $1, ctx => $arg{ctx} );
            $buffer =~ s/^<\/\s*(\S+?)\s*>//;
            redo;
        }
        elsif ( $buffer =~ /^<\s*(\S+?)((\s+\S+?\s*=\s*\".+?\")*)\s*>/ )
        {
            my $name  = $1;
            my @alist = ( $2 =~ /(\S+?\s*=\s*\".+?\")/g );
            my %attr;
            for (@alist)
            {
                $_ =~ /(\S+?)\s*=\s*\"(.+?)\"/;
                $attr{$1} = $2;
            }
            &{ $arg{start} }
                ( name => $name, attributes => \%attr, ctx => $arg{ctx} );
            $buffer =~ s/^<\s*(\S+?)((\s+\S+?\s*=\s*\".+?\")*)\s*>//;
            redo;
        }
        elsif ( $buffer =~ /^<\s*(\S+?)((\s+\S+?\s*=\s*\".+?\")*)\s*\/>/ )
        {
            my $name  = $1;
            my @alist = ( $2 =~ /(\S+?\s*=\s*\".+?\")/g );
            my %attr;
            for (@alist)
            {
                $_ =~ /(\S+?)\s*=\s*\"(.+?)\"/;
                $attr{$1} = $2;
            }
            &{ $arg{start} }
                ( name => $name, attributes => \%attr, ctx => $arg{ctx} );
            &{ $arg{end} }( name => $1, ctx => $arg{ctx} );
            $buffer =~ s/^<\s*(\S+?)((\s+\S+?\s*=\s*\".+?\")*)\s*\/>//;
            redo;
        }
        elsif ( $buffer =~ /^([^<]+)</ )
        {
            $_ = $1;
            s/\n\s*$//;
            &{ $arg{data} }( data => $_, ctx => $arg{ctx} );
            $buffer =~ s/^([^<]+)</</;
            redo;
        }
        $line = <XML>;
        last unless ($line);
        $buffer .= $line;
        redo;
    }
    close XML;
}

sub events
{
    return ( \&init, \&header, \&start, \&data, \&end, \&final );
}

1;
