package lostTraces;
use strict;
use Data::Dumper;
use POSIX qw(strftime);
use POSIX;
use Time::Local;

sub lostTraces::new() {
    my $class = shift;
    my $conf = shift;
    my $types = shift;
    my %self = @_;
    $self{lostTraces} = $conf->{flotpath} . 'lost_traces.js';
    open LOSTFILE, "> $self{lostTraces}";
    print LOSTFILE "var gapMarkingsData = []\n";
    close LOSTFILE;
    foreach my $type ( @{$types} )
    {
        my $exp = $type->getRegexp();
        if ( $exp eq "INFO" )
        {
            $self{TYPE} = $type;
        }
        elsif ( $exp eq "Messages lost:" )
        {
            $self{TYPE} = $type;
        }
    }
    return bless \%self;
}

sub lostTraces::parser
{
    my $self = shift;
    my $type = shift;
    my $conf = shift;
    if  ( $type->{matchString} eq "INFO:" && $type->{obj}->{infoString} =~ /Monitor\s+overflow:/ )
    {
        $self->{lost_traces}->{$type->{obj}->{newRopTime}} = 1;
    }
    elsif ( $type->{matchString} eq "Messages lost:" && $type->{obj}->{MessagesLost} =~ /Expected sequence no:/ )
    {
        $self->{lost_traces}->{$type->{obj}->{newRopTime}} = 1;
    }
    return undef;
}

sub lostTraces::printer(){
    my $self = shift;
    my $conf = shift;
    my $printer = shift;
    my $modulePrinter = shift;
    open LOSTTRACES, "> $self->{lostTraces}";
    my $tableData  = 'var gapMarkingsData'  . ' = [';
    if (defined $self->{lost_traces} )
    {
        foreach my $rop ( sort keys %{$self->{lost_traces}} )
        {
            if ( $rop =~ /(\d{4})\-(\d{2})\-(\d{2}) (\d{2}):(\d{2})/ )
            {
                 $tableData .= ( (timegm( 0, $5, $4, $3, $2 -1, $1 -1900, 0, 0, 0)) * 1000 ) + 0 . ',';
            }
        }
    }
    $tableData =~ s/,$//;
    $tableData .= ']' . "\n";
    print LOSTTRACES $tableData;
    close LOSTTRACES;
    return ();
}




1;
