#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>

#ifndef __linux__
#include <sys/sockio.h>
#endif

#include <sys/un.h>  
#include <netinet/in.h>
#include <sys/time.h>
#include <netdb.h>
#include <signal.h>  
#include <arpa/inet.h>
#include <string.h>
#include <strings.h>
#include <fcntl.h>
#include <unistd.h>
#include <stropts.h>
#include <net/if.h>

#include "socketLib_soc.h"

/************************************************************************/
/*                                                                     	*/
/* 	Function    : createTCPSocketServer                             */
/*                                                                     	*/
/* 	Description :                                                   */
/*                                                                     	*/
/************************************************************************/

SOCK_RESULT createTCPSocketServer(int serverPort, int *fileDescriptor)
{
  int                listenSock;
  int                on = 1;
  struct sockaddr_in iserv_addr;
  int                iBufferSize=4096;

  listenSock = socket(AF_INET, SOCK_STREAM, 0);

  if (listenSock < 0)
    {
      return (EOPENSOCK);
    }

  bzero((char*) &iserv_addr, sizeof(iserv_addr));
  iserv_addr.sin_family      = AF_INET;
  iserv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  iserv_addr.sin_port        = htons(serverPort);

  if (setsockopt(listenSock, SOL_SOCKET, SO_REUSEADDR | SO_KEEPALIVE, (char *)&on,
		 sizeof (on)) < 0)
    {
      close(listenSock);
      return (ESETSOCKOPT);
    }

  if(setsockopt(listenSock, SOL_SOCKET, SO_RCVBUF, (void *) &iBufferSize,
		sizeof(iBufferSize)))
    {
      close(listenSock);
      return (ESETSOCKOPT);
    }

  if (bind(listenSock, (struct sockaddr*) &iserv_addr,
	   sizeof(iserv_addr)) < 0)
    {
      return (EBADPORTNO);
    }

  listen(listenSock, 5);

  /* OK start accepting connections from the outside */
    
  *fileDescriptor = accept(listenSock,(struct sockaddr*)0,(int*)0);

  return (OK);
}

/************************************************************************/
/*                                                                     	*/
/* 	Function    : createTCPSocketClient                             */
/*                                                                     	*/
/* 	Description :                                                   */
/*                                                                     	*/
/************************************************************************/

SOCK_RESULT createTCPSocketClient(int   serverPort,
				  char *hostRef,
				  int  *fileDescriptor)
{
  int                 receiveSock;
  struct sockaddr_in  iserv_addr;
  struct hostent     *hostEntry;
  unsigned char      *servIPAddr;
  unsigned long       address;
  unsigned int       *hostAddr;
  int                 iBufferSize=262144;

  receiveSock = socket(AF_INET, SOCK_STREAM, 0);

  if (receiveSock < 0)
    {
      return (EOPENSOCK);
    }
  /*
  if (setsockopt(receiveSock, SOL_SOCKET, SO_REUSEADDR, (char *)&on,
		 sizeof (on)) < 0)
    {
      close(receiveSock);
      return (ESETSOCKOPT);
    }
  */
  if(setsockopt(receiveSock, SOL_SOCKET, SO_RCVBUF, (void *) &iBufferSize,
		sizeof(iBufferSize)))
    {
      close(receiveSock);
      return (ESETSOCKOPT);
    }


  /* Check if host name or address */

  if ((address = inet_addr(hostRef)) == -1)
    {
      hostEntry = gethostbyname(hostRef);

      if (hostEntry <= 0)
	{
	  close(receiveSock);
	  return (EINVALHOST);
	}

      servIPAddr = hostEntry->h_addr_list[0];
      hostAddr   = (unsigned int *) servIPAddr;
      address    = *hostAddr;
    }

  bzero((char*) &iserv_addr, sizeof(iserv_addr));
  iserv_addr.sin_family      = AF_INET;
  iserv_addr.sin_port        = htons(serverPort);
  iserv_addr.sin_addr.s_addr = address;

  /* Connect to server */

  if (connect(receiveSock,(struct sockaddr *) &iserv_addr,
	      sizeof(iserv_addr)) < 0)
    {
      close(receiveSock);
      return (ECONNECT);
    }

  *fileDescriptor = receiveSock;
  return (OK);
}

/************************************************************************/
/*                                                                     	*/
/* 	Function    : createUDPSocketServer                             */
/*                                                                     	*/
/* 	Description :                                                   */
/*                                                                     	*/
/************************************************************************/

SOCK_RESULT createUDPSocketServer(int   serverPort,
				  char *hostRef,
				  int  *fileDescriptor)
{
  int                 listenSock;
  int                 on = 1;
  struct sockaddr_in  iserv_addr;

  listenSock = socket(AF_INET, SOCK_DGRAM, 0);

  if (listenSock < 0)
    {
      return (EOPENSOCK);
    }

  bzero((char*) &iserv_addr, sizeof(iserv_addr));
  iserv_addr.sin_family      = AF_INET;
  iserv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  iserv_addr.sin_port        = htons(serverPort);

  if (bind(listenSock, (struct sockaddr*) &iserv_addr,
	   sizeof(iserv_addr)) < 0)
    {
      return (EBADPORTNO);
    }

  *fileDescriptor = listenSock;

  return (OK);
}

/************************************************************************/
/*                                                                     	*/
/* 	Function    : createUDPSocketClient                             */
/*                                                                     	*/
/* 	Description :                                                   */
/*                                                                     	*/
/************************************************************************/

SOCK_RESULT createUDPSocketClient(int   serverPort,
				  char *hostRef,
				  int  *fileDescriptor)
{
  int                 receiveSock;
  int                 on = 1;
  struct sockaddr_in  iserv_addr;

  receiveSock = socket(AF_INET, SOCK_DGRAM, 0);

  if (receiveSock < 0)
    {
      return (EOPENSOCK);
    }

  if (setsockopt(receiveSock, SOL_SOCKET, SO_REUSEADDR, (char *)&on,
		 sizeof (on)) < 0)
    {
      close(receiveSock);
      return (ESETSOCKOPT);
    }

  bzero((char*) &iserv_addr, sizeof(iserv_addr));
  iserv_addr.sin_family      = AF_INET;
  iserv_addr.sin_port        = htons(serverPort);
  iserv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

  /* Connect to server */

  if (bind(receiveSock,(struct sockaddr *) &iserv_addr,
	   sizeof(iserv_addr)) < 0)
    {
      close(receiveSock);
      return (EBADPORTNO);
    }

  *fileDescriptor = receiveSock;

  return (OK);
}

/************************************************************************/
/*                                                                     	*/
/* 	Function    : createUDPBcastClient                              */
/*                                                                     	*/
/* 	Description :                                                   */
/*                                                                     	*/
/************************************************************************/

SOCK_RESULT createUDPBcastClient(int   serverPort,
				 int  *fileDescriptor)
{
  int                 receiveSock;
  int                 on = 1;
  struct sockaddr_in  iserv_addr;

  receiveSock = socket(AF_INET, SOCK_DGRAM, 0);

  if (receiveSock < 0)
    {
      return(EOPENSOCK);
    }

  if (setsockopt(receiveSock, SOL_SOCKET, SO_REUSEADDR, (char *)&on,
		 sizeof (on)) < 0)
    {
      close(receiveSock);
      return (ESETSOCKOPT);
    }

  if (setsockopt(receiveSock, SOL_SOCKET, SO_BROADCAST, (char *)&on,
		 sizeof (on)) < 0)
    {
      close(receiveSock);
      return (ESETSOCKOPT);
    }

  bzero((char*) &iserv_addr, sizeof(iserv_addr));
  iserv_addr.sin_family      = AF_INET;
  iserv_addr.sin_port        = htons(0);
  iserv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

  /* Connect to server */

  if (bind(receiveSock, (struct sockaddr *) &iserv_addr,
	   sizeof(iserv_addr)) < 0)
    {
      close(receiveSock);
      return (EBADPORTNO);
    }

  *fileDescriptor = receiveSock;

  return (OK);
}

/************************************************************************/
/*                                                                     	*/
/* 	Function    : readFromSocket                                    */
/*                                                                     	*/
/* 	Description : Reads from socket.                                */
/*                                                                     	*/
/************************************************************************/

SOCK_RESULT readFromSocket(int   usedSocket,
			   char *msgBuffer,
			   int  *bytesRead)
{
  *bytesRead = read(usedSocket, msgBuffer, 4096);

  if (*bytesRead <= 0)
    {
      /* Read error on socket, exit */
      return (EREAD);
    }

  return (OK);
}

/************************************************************************/
/*                                                                     	*/
/* 	Function    : writeToSocket                                     */
/*                                                                     	*/
/* 	Description : Writes to socket.                                 */
/*                                                                     	*/
/************************************************************************/

SOCK_RESULT writeToSocket(int   usedSocket,
			  char *msgBuffer,
			  int   noOfBytes)
{
  unsigned char     *bufferPtr;
  int                bytesLeft;
  int                bytesWritten;

  bytesLeft = noOfBytes;
  bufferPtr = (unsigned char *) msgBuffer;

  while(bytesLeft > 0)
    {
      bytesWritten = write(usedSocket, bufferPtr, bytesLeft);

      if (bytesWritten <= 0)
	{
	  /* Write error on socket, exit */
	  break;
	}

      bytesLeft -= bytesWritten;
      bufferPtr += bytesWritten;
    }

  return (OK);
}

/************************************************************************/
/*                                                                     	*/
/* 	Function    : receiveFromSocket                                 */
/*                                                                     	*/
/* 	Description : Reads from socket.                                */
/*                                                                     	*/
/************************************************************************/

SOCK_RESULT receiveFromSocket(int   usedSocket,
			      char *msgBuffer,
			      int  *serverPort,
			      char *hostRef,
			      int  *bytesRead)
{
  struct sockaddr_in  iserv_addr;
  int                 addrLen = sizeof(iserv_addr);

  bzero((char*) &iserv_addr, sizeof(iserv_addr));
  iserv_addr.sin_family      = AF_INET;
  iserv_addr.sin_port        = htons(*serverPort);
  iserv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

  *bytesRead = recvfrom(usedSocket, msgBuffer, 2048, 0,
			(struct sockaddr *) &iserv_addr, &addrLen);

  if (*bytesRead <= 0)
    {
      /* Read error on socket, exit */
      return (EREAD);
    }

  *serverPort = htonl(iserv_addr.sin_port);
  strcpy(hostRef, (char *) inet_ntoa(iserv_addr.sin_addr));

  return (OK);
}

/************************************************************************/
/*                                                                     	*/
/* 	Function    : sendToSocket                                      */
/*                                                                     	*/
/* 	Description : Writes to socket.                                 */
/*                                                                     	*/
/************************************************************************/

SOCK_RESULT sendToSocket(int   usedSocket,
			 char *msgBuffer,
			 int   noOfBytes,
			 int   serverPort,
			 char *hostRef)
{
  unsigned char      *bufferPtr;
  int                 bytesLeft;
  int                 bytesWritten;
  struct sockaddr_in  iserv_addr;
  struct hostent     *hostEntry;
  unsigned char      *servIPAddr;
  unsigned int       *hostAddr;
  unsigned int        address;

  /* Check if host name or address */

  if ((address = inet_addr(hostRef)) == -1)
    {
      hostEntry = gethostbyname(hostRef);
    
      if (hostEntry <= 0)
	{
	  close(usedSocket);
	  return (EINVALHOST);
	}

      servIPAddr = hostEntry->h_addr_list[0];
      hostAddr   = (unsigned int *) servIPAddr;
      address    = *hostAddr;
    }

  bzero((char*) &iserv_addr, sizeof(iserv_addr));
  iserv_addr.sin_family      = AF_INET;
  iserv_addr.sin_port        = htons(serverPort);
  iserv_addr.sin_addr.s_addr = address;

  bytesLeft = noOfBytes;
  bufferPtr = (unsigned char *) msgBuffer;
  while(bytesLeft > 0)
    {
      bytesWritten = sendto(usedSocket, bufferPtr, bytesLeft, 0,
			    (struct sockaddr *) &iserv_addr,
			    sizeof(iserv_addr));

      if (bytesWritten <= 0)
	{
	  /* Write error on socket, exit */
	  break;
	}

      bytesLeft -= bytesWritten;
      bufferPtr += bytesWritten;
    }

  return (OK);
}

/************************************************************************/
/*                                                                     	*/
/* 	Function    : bcastOnSocket                                     */
/*                                                                     	*/
/* 	Description : Writes to socket.                                 */
/*                                                                     	*/
/************************************************************************/

SOCK_RESULT bcastOnSocket(int   usedSocket,
			  char *msgBuffer,
			  int   noOfBytes,
			  int   serverPort)
{
  unsigned char      *bufferPtr;
  int                 bytesLeft;
  int                 bytesWritten;
  struct sockaddr_in  iserv_addr;

  bzero((char*) &iserv_addr, sizeof(iserv_addr));
  iserv_addr.sin_family      = AF_INET;
  iserv_addr.sin_port        = htons(serverPort);
  iserv_addr.sin_addr.s_addr = htonl(inet_addr("255.255.255.255"));

  bytesLeft = noOfBytes;
  bufferPtr = (unsigned char *) msgBuffer;
  while(bytesLeft > 0)
    {
      bytesWritten = sendto(usedSocket, bufferPtr, bytesLeft, 0,
			    (struct sockaddr *) &iserv_addr,
			    sizeof(iserv_addr));

      if (bytesWritten <= 0)
	{
	  /* Write error on socket, exit */
	  break;
	}

      bytesLeft -= bytesWritten;
      bufferPtr += bytesWritten;
    }

  return (OK);
}

/************************************************************************/
/*                                                                     	*/
/* 	Function    : cleanup                                           */
/*                                                                     	*/
/* 	Description : terminates socket.                                */
/*                                                                     	*/
/************************************************************************/

void cleanup(int usedSocket)
{
  close(usedSocket);
}
