package ueConfigTables;
use strict;
use Data::Dumper;
use formatTXT;
use formatCSV;
use formatHTML;
use timeparser;

sub ueConfigTables::new() {
    my $class = shift;
    my $conf  = shift;
    my $types = shift;
    my %self  = @_;
    $self{UECONFIG}    = {};
    $self{TABLES}      = ();
    $self{TABLEAME}    = ();
    $self{TEXTPRINTER} = new formatTXT();
    $self{CSVPRINTER}  = new formatCSV();
    $self{HTMLPRINTER} = new formatHTML();
    foreach my $type ( @{$types} ) {
        my $exp = $type->getRegexp();
        if ( $exp eq "IU_IF" ) {
            push( @{$self{TYPES}}, $type);
            $type->{required}->{roamCounter} = 1;
            $type->{required}->{IMSI} = 1;
        }
        elsif ( $exp eq "UEH_EXCEPTION" ) {
            push( @{$self{TYPES}}, $type);
            $type->{required}->{CODE}        = 1;
            $type->{required}->{RbId}        = 1;
            $type->{required}->{'EC-STRING'} = 1;
            $type->{required}->{IMSI}        = 1;
        }
        elsif ( $exp eq "RNC_EXCEPTION" ) {
            push( @{$self{TYPES}}, $type);
            $type->{required}->{CODE}         = 1;
            $type->{required}->{'ERROR-CODE'} = 1;
            $type->{required}->{'EC-STRING'}  = 1;
            $type->{required}->{IMSI}         = 1;
        }
    }
    parseConfig( \%self, $conf->{config} );

    my $type = new Type( matchString => 'ueConfigTables' );
    $self{type} = $type;
    my @headers = ();
    my $table   = {};

    @headers = ( 'CODE', 'RbId', 'EC-STRING' );
    my $tableName = 'Config file UEH_EXCEPTIONS grouped by ueType';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "uetype" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $tableName = 'Config file UEH_EXCEPTIONS grouped by profile';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "profile" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $tableName = 'Config file UEH_EXCEPTIONS grouped by route';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "rack_route" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $tableName = 'Config file UEH_EXCEPTIONS grouped by imsi';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "IMSI" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $self{tables}->{UEH_EXCEPTION} = $table;
    $table = {};
    @headers = ( 'CODE', 'ERROR-CODE', 'EC-STRING' );
    $tableName = 'Config file RNC_EXCEPTIONS grouped by ueType';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "uetype" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $tableName = 'Config file RNC_EXCEPTIONS grouped by profile';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "profile" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $tableName = 'Config file RNC_EXCEPTIONS grouped by route';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "rack_route" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $tableName = 'Config file RNC_EXCEPTIONS grouped by imsi';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "IMSI" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $self{tables}->{RNC_EXCEPTION} = $table;
    $table = {};

    @headers = ( 'roamCounter' );
    $tableName = 'Config file IU_IF grouped by ueType';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "uetype" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $tableName = 'Config file IU_IF grouped by profile';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "profile" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $tableName = 'Config file IU_IF grouped by route';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "rack_route" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $tableName = 'Config file IU_IF grouped by imsi';
    $table->{$tableName} = $type->addTable( name => $tableName, outfile => $conf->{outfile}, silent => $conf->{silent} );
    $table->{$tableName}->addGroupBy( conf => $conf, name => "IMSI" );
    foreach my $header (@headers)
    {
        $table->{$tableName}->addHeader( conf => $conf, name => $header );
    }
    $self{tables}->{IU_IF} = $table;
    $table = {};
    return bless \%self;
}

sub ueConfigTables::parser() {
    my $self = shift;
    foreach my $objType ( @{$self->{TYPES}} )
    {
        next if !defined $objType->{obj}->{IMSI};
        my $obj = $objType->{obj};
        next if !defined $self->{UECONFIG}->{ $obj->{IMSI} };
        foreach my $type ( keys %{$self->{tables}} )
        {
            if ( defined $obj->{traceType} && $obj->{traceType} eq $type )
            {
                foreach my $tableName ( keys %{$self->{tables}->{$type}} )
                {
                    my $tableObj = $self->{tables}->{$type}->{$tableName};
                    my $tableHeaders = $tableObj->getHeaders();
                    my $groupBy      = $tableObj->getGroupBy();
                    if ( defined $groupBy && defined $self->{UECONFIG}->{ $obj->{IMSI} }->{$groupBy})
                    {
                        $$obj{$groupBy} = $self->{UECONFIG}->{ $obj->{IMSI} }->{$groupBy};
                    }
                    my $uniqueString;
                    foreach my $header (@$tableHeaders)
                    {
                        if ( defined $$obj{$header} )
                        {
                            $uniqueString .= $$obj{$header} . ';';
                        }
                        else
                        {
                            $uniqueString .= '-' . ';';
                        }
                    }
                    if ( defined $uniqueString && $uniqueString !~ /^[-;]+$/ ) {
                        chop $uniqueString;
                        if ( defined $groupBy && defined $$obj{$groupBy} )
                        {
                            $tableObj->addKey(    \$uniqueString, \$obj->{newRopTime}, undef, \$$obj{$groupBy} );
                        }
                    }
                }
            }
        }
    }
    return undef;
}

sub ueConfigTables::printer() {
    my $self    = shift;
    my $conf    = shift;
    my $printer = shift;
    my $format  = shift;

    my $timeParser = new timeparser( );
    my @tablesToPrint;

    my $tablePrinters = $self->{type}->getTablesPrinter();
    foreach my $tablePrinter ( @$tablePrinters )
    {
        if ( defined $conf->{csv} && $format eq 'CSVPRINTER' )
        {
            $tablePrinter->{PRINTER} = $tablePrinter->{CSVPRINTER};
            $tablePrinter->{fh} = $self->{fh};
            $tablePrinter->printTable( );
        }
        elsif( $format eq 'TEXTPRINTER' )
        {
            $tablePrinter->{PRINTER} = $tablePrinter->{TEXTPRINTER};
            $tablePrinter->{fh} = $self->{fh};
            $tablePrinter->printTable( );
        }
        elsif ( defined  $conf->{html} && $format eq 'HTMLPRINTER' )
        {
            $tablePrinter->{HTMLPATH} = $conf->{html};
            $tablePrinter->{PRINTER} = $tablePrinter->{HTMLPRINTER};
            $tablePrinter->printTable( );
            my $name = ( defined $tablePrinter->{max}?"Top $tablePrinter->{max} ":"") .  $tablePrinter->{name};
            #my $name = 'Top_' . $tablePrinter->{max} . '_' . $tablePrinter->{name};
            $name =~ s/\s+/_/g;
            push( @tablesToPrint, $name );
        }
    }
    return @tablesToPrint;
}

#IMSI           TYPE            UE      PROFILE                                       ROUTE
#235911003301000 U360            0       9.2_CS_Speech_WB-AMR                                                                   Rack33_Route_A
#235911003301001 K810            1       9.2_CS_Speech_WB-AMR                                                                           Rack33_Route_A
#235911003301002 K810            2       9.2_CS_Speech_WB-AMR                          Rack33_Route_A
#235911003301003 CS702           3       9.2_CS_Speech_WB-AMR                          Rack33_Route_A
#235911003301004 QC8220          4       9.2_CS_Speech_WB-AMR                          Rack33_Route_A

sub ueConfigTables::parseConfig() {
    my $self = shift;
    my $file = shift;
    open CONFIG, "< $file";
    foreach my $line (<CONFIG>) {
        if ( $line =~ /^\s*#/ ) {
            next;
        }
        next if $line =~ /^\s*$/;
        if ( $line =~ /^\s*(\S+?)\s*=\s*(.+?)\s*$/ ) {
            next;
        }
        my @line = split( /\s+/, $line );
        if ( @line == 5 ) {
            if ( $line =~
                /^\s*(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(Rack\S+?)_(Route_\S+)\s*$/i
              )
            {
                my ( $imsi, $uetyp, $ueno, $profile, $ccn, $rutt ) =
                  ( $1, $2, $3, $4, $5, $6 );
                $self->{UECONFIG}->{$imsi}->{uetype}  = $uetyp;
                $self->{UECONFIG}->{$imsi}->{ueno}    = $ueno;
                $self->{UECONFIG}->{$imsi}->{profile} = $profile;
                $self->{UECONFIG}->{$imsi}->{route}   = $rutt;
                $self->{UECONFIG}->{$imsi}->{ccn}     = $ccn;
                $self->{UECONFIG}->{$imsi}->{rack_route}   = $ccn . '_' . $rutt;
                my $length = ( length($profile) );
                if ( !defined $self->{UECONFIG_LENGTH} ) {
                    $self->{UECONFIG_LENGTH} = 0;
                }
                if ( $length > $self->{UECONFIG_LENGTH} ) {
                    $self->{UECONFIG_LENGTH} = $length;
                }
                push( @{ $self->{UEARRAY}->{$ccn}->{$rutt} }, $imsi );
            }
        }
        else {
            print STDERR "teSummary wrong format in config file: $line\n";
        }
    }
    close CONFIG;
}

1;

