package teSummaryDiff;
use strict;
use Data::Dumper;
my $header_hash;
my ($oldfile,$newfile);
my @tables =
(
'^Top \d+ UEH_EXCEPTIONs.\s*$',
'^Top \d+ ERRORs.\s*$',
'^Top \d+ RNC_EXCEPTIONs.\s*$',
'^Top \d+ INFOs.\s*$',
'^Top \d+ IU_IF ROAM Counters.$',
'^Top \d+ IU_IF Release Requests',
'^Top \d+ IU_IF Release Command\s+\(.+?\)\.$',
'^Top \d+ SP_EXCEPTION.$',
'^Top \d+ unique UEH_EXCEPTIONs in DRNC.$',
'^Top \d+ UEH_EXCEPTIONs per transitions.$',
'^Top \d+ UE_GENERAL procedure names.$',
'^Top \d+ UE_GENERAL source UeRc states.$',
'^Top \d+ UE_GENERAL target UeRc states.$',
'^Top \d+ Attempted UeRc transitions.$',
);
sub read_files
{
    my $file = shift;
    my $tablehit;
    my $stringMap;
    my $hash;
    my $end = '\d+ \(TOTAL\)\s*----------------------------------';
    my $printflag;
    open FILE, "< $file";
    while (my $line = <FILE>)
    {
        chomp($line);
        if ($line =~ /^Top/i)
        {
            foreach my $table (@tables)
            {
                if ($line =~ /$table/i)
                {
                    $tablehit = $line;
                    $printflag = 1;

                }
            }
        }
        if($line =~ /Log file Ends at:\s+(.+)/)
        {
            $hash->{endtime} = $1;
        }
        elsif ($line =~ /Log file Starts at:\s+(.+)/)
        {
            $hash->{starttime} = $1;
        }
        elsif ($line =~ /Log file Duration:\s+(.+)/)
        {
            $hash->{duration} = $1;
        }

        if ($line =~ /$end/)
        {
            $printflag = undef;
            $tablehit = undef;
            next;
        }
        if (defined $printflag && $line =~ /^(\d+)\s+(.+)\s*$/)
        {
            my $count = $1;
            my $string = $2;
            $string =~ s/\s+$//;
            my $matchString = $string;
            $matchString =~ s/\s+/ /g;
            $hash->{$tablehit}->{$matchString} = $count;
            $stringMap->{$tablehit}->{$matchString} = $string;
        }
        elsif (defined $tablehit && $line =~ /^COUNT/)
        {
            $line =~ s/COUNT\s+//i;
            $header_hash->{$tablehit} = $line;
        }
    }
    close FILE;
    return ($hash,$stringMap);
}

sub compare_result
{
    my $old_hash = shift;
    my $new_hash = shift;
    my $stringMap1 = shift;
    my $stringMap2 = shift;
    my $length = 0;

    $old_hash->{endtime} = '' if !defined $old_hash->{endtime};
    $old_hash->{starttime} = '' if !defined $old_hash->{starttime};
    $old_hash->{duration} = '' if !defined $old_hash->{duration};
    $new_hash->{duration} = '' if !defined $new_hash->{duration};
    $new_hash->{endtime} = '' if !defined $new_hash->{endtime};
    $new_hash->{starttime} = '' if !defined $new_hash->{starttime};

    print "file1: " . $oldfile . " StartTime: " . $old_hash->{starttime} . " EndTime: " . $old_hash->{endtime} . " Duration: " . $old_hash->{duration} . "\n";
    print "file2: " . $newfile . " StartTime: " . $new_hash->{starttime} . " EndTime: " . $new_hash->{endtime} . " Duration: " . $new_hash->{duration} . "\n";

    delete $old_hash->{endtime} if defined $old_hash->{endtime};
    delete $old_hash->{starttime} if defined $old_hash->{starttime};
    delete $old_hash->{duration} if defined $old_hash->{duration};
    delete $new_hash->{duration} if defined $new_hash->{duration};
    delete $new_hash->{endtime} if defined $new_hash->{endtime};
    delete $new_hash->{starttime} if defined $new_hash->{starttime};
    #store the different data
    my $tmp_hash;
    foreach my $table (sort keys %{$old_hash})
    {
        foreach my $line (keys %{$old_hash->{$table}})
        {
            $tmp_hash->{$table}->{$line}->{old} += (defined $old_hash->{$table}->{$line}) ? $old_hash->{$table}->{$line} : 0;
        }
        foreach my $line (keys %{$new_hash->{$table}})
        {
            $tmp_hash->{$table}->{$line}->{new} += (defined $new_hash->{$table}->{$line}) ? $new_hash->{$table}->{$line} : 0;
        }
    }
    foreach my $table (sort keys %{$new_hash})
    {
        next if defined $tmp_hash->{$table};
        foreach my $line (keys %{$old_hash->{$table}})
        {
            $tmp_hash->{$table}->{$line}->{old} += (defined $old_hash->{$table}->{$line}) ? $old_hash->{$table}->{$line} : 0;
        }
        foreach my $line (keys %{$new_hash->{$table}})
        {
            $tmp_hash->{$table}->{$line}->{new} += (defined $new_hash->{$table}->{$line}) ? $new_hash->{$table}->{$line} : 0;
        }
    }
    foreach my $tablehit (@tables)
    {
        foreach my $table (sort keys %{$tmp_hash})
        {
            if($table =~ m/$tablehit/i)
            {
                my $header = $header_hash->{$table};
                if(defined $header)
                {
                    $header = sprintf("COUNT1 COUNT2  %s\n",$header);
                    print_header_diff($table,$header);
                }
                foreach my $line (keys %{$tmp_hash->{$table}})
                {
                    my $count1 = (defined $tmp_hash->{$table}->{$line}->{old}?$tmp_hash->{$table}->{$line}->{old}:0);
                    my $count2 = (defined $tmp_hash->{$table}->{$line}->{new}?$tmp_hash->{$table}->{$line}->{new}:0);
                    my $matchString = $line;
                    $matchString =~ s/\s+/ /g;
                    my $string = ( defined $stringMap1->{$table}->{$matchString}?$stringMap1->{$table}->{$matchString}:"");
                    if ( $string eq "" )
                    {
                        $string = ( defined $stringMap2->{$table}->{$matchString}?$stringMap2->{$table}->{$matchString}:"");
                    }
                    printf("%-6s %-6s   %s\n",$count1,$count2,$string);
                }
                print "\n";
            }
        }
    }
    print "\n";
}


sub print_header_diff
{
        my $table = shift;
        my $header = shift;
        print $table . "\n";
        print "===================================================================================================\n";
        print $header;
        print "===================================================================================================\n";
}

sub diff
{
    my $confighash = shift;
    ($oldfile,$newfile) = split(/,/,$confighash->{diff});
    if (!-e $oldfile || !-e $newfile)
    {
        print "check the files that you want to diff.\n";
    }
    my ($old_hash,$stringMap1) = read_files($oldfile);
    my ($new_hash,$stringMap2) = read_files($newfile);
    compare_result($old_hash,$new_hash,$stringMap1,$stringMap2);
    exit;
}

1;
