package teSummaryHELP;
use strict;

my $help = <<HELPTEXT;
******************************************************************************
*******************************  teSummary.pl  *******************************
******************************************************************************
by: Martin Aldrin
This script "teSummary.pl" creates a summary report build on the log files from the TE Monitor, flow, decoder or te log read output.
This version has support for concat traces.
Some parts required  that the log file has past the decoder before you can get a full summery report.

OPTIONS:

    -eimsi      <imsi>      Exclude an imsi or imsi group from the Summary Report,
                            use pipe to create a list of imsi(s) that should be skipped.

    -ecell      <cell>      Exclude a cell from the Summary Report,
                            use pipe to create a list of cells that should be skipped.

    -imsi       <imsi>      Filter on an imsi or imsi group, use pipe to create a list of imsi(s).

    -cell       <cell>      Filter on the cellId, use pipe to create a list of cells.

        -or                 Option to make it possible to filter on imsi or cell.

    -file|f     <file>      Specify file. Then you using this option to specify the file instead of pipe to the file a progress counter will be printed.
                        It's also possible to specify a path to a directory, teSummary will try to read all files in that directory.

    -table     <RegExp>     Will only print table that match the specified. use pipe to separate.

    -etable    <RegExp>     Will only print table that NOT match the specified. use pipe to separate.

    -type     <RegExp>      Will only print types that match the specified. use pipe to separate.

    -etype    <RegExp>      Will only print types that NOT match the specified. use pipe to separate.

    -noueStat <N/A>         Turn of ueStat tables.

    -noueRackTables         Turn of ueRackTables.

    -notransitionAttempt    Turn of transitionAttempts.

    -noueConfigTables       Turn of configTables.

    -extended               This will give an extended Summary.

    -start|s                Specify the start time. Time format is 2009-03-01.15:00:00

    -end|e                  Specify the end time. Time format is 2009-03-01.15:00:00

    -max        <number>    Specify the maximum number of lines per table, default is 100.

    -config|c               Specify a config file to get some extra information just for specified imsi in the config file.
                        Can also be used to specify input parameters, see example below.

    -3gsim                  Read 3gsim traffic file (only lab).

    -html    <file.html>    teSummary.pl will generate a html file.

    -output|o    <outfile>  teSummary will generated a log file as well.

    -traces                 Help about recommend traces.


    -diff                   Use this option to diff two teSummary results.
                        will only be in text format.

    -nodiff                  let the user store diff result without reading in old.

    -diffstore <path>       path to store teSummary Dumps, next time teSummary is executed this will be read and shown in a new table.
                        This will let you compare data from longer period, without parse all data at again.
                        Important to get this option work properly, the time period for the different runs shall be as similar as possible.
                        As default all files in the diffstore will be read.
                        use -difffiles to specify files to diff.

    -difffiles    <file1,file2> specify which files to include in the diff.
                        Required option is -diffstore

    -onlydiff               This option will allow you to only read old data that are stored in the diffstore without parsing a new file.
                        Required option is -diffstore

    -converthtmltodump  <dir>   convert from html to teSummary dump format.
                        location where to find old teSummary files.
                        must be used together with diffstore.


    -rop|r                  se exception quarter by quarter.

    -csv                    print with ';' as separator.

    -noconcat               Will not concat the traces, will speed up the trace parsing.

    -noconvert              Will not convert Moshell printouts, will speed up the trace parsing.

    -printrop               Will print Summary every rop.

    -force                  Will overwrite the content in the html directory.

    -period    <15>         Allow you to specify frequencies, default is every 15 minutes.
                        This option will only have affect together with -rop or -html.
                        Accepted range is 1-60, or up to 1440 and divisible with 60.

    -silent                 No Summary tables will be printed on the screen.

    -perimsi                Will print tables per imsi,

    -pertimsi               Will print tables per timsi,

    -perimeisv              Will print tables per imeisv,

    -mhweb                  Will search Error and Exception in mhweb,

    -comment                Add comments into html page.

    -teDB                   Store teSummary results into database.  When using this option,
                        the stp, node, runtype, and sw parameters must also be passed in.

    -node        <nodeName>          Used in conjunction with the teDB flag.
                        The node name should be the string describing the node that the
                        given teSummary information belongs to (eg. RNC101, RBS200, etc.)

    -stp        <stpName>        Used in conjunction with the teDB flag.
                        The stp name should be the string describing the stp that the
                        node being reported belongs to. (eg. STP192, STP130, etc.)

    -runType    <runType>        Used in conjunction with the teDB flag.
                        The run type string should describe the type of run being
                        reported to the database (eg. 2h, 4h, nightly, etc.)

    -sw        <softwarePackage>    Used in conjunction with the teDB flag.
                        The sw string should describe the software package that was used
                        on the node being reported to the database
                        (eg. CXP9014711%7_R11CA10,  CXP9021775_R1CB01_W12B, etc.)

    -start_time    <start_time>        Used in conjunction with the teDB flag.
                        Optional parameter when using teDB mode.
                        This start time is used to identify individual stp runs when
                        they are reported to the database.  For example, if NodeA and
                        NodeB both belong to STP_AB, the start times for the reports on
                        both NodeA and NodeB need to be identical in order for the
                        system to interpret them to belong to the same run on STP_AB.
                        If they are different, the system will assume that the results
                        from NodeA and NodeB are from 2 different runs for 2 different
                        nodes on the same STP.  If no start time is given, the system
                        will use whatever start time is found in the logs, which can
                        occasionally vary between two nodes on the same STP.  If it is
                        imperative that several nodes be associated with the same STP
                        run, it is recommended to use the -start_time command-line
                        parameter.
                        Supported time formats are: 2013-01-01.14:14:14 or 130101_141414
                        or 130101141414.

    -tedb_log|tl    <log name>        Used in conjunction with the teDB flag.
                        Optional parameter when using teDB mode.
                        Specifies a file where to print the teDB-specific log traces.
                        If this is not given, it defaults to use a file named tedb_syslog.

    -testcase|tc    <testcase name>        Used in conjunction with the teDB flag.
                        Optional parameter when using teDB mode.
                        String that indicates which testcase is being run on the reporting
                        node.

    -teststep|ts    <teststep name>        Used in conjunction with the teDB flag.
                        Optional parameter when using teDB mode.
                        String that indicates which teststep is being run on the reporting
                        node.

    -eJSON                  Used in conjunction with the html flag.
                        Optional parameter when using the html flag. All JSON dataseries will
                        will be the same length by padding them with zeros if there are no
                        data for the period.

    -midPoint               Used in conjunction with the html flag.
                        Will put the datapoints off graphs in the middle of each period
                        instead of the end.

    -completeROPs           Used in conjunction with the html flag.
                        Only shows complete ROP periods in the html graphs by removing the
                        first and last rop period from the graphs if there are three or more
                        ROPs.

    -xml                    Run teSummary with custom configuration of tables. Default it is teSummary.xml 
                        from /etc directory. To create own configuration xml, check teSummary.xml as pattern.
    
    -help|h                 Syntax help.



HELPTEXT

my $traces = <<TRACEINFO;
Important RNC traces:
    lh mod te e all RNC_EXCEPTION
    lh mod te e all UEH_EXCEPTION
    lh mod te e all DRH_EXCEPTION
    lh mod te e all PM_OBS_EXCEPTION
    lh mod te e trace1 trace3 UE_IU_IF
    lh mod te e all ADMISSION_REJECT_CELL
    lh mod te e all AAL2REJECTS
    lh mod te e all AAL2NCCDISCIND
    lh mod te e trace4 UE_GENERAL
    lh dc te e all SP_EXCEPTION
    lh cc te e all SP_EXCEPTION
    lh dc te e all SP_CONFIG_REJ
    lh cc te e all SP_CONFIG_REJ

    lh dc te e all DISCARD_UE
    lh dc te e all RETRANSM_UE
    lh dc te e trace1 HANDOVER_EVAL_UE

    lh mod Ue_pm_event_enableall
    lh dc Sp_pm_event_enableall
    pset <proxy> RAB_ESTABLISHMENT|RAB_RELEASE|IFHO_E|HSDSCH|IRAT|CONGESTION$|CAPABILITY_INFORMATION$|FAILURE|REJECT|CANCEL|RESET|ERROR utrancell=<cell cluster>
    pdeb <proxy>

Important RBS traces:
    te e all RADIOLINK_REJECT
    te e all AAL2REJECTS
    te e all AAL2NCCDISCIND

Recommended RNC traces:
    lh mod te e trace3 trace5 UE_HANDOVER_AS
    lh mod te e bus_send bus_receive UE_ASN_RRC
    lh mod te e bus_send bus_receive UE_ASN_RANAP
    lh mod te e bus_send bus_receive UE_ASN_NBAP
    lh mod te e bus_send bus_receive UE_ASN_RNSAP
    lh dc te e bus_send bus_receive RRC_DL_UE
    lh dc te e bus_send bus_receive RRC_UL_UE

    lh mod te e bus_send bus_receive PM_OBS_IND
    lh dc te e bus_send bus_receive PM_OBS_IND
    lh dc te e bus_send bus_receive RLC_CP_DL_UE
    lh dc te e bus_send bus_receive RLC_CP_UL_UE
    lh dc te e bus_send bus_receive RLC_CP_CONTROL_DL_UE
    lh dc te e bus_send bus_receive RLC_CP_CONTROL_UL_UE

Recommended RBS traces:
    te e bus_send bus_receive NBAP_RL_HANDLING
    te e bus_send bus_receive NBAP_CELL_CHANNEL

TRACEINFO

sub helpTextPrinter {
    my $conf = shift;
    if ( defined $conf->{help} ) {
        print $help;
        exit;
    }
    elsif ( defined $conf->{traces} ) {
        print $traces;
        exit;
    }
}

1;
