#!/usr/bin/bash

dockerdir=$(dirname $(readlink -f "$0"))

USERVAR=${USER}
INSTALL=0
ADDUSER=0
RUN=0
MOSHELL_VERSION=""
MOSHELL_VERSION_INSTALL=""
BYPASS_DOCKER_CHECK=0
STOPCONTAINER=0
PATH_TO_MOSHELL=""

usage() {                                 # Function: Print a help message.
	echo "Usage: $0 [ -i PATH/TO/MOSHELLXX.XX.ZIP ] [ -s MOSHELL_VERSION ] [ -n ] [ -u USER ] [ -k MOSHELL_VERSION ] [ -b ]" >&2
	echo ""
	echo "[ -i PATH/TO/MOSHELLXX.XX.ZIP ]"
	echo -e "	Install moshell and set up docker container/image\n";
	echo "[ -r MOSHELL_VERSION ]"
	echo -e "	Start or restart the docker container and run moshell\n"
	echo "[ -s MOSHELL_VERSION ]"
	echo -e "	Stop a docker container\n"
	echo "[ -d MOSHELL_VERSION ]"
	echo -e "	Delete a docker container\n"
	echo "[ -u USER ]"
	echo -e "	To change the user var from the default one. See README.txt for more details\n"
	echo "[ -a MOSHELL_VERSION ]"
	echo -e "	Add a user to a docker container\n"
	echo "[ -b ]"
	echo -e "	Bypass the docker configuration check\n"
	echo -e "More information can be found in the readme.\n"
}
exit_with_error() {
	usage
	exit 1
}
add_user_func() {
	# ADD_USER
	docker exec ${USERVAR}_container_moshell${MOSHELL_VERSION} useradd -rm --no-log-init -d /home/"$(id -u -n ${USER})" -s /bin/bash --uid "$(id -u ${USER})" \
	--gid "$(id -g ${USER})" --groups "$(id -g ${USER})" "$(id -u -n ${USER})";		
}

while getopts ":i:r:u:s:a:bhd:" arg; do
	case "${arg}" in
		i)	# INSTALL
			INSTALL=1
			PATH_TO_MOSHELL=${OPTARG}
			# path/to/moshellxx.xx.zip <- keep 5 chars following the 9th char from the end of the string, i.e. the version nr "xx.xx"
			MOSHELL_VERSION_INSTALL="${PATH_TO_MOSHELL: -9:5}"
			;;
		r)	# Run/restart the container and run moshell
			RUN=1
			MOSHELL_VERSION=${OPTARG}
			;;
		u)	# Set user variable to something else
			USERVAR=${OPTARG}
			;;
		s)	# Stop a running container, default = ${USER}_container_moshell${MOSHELLVERSION}, change user with -u
			STOPCONTAINER=1
			MOSHELL_VERSION=${OPTARG}
			;;
		d)	# Delete a container, default = ${USER}_container_moshell${MOSHELLVERSION}, change user with -u
			DELETECONTAINER=1
			MOSHELL_VERSION=${OPTARG}
			;;
		a) 	# If you wish to add your user to a container but not start the container.
			ADDUSER = 1
			MOSHELL_VERSION=${OPTARG}
			;;
		b)	# Bypasses the docker check in case the system works differently for external users
			BYPASS_DOCKER_CHECK=1
			;;
		h)  	# Help
			usage; 
			exit 1
			;;
		*)
			exit_with_error;;
	esac
done

# Check that there are input arguments
if [[ $# -eq 0 ]]; then	
	usage; 
	exit 1
fi

# Check that docker is properly configured
if [[ $BYPASS_DOCKER_CHECK -eq 0 ]] && [ $(docker version | grep -c "Server:") -eq 0 ]; then
	echo -e "Please ensure that docker is properly installed and configured, see readme for more information."
	exit 1
fi
if [[ $INSTALL -eq 1 ]]; then
	rm -f -r /tmp/${USER}_moshell${MOSHELL_VERSION_INSTALL}	# Clean up unnecessary directory
	mkdir /tmp/${USER}_moshell${MOSHELL_VERSION_INSTALL}
	unzip -o $PATH_TO_MOSHELL -d /tmp/${USER}_moshell${MOSHELL_VERSION_INSTALL}/
	cp $dockerdir/Dockerfile /tmp/${USER}_moshell${MOSHELL_VERSION_INSTALL}/
	cd /tmp/${USER}_moshell${MOSHELL_VERSION_INSTALL}
	# BUILD
	docker build --build-arg GROUP_ID=$(id -g ${USER}) --build-arg GROUP_NAME=$(id -g -n ${USER}) -t moshell_$MOSHELL_VERSION_INSTALL .;
fi
if [[ $ADD_USER -eq 1 ]]; then
	
	(docker ps | grep -q " ${USERVAR}_container_moshell${MOSHELL_VERSION}") && add_user_func || exit_with_error	#If a docker container is running, we want to add the current user
fi
# The start function starts moshell if a container with the given name is running, if a container is exited or is not started,
# this is also handled in the conditional statements.
if [[ $RUN -eq 1 ]]; then
	if docker ps | grep -q " ${USERVAR}_container_moshell${MOSHELL_VERSION}"; then
		# START
		echo "To run moshell, in the next window enter: >> /opt/moshell/moshell "
		docker start ${USERVAR}_container_moshell${MOSHELL_VERSION}
		docker exec -it -u "$USER" ${USERVAR}_container_moshell${MOSHELL_VERSION} /bin/bash;		
		
	else
		if [ ! "$(docker ps -a -q -f name=${USERVAR}_container_moshell${MOSHELL_VERSION})" ]; then
    			if [ "$(docker ps -aq -f status=exited -f name=${USERVAR}_container_moshell${MOSHELL_VERSION} )" ]; then
        			# cleanup
        			docker rm ${USERVAR}_container_moshell${MOSHELL_VERSION} 
    			fi
 			# RUN
    			docker run -d -t --name ${USERVAR}_container_moshell${MOSHELL_VERSION} --network host --mount type=bind,source=/proj,target=/proj moshell_$MOSHELL_VERSION;
		else
			docker start ${USERVAR}_container_moshell${MOSHELL_VERSION}	
		fi
		add_user_func

		# START
		echo "To run moshell, in the next window enter: >> /opt/moshell/moshell "
		docker exec -it -u "$USER" ${USERVAR}_container_moshell${MOSHELL_VERSION} /bin/bash;
	fi
fi
if [[ $STOPCONTAINER -eq 1 ]]; then
	docker stop ${USERVAR}_container_moshell${MOSHELL_VERSION};
fi
if [[ $DELETECONTAINER -eq 1 ]]; then
	docker rm ${USERVAR}_container_moshell${MOSHELL_VERSION};
fi
