#!/usr/bin/perl -w

#
#  v0.01 erached & ecarnsa::	 plot the pmRadioUeRepCqiDistr and pmRadioUeRepCqiDistr2 counters under the "pmr" command... need a proper CONFIG file.
# 
#
#
#
# (this script require to install "gnuplot" under cygwin)
#


use strict;
use FileHandle;




my (@Object_array, @unique_object, @name_file, @title_plot);
my (@data, @temp, @ytics);
my %Kpi;
my $var;
my $xtics;
my $index = 0;
my @time;
my ($i,$k,$j,$title,$usage);
my ($date, $time, $Object, $value, $list, $time_object);
my $offset=0;
my $counter_index;
my ($license,$string);
my $flag="";
my $folder=".";



$usage="\n\n\n\n Usage: $0 Counter_name \n\n\n";
@ARGV == 1 or @ARGV == 3 or die $usage;
if ($ARGV[0] eq "h" ){print $usage;exit;}
if (defined $ARGV[0] ){ $title = $ARGV[0]; }
if (defined $ARGV[1]) {
	if ($ARGV[1] eq "-out") { $folder = $ARGV[2]; } else { die(" argument not correct"); }
	}



while (<STDIN>) {
	$date = "";
	if (/^(\d\d\d\d-\d\d-\d\d) (\d\d:\d\d) (\S+) (.*)/) { $date=$1; $offset=1;} #set an offset of one in case there is also the date
	if (/(\d\d:\d\d) (\S+) (.*)/) { $time = $1; $Object= $2; $value=$3; print $date." ".$time." ".$Object." ".$value."\n";
		$time_object = $date." ".$time." ".$Object;
	$Kpi{$time_object} = $value;
	$Object_array[$index] = $Object; 
	$index ++;
	}
}

###  Find the unique elements of $Object_array

my %temp;
@unique_object = grep { ! $temp{$_}++ } @Object_array;
$list = @unique_object;

for ($i=0; $i<$list; $i++) {
	$name_file[$i]=$unique_object[$i];
	$title_plot[$i]=$unique_object[$i];
	$name_file[$i]=~s/,/_/g;
	$title_plot[$i]=~s/_/_-/g;
}




for ($j=0; $j<$list; $j++) {

$counter_index = 0;

open OUTPUTFILE, ">".$folder."/ROT_temp.txt";

foreach $var (sort keys %Kpi) {
	if ($var =~ $unique_object[$j]) {

	$counter_index ++;
	if ($var=~ /(\d\d:\d\d) \S+/) {$time[$counter_index]=$1;}
	@data = split(',',$Kpi{$var});
	if (scalar(@data) > 0) {
		for ($i=0; $i<scalar(@data); $i++) {
			if ($data[$i] ne 0) {
			print OUTPUTFILE ($counter_index." ".($i)." ".$data[$i]."\n");
			}
		}
	}
	print OUTPUTFILE "\n";
	}
}

$xtics = 'set xtics (';
for ($k=1; $k<scalar(@time); $k=$k+4) {
if ($k==1) { $xtics = $xtics.'"'.$time[$k].'"'.$k;}
else { $xtics = $xtics.',"'.$time[$k].'"'.$k;}
}
$xtics = $xtics.") rotate by -90";
close OUTPUTFILE;


open (GP, "|gnuplot ") or die "no gnuplot";
GP->autoflush(1);
print GP "set term pngcairo size 1280,480 enhanced font 'Verdana,10'\n";
print GP "set output '",$folder,"/",$name_file[$j],"_",$title,".png'\n";
print GP "reset\n";
print GP "set lmargin 7\n";
print GP "set rmargin 29\n";
print GP "set title '",$title,"' font 'Verdana,14'\n";
print GP "set xlabel 'Time'\n";
print GP "set ytics nomirror\n";
print GP "set xtics nomirror\n";
print GP "set grid\n";
#print GP "set label '<= 0.5' at -7.3,-3\n";
#print GP "set label '>= 25' at -6.7,53\n";
#print GP "set arrow from -2.4,-3 to -1,0\n";
#print GP "set arrow from -2.4,53 to -1,50\n";
print GP "set ytics ('0' 0, '1' 1, '2' 2, '3' 3, '4' 4, '5' 5, '6' 6, '7' 7, '8' 8, '9' 9, '10' 10, '11' 11, '12' 12, '13' 13, '14' 14, '15' 15)\n";
print GP  $xtics,"\n";
print GP "set yrange [-1:",(scalar(@data)),"]\n";
print GP "set xrange [-1:",(scalar(@time)+1),"]\n";
print GP "set key out\n";
print GP "set multiplot\n";
print GP "set size 1.06,1\n";

print GP "set pal defined ( 0 '#0101DF', 4 '#0000FF', 8 '#0080FF', 16 '#00BFFF', 32 '#00FFFF', 48 '#01DFA5', 64 '#04B45F', 96 '#01DF3A', 128 '#40FF00', 192 '#D0FA58', 256 '#FFFF00', 384 '#FF8000', 512 '#F79F81', 756 '#FF0000', 1024 '#8A0808')\n";
print GP "set colorbox vertical user origin .9,.15 size 0.02,.75 \n";
print GP "plot '".$folder."/ROT_temp.txt' u 1:2:3 w p pt 7 ps 1.8 lc palette notitle\n";
print GP "unset border\n";
print GP "unset xtics\n";
print GP "unset ytics\n";
print GP "unset title\n";
print GP "unset xlabel\n";
print GP "set ylabel 'CQI #'\n";
print GP "unset key\n";
print GP "unset grid\n";
print GP "set lmargin 4\n";
print GP "unset rmargin\n";
print GP "set xrange [1:10]\n";
print GP "set yrange [1:10]\n";
print GP "set label 'Number of samples' at  8.65,5 rotate by 90\n";
print GP "set label '",$title_plot[$j],"' font 'Verdana,12' at 6.5,9.8\n";
print GP "set object 1 rect fc rgbcolor '#FFFFFF' fillstyle solid 1.0 noborder\n";
print GP "set object 1 rect from 9.1,2.3 to 9,1.9\n";
print GP "set label '1' at 9.02,2.12 \n";
print GP "plot 0/1 \n";
print GP "unset multiplot\n";

close GP;
}
