%%
%% This is file 'ericsson.cls',
%% NOT generated with the docstrip utility.  :-)
%%
%% Instructions:
%% =============
%%
%% Use \documentclass{ericsson} and set the header fields with the
%% commands \infotype, \doctype, \file, \docresp, \docprep, \docchk, 
%% \docno, \docrev and \docdate.
%%
%% The value of \docdate is by default set to today's date, but may be
%% overridden. All other fields default to empty.
%%
%% Authors:
%% ========
%%
%% Morten Vadskjr Jensen (mvj@ericssontelebit.com)
%% Morten Heiberg         (mhr@ericssontelebit.com)
%% Michael Vittrup Larsen (mvl@ericssontelebit.com)
%%
%% Change Log:
%% ===========
%%
%% Version  Date        Author  Change
%% --------------------------------------------------------------------------
%% 0.0      2000-06-01  MVJ     Original .sty file.
%% 0.1      2000-06-12  MHR     Changed original .sty file to a class and 
%%                              remade the header delimiters to be regular 
%%                              tabular delimiters. Uses koma-script article
%%                              class for most of the work. Passes a few
%%                              options to the babel package. There is still
%%                              an annoying underfull hbox hiding somewhere.
%%                              Probably needs lots more work, but is usable. 
%%                              Screw MS Word!
%% 0.2      2000-06-16  MVL     Underfull hbox fixed.
%%          2000-06-16  MHR     Less picky with the versions of required
%%                              packages. Passes a4paper option to
%%                              scrartcl.
%% 0.3      2000-06-17  MHR     A bug fixed that caused the top of the
%%                              Ericsson logo to be cut off when documents
%%                              were converted to PDF. Postscript printing
%%                              was OK, though.
%% 0.4      2001-02-27  MHR     Changed the default fonts to Helvetica and
%%                              Adobe Courier. These generate proper PDF
%%                              files when using ps2pdf. The CM fonts were
%%                              sampled to ugly bitmaps.
%%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ericsson}  [2001/02/27 v0.4
  Ericsson LaTeX document class]
\newcommand*{\ericsson@enc}{ansinew}
\DeclareOption{ascii}{\renewcommand*{\ericsson@enc}{ascii}}
\DeclareOption{applemac}{\renewcommand*{\ericsson@enc}{applemac}}
\DeclareOption{ansinew}{\renewcommand*{\ericsson@enc}{ansinew}}
\DeclareOption{latin1}{\renewcommand*{\ericsson@enc}{latin1}}
\DeclareOption{cp850}{\renewcommand*{\ericsson@enc}{cp850}}
\DeclareOption{english}{\PassOptionsToPackage{english}{babel}%
  \AtEndOfClass{\main@language{english}}}
\DeclareOption{danish}{\PassOptionsToPackage{danish}{babel}%
  \AtEndOfClass{\main@language{danish}}}
\DeclareOption{swedish}{\PassOptionsToPackage{swedish}{babel}%
  \AtEndOfClass{\main@language{swedish}}}
\ExecuteOptions{english}
\ProcessOptions\relax
\RequirePackage[\ericsson@enc]{inputenc}
\RequirePackage[T1]{fontenc}
\RequirePackage{babel}
\RequirePackage{epsfig}
\LoadClass[9pt,a4paper]{scrartcl}
\sloppy
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\parindent 0mm
\parskip 2mm
\setlength\headsep{1.8cm}
\setlength\headheight{2cm}
%%\setlength\topmargin{-0.58in}
\addtolength\textheight{-0.4cm}


%\addtolength{\oddsidemargin}{-1in}% compensate for LaTeX's 1in offset
%\addtolength{\evensidemargin}{-1in}% compensate for LaTeX's 1in offset
\setlength{\textwidth}{\paperwidth}%
% subtract for the 1" top/bottom margins
\addtolength{\textwidth}{-2.0in}%
\setlength{\evensidemargin}{12pt}
\setlength{\oddsidemargin}{12pt}


\newcommand{\infotype}{\def\@einfotype}
\newcommand{\doctype}{\def\@edoctype}
\newcommand{\file}{\def\@efile}
\newcommand{\docresp}{\def\@edocresp}
\newcommand{\docprep}{\def\@edocprep}
\newcommand{\docchk}{\def\@edocchk}
\newcommand{\docno}{\def\@edocno}
\newcommand{\docrev}{\def\@edocrev}
\newcommand{\docdate}{\def\@edate}
\newcommand{\doctitle}[1]{\begin{center}{\LARGE\bf\textsf{#1}}\end{center}}

\AtEndDocument{\label{lastpage}}

% Initialize header fields to empty. The user may override any of these.
\infotype{}
\doctype{}
\file{}
\docresp{}
\docprep{}
\docchk{}
\docno{}
\docrev{}
\docdate{\the\year-\two@digits{\the\month}-\two@digits{\the\day}}

\RequirePackage{calc}
\newlength{\ERICSSON@hdwidth}
\setlength{\ERICSSON@hdwidth}{13cm}
\newlength{\ERICSSON@cw}
\setlength{\ERICSSON@cw}{\ERICSSON@hdwidth/8}
\newlength{\ERICSSON@tcw}
\setlength{\ERICSSON@tcw}{\ERICSSON@hdwidth/12}
\newcounter{ERICSSONhdleftoffset}
\setcounter{ERICSSONhdleftoffset}{3}

% Font for fixed header strings
\DeclareFixedFont{\fhdf}{T1}{phv}{b}{n}{8pt}

% Font for customizable header strings
\DeclareFixedFont{\chdf}{T1}{phv}{m}{n}{11pt}

%\renewcommand{\rmdefault}{ptm}
\renewcommand{\rmdefault}{phv}
\renewcommand{\sfdefault}{phv}
\renewcommand{\ttdefault}{pcr}

\renewcommand{\@oddhead}{%
\setlength{\unitlength}{1mm}%
\begin{picture}(0,0)(\theERICSSONhdleftoffset,0)\scriptsize%
\begin{tabular}{p{2\ERICSSON@cw}p{\ERICSSON@cw}p{\ERICSSON@cw}p{2\ERICSSON@tcw}p{\ERICSSON@tcw}p{\ERICSSON@tcw}p{\ERICSSON@tcw}p{\ERICSSON@tcw}}%
% The next line serves two purposes. It makes the fields be as wide as we
% specified in the tabular declaration. Due to the multicolumns they are
% not fixed width. And it keeps the top of the Ericsson logo within the
% Postscript bounding box for the page. Small hack.
 & & & & & & & \\%
\multicolumn{3}{l}{} & \multicolumn{5}{l}{\chdf\@einfotype}\\%
\multicolumn{3}{l}{\raisebox{4pt}[0cm][0cm]{\includegraphics[width=3.5cm]{elogo.png}}} & \multicolumn{4}{l}{\chdf\makebox[0pt][l]{\MakeUppercase{\@edoctype}}} & \multicolumn{1}{r}{\chdf\thepage (\pageref{lastpage})}\\\hline%
\multicolumn{3}{|l|}{\fhdf Prepared (also subject responsible, if other)} & \multicolumn{1}{l}{\fhdf No.} & \multicolumn{2}{l}{} & \multicolumn{2}{l|}{}\\%
\multicolumn{3}{|l|}{\chdf\@edocprep} & \multicolumn{5}{l|}{\chdf\@edocno}\\\hline%
\multicolumn{2}{|l|}{\fhdf Document responsible/Approved} & \multicolumn{1}{|l|}{\fhdf Checked} & \multicolumn{1}{l|}{\fhdf Date} & \multicolumn{1}{|l|}{\fhdf Rev.} & \multicolumn{3}{l|}{\fhdf File}\\%
\multicolumn{2}{|l}{\chdf\@edocresp} & \multicolumn{1}{|l|}{\chdf\@edocchk} & \multicolumn{1}{|l}{\chdf\@edate} & \multicolumn{1}{|l|}{\chdf\@edocrev} & \multicolumn{3}{l|}{\chdf\@efile}\\\hline%
% The next line makes the fields be as wide as we specified in the tabular
% declaration. Due to the multicolumns they are not fixed width. Small hack.
\end{tabular}%
\end{picture}%
\hfill
}
%\renewcommand{\@evenhead}{\@oddhead}
%\renewcommand{\@oddfoot}{\@empty}
%\renewcommand{\@oddfoot}{\@evenfoot}

\endinput

