#!/usr/bin/env perl
use warnings;
$| = 1;    #don't buffer output
use strict;

#use xmlParser;
#use XML::Parser;
use Data::Dumper;
use POSIX qw(strftime);
use POSIX;
use Time::Local;
use:$SIG{CHLD} = 'IGNORE';
###########################################################
#Author Martin Aldrin
###########################################################

my $USERX;
my $BASE;

BEGIN
{
    use Cwd 'abs_path';
    ($BASE) = (
        abs_path($0) =~ /\//
        ? substr( abs_path($0), 0, rindex( abs_path($0), "/" ) )
        : "."
    );
    $BASE =~ s/bin\/?$//;
    $BASE .= '/';
    #unshift( @INC, "/vobs/iov/wcdma/lib/" ); ## Everything should be available in the tool
    unshift( @INC, "$BASE/" );
    unshift( @INC, "$BASE/lib/" );
    unshift( @INC, "$BASE/lib/modules/" );
    my $OS = `uname -a`;
    if ( $OS =~ /linux/i )
    {
    }
    $USERX = $ENV{USER};
}

## Script usage counter
system("/proj/wcdmaiov/tools/ttools/stat/script_usage_counter $0 @ARGV")
    if -x "/proj/wcdmaiov/tools/ttools/stat/script_usage_counter";

my $conf = {};
$conf->{BASE} = $BASE;
use teSummaryConfiguration;
use lookupTables;
teSummaryConfiguration::init($conf);
my $parseData = parseXml::parse($conf);
use Type;
use Table;
use Attrib;
use parseXml;
use formatFABRIC;
use timeparser;
use printer;
use fileHandler;
use concat;

$SIG{INT} = "ctrlc";

sub ctrlc
{
    printer::printer( $conf, $parseData );
    exit;
}

sub main
{
    my $oldrop;

    #load additional modules.
    foreach my $module ( @{ $conf->{modules} } )
    {
        my $moduleName = $module->{modulename} . '.pm';
        require $moduleName;
        $module->{obj} = new { $module->{modulename} }( $conf, $parseData->{types} );
    }
    foreach my $module ( @{ $conf->{modules2} } )
    {
        my $moduleName = $module->{modulename} . '.pm';
        require $moduleName;
        $module->{obj} = new { $module->{modulename} }($conf);
    }

    #remove not used attribs.
    my $requiredAttribsCheck;

    #foreach my $type ( @{$parseData->{types}} )
    for ( my $j = 0 ; $j < @{ $parseData->{types} } ; $j++ )
    {
        my $type       = @{ $parseData->{types} }[$j];
        my $usedAttrib = {};
        my $tables     = $type->getTables();

        my $attribs = $type->getAttributes();
        my $exp     = $type->getRegexp();

        if ( defined $conf->{type} && $exp !~ /$conf->{type}/i )
        {
            print "removing types that not match user input -table '$conf->{type}', removed: '$exp'\n";
            splice( @{ $parseData->{types} }, $j, 1 );
            $j--;
            next;
        }
        if ( defined $conf->{etype} && $exp =~ /$conf->{etype}/i )
        {
            print "removing types that match user input -etable '$conf->{etype}', removed: '$exp'\n";
            splice( @{ $parseData->{types} }, $j, 1 );
            $j--;
            next;
        }

        #foreach my $table ( @$tables )
        if ( defined $tables )
        {
            for ( my $i = 0 ; $i < @$tables ; $i++ )
            {
                my $table        = @{$tables}[$i];
                my $tableName    = $table->getName();
                my $tableHeaders = $table->getHeaders();
                my $groupBy      = $table->getGroupBy();
                if ( defined $conf->{table} && $tableName !~ /$conf->{table}/i )
                {
                    print "removing tables that not match user input -table '$conf->{table}', removed: '$tableName'\n";
                    splice( @{ $type->{TABLE} }, $i, 1 );
                    $i--;
                    next;
                }
                if ( defined $conf->{etable}
                    && $tableName =~ /$conf->{etable}/i )
                {
                    print "removing tables that match user input -etable '$conf->{table}', removed: '$tableName'\n";
                    splice( @{ $type->{TABLE} }, $i, 1 );
                    $i--;
                    next;
                }

                #remove groupBy imsi, tmsi,imeisv, ueRef by default. need command line activation.
                if (   defined $groupBy
                    && $groupBy =~ /imeisv/i
                    && !defined $conf->{perimeisv} )
                {
                    print "turned off table: '$tableName', activate by option -perimeisv\n";
                    splice( @{ $type->{TABLE} }, $i, 1 );
                    $i--;
                    next;
                }
                if (   defined $groupBy
                    && $groupBy =~ /imsi/i
                    && !defined $conf->{perimsi} )
                {
                    print "turned off table: '$tableName', activate by option -perimsi\n";
                    splice( @{ $type->{TABLE} }, $i, 1 );
                    $i--;
                    next;
                }
                if (   defined $groupBy
                    && $groupBy =~ /tmsi/i
                    && !defined $conf->{pertmsi} )
                {
                    print "turned off table: '$tableName', activate by option -pertmsi\n";
                    splice( @{ $type->{TABLE} }, $i, 1 );
                    $i--;
                    next;
                }
                if (   defined $groupBy
                    && $groupBy =~ /ueref/i
                    && !defined $conf->{perueref} )
                {
                    print "turned off table: '$tableName', activate by option -perueref\n";
                    splice( @{ $type->{TABLE} }, $i, 1 );
                    $i--;
                    next;
                }
                if ( defined $table->{if} )
                {
                    $usedAttrib->{ $table->{if} } = 1;
                }
                foreach my $header (@$tableHeaders)
                {
                    $usedAttrib->{$header} = 1;
                }
                if ( defined $groupBy )
                {
                    $usedAttrib->{$groupBy} = 1;
                }
                if ( defined $groupBy && $groupBy =~ /:/ )
                {
                    my @groupBys = split( /:/, $groupBy );
                    foreach my $gb (@groupBys)
                    {
                        $usedAttrib->{$gb} = 1;
                    }
                }
                my @a = Dumper(\$table->{renamefrom}) =~ /\'\s*\$(\S+?)\s*'/g;
                foreach my $attrib (@a)
                {
                    $usedAttrib->{$attrib} = 1;
                }

            }
        }
        if ( defined $type->{required} )
        {
            foreach my $requiredAttribs ( sort keys %{ $type->{required} } )
            {
                if ( !defined $usedAttrib->{$requiredAttribs} )
                {
                    $requiredAttribsCheck->{$requiredAttribs} = 1;
                }
            }
        }
        foreach my $attrib (@$attribs){
            my $name = $attrib->getName();
            my $namedGroups = $attrib->getNamedGroups();
            my @names;
            push @names, $name if $name;
            push @names, @$namedGroups if $namedGroups;
            foreach my $namedGroup (@names){
                if ( !defined $usedAttrib->{$namedGroup} && !defined $requiredAttribsCheck->{$namedGroup} ){
                    $attrib = undef;
                }
                elsif ( defined $requiredAttribsCheck->{$namedGroup} ){
                    delete $requiredAttribsCheck->{$namedGroup};
                }
            }
        }


        if (%$requiredAttribsCheck)
        {
            my $exp = $type->getRegexp();
            foreach my $missedAttrib ( sort keys %$requiredAttribsCheck )
            {
                print "required attributues not found: $missedAttrib, in match type $exp\n";
            }
        }
    }

    #start main loop
    if ( !defined $conf->{onlydiff} )
    {
        my $concat = new concat( DISABLE => $conf->{noconcat} );
        my @files = fileHandler::checkFiles($conf);

        if (@files)
        {
            foreach my $file (@files)
            {
                next if ($file =~ /^[.]+$/ );
                next if ($file =~ /^[.]+bin$/ );
                $$conf{file} = $file;
                fileHandler::openFile($file);
                loop( $conf, $concat, $parseData, $oldrop );
            }
        }
        else
        {
            loop( $conf, $concat, $parseData, $oldrop );
        }
    }
}

sub loop
{
    my $conf       = shift;
    my $concat     = shift;
    my $parseData  = shift;
    my $oldRopTime = shift;
    while ( my $line = <STDIN> )
    {
        fileHandler::fileStatusCounter( $conf, \$line );
        $concat->concat_line( \$line );
        while ( my $lineref = $concat->readBuffer() )
        {
            if ( defined $$lineref )
            {
                print $$lineref . "\n" if $$lineref =~ /<---TERMINATED--->/;

                next if $$lineref !~/^(\[|\d{4}:\s+\[)/;
                foreach my $type ( @{ $parseData->{types} } )
                {
                    my $filterCheck;
                    my $exp       = $type->getRegexp();
                    my $timeStamp = $type->getTimeStamp();
                    if ( $$lineref =~ /$exp/ )
                    {
                        my $obj     = {};
                        my $attribs = $type->getAttributes();
                        foreach my $attrib (@$attribs)
                        {
                            if ( defined $attrib )
                            {
                                $attrib->getCleanString( $obj, $lineref );
                            }
                        }
                        $type->getKeys( $obj, $attribs );
                        if (%$obj)
                        {
                            $obj->{traceType} = $exp;
                            $type->addAttributesValues($obj);
                            my ( $realTime, $newRopTime ) = $timeStamp->parseTime($lineref);
                            if ( defined $conf->{printrop} && defined $oldRopTime && $oldRopTime ne $newRopTime )
                            {
                                if ( !defined $conf->{printedRop}->{$newRopTime} )
                                {
                                    $conf->{printedRop}->{$newRopTime} = 1;
                                    my $childPID;
                                    if ( $childPID = fork() == 0 )
                                    {
                                        printer::printer( $conf, $parseData, "printRop" );
                                        exit;
                                    }
                                }
                            }
                            $obj->{realTime}   = $realTime;
                            $obj->{newRopTime} = $newRopTime;
                            $obj->{line}       = $lineref;
                            foreach my $module ( @{ $conf->{modules} } )
                            {

                                if ( $module->{obj}->parser( $type, $conf ) )
                                {
                                    $filterCheck = 1;
                                    last;
                                }
                            }
                            if ( defined $filterCheck )
                            {
                                $filterCheck = undef;
                                next;
                            }
                            if ( !defined $conf->{startTime} )
                            {
                                $conf->{startTime} = $obj->{realTime};
                            }
                            $conf->{endTime} = $obj->{realTime};

                            my $tables = $type->getTables();
                            foreach my $table (@$tables)
                            {
                                if ( defined $table->{if}
                                    && !defined $obj->{ $table->{if} } )
                                {
                                    next;
                                }
                                my $tableName    = $table->getName();
                                my $tableHeaders = $table->getHeaders();
                                my $groupBy      = $table->getGroupBy();
                                if ( defined $groupBy && $groupBy =~ /:/ )
                                {
                                    my $NewgroupBy = $groupBy;
                                    my @groupBys = split( /:/, $groupBy );
                                    foreach my $gb (@groupBys)
                                    {
                                        if ( defined $$obj{$gb} )
                                        {
                                            $NewgroupBy =~ s/$gb/$$obj{$gb}/;
                                        }
                                    }
                                    $$obj{$groupBy} = $NewgroupBy;
                                }
                                my $uniqueString;
                                foreach my $header (@$tableHeaders)
                                {
                                    if ( defined $$obj{$header} )
                                    {
                                        $uniqueString .= $$obj{$header} . ';';
                                    }
                                    else
                                    {
                                        $uniqueString .= '-' . ';';
                                    }
                                }
                                if ( defined $uniqueString
                                    && $uniqueString !~ /^[-;]+$/ )
                                {
                                    chop $uniqueString;
                                    if (   defined $groupBy
                                        && defined $$obj{$groupBy} )
                                    {
                                        $table->addKey( \$uniqueString, \$newRopTime, $lineref, \$$obj{$groupBy} );
                                    }
                                    else
                                    {
                                        $table->addKey( \$uniqueString, \$newRopTime, $lineref );
                                    }
                                }
                            }
                            $type->appendStoreData($obj);
                            $type->removeAttributesValues();

                            $oldRopTime = $newRopTime;
                            next;
                        }
                    }
                }

                #foreach my $module ( @{ $conf->{modules} } ) {
                #    $module->{obj}->parser( $conf, $lineref );
                #}
            }
        }
    }
}

main($conf);
printer::printer( $conf, $parseData );

