package formatFLOT;

use strict;
use locale;
use Data::Dumper;

use POSIX qw(strftime);
use POSIX;
use Time::Local;

sub formatFLOT::new() {
  my $class = shift;
  my %self = @_;
  $self{format} = "FLOT";
  $self{ROP} = ();
  return bless \%self;
}

sub formatFLOT::begin(){
    my $self = shift;
    my $path = shift;
    my $fileName = shift;
    $fileName =~ s/\s+/_/g;
    $fileName =~ s/\.//g;
    $fileName =~ s/\,//g;
    $fileName =~ s/\(//g;
    $fileName =~ s/\)//g;

    $self->{TABLEAME} = $fileName . '_flot';
    my $file = $path . $self->{TABLEAME} . '.js';
    my $fh;
    open $fh, ">$file" or print "couldn't open FileHandle for file: $file\n";
    $self->{OPENEDHANDLE} = $fh;
    my $string = 'var ' . $self->{TABLEAME} . ' = [';
    $self->printer( $string );
}

sub formatFLOT::header(){
    my $self = shift;
    my $string = shift;
    my $header = shift;
    if ( defined $self->{error} )
    {
        return;
    }
    foreach my $rop ( @$header )
    {
        if ( $rop =~ /(\d{4})\-(\d{2})\-(\d{2}) (\d{2}):(\d{2})/ )
        {
            push( @{$self->{ROP}}, ((timegm( 0, $5, $4, $3, $2 -1, $1 -1900, 0, 0, 0))*1000)+0 );
        }
    }

}

sub formatFLOT::content(){
    my $self = shift;
    my ( $numberOf, $string, $rop ) = @_;
    if ( defined $self->{error} )
    {
        return;
    }
    $string =~ s/\s+/ /g;
    $string =~ s/\}|\{//g;
    $string =~ s/\]|\[//g;
    $string =~ s/\'//g;
    $rop =~ s/\s+//g;
    $self->printer( "{" );
    $self->printer( "\tlabel: '$string'," );
    my @rops = split( /;/, $rop );
    my $dataString;
    for ( my $i = 0; $i <@{$self->{ROP}}; $i++ )
    {
        $dataString .= '[' . @{$self->{ROP}}[$i] . ',' . (defined $rops[$i]?$rops[$i]:0) . '],';
    }
    $dataString =~ s/,$//;
    $self->printer( "\tdata: [$dataString]" );
    $self->printer( "}," );


}

sub formatFLOT::end(){
    my $self = shift;
    my $fh = $self->{OPENEDHANDLE};
    $self->printer( "]" );
    close $fh;
}

sub formatFLOT::printer(){
    my $self = shift;
    my $string = shift;
    if ( defined $self->{error} )
    {
        return;
    }
    my $fg = $self->{OPENEDHANDLE};
    print $fg "$string\n";
}
1;
