package flot;
use strict;
use Data::Dumper;

sub generate_flot
{
    my $confighash = shift;
    return if ( !defined $confighash->{flotpath} );
    my $tmp;
    foreach my $flotname ( sort keys %{ $confighash->{flothash} } )
    {
        my $tmp_flotname = $flotname;
        $tmp_flotname =~ s/\.//g;
        $tmp_flotname =~ s/,//g;
        my $tablefile = $confighash->{flotpath} . $tmp_flotname . '.js';
        my $tableData = "var " . $tmp_flotname . ' = [' . "\n" . '{' . "\n";
        open TABLEFILE, "> $tablefile";
        foreach
            my $lable ( sort keys %{ $confighash->{flothash}->{$flotname} } )
        {
            my $tmplable = $lable;
            $tmplable =~ s/\s+/ /g;
            $tmplable =~ s/\// /g;
            $tmplable =~ s/'//g;

            #$tmplable =~ s/\%//g;
            my @tmplables = split( /_/, $tmplable );
            $tableData .= "\tlabel: '" . $tmplable . "',\n" . "\tdata: " . '[';
            my $y2;
            foreach my $tl (@tmplables)
            {
                $y2 = 1 if defined $confighash->{y2data}->{$tl};
            }
            foreach my $data (
                          @{ $confighash->{flothash}->{$flotname}->{$lable} } )
            {
                $tableData .= '[' . $data . '],';
            }
            $tableData =~ s/,$//;
            $tableData .= ']'
                . ( defined $y2 ? ',' : '' ) . "\n"
                . ( defined $y2 ? 'yaxis:2' . "\n" : '' ) . '},' . "\n" . '{'
                . "\n";
        }
        $tableData =~ s/\n{$//;
        $tableData =~ s/,$//;
        $tableData =~ s/\n,$//;
        $tableData =~ s/,$//;
        $tableData .= ']' . "\n";
        $tmp .= $tableData;
        print TABLEFILE $tableData;
        close TABLEFILE;
    }
}

sub lost_traces
{
    my $confighash = shift;

    $confighash->{tabelList}->{lost_traces} = 0;

    #return if !defined $confighash->{lost_traces};
    $confighash->{tabelList}->{lost_traces} = 1;

    my $tablefile = $confighash->{flotpath} . 'lost_traces' . '.js';
    open LOSTTRACES, "> $tablefile";

    my $tableData = 'var lost_traces' . ' = [';
    if ( defined $confighash->{CurrentRop} )
    {
        foreach my $ropKey ( sort keys %{ $confighash->{rop} } )

            #for(my $i=1; $i <= $confighash->{CurrentRop}; $i++)
        {
            if ( defined $confighash->{lost_traces}->{$ropKey} )
            {
                $tableData .= $confighash->{ropmill}->{$ropKey} . ',';
            }
        }
    }
    $tableData =~ s/,$//;
    $tableData .= ']' . "\n";
    print LOSTTRACES $tableData;

    close LOSTTRACES;
}

1;
