package parseTraceAttributes;
use strict;

sub get_attr
{
    my $confighash = shift;
    my $reg_exp    = shift;
    my $reg_exp2   = shift;
    my ($param);

    if (    defined $reg_exp2
         && $confighash->{lineref} =~ /$reg_exp/i
         && $confighash->{lineref} =~ /$reg_exp2/i )
    {
        $param = $1;
    }
    elsif ( $confighash->{lineref} =~ /$reg_exp/i )
    {
        $param = $1;
    }
    else
    {
        $reg_exp  = undef;
        $reg_exp2 = undef;
    }
    return ( \$param, \$reg_exp, \$reg_exp2 );
}

sub ExceptionCode
{
    my $confighash = shift;
    my ( $ExceptionCode, $reg_exp );
    ( $ExceptionCode, $reg_exp ) =
        get_attr( $confighash, q"Exception\s*Code\s*=?:?\s*(\S+?);" );
    $$ExceptionCode = "-" if !defined $$ExceptionCode;
    return ( $ExceptionCode, $reg_exp );
}

sub ExceptionFile
{
    my $confighash = shift;
    my ( $ExceptionFile, $reg_exp );
    ( $ExceptionFile, $reg_exp ) =
        get_attr( $confighash, q"ExceptionFile\s*=?:?\s*(\S+?);" );
    $$ExceptionFile = "" if !defined $$ExceptionFile;
    return ( $ExceptionFile, $reg_exp );
}

sub UEH_ExceptionFile
{
    my $confighash = shift;
    my ( $ExceptionFile, $reg_exp );
    ( $ExceptionFile, $reg_exp ) =
        get_attr( $confighash, q"\(UEH_EXCEPTION\)\s*(\S+?)\s+" );
    $$ExceptionFile = "-" if !defined $$ExceptionFile;
    return ( $ExceptionFile, $reg_exp );
}

sub ExceptionLine
{
    my $confighash = shift;
    my ( $ExceptionLine, $reg_exp );
    ( $ExceptionLine, $reg_exp ) =
        get_attr( $confighash, q"ExceptionLine\s*=?:?\s*(\S+?);" );
    $$ExceptionLine = "" if !defined $$ExceptionLine;
    return ( $ExceptionLine, $reg_exp );
}

sub ExceptionAdditionalText
{
    my $confighash = shift;
    my ( $ExceptionAdditionalText, $reg_exp );
    ( $ExceptionAdditionalText, $reg_exp ) =
        get_attr( $confighash, q"ExceptionAdditionalText\s*=?:?\s*(.+?);" );
    $$ExceptionAdditionalText = "" if !defined $$ExceptionAdditionalText;
    return ( $ExceptionAdditionalText, $reg_exp );
}

sub UEH_message
{
    my $confighash = shift;
    my ( $message, $reg_exp );
    ( $message, $reg_exp ) =
        get_attr( $confighash, q"ExceptionCode\s*=\s*\S+?;\s*(.+?)\s*;" );
    $$message = "-" if !defined $$message;
    return ( $message, $reg_exp );
}

sub RNC_message
{
    my $confighash = shift;
    my ( $message, $reg_exp );
    ( $message, $reg_exp ) =
        get_attr( $confighash, q"ExceptionString\s*=?:?\s*(.*?);" );
    $$message = "-" if !defined $$message;
    return ( $message, $reg_exp );
}

sub processor
{
    my $confighash = shift;
    my ( $processor, $reg_exp );
    ( $processor, $reg_exp ) =
        get_attr( $confighash, q"ProcessorName:\s*(.+?);" );
    $$processor = "-" if !defined $$processor;
    return ( $processor, $reg_exp );
}

sub UeRef
{
    my $confighash = shift;
    my ( $UeRef, $reg_exp );
    ( $UeRef, $reg_exp ) =
        get_attr( $confighash, q"UeRef\s*=?:?\s*(\S+?)[,;]" );    #UeContext
    ( $UeRef, $reg_exp ) =
        get_attr( $confighash, q"UeContext\s*=?:?\s*(\S+?)[,;]" )
        if !defined $$UeRef;
    ( $UeRef, $reg_exp ) =
        get_attr( $confighash, q"^\s*\[.+?\]\s*\d{4}\/(\d+)" )
        if !defined $$UeRef;
    ( $UeRef, $reg_exp ) =
        get_attr( $confighash, q"^\s*\[.+?\]\s*\w+:\d{4}\/(\d+)" )
        if !defined $$UeRef;
    $$UeRef = "-" if !defined $$UeRef;
    return ( $UeRef, $reg_exp );
}

sub currentUeRcId
{
    my $confighash = shift;
    my ( $currentRcId, $reg_exp );
    ( $currentRcId, $reg_exp ) =
        get_attr( $confighash, q"current\s*UeRcId\s*:?=?\s*(\d+)" );
    return ( $currentRcId, $reg_exp );
}

sub currentRcId
{
    my $confighash = shift;
    my ( $currentRcId, $reg_exp );
    ( $currentRcId, $reg_exp ) =
        get_attr( $confighash, q"current\s*RcId\s*:?=?\s*(\d+)" );
    return ( $currentRcId, $reg_exp );
}

sub targetUeRcId
{
    my $confighash = shift;
    my ( $targetRcId, $reg_exp );
    ( $targetRcId, $reg_exp ) =
        get_attr( $confighash, q"target\s*UeRcId:?=?\s*(\d+)" );
    return ( $targetRcId, $reg_exp );
}

sub procedureno
{
    my $confighash = shift;
    my ( $procedureno, $reg_exp );
    ( $procedureno, $reg_exp ) = get_attr( $confighash, q"PROC\s*(\d+)\s*:" );
    return ( $procedureno, $reg_exp );
}

sub procedurename
{
    my $confighash = shift;
    my ( $procedurename, $reg_exp );
    ( $procedurename, $reg_exp ) =
        get_attr( $confighash, q"PROC\s*\d+\s*:\s*(.+?)," );
    return ( $procedurename, $reg_exp );
}

sub imsi
{
    my $confighash = shift;
    my ( $imsi,, $reg_exp );
    ( $imsi, $reg_exp ) = get_attr( $confighash, q"IMSI\s*=?:?\s*(\S+?);" );
    $$imsi = "-" if !defined $$imsi;
    return ( $imsi, $reg_exp );
}

sub tmsi
{
    my $confighash = shift;
    my ( $tmsi, $reg_exp );
    ( $tmsi, $reg_exp ) = get_attr( $confighash, q"TMSI\s*=?:?\s*(\S+?);" );
    $$tmsi = "-" if !defined $$tmsi;
    return ( $tmsi, $reg_exp );

}

sub cellId
{
    my $confighash = shift;
    my ( $cellId, $reg_exp );
    ( $cellId, $reg_exp ) =
        get_attr( $confighash, q"cellId\s*=?:?\s*(\S+?);" );
    $$cellId = "-" if !defined $$cellId;
    return ( $cellId,, $reg_exp );
}

sub RNC_cellId
{
    my $confighash = shift;
    my ( $cellId, $reg_exp );
    ( $cellId, $reg_exp ) = get_attr( $confighash, q"CId1\s*=?:?\s*(\S+?);" );
    $$cellId = "-" if !defined $$cellId;
    return ( $cellId, $reg_exp );
}

sub causeCode
{
    my $confighash = shift;
    my ( $causecode, $reg_exp );
    ( $causecode, $reg_exp ) =
        get_attr( $confighash, q"causeCode\s*=?:?\s*(\S+?);" );
    ( $causecode, $reg_exp ) =
        get_attr( $confighash, q"causeCode\s*=?:?\s*(\S+)" )
        if !defined $$causecode;
    ( $causecode, $reg_exp ) =
        get_attr( $confighash, q"cause\s*=?:?\s*(\S+?);?" )
        if !defined $$causecode;
    $$causecode = "-" if !defined $$causecode;
    $$causecode = "-"
        if ( defined $$causecode && $$causecode !~ /^(\d+|UNDEF)$/ );
    return ( $causecode, $reg_exp );
}

sub NbapCauses
{
    my $confighash = shift;
    my ( $causevalue, $causeType, $reg_exp );
    ( $causeType, $reg_exp ) = get_attr( $confighash,
                          q"NBAP RADIO LINK.+?causeType\s*=?:?\s*(\S+?),\s+" );
    ( $causevalue, $reg_exp ) = get_attr( $confighash,
                             q"NBAP RADIO LINK.+?causevalue\s*=?:?\s*(\S+?)" );
    $$causevalue = $$causeType . ':' . $$causevalue
        if ( defined $$causevalue && defined $$causeType );
    return ( $causevalue, $reg_exp );
}

sub causeValue
{
    my $confighash = shift;
    my ( $causeValue, $reg_exp );
    ( $causeValue, $reg_exp ) =
        get_attr( $confighash, q"causeValue\s*(\d+),?;" );
    $$causeValue = '-' if !defined $$causeValue;
    return ( $causeValue, $reg_exp );
}

sub causeType
{
    my $confighash = shift;
    my ( $causeType, $reg_exp );
    ( $causeType, $reg_exp ) =
        get_attr( $confighash, q"causeType\s*(\d+),?;" );
    $$causeType = '-' if !defined $$causeType;
    return ( $causeType, $reg_exp );
}

sub errorCode
{
    my $confighash = shift;
    my ( $errorCode, $reg_exp );
    ( $errorCode, $reg_exp ) =
        get_attr( $confighash, q"ErrorCode\s*=?:?\s*(\S+?);" );
    $$errorCode = '-' if !defined $$errorCode;
    return ( $errorCode, $reg_exp );
}

sub conntype
{
    my $confighash = shift;
    my ( $conntype, $reg_exp );
    ( $conntype, $reg_exp ) =
        get_attr( $confighash, q"[^tg]\s*connType\s*=?:?\s*(\S+?);" );
    ( $conntype, $reg_exp ) =
        get_attr( $confighash, q"[^tg]\s*connType\s*=?:?\s*(\S+?)," )
        if !defined $$conntype;
    ( $conntype, $reg_exp ) =
        get_attr( $confighash, q"[^tg]\s*connType\s*=?:?\s*(\S+?)\s+" )
        if !defined $$conntype;
    ( $conntype, $reg_exp ) =
        get_attr( $confighash, q"Source\s*conn\s*type(.+?)," )
        if !defined $$conntype;
    ( $conntype, $reg_exp ) =
        get_attr( $confighash, q"srcConnType\s*=?:?\s*(\S+?);" )
        if !defined $$conntype;
    ( $conntype, $reg_exp ) =
        get_attr( $confighash, q"Current connType\s+(\S+?)" )
        if !defined $$conntype;
    $$conntype = "-" if !defined $$conntype;
    return ( $conntype, $reg_exp );
}

sub targetconntype
{
    my $confighash = shift;
    my ( $targetconntype, $reg_exp );
    ( $targetconntype, $reg_exp ) =
        get_attr( $confighash, q"target\s*ConnType\s*=?:?\s*(\w+?);" );
    ( $targetconntype, $reg_exp ) =
        get_attr( $confighash, q"target\s*ConnType\s*=?:?\s*(\w+)" )
        if !defined $$targetconntype;
    ( $targetconntype, $reg_exp ) =
        get_attr( $confighash, q"req\s*ConnType\s*=?:?\s*(\w+)" )
        if !defined $$targetconntype;
    ( $targetconntype, $reg_exp ) =
        get_attr( $confighash, q"Target\s*conn\s*type(.+?)," )
        if !defined $$targetconntype;
    $$targetconntype = "-" if !defined $$targetconntype;
    return ( $targetconntype, $reg_exp );
}

sub callProc
{
    my $confighash = shift;
    my ( $callProc, $reg_exp );
    ( $callProc, $reg_exp ) =
        get_attr( $confighash, q"callProc\s*=?:?\s*(\S+?);" );
    $$callProc = "-" if !defined $$callProc;
    return ( $callProc, $reg_exp );
}

sub DRNC
{
    my $confighash = shift;
    my ( $drnc, $reg_exp ) =
        get_attr( $confighash, q"Best RL in DRNC: Yes, DRNC Id: (\d+);" );
    $$drnc = '-' if !defined $$drnc;
    return ( $drnc, $reg_exp );
}

sub gcp
{
    my $confighash = shift;
    my ( $gcp, $reg_exp ) =
        get_attr( $confighash, q"sGCP\s*=?:?\s*(\d+)\S*?;?" );
    ( $gcp, $reg_exp ) =
        get_attr( $confighash,
                  q"\s+connType\s*=?:?\s*\S+\s+GCP\s*=?:?\s*(\d+)\s*;" )
        if !defined $$gcp;
    my $genuine = $$gcp;
    if ( defined $$gcp )
    {
        $$gcp = eval( "0b" . $$gcp );
        if ( defined $$gcp )
        {
            $$gcp = eval($$gcp);
        }
        else
        {
            $$gcp = '-';
        }
    }
    $genuine = '-' if !defined $genuine;
    $$gcp    = '-' if !defined $$gcp;
    return ( $gcp, \$genuine, $reg_exp );
}

sub rabest
{
    my $confighash = shift;
    my ( $rabest, $reg_exp );
    ( $rabest, $reg_exp ) = get_attr( $confighash, q"(\S*rabest\S*)" );
    return ( $rabest, $reg_exp );
}

sub tgcp
{
    my $confighash = shift;
    my ( $gcp, $reg_exp ) = get_attr( $confighash, q"tGCP=(\d+)\S*;" );
    ( $gcp, $reg_exp ) =
        get_attr( $confighash,
                  q"\s+targetConnType\s*=?:?\s*\S+\s+GCP\s*=?:?\s*(\d+)\s*;" )
        if !defined $$gcp;
    my $genuine = $$gcp;
    if ( defined $$gcp )
    {
        $$gcp = eval( "0b" . $$gcp );
        $$gcp = eval($$gcp);
    }
    $genuine = '-' if !defined $genuine;
    return ( $gcp, \$genuine, $reg_exp );
}

sub rbId
{
    my $confighash = shift;
    my ( $rbId, $reg_exp ) = get_attr( $confighash, q"rbId\s*=?:?\s*(\d+)" );
    $$rbId = "-" if !defined $$rbId;
    return ( $rbId, $reg_exp );
}

sub subType
{
    my $confighash = shift;
    my ( $sub,, $reg_exp ) =
        get_attr( $confighash, q" (UEH|UE|CELL|RNH|DCSP|N\/A);" );
    $$sub = "-" if !defined $$sub;
    return ( $sub, $reg_exp );
}

sub spProcessingFailure
{
    my $confighash = shift;
    my ( $spProcessingFailure, $reg_exp );
    ( $spProcessingFailure, $reg_exp ) =
        get_attr( $confighash, q"spProcessingFailure",
                  q';\s*([a-zA-Z, ]+)\s+rbId\s*=?:?\s*\d*\s*;?' );
    ( $spProcessingFailure, $reg_exp ) =
        get_attr( $confighash, q"spProcessingFailure", q';.+\s+\(\s*(.+)\)$' )
        if !defined $$spProcessingFailure;
    ( $spProcessingFailure, $reg_exp ) =
        get_attr( $confighash, q"spProcessingFailure",
                  q';\s+(\w*\s*\w*\s*\w*\s*processing failure.+)[^;]$' )
        if !defined $$spProcessingFailure;
    return ( $spProcessingFailure, $reg_exp );
}

sub RRCCon
{
    my $confighash = shift;
    my ( $RRCCon, $type, $reg_exp );
    if ( $confighash->{lineref} =~
        /(RRCConRel|RRCConnRel|RRCConNotRel|RRCConnNotRel)\s*;\s*(.+?)?\s*[;,]/
       )
    {
        $reg_exp = q'(RRCConRel|RRCConnRel|RRCConNotRel)\s*;\s*(.+?)?\s*[;,]';
        $type    = lc $2;
        $RRCCon =
            $1 . "; "
            . (   $confighash->{rrcCon_map}->{$type}
                ? $confighash->{rrcCon_map}->{$type}
                : $type );
        $RRCCon =~ s/\s+/ /g;
    }
    $RRCCon = "-" if !defined $RRCCon || $RRCCon =~ /callProc/i;
    return ( \$RRCCon, \$reg_exp );
}

sub Timer_Switch
{
    my $confighash = shift;
    my ( $timer, $reg_exp );
    if ( $confighash->{lineref} =~ /(TIMER T_CH_SWITCH_(\d+))/ )
    {
        $timer = '(DCH<->FACH)' if $2 == 1;
        $timer = '(DCH->DCH)'   if $2 == 3;
        $timer = '(FACH->URA)'  if $2 == 6;
        $reg_exp = $1;
    }
    return ( \$timer, $reg_exp );
}

sub roam_counter
{
    my $confighash = shift;
    my ( $counter,, $reg_exp ) = get_attr( $confighash, q"(ROAM_\S+_\S+?);" );
    return ( $counter, $reg_exp );
}

sub ReleaseType
{
    my $confighash = shift;
    my ( $commandVsrequest, $ReleaseType, $cause, $reg_exp );
    ( $commandVsrequest, $reg_exp ) =
        get_attr( $confighash, q"IuRelease(Command|Request)" );
    ( $ReleaseType, $reg_exp ) =
        get_attr( $confighash, q"IuRelease.+?(packet|circuit)" );
    ( $cause, $reg_exp ) =
        get_attr( $confighash, q"IuRelease.+?cause\s*(\d+);" );
    $$cause = '-' if !defined $$cause;
    return ( $commandVsrequest, $ReleaseType, $cause, $reg_exp );
}

sub module
{
    my $confighash = shift;
    my ( $module, $reg_exp ) = get_attr( $confighash, q"^\s*\[.+?\](\d{4})" );
    ( $module, $reg_exp ) = get_attr( $confighash, q"^(\d{4}):\s+\[.+?\]" )
        if !defined $$module;
    ( $module, $reg_exp ) =
        get_attr( $confighash, q"^\s*\[.+?\]\s+\S+?:(\d{6})" )
        if !defined $$module;
    ( $module, $reg_exp ) = get_attr( $confighash, q"^\s*\[.+?\]\s+(\d{6})" )
        if !defined $$module;
    ( $module, $reg_exp ) = get_attr( $confighash, q"^\s*\[.+?\]\s*(\d{4})\/" )
        if !defined $$module;
    ( $module, $reg_exp ) =
        get_attr( $confighash, q"^\s*\[.+?\]\s*\w+:(\d{4})\/" )
        if !defined $$module;
    return ( $module, $reg_exp );
}

sub get_time
{
    my $confighash = shift;
    my ( $time, $reg_exp ) = get_attr( $confighash, q"^\s*(\[.+?\])" );
    return ( $time, $reg_exp );
}

sub get_actor
{
    my $confighash = shift;
    my ( $time, $reg_exp ) =
        get_attr( $confighash, q"^\s*\[.+?\]\s*\d{6}?\/?(\S+?)\(" );
    return ( $time, $reg_exp );
}

sub get_src
{
    my $confighash = shift;
    my ( $src, $reg_exp ) = get_attr( $confighash, q"(\.\.\/src\/\S+)" );
    return ( $src, $reg_exp );
}

sub get_trace
{
    my $confighash = shift;
    my ( $src, $reg_exp ) = get_attr( $confighash, q"(TRACE\d+)" );
    return ( $src, $reg_exp );
}

sub message_type
{
    my $confighash = shift;
    my ( $mtype, $reg_exp ) =
        get_attr( $confighash, q"(ResourceReject|FailureIndication)" );
    $$mtype = '-' if !defined $$mtype;
    return ( $mtype, $reg_exp );
}

sub cellFroId
{
    my $confighash = shift;
    my ( $cellFroId, $reg_exp );
    ( $cellFroId, $reg_exp ) =
        get_attr( $confighash, q"cellFroId\s*=?:?\s*(\S+?);" );
    $$cellFroId = "-" if !defined $$cellFroId;
    return ( $cellFroId, $reg_exp );
}

sub SRNTI
{
    my $confighash = shift;
    my ( $SRNTI, $reg_exp );
    ( $SRNTI, $reg_exp ) = get_attr( $confighash, q"S-RNTI\s*=?:?\s*(\S+?);" );
    $$SRNTI = "-" if !defined $$SRNTI;
    return ( $SRNTI, $reg_exp );
}

sub rncId
{
    my $confighash = shift;
    my ( $rncId, $reg_exp );
    ( $rncId, $reg_exp ) = get_attr( $confighash, q"rncId\s*=?:?\s*(\S+?);" );
    $$rncId = "-" if !defined $$rncId;
    return ( $rncId, $reg_exp );
}

sub rabStatus
{
    my $confighash = shift;
    my ( $rabStatus, $reg_exp );
    ( $rabStatus, $reg_exp ) =
        get_attr( $confighash, q"rabStatus\s*=?:?\s*(\S+?);" );
    $$rabStatus = "-" if !defined $$rabStatus;
    return ( $rabStatus, $reg_exp );
}

sub RLsinDRNC
{
    my $confighash = shift;
    my ( $RLsinDRNC, $reg_exp );
    ( $RLsinDRNC, $reg_exp ) =
        get_attr( $confighash, q"RLs in DRNC\s*=?:?\s*(\S+?);" );
    $$RLsinDRNC = "-" if !defined $$RLsinDRNC;
    return ( $RLsinDRNC, $reg_exp );
}

sub c1c2c3c4
{
    my $confighash = shift;
    my $c1c2c3c4;
    my ( $c1, $c2, $c3, $c4, $reg_exp );
    ( $c1c2c3c4, $reg_exp ) =
        get_attr( $confighash, q"(c1.+?c2.+?c3.+?c4.+?;)" );
    ( $c1c2c3c4, $reg_exp ) = get_attr( $confighash, q"(c1.+?c2.+?c3.+?;)" )
        if ( !defined $$c1c2c3c4 );
    ( $c1c2c3c4, $reg_exp ) = get_attr( $confighash, q"(c1.+?c2.+?;)" )
        if ( !defined $$c1c2c3c4 );
    ( $c1c2c3c4, $reg_exp ) = get_attr( $confighash, q"(c1.+?;)" )
        if ( !defined $$c1c2c3c4 );
    if ( defined $$c1c2c3c4 )
    {
        #c1 = 10311; c2 = 10315; c3 = UNDEF; c4 = UNDEF;
        $$c1c2c3c4 =~ s/(c\d\s*=)//g;
        $$c1c2c3c4 =~ s/(\s+)//g;

        my @c = split( ';', $$c1c2c3c4 );
        ( $c1, $c2, $c3, $c4 ) = ( $c[0], $c[1], $c[2], $c[3] );
        $c1 = "-" if !defined $c1;
        $c2 = "-" if !defined $c2;
        $c3 = "-" if !defined $c3;
        $c4 = "-" if !defined $c4;
    }
    else
    {
        ( $c1, $c2, $c3, $c4 ) = ( '-', '-', '-', '-' );
    }

    return ( \$c1, \$c2, \$c3, \$c4, $reg_exp );
}

1;

__END__
[2010-08-17 15:55:17.120] 011700/RncLmUePT(UEH_EXCEPTION) ../src/UehRabEstComDedC.cpp:15342 TRACE1:ExceptionCode = 54; Received signal spProcessingFailure on DcsIfEventP; FailureIndication; DcSP; RRCConNotRel; No affect to connection; UehRabEstComDed; UeRef = 757; IMSI = 235911000801032; cellId = 10421; cellFroId = 629; S-RNTI = 148213; globalCnIdCs: cnId = 161, mcc = 235, mnc= 91;; Current connType uehPacketCch; sGCP=0000000000000; Target connType uehSp0; tGCP=0000001000000; causecode = 1; rabTypeToBeSetup = uehRabSpeech;  (while waiting for RRC RB SetupComplete in state srnc with rbid = 2)

