package trace;

use strict;
use Data::Dumper;

my $trace_never;
my $trace_trace;
my $trace_verbose;

sub debug
{
    my ( $text, $line ) = @_;
    show( "DEBUG: $$ " . timestamp( time, $line ) . " $text\n" )
        if $trace_trace;
}

sub drop
{
    undef $trace_trace;
}

sub enter
{
    my ( $func, $line ) = @_;
    debug( "Entering $func", $line );
}

sub leave
{
    my ( $func, $rv, $line ) = @_;
    $rv = "undef" unless defined $rv;
    if ( ref $rv eq "HASH" or ref $rv eq "ARRAY" )
    {
        debug( "Leaving $func -> " . Dumper($rv), $line );
    }
    else
    {
        debug( "Leaving $func -> $rv", $line );
    }
}

sub mute
{
    $trace_never = 1;
    $trace_trace = 0;
}

sub quiet
{
    undef $trace_verbose;
}

sub show
{
    my ($text) = @_;
    print STDERR "$text";
}

sub timestamp
{
    my ( $time, $msg ) = @_;
    $time = time unless $time;
    my ( $sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst ) =
        localtime($time);
    return
        sprintf $msg
        ? "($msg) [%04i-%02i-%02i %02i:%02i:%02i]"
        : "[%04i-%02i-%02i %02i:%02i:%02i]", $year + 1900, $mon + 1, $mday,
        $hour, $min, $sec;
}

sub trace
{
    $trace_trace = 1 unless $trace_never;
}

sub verbalize
{
    $trace_verbose = 1;
}

sub verbose
{
    my ($text) = @_;
    print $text if $trace_verbose;
}

1;
