package teLoader;

use strict;
use locale;

use Time::HiRes;
use teconfigModule;
use temanagedbModule;
eval{
    require "DBI.pm";
    DBI->import();
    1;
};
eval{
    require HTTP::Request;
    HTTP::Request->import();
    1;
};

my $SQLUNLOCK = "UNLOCK TABLES;";

##**********************************************##

sub teLoader::initSessionTable{
    my ($stp, $node, $startTime, $stopTime, $runtype, $swpackage, $testcase, $teststep, $fh) = @_;
        if( !defined $stopTime)
      {
        $stopTime = $startTime;
      }
    print $fh "Start Time TEDB: $startTime\nStop Time TEDB: $stopTime\n";
    my $dbh = getDbh();
    my %sessionItem =
        (stp => $stp,
         node => $node,
         starttime => $startTime,
         stoptime => $stopTime,
         type => $runtype,
         swpackage => $swpackage,
         testcase => $testcase,
         teststep => $teststep);


    my $tempHashReference = teLoader::sendSessionInfoToDB(\%sessionItem, $dbh, $fh);

    return $tempHashReference;
}
##*********************************************##
sub teLoader::sendRowData_experimental{
    my $dbh = getDbh();
    my $sessionID = shift;
    my $exceptionCount = shift;
    my $exceptionString = shift;
    my $ropString = shift;
    my $tableNameIndex = shift;
    my $fh = shift;
    print $fh "TEDBSessionID: $sessionID\t\t$exceptionCount\t\t$exceptionString\n";

    my $exception_id = -1;

    $exception_id = teLoader::populate_te_exception_table($dbh, $exceptionString, $fh);
    my $result=-1;

    if ($exception_id != -1) {
        print $fh "...Populating counts table with SID: $sessionID, ExcID: $exception_id, Count: $exceptionCount, TableIndex: $tableNameIndex\n";
        $result = teLoader::populate_te_counts_table($dbh, $sessionID, $exception_id, $tableNameIndex, $exceptionCount, $ropString, $fh);
    } else {
        print $fh "Error populating exception table...giving up***\n";
    }

    return $result;
}

##*********************************************##

sub teLoader::addTableNameToDBIfNecessary{
    my $dbh = getDbh();
    my $tableName = shift;
    my $tableNameIndex;

    ####LOCK TABLES
    my $SQLLOCK = "LOCK TABLES `te_tableNames` WRITE;";
    my $sth = $dbh->prepare($SQLLOCK);
    $sth->execute();
    ####

    my $SQL = "SELECT * FROM `te_tableNames` WHERE `tableName` = ? LIMIT 1;";
    $sth = $dbh->prepare($SQL);
     $sth->execute($tableName);

     my $row_href = $sth->fetchrow_hashref();
     if (defined $row_href){
         $tableNameIndex = $row_href->{table_id};
     } else {
         my $SQL2 = "INSERT INTO `te_tableNames` (`tableName`) VALUES (?);";
         my $sth2 = $dbh->prepare($SQL2);
         $sth2->execute($tableName);
         $sth->execute($tableName);

         $row_href = $sth->fetchrow_hashref();
         $tableNameIndex = $row_href->{table_id};
     }
     ####UNLOCK TABLES
     $sth = $dbh->prepare($SQLUNLOCK);
     $sth->execute();
     ####

     return $tableNameIndex;
}

## For a given start time and stp name pair, there should be one and only one stp session id in the
#  'te_sessions' table.  If it is found that there are more than one, the correct one is the first one
#  that was written to the database, ie. the lowest STP SID.  This calculated STP SID gets returned from
#  the function.
sub teLoader::calculateExpectedSTPSID{
    my $stpName = shift;
    my $startTime = shift;

    my $SQL = "SELECT * FROM `te_sessions` WHERE `stp` = ? AND `starttime` = ? ORDER BY `stp_session_id` ASC LIMIT 1;";
    my $dbh = getDbh();
    my $sth = $dbh->prepare($SQL);
    $sth->execute($stpName, $startTime);

    my $row_href = $sth->fetchrow_hashref();
    my $expectedSTPSID = $row_href->{stp_session_id};

    return $expectedSTPSID;
}

## Function is used by formatTEDB's validateSTPSessionID function.  It updates the 'te_sessions' table
# such that the row matching the 'session_id' passed in as the first parameter gets its 'stp_session_id'
# updated to match the integer that is passed in as the second parameter.
sub teLoader::updateSTPSIDForGivenSession{
    my $dbsession = shift;
    my $expectedSTPSID = shift;

    my $SQL = "UPDATE `te_sessions` SET `stp_session_id` = ? WHERE `session_id` = ?;";
    my $dbh = getDbh();
    my $sth = $dbh->prepare($SQL);
    $sth->execute($expectedSTPSID, $dbsession);
}


##**********************************************##
##            HELPER FUNCTIONS                  ##
##**********************************************##

sub getDbh{
    my $dbh = temanagedbModule::te_dbConnect(teconfigModule::getConfig7);
    return $dbh;
}

##**********************************************##

sub teLoader::sendSessionInfoToDB{
    my $sessionItemRef = shift;
    my $dbh = shift;
    my $fh = shift;

    my $SQLLOCK = "LOCK TABLES `te_sessions` WRITE;";

    my $tempstpsid = &propose_temporary_stp_sid($dbh, $fh, $sessionItemRef->{stp}, $sessionItemRef->{starttime});
    my $stp_session_id;

    my $SQL = "SELECT * FROM `te_sessions` WHERE `stp_session_id`= ? AND `node`= ? LIMIT 1;";
    my $sth = $dbh->prepare($SQL);
    $sth->execute($tempstpsid, $sessionItemRef->{node});
    my $result_2 = $sth->fetchrow_hashref();
    if (defined $result_2){
        die "A session with the following info already exists in the database:\nSTP: $sessionItemRef->{stp}\nNode: $sessionItemRef->{node}\nStart Time: $sessionItemRef->{starttime}\nStop Time: $sessionItemRef->{stoptime}\nRun Type: $sessionItemRef->{type}\nSoftware: $sessionItemRef->{swpackage}\nQuitting.  No data stored.  Please ensure you have not already reported this information\n";
    } else {
        #####LOCK TABLE
        $sth = $dbh->prepare($SQLLOCK);
        $sth->execute();
        #####
        my $currentbestsid = &propose_temporary_stp_sid($dbh, $fh, $sessionItemRef->{stp}, $sessionItemRef->{starttime});

        while ($currentbestsid != $tempstpsid){
            $tempstpsid=$currentbestsid;
            $currentbestsid = &propose_temporary_stp_sid($dbh, $fh, $sessionItemRef->{stp}, $sessionItemRef->{starttime});
        }

        my ($testString, $valuesArrayRef) = &buildInsertQuery($currentbestsid, $sessionItemRef);
        #First try to insert the data
        $SQL = $testString;
        #####PERFORM INSERT
        $sth = $dbh->prepare($SQL);
        $sth->execute(@{$valuesArrayRef});
        ######
        ######UNLOCK TABLE
        $sth = $dbh->prepare($SQLUNLOCK);
        $sth->execute();
        ######
        print $fh "CONTENTS of INSERT query: \n$testString\n";
        print $fh "Parameters:\n\t";
        print $fh join("\n\t",@{$valuesArrayRef});
        print $fh "\n";
        #Now verify the data was stored correctly
        my ($validateQuery, $validateValuesArrayRef) = &buildSelectQuery($tempstpsid, $sessionItemRef);
        $SQL = "$validateQuery";
        $sth = $dbh->prepare($SQL);
        $sth->execute(@{$validateValuesArrayRef});
        print $fh "CONTENTS of VALIDATE query:\n$validateQuery\n";
        print $fh "Parameters:\n\t";
        print $fh join("\n\t", @{$validateValuesArrayRef});
        print $fh "\n";

        $result_2 = $sth->fetchrow_hashref();

        if (!defined $result_2){
            die "Unable to populate session table in database.  Database Error 2.\n";
        } else {
            print $fh "Session Data successfully populated\n";
            my %sidHash = (
                       dbsession => $result_2->{session_id},
                       stpsession => $result_2->{stp_session_id}
                       );
            return \%sidHash;
        }
    }
}

sub teLoader::propose_temporary_stp_sid{
    my $dbh = shift;
    my $fh = shift;
    my $stp = shift;
    my $startTime = shift;

    my $tempstpsid = &doesSessionAlreadyExist($dbh, $stp, $startTime);

    #now do some checks on this id
    if (!$tempstpsid){
        print $fh "Branch 1\n";
        my $SQL = "SELECT `stp_session_id` FROM `te_sessions` ORDER BY `stp_session_id` DESC LIMIT 1;";
        my $sth = $dbh->prepare($SQL);
        $sth->execute();
        my $result = $sth->fetchrow_hashref();
        if (!defined $result){
            print $fh "Branch 1-a\n";
            #This means there is no data in the table at all, so we have to assign a value of 1 to $stp_session_id
            $tempstpsid = 1;
        } else {
            print $fh "Branch 1-b\n";
            #Add 1 to $result and return that.
            $tempstpsid = $result->{stp_session_id}+1;
            print $fh "STP SID: $tempstpsid\n";
        }
        #This means the session doesn't exist so we have to take the last reported $stp_session_id and increment it by 1
    } else {
        print $fh "Branch 2\n";
        #This means the session does exist, so we just reuse that one.
        print $fh "STP SID: $tempstpsid"
    }
    return $tempstpsid;
}

sub teLoader::buildInsertQuery{
    my $stpSessionID = shift;
    my $sessionItemRef = shift;

#$SQL = "INSERT INTO `te_sessions` (`stp`, `stp_session_id`, `node`, `starttime`, `stoptime`, `type`, `swpackage`) VALUES (?,?,?,?,?,?,?);";
    my $queryString = "INSERT INTO `te_sessions` (`stp_session_id`,";
    my $parameterCount = 0;
    my @valuesList;
    push(@valuesList, $stpSessionID);
    while (my ($k, $v) = each %$sessionItemRef){
#        $teststring .= "key: $k, value: $v.\n";

#  I have no fucking clue how uninitialized values are getting into the hash,
#  but this should hopefully fix the problem:
        if (defined $v){
            $parameterCount++;
            my $stringfragment = "`$k`,";
            push(@valuesList, $v);
            $queryString = $queryString . $stringfragment;
        }

    }
    chop($queryString);        #remove the last comma in the list
    $queryString = $queryString . ") VALUES (";

    my $qmarkstring;

    for (my $count = 0; $count<=$parameterCount; $count++){
        $qmarkstring.="?,";
    }
    chop $qmarkstring;

    $queryString = $queryString."$qmarkstring);";
    return ($queryString, \@valuesList);
}

sub teLoader::buildSelectQuery{
    my $stpSessionID = shift;
    my $sessionItemRef = shift;

    my $queryString = "SELECT * FROM `te_sessions` WHERE `stp_session_id` = ?";
    my @valuesList;
    push(@valuesList, $stpSessionID);
    while (my ($k, $v) = each %$sessionItemRef){
        if (defined $v){
            my $stringfragment = " AND `$k` = ?";
            push(@valuesList, $v);
            $queryString = $queryString . $stringfragment;
        }
    }
    $queryString = $queryString . ";";

    return ($queryString, \@valuesList);
}

sub teLoader::populate_te_exception_table{
    my $dbh = shift;
    my $exceptionString = shift;
    my $fh = shift;

    ####LOCK TABLES
    my $SQLLOCK = "LOCK TABLES `te_exceptions` WRITE;";
    my $sth = $dbh->prepare($SQLLOCK);
    $sth->execute();
    ####

    my $SQL = "SELECT * FROM `te_exceptions` WHERE `exception_string` = ?   LIMIT 1;";
     $sth = $dbh->prepare($SQL);
     $sth->execute($exceptionString);

     my $row_href = $sth->fetchrow_hashref();
     my $exception_id=-1;
     if (defined $row_href){
          $exception_id = $row_href->{exception_id};
          print $fh "Exception $exception_id was already found in the database.ID = $exception_id\n";
     }
     else {
         #need to add the exception to the table
         print $fh "Exception not found in database.  Need to add it\n";
         $exception_id = teLoader::create_exception_experimental($dbh, $exceptionString, $fh);
     }
     ####UNLOCK TABLES
     $sth = $dbh->prepare($SQLUNLOCK);
     $sth->execute();
     ####

     return $exception_id;
}

sub teLoader::doesSessionAlreadyExist{
    my $dbh = shift;
    my $stpName = shift;
    my $startTime = shift;

    my $SQL = "SELECT * FROM `te_sessions` WHERE `stp` = ? AND `starttime` = ?;";
    my $sth = $dbh->prepare($SQL);
    $sth->execute($stpName, $startTime);

    my $row_href = $sth->fetchrow_hashref();
    if (defined $row_href){
        return $row_href->{stp_session_id};
    }
    return 0;
}

##************************************************##
sub teLoader::create_exception_experimental{
    my $dbh = shift;
    my $exceptionString = shift;
    my $fh = shift;

    my $SQL = "INSERT INTO `te_exceptions` (`exception_string`) VALUES (?)";
    my $sth = $dbh->prepare($SQL);
     $sth->execute($exceptionString);

     $SQL = "SELECT * FROM `te_exceptions` WHERE `exception_string` = ?   LIMIT 1;";
     $sth = $dbh->prepare($SQL);
     $sth->execute($exceptionString);

     my $row_href = $sth->fetchrow_hashref();
     my $exception_id=-1;
     if (defined $row_href){
          $exception_id = $row_href->{exception_id};
     } else {
         print $fh "...table population unsuccessful\n"
     }
     return $exception_id;
}

##**********************************************##
sub teLoader::populate_te_counts_table{
    my $dbh = shift;
    my $session_id = shift;
    my $exception_id = shift;
    my $tableNameIndex = shift;
    my $exceptionCount = shift;
    my $ropString = shift;
    my $fh = shift;

    my $result1 = -1;
    my $result2 = -1;

    my $SQL = "SELECT * FROM `te_counts` WHERE `exception_id` = ? AND `session_id` = ? AND `table_id` = ? AND `counter`= ?;";
    my $sth = $dbh->prepare($SQL);
    $sth->execute($exception_id, $session_id, $tableNameIndex, $exceptionCount);

    my $row_href = $sth->fetchrow_hashref();
    if (!defined $row_href){
        #  Great!  This means the particular error ID does not exist in the database yet, and we can store the count there.
        my $SQL2 = undef;
        if (!defined $ropString){
            $SQL2 = "INSERT INTO `te_counts` (`exception_id`, `session_id`, `table_id`, `counter`) VALUES (?, ?, ?, ?);";
        } else {
            $SQL2 = "INSERT INTO `te_counts` (`exception_id`, `session_id`, `table_id`, `counter`, `rop_counter`) VALUES (?, ?, ?, ?,?);";
        }
        my $sth2 = $dbh->prepare($SQL2);
        if (!defined $ropString){
            $sth2->execute($exception_id, $session_id, $tableNameIndex, $exceptionCount);
        } else {
            $sth2->execute($exception_id, $session_id, $tableNameIndex, $exceptionCount, $ropString);
        }
        $result1 = 1;
    } else {
        print $fh "Error! Somehow, that data is already in the tables.\n";
        $result2 = 0;    #data is there, but it really shouldn't be, if this is a new row
    }
    #should check if the exception got stored properly or not
    if ($result1 !=-1) {
        $sth = $dbh->prepare($SQL);
        $sth->execute($exception_id, $session_id, $tableNameIndex, $exceptionCount);

        my $row_href = $sth->fetchrow_hashref();
        if (defined $row_href){
            $result2 = 1;
        } else {
            print $fh "Counter not stored properly --2\n";
        }
    } else {
        print $fh "Counter seems to already exist somehow --1\n";
    }
    $sth->finish;
    return $result2;

}
##**********************************************##

1;
