package teloaderModule;

use strict;
use LWP::UserAgent;
use HTTP::Request;
use Time::HiRes;
use teconfigModule;
use temanagedbModule;


############################################################
####                                                    ####
####               Subroutines                          ####
####                                                    ####
############################################################

##**********************************************##

sub isDbConnection{
  my $dbh = getDbh();
  if ($dbh =~ m/DBI::db=HASH/) {
    print "DB connection OK.\n";
    return 1;
  } else {
    print "DB not connected, check configuration.\n";
    return 0;
  }
}

##**********************************************##

sub getDbh{
    my $dbh = temanagedbModule::te_dbConnect(teconfigModule::getConfig1);
    return $dbh;
}


##**********************************************##

sub initSessionTable{
    my $dbh = getDbh();

    my %sessionItem =
        (#session_id => $sessionId,
         stp => shift,
         node => shift,
         starttime => shift,
         stoptime => shift,
         up => shift,
         uprev => shift,
         type => shift);

    my $sessionId = temanagedbModule::send_session_to_tedb(\%sessionItem, $dbh);

    return $sessionId;
}

##**********************************************##

sub sendRowData{
  my $dbh = getDbh();
  my $sessionID = shift;
  my $exceptionCount = shift;
  my $exceptionString = shift;

  my %exceptionItem = ( # unikey => autoincrement primary key
               code => _getCode($exceptionString),
               sconntype => "uehPsInt1616",
               callproc => "UehRabHandlingC",
               subtype => "CELL",
               ec_string => $exceptionString);

  my @ret1 = temanagedbModule::send_exception_to_tedb_new(\%exceptionItem, $dbh);
  my  $unikey = $ret1[1];

  my %code = _buildCodeItem($unikey, $sessionID, $exceptionCount, $exceptionString);

  my $ret2 = temanagedbModule::send_code_to_tedb_new(\%code, $dbh, $sessionID, $unikey);

  $ret1[3] = $ret2;

  if($ret2 >= 2)
      {
    $ret1[0] = 1;
      }

  return @ret1;
}

##**********************************************##

sub _buildCodeItem{
  my $exkey = shift;
  my $id = shift;
  my $errorCount = shift;
  my $excepString = shift;

  my %codeItem = (excepKey => $exkey,      ## from exception
                  session_id => $id,       ## from session
                  counter => $errorCount,
          ##rbid => "9");
          rbid => _getRbId($excepString));


  return %codeItem;
}

##**********************************************##

sub _getCode{
  my $excepString = shift;
  #print "excepString = $excepString";
  my @splitted = split(/(\d+)/, $excepString);
  #print "\nsplitted[0] $splitted[0], \nsplitted[1]  $splitted[1]\n";
  return $splitted[1];
}

##**********************************************##

sub _getRbId{
  my $excepString = shift;

 my $foundRbId = "";
  ## print "getRbId: excepString = $excepString";
  my @splitted = split(/RbId=/, $excepString);
  ## print "\nsplitted[0] $splitted[0], \nsplitted[1]  $splitted[1], \nsplitted[2] $splitted[2]\n";
  my @splitted2 = split(/(\d+)/, $splitted[1]);
  ## print "Seaching RbId: \nsplitted2[0] $splitted2[0]\nsplitted2[1] $splitted2[1]\n";

  my $pos = index($splitted2[0], '-');

 ##= if ($pos == 0){ $foundRbId = ''; }
  if ($pos == 0){ $foundRbId = '-'; }
  else { $foundRbId = $splitted2[1]; }

  #print "foundRbId $foundRbId";

  return $foundRbId;
}


sub _manPage
  {
    print "****************************************************************\n";
    print "***                                                          ***\n";
    print "*** teloader.pl <file1 | read | dbcon | test | trunc | drop> ***\n";
    print "***                                                          ***\n";
    print "*** read options:                                            ***\n";
    print "*** [CRLF|q|*|te_sessions|te_exceptions|te_codes|test]       ***\n";
    print "***                                                          ***\n";
    print "****************************************************************\n";
    exit;
  }

  sub _fileProcessed
    {
      print "***************************************************************\n";
      print "***                                                            \n";
      print "***  FILE PROCESSING FINISHED -   @_                           \n";
      print "***  DP  U P D A T E D                                         \n";
      print "***                                                            \n";
      print "***************************************************************\n";
    }

  sub _excepProcessed
    {
      print "***************************************************************\n";
      print "***                                                            \n";
      print "***  EXCEPTION PROCESSING FINISHED -    @_                     \n";
      print "***  DP  U P D A T E D                                         \n";
      print "***                                                            \n";
      print "***************************************************************\n";
    }
