#!/usr/bin/perl -w

#  v0.01 ecarnsa:	 plot for "pmr" command... need a proper CONFIG file.
#  v0.02 ecarnsa:	 when all the elements in a column are "N/A" gnuplot print an error;
#					 replace all the N/A with 0 (only when all of them are N/A)
#  v0.03 ecarnsa:    avoid the Warning message: empty y range [0:0], adjusting to [-1:1]
#  v0.04 ecarnsa:	 introduced an ordering to avoid overlapping of graphs
#  v0.05 ecarnsa:	 exclude the ROP files when not all the counters/kpis are present
#  v0.06 ecarnsa:	 avoid the Warning message: empty y range [100:100], adjusting to [99:101]
#  v0.07 ecarnsa:	 unset y2 in the second plot in case y2 (y axis on right) will not used.

#***************************************************************************************
#					                     >-------------------- Kpi position 1 --------------------<  >--------------------- Kpi position 2 -------------------<  .....
# KPIgnuplot_diff1.pl [-out <directory>] <Plot> <KpiName> <histogram>|<line> <left>|<right> <order>  <Plot> <KpiName> <histogram>|<line> <left>|<right> <order> [<Plot> <KpiName> <histogram>|<line> <left>|<right> <order>] [<Plot> <KpiName> <histogram>|<line> <left>|<right> <order>] ... 
#***************************************************************************************


#The <Plot> (mandatory) indicates on which graph the data should be plot: "plot1" (above with 60% of the space) or "plot2" (below with 40% of the space).
#
#The <KpiName> (mandatory) indicates the name of the Kpi.
#
#The <histogram>|<line> (mandatory) indicates the type of graph: can be histogram or line.
#
#The <left>|<right> (mandatory) indicates where the y axis shold be rappresent; <secondPlot> will plot the data in the graph below.
#
#The <order> take into account to plot order in "pmr" command: if you plot 2 histogram make sure to plot before the one with higher number otherwise you will not see it:
#   for example plot always the "Attempt" before the "Success".
#	Keep the "line" plot after the "histogram".
#
#
#
#Any further arguments must be a new set of the 5 arguments described above.

### NOTE: limited the number of histogram to 5 per plot... 
# with more than 2 histograms, the plot become unreadable!

use strict;
use FileHandle;


my (@Object_array, @unique_object, @name_file, @title_plot);
my $offset = 0;
my (%Kpi, %Kpi2);
my ($i,$k,$j);
my ($var,$string);
my $index=0;
my ($date, $time, $Object, $value, $list, $time_object);
my ($usage,$arg_index, $arg_index2);
my (@type, @type2, @kpi_name, @kpi_name2, @position, @position2, @flagNA, @value_temp, @order, @order2, @sorting, @sorting2);
my ($number_kpi,$number_kpi2,$flag0_y, $flag0_y2,$flag100_y, $flag100_y2, $flag_define_y2);
my ($string1, $string2, $y1_label, $y2_label);
my $folder=".";
my %table_pointtype = (
0 => 5,
1 => 7,
2 => 9,
3 => 11,
4 => 13,
);
my %colour_histogram = (
1 => 5,
2 => 3,
3 => 6,
4 => 1,
);

####  need to add the usage and the die to exit in case of wrong ARGV entry!

if ($ARGV[0] eq "-out") { $folder = $ARGV[1]; shift(@ARGV); shift(@ARGV);}

$arg_index=0;
$arg_index2=0;
$index = 0;

while (@ARGV > 0) { #while there are arguments left
	if ($ARGV[0] eq "plot1") { shift(@ARGV);  # divide the KPIs in 2 different groups base on graph
		$kpi_name[$arg_index] = shift(@ARGV);
		$type[$arg_index] = shift(@ARGV);
		$position[$arg_index] = shift(@ARGV);
		$order[$arg_index] = shift(@ARGV);
		$sorting[$arg_index]=[$order[$arg_index],$kpi_name[$arg_index],$type[$arg_index],$position[$arg_index],$index];
		$arg_index++;
		}
	elsif ($ARGV[0] eq "plot2") { shift(@ARGV);
		$kpi_name2[$arg_index2] = shift(@ARGV);
		$type2[$arg_index2] = shift(@ARGV);
		$position2[$arg_index2] = shift(@ARGV);
		$order2[$arg_index2] = shift(@ARGV);
		$sorting2[$arg_index2]=[$order2[$arg_index2],$kpi_name2[$arg_index2],$type2[$arg_index2],$position2[$arg_index2],$index];
		$arg_index2++;
		}	
		$index++;     
}	

### sort the 2x4 arrays base on $order to plot the KPIs in the right order ###


@sorting = sort { $$a[0] <=> $$b[0] } @sorting;
@order = map { $$_[4] } @sorting;
@kpi_name = map { $$_[1] } @sorting;
@type = map { $$_[2] } @sorting;
@position = map { $$_[3] } @sorting;

@sorting2 = sort { $$a[0] <=> $$b[0] } @sorting2;
@order2 = map { $$_[4] } @sorting2;
@kpi_name2 = map { $$_[1] } @sorting2;
@type2 = map { $$_[2] } @sorting2;
@position2 = map { $$_[3] } @sorting2;


$number_kpi=@kpi_name;
$number_kpi2=@kpi_name2;
$index = 0;

while (<STDIN>) {
	$date = "";
	if (/^(\d\d\d\d-\d\d-\d\d) (\d\d:\d\d) (\S+) (.*)/) { $date=$1; $offset=1;} #set an offset of one in case there is also the date
	if (/(\d\d:\d\d) (\S+) (.*)/) { $time = $1; $Object= $2; $value=$3; print $date." ".$time." ".$Object." ".$value."\n";
		$time_object = $date." ".$time." ".$Object;
		@value_temp = split(/\s+/,$value);
		shift(@value_temp);
		if (scalar(@value_temp) eq ($number_kpi+$number_kpi2)) {   # avoid the ROPs where not all the values are present
			$string = "";
			foreach $i (@order) {
					$string = $string." ".$value_temp[$i];   #save the value already in the right order
			}
			$Kpi{$time_object} = $string;
			$string = "";
			foreach $i (@order2) {
					$string = $string." ".$value_temp[$i];	   #save the value already in the right order
			}
			$Kpi2{$time_object} = $string;
			$Object_array[$index] = $Object; 
			$index ++;
		}
	}
}

###  Find the unique elements of $Object_array to define the number of file to create -> $list
my %temp;
@unique_object = grep { ! $temp{$_}++ } @Object_array;
$list = @unique_object;

for ($i=0; $i<$list; $i++) {
	$name_file[$i]=$unique_object[$i];
	$title_plot[$i]=$unique_object[$i];
	$name_file[$i]=~s/,/_/g;		# avoid the comma in the file name
	$title_plot[$i]=~s/_/_-/g;		# avoid the _ in the plot: it will subsript the next letter
}

for ($j=0; $j<$list; $j++) {		# perform the loop for the numeber of files that will be created
	open (GP, "|gnuplot ") or die "no gnuplot";
	GP->autoflush(1);
	
	print GP "set terminal pngcairo size 1600,800 enhanced font 'Verdana,10'\n";
	print GP "set output '",$folder,"/",$name_file[$j],"_",$kpi_name[0],"_",localtime(time),".png'\n"; # create name of the file
	print GP "set key outside center top horizontal box\n";
	print GP "set datafile missing 'N/A'\n";					# when find N/A consider as missing data.
	print GP "set xdata time\n";
		
	if ($offset == 1) { print GP "set timefmt '%Y-%m-%d %H:%M'\n";}
	else {print GP "set timefmt '%H:%M'\n";}
	
	print GP "set xtics format '%H:%M'\n";
	print GP "set xtic rotate by -90 scale 0\n";
	print GP "set lmargin 10\n";
	print GP "set rmargin 10\n"; 
	print GP "set xtics textcolor rgbcolor '#FFFFFF'\n";
	print GP "set multiplot\n";
	print GP "set size 1, 0.6\n";
	print GP "set origin 0, 0.4\n";
	print GP "set tmargin 4\n";
	print GP "set bmargin 0\n";
	print GP "set ytics nomirror\n";
	print GP "set y2tics offset 0,0.5\n";
	print GP "set ytics offset 0,0.5\n";
	print GP "set style fill solid border lc rgbcolor '#505050'\n";
	print GP "set grid front\n";
	print GP "set grid y2tics front\n";
	for ($k=0; $k < ($number_kpi+$number_kpi2); $k++) { print GP "set style line ",($k+1)," lt ",($k+1)," lw 2 pt ", $table_pointtype{($k+1) % 5} ," ps 1\n"; }
	
		
	
	print GP " set title '", $title_plot[$j],"' font 'Verdana,14'\n";

	$string2="";

	my $histcolour=1;
	my $linecolour=1;
	$y1_label="";
	$y2_label="";
	for ($k=0; $k < $number_kpi; $k++) {
		if ($position[$k] eq "left") {$string1 = "x1y1 ";$y1_label=$y1_label.$kpi_name[$k].",  ";}
		if ($position[$k] eq "right") {$string1 = "x1y2 ";$y2_label=$y2_label.$kpi_name[$k].",  ";}

		if ($type[$k] eq "histogram") {$string1 = $string1."with boxes lc ".$colour_histogram{($histcolour)};$histcolour++;}
		if ($type[$k] eq "line") {$string1 = $string1."with lp ls ".$linecolour;$linecolour++;}

		$string2 = $string2." '-' u 1:".($k+3+$offset).":xtic(".($offset+1).") title '".$kpi_name[$k]."' axes ".$string1.",";
	}

	$string2= substr($string2,0,length($string2)-1);  #define the string to create the plot 
	
	print GP "set ylabel '".substr($y1_label,0,length($y1_label)-3)."'\n";
	print GP "set y2label '".substr($y2_label,0,length($y2_label)-3)."'\n";
	
	
	### if all the samples are N/A, gnuplot print a error message, 
####### from here to "END" 
	### fix for this problem replacing N/A with 0 for the column that has all the samples equal to N/A

	#### implemented the fix when all the sample are 0.
	#### implemented the fix when all the sample are 100.

	@flagNA = (1) x $number_kpi;    # inizialization of @flag to 1; @flag will set to 0 if at least 1 of the samples is different from "N/A"
	$flag0_y = 1;
	$flag0_y2 = 1;
	$flag100_y = 1;
	$flag100_y2 = 1;
	

	foreach $var (keys %Kpi) {
		if ($var =~ $unique_object[$j]) {
		@value_temp = split(/\s+/,$Kpi{$var});	#slit and analisys of each value
		shift(@value_temp);
			for ($i=0; $i < $number_kpi; $i++) {
			   if ($value_temp[$i] ne "N/A") {$flagNA[$i]="0";}
			   if ($value_temp[$i] ne "0" && $value_temp[$i] ne "N/A") {
					if ($position[$i] eq "left") {$flag0_y=0;}
					if ($position[$i] eq "right") {$flag0_y2=0;}
				}
				if ($value_temp[$i] ne "100" && $value_temp[$i] ne "N/A") {
					if ($position[$i] eq "left") {$flag100_y=0;}
					if ($position[$i] eq "right") {$flag100_y2=0;}
				}
			}
		}
	}	
	
	foreach $var (keys %Kpi) {
		if ($var =~ $unique_object[$j]) {
		@value_temp = split(/\s+/,$Kpi{$var});
		shift(@value_temp);
			for ($i=0; $i < $number_kpi; $i++) {
			   if ($flagNA[$i] eq 1) {$value_temp[$i]=0;}
			}
			$Kpi{$var} = "";
			for ($i=0; $i < $number_kpi; $i++) {
				$Kpi{$var} = $Kpi{$var}." ".$value_temp[$i];
			}
		}
	}	
	
	
####### END ####

	if ($flag0_y == 1) {print GP "set yrange [0:1] \n";}
	if ($flag0_y2 == 1) {print GP "set y2range [0:1] \n";}
	if ($flag100_y == 1) {print GP "set yrange [99:100] \n";}
	if ($flag100_y2 == 1) {print GP "set y2range [99:100] \n";}

	
	print GP "plot ",$string2," \n";    #### plot first graph !!!!
	
	for ($k=0; $k < $number_kpi; $k++) {  # print the values in gnuplot.
	
		foreach $var (sort keys %Kpi) {
			if ($var =~ $unique_object[$j]) {
				print GP "$var   $Kpi{$var} \n";  
			}
		}
		print GP "e\n";  ### gnuplot end the graph when the letter e is printed
	}
	
	# end first graph plotting ################# !!!!!!!!!!!!!!!!!!!!!!!!!! #################### !!!!!!!!!!!!!!!!!!
	
	$string2="";

	$histcolour=3;
	$linecolour=2;
	$y1_label="";
	$y2_label="";
	for ($k=0; $k < $number_kpi2; $k++) {
		if ($position2[$k] eq "left") {$string1 = "x1y1 ";$y1_label=$y1_label.$kpi_name2[$k].",  ";}
		if ($position2[$k] eq "right") {$string1 = "x1y2 ";$y2_label=$y2_label.$kpi_name2[$k].",  ";}
		if ($type2[$k] eq "histogram") {$string1 = $string1."with boxes lc ".$colour_histogram{($histcolour)};$histcolour++;}
		if ($type2[$k] eq "line") {$string1 = $string1."with lp ls ".($linecolour); $linecolour++;}
		$string2 = $string2." '-' u 1:".($k+3+$offset).":xtic(".($offset+1).") title '".$kpi_name2[$k]."' axes ".$string1.",";
	}

	$string2= substr($string2,0,length($string2)-1);
	
	print GP "set ylabel '".substr($y1_label,0,length($y1_label)-3)."'\n";
	print GP "set y2label '".substr($y2_label,0,length($y2_label)-3)."'\n";
	
	
	### if all the samples are N/A, gnuplot print a error message, 
####### from here to "END" 
	### fix for this problem replacing N/A with 0 for the column that has all the samples equal to N/A

	#### implemented the fix when all the sample are 0.
	#### implemented the fix when all the sample are 100.	

	@flagNA = (1) x $number_kpi2;    # inizialization of @flag to 1; @flag will set to 0 if at least 1 of the samples is different from "N/A"
	$flag0_y = 1;
	$flag0_y2 = 1;
	$flag100_y = 1;
	$flag100_y2 = 1;

	foreach $var (keys %Kpi2) {
		if ($var =~ $unique_object[$j]) {
		@value_temp = split(/\s+/,$Kpi2{$var});
		shift(@value_temp);
			for ($i=0; $i < $number_kpi2; $i++){
			   if ($value_temp[$i] ne "N/A") {$flagNA[$i]="0";}
			   if ($value_temp[$i] ne "0" && $value_temp[$i] ne "N/A") {
					if ($position2[$i] eq "left") {$flag0_y=0;}
					if ($position2[$i] eq "right") {$flag0_y2=0;}
				}
				if ($value_temp[$i] ne "100" && $value_temp[$i] ne "N/A") {
					if ($position[$i] eq "left") {$flag100_y=0;}
					if ($position[$i] eq "right") {$flag100_y2=0;}
				}	
			}
		}
	}	
	
	foreach $var (keys %Kpi2) {
		if ($var =~ $unique_object[$j]) {
		@value_temp = split(/\s+/,$Kpi2{$var});
		shift(@value_temp);
			for ($i=0; $i < $number_kpi2; $i++) {
			   if ($flagNA[$i] eq 1) {$value_temp[$i]=0;}
			}
			$Kpi2{$var} = "";
			for ($i=0; $i < $number_kpi2; $i++) {
				$Kpi2{$var} = $Kpi2{$var}." ".$value_temp[$i];
			}
		}
	}	
	
	
####### END

	if ($flag0_y == 1) {print GP "set yrange [0:1] \n";}
	if ($flag0_y2 == 1) {print GP "set y2range [0:1] \n";}
	if ($flag100_y == 1) {print GP "set yrange [99:100] \n";}
	if ($flag100_y2 == 1) {print GP "set y2range [99:100] \n";}
	
	print GP "unset title\n";
	print GP "set key outside center bottom horizontal box\n";
	print GP "set bmargin 5\n";
	print GP "set xdata time\n";
	if ($offset == 1) { print GP "set timefmt '%Y-%m-%d %H:%M'\n";}
	else {print GP "set timefmt '%H:%M'\n";}
	print GP "set xtics format '%H:%M'\n";
	print GP "set xtic rotate by -90 scale 0\n";
	print GP "set xtics textcolor rgbcolor '#000000'\n";
	print GP "set y2tics offset 0,0\n";
	print GP "set ytics offset 0,0\n";
	print GP "set size 1, 0.4\n";
	print GP "set origin 0.0, 0.0\n";
	print GP "set tmargin 0.5\n";
	
	# unset y2 in case no plot will use the second axis
	
	$flag_define_y2 = 1;
	
	for ($i=0; $i<scalar(@position2); $i++) {
		if ($position2[$i] eq "right") {$flag_define_y2 =0;} 
	}
	
	if ( $flag_define_y2 == 1) { print GP "unset y2tics\n"; }
	
	
	print GP "plot ",$string2," \n";    #### plot second graph !!!!
	
	for ($i=0; $i<$number_kpi2; $i++) {
	
		foreach $var (sort keys %Kpi2) {
			if ($var =~ $unique_object[$j]) {
				print GP "$var   $Kpi2{$var} \n"; 
			}
		}
		print GP "e\n";
	}


print GP "unset multiplot\n";

	close GP;
}
