#Author: Misha Magnusson
function to_std_time(arg) { 
    gsub("-", " ", arg);
    gsub(":", " ", arg);
    gsub(/^\s+|\s+$/, "", arg);
    arg = arg" 00";
    stdArg = mktime(arg,1);
    return stdArg;
}
function to_nrml_time(arg) {
    return strftime("%Y-%m-%d %H:%M:%S", arg, 1);
}
BEGIN{
    docuArr[1] = "";
}
{
    docuArr[length(docuArr)+1] = $0;
    split($0,semicolons,";");
    interval = 900;# 15 minutes or 900s is default
    if($0 ~ "Object; Counter;"){
        firstTimestamp = semicolons[3];
        lastTimestamp = semicolons[length(semicolons)-1];
        stdTime1 = to_std_time(semicolons[3]);
        stdTime2 = to_std_time(semicolons[4]);
        interval = stdTime2-stdTime1;
        # print interval;
        # print stdTime1;
        # print stdTime2;
        # print "";
    }
    if (semicolons[1] ~ "="){
        split ($0, char, "");
        #print char[1];
        #print length(char);
        #print "-------";
        indexCounter = 1;
        commaCounter = 1;
        for (i=1; i <= length(char); i++){
            if (indexCounter > 2 && indexCounter < 4){
                #printf char[i];
                if(char[i] == ",") {
                    commaCounter++;
                }
            }
            if (char[i] == ";"){
                indexCounter++;
            }
        }
        #printf "\n-----";
        #printf commaCounter;
        #print " commas were found";
    }
}
END {
    newInterval = interval/commaCounter
    #printf "time(secs) between each timestamp: "
    #print newInterval;
    for (i=1; i<= length(docuArr); i++){
        if (docuArr[i] ~ "Object; Counter;"){
            printf "Object; Counter; ";
            currentTime = to_std_time(firstTimestamp);
            while (currentTime != to_std_time(lastTimestamp)){
                printf to_nrml_time(currentTime) "; ";
                currentTime = currentTime + newInterval;
            }
            for (ii=1; ii <= commaCounter; ii++){# we have reached end time, now print last interval.
                printf to_nrml_time(currentTime) "; ";
                currentTime = currentTime + newInterval; 
            }
            print "";

        } else{
            split(docuArr[i], divArray,";");
            if (divArray[1] ~ "="){ #Line containing values
                for (i=3; i <= length(divArray); i++){
                    gsub(",", ";", divArray[i]);
                }
                valuesLine = "";
                for (i=1; i <= length(divArray); i++){
                    if(i==1){
                        valuesLine = valuesLine divArray[i];
                    } else{
                        valuesLine = valuesLine ";" divArray[i];
                    }
                }
                print valuesLine;
            } else {
                print docuArr[i];
            }
        }
    }
}