#!/app/vbuild/SLED11-x86_64/perl/5.22.0/bin/perl
#!/usr/bin/perl

############################################################################################
#
# ul_bler.pl
# by Mathias Aldrin
#
# 20190506
#

# Mandatory traces:
# bbte @N_R4_0 log enable 1 ULL1COMMONNR.15			(RC information)
# bbte @N_R4_0 log enable 1 ULL1COMMONNR.29			(Power and HARQ NACK ratio)
# optional
# bbte @N_R4_0 log enable 1 ULL1COMMONNR.79
# bbte @N_R4_0 log enable 4 DRAULMDBFNR.103			(HARQ NACK ratio per number of SEs Has slot info, not used in version 1.0)
# bbte @N_R4_0 log enable 4 DRAULMDBFNR.104			(HARQ NACK ratio per number of SEs has not slot info)
#
# To include temp crnti info for each UE the following trace needs to be enabled
# mtd @N_R4_0 peek -ta upcUeUlNrCeIfC -sig NRULMACCI_MAC_CTRL_INFO_IND
#
# if perl module Excel::Writer is not installed on your system you need to download it and install it locally.
#
# module add perl/5.22.0
#
# Clone excel-writer repo
# cd /home/eraaldr/tmp/perlmodules
# git clone https://github.com/jmcnamara/excel-writer-xlsx
#
# cd /home/eraaldr/tmp/excel-writer-xlsx/
#
# perl Makefile.PL PREFIX=/home/eraaldr/tmp/perlmodules LIB=/home/eraaldr/tmp/perlmodules
# Checking if your kit is complete...
# Looks good
# Warning: prerequisite IO::File 1.14 not found. We have 1.10.
# Writing Makefile for Excel::Writer::XLSX
#
#            make
#            make test
#            make install
#
# Install Archive-Zip module in case it is not already installed
# cd /home/eraaldr/tmp/perlmodules
# wget https://cpan.metacpan.org/authors/id/P/PH/PHRED/Archive-Zip-1.64.tar.gz
#
# tar zxvf Archive-Zip-1.64.tar.gz
# cd Archive-Zip-1.64
# perl Makefile.PL PREFIX=/home/eraaldr/tmp/perlmodules LIB=/home/eraaldr/tmp/perlmodules
# make
# make install

# Create a configuration file in you home directory
# nano $HOME/.ulblerrc
#
# Write this row to the file and save it
# modulepath=/home/eraaldr/tmp/perlmodules
#
# Test the script
# cat logfile.dec | $HOME/eraaldr/bin/ul_bler.pl - e
#
### Old stuff
# run "module add rddtool" before running this script in case you want to generate a graph
#
############################################################################################


use Data::Dumper;

my $ul_bler_version = 1.01;
use strict;


sub readConfigFile($){
	my $cfgfile = shift;
	my %cfg;
	if (-e $cfgfile) {
		open(CONFIG, $cfgfile) or die " Error opening $cfgfile: $!\n";
		while (<CONFIG>) {
			next if /^\s*$/;
			next if /^\#/;
			chomp;
			next unless /=/;
			my ($key, $variable) = split(/=/,$_,2);
			$variable =~ s/(\$(\w+))/$cfg{$2}/g;
			$cfg{$key} = $variable;
		}
	}else {
		print 'You do not have any configuration file in your home directory $HOME/.ulblerrc' . "\n";
#		sleep (2);
	}
	return %cfg;
}

BEGIN {
	my %config = readConfigFile("$ENV{'HOME'}/.ulblerrc");
	print "module path = $config{modulepath}\n";
	if (not defined $config{modulepath}){
		$config{modulepath} = "/home/eraaldr/bin/perlmodules"
	}
	unshift @INC, $config{modulepath};
}

use Time::Local qw/timegm/;

use Excel::Writer::XLSX;
use Excel::Writer::XLSX::Utility;

use Storable qw(dclone);

use Getopt::Long;
use Time::HiRes qw(usleep nanosleep);

use constant USAGEMSG => <<USAGE;

Parses PUSCH info traces and generate statistics.

OPTIONS:

	-file|f		<filename>	Name of logfile which includes concatenated exceptions.

	-graph|g			Create graph using rrdtool (not always working)

	-excel|e			Create an excel sheet

	-ue				Print statistics from each UE

	-details|d			Print more statistsics per UE

	-complete|c			Print full statistics

	-version|v			Prints ul_bler.pl version

	-help|h				Prints help text

	-installation|i			Print installation help

USAGE

my (
        $filename,	$db,	$db2,	$graph,	$help,$ue,$complete,$version,$excel,$debug,$details,$installation
);

GetOptions(
	'file|f=s'	=> \$filename,
	'db=s'		=> \$db,
	'graph|g'	=> \$graph,
	'excel|e'	=> \$excel,
	'ue'		=> \$ue,
	'details|d'	=> \$details,
	'complete|c'	=> \$complete,
	'version|v'	=> \$version,
	'help|h'	=> \$help,
	'installation|i'	=> \$installation,
	'debug'		=> \$debug
);

die USAGEMSG if ($help);

if (defined $version){
	print "ul_perl.pl v$ul_bler_version\n\n";
	exit;
}
if (defined $installation){
	installation();
	exit;
}

if ($filename){
	open(STDIN, "<$filename") or die "Can't open file " . $filename . " for reading.";
}

if (defined $graph and ! defined $db){
#	my $RRDDataDirectory="/home/eraaldr/rrddata/";
	$db = "ul-bler.rrd";
	$db2 = "ul-rx-pwr.rrd";
	$graph = 1;
}
if (defined $graph) {
#	setenv TZ "UTC"
	$ENV{"TZ"} = "UTC";
}

my $workbook;
my %sheets;
my ($writeformat,$writeformat_noue);
my $row = 2;

if (defined $excel) {
	create_book(\$workbook,"graph.xlsx");
	create_sheets(\$workbook);
	$writeformat = $workbook->add_format();
	$writeformat->set_bold();
	$writeformat->set_color( 'blue' );
	$writeformat->set_align( 'center' );

	$writeformat_noue = $workbook->add_format();
	$writeformat_noue->set_bold();
	$writeformat_noue->set_color( 'cyan' );
	$writeformat_noue->set_align( 'center' );
}

my %bler;

my %summa = (
	'padding' => 0,
	'short_bsr' => 0,
	'long_bsr' => 0,
	'real_data' => 0,
	'empty_data' => 0
	);
my %lastmsg = (
	'MSG3' => 0,
	'PADDING' => 0,
	'SHORTBSR' => 0,
	'DATA' => 0
	);

my %rxpower = (
	'MIN' => 0,
	'MAX' => -20000,
	'SUM' => 0,
	'NUM' => 0,
	'AVG' => 0
);
my %rxpowerbucket;
my ($sum,$lastsum,$momentansum) = (0,0,0);
my $i = 0;

my ($date,$timestamp,$time);
my ($sec,$oldsec) = (0,0);
my ($firstepoc,$lastepoc);
my %time;
my ($rc,$blertype);
my (%blerperue,%blerperueCOUNTER,%rxpowerperue);
my %buffersize;
my (%ULL1MDBFUNR79,%ULL1COMMONNR15,%ULL1COMMONNR65,%ULL1COMMONNR12,%ULL1COMMONNR29,%powerbuckets,%DRAULMDBFNR,%harqacknack,%SECOUNT);
my $power_bucket_min = 800;
my $power_bucket_width = 100;
my (%crntitable);
my $macctrlinfo;
my ($macbbueref,$msg3crnti);
my $ueno = 1;
my %blerperslot;
my (%blerpercodeblock,%blerpercount);
my %tbsize;
my $DEBUGSTRING;
my $numberofcodeblocks = 0;
my %codeblocks;
my %uehealth;
my $uecol = 1;
my $harqresult = 0;
my $lastprbstart = 1;
my $secounter = 1;
#[2018-12-21 13:48:20.608269] 0xb547af1a=(bfn:2900, sfn:852, sf:8.13, bf:241) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_post_decoding_fpga.c:182: <!ULL1COMMONNR.15!> INFO bbUeRef=0x00000100 jobId=0x00172000 nCSE=0 MIR=0
# RC=0 nIt=1 activityId=0x0961 actionIdH=0x0000 actionIdL=0x0dcf torContext=0x004b92f4 codeBlockNo=0 tbSizeWithCrc=8216 cbSizeWithCrcInBits=8216 d[0 - 6] = { 0103 0002 0c3d a03f 0000 0000 0000 }
while (<STDIN>)
{
	if ( /^(\[\S+ \S+\])/ ){
		my $timestamp = $1;
		if ($timestamp =~ /\[(\d\d\d\d-\d\d-\d\d)/) {
			$date = $1;
		}
		if ($timestamp =~ /\s(\d\d:\d\d:\d\d.\d\d\d)/) {
			$time = $1;
			$sec = substr($time,6,2);
		}
		undef $macctrlinfo;
		
		if (/bbUeRef=(\S+).+crnti=(\d+)/) {
			my $bbueref = $1;
			my $crnti = $2;
			$bbueref =~ s/,//g;
			if ($bbueref =~ /0x/){
				$bbueref = hex($bbueref);
			}
			if ($bbueref < 20000){
				$crntitable{$crnti}{BBUEREF} = $bbueref;
			}else{
				$crntitable{$crnti}{TEMPBBUEREF} = $bbueref;
			}
		}

#[2019-04-26 14:31:14.038136] 0xc9378d89=(bfn:3219, sfn:147, sf:8.00, bf:216) duId:1 EMCA4/BbiUniqueTrace 2 draulnrmdbfce_puschslotalloc_scheduleue.c:945: <!DRAULMDBFNR.103!> TRACE3 cellId=1, bbUeRef=0x00000480  : Sending PdcchResultInd. puschSlotAlloc DRA UL data: cellIdx=0 mValue=6 timeResAllocIndex=5 symbolStart=0 symbolStop=13 harqProcId=5 ndi=0 mcs=12 rv=0 zPwrPtrsPresence=0 mapPuschToDmrs=0 puschTpcCmd=1 nrOfAntennaPorts=1 mapVrbToPrb=0 freqHoppingFlag=0 srsRequset=0 dmrsSeqInit=0 ulBandwidthInPrbs=273 prbStart=1 prbLength=33 aCsiScheduling=1 csiRptFormat=0 reportTriggerSize=1 puschSlot=4 tbSizeInBits=8064 
#[2019-04-26 14:31:14.040128] 0xc9400b98=(bfn:3220, sfn:148, sf:0.00, bf:185) duId:1 EMCA4/BbiUniqueTrace 2 draulnrmdbfce_puschslotalloc_scheduleue.c:945: <!DRAULMDBFNR.103!> TRACE3 cellId=1, bbUeRef=0x000004c0  : Sending PdcchResultInd. puschSlotAlloc DRA UL data: cellIdx=0 mValue=2 timeResAllocIndex=1 symbolStart=0 symbolStop=13 harqProcId=13 ndi=0 mcs=12 rv=0 zPwrPtrsPresence=0 mapPuschToDmrs=0 puschTpcCmd=1 nrOfAntennaPorts=1 mapVrbToPrb=0 freqHoppingFlag=0 srsRequset=0 dmrsSeqInit=0 ulBandwidthInPrbs=273 prbStart=34 prbLength=1 aCsiScheduling=0 csiRptFormat=65535 reportTriggerSize=1 puschSlot=4 tbSizeInBits=240 
#[2019-04-26 14:31:14.040145] 0xc9400f91=(bfn:3220, sfn:148, sf:0.00, bf:249) duId:1 EMCA4/BbiUniqueTrace 2 draulnrmdbfce_puschslotalloc_scheduleue.c:945: <!DRAULMDBFNR.103!> TRACE3 cellId=1, bbUeRef=0x00000460  : Sending PdcchResultInd. puschSlotAlloc DRA UL data: cellIdx=0 mValue=2 timeResAllocIndex=1 symbolStart=0 symbolStop=13 harqProcId=5 ndi=1 mcs=12 rv=0 zPwrPtrsPresence=0 mapPuschToDmrs=0 puschTpcCmd=1 nrOfAntennaPorts=1 mapVrbToPrb=0 freqHoppingFlag=0 srsRequset=0 dmrsSeqInit=0 ulBandwidthInPrbs=273 prbStart=35 prbLength=43 aCsiScheduling=0 csiRptFormat=65535 reportTriggerSize=1 puschSlot=4 tbSizeInBits=10504 
#[2019-04-26 14:31:14.040350] 0xc9404099=(bfn:3220, sfn:148, sf:0.27, bf:9) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_post_decoding_fpga.c:182: <!ULL1COMMONNR.15!> TRACE3 bbUeRef=0x00000460 jobId=0x00366000 nCSE=0 MIR=0 RC=0 nIt=1 activityId=0x01aa actionIdH=0x0000 actionIdL=0x1004 torContext=0x0059e346 codeBlockNo=0 tbSizeWithCrc=5656 cbSizeWithCrcInBits=5656 d[0 - 6] = { 0103 0114 bc41 02b8 b007 4100 1700 }  
#[2019-04-26 14:31:14.040503] 0xc9406578=(bfn:3220, sfn:148, sf:0.40, bf:87) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_post_decoding_fpga.c:182: <!ULL1COMMONNR.15!> TRACE3 bbUeRef=0x000004e0 jobId=0x00365000 nCSE=0 MIR=0 RC=0 nIt=2 activityId=0x06ad actionIdH=0x0000 actionIdL=0x1004 torContext=0x0059df31 codeBlockNo=0 tbSizeWithCrc=31264 cbSizeWithCrcInBits=7840 d[0 - 6] = { 4103 b9a0 0303 0037 0809 0a0b 0c0d }  
#[2019-04-26 14:31:14.040521] 0xc94069d9=(bfn:3220, sfn:148, sf:0.40, bf:157) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_post_decoding_fpga.c:182: <!ULL1COMMONNR.15!> TRACE3 bbUeRef=0x000004e0 jobId=0x00365100 nCSE=0 MIR=0 RC=0 nIt=2 activityId=0x0388 actionIdH=0x0000 actionIdL=0x1004 torContext=0x0059df31 codeBlockNo=1 tbSizeWithCrc=31264 cbSizeWithCrcInBits=7840 d[0 - 6] = { 1911 009e 0a72 a701 0008 2926 0860 }  
#[2019-04-26 14:31:14.040540] 0xc9406e37=(bfn:3220, sfn:148, sf:0.40, bf:227) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_post_decoding_fpga.c:182: <!ULL1COMMONNR.15!> TRACE3 bbUeRef=0x000004e0 jobId=0x00365200 nCSE=0 MIR=0 RC=0 nIt=2 activityId=0x0a0b actionIdH=0x0000 actionIdL=0x1004 torContext=0x0059df31 codeBlockNo=2 tbSizeWithCrc=31264 cbSizeWithCrcInBits=7840 d[0 - 6] = { b1b2 b3b4 b5b6 b7b8 b9ba bb41 03ee }  
#[2019-04-26 14:31:14.040557] 0xc9407262=(bfn:3220, sfn:148, sf:0.47, bf:38) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_post_decoding_fpga.c:182: <!ULL1COMMONNR.15!> TRACE3 bbUeRef=0x000004e0 jobId=0x00365300 nCSE=0 MIR=0 RC=0 nIt=2 activityId=0x0665 actionIdH=0x0000 actionIdL=0x1004 torContext=0x0059df31 codeBlockNo=3 tbSizeWithCrc=31264 cbSizeWithCrcInBits=7840 d[0 - 6] = { 9192 9394 9596 9798 999a 9b9c 9d9e }  
		if (/DRAULMDBFNR.103/){
			if (/bbUeRef=(\S+) .+prbStart=(\d+) prbLength=(\d+) aCsiScheduling=(\d+) csiRptFormat=(\d+) reportTriggerSize=(\d+) puschSlot=(\d+) tbSizeInBits=(\d+)/){
				my $bbueref = hex($1);
				my $prbstart = $2;
				my $prblength = $3;
				my $acsischeduling = $4;
				my $csirptformat = $5;
				my $reporttriggersize = $6;
				my $puschslot = $7;
				my $tbsizeinbits = $8;

				if (exists $DRAULMDBFNR{COUNT}{SLOT}{$puschslot}) {
					$DRAULMDBFNR{COUNT}{SLOT}{$puschslot}++;
				}else{
					$DRAULMDBFNR{COUNT}{SLOT}{$puschslot} = 1;
				}
				if (exists $DRAULMDBFNR{BBUEREF}{$bbueref}) {
					$DRAULMDBFNR{BBUEREF}{$bbueref}++;
				}else{
					$DRAULMDBFNR{BBUEREF}{$bbueref} = 1;
				}
#				print "slot=$puschslot,	COUNT = $DRAULMDBFNR{COUNT}{SLOT}{$puschslot}\n";
			}
		}
		elsif (/DRAULMDBFNR.104/){
#[2019-04-23 08:39:37.610383] 0x9c900892=(bfn:2505, sfn:457, sf:0.00, bf:137) duId:1 EMCA4/BbiUniqueTrace 2 draulnrmdbfce_puschslotalloc_scheduleue.c:787: <!DRAULMDBFNR.104!> TRACE3 bbUeRef=0x000000e0  : pusch SlotAlloc DRA UL temp data: 
# cellIdx=0 nPuschId=-1 crnti=17947 tbSizeInBits=240 symbolMask=16383 qm=4 rvIdx=0 ulHarqProcessId=1 nrOfHarqBits=0 ulHarqBufferPoolIndex=2 dlHarqProcId=[65535,65535,65535] isFirstTransmission=1 isFirstNewTx=0
# isLastTransmission=1 nrOfCsiPart1Bits=0 nrOfCsiPart2Bits=[0,0,0,0] csiRptFormat=-1 rInit=868 nrOfAntennas=2 nrOfAntennaPorts=1 nrOfClusters=1 nrOfRefSymbols=2 seIndex=0 refSymbolIndex0=2
#refSymbolIndex1=11 antennaPort[0].antennaPortInd=0 clusterInfo[0].prbStart=1 clusterInfo[0].prbLength=1
			if (/bbUeRef=(\S+) .+prbStart=(\d+).+prbLength=(\d+)/){
				my $bbueref = hex($1);
				my $prbstart = $2;
				my $prblength = $3;
				if ($lastprbstart < $prbstart){
					$secounter++;
				}else{
#					print "harqresult=$harqresult,	prbstart=$prbstart,	lastprbstart=$lastprbstart,	prblength=$prblength,	secounter=$secounter\n";
					if ($harqresult == 1) {
						if (exists $SECOUNT{$secounter}{ACK}) {
							$SECOUNT{$secounter}{ACK} ++;
						}else{
							$SECOUNT{$secounter}{ACK} = 1;
						}
					}else{
						if (exists $SECOUNT{$secounter}{NACK}) {
							$SECOUNT{$secounter}{NACK} ++;
						}else{
							$SECOUNT{$secounter}{NACK} = 1;
						}
					}
					if (exists $SECOUNT{$secounter}{TOT}) {
						$SECOUNT{$secounter}{TOT} ++;
					}else{
						$SECOUNT{$secounter}{TOT} = 1;
					}
					$secounter = 1;
				}
				$lastprbstart = $prbstart;
			}
		}
		elsif (/ULL1MDBFUNR\.79/){
#[2019-05-03 12:15:03.204161] 0xed83ce44=(bfn:3800, sfn:728, sf:4.00, bf:228) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrmdbfupe_puschcoord_handlenrpuschseallocationind.c:764: <!ULL1MDBFUNR.79!> INFO ULL1NRMDBF_PUSCHCOORD_handleSeAllocInd sigNo=00004c40
# bbUeRef=0x002801c0 sfn=728 slotNo=9 source=0 allocIndex=16 foundIdleSeTor=1 isPltMode=0 isBeamSpace=1 bbCellIndex=0 cellId=1 nrOfAntennaPorts=1 nrOfAntennas=8 nrOfClusters=1 prbStart=1 prbLength=3 nrOfRefSymbols=3 symbolMask=16383 qm=2 nPuschId=-1 refSymbolIndex [2 7 11 0] antennaPort [0 0]
# harqProc=0 crnti=17941 tbSizeInBits=88 rvIdx=0 rInit=240 isFirstTransmission=1 isFirstNewTx=1 isLastTransmission=1 ulHarqBufferPoolIndex=1 alpha=100 nrOfHarqBits=0 betaOffsetIndexHarq=5 nrOfCsiPart1Bits=0 betaOffsetIndexCsiPart1=0 nrOfCsiPart2Bits [0 0 0 0] betaOffsetCsiPart2Index1=0
# betaOffsetCsiPart2Index2=0 groupIndex=0 userIndex=0 nrOfUsers=0
			if (/bbUeRef=(\S+) sfn=(\d+) slotNo=(\d+).+nrOfAntennaPorts=(\d+) nrOfAntennas=(\d+) nrOfClusters=(\d+) prbStart=(\d+) prbLength=(\d+) nrOfRefSymbols=(\d+) symbolMask=(\d+) qm=(\d+).+tbSizeInBits=(\d+).+nrOfHarqBits=(\d+).+betaOffsetIndexCsiPart1=(\d+).+betaOffsetCsiPart2Index1=(\d+).+nrOfUsers=(\d+)/){
				my $bbueref = hex($1);
				my $sfn = $2;
				my $slotno = $3;
				my $nrofantennaports=$4;
				my $nrofantennas=$5;
				my $nrofclusters=$6;
				my $prbstart=$7;
				my $prblength=$8;
				my $nrofrefsymbols=$9;
				my $symbolmask=$10;
				my $qm=$11;
				my $tbsizeinbits=$12;
				my $nrofharqbits=$13;
				my $betaoffsetindexcsipart1=$14;
				my $betaoffsetindexcsipart2=$15;
				my $numberofusers=$16;
	
				if (exists $ULL1MDBFUNR79{NROFANTENNAPORTS}{$nrofantennaports}) {
					$ULL1MDBFUNR79{NROFANTENNAPORTS}{$nrofantennaports}++;
				}else{
					$ULL1MDBFUNR79{NROFANTENNAPORTS}{$nrofantennaports}=1;
				}
				if (exists $ULL1MDBFUNR79{NROFANTENNAS}{$nrofantennas}) {
					$ULL1MDBFUNR79{NROFANTENNAS}{$nrofantennas}++;
				}else{
					$ULL1MDBFUNR79{NROFANTENNAS}{$nrofantennas}=1;
				}
				if (exists $ULL1MDBFUNR79{NROFCLUSTERS}{$nrofclusters}) {
					$ULL1MDBFUNR79{NROFCLUSTERS}{$nrofclusters}++;
				}else{
					$ULL1MDBFUNR79{NROFCLUSTERS}{$nrofclusters}=1;
				}
				if (exists $ULL1MDBFUNR79{PRBSTART}{$prbstart}) {
					$ULL1MDBFUNR79{PRBSTART}{$prbstart}++;
				}else{
					$ULL1MDBFUNR79{PRBSTART}{$prbstart}=1;
				}
				if (exists $ULL1MDBFUNR79{PRBLENGTH}{$prblength}) {
					$ULL1MDBFUNR79{PRBLENGTH}{$prblength}++;
				}else{
					$ULL1MDBFUNR79{PRBLENGTH}{$prblength}=1;
				}
				if (exists $ULL1MDBFUNR79{NROFREFSYMBOLS}{$nrofrefsymbols}) {
					$ULL1MDBFUNR79{NROFREFSYMBOLS}{$nrofrefsymbols}++;
				}else{
					$ULL1MDBFUNR79{NROFREFSYMBOLS}{$nrofrefsymbols}=1;
				}
				if (exists $ULL1MDBFUNR79{SYMBOLMASK}{$symbolmask}) {
					$ULL1MDBFUNR79{SYMBOLMASK}{$symbolmask}++;
				}else{
					$ULL1MDBFUNR79{SYMBOLMASK}{$symbolmask}=1;
				}
				if (exists $ULL1MDBFUNR79{QM}{$qm}) {
					$ULL1MDBFUNR79{QM}{$qm}++;
				}else{
					$ULL1MDBFUNR79{QM}{$qm}=1;
				}
				if (exists $ULL1MDBFUNR79{TBSIZEINBITS}{$tbsizeinbits}) {
					$ULL1MDBFUNR79{TBSIZEINBITS}{$tbsizeinbits}++;
				}else{
					$ULL1MDBFUNR79{TBSIZEINBITS}{$tbsizeinbits}=1;
				}
				if (exists $ULL1MDBFUNR79{NROFHARQBITS}{$nrofharqbits}) {
					$ULL1MDBFUNR79{NROFHARQBITS}{$nrofharqbits}++;
				}else{
					$ULL1MDBFUNR79{NROFHARQBITS}{$nrofharqbits}=1;
				}
				if (exists $ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART1}{$betaoffsetindexcsipart1}) {
					$ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART1}{$betaoffsetindexcsipart1}++;
				}else{
					$ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART1}{$betaoffsetindexcsipart1}=1;
				}
				if (exists $ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART2}{$betaoffsetindexcsipart2}) {
					$ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART2}{$betaoffsetindexcsipart2}++;
				}else{
					$ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART2}{$betaoffsetindexcsipart2}=1;
				}
				
				if (exists $ULL1MDBFUNR79{SLOT}{$slotno}) {
					$ULL1MDBFUNR79{SLOT}{$slotno}++;
				}else{
					$ULL1MDBFUNR79{SLOT}{$slotno} = 1;
				}
				if (exists $ULL1MDBFUNR79{BBUEREF}{$bbueref}) {
					$ULL1MDBFUNR79{BBUEREF}{$bbueref}++;
				}else{
					$ULL1MDBFUNR79{BBUEREF}{$bbueref} = 1;
				}
#				print "slot=$slotno,	COUNT = $ULL1MDBFUNR79{COUNT}{SLOT}{$slotno}\n";
			}
		}elsif (/ULL1COMMONNR.15/){
			if (/bbUeRef=(\S+) .+MIR=(\d+) RC=(\d+) nIt=(\d+) .+codeBlockNo=(\d+).+cbSizeWithCrcInBits=(\d+).+d\[0 - 6\] = (\{.+\})/){
				my $bbueref = hex($1);
				my $mir = $2;
				$rc = $3;
				my $nint = $4;
				my $codeblock = $5;
				my $tbsizewithcrc = $6;
				my $data = $7;
				$blertype = "---";
				$sum++;
				$momentansum++;
#				print "sum=$sum,	momentansum=$momentansum rc=$rc\n";
#				print "bbueref=$bbueref,	tbsize=$tbsicewithcrc,	rc=$rc\n";
				$numberofcodeblocks++;
				if (exists $codeblocks{$rc}) {
					$codeblocks{$rc}++;
				}else{
					$codeblocks{$rc} = 1;
				}
				
				if (exists $ULL1COMMONNR15{MIR}{$mir}) {
					$ULL1COMMONNR15{MIR}{$mir}++;
				}else{
					$ULL1COMMONNR15{MIR}{$mir}=1;
				}
				if (exists $ULL1COMMONNR15{RC}{$rc}) {
					$ULL1COMMONNR15{RC}{$rc}++;
				}else{
					$ULL1COMMONNR15{RC}{$rc}=1;
				}
				if (exists $ULL1COMMONNR15{CODEBLOCK}{$codeblock}) {
					$ULL1COMMONNR15{CODEBLOCK}{$codeblock}++;
				}else{
					$ULL1COMMONNR15{CODEBLOCK}{$codeblock}=1;
				}
				if (exists $ULL1COMMONNR15{NINT}{$nint}) {
					$ULL1COMMONNR15{NINT}{$nint}++;
				}else{
					$ULL1COMMONNR15{NINT}{$nint}=1;
				}
				if (exists $ULL1COMMONNR15{TBSIZEWITHCRC}{$tbsizewithcrc}) {
					$ULL1COMMONNR15{TBSIZEWITHCRC}{$tbsizewithcrc}++;
				}else{
					$ULL1COMMONNR15{TBSIZEWITHCRC}{$tbsizewithcrc}=1;
				}
				if (exists $tbsize{UE}{$bbueref}) {
					$tbsize{UE}{$bbueref} += $tbsizewithcrc;
					$tbsize{UEDELTA}{$bbueref} += $tbsizewithcrc;
					$tbsize{TOT} += $tbsizewithcrc;
					$tbsize{TOTDELTA} += $tbsizewithcrc;
#print "2.	$time	bbueref=$bbueref,	TPT_UE=$tbsize{UE}{$bbueref}	UEDELTA=$tbsize{UEDELTA}{$bbueref},	TOT=$tbsize{TOT},	TOTDELTA=$tbsize{TOTDELTA}	tpt=" .$tbsize{TOTDELTA}/1000 . "kbits/s\n";
				}else{
					$tbsize{UE}{$bbueref} = $tbsizewithcrc;
					$tbsize{UEDELTA}{$bbueref} = $tbsizewithcrc;
					$tbsize{TOT} = $tbsizewithcrc;
#print "1.	$time	bbueref=$bbueref,	TPT_UE=$tbsize{UE}{$bbueref}	UEDELTA=$tbsize{UEDELTA}{$bbueref},	TOT=$tbsize{TOT},	TOTDELTA=$tbsize{TOTDELTA}	tpt=" . $tbsize{TOTDELTA}/1000 . "kbits/s\n";	

					$tbsize{TOTDELTA} = $tbsizewithcrc;
					if (defined $excel) {
						my $tpt = $tbsize{TOTDELTA} / 1000;
#						print "uecol=$uecol,	tpt=$tpt,	writeformat=$writeformat\n";
						$sheets{5}->write( "$uecol"."1",$tpt,$writeformat);
					}
					$uecol++;
				}
				if ($data =~ /\{ 3a46 /) {
					$lastmsg{MSG3} = $time;
					#This is also  data
					if ($bler{total}{real_data}{$rc}){
						$bler{momentan}{real_data}{$rc}++;
						$bler{momentan}{real_data_c}{$rc}++;
						$bler{total}{real_data}{$rc}++;
						$bler{total}{real_data_c}{$rc}++;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{real_data}{$rc}++;
						$blerpercodeblock{$codeblock}{real_data}{$rc}++;
						$blerpercodeblock{$codeblock}{real_data_c}{$rc}++;
					}else {
						$bler{momentan}{real_data}{$rc} = 1;
						$bler{momentan}{real_data_c}{$rc} = 1;
						$bler{total}{real_data}{$rc} = 1;
						$bler{total}{real_data_c}{$rc} = 1;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{real_data}{$rc} = 1;
						$blerpercodeblock{$codeblock}{real_data}{$rc} = 1;
						$blerpercodeblock{$codeblock}{real_data_c}{$rc} = 1;
#						$blerseperslot{$}{real_data}{$rc} = 1;
					}
					if ($summa{real_data}){
						$summa{real_data}++;
					}else {
						$summa{real_data} = 1;
					}
					$lastmsg{DATA} = $time;
					$blertype = "real_data";
				}elsif ($data =~ /3f00 0000 0000 0000 0000 0000 0000/ ){
					if ($bler{total}{padding}{$rc}){
						$bler{momentan}{padding}{$rc}++;
						$bler{momentan}{padding_c}{$rc}++;
						$bler{total}{padding}{$rc}++;
						$bler{total}{padding_c}{$rc}++;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{padding}{$rc}++;
						$blerpercodeblock{$codeblock}{padding}{$rc}++;
						$blerpercodeblock{$codeblock}{padding_c}{$rc}++;
					}else {
						$bler{momentan}{padding}{$rc} = 1;
						$bler{momentan}{padding_c}{$rc} = 1;
						$bler{total}{padding}{$rc} = 1;
						$bler{total}{padding_c}{$rc} = 1;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{padding}{$rc} = 1;
						$blerpercodeblock{$codeblock}{padding}{$rc} = 1;
						$blerpercodeblock{$codeblock}{padding_c}{$rc} = 1;
					}
					if ($summa{padding}){
						$summa{padding}++;
					}else {
						$summa{padding} = 1;
					}
					$lastmsg{PADDING} = $time;
					$blertype = "padding";
					#{ 3ddf 3eec 06aa b0da 152b 688e d3df 			[0-9a-f]{4} [0-9a-f]{4} [0-9a-f]{4} [0-9a-f]{4} [0-9a-f]{4}
				}elsif ($data =~ /3d([0-9a-f]{1,2}) 3f[0-9a-f]{1,2} [0-9a-f]{4} [0-9a-f]{4} [0-9a-f]{4} [0-9a-f]{4} [0-9a-f]{4}/){
#					printf ("	LGCID %d - BSR index %d:%d,	" , ($buffersize{$index} & 224 )>> 5, (hex($index) & 31),$buffersize{$index});
#					my $lgcid = ($1 & 224) >> 5;
#					my $bufsize = hex($1) & 31;
#					if (exists $buffersize{LGCID}{$lgcid}) {
#						$buffersize{LGCID}{$lgcid}++;
#					}else {
#						$buffersize{LGCID}{$lgcid} = 1;
#					}
#					if (exists $buffersize{BUFFERSIZE}{$bufsize}) {
#						$buffersize{BUFFERSIZE}{$bufsize}++;
#					}else {
#						$buffersize{BUFFERSIZE}{$bufsize} = 1;
#					}
#print "APA:	$_";
					if (exists $buffersize{$1}) {
						$buffersize{$1}++;
					}else {
						$buffersize{$1} = 1;
					}
					if ($bler{total}{short_bsr}{$rc}){
						$bler{momentan}{short_bsr}{$rc}++;
						$bler{total}{short_bsr}{$rc}++;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{short_bsr}{$rc}++;
						$blerpercodeblock{$codeblock}{short_bsr}{$rc}++;
						$blerpercodeblock{$codeblock}{short_bsr_c}{$rc}++;
					}else {
						$bler{momentan}{short_bsr}{$rc} = 1;
						$bler{total}{short_bsr}{$rc} = 1;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{short_bsr}{$rc} = 1;
						$blerpercodeblock{$codeblock}{short_bsr}{$rc} = 1;
						$blerpercodeblock{$codeblock}{short_bsr_c}{$rc} = 1;
					}
					if ($summa{short_bsr}){
						$summa{short_bsr}++;
					}else {
						$summa{short_bsr} = 1;
					}
					$lastmsg{SHORTBSR} = $time;
					$blertype = "short_bsr";				
				}elsif ($data =~ /3e[\da-f]{1,2} [\da-f]{1,4} 0000 0000 0000 0000 0000/){
					if ($bler{total}{long_bsr}{$rc}){
						$bler{momentan}{long_bsr}{$rc}++;
						$bler{total}{long_bsr}{$rc}++;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{long_bsr}{$rc}++;
						$blerpercodeblock{$codeblock}{long_bsr}{$rc}++;
						$blerpercodeblock{$codeblock}{long_bsr_c}{$rc}++;
					}else {
						$bler{total}{long_bsr}{$rc} = 1;
						$bler{momentan}{long_bsr}{$rc} = 1;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{long_bsr}{$rc} = 1;
						$blerpercodeblock{$codeblock}{long_bsr}{$rc} = 1;
						$blerpercodeblock{$codeblock}{long_bsr_c}{$rc} = 1;
					}
					if ($summa{long_bsr}){
						$summa{long_bsr}++;
					}else {
						$summa{long_bsr} = 1;
					}
					$lastmsg{LONGBSR} = $time;
					$blertype = "long_bsr";
				}elsif ($data =~ /0000 0000 0000 0000 0000 0000 0000/ ){
					if ($bler{total}{empty_data}{$rc}){
						$bler{momentan}{empty_data}{$rc}++;
						$bler{momentan}{empty_data_c}{$rc}++;
						$bler{total}{empty_data}{$rc}++;
						$bler{total}{empty_data_c}{$rc}++;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{empty_data}{$rc}++;
						$blerpercodeblock{$codeblock}{empty_data}{$rc}++;
						$blerpercodeblock{$codeblock}{empty_data_c}{$rc}++;
					}else {
						$bler{momentan}{empty_data}{$rc} = 1;
						$bler{momentan}{empty_data_c}{$rc} = 1;
						$bler{total}{empty_data}{$rc} = 1;
						$bler{total}{empty_data_c}{$rc} = 1;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{empty_data}{$rc} = 1;
						$blerpercodeblock{$codeblock}{empty_data}{$rc} = 1;
						$blerpercodeblock{$codeblock}{empty_data_c}{$rc} = 1;
					}
					if ($summa{empty_data}){
						$summa{empty_data}++;
					}else {
						$summa{empty_data} = 1;
					}
					$lastmsg{DATA} = $time;
					$blertype = "empty_data";
				}else{
					if ($bler{total}{real_data}{$rc}){
						$bler{momentan}{real_data}{$rc}++;
						$bler{momentan}{real_data_c}{$rc}++;
						$bler{total}{real_data}{$rc}++;
						$bler{total}{real_data_c}{$rc}++;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{real_data}{$rc}++;
						$blerpercodeblock{$codeblock}{real_data}{$rc}++;
						$blerpercodeblock{$codeblock}{real_data_c}{$rc}++;
#						print "real data again $bler{total}{real_data}{$rc}\n";
					}else {
						$bler{momentan}{real_data}{$rc} = 1;
						$bler{momentan}{real_data_c}{$rc} = 1;
						$bler{total}{real_data}{$rc} = 1;
						$bler{total}{real_data_c}{$rc} = 1;
						$blerpercount{total}{$DRAULMDBFNR{COUNT}}{real_data}{$rc} = 1;
						$blerpercodeblock{$codeblock}{real_data}{$rc} = 1;
						$blerpercodeblock{$codeblock}{real_data_c}{$rc} = 1;
					}
					if ($summa{real_data}){
						$summa{real_data}++;
						$summa{real_data_c}++;
					}else {
						$summa{real_data} = 1;
						$summa{real_data_c} = 1;
					}
					$lastmsg{DATA} = $time;
					$blertype = "real_data";
				}
#				print "existing0 $bbueref,	$blertype,	$rc,	sum=$blerperue{$bbueref}{sum},	val=$blerperue{$bbueref}{rc}{$blertype}{$rc}\n";
				if ($bbueref < 20000) {
					if (not exists $blerperue{$bbueref}{ueno}){
						$blerperue{$bbueref}{ueno} = $ueno;
						$uehealth{$bbueref}{status} = 'ALIVE';
						$uehealth{$bbueref}{lastseen} = getTime($date,$time);
						$uehealth{$bbueref}{ueno} = $ueno;
						$blerperueCOUNTER{$bbueref}{ueno} = $ueno;
						$ueno++;		
					}else{
						$uehealth{$bbueref}{status} = 'ALIVE';
						$uehealth{$bbueref}{lastseen} = getTime($date,$time);
						$blerperueCOUNTER{$bbueref}{ueno} = 1;
					}
					if (exists $blerperue{$bbueref}{sum}){
						$blerperue{$bbueref}{sum}++;
					}else{
						$blerperue{$bbueref}{sum} = 1;
					}
					if (exists $blerperue{$bbueref}{rc}{$blertype}{$rc}){
						$blerperue{$bbueref}{rc}{$blertype}{$rc}+=1;
					}else{
						$blerperue{$bbueref}{rc}{$blertype}{$rc} = 1;
					}
#					print Dumper(%blerperue);
#					print "bbueref=$bbueref,	sum=$blerperue{$bbueref}{sum}, rc=$rc,	type=$blertype,	val=$blerperue{$bbueref}{rc}{$blertype}{$rc}\n";
					if ($blerperue{$bbueref}{rc}{$blertype}{$rc} > $blerperue{$bbueref}{sum}){
						exit;
					}
				}
				if (exists $DRAULMDBFNR{COUNT}){
#					print "COUNT = $DRAULMDBFNR{COUNT}{SLOT}{4}\n";
#					if ( $DRAULMDBFNR{COUNT} == 9){
#						print $_;
#					}
				}

			} # end if MIR=
			undef $DRAULMDBFNR{COUNT};
		} #ULL1COMMONNR.15
#[2018-12-19 08:02:10.532294] 0xe0520fa3=(bfn:3589, sfn:517, sf:2.13, bf:250) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_send_puschrpt2ul.c:117: <!ULL1COMMONNR.29!> INFO Sending puschRpt2Ul to UPC, bbUeRef=32, cellId=1, 
#sfn=517, slotNo=3, crnti=18012 isPuschFbValid=1 cbgCrcInfo=1 cbgValidBitmap=1 ulHarqProcId=5 puschPerAntRxPsdAvg=0 puschTotalRxPsdAvg=-752 postEqSinr=114 isDtx=0 timingOffsetReport=0 sesType=0, isPltMode=0  
#puschRpt2Ul to UPC, bbUeRef=32, cellId=1, sfn=358, slotNo=19, crnti=18012 isPuschFbValid=1 cbgCrcInfo=1 cbgValidBitmap=1 ulHarqProcId=14 puschPerAntRxPsdAvg=0 puschTotalRxPsdAvg=-751 postEqSinr=117 isDtx=0 timingOffsetReport=0 sesType=0, isPltMode=0  

#2018-12-17 14:59:13.920435] 0x0c8051c1=(bfn:200, sfn:200, sf:0.33, bf:28) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_send_puschrpt2ul.c:117: <!ULL1COMMONNR.29!> INFO Sending puschRpt2Ul to UPC, bbUeRef=0, cellId=1, sfn=199, 
#slotNo=19, crnti=17930 isPuschFbValid=1 isAck=0 ulHarqProcId=10 puschPerAntRxPsdAvg=0 puschTotalRxPsdAvg=-1394 postEqSinr0=-150 postEqSinr1=0 isDtx=0 timingOffsetReport=0 sesType=0, isPltMode=0

#
		elsif (/ULL1COMMONNR\.29.+puschRpt2Ul to UPC,/){
			my ($bbueref, $slotnum, $ispuschfbvalid, $cbgcrcinfo, $cbgvalidbitmap, $ulharqprocid, $isack, $puschperantrxpsavg, $puschtotalrxpsavg, $posteqsinr, $posteqsinr0, $posteqsinr1, $isdtx, $timingOffsetReport, $sestype,$crnti);
			if (/ bbUeRef=(\d+).+slotNo=(\d+).+isPuschFbValid=(\d+)/){
				$bbueref = $1;
				$slotnum = $2;
				$ispuschfbvalid = $3;
				my $blertype2 = $blertype . "_c";
				$DEBUGSTRING = "slot=$slotnum,	rc=$rc	hash=$blerperslot{$slotnum}{SLOT}{$blertype}{$rc}\n";
				if ($blerperslot{$slotnum}{TOT}){
					$blerperslot{$slotnum}{TOT} += $numberofcodeblocks;
				}else{
					$blerperslot{$slotnum}{TOT} = $numberofcodeblocks;
				}
				foreach my $rc (sort {$a<=>$b} keys %codeblocks) {
					if ($blerperslot{$slotnum}{SLOT}{$blertype}{$rc}){
						$blerperslot{$slotnum}{SLOT}{$blertype}{$rc} += $codeblocks{$rc};		#Maste gora detta pga endast en slot trace men mojligen 5 RC= tracar, annars skiljer sig pler per slot jamfort med total bler
						$blerperslot{$slotnum}{SLOT}{$blertype2}{$rc} += $codeblocks{$rc};
					}else {
						$blerperslot{$slotnum}{SLOT}{$blertype}{$rc} = $codeblocks{$rc};
						$blerperslot{$slotnum}{SLOT}{$blertype2}{$rc} = $codeblocks{$rc};
					}
					$codeblocks{$rc} = 0;
				}

#				print "STOP: slotno=$slotnum,	$blerperslot{$slotnum}{TOT}\n";
#				print "$_";
#	print "rc=$rc,	slot=$slotnum,	$codeblocks{$rc}	0=$codeblocks{0}	4=$codeblocks{4}	7=$codeblocks{7}\n";
				$numberofcodeblocks = 0;
			}
			if (/cbgCrcInfo=(\d+) cbgValidBitmap=(\d+)/){
				$cbgcrcinfo = $1;
				$cbgvalidbitmap = $2;
			}
			if (/isAck=(\d+)/){
				$isack = $1;
				$harqresult = $isack;
				if ($isack == 1){
					if (exists $harqacknack{SLOT_ACK}{$slotnum}){
						$harqacknack{SLOT_ACK}{$slotnum}++;
					}else{
						$harqacknack{SLOT_ACK}{$slotnum} = 1;
					}
					if (exists $harqacknack{TOT_ACK}){
						$harqacknack{TOT_ACK}++;
					}else{
						$harqacknack{TOT_ACK} = 1;
					}
				}else{
					if (exists $harqacknack{SLOT_NACK}{$slotnum}){
						$harqacknack{SLOT_NACK}{$slotnum}++;
					}else{
						$harqacknack{SLOT_NACK}{$slotnum} = 1;
					}
					if (exists $harqacknack{TOT_NACK}){
						$harqacknack{TOT_NACK}++;
					}else{
						$harqacknack{TOT_NACK} = 1;
					}
				}
				if (exists $harqacknack{SLOT_TOT}{$slotnum}){
					$harqacknack{SLOT_TOT}{$slotnum}++;
				}else{
					$harqacknack{SLOT_TOT}{$slotnum} = 1;
				}
				if (exists $harqacknack{TOT}){
					$harqacknack{TOT}++;
				}else{
					$harqacknack{TOT} = 1;
				}
			}
			if (/ulHarqProcId=(\d+) puschPerAntRxPsdAvg=(-*\d+) puschTotalRxPsdAvg=(-*\d+)/) {
				$ulharqprocid = $1;
				$puschperantrxpsavg = $2;
				$puschtotalrxpsavg = $3;
			}
			if (/postEqSinr=(-*\d+)/){
				$posteqsinr = $1;
			}
			if (/postEqSinr0=(-*\d+) postEqSinr1=(-*\d+)/){
				$posteqsinr0 = $1;
				$posteqsinr1 = $2;
			}
  			if (/isDtx=(\d+) timingOffsetReport=(\d+) sesType=(\d+)/){
				$isdtx = $1;
				$timingOffsetReport = $2;
				$sestype = $3;
			}
			if (/crnti=(\d+)/){
				$crnti = $1;
			}
			if (exists $ULL1COMMONNR29{SLOTNUM}{$slotnum}) {
				$ULL1COMMONNR29{SLOTNUM}{$slotnum}++;
			}else{
				$ULL1COMMONNR29{SLOTNUM}{$slotnum}=1;
			}
			if (exists $ULL1COMMONNR29{ISPUSCHFBVALID}{$ispuschfbvalid}) {
				$ULL1COMMONNR29{ISPUSCHFBVALID}{$ispuschfbvalid}++;
			}else{
				$ULL1COMMONNR29{ISPUSCHFBVALID}{$ispuschfbvalid}=1;
			}
			if (defined $cbgcrcinfo) {
				if (exists $ULL1COMMONNR29{CBCCRCINFO}{$cbgcrcinfo}) {
					$ULL1COMMONNR29{CBCCRCINFO}{$cbgcrcinfo}++;
				}else{
					$ULL1COMMONNR29{CBCCRCINFO}{$cbgcrcinfo}=1;
				}
			}
			if (exists $ULL1COMMONNR29{ISACK}{$isack}) {
				$ULL1COMMONNR29{ISACK}{$isack}++;
			}else{
				$ULL1COMMONNR29{ISACK}{$isack}=1;
			}
			if (exists $ULL1COMMONNR29{ULHARQPROCID}{$ulharqprocid}) {
				$ULL1COMMONNR29{ULHARQPROCID}{$ulharqprocid}++;
			}else{
				$ULL1COMMONNR29{ULHARQPROCID}{$ulharqprocid}=1;
			}
			if (exists $ULL1COMMONNR29{PUSCHPERANTRXPSAVG}{$puschperantrxpsavg}) {
				$ULL1COMMONNR29{PUSCHPERANTRXPSAVG}{$puschperantrxpsavg}++;
			}else{
				$ULL1COMMONNR29{PUSCHPERANTRXPSAVG}{$puschperantrxpsavg}=1;
			}
			if (exists $ULL1COMMONNR29{PUSCHTOTALRXPSAVG}{$puschtotalrxpsavg}) {
				$ULL1COMMONNR29{PUSCHTOTALRXPSAVG}{$puschtotalrxpsavg}++;
			}else{
				$ULL1COMMONNR29{PUSCHTOTALRXPSAVG}{$puschtotalrxpsavg}=1;
			}
			if (defined $posteqsinr) {
				if (exists $ULL1COMMONNR29{POSTEQSINR}{$posteqsinr}) {
					$ULL1COMMONNR29{POSTEQSINR}{$posteqsinr}++;
				}else{
					$ULL1COMMONNR29{POSTEQSINR}{$posteqsinr}=1;
				}
			}
			if (exists $ULL1COMMONNR29{POSTEQSINR0}{$posteqsinr0}) {
				$ULL1COMMONNR29{POSTEQSINR0}{$posteqsinr0}++;
			}else{
				$ULL1COMMONNR29{POSTEQSINR0}{$posteqsinr0}=1;
			}
			if (exists $ULL1COMMONNR29{POSTEQSINR1}{$posteqsinr1}) {
				$ULL1COMMONNR29{POSTEQSINR1}{$posteqsinr1}++;
			}else{
				$ULL1COMMONNR29{POSTEQSINR1}{$posteqsinr1}=1;
			}
			if (exists $ULL1COMMONNR29{ISDTX}{$isdtx}) {
				$ULL1COMMONNR29{ISDTX}{$isdtx}++;
			}else{
				$ULL1COMMONNR29{ISDTX}{$isdtx}=1;
			}
			if (exists $ULL1COMMONNR29{TIMINGOFFSETREPORT}{$timingOffsetReport}) {
				$ULL1COMMONNR29{TIMINGOFFSETREPORT}{$timingOffsetReport}++;
			}else{
				$ULL1COMMONNR29{TIMINGOFFSETREPORT}{$timingOffsetReport}=1;
			}
			if (exists $ULL1COMMONNR29{SESTYPE}{$sestype}) {
				$ULL1COMMONNR29{SESTYPE}{$sestype}++;
			}else{
				$ULL1COMMONNR29{SESTYPE}{$sestype}=1;
			}

			if ($bbueref < 200000) {		# Exclude bbUeRefs used in Random Access Procedure
				if (! defined $blerperue{$bbueref} ) {
					$blerperue{$bbueref}{power}{MIN} = 20000;
					$blerperue{$bbueref}{power}{MAX} = -20000;
					$blerperue{$bbueref}{power}{SUM} = 0;
					$blerperue{$bbueref}{power}{NUM} = 0;
					$blerperue{$bbueref}{rc}{real_data}{0} = 0;
					$blerperue{$bbueref}{rc}{real_data}{5} = 0;
					$blerperue{$bbueref}{rc}{real_data}{6} = 0;
					$blerperue{$bbueref}{rc}{real_data}{7} = 0;
					$blerperue{$bbueref}{rc}{empty_data}{4} = 0;
					$blerperue{$bbueref}{rc}{empty_data}{7} = 0;
					$blerperue{$bbueref}{rc}{padding}{0} = 0;
					$blerperue{$bbueref}{rc}{padding}{7} = 0;
					$blerperue{$bbueref}{rc}{short_bsr}{0} = 0;
					$blerperue{$bbueref}{bad} = 0;
					$blerperue{$bbueref}{good} = 0;
					$blerperue{$bbueref}{good} = 0;
				}
				my ($urk) = $timestamp =~ /\[\d+-\d+-\d+ (.+)\]/;
				if ($puschtotalrxpsavg > -1400) {
					$blerperue{$bbueref}{good}++;
#					print "DEBUG1: bbueref=$bbueref,	rc=$rc,	type=$blertype,	A=$bler{$blertype}{$rc},	B=$blerperue{$bbueref}{rc}{$blertype}{$rc}\n";
					$blerperue{$bbueref}{rc2}{$blertype}{$rc} = $bler{$blertype}{$rc} - $blerperue{$bbueref}{rc}{$blertype}{$rc};
#					$blerperue{$bbueref}{rc}{$blertype}{$rc} = $bler{$blertype}{$rc};
#					print "DEBUG2: bbueref=$bbueref,	rc=$rc,	type=$blertype,	A=$bler{$blertype}{$rc},	B=$blerperue{$bbueref}{rc}{$blertype}{$rc}\n";
					print "Debuginfo: BLER per UE:	rc1=$blerperue{$bbueref}{rc}{$blertype}{$rc}	rc2=$blerperue{$bbueref}{rc2}{$blertype}{$rc} \n" if (defined $debug);
				}else {
					$blerperue{$bbueref}{bad}++;
				}
				$blerperue{$bbueref}{crnti}{$crnti} = $crnti;

				$blerperue{$bbueref}{power}{MIN} = $puschtotalrxpsavg if ($puschtotalrxpsavg < $blerperue{$bbueref}{power}{MIN});
				$blerperue{$bbueref}{power}{MAX} = $puschtotalrxpsavg if ($blerperue{$bbueref}{power}{MAX});
				$blerperue{$bbueref}{power}{SUM} += $puschtotalrxpsavg;
				$blerperue{$bbueref}{power}{NUM} += 1;
				$blerperue{$bbueref}{power}{AVG} = $blerperue{$bbueref}{power}{SUM} / $blerperue{$bbueref}{power}{NUM};

				$rxpower{MIN} = $puschtotalrxpsavg if ($puschtotalrxpsavg < $rxpower{MIN});
				$rxpower{MAX} = $puschtotalrxpsavg if ($puschtotalrxpsavg > $rxpower{MAX});
				$rxpower{SUM} += $puschtotalrxpsavg;
				$rxpower{NUM} += 1;
				$rxpower{AVG} = $rxpower{SUM} / $rxpower{NUM};
#				$rxpower{AVG} = -1400 if $rxpower{AVG} < 1;
				
				$puschtotalrxpsavg = abs($puschtotalrxpsavg);

				my $bin =  int($puschtotalrxpsavg / $power_bucket_width) * $power_bucket_width;
				if ($bin < 1400){
					$bin = $bin . "-" . ($bin+$power_bucket_width);
				} 
				if (exists $rxpowerbucket{$bin}) {
					$rxpowerbucket{$bin}++;
				}else{
					$rxpowerbucket{$bin} = 1;
				}
				if (exists $blerperue{$bbueref}{powerbucket}{$bin}) {
					$blerperue{$bbueref}{powerbucket}{$bin}++;
				}else{
					$blerperue{$bbueref}{powerbucket}{$bin} = 1;
				}

			} # end if $bbueref < 200000
		}
#[2018-12-06 12:41:18.225176] 0xe164be08=(bfn:3606, sfn:534, sf:5.00, bf:224) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrmdbfupe_puschcoord_handlenrpuschseallocationind.c:348: <!ULL1MDBFUNR.79!> INFO ULL1NRMDBF_PUSCHCOORD_handleSeAllocInd sigNo=00004c40 bbUeRef=0x00000120 sfn=534 slotNo=11 source=0 allocIndex=6 foundIdleSeTor=
#1 isPltMode=0 bbCellIndex=0 cellId=1 nrOfAntennaPorts=1 nrOfAntennas=2 nrOfClusters=1 prbStart=1 prbLength=2 nrOfRefSymbols=2 symbolMask=16383 qm=4 nPuschId=-1 refSymbolIndex [2 11 0 0] antennaPort [0 0] harqProc=1 crnti=17996 tbSizeInBits=504 rvIdx=0 rInit=868 isFirstTransmission=1 isLastTransmission=1 ulHarqBufferPoo
#lIndex=7 alpha=100 nrOfHarqBits=0 betaOffsetIndexHarq=5 nrOfCsiPart1Bits=0 betaOffsetIndexCsiPart1=0 nrOfCsiPart2Bits [0 0 0 0] betaOffsetIndexCsiPart2=0  
		elsif (/TRIGGERED ABOVE, THIS SHOULD BE REMOVED      nrOfAntennaPorts=(\d+) nrOfAntennas=(\d+) nrOfClusters=(\d+) prbStart=(\d+) prbLength=(\d+) nrOfRefSymbols=(\d+) symbolMask=(\d+) qm=(\d+).+tbSizeInBits=(\d+).+nrOfHarqBits=(\d+).+betaOffsetIndexCsiPart1=(\d+).+betaOffsetIndexCsiPart2=(\d+)/) {
			my $nrofantennaports=$1;
			my $nrofantennas=$2;
			my $nrofclusters=$3;
			my $prbstart=$4;
			my $prblength=$5;
			my $nrofrefsymbols=$6;
			my $symbolmask=$7;
			my $qm=$8;
			my $tbsizeinbits=$9;
			my $nrofharqbits=$10;
			my $betaoffsetindexcsipart1=$11;
			my $betaoffsetindexcsipart2=$12;
			if (exists $ULL1MDBFUNR79{NROFANTENNAPORTS}{$nrofantennaports}) {
				$ULL1MDBFUNR79{NROFANTENNAPORTS}{$nrofantennaports}++;
			}else{
				$ULL1MDBFUNR79{NROFANTENNAPORTS}{$nrofantennaports}=1;
			}
			if (exists $ULL1MDBFUNR79{NROFANTENNAS}{$nrofantennas}) {
				$ULL1MDBFUNR79{NROFANTENNAS}{$nrofantennas}++;
			}else{
				$ULL1MDBFUNR79{NROFANTENNAS}{$nrofantennas}=1;
			}
			if (exists $ULL1MDBFUNR79{NROFCLUSTERS}{$nrofclusters}) {
				$ULL1MDBFUNR79{NROFCLUSTERS}{$nrofclusters}++;
			}else{
				$ULL1MDBFUNR79{NROFCLUSTERS}{$nrofclusters}=1;
			}
			if (exists $ULL1MDBFUNR79{PRBSTART}{$prbstart}) {
				$ULL1MDBFUNR79{PRBSTART}{$prbstart}++;
			}else{
				$ULL1MDBFUNR79{PRBSTART}{$prbstart}=1;
			}
			if (exists $ULL1MDBFUNR79{PRBLENGTH}{$prblength}) {
				$ULL1MDBFUNR79{PRBLENGTH}{$prblength}++;
			}else{
				$ULL1MDBFUNR79{PRBLENGTH}{$prblength}=1;
			}
			if (exists $ULL1MDBFUNR79{NROFREFSYMBOLS}{$nrofrefsymbols}) {
				$ULL1MDBFUNR79{NROFREFSYMBOLS}{$nrofrefsymbols}++;
			}else{
				$ULL1MDBFUNR79{NROFREFSYMBOLS}{$nrofrefsymbols}=1;
			}
			if (exists $ULL1MDBFUNR79{SYMBOLMASK}{$symbolmask}) {
				$ULL1MDBFUNR79{SYMBOLMASK}{$symbolmask}++;
			}else{
				$ULL1MDBFUNR79{SYMBOLMASK}{$symbolmask}=1;
			}
			if (exists $ULL1MDBFUNR79{QM}{$qm}) {
				$ULL1MDBFUNR79{QM}{$qm}++;
			}else{
				$ULL1MDBFUNR79{QM}{$qm}=1;
			}
			if (exists $ULL1MDBFUNR79{TBSIZEINBITS}{$tbsizeinbits}) {
				$ULL1MDBFUNR79{TBSIZEINBITS}{$tbsizeinbits}++;
			}else{
				$ULL1MDBFUNR79{TBSIZEINBITS}{$tbsizeinbits}=1;
			}
			if (exists $ULL1MDBFUNR79{NROFHARQBITS}{$nrofharqbits}) {
				$ULL1MDBFUNR79{NROFHARQBITS}{$nrofharqbits}++;
			}else{
				$ULL1MDBFUNR79{NROFHARQBITS}{$nrofharqbits}=1;
			}
			if (exists $ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART1}{$betaoffsetindexcsipart1}) {
				$ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART1}{$betaoffsetindexcsipart1}++;
			}else{
				$ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART1}{$betaoffsetindexcsipart1}=1;
			}
			if (exists $ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART2}{$betaoffsetindexcsipart2}) {
				$ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART2}{$betaoffsetindexcsipart2}++;
			}else{
				$ULL1MDBFUNR79{BETAOFFSETINDEXCSIPART2}{$betaoffsetindexcsipart2}=1;
			}
		}
#[2018-12-21 13:48:20.121152] 0xb24102db=(bfn:2852, sfn:804, sf:1.07, bf:45) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_handle_se_alloc.c:796: <!ULL1COMMONNR.156!> INFO PUSCHSES: demux precalc alpha=100 firstRsSym=2 harq
#Beta=40 modOrder=4 nrOfCsi1Bits=0 nrOfDataSymbols=8 nrOfHarqBits=1 nrOfLayers=1 nrOfSc=612 totalNrOfHarqSofts=12 totalNrOfDataSofts=19584 
		elsif (/ULL1COMMONNR\.15.+alpha=(\d+) firstRsSym=(\d+) harqBeta=(\d+) modOrder=(\d+) nrOfCsi1Bits=(\d+) nrOfDataSymbols=(\d+) nrOfHarqBits=(\d+) nrOfLayers=(\d+) nrOfSc=(\d+) totalNrOfHarqSofts=(\d+) totalNrOfDataSofts=(\d+)/) {
			my $alpha = $1;		
			my $firstrssym = $2;
			my $harqbeta = $3;
			my $modorder = $4;
			my $nrofcsi1bits = $5;
			my $nrofdatasymbols = $6;
			my $nrofharqbits = $7;
			my $nroflayers = $8;
			my $nrofsc = $9;
			my $totalnrofharqslots = $10;
			my $totalnrofdataslots = $11;
			if (exists $ULL1COMMONNR15{ALPHA}{$alpha}) {
				$ULL1COMMONNR15{ALPHA}{$alpha}++;
			}else{
				$ULL1COMMONNR15{ALPHA}{$alpha}=1;
			}
			if (exists $ULL1COMMONNR15{FIRSTRSSYM}{$firstrssym}) {
				$ULL1COMMONNR15{FIRSTRSSYM}{$firstrssym}++;
			}else{
				$ULL1COMMONNR15{FIRSTRSSYM}{$firstrssym}=1;
			}
			if (exists $ULL1COMMONNR15{HARQBETA}{$harqbeta}) {
				$ULL1COMMONNR15{HARQBETA}{$harqbeta}++;
			}else{
				$ULL1COMMONNR15{HARQBETA}{$harqbeta}=1;
			}
			if (exists $ULL1COMMONNR15{MODORDER}{$modorder}) {
				$ULL1COMMONNR15{MODORDER}{$modorder}++;
			}else{
				$ULL1COMMONNR15{MODORDER}{$modorder}=1;
			}
			if (exists $ULL1COMMONNR15{NROFCSI1BITS}{$nrofcsi1bits}) {
				$ULL1COMMONNR15{NROFCSI1BITS}{$nrofcsi1bits}++;
			}else{
				$ULL1COMMONNR15{NROFCSI1BITS}{$nrofcsi1bits}=1;
			}
			if (exists $ULL1COMMONNR15{NROFDATASYMBOLS}{$nrofdatasymbols}) {
				$ULL1COMMONNR15{NROFDATASYMBOLS}{$nrofdatasymbols}++;
			}else{
				$ULL1COMMONNR15{NROFDATASYMBOLS}{$nrofdatasymbols}=1;
			}
			if (exists $ULL1COMMONNR15{NROFHARQBITS}{$nrofharqbits}) {
				$ULL1COMMONNR15{NROFHARQBITS}{$nrofharqbits}++;
			}else{
				$ULL1COMMONNR15{NROFHARQBITS}{$nrofharqbits}=1;
			}
			if (exists $ULL1COMMONNR15{NROFLAYERS}{$nroflayers}) {
				$ULL1COMMONNR15{NROFLAYERS}{$nroflayers}++;
			}else{
				$ULL1COMMONNR15{NROFLAYERS}{$nroflayers}=1;
			}
			if (exists $ULL1COMMONNR15{NROFSC}{$nrofsc}) {
				$ULL1COMMONNR15{NROFSC}{$nrofsc}++;
			}else{
				$ULL1COMMONNR15{NROFSC}{$nrofsc}=1;
			}
			if (exists $ULL1COMMONNR15{TOTALNROFHARQSLOTS}{$totalnrofharqslots}) {
				$ULL1COMMONNR15{TOTALNROFHARQSLOTS}{$totalnrofharqslots}++;
			}else{
				$ULL1COMMONNR15{TOTALNROFHARQSLOTS}{$totalnrofharqslots}=1;
			}
			if (exists $ULL1COMMONNR15{TOTALNROFDATASLOTS}{$totalnrofdataslots}) {
				$ULL1COMMONNR15{TOTALNROFDATASLOTS}{$totalnrofdataslots}++;
			}else{
				$ULL1COMMONNR15{TOTALNROFDATASLOTS}{$totalnrofdataslots}=1;
			}
		}
#[2018-12-21 13:48:20.121163] 0xb2410590=(bfn:2852, sfn:804, sf:1.07, bf:89) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_handle_se_alloc.c:834: <!ULL1COMMONNR.12!> INFO tbSizeWithCrc=8216 nrOfFillerBits=232 baseGraph=1 nr
#OfCodeBlocks=1 config_id=1 zc=384 k0Adjusted=0 circBufLen=25112 nrOfDataREs=4896  
		elsif (/ULL1COMMONNR\.12.+nrOfCodeBlocks=(\d+) config_id=(\d+) zc=(\d+) k0Adjusted=(\d+) circBufLen=(\d+) nrOfDataREs=(\d+)/) {
			my $nrofcodeblocks = $1;
			my $configid = $2;
			my $sz = $3;
			my $k0adjested = $4;
			my $circbuflen = $5;
			my $nrofdatares = $6;
			if (exists $ULL1COMMONNR12{NROFCODEBLOCKS}{$nrofcodeblocks}) {
				$ULL1COMMONNR12{NROFCODEBLOCKS}{$nrofcodeblocks}++;
			}else{
				$ULL1COMMONNR12{NROFCODEBLOCKS}{$nrofcodeblocks}=1;
			}
			if (exists $ULL1COMMONNR12{CONFIGID}{$configid}) {
				$ULL1COMMONNR12{CONFIGID}{$configid}++;
			}else{
				$ULL1COMMONNR12{CONFIGID}{$configid}=1;
			}
			if (exists $ULL1COMMONNR12{K0ADJUSTED}{$k0adjested}) {
				$ULL1COMMONNR12{K0ADJUSTED}{$k0adjested}++;
			}else{
				$ULL1COMMONNR12{K0ADJUSTED}{$k0adjested}=1;
			}
			if (exists $ULL1COMMONNR12{CIRBUFLEN}{$circbuflen}) {
				$ULL1COMMONNR12{CIRBUFLEN}{$circbuflen}++;
			}else{
				$ULL1COMMONNR12{CIRBUFLEN}{$circbuflen}=1;
			}
			if (exists $ULL1COMMONNR12{NROFDATARES}{$nrofdatares}) {
				$ULL1COMMONNR12{NROFDATARES}{$nrofdatares}++;
			}else{
				$ULL1COMMONNR12{NROFDATARES}{$nrofdatares}=1;
			}
		}
#[2018-12-21 13:48:20.122159] 0xb241f4a4=(bfn:2852, sfn:804, sf:2.07, bf:74) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_handle_dl_harq.c:231: <!ULL1COMMONNR.65!> INFO Sending PUSCH_HARQ_RPT2_DL_IND: cellId: 1 bbUeRef 256
# crnti 17954 sfn 804 slotNo 3 noOfHarqFeedbacks 1 harqFeedback 0 0 0 harqProcId 65535 65535 65535 isSupportedNrOfHarqBits 1 
		elsif (/ULL1COMMONNR\.65.+slotNo (\d+) noOfHarqFeedbacks (\d+).+isSupportedNrOfHarqBits (\d+)/) {
			my $slotno = $1;
			my $noofharqfeedbacks = $2;
			my $issupportednrofharqbits = $3;
			if (exists $ULL1COMMONNR65{SLOTNO}{$slotno}) {
				$ULL1COMMONNR65{SLOTNO}{$slotno}++;
			}else{
				$ULL1COMMONNR65{SLOTNO}{$slotno}=1;
			}
			if (exists $ULL1COMMONNR65{NOOFHARQFEEDBACKS}{$noofharqfeedbacks}) {
				$ULL1COMMONNR65{NOOFHARQFEEDBACKS}{$noofharqfeedbacks}++;
			}else{
				$ULL1COMMONNR65{NOOFHARQFEEDBACKS}{$noofharqfeedbacks}=1;
			}
			if (exists $ULL1COMMONNR65{ISUPPORTEDNOOFHARGBITS}{$issupportednrofharqbits}) {
				$ULL1COMMONNR65{ISUPPORTEDNOOFHARGBITS}{$issupportednrofharqbits}++;
			}else{
				$ULL1COMMONNR65{ISUPPORTEDNOOFHARGBITS}{$issupportednrofharqbits}=1;
			}
		}
		
		if ($sec != $oldsec){
			clear_screen();
			print $DEBUGSTRING if (defined $debug);
#			sleep(0.1);
			my $epoctime = getTime(($date,$time));
			if (! defined $time{FIRSTEPOC}){
				$time{FIRSTEPOC} = $epoctime;
				$time{FIRSTREALTIME} = $timestamp;
			}
			$time{LASTEPOC}=$epoctime;
			$time{LASTREALTIME} = $timestamp;
			
			foreach my $ue (sort keys %uehealth) {
				if ($uehealth{$ue}{status} =~ /ALIVE/){
					if ($epoctime - $uehealth{$ue}{lastseen} > 10) {		# Needs to be set to 10 to avoid false dead UEs due to last traces
						$uehealth{$ue}{status} = 'DEAD';
						delete $blerperueCOUNTER{$ue};
#					print "$ue is $uehealth{$ue}{status},	now=$epoctime	lastseen=$uehealth{$ue}{lastseen}	uehealth=" . %uehealth ."	blerperue=" .%blerperue."\n";
					}
				}
			}

			if (defined $graph) {
				print "db=$db,	db2=$db2\n";
#				`rrdtool update $RRDDataDirectory$RRDDataFile --template data0 $epoctime:$bler{data}{0}`;
#				`rrdtool update $RRDDataDirectory$RRDDataFile $epoctime:$bler{data}{0}`;
#				`rrdtool update $RRDDataDirectory$RRDDataFile N:$bler{data}{0}`;
				my $a=`rrdtool update $db --template data0:data1:data2:data3:data4:data5:data6:data7:padding0:padding1:padding2:padding3:padding4:padding5:padding6:padding7:empty0:empty1:empty2:empty3:empty4:empty5:empty6:empty7:shortbsr0:shortbsr1:shortbsr2:shortbsr3:shortbsr4:shortbsr5:shortbsr6:shortbsr7:longbsr0:longbsr1:longbsr2:longbsr3:longbsr4:longbsr5:longbsr6:longbsr7 $epoctime:$bler{real_data}{0}:$bler{real_data}{1}:$bler{real_data}{2}:$bler{real_data}{3}:$bler{real_data}{4}:$bler{real_data}{5}:$bler{real_data}{6}:$bler{real_data}{7}:$bler{padding}{0}:$bler{padding}{1}:$bler{padding}{2}:$bler{padding}{3}:$bler{padding}{4}:$bler{padding}{5}:$bler{padding}{6}:$bler{padding}{7}:$bler{empty_data}{0}:$bler{empty_data}{1}:$bler{empty_data}{2}:$bler{empty_data}{3}:$bler{empty_data}{4}:$bler{empty_data}{5}:$bler{empty_data}{6}:$bler{empty_data}{7}:$bler{short_bsr}{0}:$bler{short_bsr}{1}:$bler{short_bsr}{2}:$bler{short_bsr}{3}:$bler{short_bsr}{4}:$bler{short_bsr}{5}:$bler{short_bsr}{6}:$bler{short_bsr}{7}:$bler{long_bsr}{0}:$bler{long_bsr}{1}:$bler{long_bsr}{2}:$bler{long_bsr}{3}:$bler{long_bsr}{4}:$bler{long_bsr}{5}:$bler{long_bsr}{6}:$bler{long_bsr}{7}`;
				my $b=`rrdtool update $db2 --template rxpowermin:rxpowermax:rxpoweravg:rxpowersum:rxpowernum $epoctime:$rxpower{MIN}:$rxpower{MAX}:$rxpower{AVG}:$rxpower{SUM}:$rxpower{NUM}`;
#				print "a=$a\n";
#				print "b=$b\n";
			}
			if (defined $excel) {
				$sheets{1}->write( "A$row",$epoctime,$writeformat);
#				$sheets{1}->write( "B$row",$bler{total}{real_data_c}{0},$writeformat);
#				$sheets{1}->write( "D$row",$bler{total}{real_data_c}{2},$writeformat);
#				$sheets{1}->write( "E$row",$bler{total}{real_data_c}{3},$writeformat);
#				$sheets{1}->write( "F$row",$bler{total}{real_data_c}{5},$writeformat);
#				$sheets{1}->write( "G$row",$bler{total}{real_data_c}{6},$writeformat);
#				$sheets{1}->write( "H$row",$bler{total}{real_data_c}{7},$writeformat);
#				$sheets{1}->write( "I$row",$bler{total}{empty_data_c}{4},$writeformat);
#				$sheets{1}->write( "J$row",$bler{total}{empty_data_c}{7},$writeformat);
#				$sheets{1}->write( "K$row",$bler{total}{padding_c}{0},$writeformat);
#				$sheets{1}->write( "L$row",$bler{total}{padding_c}{7},$writeformat);

				$sheets{2}->write( "A$row",$epoctime,$writeformat);

				$sheets{3}->write( "A$row",$epoctime,$writeformat);
				$sheets{3}->write( "B$row",$rxpower{MIN},$writeformat);
				$sheets{3}->write( "C$row",$rxpower{MAX},$writeformat);
				$rxpower{AVG} = -1400 if ($rxpower{AVG} == 0);
				$sheets{3}->write( "D$row",$rxpower{AVG},$writeformat);
				$sheets{3}->write( "E$row",$rxpower{NUM},$writeformat);
				$sheets{3}->write( "F$row",$rxpower{SUM},$writeformat);

				$sheets{4}->write( "A$row",$epoctime,$writeformat);

				$sheets{5}->write( "A$row",$epoctime,$writeformat);
				$sheets{5}->write( "B$row",($tbsize{TOTDELTA}/1000),$writeformat);

				$row++;
			} # if defined $excel

			print  "Time:	$epoctime	$date $time		(ul_bler.pl v$ul_bler_version)\n";
			$oldsec = $sec;
  			print "Last MSG3 found at : $lastmsg{MSG3},	Last PADDING found at : $lastmsg{PADDING},	Last SHORT BSR found at : $lastmsg{SHORTBSR},	Last DATA found at : $lastmsg{DATA}\n";
			print "\n\n";

			print "L1 PUSCH frames distribution:\n";
			foreach my $type (sort keys %{$bler{total}}) {
				if ($type !~ /_c$/){
					print "	$type\n";
					foreach my $rc (sort keys %{$bler{total}{$type}}) {
						if ($bler{total}{$type}{$rc} > 0) {
							printf ("		$rc = %5d	::	$bler{total}{$type}{$rc} / $sum = %.2f %%\n" , $bler{total}{$type}{$rc}, $bler{total}{$type}{$rc}/$sum*100);
						}
					}
				}
			}

			print "\n\nUL Bler per slot:\n";
			my $startpos = 'Q';
			foreach my $slot (sort {$a<=>$b} keys %blerperslot) {
				print "	$slot";
				if ($slot  =~ /\d+/){
					my $taljare = $blerperslot{$slot}{SLOT}{real_data}{7}+$blerperslot{$slot}{SLOT}{real_data}{4}+$blerperslot{$slot}{SLOT}{empty_data}{7}+$blerperslot{$slot}{SLOT}{padding}{7}+$blerperslot{$slot}{SLOT}{short_bsr}{7};
					my $namnare = $blerperslot{$slot}{TOT};
					my $ulbler = 0;
					if ($namnare > 0) {
						$ulbler = $taljare/$namnare*100;
					}
					printf ("			$taljare / $namnare = %.2f %%\n" , $ulbler);
					if (defined $excel) {
						if ((keys %blerperue) > 0){
							$sheets{1}->write( "$startpos$row",$ulbler,$writeformat);
						}else{
							$sheets{1}->write( "$startpos$row","NO_DATA",$writeformat_noue); #yellow colour for initial garbage
						}
						$startpos++;
					}

				}
			}

			print "\n\nUL HARQ NACK ratio per slot:\n";
			foreach my $slot (sort {$a<=>$b} keys %{$harqacknack{SLOT_TOT}}) {
				if ($harqacknack{SLOT_TOT}{$slot} > 0){
					printf ("	$slot			$harqacknack{SLOT_NACK}{$slot}/$harqacknack{SLOT_TOT}{$slot} = %.2f %%\n", ($harqacknack{SLOT_NACK}{$slot}/$harqacknack{SLOT_TOT}{$slot}*100));
				}
			}
			
			print "\n\nUL Bler per codeblock:\n";
			my $startpos = 'X';
			foreach my $block (sort {$a<=>$b} keys %blerpercodeblock) {
				print "	$block";
				if ($block  =~ /\d+/){
					my $taljare = $blerpercodeblock{$block}{real_data}{7}+$blerpercodeblock{$block}{real_data}{4}+$blerpercodeblock{$block}{empty_data}{7}+$blerpercodeblock{$block}{padding}{7}+$blerpercodeblock{$block}{short_bsr}{7};
					my $namnare = $blerpercodeblock{$block}{real_data}{0}+$blerpercodeblock{$block}{padding}{0}+$blerpercodeblock{$block}{short_bsr}{0} + $taljare;
					$namnare = 1 if ($namnare == 0);
					my $ulbler = $taljare/$namnare*100;
					printf ("			$taljare / $namnare = %.2f %%\n" , $ulbler);
					if (defined $excel) {
						if ((keys %blerperue) > 0){
							$sheets{1}->write( "$startpos$row",$ulbler,$writeformat);
						}else{
							$sheets{1}->write( "$startpos$row","NO_DATA",$writeformat_noue); #This ignores initial garbage
						}
						$startpos++;
						if ($startpos == 'Z'){
							$startpos='AA';
						}
					}

				}
			}

#			if (exists $SECOUNT) {
				print "\n\nUL HARQ NACK ratio per number of scheduling entities (experimental):\n";
				my $startpos = 'X';
				foreach my $count (sort {$a<=>$b} keys %SECOUNT) {
					if (exists $SECOUNT{$count}{NACK}) {
						print "	$count";
						my $ulbler = $SECOUNT{$count}{NACK} / $SECOUNT{$count}{TOT} * 100;
						printf ("			$SECOUNT{$count}{NACK} / $SECOUNT{$count}{TOT} = %.2f %%\n" , $ulbler);
#						if (defined $excel) {
#							if ((keys %blerperue) > 0){
#								$sheets{1}->write( "$startpos$row",$ulbler,$writeformat);
#							}else{
#								$sheets{1}->write( "$startpos$row","NO_DATA",$writeformat_noue); #This ignores initial garbage
#							}
#							$startpos++;
#							if ($startpos == 'Z'){
#								$startpos='AA';
#							}
#						}
					}
				}
#			}
			if ($sum > 0) {
				my $ues = (keys %blerperueCOUNTER);
				print "\nNumber of UEs = $ues";
				print "\		Total HARQ NACK ratio: ";
				if ($harqacknack{TOT} > 0){
					printf ("%.2f%", ($harqacknack{TOT_NACK}/$harqacknack{TOT}*100));
				}
				printf ("	Total BLER = %.2f %%" , ($bler{total}{real_data}{7}+$bler{total}{real_data}{4}+$bler{total}{empty_data}{7}+$bler{total}{padding}{7}+$bler{total}{short_bsr}{7})/$sum*100);
				print "		Total UL L1 tpt = " . ($tbsize{TOTDELTA}/1000) . " kBits/s";

				if (defined $excel) {
					if (defined $ues){
						$sheets{1}->write( "V$row",$ues,$writeformat);
					}
#					if ((keys %blerperue) > 0){
						my $totalulbler = sprintf("%.2f",($bler{total}{real_data}{7}+$bler{total}{real_data}{4}+$bler{total}{empty_data}{7}+$bler{total}{padding}{7})/$sum*100);
						my $momentanulbler = 'NO_DATA';
						if ($momentansum > 0) {
							$momentanulbler = sprintf("%.2f",($bler{momentan}{real_data}{7}+$bler{momentan}{real_data}{4}+$bler{momentan}{empty_data}{7}+$bler{momentan}{padding}{7})/$momentansum*100);
							$sheets{1}->write( "O$row",$momentanulbler,$writeformat);
							$sheets{1}->write( "N$row",$totalulbler,$writeformat);
						}else{
							$sheets{1}->write( "O$row",$momentanulbler,$writeformat_noue);
							$sheets{1}->write( "N$row","NO_DATA",$writeformat_noue);
						}

#						print "\n\n##### rowa=$row	momentanulbler=$momentanulbler #####\n";

#					}else{
#						$sheets{1}->write( "N$row",0,$writeformat_noue); #This ignores initial garbage
#						$sheets{1}->write( "O$row",0,$writeformat_noue); #This ignores initial garbage
#						print "rowb=$row\n";
#						exit;
#					}
				}
#				print "\momentansum=$momentansum\n";
#				sleep(1);
				$momentansum = 0;
			}
			
			foreach my $type (sort keys %{$bler{momentan}}) {
				foreach my $rc (sort keys %{$bler{momentan}{$type}}) {
					$bler{momentan}{$type}{$rc} = 0;
				}
			}
#			print "##### Cleared monentan hash #####\n\n\n\n\n\n\n\n\n";
#			sleep(1);
			
			$rxpower{AVG} = $rxpower{SUM} / $rxpower{NUM} if ($rxpower{NUM} > 0);
			
			print "\n\nReceived UL Power during last second\n";
			foreach my $type (sort keys %rxpower) {
				if ($type !~ /SUM|NUM/){
					printf ("	$type:	%5d," , $rxpower{$type});
				}
			}
			if (defined $excel) {
				my $cola = "C";
				foreach my $bbueref (sort {$a<=>$b} keys %blerperue) {
					$sheets{4}->write( "$cola$row",$blerperue{$bbueref}{power}{AVG},$writeformat);
					$cola++;
				}
			}

			print "\n\nReceived UL Power distribution from beginning of log\n";
			foreach my $bucket (sort {$a<=>$b} keys %rxpowerbucket) {
				printf ("	$bucket: [%d]," , $rxpowerbucket{$bucket});
			}

			print "\n\nBSR buffersize indices\n";
#			foreach my $lgcid (sort keys %{$buffersize{LGCID}}) {
#				printf ("	LGCID %d:%d,	" , $lgcid,$buffersize{LGCID}{$lgcid});
#			}
			foreach my $index (sort keys %buffersize) {
				printf ("	LGCID %d - BSR index %d:%d,	" , ($buffersize{$index} & 224 )>> 5, (hex($index) & 31),$buffersize{$index});
			}

			print "\n\nTimingOffsetReports\n";
			foreach my $offset (sort keys %{$ULL1COMMONNR29{TIMINGOFFSETREPORT}}) {
				print "	$offset:$ULL1COMMONNR29{TIMINGOFFSETREPORT}{$offset}";
			}
			print "\n\nDTX info\n";
			foreach my $isdtx (sort keys %{$ULL1COMMONNR29{ISDTX}}) {
				print "	$isdtx:$ULL1COMMONNR29{TIMINGOFFSETREPORT}{$isdtx}";
			}

			if (defined $complete) {
				print_hash_of_hashes(\%ULL1COMMONNR15,"ULL1COMMONNR.15");
				print_hash_of_hashes(\%ULL1COMMONNR12,"ULL1COMMONNR.12");
				print_hash_of_hashes(\%ULL1COMMONNR29,"ULL1COMMONNR.29");
				print_hash_of_hashes(\%ULL1COMMONNR65,"ULL1COMMONNR.65");
				print_hash_of_hashes(\%ULL1MDBFUNR79,"ULL1MDBFUNR.79");
			}			
			print "\n\n";

			my $col = "C";
			foreach my $ue (sort {$a<=>$b} keys %{$tbsize{UEDELTA}}) {
				if ($ue < 20000){
					my $tpt = $tbsize{UEDELTA}{$ue}/1000;
#					print "$ue:		$tpt kBits/s";
					if (defined $excel) {
						$sheets{5}->write( "$col$row",$tpt,$writeformat);
					}
				}
				$col++;
			}

			if (defined $ue) {
				my $cola = "C";
				foreach my $bbueref (sort {$a<=>$b} keys %blerperue) {
					print "UE:$blerperue{$bbueref}{ueno}	bbUeRef:$bbueref	crnti:";
					foreach my $crnti (sort keys %{$blerperue{$bbueref}{crnti}}){
						print "$crnti,	";
						if (exists $crntitable{$crnti}{UE}){
							print "MSG3_crnti = $crntitable{$crnti}{MSG3},	";
#							print "UE_crnti = $crntitable{$crnti}{UE},	";
							print "TempbbUeref = $crntitable{$crnti}{TEMPBBUEREF}";
						}
					}

					my $taljare = $blerperue{$bbueref}{rc}{real_data}{7}+$blerperue{$bbueref}{padding}{7}+$blerperue{$bbueref}{rc}{short_bsr}{7}+$blerperue{$bbueref}{rc}{padding}{7}+$blerperue{$bbueref}{rc}{empty}{4}+$blerperue{$bbueref}{rc}{empty}{7};
					my $namnare = $blerperue{$bbueref}{rc}{real_data}{0}+$blerperue{$bbueref}{padding}{0}+$blerperue{$bbueref}{rc}{short_bsr}{0}+$blerperue{$bbueref}{rc}{padding}{0} + $taljare;
					my $ulbler = 0;
					if ($namnare > 0) {
						$ulbler = sprintf("%.2f", ($taljare / $namnare * 100));
					}
					$blerperue{$bbueref}{ulbler} = sprintf("%.2f",$ulbler);
					printf ("	UL BLER = %.2f%",$ulbler);
					if (defined $excel) {
						$sheets{2}->write( "$cola$row",$ulbler,$writeformat);
						$cola++;
#						print "\nbbueref=$bbueref,	cola=$cola,	row=$row,	ulbler=$ulbler\n";
					}
										
					my $tpt = $tbsize{UEDELTA}{$bbueref}/1000;
					$blerperue{$bbueref}{tpt} = $tpt;
					printf ("	UL L1 tpt = %.2f kBits/s", $tpt);

#					$blerperue{$bbueref}{crnti}{$crnti} = $crnti;
					print "\n";
					if ($blerperue{$bbueref}{good} > 0 ) {
						if (defined $details) {
							foreach my $type (sort keys %{$blerperue{$bbueref}{rc}}) {
								print "		$type\n";
								foreach my $rc (sort keys %{$blerperue{$bbueref}{rc}{$type}}) {
									if (defined $blerperue{$bbueref}{rc}{$type}{$rc} and $blerperue{$bbueref}{rc}{$type}{$rc} > 0) {
										my $taljare = $blerperue{$bbueref}{rc}{$type}{$rc};
										my $namnare = $blerperue{$bbueref}{sum};
										my $ulbler = $taljare/$namnare*100;
										printf ("			$rc = %5d	::	$taljare / $namnare = %.2f %%\n" , $blerperue{$bbueref}{rc}{$type}{$rc}, $ulbler);
									}
								}
							}
						}
					} # good > 0
					print "	Received UL Power per UE\n";
					foreach my $type (sort keys %{$blerperue{$bbueref}{power}}) {
						if ($type !~ /SUM|NUM/){
							printf ("		$type = %.2d" , $blerperue{$bbueref}{power}{$type});
						}
					}
					print "\n";
					foreach my $bucket (sort keys %{$blerperue{$bbueref}{powerbucket}}) {
						printf ("		$bucket = [%.2d]" , $blerperue{$bbueref}{powerbucket}{$bucket});
					}
					print "\n\n";
					$blerperue{$bbueref}{power}{MAX} = -20000;
					$blerperue{$bbueref}{power}{MIN} = 20000;
					$blerperue{$bbueref}{power}{NUM} = 0;
					$blerperue{$bbueref}{power}{SUM} = 0;
				}
			}
#			undef %buffersize ;

			print "\n";
			$rxpower{MIN} = 0;
			$rxpower{MAX} = -20000;
			$rxpower{AVG} = 0;
			$rxpower{SUM} = 0;
			$rxpower{NUM} = 0;
			$tbsize{TOTDELTA} = 0;
			foreach my $ue (sort {$a<=>$b} keys %{$tbsize{UEDELTA}}) {
				$tbsize{UEDELTA}{$ue} = 0;
			}
		} #end if sec!=oldsec
	} # end if timestamp
	elsif (/^NRULMACCI_MAC_CTRL_INFO_IND/){
		$macctrlinfo=1;
		undef $macbbueref;
		undef $msg3crnti;
	}
	if (defined $macctrlinfo){
		if (not defined $macbbueref) {
			if ( /crnti (\d+)/ ) {
				$msg3crnti=$1;
				$crntitable{$msg3crnti}{UE} = $1;
			}
		}else{
			if ( /crnti (\d+)/ ) {
				my $uecrnti = $1;
				$crntitable{$1}{UE} = $uecrnti;
				$crntitable{$1}{MSG3} = $msg3crnti;
				$crntitable{$1}{TEMPBBUEREF} = $macbbueref;
#				print "tempbbueref=$crntitable{$uecrnti}{TEMPBBUEREF},	bbueref=$crntitable{$uecrnti}{BBUEREF},	msg3crnti=$crntitable{$uecrnti}{MSG3},	uecrnti=$crntitable{$uecrnti}{UE}\n";
			}
		}
		
		if (/bbUeRef (\d+)/){
			$macbbueref = $1;
			if (exists $crntitable{$msg3crnti}{TEMPBBUEREF}){
				$crntitable{$msg3crnti}{BBUEREF} = $macbbueref;
			}else{
				$crntitable{$msg3crnti}{TEMPBBUEREF} = $macbbueref;
			}
		}
	}

}
if (defined $graph) {
	print "\nFirst data found at: $time{FIRSTEPOC}	$time{FIRSTREALTIME}\n";
	print "Last data found at: $time{LASTEPOC}	$time{LASTREALTIME}\n";
	`/home/eraaldr/bin/graph_ul_bler.sh -s $time{FIRSTEPOC} -e $time{LASTEPOC} -i $db`;
	print "Graph is stored at: ./ul_bler.png	./ul_rx_pwr.png";
}
if (defined $excel) {
	my $rowa=1;
	my $col="B";
	my $header;
	my $cola = "C";
	foreach my $ueref (sort {$a<=>$b} keys %blerperue) {
		$sheets{5}->write( "$cola$rowa","UE\_$ueref",$writeformat);
		$sheets{4}->write( "$cola$rowa","UE\_$ueref",$writeformat);
		$sheets{2}->write( "$cola$rowa","UE\_$ueref",$writeformat);
		$cola++;
	}

	$workbook->set_properties(
        title    => 'ul_bler spreadsheet',
        author   => 'Mathias Aldrin',
		company	=> 'Ericsson',
        comments => 'Created with ul_bler.pl v$version');

	autofit_columns($sheets{1});
	autofit_columns($sheets{2});
	autofit_columns($sheets{3});
	autofit_columns($sheets{4});
	autofit_columns($sheets{5});

	my $chart1_1     = $workbook->add_chart( type => 'line', embedded => 1 );
	my $chart1_2     = $workbook->add_chart( type => 'line', embedded => 1 );
	my $chart1_3     = $workbook->add_chart( type => 'line', embedded => 1 );

	my $chart1_4     = $workbook->add_chart( type => 'line', embedded => 1 );
	my $chart1_5     = $workbook->add_chart( type => 'line', embedded => 1 );

	my $chart2_1     = $workbook->add_chart( type => 'line', embedded => 1 );
	my $chart3_1     = $workbook->add_chart( type => 'line', embedded => 1 );
	my $chart4_1     = $workbook->add_chart( type => 'line', embedded => 1 );
	my $chart5_1     = $workbook->add_chart( type => 'line', embedded => 1 );
	my $chart5_2     = $workbook->add_chart( type => 'line', embedded => 1 );
 
	my $chart5_3     = $workbook->add_chart( type => 'line', embedded => 1 );
	my $chart5_4     = $workbook->add_chart( type => 'line', embedded => 1 );
	my $chart5_5     = $workbook->add_chart( type => 'line', embedded => 1 );
	my $chart5_6     = $workbook->add_chart( type => 'line', embedded => 1 );
	my $chart5_7     = $workbook->add_chart( type => 'line', embedded => 1 );

	# Configure the first series.
	$chart1_1->add_series(
	    name       => 'UL_BLER',
	    categories => "=Total_UL_BLER!\$A\$2:\$A$\$row",
	    values     => "=Total_UL_BLER!\$N\$2:\$N\$$row",
	);
 
	# Configure the second series.
	$chart1_1->add_series(
	    name	=> 'Number_of_UEs',
	    categories => "=Total_UL_BLER!\$A\$2:\$A$\$row",
	    values     => "=Total_UL_BLER!\$V\$2:\$V\$$row",
	    y2_axis	=> 1,
	);

	my $start = 'Q';
	foreach my $slot (sort {$a<=>$b} keys %blerperslot) {
		if ($slot  =~ /\d+/){
			$chart1_2->add_series(
				name       => "UL BLER per slot $slot",
	    			categories => "=Total_UL_BLER!\$A\$2:\$A$\$row",
				values     => "=Total_UL_BLER!\$$start\$2:\$$start\$$row",
			);
			$start++;
			if ($start eq 'Z'){
				$start = "AA";
			}
		}
	}
	my $start = 'X';
	foreach my $block (sort {$a<=>$b} keys %blerpercodeblock) {
		if ($block  =~ /\d+/){
			$chart1_3->add_series(
				name       => "UL BLER per codeblock $block",
	    			categories => "=Total_UL_BLER!\$A\$2:\$A$\$row",
				values     => "=Total_UL_BLER!\$$start\$2:\$$start\$$row",
			);
			$start++;
			if ($start eq 'Z'){
				$start = "AA";
			}
		}
	}

	$chart1_4->add_series(
	    name	=> 'Momentan UL BLER',
	    categories	=> "=Total_UL_BLER!\$A\$2:\$A$\$row",
	    values	=> "=Total_UL_BLER!\$O\$2:\$O\$$row",
	    min		=> 0,
	    max		=> 20,
	);

	my $start = 'C';
	foreach my $slot (sort {$a<=>$b} keys %blerperue) {
		if ($slot  =~ /\d+/){
			$chart2_1->add_series(
				name       => "UL BLER per UE $slot",
	    			categories => "=UL_BLER_per_UE!\$A\$2:\$A$\$row",
				values     => "=UL_BLER_per_UE!\$$start\$2:\$$start\$$row",
			);
			$start++;
			if ($start eq 'Z'){
				$start = "AA";
			}
		}
	}

	$chart3_1->add_series(
	    name	=> 'Avg Total UL Power',
	    categories => "=Total_UL_Power!\$A\$2:\$A$\$row",
	    values     => "=Total_UL_Power!\$D\$2:\$D\$$row",
	);

#	$chart3_1->add_series(
#	    name	=> 'Min Total UL Power',
#	    categories => "=Total_UL_Power!\$A\$2:\$A$\$row",
#	    values     => "=Total_UL_Power!\$B\$2:\$B\$$row",
#	);

#	$chart3_1->add_series(
#	    name	=> 'Max Total UL Power',
#	    categories => "=Total_UL_Power!\$A\$2:\$A$\$row",
#	    values     => "=Total_UL_Power!\$C\$2:\$C\$$row",
#	);

	my $start = 'C';
	foreach my $ue (sort {$a<=>$b} keys %blerperue) {
		if ($ue  < 20000) {
			$chart4_1->add_series(
				name       => "$ue",
	    			categories => "=UL_power_per_UE!\$A\$2:\$A$\$row",
				values     => "=UL_power_per_UE!\$$start\$2:\$$start\$$row",
			);
			$start++;
			if ($start eq 'Z'){
				$start = "AA";
			}
		}
	}

	$chart5_1->add_series(
	    name	=> 'Total throughput',
	    categories => "=UL_TPT!\$A\$2:\$A$\$row",
	    values     => "=UL_TPT!\$B\$2:\$B\$$row",
	);

	my $start = 'C';
	foreach my $ue (sort {$a<=>$b} keys %{$tbsize{UE}}) {
		if ($ue  < 20000) {
			$chart5_2->add_series(
				name       => "$ue",
	    			categories => "=UL_TPT!\$A\$2:\$A$\$row",
				values     => "=UL_TPT!\$$start\$2:\$$start\$$row",
			);
#			print "row=$row,	col=$start\n";
			$start++;
			if ($start eq 'Z'){
				$start = "AA";
			}
		}
	}

	$chart5_3->add_series(
	    name	=> 'Total throughput',
	    categories => "=UL_TPT!\$A\$2:\$A$\$row",
	    values     => "=UL_TPT!\$H\$2:\$H\$$row",
	);
	$chart5_4->add_series(
	    name	=> 'Total throughput',
	    categories => "=UL_TPT!\$A\$2:\$A$\$row",
	    values     => "=UL_TPT!\$I\$2:\$I\$$row",
	);
	$chart5_5->add_series(
	    name	=> 'Total throughput',
	    categories => "=UL_TPT!\$A\$2:\$A$\$row",
	    values     => "=UL_TPT!\$J\$2:\$J\$$row",
	);
	$chart5_6->add_series(
	    name	=> 'Total throughput',
	    categories => "=UL_TPT!\$A\$2:\$A$\$row",
	    values     => "=UL_TPT!\$K\$2:\$K\$$row",
	);
	$chart5_7->add_series(
	    name	=> 'Total throughput',
	    categories => "=UL_TPT!\$A\$2:\$A$\$row",
	    values     => "=UL_TPT!\$L\$2:\$L\$$row",
	);


	# Add a chart title and some axis labels.
	$chart1_1->set_title ( name => 'UL_BLER' );
	$chart1_1->set_x_axis( name => 'Epoc time (s)' );
	$chart1_1->set_y_axis( name => 'BLER (%)' );
	$chart1_1->set_y2_axis( name => 'number of UEs' );

	$chart1_2->set_title ( name => 'UL BLER per slot' );
	$chart1_2->set_x_axis( name => 'Epoc time (s)' );
	$chart1_2->set_y_axis( name => 'BLER (%)' );

	$chart1_3->set_title ( name => 'UL BLER per codeblock' );
	$chart1_3->set_x_axis( name => 'Epoc time (s)' );
	$chart1_3->set_y_axis( name => 'BLER (%)' );

	$chart1_4->set_title ( name => 'Momentan UL BLER' );
	$chart1_4->set_x_axis( name => 'Epoc time (s)' );
	$chart1_4->set_y_axis( name => 'BLER (%)' );

	$chart2_1->set_title ( name => 'UL_BLER' );
	$chart2_1->set_x_axis( name => 'Epoc time (s)' );
	$chart2_1->set_y_axis( name => 'BLER (%)' );

	$chart3_1->set_title ( name => 'UL_Power' );
	$chart3_1->set_x_axis( name => 'Epoc time (s)' );
	$chart3_1->set_y_axis( name => 'Power (dBm/10)' );

	$chart4_1->set_title ( name => 'UL_Power per UE' );
	$chart4_1->set_x_axis( name => 'Epoc time (s)' );
	$chart4_1->set_y_axis( name => 'Power (dBm/10)' );

	$chart5_1->set_title ( name => 'Total UL L1 throughput' );
	$chart5_1->set_x_axis( name => 'Epoc time (s)' );
	$chart5_1->set_y_axis( name => 'tpt (kbits/s)' );

	$chart5_2->set_title ( name => 'UL L1 throughput per UE' );
	$chart5_2->set_x_axis( name => 'Epoc time (s)' );
	$chart5_2->set_y_axis( name => 'tpt (kbits/s)' );

	$chart5_3->set_title ( name => 'UL L1 throughput for UE1' );
	$chart5_3->set_x_axis( name => 'Epoc time (s)' );
	$chart5_3->set_y_axis( name => 'tpt (kbits/s)' );

	$chart5_4->set_title ( name => 'UL L1 throughput for UE2' );
	$chart5_4->set_x_axis( name => 'Epoc time (s)' );
	$chart5_4->set_y_axis( name => 'tpt (kbits/s)' );

	$chart5_5->set_title ( name => 'UL L1 throughput for UE3' );
	$chart5_5->set_x_axis( name => 'Epoc time (s)' );
	$chart5_5->set_y_axis( name => 'tpt (kbits/s)' );

	$chart5_6->set_title ( name => 'UL L1 throughput for UE4' );
	$chart5_6->set_x_axis( name => 'Epoc time (s)' );
	$chart5_6->set_y_axis( name => 'tpt (kbits/s)' );

	$chart5_7->set_title ( name => 'UL L1 throughput for UE5' );
	$chart5_7->set_x_axis( name => 'Epoc time (s)' );
	$chart5_7->set_y_axis( name => 'tpt (kbits/s)' );


	# Insert the chart into the worksheet (with an offset).
	$sheets{1}->insert_chart( 'V2', $chart1_1,0,0,4,2 );
	$sheets{1}->insert_chart( 'V30', $chart1_2,0,0,4,2 );
	$sheets{1}->insert_chart( 'V60', $chart1_3,0,0,4,2 );

	$sheets{1}->insert_chart( 'V90', $chart1_4,0,0,4,2 );

	$sheets{2}->insert_chart( 'M2', $chart2_1,0,0,4,2 );

	$sheets{3}->insert_chart( 'M2', $chart3_1,0,0,4,2 );

	$sheets{4}->insert_chart( 'M2', $chart4_1,0,0,4,2 );

	$sheets{5}->insert_chart( 'M2', $chart5_1,0,0,4,2 );
	$sheets{5}->insert_chart( 'M30', $chart5_2,0,0,4,2 );

	$sheets{5}->insert_chart( 'M60', $chart5_3,0,0,4,2 );
	$sheets{5}->insert_chart( 'M90', $chart5_4,0,0,4,2 );
	$sheets{5}->insert_chart( 'M120', $chart5_5,0,0,4,2 );
	$sheets{5}->insert_chart( 'M150', $chart5_6,0,0,4,2 );
	$sheets{5}->insert_chart( 'M180', $chart5_7,0,0,4,2 );

	$workbook->close() or die("$!");
}
print "\n\n";
exit;

sub print_hash_of_hashes
{
	my $hashref = shift;
	my $hashname = shift;
	
	print "\n\n";
	print "$hashname\n";
	print "==============\n";
	foreach my $param (sort keys %$hashref) {
		print "$param:	";
		foreach my $value (sort {$a<=>$b} keys %{${$hashref}{$param}}) {
			print "	$value:${$hashref}{$param}{$value}";
		}
		print "\n";
	}
}

sub getTime
{
        my @date = split'\-',$_[0];
        my @time = split'\:',$_[1];
        # This object represent 01:30:00 standard time
	my $epoc = timegm($time[2],$time[1],$time[0],$date[2],$date[1]-1,$date[0]);
	$epoc =~ s/\.\d+$//;
        return $epoc;
}
sub clear_screen
{
	print "\033[2J" if (not defined $debug);
}

sub create_book
{
	my $bookref = shift;
	my $excelfile = shift;

	
	$$bookref  = Excel::Writer::XLSX->new( "$excelfile" );
	die "Couldn't create new Excel file: $!.\n" unless defined $$bookref;
#	$workbook->compatibility_mode(); 
#	set_properties($$bookref);
	print "Created $excelfile\n";
}
sub create_sheets
{
	my $bookref = shift;

	$sheets{1} = $$bookref->add_worksheet("Total_UL_BLER");
	$sheets{2} = $$bookref->add_worksheet("UL_BLER_per_UE");
	$sheets{3} = $$bookref->add_worksheet("Total_UL_Power");
	$sheets{4} = $$bookref->add_worksheet("UL_power_per_UE");
	$sheets{5} = $$bookref->add_worksheet("UL_TPT");


	$sheets{1}->add_write_handler(qr[\w], \&store_string_widths);
	$sheets{2}->add_write_handler(qr[\w], \&store_string_widths);
	$sheets{3}->add_write_handler(qr[\w], \&store_string_widths);
	$sheets{4}->add_write_handler(qr[\w], \&store_string_widths);
	$sheets{5}->add_write_handler(qr[\w], \&store_string_widths);


	my $writeformat = $workbook->add_format();
	$writeformat->set_bold();
	$writeformat->set_color( 'black' );
	$writeformat->set_align( 'center' );

	$sheets{1}->write( "A1","TIME",$writeformat);
	$sheets{1}->write( "B1","Data RC=0",$writeformat);
	$sheets{1}->write( "C1","Data RC=1",$writeformat);
	$sheets{1}->write( "D1","Data RC=2",$writeformat);
	$sheets{1}->write( "E1","Data RC=3",$writeformat);
	$sheets{1}->write( "F1","Data RC=5",$writeformat);
	$sheets{1}->write( "G1","Data RC=6",$writeformat);
	$sheets{1}->write( "H1","Data RC=7",$writeformat);
	$sheets{1}->write( "I1","Empty RC=4",$writeformat);
	$sheets{1}->write( "J1","Empty RC=7",$writeformat);
	$sheets{1}->write( "K1","Padding RC=0",$writeformat);
	$sheets{1}->write( "L1","Padding RC=7",$writeformat);

	$sheets{1}->write( "N1","Total UL_BLER",$writeformat);
	$sheets{1}->write( "O1","Momentan UL_BLER",$writeformat);
	$sheets{1}->write( "Q1","UL_BLER_slot3",$writeformat);
	$sheets{1}->write( "R1","UL_BLER_slot7",$writeformat);
	$sheets{1}->write( "S1","UL_BLER_slot11",$writeformat);
	$sheets{1}->write( "T1","UL_BLER_slot15",$writeformat);
	$sheets{1}->write( "U1","UL_BLER_slot19",$writeformat);
	$sheets{1}->write( "V1","#UEs",$writeformat);

	$sheets{2}->write( "A1","TIME",$writeformat);

	$sheets{3}->write( "A1","TIME",$writeformat);
	$sheets{3}->write( "B1","MIN",$writeformat);
	$sheets{3}->write( "C1","MAX",$writeformat);
	$sheets{3}->write( "D1","AVG",$writeformat);
	$sheets{3}->write( "E1","NUM",$writeformat);
	$sheets{3}->write( "F1","SUM",$writeformat);

	$sheets{4}->write( "A1","TIME",$writeformat);

	$sheets{5}->write( "A1","TIME",$writeformat);
	$sheets{5}->write( "B1","TOT UL TPT",$writeformat);
}

#################################
###############################################################################
###############################################################################
#
# Functions used for Autofit.
#

###############################################################################
#
# Adjust the column widths to fit the longest string in the column.
#
sub autofit_columns {

    my $worksheet = shift;
    my $col       = 0;

    for my $width (@{$worksheet->{__col_widths}}) {

        $worksheet->set_column($col, $col, $width) if $width;
        $col++;
    }
}


###############################################################################
#
# The following function is a callback that was added via add_write_handler()
# above. It modifies the write() function so that it stores the maximum
# unwrapped width of a string in a column.
#
sub store_string_widths {

    my $worksheet = shift;
    my $col       = $_[1];
    my $token     = $_[2];

    # Ignore some tokens that we aren't interested in.
    return if not defined $token;       # Ignore undefs.
    return if $token eq '';             # Ignore blank cells.
    return if ref $token eq 'ARRAY';    # Ignore array refs.
    return if $token =~ /^=/;           # Ignore formula

    # Ignore numbers
    return if $token =~ /^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/;

    # Ignore various internal and external hyperlinks. In a real scenario
    # you may wish to track the length of the optional strings used with
    # urls.
    return if $token =~ m{^[fh]tt?ps?://};
    return if $token =~ m{^mailto:};
    return if $token =~ m{^(?:in|ex)ternal:};


    # We store the string width as data in the Worksheet object. We use
    # a double underscore key name to avoid conflicts with future names.
    #
    my $old_width    = $worksheet->{__col_widths}->[$col];
    my $string_width = string_width($token);

    if (not defined $old_width or $string_width > $old_width) {
        # You may wish to set a minimum column width as follows.
        #return undef if $string_width < 10;

        $worksheet->{__col_widths}->[$col] = $string_width;
    }


    # Return control to write();
    return undef;
}

sub installation
{
	print "\nShort instruction how to use ul_bler.pl (v$ul_bler_version)\n";
	print "===============================================\n";
	print "\n";
	print "Perl is assumed to be installed in your linux environment already\n";
	print "You also need to install perl module Excel::Writer, either in your system if you have sudo rights or locally if you do not have sudo rights.\n";
	print "\n";
	print "Below you see how excel-writer-xlsx and Archive-Zip perl module are installed locally into directoy /home/eraaldr/bin/perlmodules/\n";
	print "	mkdir -p /home/eraaldr/bin/perlmodules\n";
	print "	cd /home/eraaldr/bin/perlmodules\n";
	print "	git clone https://github.com/jmcnamara/excel-writer-xlsx\n";
	print "	excel-writer-xlsx\n";
	print "	perl Makefile.PL PREFIX=/home/eraaldr/tmp/perlmodules LIB=/home/eraaldr/tmp/perlmodules\n";
	print "	make\n";
	print "	make test\n";
	print "	make install\n";
	print "	cd /home/eraaldr/tmp/perlmodules\n";
	print "	wget https://cpan.metacpan.org/authors/id/P/PH/PHRED/Archive-Zip-1.64.tar.gz\n";
	print "	tar zxvf Archive-Zip-1.64.tar.gz\n";
	print "	Archive-Zip-1.64\n";
	print "	perl Makefile.PL PREFIX=/home/eraaldr/tmp/perlmodules LIB=/home/eraaldr/tmp/perlmodules\n";
	print "	make\n";
	print "	make install\n";
	print "\n";
	print "Create a configuration file in you home directory\n";
	print "	nano \$HOME/.ulblerrc\n";
	print "\n";
	print "Write this row to the file and save it\n";
	print "	modulepath=/home/eraaldr/tmp/perlmodules\n";
	print "\n";
	print "Enable the following traces\n";
	print "	bbte \@N_R4_0 log enable 1 ULL1COMMONNR.15\n";
	print "	bbte \@N_R4_0 log enable 1 ULL1COMMONNR.29\n";
	print "\n";
	print "Optional traces:\n";
#	print "	bbte \@N_R4_0 log enable 1 ULL1COMMONNR.79\n";
#	print "	bbte \@N_R4_0 log enable 4 DRAULMDBFNR.103\n";
	print "	bbte \@N_R4_0 log enable 4 DRAULMDBFNR.104\n";
	print "\n";
}

###############################################################################
#
# Very simple conversion between string length and string width for Arial 10.
# See below for a more sophisticated method.
#
sub string_width {

    return 0.9 * length $_[0];
}


__END__

# nCSE=0 MIR=1 RC=7 nIt=63 activityId=1c00 actionId=0a8f torContext=0x004674f9 codeBlockNo=0 tbSizeWithCrc=5784 cbSizeWithCrcInBits=5784 d[0 - 6] = { 0203 89a1 0021 3088 0852 5492 c467 }
# [2018-08-29 11:16:00.630973] 0x88a371a2=(bfn:2186, sfn:138, sf:3.67, bf:26) duId:1 EMCA1/BbiUniqueTrace 2 ull1nrcommon_puschses_send_data_ind.c:658: <!ULL1COMMONNR.15!> INFO jobId=0x00116000 nCSE=0 MIR=0 RC=0 nIt=2 activityId=0x0b19 actionIdH=0x0000 actionIdL=0x0f9c torContext=0x0047276b codeBlockNo=0 tbSizeWithCrc=3256 cbSizeWithCrcInBits=3256 d[0 - 6] = { 3d00 3f00 0000 0000 0000 0000 0000 } 


# loggar med 2 ttier per slot
# /proj/lterbsLablogOT/sp665_ki/20190423/nr_bb3.dec 
# /proj/www_user/ematshe/NR/eFIT/2SETTI/2SEDLTTI_pa2.log
#cat /proj/www_user/ematshe/NR/eFIT/2SETTI/2SEDLTTI_pa2.log | egrep isAck | egrep -o "slotNo=[0-9]+|isAck=[0-9]+" | xargs -n 2 | sort | uniq -c
#    212 slotNo=14 isAck=0
#    429 slotNo=14 isAck=1
#    170 slotNo=19 isAck=0
#    469 slotNo=19 isAck=1
#    127 slotNo=4 isAck=0
#    518 slotNo=4 isAck=1
#    207 slotNo=9 isAck=0
#    448 slotNo=9 isAck=1


