#################################################################################
#                                                                                #
#                    Author:Min Wang (eminwag)                                    #
#        This module use a css way to generate Tk and make miscellaneous widgets #
#                                                                               #
#################################################################################
package simple_tk;

use strict;
use warnings;

use Data::Dumper;

use Tk;
use Tk::NoteBook;
use Tk::TextUndo;
use Tk::Dialog;
use Tk::Adjuster;
use Tk::PathEntry;
use Tk::PathEntry::Dialog;
use Tk::LabFrame;
use Tk::NoteBook;
use Tk::Pane;

our $version = '1.0';

sub s_new
{
    my $class = shift;
    my $self  = {};
    bless $self, $class;
    return $self;
}

sub s_window
{
    my $self    = shift;
    my $w_css   = shift;
    my $w_style = $self->get_style($w_css);

    my $w = tkinit();

    $w->optionAdd( @{$w_style} );
    my $w_methods = $self->get_methods($w_css);
    if ($w_methods)
    {
        $self->set_methods( $w, $w_methods );
    }

    if ( $w->geometry() =~ /(\d+)x(\d+)/ )
    {
        my ( $width, $height ) = ( $1, $2 );
        my ( $x, $y ) = ( int( ( $w->screenwidth() - $width ) / 4 ),
                          int( ( $w->screenheight() - $height ) / 4 ) );
        $w->geometry("${width}x${height}+${x}+${y}");
    }

    return $w;
}

sub s_frame
{
    my $self   = shift;
    my $parent = shift;
    my $f_css  = shift;

    my $f_style = $self->get_style($f_css);
    my $f       = $parent->Frame( %{$f_style} );

    return $f;
}

sub s_labframe
{
    my $self   = shift;
    my $parent = shift;
    my $lf_css = shift;

    my $lf_style = $self->get_style($lf_css);
    my $lf       = $parent->LabFrame( %{$lf_style} );
    return $lf;

}

sub s_scrolled_lab_frame
{
    my ( $self, $parent, $sf_css, $pa_css ) = @_;

    my $sf_style = $self->get_style($sf_css);
    my $pa_style = $self->get_style($pa_css);
    my $f        = $parent->LabFrame( %{$sf_style} );

    my $p = $f->Scrolled( 'Pane', -scrollbars => 'e', );
    $p->configure( %{$pa_style} );
    $self->s_pack( $p, $self->get_pack($pa_css) );
    $self->s_pack( $f, $self->get_pack($sf_css) );
    return ( $f, $p );
}

sub s_button
{
    my ( $self, $parent, $b_css, $is_pack ) = @_;

    my $b_style = $self->get_style($b_css);

    my $b = $parent->Button( %{$b_style} );

    if ( defined $is_pack && $is_pack )
    {
        $self->s_pack( $b, $self->get_pack($b_css) );
    }

    return $b;
}

sub s_label
{
    my ( $self, $parent, $l_css, $is_pack ) = @_;

    my $l_style = $self->get_style($l_css);

    my $l = $parent->Label( %{$l_style} );
    if ( defined $is_pack && $is_pack )
    {
        $self->s_pack( $l, $self->get_pack($l_css) );
    }

    return $l;
}

sub s_entry
{
    my ( $self, $parent, $e_css, $is_pack ) = @_;

    my $e_style = $self->get_style($e_css);
    my $e       = $parent->Entry( %{$e_style} );

    if ( defined $is_pack && $is_pack )
    {
        $self->s_pack( $e, $self->get_pack($e_css) );
    }

    return $e;
}

sub s_pathdialog
{
    my ( $self, $parent, $pe_css ) = @_;
    my $pd = $parent->PathEntryDialog( -autocomplete => 1 )->Show();
    return $pd;
}

sub s_pathentry
{
    my ( $self, $parent, $pe_css, $is_pack ) = @_;

    my $pe_style = $self->get_style($pe_css);
    my $pe       = $parent->PathEntry( %{$pe_style} );

    if ( defined $is_pack && $is_pack )
    {
        $self->s_pack( $pe, $self->get_pack($pe_css) );
    }

    return $pe;

}

sub s_list
{
    my ( $self, $parent, $li_css, $is_pack ) = @_;
    my $style = $self->get_style($li_css);
    my $li = $parent->Scrolled( 'Listbox', %{$style} );

    if ( defined $is_pack && $is_pack )
    {
        $self->s_pack( $li, $self->get_pack($li_css) );
    }

    return $li;
}

sub s_text
{
    my ( $self, $parent, $t_css, $is_pack ) = @_;

    my $s       = $parent->Scrollbar();
    my $t_style = $self->get_style($t_css);

    my $text = $parent->Text( %{$t_style} );
    $text->configure( '-yscrollcommand' => [ 'set', $s ], );
    $s->pack( '-side' => "right", '-expand' => "no", '-fill' => "y" );

    if ($is_pack)
    {
        $self->s_pack( $text, $self->get_pack($t_css) );
    }

    return $text;
}

sub s_label_pathdialog
{
    my ( $self, $parent, $f_css, $l_css, $pd_css ) = @_;

    my $f = $self->s_frame( $parent, $f_css );

    $self->s_pack( $self->s_label( $f, $l_css ), $self->get_pack($l_css) );
    $self->s_pack( $self->s_pathdialog( $f, $pd_css ),
                   $self->get_pack($pd_css) );

    $self->s_pack( $f, $self->get_pack($f_css) );
}

sub s_label_entry
{
    my ( $self, $parent, $f_css, $l_css, $e_css ) = @_;

    my $f = $self->s_frame( $parent, $f_css );

    my $l = $self->s_label( $f, $l_css );

    my $e = $self->s_entry( $f, $e_css );

    $self->s_pack( $l, $self->get_pack($l_css) );

    $self->s_pack( $e, $self->get_pack($e_css) );

    $self->s_pack( $f, $self->get_pack($f_css) );

    return ( $f, $l, $e );
}

sub s_label_pathentry
{
    my ( $self, $parent, $f_css, $l_css, $e_css ) = @_;

    my $f = $self->s_frame( $parent, $f_css );

    $self->s_pack( $self->s_label( $f, $l_css ), $self->get_pack($l_css) );

    $self->s_pack( $self->s_pathentry( $f, $e_css ), $self->get_pack($e_css) );

    $self->s_pack( $f, $self->get_pack($f_css) );

}

sub s_label_list
{
    my ( $self, $parent, $f_css, $l_css, $li_css ) = @_;
    my $f = $self->s_frame( $parent, $f_css );

    $self->s_label( $f, $l_css );

    $self->s_list( $f, $li_css );
}

sub s_option
{
    my ( $self, $parent, $op_css ) = @_;
    my $op_style = $self->get_style($op_css);

    return $parent->Optionmenu( %{$op_style} );
}

sub s_label_option
{
    my ( $self, $parent, $f_css, $l_css, $op_css ) = @_;
    my $f = $self->s_frame( $parent, $f_css );

    my $op = $self->s_option( $f, $op_css );

    $self->s_pack( $self->s_label( $f, $l_css ), $self->get_pack($l_css) );
    $self->s_pack( $op, $self->get_pack($op_css) );
    $self->s_pack( $f,  $self->get_pack($f_css) );

    return $op;
}

sub s_menubar
{
    my ( $self, $parent, $mb_css ) = @_;
    my $mb = $parent->Menu();

    my $mb_style = $self->get_style($mb_css);
    if ($mb_style)
    {
        $self->set_style( $mb, $mb_style );
    }
    $parent->configure( -menu => $mb );

    return $mb;
}

sub s_adjuster
{
    my ( $self, $parent, $a_css, $is_pack ) = @_;

    my $a_style = $self->get_style($a_css);
    my $a       = $parent->Adjuster( %{$a_style} );

    if ( defined $is_pack && $is_pack )
    {
        $self->s_pack( $a, $self->get_pack($a_css) );
    }
    return $a;
}

sub s_messagebox
{
    my ( $self, $parent, $mb_css, $is_pack ) = @_;

    my $res = $parent->messageBox( %{ $self->get_style($mb_css) } );

    return $res;
}

sub s_cascade
{
    my ( $self, $menubar, $mb_css, $all ) = @_;

    my $c_list = ();
    foreach my $key ( sort keys %{$mb_css} )
    {
        if ( $key =~ /^c_/ )
        {
            my $c =
                $menubar->cascade( %{ $self->get_style( $mb_css->{$key} ) } );
            $c_list->{$key}->{self} = $c;
            if ( defined $mb_css->{$key}->{command} )
            {
                foreach my $cmd ( sort keys %{ $mb_css->{$key}->{command} } )
                {
                    if ( $cmd =~ /^c_/ )
                    {
                        #my $cmd_style = $self->get_style($mb_css->{$key}->{command}->{$cmd});
                        $c_list->{$key}->{command}->{$cmd} =
                            $self->s_command( $c,
                                          $mb_css->{$key}->{command}->{$cmd} );
                    }
                }
            }
        }

    }

    return $c_list;
}

sub s_notebook
{
    my ( $self, $parent, $nb_css, $is_pack ) = @_;

    my $nb_style = $self->get_style($nb_css);
    my $nb       = $parent->NoteBook( %{$nb_style} );

    if ( defined $is_pack && $is_pack )
    {
        $self->s_pack( $nb, $self->get_pack($nb_css) );
    }

    return $nb;
}

sub s_command
{
    my ( $self, $cascade, $cmd_css ) = @_;

    my $cmd_style = $self->get_style($cmd_css);
    my $cmd       = $cascade->command( %{$cmd_style} );

    return $cmd;
}

sub s_dialog
{
    #print Dumper(@_);
    my ( $self, $parent, $d_css ) = @_;

    my $d_style = $self->get_style($d_css);
    my $d       = $parent->Dialog( %{$d_style} );

    return $d;
}

sub s_getopenfile
{
    my ( $self, $parent, $gf_css ) = @_;
    my $gf_style = $self->get_style($gf_css);
    return $parent->getOpenFile( %{$gf_style} );
}

sub s_getsavefile
{
    my ( $self, $parent, $gf_css ) = @_;
    my $gf_style = $self->get_style($gf_css);
    return $parent->getSaveFile( %{$gf_style} );
}

sub s_choosedirectory
{
    my ( $self, $parent, $cd_css ) = @_;
    my $cd_style = $self->get_style($cd_css);
    my $dir      = $parent->chooseDirectory( %{$cd_style} );
    return $dir if defined $dir;
    return undef;

}

sub get_style
{
    my $self       = shift;
    my $widget_css = shift;

    foreach ( keys %{$widget_css} )
    {
        return $widget_css->{$_} if ( $_ eq 'style' );
    }

    return 0;
}

sub set_style
{
    my $self   = shift;
    my $widget = shift;
    my $style  = shift;

    $widget->configure( %{$style} );
}

sub get_methods
{
    my $self       = shift;
    my $widget_css = shift;

    foreach ( keys %{$widget_css} )
    {
        if ( $_ eq 'methods' )
        {
            return $widget_css->{$_};
        }
    }
    return 0;
}

sub set_methods
{
    my $self    = shift;
    my $widget  = shift;
    my $methods = shift;

    foreach my $key ( keys %{$methods} )
    {
        no warnings;
        $widget->$key(   eval( $methods->{$key} )
                       ? eval( $methods->{$key} )
                       : $methods->{$key} );
        use warnings;
    }

}

sub s_pack
{
    my $self      = shift;
    my $widget    = shift;
    my $pack_info = shift;

    if ( defined $pack_info && $pack_info )
    {
        $widget->pack( %{$pack_info} );
    }
    else
    {
        $widget->pack();
    }

}

sub s_bindall
{
    my $self   = shift;
    my $widget = shift;
    my $css    = shift;

    foreach my $key ( keys %{$css} )
    {
        if ( $key eq 'bind' )
        {
            foreach my $k ( keys %{ $css->{$key} } )
            {
                $widget->bind( $k, $css->{$key}->{$k} );
            }
        }
        elsif ( ( $key ne 'bind' ) && ( ref( $css->{$key} ) eq 'HASH' ) )
        {
            $self->s_bindall( $widget, $css->{$key} );
        }
    }

}

sub get_pack
{
    my $self       = shift;
    my $widget_css = shift;

    foreach ( keys %{$widget_css} )
    {
        return $widget_css->{$_} if ( $_ eq 'pack' );
    }

    return 0;
}

1;
